package Beam::Runner;
our $VERSION = '0.002';
# ABSTRACT: Execute runnable objects from Beam::Wire containers

#pod =head1 SYNOPSIS
#pod
#pod     beam run <container> <service> [<args...>]
#pod     beam list
#pod     beam list <container>
#pod     beam help <container> <service>
#pod     beam help
#pod
#pod =head1 DESCRIPTION
#pod
#pod This distribution is an execution and organization system for
#pod L<Beam::Wire> containers. This allows you to prepare executable objects
#pod in configuration files and then execute them. This also allows easy
#pod discovery of container files and objects, and allows you to document
#pod your objects for your users.
#pod
#pod =head1 SEE ALSO
#pod
#pod L<beam>, L<Beam::Runnable>, L<Beam::Wire>
#pod
#pod =cut

use strict;
use warnings;



1;

__END__

=pod

=head1 NAME

Beam::Runner - Execute runnable objects from Beam::Wire containers

=head1 VERSION

version 0.002

=head1 SYNOPSIS

    beam run <container> <service> [<args...>]
    beam list
    beam list <container>
    beam help <container> <service>
    beam help

=head1 DESCRIPTION

This distribution is an execution and organization system for
L<Beam::Wire> containers. This allows you to prepare executable objects
in configuration files and then execute them. This also allows easy
discovery of container files and objects, and allows you to document
your objects for your users.

=head1 SEE ALSO

L<beam>, L<Beam::Runnable>, L<Beam::Wire>

=head1 AUTHOR

Doug Bell <preaction@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by Doug Bell.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
