# This Makefile.PL for UV was generated by
# Dist::Zilla::Plugin::MakeMaker::Awesome 0.48.
# Don't edit it but the dist.ini and plugins used to construct it.

use strict;
use warnings;

use ExtUtils::MakeMaker;

use Alien::Base::Wrapper ();

my %xsbuild;

my $have_libuv_by_pkgconfig = defined eval {
    require ExtUtils::PkgConfig;
    ExtUtils::PkgConfig->atleast_version( "libuv", "1.32" );
};

my %extra_buildreq;
my %extra_prereq;

if( $have_libuv_by_pkgconfig ) {
    my %info = ExtUtils::PkgConfig->find( "libuv" );
    print STDERR "Using libuv $info{modversion} from pkg-config\n";

    my @cflags = split m/ /, $info{cflags} // "";
    my @libs   = split m/ /, $info{libs};

    %xsbuild = (
        INC  => join( " ", grep { m/^-I/ } @cflags ),
        LIBS    => [          grep {  m/-l/i } @libs ],
        LDFLAGS => join( " ", grep { !m/-l/  } @libs ),
    );
}
else {
    print STDERR "Using libuv from Alien::libuv\n";

    %xsbuild = Alien::Base::Wrapper->new('Alien::libuv')->mm_args2;
    $extra_buildreq{"Alien::Base::Wrapper"} = 0;
    $extra_prereq{"Alien::libuv"} = "1.000";
}

# Our cpanfile contains the proper configure requires already
delete $xsbuild{CONFIGURE_REQUIRES};

# We keep our XS file in the right place in lib/
$xsbuild{XSMULTI} = 1;

# Append our hax/ directory
$xsbuild{INC} .= " -Ihax";

my %WriteMakefileArgs = (
  "ABSTRACT" => "Perl interface to libuv",
  "AUTHOR" => "Chase Whitener <capoeirab\@cpan.org>, Daisuke Murase <typester\@cpan.org>",
  "BUILD_REQUIRES" => {
    "Config" => 0,
    "ExtUtils::MakeMaker" => "7.12",
    %extra_buildreq,
    %extra_prereq,
  },
  "CONFIGURE_REQUIRES" => {
    "Alien::Base::Wrapper" => 0,
    "Alien::libuv" => "1.000",
    "ExtUtils::MakeMaker" => "7.12"
  },
  "DISTNAME" => "UV",
  "LICENSE" => "perl",
  "NAME" => "UV",
  "PREREQ_PM" => {
    "Carp" => 0,
    "Exporter" => "5.57",
    "Scalar::Util" => 0,
    "XSLoader" => "0.14",
    "parent" => 0,
    "strict" => 0,
    "warnings" => 0,
    %extra_prereq,
  },
  "TEST_REQUIRES" => {
    "Errno" => 0,
    "ExtUtils::MakeMaker" => "7.12",
    "File::Spec" => 0,
    "FindBin" => 0,
    "IO::Handle" => 0,
    "IO::Socket::INET" => 0,
    "POSIX" => 0,
    "Socket" => 0,
    "Test::More" => "0.88",
    "Try::Tiny" => 0,
    %extra_prereq,
  },
  "VERSION" => "1.902",
  "test" => {
    "TESTS" => "t/*.t"
  }
);

%WriteMakefileArgs = (
    %WriteMakefileArgs,
    %xsbuild,
);

my %FallbackPrereqs = (
  "Alien::Base::Wrapper" => 0,
  "Carp" => 0,
  "Config" => 0,
  "Errno" => 0,
  "Exporter" => "5.57",
  "ExtUtils::MakeMaker" => "7.12",
  "File::Spec" => 0,
  "FindBin" => 0,
  "IO::Handle" => 0,
  "IO::Socket::INET" => 0,
  "POSIX" => 0,
  "Scalar::Util" => 0,
  "Socket" => 0,
  "Test::More" => "0.88",
  "Try::Tiny" => 0,
  "XSLoader" => "0.14",
  "parent" => 0,
  "strict" => 0,
  "warnings" => 0,
  %extra_prereq,
);

unless ( eval { ExtUtils::MakeMaker->VERSION('6.63_03') } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);
