package Zodiac::Chinese::Table;

our $DATE = '2015-11-21'; # DATE
our $VERSION = '0.01'; # VERSION

use 5.010001;
use strict;
use utf8;
use warnings;

use List::BinarySearch::XS qw(binsearch);

use Exporter;
our @ISA = qw(Exporter);
our @EXPORT_OK = qw(
                       chinese_zodiac
               );

# BEGIN FRAGMENT id=meta
# note: This section is generated by a script. Do not edit manually!
# src-file: /mnt/u1/home/repos/gudangdata/table/chinese_zodiac/meta.yaml
# src-revision: 503280f40be8a30712dc437a3721edf784017757
# revision-date: Sat Nov 21 08:21:54 2015 +0700
# generate-date: Sat Nov 21 08:22:03 2015
# generated-by: /mnt/u1/home/repos/gudangdata/bin/gen-perl-meta-snippet
our $meta = {
  "fields" => {
    earthly_branch => { pos => 5, schema => "str*" },
    element        => { pos => 3, schema => "str*" },
    en_animal      => { pos => 7, schema => "str*" },
    end_date       => { pos => 1, schema => "date*" },
    heavenly_stem  => { pos => 4, schema => "str*" },
    start_date     => { pos => 0, schema => "date*" },
    yin_yang       => { pos => 2, schema => "str*" },
    zh_animal      => { pos => 6, schema => "str*" },
  },
  "pk" => "start_date",
  "summary" => "Chinese zodiac",
  "summary.alt.lang.id_ID" => "Zodiak Cina",
  "table_aliases.alt.lang.id_ID" => ["zodiak_cina"],
};
# END FRAGMENT id=meta
# BEGIN FRAGMENT id=data
# note: This section is generated by a script. Do not edit manually!
# src-file: /mnt/u1/home/repos/gudangdata/table/chinese_zodiac/data.csv
# src-revision: e4bd60c355ae617a8dddf9b6796c10156cd6fa6b
# revision-date: Sat Nov 21 08:19:52 2015 +0700
# generate-date: Sat Nov 21 08:22:03 2015
# generated-by: /mnt/u1/home/repos/gudangdata/bin/gen-perl-data-snippet
our $data = [
    ['1924-02-05','1925-01-23','yang','wood',"\x{7532}","\x{5b50}","\x{9f20}",'rat'],
    ['1925-01-24','1926-02-12','yin','wood',"\x{4e59}","\x{4e11}","\x{725b}",'ox'],
    ['1926-02-13','1927-02-01','yang','fire',"\x{4e19}","\x{5bc5}","\x{864e}",'tiger'],
    ['1927-02-02','1928-01-22','yin','fire',"\x{4e01}","\x{536f}","\x{5154}",'rabbit'],
    ['1928-01-23','1929-02-09','yang','earth',"\x{620a}","\x{8fb0}","\x{9f8d}",'dragon'],
    ['1929-02-10','1930-01-29','yin','earth',"\x{5df1}","\x{5df3}","\x{86c7}",'snake'],
    ['1930-01-30','1931-02-16','yang','metal',"\x{5e9a}","\x{5348}","\x{99ac}",'horse'],
    ['1931-02-17','1932-02-05','yin','metal',"\x{8f9b}","\x{672a}","\x{7f8a}",'goat'],
    ['1932-02-06','1933-01-25','yang','water',"\x{58ec}","\x{7533}","\x{7334}",'monkey'],
    ['1933-01-26','1934-02-13','yin','water',"\x{7678}","\x{9149}","\x{96de}",'rooster'],
    ['1934-02-14','1935-02-03','yang','wood',"\x{7532}","\x{620c}","\x{72d7}",'dog'],
    ['1935-02-04','1936-01-23','yin','wood',"\x{4e59}","\x{4ea5}","\x{732a}",'pig'],
    ['1936-01-24','1937-02-10','yang','fire',"\x{4e19}","\x{5b50}","\x{9f20}",'rat'],
    ['1937-02-11','1938-01-30','yin','fire',"\x{4e01}","\x{4e11}","\x{725b}",'ox'],
    ['1938-01-31','1939-02-18','yang','earth',"\x{620a}","\x{5bc5}","\x{864e}",'tiger'],
    ['1939-02-19','1940-02-07','yin','earth',"\x{5df1}","\x{536f}","\x{5154}",'rabbit'],
    ['1940-02-08','1941-01-26','yang','metal',"\x{5e9a}","\x{8fb0}","\x{9f8d}",'dragon'],
    ['1941-01-27','1942-02-14','yin','metal',"\x{8f9b}","\x{5df3}","\x{86c7}",'snake'],
    ['1942-02-15','1943-02-04','yang','water',"\x{58ec}","\x{5348}","\x{99ac}",'horse'],
    ['1943-02-05','1944-01-24','yin','water',"\x{7678}","\x{672a}","\x{7f8a}",'goat'],
    ['1944-01-25','1945-02-12','yang','wood',"\x{7532}","\x{7533}","\x{7334}",'monkey'],
    ['1945-02-13','1946-02-01','yin','wood',"\x{4e59}","\x{9149}","\x{96de}",'rooster'],
    ['1946-02-02','1947-01-21','yang','fire',"\x{4e19}","\x{620c}","\x{72d7}",'dog'],
    ['1947-01-22','1948-02-09','yin','fire',"\x{4e01}","\x{4ea5}","\x{732a}",'pig'],
    ['1948-02-10','1949-01-28','yang','earth',"\x{620a}","\x{5b50}","\x{9f20}",'rat'],
    ['1949-01-29','1950-02-16','yin','earth',"\x{5df1}","\x{4e11}","\x{725b}",'ox'],
    ['1950-02-17','1951-02-05','yang','metal',"\x{5e9a}","\x{5bc5}","\x{864e}",'tiger'],
    ['1951-02-06','1952-01-26','yin','metal',"\x{8f9b}","\x{536f}","\x{5154}",'rabbit'],
    ['1952-01-27','1953-02-13','yang','water',"\x{58ec}","\x{8fb0}","\x{9f8d}",'dragon'],
    ['1953-02-14','1954-02-02','yin','water',"\x{7678}","\x{5df3}","\x{86c7}",'snake'],
    ['1954-02-03','1955-01-23','yang','wood',"\x{7532}","\x{5348}","\x{99ac}",'horse'],
    ['1955-01-24','1956-02-11','yin','wood',"\x{4e59}","\x{672a}","\x{7f8a}",'goat'],
    ['1956-02-12','1957-01-30','yang','fire',"\x{4e19}","\x{7533}","\x{7334}",'monkey'],
    ['1957-01-31','1958-02-17','yin','fire',"\x{4e01}","\x{9149}","\x{96de}",'rooster'],
    ['1958-02-18','1959-02-07','yang','earth',"\x{620a}","\x{620c}","\x{72d7}",'dog'],
    ['1959-02-08','1960-01-27','yin','earth',"\x{5df1}","\x{4ea5}","\x{732a}",'pig'],
    ['1960-01-28','1961-02-14','yang','metal',"\x{5e9a}","\x{5b50}","\x{9f20}",'rat'],
    ['1961-02-15','1962-02-04','yin','metal',"\x{8f9b}","\x{4e11}","\x{725b}",'ox'],
    ['1962-02-05','1963-01-24','yang','water',"\x{58ec}","\x{5bc5}","\x{864e}",'tiger'],
    ['1963-01-25','1964-02-12','yin','water',"\x{7678}","\x{536f}","\x{5154}",'rabbit'],
    ['1964-02-13','1965-02-01','yang','wood',"\x{7532}","\x{8fb0}","\x{9f8d}",'dragon'],
    ['1965-02-02','1966-01-20','yin','wood',"\x{4e59}","\x{5df3}","\x{86c7}",'snake'],
    ['1966-01-21','1967-02-08','yang','fire',"\x{4e19}","\x{5348}","\x{99ac}",'horse'],
    ['1967-02-09','1968-01-29','yin','fire',"\x{4e01}","\x{672a}","\x{7f8a}",'goat'],
    ['1968-01-30','1969-02-16','yang','earth',"\x{620a}","\x{7533}","\x{7334}",'monkey'],
    ['1969-02-17','1970-02-05','yin','earth',"\x{5df1}","\x{9149}","\x{96de}",'rooster'],
    ['1970-02-06','1971-01-26','yang','metal',"\x{5e9a}","\x{620c}","\x{72d7}",'dog'],
    ['1971-01-27','1972-02-14','yin','metal',"\x{8f9b}","\x{4ea5}","\x{732a}",'pig'],
    ['1972-02-15','1973-02-02','yang','water',"\x{58ec}","\x{5b50}","\x{9f20}",'rat'],
    ['1973-02-03','1974-01-22','yin','water',"\x{7678}","\x{4e11}","\x{725b}",'ox'],
    ['1974-01-23','1975-02-10','yang','wood',"\x{7532}","\x{5bc5}","\x{864e}",'tiger'],
    ['1975-02-11','1976-01-30','yin','wood',"\x{4e59}","\x{536f}","\x{5154}",'rabbit'],
    ['1976-01-31','1977-02-17','yang','fire',"\x{4e19}","\x{8fb0}","\x{9f8d}",'dragon'],
    ['1977-02-18','1978-02-06','yin','fire',"\x{4e01}","\x{5df3}","\x{86c7}",'snake'],
    ['1978-02-07','1979-01-27','yang','earth',"\x{620a}","\x{5348}","\x{99ac}",'horse'],
    ['1979-01-28','1980-02-15','yin','earth',"\x{5df1}","\x{672a}","\x{7f8a}",'goat'],
    ['1980-02-16','1981-02-04','yang','metal',"\x{5e9a}","\x{7533}","\x{7334}",'monkey'],
    ['1981-02-05','1982-01-24','yin','metal',"\x{8f9b}","\x{9149}","\x{96de}",'rooster'],
    ['1982-01-25','1983-02-12','yang','water',"\x{58ec}","\x{620c}","\x{72d7}",'dog'],
    ['1983-02-13','1984-02-01','yin','water',"\x{7678}","\x{4ea5}","\x{732a}",'pig'],
    ['1984-02-02','1985-02-19','yang','wood',"\x{7532}","\x{5b50}","\x{9f20}",'rat'],
    ['1985-02-20','1986-02-08','yin','wood',"\x{4e59}","\x{4e11}","\x{725b}",'ox'],
    ['1986-02-09','1987-01-28','yang','fire',"\x{4e19}","\x{5bc5}","\x{864e}",'tiger'],
    ['1987-01-29','1988-02-16','yin','fire',"\x{4e01}","\x{536f}","\x{5154}",'rabbit'],
    ['1988-02-17','1989-02-05','yang','earth',"\x{620a}","\x{8fb0}","\x{9f8d}",'dragon'],
    ['1989-02-06','1990-01-26','yin','earth',"\x{5df1}","\x{5df3}","\x{86c7}",'snake'],
    ['1990-01-27','1991-02-14','yang','metal',"\x{5e9a}","\x{5348}","\x{99ac}",'horse'],
    ['1991-02-15','1992-02-03','yin','metal',"\x{8f9b}","\x{672a}","\x{7f8a}",'goat'],
    ['1992-02-04','1993-01-22','yang','water',"\x{58ec}","\x{7533}","\x{7334}",'monkey'],
    ['1993-01-23','1994-02-09','yin','water',"\x{7678}","\x{9149}","\x{96de}",'rooster'],
    ['1994-02-10','1995-01-30','yang','wood',"\x{7532}","\x{620c}","\x{72d7}",'dog'],
    ['1995-01-31','1996-02-18','yin','wood',"\x{4e59}","\x{4ea5}","\x{732a}",'pig'],
    ['1996-02-19','1997-02-06','yang','fire',"\x{4e19}","\x{5b50}","\x{9f20}",'rat'],
    ['1997-02-07','1998-01-27','yin','fire',"\x{4e01}","\x{4e11}","\x{725b}",'ox'],
    ['1998-01-28','1999-02-15','yang','earth',"\x{620a}","\x{5bc5}","\x{864e}",'tiger'],
    ['1999-02-16','2000-02-04','yin','earth',"\x{5df1}","\x{536f}","\x{5154}",'rabbit'],
    ['2000-02-05','2001-01-23','yang','metal',"\x{5e9a}","\x{8fb0}","\x{9f8d}",'dragon'],
    ['2001-01-24','2002-02-11','yin','metal',"\x{8f9b}","\x{5df3}","\x{86c7}",'snake'],
    ['2002-02-12','2003-01-31','yang','water',"\x{58ec}","\x{5348}","\x{99ac}",'horse'],
    ['2003-02-01','2004-01-21','yin','water',"\x{7678}","\x{672a}","\x{7f8a}",'goat'],
    ['2004-01-22','2005-02-08','yang','wood',"\x{7532}","\x{7533}","\x{7334}",'monkey'],
    ['2005-02-09','2006-01-28','yin','wood',"\x{4e59}","\x{9149}","\x{96de}",'rooster'],
    ['2006-01-29','2007-02-17','yang','fire',"\x{4e19}","\x{620c}","\x{72d7}",'dog'],
    ['2007-02-18','2008-02-06','yin','fire',"\x{4e01}","\x{4ea5}","\x{732a}",'pig'],
    ['2008-02-07','2009-01-25','yang','earth',"\x{620a}","\x{5b50}","\x{9f20}",'rat'],
    ['2009-01-26','2010-02-13','yin','earth',"\x{5df1}","\x{4e11}","\x{725b}",'ox'],
    ['2010-02-14','2011-02-02','yang','metal',"\x{5e9a}","\x{5bc5}","\x{864e}",'tiger'],
    ['2011-02-03','2012-01-22','yin','metal',"\x{8f9b}","\x{536f}","\x{5154}",'rabbit'],
    ['2012-01-23','2013-02-09','yang','water',"\x{58ec}","\x{8fb0}","\x{9f8d}",'dragon'],
    ['2013-02-10','2014-01-30','yin','water',"\x{7678}","\x{5df3}","\x{86c7}",'snake'],
    ['2014-01-31','2015-02-18','yang','wood',"\x{7532}","\x{5348}","\x{99ac}",'horse'],
    ['2015-02-19','2016-02-07','yin','wood',"\x{4e59}","\x{672a}","\x{7f8a}",'goat'],
    ['2016-02-08','2017-01-27','yang','fire',"\x{4e19}","\x{7533}","\x{7334}",'monkey'],
    ['2017-01-28','2018-02-15','yin','fire',"\x{4e01}","\x{9149}","\x{96de}",'rooster'],
    ['2018-02-16','2019-02-04','yang','earth',"\x{620a}","\x{620c}","\x{72d7}",'dog'],
    ['2019-02-05','2020-01-24','yin','earth',"\x{5df1}","\x{4ea5}","\x{732a}",'pig'],
    ['2020-01-25','2021-02-11','yang','metal',"\x{5e9a}","\x{5b50}","\x{9f20}",'rat'],
    ['2021-02-12','2022-01-31','yin','metal',"\x{8f9b}","\x{4e11}","\x{725b}",'ox'],
    ['2022-02-01','2023-01-21','yang','water',"\x{58ec}","\x{5bc5}","\x{864e}",'tiger'],
    ['2023-01-22','2024-02-09','yin','water',"\x{7678}","\x{536f}","\x{5154}",'rabbit'],
    ['2024-02-10','2025-01-28','yang','wood',"\x{7532}","\x{8fb0}","\x{9f8d}",'dragon'],
    ['2025-01-29','2026-02-16','yin','wood',"\x{4e59}","\x{5df3}","\x{86c7}",'snake'],
    ['2026-02-17','2027-02-05','yang','fire',"\x{4e19}","\x{5348}","\x{99ac}",'horse'],
    ['2027-02-06','2028-01-25','yin','fire',"\x{4e01}","\x{672a}","\x{7f8a}",'goat'],
    ['2028-01-26','2029-02-12','yang','earth',"\x{620a}","\x{7533}","\x{7334}",'monkey'],
    ['2029-02-13','2030-02-02','yin','earth',"\x{5df1}","\x{9149}","\x{96de}",'rooster'],
    ['2030-02-03','2031-01-22','yang','metal',"\x{5e9a}","\x{620c}","\x{72d7}",'dog'],
    ['2031-01-23','2032-02-10','yin','metal',"\x{8f9b}","\x{4ea5}","\x{732a}",'pig'],
    ['2032-02-11','2033-01-30','yang','water',"\x{58ec}","\x{5b50}","\x{9f20}",'rat'],
    ['2033-01-31','2034-02-18','yin','water',"\x{7678}","\x{4e11}","\x{725b}",'ox'],
    ['2034-02-19','2035-02-07','yang','wood',"\x{7532}","\x{5bc5}","\x{864e}",'tiger'],
    ['2035-02-08','2036-01-27','yin','wood',"\x{4e59}","\x{536f}","\x{5154}",'rabbit'],
    ['2036-01-28','2037-02-14','yang','fire',"\x{4e19}","\x{8fb0}","\x{9f8d}",'dragon'],
    ['2037-02-15','2038-02-03','yin','fire',"\x{4e01}","\x{5df3}","\x{86c7}",'snake'],
    ['2038-02-04','2039-01-23','yang','earth',"\x{620a}","\x{5348}","\x{99ac}",'horse'],
    ['2039-01-24','2040-02-11','yin','earth',"\x{5df1}","\x{672a}","\x{7f8a}",'goat'],
    ['2040-02-12','2041-01-31','yang','metal',"\x{5e9a}","\x{7533}","\x{7334}",'monkey'],
    ['2041-02-01','2042-01-21','yin','metal',"\x{8f9b}","\x{9149}","\x{96de}",'rooster'],
    ['2042-01-22','2043-02-09','yang','water',"\x{58ec}","\x{620c}","\x{72d7}",'dog'],
    ['2043-02-10','2044-01-29','yin','water',"\x{7678}","\x{4ea5}","\x{732a}",'pig'],
]
;
# END FRAGMENT id=data

sub chinese_zodiac {
    my $date = shift;

    my $idx = binsearch {
        $a lt $b->[0] ? -1 :
            $a gt $b->[1] ? 1 : 0
        } $date, @$data;
    return undef unless defined $idx;

    $data->[$idx];
}

1;
# ABSTRACT: Look up Chinese zodiac for a given Gregorian date

__END__

=pod

=encoding UTF-8

=head1 NAME

Zodiac::Chinese::Table - Look up Chinese zodiac for a given Gregorian date

=head1 VERSION

This document describes version 0.01 of Zodiac::Chinese::Table (from Perl distribution Zodiac-Chinese-Table), released on 2015-11-21.

=head1 SYNOPSIS

 use Chinese::Zodiac::Table qw(chinese_zodiac);
 my $res = chinese_zodiac("1980-02-17");

Sample result:

 [
   "1980-02-16",
   "1981-02-04",
   "yang",
   "metal",
   "庚",
   "申",
   "猴",
   "monkey",
 ]

=head1 DESCRIPTION

This module can look up Chinese zodiac for a given Gregorian date. Compared to
L<Zodiac::Chinese>, it uses a lookup table (currently available for years
1924-2043) so it is more accurate.

Data source is currently at: https://github.com/perlancar/gudangdata
(table/chinese_zodiac), which in turn is parsed from Wikipedia article.

=head1 FUNCTIONS

=head2 chinese_zodiac($date) => arrayref

Return Chinese zodiac information for a Gregorian date C<$date>. Currently date
must be a string in the format of C<YYYY-MM-DD>. Will return an arrayref
containing these elements:

 # index: 0         1           2           3              4               5               6            7
 ["start_date", "end_date", "yin_yang", "element", "heavenly_stem", "earthly_branch", "zh_animal", "en_animal"].

Will return undef if date range is unsupported.

=head1 SEE ALSO

L<Zodiac::Chinese>

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Zodiac-Chinese-Table>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Zodiac-Chinese-Table>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Zodiac-Chinese-Table>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
