package Pod::Elide;

our $DATE = '2017-01-28'; # DATE
our $VERSION = '0.001'; # VERSION

use 5.010001;
use strict;
use warnings;

use Exporter;
our @ISA = qw(Exporter);
our @EXPORT_OK = qw(elide);

sub _markup {
    my ($cmd, $rest) = @_;

    my $prio = 10;
    if ($cmd =~ /\Ahead(\d+)\z/) {
        $prio = $1;
    }

    "<elspan prio=$prio>=$cmd$rest</elspan>";
}

sub elide {
    require String::Elide::Lines;

    my ($str, $len, $opts) = @_;

    $opts //= {};

    $str =~ s/^=(\w+)(.*\R(?:\R|\z))/_markup($1, $2)/egm;
    #print $str;
    String::Elide::Lines::elide($str, $len, {%$opts, default_prio=>999});
}

1;
# ABSTRACT: Elide POD lines from a string, with options

__END__

=pod

=encoding UTF-8

=head1 NAME

Pod::Elide - Elide POD lines from a string, with options

=head1 VERSION

This document describes version 0.001 of Pod::Elide (from Perl distribution Pod-Elide), released on 2017-01-28.

=head1 SYNOPSIS

 use Pod::Elide qw(elide);
 print elide(<<EOP, 20);
 =head1 NAME

 Foo - Do something fooish

 =head1 VERSION

 1.23

 =head1 SYNOPSIS

  blah blah
  blah blah
  blah blah

 =head1 DESCRIPTION

 Some description some description some description. Some description some
 description some description some description. Some description some
 description some description. Some description some description some
 description some description. Some description some description some
 description. Some description some description some description some
 description.

 =head1 FUNCTIONS

 =head2 func1

 Blah blah blah
 Blah blah blah

 =head2 func2

 Blah blah blah
 Blah blah blah

 =head1 SEE ALSO

 L<Bar>

 =cut
 EOP

The output is something like:

 =head1 NAME

 =head1 VERSION

 =head1 SYNOPSIS

 =head1 DESCRIPTION

 Some description some description some description. Some description some
 description some description some description. Some description some
 ..
 =head1 FUNCTIONS

 =head2 func1

 =head2 func2

 =head1 SEE ALSO

 =cut

=head1 DESCRIPTION

String::Elide::Lines is based on L<String::Elide::Parts> but works on a per-line
basis.

=head1 FUNCTIONS

=head2 elide($str, $len[, \%opts]) => str

Elide lines from a string if the string contains more than C<$len> lines.

String can be marked with C<< <elspan prio=N truncate=T marker=M>...</elspan> >>
so there can be multiple parts with different priorities and truncate direction.
The default priority is 1. You can mark less important lines with higher
priority to let it be elided first. The markup will be removed from the string
before eliding.

Known options:

=over

=item * marker => str (default: '..')

=item * truncate => 'top'|'middle'|'bottom'|'ends' (default: 'bottom')

=back

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Pod-Elide>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Pod-Elide>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Pod-Elide>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 SEE ALSO

L<String::Elide::Parts> is the basis of this module but works on a per-character
basis. See that module's SEE ALSO for list of other string eliding modules.

L<Pod::Elide> uses this module.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
