package DBIx::TSV;

our $DATE = '2018-07-01'; # DATE
our $VERSION = '0.001'; # VERSION

use strict;
use warnings;
use DBIx::TextTableAny;

sub import {
    my $class = shift;

    %DBIx::TextTableAny::opts = (
        @_,
        backend => 'Text::Table::TSV',
    );
}

package
    DBI::db;

sub selectrow_tsv { goto &selectrow_texttable }
sub selectall_tsv { goto &selectall_texttable }

package
    DBI::st;

sub fetchrow_tsv { goto &fetchrow_texttable }
sub fetchall_tsv { goto &fetchall_texttable }

1;
# ABSTRACT: Generate TSV from SQL query result

__END__

=pod

=encoding UTF-8

=head1 NAME

DBIx::TSV - Generate TSV from SQL query result

=head1 VERSION

This document describes version 0.001 of DBIx::TSV (from Perl distribution DBIx-TSV), released on 2018-07-01.

=head1 SYNOPSIS

 use DBI;
 use DBIx::TSV;
 my $dbh = DBI->connect("dbi:mysql:database=mydb", "someuser", "somepass");

Selecting a row:

 print $dbh->selectrow_tsv("SELECT * FROM member");

Sample result (default backend is L<Text::Table::Tiny>):

 Name    Rank    Serial
 alice   pvt     123456

Selecting all rows:

 print $dbh->selectrow_tsv("SELECT * FROM member");

Sample result:

 Name    Rank    Serial
 alice   pvt     123456
 bob     cpl     98765321
 carol   brig gen        8745

Setting other options:

 DBIx::TSV->import(header_row => 0);

 my $sth = $dbh->prepare("SELECT * FROM member");
 $sth->execute;

 print $sth->fetchall_tsv;

Sample result:

 alice   pvt     123456
 bob     cpl     98765321
 carol   brig gen        8745

=head1 DESCRIPTION

This package is a thin glue between L<DBI> and L<DBIx::TextTableAny> (which in
turn is a thin glue to L<Text::Table::Any>). It adds the following methods to
database handle:

 selectrow_tsv
 selectall_tsv

as well as the following methods to statement handle:

 fetchrow_tsv
 fetchall_tsv

The methods send the result of query to Text::Table::Any (using the
L<Text::Table::TSV> backend) and return the rendered TSV data.

In essence, this is an easy, straightforward way produce TSV data from SQL
query.

=for Pod::Coverage ^(.+)$

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/DBIx-TSV>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-DBIx-TSV>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=DBIx-TSV>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 SEE ALSO

L<DBIx::CSV>

L<DBIx::TextTableAny> which has a similar interface as this module and offers
multiple output formats.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2018 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
