package Bencher::Scenario::HashPicking::pick;

our $DATE = '2016-08-29'; # DATE
our $VERSION = '0.001'; # VERSION

use 5.010001;
use strict;
use warnings;

our $scenario = {
    summary => 'Benchmark hash picking',
    participants => [
        {
            module => 'Hash::Util::Pick',
            function => 'pick',
            code_template => 'state $hash = <hash>; state $keys = <keys>; Hash::Util::Pick::pick($hash, @$keys)',
        },
        {
            name => 'map',
            code_template => 'state $hash = <hash>; state $keys = <keys>; +{ map { (exists $hash->{$_} ? ($_ => $hash->{$_}) : ()) } @$keys}',
        },
        {
            name => 'map+grep',
            code_template => 'state $hash = <hash>; state $keys = <keys>; +{ map {$_ => $hash->{$_}} grep { exists $hash->{$_} } @$keys}',
        },
    ],

    datasets => [
        {
            name => 'keys=2, pick=2, exists=1',
            args => { hash=>{1=>1, 2=>1}, keys=>[1, 3] },
        },

        {
            name => 'keys=10, pick=2, exists=1',
            args => { hash=>{map {$_=>1} 1..10}, keys=>[1, 11] },
        },
        {
            name => 'keys=10, pick=10, exists=5',
            args => { hash=>{map {$_=>1} 1..10}, keys=>[1..5, 11..15] },
        },

        {
            name => 'keys=100, pick=2, exists=1',
            args => { hash=>{map {$_=>1} 1..100}, keys=>[1, 101] },
        },
        {
            name => 'keys=100, pick=10, exists=5',
            args => { hash=>{map {$_=>1} 1..100}, keys=>[1..5, 101..105] },
        },
        {
            name => 'keys=100, pick=100, exists=50',
            args => { hash=>{map {$_=>1} 1..100}, keys=>[1..50, 101..150] },
        },

        {
            name => 'keys=1000, pick=2, exists=1',
            args => { hash=>{map {$_=>1} 1..1000}, keys=>[1, 1001] },
        },
        {
            name => 'keys=1000, pick=10, exists=5',
            args => { hash=>{map {$_=>1} 1..1000}, keys=>[1..5, 1001..1005] },
        },
        {
            name => 'keys=1000, pick=100, exists=50',
            args => { hash=>{map {$_=>1} 1..1000}, keys=>[1..50, 1001..1050] },
        },
        {
            name => 'keys=1000, pick=1000, exists=500',
            args => { hash=>{map {$_=>1} 1..1000}, keys=>[1..500, 1001..1500] },
        },

        {
            name => 'keys=10000, pick=2, exists=1',
            args => { hash=>{map {$_=>1} 1..10000}, keys=>[1,10001] },
        },
        {
            name => 'keys=10000, pick=10, exists=5',
            args => { hash=>{map {$_=>1} 1..10000}, keys=>[1..5,10001..10005] },
        },
        {
            name => 'keys=10000, pick=100, exists=50',
            args => { hash=>{map {$_=>1} 1..10000}, keys=>[1..50,10001..10050] },
        },

        {
            name => 'keys=100000, pick=2, exists=1',
            args => { hash=>{map {$_=>1} 1..100000}, keys=>[1,100001] },
        },
    ],
};

1;
# ABSTRACT: Benchmark hash picking

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::HashPicking::pick - Benchmark hash picking

=head1 VERSION

This document describes version 0.001 of Bencher::Scenario::HashPicking::pick (from Perl distribution Bencher-Scenarios-HashPicking), released on 2016-08-29.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m HashPicking::pick

To run module startup overhead benchmark:

 % bencher --module-startup -m HashPicking::pick

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<Hash::Util::Pick> 0.03

=head1 BENCHMARK PARTICIPANTS

=over

=item * Hash::Util::Pick::pick (perl_code)

Code template:

 state $hash = <hash>; state $keys = <keys>; Hash::Util::Pick::pick($hash, @$keys)



=item * map (perl_code)

Code template:

 state $hash = <hash>; state $keys = <keys>; +{ map { (exists $hash->{$_} ? ($_ => $hash->{$_}) : ()) } @$keys}



=item * map+grep (perl_code)

Code template:

 state $hash = <hash>; state $keys = <keys>; +{ map {$_ => $hash->{$_}} grep { exists $hash->{$_} } @$keys}



=back

=head1 BENCHMARK DATASETS

=over

=item * keys=2, pick=2, exists=1

=item * keys=10, pick=2, exists=1

=item * keys=10, pick=10, exists=5

=item * keys=100, pick=2, exists=1

=item * keys=100, pick=10, exists=5

=item * keys=100, pick=100, exists=50

=item * keys=1000, pick=2, exists=1

=item * keys=1000, pick=10, exists=5

=item * keys=1000, pick=100, exists=50

=item * keys=1000, pick=1000, exists=500

=item * keys=10000, pick=2, exists=1

=item * keys=10000, pick=10, exists=5

=item * keys=10000, pick=100, exists=50

=item * keys=100000, pick=2, exists=1

=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.1 >>, CPU: I<< Intel(R) Core(TM) M-5Y71 CPU @ 1.20GHz (2 cores) >>, OS: I<< GNU/Linux LinuxMint version 17.3 >>, OS kernel: I<< Linux version 3.19.0-32-generic >>.

Benchmark with default options (C<< bencher -m HashPicking::pick >>):

 #table1#
 {dataset=>"keys=10, pick=10, exists=5"}
 +------------------------+-----------+-----------+------------+---------+---------+
 | participant            | rate (/s) | time (μs) | vs_slowest |  errors | samples |
 +------------------------+-----------+-----------+------------+---------+---------+
 | map+grep               |    400000 |      3    |       1    | 3.4e-08 |      21 |
 | map                    |    459000 |      2.18 |       1.16 | 1.1e-09 |      25 |
 | Hash::Util::Pick::pick |   1300000 |      0.76 |       3.3  | 1.7e-09 |      20 |
 +------------------------+-----------+-----------+------------+---------+---------+

 #table2#
 {dataset=>"keys=10, pick=2, exists=1"}
 +------------------------+-----------+-----------+------------+---------+---------+
 | participant            | rate (/s) | time (ns) | vs_slowest |  errors | samples |
 +------------------------+-----------+-----------+------------+---------+---------+
 | map+grep               |   1262370 |   792.158 |      1     |   0     |      20 |
 | map                    |   1602000 |   624.1   |      1.269 | 4.6e-11 |      20 |
 | Hash::Util::Pick::pick |   3500000 |   290     |      2.8   | 4.3e-10 |      20 |
 +------------------------+-----------+-----------+------------+---------+---------+

 #table3#
 {dataset=>"keys=100, pick=10, exists=5"}
 +------------------------+-----------+-----------+------------+---------+---------+
 | participant            | rate (/s) | time (μs) | vs_slowest |  errors | samples |
 +------------------------+-----------+-----------+------------+---------+---------+
 | map+grep               |    430000 |      2.33 |        1   | 8.4e-10 |      20 |
 | map                    |    460000 |      2.2  |        1.1 | 3.3e-09 |      20 |
 | Hash::Util::Pick::pick |   1500000 |      0.65 |        3.6 | 8.3e-10 |      20 |
 +------------------------+-----------+-----------+------------+---------+---------+

 #table4#
 {dataset=>"keys=100, pick=100, exists=50"}
 +------------------------+-----------+-----------+------------+---------+---------+
 | participant            | rate (/s) | time (μs) | vs_slowest |  errors | samples |
 +------------------------+-----------+-----------+------------+---------+---------+
 | map                    |     42000 |      24   |        1   | 2.7e-08 |      20 |
 | map+grep               |     46000 |      22   |        1.1 | 2.7e-08 |      20 |
 | Hash::Util::Pick::pick |    150000 |       6.5 |        3.6 | 1.3e-08 |      20 |
 +------------------------+-----------+-----------+------------+---------+---------+

 #table5#
 {dataset=>"keys=100, pick=2, exists=1"}
 +------------------------+-----------+-----------+------------+---------+---------+
 | participant            | rate (/s) | time (ns) | vs_slowest |  errors | samples |
 +------------------------+-----------+-----------+------------+---------+---------+
 | map+grep               |   1416000 |     706.2 |      1     | 4.7e-11 |      20 |
 | map                    |   1583000 |     631.8 |      1.118 | 1.1e-11 |      20 |
 | Hash::Util::Pick::pick |   2900000 |     350   |      2     | 8.3e-10 |      20 |
 +------------------------+-----------+-----------+------------+---------+---------+

 #table6#
 {dataset=>"keys=1000, pick=10, exists=5"}
 +------------------------+-----------+-----------+------------+---------+---------+
 | participant            | rate (/s) | time (μs) | vs_slowest |  errors | samples |
 +------------------------+-----------+-----------+------------+---------+---------+
 | map                    |    200000 |       5   |        1   | 6.8e-08 |      20 |
 | map+grep               |    410000 |       2.5 |        1.9 | 2.5e-09 |      20 |
 | Hash::Util::Pick::pick |   1200000 |       0.8 |        5.9 | 3.3e-09 |      20 |
 +------------------------+-----------+-----------+------------+---------+---------+

 #table7#
 {dataset=>"keys=1000, pick=100, exists=50"}
 +------------------------+-----------+-----------+------------+---------+---------+
 | participant            | rate (/s) | time (μs) | vs_slowest |  errors | samples |
 +------------------------+-----------+-----------+------------+---------+---------+
 | map                    |     20000 |    40     |      1     | 4.4e-07 |      20 |
 | map+grep               |     43231 |    23.131 |      1.763 | 4.6e-11 |      20 |
 | Hash::Util::Pick::pick |    130000 |     8     |      5.1   | 1.3e-08 |      21 |
 +------------------------+-----------+-----------+------------+---------+---------+

 #table8#
 {dataset=>"keys=1000, pick=1000, exists=500"}
 +------------------------+-----------+-----------+------------+---------+---------+
 | participant            | rate (/s) | time (μs) | vs_slowest |  errors | samples |
 +------------------------+-----------+-----------+------------+---------+---------+
 | map                    |      2300 |       430 |       1    | 6.4e-07 |      20 |
 | map+grep               |      4080 |       245 |       1.76 | 1.6e-07 |      20 |
 | Hash::Util::Pick::pick |      9100 |       110 |       3.9  | 2.5e-07 |      23 |
 +------------------------+-----------+-----------+------------+---------+---------+

 #table9#
 {dataset=>"keys=1000, pick=2, exists=1"}
 +------------------------+-----------+-----------+------------+---------+---------+
 | participant            | rate (/s) | time (ns) | vs_slowest |  errors | samples |
 +------------------------+-----------+-----------+------------+---------+---------+
 | map                    |    700000 |    1400   |      1     | 1.4e-08 |      21 |
 | map+grep               |   1386000 |     721.7 |      1.985 | 4.6e-11 |      21 |
 | Hash::Util::Pick::pick |   3300000 |     310   |      4.7   | 4.2e-10 |      20 |
 +------------------------+-----------+-----------+------------+---------+---------+

 #table10#
 {dataset=>"keys=10000, pick=10, exists=5"}
 +------------------------+-----------+-----------+------------+---------+---------+
 | participant            | rate (/s) | time (μs) | vs_slowest |  errors | samples |
 +------------------------+-----------+-----------+------------+---------+---------+
 | map+grep               |    426230 |   2.34615 |       1    |   0     |      20 |
 | map                    |    454000 |   2.2     |       1.06 | 7.6e-10 |      24 |
 | Hash::Util::Pick::pick |   1500000 |   0.66    |       3.5  | 8.3e-10 |      20 |
 +------------------------+-----------+-----------+------------+---------+---------+

 #table11#
 {dataset=>"keys=10000, pick=100, exists=50"}
 +------------------------+-----------+-----------+------------+---------+---------+
 | participant            | rate (/s) | time (μs) | vs_slowest |  errors | samples |
 +------------------------+-----------+-----------+------------+---------+---------+
 | map                    |     41700 |      24   |        1   |   2e-08 |      21 |
 | map+grep               |     44000 |      23   |        1.1 | 2.7e-08 |      20 |
 | Hash::Util::Pick::pick |    140000 |       7.3 |        3.3 | 1.3e-08 |      20 |
 +------------------------+-----------+-----------+------------+---------+---------+

 #table12#
 {dataset=>"keys=10000, pick=2, exists=1"}
 +------------------------+-----------+-----------+------------+---------+---------+
 | participant            | rate (/s) | time (ns) | vs_slowest |  errors | samples |
 +------------------------+-----------+-----------+------------+---------+---------+
 | map+grep               |   1415000 |     706.5 |        1   | 1.1e-11 |      20 |
 | map                    |   1000000 |     700   |        1   | 8.7e-09 |      20 |
 | Hash::Util::Pick::pick |   3300000 |     300   |        2.4 | 4.2e-10 |      20 |
 +------------------------+-----------+-----------+------------+---------+---------+

 #table13#
 {dataset=>"keys=100000, pick=2, exists=1"}
 +------------------------+-----------+-----------+------------+---------+---------+
 | participant            | rate (/s) | time (ns) | vs_slowest |  errors | samples |
 +------------------------+-----------+-----------+------------+---------+---------+
 | map                    |   1400000 |     720   |      1     | 1.3e-09 |      31 |
 | map+grep               |   1417000 |     705.8 |      1.018 | 4.4e-11 |      20 |
 | Hash::Util::Pick::pick |   3500000 |     290   |      2.5   | 4.3e-10 |      21 |
 +------------------------+-----------+-----------+------------+---------+---------+

 #table14#
 {dataset=>"keys=2, pick=2, exists=1"}
 +------------------------+-----------+-----------+------------+---------+---------+
 | participant            | rate (/s) | time (ns) | vs_slowest |  errors | samples |
 +------------------------+-----------+-----------+------------+---------+---------+
 | map+grep               |   1300000 |     800   |      1     | 1.4e-09 |      29 |
 | map                    |   1620000 |     617.2 |      1.291 | 2.3e-11 |      23 |
 | Hash::Util::Pick::pick |   3500000 |     290   |      2.8   | 7.6e-10 |      20 |
 +------------------------+-----------+-----------+------------+---------+---------+


Benchmark module startup overhead (C<< bencher -m HashPicking::pick --module-startup >>):

 #table15#
 +---------------------+-----------+------------------------+------------+---------+---------+
 | participant         | time (ms) | mod_overhead_time (ms) | vs_slowest |  errors | samples |
 +---------------------+-----------+------------------------+------------+---------+---------+
 | Hash::Util::Pick    |      13   |                    3.5 |        1   | 6.5e-05 |      20 |
 | perl -e1 (baseline) |       9.5 |                    0   |        1.4 | 3.2e-05 |      20 |
 +---------------------+-----------+------------------------+------------+---------+---------+

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-HashPicking>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenarios-HashPicking>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-HashPicking>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
