package Bencher::Scenario::Accessors::ClassStartup;

our $DATE = '2016-09-09'; # DATE
our $VERSION = '0.10'; # VERSION

use Bencher::ScenarioUtil::Accessors;

my $classes = \%Bencher::ScenarioUtil::Accessors::classes;

our $scenario = {
    summary => 'Benchmark startup of classes using various accessor generators',
    module_startup => 1,
    modules => {
        # include the generator modules here so we can show their versions in
        # sample benchmark results produced by PWP:Bencher::Scenario
        (map { $_=>0 } grep {defined} map { $classes->{$_}{generator} }
             keys %$classes),
    },
    participants => [
        map {
            #my $spec = $classes->{$_};
            +{ module=>$_ };
        } keys %$classes,
    ],
};

1;
# ABSTRACT: Benchmark startup of classes using various accessor generators

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::Accessors::ClassStartup - Benchmark startup of classes using various accessor generators

=head1 VERSION

This document describes version 0.10 of Bencher::Scenario::Accessors::ClassStartup (from Perl distribution Bencher-Scenarios-Accessors), released on 2016-09-09.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m Accessors::ClassStartup

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<Class::Accessor> 0.34

L<Class::Accessor::Array> 0.02

L<Class::InsideOut> 1.13

L<Class::Tiny> 1.004

L<Class::XSAccessor> 1.19

L<Class::XSAccessor::Array> 1.19

L<Mo> 0.40

L<Mojo::Base>

L<Moo> 2.002004

L<Moose> 2.1805

L<Mouse> v2.4.5

L<Object::Simple> 3.1703

L<Perl::Examples::Accessors::Array> 0.08

L<Perl::Examples::Accessors::ClassAccessor> 0.08

L<Perl::Examples::Accessors::ClassAccessorArray> 0.08

L<Perl::Examples::Accessors::ClassInsideOut> 0.08

L<Perl::Examples::Accessors::ClassTiny> 0.08

L<Perl::Examples::Accessors::ClassXSAccessor> 0.08

L<Perl::Examples::Accessors::ClassXSAccessorArray> 0.08

L<Perl::Examples::Accessors::Hash> 0.08

L<Perl::Examples::Accessors::Mo> 0.08

L<Perl::Examples::Accessors::MojoBase> 0.08

L<Perl::Examples::Accessors::Moo> 0.08

L<Perl::Examples::Accessors::Moose> 0.08

L<Perl::Examples::Accessors::Mouse> 0.08

L<Perl::Examples::Accessors::ObjectSimple> 0.08

L<Perl::Examples::Accessors::Scalar> 0.08

L<Perl::Examples::Accessors::SimpleAccessor> 0.08

L<Simple::Accessor> 1.02

=head1 BENCHMARK PARTICIPANTS

=over

=item * Perl::Examples::Accessors::SimpleAccessor (perl_code)

L<Perl::Examples::Accessors::SimpleAccessor>



=item * Perl::Examples::Accessors::Mouse (perl_code)

L<Perl::Examples::Accessors::Mouse>



=item * Perl::Examples::Accessors::MojoBase (perl_code)

L<Perl::Examples::Accessors::MojoBase>



=item * Perl::Examples::Accessors::ClassAccessor (perl_code)

L<Perl::Examples::Accessors::ClassAccessor>



=item * Perl::Examples::Accessors::Hash (perl_code)

L<Perl::Examples::Accessors::Hash>



=item * Perl::Examples::Accessors::Moose (perl_code)

L<Perl::Examples::Accessors::Moose>



=item * Perl::Examples::Accessors::Moo (perl_code)

L<Perl::Examples::Accessors::Moo>



=item * Perl::Examples::Accessors::ClassXSAccessor (perl_code)

L<Perl::Examples::Accessors::ClassXSAccessor>



=item * Perl::Examples::Accessors::Scalar (perl_code)

L<Perl::Examples::Accessors::Scalar>



=item * Perl::Examples::Accessors::ClassTiny (perl_code)

L<Perl::Examples::Accessors::ClassTiny>



=item * Perl::Examples::Accessors::ClassXSAccessorArray (perl_code)

L<Perl::Examples::Accessors::ClassXSAccessorArray>



=item * Perl::Examples::Accessors::ClassAccessorArray (perl_code)

L<Perl::Examples::Accessors::ClassAccessorArray>



=item * Perl::Examples::Accessors::Array (perl_code)

L<Perl::Examples::Accessors::Array>



=item * Perl::Examples::Accessors::ClassInsideOut (perl_code)

L<Perl::Examples::Accessors::ClassInsideOut>



=item * Perl::Examples::Accessors::Mo (perl_code)

L<Perl::Examples::Accessors::Mo>



=item * Perl::Examples::Accessors::ObjectSimple (perl_code)

L<Perl::Examples::Accessors::ObjectSimple>



=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.24.0 >>, CPU: I<< Intel(R) Core(TM) i5-2400 CPU @ 3.10GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default options (C<< bencher -m Accessors::ClassStartup >>):

 #table1#
 +-------------------------------------------------+-----------+------------------------+------------+-----------+---------+
 | participant                                     | time (ms) | mod_overhead_time (ms) | vs_slowest |  errors   | samples |
 +-------------------------------------------------+-----------+------------------------+------------+-----------+---------+
 | Perl::Examples::Accessors::Moose                |     200   |                  195.5 |        1   |   0.0025  |      22 |
 | Perl::Examples::Accessors::Moo                  |      32   |                   27.5 |        5.8 | 6.5e-05   |      20 |
 | Perl::Examples::Accessors::Mouse                |      26   |                   21.5 |        7.2 | 7.2e-05   |      20 |
 | Perl::Examples::Accessors::ClassInsideOut       |      16   |                   11.5 |       11   | 8.8e-05   |      20 |
 | Perl::Examples::Accessors::MojoBase             |      16   |                   11.5 |       12   | 7.7e-05   |      20 |
 | Perl::Examples::Accessors::ClassTiny            |      14   |                    9.5 |       13   | 5.7e-05   |      20 |
 | Perl::Examples::Accessors::ObjectSimple         |      10   |                    5.5 |       10   |   0.00015 |      20 |
 | Perl::Examples::Accessors::ClassXSAccessorArray |      13   |                    8.5 |       15   | 8.8e-05   |      22 |
 | Perl::Examples::Accessors::ClassXSAccessor      |      13   |                    8.5 |       15   | 9.9e-05   |      20 |
 | Perl::Examples::Accessors::ClassAccessor        |      12   |                    7.5 |       15   | 5.7e-05   |      21 |
 | Perl::Examples::Accessors::SimpleAccessor       |       6.9 |                    2.4 |       27   | 2.3e-05   |      20 |
 | Perl::Examples::Accessors::Mo                   |       6.6 |                    2.1 |       28   | 2.6e-05   |      20 |
 | Perl::Examples::Accessors::ClassAccessorArray   |       6.6 |                    2.1 |       28   | 2.1e-05   |      20 |
 | Perl::Examples::Accessors::Scalar               |       4.8 |                    0.3 |       39   | 3.6e-05   |      20 |
 | perl -e1 (baseline)                             |       4.5 |                    0   |       41   | 4.2e-05   |      20 |
 | Perl::Examples::Accessors::Array                |       4.5 |                    0   |       41   | 1.7e-05   |      20 |
 | Perl::Examples::Accessors::Hash                 |       4.5 |                    0   |       42   | 2.2e-05   |      20 |
 +-------------------------------------------------+-----------+------------------------+------------+-----------+---------+

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-Accessors>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenarios-Accessors>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-Accessors>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 SEE ALSO

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
