package Bencher::Scenario::Accessors::Construction;

our $DATE = '2016-04-14'; # DATE
our $VERSION = '0.05'; # VERSION

use Bencher::ScenarioUtil::Accessors;

my $classes = \%Bencher::ScenarioUtil::Accessors::classes;

our $scenario = {
    summary => 'Benchmark object construction',
    modules => {
        'Perl::Examples::Accessors' => {version=>0.04},
    },
    participants => [
        map {
            my $spec = $classes->{$_};
            +{
                name => $spec->{generator} || $spec->{name},
                module => $_,
                code_template => "${_}->new",
            };
        } keys %$classes,
    ],
    include_result_size => 1,
};

1;
# ABSTRACT: Benchmark object construction

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::Accessors::Construction - Benchmark object construction

=head1 VERSION

This document describes version 0.05 of Bencher::Scenario::Accessors::Construction (from Perl distribution Bencher-Scenarios-Accessors), released on 2016-04-14.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m Accessors::Construction

To run module startup overhead benchmark:

 % bencher --module-startup -m Accessors::Construction

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<Perl::Examples::Accessors> 0.04

L<Perl::Examples::Accessors::Array> 0.04

L<Perl::Examples::Accessors::ClassAccessor> 0.04

L<Perl::Examples::Accessors::ClassAccessorArray> 0.04

L<Perl::Examples::Accessors::ClassInsideOut> 0.04

L<Perl::Examples::Accessors::ClassXSAccessor> 0.04

L<Perl::Examples::Accessors::ClassXSAccessorArray> 0.04

L<Perl::Examples::Accessors::Hash> 0.04

L<Perl::Examples::Accessors::Mo> 0.04

L<Perl::Examples::Accessors::Moo> 0.04

L<Perl::Examples::Accessors::Moose> 0.04

L<Perl::Examples::Accessors::Mouse> 0.04

L<Perl::Examples::Accessors::Scalar> 0.04

=head1 BENCHMARK PARTICIPANTS

=over

=item * Class::XSAccessor::Array (perl_code)

Code template:

 Perl::Examples::Accessors::ClassXSAccessorArray->new



=item * Class::Accessor::Array (perl_code)

Code template:

 Perl::Examples::Accessors::ClassAccessorArray->new



=item * Class::Accessor (perl_code)

Code template:

 Perl::Examples::Accessors::ClassAccessor->new



=item * Moo (perl_code)

Code template:

 Perl::Examples::Accessors::Moo->new



=item * no generator (hash-based) (perl_code)

Code template:

 Perl::Examples::Accessors::Hash->new



=item * Class::XSAccessor (perl_code)

Code template:

 Perl::Examples::Accessors::ClassXSAccessor->new



=item * Mouse (perl_code)

Code template:

 Perl::Examples::Accessors::Mouse->new



=item * no generator (array-based) (perl_code)

Code template:

 Perl::Examples::Accessors::Array->new



=item * Moose (perl_code)

Code template:

 Perl::Examples::Accessors::Moose->new



=item * no generator (scalar-based) (perl_code)

Code template:

 Perl::Examples::Accessors::Scalar->new



=item * Mo (perl_code)

Code template:

 Perl::Examples::Accessors::Mo->new



=item * Class::InsideOut (perl_code)

Code template:

 Perl::Examples::Accessors::ClassInsideOut->new



=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.0 >>, CPU: I<< Intel(R) Core(TM) i7-4770 CPU @ 3.40GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default options (C<< bencher -m Accessors::Construction >>):

 +-----------------------------+-------------+-----------+------------+-----------------+---------+---------+
 | participant                 | rate (/s)   | time (μs) | vs_slowest | result_size (b) | errors  | samples |
 +-----------------------------+-------------+-----------+------------+-----------------+---------+---------+
 | Class::InsideOut            | 3.9e+05     | 2.6       | 1          | 144             | 3.3e-09 | 20      |
 | Moose                       | 9.2495e+05  | 1.0811    | 2.3846     | 120             | 9.2e-12 | 22      |
 | Mo                          | 1.3e+06     | 0.77      | 3.4        | 120             | 1.7e-09 | 20      |
 | Moo                         | 1.667e+06   | 0.5998    | 4.298      | 120             | 1.1e-11 | 20      |
 | Class::Accessor             | 1.81e+06    | 0.5525    | 4.667      | 120             | 1e-11   | 20      |
 | Mouse                       | 2.06e+06    | 0.485     | 5.31       | 120             | 1.8e-10 | 26      |
 | no generator (array-based)  | 2.54975e+06 | 0.392196  | 6.57354    | 64              | 0       | 20      |
 | no generator (hash-based)   | 3.033e+06   | 0.3297    | 7.821      | 120             | 1.2e-11 | 20      |
 | no generator (scalar-based) | 3.37e+06    | 0.297     | 8.69       | 72              | 1e-10   | 22      |
 | Class::Accessor::Array      | 3.45e+06    | 0.29      | 8.89       | 64              | 8.6e-11 | 30      |
 | Class::XSAccessor           | 5.125e+06   | 0.1951    | 13.21      | 120             | 9.4e-12 | 20      |
 | Class::XSAccessor::Array    | 5.26e+06    | 0.19      | 13.6       | 64              | 1e-10   | 20      |
 +-----------------------------+-------------+-----------+------------+-----------------+---------+---------+

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-Accessors>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenarios-Accessors>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-Accessors>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 SEE ALSO

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
