package Bencher::Scenario::Accessors::ClassStartup;

our $DATE = '2016-03-31'; # DATE
our $VERSION = '0.04'; # VERSION

use Bencher::ScenarioUtil::Accessors;

my $classes = \%Bencher::ScenarioUtil::Accessors::classes;

our $scenario = {
    summary => 'Benchmark startup of classes using various accessor generators',
    module_startup => 1,
    modules => {
    },
    participants => [
        map {
            #my $spec = $classes->{$_};
            +{ module=>$_ };
        } keys %$classes,
    ],
};

1;
# ABSTRACT: Benchmark startup of classes using various accessor generators

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::Accessors::ClassStartup - Benchmark startup of classes using various accessor generators

=head1 VERSION

This document describes version 0.04 of Bencher::Scenario::Accessors::ClassStartup (from Perl distribution Bencher-Scenarios-Accessors), released on 2016-03-31.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m Accessors::ClassStartup

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<Perl::Examples::Accessors::Array> 0.03

L<Perl::Examples::Accessors::ClassAccessor> 0.03

L<Perl::Examples::Accessors::ClassAccessorArray> 0.03

L<Perl::Examples::Accessors::ClassXSAccessor> 0.03

L<Perl::Examples::Accessors::ClassXSAccessorArray> 0.03

L<Perl::Examples::Accessors::Hash> 0.03

L<Perl::Examples::Accessors::Mo> 0.03

L<Perl::Examples::Accessors::Moo> 0.03

L<Perl::Examples::Accessors::Moose> 0.03

L<Perl::Examples::Accessors::Mouse> 0.03

L<Perl::Examples::Accessors::Scalar> 0.03

=head1 BENCHMARK PARTICIPANTS

=over

=item * Perl::Examples::Accessors::Moo (perl_code)

L<Perl::Examples::Accessors::Moo>



=item * Perl::Examples::Accessors::ClassXSAccessorArray (perl_code)

L<Perl::Examples::Accessors::ClassXSAccessorArray>



=item * Perl::Examples::Accessors::Mo (perl_code)

L<Perl::Examples::Accessors::Mo>



=item * Perl::Examples::Accessors::Mouse (perl_code)

L<Perl::Examples::Accessors::Mouse>



=item * Perl::Examples::Accessors::Scalar (perl_code)

L<Perl::Examples::Accessors::Scalar>



=item * Perl::Examples::Accessors::Moose (perl_code)

L<Perl::Examples::Accessors::Moose>



=item * Perl::Examples::Accessors::Hash (perl_code)

L<Perl::Examples::Accessors::Hash>



=item * Perl::Examples::Accessors::Array (perl_code)

L<Perl::Examples::Accessors::Array>



=item * Perl::Examples::Accessors::ClassXSAccessor (perl_code)

L<Perl::Examples::Accessors::ClassXSAccessor>



=item * Perl::Examples::Accessors::ClassAccessorArray (perl_code)

L<Perl::Examples::Accessors::ClassAccessorArray>



=item * Perl::Examples::Accessors::ClassAccessor (perl_code)

L<Perl::Examples::Accessors::ClassAccessor>



=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.0 >>, CPU: I<< Intel(R) Core(TM) i5-2400 CPU @ 3.10GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default options (C<< bencher -m Accessors::ClassStartup >>):

 +-------------------------------------------------+-----------+------------------------+------------+---------+---------+
 | participant                                     | time (ms) | mod_overhead_time (ms) | vs_slowest | errors  | samples |
 +-------------------------------------------------+-----------+------------------------+------------+---------+---------+
 | Perl::Examples::Accessors::Moose                | 1.8e+02   | 175                    | 1          | 0.00066 | 20      |
 | Perl::Examples::Accessors::Moo                  | 32        | 27                     | 5.7        | 9e-05   | 20      |
 | Perl::Examples::Accessors::Mouse                | 26        | 21                     | 6.9        | 6.4e-05 | 20      |
 | Perl::Examples::Accessors::ClassXSAccessorArray | 12        | 7                      | 15         | 9e-05   | 20      |
 | Perl::Examples::Accessors::ClassAccessor        | 12        | 7                      | 15         | 7.9e-05 | 20      |
 | Perl::Examples::Accessors::ClassXSAccessor      | 12        | 7                      | 15         | 8.1e-05 | 21      |
 | Perl::Examples::Accessors::ClassAccessorArray   | 7         | 2                      | 26         | 6.1e-05 | 20      |
 | Perl::Examples::Accessors::Mo                   | 6.8       | 1.8                    | 27         | 4.4e-05 | 20      |
 | Perl::Examples::Accessors::Scalar               | 5         | 0                      | 4e+01      | 7.3e-05 | 20      |
 | Perl::Examples::Accessors::Hash                 | 5         | 0                      | 4e+01      | 5.9e-05 | 20      |
 | Perl::Examples::Accessors::Array                | 4.7       | -0.3                   | 39         | 4.5e-05 | 20      |
 | perl -e1 (baseline)                             | 5         | 0                      | 4e+01      | 8.2e-05 | 20      |
 +-------------------------------------------------+-----------+------------------------+------------+---------+---------+

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-Accessors>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenarios-Accessors>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-Accessors>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 SEE ALSO

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
