package Bencher::Scenario::SetComparison;

our $DATE = '2016-10-19'; # DATE
our $VERSION = '0.001'; # VERSION

use 5.010001;
use strict;
use warnings;

our $scenario = {
    summary => 'Benchmark set comparison',
    participants => [
        {
            module => 'Test::Deep', # Test::Deep::NoTest is useless without importing
            code_template=>'state $set = Test::Deep::set(@{<set>}); Test::Deep::eq_deeply(<array>, $set)',
        },
        {
            module => 'Set::Tiny',
            code_template=>'state $set1 = Set::Tiny->new(@{<array>}); state $set2 = Set::Tiny->new(@{<set>}); $set1->symmetric_difference($set2)->size == 0 ? 1:0',
            tags => ['simple-elements'], # Set::Tiny stringifies arguments
        },
    ],
    datasets => [
        {name=>'elems=10num' , args=>{array=>[1..10] , set=>[reverse 1..10, 1] }},
        {name=>'elems=100num', args=>{array=>[1..100], set=>[reverse 1..100, 1]}},
        {name=>'elems=200num', args=>{array=>[1..200], set=>[reverse 1..200, 1]}},
    ],
};

1;
# ABSTRACT: Benchmark set comparison

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::SetComparison - Benchmark set comparison

=head1 VERSION

This document describes version 0.001 of Bencher::Scenario::SetComparison (from Perl distribution Bencher-Scenario-SetComparison), released on 2016-10-19.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m SetComparison

To run module startup overhead benchmark:

 % bencher --module-startup -m SetComparison

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 DESCRIPTION

TODO: include more set modules.

TODO: compare complex elements.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<Test::Deep> 1.120

L<Set::Tiny> 0.04

=head1 BENCHMARK PARTICIPANTS

=over

=item * Test::Deep (perl_code)

Code template:

 state $set = Test::Deep::set(@{<set>}); Test::Deep::eq_deeply(<array>, $set)



=item * Set::Tiny (perl_code) [simple-elements]

Code template:

 state $set1 = Set::Tiny->new(@{<array>}); state $set2 = Set::Tiny->new(@{<set>}); $set1->symmetric_difference($set2)->size == 0 ? 1:0



=back

=head1 BENCHMARK DATASETS

=over

=item * elems=10num

=item * elems=100num

=item * elems=200num

=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.24.0 >>, CPU: I<< Intel(R) Core(TM) i5-2400 CPU @ 3.10GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default options (C<< bencher -m SetComparison >>):

 #table1#
 +-------------+--------------+-----------+-----------+------------+-----------+---------+
 | participant | dataset      | rate (/s) | time (ms) | vs_slowest |  errors   | samples |
 +-------------+--------------+-----------+-----------+------------+-----------+---------+
 | Test::Deep  | elems=200num |      4.09 | 244       |       1    |   0.00022 |      20 |
 | Test::Deep  | elems=100num |     16.1  |  62       |       3.94 | 5.2e-05   |      20 |
 | Test::Deep  | elems=10num  |   1400    |   0.69    |     350    | 6.9e-07   |      20 |
 | Set::Tiny   | elems=200num |  15000    |   0.069   |    3500    | 1.1e-07   |      20 |
 | Set::Tiny   | elems=100num |  28000    |   0.036   |    6800    | 2.3e-07   |      20 |
 | Set::Tiny   | elems=10num  | 182000    |   0.00551 |   44400    | 1.7e-09   |      20 |
 +-------------+--------------+-----------+-----------+------------+-----------+---------+


Benchmark module startup overhead (C<< bencher -m SetComparison --module-startup >>):

 #table2#
 +---------------------+-----------+------------------------+------------+---------+---------+
 | participant         | time (ms) | mod_overhead_time (ms) | vs_slowest |  errors | samples |
 +---------------------+-----------+------------------------+------------+---------+---------+
 | Test::Deep          |      24   |                   19   |        1   | 7.1e-05 |      20 |
 | Set::Tiny           |       7.2 |                    2.2 |        3.4 | 6.8e-05 |      21 |
 | perl -e1 (baseline) |       5   |                    0   |        5   | 8.1e-05 |      20 |
 +---------------------+-----------+------------------------+------------+---------+---------+

=head1 BENCHMARK NOTES

Test::Deep is slow :)

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenario-SetComparison>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenario-SetComparison>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenario-SetComparison>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 SEE ALSO

L<Bencher::Scenario::BagComparison>

L<Bencher::Scenario::SetOperationModules>

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
