package App::lcpan::Cmd::stats_last_index_time;

our $DATE = '2016-07-20'; # DATE
our $VERSION = '1.001'; # VERSION

use 5.010;
use strict;
use warnings;

require App::lcpan;

our %SPEC;

$SPEC{handle_cmd} = {
    v => 1.1,
    summary => 'Return last index time of mirror',
    description => <<'_',

This is mostly to support `App::lcpan::Call`. See also `stats` subcommand which
gives a more complete statistics, but can be much slower.

_
    args => {
        %App::lcpan::common_args,
    },
};
sub handle_cmd {
    my %args = @_;

    my $state = App::lcpan::_init(\%args, 'ro');
    my $dbh = $state->{dbh};

    my $stat = {};

    {
        my ($time) = $dbh->selectrow_array("SELECT value FROM meta WHERE name='last_index_time'");
        $stat->{raw_last_index_time} = $time;
        $stat->{last_index_time} = App::lcpan::_fmt_time($time);
    }

    [200, "OK", $stat];
}

1;
# ABSTRACT: Return last index time of mirror

__END__

=pod

=encoding UTF-8

=head1 NAME

App::lcpan::Cmd::stats_last_index_time - Return last index time of mirror

=head1 VERSION

This document describes version 1.001 of App::lcpan::Cmd::stats_last_index_time (from Perl distribution App-lcpan), released on 2016-07-20.

=head1 FUNCTIONS


=head2 handle_cmd(%args) -> [status, msg, result, meta]

Return last index time of mirror.

This is mostly to support C<App::lcpan::Call>. See also C<stats> subcommand which
gives a more complete statistics, but can be much slower.

This function is not exported.

Arguments ('*' denotes required arguments):

=over 4

=item * B<cpan> => I<dirname>

Location of your local CPAN mirror, e.g. /path/to/cpan.

Defaults to C<~/cpan>.

=item * B<index_name> => I<filename> (default: "index.db")

Filename of index.

=back

Returns an enveloped result (an array).

First element (status) is an integer containing HTTP status code
(200 means OK, 4xx caller error, 5xx function error). Second element
(msg) is a string containing error message, or 'OK' if status is
200. Third element (result) is optional, the actual result. Fourth
element (meta) is called result metadata and is optional, a hash
that contains extra information.

Return value:  (any)

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/App-lcpan>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-App-lcpan>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=App-lcpan>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
