package Acme::PERLANCAR::Test::FlipFlop;

our $DATE = '2016-01-17'; # DATE
our $DIST = 'Acme-PERLANCAR-Test-FlipFlop'; # DIST
our $VERSION = '0.001'; # VERSION

use 5.010001;
use strict 'vars', 'subs';
use warnings;

use Exporter qw(import);
our @EXPORT_OK = qw(one_in_odd die_in_odd);

sub _version_is_odd {
    my $v = version->parse(${__PACKAGE__."::VERSION"} // 0)->normal;
    $v =~ /\Av\d+\.(\d+)/ or die "Invalid normalized version '$v'";
    $1 % 2 ? 1:0;
}

sub one_in_odd {
    _version_is_odd() ? 1:2;
}

sub die_in_odd {
    die "Die-ing because we are in odd releases" if _version_is_odd();
}

1;
# ABSTRACT: Incompatibilities between releases

__END__

=pod

=encoding UTF-8

=head1 NAME

Acme::PERLANCAR::Test::FlipFlop - Incompatibilities between releases

=head1 VERSION

This document describes version 0.001 of Acme::PERLANCAR::Test::FlipFlop (from Perl distribution Acme-PERLANCAR-Test-FlipFlop), released on 2016-01-17.

=head1 DESCRIPTION

This distribution is created for testing. It has several functions which behave
differently between releases (I'll call versions X.Y where Y is an odd number as
odd releases and where Y is an even number as even releases.)

=head1 FUNCTIONS

=head2 one_in_odd() => int

Return odd number 1 in odd releases, and even number 2 in even releases.

=head2 die_in_odd()

Will die in odd releases, and do nothing in even releases.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Acme-PERLANCAR-Test-FlipFlop>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Acme-PERLANCAR-Test-FlipFlop>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Acme-PERLANCAR-Test-FlipFlop>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
