package Acme::CPANAuthors::CPAN::Streaks::MonthlyReleases::Current;

use strict;
use warnings;

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2024-02-01'; # DATE
our $DIST = 'Acme-CPANAuthorsBundle-CPAN-Streaks'; # DIST
our $VERSION = '20240201.0'; # VERSION

use Acme::CPANAuthors::Register (
    'BINGOS' => '',
    'ETHER' => '',
    'LEEJO' => '',
    'PERLANCAR' => '',
    'PEVANS' => '',
    'UTASHIRO' => '',
    'OALDERS' => '',
    'KIMOTO' => '',
    'OLIVER' => '',
    'SKIM' => '',
    'DERF' => '',
    'JDEGUEST' => '',
    'BDFOY' => '',
    'HMBRAND' => '',
    'JIMAVERA' => '',
    'ASPOSE' => '',
    'DJERIUS' => '',
    'DDUMONT' => '',
    'DRCLAW' => '',
    'JV' => '',
    'VVELOX' => '',
    'AJNN' => '',
    'DCANTRELL' => '',
    'ABALAMA' => '',
    'SHLOMIF' => '',
    'BLIAKO' => '',
    'CUKEBOT' => '',
    'DROLSKY' => '',
    'NLNETLABS' => '',
    'TEAM' => '',
    'WYANT' => '',
    'YANICK' => '',
    'BPS' => '',
    'DART' => '',
    'PJACKLAM' => '',
    'RKAPL' => '',
    'GENE' => '',
    'GSG' => '',
    'JGNI' => '',
    'JMATES' => '',
    'JRM' => '',
    'OETIKER' => '',
    'RKELSCH' => '',
    'RRWO' => '',
    'SREZIC' => '',
    'CGPAN' => '',
    'DAMI' => '',
    'DERIV' => '',
    'DORNER' => '',
    'ISHIGAKI' => '',
    'MIKKOI' => '',
    'RJBS' => '',
    'SHOGO' => '',
    'TONYC' => '',
    'VOEGELAS' => '',
    'AAHAZRED' => '',
    'ABH' => '',
    'AJM' => '',
    'AVERKIOS' => '',
    'BLAINEM' => '',
    'BWEST' => '',
    'CRLCU' => '',
    'DAVECROSS' => '',
    'GARU' => '',
    'GUILLEM' => '',
    'INGY' => '',
    'KUERBIS' => '',
    'MATHIAS' => '',
    'PACMAN' => '',
    'RJET' => '',
    'SBECK' => '',
    'SKAJI' => '',
    'VEESH' => '',
    'VKON' => '',
    'YOUPONG' => '',
    'ABELTJE' => '',
    'ANELSON' => '',
    'APPEL' => '',
    'ARIDEV' => '',
    'ARISTOTLE' => '',
    'ASLEWIS' => '',
    'ATRODO' => '',
    'BAKERSCOT' => '',
    'BIGFOOT' => '',
    'BIGPRESH' => '',
    'BKB' => '',
    'CHEVALIER' => '',
    'CHRISN' => '',
    'CHROMATIC' => '',
    'CMANLEY' => '',
    'CORION' => '',
    'CORLISS' => '',
    'DANBERR' => '',
    'DDICK' => '',
    'DEXTER' => '',
    'DMANTO' => '',
    'DOMM' => '',
    'DORIAN' => '',
    'DSKOLL' => '',
    'ELCAMLOST' => '',
    'ETJ' => '',
    'EXIFTOOL' => '',
    'EZIMUEL' => '',
    'FDULAU' => '',
    'FKENTO' => '',
    'FREDERICD' => '',
    'FSEITZ' => '',
    'GHE' => '',
    'GLLORE' => '',
    'GNUSTAVO' => '',
    'GRAY' => '',
    'GRECHARY' => '',
    'HOCHSTEN' => '',
    'IKEGAMI' => '',
    'IPENBURG' => '',
    'JEFFA' => '',
    'JETM' => '',
    'JJNAPIORK' => '',
    'JKG' => '',
    'JOHNH' => '',
    'JROBINSON' => '',
    'JUERD' => '',
    'KARASIK' => '',
    'KAZEBURO' => '',
    'KJETILK' => '',
    'LEONT' => '',
    'LION' => '',
    'LNATION' => '',
    'LOCATION' => '',
    'LSKATZ' => '',
    'MANWAR' => '',
    'MAREKR' => '',
    'MBRADSHAW' => '',
    'MIKEVNTNR' => '',
    'MIYAGAWA' => '',
    'MMCCLENN' => '',
    'MRSCOTTY' => '',
    'MSCHOUT' => '',
    'MSIMERSON' => '',
    'MSLM' => '',
    'NHORNE' => '',
    'NJFRANCK' => '',
    'NUDDLEGG' => '',
    'OLEG' => '',
    'PMORCH' => '',
    'POWERMAN' => '',
    'RADIATOR' => '',
    'RHANDOM' => '',
    'RWSTAUNER' => '',
    'SALVA' => '',
    'SANKO' => '',
    'SBAKKER' => '',
    'SCHROEDER' => '',
    'SFOBERSKI' => '',
    'SHE' => '',
    'SISYPHUS' => '',
    'SORTIZ' => '',
    'SUKRIA' => '',
    'SULLR' => '',
    'SYBER' => '',
    'TIMLEGGE' => '',
    'TINITA' => '',
    'TOKUHIROM' => '',
    'TORBIAK' => '',
    'TRIZEN' => '',
    'TURNERJW' => '',
    'VOLKENING' => '',
    'WESM' => '',
    'WSNYDER' => '',
    'XMOLEX' => '',
    'TANIGUCHI' => '',
);


1;
# ABSTRACT: Authors with ongoing month releases streak (do a release every month)

__END__

=pod

=encoding UTF-8

=head1 NAME

Acme::CPANAuthors::CPAN::Streaks::MonthlyReleases::Current - Authors with ongoing month releases streak (do a release every month)

=head1 VERSION

This document describes version 20240201.0 of Acme::CPANAuthors::CPAN::Streaks::MonthlyReleases::Current (from Perl distribution Acme-CPANAuthorsBundle-CPAN-Streaks), released on 2024-02-01.

=head1 SYNOPSIS

=head1 DESCRIPTION

Current standings (as of 2024-02-01, produced by L<cpan-streaks>):

  +-----------+-----+------------+-------------+
  | author    | len | start_date | status      |
  +-----------+-----+------------+-------------+
  | BINGOS    | 215 | 2006-03    | might-break |
  | ETHER     | 143 | 2012-03    | might-break |
  | LEEJO     | 118 | 2014-04    | might-break |
  | PERLANCAR | 115 | 2014-08    | ongoing     |
  | PEVANS    |  68 | 2018-06    | might-break |
  | UTASHIRO  |  68 | 2018-06    | might-break |
  | OALDERS   |  54 | 2019-08    | might-break |
  | KIMOTO    |  26 | 2021-12    | might-break |
  | OLIVER    |  24 | 2022-02    | might-break |
  | SKIM      |  22 | 2022-04    | might-break |
  | DERF      |  20 | 2022-06    | might-break |
  | JDEGUEST  |  20 | 2022-06    | might-break |
  | BDFOY     |  13 | 2023-01    | might-break |
  | HMBRAND   |  13 | 2023-01    | might-break |
  | JIMAVERA  |  13 | 2023-01    | might-break |
  | ASPOSE    |  12 | 2023-02    | might-break |
  | DJERIUS   |  11 | 2023-03    | might-break |
  | DDUMONT   |   9 | 2023-05    | might-break |
  | DRCLAW    |   9 | 2023-05    | might-break |
  | JV        |   9 | 2023-05    | might-break |
  | VVELOX    |   9 | 2023-05    | might-break |
  | AJNN      |   8 | 2023-06    | might-break |
  | DCANTRELL |   8 | 2023-06    | might-break |
  | ABALAMA   |   7 | 2023-07    | might-break |
  | SHLOMIF   |   7 | 2023-07    | might-break |
  | BLIAKO    |   6 | 2023-08    | might-break |
  | CUKEBOT   |   6 | 2023-08    | might-break |
  | DROLSKY   |   6 | 2023-08    | might-break |
  | NLNETLABS |   6 | 2023-08    | might-break |
  | TEAM      |   6 | 2023-08    | might-break |
  | WYANT     |   6 | 2023-08    | might-break |
  | YANICK    |   6 | 2023-08    | might-break |
  | BPS       |   5 | 2023-09    | might-break |
  | DART      |   5 | 2023-09    | might-break |
  | PJACKLAM  |   5 | 2023-09    | might-break |
  | RKAPL     |   5 | 2023-09    | might-break |
  | GENE      |   4 | 2023-10    | might-break |
  | GSG       |   4 | 2023-10    | might-break |
  | JGNI      |   4 | 2023-10    | might-break |
  | JMATES    |   4 | 2023-10    | might-break |
  | JRM       |   4 | 2023-10    | might-break |
  | OETIKER   |   4 | 2023-10    | might-break |
  | RKELSCH   |   4 | 2023-10    | might-break |
  | RRWO      |   4 | 2023-10    | might-break |
  | SREZIC    |   4 | 2023-10    | might-break |
  | CGPAN     |   3 | 2023-11    | might-break |
  | DAMI      |   3 | 2023-11    | might-break |
  | DERIV     |   3 | 2023-11    | might-break |
  | DORNER    |   3 | 2023-11    | might-break |
  | ISHIGAKI  |   3 | 2023-11    | might-break |
  | MIKKOI    |   3 | 2023-11    | might-break |
  | RJBS      |   3 | 2023-11    | might-break |
  | SHOGO     |   3 | 2023-11    | might-break |
  | TONYC     |   3 | 2023-11    | might-break |
  | VOEGELAS  |   3 | 2023-11    | might-break |
  | AAHAZRED  |   2 | 2023-12    | might-break |
  | ABH       |   2 | 2023-12    | might-break |
  | AJM       |   2 | 2023-12    | might-break |
  | AVERKIOS  |   2 | 2023-12    | might-break |
  | BLAINEM   |   2 | 2023-12    | might-break |
  | BWEST     |   2 | 2023-12    | might-break |
  | CRLCU     |   2 | 2023-12    | might-break |
  | DAVECROSS |   2 | 2023-12    | might-break |
  | GARU      |   2 | 2023-12    | might-break |
  | GUILLEM   |   2 | 2023-12    | might-break |
  | INGY      |   2 | 2023-12    | might-break |
  | KUERBIS   |   2 | 2023-12    | might-break |
  | MATHIAS   |   2 | 2023-12    | might-break |
  | PACMAN    |   2 | 2023-12    | might-break |
  | RJET      |   2 | 2023-12    | might-break |
  | SBECK     |   2 | 2023-12    | might-break |
  | SKAJI     |   2 | 2023-12    | might-break |
  | VEESH     |   2 | 2023-12    | might-break |
  | VKON      |   2 | 2023-12    | might-break |
  | YOUPONG   |   2 | 2023-12    | might-break |
  | ABELTJE   |   1 | 2024-01    | might-break |
  | ANELSON   |   1 | 2024-01    | might-break |
  | APPEL     |   1 | 2024-01    | might-break |
  | ARIDEV    |   1 | 2024-01    | might-break |
  | ARISTOTLE |   1 | 2024-01    | might-break |
  | ASLEWIS   |   1 | 2024-01    | might-break |
  | ATRODO    |   1 | 2024-01    | might-break |
  | BAKERSCOT |   1 | 2024-01    | might-break |
  | BIGFOOT   |   1 | 2024-01    | might-break |
  | BIGPRESH  |   1 | 2024-01    | might-break |
  | BKB       |   1 | 2024-01    | might-break |
  | CHEVALIER |   1 | 2024-01    | might-break |
  | CHRISN    |   1 | 2024-01    | might-break |
  | CHROMATIC |   1 | 2024-01    | might-break |
  | CMANLEY   |   1 | 2024-01    | might-break |
  | CORION    |   1 | 2024-01    | might-break |
  | CORLISS   |   1 | 2024-01    | might-break |
  | DANBERR   |   1 | 2024-01    | might-break |
  | DDICK     |   1 | 2024-01    | might-break |
  | DEXTER    |   1 | 2024-01    | might-break |
  | DMANTO    |   1 | 2024-01    | might-break |
  | DOMM      |   1 | 2024-01    | might-break |
  | DORIAN    |   1 | 2024-01    | might-break |
  | DSKOLL    |   1 | 2024-01    | might-break |
  | ELCAMLOST |   1 | 2024-01    | might-break |
  | ETJ       |   1 | 2024-01    | might-break |
  | EXIFTOOL  |   1 | 2024-01    | might-break |
  | EZIMUEL   |   1 | 2024-01    | might-break |
  | FDULAU    |   1 | 2024-01    | might-break |
  | FKENTO    |   1 | 2024-01    | might-break |
  | FREDERICD |   1 | 2024-01    | might-break |
  | FSEITZ    |   1 | 2024-01    | might-break |
  | GHE       |   1 | 2024-01    | might-break |
  | GLLORE    |   1 | 2024-01    | might-break |
  | GNUSTAVO  |   1 | 2024-01    | might-break |
  | GRAY      |   1 | 2024-01    | might-break |
  | GRECHARY  |   1 | 2024-01    | might-break |
  | HOCHSTEN  |   1 | 2024-01    | might-break |
  | IKEGAMI   |   1 | 2024-01    | might-break |
  | IPENBURG  |   1 | 2024-01    | might-break |
  | JEFFA     |   1 | 2024-01    | might-break |
  | JETM      |   1 | 2024-01    | might-break |
  | JJNAPIORK |   1 | 2024-01    | might-break |
  | JKG       |   1 | 2024-01    | might-break |
  | JOHNH     |   1 | 2024-01    | might-break |
  | JROBINSON |   1 | 2024-01    | might-break |
  | JUERD     |   1 | 2024-01    | might-break |
  | KARASIK   |   1 | 2024-01    | might-break |
  | KAZEBURO  |   1 | 2024-01    | might-break |
  | KJETILK   |   1 | 2024-01    | might-break |
  | LEONT     |   1 | 2024-01    | might-break |
  | LION      |   1 | 2024-01    | might-break |
  | LNATION   |   1 | 2024-01    | might-break |
  | LOCATION  |   1 | 2024-01    | might-break |
  | LSKATZ    |   1 | 2024-01    | might-break |
  | MANWAR    |   1 | 2024-01    | might-break |
  | MAREKR    |   1 | 2024-01    | might-break |
  | MBRADSHAW |   1 | 2024-01    | might-break |
  | MIKEVNTNR |   1 | 2024-01    | might-break |
  | MIYAGAWA  |   1 | 2024-01    | might-break |
  | MMCCLENN  |   1 | 2024-01    | might-break |
  | MRSCOTTY  |   1 | 2024-01    | might-break |
  | MSCHOUT   |   1 | 2024-01    | might-break |
  | MSIMERSON |   1 | 2024-01    | might-break |
  | MSLM      |   1 | 2024-01    | might-break |
  | NHORNE    |   1 | 2024-01    | might-break |
  | NJFRANCK  |   1 | 2024-01    | might-break |
  | NUDDLEGG  |   1 | 2024-01    | might-break |
  | OLEG      |   1 | 2024-01    | might-break |
  | PMORCH    |   1 | 2024-01    | might-break |
  | POWERMAN  |   1 | 2024-01    | might-break |
  | RADIATOR  |   1 | 2024-01    | might-break |
  | RHANDOM   |   1 | 2024-01    | might-break |
  | RWSTAUNER |   1 | 2024-01    | might-break |
  | SALVA     |   1 | 2024-01    | might-break |
  | SANKO     |   1 | 2024-01    | might-break |
  | SBAKKER   |   1 | 2024-01    | might-break |
  | SCHROEDER |   1 | 2024-01    | might-break |
  | SFOBERSKI |   1 | 2024-01    | might-break |
  | SHE       |   1 | 2024-01    | might-break |
  | SISYPHUS  |   1 | 2024-01    | might-break |
  | SORTIZ    |   1 | 2024-01    | might-break |
  | SUKRIA    |   1 | 2024-01    | might-break |
  | SULLR     |   1 | 2024-01    | might-break |
  | SYBER     |   1 | 2024-01    | might-break |
  | TIMLEGGE  |   1 | 2024-01    | might-break |
  | TINITA    |   1 | 2024-01    | might-break |
  | TOKUHIROM |   1 | 2024-01    | might-break |
  | TORBIAK   |   1 | 2024-01    | might-break |
  | TRIZEN    |   1 | 2024-01    | might-break |
  | TURNERJW  |   1 | 2024-01    | might-break |
  | VOLKENING |   1 | 2024-01    | might-break |
  | WESM      |   1 | 2024-01    | might-break |
  | WSNYDER   |   1 | 2024-01    | might-break |
  | XMOLEX    |   1 | 2024-01    | might-break |
  | TANIGUCHI |   1 | 2024-02    | ongoing     |
  +-----------+-----+------------+-------------+

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Acme-CPANAuthorsBundle-CPAN-Streaks>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Acme-CPANAuthorsBundle-CPAN-Streaks>.

=head1 SEE ALSO

L<Acme::CPANAuthors>

CPAN Regulars Boards, L<http://cpan.io/board/once-a/>, which as of this writing,
has some input data missing and thus produces some incorrect results.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 CONTRIBUTING


To contribute, you can send patches by email/via RT, or send pull requests on
GitHub.

Most of the time, you don't need to build the distribution yourself. You can
simply modify the code, then test via:

 % prove -l

If you want to build the distribution (e.g. to try to install it locally on your
system), you can install L<Dist::Zilla>,
L<Dist::Zilla::PluginBundle::Author::PERLANCAR>,
L<Pod::Weaver::PluginBundle::Author::PERLANCAR>, and sometimes one or two other
Dist::Zilla- and/or Pod::Weaver plugins. Any additional steps required beyond
that are considered a bug and can be reported to me.

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2024, 2023 by perlancar <perlancar@cpan.org>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Acme-CPANAuthorsBundle-CPAN-Streaks>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=cut
