package Acme::CPANAuthors::CPAN::Streaks::MonthlyReleases::AllTime;

use strict;
use warnings;

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2024-02-01'; # DATE
our $DIST = 'Acme-CPANAuthorsBundle-CPAN-Streaks'; # DIST
our $VERSION = '20240201.0'; # VERSION

use Acme::CPANAuthors::Register (
    'DROLSKY' => '',
    'BINGOS' => '',
    'RJBS' => '',
    'ETHER' => '',
    'PEVANS' => '',
    'PLICEASE' => '',
    'LEEJO' => '',
    'PERLANCAR' => '',
    'IVANWILLS' => '',
    'LEONT' => '',
    'ADAMK' => '',
    'DAGOLDEN' => '',
    'WYANT' => '',
    'BOOK' => '',
    'KRYDE' => '',
    'TOKUHIROM' => '',
    'JHTHORSEN' => '',
    'CSSON' => '',
    'UTASHIRO' => '',
    'JKEGL' => '',
    'SRI' => '',
    'MANWAR' => '',
    'MARKOV' => '',
    'AUTRIJUS' => '',
    'PETDANCE' => '',
    'SHARYANTO' => '',
    'KENTNL' => '',
    'FELIPE' => '',
    'MGV' => '',
    'OALDERS' => '',
    'KWILLIAMS' => '',
    'SALVA' => '',
    'CJM' => '',
    'SMUELLER' => '',
    'FREW' => '',
    'YANICK' => '',
    'GFUJI' => '',
    'DOY' => '',
    'RCLAMP' => '',
    'MLEHMANN' => '',
    'SCHUBIGER' => '',
    'AMBS' => '',
    'FAYLAND' => '',
    'FLORA' => '',
    'AVENJ' => '',
    'EXODIST' => '',
    'KARMAN' => '',
    'XSAWYERX' => '',
    'BARBIE' => '',
    'DDUMONT' => '',
    'LDS' => '',
    'MSERGEANT' => '',
    'LEOCHARRE' => '',
    'SHLOMIF' => '',
    'PJFL' => '',
    'OETIKER' => '',
    'TOBYINK' => '',
    'BINARY' => '',
    'PRBRENAN' => '',
    'SARTAK' => '',
    'HDIAS' => '',
    'VPIT' => '',
    'TANIGUCHI' => '',
    'KAZEBURO' => '',
    'JJNAPIORK' => '',
    'MIYAGAWA' => '',
    'KIMOTO' => '',
    'DMAKI' => '',
    'REEDFISH' => '',
    'NEILB' => '',
    'ZDM' => '',
    'GENE' => '',
    'DUNCAND' => '',
    'NUFFIN' => '',
    'BOBTFISH' => '',
    'NHORNE' => '',
    'MOZNION' => '',
    'CORION' => '',
    'MTHURN' => '',
    'MSCHILLI' => '',
    'JESSE' => '',
    'ISHIGAKI' => '',
    'GPHAT' => '',
    'XAICRON' => '',
    'OLIVER' => '',
    'JOHND' => '',
    'ETJ' => '',
    'JWIED' => '',
    'BOSU' => '',
    'JBERGER' => '',
    'RURBAN' => '',
    'DBOOK' => '',
    'CLKAO' => '',
    'WSNYDER' => '',
    'DWHEELER' => '',
    'HAARG' => '',
    'KUERBIS' => '',
    'SJDY' => '',
    'GUGOD' => '',
    'SPROUT' => '',
    'SAXJAZMAN' => '',
    'VANSTYN' => '',
    'JMATES' => '',
    'STEVEB' => '',
    'ILYAZ' => '',
    'TJMATHER' => '',
    'AUDREYT' => '',
    'HORNBURG' => '',
    'PREACTION' => '',
    'RBOW' => '',
    'TEAM' => '',
    'DOUGM' => '',
    'LBROCARD' => '',
    'JSIRACUSA' => '',
    'ANDK' => '',
    'BTMCINNES' => '',
    'SULLR' => '',
    'BLHOTSKY' => '',
    'FSEITZ' => '',
    'MRAMBERG' => '',
    'HINRIK' => '',
    'BDFOY' => '',
    'NLNETLABS' => '',
    'MSCHWERN' => '',
    'JDHEDDEN' => '',
    'STEVAN' => '',
    'GAAS' => '',
    'JQUELIN' => '',
    'ALEXBIO' => '',
    'TSIBLEY' => '',
    'ABBYPAN' => '',
    'SONGMU' => '',
    'ZMUGHAL' => '',
    'MONGODB' => '',
    'BKB' => '',
    'TRIZEN' => '',
    'HOCHSTEN' => '',
    'RRWO' => '',
    'SKIM' => '',
    'DMOW' => '',
    'ZAG' => '',
    'RKITOVER' => '',
    'NEKOKAK' => '',
    'AUBERTG' => '',
    'PHRED' => '',
    'MELMOTHX' => '',
    'IRONCAMEL' => '',
    'JV' => '',
    'TINITA' => '',
    'TELS' => '',
    'JHI' => '',
    'RCAPUTO' => '',
    'BRICAS' => '',
    'POTYL' => '',
    'COSIMO' => '',
    'ANAZAWA' => '',
    'DAVIDO' => '',
    'HMBRAND' => '',
    'BEROV' => '',
    'MAXMIND' => '',
    'SREZIC' => '',
    'MBRADSHAW' => '',
    'DERF' => '',
    'JDEGUEST' => '',
);


1;
# ABSTRACT: Authors with all-time monthly releases streak (do a release every month)

__END__

=pod

=encoding UTF-8

=head1 NAME

Acme::CPANAuthors::CPAN::Streaks::MonthlyReleases::AllTime - Authors with all-time monthly releases streak (do a release every month)

=head1 VERSION

This document describes version 20240201.0 of Acme::CPANAuthors::CPAN::Streaks::MonthlyReleases::AllTime (from Perl distribution Acme-CPANAuthorsBundle-CPAN-Streaks), released on 2024-02-01.

=head1 SYNOPSIS

=head1 DESCRIPTION

Current standings (as of 2024-02-01, produced by L<cpan-streaks>, only streaks with length of at least 20 are included):

  +-----------+-----+------------+----------+-------------+
  | author    | len | start_date | end_date | status      |
  +-----------+-----+------------+----------+-------------+
  | DROLSKY   | 245 | 2001-01    | 2021-05  | broken      |
  | BINGOS    | 215 | 2006-03    |          | might-break |
  | RJBS      | 146 | 2003-12    | 2016-01  | broken      |
  | ETHER     | 143 | 2012-03    |          | might-break |
  | PEVANS    | 142 | 2006-07    | 2018-04  | broken      |
  | PLICEASE  | 133 | 2012-08    | 2023-08  | broken      |
  | LEEJO     | 118 | 2014-04    |          | might-break |
  | PERLANCAR | 115 | 2014-08    |          | ongoing     |
  | IVANWILLS | 114 | 2014-05    | 2023-10  | broken      |
  | LEONT     | 112 | 2009-10    | 2019-01  | broken      |
  | ADAMK     | 108 | 2003-04    | 2012-03  | broken      |
  | DAGOLDEN  | 107 | 2008-09    | 2017-07  | broken      |
  | WYANT     | 104 | 2013-04    | 2021-11  | broken      |
  | BOOK      |  95 | 2012-03    | 2020-01  | broken      |
  | KRYDE     |  87 | 2008-04    | 2015-06  | broken      |
  | TOKUHIROM |  87 | 2009-02    | 2016-04  | broken      |
  | JHTHORSEN |  87 | 2013-04    | 2020-06  | broken      |
  | CSSON     |  73 | 2016-01    | 2022-01  | broken      |
  | PEVANS    |  68 | 2018-06    |          | might-break |
  | UTASHIRO  |  68 | 2018-06    |          | might-break |
  | JKEGL     |  66 | 2009-06    | 2014-11  | broken      |
  | SRI       |  66 | 2016-01    | 2021-06  | broken      |
  | MANWAR    |  65 | 2014-07    | 2019-11  | broken      |
  | MARKOV    |  63 | 2006-07    | 2011-09  | broken      |
  | AUTRIJUS  |  62 | 2001-06    | 2006-07  | broken      |
  | PETDANCE  |  61 | 2002-01    | 2007-01  | broken      |
  | SHARYANTO |  60 | 2009-10    | 2014-09  | broken      |
  | KENTNL    |  55 | 2012-10    | 2017-04  | broken      |
  | FELIPE    |  55 | 2017-07    | 2022-01  | broken      |
  | MGV       |  54 | 2014-01    | 2018-06  | broken      |
  | OALDERS   |  54 | 2019-08    |          | might-break |
  | KWILLIAMS |  53 | 2002-01    | 2006-05  | broken      |
  | SALVA     |  52 | 2008-04    | 2012-07  | broken      |
  | CJM       |  52 | 2011-10    | 2016-01  | broken      |
  | SMUELLER  |  51 | 2005-07    | 2009-09  | broken      |
  | FREW      |  50 | 2011-11    | 2015-12  | broken      |
  | YANICK    |  49 | 2012-09    | 2016-09  | broken      |
  | GFUJI     |  48 | 2008-01    | 2011-12  | broken      |
  | SRI       |  48 | 2011-07    | 2015-06  | broken      |
  | DOY       |  46 | 2009-04    | 2013-01  | broken      |
  | RCLAMP    |  44 | 2001-11    | 2005-06  | broken      |
  | MLEHMANN  |  44 | 2006-06    | 2010-01  | broken      |
  | SCHUBIGER |  44 | 2009-06    | 2013-01  | broken      |
  | AMBS      |  44 | 2010-02    | 2013-09  | broken      |
  | FAYLAND   |  43 | 2008-04    | 2011-10  | broken      |
  | FLORA     |  43 | 2008-05    | 2011-11  | broken      |
  | FAYLAND   |  43 | 2012-09    | 2016-03  | broken      |
  | AVENJ     |  43 | 2013-01    | 2016-07  | broken      |
  | EXODIST   |  43 | 2018-10    | 2022-04  | broken      |
  | KARMAN    |  42 | 2007-09    | 2011-02  | broken      |
  | XSAWYERX  |  42 | 2009-12    | 2013-05  | broken      |
  | BARBIE    |  42 | 2011-12    | 2015-05  | broken      |
  | EXODIST   |  42 | 2015-03    | 2018-08  | broken      |
  | OALDERS   |  41 | 2014-05    | 2017-09  | broken      |
  | DDUMONT   |  41 | 2015-09    | 2019-01  | broken      |
  | LDS       |  40 | 1999-11    | 2003-02  | broken      |
  | MSERGEANT |  40 | 2000-01    | 2003-04  | broken      |
  | LEOCHARRE |  40 | 2007-02    | 2010-05  | broken      |
  | SHLOMIF   |  40 | 2007-10    | 2011-01  | broken      |
  | PJFL      |  40 | 2014-04    | 2017-07  | broken      |
  | SHLOMIF   |  40 | 2017-08    | 2020-11  | broken      |
  | OETIKER   |  40 | 2019-02    | 2022-05  | broken      |
  | TOBYINK   |  39 | 2011-09    | 2014-11  | broken      |
  | BINARY    |  39 | 2014-05    | 2017-07  | broken      |
  | PRBRENAN  |  39 | 2016-12    | 2020-02  | broken      |
  | SARTAK    |  38 | 2007-07    | 2010-08  | broken      |
  | SHLOMIF   |  38 | 2011-04    | 2014-05  | broken      |
  | HDIAS     |  37 | 2001-12    | 2004-12  | broken      |
  | VPIT      |  37 | 2008-02    | 2011-02  | broken      |
  | SMUELLER  |  37 | 2010-06    | 2013-06  | broken      |
  | TANIGUCHI |  37 | 2011-06    | 2014-06  | broken      |
  | KAZEBURO  |  37 | 2012-01    | 2015-01  | broken      |
  | JJNAPIORK |  37 | 2013-04    | 2016-04  | broken      |
  | MARKOV    |  36 | 2001-06    | 2004-05  | broken      |
  | MIYAGAWA  |  36 | 2004-07    | 2007-06  | broken      |
  | MIYAGAWA  |  36 | 2008-08    | 2011-07  | broken      |
  | KIMOTO    |  36 | 2008-12    | 2011-11  | broken      |
  | DMAKI     |  36 | 2009-07    | 2012-06  | broken      |
  | REEDFISH  |  36 | 2014-05    | 2017-04  | broken      |
  | SHLOMIF   |  35 | 2014-08    | 2017-06  | broken      |
  | NEILB     |  34 | 2013-07    | 2016-04  | broken      |
  | ZDM       |  33 | 2016-11    | 2019-07  | broken      |
  | GENE      |  33 | 2018-09    | 2021-05  | broken      |
  | DUNCAND   |  32 | 2007-06    | 2010-01  | broken      |
  | NUFFIN    |  32 | 2007-12    | 2010-07  | broken      |
  | BOBTFISH  |  32 | 2008-09    | 2011-04  | broken      |
  | NHORNE    |  32 | 2010-11    | 2013-06  | broken      |
  | MARKOV    |  32 | 2011-11    | 2014-06  | broken      |
  | MOZNION   |  32 | 2012-10    | 2015-05  | broken      |
  | CORION    |  32 | 2017-11    | 2020-06  | broken      |
  | JHTHORSEN |  32 | 2020-08    | 2023-03  | broken      |
  | MTHURN    |  31 | 2000-09    | 2003-03  | broken      |
  | MSCHILLI  |  31 | 2002-11    | 2005-05  | broken      |
  | JESSE     |  31 | 2004-05    | 2006-11  | broken      |
  | ISHIGAKI  |  31 | 2007-10    | 2010-04  | broken      |
  | GPHAT     |  31 | 2008-02    | 2010-08  | broken      |
  | XAICRON   |  31 | 2010-02    | 2012-08  | broken      |
  | OLIVER    |  31 | 2013-12    | 2016-06  | broken      |
  | TANIGUCHI |  31 | 2014-08    | 2017-02  | broken      |
  | DMAKI     |  30 | 2006-12    | 2009-05  | broken      |
  | JOHND     |  30 | 2009-10    | 2012-03  | broken      |
  | YANICK    |  30 | 2010-02    | 2012-07  | broken      |
  | JJNAPIORK |  30 | 2010-06    | 2012-11  | broken      |
  | ETJ       |  30 | 2020-05    | 2022-10  | broken      |
  | JWIED     |  29 | 1997-08    | 1999-12  | broken      |
  | DAGOLDEN  |  29 | 2004-12    | 2007-04  | broken      |
  | BOSU      |  29 | 2005-10    | 2008-02  | broken      |
  | JBERGER   |  29 | 2011-04    | 2013-08  | broken      |
  | RURBAN    |  29 | 2012-10    | 2015-02  | broken      |
  | RURBAN    |  29 | 2015-04    | 2017-08  | broken      |
  | DBOOK     |  29 | 2018-06    | 2020-10  | broken      |
  | CLKAO     |  28 | 2003-07    | 2005-10  | broken      |
  | WSNYDER   |  28 | 2004-07    | 2006-10  | broken      |
  | WSNYDER   |  28 | 2007-04    | 2009-07  | broken      |
  | DWHEELER  |  28 | 2009-08    | 2011-11  | broken      |
  | LDS       |  28 | 2009-11    | 2012-02  | broken      |
  | HAARG     |  28 | 2013-09    | 2015-12  | broken      |
  | KUERBIS   |  28 | 2013-12    | 2016-03  | broken      |
  | ISHIGAKI  |  28 | 2014-01    | 2016-04  | broken      |
  | SJDY      |  28 | 2014-11    | 2017-02  | broken      |
  | KIMOTO    |  28 | 2017-03    | 2019-06  | broken      |
  | GUGOD     |  27 | 2004-02    | 2006-04  | broken      |
  | SPROUT    |  27 | 2009-01    | 2011-03  | broken      |
  | SAXJAZMAN |  27 | 2011-03    | 2013-05  | broken      |
  | BOBTFISH  |  27 | 2011-06    | 2013-08  | broken      |
  | VANSTYN   |  27 | 2013-06    | 2015-08  | broken      |
  | JMATES    |  27 | 2013-12    | 2016-02  | broken      |
  | STEVEB    |  27 | 2015-06    | 2017-08  | broken      |
  | ILYAZ     |  26 | 1997-05    | 1999-06  | broken      |
  | TJMATHER  |  26 | 2000-12    | 2003-01  | broken      |
  | AUDREYT   |  26 | 2006-07    | 2008-08  | broken      |
  | HORNBURG  |  26 | 2014-07    | 2016-08  | broken      |
  | PREACTION |  26 | 2018-07    | 2020-08  | broken      |
  | KIMOTO    |  26 | 2021-12    |          | might-break |
  | RBOW      |  25 | 2000-06    | 2002-06  | broken      |
  | FREW      |  25 | 2009-09    | 2011-09  | broken      |
  | PJFL      |  25 | 2012-02    | 2014-02  | broken      |
  | YANICK    |  25 | 2017-01    | 2019-01  | broken      |
  | GUGOD     |  25 | 2018-10    | 2020-10  | broken      |
  | TEAM      |  25 | 2020-03    | 2022-03  | broken      |
  | DOUGM     |  24 | 1996-05    | 1998-04  | broken      |
  | LBROCARD  |  24 | 2002-12    | 2004-11  | broken      |
  | JSIRACUSA |  24 | 2005-03    | 2007-02  | broken      |
  | ANDK      |  24 | 2006-07    | 2008-06  | broken      |
  | BTMCINNES |  24 | 2009-10    | 2011-09  | broken      |
  | SULLR     |  24 | 2012-08    | 2014-07  | broken      |
  | BLHOTSKY  |  24 | 2013-04    | 2015-03  | broken      |
  | FSEITZ    |  24 | 2019-01    | 2020-12  | broken      |
  | OLIVER    |  24 | 2022-02    |          | might-break |
  | BOOK      |  23 | 2005-01    | 2006-11  | broken      |
  | MRAMBERG  |  23 | 2005-03    | 2007-01  | broken      |
  | DDUMONT   |  23 | 2007-09    | 2009-07  | broken      |
  | HINRIK    |  23 | 2009-02    | 2010-12  | broken      |
  | BARBIE    |  23 | 2009-10    | 2011-08  | broken      |
  | KARMAN    |  23 | 2011-05    | 2013-03  | broken      |
  | MIYAGAWA  |  23 | 2012-02    | 2013-12  | broken      |
  | DBOOK     |  23 | 2014-11    | 2016-09  | broken      |
  | BDFOY     |  23 | 2015-06    | 2017-04  | broken      |
  | PREACTION |  23 | 2016-07    | 2018-05  | broken      |
  | NLNETLABS |  23 | 2016-11    | 2018-09  | broken      |
  | ANDK      |  22 | 1996-05    | 1998-02  | broken      |
  | MSCHWERN  |  22 | 2000-11    | 2002-08  | broken      |
  | MTHURN    |  22 | 2003-06    | 2005-03  | broken      |
  | JDHEDDEN  |  22 | 2005-06    | 2007-03  | broken      |
  | STEVAN    |  22 | 2007-02    | 2008-11  | broken      |
  | BOSU      |  22 | 2008-04    | 2010-01  | broken      |
  | GAAS      |  22 | 2008-04    | 2010-01  | broken      |
  | JQUELIN   |  22 | 2009-01    | 2010-10  | broken      |
  | GPHAT     |  22 | 2010-10    | 2012-07  | broken      |
  | SARTAK    |  22 | 2010-10    | 2012-07  | broken      |
  | ALEXBIO   |  22 | 2011-08    | 2013-05  | broken      |
  | TSIBLEY   |  22 | 2011-12    | 2013-09  | broken      |
  | DMAKI     |  22 | 2012-10    | 2014-07  | broken      |
  | ABBYPAN   |  22 | 2012-12    | 2014-09  | broken      |
  | SONGMU    |  22 | 2012-12    | 2014-09  | broken      |
  | ZMUGHAL   |  22 | 2013-11    | 2015-08  | broken      |
  | MONGODB   |  22 | 2014-04    | 2016-01  | broken      |
  | MIYAGAWA  |  22 | 2014-08    | 2016-05  | broken      |
  | BKB       |  22 | 2015-07    | 2017-04  | broken      |
  | TRIZEN    |  22 | 2016-05    | 2018-02  | broken      |
  | HOCHSTEN  |  22 | 2016-09    | 2018-06  | broken      |
  | RRWO      |  22 | 2019-10    | 2021-07  | broken      |
  | TANIGUCHI |  22 | 2020-03    | 2021-12  | broken      |
  | SKIM      |  22 | 2022-04    |          | might-break |
  | SMUELLER  |  21 | 2002-11    | 2004-07  | broken      |
  | DMOW      |  21 | 2003-09    | 2005-05  | broken      |
  | SCHUBIGER |  21 | 2007-08    | 2009-04  | broken      |
  | JOHND     |  21 | 2007-12    | 2009-08  | broken      |
  | ZAG       |  21 | 2008-06    | 2010-02  | broken      |
  | RKITOVER  |  21 | 2009-01    | 2010-09  | broken      |
  | NEKOKAK   |  21 | 2009-07    | 2011-03  | broken      |
  | AUBERTG   |  21 | 2011-12    | 2013-08  | broken      |
  | PHRED     |  21 | 2012-06    | 2014-02  | broken      |
  | DWHEELER  |  21 | 2012-07    | 2014-03  | broken      |
  | MELMOTHX  |  21 | 2013-10    | 2015-06  | broken      |
  | IRONCAMEL |  21 | 2013-12    | 2015-08  | broken      |
  | JV        |  21 | 2016-06    | 2018-02  | broken      |
  | TINITA    |  21 | 2018-03    | 2019-11  | broken      |
  | PRBRENAN  |  21 | 2020-04    | 2021-12  | broken      |
  | TELS      |  20 | 2001-02    | 2002-09  | broken      |
  | JHI       |  20 | 2002-03    | 2003-10  | broken      |
  | RCAPUTO   |  20 | 2002-12    | 2004-07  | broken      |
  | TELS      |  20 | 2004-10    | 2006-05  | broken      |
  | MSCHWERN  |  20 | 2006-09    | 2008-04  | broken      |
  | MTHURN    |  20 | 2006-12    | 2008-07  | broken      |
  | MSCHILLI  |  20 | 2008-05    | 2009-12  | broken      |
  | BRICAS    |  20 | 2008-08    | 2010-03  | broken      |
  | POTYL     |  20 | 2008-10    | 2010-05  | broken      |
  | WSNYDER   |  20 | 2009-09    | 2011-04  | broken      |
  | BRICAS    |  20 | 2010-05    | 2011-12  | broken      |
  | GUGOD     |  20 | 2010-10    | 2012-05  | broken      |
  | COSIMO    |  20 | 2011-03    | 2012-10  | broken      |
  | ANAZAWA   |  20 | 2012-01    | 2013-08  | broken      |
  | DAVIDO    |  20 | 2012-08    | 2014-03  | broken      |
  | HMBRAND   |  20 | 2012-11    | 2014-06  | broken      |
  | BEROV     |  20 | 2013-11    | 2015-06  | broken      |
  | DDUMONT   |  20 | 2013-12    | 2015-07  | broken      |
  | HOCHSTEN  |  20 | 2014-12    | 2016-07  | broken      |
  | MAXMIND   |  20 | 2015-10    | 2017-05  | broken      |
  | SREZIC    |  20 | 2016-09    | 2018-04  | broken      |
  | OALDERS   |  20 | 2017-11    | 2019-06  | broken      |
  | MBRADSHAW |  20 | 2019-10    | 2021-05  | broken      |
  | DERF      |  20 | 2022-06    |          | might-break |
  | JDEGUEST  |  20 | 2022-06    |          | might-break |
  +-----------+-----+------------+----------+-------------+

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Acme-CPANAuthorsBundle-CPAN-Streaks>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Acme-CPANAuthorsBundle-CPAN-Streaks>.

=head1 SEE ALSO

L<Acme::CPANAuthors>

CPAN Regulars Boards, L<http://cpan.io/board/once-a/>, which as of this writing,
has some input data missing and thus produces some incorrect results.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 CONTRIBUTING


To contribute, you can send patches by email/via RT, or send pull requests on
GitHub.

Most of the time, you don't need to build the distribution yourself. You can
simply modify the code, then test via:

 % prove -l

If you want to build the distribution (e.g. to try to install it locally on your
system), you can install L<Dist::Zilla>,
L<Dist::Zilla::PluginBundle::Author::PERLANCAR>,
L<Pod::Weaver::PluginBundle::Author::PERLANCAR>, and sometimes one or two other
Dist::Zilla- and/or Pod::Weaver plugins. Any additional steps required beyond
that are considered a bug and can be reported to me.

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2024, 2023 by perlancar <perlancar@cpan.org>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Acme-CPANAuthorsBundle-CPAN-Streaks>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=cut
