
use strict ;
use warnings ;

use Module::Build;

my %all_modules ;
my @split_modules ;

my @pm_files = qw(
lib/App/Asciio.pm

lib/App/Asciio/Actions.pm
lib/App/Asciio/Ascii.pm
lib/App/Asciio/Connections.pm
lib/App/Asciio/Dialogs.pm
lib/App/Asciio/Elements.pm
lib/App/Asciio/Io.pm
lib/App/Asciio/Menues.pm
lib/App/Asciio/Setup.pm
lib/App/Asciio/Undo.pm
lib/App/Asciio/Options.pm

lib/App/Asciio/stripes/editable_arrow2.pm
lib/App/Asciio/stripes/editable_box2.pm
lib/App/Asciio/stripes/if_box.pm
lib/App/Asciio/stripes/process_box.pm
lib/App/Asciio/stripes/section_wirl_arrow.pm
lib/App/Asciio/stripes/single_stripe.pm
lib/App/Asciio/stripes/stripes.pm
lib/App/Asciio/stripes/wirl_arrow.pm
);

for(@pm_files)
	{
	$all_modules{$_} = $_ ;
	push @split_modules, $_ ;
	}


my @setup_lib=
qw(
setup/setup.ini

setup/actions/align.pl
setup/actions/clipboard.pl
setup/actions/debug.pl
setup/actions/elements_manipulation.pl
setup/actions/file.pl
setup/actions/mouse.pl
setup/actions/new_elements.pl
setup/actions/colors.pl
setup/actions/unsorted.pl
setup/actions/presentation.pl

setup/actions/context_menu_multi_wirl.pl
setup/actions/context_menu_box.pl
setup/actions/context_menu_rulers.pl

setup/asciio_object/basic.pl
setup/hooks/canonize_connections.pl

setup/import_export/ascii.pl
setup/import_export/asciioe.pl
setup/import_export/perl.pl
setup/import_export/png.pl

setup/stencils/asciio
setup/stencils/computer
setup/stencils/people
setup/stencils/divers
) ;

for(@setup_lib)
	{
	$all_modules{$_} = "lib/App/Asciio/$_" ;
	}

sub GetVersionAndRevisionFrom
{
my ($file) = @_ ;

my $version_from = File::Spec->catfile( split '/', $file );
my $version      = Module::Build->version_from_file($version_from);

if($ENV{'App-Asciio_USE_SVK_VERSION_FOR_DIST'})
	{
	my @svk_log = `svk log -r HEAD -q` ;
	if(@svk_log)
		{
		my ($revision) = $svk_log[1] =~ m/^r([0-9]+):/ ;
		print "using SVK revision $revision.\n" ;
		return("${version}.${revision}") ;
		}
	else
		{
		print "Couldn't get SVK revision, using version from '$file'!\n" ;
		return($version) ;
		}
	}
else
	{
	return($version) ;
	}
}

my $code = <<'EOC'

use strict ;
use warnings ;

#~ use Data::TreeDumper ;
#~ print DumpTree \@_, 'args:' ;

sub GetVersionAndRevisionFrom
{
my ($file) = @_ ;

my $version_from = File::Spec->catfile( split '/', $file );
my $version      = Module::Build->version_from_file($version_from);

if($ENV{'App-Asciio_USE_SVK_VERSION_FOR_DIST'})
	{
	my @svk_log = `svk log -r HEAD -q` ;
	if(@svk_log)
		{
		my ($revision) = $svk_log[1] =~ m/^r([0-9]+):/ ;
		print "using SVK revision $revision.\n" ;
		return("${version}.${revision}") ;
		}
	else
		{
		print "Couldn't get SVK revision, using version from '$file'!\n" ;
		return($version) ;
		}
	}
else
	{
	return($version) ;
	}
}

#~ sub ACTION_
#~ {
#~ my $self = shift;
#~ print "\n";
#~ }

sub ACTION_build 
{
my $self = shift;

if($ENV{'App-Asciio_USE_SVK_VERSION_FOR_DIST'})
	{
	my ($version) = GetVersionAndRevisionFrom('lib/App//Asciio.pm') ;
	
	print "Generating version module ($version)\n" ;
	
	open VERSION, '>', 'Version.pm' or die "can't generate Version module: $!\n" ;
	
	print VERSION <<EOV ;
	
	# version module automatically generated by the build system
	
	package Asciio::Version ;
	
	sub GetVersion {return '$version'} ;
	
	1 ;
	
	# end of generated version module
EOV
	
	close VERSION ;
	}
	
$self->SUPER::ACTION_build(@_);
}

#~ sub ACTION_latest
#~ {
#~ ACTION_dist(@_) ;
#~ if($ENV{'App-Asciio_USE_SVK_VERSION_FOR_DIST'})
	#~ {
	#~ my ($version) = GetVersionAndRevisionFrom('lib/App//Asciio.pm') ;
	
	#~ my $source = "PerlBuildSystem-$pbs_version.tar.gz" ;
	#~ my $destination = "PerlBuildSystem-latest.tar.gz" ;
	
	#~ use Net::SCP qw(scp iscp);
	#~ iscp($source, "nadim\@firewall:/var/www/localhost/htdocs/files_for_download/$destination");
	#~ }
#~ }

#~ sub ACTION_dist
#~ {
#~ my $self = shift;

#~ if($ENV{'App-Asciio_USE_SVK_VERSION_FOR_DIST'})
	#~ {
	#~ my $have_svk = $self->do_system('svk --version');
	
	#~ if($have_svk)
		#~ {
		#~ if($self->do_system('svk log -x -v > SVK_Changes'))
			#~ {
			#~ use File::Copy;
			#~ move('SVK_Changes', 'Changes') ;
			#~ }
		#~ else
			#~ {
			#~ print "Couldn't get SVK log, 'Changes' will not be generated from SVK log!\n" ;
			#~ }
		#~ }
	#~ else
		#~ {
		#~ print "SVK not found, 'Changes' will not be generated from SVK log!\n" ;
		#~ }
	#~ }
	
#~ $self->SUPER::ACTION_dist();

#~ if($ENV{'App-Asciio_USE_SVK_VERSION_FOR_DIST'})
	#~ {
	#~ my ($pbs_version) = GetVersionAndRevisionFrom('lib/App//Asciio.pm') ;
	
	#~ my $source = "PerlBuildSystem-$pbs_version.tar.gz" ;
	#~ my $destination = "PerlBuildSystem-bleed.tar.gz" ;
	
	#~ use Net::SCP qw(scp iscp);
	#~ iscp($source, "nadim\@firewall:/var/www/localhost/htdocs/files_for_download/$destination");
	#~ }
#~ };

sub ACTION_inject
{
#~ my $self = shift;

# check cpan if mini inject is installed
# build
# from $self find how to update 02packages.details.txt.gz

die "'inject' not implemented yet!\n";
}

sub ACTION_update_cpan_mini
{
# build test and make a dist
die "'update_mini_cpan' not implemented yet!\n";
}

EOC
;

my $class = Module::Build->subclass(class => 'App::Asciio', code => $code) ;

my $build = $class->new
	(
	module_name => 'App::Asciio',
	
	#~ dist_version => GetVersionAndRevisionFrom('lib/App/Asciio.pm'),
	dist_version => '1.01',
	
	license => 'perl',
	
	requires => 
		{
		'Readonly'         => 0,
		'Data::Compare'    => 0,
		'Sub::Exporter'     => 0,
		'Data::TreeDumper' => 0,
		'version'    => 0.50,
		
		'Compress::Bzip2' => 0,
		'Cwd' => 0,
		'Data::TreeDumper::Renderer::GTK' => 0,
		'Directory::Scratch' => 0,
		'Directory::Scratch::Structured' => 0,
		'Eval::Context' => 0,
		'File::Basename' => 0,
		'File::Spec' => 0,
		'Glib' => 0,
		'Gtk2' => 0,
		'Gtk2::Gdk::Keysyms' => 0,
		'List::MoreUtils' => 0,
		'List::Util' => 0,
		'MIME::Base64' => 0,
		'File::Copy' => 0,
		'File::Slurp' => 0,
		'Algorithm::Diff' => 0,
		'Clone' => 0,
		'Module::Util' =>0,
		
		'Test::Block' => 0,
		'Test::Dependencies' => 0,
		'Test::Distribution' => 0,
		'Test::Exception' => 0,
		'Test::NoWarnings' => 0,
		'Test::Warn' => 0,
		'Test::Perl::Critic' => 0,
		'Test::Pod' => 0,
		'Test::Pod::Coverage' => 0,
		'Test::Spelling' => 0,
		'Test::Strict' => 0,
		},
		
	pm_files     => \%all_modules,
	#~ autosplit    => \@split_modules,
	
	script_files => 'script/asciio',
	dist_author  => 'Khemir Nadim ibn Hamouda. <nadim@khemir.net>',
	dist_abstract => 'App::Asciio - ',
	);
	
$build->create_build_script;
  

