#!/usr/bin/perl -w -I./t
# $Id: rt_46597.t 12806 2009-06-02 15:56:56Z mjevans $
use Test::More;
use strict;

$| = 1;

my $has_test_nowarnings = 1;
eval "require Test::NoWarnings";
$has_test_nowarnings = undef if $@;
my $tests = 7;
$tests += 1 if $has_test_nowarnings;
plan tests => $tests;

use DBI qw(:sql_types);
use_ok('ODBCTEST');             # 1
use_ok('Data::Dumper');         # 2

my $dbh;

BEGIN {
    plan skip_all => "DBI_DSN is undefined"
        if (!defined $ENV{DBI_DSN});
}
END {
    if ($dbh) {
        eval {
            local $dbh->{PrintWarn} = 0;
            local $dbh->{PrintError} = 0;
            $dbh->do(q/drop table PERL_DBD_rt_46597/);
        };
        $dbh->disconnect;
    }
    Test::NoWarnings::had_no_warnings()
          if ($has_test_nowarnings); # 8
}

$dbh = DBI->connect();
unless($dbh) {
   BAIL_OUT("Unable to connect to the database $DBI::errstr\nTests skipped.\n");
   exit 0;
}
my $sth;
$dbh->{RaiseError} = 1;
my $dbname = $dbh->get_info(17); # DBI::SQL_DBMS_NAME
SKIP: {
   skip "Microsoft Access tests not supported using $dbname", 5
       unless ($dbname =~ /Access/i);

   eval {
       local $dbh->{PrintWarn} = 0;
       local $dbh->{PrintError} = 0;
       $dbh->do(q/drop table PERL_DBD_rt_46597/);
   };
   pass('dropped test table');  # 3

   eval {$dbh->do(q{CREATE TABLE PERL_DBD_RT_46597 (Sequence memo)})};

   my $data = "GAAGCGGGATGAGCTCAAACTTAAAATCTCTGTTGCTTGCAACAGCGAATTGTAGTCTCGAGAAGCGTTTTCAAGGCGGATGCACAGTGCTCAAGTTGCTTGGAACGGCACATCGTAGAGGGTGACAATCCCGTACGTGGCACTGTGTACTGTTCACGATTCGCTTTCTATGAGTCGGGTTGCTTGGGAATGCAGCCCAAAATGGGAGGTAAACTCCTTCTAAAGCTAAATATTGGCACGAGACCGATAGCGAACAAGTACCGTGAGGGAAAGATGAAAAGCACTTTGAAAAGAAAGTTAATAGTACGTGAAACCGTTAGTAGGGAAGCGCATGGAATTAGCAATACACTGTCGAGATTCAGGCGGGCGGCGATTGGTACGGCTGTTGTACGGATCTGAATGGACCGTCGGTGGTCGTCACTGGTTGCTGCCTGTTGCATTTCCCGGCAGTGTTCGTCAACAGGTGTTGGAACCGAGCGATAAGCCCCGCAGGAAGGTGGCTGGCTTCGGCTAGTGTTATAGCCTGTGGTGTGCGAGCTCGGGTCCGACAGAGGGGTTGCGGCACATGCTCTTTTGGGCTGGTCTCGTCTCTCTCGGCTGGTTGTCGACTATGGCGGACTGCGTGCAGTGCGCTTGAACTGCTGCCGGTCGTCGAGGGGCATCGGACACACATTGTGCCAAGGTTGTTGGCGGTCATATGGTTTCATACGACCCGTCTTGAAACACGGACCAAGGAGTCTAACATGTGTGCGAGTCTTTGGGTGATCGAAACCCGCAGGCACAATGAAAGTAAAGGCTGCTTGCAGCTGAAGTGAGATCTCCCGGTCTCGGCCGGGGGCGCATCATTGACCGACCTATTCTACTCCTAGAAAGGTTTGAGTAAGAGCACATCTGTTGGGACCCGAAAGATGGTGAACTATGCTTGAGTAGGGCGAAGCCAGAGGAAACTCTGGTGGAGGCTCGTAGCGATTCTGACGTGCAAATCGATCGTCAAACTTGAGTATAGGGGCGAAAGACTAATCGAACCATCTAGTAGCTGGTTCCCTCCGAAGTTTCCCTTAGGATAGCTGGAACTCGGAACAGTTTTATCAGGTAAAGCGAATGATTAGAGGTCTTAGGATTGAAACAATCTTAACCTATTCTCAAACTTTAAATTGGTAAGAAGCCCGGCTTGCTTAACTGAAGCAGGGCACAGAATGAGAGTTCTTAGTGGGCCATTTTTGGTAAGCAGAACTGGCGATGCGGGATGAACCGAACGCTGAGTTAAGGCGTCTAAATCGACGCTCATCAGACCCCACAAAAGGTGTTGGTTGATCTAGACAGCAGGACGGTGGCCATGGAAGTCGGAATCCGCTAAGGAGTGTGTAACAACCCACCTGCCGAATCAACTAGCCCTGAAAATGGATGACGCTCAAGCGTCGTGCCTATACTCAGCCGTCAACGTAAATAGCGAAGCGTTGACGAGTAGGAGGGCGTGGGGATCGTGACGCAGCCTTTGGCGTGAGCCTGGGTGAAACGGTCTCTAGTGAAGATCTTGGTGGTAGTAGCAAATATTCAAATGAGAACTTTGAAGACCGAAGTGGAGAAAGGTTCCATGTGAACAGCAGTTGGACATGGGTTAGTCGATCCTAAGAGATAGGGAAACTCCGTTTCAAAGTGTCCGATCTTGGACCGTTTATCGAAAGGGAATCGGGTTAATATTCCCGAACCAGAACGCGGATATTCTAGCCTCTCGGGGTTAGATGTGCGGTAACGCAACTGAACTCGGAGACGTCGGCAGGGGCCCTGGGAAGAGTTCTCTTTTCTTGTTAACGACCTGACACCATGGAATCTGATTGCCAGGAGATATGGTTTGATGGTCGGTAAAGCACCACACTTCTTGTGGTGTCCGGTGCGCTCCTGAAGGCCCTTGAAAATCCGAGGGAAAGATTGATTTTCGCGTCTGTTCGTACTCATAACCGCAGCAGGTCTCCAAGGTGAGCAGCCTCTGGTCGATAGAACAATGTAGGTAAGGGAAGTCGGCAAAATAGATCCGTAACTTCGGGAAAAGGATTGGCTCTAAGGATTGGGTCTGTCGGGCTGAGACTTGAAGCGGGCGGCACCGACTCGGACTGGCTGTGGCCTCTCGGGGCTATGGTTGGACTGGGAAGGAACTGCGCGTGGATTGGCCCAGCTATGCTCGCAAGAGCAGTTCGGCAGGCAATTAACAATCAACTTAGAACTGGTACGGACAAGGGGAATCCGACTGTTTAATTAAAACAAAGCATTGCGATGGCCGGAAACGGTGTTGACGCAATGTGATTTCTGCCCAGTGCTCTGAATGTCAAAGTGAAGAAATTCAACCAAGCGCGGGTAAACGGCGGGAGTAACTATGACTCTCTTAAGGTAGCCAAATGCCTCGTCATCTAATTAGTGACGCGCATGAATGGATTAACGAGATTCCCACTGTCCCTATCTACTATCTAGCGAAACCACAGCCAAGGGAACGGGCTTGGCAAAATCAGCGGGGAAAGAAGACCCTGTTGAGCTTGACTCTAGTCTGACTCTGTGAAAAGACATAGGAGGTGTAGAATAGGTGGGAGCAGCAATGCAACAGTGAAATACCACTACTCTTATAGTTTTTTTACTTATTCGATTGAGCGGAAGCGAGCTTCACGGCTCATTTTCTAGAATTAAGGCCCCATTGGCGGGTCGATCCGTGTCGAAGACACTGTCAGGTTGGGAGTTTGGCTGGGGCGGCACATCTGTCAAATGATAACGCAGGTGTCCTAAGGTGAGCTCAATGAGAACGGAAATCTCATGTAGAACAAAAGGGTAAAAGCTCACTTGATTTTGATTTTCAGTATGAATACAAACTGTGAAAGCATGGCCTATCGATCCTTTAGTCTTTAGGAGTTTTAAGCTAGAGGTGTCAGAAAAGTTACCACAGGGATAACTGGCTTGTGGCAGCCAAGCGTTCATAGCGACGTTGCTTTTTGATCCTTCGATGTCGGCTCTTCCTATCATTGTGAAGCAGAATTCACCAAGTGTTGGATTGTTCACCCACTAATAGGGAACGTGAGCTGGGTTTAGACCGTCGTGAGACAGGTTAGTTTTACCCTACTGATGAAGTGTTGTTGCAATAGTAATTCTGCTCAGTACGAGAGGAACCGCAGATTCAGACAATTGGCATTTGCACTTGCTTGAAAAGGCAATGGTG";

   my $ev = $@;
   ok(!$ev, 'created test table PERL_DBD_rt_43384'); # 4
   SKIP: {
       skip 'failed to create test table', 3 if $ev;


       my $sth = $dbh->prepare(
           q{INSERT INTO TestTable values (?)}) || die ($DBI::errstr);
       ok($sth, 'insert prepared'); # 5

     SKIP: {
           skip 'failed to prepare', 2 if !$sth;

           ok($sth->bind_param(1, $data, DBI::SQL_LONGVARCHAR),
              'parameter bound'); # 6
           eval {$sth->execute($data)};
           $ev = $@;
           ok(!$ev, "inserted into test table with sticky parameter type"); # 7
       };
   };
};

exit 0;
