MODULE = CryptX         PACKAGE = Crypt::Mac::Pelican

### BEWARE - GENERATED FILE, DO NOT EDIT MANUALLY!

Crypt::Mac::Pelican
new(char * class, SV * key)
    CODE:
    {
        STRLEN k_len=0;
        unsigned char *k=NULL;
        int rv;

        if (!SvPOK(key)) croak("FATAL: key must be string/buffer scalar");
        k = (unsigned char *) SvPVbyte(key, k_len);

        Newz(0, RETVAL, 1, struct pelican_struct);
        if (!RETVAL) croak("FATAL: Newz failed");

        rv = pelican_init(&RETVAL->state, k, (unsigned long)k_len);
        if (rv != CRYPT_OK) {
          Safefree(RETVAL);
          croak("FATAL: pelican_init failed: %s", error_to_string(rv));
        }
    }
    OUTPUT:
        RETVAL

void
DESTROY(Crypt::Mac::Pelican self)
    CODE:
        Safefree(self);

Crypt::Mac::Pelican
clone(Crypt::Mac::Pelican self)
    CODE:
        Newz(0, RETVAL, 1, struct pelican_struct);
        if (!RETVAL) croak("FATAL: Newz failed");
        Copy(&self->state, &RETVAL->state, 1, struct pelican_struct);
    OUTPUT:
        RETVAL

void
add(Crypt::Mac::Pelican self, ...)
    PPCODE:
    {
        int rv, i;
        STRLEN in_data_len;
        unsigned char *in_data;

        for(i = 1; i < items; i++) {
          in_data = (unsigned char *)SvPVbyte(ST(i), in_data_len);
          if (in_data_len > 0) {
            rv = pelican_process(&self->state, in_data, (unsigned long)in_data_len);
            if (rv != CRYPT_OK) croak("FATAL: pelican_process failed: %s", error_to_string(rv));
          }
        }
        XPUSHs(ST(0)); /* return self */
    }

SV *
mac(Crypt::Mac::Pelican self)
    ALIAS:
        hexmac  = 1
        b64mac  = 2
        b64umac = 3
    CODE:
    {
        unsigned char mac[MAXBLOCKSIZE];
        unsigned long maclen, outlen;
        int rv;
        char out[MAXBLOCKSIZE*2];

        maclen = 16;
        rv = pelican_done(&self->state, mac);
        if (rv != CRYPT_OK) croak("FATAL: pelican_done failed: %s", error_to_string(rv));
        outlen = sizeof(out);
        if (ix == 3) {
          rv = base64url_encode(mac, maclen, (unsigned char*)out, &outlen);
          if (rv != CRYPT_OK) croak("FATAL: base64url_encode failed: %s", error_to_string(rv));
          RETVAL = newSVpvn(out, outlen);
        }
        if (ix == 2) {
          rv = base64_encode(mac, maclen, (unsigned char*)out, &outlen);
          if (rv != CRYPT_OK) croak("FATAL: base64_encode failed: %s", error_to_string(rv));
          RETVAL = newSVpvn(out, outlen);
        }
        if (ix == 1) {
          rv = _base16_encode(mac, maclen, (unsigned char *)out, &outlen);
          if (rv != CRYPT_OK) croak("FATAL: base16_encode failed: %s", error_to_string(rv));
          RETVAL = newSVpvn(out, outlen);
        }
        else {
          RETVAL = newSVpvn(mac, maclen);
        }
    }
    OUTPUT:
        RETVAL

SV *
pelican(SV * key, ...)
    ALIAS:
        pelican_hex  = 1
        pelican_b64  = 2
        pelican_b64u = 3
    CODE:
    {
        STRLEN inlen, klen;
        unsigned char *in;
        unsigned char *k = (unsigned char *)SvPVbyte(key, klen);
        int rv, i;
        unsigned char mac[MAXBLOCKSIZE];
        unsigned long len = sizeof(mac), outlen;
        char out[MAXBLOCKSIZE*2];
        pelican_state st;

        len = 16;
        rv = pelican_init(&st, k, klen);
        if (rv != CRYPT_OK) croak("FATAL: pelican_init failed: %s", error_to_string(rv));
        for (i = 1; i < items; i++) {
          in = (unsigned char *)SvPVbyte(ST(i), inlen);
          if (inlen > 0) {
            rv = pelican_process(&st, in, inlen);
            if (rv != CRYPT_OK) croak("FATAL: pelican_process failed: %s", error_to_string(rv));
          }
        }
        rv = pelican_done(&st, mac);
        if (rv != CRYPT_OK) croak("FATAL: pelican_done failed: %s", error_to_string(rv));

        outlen = sizeof(out);
        if (ix == 3) {
          rv = base64url_encode(mac, len, (unsigned char *)out, &outlen);
          if (rv != CRYPT_OK) croak("FATAL: base64url_encode failed: %s", error_to_string(rv));
          RETVAL = newSVpvn((char *) out, outlen);
        }
        else if (ix == 2) {
          rv = base64_encode(mac, len, (unsigned char *)out, &outlen);
          if (rv != CRYPT_OK) croak("FATAL: base64_encode failed: %s", error_to_string(rv));
          RETVAL = newSVpvn((char *) out, outlen);
        }
        else if (ix == 1) {
          rv = _base16_encode(mac, len, (unsigned char *)out, &outlen);
          if (rv != CRYPT_OK) croak("FATAL: base16_encode failed: %s", error_to_string(rv));
          RETVAL = newSVpvn((char *) out, outlen);
        }
        else {
          RETVAL = newSVpvn((char *) mac, len);
        }
    }
    OUTPUT:
        RETVAL
