# Before `make install' is performed this script should be runnable with
# `make test'. After `make install' it should work as `perl new_blz.t'

use Test::More tests => 1174;

BEGIN { use_ok('Business::KontoCheck') };

$ok_cnt=$nok_cnt=0;
$retval=lut_init("blz.lut");
$ret_txt=$kto_retval{$retval};
if($retval>0){$ok_cnt++;}else{$nok_cnt++;}
ok($retval gt 0,"init: $retval => $ret_txt (ok: $ok_cnt, nok: $nok_cnt)");

if($retval>0){
   while(<DATA>){
      chomp;
      ($ret,$blz,$kto)=split(/ /);
      $retval=kto_check_blz($blz,$kto);
      $ret_txt=$kto_retval{$retval};
      if($retval==$ret){$ok_cnt++;}else{$nok_cnt++;}
      ok($retval eq $ret,"BLZ/KTO (neu) $blz $kto: $retval (Soll: $ret) => $ret_txt (ok: $ok_cnt, nok: $nok_cnt)");
   }
}

__DATA__
1 10220500 2986104616
1 12030000 7060260903
1 10130800 3992314124
1 25010600 8867747106
2 45050001 5579780911
2 45050001 5827618671
1 47850065 7523445698
1 55350010 3511140034
1 30030500 5287804228
1 52050353 5706723916
1 10060198 4420996247
1 10090000 1815860868
1 70220800 6330957444
1 70220800 2480901378
1 30022000 9620933573
1 30025500 6488374122
2 30050000 9086
2 40022000 2184
2 40050000 47332
1 44050000 76992
2 10000000 9394732621
2 10010424 8715429344
1 12030900 9905387617
1 20030133 1384736042
1 51420200 6091086146
1 74350000 5359927135
1 10010111 711793036
1 10040000 62364982
1 10040005 35824073
1 10030700 5943915468
1 20120700 6744867388
1 10110600 5081456951
1 51420300 7343688158
1 29020100 3420354861
1 30120500 4591958957
1 10220600 7119791599
1 13050000 2627507764
1 14051000 1341866773
-133 50210189 9596026894
-133 50510136 2307159923
1 26851620 8315912773
1 26851620 8374551104
1 72020700 8036705175
1 72020700 6211704217
1 72020700 3481301848
1 72020700 2360616553
1 72020700 2461110867
1 72020700 7410824588
1 72020700 5197929674
1 72020700 1096633621
1 72020700 7895933858
1 72020700 1578448182
1 72020700 6285044258
1 72020700 7045654919
1 72020700 9539352049
1 72020700 7962061397
1 72020700 3630463306
1 72020700 4604873937
1 72020700 7945973554
1 72020700 3646988598
1 72020700 1164499910
1 72020700 7161794042
1 10010010 1761832444
1 20010020 1199281657
1 25010030 2568395716
1 36010043 2999523244
1 37010050 7730401622
1 37011000 7819035749
1 44010046 8313358651
1 50010060 8847606328
1 54510067 3931203039
1 59010066 3351370412
1 60010070 4321462448
1 66010075 4901306540
1 70010080 5921192740
1 76010085 5791220147
1 86010090 6761250425
1 10010010 6261651870
1 10010010 3272637742
1 20010020 3982461041
1 25010030 4082165117
1 36010043 4342816011
1 37010050 5612352474
1 37011000 5462149101
1 44010046 6152785258
1 50010060 6022953691
1 54510067 3513316859
1 59010066 3593284510
1 60010070 4403669617
1 66010075 4213648557
1 70010080 5563642375
1 76010085 5173032530
1 86010090 6523761015
1 10010010 6343306814
1 10010010 3055887641
1 20010020 3525499065
1 25010030 4835383605
1 36010043 4145653924
1 37010050 5275215115
1 37011000 6525545017
1 44010046 6565793284
1 50010060 3406917626
1 54510067 3856459462
1 59010066 4386143599
1 60010070 4336441459
1 66010075 5786033576
1 70010080 5566277885
1 76010085 6026920931
1 86010090 6476601731
1 10010010 3277812864
1 10010010 3797383091
1 20010020 4087397380
1 25010030 4877775185
1 36010043 5857164117
1 37010050 5727676151
1 37011000 6097579931
1 44010046 6897499458
1 50010060 3788978874
1 54510067 3248017515
1 59010066 4138295944
1 60010070 4528896325
1 66010075 5478457485
1 70010080 5718414142
1 76010085 6828665036
1 86010090 6598155292
1 10010010 3879350658
1 10010010 3579100136
1 20010020 4069537819
1 25010030 5279631580
1 36010043 5329695220
1 37010050 6089457420
1 37011000 6369698441
1 44010046 9141606948
1 50010060 9731899733
1 54510067 9252197036
1 59010066 9333301145
1 60010070 9494377491
1 66010075 9954682409
1 70010080 9875724322
1 76010085 9835953364
1 86010090 9006340107
1 10010010 9856254910
1 10010010 9977041262
1 20010020 9177328081
1 25010030 9488389421
1 36010043 9698067252
1 37010050 9359934465
1 42050001 874681693
1 25055500 47050626
1 72012300 35315373
1 25055500 1584152452
1 25055500 9111774654
1 25050000 556009389
1 59050000 667383079
1 25050000 9681134212
1 25050000 5828254078
1 16062008 2577622379
1 20069780 4333867499
1 20069782 40315636
1 29050000 7831270833
1 29050000 6104658723
1 52420600 6195881206
1 70120600 2765887145
1 50324000 7643374554
1 50324040 1210397447
1 13061008 9039837809
1 13061028 6145269245
1 20069125 5115446513
1 36060488 2919904160
1 40060265 78548515
1 38621500 9918112955
1 56061151 5448482147
1 35060386 1728901519
1 56062227 2159397248
1 25020600 6659185265
1 25020600 8759700089
1 25020600 8223967418
1 25020600 1297791228
1 66661454 5869257749
1 66690000 6099682743
1 66690000 3954098584
1 30060010 6292069411
1 40060000 8539781169
2 29020000 765116405
2 29020000 956940713
2 29020000 8528128980
2 29020000 5764183880
1 29020000 6989597338
1 29020000 9064439178
1 50310400 4410635677
1 50310455 5039661372
1 27290087 4752779243
1 20190109 5842714674
1 21092023 4282344857
1 76050101 4234100859
1 76050101 6097349184
1 76050101 1680939796
1 76050101 2583781583
1 20090700 8630313339
1 20090745 4949994
1 26991066 1215612
1 33060592 5851977064
1 36060591 2996888804
1 37060590 7535208483
1 33060592 9441822322
1 33060592 8900888435
1 36060591 4733787914
1 37060590 4354633525
1 33060592 3020902932
1 33060592 4371928926
1 36060591 5720210260
1 37060590 8499892545
1 33060592 7897603767
1 33060592 4199633073
1 36060591 1394301162
1 13051172 91963897
1 13051172 67161675
1 16052072 866183073
1 70012100 5753623249
1 30030100 8760727955
1 30020900 5187800477
2 30020900 7777773585
2 30020900 7777775518
2 30020900 8888882139
2 30020900 8888883142
2 30020900 4054678861
2 30020900 4025769915
2 30020900 5083020075
2 30020900 5073513260
2 30020900 9116314383
2 30020900 9105267751
2 30020900 9930839648
2 30020900 185125434
2 30020900 185125434
2 55050000 76819010
2 55050000 15321184
1 55050000 396503104
1 55050000 479048811
1 55050000 3600887412
1 55050000 7600736222
1 10020200 3507146889
1 20120200 8578216827
1 25621327 5034857211
1 26520017 7251371653
1 26521703 4418021282
1 26522319 2813825983
1 10070000 3506313
1 10070024 856458544
1 10070100 783322184
1 57090000 2967143501
1 57090000 9001552439
1 60020030 1518950398
1 66020020 6585285795
1 60020030 3275118594
1 60020030 9972703391
2 50120500 942688013
1 50120500 457276787
1 50120500 152515195
1 50120500 157953389
1 50120500 255210291
1 50120500 268570696
1 50120500 307924769
1 50120500 425047591
1 50120500 435176472
1 50120500 591764696
1 50120500 599490804
1 50120500 605653031
1 50120500 672542255
1 50120500 772815077
1 50120500 731832036
1 50120500 835048991
1 50120500 844617104
2 50120500 924866188
2 50120500 964366595
1 70013000 2256668176
1 70013010 4854632977
2 20030000 452375801
2 20030000 457464795
1 20030000 3069090705
1 20030000 1379305442
1 20030000 111153
1 20030000 409359
1 20030000 1729029
1 20030000 2366565
1 20030000 20893707
1 20030000 93518942
1 20030000 651149908
1 20030000 728035957
1 20030000 634352
1 20030000 168310
1 20030000 8914580
1 20030000 7757419
1 20030000 29637900
1 20030000 73854315
1 20030000 766453541
2 20030000 403983417
2 20030000 475903076
1 65110200 7789358309
1 65110200 9476774001
1 50090500 9003621650
1 50090500 7713063025
1 50090500 4418079972
1 50090500 9121649417
1 50090500 8845278879
1 50090500 3506284182
1 50090500 6960165926
1 50090500 1701120513
1 50090500 1591755719
1 21050170 9370909
1 21050170 9017831
1 21050170 34575241
1 21050170 19831148
1 21050170 503747297
1 21050170 782931281
1 21050170 3373878044
1 21050170 368902
1 21050170 693101
1 21050170 813548
1 21050170 203138
1 10080000 3280394
1 10080005 3725431
1 10080006 31388960
1 10080055 41097400
1 10080057 747511166
1 10080088 686411923
1 10080900 4592345127
1 12080000 35518
1 13080000 11861
1 14080000 722169
1 14080011 6909279
1 15080000 9391423
1 16080000 88287120
1 17080000 46666826
1 18080000 79025777
2 36050105 35913488
1 36050105 7473910037
1 36050105 4824349866
1 20090500 7105369452
1 25090500 2900883530
1 70090500 8914417453
1 76090500 2017982577
1 20090500 6025605431
1 20090500 8122792265
1 25090500 4636877206
1 70090500 6531912038
1 76090500 8949726535
1 20090500 6644179595
1 20090500 9757256990
1 25090500 2260508276
1 70090500 1076672981
1 76090500 6076315305
1 20090500 8288459150
1 20090500 9284038010
1 25090500 7597258512
1 70090500 5597966606
1 72090500 5956615374
1 75090500 6422588792
1 72090500 1887284605
1 72090500 3486580054
1 75090500 2367435611
1 72090500 6877045494
1 72090500 9891085896
1 75090500 7496129530
1 40060560 6765830435
1 40060560 3315491649
1 40060560 8514595772
1 40060560 1494363456
1 40060560 9949050290
1 40060560 8080335193
1 40060560 2299942291
1 40060560 7099821575
1 60090800 8262394408
1 60090800 767018
1 60090800 522333
1 60090800 777129
1 60090800 245070
1 60090800 5751713
1 60090800 8864047
1 60090800 99974584
1 60090800 90721810
1 60090800 99598302
1 60090800 92566456
1 10030600 4654965582
1 70090100 2194381445
1 70091500 5396447966
1 55090500 5300989541
1 55090500 4401329600
1 55090500 9104857882
1 55090500 7408717320
1 55090500 7403643370
1 55090500 1307248293
1 55090500 7805958014
1 55090500 6406646318
1 55090500 3301465725
1 55090500 1809079550
1 55090500 6519909230
1 55090500 1318843636
1 55090500 5313590568
1 55090500 8919264326
1 55090500 3218292961
1 55090500 6915796566
1 55090500 2816133596
1 55090500 4518067109
1 55090500 8929995889
1 55090500 5123292827
1 55090500 2123215295
1 55090500 2424199275
1 55090500 9223790043
1 55090500 3327193033
1 55090500 4628915870
1 55090500 2622721359
1 55090500 7123242488
1 55090500 6136092063
1 55090500 8533559548
1 55090500 8837707783
1 55090500 2133791865
1 55090500 4333300475
1 55090500 2339171171
1 55090500 3737279267
1 55090500 8839726443
1 55090500 7638140921
1 55090500 5832286189
1 55090500 5440129933
1 55090500 9044093780
1 55090500 1146601942
1 55090500 8642512103
1 55090500 2344952542
1 55090500 7048223092
1 55090500 6443730096
1 55090500 5343160490
1 55090500 2253943313
1 55090500 6953975967
1 55090500 6758640344
1 55090500 9154656461
1 55090500 4055510553
1 55090500 9459308335
1 55090500 9153748508
1 55090500 6854945395
1 55090500 5855382838
1 55090500 1257188351
1 55090500 7069899952
1 55090500 9965007684
1 55090500 4661989355
1 55090500 6865070135
1 55090500 8466962680
1 55090500 6768040194
1 55090500 6161365953
1 55090500 9861291948
1 55090500 8562580614
1 55090500 5072412950
1 55090500 8573363929
1 55090500 6371514110
1 55090500 1972533653
1 55090500 6676319944
1 55090500 1078343680
1 55090500 9275695486
1 55090500 8371779978
1 55090500 2472225004
1 55090500 9975631574
1 55090500 7288484678
1 55090500 5584677080
1 55090500 5884512354
1 55090500 4685829161
1 55090500 8184472966
1 55090500 2380182780
1 55090500 2880899955
1 55090500 1689538078
1 55090500 1782159956
1 55090500 8791021979
1 55090500 1296550732
1 10090900 3191605723
1 20090900 4934423907
1 21090900 9299465392
1 25090900 5909739857
1 27090900 7073073810
1 29090900 1285006621
1 67230000 7357481835
1 67230001 5684912273
1 10120100 1603833370
1 50110801 4176558947
2 70020270 1288243
2 70020270 1035767
2 70020270 9896098
2 70020270 9742019
2 70020270 11723735
2 70020270 12657185
2 70020270 20197963
2 70020270 20773654
2 70020270 21069815
2 70020270 21184549
2 70020270 22582064
2 70020270 22764882
2 70020270 23769672
2 70020270 23915640
2 70020270 24565687
2 70020270 24993371
2 70020270 25802646
2 70020270 25533876
2 70020270 396107137
2 70020270 396372776
2 70020270 397288307
2 70020270 397351800
2 70020270 398623580
2 70020270 398371678
2 70020270 399980356
2 70020270 399189680
2 70020270 465236339
2 70020270 415363968
2 70020270 705322759
2 70020270 774487317
2 70020270 910583909
2 70020270 910967395
2 70020270 928042740
2 70020270 937848431
2 70020270 934596305
2 70020270 943123950
2 70020270 941599314
2 70020270 959060206
2 70020270 952942326
2 70020270 969140004
2 70020270 963155993
2 70020270 974786685
2 70020270 983565346
2 70020270 985462122
1 70020270 2267057829
1 70020270 5843253026
1 50050201 3535224505
1 50050201 5729414014
1 50050201 1314805365
1 50050201 3387240439
2 50050201 1385965
2 50050201 1387738
2 50050201 1487701
2 50050201 1409189
2 50050201 1578097
2 50050201 1547851
2 50050201 1688026
2 50050201 1623814
2 50050201 1781270
2 50050201 1765873
2 50050201 1883585
2 50050201 1851633
2 50050201 1928529
2 50050201 1952620
2 50050201 2606075
2 50050201 2006417
2 50050201 3465339
2 50050201 3573571
2 50050201 4330795
2 50050201 4285112
2 50050201 5746201
2 50050201 5312128
2 50050201 6742231
2 50050201 6135276
2 50050201 7685391
2 50050201 8911429
2 50050201 9385254
2 50050201 9576133
2 50050201 10883579
2 50050201 10497581
2 50050201 20476960
2 50050201 20926140
2 50050201 30398996
2 50050201 30683357
2 50050201 40056329
2 50050201 40621252
2 50050201 50262005
2 50050201 50267948
2 50050201 60900943
2 50050201 60609354
2 50050201 70976177
2 50050201 70576529
2 50050201 80438383
2 50050201 80097188
2 50050201 90302595
2 50050201 90070090
2 50050201 91663433
2 50050201 91420407
2 50050201 92468833
2 50050201 92387938
2 50050201 93007630
2 50050201 93804618
2 50050201 94337443
2 50050201 94025267
2 50050201 95829628
2 50050201 95332084
2 50050201 96559359
2 50050201 96543331
2 50050201 97731091
2 50050201 97703406
2 50050201 98016951
2 50050201 98923891
2 50050201 99312696
1 50050201 99880415
2 50050201 99132421
2 50050201 99175086
2 50050201 99260070
2 50050201 99225813
2 50050201 99356848
2 50050201 99376988
1 74290100 4874608870
1 74290100 7215400244
1 74290100 1940388645
1 74290100 6890040894
1 10020890 1961429508
1 16020086 4617959289
1 17020086 396919444
1 18020086 396089119
1 20730023 397061349
1 30220190 397182624
1 33020190 398024644
1 36020186 398322827
1 37020090 399765609
1 38020090 399164157
1 44020090 439247806
1 48020086 444866102
1 21051275 2199698131
1 21452030 1730169503
1 21852310 8025506457
1 22150000 5530208739
1 25050180 7010929227
1 25050299 8483127919
1 60030000 6699474880
1 25050180 3110942666
1 10090603 6809781749
1 12090640 4002454750
1 20090602 7210217140
1 21090619 1027470495
1 23092620 1228815461
1 25090608 8630952710
1 26560625 1732413990
1 27090618 4942374129
1 28090633 6142546248
1 29090605 6251861018
1 30060601 6651107410
1 33060616 2568048185
1 35060632 2369766200
1 36060610 2974450892
1 37060615 8676481841
1 39060630 6781466658
1 40060614 2289193464
1 44060604 6140419125
1 50090607 6010184691
1 50890634 8461580493
1 51090636 1421938304
1 52090611 7082490560
1 53390635 6723607577
1 54690623 8794648706
1 55060831 4794009673
1 57060612 7185339057
1 59090626 5645223580
1 60090609 9846978754
1 66090621 5056416128
1 67090617 5177077220
1 68090622 9307636229
1 70090606 5508784396
1 75090629 6728795851
1 76090613 8815759822
1 77390628 5518653550
1 79090624 5025861563
1 10090603 5526276672
1 10090603 4437825343
1 12090640 1246318875
1 20090602 3746815534
1 21090619 8152232425
1 23092620 6358985655
1 25090608 6461757340
1 26560625 9965911924
1 27090618 1473613502
1 28090633 1970944813
1 29090605 8581719241
1 30060601 3188262382
1 33060616 2591066652
1 35060632 5921585995
1 36060610 5702530801
1 37060615 6122469426
1 39060630 1263584671
1 40060614 6793495041
1 44060604 3824729533
1 50090607 4644375461
1 50890634 5655140563
1 51090636 7625576451
1 52090611 6966444974
1 53390635 7416818196
1 54690623 2457829020
1 55060831 1227113841
1 57060612 3108740016
1 59090626 1268278261
1 60090609 6699864455
1 66090621 519855
1 67090617 423327
1 68090622 7650824982
1 70090606 1852919821
1 75090629 5709304930
1 76450000 3390037095
1 76450000 9804990720
1 76450000 462211479
1 76450000 286914581
1 76450000 1617223514
1 76450000 1451607873
1 76450000 2721704400
1 76450000 2726748740
1 76450000 3890120270
1 76450000 3337678858
1 76450000 4395487165
1 76450000 4608596462
1 76450000 5946310429
1 76450000 5583290536
1 76450000 6805518555
1 76450000 6917014737
1 76450000 7061997095
1 76450000 7603083966
1 76450000 8120212436
1 76450000 8965995264
1 53250000 1835292093
1 53250000 6825624684
1 53250000 3095710625
1 53250000 2084931722
1 53250000 8143329224
1 53250000 9199030449
1 53250000 9207912947
1 53250000 8333431180
1 53250000 8337917655
1 53250000 9498428343
1 53250000 6433721857
1 53250000 3543323083
1 53250000 4543361233
1 53250000 8699067274
1 53250000 3640440405
1 53250000 3744954268
1 53250000 9780530987
1 53250000 6915612680
1 21352240 2283236053
1 21352240 2016142628
1 21352240 6759028343
1 12096597 9309614966
1 12096597 8501057812
1 12096597 6812175592
1 12096597 2312639491
1 12096597 4026928218
1 12096597 7638522278
1 12096597 1833990982
1 12096597 4448998566
1 12096597 7144154231
1 12096597 1752091097
1 12096597 4055535387
1 12096597 5866966373
1 12096597 2964866347
1 12096597 6970730130
1 12096597 1373248518
1 12096597 8580336785
1 12096597 1903104916
1 12096597 4109043324
1 12096597 5412220036
1 12096597 7518190738
1 12096597 8529449430
1 12096597 7427825672
1 12096597 8236475198
1 12096597 5137623838
1 12096597 9644638151
1 12096597 8946621114
1 12096597 1553791977
1 12096597 4459921560
1 12096597 5568823213
1 12096597 5263286044
1 12096597 3871170950
1 12096597 9576691687
1 12096597 9887726748
1 12096597 4480699967
1 12096597 4690031830
1 12096597 2191351537
1 12096597 5691807978
1 12096597 9999583822
1 60651070 1024051034
1 60651070 6831021575
1 60651070 7247144662
1 25950001 9831077096
1 25950130 8201779433
1 25950001 2209300671
1 25950001 7206189838
1 54051660 796303002
1 56250030 903185172
1 54051660 1146743499
1 54051660 1799266777
1 56250030 2091315669
1 54051660 2144850687
1 54051660 3615732938
1 56250030 3797944863
1 54051660 4686999633
1 54051660 4115792204
1 56250030 5065200331
1 54051660 5133162010
1 54051660 6013162011
1 56250030 6917932713
1 54051660 7818019805
1 54051660 8911757873
1 56250030 8916234761
1 54051660 9737548702
1 54051660 9881747670
1 66090800 805527376
1 66090800 941579568
1 66090800 1409333991
1 66090800 1429490230
1 66090800 2170067075
1 66090800 2513067327
1 66090800 3886788696
1 66090800 3267561393
1 66090800 4857685840
1 66090800 4484012615
1 66090800 5423550117
1 66090800 5764326040
1 66090800 6870313599
1 66090800 6387553730
1 66090800 7679159550
1 66090800 7251191675
1 66090800 8982839393
1 66090800 8298201960
1 66090800 9982584610
1 66090800 9554220000
1 37050299 8243941481
1 37050299 132759366
1 37050299 718083371
1 37050299 1897596068
1 37050299 1012336655
1 37050299 2601422120
1 37050299 2789290810
1 37050299 3322433602
1 37050299 4090834500
1 37050299 4573040294
1 37050299 5142608784
1 37050299 6704768388
1 37050299 6717025008
1 37050299 7299640180
1 80053762 1144711130
1 80053762 1216232446
1 80053762 2021299549
1 80053762 2011899144
1 80053762 3227315504
1 80053762 3882531702
1 80053762 4318243015
1 80053762 5665247369
1 80053762 5970907016
1 80053762 6048675338
1 80053762 6818271624
1 80053762 7881259048
1 80053762 7751718271
1 80053762 8866273881
1 80053762 8897205764
1 80053762 9832086164
1 80053762 9696829563
1 80053762 269120149
1 80053762 269125442
1 80053762 269250859
1 80053762 269258272
1 80053762 269386017
1 80053762 269397124
1 80053762 269486160
1 80053762 269436197
1 80053762 269576410
1 80053762 269681060
1 80053762 269696792
1 80053762 269754458
1 80053762 269744827
1 80053762 269852417
1 80053762 269886834
1 80053762 269983090
1 80053762 269923969
1 80053762 643059209
1 80053772 244407070
1 80053782 668267099
1 50010700 1416569
1 50010700 1383094
1 50010700 2211828
1 50010700 2122278
1 50010700 3166147
1 50010700 3942488
1 50010700 4438056
1 50010700 4371890
1 50010700 5606337
1 50010700 5772917
1 50010700 764144123
1 50010700 729135074
1 50010700 827195088
1 50010700 862563637
1 10050000 8453705837
1 10050020 2933932892
1 10050000 9722242208
1 10050000 9484141045
2 10050020 5605932201
2 10050000 5124912560
2 10050000 5123614612
2 10050020 5263010642
2 10050000 5276819572
2 10050000 5320243413
2 10050020 5312455332
2 10050000 5433395980
2 10050000 5457685008
2 10050020 5510386389
2 10050000 5688529805
2 10050000 5642342433
2 10050020 5774648711
2 10050000 5703463549
2 10050000 5821417859
1 10050020 5896320210
2 10050000 5924828045
2 10050000 5969525346
2 10050020 9013563747
2 10050000 9018531669
2 10050000 9026325083
2 10050020 9022474022
2 10050000 9039234690
2 10050000 9040590508
2 10050020 9051748147
2 10050000 9050769597
2 10050000 9067693475
1 10050020 9066086462
2 10050000 9075819453
2 10050000 9086417004
1 10050020 9084697445
2 10050000 9096276351
2 10050000 9091008553
1 10050020 9103593225
2 10050000 9106313855
1 13051172 65023618
1 13051042 9652242346
1 14051462 5159012020
1 50010517 643717584
1 50010517 520108406
1 50010517 1729474118
1 50010517 1702555630
1 50010517 2915668195
1 50010517 2351951132
1 50010517 3813282480
1 50010517 3907375389
1 50010517 4062139385
1 50010517 4846901098
1 50010517 6380396519
1 50010517 6197345584
1 50010517 7177188353
1 50010517 8259787327
1 50010517 8350108964
1 50010517 9750865087
1 50010517 9623195800
1 50010517 5761799084
1 50010517 5332500055
1 21450000 9673657290
1 21450000 5376533145
1 21450000 6068219994
1 21450000 4312074752
1 20030400 675909949
1 20030400 563627561
1 20030400 1704682648
1 20030400 1936004967
1 20030400 2045811532
1 20030400 2824290478
1 20030400 3398232342
1 20030400 3712215940
1 20030400 4238234266
1 20030400 4728434053
1 20030400 5274891364
1 20030400 5712858264
1 20030400 6847394555
1 20030400 6800408137
1 20030400 7998450568
1 20030400 8878593188
1 20030400 8956178035
1 20030400 9275229156
1 20050000 148411
1 21050000 150961
1 23050000 213785
1 20050000 227579
1 20050000 381137
1 21050000 376822
1 23050000 461822
1 20050000 411645
1 20050000 557405
1 21050000 502963
1 23050000 667584
1 20050000 643189
1 20050000 769430
1 21050000 727859
1 23050000 813808
1 20050000 850024
1 20050000 102897043
1 21050000 132522738
1 23050000 270280575
1 20050000 212126240
1 20050000 311191286
1 21050000 340240084
1 23050000 404814275
1 20050000 454769205
1 20050000 536706713
1 21050000 533430862
1 23050000 646760033
1 20050000 765628803
1 20050000 769174030
1 21050000 885731632
1 23050000 874925513
1 20050000 1312129173
1 20050000 1052395805
1 21050000 4935947985
1 23050000 4096657079
1 20050000 5120638679
1 20050000 5903754186
1 21050000 6446123523
1 23050000 6760853678
1 20050000 9757432876
1 20050000 9892320490
1 21050000 3384856468
2 23050000 37051161
2 20050000 33907228
2 20050000 44834720
2 21050000 48443425
2 23050000 57104712
2 20050000 50589882
2 20050000 7050906052
2 21050000 7046454905
2 23050000 8567337860
2 20050000 8536137097
1 10050005 8570985242
1 10050005 8521278002
1 76026000 2324252
1 76026000 776218041
1 76026000 913798549
1 76026000 8209822653
1 76026000 7871293117
1 21750000 4248383277
1 21750000 7765094508
1 21750000 1024928868
1 21750000 7373071481
1 21750000 4092293372
1 59252046 7633150391
1 59252046 9256511453
1 59252046 9321122168
1 59252046 1465443150
1 86055592 7939761832
1 86055592 8270933776
2 86055592 5749952536
2 86055592 5737542941
1 10050006 138581243
1 10050006 587244459
1 10050006 1525831951
1 10050006 1815812315
1 10050006 2489385547
1 10050006 2472951495
1 10050006 3905696475
1 10050006 3232529688
1 10050006 4237602090
1 10050006 4091749458
1 10050006 5060947148
1 10050006 6600682799
1 10050006 6946936107
1 10050006 7088564889
1 10050006 7897786509
1 10050006 9562246918
1 10050006 9619978323
2 70120500 1174026
2 70120500 1153993
2 70120500 9766949
2 70120500 9121842
2 70120500 14370262
2 70120500 14861866
2 70120500 20782301
2 70120500 20409543
2 70120500 21209019
2 70120500 21103170
2 70120500 22618622
2 70120500 22232554
2 70120500 23486588
2 70120500 23684730
2 70120500 24811149
2 70120500 24638104
2 70120500 25021073
2 70120500 25398442
2 70120500 396008292
2 70120500 396797139
2 70120500 397144694
2 70120500 397385313
2 70120500 398190458
2 70120500 398853139
2 70120500 399863371
2 70120500 463467008
2 70120500 474651594
2 70120500 773050491
2 70120500 717730202
1 70120500 3293633656
1 70120500 8742787720
1 70120500 7450438077
1 70120500 4700820626
2 70120500 481459382
2 70120500 400675302
1 70120500 6349302159
1 70120500 6829506452
2 70120500 436899
2 70120500 616862
1 70120500 7350884
1 70120500 3533299
1 70120500 30710517
1 70120500 38768036
1 70120500 881989915
1 70120500 872775991
2 70120500 320424
2 70120500 647834
1 70120500 7778670
1 70120500 8278259
1 70120500 30264242
1 70120500 61085233
1 70120500 108192129
1 70120500 628810337
2 70120500 455858678
2 70120500 427203202
1 10050007 1098693608
1 10050007 1658726202
1 10050007 2093233572
1 10050007 2204009960
1 10050007 3698967127
1 10050007 3986400880
1 10050007 4627135943
1 10050007 4378689932
1 10050007 5898202387
1 10050007 5183786037
1 10050007 6440365334
1 10050007 6862684535
1 10050007 7749820672
1 10050007 7191184718
1 10050007 8763259060
1 10050007 8543470326
1 10050007 9901171654
1 10050007 9776989800
1 20690500 4999573997
1 20690500 7999593548
1 20690500 5484595858
1 20690500 1742653648
1 20690500 6893108004
1 20690500 9822558325
1 20690500 4783385166
1 20690500 1903272436
1 22151730 7695375179
1 22151730 8024662280
1 22151730 1513696424
1 22151730 9822229992
1 22151730 3300726079
1 22151730 6801455171
1 57020500 8078556605
1 57020500 4541473888
1 27020000 4858932561
1 27020001 8499896515
2 27020003 91070188
2 27020004 48697135
1 50120383 6189368787
1 50120383 2372002048
1 20120400 9912372483
1 20120400 1529105760
1 50131000 604455873
1 50131000 653816499
1 10050008 3918186155
1 59050101 9290701
1 59050101 539290858
1 59050101 1501824
1 59050101 1501832
1 59050101 9290708
1 59050101 539290854
1 59050101 1501823
1 59050101 1501831
1 59050101 2345678909
1 59050101 5678901237
0 59050101 0123456789
0 59050101 7414398260
0 59050101 0123456789
0 59050101 2345678901
0 59050101 5678901234
0 59050101 7414398260
