package # hide from PAUSE
App::YTDL::GetData;

use warnings;
use strict;
use 5.010000;

use Exporter qw( import );
our @EXPORT_OK = qw( get_yt_list_info get_vimeo_list_info get_new_video_url get_download_info
                     get_youtube_list_info );

use JSON                qw( decode_json );
use LWP::UserAgent      qw();
#use Mojo::DOM          qw(); # required
use Term::ANSIScreen    qw( :screen );
use Try::Tiny           qw( try catch );

use if $^O eq 'MSWin32', 'Win32::Console::ANSI';

use App::YTDL::DataExtract qw( json_to_hash );
use App::YTDL::Helper      qw( uni_capture HIDE_CURSOR SHOW_CURSOR );



sub get_yt_list_info {
    my ( $opt, $url ) = @_;
    my $show_progress = 1;
    my $ua = LWP::UserAgent->new(
        agent         => $opt->{useragent},
        timeout       => $opt->{timeout},
        show_progress => $show_progress
    );
    my $tmp;
    my $count = 0;

    RETRY: while ( 1 ) {
        my $ok = 1;
        try {
            $count++;
            my $res = $ua->get( $url );
            die $res->status_line, ': ', $url if ! $res->is_success;
            my $json = $res->decoded_content;
            $tmp = decode_json( $json );
            die $url . ' - error fetching youtube list info!' if ! defined $tmp || ! %$tmp;
        }
        catch {
            say "$count/$opt->{retries}  $_"; #
            return if $count == $opt->{retries};
            $ok = 0;
            sleep $opt->{retries} * 3;
        };
        return $tmp if $ok;
    }
}


sub get_youtube_list_info {
    my ( $opt, $url ) = @_;
    my $ua = LWP::UserAgent->new(
    #require File::Spec;
    #my $tmp_dir = File::Spec->catdir( File::Spec->tmpdir(), 'lwp' );
    #mkdir $tmp_dir or die $! if ! -d $tmp_dir;
    #require LWP::UserAgent::Cached;
    #my $ua = LWP::UserAgent::Cached->new(
    #    cache_dir     => $tmp_dir,

        agent         => $opt->{useragent},
        timeout       => $opt->{timeout},
        show_progress => 1
    );
    eval { require Mojo::DOM } or die $@;
    my $tmp = [];
    my $next;
    my $count = 0;

    RETRY: while ( 1 ) {
        my $ok = 1;
        try {
            $count++;
            my $res = $ua->get( $url );
            die $res->status_line, ': ', $url if ! $res->is_success;
            my $decoded_content = $res->decoded_content;
            my $date_sort = 0;
            my $dom = Mojo::DOM->new( $decoded_content );
            my $uploader = $dom->at( 'meta[itemprop="name"][content]' )->attr( 'content' );
            $dom->find( 'li[class="channels-content-item yt-shelf-grid-item"]' )
                ->each(
                    sub {
                        my $duration        = $_->at(  'span[class="video-time"] > span[title]' )->text;
                        my $title           = $_->at(  'h3[class="yt-lockup-title"] > a[class]' )->attr( 'title' );
                        my $video_id        = $_->at(  'h3[class="yt-lockup-title"] > a[class]' )->attr( 'href' );
                        my $view_count      = $_->find( 'ul[class="yt-lockup-meta-info"] > li' )->[0]->text;
                        my $upload_date_rel = $_->find( 'ul[class="yt-lockup-meta-info"] > li' )->[1]->text;
                        $duration =~ s/\.//g; ##
                        $video_id =~ s/^.+=(?=[^=]{11}\z)//;
                        $view_count =~ s/^(\S+)(?!\S).+\z/$1/; #
                        $view_count =~ s/[,.]//g;
                        if ( $duration =~ /^(?:\d\d?:){0,2}\d\d?\z/ ) {
                            my $seconds = 0;
                            my @u = ( 1, 60, 3600 );
                            my @parts = reverse split ':', $duration;
                            for my $i ( 0 .. $#parts ) {
                                $seconds += $parts[$i] * $u[$i];
                            }
                            $duration = $seconds if $seconds;
                        }
                        push @$tmp, {
                            date_sort       => ++$date_sort,
                            duration        => $duration,
                            video_id        => $video_id,
                            title           => $title,
                            uploader        => $uploader,
                            view_count      => $view_count,
                            upload_date_rel => $upload_date_rel,
                            webpage_url     => sprintf( 'https://www.youtube.com/watch?v=%s', $video_id ),
                        };
                    }
                );
        }
        catch {
            say "$count/$opt->{retries}  $_";
            return if $count == $opt->{retries};
            $ok = 0;
            sleep $opt->{retries} * 3;
        };
        return $tmp;
    }
}


sub get_vimeo_list_info {
    my ( $opt, $url ) = @_;
    my $ua = LWP::UserAgent->new(
        agent         => $opt->{useragent},
        timeout       => $opt->{timeout},
        show_progress => 1
    );
    eval { require Mojo::DOM } or die $@;
    my $tmp = [];
    my $next;
    my $count = 0;

    RETRY: while ( 1 ) {
        my $ok = 1;
        try {
            $count++;
            my $res = $ua->get( $url );
            die $res->status_line, ': ', $url if ! $res->is_success;
            my $decoded_content = $res->decoded_content;
            my $dom = Mojo::DOM->new( $decoded_content );
            my $uploader = $dom->at( 'a[class="user"]' )->text;
            $dom->find( 'div[id="browse_content"] > ol > li[id][data-position]' )
                ->each(
                    sub {
                        my $video_id    = $_->attr( 'id' );
                        my $title       = $_->at( 'a' )->attr( 'title' );
                        my $datetime    = $_->at( 'time' )->attr( 'datetime' );
                        $video_id =~ s/^clip_//;
                        push @$tmp, {
                            video_id    => $video_id,
                            title       => $title,
                            published   => $datetime,
                            uploader    => $uploader,
                            webpage_url => sprintf( 'https://vimeo.com/%s', $video_id ),
                        };
                    }
                );
            $next = $dom->at( 'a[rel="next"]' ) ? 1 : 0;
        }
        catch {
            say "$count/$opt->{retries}  $_";
            return if $count == $opt->{retries};
            $ok = 0;
            sleep $opt->{retries} * 3;
        };
        return $tmp, $next if $ok;
    }
}


sub get_new_video_url {
    my ( $opt, $info, $ex, $webpage_url, $fmt ) = @_;
    my @cmd = ( $opt->{youtube_dl} );
    push @cmd, '--user-agent', $opt->{useragent}    if defined $opt->{useragent};
    push @cmd, '--netrc'                            if $opt->{use_netrc};
    push @cmd, '--socket-timeout', $opt->{timeout};
    push @cmd, '--format', $fmt, '--get-url', '--', $webpage_url;
    my $video_url;
    try {
        $video_url = uni_capture( @cmd );
        die $webpage_url . ' - could not get new video url!' if ! $video_url;
    }
    catch {
        say $_;
        $video_url = undef;
    };
    return $video_url;
}


sub get_download_info {
    my ( $opt, $webpage_url, $message ) = @_;
    my @cmd = ( $opt->{youtube_dl} );
    push @cmd, '--user-agent', $opt->{useragent}    if defined $opt->{useragent};
    push @cmd, '--netrc'                            if $opt->{use_netrc};
    push @cmd, '--socket-timeout', $opt->{timeout};
    push @cmd, '--youtube-skip-dash-manifest';
    push @cmd, '--dump-json', '--', $webpage_url;
    my $json_all;
    my $count = 0;

    RETRY: while ( 1 ) {
        my $ok = 1;
        try {
            $count++;
            print HIDE_CURSOR;
            print $message . '...';
            $json_all = uni_capture( @cmd );
            print "\r", clline;
            print $message . "done.\n";
            print SHOW_CURSOR;
            die $webpage_url . ' - no JSON!' if ! $json_all;
        }
        catch {
            say "$count/$opt->{retries}  $webpage_url: $_"; #
            if ( $count == $opt->{retries} ) {
                push @{$opt->{error_get_download_infos}}, $webpage_url; # $ex
                return;
            }
            $ok = 0;
            print SHOW_CURSOR;
            sleep $opt->{retries} * 3;
        };
        last RETRY if $ok;
    }
    $opt->{up}++;
    my $tmp = json_to_hash( $opt, $json_all );
    return $tmp
}




1;


__END__
