#!perl -w

# Copyright 2011 Kevin Ryde

# This file is part of Math-Image.
#
# Math-Image is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by the
# Free Software Foundation; either version 3, or (at your option) any later
# version.
#
# Math-Image is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
# or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
# for more details.
#
# You should have received a copy of the GNU General Public License along
# with Math-Image.  If not, see <http://www.gnu.org/licenses/>.

use 5.004;
use strict;
use warnings;
use Data::Dumper;
use Module::Util;

use vars '$VERSION';
$VERSION = 50;

# uncomment this to run the ### lines
#use Smart::Comments;

my $outfilename = 'lib/App/MathImage/NumSeq/OeisCatalogue/Plugin/BuiltinTable.pm';

my %seen;
my $exit_code = 0;

my @info_arrayref;
my @classes = Module::Util::find_in_namespace('App::MathImage::NumSeq::Sequence');
@classes = sort @classes;
foreach my $class (@classes) {
  # next if $class =~ /^App::MathImage::NumSeq::Sequence::.*::/; # not sub-parts

  my $filename = Module::Util::find_installed($class) or die;
  open my $in, '<', $filename or die;
  while (<$in>) {
    chomp;
    my $where = "$filename:$.";
    my ($num, $parameters, $comment);
    if (/^# OeisCatalogue: /) {
      ### OeisCatalogue
      ($num, $parameters, $comment) = /^# OeisCatalogue: A0*([0-9]+)\s*(.*?)(#.*)?$/
        or die "$where: oops, bad OEIS line: $_";
    } elsif (/^use constant oeis\W/) {
      ### use constant
      ($num, $comment) = /^use constant oeis\s*=>\s*'?A?0*(\d+)().*?(#.*)?/
        or die "$where: oops, bad OEIS line: $_";
      $parameters = '';
    } else {
      next;
    }
    ### $num
    ### $parameters
    ### $comment

    $num or die "$where: oops, no OEIS number: $_";

    my @parameters = split /[,= \t]+/, $parameters;
    if (@parameters & 1) {
      die "Oops, odd number of  OEIS params: $_";
    }
    defined $class
      or die "$filename:$.: oops, no \"package\" line";
    if ($seen{$num}) {
      print STDERR "$where: duplicate of $num\n$seen{$num}: is here\n";
      $exit_code = 1;
      next;
    }
    $seen{$num} = $where;
    push @info_arrayref,
      {
       num => $num,
       class => $class,
       (scalar(@parameters) ? (parameters_hashref => {@parameters}) : ()),
      };
  }
  close $in or die;
}

my $dump = Data::Dumper->new([\@info_arrayref])->Sortkeys(1)->Terse(1)->Indent(1)->Dump;
# $dump =~ s/^{\n//;
# $dump =~ s/}.*\n//;

open my $out, '>', $outfilename
  or die "Cannot create $outfilename: $!";
print $out <<"HERE";
# Copyright 2011 Kevin Ryde

# Generated by make-oeis-catalogue.pl -- DO NOT EDIT

# This file is part of Math-Image.
#
# Math-Image is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by the
# Free Software Foundation; either version 3, or (at your option) any later
# version.
#
# Math-Image is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
# or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
# for more details.
#
# You should have received a copy of the GNU General Public License along
# with Math-Image.  If not, see <http://www.gnu.org/licenses/>.

package App::MathImage::NumSeq::OeisCatalogue::Plugin::BuiltinTable;
use strict;
use warnings;

use vars '\$VERSION', '\@ISA';
\$VERSION = $VERSION;
use App::MathImage::NumSeq::OeisCatalogue::Base;
\@ISA = ('App::MathImage::NumSeq::OeisCatalogue::Base');

use constant info_arrayref =>
HERE

print $out "$dump;\n1;\n__END__\n";
exit 0;
