use strict;
use warnings;
use utf8;

use Test::More tests => 12;

use String::Copyright;

is copyright("© 1999,2000 \n , 2001 ,2002, 2003 \nFoo"), '1999-2003 Foo',
	'comma list';
is copyright("© 1999,2000 \n  2001 ,2002, 2003 \nFoo"), '1999-2003 Foo',
	'non-comma list';
is copyright("© 1999-2000  , 2001 - 2002\n, 2003 Foo"), '1999-2003 Foo',
	'single-year ranges';
is copyright("© 1999-2000  , 2001\n - 2002\n, 2003 Foo"), '1999-2003 Foo',
	'range w/ newline before hyphen';
is copyright("© 1999,2000,2003,2005,2006 Foo"),
	'1999-2000, 2003, 2005-2006 Foo',
	'range non-range range';

TODO: {
	local $TODO = 'not yet handled';
	is copyright("© 1999-2000  , 2001 -\n 2002\n, 2003 Foo"),
		'1999-2003 Foo',
		'range w/ newline after hyphen';
}
is copyright("© 1999-2002\n, 2003 Foo"), '1999-2003 Foo',
	'multi-year ranges';

is copyright("© 1999-2000-2004-2005 Foo"), '1999-2005 Foo',
	'broken range - bogus multi-range';
TODO: {
	local $TODO = 'not yet handled';
	is copyright("© 1999-2000-2005-2004 Foo"), '1999-2000-2005-2004 Foo',
		'broken range - bogus multi-range wrong order';
	is copyright("© 1999,2000 \n - 2000 ,2002, 2003 \nFoo"),
		'1999-2000, 2002-2003 Foo', 'broken range - same year';
	is copyright("© 1999,2000 \n - 1999 ,2002, 2003 \nFoo"),
		'1999, 2000 - 1999, 2002-2003 Foo', 'broken range - earlier year';
}
is copyright("© 1999,2000  , 2001 ,200\n2, 2003 Foo"),
	'1999-2001 ,200 2, 2003 Foo', 'broken range - newline in year';
