/*
 * pdb.c
 *
 * CVS Info
 *    $Id: pdb.c,v 1.2 2002/06/07 01:31:57 josh Exp $
 * Overview:
 *    The Parrot debugger
 * History:
 *      Initial version by Daniel Grunblatt on 2002.5.19
 * Notes:
 * References:
 */

#include "parrot/embed.h"
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>

void PDB_printwelcome(void);

#define na(c) { \
    while(*c && !isspace(*c)) \
        c++; }

int
main(int argc, char *argv[])
{
    Parrot_Interp interpreter;
    char *filename;
    Parrot_PackFile pf;

    interpreter = Parrot_new();

    if (!interpreter) {
        return 1;
    }

    Parrot_init(interpreter);

    if (argc != 2) {
        fprintf(stderr, "Usage: pdb programfile\n");
        exit(1);
    }

    na(argv[0]);

    filename = &(*argv)[1];

    pf = Parrot_readbc(interpreter, filename);

    if (!pf) {
        return 1;
    }

    Parrot_loadbc(interpreter, pf);
    PDB_printwelcome();
    Parrot_debug(interpreter);
    Parrot_destroy(interpreter);

    return 0;
}

void
PDB_printwelcome()
{
    fprintf(stderr, "Parrot Debugger 0.0.1\n");
}

/*
 * Local variables:
 * c-indentation-style: bsd
 * c-basic-offset: 4
 * indent-tabs-mode: nil 
 * End:
 *
 * vim: expandtab shiftwidth=4:
 */
