=head1

Locale::CLDR::Locales::Brx - Package for language Bodo

=cut

package Locale::CLDR::Locales::Brx;
# This file auto generated from Data\common\main\brx.xml
#	on Sat  4 Aug 10:43:32 am GMT

use strict;
use warnings;
use version;

our $VERSION = version->declare('v0.33.0');

use v5.10.1;
use mro 'c3';
use utf8;
use if $^V ge v5.12.0, feature => 'unicode_strings';
use Types::Standard qw( Str Int HashRef ArrayRef CodeRef RegexpRef );
use Moo;

extends('Locale::CLDR::Locales::Root');
# Need to add code for Key type pattern
sub display_name_pattern {
	my ($self, $name, $region, $script, $variant) = @_;

	my $display_pattern = '{0} ({1})';
	$display_pattern =~s/\{0\}/$name/g;
	my $subtags = join '{0},{1}', grep {$_} (
		$region,
		$script,
		$variant,
	);

	$display_pattern =~s/\{1\}/$subtags/g;
	return $display_pattern;
}

has 'display_name_language' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub { 
		 sub {
			 my %languages = (
				'ab' => 'अब्खाज़ियन्',
 				'ace' => 'अचेहनी',
 				'ach' => 'अकोली',
 				'ada' => 'अडांगमे',
 				'ady' => 'अडीगे',
 				'ae' => 'अवस्तन्',
 				'af' => 'अफ्रीकी',
 				'afh' => 'अफ्रीहीली',
 				'ain' => 'ऐनू',
 				'ak' => 'अकन',
 				'akk' => 'अकाडिनी',
 				'ale' => 'अलुट',
 				'am' => 'अम्हारिक्',
 				'an' => 'आर्गोनी',
 				'ang' => 'पुरानी अंग्रेज़ी',
 				'anp' => 'अंगीका',
 				'ar' => 'अरबी',
 				'arc' => 'अरामाईक',
 				'arp' => 'अरापाहो',
 				'arw' => 'अरावाक',
 				'as' => 'असामी',
 				'av' => 'अवारिक्',
 				'awa' => 'अवधी',
 				'ay' => 'आयमारा',
 				'az' => 'अज़रबैजानी',
 				'ba' => 'बशख़िर्',
 				'bal' => 'बलूची',
 				'ban' => 'बालिनी',
 				'bas' => 'बास्क़्',
 				'be' => 'बैलोरूसियन्',
 				'bej' => 'बेजा',
 				'bem' => 'बेंबा',
 				'bg' => 'बल्गैरियन्',
 				'bho' => 'भोजपुरी',
 				'bi' => 'बिस्लामा',
 				'bik' => 'बिकोल्',
 				'bin' => 'बिनी',
 				'bla' => 'सीकसीका',
 				'bm' => 'बांबारा',
 				'bn' => 'बंगला',
 				'bo' => 'तिब्बती',
 				'br' => 'ब्रटों',
 				'bra' => 'ब्रज',
 				'brx' => 'बड़ो',
 				'bs' => 'बोस्नियाई',
 				'bua' => 'बुरियात',
 				'bug' => 'बुगीनी',
 				'byn' => 'ब्लीन',
 				'ca' => 'कातालान्',
 				'cad' => 'काद्दौ',
 				'car' => 'कारीब्',
 				'cch' => 'आत्सम',
 				'ce' => 'चेचेन्',
 				'ceb' => 'चेबुआनो',
 				'ch' => 'चामोरो',
 				'chb' => 'चीबचा',
 				'chg' => 'चगताई',
 				'chk' => 'चुकेसे',
 				'chm' => 'मारी',
 				'chn' => 'चीनूक् जार्गन्',
 				'cho' => 'चौक्टो',
 				'chp' => 'चिपेवियान्',
 				'chr' => 'चीरोकी',
 				'chy' => 'शायान्',
 				'co' => 'कोर्सीकन्',
 				'cop' => 'कॉप्टीक्',
 				'cr' => 'क्री',
 				'crh' => 'तुर्की क्रिमिया',
 				'cs' => 'चेक्',
 				'csb' => 'काशुबियान्',
 				'cu' => 'चर्च स्लाविक्',
 				'cv' => 'चुवाश्',
 				'cy' => 'वैल्श्',
 				'da' => 'डैनीश्',
 				'dak' => 'डकौटा',
 				'dar' => 'दर्गवा',
 				'de' => 'ज़र्मन',
 				'de_AT' => 'जर्मन (ऑस्ट्रिया)',
 				'de_CH' => 'उच्च स्तरिय स्वीस जर्मन',
 				'del' => 'दलावार्',
 				'den' => 'स्लेव्',
 				'dgr' => 'डोगरीब्',
 				'din' => 'डींगका',
 				'doi' => 'डोगरी',
 				'dsb' => 'सोर्बियन्',
 				'dua' => 'डुआला',
 				'dum' => 'मध्य डच',
 				'dv' => 'दीवेही',
 				'dyu' => 'द्युआला',
 				'dz' => 'भुटानी',
 				'ee' => 'एवे',
 				'efi' => 'एफीक्',
 				'egy' => 'प्राचीन मिस्री',
 				'eka' => 'एकाजुक',
 				'el' => 'ग्रीक',
 				'elx' => 'एलामी',
 				'en' => 'अंग्रेज़ी',
 				'en_AU' => 'अंग्रेज़ी (ऑस्ट्रेलिया का)',
 				'en_CA' => 'अंग्रेज़ी (कनाडाई)',
 				'en_GB' => 'अंग्रेजी (ब्रिटिश)',
 				'en_US' => 'अंग्रेज़ी (अमरिकी)',
 				'enm' => 'मध्य अंग्रेज़ी',
 				'eo' => 'एस्पेरान्तो',
 				'es' => 'स्पैनिश',
 				'es_419' => 'लैटिन अमरिकी स्पैनिश',
 				'es_ES' => 'ईवेरियाई स्पैनिश',
 				'et' => 'ऐस्टोनियन्',
 				'eu' => 'बास्क्',
 				'ewo' => 'एवौंडो',
 				'fa' => 'फार्सी',
 				'fan' => 'फाँग्',
 				'fat' => 'फाँटी',
 				'ff' => 'फुलाह्',
 				'fi' => 'फिनिश्',
 				'fil' => 'फिलिपिनो',
 				'fj' => 'फ़ीजी',
 				'fo' => 'फिरोज़ी',
 				'fon' => 'फोन',
 				'fr' => 'फ्रांसीसी',
 				'fr_CA' => 'फ्रांसीसी (कनाडाई)',
 				'fr_CH' => 'फ्रांसीसी (स्वीस)',
 				'frm' => 'मध्य फ्रांसीसी',
 				'fro' => 'पुरानी फ्रांसीसी',
 				'frr' => 'उत्तरी फ्रीज़ियन्',
 				'frs' => 'पूर्वी फ्रीज़ियन्',
 				'fur' => 'फ्रीउलीअन्',
 				'fy' => 'पश्चीमी फ्रीज़ियन्',
 				'ga' => 'आईरिश',
 				'gaa' => 'गा',
 				'gay' => 'गायो',
 				'gba' => 'ग्बाया',
 				'gd' => 'स्कॉट्स् गैलिक्',
 				'gez' => 'गीज़्',
 				'gil' => 'गीलबर्टी',
 				'gl' => 'गैलिशियन्',
 				'gmh' => 'मध्य उच्चस्तरी जर्मन',
 				'gn' => 'गुआरानी',
 				'goh' => 'पुरानी उच्चस्तरी जर्मन',
 				'gon' => 'गाँडी',
 				'gor' => 'गोरंटालो',
 				'got' => 'गॉथिक',
 				'grb' => 'ग्रेबो',
 				'grc' => 'प्राचीन यूनानी',
 				'gsw' => 'स्वीस जर्मन',
 				'gu' => 'गुजराती',
 				'gv' => 'मैंक्स',
 				'gwi' => 'ग्वीचलीन',
 				'ha' => 'हउसा',
 				'hai' => 'हईडा',
 				'haw' => 'हवाईअन',
 				'he' => 'हिब्रु',
 				'hi' => 'हिंदी',
 				'hil' => 'हीलीगैनोन',
 				'hit' => 'हीत्ती',
 				'hmn' => 'ह्मौंग',
 				'ho' => 'हीरी मोटु',
 				'hr' => 'क्रोएशन्',
 				'hsb' => 'ऊपरी सौर्बियन',
 				'ht' => 'हाईशीयन्',
 				'hu' => 'हंगैरीयन्',
 				'hup' => 'हूपा',
 				'hy' => 'अरमेनियन्',
 				'hz' => 'हेरेरो',
 				'ia' => 'ईन्टरलिंग्वा',
 				'iba' => 'ईबान्',
 				'id' => 'इन्डोनेशियन्',
 				'ie' => 'ईन्टरलिंग्वे',
 				'ig' => 'ईग्बो',
 				'ii' => 'सीचुआन् यी',
 				'ik' => 'इनुपियाक़्',
 				'ilo' => 'ईलोको',
 				'inh' => 'ईंगुष',
 				'io' => 'ईडो',
 				'is' => 'आईस्लैंडिक्',
 				'it' => 'ईटालियन्',
 				'iu' => 'इनूक्टीटूत्',
 				'ja' => 'जापानी',
 				'jbo' => 'लोजबान',
 				'jpr' => 'यहुदी फ़ारसी',
 				'jrb' => 'यहुदी अरबी',
 				'jv' => 'जावानीस',
 				'ka' => 'जॉर्जियन्',
 				'kaa' => 'कारा कलपक',
 				'kab' => 'काबील्',
 				'kac' => 'कचीन्',
 				'kaj' => 'जु',
 				'kam' => 'कंबा',
 				'kaw' => 'कावी',
 				'kbd' => 'कबार्डी भाषा',
 				'kcg' => 'त्याप्',
 				'kfo' => 'कोरो',
 				'kg' => 'कॉंगो',
 				'kha' => 'ख़ासी',
 				'kho' => 'ख़ोतानी',
 				'ki' => 'किकुयु',
 				'kj' => 'कुआनयामा',
 				'kk' => 'क़ज़ाख़्',
 				'kl' => 'कलालीसुत',
 				'km' => 'ख्मेर',
 				'kmb' => 'कींबुंडु',
 				'kn' => 'कन्नड्',
 				'ko' => 'कोरीयन्',
 				'kok' => 'कोंकणी',
 				'kos' => 'कोस्राईयन्',
 				'kpe' => 'क्पेले',
 				'kr' => 'कनुरी',
 				'krc' => 'कराचय् बलकार्',
 				'krl' => 'करेलियन्',
 				'kru' => 'कुरुख़्',
 				'ks' => 'कश्मिरी',
 				'ku' => 'कुर्दी',
 				'kum' => 'कुमीक्',
 				'kut' => 'कुतेनाई',
 				'kv' => 'कोमी',
 				'kw' => 'कौर्नवॉली',
 				'ky' => 'किरग़ीज़्',
 				'la' => 'लैटीन्',
 				'lad' => 'लाड़ीनो',
 				'lah' => 'लाह्डां',
 				'lam' => 'लांबा',
 				'lb' => 'लुक्समबुर्गी',
 				'lez' => 'लेज़गीयान',
 				'lg' => 'गांडा',
 				'li' => 'लींबुर्गी',
 				'ln' => 'लिंगाला',
 				'lo' => 'लाओसीयन्',
 				'lol' => 'मोंगो',
 				'loz' => 'लोज़ी',
 				'lt' => 'लिथुआनियन्',
 				'lu' => 'लुबा कटांगा',
 				'lua' => 'लुबा लुलुआ',
 				'lui' => 'लुईसेनो',
 				'lun' => 'लुंडा',
 				'luo' => 'लुओ',
 				'lus' => 'लुशाई',
 				'lv' => 'लाटवियन् (लैट्टीश)',
 				'mad' => 'मादुरी',
 				'mag' => 'मघी',
 				'mai' => 'मैथीली',
 				'mak' => 'मक्सर',
 				'man' => 'मांडींगो',
 				'mas' => 'मसाई',
 				'mdf' => 'मोक्षा',
 				'mdr' => 'मंदार',
 				'men' => 'मेंदे',
 				'mg' => 'मालागासी',
 				'mga' => 'मध्य आईरीश भाषा',
 				'mh' => 'मार्शली',
 				'mi' => 'माओरी',
 				'mic' => 'मीकमाक',
 				'min' => 'मिनंगकाबाउ',
 				'mk' => 'मैसेडोनियन्',
 				'ml' => 'मलयालम',
 				'mn' => 'मोंगोलियन',
 				'mnc' => 'मांचु',
 				'mni' => 'मणीपुरी',
 				'moh' => 'मोहोक',
 				'mos' => 'मोस्सी',
 				'mr' => 'मराठी',
 				'ms' => 'मलाय',
 				'mt' => 'मालटीज़्',
 				'mus' => 'क्रीक',
 				'mwl' => 'मीरांडी',
 				'mwr' => 'मारवाड़ी',
 				'my' => 'बर्मी',
 				'myv' => 'ऐर्ज़िया',
 				'na' => 'नाऊरू',
 				'nap' => 'नेआपोलिटन',
 				'nb' => 'नोर्वेगी बोकमाल',
 				'nd' => 'उत्तर न्दबेले',
 				'nds' => 'नीजी स्तरिय जर्मन',
 				'ne' => 'नेपाली',
 				'new' => 'नेवारी',
 				'ng' => 'न्डोंगा',
 				'nia' => 'नियास',
 				'niu' => 'नियुइआन',
 				'nl' => 'डच्',
 				'nl_BE' => 'फ्लेमी',
 				'nn' => 'नॉर्वेजियन् नीनॉर्स्क्',
 				'no' => 'नॉर्वेजीयन्',
 				'nog' => 'नोगाई',
 				'non' => 'पुरानी नॉर्स्',
 				'nqo' => 'न्गको',
 				'nr' => 'दक्षिणी न्दबेले',
 				'nv' => 'नावाहो',
 				'nwc' => 'पुरानी नेवारी',
 				'ny' => 'न्यानजा',
 				'nym' => 'न्यामवेज़ी',
 				'nyn' => 'न्यानकोले',
 				'nyo' => 'न्यौरो',
 				'nzi' => 'न्ज़ीमा',
 				'oc' => 'ओक्सीतान',
 				'oj' => 'ओहीबवा',
 				'om' => 'ओरोमो (अफ़ान)',
 				'or' => 'उड़िया',
 				'os' => 'ओस्सेटी',
 				'osa' => 'ओसेज',
 				'ota' => 'तुर्की ओटोमान',
 				'pa' => 'पंजाबी',
 				'pag' => 'पांगासीनन',
 				'pal' => 'पहलवी',
 				'pam' => 'पंपंगा',
 				'pap' => 'पापीआमेन्तो',
 				'pau' => 'पालाऊ',
 				'peo' => 'पुरानी फ़ारसी',
 				'phn' => 'फीनीसी',
 				'pi' => 'पाली',
 				'pl' => 'पोलिश',
 				'pon' => 'पोहनपी',
 				'pro' => 'पुरानी प्रोवाँसाल',
 				'ps' => 'पख़्तु',
 				'pt' => 'पुर्तगाली',
 				'qu' => 'क्वेचुआ',
 				'raj' => 'राजस्थानी',
 				'rap' => 'रापानुई',
 				'rar' => 'रारोटोंगा',
 				'rm' => 'रेह्टो-रोमान्स',
 				'rn' => 'किरून्दी',
 				'ro' => 'रूमानीयन्',
 				'ro_MD' => 'मोल्डेवियन्',
 				'rom' => 'रुमानी',
 				'root' => 'रुट',
 				'ru' => 'रुसी',
 				'rup' => 'आरोमानी',
 				'rw' => 'किन्यारुआण्डा',
 				'sa' => 'संस्कृत्',
 				'sad' => 'संडावे',
 				'sah' => 'यकुट्',
 				'sam' => 'समारीती आरामाईक़',
 				'sas' => 'सासक',
 				'sat' => 'संताली',
 				'sc' => 'सार्दीनी',
 				'scn' => 'सीसीलीअन',
 				'sco' => 'स्कॉट',
 				'sd' => 'सिंधी',
 				'se' => 'उत्तरी सामी',
 				'sel' => 'सेलकुप',
 				'sg' => 'सांग्रो',
 				'sga' => 'पुरानी आईरीश',
 				'sh' => 'सर्बो-क्रोएशन्',
 				'shn' => 'शान',
 				'si' => 'सींहाला',
 				'sid' => 'सीदामो',
 				'sk' => 'स्लोवाक्',
 				'sl' => 'स्लोवेनियन्',
 				'sm' => 'सामोअन',
 				'sma' => 'पश्चीमी सामी',
 				'smj' => 'लुले सामी',
 				'smn' => 'ईनारी सामी',
 				'sms' => 'स्कोल्ट् सामी',
 				'sn' => 'शोना',
 				'snk' => 'सोनिंगके',
 				'so' => 'सोमाली',
 				'sog' => 'सोगडीयन',
 				'sq' => 'आल्बेनियन्',
 				'sr' => 'सर्बियन्',
 				'srn' => 'स्रनान् टॉंगो',
 				'srr' => 'सेरेर',
 				'ss' => 'स्वाटि',
 				'su' => 'सुन्दानी',
 				'suk' => 'सुकुमा',
 				'sus' => 'सुसु',
 				'sux' => 'सुमेरिअन',
 				'sv' => 'स्वीडिश',
 				'sw' => 'स्वाहिली',
 				'syc' => 'पारंपरीक सिरिआक',
 				'syr' => 'सिरिआक',
 				'ta' => 'तमिळ',
 				'te' => 'तेलुगु',
 				'tem' => 'तीमने',
 				'ter' => 'तेरेनो',
 				'tet' => 'तेतुम',
 				'tg' => 'ताजिक्',
 				'th' => 'थाई',
 				'ti' => 'तिग्रीन्या',
 				'tig' => 'टीग्रे',
 				'tiv' => 'टीव्',
 				'tk' => 'तुर्कमेन',
 				'tkl' => 'टोकेलौ',
 				'tl' => 'तागालोग',
 				'tlh' => 'क्लींगदन',
 				'tli' => 'ट्लिंगीत',
 				'tmh' => 'तमाशेक',
 				'tn' => 'त्स्वाना',
 				'to' => 'टॉंगा',
 				'tog' => 'न्यासा टॉंगा',
 				'tpi' => 'तोक पिसीन',
 				'tr' => 'तुर्की',
 				'ts' => 'सोंगा',
 				'tsi' => 'त्सीमशीआन्',
 				'tt' => 'टाटर्',
 				'tum' => 'टुँबुका',
 				'tvl' => 'टुवालु',
 				'tw' => 'ट्वी',
 				'ty' => 'टाहिटि',
 				'tyv' => 'टुवी',
 				'udm' => 'उड़मुर्त',
 				'ug' => 'उईग़ुर',
 				'uga' => 'उगारिती',
 				'uk' => 'यूक्रेनियन्',
 				'umb' => 'उंबुंडु',
 				'und' => 'अज्ञात या अवैध भाषा',
 				'ur' => 'ऊर्दु',
 				'uz' => 'उज़बेक्',
 				'vai' => 'वाई',
 				've' => 'वेंडा',
 				'vi' => 'वियेतनामी',
 				'vo' => 'वोलापोक',
 				'vot' => 'वोटीक',
 				'wa' => 'वालुन',
 				'wal' => 'वालामो',
 				'war' => 'वारय',
 				'was' => 'वाशो',
 				'wo' => 'वोलोफ',
 				'xal' => 'कालमीक',
 				'xh' => 'ख़ोसा',
 				'yao' => 'याओ',
 				'yap' => 'यापीज़',
 				'yi' => 'यीद्दीश',
 				'yo' => 'योरूबा',
 				'za' => 'ज़ुआंग',
 				'zap' => 'ज़ापोतेक',
 				'zbl' => 'ब्लीस चिन्ह',
 				'zen' => 'ज़ेनागा',
 				'zh' => 'चीनी',
 				'zh_Hans' => 'चीनी (सरलीकृत)',
 				'zh_Hant' => 'चीनी (पारम्परिक)',
 				'zu' => 'ज़ुलू',
 				'zun' => 'ज़ुनी',
 				'zxx' => 'रिक्त',
 				'zza' => 'ज़ाज़ा',

			);
			if (@_) {
				return $languages{$_[0]};
			}
			return \%languages;
		}
	},
);

has 'display_name_script' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub {
		sub {
			my %scripts = (
			'Arab' => 'अरबी',
 			'Armi' => 'शहनशाही आरामाईक',
 			'Armn' => 'अर्मेनियाई',
 			'Avst' => 'अवस्तन्',
 			'Bali' => 'बाली',
 			'Batk' => 'बटकी',
 			'Beng' => 'बंगाली',
 			'Blis' => 'ब्लीस चीन्ह',
 			'Bopo' => 'बोपोमोफो',
 			'Brah' => 'ब्रह्मी',
 			'Brai' => 'ब्रेल',
 			'Bugi' => 'बुगीनी',
 			'Buhd' => 'बुहीद',
 			'Cans' => 'युनीफाईड कैनेडियन अबॉरीजीनल सीलैबीक्स',
 			'Cari' => 'कारियन',
 			'Cham' => 'कॅम',
 			'Cher' => 'चिरूकी',
 			'Cirt' => 'सिर्थ',
 			'Copt' => 'कॉप्ट',
 			'Cprt' => 'सीप्रीओट्',
 			'Cyrl' => 'सिरिलिक्',
 			'Cyrs' => 'पुरानी चर्च सिरिलिक्',
 			'Deva' => 'देवनागरी',
 			'Dsrt' => 'देसेरट्',
 			'Egyd' => 'मीस्री डैमोटीक्',
 			'Egyh' => 'मीस्री हैरैटीक्',
 			'Egyp' => 'मीस्री हैरोग्लीफ़्',
 			'Ethi' => 'ईथोपियाई',
 			'Geok' => 'जोर्जीयन खुतसुरी',
 			'Geor' => 'जोर्जीयन',
 			'Glag' => 'ग्लैगोलिटीक',
 			'Goth' => 'गौथीक',
 			'Grek' => 'ग्रीक',
 			'Gujr' => 'गुजराती',
 			'Guru' => 'गुरमुखी',
 			'Hang' => 'हंगुल',
 			'Hani' => 'हान',
 			'Hano' => 'हानुनु',
 			'Hans' => 'सरलीकृत हान',
 			'Hant' => 'पारम्परिक हान',
 			'Hebr' => 'हिब्रू',
 			'Hira' => 'हीरागाना',
 			'Hmng' => 'पाहवाह ह्मौंग',
 			'Hrkt' => 'काताकाना या हीरागाना',
 			'Hung' => 'पुरानी हंगैरीयन',
 			'Inds' => 'सिन्धु',
 			'Ital' => 'पुरानी इटैलियन',
 			'Java' => 'जावानीस',
 			'Jpan' => 'जापानी',
 			'Kali' => 'कायाह ली',
 			'Kana' => 'काताकाना',
 			'Khar' => 'खरोष्टी',
 			'Khmr' => 'ख्मेर',
 			'Knda' => 'कन्नड़',
 			'Kore' => 'कोरियाई',
 			'Lana' => 'लाना',
 			'Laoo' => 'लाओ',
 			'Latf' => 'फ्रैक्तुर लैटिन',
 			'Latg' => 'गैलीक लैटिन',
 			'Latn' => 'लैटिन',
 			'Lepc' => 'लेपचा',
 			'Limb' => 'लिम्बु',
 			'Lina' => 'लीनीयर ए',
 			'Linb' => 'लीनीयर बी',
 			'Lyci' => 'लीसीयन',
 			'Lydi' => 'लीडीयन',
 			'Mand' => 'मांडे',
 			'Mani' => 'मानीकी',
 			'Maya' => 'माया हीरोग्लीफ्',
 			'Mero' => 'मेरोईटीक्',
 			'Mlym' => 'मलयालम्',
 			'Mong' => 'मंगोलियाई',
 			'Moon' => 'मुन्',
 			'Mtei' => 'मेतेई मयेक',
 			'Mymr' => 'म्यानमार्',
 			'Nkoo' => 'न्गको',
 			'Ogam' => 'ओगहैम',
 			'Olck' => 'ओल चीकी',
 			'Orkh' => 'ओरखोन',
 			'Orya' => 'उड़िया',
 			'Osma' => 'ओस्मानिया',
 			'Perm' => 'पुरानी पर्मीक्',
 			'Phag' => 'फाग्स पा',
 			'Phlv' => 'बुक (सालटर) पहलवी',
 			'Phnx' => 'फोनीशीयन',
 			'Plrd' => 'पौलार्ड़ फोनेटीक',
 			'Rjng' => 'रेजेंग',
 			'Roro' => 'रोंगोरोंगो',
 			'Runr' => 'रूनिक',
 			'Samr' => 'समारती',
 			'Sara' => 'सराती',
 			'Saur' => 'सौराष्ट्र',
 			'Sgnw' => 'सांकेतिक लेख',
 			'Shaw' => 'शेवियन',
 			'Sinh' => 'सिंहाली',
 			'Sund' => 'सूडानी',
 			'Sylo' => 'सील्होटी नागरी',
 			'Syrc' => 'सीरीआक',
 			'Syre' => 'एस्ट्रांगलो सीरीआक',
 			'Syrj' => 'पश्चीमी सीरीआक',
 			'Syrn' => 'पूर्वी सीरीआक',
 			'Tagb' => 'तागबानवा',
 			'Tale' => 'ताई ले',
 			'Talu' => 'नया ताई लुए',
 			'Taml' => 'तमीळ',
 			'Telu' => 'तेलुगु',
 			'Teng' => 'तेंगवार',
 			'Tfng' => 'तीफीनाग़',
 			'Tglg' => 'टागालॉग',
 			'Thaa' => 'थाना',
 			'Thai' => 'थाई',
 			'Tibt' => 'तिब्बती',
 			'Ugar' => 'ऊगारीटीक',
 			'Vaii' => 'वाई',
 			'Visp' => 'वीज़ीबल बोली',
 			'Xpeo' => 'पुरानी फारसी',
 			'Xsux' => 'सुमेरो अक्काड़ी कुनेईफॉर्म',
 			'Yiii' => 'यी',
 			'Zinh' => 'विरासत',
 			'Zxxx' => 'अलिखित',
 			'Zyyy' => 'आम',
 			'Zzzz' => 'अज्ञात या अवैध लिपि',

			);
			if ( @_ ) {
				return $scripts{$_[0]};
			}
			return \%scripts;
		}
	}
);

has 'display_name_region' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { 
		{
			'001' => 'दुनिया',
 			'002' => 'अफ्रीका',
 			'003' => 'उत्तर अमरिका',
 			'005' => 'दक्षिण अमरिका',
 			'009' => 'ओशेआनिया',
 			'011' => 'पश्चिमी अफ्रीका',
 			'013' => 'मध्य अमरिका',
 			'014' => 'पूर्वी अफ्रीका',
 			'015' => 'उत्तरी अफ्रीका',
 			'017' => 'मध्य अफ्रीका',
 			'018' => 'दक्षिणी अफ्रीका',
 			'019' => 'अमरिकाज़्',
 			'021' => 'उत्तरी अमरिका',
 			'029' => 'कैरिबियन',
 			'030' => 'पूर्वी एशिया',
 			'034' => 'दक्षिणी एशिया',
 			'035' => 'दक्षिण-पूर्वी एशिया',
 			'039' => 'दक्षिणी यूरोप',
 			'053' => 'ऑस्ट्रेलिया एवं न्यूजीलैंड',
 			'054' => 'मेलीनेशिया',
 			'057' => 'माईक्रोनेशिया',
 			'061' => 'पोलीनेशिया',
 			'142' => 'एशिया',
 			'143' => 'मध्य एशिया',
 			'145' => 'पश्चिमी ऐशिया',
 			'150' => 'यूरोप',
 			'151' => 'पूर्वी यूरोप',
 			'154' => 'उत्तरी यूरोप',
 			'155' => 'पश्चिमी यूरोप्',
 			'419' => 'लैटिन अमरिका एवं करीबी',
 			'AD' => 'ऍन्डोरा',
 			'AE' => 'संयुक्त अरब अमीरात',
 			'AF' => 'अफ़ग़ानिस्तान',
 			'AG' => 'एन्टिगुआ एवं बारबूडा',
 			'AI' => 'एंगीला',
 			'AL' => 'अल्बानिया',
 			'AM' => 'आर्मेनिया',
 			'AO' => 'अंगोला',
 			'AQ' => 'अंटार्कटिका',
 			'AR' => 'अर्जेण्टिना',
 			'AS' => 'अमरिकी समोआ',
 			'AT' => 'ऑस्ट्रिया',
 			'AU' => 'ऑस्ट्रेलिया',
 			'AW' => 'अरूबा',
 			'AX' => 'आलाँड द्वीप',
 			'AZ' => 'अज़रबैजान',
 			'BA' => 'बोसनिया हर्ज़ेगोविना',
 			'BB' => 'बारबाडोस',
 			'BD' => 'बंगलादेश',
 			'BE' => 'बेल्जियम',
 			'BF' => 'बुर्किना फासो',
 			'BG' => 'बल्गैरिया',
 			'BH' => 'बहरैन',
 			'BI' => 'बुरुंडी',
 			'BJ' => 'बेनेँ',
 			'BL' => 'सेँ बार्थेलेमी',
 			'BM' => 'बरमूडा',
 			'BN' => 'ब्रूनइ',
 			'BO' => 'बोलीविया',
 			'BR' => 'ब्राज़ील',
 			'BS' => 'बहामा',
 			'BT' => 'भूटान',
 			'BV' => 'बुवे द्वीप',
 			'BW' => 'बोत्स्वाना',
 			'BY' => 'बेलारूस',
 			'BZ' => 'बेलिज़',
 			'CA' => 'कैनाडा',
 			'CC' => 'कोकोस द्वीप',
 			'CD' => 'कॉंगो किनशासा',
 			'CF' => 'सेंट्रल अफ्रीकन रिपब्लिक',
 			'CG' => 'कॉंगो ब्राज़्ज़ावील',
 			'CH' => 'स्वित्ज़रलैंड',
 			'CI' => 'आईवरी कोस्ट',
 			'CK' => 'कुक द्वीप',
 			'CL' => 'चिली',
 			'CM' => 'कोमेरान',
 			'CN' => 'चीन',
 			'CO' => 'कोलम्बिया',
 			'CR' => 'कोस्टारीका',
 			'CU' => 'क्यूबा',
 			'CV' => 'कैप वेर्दे',
 			'CX' => 'क्रिस्मस द्वीप',
 			'CY' => 'साइप्रस',
 			'CZ' => 'चेक गणराज्य',
 			'DE' => 'जर्मनी',
 			'DJ' => 'द्जिबूती',
 			'DK' => 'डेनमार्क',
 			'DM' => 'डोमिनिका',
 			'DO' => 'डोमिनिकन गणराज्य',
 			'DZ' => 'अल्जीरिया',
 			'EC' => 'एक्वाडोर',
 			'EE' => 'एस्टोनिया',
 			'EG' => 'मिस्र',
 			'EH' => 'पश्चिमी सहारा',
 			'ER' => 'एरिट्रिया',
 			'ES' => 'स्पेन',
 			'ET' => 'इथिओपिया',
 			'EU' => 'यूरोपीय संघ',
 			'FI' => 'फिनलैंड',
 			'FJ' => 'फिजी',
 			'FK' => 'फ़ॉल्कलैंड द्वीप',
 			'FM' => 'माइक्रोनेशिया',
 			'FO' => 'फरो द्वीप',
 			'FR' => 'फ्राँस',
 			'GA' => 'गैबॉन',
 			'GB' => 'ब्रितन',
 			'GD' => 'ग्रेनडा',
 			'GE' => 'जॉर्जिया',
 			'GF' => 'फ्राँसीसी गिआना',
 			'GG' => 'गेर्नसे',
 			'GH' => 'घाना',
 			'GI' => 'जिब्राल्टर',
 			'GL' => 'ग्रीनलैण्ड',
 			'GM' => 'गाम्बिया',
 			'GN' => 'गिनी',
 			'GP' => 'ग्वादलुप',
 			'GQ' => 'इक्वेटोरियल गिनी',
 			'GR' => 'ग्रीस',
 			'GS' => 'दक्षिण जोर्जिया एवं दक्षिण सैंडवीच द्वीप',
 			'GT' => 'गोतेदाला',
 			'GU' => 'गुआम',
 			'GW' => 'गीनी-बिसाउ',
 			'GY' => 'गुयाना',
 			'HK' => 'हाँगकाँग विशेष प्रशासनिक क्षेत्र चीन',
 			'HM' => 'हर्ड द्वीप एवं मैकडोनॉल्ड द्वीप',
 			'HN' => 'हौण्डूरास',
 			'HR' => 'क्रोएशिया',
 			'HT' => 'हाइती',
 			'HU' => 'हंगरी',
 			'ID' => 'इंडोनेशिया',
 			'IE' => 'आयरलैंड',
 			'IL' => 'इस्राइल',
 			'IM' => 'आईल ऑफ़ मैन',
 			'IN' => 'भारत',
 			'IO' => 'ब्रिटिश हिंद महासागरिय क्षेत्र',
 			'IQ' => 'ईराक़',
 			'IR' => 'ईरान',
 			'IS' => 'आइसलैंड',
 			'IT' => 'इटली',
 			'JE' => 'जर्सी',
 			'JM' => 'जमाइका',
 			'JO' => 'जॉर्डन',
 			'JP' => 'जापान',
 			'KE' => 'केन्या',
 			'KG' => 'किर्गिज़',
 			'KH' => 'कम्बोडिया',
 			'KI' => 'किरिबाती',
 			'KM' => 'कोमोरोज़',
 			'KN' => 'सेंट किट्स एवं नेविस',
 			'KP' => 'उत्तर कोरिया',
 			'KR' => 'दक्षिण कोरिया',
 			'KW' => 'कुवैत',
 			'KY' => 'केमैन द्वीप',
 			'KZ' => 'कज़ाखस्तान',
 			'LA' => 'लाओस',
 			'LB' => 'लेबनोन',
 			'LC' => 'सेंट लूसिया',
 			'LI' => 'लिक्टैनस्टाईन',
 			'LK' => 'श्री लँका',
 			'LR' => 'लाइबेरिया',
 			'LS' => 'लसोथो',
 			'LT' => 'लिथुआनिया',
 			'LU' => 'लक्समबर्ग',
 			'LV' => 'लाट्वीया',
 			'LY' => 'लीबिया',
 			'MA' => 'मोरोक्को',
 			'MC' => 'मोनाको',
 			'MD' => 'मोल्डेविया',
 			'ME' => 'मोंटेनेग्रो',
 			'MF' => 'सेँ मार्टेँ',
 			'MG' => 'मदागास्कर',
 			'MH' => 'मार्शल द्वीप',
 			'MK' => 'मैसेडोनिया',
 			'ML' => 'माली',
 			'MM' => 'म्यानमार',
 			'MN' => 'मंगोलिया',
 			'MO' => 'मकाओ विशेष प्रशासनिक क्षेत्र (चीन)',
 			'MP' => 'उत्तरी मारियाना द्वीप',
 			'MQ' => 'मार्टीनिक',
 			'MR' => 'मॉरिटेनिया',
 			'MS' => 'मॉंसेरा',
 			'MT' => 'माल्टा',
 			'MU' => 'मॉरिस',
 			'MV' => 'मालदीव',
 			'MW' => 'मलावी',
 			'MX' => 'मैक्सिको',
 			'MY' => 'मलेशिया',
 			'MZ' => 'मोज़ाम्बिक',
 			'NA' => 'नामीबिया',
 			'NC' => 'न्यू कैलेडोनिया',
 			'NE' => 'नाइजेर',
 			'NF' => 'नॉरफ़ॉक द्वीप',
 			'NG' => 'नाइजीरिया',
 			'NI' => 'निकारागुआ',
 			'NL' => 'नेदरलैण्ड',
 			'NO' => 'नॉर्वे',
 			'NP' => 'नेपाल',
 			'NR' => 'नाउरू',
 			'NU' => 'नीयूए',
 			'NZ' => 'न्यूज़ीलैंड',
 			'OM' => 'ओमान',
 			'PA' => 'पनामा',
 			'PE' => 'पेरू',
 			'PF' => 'फ्राँसीसी पॉलिनीशिया',
 			'PG' => 'पापुआ न्यू गिनी',
 			'PH' => 'फिलीपिन्स',
 			'PK' => 'पाकिस्तान',
 			'PL' => 'पोलैण्ड',
 			'PM' => 'सेँ पीएर एवं मि‍केलॉं',
 			'PN' => 'पिटकेर्न',
 			'PR' => 'पुएर्टो रीको',
 			'PS' => 'फ़िलिस्तीन',
 			'PT' => 'पुर्तगाल',
 			'PW' => 'पलाऊ',
 			'PY' => 'पारागुए',
 			'QA' => 'क़तार',
 			'QO' => 'बाहरिय ओशेआनिया',
 			'RE' => 'रेयूनियॉं',
 			'RO' => 'रोमानिया',
 			'RS' => 'सर्बिया',
 			'RU' => 'रूस',
 			'RW' => 'रूआण्डा',
 			'SA' => 'सऊदी अरब',
 			'SB' => 'सॉलोमन द्वीप',
 			'SC' => 'सेशेल्स',
 			'SD' => 'सूदान',
 			'SE' => 'स्वीडन',
 			'SG' => 'सिंगापुर',
 			'SH' => 'सेण्‍ट हेलेना',
 			'SI' => 'स्लोवेनिया',
 			'SJ' => 'स्वाल्बार्ड एवं यान मायेन',
 			'SK' => 'स्लोवाकिया',
 			'SL' => 'सियेरा लेओन',
 			'SM' => 'सैन मरीनो',
 			'SN' => 'सेनेगाल',
 			'SO' => 'सोमालिया',
 			'SR' => 'सुरिनाम',
 			'ST' => 'साउँ-तोमे एवं प्रिंसिप',
 			'SV' => 'ऍल साल्वाडोर',
 			'SY' => 'सीरिया',
 			'SZ' => 'स्वाज़ीलैंड',
 			'TC' => 'तुर्की एवं कैकोज़ द्वीप',
 			'TD' => 'चाड',
 			'TF' => 'फ्राँसीसी उत्तरी क्षेत्रों',
 			'TG' => 'टोगो',
 			'TH' => 'थाइलैण्ड',
 			'TJ' => 'ताजिकिस्तान',
 			'TK' => 'टोकेलौ',
 			'TL' => 'पूर्वी तिमोर',
 			'TM' => 'तुर्कमेनीस्तान',
 			'TN' => 'त्युनिशिया',
 			'TO' => 'टॉंगा',
 			'TR' => 'तुर्की',
 			'TT' => 'ट्रिनिडाड एवं टोबैगो',
 			'TV' => 'तुवालु',
 			'TW' => 'ताइवान',
 			'TZ' => 'तंज़ानिया',
 			'UA' => 'यूक्रेन',
 			'UG' => 'युगाँडा',
 			'UM' => 'युनाइटेड स्टेट्स के छोटे बाहरिय द्वीप',
 			'US' => 'संयुक्त राज्य अमरिका',
 			'UY' => 'युरूगुए',
 			'UZ' => 'उज़बेकिस्तान',
 			'VA' => 'वैटिकन',
 			'VC' => 'सेंट विंसंट एवं दी ग्रनाडीन्स्',
 			'VE' => 'वेनेज़ुएला',
 			'VG' => 'ब्रिटिश वर्जीन आईलंड्स',
 			'VI' => 'यु.एस. वर्जीन आईलंड्स',
 			'VN' => 'वियतनाम',
 			'VU' => 'वानाऊटु',
 			'WF' => 'वॉलेस एवं फ़्यूचूना',
 			'WS' => 'समोआ',
 			'YE' => 'यमन',
 			'YT' => 'मैयौट',
 			'ZA' => 'दक्षिण अफ्रीका',
 			'ZM' => 'ज़ाम्बिया',
 			'ZW' => 'ज़ीम्बाब्वे',
 			'ZZ' => 'अज्ञात या अवैध प्रदेश',

		}
	},
);

has 'display_name_variant' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { 
		{
			'1901' => 'पारम्पारिक जर्मन वर्तनी 1901',
 			'1994' => 'पारम्पारिक रेसीयन वर्तनी 1994',
 			'1996' => 'जर्मन वर्तनी 1996',
 			'1606NICT' => 'मध्य फ्रांसीसी 1606 तक',
 			'AREVELA' => 'पूर्वी अर्मेनियाई',
 			'BAKU1926' => 'युनीफाईड तुर्की लैटीनी वर्तनी',
 			'BISKE' => 'सान जीओर्जीओ / बीला डायलेक्ट',
 			'BOONT' => 'बुन्तलींग',
 			'FONIPA' => 'आईपीए फ़ोनेटीक्स',
 			'FONUPA' => 'युपीए फ़ोनेटीक्स',
 			'LIPAW' => 'रेज़ीयन की लीपोवाज़ डायलेक्ट',
 			'MONOTON' => 'एकस्वरीय',
 			'NEDIS' => 'नाटीसोन डायलेक्ट',
 			'NJIVA' => 'ग्नीवा या न्जीवा डायलेक्ट',
 			'OSOJS' => 'ओसेआको ओसोजाने डायलेक्ट',
 			'POLYTON' => 'बहुस्वरीय',
 			'POSIX' => 'कम्प्यूटर',
 			'REVISED' => 'संशोधित वर्तनी',
 			'ROZAJ' => 'रेज़ीयन',
 			'SAAHO' => 'साहो',
 			'SCOTLAND' => 'मानक स्कॉट अंग्रेज़ी',
 			'SCOUSE' => 'स्काउज़',
 			'SOLBA' => 'श्टोलविज़्ज़ा या सोलबीका डायलेक्ट',
 			'TARASK' => 'तारास्कीएवीचा वर्तनी',

		}
	},
);

has 'display_name_key' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { 
		{
			'calendar' => 'पंचाग',
 			'collation' => 'वर्गीकरण',
 			'currency' => 'मुद्रा',

		}
	},
);

has 'display_name_type' => (
	is			=> 'ro',
	isa			=> HashRef[HashRef[Str]],
	init_arg	=> undef,
	default		=> sub {
		{
			'calendar' => {
 				'buddhist' => q{बौद्ध पंचांग},
 				'chinese' => q{चीनी पंचांग},
 				'gregorian' => q{ग्रेगरीअन पंचांग},
 				'hebrew' => q{यहुदी पंचांग},
 				'islamic' => q{इस्लामी पंचांग},
 				'islamic-civil' => q{इस्लामी नागरिक पंचांग},
 				'japanese' => q{जापानी पंचांग},
 				'roc' => q{चीनी गणतंत्र पंचांग},
 			},
 			'collation' => {
 				'big5han' => q{पारम्पारिक चीनी वर्गीकरण बीग फ़ाईव},
 				'gb2312han' => q{सरलीकृत चीनी वर्गीकरण जीबी2312},
 				'phonebook' => q{दूरभाष निर्देशिका वर्गीकरण},
 				'pinyin' => q{पिनयीन वर्गीकरण},
 				'stroke' => q{स्ट्रोक वर्गीकरण},
 				'traditional' => q{पारम्पारिक वर्गीकरण},
 			},

		}
	},
);

has 'display_name_measurement_system' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { 
		{
			'metric' => q{मिथार खिलमिथार},
 			'US' => q{यु.एस},

		}
	},
);

has 'display_name_code_patterns' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { 
		{
			'script' => 'देवनागरी: {0}',
 			'region' => 'क्षेत्र:भारत {0}',

		}
	},
);

has 'characters' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> $^V ge v5.18.0
	? eval <<'EOT'
	sub {
		no warnings 'experimental::regex_sets';
		return {
			auxiliary => qr{[‌‍]},
			index => ['अ', 'आ', 'इ', 'ई', 'उ', 'ऊ', 'ऍ', 'ए', 'ऐ', 'ऑ', 'ओ', 'औ', 'क', 'ख', 'ग', 'घ', 'च', 'छ', 'ज', 'झ', 'ञ', 'ट', 'ठ', 'ड', '{ड\u093C}', 'ढ', 'ण', 'त', 'थ', 'द', 'ध', 'न', 'प', 'फ', 'ब', 'भ', 'म', 'य', 'र', 'ल', 'ळ', 'व', 'श', 'ष', 'स', 'ह'],
			main => qr{[़ ँ ं अ आ इ ई उ ऊ ऍ ए ऐ ऑ ओ औ क ख ग घ च छ ज झ ञ ट ठ ड {ड़} ढ ण त थ द ध न प फ ब भ म य र ल ळ व श ष स ह ा ि ी ु ू ृ ॅ े ै ॉ ो ौ ्]},
			numbers => qr{[\- , . % ‰ + 0 1 2 3 4 5 6 7 8 9]},
		};
	},
EOT
: sub {
		return { index => ['अ', 'आ', 'इ', 'ई', 'उ', 'ऊ', 'ऍ', 'ए', 'ऐ', 'ऑ', 'ओ', 'औ', 'क', 'ख', 'ग', 'घ', 'च', 'छ', 'ज', 'झ', 'ञ', 'ट', 'ठ', 'ड', '{ड\u093C}', 'ढ', 'ण', 'त', 'थ', 'द', 'ध', 'न', 'प', 'फ', 'ब', 'भ', 'म', 'य', 'र', 'ल', 'ळ', 'व', 'श', 'ष', 'स', 'ह'], };
},
);


has 'quote_start' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{“},
);

has 'quote_end' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{”},
);

has 'alternate_quote_start' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{‘},
);

has 'alternate_quote_end' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{’},
);

has 'units' => (
	is			=> 'ro',
	isa			=> HashRef[HashRef[HashRef[Str]]],
	init_arg	=> undef,
	default		=> sub { {
				'long' => {
					'day' => {
						'name' => q(सान),
						'one' => q({0} सान),
						'other' => q({0} सान),
					},
					'hour' => {
						'name' => q(घंटे),
						'one' => q({0} रिंगा),
						'other' => q({0} घंटे),
					},
					'minute' => {
						'name' => q(मिन.),
						'one' => q({0} मिन.),
						'other' => q({0} मिन.),
					},
					'month' => {
						'name' => q(महीने),
						'one' => q({0} महीना),
						'other' => q({0} महीने),
					},
					'second' => {
						'name' => q(सेकं.),
						'one' => q({0} सेकं.),
						'other' => q({0} सेकं.),
					},
					'week' => {
						'name' => q(सप्ताह),
						'one' => q({0} सप्ताह),
						'other' => q({0} सप्ताह),
					},
					'year' => {
						'name' => q(साल),
						'one' => q({0} साल),
						'other' => q({0} साल),
					},
				},
				'short' => {
					'day' => {
						'name' => q(सान),
					},
					'hour' => {
						'name' => q(घंटे),
					},
					'minute' => {
						'name' => q(मिन.),
					},
					'month' => {
						'name' => q(महीने),
					},
					'second' => {
						'name' => q(सेकं.),
					},
					'week' => {
						'name' => q(सप्ताह),
					},
					'year' => {
						'name' => q(साल),
					},
				},
			} }
);

has 'yesstr' => (
	is			=> 'ro',
	isa			=> RegexpRef,
	init_arg	=> undef,
	default		=> sub { qr'^(?i:हाँ|yes|y)$' }
);

has 'nostr' => (
	is			=> 'ro',
	isa			=> RegexpRef,
	init_arg	=> undef,
	default		=> sub { qr'^(?i:नहीं|no|n)$' }
);

has 'default_numbering_system' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> 'latn',
);

has native_numbering_system => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> 'deva',
);

has 'number_symbols' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'latn' => {
			'decimal' => q(.),
			'exponential' => q(E),
			'group' => q(,),
			'infinity' => q(∞),
			'list' => q(;),
			'minusSign' => q(-),
			'nan' => q(NaN),
			'perMille' => q(‰),
			'percentSign' => q(%),
			'plusSign' => q(+),
		},
	} }
);

has 'number_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		decimalFormat => {
			'default' => {
				'standard' => {
					'default' => '#,##,##0.###',
				},
			},
		},
		percentFormat => {
			'default' => {
				'standard' => {
					'default' => '#,##,##0%',
				},
			},
		},
		scientificFormat => {
			'default' => {
				'standard' => {
					'default' => '#E0',
				},
			},
		},
} },
);

has 'number_currency_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'latn' => {
			'pattern' => {
				'default' => {
					'standard' => {
						'positive' => '¤ #,##,##0.00',
					},
				},
			},
		},
} },
);

has 'currencies' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'ADP' => {
			display_name => {
				'currency' => q(ऐन्डोरा का पेसेता),
			},
		},
		'AED' => {
			display_name => {
				'currency' => q(संयुक्त अरब अमीरात का दिर्हाम),
			},
		},
		'AFA' => {
			display_name => {
				'currency' => q(अफ़ग़ानी 1927–2002),
			},
		},
		'AFN' => {
			display_name => {
				'currency' => q(अफ़ग़ानी),
			},
		},
		'ALL' => {
			display_name => {
				'currency' => q(आल्बेनिया का लेक),
			},
		},
		'AMD' => {
			display_name => {
				'currency' => q(आरमिनियाई दिर्हाम),
			},
		},
		'ANG' => {
			display_name => {
				'currency' => q(नेदरलैण्ड एन्टीलीज़ का गील्डर),
			},
		},
		'AOA' => {
			display_name => {
				'currency' => q(एंगोला क्वानज़ा),
			},
		},
		'AOK' => {
			display_name => {
				'currency' => q(एंगोला क्वानज़ा \(1977–1990\)),
			},
		},
		'AON' => {
			display_name => {
				'currency' => q(एंगोला नया क्वानज़ा \(1990–20000\)),
			},
		},
		'AOR' => {
			display_name => {
				'currency' => q(एंगोला क्वानज़ा सुधारीत \(1995–1999\)),
			},
		},
		'ARA' => {
			display_name => {
				'currency' => q(अर्जेण्टीनी ओस्ट्राल),
			},
		},
		'ARP' => {
			display_name => {
				'currency' => q(अर्जेण्टीनी पेसो \(1983–1985\)),
			},
		},
		'ARS' => {
			display_name => {
				'currency' => q(अर्जेण्टीनी पेसो),
			},
		},
		'ATS' => {
			display_name => {
				'currency' => q(ऑस्ट्रियन शीलींग),
			},
		},
		'AUD' => {
			display_name => {
				'currency' => q(ऑस्ट्रेलियन डॉलर),
			},
		},
		'AWG' => {
			display_name => {
				'currency' => q(अरुबा गील्डर),
			},
		},
		'AZM' => {
			display_name => {
				'currency' => q(आज़रबैजानी मनात \(1993–2006\)),
			},
		},
		'AZN' => {
			display_name => {
				'currency' => q(आज़रबैजानी मनात),
			},
		},
		'BAD' => {
			display_name => {
				'currency' => q(बोसनिया हेर्ज़ेगोविना का दीनार),
			},
		},
		'BAM' => {
			display_name => {
				'currency' => q(बोसनिया हेर्ज़ेगोविना कनवर्टीबल मार्क),
			},
		},
		'BBD' => {
			display_name => {
				'currency' => q(बारबादोस डॉलर),
			},
		},
		'BDT' => {
			display_name => {
				'currency' => q(बांगलादेश टका),
			},
		},
		'BEC' => {
			display_name => {
				'currency' => q(बेल्जियन फ्राँ कनवर्टीबल),
			},
		},
		'BEF' => {
			display_name => {
				'currency' => q(बेल्जियन फ्राँ),
			},
		},
		'BEL' => {
			display_name => {
				'currency' => q(बेल्जियन फ्राँ फिनानसीयल \(वित्तीय\)),
			},
		},
		'BGL' => {
			display_name => {
				'currency' => q(बल्गेरियाई हार्ड लेव),
			},
		},
		'BGN' => {
			display_name => {
				'currency' => q(बल्गेरियाई लेव),
			},
		},
		'BHD' => {
			display_name => {
				'currency' => q(बाहरैनी दीनार),
			},
		},
		'BIF' => {
			display_name => {
				'currency' => q(बुरुंदी फ्राँ),
			},
		},
		'BMD' => {
			display_name => {
				'currency' => q(बरमुडी डॉलर),
			},
		},
		'BND' => {
			display_name => {
				'currency' => q(ब्रुनई डॉलर),
			},
		},
		'BOB' => {
			display_name => {
				'currency' => q(बोलिवियानो),
			},
		},
		'BOP' => {
			display_name => {
				'currency' => q(बोलिवियाई पेसो),
			},
		},
		'BOV' => {
			display_name => {
				'currency' => q(बोलिवियाई डॉलर),
			},
		},
		'BRB' => {
			display_name => {
				'currency' => q(ब्रज़ीली नया क्रुज़ेरो \(1967–1986\)),
			},
		},
		'BRC' => {
			display_name => {
				'currency' => q(ब्रज़ीली क्रुज़ाडो),
			},
		},
		'BRE' => {
			display_name => {
				'currency' => q(ब्रज़ीली क्रुज़ेरो \(190–1993\)),
			},
		},
		'BRL' => {
			display_name => {
				'currency' => q(ब्रज़ीली रेयाल),
			},
		},
		'BRN' => {
			display_name => {
				'currency' => q(ब्रज़ीली नया क्रुज़ाडो),
			},
		},
		'BRR' => {
			display_name => {
				'currency' => q(ब्रज़ीली क्रुज़ेरो),
			},
		},
		'BSD' => {
			display_name => {
				'currency' => q(बहामा डॉलर),
			},
		},
		'BTN' => {
			display_name => {
				'currency' => q(भुतान का नगुलत्रुम),
			},
		},
		'BUK' => {
			display_name => {
				'currency' => q(बर्मी \(म्यानमारी\) क्याट),
			},
		},
		'BWP' => {
			display_name => {
				'currency' => q(बोट्सवाना का पुलाट),
			},
		},
		'BYB' => {
			display_name => {
				'currency' => q(बेलारुसी नया रूबल \(194–1999\)),
			},
		},
		'BYN' => {
			display_name => {
				'currency' => q(बेलारुसी रूबल),
			},
		},
		'BYR' => {
			display_name => {
				'currency' => q(बेलारुसी रूबल \(2000–2016\)),
			},
		},
		'BZD' => {
			display_name => {
				'currency' => q(बेलीज़ डॉलर),
			},
		},
		'CAD' => {
			display_name => {
				'currency' => q(कनेडियन डॉलर),
			},
		},
		'CDF' => {
			display_name => {
				'currency' => q(कॉंगोलीज़ फ्राँ),
			},
		},
		'CHE' => {
			display_name => {
				'currency' => q(आईरलैण्ड का युरो),
			},
		},
		'CHF' => {
			display_name => {
				'currency' => q(स्विस फ़्रैंक),
			},
		},
		'CHW' => {
			display_name => {
				'currency' => q(आईरलैण्ड का फ़्रैंक),
			},
		},
		'CLF' => {
			display_name => {
				'currency' => q(चीली का ऊनीदादेस द फोमेंटो),
			},
		},
		'CLP' => {
			display_name => {
				'currency' => q(चिली पेसो),
			},
		},
		'CNY' => {
			display_name => {
				'currency' => q(चीनी युआन रेनमीनबी),
			},
		},
		'COP' => {
			display_name => {
				'currency' => q(कोलम्बियाई पेसो),
			},
		},
		'COU' => {
			display_name => {
				'currency' => q(युनीदाद द वालोर रेआल),
			},
		},
		'CRC' => {
			display_name => {
				'currency' => q(कॉस्टा रीका का कोलोन),
			},
		},
		'CSD' => {
			display_name => {
				'currency' => q(सर्बिया का डीनार),
			},
		},
		'CSK' => {
			display_name => {
				'currency' => q(चैकोस्लोवाकिय हार्ड कोरुना),
			},
		},
		'CUP' => {
			display_name => {
				'currency' => q(क्युबा का पेसो),
			},
		},
		'CVE' => {
			display_name => {
				'currency' => q(काप वेर्दे का एस्कुदो),
			},
		},
		'CYP' => {
			display_name => {
				'currency' => q(साईप्रस का पाऊंड),
			},
		},
		'CZK' => {
			display_name => {
				'currency' => q(चेक गनतंत्र का कोरुना),
			},
		},
		'DDM' => {
			display_name => {
				'currency' => q(ईस्ट जर्मन ओस्टमार्क),
			},
		},
		'DEM' => {
			display_name => {
				'currency' => q(डॉईच मार्क),
			},
		},
		'DJF' => {
			display_name => {
				'currency' => q(जीबुती फ्राँ),
			},
		},
		'DKK' => {
			display_name => {
				'currency' => q(डेनमार्क का क्रोन),
			},
		},
		'DOP' => {
			display_name => {
				'currency' => q(डॉमीनीकन पेसो),
			},
		},
		'DZD' => {
			display_name => {
				'currency' => q(आल्जीरी दीनार),
			},
		},
		'ECS' => {
			display_name => {
				'currency' => q(एक्वादोर सुक्रे),
			},
		},
		'ECV' => {
			display_name => {
				'currency' => q(एक्वादोर युनीदाद दे वालोर कॉनस्तांते),
			},
		},
		'EEK' => {
			display_name => {
				'currency' => q(एस्टोनियाई क्रून),
			},
		},
		'EGP' => {
			display_name => {
				'currency' => q(मिस्री पाउण्ड),
			},
		},
		'ERN' => {
			display_name => {
				'currency' => q(ऐरित्रीया का नाफ़का),
			},
		},
		'ESA' => {
			display_name => {
				'currency' => q(हीस्पानी पेसेता \(ए अकाऊँट\)),
			},
		},
		'ESB' => {
			display_name => {
				'currency' => q(हीस्पानी पेसेता \(कनवर्टीबल अकाऊँट\)),
			},
		},
		'ESP' => {
			display_name => {
				'currency' => q(हीस्पानी पेसेता),
			},
		},
		'ETB' => {
			display_name => {
				'currency' => q(ईथिओपिया का बीर्र),
			},
		},
		'EUR' => {
			display_name => {
				'currency' => q(युरो),
			},
		},
		'FIM' => {
			display_name => {
				'currency' => q(फीनीश मार्क्का),
			},
		},
		'FJD' => {
			display_name => {
				'currency' => q(फ़िजी का डॉलर),
			},
		},
		'FKP' => {
			display_name => {
				'currency' => q(फाल्कलैण्ड द्वीप पौण्ड),
			},
		},
		'FRF' => {
			display_name => {
				'currency' => q(फ्राँसीसी फ्राँ),
			},
		},
		'GBP' => {
			display_name => {
				'currency' => q(ब्रितन का पौण्ड स्टर्लिग),
			},
		},
		'GEK' => {
			display_name => {
				'currency' => q(जॉर्जिया का कुपोन लारीत),
			},
		},
		'GEL' => {
			display_name => {
				'currency' => q(जॉर्जिया का लारी),
			},
		},
		'GHC' => {
			display_name => {
				'currency' => q(घाना चेदी \(1979–2007\)),
			},
		},
		'GHS' => {
			display_name => {
				'currency' => q(घाना चेदी),
			},
		},
		'GIP' => {
			display_name => {
				'currency' => q(जीब्रालटर का पौण्ड),
			},
		},
		'GMD' => {
			display_name => {
				'currency' => q(गाँबिया का दलासी),
			},
		},
		'GNF' => {
			display_name => {
				'currency' => q(गीनी फ्राँ),
			},
		},
		'GNS' => {
			display_name => {
				'currency' => q(गीनी सीली),
			},
		},
		'GQE' => {
			display_name => {
				'currency' => q(ऐक्वाटरी गीनी एक्वेले गीनीआना),
			},
		},
		'GRD' => {
			display_name => {
				'currency' => q(युनानी द्राखमा),
			},
		},
		'GTQ' => {
			display_name => {
				'currency' => q(ग्वातेमाला क़्वेत्ज़ाल),
			},
		},
		'GWE' => {
			display_name => {
				'currency' => q(पुरतुगी गीनी का एस्कुएदो),
			},
		},
		'GWP' => {
			display_name => {
				'currency' => q(गीनी बिस्साऊ का पेसो),
			},
		},
		'GYD' => {
			display_name => {
				'currency' => q(गुयाना डॉलर),
			},
		},
		'HKD' => {
			display_name => {
				'currency' => q(हाँग काँग डॉलर),
			},
		},
		'HNL' => {
			display_name => {
				'currency' => q(हॉंडुरास लेंपीरा),
			},
		},
		'HRD' => {
			display_name => {
				'currency' => q(क्रोएशियाई दीनार),
			},
		},
		'HRK' => {
			display_name => {
				'currency' => q(क्रोएशियाई कुना),
			},
		},
		'HTG' => {
			display_name => {
				'currency' => q(हाईती गुर्द),
			},
		},
		'HUF' => {
			display_name => {
				'currency' => q(हंगेरियाई फ़ोरिण्ट),
			},
		},
		'IDR' => {
			display_name => {
				'currency' => q(इण्डोनेशियाई रुपिया),
			},
		},
		'IEP' => {
			display_name => {
				'currency' => q(आईरीश पौंड),
			},
		},
		'ILP' => {
			display_name => {
				'currency' => q(इस्राइली पौंड),
			},
		},
		'ILS' => {
			display_name => {
				'currency' => q(इस्राइली शेकेल),
			},
		},
		'INR' => {
			display_name => {
				'currency' => q(रां),
			},
		},
		'IQD' => {
			display_name => {
				'currency' => q(ईराक़ी दीनार),
			},
		},
		'IRR' => {
			display_name => {
				'currency' => q(ईरानी रीयाल),
			},
		},
		'ISK' => {
			display_name => {
				'currency' => q(आईसलैण्ड क्रोना),
			},
		},
		'ITL' => {
			display_name => {
				'currency' => q(इतली का लीरा),
			},
		},
		'JMD' => {
			display_name => {
				'currency' => q(जमाईका का डॉलर),
			},
		},
		'JOD' => {
			display_name => {
				'currency' => q(जोर्डनी दीनार),
			},
		},
		'JPY' => {
			display_name => {
				'currency' => q(जापानी येन),
			},
		},
		'KES' => {
			display_name => {
				'currency' => q(किनियाई शीलींग),
			},
		},
		'KGS' => {
			display_name => {
				'currency' => q(क़ीर्ग़ीज़स्तानी सोम),
			},
		},
		'KHR' => {
			display_name => {
				'currency' => q(कंबोडिया का रिएल),
			},
		},
		'KMF' => {
			display_name => {
				'currency' => q(कोमोरो का फ्राँ),
			},
		},
		'KPW' => {
			display_name => {
				'currency' => q(ऊत्तर कोरियाई वोन),
			},
		},
		'KRW' => {
			display_name => {
				'currency' => q(दक्षिण कोरियाई वोन),
			},
		},
		'KWD' => {
			display_name => {
				'currency' => q(क़ुवैती दीनार),
			},
		},
		'KYD' => {
			display_name => {
				'currency' => q(कैमान द्वीप का डॉलर),
			},
		},
		'KZT' => {
			display_name => {
				'currency' => q(क़ाज़ाख़स्तान तेंगे),
			},
		},
		'LAK' => {
			display_name => {
				'currency' => q(लाओस का कीप),
			},
		},
		'LBP' => {
			display_name => {
				'currency' => q(लीबानी पौंड),
			},
		},
		'LKR' => {
			display_name => {
				'currency' => q(श्री लंका रूपी),
			},
		},
		'LRD' => {
			display_name => {
				'currency' => q(लीबेरियाई डॉलर),
			},
		},
		'LSL' => {
			display_name => {
				'currency' => q(लसोथो का लोटी),
			},
		},
		'LTL' => {
			display_name => {
				'currency' => q(लिथुआनियाई लिता),
			},
		},
		'LTT' => {
			display_name => {
				'currency' => q(लिथुआनियाई टालोनास),
			},
		},
		'LUC' => {
			display_name => {
				'currency' => q(लुक्ज़मबुर्गी कनवर्टीबल फ्राँ),
			},
		},
		'LUF' => {
			display_name => {
				'currency' => q(लुक्ज़मबुर्गी फ्राँ),
			},
		},
		'LUL' => {
			display_name => {
				'currency' => q(लुक्ज़मबुर्गी वीत्ती फ्राँ),
			},
		},
		'LVL' => {
			display_name => {
				'currency' => q(लाटवियाई लाट्स),
			},
		},
		'LVR' => {
			display_name => {
				'currency' => q(लाटवियाई रूबल),
			},
		},
		'LYD' => {
			display_name => {
				'currency' => q(लिबियाई दीनार),
			},
		},
		'MAD' => {
			display_name => {
				'currency' => q(मोरक्किय दिर्हाम),
			},
		},
		'MAF' => {
			display_name => {
				'currency' => q(मोरक्किय फ्राँ),
			},
		},
		'MDL' => {
			display_name => {
				'currency' => q(मोल्डोवियाई ल),
			},
		},
		'MGA' => {
			display_name => {
				'currency' => q(मादागास्करी आरिआरी),
			},
		},
		'MGF' => {
			display_name => {
				'currency' => q(मादागास्करी फ्राँ),
			},
		},
		'MKD' => {
			display_name => {
				'currency' => q(मसेदोनियाई दीनार),
			},
		},
		'MLF' => {
			display_name => {
				'currency' => q(माली का फ्राँ),
			},
		},
		'MMK' => {
			display_name => {
				'currency' => q(म्यानमारी क्याट),
			},
		},
		'MNT' => {
			display_name => {
				'currency' => q(मौंगोलीयाई तुग्रीक),
			},
		},
		'MOP' => {
			display_name => {
				'currency' => q(माकाव पाताचा),
			},
		},
		'MRO' => {
			display_name => {
				'currency' => q(मौरिटानी ऊगुया \(1973–2017\)),
			},
		},
		'MRU' => {
			display_name => {
				'currency' => q(मौरिटानी ऊगुया),
			},
		},
		'MTL' => {
			display_name => {
				'currency' => q(माल्टी लीरा),
			},
		},
		'MTP' => {
			display_name => {
				'currency' => q(माल्टी पौंड),
			},
		},
		'MUR' => {
			display_name => {
				'currency' => q(मोरिशियस का रूपी),
			},
		},
		'MVR' => {
			display_name => {
				'currency' => q(मालदीव द्वीप का रूफिया),
			},
		},
		'MWK' => {
			display_name => {
				'currency' => q(मालवी क्वाचा),
			},
		},
		'MXN' => {
			display_name => {
				'currency' => q(मेक्सिकन पेसो),
			},
		},
		'MXP' => {
			display_name => {
				'currency' => q(मेक्सिकन रजती पेसो \(1861–1992\)),
			},
		},
		'MXV' => {
			display_name => {
				'currency' => q(मेक्सिकन युनीदाद द ईनवेरसिओन \(युडीआई\)),
			},
		},
		'MYR' => {
			display_name => {
				'currency' => q(मलेशियन रिंगित),
			},
		},
		'MZE' => {
			display_name => {
				'currency' => q(मोज़ांबीक एस्कुएदो),
			},
		},
		'MZM' => {
			display_name => {
				'currency' => q(मोज़ांबीक पुराना मेतीकाल),
			},
		},
		'MZN' => {
			display_name => {
				'currency' => q(मोज़ांबीक मेतीकाल),
			},
		},
		'NAD' => {
			display_name => {
				'currency' => q(नमीबिया डॉलर),
			},
		},
		'NGN' => {
			display_name => {
				'currency' => q(नाईजीरीयाई नाईरा),
			},
		},
		'NIC' => {
			display_name => {
				'currency' => q(नीकारागुआई कोर्दोबा),
			},
		},
		'NIO' => {
			display_name => {
				'currency' => q(नीकारागुआई सुवर्ण कोर्दोबा),
			},
		},
		'NLG' => {
			display_name => {
				'currency' => q(नेदरलैण्ड गीलडर),
			},
		},
		'NOK' => {
			display_name => {
				'currency' => q(नॉर्वे का क्रोन),
			},
		},
		'NPR' => {
			display_name => {
				'currency' => q(नेपाली रुपी),
			},
		},
		'NZD' => {
			display_name => {
				'currency' => q(न्यूज़ीलैंड डॉलर),
			},
		},
		'OMR' => {
			display_name => {
				'currency' => q(ओमानी रियाल),
			},
		},
		'PAB' => {
			display_name => {
				'currency' => q(पनामा का बालबोआ),
			},
		},
		'PEI' => {
			display_name => {
				'currency' => q(पेरूवाई ईंटी),
			},
		},
		'PEN' => {
			display_name => {
				'currency' => q(पेरुवाई सोल),
			},
		},
		'PES' => {
			display_name => {
				'currency' => q(पेरुवाई सोल \(1863–1965\)),
			},
		},
		'PGK' => {
			display_name => {
				'currency' => q(पापुआ न्यु गीनी का कीना),
			},
		},
		'PHP' => {
			display_name => {
				'currency' => q(फ़िलिपीन का पेसो),
			},
		},
		'PKR' => {
			display_name => {
				'currency' => q(पाकिस्तानी रुपया),
			},
		},
		'PLN' => {
			display_name => {
				'currency' => q(पोलिश ज़्लॉटी),
			},
		},
		'PTE' => {
			display_name => {
				'currency' => q(पुरतुगी एस्कुदो),
			},
		},
		'PYG' => {
			display_name => {
				'currency' => q(पारागुऐई गुआरानी),
			},
		},
		'QAR' => {
			display_name => {
				'currency' => q(क़तारी रीयाल),
			},
		},
		'RHD' => {
			display_name => {
				'currency' => q(रोडेशियाई डॉलर),
			},
		},
		'ROL' => {
			display_name => {
				'currency' => q(रोमानियाई पुरानी ल),
			},
		},
		'RON' => {
			display_name => {
				'currency' => q(रोमानियाई ल),
			},
		},
		'RSD' => {
			display_name => {
				'currency' => q(सर्बियाई दिनार),
			},
		},
		'RUB' => {
			display_name => {
				'currency' => q(रूसी रूबल),
			},
		},
		'RWF' => {
			display_name => {
				'currency' => q(रुआँदा फ्राँ),
			},
		},
		'SAR' => {
			display_name => {
				'currency' => q(साउदी रियाल),
			},
		},
		'SBD' => {
			display_name => {
				'currency' => q(सोलोमन द्वीप का डॉलर),
			},
		},
		'SCR' => {
			display_name => {
				'currency' => q(सेशेल रूपी),
			},
		},
		'SDD' => {
			display_name => {
				'currency' => q(सुदानी पुराना डॉलर),
			},
		},
		'SDG' => {
			display_name => {
				'currency' => q(सुदानी पौंड),
			},
		},
		'SDP' => {
			display_name => {
				'currency' => q(सुदानी पुराना पौंड),
			},
		},
		'SEK' => {
			display_name => {
				'currency' => q(स्वीडन क्रोना),
			},
		},
		'SGD' => {
			display_name => {
				'currency' => q(सिंगापुर डॉलर),
			},
		},
		'SHP' => {
			display_name => {
				'currency' => q(सेंट हेलीना पौंड),
			},
		},
		'SIT' => {
			display_name => {
				'currency' => q(स्लोवेनियाई तोलार),
			},
		},
		'SKK' => {
			display_name => {
				'currency' => q(स्लोवाकी कोरुना),
			},
		},
		'SLL' => {
			display_name => {
				'currency' => q(सीयेरा लीयोनेई लीयोने),
			},
		},
		'SOS' => {
			display_name => {
				'currency' => q(सोमाली शीलींग),
			},
		},
		'SRD' => {
			display_name => {
				'currency' => q(सुरीनाम डॉलर),
			},
		},
		'SRG' => {
			display_name => {
				'currency' => q(सुरीनाम गील्डर),
			},
		},
		'STD' => {
			display_name => {
				'currency' => q(साँव तोमे एवं प्रीन्सीपे का डोब्रा \(1977–2017\)),
			},
		},
		'STN' => {
			display_name => {
				'currency' => q(साँव तोमे एवं प्रीन्सीपे का डोब्रा),
			},
		},
		'SUR' => {
			display_name => {
				'currency' => q(सोवियत रूबल),
			},
		},
		'SVC' => {
			display_name => {
				'currency' => q(एल सालवादर कोलोन),
			},
		},
		'SYP' => {
			display_name => {
				'currency' => q(सीरियाई पौंड),
			},
		},
		'SZL' => {
			display_name => {
				'currency' => q(स्वाज़ीलैण्ड लीलांगेनी),
			},
		},
		'THB' => {
			display_name => {
				'currency' => q(थाई बाह्ट),
			},
		},
		'TJR' => {
			display_name => {
				'currency' => q(ताजीक़ीस्तानी रूबल),
			},
		},
		'TJS' => {
			display_name => {
				'currency' => q(ताजीक़ीस्तानी सोमोनी),
			},
		},
		'TMM' => {
			display_name => {
				'currency' => q(तुर्कमेनीस्तानी मानाट),
			},
		},
		'TND' => {
			display_name => {
				'currency' => q(त्युनीसी दीनर),
			},
		},
		'TOP' => {
			display_name => {
				'currency' => q(टॉंगा पाईंगा),
			},
		},
		'TPE' => {
			display_name => {
				'currency' => q(तीमोरी एस्कुदो),
			},
		},
		'TRL' => {
			display_name => {
				'currency' => q(तुर्की लीरा),
			},
		},
		'TRY' => {
			display_name => {
				'currency' => q(तुर्की नया लीरा),
			},
		},
		'TTD' => {
			display_name => {
				'currency' => q(त्रीनीदाद एवं टोबागो डॉलर),
			},
		},
		'TWD' => {
			display_name => {
				'currency' => q(ताईवानी नया डॉलर),
			},
		},
		'TZS' => {
			display_name => {
				'currency' => q(तान्ज़ेनियाई शीलींग),
			},
		},
		'UAH' => {
			display_name => {
				'currency' => q(युक्रेनी ह्रीवनिया),
			},
		},
		'UAK' => {
			display_name => {
				'currency' => q(युक्रेनी कार्बोवानेत्ज़),
			},
		},
		'UGS' => {
			display_name => {
				'currency' => q(युगाँडाई शीलींग \(1996–1987\)),
			},
		},
		'UGX' => {
			display_name => {
				'currency' => q(युगाँडाई शीलींग),
			},
		},
		'USD' => {
			display_name => {
				'currency' => q(अमरिकी डॉलर),
			},
		},
		'USN' => {
			display_name => {
				'currency' => q(अमरिकी डॉलर \(अगले दिन का\)),
			},
		},
		'USS' => {
			display_name => {
				'currency' => q(अमरिकी डॉलर \(इसी दिन का\)),
			},
		},
		'UYI' => {
			display_name => {
				'currency' => q(ऊरुगुए का पेसो आन ऊनीदादोस ईंदेक्सादास),
			},
		},
		'UYP' => {
			display_name => {
				'currency' => q(ऊरुगुए का पेसो \(1975–1993\)),
			},
		},
		'UYU' => {
			display_name => {
				'currency' => q(ऊरुगुए का ऊरुगुआयो पेसो),
			},
		},
		'UZS' => {
			display_name => {
				'currency' => q(ऊज़बेक सुम),
			},
		},
		'VEB' => {
			display_name => {
				'currency' => q(वेनेज़ुएलाई बोलिवार \(1871–2008\)),
			},
		},
		'VEF' => {
			display_name => {
				'currency' => q(वेनेज़ुएलाई बोलिवार),
			},
		},
		'VND' => {
			display_name => {
				'currency' => q(वीयतनामी डॉंग),
			},
		},
		'VUV' => {
			display_name => {
				'currency' => q(वनुआटु वटु),
			},
		},
		'WST' => {
			display_name => {
				'currency' => q(वेस्टर्न समोआ ताला),
			},
		},
		'XAF' => {
			display_name => {
				'currency' => q(\(सीएफ़ए\) फ्रानसीसी फेदरेशनी फ्राँ),
			},
		},
		'XAG' => {
			display_name => {
				'currency' => q(रजत),
			},
		},
		'XAU' => {
			display_name => {
				'currency' => q(सोना),
			},
		},
		'XBA' => {
			display_name => {
				'currency' => q(एक्यु),
			},
		},
		'XBB' => {
			display_name => {
				'currency' => q(एम्यु),
			},
		},
		'XBC' => {
			display_name => {
				'currency' => q(यूरोपी एकाऊंट का युनीट \(एक्स बी सी\)),
			},
		},
		'XBD' => {
			display_name => {
				'currency' => q(यूरोपी एकाऊंट का युनीट \(एक्स बी डी\)),
			},
		},
		'XCD' => {
			display_name => {
				'currency' => q(ईस्ट करिबियन डॉलर),
			},
		},
		'XDR' => {
			display_name => {
				'currency' => q(स्पेशियल ड्राईंग राईट्स),
			},
		},
		'XEU' => {
			display_name => {
				'currency' => q(यूरोपी मुद्रा \(एक्यु\)),
			},
		},
		'XFO' => {
			display_name => {
				'currency' => q(फ्रानसीसी सुवर्ण फ्राँ),
			},
		},
		'XFU' => {
			display_name => {
				'currency' => q(फ्रानसीसी युआईसी फ्राँ),
			},
		},
		'XOF' => {
			display_name => {
				'currency' => q(फ्रानसीसी फेदेरेशनी बीसीएआओ फ्राँ),
			},
		},
		'XPD' => {
			display_name => {
				'currency' => q(पैलेडियम),
			},
		},
		'XPF' => {
			display_name => {
				'currency' => q(फ्रानसीसी फेदेरेशनी फ्राँ),
			},
		},
		'XPT' => {
			display_name => {
				'currency' => q(प्लैटीनम),
			},
		},
		'XRE' => {
			display_name => {
				'currency' => q(रीनैट फंड्स),
			},
		},
		'XTS' => {
			display_name => {
				'currency' => q(टेस्टींग करनसी कोड),
			},
		},
		'XXX' => {
			display_name => {
				'currency' => q(अज्ञात या अवैध मुद्रा),
			},
		},
		'YDD' => {
			display_name => {
				'currency' => q(यमनी दीनार),
			},
		},
		'YER' => {
			display_name => {
				'currency' => q(यमनी रीयाल),
			},
		},
		'YUD' => {
			display_name => {
				'currency' => q(युगोस्लावी हार्ड दीनार),
			},
		},
		'YUM' => {
			display_name => {
				'currency' => q(युगोस्लावी नोवीय \(नये\) दीनार),
			},
		},
		'YUN' => {
			display_name => {
				'currency' => q(युगोस्लावी कनवर्टीबल दीनार),
			},
		},
		'ZAR' => {
			display_name => {
				'currency' => q(दक्षिण अफ़्रीकी रॅण्ड),
			},
		},
		'ZMK' => {
			display_name => {
				'currency' => q(ज़ाम्बियाई क्वाचा \(1968–2012\)),
			},
		},
		'ZMW' => {
			display_name => {
				'currency' => q(ज़ाम्बियाई क्वाचा),
			},
		},
		'ZRN' => {
			display_name => {
				'currency' => q(ज़ाईरी नये ज़ाईर),
			},
		},
		'ZRZ' => {
			display_name => {
				'currency' => q(ज़ाईरी ज़ाईर),
			},
		},
		'ZWD' => {
			display_name => {
				'currency' => q(ज़ीम्बाबवेई डॉलर),
			},
		},
	} },
);


has 'calendar_months' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					wide => {
						nonleap => [
							'जानुवारी',
							'फेब्रुवारी',
							'मार्स',
							'एफ्रिल',
							'मे',
							'जुन',
							'जुलाइ',
							'आगस्थ',
							'सेबथेज्ब़र',
							'अखथबर',
							'नबेज्ब़र',
							'दिसेज्ब़र'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					narrow => {
						nonleap => [
							'ज',
							'फे',
							'मा',
							'ए',
							'मे',
							'जु',
							'जु',
							'आ',
							'से',
							'अ',
							'न',
							'दि'
						],
						leap => [
							
						],
					},
				},
			},
			'indian' => {
				'format' => {
					wide => {
						nonleap => [
							'बैसागो/बैसाग',
							'जेथो',
							'आसार',
							'सावुन',
							'भाद्र',
							'आसिन',
							'खाथि',
							'आगाह्न',
							'फुस',
							'मागो',
							'फागुन',
							'सैथो'
						],
						leap => [
							
						],
					},
				},
			},
	} },
);

has 'calendar_days' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						mon => 'सम',
						tue => 'मंगल',
						wed => 'बुद',
						thu => 'बिसथि',
						fri => 'सुखुर',
						sat => 'सुनि',
						sun => 'रबि'
					},
					wide => {
						mon => 'समबार',
						tue => 'मंगलबार',
						wed => 'बुदबार',
						thu => 'बिसथिबार',
						fri => 'सुखुरबार',
						sat => 'सुनिबार',
						sun => 'रबिबार'
					},
				},
				'stand-alone' => {
					narrow => {
						mon => 'स',
						tue => 'मं',
						wed => 'बु',
						thu => 'बि',
						fri => 'सु',
						sat => 'सु',
						sun => 'र'
					},
				},
			},
	} },
);

has 'calendar_quarters' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					wide => {0 => 'सिथासे/खोन्दोसे/बाहागोसे',
						1 => 'खावसे/खोन्दोनै/बाहागोनै',
						2 => 'खावथाम/खोन्दोथाम/बाहागोथाम',
						3 => 'खावब्रै/खोन्दोब्रै/फुरा/आबुं'
					},
				},
			},
	} },
);

has 'day_periods' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'format' => {
				'abbreviated' => {
					'am' => q{फुं},
					'pm' => q{बेलासे},
				},
				'wide' => {
					'pm' => q{बेलासे},
					'am' => q{फुं},
				},
			},
		},
	} },
);

has 'eras' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
		},
		'gregorian' => {
			abbreviated => {
				'0' => 'ईसा.पूर्व',
				'1' => 'सन'
			},
		},
		'indian' => {
		},
	} },
);

has 'date_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			'full' => q{EEEE, MMMM d, y G},
			'long' => q{MMMM d, y G},
			'medium' => q{MMM d, y G},
			'short' => q{M/d/yy GGGGG},
		},
		'gregorian' => {
			'full' => q{EEEE, MMMM d, y},
			'long' => q{MMMM d, y},
			'medium' => q{MMM d, y},
			'short' => q{M/d/yy},
		},
		'indian' => {
		},
	} },
);

has 'time_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
		},
		'gregorian' => {
			'full' => q{h:mm:ss a zzzz},
			'long' => q{h:mm:ss a z},
			'medium' => q{h:mm:ss a},
			'short' => q{h:mm a},
		},
		'indian' => {
		},
	} },
);

has 'datetime_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
		},
		'gregorian' => {
		},
		'indian' => {
		},
	} },
);

has 'datetime_formats_available_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			Gy => q{y G},
			GyMMM => q{MMM, y G},
			GyMMMEd => q{E, MMM d, y G},
			GyMMMd => q{MMM d, y G},
			Hm => q{HH:mm},
			Hms => q{HH:mm:ss},
			M => q{L},
			MEd => q{E, M/d},
			MMM => q{LLL},
			MMMEd => q{E, MMM d},
			MMMMEd => q{E, MMMM d},
			MMMMd => q{MMMM d},
			MMMd => q{d-MMM},
			Md => q{M/d},
			d => q{d},
			hm => q{h:mm a},
			ms => q{mm:ss},
			y => q{y},
			yM => q{M/y},
			yMEd => q{E, M/d/y},
			yMMM => q{MMM y},
			yMMMEd => q{E, MMM d, y},
			yMMMM => q{MMMM y},
			yQQQ => q{QQQ y},
			yQQQQ => q{QQQQ y},
		},
		'gregorian' => {
			Gy => q{y G},
			GyMMM => q{MMM, y G},
			GyMMMEd => q{E, MMM d, y G},
			GyMMMd => q{MMM d, y G},
			Hm => q{HH:mm},
			Hms => q{HH:mm:ss},
			M => q{L},
			MEd => q{E, M/d},
			MMM => q{LLL},
			MMMEd => q{E, MMM d},
			MMMMEd => q{E, MMMM d},
			MMMMd => q{MMMM d},
			MMMd => q{d-MMM},
			Md => q{M/d},
			d => q{d},
			hm => q{h:mm a},
			ms => q{mm:ss},
			y => q{y},
			yM => q{M/y},
			yMEd => q{E, M/d/y},
			yMMM => q{MMM y},
			yMMMEd => q{E, MMM d, y},
			yMMMM => q{MMMM y},
			yQQQ => q{QQQ y},
			yQQQQ => q{QQQQ y},
		},
	} },
);

has 'datetime_formats_append_item' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
	} },
);

has 'datetime_formats_interval' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
	} },
);

has 'time_zone_names' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default	=> sub { {
		'Acre' => {
			long => {
				'daylight' => q#आकर समर टाईम#,
				'generic' => q#आकर टाईम#,
				'standard' => q#आकर स्टैंडर्ड टाईम#,
			},
		},
		'Afghanistan' => {
			long => {
				'standard' => q#अफ़गानी स्टैंडर्ड टाईम#,
			},
		},
		'Africa/Abidjan' => {
			exemplarCity => q#अबिद्जान#,
		},
		'Africa/Accra' => {
			exemplarCity => q#आक्रा#,
		},
		'Africa/Addis_Ababa' => {
			exemplarCity => q#ऍडिस अबाबा#,
		},
		'Africa/Algiers' => {
			exemplarCity => q#आल्जीए#,
		},
		'Africa/Asmera' => {
			exemplarCity => q#अस्मेरा#,
		},
		'Africa/Bamako' => {
			exemplarCity => q#बामाको#,
		},
		'Africa/Bangui' => {
			exemplarCity => q#बाँगी#,
		},
		'Africa/Banjul' => {
			exemplarCity => q#बन्जुल#,
		},
		'Africa/Bissau' => {
			exemplarCity => q#बिस्साउ#,
		},
		'Africa/Blantyre' => {
			exemplarCity => q#ब्लांटीर#,
		},
		'Africa/Brazzaville' => {
			exemplarCity => q#ब्राज़ावील#,
		},
		'Africa/Bujumbura' => {
			exemplarCity => q#बुजुम्बुरा#,
		},
		'Africa/Cairo' => {
			exemplarCity => q#कायरो#,
		},
		'Africa/Casablanca' => {
			exemplarCity => q#काज़ाब्लाँका#,
		},
		'Africa/Ceuta' => {
			exemplarCity => q#सेउता#,
		},
		'Africa/Conakry' => {
			exemplarCity => q#कोनाक्री#,
		},
		'Africa/Dakar' => {
			exemplarCity => q#डाकार#,
		},
		'Africa/Dar_es_Salaam' => {
			exemplarCity => q#दार एस सलाम#,
		},
		'Africa/Djibouti' => {
			exemplarCity => q#ड्जिबुटी#,
		},
		'Africa/Douala' => {
			exemplarCity => q#दुआला#,
		},
		'Africa/El_Aaiun' => {
			exemplarCity => q#अल आइउन#,
		},
		'Africa/Freetown' => {
			exemplarCity => q#फ़्रीटाउन#,
		},
		'Africa/Gaborone' => {
			exemplarCity => q#गैबोरोन#,
		},
		'Africa/Harare' => {
			exemplarCity => q#हरारे#,
		},
		'Africa/Johannesburg' => {
			exemplarCity => q#जोहानेसबर्ग#,
		},
		'Africa/Kampala' => {
			exemplarCity => q#कंपाला#,
		},
		'Africa/Khartoum' => {
			exemplarCity => q#खार्तूम#,
		},
		'Africa/Kigali' => {
			exemplarCity => q#किगालि#,
		},
		'Africa/Kinshasa' => {
			exemplarCity => q#किन्शासा#,
		},
		'Africa/Lagos' => {
			exemplarCity => q#लागोस#,
		},
		'Africa/Libreville' => {
			exemplarCity => q#लिब्रविल#,
		},
		'Africa/Lome' => {
			exemplarCity => q#लोमे#,
		},
		'Africa/Luanda' => {
			exemplarCity => q#लुआँडा#,
		},
		'Africa/Lubumbashi' => {
			exemplarCity => q#लुबुम्बाशी#,
		},
		'Africa/Lusaka' => {
			exemplarCity => q#लुसाका#,
		},
		'Africa/Malabo' => {
			exemplarCity => q#मालाबो#,
		},
		'Africa/Maputo' => {
			exemplarCity => q#मापुटो#,
		},
		'Africa/Maseru' => {
			exemplarCity => q#मसेरू#,
		},
		'Africa/Mbabane' => {
			exemplarCity => q#म्बाबने#,
		},
		'Africa/Mogadishu' => {
			exemplarCity => q#मोगाडिशू#,
		},
		'Africa/Monrovia' => {
			exemplarCity => q#मोनरोविया#,
		},
		'Africa/Nairobi' => {
			exemplarCity => q#नैरोबी#,
		},
		'Africa/Ndjamena' => {
			exemplarCity => q#न्जामेना#,
		},
		'Africa/Niamey' => {
			exemplarCity => q#नीआमे#,
		},
		'Africa/Nouakchott' => {
			exemplarCity => q#न्वाकशॉट#,
		},
		'Africa/Ouagadougou' => {
			exemplarCity => q#ऊगाडुगु#,
		},
		'Africa/Porto-Novo' => {
			exemplarCity => q#पोर्टो-नोवो#,
		},
		'Africa/Sao_Tome' => {
			exemplarCity => q#साँव टोमे#,
		},
		'Africa/Tripoli' => {
			exemplarCity => q#त्रिपोली#,
		},
		'Africa/Tunis' => {
			exemplarCity => q#ट्यूनिस#,
		},
		'Africa/Windhoek' => {
			exemplarCity => q#विन्डोक#,
		},
		'Africa_Central' => {
			long => {
				'standard' => q#मध्य अफ्रीका स्टैंडर्ड टाईम#,
			},
		},
		'Africa_Eastern' => {
			long => {
				'standard' => q#पूर्वी अफ्रीका स्टैंडर्ड टाईम#,
			},
		},
		'Africa_Southern' => {
			long => {
				'standard' => q#दक्षिण अफ्रीका स्टैंडर्ड टाईम#,
			},
		},
		'Africa_Western' => {
			long => {
				'daylight' => q#पश्चीम अफ्रीका समर टाईम#,
				'generic' => q#पश्चीम अफ्रीका टाईम#,
				'standard' => q#पश्चीम अफ्रीका स्टैंडर्ड टाईम#,
			},
		},
		'Alaska' => {
			long => {
				'daylight' => q#अलास्का डेलाईट टाईम#,
				'generic' => q#अलास्का टाईम#,
				'standard' => q#अलास्का स्टैंडर्ड टाईम#,
			},
		},
		'Almaty' => {
			long => {
				'daylight' => q#अलमाटी समर टाईम#,
				'generic' => q#अलमाटी टाईम#,
				'standard' => q#अलमाटी स्टैंडर्ड टाईम#,
			},
		},
		'Amazon' => {
			long => {
				'daylight' => q#अमाज़ोन समर टाईम#,
				'generic' => q#अमाज़ोन टाईम#,
				'standard' => q#अमाज़ोन स्टैंडर्ड टाईम#,
			},
		},
		'America/Adak' => {
			exemplarCity => q#एडेक#,
		},
		'America/Anchorage' => {
			exemplarCity => q#ऐन्करेज#,
		},
		'America/Anguilla' => {
			exemplarCity => q#एंगिला#,
		},
		'America/Antigua' => {
			exemplarCity => q#एंटिगुआ#,
		},
		'America/Araguaina' => {
			exemplarCity => q#अरागुआईना#,
		},
		'America/Argentina/La_Rioja' => {
			exemplarCity => q#ला रिओख़ा#,
		},
		'America/Argentina/Rio_Gallegos' => {
			exemplarCity => q#रियो गालेगोस#,
		},
		'America/Argentina/San_Juan' => {
			exemplarCity => q#सान हुआँ#,
		},
		'America/Argentina/San_Luis' => {
			exemplarCity => q#सान लुईस#,
		},
		'America/Argentina/Tucuman' => {
			exemplarCity => q#टुकुमान#,
		},
		'America/Argentina/Ushuaia' => {
			exemplarCity => q#उशूआयिया#,
		},
		'America/Aruba' => {
			exemplarCity => q#अरूबा#,
		},
		'America/Asuncion' => {
			exemplarCity => q#आसुनसीओन#,
		},
		'America/Bahia' => {
			exemplarCity => q#बाहिया#,
		},
		'America/Barbados' => {
			exemplarCity => q#बार्बाडोस#,
		},
		'America/Belem' => {
			exemplarCity => q#बेलेम#,
		},
		'America/Belize' => {
			exemplarCity => q#बेलिज़#,
		},
		'America/Blanc-Sablon' => {
			exemplarCity => q#ब्लाँ-साबलोन#,
		},
		'America/Boa_Vista' => {
			exemplarCity => q#बोआ विस्टा#,
		},
		'America/Bogota' => {
			exemplarCity => q#बोगोटा#,
		},
		'America/Boise' => {
			exemplarCity => q#ब्वाज़#,
		},
		'America/Buenos_Aires' => {
			exemplarCity => q#बुएनोस एरेस#,
		},
		'America/Cambridge_Bay' => {
			exemplarCity => q#केम्ब्रिज खाडी#,
		},
		'America/Campo_Grande' => {
			exemplarCity => q#काम्पो ग्रांडे#,
		},
		'America/Cancun' => {
			exemplarCity => q#कानकुन#,
		},
		'America/Caracas' => {
			exemplarCity => q#काराकास#,
		},
		'America/Catamarca' => {
			exemplarCity => q#काटामार्का#,
		},
		'America/Cayenne' => {
			exemplarCity => q#कायेन#,
		},
		'America/Cayman' => {
			exemplarCity => q#केमॅन#,
		},
		'America/Chicago' => {
			exemplarCity => q#शिकागो#,
		},
		'America/Chihuahua' => {
			exemplarCity => q#चिवावा#,
		},
		'America/Coral_Harbour' => {
			exemplarCity => q#कॉरल बन्दरगाह#,
		},
		'America/Cordoba' => {
			exemplarCity => q#कोर्डोबा#,
		},
		'America/Costa_Rica' => {
			exemplarCity => q#कॉस्टा रिका#,
		},
		'America/Cuiaba' => {
			exemplarCity => q#कुईआबा#,
		},
		'America/Curacao' => {
			exemplarCity => q#क्यूरासाओं#,
		},
		'America/Danmarkshavn' => {
			exemplarCity => q#डेनमार्क्सहैवन#,
		},
		'America/Dawson' => {
			exemplarCity => q#डॉसन#,
		},
		'America/Dawson_Creek' => {
			exemplarCity => q#डॉसन क्रिक#,
		},
		'America/Denver' => {
			exemplarCity => q#डॅनवर#,
		},
		'America/Detroit' => {
			exemplarCity => q#डेट्रोई#,
		},
		'America/Dominica' => {
			exemplarCity => q#डॉमिनिका#,
		},
		'America/Edmonton' => {
			exemplarCity => q#एडमंटन#,
		},
		'America/Eirunepe' => {
			exemplarCity => q#एईरुनेपे#,
		},
		'America/El_Salvador' => {
			exemplarCity => q#ऍल साल्वादोर#,
		},
		'America/Fortaleza' => {
			exemplarCity => q#फ़ोर्टालेज़ा#,
		},
		'America/Glace_Bay' => {
			exemplarCity => q#ग्लास (खाडी) बे#,
		},
		'America/Godthab' => {
			exemplarCity => q#गॉडथैब#,
		},
		'America/Goose_Bay' => {
			exemplarCity => q#गूस (खाडी) बे#,
		},
		'America/Grand_Turk' => {
			exemplarCity => q#ग्रॅंड टर्क#,
		},
		'America/Grenada' => {
			exemplarCity => q#ग्रेनाडा#,
		},
		'America/Guadeloupe' => {
			exemplarCity => q#गुआदलुप#,
		},
		'America/Guatemala' => {
			exemplarCity => q#ग्वाटेमाला#,
		},
		'America/Guayaquil' => {
			exemplarCity => q#गुआयाकिल#,
		},
		'America/Guyana' => {
			exemplarCity => q#गुयाना#,
		},
		'America/Halifax' => {
			exemplarCity => q#हैलिफेक्स#,
		},
		'America/Havana' => {
			exemplarCity => q#हवाना#,
		},
		'America/Hermosillo' => {
			exemplarCity => q#हर्मोसिलो#,
		},
		'America/Indiana/Knox' => {
			exemplarCity => q#नॉक्स#,
		},
		'America/Indiana/Marengo' => {
			exemplarCity => q#मारेंगो#,
		},
		'America/Indiana/Petersburg' => {
			exemplarCity => q#पिटर्सबर्ग#,
		},
		'America/Indiana/Tell_City' => {
			exemplarCity => q#टॅल सिटी#,
		},
		'America/Indiana/Vevay' => {
			exemplarCity => q#वेवे#,
		},
		'America/Indiana/Vincennes' => {
			exemplarCity => q#वॅंसेन्#,
		},
		'America/Indiana/Winamac' => {
			exemplarCity => q#विनामॅक#,
		},
		'America/Indianapolis' => {
			exemplarCity => q#इन्डियानापोलिस#,
		},
		'America/Inuvik' => {
			exemplarCity => q#इनूविक#,
		},
		'America/Iqaluit' => {
			exemplarCity => q#इकाल्यूईत#,
		},
		'America/Jamaica' => {
			exemplarCity => q#जमैका#,
		},
		'America/Jujuy' => {
			exemplarCity => q#जुजुई#,
		},
		'America/Juneau' => {
			exemplarCity => q#जुनो#,
		},
		'America/Kentucky/Monticello' => {
			exemplarCity => q#मोंटीचेलो#,
		},
		'America/La_Paz' => {
			exemplarCity => q#ला पाज़#,
		},
		'America/Lima' => {
			exemplarCity => q#लीमा#,
		},
		'America/Los_Angeles' => {
			exemplarCity => q#लोस ऐंजिलेस#,
		},
		'America/Louisville' => {
			exemplarCity => q#लुईवील#,
		},
		'America/Maceio' => {
			exemplarCity => q#माचेईओ#,
		},
		'America/Managua' => {
			exemplarCity => q#मनागुआ#,
		},
		'America/Manaus' => {
			exemplarCity => q#मनाउस#,
		},
		'America/Martinique' => {
			exemplarCity => q#मार्टीनीक#,
		},
		'America/Mazatlan' => {
			exemplarCity => q#माज़ाट्लान#,
		},
		'America/Mendoza' => {
			exemplarCity => q#मेंडोज़ा#,
		},
		'America/Menominee' => {
			exemplarCity => q#मेनोमिनी#,
		},
		'America/Merida' => {
			exemplarCity => q#मेरिडा#,
		},
		'America/Mexico_City' => {
			exemplarCity => q#मेक्सिको सिटी#,
		},
		'America/Miquelon' => {
			exemplarCity => q#मिकलों#,
		},
		'America/Moncton' => {
			exemplarCity => q#मोंक्ट्न#,
		},
		'America/Monterrey' => {
			exemplarCity => q#मोंटेरे#,
		},
		'America/Montevideo' => {
			exemplarCity => q#मोन्टेवीडिओ#,
		},
		'America/Montserrat' => {
			exemplarCity => q#मॉंसेरा#,
		},
		'America/Nassau' => {
			exemplarCity => q#नास्साउ#,
		},
		'America/New_York' => {
			exemplarCity => q#न्यू यार्क#,
		},
		'America/Nipigon' => {
			exemplarCity => q#निपिगॉन#,
		},
		'America/Nome' => {
			exemplarCity => q#नोम#,
		},
		'America/Noronha' => {
			exemplarCity => q#नोरोन्हा#,
		},
		'America/North_Dakota/Center' => {
			exemplarCity => q#सैन्टर#,
		},
		'America/North_Dakota/New_Salem' => {
			exemplarCity => q#न्यू सॅलेम#,
		},
		'America/Panama' => {
			exemplarCity => q#पनामा#,
		},
		'America/Pangnirtung' => {
			exemplarCity => q#पंग्नीरटुँग्#,
		},
		'America/Paramaribo' => {
			exemplarCity => q#पारामारिबो#,
		},
		'America/Phoenix' => {
			exemplarCity => q#फीनिक्स#,
		},
		'America/Port-au-Prince' => {
			exemplarCity => q#पॉर-ओ-प्रँस#,
		},
		'America/Port_of_Spain' => {
			exemplarCity => q#पोर्ट ऑफ़ स्पेन#,
		},
		'America/Porto_Velho' => {
			exemplarCity => q#पोर्टो वेल्हो#,
		},
		'America/Puerto_Rico' => {
			exemplarCity => q#पुएर्तो रिको#,
		},
		'America/Rainy_River' => {
			exemplarCity => q#रेनी रीवर#,
		},
		'America/Rankin_Inlet' => {
			exemplarCity => q#रेनकिन इनलेट#,
		},
		'America/Recife' => {
			exemplarCity => q#रेसीफ़े#,
		},
		'America/Regina' => {
			exemplarCity => q#रेजिना#,
		},
		'America/Resolute' => {
			exemplarCity => q#रॅज़ोल्यूट#,
		},
		'America/Rio_Branco' => {
			exemplarCity => q#रियो ब्रान्को#,
		},
		'America/Santiago' => {
			exemplarCity => q#सेंटिआगो#,
		},
		'America/Santo_Domingo' => {
			exemplarCity => q#साँतो डोमिंगो#,
		},
		'America/Sao_Paulo' => {
			exemplarCity => q#साँव पावलो#,
		},
		'America/Scoresbysund' => {
			exemplarCity => q#स्कोर्सबाइसुंड#,
		},
		'America/St_Johns' => {
			exemplarCity => q#सेंट जोन्स#,
		},
		'America/St_Kitts' => {
			exemplarCity => q#सेंट किट्स#,
		},
		'America/St_Lucia' => {
			exemplarCity => q#सेंट लुसीया#,
		},
		'America/St_Thomas' => {
			exemplarCity => q#सेंट टॉमस#,
		},
		'America/St_Vincent' => {
			exemplarCity => q#सेंट विन्संट#,
		},
		'America/Swift_Current' => {
			exemplarCity => q#स्विफ्ट करंट#,
		},
		'America/Thule' => {
			exemplarCity => q#थ्यूल#,
		},
		'America/Thunder_Bay' => {
			exemplarCity => q#थंडर खाडी#,
		},
		'America/Tijuana' => {
			exemplarCity => q#टिहुआना#,
		},
		'America/Toronto' => {
			exemplarCity => q#टोरोंटो#,
		},
		'America/Tortola' => {
			exemplarCity => q#टॉरटोला#,
		},
		'America/Vancouver' => {
			exemplarCity => q#वानकुवर#,
		},
		'America/Whitehorse' => {
			exemplarCity => q#व्हाईट हॉर्स#,
		},
		'America/Winnipeg' => {
			exemplarCity => q#विनीपॅग#,
		},
		'America/Yakutat' => {
			exemplarCity => q#यकूतत#,
		},
		'America/Yellowknife' => {
			exemplarCity => q#यलोनाईफ#,
		},
		'America_Central' => {
			long => {
				'daylight' => q#सैंट्रल अमरिका डेलाईट टाईम#,
				'generic' => q#सैंट्रल अमरिका टाईम#,
				'standard' => q#सैंट्रल अमरिका स्टैंडर्ड टाईम#,
			},
		},
		'America_Eastern' => {
			long => {
				'daylight' => q#ईस्टर्न अमरिका डेलाईट टाईम#,
				'generic' => q#ईस्टर्न अमरिका टाईम#,
				'standard' => q#ईस्टर्न अमरिका स्टैंडर्ड टाईम#,
			},
		},
		'America_Mountain' => {
			long => {
				'daylight' => q#अमरिका माऊन्टन डेलाईट टाईम#,
				'generic' => q#अमरिका माऊन्टन टाईम#,
				'standard' => q#अमरिका माऊन्टन स्टैंडर्ड टाईम#,
			},
		},
		'America_Pacific' => {
			long => {
				'daylight' => q#पैसीफीक डेलाईट टाईम#,
				'generic' => q#पैसीफीक टाईम#,
				'standard' => q#पैसीफीक स्टैंडर्ड टाईम#,
			},
		},
		'Anadyr' => {
			long => {
				'daylight' => q#अनादीर समर टाईम#,
				'generic' => q#अनादीर टाईम#,
				'standard' => q#अनादीर स्टैंडर्ड टाईम#,
			},
		},
		'Antarctica/Casey' => {
			exemplarCity => q#केसी#,
		},
		'Antarctica/Davis' => {
			exemplarCity => q#डेविस#,
		},
		'Antarctica/DumontDUrville' => {
			exemplarCity => q#डुमॉं ड्युरवील#,
		},
		'Antarctica/Mawson' => {
			exemplarCity => q#मॉसन#,
		},
		'Antarctica/McMurdo' => {
			exemplarCity => q#मकमर्डो#,
		},
		'Antarctica/Palmer' => {
			exemplarCity => q#पामर#,
		},
		'Antarctica/Rothera' => {
			exemplarCity => q#रोथेरा#,
		},
		'Antarctica/Syowa' => {
			exemplarCity => q#स्योवा#,
		},
		'Antarctica/Vostok' => {
			exemplarCity => q#वॉस्तॉक#,
		},
		'Aqtau' => {
			long => {
				'daylight' => q#अक़्टाऊ समर टाईम#,
				'generic' => q#अक़्टाऊ टाईम#,
				'standard' => q#अक़्टाऊ स्टैंडर्ड टाईम#,
			},
		},
		'Aqtobe' => {
			long => {
				'daylight' => q#अक़्टोबे समर टाईम#,
				'generic' => q#अक़्टोबे टाईम#,
				'standard' => q#अक़्टोबे स्टैंडर्ड टाईम#,
			},
		},
		'Arabian' => {
			long => {
				'daylight' => q#अरबी डेलाईट टाईम#,
				'generic' => q#अरबी टाईम#,
				'standard' => q#अरबी स्टैंडर्ड टाईम#,
			},
		},
		'Argentina' => {
			long => {
				'daylight' => q#अर्जण्टिना समर टाईम#,
				'generic' => q#अर्जनटिना टाईम#,
				'standard' => q#अर्जनटिना स्टैंडर्ड टाईम#,
			},
		},
		'Argentina_Western' => {
			long => {
				'daylight' => q#पश्चीम अर्जण्टिना समर टाईम#,
				'generic' => q#पश्चीम अर्जण्टिना टाईम#,
				'standard' => q#पश्चीम अर्जण्टिना स्टैंडर्ड टाईम#,
			},
		},
		'Armenia' => {
			long => {
				'daylight' => q#आरमीनी समर टाईम#,
				'generic' => q#आरमीनी टाईम#,
				'standard' => q#आरमीनी स्टैंडर्ड टाईम#,
			},
		},
		'Asia/Aden' => {
			exemplarCity => q#एडन#,
		},
		'Asia/Almaty' => {
			exemplarCity => q#अल्माटी#,
		},
		'Asia/Amman' => {
			exemplarCity => q#अमान#,
		},
		'Asia/Anadyr' => {
			exemplarCity => q#अनाडीर#,
		},
		'Asia/Aqtau' => {
			exemplarCity => q#अक्ताउ#,
		},
		'Asia/Aqtobe' => {
			exemplarCity => q#अक़्टोबे#,
		},
		'Asia/Ashgabat' => {
			exemplarCity => q#अश्गाबात#,
		},
		'Asia/Baghdad' => {
			exemplarCity => q#बग़दाद#,
		},
		'Asia/Bahrain' => {
			exemplarCity => q#बहरीन#,
		},
		'Asia/Baku' => {
			exemplarCity => q#बाकू#,
		},
		'Asia/Bangkok' => {
			exemplarCity => q#बैंगकॉक#,
		},
		'Asia/Beirut' => {
			exemplarCity => q#बैरुत#,
		},
		'Asia/Bishkek' => {
			exemplarCity => q#बिश्केक#,
		},
		'Asia/Brunei' => {
			exemplarCity => q#ब्रुनइ#,
		},
		'Asia/Choibalsan' => {
			exemplarCity => q#चोइबालसन#,
		},
		'Asia/Colombo' => {
			exemplarCity => q#कोलंबो#,
		},
		'Asia/Damascus' => {
			exemplarCity => q#दमास्कस#,
		},
		'Asia/Dhaka' => {
			exemplarCity => q#ढाका#,
		},
		'Asia/Dili' => {
			exemplarCity => q#डिली#,
		},
		'Asia/Dubai' => {
			exemplarCity => q#दुबई#,
		},
		'Asia/Dushanbe' => {
			exemplarCity => q#दुशांबे#,
		},
		'Asia/Gaza' => {
			exemplarCity => q#गाज़ा#,
		},
		'Asia/Hong_Kong' => {
			exemplarCity => q#हाँगकाँग#,
		},
		'Asia/Hovd' => {
			exemplarCity => q#होव्ड#,
		},
		'Asia/Irkutsk' => {
			exemplarCity => q#ईर्कुत्स्क#,
		},
		'Asia/Jakarta' => {
			exemplarCity => q#जाकार्ता#,
		},
		'Asia/Jayapura' => {
			exemplarCity => q#जयापुरा#,
		},
		'Asia/Jerusalem' => {
			exemplarCity => q#येरुसलम#,
		},
		'Asia/Kabul' => {
			exemplarCity => q#काबूल#,
		},
		'Asia/Kamchatka' => {
			exemplarCity => q#कामचटका#,
		},
		'Asia/Karachi' => {
			exemplarCity => q#कराची#,
		},
		'Asia/Katmandu' => {
			exemplarCity => q#काठमांडौ#,
		},
		'Asia/Krasnoyarsk' => {
			exemplarCity => q#क्रास्नोयार्स्क#,
		},
		'Asia/Kuala_Lumpur' => {
			exemplarCity => q#क्वाला लम्पुर#,
		},
		'Asia/Kuching' => {
			exemplarCity => q#कूचिंग#,
		},
		'Asia/Kuwait' => {
			exemplarCity => q#कुवैत#,
		},
		'Asia/Macau' => {
			exemplarCity => q#मकाऊ#,
		},
		'Asia/Magadan' => {
			exemplarCity => q#मगदन#,
		},
		'Asia/Makassar' => {
			exemplarCity => q#माकास्सार#,
		},
		'Asia/Manila' => {
			exemplarCity => q#मनीला#,
		},
		'Asia/Muscat' => {
			exemplarCity => q#मस्कट#,
		},
		'Asia/Nicosia' => {
			exemplarCity => q#निकोसिया#,
		},
		'Asia/Novosibirsk' => {
			exemplarCity => q#नोवोसिबिर्स्क#,
		},
		'Asia/Omsk' => {
			exemplarCity => q#ओम्स्क#,
		},
		'Asia/Oral' => {
			exemplarCity => q#ओराल#,
		},
		'Asia/Phnom_Penh' => {
			exemplarCity => q#नॉम पेन#,
		},
		'Asia/Pontianak' => {
			exemplarCity => q#पोंतिआनाक#,
		},
		'Asia/Pyongyang' => {
			exemplarCity => q#प्योंगयाँग#,
		},
		'Asia/Qatar' => {
			exemplarCity => q#क़तार#,
		},
		'Asia/Qyzylorda' => {
			exemplarCity => q#कीज़ीलोर्डा#,
		},
		'Asia/Rangoon' => {
			exemplarCity => q#रंगून#,
		},
		'Asia/Riyadh' => {
			exemplarCity => q#रियाध#,
		},
		'Asia/Saigon' => {
			exemplarCity => q#साइगॉन#,
		},
		'Asia/Sakhalin' => {
			exemplarCity => q#सख़ालिन#,
		},
		'Asia/Samarkand' => {
			exemplarCity => q#समरकंद#,
		},
		'Asia/Seoul' => {
			exemplarCity => q#सोल#,
		},
		'Asia/Singapore' => {
			exemplarCity => q#सिंगापुर#,
		},
		'Asia/Taipei' => {
			exemplarCity => q#ताइपेइ#,
		},
		'Asia/Tashkent' => {
			exemplarCity => q#ताशकंद#,
		},
		'Asia/Tbilisi' => {
			exemplarCity => q#तिबिलिसी#,
		},
		'Asia/Tehran' => {
			exemplarCity => q#तेहरान#,
		},
		'Asia/Thimphu' => {
			exemplarCity => q#थिम्पु#,
		},
		'Asia/Tokyo' => {
			exemplarCity => q#टोक्यो#,
		},
		'Asia/Ulaanbaatar' => {
			exemplarCity => q#उलानबातर#,
		},
		'Asia/Urumqi' => {
			exemplarCity => q#उरुमकी#,
		},
		'Asia/Vientiane' => {
			exemplarCity => q#वियंसियान#,
		},
		'Asia/Vladivostok' => {
			exemplarCity => q#व्लाडिवॉस्टोक#,
		},
		'Asia/Yakutsk' => {
			exemplarCity => q#याकूत्स्क#,
		},
		'Asia/Yekaterinburg' => {
			exemplarCity => q#येकातेरिनबर्ग#,
		},
		'Asia/Yerevan' => {
			exemplarCity => q#येरेवान#,
		},
		'Atlantic' => {
			long => {
				'daylight' => q#अटलांटीक डेलाईट टाईम#,
				'generic' => q#अटलांटीक टाईम#,
				'standard' => q#अटलांटीक स्टैंडर्ड टाईम#,
			},
		},
		'Atlantic/Azores' => {
			exemplarCity => q#अज़ोर#,
		},
		'Atlantic/Bermuda' => {
			exemplarCity => q#बर्मुडा#,
		},
		'Atlantic/Canary' => {
			exemplarCity => q#कनेरी द्वीप#,
		},
		'Atlantic/Cape_Verde' => {
			exemplarCity => q#केप वॅर्दे#,
		},
		'Atlantic/Faeroe' => {
			exemplarCity => q#फ़ैरो#,
		},
		'Atlantic/Madeira' => {
			exemplarCity => q#माडेरा#,
		},
		'Atlantic/Reykjavik' => {
			exemplarCity => q#रीकयाविक#,
		},
		'Atlantic/South_Georgia' => {
			exemplarCity => q#साउथ जॉर्जिया#,
		},
		'Atlantic/St_Helena' => {
			exemplarCity => q#सेंट हेलेना#,
		},
		'Atlantic/Stanley' => {
			exemplarCity => q#स्टैनली#,
		},
		'Australia/Adelaide' => {
			exemplarCity => q#एडलेड्#,
		},
		'Australia/Brisbane' => {
			exemplarCity => q#ब्रीसबेन्#,
		},
		'Australia/Broken_Hill' => {
			exemplarCity => q#ब्रोकन हिल्#,
		},
		'Australia/Currie' => {
			exemplarCity => q#करी#,
		},
		'Australia/Darwin' => {
			exemplarCity => q#डार्विन्#,
		},
		'Australia/Eucla' => {
			exemplarCity => q#यूक्ला#,
		},
		'Australia/Hobart' => {
			exemplarCity => q#होबार्ट्#,
		},
		'Australia/Lindeman' => {
			exemplarCity => q#लिंडमेन्#,
		},
		'Australia/Lord_Howe' => {
			exemplarCity => q#लोर्ड होव्#,
		},
		'Australia/Melbourne' => {
			exemplarCity => q#मेलबोर्न्#,
		},
		'Australia/Perth' => {
			exemplarCity => q#पर्थ#,
		},
		'Australia/Sydney' => {
			exemplarCity => q#सिडनी#,
		},
		'Australia_Central' => {
			long => {
				'daylight' => q#मध्य ओस्ट्रेलिया डेलाईट टाईम#,
				'generic' => q#ओस्ट्रेलिया टाईम#,
				'standard' => q#मध्य ओस्ट्रेलिया स्टैंडर्ड टाईम#,
			},
		},
		'Australia_CentralWestern' => {
			long => {
				'daylight' => q#मध्य-पश्चीम ओस्ट्रेलिया डेलाईट टाईम#,
				'generic' => q#मध्य-पश्चीम ओस्ट्रेलिया टाईम#,
				'standard' => q#मध्य-पश्चीम ओस्ट्रेलिया स्टैंडर्ड टाईम#,
			},
		},
		'Australia_Eastern' => {
			long => {
				'daylight' => q#पूर्वी ओस्ट्रेलिया डेलाईट टाईम#,
				'generic' => q#पूर्वी ओस्ट्रेलिया टाईम#,
				'standard' => q#पूर्वी ओस्ट्रेलिया स्टैंडर्ड टाईम#,
			},
		},
		'Australia_Western' => {
			long => {
				'daylight' => q#दक्षिण ओस्ट्रेलिया डेलाईट टाईम#,
				'generic' => q#दक्षिण ओस्ट्रेलिया टाईम#,
				'standard' => q#दक्षिण ओस्ट्रेलिया स्टैंडर्ड टाईम#,
			},
		},
		'Azerbaijan' => {
			long => {
				'daylight' => q#आज़रबैजान समर टाईम#,
				'generic' => q#आज़रबैजान टाईम#,
				'standard' => q#आज़रबैजान स्टैंडर्ड टाईम#,
			},
		},
		'Azores' => {
			long => {
				'daylight' => q#आज़ोर समर टाईम#,
				'generic' => q#आज़ोर टाईम#,
				'standard' => q#आज़ोर स्टैंडर्ड टाईम#,
			},
		},
		'Bangladesh' => {
			long => {
				'daylight' => q#बांगलादेश समर टाईम#,
				'generic' => q#बांगलादेश टाईम#,
				'standard' => q#बांगलादेश स्टैंडर्ड टाईम#,
			},
		},
		'Bhutan' => {
			long => {
				'standard' => q#भुटान स्टैंडर्ड टाईम#,
			},
		},
		'Bolivia' => {
			long => {
				'standard' => q#बोलिविया स्टैंडर्ड टाईम#,
			},
		},
		'Brasilia' => {
			long => {
				'daylight' => q#ब्राज़ीलिया समर टाईम#,
				'generic' => q#ब्राज़ीलिया टाईम#,
				'standard' => q#ब्राज़ीलिया स्टैंडर्ड टाईम#,
			},
		},
		'Brunei' => {
			long => {
				'standard' => q#ब्रुनेई दर उस सलाम स्टैंडर्ड टाईम#,
			},
		},
		'Cape_Verde' => {
			long => {
				'daylight' => q#काप वेर्दे समर टाईम#,
				'generic' => q#काप वेर्दे टाईम#,
				'standard' => q#काप वेर्दे स्टैंडर्ड टाईम#,
			},
		},
		'Chamorro' => {
			long => {
				'standard' => q#चामरो स्टैंडर्ड टाईम#,
			},
		},
		'Chatham' => {
			long => {
				'daylight' => q#चैथम डेलाईट टाईम#,
				'generic' => q#चैथम टाईम#,
				'standard' => q#चैथम स्टैंडर्ड टाईम#,
			},
		},
		'Chile' => {
			long => {
				'daylight' => q#चीली समर टाईम#,
				'generic' => q#चीली टाईम#,
				'standard' => q#चीली स्टैंडर्ड टाईम#,
			},
		},
		'China' => {
			long => {
				'daylight' => q#चाईना डेलाईट टाईम#,
				'generic' => q#चाईना टाईम#,
				'standard' => q#चाईना स्टैंडर्ड टाईम#,
			},
		},
		'Choibalsan' => {
			long => {
				'daylight' => q#चोईबालसान समर टाईम#,
				'generic' => q#चोईबालसान टाईम#,
				'standard' => q#चोईबालसान स्टैंडर्ड टाईम#,
			},
		},
		'Christmas' => {
			long => {
				'standard' => q#क्रीसमस स्टैंडर्ड टाईम#,
			},
		},
		'Cocos' => {
			long => {
				'standard' => q#कोको द्वीप स्टैंडर्ड टाईम#,
			},
		},
		'Colombia' => {
			long => {
				'daylight' => q#कोलंबिया समर टाईम#,
				'generic' => q#कोलंबिया टाईम#,
				'standard' => q#कोलंबिया स्टैंडर्ड टाईम#,
			},
		},
		'Cook' => {
			long => {
				'daylight' => q#कुक द्वीप अर्ध समर टाईम#,
				'generic' => q#कुक द्वीप टाईम#,
				'standard' => q#कुक द्वीप स्टैंडर्ड टाईम#,
			},
		},
		'Cuba' => {
			long => {
				'daylight' => q#क्युबा डेलाईट टाईम#,
				'generic' => q#क्युबा टाईम#,
				'standard' => q#क्युबा स्टैंडर्ड टाईम#,
			},
		},
		'Davis' => {
			long => {
				'standard' => q#डेवीस स्टैंडर्ड टाईम#,
			},
		},
		'DumontDUrville' => {
			long => {
				'standard' => q#ड्युमों ड्युरवील स्टैंडर्ड टाईम#,
			},
		},
		'East_Timor' => {
			long => {
				'standard' => q#ईस्ट टीमोर स्टैंडर्ड टाईम#,
			},
		},
		'Easter' => {
			long => {
				'daylight' => q#ईस्टर आईलंड समर टाईम#,
				'generic' => q#ईस्टर आईलंड टाईम#,
				'standard' => q#ईस्टर आईलंड स्टैंडर्ड टाईम#,
			},
		},
		'Ecuador' => {
			long => {
				'standard' => q#एक्वाडौर स्टैंडर्ड टाईम#,
			},
		},
		'Etc/Unknown' => {
			exemplarCity => q#अज्ञात#,
		},
		'Europe/Amsterdam' => {
			exemplarCity => q#ऐम्स्टरडम#,
		},
		'Europe/Andorra' => {
			exemplarCity => q#अंडोरा#,
		},
		'Europe/Athens' => {
			exemplarCity => q#एथन्स#,
		},
		'Europe/Berlin' => {
			exemplarCity => q#बर्लिन#,
		},
		'Europe/Brussels' => {
			exemplarCity => q#ब्रसल्स#,
		},
		'Europe/Bucharest' => {
			exemplarCity => q#बुकारेस्ट#,
		},
		'Europe/Budapest' => {
			exemplarCity => q#बुदापेस्ट#,
		},
		'Europe/Chisinau' => {
			exemplarCity => q#चिसीनौ#,
		},
		'Europe/Copenhagen' => {
			exemplarCity => q#कोपनहागन#,
		},
		'Europe/Dublin' => {
			exemplarCity => q#डबलिन#,
			long => {
				'daylight' => q#आईरीश समर टाईम#,
			},
		},
		'Europe/Gibraltar' => {
			exemplarCity => q#जिब्राल्टर#,
		},
		'Europe/Helsinki' => {
			exemplarCity => q#हैल्सिंकी#,
		},
		'Europe/Istanbul' => {
			exemplarCity => q#इस्तांबुल#,
		},
		'Europe/Kaliningrad' => {
			exemplarCity => q#कालिलीनग्राड#,
		},
		'Europe/Kiev' => {
			exemplarCity => q#कीव#,
		},
		'Europe/Lisbon' => {
			exemplarCity => q#लिस्बन#,
		},
		'Europe/London' => {
			exemplarCity => q#लंदन#,
			long => {
				'daylight' => q#ब्रीटीश समर टाईम#,
			},
		},
		'Europe/Luxembourg' => {
			exemplarCity => q#लक्ज़मबर्ग#,
		},
		'Europe/Madrid' => {
			exemplarCity => q#मैड्रिड#,
		},
		'Europe/Malta' => {
			exemplarCity => q#माल्टा#,
		},
		'Europe/Minsk' => {
			exemplarCity => q#मिन्स्क#,
		},
		'Europe/Monaco' => {
			exemplarCity => q#मोनाको#,
		},
		'Europe/Moscow' => {
			exemplarCity => q#मॉस्को#,
		},
		'Europe/Oslo' => {
			exemplarCity => q#ओस्लो#,
		},
		'Europe/Paris' => {
			exemplarCity => q#पॅरिस#,
		},
		'Europe/Riga' => {
			exemplarCity => q#रिगा#,
		},
		'Europe/Rome' => {
			exemplarCity => q#रोम#,
		},
		'Europe/Samara' => {
			exemplarCity => q#समारा#,
		},
		'Europe/Simferopol' => {
			exemplarCity => q#सिम्फेरोपोल#,
		},
		'Europe/Sofia' => {
			exemplarCity => q#सोफ़िया#,
		},
		'Europe/Stockholm' => {
			exemplarCity => q#स्टॉकहॉम#,
		},
		'Europe/Tallinn' => {
			exemplarCity => q#टैलिन#,
		},
		'Europe/Tirane' => {
			exemplarCity => q#टिरान#,
		},
		'Europe/Uzhgorod' => {
			exemplarCity => q#उज़्गोरोड्#,
		},
		'Europe/Vaduz' => {
			exemplarCity => q#वादुज़#,
		},
		'Europe/Vienna' => {
			exemplarCity => q#वियेना#,
		},
		'Europe/Vilnius' => {
			exemplarCity => q#विल्निउस#,
		},
		'Europe/Volgograd' => {
			exemplarCity => q#वोल्गोग्राड#,
		},
		'Europe/Warsaw' => {
			exemplarCity => q#वॉरसॉ#,
		},
		'Europe/Zaporozhye' => {
			exemplarCity => q#झापरोझ्य#,
		},
		'Europe/Zurich' => {
			exemplarCity => q#ज़्युरिक#,
		},
		'Europe_Central' => {
			long => {
				'daylight' => q#मध्य यूरोप समर टाईम#,
				'generic' => q#मध्य यूरोप टाईम#,
				'standard' => q#मध्य यूरोप स्टैंडर्ड टाईम#,
			},
		},
		'Europe_Eastern' => {
			long => {
				'daylight' => q#ईस्टर्न यूरोप समर टाईम#,
				'generic' => q#ईस्टर्न यूरोप टाईम#,
				'standard' => q#ईस्टर्न यूरोप स्टैंडर्ड टाईम#,
			},
		},
		'Europe_Western' => {
			long => {
				'daylight' => q#वेस्टर्न यूरोप समर टाईम#,
				'generic' => q#वेस्टर्न यूरोप टाईम#,
				'standard' => q#वेस्टर्न यूरोप स्टैंडर्ड टाईम#,
			},
		},
		'Falkland' => {
			long => {
				'daylight' => q#फ़ाल्कलैण्ड समर टाईम#,
				'generic' => q#फ़ाल्कलैण्ड टाईम#,
				'standard' => q#फ़ाल्कलैण्ड स्टैंडर्ड टाईम#,
			},
		},
		'Fiji' => {
			long => {
				'daylight' => q#फीजी समर टाईम#,
				'generic' => q#फीजी टाईम#,
				'standard' => q#फीजी स्टैंडर्ड टाईम#,
			},
		},
		'French_Guiana' => {
			long => {
				'standard' => q#फ्रान्सीसी गुयाना स्टैंडर्ड टाईम#,
			},
		},
		'French_Southern' => {
			long => {
				'standard' => q#दक्षिण फ्रान्सीसी स्टैंडर्ड टाईम#,
			},
		},
		'GMT' => {
			long => {
				'standard' => q#ग्रीनीच स्टैंडर्ड टाईम#,
			},
		},
		'Galapagos' => {
			long => {
				'standard' => q#गालापागोस स्टैंडर्ड टाईम#,
			},
		},
		'Gambier' => {
			long => {
				'standard' => q#गांबिये स्टैंडर्ड टाईम#,
			},
		},
		'Georgia' => {
			long => {
				'daylight' => q#जोर्जिया समर टाईम#,
				'generic' => q#जोर्जिया टाईम#,
				'standard' => q#जोर्जिया स्टैंडर्ड टाईम#,
			},
		},
		'Gilbert_Islands' => {
			long => {
				'standard' => q#गीलबर्ट द्वीप स्टैंडर्ड टाईम#,
			},
		},
		'Greenland_Eastern' => {
			long => {
				'daylight' => q#ग्रीनलैण्ड ईस्टर्न समर टाईम#,
				'generic' => q#ग्रीनलैण्ड ईस्टर्न टाईम#,
				'standard' => q#ग्रीनलैण्ड ईस्टर्न स्टैंडर्ड टाईम#,
			},
		},
		'Greenland_Western' => {
			long => {
				'daylight' => q#ग्रीनलैण्ड वेस्टर्न समर टाईम#,
				'generic' => q#ग्रीनलैण्ड वेस्टर्न टाईम#,
				'standard' => q#ग्रीनलैण्ड वेस्टर्न स्टैंडर्ड टाईम#,
			},
		},
		'Guam' => {
			long => {
				'standard' => q#गुआम स्टैंडर्ड टाईम#,
			},
		},
		'Gulf' => {
			long => {
				'standard' => q#गल्फ़ स्टैंडर्ड टाईम#,
			},
		},
		'Guyana' => {
			long => {
				'standard' => q#गुयाना स्टैंडर्ड टाईम#,
			},
		},
		'Hawaii_Aleutian' => {
			long => {
				'daylight' => q#हवाई आलटन डेलाईट टाईम#,
				'generic' => q#हवाई आलटन टाईम#,
				'standard' => q#हवाई आलटन स्टैंडर्ड टाईम#,
			},
		},
		'Hong_Kong' => {
			long => {
				'daylight' => q#हाँगकॉंग समर टाईम#,
				'generic' => q#हाँगकॉंग टाईम#,
				'standard' => q#हाँगकॉंग स्टैंडर्ड टाईम#,
			},
		},
		'Hovd' => {
			long => {
				'daylight' => q#होव्ड समर टाईम#,
				'generic' => q#होव्ड टाईम#,
				'standard' => q#होव्ड स्टैंडर्ड टाईम#,
			},
		},
		'India' => {
			long => {
				'standard' => q#भारतीय स्टैंडर्ड टाईम#,
			},
			short => {
				'standard' => q#IST#,
			},
		},
		'Indian/Antananarivo' => {
			exemplarCity => q#ऐंटनानरीवो#,
		},
		'Indian/Chagos' => {
			exemplarCity => q#चागोस#,
		},
		'Indian/Christmas' => {
			exemplarCity => q#क्रिस्मस आइलैंड#,
		},
		'Indian/Cocos' => {
			exemplarCity => q#कोकोस#,
		},
		'Indian/Comoro' => {
			exemplarCity => q#कोमोरो#,
		},
		'Indian/Kerguelen' => {
			exemplarCity => q#कॅरगेइलेन#,
		},
		'Indian/Mahe' => {
			exemplarCity => q#माहे#,
		},
		'Indian/Maldives' => {
			exemplarCity => q#मालदीव#,
		},
		'Indian/Mauritius' => {
			exemplarCity => q#मॉरिशस#,
		},
		'Indian/Mayotte' => {
			exemplarCity => q#मायोट#,
		},
		'Indian/Reunion' => {
			exemplarCity => q#रेयूनियॉं#,
		},
		'Indian_Ocean' => {
			long => {
				'standard' => q#भारतीय महासगर स्टैंडर्ड टाईम#,
			},
		},
		'Indochina' => {
			long => {
				'standard' => q#ईंडो चइना स्टैंडर्ड टाईम#,
			},
		},
		'Indonesia_Central' => {
			long => {
				'standard' => q#ईंडोनीशिया स्टैंडर्ड टाईम#,
			},
		},
		'Indonesia_Eastern' => {
			long => {
				'standard' => q#ईस्टर्न ईंडोनीशिया स्टैंडर्ड टाईम#,
			},
		},
		'Indonesia_Western' => {
			long => {
				'standard' => q#वेस्टर्न ईंडोनीशिया स्टैंडर्ड टाईम#,
			},
		},
		'Iran' => {
			long => {
				'daylight' => q#ईरान डेलाईट टाईम#,
				'generic' => q#ईरान टाईम#,
				'standard' => q#ईरान स्टैंडर्ड टाईम#,
			},
		},
		'Irkutsk' => {
			long => {
				'daylight' => q#ईरकुर्त्स्क समर टाईम#,
				'generic' => q#ईरकुर्त्स्क टाईम#,
				'standard' => q#ईरकुर्त्स्क स्टैंडर्ड टाईम#,
			},
		},
		'Israel' => {
			long => {
				'daylight' => q#ईस्राइल डेलाईट टाईम#,
				'generic' => q#ईस्राइल टाईम#,
				'standard' => q#ईस्राइल स्टैंडर्ड टाईम#,
			},
		},
		'Japan' => {
			long => {
				'daylight' => q#जपान डेलाईट टाईम#,
				'generic' => q#जपान टाईम#,
				'standard' => q#जपान स्टैंडर्ड टाईम#,
			},
		},
		'Kamchatka' => {
			long => {
				'daylight' => q#पेत्रोपावलोस्क कामचटका समर टाईम#,
				'generic' => q#पेत्रोपावलोस्क कामचटका टाईम#,
				'standard' => q#पेत्रोपावलोस्क कामचटका स्टैंडर्ड टाईम#,
			},
		},
		'Kazakhstan_Eastern' => {
			long => {
				'standard' => q#क़ज़ाख़स्तान टाईम#,
			},
		},
		'Kazakhstan_Western' => {
			long => {
				'standard' => q#वेस्टर्न क़ज़ाख़स्तान टाईम#,
			},
		},
		'Korea' => {
			long => {
				'daylight' => q#कोरिया डेलाईट टाईम#,
				'generic' => q#कोरिया टाईम#,
				'standard' => q#कोरिया स्टैंडर्ड टाईम#,
			},
		},
		'Kosrae' => {
			long => {
				'standard' => q#कोसरी स्टैंडर्ड टाईम#,
			},
		},
		'Krasnoyarsk' => {
			long => {
				'daylight' => q#क्रासनोयार्स्क समर टाईम#,
				'generic' => q#क्रासनोयार्स्क टाईम#,
				'standard' => q#क्रासनोयार्स्क स्टैंडर्ड टाईम#,
			},
		},
		'Kyrgystan' => {
			long => {
				'standard' => q#क़ीर्ग़स्तान स्टैंडर्ड टाईम#,
			},
		},
		'Lanka' => {
			long => {
				'standard' => q#लंका स्टैंडर्ड टाईम#,
			},
		},
		'Line_Islands' => {
			long => {
				'standard' => q#लाईन द्वीप स्टैंडर्ड टाईम#,
			},
		},
		'Lord_Howe' => {
			long => {
				'daylight' => q#लार्ड़ होव डेलाईट टाईम#,
				'generic' => q#लार्ड़ होव टाईम#,
				'standard' => q#लार्ड़ होव स्टैंडर्ड टाईम#,
			},
		},
		'Macau' => {
			long => {
				'daylight' => q#माकाऊ समर टाईम#,
				'generic' => q#माकाऊ टाईम#,
				'standard' => q#माकाऊ स्टैंडर्ड टाईम#,
			},
		},
		'Magadan' => {
			long => {
				'daylight' => q#मगदन समर टाईम#,
				'generic' => q#मगदन टाईम#,
				'standard' => q#मगदन स्टैंडर्ड टाईम#,
			},
		},
		'Malaysia' => {
			long => {
				'standard' => q#मलेशिया स्टैंडर्ड टाईम#,
			},
		},
		'Maldives' => {
			long => {
				'standard' => q#मालदीव स्टैंडर्ड टाईम#,
			},
		},
		'Marquesas' => {
			long => {
				'standard' => q#मार्केज़ास स्टैंडर्ड टाईम#,
			},
		},
		'Marshall_Islands' => {
			long => {
				'standard' => q#मार्शल र्स्टैंडर्ड टाईम#,
			},
		},
		'Mauritius' => {
			long => {
				'daylight' => q#मॉरिशीयस समर टाईम#,
				'generic' => q#मॉरिशीयस टाईम#,
				'standard' => q#मॉरिशीयस स्टैंडर्ड टाईम#,
			},
		},
		'Mawson' => {
			long => {
				'standard' => q#मॉसन स्टैंडर्ड टाईम#,
			},
		},
		'Mongolia' => {
			long => {
				'daylight' => q#मँगोलिया समर टाईम#,
				'generic' => q#मँगोलिया टाईम#,
				'standard' => q#मँगोलिया स्टैंडर्ड टाईम#,
			},
		},
		'Moscow' => {
			long => {
				'daylight' => q#मॉस्को समर टाईम#,
				'generic' => q#मॉस्को टाईम#,
				'standard' => q#मॉस्को स्टैंडर्ड टाईम#,
			},
		},
		'Myanmar' => {
			long => {
				'standard' => q#म्यानमार स्टैंडर्ड टाईम#,
			},
		},
		'Nauru' => {
			long => {
				'standard' => q#नाऊरु स्टैंडर्ड टाईम#,
			},
		},
		'Nepal' => {
			long => {
				'standard' => q#नेपाल स्टैंडर्ड टाईम#,
			},
		},
		'New_Caledonia' => {
			long => {
				'daylight' => q#न्यु कैलेडोनिया समर टाईम#,
				'generic' => q#न्यु कैलेडोनिया टाईम#,
				'standard' => q#न्यु कैलेडोनिया स्टैंडर्ड टाईम#,
			},
		},
		'New_Zealand' => {
			long => {
				'daylight' => q#न्युज़ीलैण्ड डेलाईट टाईम#,
				'generic' => q#न्युज़ीलैण्ड टाईम#,
				'standard' => q#न्युज़ीलैण्ड स्टैंडर्ड टाईम#,
			},
		},
		'Newfoundland' => {
			long => {
				'daylight' => q#न्युफाऊंडलैण्ड डेलाईट टाईम#,
				'generic' => q#न्युफाऊंडलैण्ड टाईम#,
				'standard' => q#न्युफाऊंडलैण्ड स्टैंडर्ड टाईम#,
			},
		},
		'Niue' => {
			long => {
				'standard' => q#नीऊई स्टैंडर्ड टाईम#,
			},
		},
		'Norfolk' => {
			long => {
				'standard' => q#नॉरफोक स्टैंडर्ड टाईम#,
			},
		},
		'Noronha' => {
			long => {
				'daylight' => q#फेरनान्दो द नोरोन्हा समर टाईम#,
				'generic' => q#फेरनान्दो द नोरोन्हा टाईम#,
				'standard' => q#फेरनान्दो द नोरोन्हा स्टैंडर्ड टाईम#,
			},
		},
		'North_Mariana' => {
			long => {
				'standard' => q#नॉर्थ मारिआना स्टैंडर्ड टाईम#,
			},
		},
		'Novosibirsk' => {
			long => {
				'daylight' => q#नोवोसीबीर्स्क समर टाईम#,
				'generic' => q#नोवोसीबीर्स्क टाईम#,
				'standard' => q#नोवोसीबीर्स्क स्टैंडर्ड टाईम#,
			},
		},
		'Omsk' => {
			long => {
				'daylight' => q#ओम्स्क समर टाईम#,
				'generic' => q#ओम्स्क टाईम#,
				'standard' => q#ओम्स्क स्टैंडर्ड टाईम#,
			},
		},
		'Pacific/Apia' => {
			exemplarCity => q#आपिआ#,
		},
		'Pacific/Auckland' => {
			exemplarCity => q#औकलैण्ड#,
		},
		'Pacific/Chatham' => {
			exemplarCity => q#चॅथम#,
		},
		'Pacific/Easter' => {
			exemplarCity => q#ईस्टर आइलैंड#,
		},
		'Pacific/Efate' => {
			exemplarCity => q#एफ़ाटे#,
		},
		'Pacific/Enderbury' => {
			exemplarCity => q#एंडरबरी#,
		},
		'Pacific/Fakaofo' => {
			exemplarCity => q#फ़काओफ़ो#,
		},
		'Pacific/Fiji' => {
			exemplarCity => q#फ़िजी#,
		},
		'Pacific/Funafuti' => {
			exemplarCity => q#फ़ुनाफ़ूटी#,
		},
		'Pacific/Galapagos' => {
			exemplarCity => q#गॅलापागोस#,
		},
		'Pacific/Gambier' => {
			exemplarCity => q#गाम्बिये#,
		},
		'Pacific/Guadalcanal' => {
			exemplarCity => q#ग्वाडालकनाल#,
		},
		'Pacific/Guam' => {
			exemplarCity => q#ग्वाम#,
		},
		'Pacific/Honolulu' => {
			exemplarCity => q#होनोलुलु#,
		},
		'Pacific/Johnston' => {
			exemplarCity => q#जौन्स्टन#,
		},
		'Pacific/Kiritimati' => {
			exemplarCity => q#किरीतिमाति#,
		},
		'Pacific/Kosrae' => {
			exemplarCity => q#कोसराए#,
		},
		'Pacific/Kwajalein' => {
			exemplarCity => q#क्वाजालैन#,
		},
		'Pacific/Majuro' => {
			exemplarCity => q#मजूरो#,
		},
		'Pacific/Marquesas' => {
			exemplarCity => q#मार्केसास#,
		},
		'Pacific/Midway' => {
			exemplarCity => q#मीडवे#,
		},
		'Pacific/Nauru' => {
			exemplarCity => q#नौरू#,
		},
		'Pacific/Niue' => {
			exemplarCity => q#नियुएई#,
		},
		'Pacific/Norfolk' => {
			exemplarCity => q#नोरफ़ोक#,
		},
		'Pacific/Noumea' => {
			exemplarCity => q#नूमिया#,
		},
		'Pacific/Pago_Pago' => {
			exemplarCity => q#पागो पागो#,
		},
		'Pacific/Palau' => {
			exemplarCity => q#पलाऊ#,
		},
		'Pacific/Pitcairn' => {
			exemplarCity => q#पिट्कैर्न#,
		},
		'Pacific/Ponape' => {
			exemplarCity => q#पोनापे#,
		},
		'Pacific/Port_Moresby' => {
			exemplarCity => q#पोर्ट मोर्सबी#,
		},
		'Pacific/Rarotonga' => {
			exemplarCity => q#रारोटॉंगा#,
		},
		'Pacific/Saipan' => {
			exemplarCity => q#सइपान#,
		},
		'Pacific/Tahiti' => {
			exemplarCity => q#टाहिटी#,
		},
		'Pacific/Tarawa' => {
			exemplarCity => q#तरावा#,
		},
		'Pacific/Tongatapu' => {
			exemplarCity => q#टॉंगाटापु#,
		},
		'Pacific/Truk' => {
			exemplarCity => q#ट्रुक#,
		},
		'Pacific/Wake' => {
			exemplarCity => q#वाके#,
		},
		'Pacific/Wallis' => {
			exemplarCity => q#वॅलिस#,
		},
		'Pakistan' => {
			long => {
				'daylight' => q#पाकिस्तान समर टाईम#,
				'generic' => q#पाकिस्तान टाईम#,
				'standard' => q#पाकिस्तान स्टैंडर्ड टाईम#,
			},
		},
		'Palau' => {
			long => {
				'standard' => q#पलाऊ स्टैंडर्ड टाईम#,
			},
		},
		'Papua_New_Guinea' => {
			long => {
				'standard' => q#पापुआ न्यु गीनी स्टैंडर्ड टाईम#,
			},
		},
		'Paraguay' => {
			long => {
				'daylight' => q#पारागुए समर टाईम#,
				'generic' => q#पारागुए टाईम#,
				'standard' => q#पारागुए स्टैंडर्ड टाईम#,
			},
		},
		'Peru' => {
			long => {
				'daylight' => q#पेरु समर टाईम#,
				'generic' => q#पेरु टाईम#,
				'standard' => q#पेरु स्टैंडर्ड टाईम#,
			},
		},
		'Philippines' => {
			long => {
				'daylight' => q#फीलीपीन्स समर टाईम#,
				'generic' => q#फीलीपीन्स टाईम#,
				'standard' => q#फीलीपीन्स स्टैंडर्ड टाईम#,
			},
		},
		'Phoenix_Islands' => {
			long => {
				'standard' => q#फीनीक्स द्वीप स्टैंडर्ड टाईम#,
			},
		},
		'Pierre_Miquelon' => {
			long => {
				'daylight' => q#सेँ पीयॅर एवं मीकलों डेलाईट टाईम#,
				'generic' => q#सेँ पीयॅर एवं मीकलों टाईम#,
				'standard' => q#सेँ पीयॅर एवं मीकलों स्टैंडर्ड टाईम#,
			},
		},
		'Pitcairn' => {
			long => {
				'standard' => q#पीटकैर्न स्टैंडर्ड टाईम#,
			},
		},
		'Ponape' => {
			long => {
				'standard' => q#पोनापे (पोह्नपेई) स्टैंडर्ड टाईम#,
			},
		},
		'Qyzylorda' => {
			long => {
				'daylight' => q#क़ीज़ीलोर्डा समर टाईम#,
				'generic' => q#क़ीज़ीलोर्डा टाईम#,
				'standard' => q#क़ीज़ीलोर्डा स्टैंडर्ड टाईम#,
			},
		},
		'Reunion' => {
			long => {
				'standard' => q#रियूनियन स्टैंडर्ड टाईम#,
			},
		},
		'Rothera' => {
			long => {
				'standard' => q#रोथेरा स्टैंडर्ड टाईम#,
			},
		},
		'Sakhalin' => {
			long => {
				'daylight' => q#सख़ालीन समर टाईम#,
				'generic' => q#सख़ालीन टाईम#,
				'standard' => q#सख़ालीन स्टैंडर्ड टाईम#,
			},
		},
		'Samara' => {
			long => {
				'daylight' => q#समारा समर टाईम#,
				'generic' => q#समारा टाईम#,
				'standard' => q#समारा स्टैंडर्ड टाईम#,
			},
		},
		'Samoa' => {
			long => {
				'daylight' => q#समोआ समर टाईम#,
				'generic' => q#समोआ टाईम#,
				'standard' => q#समोआ स्टैंडर्ड टाईम#,
			},
		},
		'Seychelles' => {
			long => {
				'standard' => q#सेशेल्स स्टैंडर्ड टाईम#,
			},
		},
		'Singapore' => {
			long => {
				'standard' => q#सींगापुर स्टैंडर्ड टाईम#,
			},
		},
		'Solomon' => {
			long => {
				'standard' => q#सॉलॉमन स्टैंडर्ड टाईम#,
			},
		},
		'South_Georgia' => {
			long => {
				'standard' => q#साऊथ जॉर्जिया स्टैंडर्ड टाईम#,
			},
		},
		'Suriname' => {
			long => {
				'standard' => q#सुरीनाम स्टैंडर्ड टाईम#,
			},
		},
		'Syowa' => {
			long => {
				'standard' => q#सीओवा स्टैंडर्ड टाईम#,
			},
		},
		'Tahiti' => {
			long => {
				'standard' => q#टाहिटी स्टैंडर्ड टाईम#,
			},
		},
		'Tajikistan' => {
			long => {
				'standard' => q#ताजीक़ीस्तान स्टैंडर्ड टाईम#,
			},
		},
		'Tokelau' => {
			long => {
				'standard' => q#टोकेलौ स्टैंडर्ड टाईम#,
			},
		},
		'Tonga' => {
			long => {
				'daylight' => q#टॉंगा समर टाईम#,
				'generic' => q#टॉंगा टाईम#,
				'standard' => q#टॉंगा स्टैंडर्ड टाईम#,
			},
		},
		'Truk' => {
			long => {
				'standard' => q#ट्रुक स्टैंडर्ड टाईम#,
			},
		},
		'Turkmenistan' => {
			long => {
				'daylight' => q#तुर्कमेनीस्तान समर टाईम#,
				'generic' => q#तुर्कमेनीस्तान टाईम#,
				'standard' => q#तुर्कमेनीस्तान स्टैंडर्ड टाईम#,
			},
		},
		'Tuvalu' => {
			long => {
				'standard' => q#तुवालु स्टैंडर्ड टाईम#,
			},
		},
		'Uruguay' => {
			long => {
				'daylight' => q#ऊरुगुए समर टाईम#,
				'generic' => q#ऊरुगुए टाईम#,
				'standard' => q#ऊरुगुए स्टैंडर्ड टाईम#,
			},
		},
		'Uzbekistan' => {
			long => {
				'daylight' => q#ऊज़्बेकिस्तान समर टाईम#,
				'generic' => q#ऊज़्बेकिस्तान टाईम#,
				'standard' => q#ऊज़्बेकिस्तान स्टैंडर्ड टाईम#,
			},
		},
		'Vanuatu' => {
			long => {
				'daylight' => q#वनुआटु समर टाईम#,
				'generic' => q#वनुआटु टाईम#,
				'standard' => q#वनुआटु स्टैंडर्ड टाईम#,
			},
		},
		'Venezuela' => {
			long => {
				'standard' => q#वेनेज़ुएला स्टैंडर्ड टाईम#,
			},
		},
		'Vladivostok' => {
			long => {
				'daylight' => q#व्लादीवॉस्तॉक डेलाईट टाईम#,
				'generic' => q#व्लादीवॉस्तॉक टाईम#,
				'standard' => q#व्लादीवॉस्तॉक स्टैंडर्ड टाईम#,
			},
		},
		'Volgograd' => {
			long => {
				'daylight' => q#वॉलगोग्राद समर टाईम#,
				'generic' => q#वॉलगोग्राद टाईम#,
				'standard' => q#वॉलगोग्राद स्टैंडर्ड टाईम#,
			},
		},
		'Vostok' => {
			long => {
				'standard' => q#वॉस्तॉक स्टैंडर्ड टाईम#,
			},
		},
		'Wake' => {
			long => {
				'standard' => q#वाके द्वीप स्टैंडर्ड टाईम#,
			},
		},
		'Wallis' => {
			long => {
				'standard' => q#वालीस एवं फ़ुतुना स्टैंडर्ड टाईम#,
			},
		},
		'Yakutsk' => {
			long => {
				'daylight' => q#याकुट्स्क समर टाईम#,
				'generic' => q#याकुट्स्क टाईम#,
				'standard' => q#याकुट्स्क स्टैंडर्ड टाईम#,
			},
		},
		'Yekaterinburg' => {
			long => {
				'daylight' => q#येकातेरीनाबुर्ग समर टाईम#,
				'generic' => q#येकातेरीनाबुर्ग टाईम#,
				'standard' => q#येकातेरीनाबुर्ग स्टैंडर्ड टाईम#,
			},
		},
	 } }
);
no Moo;

1;

# vim: tabstop=4
