use ExtUtils::MakeMaker qw(%att &WriteMakefile);

$Version = '0.52';

$inc    = "";
$xlib   = "";
#$dirTk = "../../Tk-b4";
# If $dirTk is not defined, try to find it

unless (defined $dirTk) {
  if (-r "../Tk/tkGlue.h") {$dirTk = "../Tk";}
  elsif (-r "Tk/tkGlue.h") {$dirTk = "Tk" }
  elsif (-r "../../tkGlue.h") {$dirTk = "../.." }
  elsif (-r "../../Tk/tkGlue.h") {$dirTk = "../../Tk" }
  # Try harder
  elsif (@list = <../../Tk-*> and -d $list[-1]) {$dirTk = $list[-1] }
  elsif (@list = <../Tk-*> and -d $list[-1]) {$dirTk = $list[-1] }
  die "Please define \$dirTk in Makefile.PL, cannot find it automatically.\n"
    unless defined $dirTk;
}

warn "Tk found in $dirTk.\n";

use lib $dirTk;
#require Tk::myConfig;
require Tk::MMutil;

$Tk::MMutil::define .= " -DLangIsPerl";
$direText = "../pTk";

# The existence of the ./*/Makefile.PL file causes MakeMaker
# to automatically include Makefile code for the targets
#	config, all, clean, realclean and */Makefile
# which perform the corresponding action in the subdirectory.
                           
#WriteMakefile
Tk::MMutil::TkExtMakefile(
    'NAME'     => 'Tk::eText',
    'VERSION'  => $Version,
    'MYEXTLIB' => "$direText/libpTkeText.a",
    #'DEFINE'  => $Tk::MMutil::define, 
    'INC'     => "-I$dirTk/pTk $inc",
    #'SKIP'	=> [qw(distclean)],
    #'PM'      => {'eText.pm' => '$(INST_LIBDIR)/eText.pm'},
    'OBJECT'      => 'eText.o',
    # 'XS'      => {'eText.xs' => 'eText.c'},
    #'clean'   => {FILES => 'eText.*'},
);

sub MY::post_constants {

 return # &upgrade_pic() . 
"
TK_DIR = $dirTk
eText_DIR = $direText
";
}

sub MY::postamble {
    '
Makefile     : $(TK_DIR)/myConfig 
$(BASEEXT).o : $(MYEXTLIB)

$(MYEXTLIB)  : FORCE $(eText_DIR)/Makefile
	cd $(eText_DIR); $(MAKE) libpTkeText.a

$(eText_DIR)/Makefile : $(eText_DIR)/Makefile.PL
	cd $(eText_DIR); $(PERL) Makefile.PL

eText.xs : $(TK_DIR)/Text/Text.xs
	cp $(TK_DIR)/Text/Text.xs $@
	perl -pi -e "s/([^_])Text/\1eText/g;" -e "s/\"text/\"etext/g" $@

eText.pm : $(TK_DIR)/Text/Text.pm cnvrt eText.xs
	cp $(TK_DIR)/Text/Text.pm $@
	perl -pi cnvrt $@

';
}


