#!/usr/bin/perl -w
#package 06_nodefield1
use Test::More no_plan;
use strict;

BEGIN {
	$| = 1;
	chdir 't' if -d 't';
	unshift @INC, '../lib';
	use_ok 'Weed';
	use_ok 'TestNode';
}

ok my $testNode = new SFNode( new TestNode );

ok !tied ${ tied $testNode->getValue->private_getField('mfbool') };
ok !tied ${ tied $testNode->getValue->private_getField('mfcolor') };
ok !tied ${ tied $testNode->getValue->private_getField('mfcolorrgba') };
ok !tied ${ tied $testNode->getValue->private_getField('mfdouble') };
ok !tied ${ tied $testNode->getValue->private_getField('mffloat') };
ok !tied ${ tied $testNode->getValue->private_getField('mfimage') };
ok !tied ${ tied $testNode->getValue->private_getField('mfint32') };
ok !tied ${ tied $testNode->getValue->private_getField('mfnode') };
ok !tied ${ tied $testNode->getValue->private_getField('mfrotation') };
ok !tied ${ tied $testNode->getValue->private_getField('mfstring') };
ok !tied ${ tied $testNode->getValue->private_getField('mftime') };
ok !tied ${ tied $testNode->getValue->private_getField('mfvec2d') };
ok !tied ${ tied $testNode->getValue->private_getField('mfvec2f') };
ok !tied ${ tied $testNode->getValue->private_getField('mfvec3d') };
ok !tied ${ tied $testNode->getValue->private_getField('mfvec3f') };
ok !tied ${ tied $testNode->getValue->private_getField('sfbool') };
ok !tied ${ tied $testNode->getValue->private_getField('sfcolor') };
ok !tied ${ tied $testNode->getValue->private_getField('sfcolorrgba') };
ok !tied ${ tied $testNode->getValue->private_getField('sfdouble') };
ok !tied ${ tied $testNode->getValue->private_getField('sffloat') };
ok !tied ${ tied $testNode->getValue->private_getField('sfimage') };
ok !tied ${ tied $testNode->getValue->private_getField('sfint32') };
ok !tied ${ tied $testNode->getValue->private_getField('sfnode') };
ok !tied ${ tied $testNode->getValue->private_getField('sfrotation') };
ok !tied ${ tied $testNode->getValue->private_getField('sfstring') };
ok !tied ${ tied $testNode->getValue->private_getField('sftime') };
ok !tied ${ tied $testNode->getValue->private_getField('sfvec2d') };
ok !tied ${ tied $testNode->getValue->private_getField('sfvec2f') };
ok !tied ${ tied $testNode->getValue->private_getField('sfvec3d') };
ok !tied ${ tied $testNode->getValue->private_getField('sfvec3f') };

isa_ok ${ tied $testNode->getValue->private_getField('mfbool') },      'MFBool';
isa_ok ${ tied $testNode->getValue->private_getField('mfcolor') },     'MFColor';
isa_ok ${ tied $testNode->getValue->private_getField('mfcolorrgba') }, 'MFColorRGBA';
isa_ok ${ tied $testNode->getValue->private_getField('mfdouble') },    'MFDouble';
isa_ok ${ tied $testNode->getValue->private_getField('mffloat') },     'MFFloat';
isa_ok ${ tied $testNode->getValue->private_getField('mfimage') },     'MFImage';
isa_ok ${ tied $testNode->getValue->private_getField('mfint32') },     'MFInt32';
isa_ok ${ tied $testNode->getValue->private_getField('mfnode') },      'MFNode';
isa_ok ${ tied $testNode->getValue->private_getField('mfrotation') },  'MFRotation';
isa_ok ${ tied $testNode->getValue->private_getField('mfbool') },      'MFBool';
isa_ok ${ tied $testNode->getValue->private_getField('mfcolor') },     'MFColor';
isa_ok ${ tied $testNode->getValue->private_getField('mfcolorrgba') }, 'MFColorRGBA';
isa_ok ${ tied $testNode->getValue->private_getField('mfdouble') },    'MFDouble';
isa_ok ${ tied $testNode->getValue->private_getField('mffloat') },     'MFFloat';
isa_ok ${ tied $testNode->getValue->private_getField('mfimage') },     'MFImage';
isa_ok ${ tied $testNode->getValue->private_getField('mfint32') },     'MFInt32';
isa_ok ${ tied $testNode->getValue->private_getField('mfnode') },      'MFNode';
isa_ok ${ tied $testNode->getValue->private_getField('mfrotation') },  'MFRotation';
isa_ok ${ tied $testNode->getValue->private_getField('mfstring') },    'MFString';
isa_ok ${ tied $testNode->getValue->private_getField('mftime') },      'MFTime';
isa_ok ${ tied $testNode->getValue->private_getField('mfvec2d') },     'MFVec2d';
isa_ok ${ tied $testNode->getValue->private_getField('mfvec2f') },     'MFVec2f';
isa_ok ${ tied $testNode->getValue->private_getField('mfvec3d') },     'MFVec3d';
isa_ok ${ tied $testNode->getValue->private_getField('mfvec3f') },     'MFVec3f';
isa_ok ${ tied $testNode->getValue->private_getField('sfbool') },      'SFBool';
isa_ok ${ tied $testNode->getValue->private_getField('sfcolor') },     'SFColor';
isa_ok ${ tied $testNode->getValue->private_getField('sfcolorrgba') }, 'SFColorRGBA';
isa_ok ${ tied $testNode->getValue->private_getField('sfdouble') },    'SFDouble';
isa_ok ${ tied $testNode->getValue->private_getField('sffloat') },     'SFFloat';
isa_ok ${ tied $testNode->getValue->private_getField('sfimage') },     'SFImage';
isa_ok ${ tied $testNode->getValue->private_getField('sfint32') },     'SFInt32';
isa_ok ${ tied $testNode->getValue->private_getField('sfnode') },      'SFNode';
isa_ok ${ tied $testNode->getValue->private_getField('sfrotation') },  'SFRotation';
isa_ok ${ tied $testNode->getValue->private_getField('sfstring') },    'SFString';
isa_ok ${ tied $testNode->getValue->private_getField('sftime') },      'SFTime';
isa_ok ${ tied $testNode->getValue->private_getField('sfvec2d') },     'SFVec2d';
isa_ok ${ tied $testNode->getValue->private_getField('sfvec2f') },     'SFVec2f';
isa_ok ${ tied $testNode->getValue->private_getField('sfvec3d') },     'SFVec3d';
isa_ok ${ tied $testNode->getValue->private_getField('sfvec3f') },     'SFVec3f';
isa_ok ${ tied $testNode->getValue->private_getField('mfstring') },    'MFString';
isa_ok ${ tied $testNode->getValue->private_getField('mftime') },      'MFTime';
isa_ok ${ tied $testNode->getValue->private_getField('mfvec2d') },     'MFVec2d';
isa_ok ${ tied $testNode->getValue->private_getField('mfvec2f') },     'MFVec2f';
isa_ok ${ tied $testNode->getValue->private_getField('mfvec3d') },     'MFVec3d';
isa_ok ${ tied $testNode->getValue->private_getField('mfvec3f') },     'MFVec3f';
isa_ok ${ tied $testNode->getValue->private_getField('sfbool') },      'SFBool';
isa_ok ${ tied $testNode->getValue->private_getField('sfcolor') },     'SFColor';
isa_ok ${ tied $testNode->getValue->private_getField('sfcolorrgba') }, 'SFColorRGBA';
isa_ok ${ tied $testNode->getValue->private_getField('sfdouble') },    'SFDouble';
isa_ok ${ tied $testNode->getValue->private_getField('sffloat') },     'SFFloat';
isa_ok ${ tied $testNode->getValue->private_getField('sfimage') },     'SFImage';
isa_ok ${ tied $testNode->getValue->private_getField('sfint32') },     'SFInt32';
isa_ok ${ tied $testNode->getValue->private_getField('sfnode') },      'SFNode';
isa_ok ${ tied $testNode->getValue->private_getField('sfrotation') },  'SFRotation';
isa_ok ${ tied $testNode->getValue->private_getField('sfstring') },    'SFString';
isa_ok ${ tied $testNode->getValue->private_getField('sftime') },      'SFTime';
isa_ok ${ tied $testNode->getValue->private_getField('sfvec2d') },     'SFVec2d';
isa_ok ${ tied $testNode->getValue->private_getField('sfvec2f') },     'SFVec2f';
isa_ok ${ tied $testNode->getValue->private_getField('sfvec3d') },     'SFVec3d';
isa_ok ${ tied $testNode->getValue->private_getField('sfvec3f') },     'SFVec3f';

isa_ok tied $testNode->getValue->private_getField('mfbool'),      'Weed::Tie::Field';
isa_ok tied $testNode->getValue->private_getField('mfcolor'),     'Weed::Tie::Field';
isa_ok tied $testNode->getValue->private_getField('mfcolorrgba'), 'Weed::Tie::Field';
isa_ok tied $testNode->getValue->private_getField('mfdouble'),    'Weed::Tie::Field';
isa_ok tied $testNode->getValue->private_getField('mffloat'),     'Weed::Tie::Field';
isa_ok tied $testNode->getValue->private_getField('mfimage'),     'Weed::Tie::Field';
isa_ok tied $testNode->getValue->private_getField('mfint32'),     'Weed::Tie::Field';
isa_ok tied $testNode->getValue->private_getField('mfnode'),      'Weed::Tie::Field';
isa_ok tied $testNode->getValue->private_getField('mfrotation'),  'Weed::Tie::Field';
isa_ok tied $testNode->getValue->private_getField('mfstring'),    'Weed::Tie::Field';
isa_ok tied $testNode->getValue->private_getField('mftime'),      'Weed::Tie::Field';
isa_ok tied $testNode->getValue->private_getField('mfvec2d'),     'Weed::Tie::Field';
isa_ok tied $testNode->getValue->private_getField('mfvec2f'),     'Weed::Tie::Field';
isa_ok tied $testNode->getValue->private_getField('mfvec3d'),     'Weed::Tie::Field';
isa_ok tied $testNode->getValue->private_getField('mfvec3f'),     'Weed::Tie::Field';
isa_ok tied $testNode->getValue->private_getField('sfbool'),      'Weed::Tie::Field';
isa_ok tied $testNode->getValue->private_getField('sfcolor'),     'Weed::Tie::Field';
isa_ok tied $testNode->getValue->private_getField('sfcolorrgba'), 'Weed::Tie::Field';
isa_ok tied $testNode->getValue->private_getField('sfdouble'),    'Weed::Tie::Field';
isa_ok tied $testNode->getValue->private_getField('sffloat'),     'Weed::Tie::Field';
isa_ok tied $testNode->getValue->private_getField('sfimage'),     'Weed::Tie::Field';
isa_ok tied $testNode->getValue->private_getField('sfint32'),     'Weed::Tie::Field';
isa_ok tied $testNode->getValue->private_getField('sfnode'),      'Weed::Tie::Field';
isa_ok tied $testNode->getValue->private_getField('sfrotation'),  'Weed::Tie::Field';
isa_ok tied $testNode->getValue->private_getField('sfstring'),    'Weed::Tie::Field';
isa_ok tied $testNode->getValue->private_getField('sftime'),      'Weed::Tie::Field';
isa_ok tied $testNode->getValue->private_getField('sfvec2d'),     'Weed::Tie::Field';
isa_ok tied $testNode->getValue->private_getField('sfvec2f'),     'Weed::Tie::Field';
isa_ok tied $testNode->getValue->private_getField('sfvec3d'),     'Weed::Tie::Field';
isa_ok tied $testNode->getValue->private_getField('mfbool'),      'Weed::Tie::Field';
isa_ok tied $testNode->getValue->private_getField('mfcolor'),     'Weed::Tie::Field';
isa_ok tied $testNode->getValue->private_getField('mfcolorrgba'), 'Weed::Tie::Field';
isa_ok tied $testNode->getValue->private_getField('mfdouble'),    'Weed::Tie::Field';
isa_ok tied $testNode->getValue->private_getField('mffloat'),     'Weed::Tie::Field';
isa_ok tied $testNode->getValue->private_getField('mfimage'),     'Weed::Tie::Field';
isa_ok tied $testNode->getValue->private_getField('mfint32'),     'Weed::Tie::Field';
isa_ok tied $testNode->getValue->private_getField('mfnode'),      'Weed::Tie::Field';
isa_ok tied $testNode->getValue->private_getField('mfrotation'),  'Weed::Tie::Field';
isa_ok tied $testNode->getValue->private_getField('mfstring'),    'Weed::Tie::Field';
isa_ok tied $testNode->getValue->private_getField('mftime'),      'Weed::Tie::Field';
isa_ok tied $testNode->getValue->private_getField('mfvec2d'),     'Weed::Tie::Field';
isa_ok tied $testNode->getValue->private_getField('mfvec2f'),     'Weed::Tie::Field';
isa_ok tied $testNode->getValue->private_getField('mfvec3d'),     'Weed::Tie::Field';
isa_ok tied $testNode->getValue->private_getField('mfvec3f'),     'Weed::Tie::Field';
isa_ok tied $testNode->getValue->private_getField('sfbool'),      'Weed::Tie::Field';
isa_ok tied $testNode->getValue->private_getField('sfcolor'),     'Weed::Tie::Field';
isa_ok tied $testNode->getValue->private_getField('sfcolorrgba'), 'Weed::Tie::Field';
isa_ok tied $testNode->getValue->private_getField('sfdouble'),    'Weed::Tie::Field';
isa_ok tied $testNode->getValue->private_getField('sffloat'),     'Weed::Tie::Field';
isa_ok tied $testNode->getValue->private_getField('sfimage'),     'Weed::Tie::Field';
isa_ok tied $testNode->getValue->private_getField('sfint32'),     'Weed::Tie::Field';
isa_ok tied $testNode->getValue->private_getField('sfnode'),      'Weed::Tie::Field';
isa_ok tied $testNode->getValue->private_getField('sfrotation'),  'Weed::Tie::Field';
isa_ok tied $testNode->getValue->private_getField('sfstring'),    'Weed::Tie::Field';
isa_ok tied $testNode->getValue->private_getField('sftime'),      'Weed::Tie::Field';
isa_ok tied $testNode->getValue->private_getField('sfvec2d'),     'Weed::Tie::Field';
isa_ok tied $testNode->getValue->private_getField('sfvec2f'),     'Weed::Tie::Field';
isa_ok tied $testNode->getValue->private_getField('sfvec3d'),     'Weed::Tie::Field';
isa_ok tied $testNode->getValue->private_getField('sfvec3f'),     'Weed::Tie::Field';
isa_ok tied $testNode->getValue->private_getField('sfvec3f'),     'Weed::Tie::Field';

#ok tied $weed->getValue->private_getField('metadata');
ok tied $testNode->getValue->private_getField('mfbool');
ok tied $testNode->getValue->private_getField('mfcolor');
ok tied $testNode->getValue->private_getField('mfcolorrgba');
ok tied $testNode->getValue->private_getField('mfdouble');
ok tied $testNode->getValue->private_getField('mffloat');
ok tied $testNode->getValue->private_getField('mfimage');
ok tied $testNode->getValue->private_getField('mfint32');
ok tied $testNode->getValue->private_getField('mfnode');
ok tied $testNode->getValue->private_getField('mfrotation');
ok tied $testNode->getValue->private_getField('mfstring');
ok tied $testNode->getValue->private_getField('mftime');
ok tied $testNode->getValue->private_getField('mfvec2d');
ok tied $testNode->getValue->private_getField('mfvec2f');
ok tied $testNode->getValue->private_getField('mfvec3d');
ok tied $testNode->getValue->private_getField('mfvec3f');
ok tied $testNode->getValue->private_getField('sfbool');
ok tied $testNode->getValue->private_getField('sfcolor');
ok tied $testNode->getValue->private_getField('sfcolorrgba');
ok tied $testNode->getValue->private_getField('sfdouble');
ok tied $testNode->getValue->private_getField('sffloat');
ok tied $testNode->getValue->private_getField('sfimage');
ok tied $testNode->getValue->private_getField('sfint32');
ok tied $testNode->getValue->private_getField('sfnode');
ok tied $testNode->getValue->private_getField('sfrotation');
ok tied $testNode->getValue->private_getField('sfstring');
ok tied $testNode->getValue->private_getField('sftime');
ok tied $testNode->getValue->private_getField('sfvec2d');
ok tied $testNode->getValue->private_getField('sfvec2f');
ok tied $testNode->getValue->private_getField('sfvec3d');
ok tied $testNode->getValue->private_getField('sfvec3f');

#is ref $weed->getValue->getField('metadata'), 'SFNode';
is ref $testNode->getValue->getField('mfbool'),      'MFBool';
is ref $testNode->getValue->getField('mfcolor'),     'MFColor';
is ref $testNode->getValue->getField('mfcolorrgba'), 'MFColorRGBA';
is ref $testNode->getValue->getField('mfdouble'),    'MFDouble';
is ref $testNode->getValue->getField('mffloat'),     'MFFloat';
is ref $testNode->getValue->getField('mfimage'),     'MFImage';
is ref $testNode->getValue->getField('mfint32'),     'MFInt32';
is ref $testNode->getValue->getField('mfnode'),      'MFNode';
is ref $testNode->getValue->getField('mfrotation'),  'MFRotation';
is ref $testNode->getValue->getField('mfstring'),    'MFString';
is ref $testNode->getValue->getField('mftime'),      'MFTime';
is ref $testNode->getValue->getField('mfvec2d'),     'MFVec2d';
is ref $testNode->getValue->getField('mfvec2f'),     'MFVec2f';
is ref $testNode->getValue->getField('mfvec3d'),     'MFVec3d';
is ref $testNode->getValue->getField('mfvec3f'),     'MFVec3f';
is ref $testNode->getValue->getField('sfbool'),      'SFBool';
is ref $testNode->getValue->getField('sfcolor'),     'SFColor';
is ref $testNode->getValue->getField('sfcolorrgba'), 'SFColorRGBA';
is ref $testNode->getValue->getField('sfdouble'),    'SFDouble';
is ref $testNode->getValue->getField('sffloat'),     'SFFloat';
is ref $testNode->getValue->getField('sfimage'),     'SFImage';
is ref $testNode->getValue->getField('sfint32'),     'SFInt32';
is ref $testNode->getValue->getField('sfnode'),      'SFNode';
is ref $testNode->getValue->getField('sfrotation'),  'SFRotation';
is ref $testNode->getValue->getField('sfstring'),    'SFString';
is ref $testNode->getValue->getField('sftime'),      'SFTime';
is ref $testNode->getValue->getField('sfvec2d'),     'SFVec2d';
is ref $testNode->getValue->getField('sfvec2f'),     'SFVec2f';
is ref $testNode->getValue->getField('sfvec3d'),     'SFVec3d';
is ref $testNode->getValue->getField('sfvec3f'),     'SFVec3f';

isa_ok $testNode->getValue->getField('mfbool'),      'MFBool';
isa_ok $testNode->getValue->getField('mfcolor'),     'MFColor';
isa_ok $testNode->getValue->getField('mfcolorrgba'), 'MFColorRGBA';
isa_ok $testNode->getValue->getField('mfdouble'),    'MFDouble';
isa_ok $testNode->getValue->getField('mffloat'),     'MFFloat';
isa_ok $testNode->getValue->getField('mfimage'),     'MFImage';
isa_ok $testNode->getValue->getField('mfint32'),     'MFInt32';
isa_ok $testNode->getValue->getField('mfnode'),      'MFNode';
isa_ok $testNode->getValue->getField('mfrotation'),  'MFRotation';
isa_ok $testNode->getValue->getField('mfstring'),    'MFString';
isa_ok $testNode->getValue->getField('mftime'),      'MFTime';
isa_ok $testNode->getValue->getField('mfvec2d'),     'MFVec2d';
isa_ok $testNode->getValue->getField('mfvec2f'),     'MFVec2f';
isa_ok $testNode->getValue->getField('mfvec3d'),     'MFVec3d';
isa_ok $testNode->getValue->getField('mfvec3f'),     'MFVec3f';
isa_ok $testNode->getValue->getField('sfbool'),      'SFBool';
isa_ok $testNode->getValue->getField('sfcolor'),     'SFColor';
isa_ok $testNode->getValue->getField('sfcolorrgba'), 'SFColorRGBA';
isa_ok $testNode->getValue->getField('sfdouble'),    'SFDouble';
isa_ok $testNode->getValue->getField('sffloat'),     'SFFloat';
isa_ok $testNode->getValue->getField('sfimage'),     'SFImage';
isa_ok $testNode->getValue->getField('sfint32'),     'SFInt32';
isa_ok $testNode->getValue->getField('sfnode'),      'SFNode';
isa_ok $testNode->getValue->getField('sfrotation'),  'SFRotation';
isa_ok $testNode->getValue->getField('sfstring'),    'SFString';
isa_ok $testNode->getValue->getField('sftime'),      'SFTime';
isa_ok $testNode->getValue->getField('sfvec2d'),     'SFVec2d';
isa_ok $testNode->getValue->getField('sfvec2f'),     'SFVec2f';
isa_ok $testNode->getValue->getField('sfvec3d'),     'SFVec3d';
isa_ok $testNode->getValue->getField('sfvec3f'),     'SFVec3f';

#is ref $weed->metadata, 'SFNode';
is ref $testNode->mfbool,      'MFBool';
is ref $testNode->mfcolor,     'MFColor';
is ref $testNode->mfcolorrgba, 'MFColorRGBA';
is ref $testNode->mfdouble,    'MFDouble';
is ref $testNode->mffloat,     'MFFloat';
is ref $testNode->mfimage,     'MFImage';
is ref $testNode->mfint32,     'MFInt32';
is ref $testNode->mfnode,      'MFNode';
is ref $testNode->mfrotation,  'MFRotation';
is ref $testNode->mfstring,    'MFString';
is ref $testNode->mftime,      'MFTime';
is ref $testNode->mfvec2d,     'MFVec2d';
is ref $testNode->mfvec2f,     'MFVec2f';
is ref $testNode->mfvec3d,     'MFVec3d';
is ref $testNode->mfvec3f,     'MFVec3f';
is ref $testNode->sfbool,      'SFBool';
is ref $testNode->sfcolor,     'SFColor';
is ref $testNode->sfcolorrgba, 'SFColorRGBA';
is ref $testNode->sfdouble,    'SFDouble';
is ref $testNode->sffloat,     'SFFloat';
is ref $testNode->sfimage,     'SFImage';
is ref $testNode->sfint32,     'SFInt32';
is ref $testNode->sfnode,      'SFNode';
is ref $testNode->sfrotation,  'SFRotation';
is ref $testNode->sfstring,    'SFString';
is ref $testNode->sftime,      'SFTime';
is ref $testNode->sfvec2d,     'SFVec2d';
is ref $testNode->sfvec2f,     'SFVec2f';
is ref $testNode->sfvec3d,     'SFVec3d';
is ref $testNode->sfvec3f,     'SFVec3f';

#isa_ok $weed->metadata, 'X3DField';
isa_ok $testNode->mfbool,      'X3DField';
isa_ok $testNode->mfcolor,     'X3DField';
isa_ok $testNode->mfcolorrgba, 'X3DField';
isa_ok $testNode->mfdouble,    'X3DField';
isa_ok $testNode->mffloat,     'X3DField';
isa_ok $testNode->mfimage,     'X3DField';
isa_ok $testNode->mfint32,     'X3DField';
isa_ok $testNode->mfnode,      'X3DField';
isa_ok $testNode->mfrotation,  'X3DField';
isa_ok $testNode->mfstring,    'X3DField';
isa_ok $testNode->mftime,      'X3DField';
isa_ok $testNode->mfvec2d,     'X3DField';
isa_ok $testNode->mfvec2f,     'X3DField';
isa_ok $testNode->mfvec3d,     'X3DField';
isa_ok $testNode->mfvec3f,     'X3DField';
isa_ok $testNode->sfbool,      'X3DField';
isa_ok $testNode->sfcolor,     'X3DField';
isa_ok $testNode->sfcolorrgba, 'X3DField';
isa_ok $testNode->sfdouble,    'X3DField';
isa_ok $testNode->sffloat,     'X3DField';
isa_ok $testNode->sfimage,     'X3DField';
isa_ok $testNode->sfint32,     'X3DField';
isa_ok $testNode->sfnode,      'X3DField';
isa_ok $testNode->sfrotation,  'X3DField';
isa_ok $testNode->sfstring,    'X3DField';
isa_ok $testNode->sftime,      'X3DField';
isa_ok $testNode->sfvec2d,     'X3DField';
isa_ok $testNode->sfvec2f,     'X3DField';
isa_ok $testNode->sfvec3d,     'X3DField';
isa_ok $testNode->sfvec3f,     'X3DField';

isa_ok my $vec3f = $testNode->sfvec3f, 'SFVec3f';
ok !tied $vec3f;

ok tied $testNode->mfbool;
ok tied $testNode->mfcolor;
ok tied $testNode->mfcolorrgba;
ok tied $testNode->mfdouble;
ok tied $testNode->mffloat;
ok tied $testNode->mfimage;
ok tied $testNode->mfint32;
ok tied $testNode->mfnode;
ok tied $testNode->mfrotation;
ok tied $testNode->mfstring;
ok tied $testNode->mftime;
ok tied $testNode->mfvec2d;
ok tied $testNode->mfvec2f;
ok tied $testNode->mfvec3d;
ok tied $testNode->mfvec3f;
ok tied $testNode->sfbool;
ok tied $testNode->sfcolor;
ok tied $testNode->sfcolorrgba;
ok tied $testNode->sfdouble;
ok tied $testNode->sffloat;
ok tied $testNode->sfimage;
ok tied $testNode->sfint32;
ok tied $testNode->sfnode;
ok tied $testNode->sfrotation;
ok tied $testNode->sfstring;
ok tied $testNode->sftime;
ok tied $testNode->sfvec2d;
ok tied $testNode->sfvec2f;
ok tied $testNode->sfvec3d;
ok tied $testNode->sfvec3f;

ok !tied ${ tied $testNode->mfbool };
ok !tied ${ tied $testNode->mfcolor };
ok !tied ${ tied $testNode->mfcolorrgba };
ok !tied ${ tied $testNode->mfdouble };
ok !tied ${ tied $testNode->mffloat };
ok !tied ${ tied $testNode->mfimage };
ok !tied ${ tied $testNode->mfint32 };
ok !tied ${ tied $testNode->mfnode };
ok !tied ${ tied $testNode->mfrotation };
ok !tied ${ tied $testNode->mfstring };
ok !tied ${ tied $testNode->mftime };
ok !tied ${ tied $testNode->mfvec2d };
ok !tied ${ tied $testNode->mfvec2f };
ok !tied ${ tied $testNode->mfvec3d };
ok !tied ${ tied $testNode->mfvec3f };
ok !tied ${ tied $testNode->sfbool };
ok !tied ${ tied $testNode->sfcolor };
ok !tied ${ tied $testNode->sfcolorrgba };
ok !tied ${ tied $testNode->sfdouble };
ok !tied ${ tied $testNode->sffloat };
ok !tied ${ tied $testNode->sfimage };
ok !tied ${ tied $testNode->sfint32 };
ok !tied ${ tied $testNode->sfnode };
ok !tied ${ tied $testNode->sfrotation };
ok !tied ${ tied $testNode->sfstring };
ok !tied ${ tied $testNode->sftime };
ok !tied ${ tied $testNode->sfvec2d };
ok !tied ${ tied $testNode->sfvec2f };
ok !tied ${ tied $testNode->sfvec3d };
ok !tied ${ tied $testNode->sfvec3f };

#is ++$weed->size, 3; #35
#is ++$weed->size, 4; #36
#is ++$weed->size, 5; #37
#is ++$weed->size, 6; #38
#is $weed->size++, 5;

#is $weed, 'Weed {
#  size 6
#}';

1;
__END__
