package App::Manoc::Controller::VlanRange;
#ABSTRACT: VlanRange controller
use Moose;

our $VERSION = '2.99.3'; ##TRIAL VERSION

use namespace::autoclean;

BEGIN { extends 'Catalyst::Controller'; }
with "App::Manoc::ControllerRole::CommonCRUD";

use App::Manoc::Form::VlanRange;

BEGIN { extends 'Catalyst::Controller'; }

__PACKAGE__->config(
    # define PathPart
    action => {
        setup => {
            PathPart => 'vlanrange',
        }
    },
    class        => 'ManocDB::VlanRange',
    form_class   => 'App::Manoc::Form::VlanRange',
    json_columns => [qw(id lansegment name description)],
    object_list  => {
        order_by => [ 'lan_segment_id', 'start' ],
    }
);


before 'create' => sub {
    my ( $self, $c ) = @_;

    my $segment_id = $c->req->query_parameters->{'lansegment'};
    my $segment = $c->model('ManocDB::LanSegment')->find( { id => $segment_id } );
    $c->stash( form_defaults => { lan_segment => $segment } );
};


sub list : Chained('object_list') : PathPart('') : Args(0) {
    my ( $self, $c ) = @_;

    $c->response->redirect( $c->uri_for_action('vlan/list') );
}


sub view : Chained('object') : PathPart('') : Args(0) {
    my ( $self, $c ) = @_;

    my $object = $c->stash->{object};
    $c->response->redirect( $c->uri_for_action( 'vlanrange/edit', [ $object->id ] ) );
}


sub delete_object {

    my ( $self, $c ) = @_;
    my $range = $c->stash->{'object'};
    my $id    = $range->id;
    my $name  = $range->name;

    if ( $range->vlans->count() ) {
        $c->flash( error_msg => "There are vlans in vlan range '$name'. Cannot delete it." );
        return;
    }

    return $range->delete;
}


sub get_form_success_url {
    my ( $self, $c ) = @_;

    return $c->uri_for_action("vlan/list");
}


sub get_delete_success_url {
    my ( $self, $c ) = @_;

    return $c->uri_for_action("vlan/list");
}


sub get_delete_failure_url {
    my ( $self, $c ) = @_;

    return $c->uri_for_action("vlan/list");
}

__PACKAGE__->meta->make_immutable;

1;

__END__

=pod

=head1 NAME

App::Manoc::Controller::VlanRange - VlanRange controller

=head1 VERSION

version 2.99.3

=head1 ACTIONS

=head2 list

Redirect to vlan list

=head2 view

Redirect to edit

=head1 METHODS

=head2 delete_object

=head2 get_form_success_url

=head2 get_delete_success_url

=head2 get_delete_failure_url

=head1 METHODS

=head2 create

=head1 AUTHORS

=over 4

=item *

Gabriele Mambrini <gmambro@cpan.org>

=item *

Enrico Liguori

=back

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by Gabriele Mambrini.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
