package App::Manoc::Controller::Credentials;
#ABSTRACT: Building Controller

use Moose;

our $VERSION = '2.99.3'; ##TRIAL VERSION

use namespace::autoclean;

use App::Manoc::Form::Credentials;

BEGIN { extends 'Catalyst::Controller'; }
with
    "App::Manoc::ControllerRole::CommonCRUD" => { -excludes => [ 'delete_object', 'view' ] },
    "App::Manoc::ControllerRole::JSONView";

__PACKAGE__->config(
    # define PathPart
    action => {
        setup => {
            PathPart => 'credentials',
        }
    },
    class               => 'ManocDB::Credentials',
    form_class          => 'App::Manoc::Form::Credentials',
    view_object_perm    => undef,
    object_list_options => {
        join      => [ 'device_nw_info', 'server_nw_info' ],
        distinct  => 1,
        '+select' => [
            { count => 'device_nw_info.device_id' },
            { count => 'server_nw_info.server_id' },
        ],
        '+as' => [qw/num_devices num_servers/],
    }
);


sub delete_object {
    my ( $self, $c ) = @_;
    my $credentials = $c->stash->{'object'};

    if ( $credentials->device_nw_info->count || $credentials->server_nw_info->count ) {
        $c->flash( error_msg =>
                'These credental set has associated configurations and cannot be deleted.' );
        return;
    }

    return $credentials->delete;
}


sub view : Chained('object') : PathPart('') : Args(0) {
    my ( $self, $c ) = @_;

    my $object = $c->stash->{object};
    $c->response->redirect( $c->uri_for_action( 'credentials/edit', [ $object->id ] ) );
}


sub get_form_success_url {
    my ( $self, $c ) = @_;

    my $action = $c->namespace . "/list";
    return $c->uri_for_action($action);
}

__PACKAGE__->meta->make_immutable;

1;
# Local Variables:
# mode: cperl
# indent-tabs-mode: nil
# cperl-indent-level: 4
# cperl-indent-parens-as-block: t
# End:

__END__

=pod

=head1 NAME

App::Manoc::Controller::Credentials - Building Controller

=head1 VERSION

version 2.99.3

=head1 ACTIONS

=head2 get_form_success_url

=head1 METHODS

=head2 delete_object

Override default implementation to warn when building has associated racks or
warehouses.

=head2 view

Redirect to edit

=head1 AUTHORS

=over 4

=item *

Gabriele Mambrini <gmambro@cpan.org>

=item *

Enrico Liguori

=back

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by Gabriele Mambrini.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
