# Test to see if a Geo::ReadGRIB object can return the 
# expected parameter data.
#
# In this case there are two 180 degree places for each lat,
# one on each edge of the flat grid, and 
# this test makes sure they are the same value
# 
# For this to work there needs to be a specific sample GRIB file
# and the module has to be able to find wgrib.exe 

BEGIN{ unshift @INC, '.'}


use Test::More tests => 303;
use strict;
use warnings;


###########################################################################
# Test for offset but on 64bit uselongdouble
############################################################################

use Geo::ReadGRIB;

## Find path to test file
my $TEST_FILE;
foreach my $inc (@INC) {
   if (-e "$inc/Geo/Sample-GRIB/2009100900_P000.grib") {
      $TEST_FILE = "$inc/Geo/Sample-GRIB/2009100900_P000.grib";
      last;
   }  
}

ok(-e "$TEST_FILE") or
   diag("Path to sample GRIB file not found");

my $w = Geo::ReadGRIB->new("$TEST_FILE");

my @wegot = qw/600 1200 1802 2402 3004 3605 4205 4807 5407 6009 6610 7210 7812 8412 9014 9615 10215 10817 11417 12019 12620 13220 13822 14422 15024 15625 16225 16827 17427 18029 18630 19230 19832 20433 21034 21635 22235 22837 23438 24039 24640 25240 25842 26443 27044 27645 28245 28847 29448 30049 30650 31250 31852 32453 33054 33655 34256 34856 35458 36059 36660 37261 37861 38463 39064 39665 40266 40867 41468 42069 42670 43271 43872 44473 45074 45675 46276 46877 47478 48079 48680 49281 49882 50483 51084 51685 52286 52887 53488 54089 54690 55291 55892 56493 57094 57695 58296 58897 59498 60099 60700 61301 61902 62503 63104 63705 64306 64907 65508 66109 66710 67311 67912 68513 69113 69715 70316 70917 71518 72118 72720 73321 73922 74523 75123 75725 76326 76927 77528 78129 78730 79331 79932 80533 81134 81735 82336 82937 83538 84139 84740 85341 85942 86543 87144 87745 88346 88947 89548 90149 90750 91351 91952 92553 93154 93755 94356 94957 95558 96159 96760 97361 97962 98563 99164 99765 100366 100967 101568 102169 102770 103371 103972 104573 105174 105775 106376 106977 107578 108179 108780 109381 109982 110583 111184 111785 112386 112987 113588 114189 114790 115391 115992 116593 117194 117795 118396 118997 119598 120199 120800 121401 122002 122603 123204 123805 124406 125007 125608 126209 126810 127411 128012 128613 129214 129815 130416 131017 131618 132219 132820 133421 134022 134622 135224 135825 136426 137027 137627 138229 138830 139431 140032 140632 141234 141835 142436 143037 143637 144239 144840 145441 146042 146642 147244 147845 148446 149047 149647 150249 150850 151451 152052 152652 153254 153855 154456 155057 155658 156259 156860 157461 158062 158663 159264 159865 160466 161067 161668 162269 162870 163471 164072 164673 165274 165875 166476 167077 167678 168279 168880 169481 170082 170683 171284 171885 172486 173087 173688 174289 174890 175491 176092 176693 177294 177895 178496 179097 179698 180299 180900/;


my $la1 = -90;
my $lo = 180;
for ( my $j = 0; $j <= 300; $j++ ) {
    
    my $la = $la1 + (.6 * $j);
    my $offset = $w->lalo2offset( $la, $lo );
    ok( $offset == $wegot[$j] ) or
        diag( "lalo2offset( $la, $lo) gives $offset, should be $wegot[$j] ");
}

my $calc = (((89.4 - -90)/.6) * 601) + (360 /.6);
ok( $calc == 180299 ) or
    diag ("((89.4 - -90)/.6) * 601) + (360 /.6) = 180299 not $calc  ");
