# NAME

Dist::Zilla::Plugin::Test::CheckBreaks - Generate a test that shows your conflicting modules

# VERSION

version 0.001

# SYNOPSIS

In your `dist.ini`:

    [CheckBreaks]
    conflicts_module = Moose::Conflicts

# DESCRIPTION

This is a [Dist::Zilla](https://metacpan.org/pod/Dist::Zilla) plugin that runs at the
[gather files](https://metacpan.org/pod/Dist::Zilla::Role::FileGatherer) stage, providing a test file
that runs last in your test suite and checks for conflicting modules, as
calculated by [Dist::CheckConflicts](https://metacpan.org/pod/Dist::CheckConflicts).  (See the `t/zzz-check-breaks.t` test
in this distribution for an example.)

In addition, the content of the `x_breaks` meta field is checked in the test.
It expects [version ranges](https://metacpan.org/pod/CPAN::Meta::Spec#Version-Ranges), with one
addition, for backwards compatibility with
[\[Conflicts\]](https://metacpan.org/pod/Dist::Zilla::Plugin::Conflicts): if a bare version number is
specified, it is interpreted as `'<= $version'` (to preserve the intent
that versions at or below the version specified are those considered to be
broken).  It is possible that this interpretation will be removed in the
future; almost certainly before `breaks` becomes a formal part of the meta
specification.

# CONFIGURATION

## `conflicts_module`

The name of the conflicts module to load and invoke the `check_conflicts`
method on. Defaults to the name of the main module with `::Conflicts`
appended, such as what is generated by the
[\[Conflicts\]](https://metacpan.org/pod/Dist::Zilla::Plugin::Conflicts) plugin.

Nothing happens if the module does not exist.

If your distribution uses [Moose](https://metacpan.org/pod/Moose) but does not itself generate a conflicts
plugin, then `Moose::Conflicts` is an excellent choice, as there are numerous
interoperability conflicts catalogued in that module.

# SEE ALSO

- [Dist::Zilla::Plugin::Breaks](https://metacpan.org/pod/Dist::Zilla::Plugin::Breaks)
- [Dist::CheckConflicts](https://metacpan.org/pod/Dist::CheckConflicts)
- [The Annotated Lancaster Consensus](http://www.dagolden.com/index.php/2098/the-annotated-lancaster-consensus/)
at "Improving on 'conflicts'"

# AUTHOR

Karen Etheridge <ether@cpan.org>

# COPYRIGHT AND LICENSE

This software is copyright (c) 2014 by Karen Etheridge.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.
