package App::Akter::Script;
use 5.10.0;
use strict;
use warnings;

use Data::Dumper;
use App::Akter::Exception;

sub new {
    my $class = shift;
    my $args = (@_ % 2 == 0) ? {@_} : undef;


    return bless {
        _file => $args->{file} || 'akterfile',
        _source => '',
        _tasks  => [],
        _param  => {}
    }, $class;
}

## accessors
sub add_task {
    my ($self, $title, $callback) = @_;
    push @{$self->{_tasks}}, {title => $title, callback => $callback};
}

sub file {
    $_[0]->{_file} = $_[1] if $_[1];
    return $_[0]->{_file};
}

sub param {
    $_[0]->{_param}->{$_[1]} = $_[2] if $_[1] && $_[2];
    return $_[0]->{_param}->{$_[1]};
}

sub source {
    $_[0]->{_source} = $_[1] if $_[1];
    return $_[0]->{_source};
}

sub task_list {
    my $self = shift;
    return $self->{_tasks};
}

## commands
sub _task {
    my ($self, $title, $callback) = @_;
    push @{$self->task_list}, {title => $title, callback => $callback};
}

sub _dumper {
    return Dumper $_[1] if $_[1];
}


## methods
sub commands {
    my $self   = shift;
    my $caller = caller;

    no strict 'refs';
    no warnings 'redefine';
    *{"${caller}::task"}   = sub { $self->_task(@_) };
    *{"${caller}::param"}  = sub { $self->param(@_) };
    *{"${caller}::dumper"} = sub { $self->_dumper(@_) };
}

sub execute {
    my $self   = shift;
    my $script = $self->read;

    # build source
    $script =~ s/requires\s+['"]?(.*)["']?\s*;/use $1;/g;
    $self->source(
        qq{
        package App::Akter::Sandbox;
        use feature ':5.10';
        BEGIN { \$_app->commands }
        $script
        1;
    }
    );

    # evaluate
    {
        local $@;
        my $_app = $self;
        eval($self->source);

        # error
        throw "evaluate:$@" if $@;
    }

    # execute tasks
    $self->_evaluate;
}

sub read {
    my ($self, $path) = @_;
    $path = $path || $self->file;

    # open script file
    open my $fh, $path or throw "error:akterfile can not be read!\n";
    $self->{_source} = join '', <$fh>;
    close $fh;

    return $self->{_source};
}

sub _evaluate {
    my $self = shift;

    # print out title and execute task
    map {
        say "[task] " . $_->{title} . '.' x (80 - length($_->{title}));
        $_->{callback}($self)
    } @{$self->task_list};
}

1;
