package Math::NLopt;

# ABSTRACT: Math::NLopt - Perl interface to the NLopt optimization library

use v5.12;
use strict;
use warnings;

#<<<

our $VERSION = '0.01'; # TRIAL

#>>>

# don't inherit.  We're a class by-golly, and don't want Exporter's methods.
use Exporter 'import';

# Items to export into callers namespace by default. Note: do not export
# names by default without a very good reason. Use EXPORT_OK instead.
# Do not simply export all your public functions/methods/constants.

# This allows declaration	use Math::NLopt ':all';
# If you do not need this, moving things directly into @EXPORT or @EXPORT_OK
# will save memory.

our %EXPORT_TAGS = (
    algorithms => [ qw(
          NLOPT_AUGLAG
          NLOPT_AUGLAG_EQ
          NLOPT_GD_MLSL
          NLOPT_GD_MLSL_LDS
          NLOPT_GD_STOGO
          NLOPT_GD_STOGO_RAND
          NLOPT_GN_AGS
          NLOPT_GN_CRS2_LM
          NLOPT_GN_DIRECT
          NLOPT_GN_DIRECT_L
          NLOPT_GN_DIRECT_L_NOSCAL
          NLOPT_GN_DIRECT_L_RAND
          NLOPT_GN_DIRECT_L_RAND_NOSCAL
          NLOPT_GN_DIRECT_NOSCAL
          NLOPT_GN_ESCH
          NLOPT_GN_ISRES
          NLOPT_GN_MLSL
          NLOPT_GN_MLSL_LDS
          NLOPT_GN_ORIG_DIRECT
          NLOPT_GN_ORIG_DIRECT_L
          NLOPT_G_MLSL
          NLOPT_G_MLSL_LDS
          NLOPT_LD_AUGLAG
          NLOPT_LD_AUGLAG_EQ
          NLOPT_LD_CCSAQ
          NLOPT_LD_LBFGS
          NLOPT_LD_LBFGS_NOCEDAL
          NLOPT_LD_MMA
          NLOPT_LD_SLSQP
          NLOPT_LD_TNEWTON
          NLOPT_LD_TNEWTON_PRECOND
          NLOPT_LD_TNEWTON_PRECOND_RESTART
          NLOPT_LD_TNEWTON_RESTART
          NLOPT_LD_VAR1
          NLOPT_LD_VAR2
          NLOPT_LN_AUGLAG
          NLOPT_LN_AUGLAG_EQ
          NLOPT_LN_BOBYQA
          NLOPT_LN_COBYLA
          NLOPT_LN_NELDERMEAD
          NLOPT_LN_NEWUOA
          NLOPT_LN_NEWUOA_BOUND
          NLOPT_LN_PRAXIS
          NLOPT_LN_SBPLX
          NLOPT_NUM_ALGORITHMS
        ),
    ],
    results => [ qw(
          NLOPT_FAILURE
          NLOPT_FORCED_STOP
          NLOPT_FTOL_REACHED
          NLOPT_INVALID_ARGS
          NLOPT_MAXEVAL_REACHED
          NLOPT_MAXTIME_REACHED
          NLOPT_MINF_MAX_REACHED
          NLOPT_NUM_FAILURES
          NLOPT_NUM_RESULTS
          NLOPT_OUT_OF_MEMORY
          NLOPT_ROUNDOFF_LIMITED
          NLOPT_STOPVAL_REACHED
          NLOPT_SUCCESS
          NLOPT_XTOL_REACHED
        ),
    ],
    subs => [
        qw( algorithm_from_string
          algorithm_name
          algorithm_to_string
          result_from_string
          result_to_string
          srand_time
          version
        ),
    ],
);

$EXPORT_TAGS{all} = [ map { @{ $EXPORT_TAGS{$_} } } keys %EXPORT_TAGS ];

our @EXPORT_OK = ( @{ $EXPORT_TAGS{'all'} } );


sub _croak {
    require Carp;
    goto \&Carp::croak;
}

# This AUTOLOAD is used to 'autoload' constants from the constant()
# XS function.

sub AUTOLOAD {    ## no critic (ClassHierarchies::ProhibitAutoload)

    my $constname;
    our $AUTOLOAD;
    ( $constname = $AUTOLOAD ) =~ s/.*:://;
    _croak '&Math::NLopt::constant not defined' if $constname eq 'constant';
    my ( $error, $val ) = constant( $constname );
    if ( $error ) { croak $error; }
    {
        no strict 'refs';    ## no critic (TestingAndDebugging::ProhibitNoStrict)

        *$AUTOLOAD = sub { $val };
    }
    goto &$AUTOLOAD;
}

require XSLoader;
XSLoader::load( 'Math::NLopt', $VERSION );

# Preloaded methods go here.

1;

#
# This file is part of Math-NLopt
#
# This software is Copyright (c) 2024 by Smithsonian Astrophysical Observatory.
#
# This is free software, licensed under:
#
#   The GNU General Public License, Version 3, June 2007
#

__END__

=pod

=for :stopwords Diab Jerius Smithsonian Astrophysical Observatory

=head1 NAME

Math::NLopt - Math::NLopt - Perl interface to the NLopt optimization library

=head1 VERSION

version 0.01

=head1 SYNOPSIS

  use Math::NLopt;

  my $opt = Math::NLopt

=head1 DESCRIPTION

=head2 EXPORT

None by default.

=head2 Exportable constants

  NLOPT_AUGLAG
  NLOPT_AUGLAG_EQ
  NLOPT_FAILURE
  NLOPT_FORCED_STOP
  NLOPT_FTOL_REACHED
  NLOPT_GD_MLSL
  NLOPT_GD_MLSL_LDS
  NLOPT_GD_STOGO
  NLOPT_GD_STOGO_RAND
  NLOPT_GN_AGS
  NLOPT_GN_CRS2_LM
  NLOPT_GN_DIRECT
  NLOPT_GN_DIRECT_L
  NLOPT_GN_DIRECT_L_NOSCAL
  NLOPT_GN_DIRECT_L_RAND
  NLOPT_GN_DIRECT_L_RAND_NOSCAL
  NLOPT_GN_DIRECT_NOSCAL
  NLOPT_GN_ESCH
  NLOPT_GN_ISRES
  NLOPT_GN_MLSL
  NLOPT_GN_MLSL_LDS
  NLOPT_GN_ORIG_DIRECT
  NLOPT_GN_ORIG_DIRECT_L
  NLOPT_G_MLSL
  NLOPT_G_MLSL_LDS
  NLOPT_INVALID_ARGS
  NLOPT_LD_AUGLAG
  NLOPT_LD_AUGLAG_EQ
  NLOPT_LD_CCSAQ
  NLOPT_LD_LBFGS
  NLOPT_LD_LBFGS_NOCEDAL
  NLOPT_LD_MMA
  NLOPT_LD_SLSQP
  NLOPT_LD_TNEWTON
  NLOPT_LD_TNEWTON_PRECOND
  NLOPT_LD_TNEWTON_PRECOND_RESTART
  NLOPT_LD_TNEWTON_RESTART
  NLOPT_LD_VAR1
  NLOPT_LD_VAR2
  NLOPT_LN_AUGLAG
  NLOPT_LN_AUGLAG_EQ
  NLOPT_LN_BOBYQA
  NLOPT_LN_COBYLA
  NLOPT_LN_NELDERMEAD
  NLOPT_LN_NEWUOA
  NLOPT_LN_NEWUOA_BOUND
  NLOPT_LN_PRAXIS
  NLOPT_LN_SBPLX
  NLOPT_MAXEVAL_REACHED
  NLOPT_MAXTIME_REACHED
  NLOPT_MINF_MAX_REACHED
  NLOPT_NUM_ALGORITHMS
  NLOPT_NUM_FAILURES
  NLOPT_NUM_RESULTS
  NLOPT_OUT_OF_MEMORY
  NLOPT_ROUNDOFF_LIMITED
  NLOPT_STOPVAL_REACHED
  NLOPT_SUCCESS
  NLOPT_XTOL_REACHED

=head1 INTERNALS

=for Pod::Coverage add_equality_constraint
add_equality_mconstraint
add_inequality_constraint
add_inequality_mconstraint
add_precond_equality_constraint
add_precond_inequality_constraint
algorithm_from_string
algorithm_name
algorithm_to_string
constant
copy
create
destroy
force_stop
get_algorithm
get_dimension
get_errmsg
get_force_stop
get_ftol_abs
get_ftol_rel
get_initial_step
get_lower_bounds
get_maxeval
get_maxtime
get_numevals
get_param
get_population
get_stopval
get_upper_bounds
get_vector_storage
get_x_weights
get_xtol_abs
get_xtol_rel
has_param
nth_param
last_optimize_result
last_optimum_value
new
num_params
optimize
remove_equality_constraints
remove_inequality_constraints
result_from_string
result_to_string
set_force_stop
set_ftol_abs
set_ftol_rel
set_initial_step
set_initial_step1
set_local_optimizer
set_lower_bound
set_lower_bounds
set_lower_bounds1
set_max_objective
set_maxeval
set_maxtime
set_min_objective
set_munge
set_param
set_population
set_precond_max_objective
set_precond_min_objective
set_stopval
set_upper_bound
set_upper_bounds
set_upper_bounds1
set_vector_storage
set_x_weights
set_x_weights1
set_xtol_abs
set_xtol_abs1
set_xtol_rel
srand
srand_time
version

=head1 SUPPORT

=head2 Bugs

Please report any bugs or feature requests to bug-math-nlopt@rt.cpan.org  or through the web interface at: L<https://rt.cpan.org/Public/Dist/Display.html?Name=Math-NLopt>

=head2 Source

Source is available at

  https://gitlab.com/djerius/math-nlopt

and may be cloned from

  https://gitlab.com/djerius/math-nlopt.git

=head1 AUTHOR

Diab Jerius <djerius@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2024 by Smithsonian Astrophysical Observatory.

This is free software, licensed under:

  The GNU General Public License, Version 3, June 2007

=cut
