package Firewall::Config::Connector::Asa;

use 5.018;
use warnings;
use Carp;
use namespace::autoclean;
use Firewall::Config::Connector::Device::Cisco;

#------------------------------------------------------------------------------
# Asa telnet 函数入口
#------------------------------------------------------------------------------
sub telnet {
  my ( $self, %param ) = @_;
  my ( $host, $user, $password ) = @{param}{qw/ host user password /};
  my $conn = Firewall::Config::Connector::Device::Cisco->new(
    host     => $host,
    username => $user,
    password => $password,
    proto    => 'telnet'
  );
  my $config = $conn->getconfig();
  if ( $config->{"success"} ) {
    return $config->{"config"};
  }
  else {
    confess $config->{"reason"};
  }
}

#------------------------------------------------------------------------------
# Asa ssh 函数入口
#------------------------------------------------------------------------------
sub ssh {
  my ( $self, %param ) = @_;
  my ( $host, $user, $password ) = @{param}{qw/ host user password /};
  my $conn = Firewall::Config::Connector::Device::Cisco->new(
    host     => $host,
    username => $user,
    password => $password,
    proto    => 'ssh'
  );
  my $config = $conn->getconfig();
  if ( $config->{"success"} ) {
    return $config->{"config"};
  }
  else {
    confess $config->{"reason"};
  }
}

__PACKAGE__->meta->make_immutable;
1;
