package Firewall::Config::Connector::Role;

#------------------------------------------------------------------------------
# 加载扩展模块
#------------------------------------------------------------------------------
use 5.016;
use Moose::Role;
use namespace::autoclean;
use Mojo::Util qw/dumper/;

#------------------------------------------------------------------------------
# 定义 Firewall::Config::Connector::Role 方法属性
#------------------------------------------------------------------------------
requires 'generateVendor';

#------------------------------------------------------------------------------
# 定义 telnet 方法直接抓取配置
#------------------------------------------------------------------------------
sub telnet {
  my ( $self, %param ) = @_;
  my ( $host, $user, $password ) = @{param}{qw/host user password/};
  # 绑定厂商
  my $vendor = $self->generateVendor();
  my $plugin = 'Firewall::Config::Connector::Device::' . $vendor;
  # 动态加载并做异常拦截
  eval("use $plugin;");
  confess "Error Can not load plugin $plugin " . __PACKAGE__ if $@;
  # 实例化插件对象
  my $conn = $plugin->new(
    host     => $host,
    username => $user,
    password => $password,
    proto    => 'telnet'
  );
  my $config = $conn->getConfig();
  if ( $config->{success} ) {
    return $config->{config};
  }
  else {
    confess $config->{reason};
  }
}

#------------------------------------------------------------------------------
# 定义 ssh 方法登录成功直接抓取配置
#------------------------------------------------------------------------------
sub ssh {
  my ( $self, %param ) = @_;
  my ( $host, $user, $password ) = @{param}{qw/host user password/};
  # 绑定厂商
  my $vendor = $self->generateVendor();
  my $plugin = 'Firewall::Config::Connector::Device::' . $vendor;
  # 动态加载并做异常拦截
  eval("use $plugin;");
  confess "Error Can not load plugin $plugin " . __PACKAGE__ if $@;
  # 实例化插件对象
  my $conn = $plugin->new(
    host     => $host,
    username => $user,
    password => $password,
    proto    => 'ssh'
  );
  # my $config = $conn->getConfig;
  my $config = $conn->getConfig();
  if ( $config->{success} ) {
    return $config->{config};
  }
  else {
    confess $config->{reason};
  }
}

1;
