use Kelp::Base -strict;
use Kelp::Test;
use Test::More;
use HTTP::Request::Common;
use Whelk;
use JSON::PP;

use lib 't/lib';

my $app = Whelk->new(mode => 'requests', __config => {formatter => 'YAML'});
my $t = Kelp::Test->new(app => $app);

################################################################################
# This test checks request data validation built into Whelk, but checks yaml
# behavior.
################################################################################

$t->request(
	POST '/body',
	)
	->code_is(415)
	->yaml_cmp({error => 'Supported Content-Types are application/json, text/yaml'});

$t->request(
	POST '/body',
	Content_Type => 'text/yaml',
	)
	->code_is(422)
	->yaml_cmp({error => 'Content error at: object'});

$t->request(
	POST '/body',
	Content_Type => 'text/yaml',
	Content => '[]',
	)
	->code_is(422)
	->yaml_cmp({error => 'Content error at: object'});

$t->request(
	POST '/body',
	Content_Type => 'text/yaml',
	Content => '{}',
	)
	->code_is(422)
	->yaml_cmp({error => 'Content error at: object[test]->required'});

$t->request(
	POST '/body',
	Content_Type => 'text/yaml',
	Content => 'test: 25.5',
	)
	->code_is(422)
	->yaml_cmp({error => 'Content error at: object[test]->integer'});

$t->request(
	POST '/body',
	Content_Type => 'text/yaml',
	Content => 'test: 13',
	)
	->code_is(200)
	->yaml_cmp(JSON::PP::false);

$t->request(
	POST '/body',
	Content_Type => 'application/json',
	Content => '{"test": 25}',
	)
	->code_is(200)
	->yaml_cmp(JSON::PP::true);

$t->request(
	POST '/body',
	Content_Type => 'text/yaml',
	Content => 'test: 25',
	)
	->code_is(200)
	->yaml_cmp(JSON::PP::true);

done_testing;

