# Range (Score) Voting Overview

Range or Score Voting is a variant of Ranked Choice Voting.

* There are a fixed number of Rankings available, usually 5, 10 or 100.

* Voters (Typically) May Rank Choices Equally.

* Voters Rank their best choice highest, the inverse of Ranked Choice.

Range Voting is usually resolved by Borda Count directly using the ratings assigned by the voters, by fixing the number of available rankings it resolves Borda Count's weighting problem. Condorcet can resolve Range Voting, but the ability to rank choices equally increases the possibility of ties. When resolving by IRV it is necessary to split the vote for equally ranked choices.

# Reading Range Ballots

See [Vote::Count::ReadBallots](../ReadBallots)

# Range Methods

## Score

Score is a method provided by [Vote::Count::Borda](../Borda) that will score the ballots based on the scores provided by the voters.

## STAR (Score Then Automatic Runoff)

Creates a runoff between the top 2 choices. Implemented in [Vote::Count::Method::STAR](../Method/STAR).

## Condorcet

[Vote::Count::Matrix](../Matrix) supports Range Ballots.

## IRV

Not yet implemented.

## Tie Breakers

Only Approval currently supports Range Ballots.

