package eris::base::types;

use Moose;
use Moose::Util::TypeConstraints;
use YAML;

# Config File to HashRef Conversion
subtype 'eris::type::config',
    as 'HashRef';
coerce  'eris::type::config'
    => from 'Str'
    => via {
        my $file = $_;
        my $config = {};
        if ( -f $file ) {
            eval {
                $config = YAML::LoadFile($file);
                1;
            } or die "unable to parse YAML file: $file, $@";
        }
        return $config;
    };

__PACKAGE__->meta->make_immutable;
1;

__END__

=pod

=encoding UTF-8

=head1 NAME

eris::base::types

=head1 VERSION

version 0.001_01

=head1 AUTHOR

Brad Lhotsky <brad@divisionbyzero.net>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2015 by Brad Lhotsky.

This is free software, licensed under:

  The (three-clause) BSD License

=cut
