#!perl

use strict;
use warnings;
$|=1;
use Test::More tests => 1;
use DBI;
#use DBD::SQLite;
use File::Spec;
use File::Path;
use File::Basename;

# rebuild cpanstats db

my $f = File::Spec->catfile('t','_DBDIR','test.db');
unlink $f if -f $f;
mkpath( dirname($f) );

my $dbh = DBI->connect("dbi:SQLite:dbname=$f", '', '', {AutoCommit=>1});
$dbh->do(q{
  CREATE TABLE cpanstats (
                          id            INTEGER PRIMARY KEY,
                          state         TEXT,
                          postdate      TEXT,
                          tester        TEXT,
                          dist          TEXT,
                          version       TEXT,
                          platform      TEXT,
                          perl          TEXT,
                          osname        TEXT,
                          osvers        TEXT,
                          fulldate      TEXT
  )
});

while(<DATA>){
  chomp;
  $dbh->do('INSERT INTO cpanstats ( id, state, postdate, tester, dist, version, platform, perl, osname, osvers, fulldate ) VALUES ( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ? )', {}, split(/\|/,$_) );
}

$dbh->do(q{ CREATE INDEX distverstate ON cpanstats (dist, version, state) });
$dbh->do(q{ CREATE INDEX ixdate ON cpanstats (postdate) });
$dbh->do(q{ CREATE INDEX ixperl ON cpanstats (perl) });
$dbh->do(q{ CREATE INDEX ixplat ON cpanstats (platform) });

my ($ct) = $dbh->selectrow_array('select count(*) from cpanstats');

$dbh->disconnect;

is($ct, 10976, "row count for cpanstats");

#select * from cpanstats where state='cpan' and dist in ('AEAE', 'AI-NeuralNet-BackProp', 'AI-NeuralNet-Mesh', 'AI-NeuralNet-SOM', 'AOL-TOC', 'Abstract-Meta-Class', 'Acme', 'Acme-Anything', 'Acme-BOPE', 'Acme-Brainfuck', 'Acme-Buffy', 'Acme-CPANAuthors-Canadian', 'Acme-CPANAuthors-CodeRepos', 'Acme-CPANAuthors-French', 'Acme-CPANAuthors-Japanese');
# sqlite> select * from cpanstats where postdate=200901 order by dist limit 20;
# id|state|postdate|tester|dist|version|platform|perl|osname|osvers|date
__DATA__
4769141|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|Data-FormValidator-Constraints-Words|0.03|s390x-linux-thread-multi|5.10.0|linux|2.6.27.19-5-default|200907250807
4768761|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|Games-Trackword|1.06|s390x-linux|5.8.9|linux|2.6.27.19-5-default|200907250645
4768746|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|Calendar-List|0.21|s390x-linux|5.8.9|linux|2.6.27.19-5-default|200907250643
4766868|pass|200907|cpan.dcollins.5100rc1@gmail.com|CPAN-WWW-Testers-Generator|0.30|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907241805
4766801|fail|200907|cpan.dcollins.smoker8@gmail.com|WWW-Scraper-ISBN-Amazon_Driver|0.14|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907241803
4766786|pass|200907|cpan.dcollins.smoker4@gmail.com|App-Maisha|0.12|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907241803
4766403|fail|200907|cpan.dcollins.5100rc1@gmail.com|WWW-Scraper-ISBN-ORA_Driver|0.09|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907241753
4766103|fail|200907|cpan.dcollins.smoker1@gmail.com|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907241744
4766061|pass|200907|cpan.dcollins.smoker6@gmail.com|App-Maisha|0.12|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907241743
4765898|fail|200907|cpan.dcollins.smoker1@gmail.com|WWW-Scraper-ISBN-Pearson_Driver|0.10|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907241739
4765868|pass|200907|cpan.dcollins.smoker1@gmail.com|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907241738
4765251|fail|200907|cpan.dcollins.smoker2@gmail.com|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907241720
4764927|pass|200907|cpan.dcollins.smoker5@gmail.com|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907241711
4764914|pass|200907|cpan.dcollins.smoker3@gmail.com|App-Maisha-Plugin-PingFM|0.02|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907241710
4764659|pass|200907|cpan.dcollins.smoker2@gmail.com|WWW-UsePerl-Journal-Thread|0.12|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907241703
4764609|pass|200907|cpan.dcollins.smoker4@gmail.com|Data-Phrasebook|0.29|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907241702
4764421|pass|200907|cpan.dcollins.smoker6@gmail.com|Data-FormValidator-Constraints-Words|0.03|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907241657
4764354|pass|200907|cpan.dcollins.smoker9@gmail.com|Mail-Outlook|0.15|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907241656
4763897|pass|200907|cpan.dcollins.smoker1@gmail.com|CPAN-Testers-Data-Generator|0.35|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907241645
4763676|pass|200907|cpan.dcollins.smoker8@gmail.com|Parse-CPAN-Distributions|0.05|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907241638
4763621|pass|200907|cpan.dcollins.smoker8@gmail.com|CPAN-Testers-WWW-Statistics|0.55|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907241636
4763613|pass|200907|cpan.dcollins.smoker2@gmail.com|Parse-CPAN-Distributions|0.05|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907241636
4763542|pass|200907|cpan.dcollins.smoker8@gmail.com|App-Maisha-Plugin-PingFM|0.02|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907241634
4762584|pass|200907|cpan.dcollins.smoker3@gmail.com|WWW-UsePerl-Journal-Thread|0.12|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907241609
4762464|pass|200907|cpan.dcollins.smoker1@gmail.com|CPAN-Testers-Data-Generator|0.35|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907241607
4762393|fail|200907|cpan.dcollins.smoker4@gmail.com|WWW-Scraper-ISBN-Amazon_Driver|0.14|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907241606
4762347|pass|200907|cpan.dcollins.smoker9@gmail.com|Games-Trackword|1.06|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907241605
4762041|pass|200907|cpan.dcollins.5100rc1@gmail.com|CPAN-Testers-WWW-Statistics|0.55|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907241600
4762008|pass|200907|cpan.dcollins.smoker2@gmail.com|Data-Phrasebook|0.29|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907241600
4761762|pass|200907|bingos@cpan.org|Regexp-Log-Common|0.05|i86pc-solaris|5.8.8|solaris|2.10|200907242024
4761682|pass|200907|cpan.dcollins.5100rc1@gmail.com|CPAN-WWW-Testers-Generator|0.30|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907241554
4760155|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|Data-FormValidator-Constraints-Words|0.03|s390x-linux-thread-multi|5.8.9|linux|2.6.27.19-5-default|200907241627
4756952|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook-Loader-YAML|0.09|s390x-linux|5.8.8|linux|2.6.27.19-5-default|200907240354
4756950|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook|0.29|s390x-linux|5.8.8|linux|2.6.27.19-5-default|200907240353
4756165|fail|200907|cpan.dcollins.smoker8@gmail.com|WWW-Scraper-ISBN-Amazon_Driver|0.14|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907240025
4755922|pass|200907|cpan.dcollins.smoker4@gmail.com|CPAN-WWW-Testers-Generator|0.30|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907240018
4755852|fail|200907|cpan.dcollins.5100rc1@gmail.com|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907240016
4755743|fail|200907|cpan.dcollins.smoker1@gmail.com|WWW-Scraper-ISBN-Amazon_Driver|0.14|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907240010
4754970|fail|200907|cpan.dcollins.smoker9@gmail.com|WWW-Scraper-ISBN-Amazon_Driver|0.14|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907231932
4754831|fail|200907|cpan.dcollins.smoker3@gmail.com|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907231926
4754597|pass|200907|cpan.dcollins.smoker4@gmail.com|WWW-UsePerl-Journal-Thread|0.12|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907231913
4754377|fail|200907|cpan.dcollins.smoker4@gmail.com|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907231902
4754291|pass|200907|cpan.dcollins.smoker2@gmail.com|Parse-CPAN-Distributions|0.05|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907231858
4753804|pass|200907|bingos@cpan.org|Parse-CPAN-Distributions|0.05|i686-linux-thread-multi-64int|5.10.0|linux|2.6.28-11-generic|200907232249
4753583|pass|200907|bingos@cpan.org|Mail-File|0.08|i686-linux-thread-multi-64int|5.10.0|linux|2.6.28-11-generic|200907232155
4753443|pass|200907|bingos@cpan.org|GD-Chart-Radial|0.07|i686-linux-thread-multi-64int|5.10.0|linux|2.6.28-11-generic|200907232117
4753442|pass|200907|bingos@cpan.org|Games-Trackword|1.06|i686-linux-thread-multi-64int|5.10.0|linux|2.6.28-11-generic|200907232117
4753414|pass|200907|bingos@cpan.org|Finance-Currency-Convert-XE|0.15|i686-linux-thread-multi-64int|5.10.0|linux|2.6.28-11-generic|200907232115
4753154|pass|200907|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi-64int|5.10.0|linux|2.6.28-11-generic|200907232020
4753153|pass|200907|bingos@cpan.org|Data-Phrasebook-Loader-XML|0.12|i686-linux-thread-multi-64int|5.10.0|linux|2.6.28-11-generic|200907232020
4753150|pass|200907|bingos@cpan.org|Data-Phrasebook-Loader-Ini|0.10|i686-linux-thread-multi-64int|5.10.0|linux|2.6.28-11-generic|200907232020
4753146|pass|200907|bingos@cpan.org|Data-Phrasebook-Loader-DBI|0.11|i686-linux-thread-multi-64int|5.10.0|linux|2.6.28-11-generic|200907232019
4753145|pass|200907|bingos@cpan.org|Data-Phrasebook|0.29|i686-linux-thread-multi-64int|5.10.0|linux|2.6.28-11-generic|200907232019
4753138|pass|200907|bingos@cpan.org|Data-FormValidator-Constraints-Words|0.03|i686-linux-thread-multi-64int|5.10.0|linux|2.6.28-11-generic|200907232018
4753070|fail|200907|bingos@cpan.org|CPAN-YACSmoke-Plugin-WebList|0.05|i686-linux-thread-multi-64int|5.10.0|linux|2.6.28-11-generic|200907232005
4753063|pass|200907|bingos@cpan.org|CPAN-YACSmoke-Plugin-NNTPWeb|0.06|i686-linux-thread-multi-64int|5.10.0|linux|2.6.28-11-generic|200907232004
4753036|pass|200907|bingos@cpan.org|CPAN-YACSmoke-Plugin-NNTP|0.05|i686-linux-thread-multi-64int|5.10.0|linux|2.6.28-11-generic|200907231959
4753031|pass|200907|bingos@cpan.org|CPAN-WWW-Testers-Generator|0.30|i686-linux-thread-multi-64int|5.10.0|linux|2.6.28-11-generic|200907231959
4753028|pass|200907|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.55|i686-linux-thread-multi-64int|5.10.0|linux|2.6.28-11-generic|200907231958
4753025|pass|200907|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.65|i686-linux-thread-multi-64int|5.10.0|linux|2.6.28-11-generic|200907231958
4753018|pass|200907|bingos@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.17|i686-linux-thread-multi-64int|5.10.0|linux|2.6.28-11-generic|200907231956
4753016|pass|200907|bingos@cpan.org|CPAN-Testers-WWW-Reports-Parser|0.01|i686-linux-thread-multi-64int|5.10.0|linux|2.6.28-11-generic|200907231956
4753008|pass|200907|bingos@cpan.org|CPAN-Testers-Data-Generator|0.37|i686-linux-thread-multi-64int|5.10.0|linux|2.6.28-11-generic|200907231954
4753007|pass|200907|bingos@cpan.org|CPAN-Testers-Data-Uploads|0.07|i686-linux-thread-multi-64int|5.10.0|linux|2.6.28-11-generic|200907231955
4753006|pass|200907|bingos@cpan.org|CPAN-Testers-Data-Generator|0.35|i686-linux-thread-multi-64int|5.10.0|linux|2.6.28-11-generic|200907231954
4752911|pass|200907|woody@2143.net|Test-YAML-Meta|0.12|i686-linux|5.8.8|linux|2.6.27-gentoo-r8|200907231842
4752887|pass|200907|bingos@cpan.org|Calendar-List|0.21|i686-linux-thread-multi-64int|5.10.0|linux|2.6.28-11-generic|200907231938
4752635|pass|200907|bingos@cpan.org|App-Maisha-Plugin-PingFM|0.02|i686-linux-thread-multi-64int|5.10.0|linux|2.6.28-11-generic|200907231851
4752626|pass|200907|bingos@cpan.org|App-Maisha|0.12|i686-linux-thread-multi-64int|5.10.0|linux|2.6.28-11-generic|200907231850
4752050|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Generator|0.35|s390x-linux|5.8.8|linux|2.6.27.19-5-default|200907231816
4750475|pass|200907|bingos@cpan.org|Regexp-Log-Common|0.05|alpha-linux-thread-multi|5.10.0|linux|2.6.18-5-alpha-generic|200907231355
4749847|pass|200907|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|alpha-linux-thread-multi|5.10.0|linux|2.6.18-5-alpha-generic|200907231204
4749845|pass|200907|bingos@cpan.org|CPAN-Testers-Data-Release|0.02|alpha-linux-thread-multi|5.10.0|linux|2.6.18-5-alpha-generic|200907231204
4749843|pass|200907|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|alpha-linux-thread-multi|5.10.0|linux|2.6.18-5-alpha-generic|200907231203
4748817|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|Games-Trackword|1.06|s390x-linux-thread-multi|5.10.0|linux|2.6.27.19-5-default|200907230904
4748811|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|Calendar-List|0.21|s390x-linux-thread-multi|5.10.0|linux|2.6.27.19-5-default|200907230902
4748175|pass|200907|bingos@cpan.org|Test-CPAN-Meta|0.13|i686-linux-thread-multi-64int|5.10.0|linux|2.6.28-11-generic|200907230505
4747966|pass|200907|cpan.dcollins.smoker4@gmail.com|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907230311
4747831|pass|200907|cpan.dcollins.smoker1@gmail.com|CPAN-Testers-WWW-Statistics|0.55|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907230304
4747512|pass|200907|cpan.dcollins.5100rc1@gmail.com|CPAN-Testers-Data-Generator|0.35|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907230257
4747503|pass|200907|cpan.dcollins.smoker4@gmail.com|CPAN-Testers-Data-Generator|0.35|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907230257
4747293|pass|200907|cpan.dcollins.smoker4@gmail.com|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907230253
4747096|pass|200907|cpan.dcollins.smoker9@gmail.com|Data-Phrasebook|0.29|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907230250
4746987|pass|200907|cpan.dcollins.smoker6@gmail.com|CPAN-Testers-WWW-Statistics|0.55|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907230248
4746594|pass|200907|cpan.dcollins.smoker9@gmail.com|CPAN-Testers-WWW-Statistics|0.55|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907230240
4746497|pass|200907|cpan.dcollins.smoker9@gmail.com|Data-Phrasebook|0.29|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907230238
4744652|pass|200907|stro@cpan.org|Test-JSON-Meta|0.01|MSWin32-x86-multi-thread|5.8.8|MSWin32|4.0|200907222351
4743941|pass|200907|bingos@cpan.org|Test-YAML-Meta|0.12|i86pc-solaris|5.8.7|solaris|2.10|200907221924
4743355|pass|200907|bingos@cpan.org|Test-YAML-Meta|0.12|i686-linux-thread-multi-64int|5.10.0|linux|2.6.28-11-generic|200907221809
4743019|pass|200907|bingos@cpan.org|Regexp-Log-Common|0.05|i86pc-solaris|5.8.7|solaris|2.10|200907221641
4742638|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|Games-Trackword|1.06|s390x-linux-thread-multi|5.8.9|linux|2.6.27.19-5-default|200907221724
4742629|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|Calendar-List|0.21|s390x-linux-thread-multi|5.8.9|linux|2.6.27.19-5-default|200907221722
4742396|pass|200907|bingos@cpan.org|Regexp-Log-Common|0.05|i686-linux-thread-multi-64int|5.10.0|linux|2.6.28-11-generic|200907221549
4742019|pass|200907|cpan.dcollins.smoker9@gmail.com|Data-Phrasebook|0.29|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907220946
4741950|pass|200907|cpan.dcollins.smoker4@gmail.com|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907220944
4741803|pass|200907|bingos@cpan.org|Test-JSON-Meta|0.01|i686-linux-thread-multi-64int|5.10.0|linux|2.6.28-11-generic|200907221427
4741801|pass|200907|bingos@cpan.org|Test-JSON-Meta|0.01|i86pc-solaris|5.8.7|solaris|2.10|200907221403
4741754|pass|200907|bingos@cpan.org|CPAN-Testers-Data-Release|0.02|i686-linux-thread-multi-64int|5.10.0|linux|2.6.28-11-generic|200907221425
4741749|pass|200907|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i686-linux-thread-multi-64int|5.10.0|linux|2.6.28-11-generic|200907221425
4741729|pass|200907|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi-64int|5.10.0|linux|2.6.28-11-generic|200907221425
4741637|pass|200907|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i86pc-solaris|5.8.7|solaris|2.10|200907221355
4741609|pass|200907|bingos@cpan.org|CPAN-Testers-Data-Release|0.02|i86pc-solaris|5.8.7|solaris|2.10|200907221354
4741603|pass|200907|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i86pc-solaris|5.8.7|solaris|2.10|200907221354
4741501|pass|200907|cpan.dcollins.smoker9@gmail.com|CPAN-Testers-Data-Generator|0.35|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907220916
4740659|pass|200907|cpan.dcollins.smoker5@gmail.com|App-Maisha-Plugin-PingFM|0.02|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907220840
4739689|pass|200907|stro@cpan.org|Test-JSON-Meta|0.01|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.00|200907221336
4739282|pass|200907|stro@cpan.org|CPAN-Testers-Data-Release|0.02|MSWin32-x86-multi-thread|5.8.8|MSWin32|4.0|200907221304
4739099|pass|200907|stro@cpan.org|CPAN-Testers-Data-Release|0.02|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.00|200907221242
4737204|pass|200907|cpan.dcollins.smoker2@gmail.com|CPAN-Testers-Data-Release|0.02|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907220001
4736615|pass|200907|cpan.dcollins.smoker1@gmail.com|CPAN-Testers-Data-Uploads|0.07|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907220351
4736406|pass|200907|cpan.dcollins.smoker3@gmail.com|Mail-Outlook|0.15|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907220347
4736276|pass|200907|cpan.dcollins.smoker6@gmail.com|App-Maisha|0.12|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907220344
4736271|pass|200907|cpan.dcollins.smoker6@gmail.com|App-Maisha|0.12|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907220344
4736083|pass|200907|cpan.dcollins.smoker2@gmail.com|Mail-Outlook|0.15|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907220341
4735903|pass|200907|cpan.dcollins.smoker2@gmail.com|App-Maisha-Plugin-PingFM|0.02|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907220337
4735866|pass|200907|cpan.dcollins.589@gmail.com|Mail-Outlook|0.15|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907220337
4735847|pass|200907|cpan.dcollins.smoker8@gmail.com|App-Maisha|0.12|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907220336
4734594|pass|200907|cpan.dcollins.smoker1@gmail.com|CPAN-Testers-Data-Release|0.02|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907211931
4733422|pass|200907|cpan.dcollins.589@gmail.com|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907211908
4732528|pass|200907|cpan.dcollins.smoker9@gmail.com|Test-CPAN-Meta|0.13|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907211846
4732484|pass|200907|cpan.dcollins.589@gmail.com|CPAN-Testers-WWW-Reports-Parser|0.01|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907211844
4731521|pass|200907|cpan.dcollins.smoker2@gmail.com|WWW-UsePerl-Journal|0.22|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907211806
4731235|pass|200907|cpan.dcollins.589@gmail.com|CPAN-Testers-Data-Generator|0.37|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907211758
4731180|pass|200907|cpan.dcollins.589@gmail.com|CPAN-Testers-Data-Generator|0.37|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907211756
4731063|pass|200907|cpan.dcollins.smoker3@gmail.com|CPAN-Testers-Data-Generator|0.37|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907211752
4730766|pass|200907|cpan.dcollins.smoker8@gmail.com|Test-CPAN-Meta|0.13|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907211737
4730600|pass|200907|cpan.dcollins.smoker2@gmail.com|WWW-UsePerl-Journal|0.22|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907211739
4729977|pass|200907|cpan.dcollins.smoker3@gmail.com|Test-CPAN-Meta|0.13|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907211723
4729746|pass|200907|cpan.dcollins.smoker4@gmail.com|CPAN-Testers-WWW-Statistics|0.65|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907211716
4729733|pass|200907|cpan.dcollins.5100rc1@gmail.com|CPAN-Testers-WWW-Reports-Mailer|0.17|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907211715
4729323|pass|200907|cpan.dcollins.smoker4@gmail.com|CPAN-Testers-WWW-Reports-Mailer|0.17|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907211704
4729094|pass|200907|cpan.dcollins.5100rc1@gmail.com|CPAN-Testers-WWW-Reports-Parser|0.01|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907211658
4729063|pass|200907|cpan.dcollins.smoker1@gmail.com|CPAN-Testers-WWW-Reports-Mailer|0.17|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907211658
4728791|pass|200907|cpan.dcollins.smoker9@gmail.com|CPAN-Testers-WWW-Reports-Parser|0.01|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907211650
4727799|pass|200907|martin.evans@easysoft.com|Data-Phrasebook-Loader-DBI|0.11|i686-linux|5.10.0|linux|2.6.24-24-generic|200907211740
4727785|pass|200907|martin.evans@easysoft.com|Data-Phrasebook-Loader-Ini|0.10|i686-linux|5.10.0|linux|2.6.24-24-generic|200907211739
4727781|pass|200907|martin.evans@easysoft.com|Data-Phrasebook-Loader-XML|0.12|i686-linux|5.10.0|linux|2.6.24-24-generic|200907211739
4727767|pass|200907|martin.evans@easysoft.com|Mail-File|0.08|i686-linux|5.10.0|linux|2.6.24-24-generic|200907211736
4727009|pass|200907|martin.evans@easysoft.com|CPAN-YACSmoke-Plugin-Outlook|0.06|i686-linux|5.10.0|linux|2.6.24-24-generic|200907211511
4727007|pass|200907|martin.evans@easysoft.com|CPAN-YACSmoke-Plugin-NNTP|0.05|i686-linux|5.10.0|linux|2.6.24-24-generic|200907211510
4726695|pass|200907|andy@hexten.net|Test-YAML-Meta|0.12|x86_64-linux-gnu-thread-multi|5.10.0|linux|2.6.28-11-generic|200907211420
4724251|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|Test-JSON-Meta|0.01|s390x-linux|5.8.8|linux|2.6.27.19-5-default|200907210627
4722716|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|Test-JSON-Meta|0.01|s390x-linux-thread-multi|5.8.9|linux|2.6.16.60-0.31-default|200907210110
4722667|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|Test-JSON-Meta|0.01|s390x-linux-thread-multi|5.8.8|linux|2.6.27.19-5-default|200907210059
4722507|pass|200907|bingos@cpan.org|Test-YAML-Meta|0.12|i86pc-solaris|5.8.6|solaris|2.10|200907202310
4721610|pass|200907|cpan.dcollins.smoker6@gmail.com|Regexp-Log-Common|0.05|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907201739
4721175|pass|200907|cpan.dcollins.smoker8@gmail.com|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907201729
4720349|pass|200907|cpan.dcollins.smoker1@gmail.com|Test-JSON-Meta|0.01|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907201708
4719799|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Release|0.02|s390x-linux|5.8.8|linux|2.6.27.19-5-default|200907202254
4718903|pass|200907|cpan.dcollins.smoker8@gmail.com|Regexp-Log-Common|0.05|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907201633
4718061|pass|200907|bingos@cpan.org|Test-YAML-Meta|0.12|i386-midnightbsd-64int|5.8.9|midnightbsd|0.1.1-release|200907201938
4717977|pass|200907|cpan.dcollins.smoker4@gmail.com|Test-YAML-Meta|0.12|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907201608
4717971|pass|200907|cpan.dcollins.smoker6@gmail.com|CPAN-Testers-Common-Article|0.36|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907201608
4717841|pass|200907|cpan.dcollins.smoker2@gmail.com|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907201604
4717840|pass|200907|cpan.dcollins.smoker2@gmail.com|CPAN-Testers-Common-Article|0.36|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907201604
4717650|pass|200907|cpan.dcollins.smoker4@gmail.com|WWW-UsePerl-Journal|0.22|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907201559
4717523|pass|200907|cpan.dcollins.589@gmail.com|CPAN-Testers-Data-Release|0.02|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907201555
4717414|pass|200907|cpan.dcollins.smoker4@gmail.com|CPAN-Testers-Common-Article|0.36|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907201552
4717354|pass|200907|cpan.dcollins.smoker2@gmail.com|Test-YAML-Meta|0.12|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907201550
4717210|pass|200907|cpan.dcollins.smoker3@gmail.com|Regexp-Log-Common|0.05|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907201545
4716961|pass|200907|cpan.dcollins.smoker8@gmail.com|Test-JSON-Meta|0.01|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907201539
4716884|pass|200907|cpan.dcollins.smoker1@gmail.com|Test-JSON-Meta|0.01|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907201538
4716291|pass|200907|cpan.dcollins.smoker4@gmail.com|Test-YAML-Meta|0.12|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907201524
4716121|pass|200907|justin.d.hunter@gmail.com|Regexp-Log-Common|0.05|i386-linux-thread-multi|5.8.8|linux|2.6.18-128.1.1.el5|200907201204
4715956|pass|200907|justin.d.hunter@gmail.com|Test-JSON-Meta|0.01|i386-linux-thread-multi|5.8.8|linux|2.6.18-128.1.1.el5|200907201138
4715946|pass|200907|justin.d.hunter@gmail.com|CPAN-Testers-Data-Release|0.02|i386-linux-thread-multi|5.8.8|linux|2.6.18-128.1.1.el5|200907201137
4715881|pass|200907|bingos@cpan.org|Regexp-Log-Common|0.05|i86pc-solaris|5.8.6|solaris|2.10|200907201905
4715146|pass|200907|bingos@cpan.org|Regexp-Log-Common|0.05|i386-midnightbsd-64int|5.8.9|midnightbsd|0.1.1-release|200907201606
4715137|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|Test-JSON-Meta|0.01|s390x-linux-thread-multi|5.8.9|linux|2.6.27.19-5-default|200907201838
4715036|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|Test-JSON-Meta|0.01|s390x-linux-thread-multi|5.10.0|linux|2.6.27.19-5-default|200907201825
4714761|pass|200907|bingos@cpan.org|Test-JSON-Meta|0.01|i86pc-solaris|5.8.6|solaris|2.10|200907201625
4714727|pass|200907|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i86pc-solaris|5.8.6|solaris|2.10|200907201622
4714725|pass|200907|bingos@cpan.org|CPAN-Testers-Data-Release|0.02|i86pc-solaris|5.8.6|solaris|2.10|200907201621
4714719|pass|200907|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i86pc-solaris|5.8.6|solaris|2.10|200907201621
4714550|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Release|0.02|s390x-linux-thread-multi|5.8.9|linux|2.6.16.60-0.31-default|200907201726
4714238|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Release|0.02|s390x-linux-thread-multi|5.8.8|linux|2.6.27.19-5-default|200907201656
4714112|pass|200907|bingos@cpan.org|Test-JSON-Meta|0.01|i386-midnightbsd-64int|5.8.9|midnightbsd|0.1.1-release|200907201406
4714106|pass|200907|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i386-midnightbsd-64int|5.8.9|midnightbsd|0.1.1-release|200907201404
4714096|pass|200907|bingos@cpan.org|CPAN-Testers-Data-Release|0.02|i386-midnightbsd-64int|5.8.9|midnightbsd|0.1.1-release|200907201403
4714091|pass|200907|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-midnightbsd-64int|5.8.9|midnightbsd|0.1.1-release|200907201403
4713794|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|Test-JSON-Meta|0.01|s390x-linux|5.8.9|linux|2.6.27.19-5-default|200907201615
4713502|pass|200907|ivan.wills@gmail.com ("Ivan Wills")|CPAN-Testers-Data-Release|0.02|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-23-server|200907202328
4713493|pass|200907|ivan.wills@gmail.com ("Ivan Wills")|CPAN-Testers-Data-Uploads|0.07|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-23-server|200907202327
4712770|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|Test-JSON-Meta|0.01|s390x-linux-thread-multi|5.8.8|linux|2.6.16.60-0.31-default|200907201326
4712529|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Release|0.02|s390x-linux-thread-multi|5.8.9|linux|2.6.27.19-5-default|200907201248
4712402|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|Test-JSON-Meta|0.01|s390x-linux|5.8.8|linux|2.6.16.60-0.31-default|200907201229
4711987|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|Test-JSON-Meta|0.01|s390x-linux|5.10.0|linux|2.6.27.19-5-default|200907201135
4711623|pass|200907|martin.evans@easysoft.com|CPAN-Testers-Data-Uploads|0.07|i686-linux|5.10.0|linux|2.6.24-24-generic|200907200946
4711622|pass|200907|martin.evans@easysoft.com|CPAN-Testers-Data-Release|0.02|i686-linux|5.10.0|linux|2.6.24-24-generic|200907200946
4711257|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|Test-JSON-Meta|0.01|s390-linux-thread-multi|5.8.9|linux|2.6.5-7.315-s390|200907200956
4710624|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|Test-JSON-Meta|0.01|s390x-linux|5.8.9|linux|2.6.16.60-0.31-default|200907200812
4710570|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Release|0.02|s390x-linux-thread-multi|5.8.8|linux|2.6.16.60-0.31-default|200907200801
4710561|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|Test-JSON-Meta|0.01|s390x-linux-thread-multi|5.10.0|linux|2.6.16.60-0.31-default|200907200759
4710334|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|Test-JSON-Meta|0.01|s390-linux|5.8.8|linux|2.6.5-7.315-s390|200907200713
4710276|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|Test-JSON-Meta|0.01|s390-linux|5.8.9|linux|2.6.5-7.315-s390|200907200705
4709196|pass|200907|cpan.dcollins.smoker9@gmail.com|Parse-CPAN-Distributions|0.05|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907200334
4709166|pass|200907|cpan.dcollins.smoker9@gmail.com|CPAN-Testers-Data-Release|0.01|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907200334
4709053|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|Test-JSON-Meta|0.01|s390x-linux-thread-multi|5.8.9|linux|2.6.18-92.1.18.el5|200907200531
4708666|pass|200907|cpan.dcollins.smoker1@gmail.com|Test-JSON-Meta|0.01|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907200325
4708510|pass|200907|cpan.dcollins.smoker8@gmail.com|CPAN-Testers-Common-Article|0.36|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907200323
4708507|pass|200907|cpan.dcollins.smoker3@gmail.com|CPAN-Testers-WWW-Reports-Mailer|0.17|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907200323
4707788|pass|200907|cpan.dcollins.smoker8@gmail.com|CPAN-Testers-WWW-Statistics|0.65|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907200311
4707722|pass|200907|cpan.dcollins.smoker8@gmail.com|CPAN-Testers-WWW-Reports-Mailer|0.17|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907200310
4707593|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|Test-JSON-Meta|0.01|s390x-linux|5.8.9|linux|2.6.18-92.1.18.el5|200907200503
4706860|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|Test-JSON-Meta|0.01|s390x-linux-thread-multi|5.8.8|linux|2.6.18-92.1.18.el5|200907200317
4706677|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|Test-JSON-Meta|0.01|s390x-linux|5.8.8|linux|2.6.18-92.1.18.el5|200907200246
4706564|pass|200907|jeff@zeroclue.com|Regexp-Log-Common|0.05|OpenBSD.i386-openbsd|5.8.9|openbsd|4.4|200907200033
4705646|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Release|0.02|s390-linux-thread-multi|5.8.9|linux|2.6.5-7.315-s390|200907200004
4705157|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|Test-JSON-Meta|0.01|s390-linux-thread-multi|5.10.0|linux|2.6.5-7.315-s390|200907192255
4704623|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Release|0.02|s390-linux|5.8.8|linux|2.6.5-7.315-s390|200907192124
4704613|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Release|0.02|s390-linux|5.8.9|linux|2.6.5-7.315-s390|200907192122
4704602|pass|200907|ivan.wills@gmail.com ("Ivan Wills")|App-Maisha-Plugin-PingFM|0.02|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-23-server|200907200520
4704247|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|Test-JSON-Meta|0.01|s390-linux|5.10.0|linux|2.6.5-7.315-s390|200907192019
4703956|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Release|0.02|s390x-linux-thread-multi|5.8.9|linux|2.6.18-92.1.18.el5|200907191928
4703803|pass|200907|ivan.wills@gmail.com ("Ivan Wills")|App-Maisha|0.12|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-23-server|200907200256
4703399|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Release|0.02|s390x-linux|5.8.9|linux|2.6.18-92.1.18.el5|200907191740
4703369|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|Test-JSON-Meta|0.01|s390x-linux-thread-multi|5.10.0|linux|2.6.18-92.el5|200907191737
4703173|pass|200907|ivan.wills@gmail.com ("Ivan Wills")|Mail-Outlook|0.15|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-23-server|200907200110
4703072|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Release|0.02|s390x-linux-thread-multi|5.8.8|linux|2.6.18-92.1.18.el5|200907191655
4703064|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|Test-JSON-Meta|0.01|s390x-linux|5.10.0|linux|2.6.18-92.el5|200907191653
4703043|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Release|0.02|s390x-linux|5.8.8|linux|2.6.18-92.1.18.el5|200907191647
4702627|pass|200907|cpan.dcollins.smoker4@gmail.com|Regexp-Log-Common|0.05|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907191015
4702290|pass|200907|cpan.dcollins.5100rc1@gmail.com|Mail-Outlook|0.15|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907191009
4701521|pass|200907|cpan.dcollins.smoker6@gmail.com|WWW-UsePerl-Journal|0.22|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907190958
4701469|pass|200907|cpan.dcollins.smoker4@gmail.com|CPAN-Testers-WWW-Statistics|0.55|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907190951
4700908|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Release|0.02|s390x-linux-thread-multi|5.10.0|linux|2.6.27.19-5-default|200907191548
4700904|pass|200907|cpan.dcollins.smoker3@gmail.com|Mail-Outlook|0.15|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907190948
4700614|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Uploads|0.07|s390x-linux-thread-multi|5.10.0|linux|2.6.27.19-5-default|200907191544
4700190|pass|200907|cpan.dcollins.smoker4@gmail.com|Test-JSON-Meta|0.01|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907190938
4699966|pass|200907|cpan.dcollins.5100rc1@gmail.com|Regexp-Log-Common|0.05|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907190934
4699667|pass|200907|cpan.dcollins.589@gmail.com|CPAN-Testers-Data-Release|0.02|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907190930
4699363|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Release|0.02|s390x-linux|5.8.8|linux|2.6.16.60-0.31-default|200907191525
4698678|pass|200907|cpan.dcollins.589@gmail.com|Test-YAML-Meta|0.12|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907190916
4698599|pass|200907|cpan.dcollins.589@gmail.com|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907190856
4698493|pass|200907|cpan.dcollins.smoker9@gmail.com|Data-Phrasebook|0.29|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907190913
4698354|pass|200907|cpan.dcollins.smoker1@gmail.com|CPAN-Testers-Data-Generator|0.35|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907190910
4698270|pass|200907|cpan.dcollins.smoker6@gmail.com|App-Maisha|0.12|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907190909
4697695|pass|200907|cpan.dcollins.5100rc1@gmail.com|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907190900
4697278|pass|200907|cpan.dcollins.smoker5@gmail.com|App-Maisha-Plugin-PingFM|0.02|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907190852
4697076|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Release|0.02|s390x-linux|5.8.9|linux|2.6.27.19-5-default|200907191437
4696678|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Release|0.02|s390-linux-thread-multi|5.10.0|linux|2.6.5-7.315-s390|200907191334
4696602|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Uploads|0.07|s390-linux-thread-multi|5.10.0|linux|2.6.5-7.315-s390|200907191329
4696103|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Release|0.02|s390x-linux-thread-multi|5.10.0|linux|2.6.16.60-0.31-default|200907191221
4695948|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Release|0.02|s390x-linux|5.10.0|linux|2.6.27.19-5-default|200907191202
4695911|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Uploads|0.07|s390x-linux|5.10.0|linux|2.6.27.19-5-default|200907191158
4695795|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Release|0.02|s390-linux|5.10.0|linux|2.6.5-7.315-s390|200907191141
4695761|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Uploads|0.07|s390-linux|5.10.0|linux|2.6.5-7.315-s390|200907191137
4695391|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Release|0.02|s390x-linux-thread-multi|5.10.0|linux|2.6.18-92.el5|200907191053
4695251|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Release|0.02|s390x-linux|5.10.0|linux|2.6.18-92.el5|200907191033
4694869|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Release|0.02|s390x-linux|5.8.9|linux|2.6.16.60-0.31-default|200907190908
4694865|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|Test-JSON-Meta|0.01|s390x-linux-thread-multi-perlio|5.6.2|linux|2.6.27.19-5-default|200907190907
4694789|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Release|0.02|s390x-linux|5.10.0|linux|2.6.16.60-0.31-default|200907190841
4694764|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|Test-JSON-Meta|0.01|s390x-linux-thread-multi|5.6.2|linux|2.6.27.19-5-default|200907190835
4694734|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|Test-JSON-Meta|0.01|s390-linux-thread-multi-perlio|5.6.2|linux|2.6.5-7.315-s390|200907190829
4694566|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|Test-JSON-Meta|0.01|s390x-linux-thread-multi|5.6.2|linux|2.6.18-92.1.18.el5|200907190754
4694543|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|Test-JSON-Meta|0.01|s390-linux-thread-multi|5.6.2|linux|2.6.5-7.315-s390|200907190749
4694363|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|Test-JSON-Meta|0.01|s390x-linux|5.6.2|linux|2.6.27.19-5-default|200907190718
4694300|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|Test-JSON-Meta|0.01|s390-linux|5.6.2|linux|2.6.5-7.315-s390|200907190701
4693851|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|Test-JSON-Meta|0.01|s390x-linux|5.6.2|linux|2.6.18-92.1.18.el5|200907190637
4693690|pass|200907|cpan.dcollins.smoker4@gmail.com|Regexp-Log-Common|0.05|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907190034
4693587|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|Test-JSON-Meta|0.01|s390x-linux-thread-multi|5.6.2|linux|2.6.16.60-0.31-default|200907190631
4693532|pass|200907|cpan.dcollins.smoker8@gmail.com|Test-CPAN-Meta|0.13|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907190030
4692997|pass|200907|cpan.dcollins.smoker6@gmail.com|Test-CPAN-Meta|0.13|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907190017
4692958|pass|200907|cpan.dcollins.589@gmail.com|CPAN-Testers-WWW-Reports-Parser|0.01|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907190016
4691279|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|Test-JSON-Meta|0.01|s390x-linux|5.6.2|linux|2.6.16.60-0.31-default|200907190527
4691192|pass|200907|cpan.dcollins.smoker2@gmail.com|CPAN-Testers-Common-Article|0.36|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907190324
4691136|pass|200907|cpan.dcollins.5100@gmail.com|WWW-UsePerl-Journal|0.22|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907190323
4691117|pass|200907|cpan.dcollins.smoker3@gmail.com|CPAN-Testers-Data-Uploads|0.07|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907190322
4691059|pass|200907|cpan.dcollins.smoker6@gmail.com|CPAN-Testers-WWW-Reports-Mailer|0.17|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907190320
4690944|pass|200907|cpan.dcollins.5100@gmail.com|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907190317
4690606|pass|200907|cpan.dcollins.smoker3@gmail.com|WWW-UsePerl-Journal|0.22|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907190308
4690575|pass|200907|cpan.dcollins.smoker1@gmail.com|CPAN-Testers-Data-Release|0.02|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907190307
4690423|pass|200907|cpan.dcollins.smoker6@gmail.com|Test-YAML-Meta|0.12|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907190302
4690163|pass|200907|cpan.dcollins.smoker2@gmail.com|CPAN-Testers-WWW-Reports-Mailer|0.17|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907190255
4689962|pass|200907|cpan.dcollins.smoker3@gmail.com|CPAN-Testers-Data-Release|0.02|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907190249
4689882|pass|200907|cpan.dcollins.589@gmail.com|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907190247
4689760|pass|200907|cpan.dcollins.589@gmail.com|CPAN-Testers-Data-Generator|0.37|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907190244
4689620|pass|200907|cpan.dcollins.smoker6@gmail.com|Regexp-Log-Common|0.05|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907190240
4689519|pass|200907|cpan.dcollins.5100rc1@gmail.com|CPAN-Testers-WWW-Reports-Parser|0.01|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907190237
4689332|pass|200907|cpan.dcollins.smoker6@gmail.com|Test-JSON-Meta|0.01|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907190232
4688456|pass|200907|cpan.dcollins.smoker1@gmail.com|Test-JSON-Meta|0.01|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907190207
4688273|pass|200907|cpan.dcollins.smoker9@gmail.com|Test-YAML-Meta|0.12|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907190202
4688265|pass|200907|cpan.dcollins.smoker6@gmail.com|CPAN-Testers-Common-Article|0.36|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907190202
4688141|pass|200907|cpan.dcollins.5100@gmail.com|CPAN-Testers-WWW-Statistics|0.65|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907190158
4687942|pass|200907|cpan.dcollins.smoker5@gmail.com|CPAN-Testers-Data-Generator|0.37|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907190152
4686813|pass|200907|barthex@linux.e-cen.pl ("Bartosz Talaga")|Test-YAML-Meta|0.12|i686-linux|5.10.0|linux|2.2.26|200907182305
4685176|pass|200907|bingos@cpan.org|Regexp-Log-Common|0.05|i86pc-solaris|5.8.5|solaris|2.10|200907182043
4684775|pass|200907|bingos@cpan.org|Test-YAML-Meta|0.12|i86pc-solaris|5.8.5|solaris|2.10|200907181939
4684759|pass|200907|bingos@cpan.org|Regexp-Log-Common|0.05|i386-midnightbsd-64int|5.10.0|midnightbsd|0.1.1-release|200907181853
4684564|pass|200907|bingos@cpan.org|Test-YAML-Meta|0.12|i386-midnightbsd-64int|5.10.0|midnightbsd|0.1.1-release|200907181810
4684107|pass|200907|david@cantrell.org.uk|CPAN-Testers-Data-Uploads|0.07|alpha-netbsd|5.10.0|netbsd|4.0.1|200907181656
4684054|pass|200907|david@cantrell.org.uk|CPAN-Testers-Data-Release|0.02|alpha-netbsd|5.10.0|netbsd|4.0.1|200907181650
4683824|pass|200907|david@cantrell.org.uk|CPAN-Testers-Data-Release|0.02|IP35-irix-64int|5.8.8|irix|6.5|200907181821
4683778|pass|200907|bingos@cpan.org|Test-JSON-Meta|0.01|i386-midnightbsd-64int|5.10.0|midnightbsd|0.1.1-release|200907181615
4683762|pass|200907|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i386-midnightbsd-64int|5.10.0|midnightbsd|0.1.1-release|200907181613
4683755|pass|200907|bingos@cpan.org|CPAN-Testers-Data-Release|0.02|i386-midnightbsd-64int|5.10.0|midnightbsd|0.1.1-release|200907181612
4683753|pass|200907|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-midnightbsd-64int|5.10.0|midnightbsd|0.1.1-release|200907181612
4683651|pass|200907|ivan.wills@gmail.com ("Ivan Wills")|CPAN-Testers-Data-Release|0.02|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-23-server|200907190203
4683640|pass|200907|ivan.wills@gmail.com ("Ivan Wills")|CPAN-Testers-Data-Uploads|0.07|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-23-server|200907190202
4683604|pass|200907|bingos@cpan.org|Test-JSON-Meta|0.01|i86pc-solaris|5.8.5|solaris|2.10|200907181642
4683576|pass|200907|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i86pc-solaris|5.8.5|solaris|2.10|200907181639
4683567|pass|200907|bingos@cpan.org|CPAN-Testers-Data-Release|0.02|i86pc-solaris|5.8.5|solaris|2.10|200907181638
4683565|pass|200907|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i86pc-solaris|5.8.5|solaris|2.10|200907181638
4683375|pass|200907|stsc@refcnt.org ("Steven Schubiger")|CPAN-Testers-Data-Uploads|0.07|i686-linux-thread-multi|5.10.0|linux|2.6.18-14-ovz-686|200907181724
4683178|pass|200907|imacat@mail.imacat.idv.tw|CPAN-Testers-Data-Uploads|0.07|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-2-amd64|200907182300
4683137|pass|200907|imacat@mail.imacat.idv.tw|CPAN-Testers-Data-Release|0.02|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-2-amd64|200907182256
4682844|pass|200907|david@cantrell.org.uk|CPAN-Testers-Data-Uploads|0.07|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200907180918
4682791|pass|200907|david@cantrell.org.uk|CPAN-Testers-Data-Release|0.02|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200907180911
4682630|pass|200907|david@cantrell.org.uk|CPAN-Testers-Data-Uploads|0.07|x86_64-linux-thread-multi|5.6.2|linux|2.6.18-4-xen-amd64|200907181439
4682621|pass|200907|david@cantrell.org.uk|CPAN-Testers-Data-Uploads|0.07|x86_64-linux-thread-multi|5.10.0|linux|2.6.18-4-xen-amd64|200907181438
4682617|pass|200907|david@cantrell.org.uk|CPAN-Testers-Data-Uploads|0.07|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200907181437
4682612|pass|200907|david@cantrell.org.uk|CPAN-Testers-Data-Release|0.02|x86_64-linux-thread-multi|5.6.2|linux|2.6.18-4-xen-amd64|200907181437
4682608|pass|200907|david@cantrell.org.uk|CPAN-Testers-Data-Release|0.02|x86_64-linux-thread-multi|5.10.0|linux|2.6.18-4-xen-amd64|200907181436
4682607|pass|200907|david@cantrell.org.uk|CPAN-Testers-Data-Release|0.02|x86_64-linux-thread-multi|5.8.9|linux|2.6.18-4-xen-amd64|200907181436
4682605|pass|200907|david@cantrell.org.uk|CPAN-Testers-Data-Release|0.02|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200907181436
4682596|pass|200907|david@cantrell.org.uk|CPAN-Testers-Data-Uploads|0.07|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200907181434
4682590|pass|200907|david@cantrell.org.uk|CPAN-Testers-Data-Release|0.02|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200907181432
4681890|fail|200907|castaway@desert-island.demon.co.uk|WWW-Scraper-ISBN-Amazon_Driver|0.14|i686-linux-thread-multi|5.8.8|linux|2.6.20.1insel|200907172316
4679711|pass|200907|cpan.dcollins.smoker9@gmail.com|CPAN-Testers-WWW-Reports-Parser|0.01|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907180121
4679350|pass|200907|cpan.dcollins.5100@gmail.com|CPAN-Testers-Data-Generator|0.37|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907180115
4679184|pass|200907|cpan.dcollins.smoker2@gmail.com|Mail-Outlook|0.15|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907180112
4678934|pass|200907|cpan.dcollins.smoker6@gmail.com|WWW-UsePerl-Journal|0.22|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907180108
4678275|pass|200907|cpan.dcollins.smoker1@gmail.com|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907180057
4678274|pass|200907|cpan.dcollins.smoker2@gmail.com|Test-CPAN-Meta|0.13|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907180057
4678204|pass|200907|cpan.dcollins.smoker3@gmail.com|Regexp-Log-Common|0.05|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907180055
4677274|pass|200907|cpan.dcollins.smoker7@gmail.com|CPAN-Testers-Data-Generator|0.37|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907180039
4677074|pass|200907|cpan.dcollins.smoker5@gmail.com|CPAN-Testers-WWW-Reports-Parser|0.01|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907180036
4676667|pass|200907|cpan.dcollins.smoker2@gmail.com|CPAN-Testers-WWW-Reports-Mailer|0.17|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907180029
4675557|pass|200907|cpan.dcollins.smoker3@gmail.com|CPAN-Testers-WWW-Statistics|0.65|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907180010
4675477|pass|200907|cpan.dcollins.smoker1@gmail.com|Test-CPAN-Meta|0.13|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907180009
4675269|pass|200907|cpan.dcollins.smoker8@gmail.com|CPAN-Testers-WWW-Reports-Mailer|0.17|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907180005
4674911|pass|200907|cpan.dcollins.smoker2@gmail.com|Mail-Outlook|0.15|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907180359
4674783|pass|200907|cpan.dcollins.5100rc1@gmail.com|CPAN-Testers-WWW-Statistics|0.65|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907180357
4674753|pass|200907|cpan.dcollins.smoker8@gmail.com|CPAN-Testers-Data-Generator|0.37|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907180356
4674717|pass|200907|cpan.dcollins.smoker4@gmail.com|Mail-Outlook|0.15|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907180356
4674666|pass|200907|cpan.dcollins.smoker2@gmail.com|CPAN-Testers-WWW-Reports-Parser|0.01|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907180355
4674440|pass|200907|cpan.dcollins.smoker2@gmail.com|Test-CPAN-Meta|0.13|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907180351
4674032|pass|200907|jeff@zeroclue.com|Test-CPAN-Meta|0.13|OpenBSD.i386-openbsd|5.8.9|openbsd|4.4|200907180305
4669811|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook-Loader-Ini|0.10|s390x-linux-thread-multi|5.6.2|linux|2.6.27.19-5-default|200907171915
4669797|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook-Loader-XML|0.12|s390x-linux-thread-multi|5.6.2|linux|2.6.27.19-5-default|200907171913
4669691|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|Mail-File|0.08|s390x-linux-thread-multi|5.6.2|linux|2.6.27.19-5-default|200907171858
4669685|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|Regexp-Log-Common|0.05|s390x-linux-thread-multi|5.6.2|linux|2.6.27.19-5-default|200907171857
4669671|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook|0.29|s390x-linux-thread-multi|5.6.2|linux|2.6.27.19-5-default|200907171856
4668932|pass|200907|martin.evans@easysoft.com|Test-JSON-Meta|0.01|i686-linux|5.10.0|linux|2.6.24-24-generic|200907171639
4667381|pass|200907|cpan.dcollins.smoker4@gmail.com|Mail-Outlook|0.15|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907170959
4667374|pass|200907|cpan.dcollins.smoker1@gmail.com|App-Maisha-Plugin-PingFM|0.02|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907171004
4667357|unknown|200907|cpan.dcollins.smoker9@gmail.com|Data-Phrasebook-Loader-XML|0.12|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907171004
4667309|pass|200907|jeff@zeroclue.com|CPAN-Testers-WWW-Reports-Mailer|0.17|OpenBSD.i386-openbsd|5.8.9|openbsd|4.4|200907170703
4667239|pass|200907|cpan.dcollins.smoker5@gmail.com|Regexp-Log-Common|0.05|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907171001
4667218|pass|200907|jeff@zeroclue.com|CPAN-Testers-WWW-Statistics|0.65|OpenBSD.i386-openbsd|5.8.9|openbsd|4.4|200907170700
4667182|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-YACSmoke-Plugin-Outlook|0.06|s390x-linux-thread-multi|5.6.2|linux|2.6.27.19-5-default|200907171559
4666899|pass|200907|mw487.yahoo.com@gmail.com|Test-JSON-Meta|0.01|cygwin-thread-multi-64int|5.10.0 patch 34065|cygwin|1.5.25(0.15642)|200907170853
4666873|pass|200907|cpan.dcollins.smoker4@gmail.com|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907170953
4666863|fail|200907|cpan.dcollins.smoker9@gmail.com|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907170952
4666842|pass|200907|mw487.yahoo.com@gmail.com|CPAN-Testers-Data-Release|0.02|cygwin-thread-multi-64int|5.10.0 patch 34065|cygwin|1.5.25(0.15642)|200907170852
4666049|pass|200907|cpan.dcollins.smoker3@gmail.com|CPAN-Testers-Data-Generator|0.37|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907170934
4665946|pass|200907|cpan.dcollins.5100@gmail.com|CPAN-Testers-Data-Generator|0.37|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907170931
4665882|pass|200907|cpan.dcollins.smoker3@gmail.com|Mail-Outlook|0.15|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907170930
4665459|pass|200907|jeff@zeroclue.com|CPAN-Testers-Data-Generator|0.37|OpenBSD.i386-openbsd|5.8.9|openbsd|4.4|200907170619
4665318|pass|200907|cpan.dcollins.5100rc1@gmail.com|Regexp-Log-Common|0.05|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907170916
4665187|pass|200907|cpan.dcollins.smoker7@gmail.com|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907170913
4664905|pass|200907|cpan.dcollins.smoker8@gmail.com|CPAN-Testers-Data-Generator|0.37|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907170906
4664867|pass|200907|jeff@zeroclue.com|CPAN-Testers-Data-Release|0.01|OpenBSD.i386-openbsd|5.8.9|openbsd|4.4|200907170606
4664559|pass|200907|cpan.dcollins.5100@gmail.com|Test-JSON-Meta|0.01|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907170859
4664289|pass|200907|cpan.dcollins.5100@gmail.com|Regexp-Log-Common|0.05|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907170855
4664230|pass|200907|cpan.dcollins.smoker2@gmail.com|Test-YAML-Meta|0.12|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907170854
4664046|unknown|200907|cpan.dcollins.smoker3@gmail.com|CPAN-Testers-Data-Release|0.02|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907170850
4663991|pass|200907|cpan.dcollins.smoker7@gmail.com|CPAN-Testers-Data-Uploads|0.07|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907170849
4663445|pass|200907|cpan.dcollins.5100rc1@gmail.com|Regexp-Log-Common|0.05|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907170840
4663114|pass|200907|cpan.dcollins.smoker7@gmail.com|Test-YAML-Meta|0.12|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907170834
4663094|pass|200907|cpan.dcollins.5100@gmail.com|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907170833
4663084|pass|200907|cpan.dcollins.smoker1@gmail.com|CPAN-Testers-Common-Article|0.36|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907170833
4662815|pass|200907|cpan.dcollins.smoker5@gmail.com|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907170829
4662756|pass|200907|cpan.dcollins.5100@gmail.com|CPAN-Testers-Data-Uploads|0.07|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907170828
4662346|pass|200907|jeff@zeroclue.com|CPAN-Testers-WWW-Reports-Parser|0.01|OpenBSD.i386-openbsd|5.8.9|openbsd|4.4|200907170521
4662333|pass|200907|cpan.dcollins.5100@gmail.com|CPAN-Testers-Data-Release|0.02|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907170821
4662090|pass|200907|cpan.dcollins.smoker5@gmail.com|CPAN-Testers-Common-Article|0.36|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907170817
4661943|pass|200907|cpan.dcollins.smoker7@gmail.com|CPAN-Testers-Data-Release|0.02|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907170814
4661576|unknown|200907|cpan.dcollins.smoker1@gmail.com|CPAN-Testers-Data-Uploads|0.07|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907170808
4661408|pass|200907|david@cantrell.org.uk|Test-JSON-Meta|0.01|alpha-netbsd|5.10.0|netbsd|4.0.1|200907171154
4661377|pass|200907|david@cantrell.org.uk|Test-JSON-Meta|0.01|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200907170650
4661326|pass|200907|david@cantrell.org.uk|Test-JSON-Meta|0.01|IP35-irix-64int|5.8.8|irix|6.5|200907171346
4661308|pass|200907|david@cantrell.org.uk|Test-JSON-Meta|0.01|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200907171244
4661303|pass|200907|david@cantrell.org.uk|Test-JSON-Meta|0.01|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200907171244
4661297|pass|200907|david@cantrell.org.uk|Test-JSON-Meta|0.01|x86_64-linux-thread-multi|5.8.9|linux|2.6.18-4-xen-amd64|200907171243
4661292|pass|200907|david@cantrell.org.uk|Test-JSON-Meta|0.01|x86_64-linux-thread-multi|5.10.0|linux|2.6.18-4-xen-amd64|200907171243
4661268|pass|200907|david@cantrell.org.uk|Test-JSON-Meta|0.01|x86_64-linux-thread-multi|5.6.2|linux|2.6.18-4-xen-amd64|200907171241
4661045|pass|200907|mw487.yahoo.com@gmail.com|Test-JSON-Meta|0.01|cygwin-thread-multi-64int|5.8.8|cygwin|1.5.24(0.15642)|200907170609
4660521|pass|200907|imacat@mail.imacat.idv.tw|Test-JSON-Meta|0.01|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-2-amd64|200907171757
4660214|pass|200907|JOST@cpan.org ("Josts Smokehouse")|CPAN-Testers-Data-Release|0.02|i86pc-solaris-64int|5.10.0|solaris|2.11|200907171115
4660210|pass|200907|JOST@cpan.org ("Josts Smokehouse")|CPAN-Testers-Data-Uploads|0.07|i86pc-solaris-64int|5.10.0|solaris|2.11|200907171114
4659809|pass|200907|JOST@cpan.org ("Josts Smokehouse")|CPAN-Testers-Data-Release|0.02|i86pc-solaris-64int|5.8.9|solaris|2.11|200907171025
4659447|pass|200907|jeff@zeroclue.com|WWW-UsePerl-Journal|0.22|OpenBSD.i386-openbsd|5.8.9|openbsd|4.4|200907170049
4659393|pass|200907|bingos@cpan.org|Finance-Currency-Convert-XE|0.15|darwin-thread-multi-64int-2level|5.11.0 patch GitLive-blead-1530-g9ef4351|darwin|8.11.0|200907170845
4659059|pass|200907|srezic@cpan.org|CPAN-Testers-Data-Release|0.02|amd64-freebsd|5.8.8|freebsd|7.0-release|200907170806
4659057|pass|200907|srezic@cpan.org|CPAN-Testers-Data-Release|0.02|amd64-freebsd|5.8.9|freebsd|7.0-release|200907170806
4659028|pass|200907|rbo@cpan.org|CPAN-Testers-Data-Uploads|0.07|i86pc-solaris|5.10.0|solaris|2.11|200907170857
4659000|pass|200907|rbo@cpan.org|CPAN-Testers-Data-Release|0.02|i86pc-solaris|5.10.0|solaris|2.11|200907170851
4658892|pass|200907|srezic@cpan.org|CPAN-Testers-Data-Uploads|0.07|amd64-freebsd|5.8.8|freebsd|7.0-release|200907170806
4658886|pass|200907|srezic@cpan.org|CPAN-Testers-Data-Uploads|0.07|amd64-freebsd|5.8.9|freebsd|7.0-release|200907170806
4658072|unknown|200907|cpan.dcollins.smoker5@gmail.com|CPAN-YACSmoke-Plugin-NNTP|0.05|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907170324
4658069|pass|200907|cpan.dcollins.smoker7@gmail.com|Regexp-Log-Common|0.05|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907170324
4657959|pass|200907|cpan.dcollins.5100@gmail.com|WWW-UsePerl-Journal|0.22|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907170317
4657584|unknown|200907|cpan.dcollins.smoker7@gmail.com|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907170311
4657290|pass|200907|cpan.dcollins.smoker7@gmail.com|CPAN-Testers-Data-Generator|0.35|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907170306
4657288|pass|200907|cpan.dcollins.smoker7@gmail.com|CPAN-Testers-Data-Generator|0.35|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907170306
4657087|unknown|200907|cpan.dcollins.5100rc1@gmail.com|GD-Chart-Radial|0.07|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907170302
4656829|unknown|200907|cpan.dcollins.smoker2@gmail.com|Data-Phrasebook-Loader-Ini|0.10|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907170258
4655950|pass|200907|cpan.dcollins.smoker8@gmail.com|App-Maisha|0.12|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907170243
4655720|pass|200907|cpan.dcollins.5100rc1@gmail.com|Test-YAML-Meta|0.12|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907170239
4655542|fail|200907|cpan.dcollins.smoker6@gmail.com|WWW-Scraper-ISBN-Amazon_Driver|0.14|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907170236
4655436|pass|200907|cpan.dcollins.5100@gmail.com|CPAN-Testers-WWW-Statistics|0.55|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907170234
4655174|pass|200907|cpan.dcollins.smoker4@gmail.com|Parse-CPAN-Distributions|0.05|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907170230
4655170|pass|200907|cpan.dcollins.smoker4@gmail.com|Parse-CPAN-Distributions|0.05|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907170230
4655087|pass|200907|cpan.dcollins.smoker3@gmail.com|WWW-UsePerl-Journal-Thread|0.12|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907170228
4655059|pass|200907|cpan.dcollins.smoker6@gmail.com|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907170228
4654990|pass|200907|cpan.dcollins.5100@gmail.com|CPAN-Testers-Data-Generator|0.35|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907170227
4654503|pass|200907|cpan.dcollins.smoker2@gmail.com|CPAN-WWW-Testers-Generator|0.30|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907170219
4654394|pass|200907|cpan.dcollins.5100@gmail.com|WWW-UsePerl-Journal-Thread|0.12|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907170217
4653528|unknown|200907|cpan.dcollins.5100rc1@gmail.com|Test-JSON-Meta|0.01|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907170202
4653415|pass|200907|cpan.dcollins.5100@gmail.com|App-Maisha-Plugin-PingFM|0.02|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907170200
4653248|pass|200907|cpan.dcollins.smoker4@gmail.com|Data-Phrasebook|0.29|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907170157
4653224|fail|200907|cpan.dcollins.5100@gmail.com|WWW-Scraper-ISBN-Amazon_Driver|0.14|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907170157
4652897|fail|200907|cpan.dcollins.smoker1@gmail.com|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907170151
4652871|pass|200907|cpan.dcollins.smoker8@gmail.com|CPAN-Testers-WWW-Statistics|0.55|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907170150
4652248|pass|200907|cpan.dcollins.smoker6@gmail.com|CPAN-WWW-Testers-Generator|0.30|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907170140
4652130|pass|200907|cpan.dcollins.smoker3@gmail.com|App-Maisha|0.12|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907170138
4652030|pass|200907|cpan.dcollins.smoker1@gmail.com|Data-Phrasebook|0.29|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907170136
4649799|pass|200907|bob@randomness.org.uk ("bob walker")|CPAN-Testers-Data-Release|0.02|i86pc-solaris|5.10.0|solaris|2.10|200907162118
4649790|pass|200907|bob@randomness.org.uk ("bob walker")|CPAN-Testers-Data-Uploads|0.07|i86pc-solaris|5.10.0|solaris|2.10|200907162116
4649787|pass|200907|bob@randomness.org.uk ("bob walker")|CPAN-Testers-Common-Article|0.36|i86pc-solaris|5.10.0|solaris|2.10|200907162115
4649786|pass|200907|bob@randomness.org.uk ("bob walker")|CPAN-Testers-Common-DBUtils|0.03|i86pc-solaris|5.10.0|solaris|2.10|200907162115
4648750|cpan|200907|BARBIE|CPAN-Testers-Data-Uploads|0.07||0|||200907162011
4648605|cpan|200907|BARBIE|CPAN-Testers-Data-Release|0.02||0|||200907161947
4648160|pass|200907|ivan.wills@gmail.com ("Ivan Wills")|CPAN-Testers-Data-Uploads|0.06|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-23-server|200907170259
4648043|pass|200907|bingos@cpan.org|Regexp-Log-Common|0.05|i86pc-solaris|5.8.4|solaris|2.10|200907161738
4647731|pass|200907|ivan.wills@gmail.com ("Ivan Wills")|App-Maisha-Plugin-PingFM|0.02|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-23-server|200907170216
4647463|pass|200907|bingos@cpan.org|Test-YAML-Meta|0.12|i86pc-solaris|5.8.4|solaris|2.10|200907161634
4647422|pass|200907|bingos@cpan.org|Regexp-Log-Common|0.05|OpenBSD.i386-openbsd|5.8.9|openbsd|4.5|200907161641
4647023|pass|200907|bingos@cpan.org|Test-YAML-Meta|0.12|OpenBSD.i386-openbsd|5.8.9|openbsd|4.5|200907161544
4645959|pass|200907|bingos@cpan.org|Test-JSON-Meta|0.01|i86pc-solaris|5.8.4|solaris|2.10|200907161335
4645949|pass|200907|bingos@cpan.org|Regexp-Log-Common|0.05|alpha-linux-thread-multi|5.8.9|linux|2.6.18-5-alpha-generic|200907161345
4645862|pass|200907|ivan.wills@gmail.com ("Ivan Wills")|Regexp-Log-Common|0.05|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-23-server|200907162236
4645674|pass|200907|bingos@cpan.org|Test-JSON-Meta|0.01|OpenBSD.i386-openbsd|5.8.9|openbsd|4.5|200907161311
4645621|pass|200907|ivan.wills@gmail.com ("Ivan Wills")|Test-JSON-Meta|0.01|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-23-server|200907162207
4644592|pass|200907|bingos@cpan.org|Test-JSON-Meta|0.01|alpha-linux-thread-multi|5.8.9|linux|2.6.18-5-alpha-generic|200907161104
4644539|pass|200907|JOST@cpan.org ("Josts Smokehouse")|Test-JSON-Meta|0.01|i86pc-solaris-64int|5.10.0|solaris|2.11|200907161157
4643340|pass|200907|JOST@cpan.org ("Josts Smokehouse")|Test-JSON-Meta|0.01|i86pc-solaris-64int|5.8.9|solaris|2.11|200907160955
4643132|pass|200907|rbo@cpan.org|Regexp-Log-Common|0.05|i86pc-solaris|5.10.0|solaris|2.11|200907160934
4642844|pass|200907|rbo@cpan.org|Test-JSON-Meta|0.01|i86pc-solaris|5.10.0|solaris|2.11|200907160855
4642166|pass|200907|ivan.wills@gmail.com ("Ivan Wills")|Test-JSON-Meta|0.01|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-23-server|200907161514
4641996|pass|200907|cpan.dcollins.5100@gmail.com|Test-YAML-Meta|0.12|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907160021
4641151|pass|200907|cpan.dcollins.589@gmail.com|Test-CPAN-Meta|0.13|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907160008
4641011|unknown|200907|cpan.dcollins.smoker5@gmail.com|Regexp-Log-Common|0.05|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907160005
4639451|pass|200907|cpan.dcollins.smoker2@gmail.com|WWW-UsePerl-Journal|0.22|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907160337
4639197|unknown|200907|cpan.dcollins.smoker4@gmail.com|WWW-Scraper-ISBN-Pearson_Driver|0.10|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907160332
4639185|pass|200907|cpan.dcollins.5100@gmail.com|CPAN-Testers-Data-Release|0.01|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907160332
4639175|pass|200907|cpan.dcollins.5100@gmail.com|App-Maisha|0.12|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907160332
4638324|pass|200907|cpan.dcollins.smoker3@gmail.com|Mail-Outlook|0.15|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907160315
4638128|pass|200907|cpan.dcollins.smoker1@gmail.com|App-Maisha|0.12|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907160310
4637656|pass|200907|cpan.dcollins.5100rc1@gmail.com|CPAN-Testers-Data-Release|0.01|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907160259
4637598|pass|200907|cpan.dcollins.smoker3@gmail.com|Test-YAML-Meta|0.12|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907160258
4637176|pass|200907|cpan.dcollins.smoker9@gmail.com|Mail-Outlook|0.15|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907160247
4636300|pass|200907|cpan.dcollins.589@gmail.com|Regexp-Log-Common|0.05|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907160227
4636135|pass|200907|cpan.dcollins.smoker6@gmail.com|Test-JSON-Meta|0.01|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907160223
4635947|pass|200907|cpan.dcollins.smoker7@gmail.com|Regexp-Log-Common|0.05|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907160218
4635798|pass|200907|cpan.dcollins.smoker4@gmail.com|Test-JSON-Meta|0.01|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907160213
4632851|pass|200907|srezic@cpan.org|Test-JSON-Meta|0.01|amd64-freebsd|5.8.9|freebsd|7.0-release|200907152123
4632807|pass|200907|bob@randomness.org.uk ("bob walker")|Test-JSON-Meta|0.01|i86pc-solaris|5.10.0|solaris|2.10|200907152054
4632560|pass|200907|srezic@cpan.org|Test-JSON-Meta|0.01|amd64-freebsd|5.8.8|freebsd|7.0-release|200907152123
4630963|unknown|200907|cpan.dcollins.smoker2@gmail.com|CPAN-Testers-Data-Generator|0.35|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907151437
4630959|pass|200907|cpan.dcollins.smoker6@gmail.com|CPAN-Testers-WWW-Reports-Parser|0.01|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907151437
4630583|cpan|200907|BARBIE|Test-JSON-Meta|0.01||0|||200907152028
4630224|pass|200907|cpan.dcollins.5100rc1@gmail.com|CPAN-Testers-Data-Generator|0.37|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907151420
4630172|unknown|200907|cpan.dcollins.smoker6@gmail.com|CPAN-Testers-Data-Uploads|0.06|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907151419
4628980|unknown|200907|cpan.dcollins.smoker3@gmail.com|Data-Phrasebook|0.29|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907151350
4628861|pass|200907|cpan.dcollins.5100rc1@gmail.com|WWW-UsePerl-Journal|0.22|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907151347
4628846|pass|200907|cpan.dcollins.smoker2@gmail.com|Test-YAML-Meta|0.12|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907151347
4628217|pass|200907|jeff@zeroclue.com|Test-YAML-Meta|0.12|OpenBSD.i386-openbsd|5.8.9|openbsd|4.4|200907151030
4627063|pass|200907|cpan.dcollins.smoker6@gmail.com|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907151259
4626824|pass|200907|cpan.dcollins.smoker3@gmail.com|CPAN-Testers-Common-Article|0.36|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907151252
4625965|pass|200907|cpan.dcollins.smoker6@gmail.com|CPAN-Testers-WWW-Reports-Mailer|0.17|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907151223
4625718|pass|200907|cpan.dcollins.5100@gmail.com|WWW-UsePerl-Journal|0.22|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907151213
4625640|pass|200907|cpan.dcollins.smoker6@gmail.com|Test-CPAN-Meta|0.13|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907151211
4625562|pass|200907|cpan.dcollins.smoker9@gmail.com|CPAN-Testers-Common-Article|0.36|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907151208
4625260|pass|200907|cpan.dcollins.5100@gmail.com|Test-CPAN-Meta|0.13|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907151200
4624907|pass|200907|martin.evans@easysoft.com|GD-Chart-Radial|0.07|i686-linux|5.10.0|linux|2.6.24-24-generic|200907151650
4624796|pass|200907|cpan.dcollins.5100@gmail.com|Test-YAML-Meta|0.12|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907151147
4624507|pass|200907|brian@minton.name|Test-CPAN-Meta|0.13|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.29.4-dsa-dl380-oldxeon|200907151126
4621697|pass|200907|paul@mystery-land.net|Test-YAML-Meta|0.12|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.30.1-dsa-ia32|200907150950
4618242|pass|200907|cpan.dcollins.smoker9@gmail.com|CPAN-Testers-WWW-Reports-Mailer|0.17|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907150320
4617961|unknown|200907|cpan.dcollins.5100@gmail.com|Parse-CPAN-Distributions|0.05|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907150309
4617690|pass|200907|cpan.dcollins.smoker5@gmail.com|CPAN-Testers-WWW-Reports-Mailer|0.17|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907150258
4617351|pass|200907|cpan.dcollins.smoker8@gmail.com|CPAN-Testers-Common-Article|0.36|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907150246
4617298|unknown|200907|cpan.dcollins.smoker4@gmail.com|CPAN-YACSmoke-Plugin-NNTPWeb|0.06|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907150244
4615167|unknown|200907|cpan.dcollins.smoker8@gmail.com|Calendar-List|0.21|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907150153
4614742|pass|200907|cpan.dcollins.smoker5@gmail.com|CPAN-Testers-WWW-Statistics|0.65|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907150145
4612617|pass|200907|cpan.dcollins.smoker1@gmail.com|CPAN-Testers-Data-Uploads|0.06|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907141850
4612005|unknown|200907|cpan.dcollins.smoker3@gmail.com|Mail-Outlook|0.15|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907141824
4610946|unknown|200907|cpan.dcollins.smoker7@gmail.com|Mail-File|0.08|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907141726
4610682|pass|200907|cpan.dcollins.smoker7@gmail.com|Regexp-Log-Common|0.05|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907141704
4610490|pass|200907|bingos@cpan.org|Test-YAML-Meta|0.12|i86pc-solaris|5.10.0|solaris|2.10|200907142145
4610263|pass|200907|cpan.dcollins.smoker5@gmail.com|App-Maisha|0.12|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907141640
4609584|unknown|200907|cpan.dcollins.smoker2@gmail.com|WWW-Scraper-ISBN-Amazon_Driver|0.14|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907141602
4608233|pass|200907|cpan.dcollins.5100@gmail.com|CPAN-Testers-WWW-Reports-Parser|0.01|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907141511
4608020|pass|200907|cpan.dcollins.smoker9@gmail.com|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907141505
4607915|pass|200907|ivan.wills@gmail.com ("Ivan Wills")|App-Maisha|0.12|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-23-server|200907150503
4607512|pass|200907|cpan.dcollins.589@gmail.com|CPAN-Testers-Data-Release|0.01|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907141452
4607409|pass|200907|cpan.dcollins.smoker5@gmail.com|CPAN-Testers-WWW-Reports-Mailer|0.17|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907141449
4607056|pass|200907|cpan.dcollins.5100@gmail.com|CPAN-Testers-Common-Article|0.36|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907141441
4607011|pass|200907|cpan.dcollins.589@gmail.com|CPAN-Testers-Common-Article|0.36|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907141440
4606996|pass|200907|cpan.dcollins.smoker1@gmail.com|Test-CPAN-Meta|0.13|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907141440
4606715|pass|200907|ivan.wills@gmail.com ("Ivan Wills")|CPAN-Testers-Data-Release|0.01|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-23-server|200907150433
4606706|pass|200907|ivan.wills@gmail.com ("Ivan Wills")|CPAN-Testers-Common-DBUtils|0.03|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-23-server|200907150433
4606490|pass|200907|ivan.wills@gmail.com ("Ivan Wills")|CPAN-Testers-WWW-Reports-Parser|0.01|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-23-server|200907150413
4605401|pass|200907|ivan.wills@gmail.com ("Ivan Wills")|WWW-UsePerl-Journal|0.22|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-23-server|200907150219
4599553|pass|200907|dagolden@cpan.org (DAGOLDEN)|Test-YAML-Meta|0.12|i686-linux|5.10.0|linux|2.6.24-16-generic|200907140232
4599400|pass|200907|bingos@cpan.org|Test-YAML-Meta|0.12|OpenBSD.i386-openbsd|5.10.0|openbsd|4.5|200907140734
4598320|pass|200907|cpan.dcollins.smoker1@gmail.com|CPAN-Testers-Data-Release|0.01|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907140122
4597681|pass|200907|cpan.dcollins.smoker1@gmail.com|WWW-UsePerl-Journal|0.22|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907140109
4597466|pass|200907|cpan.dcollins.smoker1@gmail.com|CPAN-Testers-WWW-Reports-Parser|0.01|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907140058
4597323|pass|200907|cpan.dcollins.smoker7@gmail.com|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907140103
4595599|pass|200907|dagolden@cpan.org (DAGOLDEN)|Data-Phrasebook|0.29|i686-linux|5.10.0|linux|2.6.24-16-generic|200907140321
4592972|pass|200907|cpan.dcollins.smoker2@gmail.com|Regexp-Log-Common|0.05|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907140107
4591587|pass|200907|dagolden@cpan.org (DAGOLDEN)|Test-CPAN-Meta|0.13|i686-linux|5.10.0|linux|2.6.24-16-generic|200907140041
4591489|pass|200907|cpan.dcollins.589@gmail.com|Test-YAML-Meta|0.12|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907140040
4591180|unknown|200907|cpan.dcollins.589@gmail.com|Data-FormValidator-Constraints-Words|0.03|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907140034
4591132|unknown|200907|cpan.dcollins.smoker4@gmail.com|Data-Phrasebook-Loader-DBI|0.11|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907140032
4590478|unknown|200907|cpan.dcollins.589@gmail.com|WWW-UsePerl-Journal|0.22|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907140020
4589586|unknown|200907|cpan.dcollins.smoker4@gmail.com|CPAN-YACSmoke-Plugin-Outlook|0.06|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907140005
4589061|unknown|200907|cpan.dcollins.smoker9@gmail.com|Finance-Currency-Convert-XE|0.15|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907131955
4586905|pass|200907|cpan.dcollins.589@gmail.com|Test-YAML-Meta|0.12|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907131913
4585439|unknown|200907|cpan.dcollins.smoker4@gmail.com|CPAN-YACSmoke-Plugin-WebList|0.05|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907131836
4585399|unknown|200907|cpan.dcollins.smoker4@gmail.com|CPAN-WWW-Testers-Generator|0.30|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907131835
4584237|pass|200907|dagolden@cpan.org (DAGOLDEN)|Data-Phrasebook|0.29|i686-linux|5.10.0|linux|2.6.24-16-generic|200907131633
4584113|pass|200907|dagolden@cpan.org (DAGOLDEN)|Test-CPAN-Meta|0.13|i686-linux|5.10.0|linux|2.6.24-16-generic|200907131623
4581015|pass|200907|dagolden@cpan.org (DAGOLDEN)|Test-YAML-Meta|0.12|i686-linux|5.10.0|linux|2.6.24-16-generic|200907131242
4580545|pass|200907|bingos@cpan.org|Test-YAML-Meta|0.12|i86pc-solaris-thread-multi-64int|5.8.9|solaris|2.10|200907131659
4577843|pass|200907|artur+cpan@niif.spb.su (ARTO)|Test-YAML-Meta|0.12|i386-linux-thread-multi|5.10.0|linux|2.6.18-128.1.6.el5xen|200907131508
4576334|pass|200907|rlane10@wi.rr.com|Test-YAML-Meta|0.12|darwin-2level-ld|5.10.0|darwin|8.11.0|200907130247
4575414|pass|200907|ivan.wills@gmail.com ("Ivan Wills")|Mail-Outlook|0.15|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-23-server|200907131903
4573772|unknown|200907|cpan.dcollins.smoker4@gmail.com|CPAN-Testers-WWW-Statistics|0.55|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907130357
4573626|pass|200907|cpan.dcollins.smoker9@gmail.com|Mail-Outlook|0.15|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907130345
4573555|pass|200907|cpan.dcollins.smoker4@gmail.com|App-Maisha|0.12|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907130340
4573192|unknown|200907|cpan.dcollins.smoker1@gmail.com|App-Maisha-Plugin-PingFM|0.02|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907130321
4571869|unknown|200907|cpan.dcollins.smoker7@gmail.com|CPAN-Testers-Common-Article|0.36|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907130233
4571653|pass|200907|cpan.dcollins.smoker2@gmail.com|App-Maisha-Plugin-PingFM|0.02|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907130225
4571649|unknown|200907|cpan.dcollins.smoker5@gmail.com|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907130225
4570787|pass|200907|ivan.wills@gmail.com ("Ivan Wills")|Test-YAML-Meta|0.12|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-23-server|200907131156
4570760|pass|200907|ivan.wills@gmail.com ("Ivan Wills")|Test-CPAN-Meta|0.13|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-23-server|200907131155
4569062|pass|200907|ivan.wills@gmail.com ("Ivan Wills")|Regexp-Log-Common|0.05|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-23-server|200907130804
4568323|pass|200907|ivan.wills@gmail.com ("Ivan Wills")|CPAN-Testers-WWW-Reports-Mailer|0.17|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-23-server|200907130556
4568310|pass|200907|ivan.wills@gmail.com ("Ivan Wills")|CPAN-Testers-WWW-Statistics|0.65|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-23-server|200907130554
4568064|pass|200907|ivan.wills@gmail.com ("Ivan Wills")|CPAN-Testers-Data-Generator|0.37|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-23-server|200907130513
4568061|pass|200907|ivan.wills@gmail.com ("Ivan Wills")|CPAN-Testers-Common-Article|0.36|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-23-server|200907130513
4564442|pass|200907|cpan.dcollins.smoker5@gmail.com|CPAN-Testers-Data-Release|0.01|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907120147
4564175|pass|200907|cpan.dcollins.smoker5@gmail.com|CPAN-Testers-WWW-Reports-Mailer|0.17|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907120141
4563902|pass|200907|cpan.dcollins.smoker3@gmail.com|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907120133
4563758|pass|200907|cpan.dcollins.smoker8@gmail.com|CPAN-Testers-Data-Generator|0.37|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907120129
4563756|pass|200907|cpan.dcollins.smoker4@gmail.com|CPAN-Testers-WWW-Statistics|0.65|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907120129
4563551|pass|200907|cpan.dcollins.smoker1@gmail.com|CPAN-Testers-Data-Release|0.01|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907120123
4563540|pass|200907|cpan.dcollins.smoker1@gmail.com|CPAN-Testers-Data-Release|0.01|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907120123
4563445|pass|200907|cpan.dcollins.589@gmail.com|CPAN-Testers-WWW-Reports-Parser|0.01|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907120120
4563442|pass|200907|cpan.dcollins.smoker5@gmail.com|WWW-UsePerl-Journal|0.22|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907120120
4563119|pass|200907|cpan.dcollins.smoker3@gmail.com|CPAN-Testers-Data-Release|0.01|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907120110
4562836|pass|200907|cpan.dcollins.589@gmail.com|Test-CPAN-Meta|0.13|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907120102
4562797|pass|200907|cpan.dcollins.smoker3@gmail.com|CPAN-Testers-Common-Article|0.36|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907120101
4562686|pass|200907|cpan.dcollins.smoker1@gmail.com|CPAN-Testers-Data-Release|0.01|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907120058
4562457|pass|200907|cpan.dcollins.smoker6@gmail.com|CPAN-Testers-WWW-Statistics|0.65|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907120051
4562445|pass|200907|cpan.dcollins.smoker2@gmail.com|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907120051
4562219|pass|200907|cpan.dcollins.smoker3@gmail.com|CPAN-Testers-WWW-Reports-Mailer|0.17|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907120045
4561923|pass|200907|cpan.dcollins.smoker2@gmail.com|CPAN-Testers-Common-Article|0.36|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907120036
4561415|pass|200907|cpan.dcollins.smoker1@gmail.com|CPAN-Testers-Data-Generator|0.37|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907120024
4561229|pass|200907|bob@randomness.org.uk ("bob walker")|Test-YAML-Meta|0.12|i86pc-solaris|5.10.0|solaris|2.10|200907120117
4561084|pass|200907|cpan.dcollins.589@gmail.com|CPAN-Testers-Common-Article|0.36|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907120014
4560862|pass|200907|cpan.dcollins.smoker7@gmail.com|CPAN-Testers-WWW-Reports-Parser|0.01|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907120008
4560756|pass|200907|cpan.dcollins.589@gmail.com|WWW-UsePerl-Journal|0.22|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907120005
4560746|pass|200907|cpan.dcollins.smoker7@gmail.com|CPAN-Testers-Data-Generator|0.37|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907120005
4560633|pass|200907|cpan.dcollins.smoker4@gmail.com|Test-CPAN-Meta|0.13|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907120002
4560549|pass|200907|cpan.dcollins.589@gmail.com|CPAN-Testers-WWW-Reports-Mailer|0.17|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907120000
4560432|pass|200907|cpan.dcollins.smoker5@gmail.com|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907111957
4559999|pass|200907|cpan.dcollins.smoker4@gmail.com|CPAN-Testers-Data-Generator|0.37|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907111950
4559717|pass|200907|cpan.dcollins.5100@gmail.com|Test-CPAN-Meta|0.13|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907111944
4559659|pass|200907|cpan.dcollins.smoker1@gmail.com|CPAN-Testers-WWW-Reports-Parser|0.01|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907111943
4559457|pass|200907|cpan.dcollins.smoker2@gmail.com|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907111940
4559268|pass|200907|cpan.dcollins.5100rc1@gmail.com|Test-CPAN-Meta|0.13|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907111935
4559202|pass|200907|cpan.dcollins.smoker2@gmail.com|CPAN-Testers-Data-Generator|0.37|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907111933
4559183|pass|200907|cpan.dcollins.5100rc1@gmail.com|WWW-UsePerl-Journal|0.22|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907111933
4558952|pass|200907|cpan.dcollins.smoker8@gmail.com|CPAN-Testers-Common-Article|0.36|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907111929
4558903|fail|200907|cpan.dcollins.smoker2@gmail.com|WWW-UsePerl-Journal|0.22|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907111928
4558894|pass|200907|cpan.dcollins.smoker1@gmail.com|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907111928
4558734|pass|200907|cpan.dcollins.smoker9@gmail.com|Test-CPAN-Meta|0.13|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907111925
4558675|pass|200907|cpan.dcollins.5100rc1@gmail.com|CPAN-Testers-WWW-Reports-Mailer|0.17|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907111924
4558674|pass|200907|cpan.dcollins.smoker5@gmail.com|CPAN-Testers-WWW-Reports-Parser|0.01|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907111924
4558191|fail|200907|cpan.dcollins.5100@gmail.com|WWW-UsePerl-Journal|0.22|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907111913
4558185|pass|200907|cpan.dcollins.smoker9@gmail.com|CPAN-Testers-WWW-Reports-Parser|0.01|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907111913
4557581|pass|200907|bingos@cpan.org|Test-YAML-Meta|0.12|OpenBSD.i386-openbsd-thread-multi-64int|5.8.9|openbsd|4.5|200907112330
4557487|pass|200907|alexchorny@gmail.com|Test-YAML-Meta|0.12|i686-linux|5.8.8|linux|2.4.20-8smp|200907111420
4552834|pass|200907|bingos@cpan.org|Test-YAML-Meta|0.12|i86pc-solaris-thread-multi-64int|5.8.8|solaris|2.10|200907110425
4552543|pass|200907|ivan.wills@gmail.com ("Ivan Wills")|Test-YAML-Meta|0.12|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-23-server|200907111822
4552538|pass|200907|ivan.wills@gmail.com ("Ivan Wills")|Test-CPAN-Meta|0.13|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-23-server|200907111821
4550682|pass|200907|cpan.dcollins.589@gmail.com|Test-YAML-Meta|0.12|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907110138
4550681|pass|200907|cpan.dcollins.589@gmail.com|Test-YAML-Meta|0.12|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907110138
4549731|pass|200907|cpan.dcollins.smoker9@gmail.com|Test-YAML-Meta|0.12|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907110118
4548529|pass|200907|cpan.dcollins.smoker5@gmail.com|Test-YAML-Meta|0.12|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907110055
4548070|pass|200907|cpan.dcollins.smoker9@gmail.com|Test-YAML-Meta|0.12|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907110044
4546828|pass|200907|cpan.dcollins.smoker1@gmail.com|Test-YAML-Meta|0.12|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907110006
4546533|pass|200907|ivan.wills@gmail.com ("Ivan Wills")|CPAN-Testers-WWW-Reports-Mailer|0.17|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-23-server|200907111249
4546528|pass|200907|ivan.wills@gmail.com ("Ivan Wills")|CPAN-Testers-WWW-Statistics|0.65|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-23-server|200907111247
4546418|pass|200907|ivan.wills@gmail.com ("Ivan Wills")|CPAN-Testers-Data-Generator|0.37|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-23-server|200907111227
4546415|pass|200907|ivan.wills@gmail.com ("Ivan Wills")|CPAN-Testers-Common-Article|0.36|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-23-server|200907111226
4546377|pass|200907|ivan.wills@gmail.com ("Ivan Wills")|CPAN-Testers-Data-Release|0.01|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-23-server|200907111221
4546376|pass|200907|ivan.wills@gmail.com ("Ivan Wills")|CPAN-Testers-Common-DBUtils|0.03|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-23-server|200907111221
4546285|pass|200907|ivan.wills@gmail.com ("Ivan Wills")|CPAN-Testers-WWW-Reports-Parser|0.01|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-23-server|200907111202
4545909|pass|200907|ivan.wills@gmail.com ("Ivan Wills")|WWW-UsePerl-Journal|0.22|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-23-server|200907110959
4544511|pass|200907|bingos@cpan.org|Test-YAML-Meta|0.12|i86pc-solaris-thread-multi-64int|5.8.4|solaris|2.10|200907102025
4543322|pass|200907|cpan.dcollins.smoker2@gmail.com|Mail-File|0.08|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907101429
4543257|pass|200907|cpan.dcollins.589@gmail.com|Data-Phrasebook-Loader-DBI|0.11|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907101427
4543212|pass|200907|cpan.dcollins.smoker2@gmail.com|Data-Phrasebook-Loader-Ini|0.10|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907101426
4542992|fail|200907|cpan.dcollins.smoker1@gmail.com|CPAN-YACSmoke-Plugin-WebList|0.05|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907101421
4542817|pass|200907|cpan.dcollins.smoker4@gmail.com|Data-Phrasebook-Loader-XML|0.12|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907101417
4542614|pass|200907|cpan.dcollins.smoker1@gmail.com|CPAN-YACSmoke-Plugin-NNTPWeb|0.06|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907101411
4542505|pass|200907|cpan.dcollins.smoker4@gmail.com|CPAN-YACSmoke-Plugin-Outlook|0.06|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907101407
4536496|pass|200907|martin.evans@easysoft.com|Data-FormValidator-Constraints-Words|0.03|i686-linux|5.10.0|linux|2.6.24-24-generic|200907101310
4529474|pass|200907|cpan.dcollins.smoker8@gmail.com|CPAN-YACSmoke-Plugin-Outlook|0.06|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907100027
4528637|pass|200907|cpan.dcollins.smoker1@gmail.com|Data-Phrasebook-Loader-Ini|0.10|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907100011
4527364|pass|200907|cpan.dcollins.smoker1@gmail.com|Data-Phrasebook-Loader-DBI|0.11|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907091947
4527022|pass|200907|cpan.dcollins.smoker4@gmail.com|Mail-File|0.08|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907091937
4526811|pass|200907|cpan.dcollins.smoker1@gmail.com|Data-Phrasebook-Loader-XML|0.12|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907091933
4526171|pass|200907|cpan.dcollins.smoker9@gmail.com|GD-Chart-Radial|0.07|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907091921
4521156|fail|200907|cpan.dcollins.smoker3@gmail.com|WWW-Scraper-ISBN-Pearson_Driver|0.10|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907091105
4520988|pass|200907|cpan.dcollins.smoker1@gmail.com|Data-Phrasebook-Loader-DBI|0.11|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907091059
4519735|pass|200907|cpan.dcollins.smoker6@gmail.com|Data-Phrasebook-Loader-Ini|0.10|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907091019
4519561|pass|200907|cpan.dcollins.smoker1@gmail.com|Data-Phrasebook-Loader-XML|0.12|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907091015
4519232|pass|200907|cpan.dcollins.5100rc1@gmail.com|GD-Chart-Radial|0.07|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907091007
4518807|pass|200907|stro@cpan.org|Regexp-Log-Common|0.05|armv5tejl-linux|5.10.0|linux|2.6.17.14|200907091658
4518305|pass|200907|cpan.dcollins.smoker9@gmail.com|Mail-File|0.08|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907090945
4516058|pass|200907|cpan.dcollins.smoker8@gmail.com|Finance-Currency-Convert-XE|0.15|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907090846
4515129|pass|200907|cpan.dcollins.smoker7@gmail.com|Data-FormValidator-Constraints-Words|0.03|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907090824
4510939|pass|200907|bingos@cpan.org|Regexp-Log-Common|0.05|darwin-thread-multi-64int-2level|5.11.0 patch GitLive-blead-1530-g9ef4351|darwin|8.11.0|200907090213
4510289|pass|200907|bingos@cpan.org|Parse-CPAN-Distributions|0.05|darwin-thread-multi-64int-2level|5.11.0 patch GitLive-blead-1530-g9ef4351|darwin|8.11.0|200907090000
4509825|pass|200907|bingos@cpan.org|Mail-File|0.08|darwin-thread-multi-64int-2level|5.11.0 patch GitLive-blead-1530-g9ef4351|darwin|8.11.0|200907082217
4509359|pass|200907|bingos@cpan.org|GD-Chart-Radial|0.07|darwin-thread-multi-64int-2level|5.11.0 patch GitLive-blead-1530-g9ef4351|darwin|8.11.0|200907082106
4509356|pass|200907|bingos@cpan.org|Games-Trackword|1.06|darwin-thread-multi-64int-2level|5.11.0 patch GitLive-blead-1530-g9ef4351|darwin|8.11.0|200907082105
4508683|fail|200907|cpan.dcollins.5100rc1@gmail.com|WWW-Scraper-ISBN-ORA_Driver|0.09|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907081534
4508155|pass|200907|bingos@cpan.org|Test-YAML-Meta|0.12|i86pc-solaris-thread-multi-64int|5.10.0|solaris|2.10|200907082018
4507310|fail|200907|cpan.dcollins.smoker6@gmail.com|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907081324
4505671|pass|200907|cpan.dcollins.smoker6@gmail.com|GD-Chart-Radial|0.07|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907081241
4503070|fail|200907|cpan.dcollins.5100rc1@gmail.com|WWW-Scraper-ISBN-Amazon_Driver|0.14|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907081132
4502958|pass|200907|cpan.dcollins.smoker6@gmail.com|Parse-CPAN-Distributions|0.05|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907081129
4502877|pass|200907|cpan.dcollins.smoker7@gmail.com|WWW-UsePerl-Journal-Thread|0.12|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907081128
4502365|pass|200907|cpan.dcollins.smoker2@gmail.com|Parse-CPAN-Distributions|0.05|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907081112
4502059|pass|200907|cpan.dcollins.smoker7@gmail.com|Data-FormValidator-Constraints-Words|0.03|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907081105
4501996|pass|200907|cpan.dcollins.smoker1@gmail.com|GD-Chart-Radial|0.07|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907081103
4501948|pass|200907|cpan.dcollins.5100@gmail.com|CPAN-YACSmoke-Plugin-Outlook|0.06|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907081102
4501600|pass|200907|cpan.dcollins.smoker9@gmail.com|Finance-Currency-Convert-XE|0.15|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907081056
4501575|pass|200907|cpan.dcollins.smoker1@gmail.com|CPAN-WWW-Testers-Generator|0.30|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907081055
4501438|pass|200907|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|darwin-thread-multi-64int-2level|5.11.0 patch GitLive-blead-1530-g9ef4351|darwin|8.11.0|200907081554
4501395|pass|200907|bingos@cpan.org|Data-Phrasebook-Loader-XML|0.12|darwin-thread-multi-64int-2level|5.11.0 patch GitLive-blead-1530-g9ef4351|darwin|8.11.0|200907081553
4501377|pass|200907|bingos@cpan.org|Data-Phrasebook-Loader-Ini|0.10|darwin-thread-multi-64int-2level|5.11.0 patch GitLive-blead-1530-g9ef4351|darwin|8.11.0|200907081553
4501361|pass|200907|bingos@cpan.org|Data-Phrasebook-Loader-DBI|0.11|darwin-thread-multi-64int-2level|5.11.0 patch GitLive-blead-1530-g9ef4351|darwin|8.11.0|200907081552
4501329|pass|200907|bingos@cpan.org|Data-Phrasebook|0.29|darwin-thread-multi-64int-2level|5.11.0 patch GitLive-blead-1530-g9ef4351|darwin|8.11.0|200907081551
4501246|pass|200907|bingos@cpan.org|Data-FormValidator-Constraints-Words|0.03|darwin-thread-multi-64int-2level|5.11.0 patch GitLive-blead-1530-g9ef4351|darwin|8.11.0|200907081548
4501097|pass|200907|bingos@cpan.org|CPAN-WWW-Testers-Generator|0.30|darwin-thread-multi-64int-2level|5.11.0 patch GitLive-blead-1530-g9ef4351|darwin|8.11.0|200907081526
4501081|pass|200907|bingos@cpan.org|CPAN-Testers-WWW-Reports-Parser|0.01|darwin-thread-multi-64int-2level|5.11.0 patch GitLive-blead-1530-g9ef4351|darwin|8.11.0|200907081523
4501068|pass|200907|bingos@cpan.org|CPAN-Testers-Data-Release|0.01|darwin-thread-multi-64int-2level|5.11.0 patch GitLive-blead-1530-g9ef4351|darwin|8.11.0|200907081521
4501045|pass|200907|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|darwin-thread-multi-64int-2level|5.11.0 patch GitLive-blead-1530-g9ef4351|darwin|8.11.0|200907081518
4501042|pass|200907|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|darwin-thread-multi-64int-2level|5.11.0 patch GitLive-blead-1530-g9ef4351|darwin|8.11.0|200907081518
4500723|pass|200907|bingos@cpan.org|Calendar-List|0.21|darwin-thread-multi-64int-2level|5.11.0 patch GitLive-blead-1530-g9ef4351|darwin|8.11.0|200907081430
4496380|pass|200907|bingos@cpan.org|Test-CPAN-Meta|0.13|darwin-thread-multi-64int-2level|5.11.0 patch GitLive-blead-1530-g9ef4351|darwin|8.11.0|200907080459
4495796|pass|200907|bingos@cpan.org|Test-YAML-Meta|0.12|darwin-thread-multi-64int-2level|5.11.0 patch GitLive-blead-1530-g9ef4351|darwin|8.11.0|200907072351
4494665|pass|200907|cpan.dcollins.smoker8@gmail.com|Games-Trackword|1.06|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907071321
4494659|pass|200907|cpan.dcollins.smoker5@gmail.com|Calendar-List|0.21|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907071320
4494612|fail|200907|cpan.dcollins.smoker6@gmail.com|WWW-Scraper-ISBN-Pearson_Driver|0.10|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907071319
4494556|fail|200907|cpan.dcollins.smoker2@gmail.com|WWW-Scraper-ISBN-ORA_Driver|0.09|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907071318
4493643|fail|200907|cpan.dcollins.smoker7@gmail.com|WWW-Scraper-ISBN-Amazon_Driver|0.14|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907071247
4493618|pass|200907|cpan.dcollins.smoker2@gmail.com|Calendar-List|0.21|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907071246
4492509|pass|200907|cpan.dcollins.smoker5@gmail.com|CPAN-WWW-Testers-Generator|0.30|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907071219
4492471|pass|200907|cpan.dcollins.589@gmail.com|Data-FormValidator-Constraints-Words|0.03|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907071219
4491482|pass|200907|cpan.dcollins.smoker2@gmail.com|Finance-Currency-Convert-XE|0.15|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907071156
4490876|fail|200907|cpan.dcollins.5100@gmail.com|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907071138
4490384|pass|200907|cpan.dcollins.smoker1@gmail.com|WWW-UsePerl-Journal-Thread|0.12|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907071122
4490164|pass|200907|cpan.dcollins.smoker6@gmail.com|Data-FormValidator-Constraints-Words|0.03|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907071114
4489982|pass|200907|cpan.dcollins.smoker6@gmail.com|Games-Trackword|1.06|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907071108
4489939|pass|200907|cpan.dcollins.smoker3@gmail.com|Games-Trackword|1.06|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907071107
4489838|pass|200907|cpan.dcollins.smoker3@gmail.com|Finance-Currency-Convert-XE|0.15|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907071102
4489833|pass|200907|cpan.dcollins.smoker3@gmail.com|Finance-Currency-Convert-XE|0.15|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907071102
4489740|pass|200907|cpan.dcollins.5100rc1@gmail.com|Calendar-List|0.21|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907071058
4489418|pass|200907|martin.evans@easysoft.com|Games-Trackword|1.06|i686-linux|5.10.0|linux|2.6.24-24-generic|200907071541
4489412|pass|200907|martin.evans@easysoft.com|Calendar-List|0.21|i686-linux|5.10.0|linux|2.6.24-24-generic|200907071541
4488086|pass|200907|bingos@cpan.org|Test-YAML-Meta|0.12|i386-netbsd-64int|5.10.0 patch GitLive-maint-5.10-1501-gba4fcaa|netbsd|5.0|200907071252
4481321|pass|200907|cpan.dcollins.smoker7@gmail.com|Data-Phrasebook|0.29|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907061907
4481275|pass|200907|cpan.dcollins.smoker7@gmail.com|Data-Phrasebook|0.29|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907061906
4481267|pass|200907|cpan.dcollins.589@gmail.com|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907061905
4481026|pass|200907|cpan.dcollins.smoker4@gmail.com|CPAN-Testers-Data-Generator|0.35|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907061858
4480270|pass|200907|stro@cpan.org|CPAN-Testers-Data-Release|0.01|armv5tejl-linux|5.10.0|linux|2.6.17.14|200907070133
4480192|pass|200907|cpan.dcollins.smoker9@gmail.com|CPAN-Testers-WWW-Statistics|0.55|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907061829
4479988|fail|200907|cpan.dcollins.5100@gmail.com|WWW-Scraper-ISBN-Pearson_Driver|0.10|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907061822
4479512|pass|200907|stro@cpan.org|CPAN-WWW-Testers|0.41|MSWin32-x86-multi-thread|5.8.8|MSWin32|4.0|200907070110
4479482|pass|200907|stro@cpan.org|CPAN-WWW-Testers|0.40|MSWin32-x86-multi-thread|5.8.8|MSWin32|4.0|200907070109
4479458|pass|200907|stro@cpan.org|CPAN-WWW-Testers|0.39|MSWin32-x86-multi-thread|5.8.8|MSWin32|4.0|200907070109
4479344|pass|200907|stro@cpan.org|CPAN-Testers-WWW-Reports-Parser|0.01|MSWin32-x86-multi-thread|5.8.8|MSWin32|4.0|200907070106
4479215|pass|200907|stro@cpan.org|CPAN-Testers-Data-Release|0.01|MSWin32-x86-multi-thread|5.8.8|MSWin32|4.0|200907070103
4479198|pass|200907|stro@cpan.org|CPAN-Testers-Data-Generator|0.37|MSWin32-x86-multi-thread|5.8.8|MSWin32|4.0|200907070102
4479182|pass|200907|cpan.dcollins.5100rc1@gmail.com|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907061802
4479161|pass|200907|cpan.dcollins.smoker7@gmail.com|CPAN-Testers-WWW-Statistics|0.55|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907061801
4478920|fail|200907|cpan.dcollins.smoker7@gmail.com|WWW-Scraper-ISBN-ORA_Driver|0.09|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907061756
4476450|pass|200907|bingos@cpan.org|Test-YAML-Meta|0.12|OpenBSD.i386-openbsd-thread-multi-64int|5.8.9|openbsd|4.4|200907061626
4476356|pass|200907|stro@cpan.org|CPAN-Testers-WWW-Reports-Parser|0.01|armv5tejl-linux|5.10.0|linux|2.6.17.14|200907062033
4475734|pass|200907|cpan.dcollins.smoker1@gmail.com|WWW-UsePerl-Journal-Thread|0.12|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907061310
4475032|fail|200907|cpan.dcollins.589@gmail.com|WWW-Scraper-ISBN-ORA_Driver|0.09|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907061252
4474842|fail|200907|cpan.dcollins.smoker3@gmail.com|WWW-Scraper-ISBN-Pearson_Driver|0.10|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907061247
4474533|pass|200907|cpan.dcollins.smoker7@gmail.com|CPAN-Testers-Data-Uploads|0.06|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907061239
4474504|pass|200907|cpan.dcollins.smoker2@gmail.com|App-Maisha|0.12|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907061238
4474472|pass|200907|cpan.dcollins.smoker2@gmail.com|CPAN-Testers-Data-Generator|0.35|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907061238
4473985|pass|200907|cpan.dcollins.smoker6@gmail.com|CPAN-WWW-Testers-Generator|0.30|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907061226
4473963|pass|200907|cpan.dcollins.smoker2@gmail.com|CPAN-Testers-Data-Uploads|0.06|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907061225
4473832|pass|200907|cpan.dcollins.smoker4@gmail.com|App-Maisha-Plugin-PingFM|0.02|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907061221
4473655|pass|200907|cpan.dcollins.smoker5@gmail.com|Mail-Outlook|0.15|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907061217
4472851|pass|200907|cpan.dcollins.smoker1@gmail.com|Parse-CPAN-Distributions|0.05|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907061157
4471558|pass|200907|cpan.dcollins.smoker4@gmail.com|App-Maisha-Plugin-PingFM|0.02|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907061129
4471179|pass|200907|cpan.dcollins.smoker2@gmail.com|App-Maisha|0.12|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907061121
4470325|pass|200907|cpan.dcollins.smoker5@gmail.com|Games-Trackword|1.06|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907061101
4469889|pass|200907|cpan.dcollins.5100@gmail.com|Mail-Outlook|0.15|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907061049
4469600|pass|200907|cpan.dcollins.smoker3@gmail.com|Calendar-List|0.21|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907061042
4463152|fail|200907|cpan.dcollins.589@gmail.com|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907060122
4462467|pass|200907|cpan.dcollins.5100rc1@gmail.com|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907060110
4462429|fail|200907|cpan.dcollins.smoker9@gmail.com|WWW-Scraper-ISBN-Amazon_Driver|0.14|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907060109
4462145|pass|200907|cpan.dcollins.smoker3@gmail.com|Regexp-Log-Common|0.05|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907060103
4462068|pass|200907|cpan.dcollins.smoker6@gmail.com|CPAN-WWW-Testers-Generator|0.30|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907060101
4461298|fail|200907|cpan.dcollins.smoker7@gmail.com|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907060047
4461270|fail|200907|cpan.dcollins.smoker8@gmail.com|WWW-Scraper-ISBN-Amazon_Driver|0.14|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907060046
4461259|pass|200907|cpan.dcollins.589@gmail.com|WWW-UsePerl-Journal-Thread|0.12|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907060046
4460925|pass|200907|cpan.dcollins.589@gmail.com|Data-Phrasebook|0.29|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907060037
4460729|pass|200907|cpan.dcollins.smoker6@gmail.com|Regexp-Log-Common|0.05|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907060033
4459461|pass|200907|cpan.dcollins.smoker7@gmail.com|CPAN-Testers-WWW-Statistics|0.55|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907060007
4459272|pass|200907|cpan.dcollins.smoker8@gmail.com|Parse-CPAN-Distributions|0.05|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907060003
4457184|pass|200907|bingos@cpan.org|Test-YAML-Meta|0.12|i386-netbsd-thread-multi-64int|5.11.0|netbsd|5.0|200907052008
4455642|pass|200907|cpan.dcollins.smoker2@gmail.com|CPAN-Testers-WWW-Statistics|0.55|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907050944
4455402|pass|200907|cpan.dcollins.589@gmail.com|CPAN-Testers-WWW-Reports-Mailer|0.17|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907050947
4455327|pass|200907|cpan.dcollins.smoker2@gmail.com|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907050946
4454885|pass|200907|cpan.dcollins.smoker1@gmail.com|CPAN-Testers-WWW-Statistics|0.65|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907050938
4454201|pass|200907|cpan.dcollins.smoker5@gmail.com|CPAN-Testers-Data-Release|0.01|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907050927
4454077|pass|200907|cpan.dcollins.5100@gmail.com|CPAN-Testers-Data-Generator|0.37|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907050925
4454032|pass|200907|cpan.dcollins.589@gmail.com|CPAN-Testers-Data-Uploads|0.06|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907050924
4453727|pass|200907|cpan.dcollins.smoker1@gmail.com|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907050918
4453505|pass|200907|cpan.dcollins.smoker8@gmail.com|CPAN-Testers-Common-Article|0.36|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907050914
4453458|pass|200907|cpan.dcollins.smoker4@gmail.com|App-Maisha-Plugin-PingFM|0.02|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907050913
4452927|pass|200907|cpan.dcollins.smoker6@gmail.com|CPAN-Testers-WWW-Reports-Parser|0.01|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907050905
4452552|pass|200907|cpan.dcollins.smoker5@gmail.com|CPAN-Testers-WWW-Reports-Parser|0.01|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907050859
4452525|pass|200907|cpan.dcollins.589@gmail.com|Test-YAML-Meta|0.12|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907050858
4452471|pass|200907|cpan.dcollins.5100@gmail.com|App-Maisha|0.12|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907050857
4452369|pass|200907|cpan.dcollins.smoker5@gmail.com|Mail-Outlook|0.15|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907050855
4452133|pass|200907|cpan.dcollins.5100rc1@gmail.com|CPAN-Testers-WWW-Reports-Mailer|0.17|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907050851
4452089|pass|200907|cpan.dcollins.smoker1@gmail.com|Test-CPAN-Meta|0.13|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907050850
4451892|pass|200907|cpan.dcollins.smoker6@gmail.com|CPAN-Testers-Common-Article|0.36|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907050847
4451818|pass|200907|cpan.dcollins.smoker2@gmail.com|CPAN-Testers-WWW-Statistics|0.65|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907050846
4451671|pass|200907|cpan.dcollins.smoker7@gmail.com|WWW-UsePerl-Journal|0.22|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907050844
4451659|pass|200907|cpan.dcollins.5100rc1@gmail.com|WWW-UsePerl-Journal|0.22|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907050843
4451504|pass|200907|cpan.dcollins.smoker8@gmail.com|Test-CPAN-Meta|0.13|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907050841
4451209|pass|200907|cpan.dcollins.smoker2@gmail.com|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907050837
4451045|pass|200907|cpan.dcollins.smoker5@gmail.com|CPAN-Testers-Data-Generator|0.37|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907050834
4450945|pass|200907|cpan.dcollins.smoker1@gmail.com|CPAN-Testers-Data-Generator|0.35|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907050832
4450804|pass|200907|cpan.dcollins.smoker8@gmail.com|Data-Phrasebook|0.29|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907050830
4450788|pass|200907|cpan.dcollins.smoker3@gmail.com|CPAN-Testers-Data-Generator|0.35|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907050829
4450761|pass|200907|cpan.dcollins.smoker6@gmail.com|Test-YAML-Meta|0.12|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907050829
4450535|pass|200907|cpan.dcollins.smoker5@gmail.com|CPAN-Testers-Data-Release|0.01|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907050824
4445851|pass|200907|cpan.dcollins.smoker5@gmail.com|Test-CPAN-Meta|0.13|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907041800
4445053|pass|200907|cpan.dcollins.smoker1@gmail.com|Mail-Outlook|0.15|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907041739
4444771|pass|200907|cpan.dcollins.smoker2@gmail.com|WWW-UsePerl-Journal|0.22|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907041746
4444734|pass|200907|cpan.dcollins.smoker3@gmail.com|CPAN-Testers-Data-Generator|0.37|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907041746
4444040|pass|200907|cpan.dcollins.smoker6@gmail.com|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907041733
4443918|pass|200907|cpan.dcollins.smoker1@gmail.com|Calendar-List|0.21|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907041730
4443341|pass|200907|cpan.dcollins.smoker8@gmail.com|App-Maisha|0.12|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907041718
4442641|pass|200907|cpan.dcollins.smoker6@gmail.com|CPAN-Testers-WWW-Statistics|0.65|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907041706
4442500|pass|200907|cpan.dcollins.smoker5@gmail.com|CPAN-Testers-Data-Generator|0.37|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907041703
4442232|pass|200907|cpan.dcollins.smoker4@gmail.com|Data-Phrasebook-Loader-XML|0.12|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907041658
4441745|pass|200907|cpan.dcollins.smoker9@gmail.com|CPAN-Testers-WWW-Statistics|0.65|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907041649
4440034|pass|200907|cpan.dcollins.smoker5@gmail.com|App-Maisha-Plugin-PingFM|0.02|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907041616
4439845|pass|200907|cpan.dcollins.smoker9@gmail.com|CPAN-Testers-Data-Uploads|0.06|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907041611
4439592|pass|200907|cpan.dcollins.smoker4@gmail.com|Regexp-Log-Common|0.05|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907041606
4437862|pass|200907|cpan.dcollins.smoker4@gmail.com|Test-YAML-Meta|0.12|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907041158
4437626|pass|200907|cpan.dcollins.smoker2@gmail.com|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907041152
4437558|pass|200907|cpan.dcollins.smoker1@gmail.com|CPAN-Testers-WWW-Reports-Mailer|0.17|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907041151
4437548|pass|200907|cpan.dcollins.smoker2@gmail.com|CPAN-YACSmoke-Plugin-NNTP|0.05|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907041151
4437214|pass|200907|cpan.dcollins.smoker8@gmail.com|Mail-File|0.08|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907041145
4437200|pass|200907|bingos@cpan.org|Test-YAML-Meta|0.12|OpenBSD.i386-openbsd-thread-multi-64int|5.8.8|openbsd|4.4|200907041644
4436762|pass|200907|cpan.dcollins.smoker8@gmail.com|CPAN-Testers-Data-Uploads|0.06|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907041137
4436693|pass|200907|cpan.dcollins.smoker6@gmail.com|Regexp-Log-Common|0.05|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907041136
4436689|pass|200907|cpan.dcollins.smoker7@gmail.com|WWW-UsePerl-Journal|0.22|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907041136
4436425|pass|200907|cpan.dcollins.5100@gmail.com|Data-Phrasebook-Loader-Ini|0.10|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907041131
4436151|pass|200907|cpan.dcollins.5100rc1@gmail.com|Test-CPAN-Meta|0.13|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907041126
4435557|pass|200907|cpan.dcollins.smoker5@gmail.com|CPAN-YACSmoke-Plugin-NNTPWeb|0.06|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907041115
4435462|pass|200907|cpan.dcollins.smoker5@gmail.com|CPAN-Testers-Common-Article|0.36|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907041114
4435241|pass|200907|cpan.dcollins.smoker6@gmail.com|CPAN-Testers-Data-Release|0.01|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907041110
4435042|pass|200907|cpan.dcollins.smoker3@gmail.com|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907041104
4434404|pass|200907|cpan.dcollins.smoker7@gmail.com|App-Maisha-Plugin-PingFM|0.02|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907041047
4433966|pass|200907|cpan.dcollins.smoker5@gmail.com|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907041036
4433900|pass|200907|cpan.dcollins.5100@gmail.com|Data-Phrasebook-Loader-DBI|0.11|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907041034
4433855|pass|200907|cpan.dcollins.smoker1@gmail.com|WWW-UsePerl-Journal|0.22|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907041033
4433775|pass|200907|cpan.dcollins.smoker2@gmail.com|CPAN-Testers-WWW-Reports-Parser|0.01|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907041032
4433731|pass|200907|cpan.dcollins.589@gmail.com|CPAN-Testers-Data-Release|0.01|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907041031
4433549|pass|200907|cpan.dcollins.smoker4@gmail.com|CPAN-Testers-WWW-Reports-Mailer|0.17|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907041007
4433366|pass|200907|cpan.dcollins.5100rc1@gmail.com|CPAN-Testers-WWW-Statistics|0.55|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907041008
4433202|pass|200907|cpan.dcollins.smoker5@gmail.com|CPAN-Testers-WWW-Reports-Parser|0.01|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907040957
4433127|pass|200907|cpan.dcollins.smoker9@gmail.com|Test-CPAN-Meta|0.13|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907041012
4433101|fail|200907|cpan.dcollins.smoker9@gmail.com|CPAN-YACSmoke-Plugin-WebList|0.05|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907041011
4432604|pass|200907|cpan.dcollins.589@gmail.com|CPAN-Testers-Common-Article|0.36|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907040958
4432600|pass|200907|cpan.dcollins.5100rc1@gmail.com|CPAN-Testers-Data-Generator|0.35|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907040958
4432479|pass|200907|cpan.dcollins.5100@gmail.com|GD-Chart-Radial|0.07|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907040953
4432468|pass|200907|cpan.dcollins.smoker7@gmail.com|CPAN-YACSmoke-Plugin-Outlook|0.06|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907040953
4431877|pass|200907|cpan.dcollins.smoker6@gmail.com|Data-Phrasebook|0.29|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907040930
4431680|pass|200907|cpan.dcollins.5100@gmail.com|Test-YAML-Meta|0.12|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907040925
4426667|pass|200907|cpan.dcollins.5100rc1@gmail.com|CPAN-Testers-Common-Article|0.36|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907031429
4426025|pass|200907|cpan.dcollins.smoker6@gmail.com|CPAN-Testers-WWW-Statistics|0.65|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907031458
4425979|pass|200907|cpan.dcollins.5100@gmail.com|Test-YAML-Meta|0.12|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907031457
4425721|pass|200907|cpan.dcollins.smoker6@gmail.com|Mail-Outlook|0.15|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907031451
4425694|pass|200907|cpan.dcollins.smoker3@gmail.com|CPAN-Testers-Data-Generator|0.37|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907031450
4423672|pass|200907|cpan.dcollins.smoker4@gmail.com|Data-FormValidator-Constraints-Words|0.03|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907031410
4423225|pass|200907|cpan.dcollins.589@gmail.com|Regexp-Log-Common|0.05|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907031400
4421911|pass|200907|cpan.dcollins.589@gmail.com|App-Maisha|0.12|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907031333
4421657|pass|200907|cpan.dcollins.smoker8@gmail.com|CPAN-Testers-Data-Release|0.01|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907031327
4421561|pass|200907|cpan.dcollins.smoker2@gmail.com|CPAN-Testers-WWW-Reports-Mailer|0.17|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907031325
4421445|pass|200907|cpan.dcollins.smoker4@gmail.com|Finance-Currency-Convert-XE|0.15|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907031322
4421346|pass|200907|cpan.dcollins.smoker6@gmail.com|CPAN-Testers-WWW-Reports-Parser|0.01|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907031319
4416909|pass|200907|bingos@cpan.org|Test-YAML-Meta|0.12|i386-midnightbsd-64int|5.10.0 patch GitLive-maint-5.10-1462-g178839f|midnightbsd|0.1.1-release|200907030600
4413860|pass|200907|cpan.dcollins.smoker1@gmail.com|Games-Trackword|1.06|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907021949
4413672|pass|200907|cpan.dcollins.589@gmail.com|Test-CPAN-Meta|0.13|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907021946
4413464|pass|200907|cpan.dcollins.589@gmail.com|CPAN-Testers-WWW-Reports-Mailer|0.17|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907021942
4413106|pass|200907|cpan.dcollins.smoker9@gmail.com|CPAN-Testers-Common-Article|0.36|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907021933
4412295|pass|200907|cpan.dcollins.smoker5@gmail.com|CPAN-Testers-WWW-Reports-Parser|0.01|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907021912
4412069|pass|200907|cpan.dcollins.smoker3@gmail.com|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907021904
4412003|fail|200907|cpan.dcollins.589@gmail.com|WWW-Scraper-ISBN-Pearson_Driver|0.10|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907021903
4410942|pass|200907|cpan.dcollins.5100rc1@gmail.com|Parse-CPAN-Distributions|0.05|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907021835
4410785|pass|200907|cpan.dcollins.5100@gmail.com|Test-YAML-Meta|0.12|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907021831
4410361|pass|200907|cpan.dcollins.smoker2@gmail.com|CPAN-Testers-Data-Release|0.01|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907021821
4410175|pass|200907|cpan.dcollins.5100rc1@gmail.com|CPAN-Testers-Data-Generator|0.37|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907021815
4409381|pass|200907|cpan.dcollins.5100@gmail.com|CPAN-Testers-WWW-Statistics|0.65|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907021755
4409338|pass|200907|cpan.dcollins.589@gmail.com|WWW-UsePerl-Journal|0.22|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907021753
4409281|pass|200907|cpan.dcollins.589@gmail.com|WWW-UsePerl-Journal-Thread|0.12|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907021752
4408944|fail|200907|cpan.dcollins.smoker5@gmail.com|WWW-Scraper-ISBN-ORA_Driver|0.09|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907021744
4407533|pass|200907|bingos@cpan.org|Test-YAML-Meta|0.12|OpenBSD.i386-openbsd-thread-multi-64int|5.10.0|openbsd|4.4|200907021951
4405338|pass|200907|martin.evans@easysoft.com|Parse-CPAN-Distributions|0.05|i686-linux|5.10.0|linux|2.6.24-24-generic|200907021132
4405050|pass|200907|martin.evans@easysoft.com|WWW-UsePerl-Journal-Thread|0.12|i686-linux|5.10.0|linux|2.6.24-24-generic|200907021048
4405049|pass|200907|martin.evans@easysoft.com|WWW-UsePerl-Journal|0.22|i686-linux|5.10.0|linux|2.6.24-24-generic|200907021048
4404883|pass|200907|martin.evans@easysoft.com|CPAN-WWW-Testers-Generator|0.30|i686-linux|5.10.0|linux|2.6.24-24-generic|200907021036
4403276|pass|200907|cpan.dcollins.smoker9@gmail.com|CPAN-YACSmoke-Plugin-NNTP|0.05|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907020049
4402952|pass|200907|cpan.dcollins.smoker7@gmail.com|CPAN-YACSmoke-Plugin-NNTPWeb|0.06|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907020043
4402931|pass|200907|cpan.dcollins.smoker2@gmail.com|Data-Phrasebook-Loader-Ini|0.10|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907020043
4401841|pass|200907|cpan.dcollins.smoker7@gmail.com|Data-Phrasebook-Loader-DBI|0.11|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907020022
4401462|fail|200907|cpan.dcollins.smoker3@gmail.com|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907020011
4401296|pass|200907|cpan.dcollins.5100rc1@gmail.com|Data-Phrasebook-Loader-XML|0.12|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907020006
4401048|pass|200907|cpan.dcollins.smoker5@gmail.com|CPAN-Testers-WWW-Statistics|0.55|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907020358
4400995|pass|200907|cpan.dcollins.5100rc1@gmail.com|CPAN-YACSmoke-Plugin-Outlook|0.06|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907020357
4400931|fail|200907|cpan.dcollins.smoker3@gmail.com|CPAN-YACSmoke-Plugin-WebList|0.05|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907020355
4400638|pass|200907|cpan.dcollins.smoker7@gmail.com|Mail-File|0.08|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907020345
4400364|fail|200907|cpan.dcollins.smoker2@gmail.com|WWW-Scraper-ISBN-Amazon_Driver|0.14|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907020337
4397499|pass|200907|cpan.dcollins.5100rc1@gmail.com|CPAN-Testers-Data-Generator|0.35|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907011737
4397031|pass|200907|cpan.dcollins.smoker6@gmail.com|CPAN-YACSmoke-Plugin-NNTP|0.05|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907011716
4396578|pass|200907|cpan.dcollins.smoker8@gmail.com|GD-Chart-Radial|0.07|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907011653
4396101|fail|200907|cpan.dcollins.smoker1@gmail.com|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907011628
4395363|pass|200907|cpan.dcollins.smoker5@gmail.com|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907011547
4395054|pass|200907|cpan.dcollins.smoker3@gmail.com|CPAN-Testers-Data-Generator|0.35|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907011533
4394617|pass|200907|cpan.dcollins.smoker2@gmail.com|Data-Phrasebook|0.29|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907011512
4393471|pass|200907|bingos@cpan.org|Test-YAML-Meta|0.12|i386-midnightbsd-64int|5.11.0 patch GitLive-blead-1493-g9015f10|midnightbsd|0.1.1-release|200907011622
4393098|fail|200907|cpan.dcollins.589@gmail.com|CPAN-YACSmoke-Plugin-WebList|0.05|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907011145
4392793|pass|200907|cpan.dcollins.smoker3@gmail.com|Data-Phrasebook-Loader-XML|0.12|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907011129
4392664|pass|200907|cpan.dcollins.smoker6@gmail.com|Data-Phrasebook-Loader-DBI|0.11|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907011122
4392342|pass|200907|cpan.dcollins.smoker3@gmail.com|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907011102
4392312|pass|200907|cpan.dcollins.589@gmail.com|Parse-CPAN-Distributions|0.05|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907011101
4390853|pass|200907|cpan.dcollins.smoker4@gmail.com|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907010959
4390667|pass|200907|cpan.dcollins.5100rc1@gmail.com|CPAN-YACSmoke-Plugin-Outlook|0.06|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907010950
4388838|pass|200907|cpan.dcollins.smoker6@gmail.com|CPAN-Testers-Data-Uploads|0.06|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200907010845
4384554|pass|200907|martin.evans@easysoft.com|Test-YAML-Meta|0.12|i486-linux-gnu-thread-multi|5.8.8|linux|2.6.24-19-server|200907010943
4382674|pass|200907|cpan@sourcentral.org ("Oliver Paukstadt")|Parse-CPAN-Distributions|0.05|s390x-linux|5.10.0|linux|2.6.27.19-5-default|200907010318
4382175|pass|200907|cpan.dcollins.smoker2@gmail.com|Mail-Outlook|0.15|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907010044
4381786|pass|200907|cpan.dcollins.5100rc1@gmail.com|Data-Phrasebook-Loader-Ini|0.10|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907010028
4381429|pass|200907|cpan.dcollins.smoker2@gmail.com|Mail-Outlook|0.15|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907010019
4380911|pass|200907|cpan.dcollins.smoker2@gmail.com|Data-Phrasebook-Loader-XML|0.12|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200907010008
4380839|pass|200907|cpan.dcollins.smoker4@gmail.com|Data-Phrasebook-Loader-DBI|0.11|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907010007
4380833|pass|200907|cpan.dcollins.smoker9@gmail.com|GD-Chart-Radial|0.07|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200907010007
4380582|pass|200907|cpan.dcollins.smoker2@gmail.com|App-Maisha-Plugin-PingFM|0.02|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200907010004
4380535|pass|200907|cpan.dcollins.smoker3@gmail.com|App-Maisha-Plugin-PingFM|0.02|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200907010004
4380061|fail|200906|cpan.dcollins.589@gmail.com|WWW-Scraper-ISBN-ORA_Driver|0.09|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906301958
4380052|fail|200906|cpan.dcollins.589@gmail.com|WWW-Scraper-ISBN-ORA_Driver|0.09|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906301958
4379935|fail|200906|cpan.dcollins.smoker4@gmail.com|WWW-Scraper-ISBN-ORA_Driver|0.09|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200906301956
4379607|fail|200906|cpan.dcollins.smoker4@gmail.com|WWW-Scraper-ISBN-Amazon_Driver|0.14|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200906301952
4378558|pass|200906|cpan.dcollins.589@gmail.com|CPAN-YACSmoke-Plugin-NNTPWeb|0.06|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906301937
4378151|pass|200906|cpan.dcollins.smoker3@gmail.com|Mail-File|0.08|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200906301931
4377851|pass|200906|cpan.dcollins.smoker2@gmail.com|Data-Phrasebook-Loader-Ini|0.10|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200906301927
4377626|pass|200906|dagolden@cpan.org (DAGOLDEN)|CPAN-Testers-WWW-Reports-Mailer|0.17|i686-linux|5.8.9|linux|2.6.24-16-generic|200906301923
4377558|pass|200906|dagolden@cpan.org (DAGOLDEN)|CPAN-Testers-WWW-Statistics|0.65|i686-linux|5.8.9|linux|2.6.24-16-generic|200906301922
4376856|pass|200906|dagolden@cpan.org (DAGOLDEN)|CPAN-Testers-Data-Generator|0.37|i686-linux|5.8.9|linux|2.6.24-16-generic|200906301848
4376699|pass|200906|dagolden@cpan.org (DAGOLDEN)|CPAN-Testers-Data-Release|0.01|i686-linux|5.8.9|linux|2.6.24-16-generic|200906301844
4375353|pass|200906|dagolden@cpan.org (DAGOLDEN)|CPAN-Testers-WWW-Reports-Parser|0.01|i686-linux|5.8.9|linux|2.6.24-16-generic|200906301818
4374781|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal-Thread|0.12|s390x-linux|5.10.0|linux|2.6.27.19-5-default|200906302301
4374530|pass|200906|dagolden@cpan.org (DAGOLDEN)|Test-YAML-Meta|0.12|i686-linux|5.8.9|linux|2.6.24-16-generic|200906301608
4374446|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-WWW-Testers-Generator|0.30|s390x-linux|5.10.0|linux|2.6.27.19-5-default|200906302141
4368619|pass|200906|bingos@cpan.org|Test-YAML-Meta|0.12|i386-midnightbsd|5.8.9|midnightbsd|0.1.1-release|200906300443
4368262|pass|200906|bingos@cpan.org|Test-YAML-Meta|0.12|OpenBSD.i386-openbsd-thread-multi-64int|5.8.9|openbsd|4.3|200906300427
4367273|pass|200906|cpan.dcollins.smoker2@gmail.com|Data-Phrasebook-Loader-DBI|0.11|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200906300246
4367073|pass|200906|cpan.dcollins.5100rc1@gmail.com|WWW-UsePerl-Journal-Thread|0.12|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200906300237
4366342|pass|200906|cpan.dcollins.5100@gmail.com|Finance-Currency-Convert-XE|0.15|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200906300212
4365587|pass|200906|cpan.dcollins.smoker6@gmail.com|Calendar-List|0.21|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200906300158
4364372|pass|200906|cpan.dcollins.smoker5@gmail.com|Mail-File|0.08|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200906300140
4364119|pass|200906|cpan.dcollins.smoker8@gmail.com|WWW-UsePerl-Journal-Thread|0.12|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906300136
4363834|pass|200906|cpan.dcollins.smoker6@gmail.com|CPAN-Testers-WWW-Statistics|0.55|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906300131
4363611|pass|200906|cpan.dcollins.smoker4@gmail.com|Data-Phrasebook-Loader-XML|0.12|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200906300128
4363416|pass|200906|cpan.dcollins.smoker5@gmail.com|Calendar-List|0.21|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906300125
4362782|pass|200906|cpan.dcollins.smoker3@gmail.com|CPAN-YACSmoke-Plugin-NNTPWeb|0.06|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200906300113
4362469|pass|200906|cpan.dcollins.smoker1@gmail.com|App-Maisha|0.12|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200906300108
4362421|pass|200906|cpan.dcollins.smoker8@gmail.com|Data-FormValidator-Constraints-Words|0.03|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906300108
4358790|pass|200906|cpan.dcollins.smoker1@gmail.com|Games-Trackword|1.06|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906291525
4358561|pass|200906|cpan.dcollins.5100rc1@gmail.com|Finance-Currency-Convert-XE|0.15|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906291519
4358064|pass|200906|cpan.dcollins.smoker1@gmail.com|CPAN-Testers-Data-Uploads|0.06|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200906291508
4356620|pass|200906|cpan.dcollins.smoker9@gmail.com|CPAN-YACSmoke-Plugin-Outlook|0.06|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906291428
4356427|pass|200906|cpan.dcollins.smoker8@gmail.com|CPAN-YACSmoke-Plugin-NNTP|0.05|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906291423
4356403|pass|200906|cpan.dcollins.smoker5@gmail.com|Data-FormValidator-Constraints-Words|0.03|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200906291423
4356251|fail|200906|cpan.dcollins.smoker5@gmail.com|WWW-Scraper-ISBN-Pearson_Driver|0.10|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200906291420
4355554|pass|200906|bingos@cpan.org|Test-YAML-Meta|0.12|darwin-thread-multi-64int-2level|5.10.0|darwin|8.11.0|200906291904
4355148|pass|200906|cpan.dcollins.smoker8@gmail.com|Mail-File|0.08|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906291354
4353771|pass|200906|cpan.dcollins.smoker5@gmail.com|GD-Chart-Radial|0.07|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200906291320
4352141|pass|200906|dagolden@cpan.org (DAGOLDEN)|Test-CPAN-Meta|0.13|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200906291001
4348577|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook-Loader-Ini|0.10|s390x-linux-thread-multi|5.6.2|linux|2.6.16.60-0.31-default|200906291006
4348569|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook-Loader-XML|0.12|s390x-linux-thread-multi|5.6.2|linux|2.6.16.60-0.31-default|200906291003
4348552|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook-Loader-YAML|0.09|s390x-linux-thread-multi|5.6.2|linux|2.6.16.60-0.31-default|200906291000
4348373|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|Mail-File|0.08|s390x-linux-thread-multi|5.6.2|linux|2.6.16.60-0.31-default|200906290940
4348368|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|Regexp-Log-Common|0.05|s390x-linux-thread-multi|5.6.2|linux|2.6.16.60-0.31-default|200906290939
4348362|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook|0.29|s390x-linux-thread-multi|5.6.2|linux|2.6.16.60-0.31-default|200906290938
4347362|pass|200906|dagolden@cpan.org (DAGOLDEN)|CPAN-Testers-WWW-Reports-Mailer|0.17|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200906290058
4347359|pass|200906|dagolden@cpan.org (DAGOLDEN)|CPAN-Testers-WWW-Statistics|0.65|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200906290056
4347100|pass|200906|dagolden@cpan.org (DAGOLDEN)|CPAN-Testers-Data-Generator|0.37|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200906290008
4347078|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-YACSmoke-Plugin-Outlook|0.06|s390x-linux-thread-multi|5.6.2|linux|2.6.16.60-0.31-default|200906290602
4347077|pass|200906|dagolden@cpan.org (DAGOLDEN)|CPAN-Testers-Data-Release|0.01|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200906290002
4346982|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-YACSmoke-Plugin-NNTP|0.05|s390x-linux-thread-multi|5.6.2|linux|2.6.16.60-0.31-default|200906290537
4346937|pass|200906|cpan.dcollins.smoker8@gmail.com|Games-Trackword|1.06|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200906290336
4346591|pass|200906|dagolden@cpan.org (DAGOLDEN)|CPAN-Testers-WWW-Reports-Parser|0.01|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200906290329
4345121|pass|200906|dagolden@cpan.org (DAGOLDEN)|Test-YAML-Meta|0.12|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200906290029
4341042|pass|200906|cpan.dcollins.smoker5@gmail.com|CPAN-WWW-Testers-Generator|0.30|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906281008
4340546|pass|200906|cpan.dcollins.smoker4@gmail.com|CPAN-YACSmoke-Plugin-NNTP|0.05|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200906280921
4340246|pass|200906|cpan.dcollins.smoker4@gmail.com|Parse-CPAN-Distributions|0.05|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906280927
4339709|fail|200906|cpan.dcollins.589@gmail.com|CPAN-YACSmoke-Plugin-WebList|0.05|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200906280946
4339618|pass|200906|cpan.dcollins.smoker4@gmail.com|Data-Phrasebook|0.29|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200906280948
4339429|pass|200906|cpan.dcollins.smoker5@gmail.com|Data-Phrasebook|0.29|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906280957
4339364|pass|200906|cpan.dcollins.smoker8@gmail.com|CPAN-Testers-Data-Generator|0.35|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200906280956
4339225|fail|200906|cpan.dcollins.smoker9@gmail.com|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200906280953
4338978|pass|200906|cpan.dcollins.5100rc1@gmail.com|App-Maisha|0.12|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906280949
4338541|pass|200906|cpan.dcollins.smoker4@gmail.com|CPAN-YACSmoke-Plugin-NNTPWeb|0.06|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200906280940
4338447|fail|200906|cpan.dcollins.589@gmail.com|CPAN-YACSmoke-Plugin-WebList|0.05|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200906280938
4337610|fail|200906|cpan.dcollins.5100@gmail.com|WWW-Scraper-ISBN-Amazon_Driver|0.14|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906280921
4337529|pass|200906|cpan.dcollins.smoker4@gmail.com|CPAN-Testers-Data-Uploads|0.06|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906280919
4336723|fail|200906|cpan.dcollins.smoker8@gmail.com|WWW-Scraper-ISBN-Pearson_Driver|0.10|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906280904
4335572|pass|200906|cpan.dcollins.smoker8@gmail.com|Data-Phrasebook-Loader-Ini|0.10|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200906280842
4335333|pass|200906|cpan.dcollins.smoker1@gmail.com|CPAN-YACSmoke-Plugin-Outlook|0.06|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200906280824
4335315|pass|200906|cpan.dcollins.smoker9@gmail.com|CPAN-Testers-WWW-Statistics|0.55|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200906280837
4335299|pass|200906|cpan.dcollins.589@gmail.com|CPAN-WWW-Testers-Generator|0.30|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200906280837
4334617|pass|200906|cpan.dcollins.5100@gmail.com|Mail-Outlook|0.15|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200906280824
4334211|pass|200906|joerg.meltzer@tngtech.com|Test-CPAN-Meta|0.13|cygwin-thread-multi-64int|5.10.0 patch 34065|cygwin|1.5.25(0.15642)|200906271510
4331867|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Uploads|0.06|s390x-linux|5.8.8|linux|2.6.27.19-5-default|200906280922
4330025|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha-Plugin-PingFM|0.02|s390x-linux|5.8.8|linux|2.6.27.19-5-default|200906280401
4328677|pass|200906|dagolden@cpan.org (DAGOLDEN)|Test-CPAN-Meta|0.13|i686-linux|5.10.0|linux|2.6.24-16-generic|200906280022
4326863|pass|200906|bingos@cpan.org|Test-YAML-Meta|0.12|i386-midnightbsd|5.10.0|midnightbsd|0.1.1-release|200906272030
4322583|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Generator|0.37|s390x-linux-thread-multi|5.10.0|linux|2.6.18-92.el5|200906271053
4322515|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Mailer|0.17|s390x-linux-thread-multi|5.10.0|linux|2.6.16.60-0.31-default|200906271043
4322389|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Generator|0.37|s390x-linux-thread-multi|5.10.0|linux|2.6.16.60-0.31-default|200906271022
4315389|pass|200906|lists.perl.cpan-testers@csjewell.fastmail.us (Curtis Jewell)|Test-CPAN-Meta|0.13|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.1|200906260055
4315228|pass|200906|bingos@cpan.org|Test-YAML-Meta|0.12|OpenBSD.i386-openbsd-thread-multi-64int|5.8.8|openbsd|4.3|200906261527
4309814|pass|200906|cpan.dcollins.5100@gmail.com|Regexp-Log-Common|0.05|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200906260130
4307066|pass|200906|cpan.dcollins.smoker4@gmail.com|Finance-Currency-Convert-XE|0.15|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200906251757
4306816|pass|200906|cpan.dcollins.smoker3@gmail.com|Regexp-Log-Common|0.05|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906251751
4306793|pass|200906|cpan.dcollins.smoker5@gmail.com|Regexp-Log-Common|0.05|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200906251750
4306388|pass|200906|cpan.dcollins.smoker4@gmail.com|Data-FormValidator-Constraints-Words|0.03|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200906251739
4303835|pass|200906|cpan.dcollins.589@gmail.com|CPAN-Testers-WWW-Reports-Mailer|0.17|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200906251221
4303196|pass|200906|cpan.dcollins.smoker4@gmail.com|Test-CPAN-Meta|0.13|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200906251129
4302780|pass|200906|cpan.dcollins.smoker8@gmail.com|Data-FormValidator-Constraints-Words|0.03|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200906251205
4302741|pass|200906|cpan.dcollins.589@gmail.com|CPAN-Testers-Common-Article|0.36|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200906251202
4301969|pass|200906|cpan.dcollins.smoker3@gmail.com|Finance-Currency-Convert-XE|0.15|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200906251227
4301868|pass|200906|cpan.dcollins.smoker1@gmail.com|Test-CPAN-Meta|0.13|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906251223
4301346|pass|200906|cpan.dcollins.smoker5@gmail.com|Calendar-List|0.21|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200906251217
4301208|pass|200906|cpan.dcollins.smoker5@gmail.com|CPAN-Testers-Data-Release|0.01|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906251227
4300801|pass|200906|cpan.dcollins.5100rc1@gmail.com|CPAN-Testers-Data-Release|0.01|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200906251218
4300629|pass|200906|cpan.dcollins.smoker1@gmail.com|CPAN-Testers-Data-Generator|0.37|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200906251214
4300550|pass|200906|cpan.dcollins.smoker2@gmail.com|CPAN-Testers-Common-Article|0.36|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906251213
4300512|pass|200906|cpan.dcollins.smoker2@gmail.com|CPAN-Testers-WWW-Statistics|0.65|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906251153
4300135|pass|200906|cpan.dcollins.smoker7@gmail.com|CPAN-Testers-WWW-Statistics|0.65|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200906251204
4299694|pass|200906|cpan.dcollins.smoker3@gmail.com|CPAN-Testers-Data-Release|0.01|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200906251058
4299440|pass|200906|cpan.dcollins.smoker9@gmail.com|CPAN-Testers-WWW-Reports-Parser|0.01|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200906251130
4299336|pass|200906|cpan.dcollins.smoker3@gmail.com|Test-CPAN-Meta|0.13|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200906251146
4299016|pass|200906|cpan.dcollins.smoker1@gmail.com|Games-Trackword|1.06|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200906251139
4298992|pass|200906|cpan.dcollins.smoker6@gmail.com|CPAN-Testers-WWW-Reports-Mailer|0.17|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200906251139
4298875|pass|200906|cpan.dcollins.smoker4@gmail.com|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906251117
4298812|pass|200906|cpan.dcollins.smoker1@gmail.com|CPAN-Testers-Data-Generator|0.37|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906251133
4298775|pass|200906|cpan.dcollins.smoker1@gmail.com|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200906251133
4298754|pass|200906|cpan.dcollins.5100@gmail.com|CPAN-Testers-WWW-Statistics|0.65|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200906251133
4298749|pass|200906|cpan.dcollins.smoker8@gmail.com|CPAN-Testers-WWW-Reports-Mailer|0.17|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906251132
4298568|pass|200906|cpan.dcollins.5100@gmail.com|CPAN-Testers-Common-Article|0.36|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200906251117
4298173|pass|200906|cpan.dcollins.589@gmail.com|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200906251121
4298127|pass|200906|cpan.dcollins.smoker8@gmail.com|CPAN-Testers-Data-Generator|0.37|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200906251120
4297560|pass|200906|cpan.dcollins.5100rc1@gmail.com|CPAN-Testers-WWW-Reports-Parser|0.01|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906251106
4297425|pass|200906|cpan.dcollins.5100@gmail.com|CPAN-Testers-WWW-Reports-Parser|0.01|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200906251103
4296349|pass|200906|martin.evans@easysoft.com|Data-Phrasebook-Loader-YAML|0.09|i686-linux|5.10.0|linux|2.6.24-24-generic|200906251416
4296345|pass|200906|martin.evans@easysoft.com|Data-Phrasebook|0.29|i686-linux|5.10.0|linux|2.6.24-24-generic|200906251416
4295189|pass|200906|martin.evans@easysoft.com|CPAN-Testers-Data-Generator|0.35|i686-linux|5.10.0|linux|2.6.24-24-generic|200906251120
4293003|pass|200906|cpan.dcollins.smoker1@gmail.com|WWW-UsePerl-Journal|0.22|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200906250525
4291803|unknown|200906|cpan.dcollins.smoker5@gmail.com|Parse-CPAN-Distributions|0.05|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906250035
4290990|unknown|200906|cpan.dcollins.589@gmail.com|CPAN-WWW-Testers-Generator|0.30|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906250016
4290984|fail|200906|cpan.dcollins.smoker5@gmail.com|WWW-Scraper-ISBN-ORA_Driver|0.09|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200906250016
4290668|pass|200906|cpan.dcollins.smoker4@gmail.com|Calendar-List|0.21|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200906250410
4290275|pass|200906|cpan.dcollins.smoker7@gmail.com|CPAN-WWW-Testers-Generator|0.30|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200906250001
4289970|unknown|200906|cpan.dcollins.smoker4@gmail.com|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906250355
4288718|pass|200906|cpan.dcollins.smoker6@gmail.com|Games-Trackword|1.06|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200906250327
4288696|pass|200906|cpan.dcollins.589@gmail.com|WWW-UsePerl-Journal|0.22|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906250326
4288694|pass|200906|cpan.dcollins.5100@gmail.com|Test-YAML-Meta|0.12|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200906250326
4288539|pass|200906|cpan.dcollins.smoker5@gmail.com|WWW-UsePerl-Journal-Thread|0.12|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200906250323
4288341|pass|200906|cpan.dcollins.5100@gmail.com|Test-YAML-Meta|0.12|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1437-g8bca5c8|linux|2.6.30-020630rc7-generic|200906250318
4288304|pass|200906|cpan.dcollins.5100rc1@gmail.com|Test-YAML-Meta|0.12|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906250317
4288299|pass|200906|cpan.dcollins.5100rc1@gmail.com|Test-YAML-Meta|0.12|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906250317
4287961|pass|200906|cpan.dcollins.smoker2@gmail.com|WWW-UsePerl-Journal|0.22|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200906250310
4287749|fail|200906|cpan.dcollins.smoker6@gmail.com|WWW-Scraper-ISBN-Pearson_Driver|0.10|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200906250305
4287507|pass|200906|cpan.dcollins.smoker7@gmail.com|Parse-CPAN-Distributions|0.05|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200906250300
4287225|unknown|200906|cpan.dcollins.smoker1@gmail.com|WWW-Scraper-ISBN-Amazon_Driver|0.14|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906250254
4286871|unknown|200906|cpan.dcollins.smoker3@gmail.com|WWW-UsePerl-Journal-Thread|0.12|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906250246
4286867|unknown|200906|cpan.dcollins.smoker3@gmail.com|WWW-UsePerl-Journal-Thread|0.12|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906250245
4283773|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook-Loader-YAML|0.09|s390-linux-thread-multi|5.8.9|linux|2.6.5-7.315-s390|200906241648
4283771|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook|0.29|s390-linux-thread-multi|5.8.9|linux|2.6.5-7.315-s390|200906241648
4283177|pass|200906|cpan.dcollins.smoker1@gmail.com|Parse-CPAN-Distributions|0.05|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1257-g2b4f847|linux|2.6.30-020630rc7-generic|200906240840
4282885|pass|200906|cpan.dcollins.589@gmail.com|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906240837
4282871|fail|200906|cpan.dcollins.5100rc1@gmail.com|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200906240836
4282818|pass|200906|cpan.dcollins.smoker9@gmail.com|Data-Phrasebook|0.29|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906240831
4282113|fail|200906|cpan.dcollins.smoker2@gmail.com|WWW-Scraper-ISBN-Pearson_Driver|0.10|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200906240845
4282057|pass|200906|cpan.dcollins.smoker1@gmail.com|CPAN-Testers-WWW-Statistics|0.55|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906240843
4281273|pass|200906|cpan.dcollins.smoker7@gmail.com|CPAN-WWW-Testers-Generator|0.30|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1257-g2b4f847|linux|2.6.30-020630rc7-generic|200906240829
4280025|pass|200906|cpan.dcollins.smoker4@gmail.com|WWW-UsePerl-Journal-Thread|0.12|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1257-g2b4f847|linux|2.6.30-020630rc7-generic|200906240810
4280009|fail|200906|cpan.dcollins.smoker7@gmail.com|WWW-Scraper-ISBN-Amazon_Driver|0.14|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200906240809
4279892|fail|200906|cpan.dcollins.smoker8@gmail.com|WWW-Scraper-ISBN-ORA_Driver|0.09|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200906240807
4279617|pass|200906|cpan.dcollins.smoker8@gmail.com|Data-FormValidator-Constraints-Words|0.03|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200906240759
4279424|pass|200906|cpan.dcollins.smoker7@gmail.com|CPAN-Testers-Data-Generator|0.35|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906240754
4279014|pass|200906|cpan.dcollins.smoker2@gmail.com|Finance-Currency-Convert-XE|0.15|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200906240744
4278573|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|Parse-CPAN-Distributions|0.05|s390-linux-thread-multi|5.10.0|linux|2.6.5-7.315-s390|200906241235
4278406|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|Parse-CPAN-Distributions|0.05|s390-linux|5.10.0|linux|2.6.5-7.315-s390|200906241206
4278050|pass|200906|martin.evans@easysoft.com|CPAN-Testers-Data-Uploads|0.06|i686-linux|5.10.0|linux|2.6.24-24-generic|200906240915
4277793|pass|200906|cpan.dcollins.smoker6@gmail.com|CPAN-Testers-WWW-Statistics|0.65|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1257-g2b4f847|linux|2.6.30-020630rc7-generic|200906231037
4277702|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Generator|0.35|s390-linux-thread-multi|5.8.9|linux|2.6.5-7.315-s390|200906240815
4277657|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal-Thread|0.12|s390-linux-thread-multi|5.10.0|linux|2.6.5-7.315-s390|200906240758
4277603|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal-Thread|0.12|s390-linux|5.10.0|linux|2.6.5-7.315-s390|200906240735
4277480|pass|200906|cpan.dcollins.smoker3@gmail.com|Parse-CPAN-Distributions|0.05|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200906240511
4277363|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-WWW-Testers-Generator|0.30|s390-linux-thread-multi|5.10.0|linux|2.6.5-7.315-s390|200906240641
4277349|pass|200906|cpan.dcollins.smoker5@gmail.com|CPAN-Testers-WWW-Statistics|0.55|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200906240437
4277178|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-WWW-Testers-Generator|0.30|s390-linux|5.10.0|linux|2.6.5-7.315-s390|200906240618
4276519|pass|200906|cpan.dcollins.5100rc1@gmail.com|WWW-UsePerl-Journal-Thread|0.12|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200906240352
4276486|pass|200906|cpan.dcollins.smoker5@gmail.com|CPAN-Testers-Data-Uploads|0.06|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200906231050
4276452|pass|200906|cpan.dcollins.smoker2@gmail.com|Games-Trackword|1.06|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200906240350
4276315|pass|200906|cpan.dcollins.smoker7@gmail.com|Calendar-List|0.21|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200906240345
4276209|fail|200906|cpan.dcollins.smoker7@gmail.com|WWW-Scraper-ISBN-Amazon_Driver|0.14|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1257-g2b4f847|linux|2.6.30-020630rc7-generic|200906240341
4275905|pass|200906|cpan.dcollins.smoker6@gmail.com|CPAN-WWW-Testers-Generator|0.30|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200906240332
4275831|pass|200906|cpan.dcollins.smoker5@gmail.com|CPAN-Testers-Data-Generator|0.35|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200906240330
4275514|fail|200906|cpan.dcollins.smoker2@gmail.com|WWW-Scraper-ISBN-Pearson_Driver|0.10|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200906240321
4274953|fail|200906|cpan.dcollins.smoker8@gmail.com|WWW-Scraper-ISBN-Amazon_Driver|0.14|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200906240308
4274868|pass|200906|cpan.dcollins.589@gmail.com|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200906240306
4274644|fail|200906|cpan.dcollins.smoker5@gmail.com|WWW-Scraper-ISBN-ORA_Driver|0.09|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200906240300
4274526|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|Parse-CPAN-Distributions|0.05|s390x-linux-thread-multi|5.10.0|linux|2.6.27.19-5-default|200906240456
4274133|pass|200906|cpan.dcollins.smoker4@gmail.com|Data-Phrasebook|0.29|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200906240246
4273998|fail|200906|cpan.dcollins.smoker6@gmail.com|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200906240243
4273827|fail|200906|cpan.dcollins.smoker2@gmail.com|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1257-g2b4f847|linux|2.6.30-020630rc7-generic|200906240239
4273694|pass|200906|cpan.dcollins.smoker5@gmail.com|Test-CPAN-Meta|0.13|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200906231037
4272846|pass|200906|cpan.dcollins.smoker5@gmail.com|CPAN-Testers-Data-Uploads|0.06|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906231340
4272110|pass|200906|cpan.dcollins.smoker6@gmail.com|App-Maisha-Plugin-PingFM|0.02|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906231359
4271921|pass|200906|cpan.dcollins.smoker8@gmail.com|App-Maisha|0.12|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200906231349
4271822|pass|200906|cpan.dcollins.smoker4@gmail.com|CPAN-Testers-Data-Uploads|0.06|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200906231339
4271712|pass|200906|cpan.dcollins.smoker8@gmail.com|CPAN-Testers-WWW-Reports-Mailer|0.16|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200906231041
4271393|pass|200906|cpan.dcollins.smoker6@gmail.com|CPAN-Testers-WWW-Statistics|0.65|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1257-g2b4f847|linux|2.6.30-020630rc7-generic|200906231038
4270521|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal-Thread|0.12|s390x-linux-thread-multi|5.10.0|linux|2.6.27.19-5-default|200906240031
4269944|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-WWW-Testers-Generator|0.30|s390x-linux-thread-multi|5.10.0|linux|2.6.27.19-5-default|200906232317
4268764|pass|200906|cpan.dcollins.5100rc1@gmail.com|App-Maisha-Plugin-PingFM|0.02|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200906231355
4267685|pass|200906|cpan.dcollins.smoker7@gmail.com|Mail-Outlook|0.15|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200906221724
4267519|pass|200906|martin.evans@easysoft.com|App-Maisha-Plugin-PingFM|0.02|i686-linux|5.10.0|linux|2.6.24-24-generic|200906231640
4266514|pass|200906|andy@hexten.net|Test-YAML-Meta|0.12|darwin-thread-multi-2level|5.10.0|darwin|9.1.0|200906231539
4265809|pass|200906|martin.evans@easysoft.com|App-Maisha|0.12|i686-linux|5.10.0|linux|2.6.24-24-generic|200906231417
4265622|pass|200906|cpan.dcollins.smoker6@gmail.com|WWW-UsePerl-Journal|0.22|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200906221827
4265055|pass|200906|cpan.dcollins.smoker5@gmail.com|CPAN-Testers-Common-Article|0.36|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1257-g2b4f847|linux|2.6.30-020630rc7-generic|200906221716
4264109|pass|200906|cpan.dcollins.smoker6@gmail.com|CPAN-Testers-Data-Generator|0.37|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200906221732
4263918|pass|200906|cpan.dcollins.smoker9@gmail.com|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200906221820
4263729|pass|200906|cpan.dcollins.smoker9@gmail.com|Test-YAML-Meta|0.12|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200906221812
4263514|pass|200906|cpan.dcollins.smoker4@gmail.com|CPAN-Testers-Data-Release|0.01|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200906221655
4262983|pass|200906|cpan.dcollins.smoker7@gmail.com|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200906221701
4262712|pass|200906|cpan.dcollins.smoker8@gmail.com|CPAN-Testers-WWW-Reports-Parser|0.01|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1257-g2b4f847|linux|2.6.30-020630rc7-generic|200906230015
4262393|pass|200906|cpan.dcollins.smoker8@gmail.com|CPAN-Testers-WWW-Reports-Mailer|0.16|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906221811
4261051|pass|200906|cpan.dcollins.smoker4@gmail.com|Regexp-Log-Common|0.05|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906221655
4260919|pass|200906|cpan.dcollins.smoker5@gmail.com|App-Maisha-Plugin-PingFM|0.02|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200906221702
4259671|pass|200906|bingos@cpan.org|Test-YAML-Meta|0.12|i386-netbsd-thread-multi|5.8.9|netbsd|5.0|200906230406
4258952|pass|200906|cpan.dcollins.smoker2@gmail.com|CPAN-Testers-WWW-Reports-Mailer|0.17|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906221356
4258366|pass|200906|cpan.dcollins.smoker2@gmail.com|CPAN-Testers-Data-Generator|0.37|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906221509
4257470|pass|200906|cpan.dcollins.smoker3@gmail.com|Data-Phrasebook|0.29|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1257-g2b4f847|linux|2.6.30-020630rc7-generic|200906221531
4257310|pass|200906|cpan.dcollins.smoker3@gmail.com|Regexp-Log-Common|0.05|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1257-g2b4f847|linux|2.6.30-020630rc7-generic|200906221505
4257280|pass|200906|cpan.dcollins.smoker1@gmail.com|CPAN-Testers-WWW-Reports-Mailer|0.16|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200906221357
4257099|pass|200906|cpan.dcollins.smoker3@gmail.com|Data-Phrasebook|0.29|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1257-g2b4f847|linux|2.6.30-020630rc7-generic|200906221531
4256796|pass|200906|cpan.dcollins.smoker3@gmail.com|Mail-Outlook|0.15|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200906221524
4256554|pass|200906|cpan.dcollins.smoker1@gmail.com|CPAN-Testers-Data-Release|0.01|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200906221517
4255743|pass|200906|cpan.dcollins.5100@gmail.com|CPAN-Testers-Common-Article|0.36|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200906221524
4255158|pass|200906|cpan.dcollins.589@gmail.com|CPAN-Testers-Data-Generator|0.35|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200906221520
4254791|pass|200906|cpan.dcollins.589@gmail.com|CPAN-Testers-Data-Release|0.01|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1257-g2b4f847|linux|2.6.30-020630rc7-generic|200906221517
4254553|pass|200906|cpan.dcollins.589@gmail.com|CPAN-WWW-Testers-Generator|0.30|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200906221507
4254393|pass|200906|cpan.dcollins.589@gmail.com|CPAN-Testers-Data-Generator|0.35|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200906221502
4253740|pass|200906|cpan.dcollins.5100rc1@gmail.com|WWW-UsePerl-Journal-Thread|0.12|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200906221347
4253602|pass|200906|cpan.dcollins.589@gmail.com|WWW-UsePerl-Journal|0.22|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1257-g2b4f847|linux|2.6.30-020630rc7-generic|200906221355
4253342|pass|200906|cpan.dcollins.5100@gmail.com|App-Maisha-Plugin-PingFM|0.02|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1257-g2b4f847|linux|2.6.30-020630rc7-generic|200906221345
4251426|pass|200906|cpan@tenzobox.net ("Axel Bourgeois")|Test-YAML-Meta|0.12|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-19-server|200906220142
4250919|pass|200906|martin.evans@easysoft.com|Mail-Outlook|0.15|i686-linux|5.10.0|linux|2.6.24-24-generic|200906221208
4247755|pass|200906|cpan.dcollins.5100@gmail.com|CPAN-Testers-Common-Article|0.36|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200906211927
4247514|pass|200906|cpan.dcollins.589@gmail.com|CPAN-Testers-WWW-Reports-Mailer|0.16|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200906211908
4247383|pass|200906|cpan.dcollins.5100@gmail.com|Mail-Outlook|0.15|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906211917
4244498|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Mailer|0.17|s390x-linux|5.10.0|linux|2.6.18-92.el5|200906212028
4244376|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Generator|0.37|s390x-linux|5.10.0|linux|2.6.18-92.el5|200906212003
4242465|pass|200906|bingos@cpan.org|Test-YAML-Meta|0.12|i386-netbsd-thread-multi|5.10.0|netbsd|5.0|200906211325
4239925|pass|200906|emer@emer.net|Test-YAML-Meta|0.12|darwin-2level|5.10.0|darwin|9.6.0|200906201237
4239465|pass|200906|bingos@cpan.org|Test-YAML-Meta|0.12|i386-netbsd-thread-multi-64int|5.8.9|netbsd|4.0|200906210736
4232094|pass|200906|dagolden@cpan.org (DAGOLDEN)|CPAN-Testers-WWW-Reports-Mailer|0.17|i686-linux|5.10.0|linux|2.6.24-16-generic|200906210138
4232023|pass|200906|dagolden@cpan.org (DAGOLDEN)|CPAN-Testers-WWW-Statistics|0.65|i686-linux|5.10.0|linux|2.6.24-16-generic|200906210137
4231033|pass|200906|dagolden@cpan.org (DAGOLDEN)|CPAN-Testers-Data-Generator|0.37|i686-linux|5.10.0|linux|2.6.24-16-generic|200906210058
4230902|pass|200906|dagolden@cpan.org (DAGOLDEN)|CPAN-Testers-Data-Release|0.01|i686-linux|5.10.0|linux|2.6.24-16-generic|200906210050
4230661|pass|200906|dagolden@cpan.org (DAGOLDEN)|CPAN-Testers-WWW-Reports-Parser|0.01|i686-linux|5.10.0|linux|2.6.24-16-generic|200906210018
4230337|pass|200906|ivan.wills@gmail.com ("Ivan Wills")|Test-YAML-Meta|0.12|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-19-server|200906210913
4230335|pass|200906|ivan.wills@gmail.com ("Ivan Wills")|Test-CPAN-Meta|0.13|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-19-server|200906210912
4230017|pass|200906|dagolden@cpan.org (DAGOLDEN)|Test-YAML-Meta|0.12|i686-linux|5.10.0|linux|2.6.24-16-generic|200906201822
4228951|pass|200906|bingos@cpan.org|Test-YAML-Meta|0.12|darwin-thread-multi-64int-2level|5.8.7|darwin|8.11.0|200906202020
4226827|pass|200906|ivan.wills@gmail.com ("Ivan Wills")|CPAN-Testers-WWW-Reports-Mailer|0.17|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-19-server|200906210126
4226813|pass|200906|ivan.wills@gmail.com ("Ivan Wills")|CPAN-Testers-WWW-Statistics|0.65|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-19-server|200906210123
4226615|pass|200906|ivan.wills@gmail.com ("Ivan Wills")|CPAN-Testers-Data-Generator|0.37|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-19-server|200906210057
4226497|pass|200906|ivan.wills@gmail.com ("Ivan Wills")|CPAN-Testers-Data-Release|0.01|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-19-server|200906210045
4226226|pass|200906|ivan.wills@gmail.com ("Ivan Wills")|CPAN-Testers-WWW-Reports-Parser|0.01|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-19-server|200906210013
4224124|pass|200906|stro@cpan.org|CPAN-Testers-WWW-Reports-Parser|0.01|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.00|200906201303
4224034|pass|200906|stro@cpan.org|CPAN-Testers-Data-Release|0.01|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.00|200906201245
4224023|pass|200906|stro@cpan.org|CPAN-Testers-Data-Generator|0.37|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.00|200906201244
4221766|pass|200906|ivan.wills@gmail.com ("Ivan Wills")|CPAN-Testers-WWW-Reports-Mailer|0.17|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.28-11-generic|200906201124
4220468|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Uploads|0.06|s390-linux-thread-multi|5.8.9|linux|2.6.5-7.315-s390|200906192232
4214510|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook-Loader-YAML|0.09|s390-linux|5.8.9|linux|2.6.5-7.315-s390|200906190708
4214505|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook|0.29|s390-linux|5.8.9|linux|2.6.5-7.315-s390|200906190707
4212577|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook-Loader-Ini|0.10|s390x-linux-thread-multi-perlio|5.6.2|linux|2.6.27.19-5-default|200906190117
4212572|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook-Loader-XML|0.12|s390x-linux-thread-multi-perlio|5.6.2|linux|2.6.27.19-5-default|200906190116
4212508|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|Mail-File|0.08|s390x-linux-thread-multi-perlio|5.6.2|linux|2.6.27.19-5-default|200906190103
4212497|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|Regexp-Log-Common|0.05|s390x-linux-thread-multi-perlio|5.6.2|linux|2.6.27.19-5-default|200906190100
4212494|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook|0.29|s390x-linux-thread-multi-perlio|5.6.2|linux|2.6.27.19-5-default|200906190059
4212475|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook-Loader-Ini|0.10|s390-linux|5.6.2|linux|2.6.5-7.315-s390|200906190055
4212474|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook-Loader-XML|0.12|s390-linux|5.6.2|linux|2.6.5-7.315-s390|200906190054
4212426|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|Mail-File|0.08|s390-linux|5.6.2|linux|2.6.5-7.315-s390|200906190041
4212424|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|Regexp-Log-Common|0.05|s390-linux|5.6.2|linux|2.6.5-7.315-s390|200906190040
4212421|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook|0.29|s390-linux|5.6.2|linux|2.6.5-7.315-s390|200906190040
4211968|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-YACSmoke-Plugin-Outlook|0.06|s390-linux|5.6.2|linux|2.6.5-7.315-s390|200906182245
4211961|pass|200906|bingos@cpan.org|Test-YAML-Meta|0.12|i386-netbsd|5.8.9|netbsd|5.0|200906182138
4211911|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-YACSmoke-Plugin-Outlook|0.06|s390x-linux-thread-multi-perlio|5.6.2|linux|2.6.27.19-5-default|200906182234
4211863|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-YACSmoke-Plugin-NNTP|0.05|s390-linux|5.6.2|linux|2.6.5-7.315-s390|200906182218
4211372|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Generator|0.35|s390-linux|5.8.9|linux|2.6.5-7.315-s390|200906182043
4210034|pass|200906|bingos@cpan.org|WWW-UsePerl-Journal|0.22|alpha-linux-thread-multi|5.8.8|linux|2.6.18-5-alpha-generic|200906181513
4207546|pass|200906|mmlange@cpan.org (Matthew Lange)|Test-YAML-Meta|0.12|x86_64-linux|5.8.8|linux|2.6.25-gentoo-r7a1|200906171153
4205974|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Mailer|0.17|s390x-linux|5.10.0|linux|2.6.16.60-0.31-default|200906180651
4205871|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Generator|0.37|s390x-linux|5.10.0|linux|2.6.16.60-0.31-default|200906180635
4205435|pass|200906|bingos@cpan.org|Test-YAML-Meta|0.12|i386-netbsd-thread-multi-64int|5.8.8|netbsd|4.0|200906180426
4201729|pass|200906|bingos@cpan.org|WWW-UsePerl-Journal|0.22|alpha-linux-thread-multi|5.10.0|linux|2.6.18-5-alpha-generic|200906171820
4198671|pass|200906|brian@minton.name|Parse-CPAN-Distributions|0.05|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.29.4-dsa-dl380-oldxeon|200906161610
4198654|pass|200906|bingos@cpan.org|Test-YAML-Meta|0.12|i386-netbsd-64int|5.10.0|netbsd|5.0|200906171317
4198391|pass|200906|bingos@cpan.org|Test-YAML-Meta|0.12|alpha-linux-thread-multi|5.10.0|linux|2.6.18-5-alpha-generic|200906171300
4197688|pass|200906|justin.d.hunter@gmail.com|WWW-UsePerl-Journal|0.22|i386-linux-thread-multi|5.8.8|linux|2.6.18-128.1.1.el5|200906170333
4197388|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal|0.22|s390x-linux-thread-multi|5.8.9|linux|2.6.16.60-0.31-default|200906171144
4194253|pass|200906|bingos@cpan.org|Test-YAML-Meta|0.12|darwin-64int-2level|5.8.9|darwin|8.11.0|200906162339
4192949|pass|200906|bingos@cpan.org|CPAN-Testers-WWW-Reports-Parser|0.01|darwin-64int-2level|5.8.9|darwin|8.11.0|200906162039
4191229|pass|200906|martin.evans@easysoft.com|Regexp-Log-Common|0.05|i686-linux|5.10.0|linux|2.6.24-24-generic|200906161608
4188189|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook-Loader-Ini|0.10|s390x-linux-thread-multi|5.6.2|linux|2.6.18-92.1.18.el5|200906160829
4188179|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook-Loader-XML|0.12|s390x-linux-thread-multi|5.6.2|linux|2.6.18-92.1.18.el5|200906160827
4188167|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook-Loader-YAML|0.09|s390x-linux-thread-multi|5.6.2|linux|2.6.18-92.1.18.el5|200906160823
4188084|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|Mail-File|0.08|s390x-linux-thread-multi|5.6.2|linux|2.6.18-92.1.18.el5|200906160807
4188077|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|Regexp-Log-Common|0.05|s390x-linux-thread-multi|5.6.2|linux|2.6.18-92.1.18.el5|200906160806
4188067|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook|0.29|s390x-linux-thread-multi|5.6.2|linux|2.6.18-92.1.18.el5|200906160805
4187636|pass|200906|bingos@cpan.org|WWW-UsePerl-Journal|0.22|i386-netbsd|5.8.9|netbsd|5.0|200906160559
4187082|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-YACSmoke-Plugin-Outlook|0.06|s390x-linux-thread-multi|5.6.2|linux|2.6.18-92.1.18.el5|200906160556
4186817|pass|200906|bingos@cpan.org|Test-YAML-Meta|0.12|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0|200906160407
4185957|pass|200906|bingos@cpan.org|CPAN-Testers-WWW-Reports-Parser|0.01|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0|200906160202
4184573|pass|200906|bingos@cpan.org|Test-YAML-Meta|0.12|i386-netbsd|5.8.9|netbsd|5.0|200906152345
4183884|pass|200906|justin.d.hunter@gmail.com|Test-YAML-Meta|0.12|i386-linux-thread-multi|5.8.8|linux|2.6.18-128.1.1.el5|200906151441
4183718|pass|200906|bingos@cpan.org|CPAN-Testers-WWW-Reports-Parser|0.01|i386-netbsd|5.8.9|netbsd|5.0|200906152210
4183714|pass|200906|bingos@cpan.org|CPAN-Testers-Data-Release|0.01|i386-netbsd|5.8.9|netbsd|5.0|200906152209
4183697|pass|200906|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-netbsd|5.8.9|netbsd|5.0|200906152207
4183672|pass|200906|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i386-netbsd|5.8.9|netbsd|5.0|200906152203
4183281|pass|200906|justin.d.hunter@gmail.com|CPAN-Testers-WWW-Reports-Parser|0.01|i386-linux-thread-multi|5.8.8|linux|2.6.18-128.1.1.el5|200906151256
4183280|pass|200906|justin.d.hunter@gmail.com|CPAN-Testers-Data-Release|0.01|i386-linux-thread-multi|5.8.8|linux|2.6.18-128.1.1.el5|200906151255
4183277|pass|200906|justin.d.hunter@gmail.com|CPAN-Testers-Common-DBUtils|0.03|i386-linux-thread-multi|5.8.8|linux|2.6.18-128.1.1.el5|200906151255
4183276|pass|200906|justin.d.hunter@gmail.com|CPAN-Testers-Common-Article|0.36|i386-linux-thread-multi|5.8.8|linux|2.6.18-128.1.1.el5|200906151255
4179027|pass|200906|mw487.yahoo.com@gmail.com|CPAN-Testers-WWW-Reports-Parser|0.01|cygwin-thread-multi-64int|5.10.0 patch 34065|cygwin|1.5.25(0.15642)|200906150600
4178074|pass|200906|stro@cpan.org|CPAN-Testers-Common-DBUtils|0.03|armv5tejl-linux|5.10.0|linux|2.6.17.14|200906151159
4175718|pass|200906|stro@cpan.org|WWW-UsePerl-Journal|0.22|armv5tejl-linux|5.10.0|linux|2.6.17.14|200906150315
4173895|pass|200906|bingos@cpan.org|WWW-UsePerl-Journal|0.22|i386-netbsd|5.10.0|netbsd|5.0|200906142132
4172381|pass|200906|l.mai@web.de|Test-YAML-Meta|0.12|i686-linux|5.10.0|linux|2.6.22-gentoo-r9|200906131705
4172057|pass|200906|bingos@cpan.org|Test-YAML-Meta|0.12|i386-netbsd|5.10.0|netbsd|5.0|200906140057
4171666|pass|200906|bernt.guldbrandtsen@agrsci.dk|Test-YAML-Meta|0.12|x86_64-linux-thread-multi|5.10.0|linux|2.6.18-128.1.6.el5|200906132217
4171325|pass|200906|bingos@cpan.org|Test-YAML-Meta|0.12|darwin-64int-2level|5.8.8|darwin|8.11.0|200906132358
4170942|pass|200906|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.65|i386-netbsd|5.10.0|netbsd|5.0|200906132301
4170939|pass|200906|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.64|i386-netbsd|5.10.0|netbsd|5.0|200906132300
4170892|pass|200906|bingos@cpan.org|CPAN-Testers-WWW-Reports-Parser|0.01|i386-netbsd|5.10.0|netbsd|5.0|200906132254
4170889|pass|200906|bingos@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.17|i386-netbsd|5.10.0|netbsd|5.0|200906132254
4170867|pass|200906|bingos@cpan.org|CPAN-Testers-Data-Release|0.01|i386-netbsd|5.10.0|netbsd|5.0|200906132249
4170857|pass|200906|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-netbsd|5.10.0|netbsd|5.0|200906132247
4170837|pass|200906|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i386-netbsd|5.10.0|netbsd|5.0|200906132242
4170179|pass|200906|bingos@cpan.org|CPAN-Testers-WWW-Reports-Parser|0.01|darwin-64int-2level|5.8.8|darwin|8.11.0|200906132035
4170169|pass|200906|bingos@cpan.org|CPAN-Testers-Data-Release|0.01|darwin-64int-2level|5.8.8|darwin|8.11.0|200906132034
4170149|pass|200906|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|darwin-64int-2level|5.8.8|darwin|8.11.0|200906132030
4170101|pass|200906|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|darwin-64int-2level|5.8.8|darwin|8.11.0|200906132022
4169912|pass|200906|justin.d.hunter@gmail.com|Test-YAML-Meta|0.12|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-16-server|200906131148
4169362|pass|200906|justin.d.hunter@gmail.com|CPAN-Testers-WWW-Reports-Parser|0.01|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-16-server|200906131009
4169356|pass|200906|justin.d.hunter@gmail.com|CPAN-Testers-Data-Release|0.01|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-16-server|200906131009
4169353|pass|200906|justin.d.hunter@gmail.com|CPAN-Testers-Common-DBUtils|0.03|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-16-server|200906131008
4169352|pass|200906|justin.d.hunter@gmail.com|CPAN-Testers-Common-Article|0.36|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-16-server|200906131008
4169027|pass|200906|bingos@cpan.org|Test-YAML-Meta|0.12|i386-netbsd-thread-multi-64int|5.8.9|netbsd|4.0.1|200906131711
4168404|pass|200906|justin.d.hunter@gmail.com|WWW-UsePerl-Journal|0.22|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.26-1-686|200906121554
4168217|pass|200906|bingos@cpan.org|CPAN-Testers-WWW-Reports-Parser|0.01|i386-netbsd-thread-multi-64int|5.8.9|netbsd|4.0.1|200906131417
4168215|pass|200906|bingos@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.17|i386-netbsd-thread-multi-64int|5.8.9|netbsd|4.0.1|200906131416
4168175|pass|200906|bingos@cpan.org|CPAN-Testers-Data-Release|0.01|i386-netbsd-thread-multi-64int|5.8.9|netbsd|4.0.1|200906131411
4168167|pass|200906|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-netbsd-thread-multi-64int|5.8.9|netbsd|4.0.1|200906131410
4168166|pass|200906|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i386-netbsd-thread-multi-64int|5.8.9|netbsd|4.0.1|200906131409
4167296|pass|200906|bingos@cpan.org|WWW-UsePerl-Journal|0.22|darwin-thread-multi-64int-2level|5.10.0|darwin|8.11.0|200906131207
4166146|pass|200906|bingos@cpan.org|Test-YAML-Meta|0.12|i386-netbsd-thread-multi-64int|5.8.8|netbsd|4.0.1|200906130611
4165797|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal-Thread|0.12|s390x-linux|5.8.9|linux|2.6.27.19-5-default|200906130548
4165607|pass|200906|justin.d.hunter@gmail.com|WWW-UsePerl-Journal|0.22|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.26-1-686|200906130303
4165574|pass|200906|bingos@cpan.org|Test-YAML-Meta|0.12|darwin-thread-multi-64int-2level|5.10.0|darwin|8.11.0|200906130356
4165084|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-WWW-Testers-Generator|0.30|s390x-linux|5.8.9|linux|2.6.27.19-5-default|200906130335
4165036|pass|200906|justin.d.hunter@gmail.com|CPAN-Testers-WWW-Reports-Mailer|0.17|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.26-1-686|200906130125
4165033|pass|200906|justin.d.hunter@gmail.com|CPAN-Testers-Data-Release|0.01|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.26-1-686|200906130125
4165032|pass|200906|justin.d.hunter@gmail.com|CPAN-Testers-Data-Generator|0.37|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.26-1-686|200906130124
4165031|pass|200906|justin.d.hunter@gmail.com|CPAN-Testers-Common-Article|0.36|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.26-1-686|200906130124
4165030|pass|200906|justin.d.hunter@gmail.com|CPAN-Testers-Common-DBUtils|0.03|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.26-1-686|200906130124
4164564|pass|200906|bingos@cpan.org|CPAN-Testers-WWW-Reports-Parser|0.01|darwin-thread-multi-64int-2level|5.10.0|darwin|8.11.0|200906130043
4164561|pass|200906|bingos@cpan.org|CPAN-Testers-Data-Release|0.01|darwin-thread-multi-64int-2level|5.10.0|darwin|8.11.0|200906130042
4164557|pass|200906|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|darwin-thread-multi-64int-2level|5.10.0|darwin|8.11.0|200906130041
4164519|pass|200906|justin.d.hunter@gmail.com|CPAN-Testers-WWW-Reports-Mailer|0.17|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.26-1-686|200906120439
4164510|pass|200906|justin.d.hunter@gmail.com|CPAN-Testers-WWW-Reports-Parser|0.01|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.26-1-686|200906110249
4164474|pass|200906|justin.d.hunter@gmail.com|CPAN-Testers-WWW-Statistics|0.65|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.26-1-686|200906120440
4164280|pass|200906|davidp@preshweb.co.uk ("David Precious")|Test-YAML-Meta|0.12|x86_64-linux-thread-multi|5.10.0|linux|2.6.25-arch|200906122128
4164181|pass|200906|justin.d.hunter@gmail.com|CPAN-Testers-Data-Release|0.01|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.26-1-686|200906120438
4164134|pass|200906|justin.d.hunter@gmail.com|CPAN-Testers-Common-Article|0.36|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.26-1-686|200906120437
4163817|pass|200906|justin.d.hunter@gmail.com|CPAN-Testers-WWW-Statistics|0.64|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.26-1-686|200906121343
4163715|pass|200906|justin.d.hunter@gmail.com|Test-YAML-Meta|0.12|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.26-1-686|200906120500
4163667|pass|200906|justin.d.hunter@gmail.com|CPAN-Testers-WWW-Reports-Parser|0.01|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.26-1-686|200906120439
4163665|pass|200906|justin.d.hunter@gmail.com|CPAN-Testers-Data-Generator|0.37|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.26-1-686|200906120438
4163664|pass|200906|justin.d.hunter@gmail.com|CPAN-Testers-Common-DBUtils|0.03|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.26-1-686|200906120437
4161283|pass|200906|MKUTTER@cpan.org ("Martin Kutter")|Test-YAML-Meta|0.12|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-19-server|200906121618
4161273|pass|200906|MKUTTER@cpan.org ("Martin Kutter")|Test-CPAN-Meta|0.13|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-19-server|200906121617
4161223|pass|200906|bingos@cpan.org|Test-YAML-Meta|0.12|i386-netbsd-thread-multi-64int|5.8.9|netbsd|5.0|200906121505
4160603|pass|200906|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.65|i386-netbsd-thread-multi-64int|5.8.9|netbsd|5.0|200906121310
4160599|pass|200906|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.64|i386-netbsd-thread-multi-64int|5.8.9|netbsd|5.0|200906121309
4160574|pass|200906|bingos@cpan.org|CPAN-Testers-WWW-Reports-Parser|0.01|i386-netbsd-thread-multi-64int|5.8.9|netbsd|5.0|200906121304
4160572|pass|200906|bingos@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.17|i386-netbsd-thread-multi-64int|5.8.9|netbsd|5.0|200906121303
4160546|pass|200906|bingos@cpan.org|CPAN-Testers-Data-Release|0.01|i386-netbsd-thread-multi-64int|5.8.9|netbsd|5.0|200906121259
4160543|pass|200906|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-netbsd-thread-multi-64int|5.8.9|netbsd|5.0|200906121258
4160542|pass|200906|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i386-netbsd-thread-multi-64int|5.8.9|netbsd|5.0|200906121258
4156532|pass|200906|bingos@cpan.org|Test-YAML-Meta|0.12|i386-netbsd-thread-multi-64int|5.10.0|netbsd|5.0|200906120052
4155758|pass|200906|vpit@cpan.org|Test-YAML-Meta|0.12|i686-linux-64int-ld|5.10.0|linux|2.6.27.4-chii.profvince.com|200906112305
4155523|pass|200906|bingos@cpan.org|CPAN-Testers-WWW-Reports-Parser|0.01|i386-netbsd-thread-multi-64int|5.8.8|netbsd|4.0.1|200906112056
4155521|pass|200906|bingos@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.17|i386-netbsd-thread-multi-64int|5.8.8|netbsd|4.0.1|200906112056
4155492|pass|200906|bingos@cpan.org|CPAN-Testers-Data-Release|0.01|i386-netbsd-thread-multi-64int|5.8.8|netbsd|4.0.1|200906112051
4155487|pass|200906|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-netbsd-thread-multi-64int|5.8.8|netbsd|4.0.1|200906112050
4155486|pass|200906|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i386-netbsd-thread-multi-64int|5.8.8|netbsd|4.0.1|200906112050
4154538|pass|200906|bingos@cpan.org|Test-YAML-Meta|0.12|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0.1|200906111650
4153018|pass|200906|bingos@cpan.org|CPAN-Testers-WWW-Reports-Parser|0.01|alpha-linux-thread-multi|5.8.9|linux|2.6.18-5-alpha-generic|200906111036
4153017|pass|200906|bingos@cpan.org|Test-YAML-Meta|0.12|darwin-64int-2level|5.8.7|darwin|8.11.0|200906111036
4153015|pass|200906|bingos@cpan.org|CPAN-Testers-Data-Release|0.01|alpha-linux-thread-multi|5.8.9|linux|2.6.18-5-alpha-generic|200906111035
4153012|pass|200906|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|alpha-linux-thread-multi|5.8.9|linux|2.6.18-5-alpha-generic|200906111034
4152971|pass|200906|justin.d.hunter@gmail.com|Test-YAML-Meta|0.12|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.26-1-686|200906110657
4152332|fail|200906|martin.evans@easysoft.com|WWW-UsePerl-Journal|0.22|i686-linux|5.10.0|linux|2.6.24-24-generic|200906110925
4149298|pass|200906|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.65|i386-netbsd-thread-multi-64int|5.10.0|netbsd|5.0|200906110056
4149292|pass|200906|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.64|i386-netbsd-thread-multi-64int|5.10.0|netbsd|5.0|200906110054
4149275|pass|200906|bingos@cpan.org|CPAN-Testers-WWW-Reports-Parser|0.01|i386-netbsd-thread-multi-64int|5.10.0|netbsd|5.0|200906110050
4149271|pass|200906|bingos@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.17|i386-netbsd-thread-multi-64int|5.10.0|netbsd|5.0|200906110049
4149259|pass|200906|bingos@cpan.org|CPAN-Testers-Data-Release|0.01|i386-netbsd-thread-multi-64int|5.10.0|netbsd|5.0|200906110045
4149251|pass|200906|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-netbsd-thread-multi-64int|5.10.0|netbsd|5.0|200906110044
4149249|pass|200906|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i386-netbsd-thread-multi-64int|5.10.0|netbsd|5.0|200906110044
4148594|pass|200906|vpit@cpan.org|Test-YAML-Meta|0.12|i686-linux-thread-multi|5.10.0|linux|2.6.24-20-eeepc|200906102307
4148342|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Mailer|0.17|s390x-linux-thread-multi|5.8.9|linux|2.6.16.60-0.31-default|200906102205
4147875|pass|200906|vpit@cpan.org|CPAN-Testers-WWW-Reports-Parser|0.01|x86_64-linux-thread-multi|5.10.0|linux|2.6.26.3-fuuka.profvince.com|200906102033
4147874|pass|200906|vpit@cpan.org|CPAN-Testers-Data-Release|0.01|x86_64-linux-thread-multi|5.10.0|linux|2.6.26.3-fuuka.profvince.com|200906102032
4147462|pass|200906|mw487.yahoo.com@gmail.com|CPAN-Testers-WWW-Reports-Parser|0.01|cygwin-thread-multi-64int|5.8.8|cygwin|1.5.24(0.15642)|200906101208
4145813|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Generator|0.37|s390-linux-thread-multi|5.8.9|linux|2.6.5-7.315-s390|200906101522
4145808|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-Article|0.36|s390-linux-thread-multi|5.8.9|linux|2.6.5-7.315-s390|200906101522
4145641|pass|200906|stro@cpan.org|Test-YAML-Meta|0.12|i686-linux|5.8.8|linux|2.4.27-2-386|200906101550
4145638|pass|200906|stro@cpan.org|Test-CPAN-Meta|0.13|i686-linux|5.8.8|linux|2.4.27-2-386|200906101549
4145248|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Release|0.01|s390x-linux-thread-multi|5.8.9|linux|2.6.18-92.1.18.el5|200906101411
4145180|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Generator|0.37|s390x-linux-thread-multi|5.8.9|linux|2.6.16.60-0.31-default|200906101406
4145173|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-Article|0.36|s390x-linux-thread-multi|5.8.9|linux|2.6.16.60-0.31-default|200906101406
4145135|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Generator|0.37|s390-linux|5.8.8|linux|2.6.5-7.315-s390|200906101403
4144807|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Mailer|0.17|s390x-linux-thread-multi|5.10.0|linux|2.6.18-92.el5|200906101342
4144704|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Release|0.01|s390-linux-thread-multi|5.8.9|linux|2.6.5-7.315-s390|200906101332
4144584|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Release|0.01|s390x-linux-thread-multi|5.8.9|linux|2.6.16.60-0.31-default|200906101304
4144571|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Release|0.01|s390x-linux|5.8.9|linux|2.6.18-92.1.18.el5|200906101302
4144507|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Generator|0.37|s390x-linux-thread-multi|5.8.8|linux|2.6.27.19-5-default|200906101251
4144504|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-Article|0.36|s390x-linux-thread-multi|5.8.8|linux|2.6.27.19-5-default|200906101251
4144371|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Generator|0.37|s390-linux|5.8.9|linux|2.6.5-7.315-s390|200906101240
4144243|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Release|0.01|s390x-linux-thread-multi|5.8.8|linux|2.6.18-92.1.18.el5|200906101230
4144048|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Release|0.01|s390-linux|5.8.8|linux|2.6.5-7.315-s390|200906101217
4144044|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Generator|0.37|s390x-linux|5.8.8|linux|2.6.27.19-5-default|200906101217
4144042|pass|200906|bingos@cpan.org|CPAN-Testers-WWW-Reports-Parser|0.01|alpha-linux-thread-multi|5.8.8|linux|2.6.18-5-alpha-generic|200906101117
4144034|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-Article|0.36|s390x-linux|5.8.8|linux|2.6.27.19-5-default|200906101216
4144025|pass|200906|bingos@cpan.org|CPAN-Testers-Data-Release|0.01|alpha-linux-thread-multi|5.8.8|linux|2.6.18-5-alpha-generic|200906101116
4144015|pass|200906|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|alpha-linux-thread-multi|5.8.8|linux|2.6.18-5-alpha-generic|200906101116
4144008|pass|200906|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|alpha-linux-thread-multi|5.8.8|linux|2.6.18-5-alpha-generic|200906101116
4143957|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Release|0.01|s390x-linux|5.8.8|linux|2.6.18-92.1.18.el5|200906101212
4143490|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Release|0.01|s390x-linux-thread-multi|5.8.8|linux|2.6.16.60-0.31-default|200906101126
4143472|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Release|0.01|s390x-linux-thread-multi|5.8.8|linux|2.6.27.19-5-default|200906101123
4143294|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Release|0.01|s390-linux|5.8.9|linux|2.6.5-7.315-s390|200906101108
4142986|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Release|0.01|s390x-linux|5.8.9|linux|2.6.16.60-0.31-default|200906101047
4142981|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Release|0.01|s390x-linux|5.8.8|linux|2.6.27.19-5-default|200906101047
4142622|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Generator|0.37|s390x-linux-thread-multi|5.8.9|linux|2.6.27.19-5-default|200906101018
4142409|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Release|0.01|s390x-linux|5.8.8|linux|2.6.16.60-0.31-default|200906100959
4141877|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Generator|0.37|s390x-linux|5.8.9|linux|2.6.27.19-5-default|200906100920
4141659|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Release|0.01|s390x-linux-thread-multi|5.8.9|linux|2.6.27.19-5-default|200906100854
4141599|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Generator|0.37|s390-linux-thread-multi|5.10.0|linux|2.6.5-7.315-s390|200906100846
4141551|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Generator|0.37|s390-linux|5.10.0|linux|2.6.5-7.315-s390|200906100837
4141496|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Release|0.01|s390x-linux|5.8.9|linux|2.6.27.19-5-default|200906100828
4141387|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Generator|0.37|s390x-linux-thread-multi|5.10.0|linux|2.6.27.19-5-default|200906100815
4141316|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Release|0.01|s390x-linux-thread-multi|5.10.0|linux|2.6.18-92.el5|200906100804
4141280|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Generator|0.37|s390x-linux|5.10.0|linux|2.6.27.19-5-default|200906100757
4141209|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Release|0.01|s390-linux-thread-multi|5.10.0|linux|2.6.5-7.315-s390|200906100747
4141177|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Release|0.01|s390x-linux|5.10.0|linux|2.6.18-92.el5|200906100741
4141168|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Release|0.01|s390-linux|5.10.0|linux|2.6.5-7.315-s390|200906100739
4141071|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Release|0.01|s390x-linux-thread-multi|5.10.0|linux|2.6.27.19-5-default|200906100720
4141038|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Release|0.01|s390x-linux-thread-multi|5.10.0|linux|2.6.16.60-0.31-default|200906100710
4141037|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Release|0.01|s390x-linux|5.10.0|linux|2.6.27.19-5-default|200906100710
4140816|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Release|0.01|s390x-linux|5.10.0|linux|2.6.16.60-0.31-default|200906100621
4140372|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Parser|0.01|s390-linux-thread-multi|5.8.9|linux|2.6.5-7.315-s390|200906100444
4140354|pass|200906|bingos@cpan.org|CPAN-Testers-WWW-Reports-Parser|0.01|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0.1|200906100338
4140352|pass|200906|bingos@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.17|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0.1|200906100338
4140341|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Parser|0.01|s390x-linux-thread-multi|5.8.9|linux|2.6.16.60-0.31-default|200906100436
4140323|pass|200906|bingos@cpan.org|CPAN-Testers-Data-Release|0.01|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0.1|200906100332
4140316|pass|200906|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0.1|200906100329
4140314|pass|200906|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0.1|200906100328
4140281|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Parser|0.01|s390x-linux-thread-multi|5.8.9|linux|2.6.27.19-5-default|200906100422
4140274|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Parser|0.01|s390x-linux-thread-multi|5.8.9|linux|2.6.18-92.1.18.el5|200906100421
4140263|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Parser|0.01|s390-linux|5.8.9|linux|2.6.5-7.315-s390|200906100420
4140208|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Parser|0.01|s390x-linux-thread-multi|5.8.8|linux|2.6.27.19-5-default|200906100410
4140153|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Parser|0.01|s390x-linux|5.8.9|linux|2.6.27.19-5-default|200906100401
4140144|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Parser|0.01|s390-linux|5.8.8|linux|2.6.5-7.315-s390|200906100359
4140100|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Parser|0.01|s390x-linux|5.8.9|linux|2.6.18-92.1.18.el5|200906100350
4140082|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Parser|0.01|s390x-linux-thread-multi|5.8.8|linux|2.6.18-92.1.18.el5|200906100348
4140064|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Parser|0.01|s390x-linux|5.8.8|linux|2.6.27.19-5-default|200906100345
4139994|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Parser|0.01|s390x-linux-thread-multi|5.8.8|linux|2.6.16.60-0.31-default|200906100336
4139846|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Parser|0.01|s390x-linux|5.8.8|linux|2.6.18-92.1.18.el5|200906100321
4139637|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Parser|0.01|s390x-linux-thread-multi|5.10.0|linux|2.6.27.19-5-default|200906100308
4139466|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Parser|0.01|s390x-linux|5.10.0|linux|2.6.27.19-5-default|200906100258
4139453|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Parser|0.01|s390-linux-thread-multi|5.10.0|linux|2.6.5-7.315-s390|200906100256
4139451|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Parser|0.01|s390x-linux-thread-multi|5.10.0|linux|2.6.18-92.el5|200906100256
4139403|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Parser|0.01|s390-linux|5.10.0|linux|2.6.5-7.315-s390|200906100253
4139388|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Parser|0.01|s390x-linux|5.8.9|linux|2.6.16.60-0.31-default|200906100252
4139296|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Parser|0.01|s390x-linux-thread-multi|5.10.0|linux|2.6.16.60-0.31-default|200906100245
4139279|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Parser|0.01|s390x-linux|5.10.0|linux|2.6.18-92.el5|200906100242
4139066|pass|200906|angryxpeh@gmail.com|CPAN-Testers-WWW-Reports-Parser|0.01|i686-linux|5.10.0|linux|2.6.26-2-686|200906100019
4138990|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Parser|0.01|s390x-linux|5.8.8|linux|2.6.16.60-0.31-default|200906100229
4138860|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Parser|0.01|s390x-linux|5.10.0|linux|2.6.16.60-0.31-default|200906100219
4138440|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Parser|0.01|s390x-linux-thread-multi|5.6.2|linux|2.6.18-92.1.18.el5|200906100120
4138437|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Parser|0.01|s390x-linux-thread-multi|5.6.2|linux|2.6.16.60-0.31-default|200906100120
4138392|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Parser|0.01|s390x-linux-thread-multi-perlio|5.6.2|linux|2.6.27.19-5-default|200906100115
4138300|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Parser|0.01|s390x-linux-thread-multi|5.6.2|linux|2.6.27.19-5-default|200906100103
4137926|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Parser|0.01|s390-linux-thread-multi-perlio|5.6.2|linux|2.6.5-7.315-s390|200906100016
4137901|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Parser|0.01|s390-linux-thread-multi|5.6.2|linux|2.6.5-7.315-s390|200906100013
4137793|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Parser|0.01|s390x-linux|5.6.2|linux|2.6.16.60-0.31-default|200906100001
4137779|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Parser|0.01|s390-linux|5.6.2|linux|2.6.5-7.315-s390|200906100000
4137773|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Parser|0.01|s390x-linux|5.6.2|linux|2.6.18-92.1.18.el5|200906100000
4137737|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Parser|0.01|s390x-linux|5.6.2|linux|2.6.27.19-5-default|200906092353
4137714|pass|200906|srezic@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.17|amd64-freebsd-thread-multi|5.10.0|freebsd|7.0-release|200906092344
4136377|pass|200906|bingos@cpan.org|CPAN-Testers-Data-Release|0.01|darwin-64int-2level|5.8.7|darwin|8.11.0|200906091703
4136374|pass|200906|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|darwin-64int-2level|5.8.7|darwin|8.11.0|200906091703
4136372|pass|200906|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|darwin-64int-2level|5.8.7|darwin|8.11.0|200906091702
4136364|fail|200906|ivan.wills@gmail.com ("Ivan Wills")|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.28-11-generic|200906100159
4136360|fail|200906|ivan.wills@gmail.com ("Ivan Wills")|WWW-Scraper-ISBN-Amazon_Driver|0.14|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.28-11-generic|200906100158
4135489|pass|200906|david@cantrell.org.uk|CPAN-Testers-WWW-Reports-Parser|0.01|alpha-netbsd|5.10.0|netbsd|4.0.1|200906091351
4135467|pass|200906|david@cantrell.org.uk|CPAN-Testers-WWW-Reports-Parser|0.01|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200906090849
4135338|pass|200906|david@cantrell.org.uk|CPAN-Testers-WWW-Reports-Parser|0.01|IP35-irix-64int|5.8.8|irix|6.5|200906091532
4135304|pass|200906|david@cantrell.org.uk|CPAN-Testers-WWW-Reports-Parser|0.01|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200906091426
4135248|pass|200906|david@cantrell.org.uk|CPAN-Testers-WWW-Reports-Parser|0.01|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200906091416
4135244|pass|200906|david@cantrell.org.uk|CPAN-Testers-WWW-Reports-Parser|0.01|x86_64-linux-thread-multi|5.10.0|linux|2.6.18-4-xen-amd64|200906091416
4135231|pass|200906|david@cantrell.org.uk|CPAN-Testers-WWW-Reports-Parser|0.01|x86_64-linux-thread-multi|5.8.9|linux|2.6.18-4-xen-amd64|200906091414
4135223|pass|200906|david@cantrell.org.uk|CPAN-Testers-WWW-Reports-Parser|0.01|x86_64-linux-thread-multi|5.6.2|linux|2.6.18-4-xen-amd64|200906091413
4135098|pass|200906|martin.evans@easysoft.com|CPAN-Testers-Data-Generator|0.37|i686-linux|5.10.0|linux|2.6.24-24-generic|200906091326
4135097|pass|200906|martin.evans@easysoft.com|CPAN-Testers-Common-Article|0.36|i686-linux|5.10.0|linux|2.6.24-24-generic|200906091326
4135062|pass|200906|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.65|i686-linux-thread-multi-64int|5.10.0|linux|2.6.28-11-generic|200906091315
4135060|pass|200906|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.64|i686-linux-thread-multi-64int|5.10.0|linux|2.6.28-11-generic|200906091315
4135056|pass|200906|bingos@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.17|i686-linux-thread-multi-64int|5.10.0|linux|2.6.28-11-generic|200906091313
4135053|pass|200906|bingos@cpan.org|CPAN-Testers-Data-Release|0.01|i686-linux-thread-multi-64int|5.10.0|linux|2.6.28-11-generic|200906091312
4135048|pass|200906|martin.evans@easysoft.com|CPAN-Testers-Data-Release|0.01|i686-linux|5.10.0|linux|2.6.24-24-generic|200906091311
4135047|pass|200906|martin.evans@easysoft.com|CPAN-Testers-Common-DBUtils|0.03|i686-linux|5.10.0|linux|2.6.24-24-generic|200906091311
4135045|pass|200906|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi-64int|5.10.0|linux|2.6.28-11-generic|200906091311
4135044|pass|200906|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i686-linux-thread-multi-64int|5.10.0|linux|2.6.28-11-generic|200906091311
4134992|pass|200906|vpit@cpan.org|Test-YAML-Meta|0.12|i686-linux-thread-multi|5.10.0|linux|2.6.18.3-tmb-desktop-2mdvsmp|200906091356
4134591|pass|200906|martin.evans@easysoft.com|CPAN-Testers-WWW-Reports-Parser|0.01|i686-linux|5.10.0|linux|2.6.24-24-generic|200906091101
4134520|pass|200906|bingos@cpan.org|Test-YAML-Meta|0.12|darwin-64int-2level|5.8.6|darwin|8.11.0|200906091042
4134516|pass|200906|JOST@cpan.org ("Josts Smokehouse")|CPAN-Testers-WWW-Reports-Parser|0.01|i86pc-solaris-64int|5.8.9|solaris|2.11|200906091140
4134319|pass|200906|imacat@mail.imacat.idv.tw|CPAN-Testers-WWW-Reports-Parser|0.01|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-2-amd64|200906091632
4134215|pass|200906|JOST@cpan.org ("Josts Smokehouse")|CPAN-Testers-WWW-Reports-Parser|0.01|i86pc-solaris-64int|5.10.0|solaris|2.11|200906090956
4133789|pass|200906|rbo@cpan.org|CPAN-Testers-WWW-Reports-Parser|0.01|i86pc-solaris|5.10.0|solaris|2.11|200906090834
4133662|pass|200906|srezic@cpan.org|CPAN-Testers-Data-Generator|0.37|amd64-freebsd-thread-multi|5.10.0|freebsd|7.0-release|200906090810
4133603|pass|200906|stro@cpan.org|Data-Phrasebook-Loader-DBI|0.11|i686-linux|5.10.0|linux|2.6.26-2-686|200906090829
4133601|pass|200906|stro@cpan.org|Data-Phrasebook-Loader-Ini|0.10|i686-linux|5.10.0|linux|2.6.26-2-686|200906090829
4133600|pass|200906|stro@cpan.org|Data-Phrasebook-Loader-XML|0.12|i686-linux|5.10.0|linux|2.6.26-2-686|200906090829
4133596|pass|200906|stro@cpan.org|Mail-File|0.08|i686-linux|5.10.0|linux|2.6.26-2-686|200906090828
4133371|fail|200906|stro@cpan.org|CPAN-YACSmoke-Plugin-WebList|0.05|i686-linux|5.10.0|linux|2.6.26-2-686|200906090722
4133370|pass|200906|stro@cpan.org|CPAN-YACSmoke-Plugin-NNTP|0.05|i686-linux|5.10.0|linux|2.6.26-2-686|200906090722
4133369|pass|200906|stro@cpan.org|CPAN-YACSmoke-Plugin-NNTPWeb|0.06|i686-linux|5.10.0|linux|2.6.26-2-686|200906090722
4132886|pass|200906|ivan.wills@gmail.com ("Ivan Wills")|CPAN-Testers-WWW-Reports-Mailer|0.17|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-19-server|200906091316
4132878|pass|200906|ivan.wills@gmail.com ("Ivan Wills")|CPAN-Testers-WWW-Statistics|0.65|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-19-server|200906091314
4132851|pass|200906|bingos@cpan.org|Test-YAML-Meta|0.12|i386-midnightbsd-64int|5.8.9|midnightbsd|0.1.1-release|200906090301
4132627|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Uploads|0.06|s390-linux|5.8.9|linux|2.6.5-7.315-s390|200906090416
4132620|pass|200906|ivan.wills@gmail.com ("Ivan Wills")|CPAN-Testers-Data-Generator|0.37|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-19-server|200906091215
4132522|pass|200906|ivan.wills@gmail.com ("Ivan Wills")|CPAN-Testers-Data-Release|0.01|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-19-server|200906091154
4132447|pass|200906|bingos@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.17|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.1-release|200906090229
4132422|pass|200906|bingos@cpan.org|CPAN-Testers-Data-Release|0.01|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.1-release|200906090222
4132414|pass|200906|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.1-release|200906090221
4132411|pass|200906|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.1-release|200906090221
4132345|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-Article|0.36|s390-linux|5.8.9|linux|2.6.5-7.315-s390|200906090313
4132310|pass|200906|ivan.wills@gmail.com ("Ivan Wills")|CPAN-Testers-WWW-Reports-Parser|0.01|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-19-server|200906091110
4132068|pass|200906|ivan.wills@gmail.com ("Ivan Wills")|CPAN-Testers-WWW-Reports-Parser|0.01|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.28-11-generic|200906091030
4131833|pass|200906|srezic@cpan.org|CPAN-Testers-Data-Release|0.01|amd64-freebsd-thread-multi|5.10.0|freebsd|7.0-release|200906090134
4131469|pass|200906|JOST@cpan.org ("Josts Smokehouse")|CPAN-Testers-WWW-Reports-Mailer|0.17|i86pc-solaris-64int|5.8.9|solaris|2.11|200906090006
4131442|pass|200906|srezic@cpan.org|CPAN-Testers-WWW-Reports-Parser|0.01|amd64-freebsd|5.8.8|freebsd|7.0-release|200906082325
4131415|pass|200906|JOST@cpan.org ("Josts Smokehouse")|CPAN-Testers-WWW-Statistics|0.65|i86pc-solaris-64int|5.8.9|solaris|2.11|200906090001
4131251|pass|200906|srezic@cpan.org|CPAN-Testers-WWW-Reports-Parser|0.01|amd64-freebsd|5.8.9|freebsd|7.0-release|200906082325
4131230|pass|200906|mw487.yahoo.com@gmail.com|CPAN-Testers-Data-Release|0.01|cygwin-thread-multi-64int|5.10.0 patch 34065|cygwin|1.5.25(0.15642)|200906081629
4131150|pass|200906|JOST@cpan.org ("Josts Smokehouse")|CPAN-Testers-Data-Generator|0.37|i86pc-solaris-64int|5.8.9|solaris|2.11|200906082320
4131083|pass|200906|JOST@cpan.org ("Josts Smokehouse")|CPAN-Testers-Data-Release|0.01|i86pc-solaris-64int|5.8.9|solaris|2.11|200906082308
4129686|pass|200906|bingos@cpan.org|Test-YAML-Meta|0.12|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.1-release|200906081841
4129101|pass|200906|stro@rail.org.ua|GD-Chart-Radial|0.07|i686-linux|5.10.0|linux|2.6.26-2-686|200906082256
4128792|pass|200906|stro@cpan.org|CPAN-Testers-Data-Release|0.01|i686-linux|5.8.9|linux|2.6.26-2-686|200906082235
4128752|pass|200906|stro@cpan.org|CPAN-Testers-Data-Generator|0.37|i686-linux|5.8.9|linux|2.6.26-2-686|200906082232
4128667|pass|200906|stro@cpan.org|CPAN-Testers-WWW-Statistics|0.65|i686-linux|5.8.9|linux|2.6.26-2-686|200906082227
4128656|pass|200906|stro@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.17|i686-linux|5.8.9|linux|2.6.26-2-686|200906082227
4128321|pass|200906|schwern@pobox.com|Test-YAML-Meta|0.12|darwin-thread-multi-2level|5.10.0|darwin|8.11.1|200906080158
4127676|pass|200906|JOST@cpan.org ("Josts Smokehouse")|CPAN-Testers-WWW-Reports-Mailer|0.17|i86pc-solaris-64int|5.10.0|solaris|2.11|200906081738
4127665|pass|200906|JOST@cpan.org ("Josts Smokehouse")|CPAN-Testers-WWW-Statistics|0.65|i86pc-solaris-64int|5.10.0|solaris|2.11|200906081737
4127186|pass|200906|JOST@cpan.org ("Josts Smokehouse")|CPAN-Testers-Data-Generator|0.37|i86pc-solaris-64int|5.10.0|solaris|2.11|200906081647
4127138|pass|200906|JOST@cpan.org ("Josts Smokehouse")|CPAN-Testers-Data-Release|0.01|i86pc-solaris-64int|5.10.0|solaris|2.11|200906081628
4127078|cpan|200906|BARBIE|CPAN-Testers-WWW-Reports-Parser|0.01||0|||200906081617
4126695|pass|200906|stro@rail.org.ua|Finance-Currency-Convert-XE|0.15|i686-linux|5.10.0|linux|2.6.26-2-686|200906081947
4126461|pass|200906|stro@rail.org.ua|Data-FormValidator-Constraints-Words|0.03|i686-linux|5.10.0|linux|2.6.26-2-686|200906081936
4125616|pass|200906|stro@cpan.org|CPAN-Testers-Data-Release|0.01|i686-linux|5.10.0|linux|2.6.26-2-686|200906081851
4125319|pass|200906|david@cantrell.org.uk|CPAN-Testers-Data-Release|0.01|alpha-netbsd|5.10.0|netbsd|4.0.1|200906081237
4125316|pass|200906|david@cantrell.org.uk|CPAN-Testers-Data-Release|0.01|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200906080737
4125306|pass|200906|david@cantrell.org.uk|CPAN-Testers-Data-Generator|0.37|alpha-netbsd|5.10.0|netbsd|4.0.1|200906081236
4125301|pass|200906|david@cantrell.org.uk|CPAN-Testers-Data-Generator|0.37|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200906080736
4125185|pass|200906|stro@rail.org.ua|Games-Trackword|1.06|i686-linux|5.10.0|linux|2.6.26-2-686|200906081825
4125184|pass|200906|stro@rail.org.ua|Calendar-List|0.21|i686-linux|5.10.0|linux|2.6.26-2-686|200906081825
4125101|pass|200906|david@cantrell.org.uk|CPAN-Testers-Data-Release|0.01|IP35-irix-64int|5.8.8|irix|6.5|200906081421
4125094|pass|200906|david@cantrell.org.uk|CPAN-Testers-Data-Generator|0.37|IP35-irix-64int|5.8.8|irix|6.5|200906081421
4125053|pass|200906|rafl@debian.org|Test-CPAN-Meta|0.13|i686-linux|5.10.0|linux|2.6.28.7|200906081417
4124989|pass|200906|david@cantrell.org.uk|CPAN-Testers-Data-Release|0.01|x86_64-linux-thread-multi|5.10.0|linux|2.6.18-4-xen-amd64|200906081313
4124987|pass|200906|david@cantrell.org.uk|CPAN-Testers-Data-Release|0.01|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200906081313
4124984|pass|200906|david@cantrell.org.uk|CPAN-Testers-Data-Generator|0.37|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200906081313
4124947|pass|200906|david@cantrell.org.uk|CPAN-Testers-Data-Release|0.01|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200906081310
4124945|pass|200906|david@cantrell.org.uk|CPAN-Testers-Data-Generator|0.37|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200906081309
4124781|fail|200906|stro@rail.org.ua|WWW-Scraper-ISBN-ORA_Driver|0.09|i686-linux|5.10.0|linux|2.6.26-2-686|200906081751
4124780|pass|200906|stro@rail.org.ua|WWW-Scraper-ISBN-Pearson_Driver|0.10|i686-linux|5.10.0|linux|2.6.26-2-686|200906081751
4124496|pass|200906|srezic@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.17|amd64-freebsd|5.10.0|freebsd|7.0-release|200906081223
4124494|pass|200906|srezic@cpan.org|CPAN-Testers-WWW-Statistics|0.65|amd64-freebsd|5.10.0|freebsd|7.0-release|200906081221
4124182|pass|200906|imacat@mail.imacat.idv.tw|CPAN-Testers-Data-Release|0.01|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-2-amd64|200906081714
4124180|pass|200906|imacat@mail.imacat.idv.tw|CPAN-Testers-Data-Generator|0.37|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-2-amd64|200906081712
4123770|pass|200906|rbo@cpan.org|CPAN-Testers-Data-Release|0.01|i86pc-solaris|5.10.0|solaris|2.11|200906080834
4123766|pass|200906|rbo@cpan.org|CPAN-Testers-Common-Article|0.36|i86pc-solaris|5.10.0|solaris|2.11|200906080833
4122290|pass|200906|imacat@mail.imacat.idv.tw|CPAN-Testers-WWW-Statistics|0.65|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-2-amd64|200906080932
4121213|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|Data-FormValidator-Constraints-Words|0.03|s390x-linux|5.6.2|linux|2.6.27.19-5-default|200906072357
4121008|pass|200906|srezic@cpan.org|CPAN-Testers-Data-Generator|0.37|amd64-freebsd|5.10.0|freebsd|7.0-release|200906072304
4120844|pass|200906|srezic@cpan.org|CPAN-Testers-Data-Release|0.01|amd64-freebsd|5.8.8|freebsd|7.0-release|200906072159
4120659|pass|200906|srezic@cpan.org|CPAN-Testers-Data-Release|0.01|amd64-freebsd|5.8.9|freebsd|7.0-release|200906072159
4120082|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Mailer|0.17|s390-linux-thread-multi|5.8.9|linux|2.6.5-7.315-s390|200906071955
4119998|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Mailer|0.17|s390-linux|5.8.9|linux|2.6.5-7.315-s390|200906071925
4119823|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Mailer|0.17|s390-linux|5.8.8|linux|2.6.5-7.315-s390|200906071858
4119606|pass|200906|srezic@cpan.org|CPAN-Testers-Data-Release|0.01|amd64-freebsd|5.10.0|freebsd|7.0-release|200906071817
4119473|cpan|200906|BARBIE|CPAN-Testers-Data-Release|0.01||0|||200906071747
4119082|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Mailer|0.17|s390x-linux-thread-multi|5.8.8|linux|2.6.27.19-5-default|200906071637
4119006|pass|200906|stro@cpan.org|Parse-CPAN-Distributions|0.05|i686-linux|5.10.0|linux|2.6.26-2-686|200906071854
4119001|pass|200906|srezic@cpan.org|CPAN-Testers-Data-Generator|0.37|amd64-freebsd|5.8.8|freebsd|7.0-release|200906071626
4118991|pass|200906|srezic@cpan.org|CPAN-Testers-Data-Generator|0.37|amd64-freebsd|5.8.9|freebsd|7.0-release|200906071626
4118870|pass|200906|stro@rail.org.ua|WWW-UsePerl-Journal-Thread|0.12|i686-linux|5.10.0|linux|2.6.26-2-686|200906071838
4118843|pass|200906|stro@rail.org.ua|CPAN-WWW-Testers-Generator|0.30|i686-linux|5.10.0|linux|2.6.26-2-686|200906071835
4118713|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Mailer|0.17|s390x-linux|5.8.8|linux|2.6.27.19-5-default|200906071559
4117970|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Mailer|0.17|s390x-linux-thread-multi|5.8.9|linux|2.6.27.19-5-default|200906071449
4117931|pass|200906|bingos@cpan.org|Test-YAML-Meta|0.12|darwin-64int-2level|5.10.0|darwin|8.11.0|200906071344
4117911|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-DBUtils|0.03|s390x-linux-thread-multi|5.8.8|linux|2.6.27.19-5-default|200906071442
4117817|fail|200906|stro@rail.org.ua|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i686-linux|5.10.0|linux|2.6.26-2-686|200906071702
4117816|fail|200906|stro@rail.org.ua|WWW-Scraper-ISBN-Amazon_Driver|0.14|i686-linux|5.10.0|linux|2.6.26-2-686|200906071702
4117652|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Mailer|0.17|s390-linux-thread-multi|5.10.0|linux|2.6.5-7.315-s390|200906071425
4117441|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Mailer|0.17|s390-linux|5.10.0|linux|2.6.5-7.315-s390|200906071408
4117377|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|GD-Chart-Radial|0.07|s390x-linux|5.6.2|linux|2.6.16.60-0.31-default|200906071402
4116939|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Mailer|0.17|s390x-linux|5.8.9|linux|2.6.27.19-5-default|200906071327
4116695|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Mailer|0.17|s390x-linux|5.10.0|linux|2.6.27.19-5-default|200906071312
4116474|pass|200906|stro@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.17|i686-linux|5.8.8|linux|2.4.27-2-386|200906071336
4116404|pass|200906|stro@cpan.org|CPAN-Testers-WWW-Statistics|0.65|i686-linux|5.8.8|linux|2.4.27-2-386|200906071331
4116369|pass|200906|stro@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i686-linux|5.8.8|linux|2.4.27-2-386|200906071328
4116342|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Mailer|0.17|s390x-linux-thread-multi|5.10.0|linux|2.6.27.19-5-default|200906071248
4116290|pass|200906|stro@rail.org.ua|CPAN-Testers-WWW-Statistics|0.55|i686-linux|5.10.0|linux|2.6.26-2-686|200906071511
4116252|pass|200906|stro@rail.org.ua|Data-Phrasebook-Loader-YAML|0.09|i686-linux|5.10.0|linux|2.6.26-2-686|200906071508
4116251|pass|200906|stro@rail.org.ua|Data-Phrasebook|0.29|i686-linux|5.10.0|linux|2.6.26-2-686|200906071508
4115938|pass|200906|stsc@refcnt.org ("Steven Schubiger")|CPAN-Testers-Data-Generator|0.37|i686-linux-thread-multi|5.10.0|linux|2.6.18-14-ovz-686|200906071218
4115671|pass|200906|angryxpeh@gmail.com|CPAN-Testers-Common-Article|0.36|i686-linux|5.10.0|linux|2.6.26-2-686|200906071425
4115588|pass|200906|wiml@hhhh.org ("Wim Lewis")|Regexp-Log-Common|0.05|powerpc-netbsd-thread-multi|5.10.0|netbsd|5.0_rc3|200906070136
4115535|pass|200906|angryxpeh@gmail.com|App-Maisha-Plugin-PingFM|0.02|i686-linux|5.10.0|linux|2.6.26-2-686|200906071408
4115239|pass|200906|angryxpeh@gmail.com|App-Maisha|0.12|i686-linux|5.10.0|linux|2.6.26-2-686|200906071345
4115105|pass|200906|david@cantrell.org.uk|CPAN-Testers-WWW-Statistics|0.65|alpha-netbsd|5.10.0|netbsd|4.0.1|200906070858
4115046|cpan|200906|BARBIE|CPAN-Testers-Data-Generator|0.37||0|||200906071055
4115040|pass|200906|david@cantrell.org.uk|CPAN-Testers-WWW-Statistics|0.64|alpha-netbsd|5.10.0|netbsd|4.0.1|200906070854
4115018|pass|200906|david@cantrell.org.uk|CPAN-Testers-WWW-Statistics|0.65|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200906070352
4114991|pass|200906|david@cantrell.org.uk|CPAN-Testers-WWW-Statistics|0.64|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200906070350
4114827|pass|200906|david@cantrell.org.uk|CPAN-Testers-WWW-Statistics|0.65|x86_64-linux-thread-multi|5.8.9|linux|2.6.18-4-xen-amd64|200906070922
4114821|pass|200906|david@cantrell.org.uk|CPAN-Testers-WWW-Statistics|0.65|x86_64-linux-thread-multi|5.10.0|linux|2.6.18-4-xen-amd64|200906070920
4114817|pass|200906|david@cantrell.org.uk|CPAN-Testers-WWW-Statistics|0.65|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200906070919
4114811|pass|200906|david@cantrell.org.uk|CPAN-Testers-WWW-Statistics|0.64|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200906070919
4114786|pass|200906|david@cantrell.org.uk|CPAN-Testers-WWW-Statistics|0.65|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200906070916
4114776|pass|200906|david@cantrell.org.uk|CPAN-Testers-WWW-Statistics|0.64|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200906070915
4114148|pass|200906|rbo@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i86pc-solaris|5.10.0|solaris|2.11|200906070827
4113848|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook-Loader-Ini|0.10|s390x-linux|5.6.2|linux|2.6.18-92.1.18.el5|200906070724
4113842|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook-Loader-XML|0.12|s390x-linux|5.6.2|linux|2.6.18-92.1.18.el5|200906070722
4113831|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook-Loader-YAML|0.09|s390x-linux|5.6.2|linux|2.6.18-92.1.18.el5|200906070719
4113768|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|Mail-File|0.08|s390x-linux|5.6.2|linux|2.6.18-92.1.18.el5|200906070705
4113763|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|Regexp-Log-Common|0.05|s390x-linux|5.6.2|linux|2.6.18-92.1.18.el5|200906070704
4113754|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook|0.29|s390x-linux|5.6.2|linux|2.6.18-92.1.18.el5|200906070703
4113284|pass|200906|bingos@cpan.org|Test-YAML-Meta|0.12|i386-midnightbsd-64int|5.10.0|midnightbsd|0.1.1-release|200906070332
4112502|pass|200906|stro@cpan.org|Regexp-Log-Common|0.05|i686-linux|5.10.0|linux|2.6.26-2-686|200906070519
4111918|pass|200906|stsc@refcnt.org ("Steven Schubiger")|CPAN-Testers-WWW-Reports-Mailer|0.17|i686-linux-thread-multi|5.10.0|linux|2.6.18-14-ovz-686|200906070035
4111899|pass|200906|stsc@refcnt.org ("Steven Schubiger")|CPAN-Testers-WWW-Statistics|0.65|i686-linux-thread-multi|5.10.0|linux|2.6.18-14-ovz-686|200906070031
4111524|pass|200906|srezic@cpan.org|CPAN-Testers-WWW-Statistics|0.65|amd64-freebsd|5.8.9|freebsd|7.0-release|200906062229
4111306|pass|200906|srezic@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.17|amd64-freebsd|5.8.8|freebsd|7.0-release|200906062229
4111297|pass|200906|srezic@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.17|amd64-freebsd|5.8.9|freebsd|7.0-release|200906062229
4111160|pass|200906|stro@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i686-linux|5.10.0|linux|2.6.26-2-686|200906070242
4111000|pass|200906|srezic@cpan.org|CPAN-Testers-WWW-Statistics|0.65|amd64-freebsd|5.8.8|freebsd|7.0-release|200906062229
4110730|pass|200906|stro@cpan.org|WWW-UsePerl-Journal|0.22|i686-linux|5.10.0|linux|2.6.26-2-686|200906070131
4107364|pass|200906|stro@rail.org.ua|Test-YAML-Meta|0.12|i686-linux|5.10.0|linux|2.6.26-2-686|200906062140
4107361|pass|200906|stro@rail.org.ua|Test-CPAN-Meta|0.13|i686-linux|5.10.0|linux|2.6.26-2-686|200906062140
4107202|pass|200906|DCOLLINS@cpan.org|GD-Chart-Radial|0.07|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200906060819
4106458|pass|200906|DCOLLINS@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1257-g2b4f847|linux|2.6.30-020630rc7-generic|200906060814
4106453|pass|200906|DCOLLINS@cpan.org|Data-Phrasebook-Loader-Ini|0.10|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200906060814
4106451|pass|200906|DCOLLINS@cpan.org|Data-Phrasebook|0.29|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1257-g2b4f847|linux|2.6.30-020630rc7-generic|200906060814
4105413|pass|200906|DCOLLINS@cpan.org|CPAN-YACSmoke-Plugin-Outlook|0.06|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200906060808
4105410|pass|200906|DCOLLINS@cpan.org|CPAN-YACSmoke-Plugin-NNTP|0.05|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200906060808
4105408|pass|200906|DCOLLINS@cpan.org|CPAN-WWW-Testers-Generator|0.30|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1257-g2b4f847|linux|2.6.30-020630rc7-generic|200906060808
4103101|fail|200906|DCOLLINS@cpan.org|CPAN-YACSmoke-Plugin-WebList|0.05|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200906060755
4102696|cpan|200906|BARBIE|CPAN-Testers-WWW-Statistics|0.65||0|||200906061312
4102235|cpan|200906|BARBIE|CPAN-Testers-WWW-Statistics|0.64||0|||200906061230
4101842|cpan|200906|BARBIE|CPAN-Testers-WWW-Reports-Mailer|0.17||0|||200906061159
4100734|fail|200906|DCOLLINS@cpan.org|Finance-Currency-Convert-XE|0.15|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200906060805
4099946|pass|200906|DCOLLINS@cpan.org|Data-FormValidator-Constraints-Words|0.03|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906060642
4098933|pass|200906|DCOLLINS@cpan.org|Mail-Outlook|0.15|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1257-g2b4f847|linux|2.6.30-020630rc7-generic|200906060434
4097763|pass|200906|DCOLLINS@cpan.org|Data-FormValidator-Constraints-Words|0.03|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200906060232
4097506|pass|200906|DCOLLINS@cpan.org|Calendar-List|0.21|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200906060207
4097492|pass|200906|DCOLLINS@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1257-g2b4f847|linux|2.6.30-020630rc7-generic|200906060205
4097490|pass|200906|DCOLLINS@cpan.org|CPAN-Testers-Data-Generator|0.36|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1257-g2b4f847|linux|2.6.30-020630rc7-generic|200906060205
4095180|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|Games-Trackword|1.06|s390x-linux|5.6.2|linux|2.6.27.19-5-default|200906060118
4095175|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|Calendar-List|0.21|s390x-linux|5.6.2|linux|2.6.27.19-5-default|200906060118
4095090|pass|200906|DCOLLINS@cpan.org|Regexp-Log-Common|0.05|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1257-g2b4f847|linux|2.6.30-020630rc7-generic|200906051433
4092975|pass|200906|stro@cpan.org|WWW-UsePerl-Journal-Thread|0.12|x86_64-linux|5.10.0|linux|2.6.24.5-xeon-aufs20081006-grsec|200906051402
4092922|pass|200906|stro@cpan.org|CPAN-WWW-Testers-Generator|0.30|x86_64-linux|5.10.0|linux|2.6.24.5-xeon-aufs20081006-grsec|200906051400
4092686|pass|200906|DCOLLINS@cpan.org|Games-Trackword|1.06|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200906051417
4092613|pass|200906|wiml@hhhh.org ("Wim Lewis")|CPAN-Testers-WWW-Reports-Mailer|0.16|powerpc-netbsd-thread-multi|5.10.0|netbsd|5.0_rc3|200906051246
4092607|pass|200906|DCOLLINS@cpan.org|GD-Chart-Radial|0.07|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906051417
4092474|pass|200906|wiml@hhhh.org ("Wim Lewis")|CPAN-Testers-Common-DBUtils|0.03|powerpc-netbsd-thread-multi|5.10.0|netbsd|5.0_rc3|200906051239
4092036|fail|200906|DCOLLINS@cpan.org|Finance-Currency-Convert-XE|0.15|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200906051359
4091798|pass|200906|DCOLLINS@cpan.org|Data-FormValidator-Constraints-Words|0.03|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200906051412
4091795|pass|200906|DCOLLINS@cpan.org|Data-FormValidator-Constraints-Words|0.03|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200906051412
4091081|pass|200906|DCOLLINS@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.16|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1257-g2b4f847|linux|2.6.30-020630rc7-generic|200906051407
4091078|pass|200906|DCOLLINS@cpan.org|CPAN-Testers-Data-Uploads|0.06|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1257-g2b4f847|linux|2.6.30-020630rc7-generic|200906051407
4091076|pass|200906|DCOLLINS@cpan.org|CPAN-Testers-Data-Generator|0.35|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1257-g2b4f847|linux|2.6.30-020630rc7-generic|200906051407
4091073|pass|200906|DCOLLINS@cpan.org|CPAN-Testers-Common-Article|0.36|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1257-g2b4f847|linux|2.6.30-020630rc7-generic|200906051407
4090051|fail|200906|DCOLLINS@cpan.org|Finance-Currency-Convert-XE|0.15|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200906051359
4088957|pass|200906|martin.evans@easysoft.com|Test-CPAN-Meta|0.13|i686-linux|5.10.0|linux|2.6.24-24-generic|200906051618
4088956|pass|200906|martin.evans@easysoft.com|Test-YAML-Meta|0.12|i686-linux|5.10.0|linux|2.6.24-24-generic|200906051618
4087366|pass|200906|srezic@cpan.org|Test-CPAN-Meta|0.13|amd64-freebsd|5.6.2|freebsd|7.0-release|200906051046
4086545|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-YACSmoke-Plugin-Outlook|0.06|s390x-linux|5.6.2|linux|2.6.18-92.1.18.el5|200906050751
4085940|pass|200906|ipenburg@xs4all.nl ("Roland van Ipenburg")|Test-YAML-Meta|0.12|darwin-2level|5.8.8|darwin|8.11.0|200906050551
4085677|fail|200906|DCOLLINS@cpan.org|Finance-Currency-Convert-XE|0.15|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906050320
4085212|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|Test-YAML-Meta|0.12|s390x-linux|5.8.9|linux|2.6.18-92.1.18.el5|200906050419
4085193|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.13|s390x-linux|5.8.9|linux|2.6.18-92.1.18.el5|200906050418
4084664|pass|200906|DCOLLINS@cpan.org|Calendar-List|0.21|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200906050114
4084542|pass|200906|wiml@hhhh.org ("Wim Lewis")|WWW-UsePerl-Journal|0.22|powerpc-netbsd-thread-multi|5.10.0|netbsd|5.0_rc3|200906050103
4083995|pass|200906|DCOLLINS@cpan.org|Test-CPAN-Meta|0.13|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1257-g2b4f847|linux|2.6.30-020630rc7-generic|200906050013
4083876|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|Test-YAML-Meta|0.12|s390x-linux|5.8.8|linux|2.6.18-92.1.18.el5|200906050201
4083866|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.13|s390x-linux|5.8.8|linux|2.6.18-92.1.18.el5|200906050200
4083628|pass|200906|DCOLLINS@cpan.org|Games-Trackword|1.06|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200906041406
4083627|pass|200906|DCOLLINS@cpan.org|Games-Trackword|1.06|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200906041406
4083597|pass|200906|ipenburg@xs4all.nl ("Roland van Ipenburg")|Test-YAML-Meta|0.12|darwin-2level|5.10.0|darwin|8.11.0|200906050138
4083402|pass|200906|DCOLLINS@cpan.org|Calendar-List|0.21|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200906041403
4082533|pass|200906|DCOLLINS@cpan.org|Parse-CPAN-Distributions|0.05|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200906042234
4082324|fail|200906|DCOLLINS@cpan.org|WWW-Scraper-ISBN-ORA_Driver|0.09|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906042221
4082297|fail|200906|DCOLLINS@cpan.org|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1049-g5f1c709|linux|2.6.28-11-generic|200906042219
4080407|pass|200906|DCOLLINS@cpan.org|Games-Trackword|1.06|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906041406
4080054|pass|200906|DCOLLINS@cpan.org|Calendar-List|0.21|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906041403
4079845|fail|200906|DCOLLINS@cpan.org|WWW-Scraper-ISBN-ORA_Driver|0.09|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200906041401
4079376|pass|200906|DCOLLINS@cpan.org|WWW-UsePerl-Journal|0.22|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200906040721
4079369|pass|200906|DCOLLINS@cpan.org|WWW-UsePerl-Journal-Thread|0.12|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200906040721
4078926|pass|200906|DCOLLINS@cpan.org|Parse-CPAN-Distributions|0.05|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200906040713
4078676|pass|200906|bingos@cpan.org|Test-YAML-Meta|0.12|i686-linux-thread-multi-64int|5.8.8|linux|2.6.28-11-generic|200906041838
4078675|fail|200906|DCOLLINS@cpan.org|WWW-Scraper-ISBN-Pearson_Driver|0.10|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906040637
4078043|pass|200906|DCOLLINS@cpan.org|CPAN-WWW-Testers-Generator|0.30|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200906040641
4077456|pass|200906|DCOLLINS@cpan.org|WWW-UsePerl-Journal-Thread|0.12|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200906040721
4077454|pass|200906|DCOLLINS@cpan.org|WWW-UsePerl-Journal|0.22|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200906040721
4076524|pass|200906|DCOLLINS@cpan.org|Parse-CPAN-Distributions|0.05|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906040713
4075853|fail|200906|DCOLLINS@cpan.org|WWW-Scraper-ISBN-Pearson_Driver|0.10|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200906040637
4075851|fail|200906|DCOLLINS@cpan.org|WWW-Scraper-ISBN-Amazon_Driver|0.14|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1049-g5f1c709|linux|2.6.28-11-generic|200906040637
4075531|pass|200906|srezic@cpan.org|WWW-UsePerl-Journal|0.22|amd64-freebsd|5.6.2|freebsd|7.0-release|200906041508
4074193|pass|200906|DCOLLINS@cpan.org|CPAN-WWW-Testers-Generator|0.30|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200906040641
4073601|fail|200906|DCOLLINS@cpan.org|WWW-Scraper-ISBN-Pearson_Driver|0.10|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200906040637
4073599|fail|200906|DCOLLINS@cpan.org|WWW-Scraper-ISBN-Pearson_Driver|0.10|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200906040637
4073595|fail|200906|DCOLLINS@cpan.org|WWW-Scraper-ISBN-ORA_Driver|0.09|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200906040637
4073594|fail|200906|DCOLLINS@cpan.org|WWW-Scraper-ISBN-ORA_Driver|0.09|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200906040637
4069864|pass|200906|DCOLLINS@cpan.org|WWW-UsePerl-Journal-Thread|0.12|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906040043
4069726|pass|200906|DCOLLINS@cpan.org|Parse-CPAN-Distributions|0.05|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200906040023
4069299|fail|200906|DCOLLINS@cpan.org|WWW-Scraper-ISBN-Amazon_Driver|0.14|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200906032349
4069068|pass|200906|DCOLLINS@cpan.org|WWW-UsePerl-Journal|0.22|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906031705
4068379|pass|200906|DCOLLINS@cpan.org|CPAN-WWW-Testers-Generator|0.30|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200906031658
4068275|fail|200906|DCOLLINS@cpan.org|WWW-Scraper-ISBN-Amazon_Driver|0.14|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200906032237
4068091|pass|200906|DCOLLINS@cpan.org|WWW-UsePerl-Journal-Thread|0.12|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200906031705
4068087|pass|200906|DCOLLINS@cpan.org|WWW-UsePerl-Journal|0.22|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200906031705
4067252|pass|200906|DCOLLINS@cpan.org|CPAN-WWW-Testers-Generator|0.30|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906031658
4066714|fail|200906|DCOLLINS@cpan.org|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200906032019
4066645|pass|200906|DCOLLINS@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906032013
4065222|pass|200906|DCOLLINS@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1049-g5f1c709|linux|2.6.28-11-generic|200906030644
4064964|pass|200906|DCOLLINS@cpan.org|CPAN-Testers-Data-Generator|0.35|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1049-g5f1c709|linux|2.6.28-11-generic|200906030641
4063027|pass|200906|bminton@integ.com (Brian Minton)|Parse-CPAN-Distributions|0.05|cygwin-thread-multi-64int|5.10.0 patch 34065|cygwin|1.5.25(0.15642)|200906031047
4061345|fail|200906|DCOLLINS@cpan.org|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200906030638
4060692|pass|200906|DCOLLINS@cpan.org|Data-Phrasebook|0.29|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1049-g5f1c709|linux|2.6.28-11-generic|200906030644
4060216|pass|200906|DCOLLINS@cpan.org|CPAN-Testers-WWW-Statistics|0.55|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1049-g5f1c709|linux|2.6.28-11-generic|200906030641
4059563|fail|200906|DCOLLINS@cpan.org|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906030638
4059562|fail|200906|DCOLLINS@cpan.org|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200906030638
4059560|fail|200906|DCOLLINS@cpan.org|WWW-Scraper-ISBN-Amazon_Driver|0.14|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906030638
4059558|fail|200906|DCOLLINS@cpan.org|WWW-Scraper-ISBN-Amazon_Driver|0.14|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200906030638
4059338|pass|200906|DCOLLINS@cpan.org|Data-Phrasebook|0.29|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906031023
4059304|pass|200906|DCOLLINS@cpan.org|CPAN-Testers-WWW-Statistics|0.55|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200906031018
4059290|pass|200906|bingos@cpan.org|Test-YAML-Meta|0.12|i686-linux-thread-multi-64int|5.8.9|linux|2.6.28-11-generic|200906031116
4059157|pass|200906|DCOLLINS@cpan.org|CPAN-Testers-Data-Uploads|0.06|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200906031005
4058541|pass|200906|DCOLLINS@cpan.org|CPAN-Testers-WWW-Statistics|0.55|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200906030915
4058482|pass|200906|DCOLLINS@cpan.org|CPAN-Testers-Data-Generator|0.35|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200906030910
4058140|pass|200906|DCOLLINS@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.16|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200906030845
4058116|pass|200906|DCOLLINS@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1049-g5f1c709|linux|2.6.28-11-generic|200906030843
4057776|pass|200906|cpan@tenzobox.net ("Axel Bourgeois")|Test-YAML-Meta|0.12|i386-openbsd|5.10.0|openbsd|4.5|200906022342
4056591|pass|200906|DCOLLINS@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200906030712
4056584|pass|200906|DCOLLINS@cpan.org|Data-Phrasebook|0.29|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200906030711
4056463|pass|200906|DCOLLINS@cpan.org|CPAN-Testers-Data-Uploads|0.06|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1049-g5f1c709|linux|2.6.28-11-generic|200906030702
4056441|pass|200906|DCOLLINS@cpan.org|CPAN-Testers-Data-Generator|0.35|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200906030701
4055960|pass|200906|DCOLLINS@cpan.org|CPAN-Testers-Common-Article|0.36|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200906030623
4055389|pass|200906|DCOLLINS@cpan.org|CPAN-Testers-Data-Generator|0.36|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200906030545
4054073|pass|200906|DCOLLINS@cpan.org|Mail-Outlook|0.15|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1049-g5f1c709|linux|2.6.28-11-generic|200906030354
4053435|pass|200906|DCOLLINS@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200906030306
4053434|pass|200906|DCOLLINS@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200906030305
4053431|pass|200906|DCOLLINS@cpan.org|Data-Phrasebook|0.29|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200906030305
4053427|pass|200906|DCOLLINS@cpan.org|Data-Phrasebook|0.29|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200906030305
4053163|pass|200906|DCOLLINS@cpan.org|CPAN-Testers-WWW-Statistics|0.55|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906030244
4053162|pass|200906|DCOLLINS@cpan.org|CPAN-Testers-WWW-Statistics|0.55|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200906030244
4053160|pass|200906|DCOLLINS@cpan.org|CPAN-Testers-Data-Generator|0.36|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1049-g5f1c709|linux|2.6.28-11-generic|200906030244
4053159|pass|200906|DCOLLINS@cpan.org|CPAN-Testers-Data-Generator|0.35|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906030244
4053157|pass|200906|DCOLLINS@cpan.org|CPAN-Testers-Data-Generator|0.35|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200906030244
4053156|pass|200906|DCOLLINS@cpan.org|CPAN-Testers-Common-Article|0.36|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1049-g5f1c709|linux|2.6.28-11-generic|200906030243
4053004|pass|200906|DCOLLINS@cpan.org|CPAN-Testers-Data-Uploads|0.06|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200906030231
4052633|pass|200906|DCOLLINS@cpan.org|Mail-Outlook|0.15|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200906030201
4052164|pass|200906|DCOLLINS@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.16|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1049-g5f1c709|linux|2.6.28-11-generic|200906030125
4051298|pass|200906|DCOLLINS@cpan.org|CPAN-Testers-Common-Article|0.36|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200906030031
4050393|pass|200906|DCOLLINS@cpan.org|Mail-Outlook|0.15|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906021412
4049160|pass|200906|DCOLLINS@cpan.org|Regexp-Log-Common|0.05|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1049-g5f1c709|linux|2.6.28-11-generic|200906021418
4048643|pass|200906|DCOLLINS@cpan.org|Test-CPAN-Meta|0.12|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1049-g5f1c709|linux|2.6.28-11-generic|200906021420
4048409|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|GD-Chart-Radial|0.07|s390x-linux-thread-multi|5.6.2|linux|2.6.16.60-0.31-default|200906022319
4047583|pass|200906|DCOLLINS@cpan.org|Mail-Outlook|0.15|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200906021412
4047581|pass|200906|DCOLLINS@cpan.org|Mail-Outlook|0.15|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200906021412
4047219|pass|200906|cpan@sourcentral.org ("Oliver Paukstadt")|Parse-CPAN-Distributions|0.05|s390x-linux|5.6.2|linux|2.6.27.19-5-default|200906022145
4046415|pass|200906|DCOLLINS@cpan.org|CPAN-Testers-Data-Uploads|0.06|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906021401
4046413|pass|200906|DCOLLINS@cpan.org|CPAN-Testers-Data-Uploads|0.06|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200906021401
4046410|pass|200906|DCOLLINS@cpan.org|CPAN-Testers-Data-Generator|0.36|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906021401
4046409|pass|200906|DCOLLINS@cpan.org|CPAN-Testers-Data-Generator|0.36|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200906021401
4046406|pass|200906|DCOLLINS@cpan.org|CPAN-Testers-Data-Generator|0.36|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200906021401
4046403|pass|200906|DCOLLINS@cpan.org|CPAN-Testers-Common-Article|0.36|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906021401
4046399|pass|200906|DCOLLINS@cpan.org|CPAN-Testers-Common-Article|0.36|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200906021401
4045828|pass|200906|DCOLLINS@cpan.org|Test-CPAN-Meta|0.12|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200906020641
4044757|pass|200906|DCOLLINS@cpan.org|Regexp-Log-Common|0.05|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200906020639
4044742|pass|200906|DCOLLINS@cpan.org|Regexp-Log-Common|0.05|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200906020639
4043537|pass|200906|DCOLLINS@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200906020621
4043532|pass|200906|DCOLLINS@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906020621
4043303|pass|200906|chris@bingosnet.co.uk|Test-YAML-Meta|0.12|i686-linux|5.8.6|linux|2.4.18|200906021600
4042450|pass|200906|DCOLLINS@cpan.org|Test-CPAN-Meta|0.13|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1049-g5f1c709|linux|2.6.28-11-generic|200906020641
4042220|pass|200906|DCOLLINS@cpan.org|Regexp-Log-Common|0.05|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906020639
4042218|pass|200906|DCOLLINS@cpan.org|Regexp-Log-Common|0.05|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200906020639
4039610|pass|200906|DCOLLINS@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.16|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906020621
4039607|pass|200906|DCOLLINS@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.16|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200906020621
4039602|pass|200906|DCOLLINS@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200906020621
4036092|pass|200906|ivan.wills@gmail.com ("Ivan Wills")|Parse-CPAN-Distributions|0.05|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-19-server|200906021312
4035275|pass|200906|DCOLLINS@cpan.org|Test-CPAN-Meta|0.13|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200906020200
4034837|pass|200906|ivan.wills@gmail.com ("Ivan Wills")|WWW-UsePerl-Journal-Thread|0.12|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-19-server|200906021130
4034457|pass|200906|ivan.wills@gmail.com ("Ivan Wills")|CPAN-WWW-Testers-Generator|0.30|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-19-server|200906021103
4033198|pass|200906|DCOLLINS@cpan.org|Test-CPAN-Meta|0.13|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200906011820
4032133|pass|200906|DCOLLINS@cpan.org|Test-CPAN-Meta|0.13|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200906011509
4030579|pass|200906|DCOLLINS@cpan.org|Test-CPAN-Meta|0.13|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200906011509
4029512|pass|200906|DCOLLINS@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200906011501
4024998|pass|200906|bingos@cpan.org|Test-YAML-Meta|0.12|darwin-2level|5.10.0|darwin|8.11.0|200906011454
4024980|pass|200906|bingos@cpan.org|Test-CPAN-Meta|0.13|darwin-2level|5.10.0|darwin|8.11.0|200906011453
4024656|pass|200906|bingos@cpan.org|Test-YAML-Meta|0.12|i686-linux-thread-multi-64int|5.10.0|linux|2.6.28-11-generic|200906011418
4024650|pass|200906|bingos@cpan.org|Test-CPAN-Meta|0.13|i686-linux-thread-multi-64int|5.10.0|linux|2.6.28-11-generic|200906011418
4023357|pass|200906|andy@hexten.net|Test-YAML-Meta|0.12|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.28-11-generic|200906011129
4022717|pass|200906|chris@bingosnet.co.uk|Test-YAML-Meta|0.12|i386-freebsd-64int|5.8.6|freebsd|5.4-release|200906010953
4022223|fail|200906|ivan.wills@gmail.com ("Ivan Wills")|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-19-server|200906011718
4022215|fail|200906|ivan.wills@gmail.com ("Ivan Wills")|WWW-Scraper-ISBN-Amazon_Driver|0.14|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-19-server|200906011717
4019842|fail|200905|stro@cpan.org|WWW-Scraper-ISBN-Yahoo_Driver|0.08|x86_64-linux|5.8.9|linux|2.6.24.5-xeon-aufs20081006-grsec|200905311551
4019841|fail|200905|stro@cpan.org|WWW-Scraper-ISBN-Amazon_Driver|0.14|x86_64-linux|5.8.9|linux|2.6.24.5-xeon-aufs20081006-grsec|200905311551
4019761|pass|200906|chris@bingosnet.co.uk|Test-YAML-Meta|0.12|i686-linux-thread-multi-64int|5.10.0|linux|2.6.23.1-42.fc8|200906010040
4018489|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Games-Trackword|1.06|s390x-linux-thread-multi|5.8.8|linux|2.6.18-92.1.18.el5|200905312158
4018487|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Calendar-List|0.21|s390x-linux-thread-multi|5.8.8|linux|2.6.18-92.1.18.el5|200905312158
4018312|pass|200905|andy@hexten.net|Test-YAML-Meta|0.12|darwin-thread-multi-2level|5.10.0|darwin|9.2.2|200905312022
4018078|fail|200905|stro@cpan.org|WWW-Scraper-ISBN-Yahoo_Driver|0.08|x86_64-linux|5.10.0|linux|2.6.24.5-xeon-aufs20081006-grsec|200905311146
4018076|fail|200905|stro@cpan.org|WWW-Scraper-ISBN-Amazon_Driver|0.14|x86_64-linux|5.10.0|linux|2.6.24.5-xeon-aufs20081006-grsec|200905311146
4017978|pass|200906|ivan.wills@gmail.com ("Ivan Wills")|CPAN-Testers-WWW-Statistics|0.55|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.28-11-generic|200906010432
4017588|pass|200906|ivan.wills@gmail.com ("Ivan Wills")|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.28-11-generic|200906010309
4017587|pass|200906|ivan.wills@gmail.com ("Ivan Wills")|Data-Phrasebook|0.29|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.28-11-generic|200906010308
4017088|pass|200906|ivan.wills@gmail.com ("Ivan Wills")|CPAN-Testers-Data-Generator|0.35|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.28-11-generic|200906010126
4016194|pass|200905|stro@rail.org.ua|Data-Phrasebook-Loader-DBI|0.11|i686-linux|5.8.9|linux|2.6.26-2-686|200905311848
4016193|pass|200905|stro@rail.org.ua|Data-Phrasebook-Loader-Ini|0.10|i686-linux|5.8.9|linux|2.6.26-2-686|200905311848
4016189|pass|200905|stro@rail.org.ua|Mail-File|0.08|i686-linux|5.8.9|linux|2.6.26-2-686|200905311847
4016132|pass|200905|stro@rail.org.ua|CPAN-YACSmoke-Plugin-Outlook|0.06|i686-linux|5.8.9|linux|2.6.26-2-686|200905311843
4016130|fail|200905|stro@rail.org.ua|CPAN-YACSmoke-Plugin-WebList|0.05|i686-linux|5.8.9|linux|2.6.26-2-686|200905311843
4016129|pass|200905|stro@rail.org.ua|CPAN-YACSmoke-Plugin-NNTP|0.05|i686-linux|5.8.9|linux|2.6.26-2-686|200905311843
4016127|pass|200905|stro@rail.org.ua|CPAN-YACSmoke-Plugin-NNTPWeb|0.06|i686-linux|5.8.9|linux|2.6.26-2-686|200905311842
4013044|pass|200905|stro@cpan.org|CPAN-Testers-WWW-Statistics|0.55|x86_64-linux|5.8.9|linux|2.6.24.5-xeon-aufs20081006-grsec|200905310548
4013043|pass|200905|stro@cpan.org|CPAN-Testers-WWW-Statistics|0.55|x86_64-linux|5.10.0|linux|2.6.24.5-xeon-aufs20081006-grsec|200905310548
4012808|pass|200905|ivan.wills@gmail.com ("Ivan Wills")|CPAN-Testers-Data-Uploads|0.06|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.28-11-generic|200905311502
4012739|pass|200905|ivan.wills@gmail.com ("Ivan Wills")|CPAN-Testers-Common-Article|0.36|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.28-11-generic|200905311451
4012681|pass|200905|stro@cpan.org|Data-Phrasebook-Loader-YAML|0.09|x86_64-linux|5.8.9|linux|2.6.24.5-xeon-aufs20081006-grsec|200905310446
4012679|pass|200905|stro@cpan.org|Data-Phrasebook-Loader-YAML|0.09|x86_64-linux|5.10.0|linux|2.6.24.5-xeon-aufs20081006-grsec|200905310446
4012678|pass|200905|stro@cpan.org|Data-Phrasebook|0.29|x86_64-linux|5.8.9|linux|2.6.24.5-xeon-aufs20081006-grsec|200905310446
4012676|pass|200905|stro@cpan.org|Data-Phrasebook|0.29|x86_64-linux|5.10.0|linux|2.6.24.5-xeon-aufs20081006-grsec|200905310446
4012459|pass|200905|ivan.wills@gmail.com ("Ivan Wills")|App-Maisha|0.12|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.28-11-generic|200905311417
4012137|pass|200905|stro@cpan.org|CPAN-Testers-Data-Generator|0.35|x86_64-linux|5.8.9|linux|2.6.24.5-xeon-aufs20081006-grsec|200905310340
4012132|pass|200905|stro@cpan.org|CPAN-Testers-Data-Generator|0.35|x86_64-linux|5.10.0|linux|2.6.24.5-xeon-aufs20081006-grsec|200905310340
4009180|pass|200905|stro@cpan.org|CPAN-Testers-Data-Uploads|0.06|x86_64-linux|5.8.9|linux|2.6.24.5-xeon-aufs20081006-grsec|200905301517
4008681|pass|200905|ivan.wills@gmail.com ("Ivan Wills")|Mail-Outlook|0.15|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.28-11-generic|200905310713
4008486|pass|200905|stro@cpan.org|CPAN-Testers-Data-Uploads|0.06|x86_64-linux|5.10.0|linux|2.6.24.5-xeon-aufs20081006-grsec|200905301356
4008479|pass|200905|stro@cpan.org|CPAN-Testers-Data-Generator|0.36|x86_64-linux|5.8.9|linux|2.6.24.5-xeon-aufs20081006-grsec|200905301356
4008476|pass|200905|stro@cpan.org|CPAN-Testers-Common-Article|0.36|x86_64-linux|5.8.9|linux|2.6.24.5-xeon-aufs20081006-grsec|200905301356
4008454|pass|200905|stro@cpan.org|CPAN-Testers-Data-Generator|0.36|x86_64-linux|5.10.0|linux|2.6.24.5-xeon-aufs20081006-grsec|200905301355
4008452|pass|200905|stro@cpan.org|CPAN-Testers-Common-Article|0.36|x86_64-linux|5.10.0|linux|2.6.24.5-xeon-aufs20081006-grsec|200905301355
4008122|pass|200905|cpan@greerga.m-l.org ("George Greer")|Test-YAML-Meta|0.12|x86_64-linux|5.10.0|linux|2.6.28-11-generic|200905301625
4008117|pass|200905|cpan@greerga.m-l.org ("George Greer")|Test-CPAN-Meta|0.13|x86_64-linux|5.10.0|linux|2.6.28-11-generic|200905301625
4008041|pass|200905|cpan@greerga.m-l.org ("George Greer")|Test-YAML-Meta|0.12|x86_64-linux|5.11.0|linux|2.6.28-11-generic|200905301617
4008037|pass|200905|cpan@greerga.m-l.org ("George Greer")|Test-CPAN-Meta|0.13|x86_64-linux|5.11.0|linux|2.6.28-11-generic|200905301616
4007943|pass|200905|cpan@greerga.m-l.org ("George Greer")|Test-YAML-Meta|0.12|x86_64-linux|5.8.9 patch 35104|linux|2.6.28-11-generic|200905301604
4007939|pass|200905|cpan@greerga.m-l.org ("George Greer")|Test-CPAN-Meta|0.13|x86_64-linux|5.8.9 patch 35104|linux|2.6.28-11-generic|200905301604
4007869|pass|200905|DCOLLINS@cpan.org|Test-YAML-Meta|0.11|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200905301057
4005984|pass|200905|stro@cpan.org|App-Maisha|0.12|x86_64-linux|5.8.9|linux|2.6.24.5-xeon-aufs20081006-grsec|200905301043
4005854|pass|200905|DCOLLINS@cpan.org|Test-YAML-Meta|0.11|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1049-g5f1c709|linux|2.6.28-11-generic|200905301057
4005841|pass|200905|DCOLLINS@cpan.org|Test-YAML-Meta|0.11|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200905301057
4004514|pass|200905|DCOLLINS@cpan.org|Test-YAML-Meta|0.11|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200905301057
4004512|pass|200905|DCOLLINS@cpan.org|Test-YAML-Meta|0.11|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200905301057
4002201|pass|200905|stro@cpan.org|Test-YAML-Meta|0.11|i386-freebsd-64int|5.8.8|freebsd|7.0-release|200905301856
4001524|pass|200905|ivan.wills@gmail.com ("Ivan Wills")|CPAN-Testers-WWW-Reports-Mailer|0.16|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.28-11-generic|200905302124
4001518|pass|200905|ivan.wills@gmail.com ("Ivan Wills")|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.28-11-generic|200905302123
4001174|pass|200905|ivan.wills@gmail.com ("Ivan Wills")|WWW-UsePerl-Journal|0.22|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.28-11-generic|200905301952
4000495|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|GD-Chart-Radial|0.07|s390x-linux-thread-multi|5.10.0|linux|2.6.18-92.el5|200905301005
3999764|pass|200905|ivan.wills@gmail.com ("Ivan Wills")|Test-YAML-Meta|0.12|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-19-server|200905301711
3999759|pass|200905|ivan.wills@gmail.com ("Ivan Wills")|Test-CPAN-Meta|0.13|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-19-server|200905301710
3999748|pass|200905|ivan.wills@gmail.com ("Ivan Wills")|Test-YAML-Meta|0.12|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.28-11-generic|200905301707
3999742|pass|200905|ivan.wills@gmail.com ("Ivan Wills")|Test-CPAN-Meta|0.13|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.28-11-generic|200905301706
3999195|fail|200905|stro@cpan.org|Finance-Currency-Convert-XE|0.15|i686-linux|5.8.9|linux|2.6.26-2-686|200905300502
3999090|pass|200905|stro@cpan.org|Data-FormValidator-Constraints-Words|0.03|i686-linux|5.8.9|linux|2.6.26-2-686|200905300451
3997732|pass|200905|bingos@cpan.org|Test-YAML-Meta|0.12|darwin-thread-multi-2level|5.8.9|darwin|8.11.0|200905300131
3997717|pass|200905|bingos@cpan.org|Test-CPAN-Meta|0.13|darwin-thread-multi-2level|5.8.9|darwin|8.11.0|200905300128
3997522|pass|200905|bingos@cpan.org|Test-YAML-Meta|0.12|i386-freebsd|5.10.0|freebsd|6.4-release|200905300046
3997510|pass|200905|bingos@cpan.org|Test-CPAN-Meta|0.13|i386-freebsd|5.10.0|freebsd|6.4-release|200905300045
3995793|pass|200905|jafelds@gmail.com|Test-YAML-Meta|0.12|x86_64-linux-gnu-thread-multi|5.10.0|linux|2.6.24-16-server|200905281253
3995488|pass|200905|ivan.wills@gmail.com ("Ivan Wills")|Regexp-Log-Common|0.05|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.28-11-generic|200905300157
3995451|pass|200905|gardnerm@gsicommerce.com|Test-YAML-Meta|0.12|x86_64-linux-thread-multi|5.10.0|linux|2.6.18-53.el5|200905281324
3995389|pass|200905|bingos@cpan.org|Test-YAML-Meta|0.12|i686-linux|5.8.6|linux|2.4.20|200905291634
3995000|pass|200905|stro@cpan.org|Games-Trackword|1.06|i686-linux|5.8.9|linux|2.6.26-2-686|200905291454
3994999|pass|200905|stro@cpan.org|Calendar-List|0.21|i686-linux|5.8.9|linux|2.6.26-2-686|200905291454
3994351|fail|200905|stro@rail.org.ua|WWW-Scraper-ISBN-ORA_Driver|0.09|i686-linux|5.8.9|linux|2.6.26-2-686|200905291332
3994349|pass|200905|stro@rail.org.ua|WWW-Scraper-ISBN-Pearson_Driver|0.10|i686-linux|5.8.9|linux|2.6.26-2-686|200905291332
3993933|pass|200905|JOST@cpan.org ("Josts Smokehouse")|Test-YAML-Meta|0.12|i86pc-solaris-64int|5.10.0|solaris|2.11|200905291358
3993930|pass|200905|JOST@cpan.org ("Josts Smokehouse")|Test-CPAN-Meta|0.13|i86pc-solaris-64int|5.10.0|solaris|2.11|200905291357
3993096|pass|200905|angryxpeh@gmail.com|Parse-CPAN-Distributions|0.05|i686-linux|5.8.9|linux|2.6.26-2-686|200905291126
3992825|pass|200905|chris@bingosnet.co.uk|Test-YAML-Meta|0.12|i386-freebsd-64int|5.8.8|freebsd|6.2-release|200905291033
3992051|pass|200905|stro@cpan.org|WWW-UsePerl-Journal-Thread|0.12|i686-linux|5.8.9|linux|2.6.26-2-686|200905290832
3992021|pass|200905|stro@cpan.org|CPAN-WWW-Testers-Generator|0.30|i686-linux|5.8.9|linux|2.6.26-2-686|200905290829
3991895|pass|200905|stro@cpan.org|Test-YAML-Meta|0.12|i386-freebsd-64int|5.8.8|freebsd|7.0-release|200905291128
3991886|pass|200905|stro@cpan.org|Test-CPAN-Meta|0.13|i386-freebsd-64int|5.8.8|freebsd|7.0-release|200905291125
3990404|fail|200905|stro@cpan.org|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i686-linux|5.8.9|linux|2.6.26-2-686|200905290223
3990402|fail|200905|stro@cpan.org|WWW-Scraper-ISBN-Amazon_Driver|0.14|i686-linux|5.8.9|linux|2.6.26-2-686|200905290223
3990047|pass|200905|bingos@cpan.org|Test-YAML-Meta|0.12|darwin-thread-multi-2level|5.8.9|darwin|8.11.0|200905290043
3990043|pass|200905|bingos@cpan.org|Test-CPAN-Meta|0.13|darwin-thread-multi-2level|5.8.9|darwin|8.11.0|200905290042
3988787|pass|200905|vpit@cpan.org|Test-YAML-Meta|0.12|x86_64-linux-thread-multi|5.10.0|linux|2.6.26.3-fuuka.profvince.com|200905282130
3988786|pass|200905|vpit@cpan.org|Test-CPAN-Meta|0.13|x86_64-linux-thread-multi|5.10.0|linux|2.6.26.3-fuuka.profvince.com|200905282130
3988632|pass|200905|stro@cpan.org|Test-YAML-Meta|0.12|armv5tejl-linux|5.10.0|linux|2.6.17.14|200905282202
3988600|pass|200905|stro@cpan.org|Test-CPAN-Meta|0.13|armv5tejl-linux|5.10.0|linux|2.6.17.14|200905282158
3987341|pass|200905|bingos@cpan.org|Test-YAML-Meta|0.12|i386-freebsd-thread-multi-64int|5.8.9|freebsd|6.4-release|200905281704
3987337|pass|200905|bingos@cpan.org|Test-CPAN-Meta|0.13|i386-freebsd-thread-multi-64int|5.8.9|freebsd|6.4-release|200905281704
3986122|pass|200905|DCOLLINS@cpan.org|WWW-UsePerl-Journal-Thread|0.12|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200905280645
3985952|fail|200905|DCOLLINS@cpan.org|WWW-Scraper-ISBN-Amazon_Driver|0.14|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200905280639
3985406|pass|200905|stro@rail.org.ua|CPAN-Testers-WWW-Statistics|0.55|i686-linux|5.8.9|linux|2.6.26-2-686|200905281822
3985345|pass|200905|stro@rail.org.ua|Data-Phrasebook-Loader-YAML|0.09|i686-linux|5.8.9|linux|2.6.26-2-686|200905281819
3985343|pass|200905|stro@rail.org.ua|Data-Phrasebook|0.29|i686-linux|5.8.9|linux|2.6.26-2-686|200905281819
3985193|pass|200905|stro@rail.org.ua|CPAN-Testers-Data-Generator|0.35|i686-linux|5.8.9|linux|2.6.26-2-686|200905281810
3985044|pass|200905|mw487.yahoo.com@gmail.com|Test-YAML-Meta|0.12|cygwin-thread-multi-64int|5.10.0 patch 34065|cygwin|1.5.25(0.15642)|200905280738
3985031|pass|200905|mw487.yahoo.com@gmail.com|Test-CPAN-Meta|0.13|cygwin-thread-multi-64int|5.10.0 patch 34065|cygwin|1.5.25(0.15642)|200905280737
3984744|pass|200905|stro@cpan.org|Mail-Outlook|0.15|x86_64-linux|5.8.9|linux|2.6.24.5-xeon-aufs20081006-grsec|200905280526
3984310|pass|200905|angryxpeh@gmail.com|CPAN-Testers-Data-Uploads|0.06|i686-linux|5.8.9|linux|2.6.26-2-686|200905281725
3984283|pass|200905|angryxpeh@gmail.com|CPAN-Testers-Data-Generator|0.36|i686-linux|5.8.9|linux|2.6.26-2-686|200905281723
3984281|pass|200905|angryxpeh@gmail.com|CPAN-Testers-Common-Article|0.36|i686-linux|5.8.9|linux|2.6.26-2-686|200905281723
3983793|pass|200905|DCOLLINS@cpan.org|Parse-CPAN-Distributions|0.05|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200905280644
3983736|pass|200905|angryxpeh@gmail.com|Mail-Outlook|0.15|i686-linux|5.8.9|linux|2.6.26-2-686|200905281656
3983434|pass|200905|ivan.wills@gmail.com ("Ivan Wills")|CPAN-Testers-WWW-Statistics|0.55|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-19-server|200905282116
3982946|pass|200905|ivan.wills@gmail.com ("Ivan Wills")|Data-Phrasebook-Loader-YAML|0.09|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-19-server|200905282056
3982940|pass|200905|ivan.wills@gmail.com ("Ivan Wills")|Data-Phrasebook|0.29|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-19-server|200905282056
3982850|pass|200905|DCOLLINS@cpan.org|CPAN-WWW-Testers-Generator|0.30|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200905280640
3982818|pass|200905|stro@cpan.org|Test-YAML-Meta|0.12|x86_64-linux|5.10.0|linux|2.6.24.5-xeon-aufs20081006-grsec|200905280352
3982816|pass|200905|stro@cpan.org|Test-CPAN-Meta|0.13|x86_64-linux|5.10.0|linux|2.6.24.5-xeon-aufs20081006-grsec|200905280351
3982694|fail|200905|DCOLLINS@cpan.org|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200905280639
3982410|pass|200905|ivan.wills@gmail.com ("Ivan Wills")|CPAN-Testers-Data-Generator|0.35|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-19-server|200905282006
3982038|pass|200905|bingos@cpan.org|Test-YAML-Meta|0.12|alpha-linux-thread-multi|5.8.9|linux|2.6.18-5-alpha-generic|200905280932
3982034|pass|200905|bingos@cpan.org|Test-CPAN-Meta|0.13|alpha-linux-thread-multi|5.8.9|linux|2.6.18-5-alpha-generic|200905280931
3981743|pass|200905|stro@cpan.org|Test-YAML-Meta|0.12|x86_64-linux|5.8.9|linux|2.6.24.5-xeon-aufs20081006-grsec|200905280039
3980024|pass|200905|srezic@cpan.org|Test-YAML-Meta|0.12|amd64-freebsd-thread-multi|5.10.0|freebsd|7.0-release|200905280141
3980022|pass|200905|srezic@cpan.org|Test-CPAN-Meta|0.13|amd64-freebsd-thread-multi|5.10.0|freebsd|7.0-release|200905280140
3978967|pass|200905|rafl@debian.org|Test-YAML-Meta|0.12|i686-linux|5.10.0|linux|2.6.28.7|200905272234
3978912|pass|200905|stro@rail.org.ua|Regexp-Log-Common|0.05|i686-linux|5.8.9|linux|2.6.26-2-686|200905271626
3978775|pass|200905|stro@rail.org.ua|WWW-UsePerl-Journal|0.22|i686-linux|5.8.9|linux|2.6.26-2-686|200905271505
3978325|pass|200905|stro@cpan.org|Test-CPAN-Meta|0.13|x86_64-linux|5.8.9|linux|2.6.24.5-xeon-aufs20081006-grsec|200905271140
3977857|pass|200905|brian@minton.name|Test-YAML-Meta|0.12|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.29.2-dsa-dl380-oldxeon|200905271224
3977752|pass|200905|angryxpeh@gmail.com|App-Maisha|0.12|i686-linux|5.8.9|linux|2.6.26-2-686|200905271100
3977628|pass|200905|overlordq@gmail.com|Test-YAML-Meta|0.12|x86_64-linux-gnu-thread-multi|5.10.0|linux|2.6.18-xen-3.1-1-amd64|200905270910
3977431|pass|200905|mjg@phoenixtrap.com|Test-YAML-Meta|0.12|darwin-thread-multi-2level|5.10.0|darwin|9.6.0|200905270116
3976913|pass|200905|angryxpeh@gmail.com|Test-YAML-Meta|0.12|i686-linux|5.8.9|linux|2.6.26-2-686|200905271113
3976905|pass|200905|angryxpeh@gmail.com|Test-CPAN-Meta|0.13|i686-linux|5.8.9|linux|2.6.26-2-686|200905271113
3976783|pass|200905|mjg@phoenixtrap.com|Test-CPAN-Meta|0.13|darwin-thread-multi-2level|5.10.0|darwin|9.6.0|200905270116
3975407|pass|200905|stro@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.16|i686-linux|5.8.9|linux|2.6.26-2-686|200905271024
3975406|pass|200905|stro@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i686-linux|5.8.9|linux|2.6.26-2-686|200905271024
3975007|pass|200905|chris@bingosnet.co.uk|Test-YAML-Meta|0.12|i686-linux-thread-multi-64int|5.10.0|linux|2.4.26|200905271211
3974521|pass|200905|rbo@cpan.org|Test-CPAN-Meta|0.13|i86pc-solaris|5.8.9|solaris|2.11|200905271223
3974048|pass|200905|bingos@cpan.org|Test-YAML-Meta|0.12|alpha-linux-thread-multi|5.8.8|linux|2.6.18-5-alpha-generic|200905271008
3974043|pass|200905|bingos@cpan.org|Test-CPAN-Meta|0.13|alpha-linux-thread-multi|5.8.8|linux|2.6.18-5-alpha-generic|200905271008
3973676|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal-Thread|0.12|s390x-linux|5.6.2|linux|2.6.27.19-5-default|200905270929
3973516|pass|200905|mw487.yahoo.com@gmail.com|Test-CPAN-Meta|0.13|cygwin-thread-multi-64int|5.8.8|cygwin|1.5.24(0.15642)|200905270153
3973465|pass|200905|mw487.yahoo.com@gmail.com|Test-YAML-Meta|0.12|cygwin-thread-multi-64int|5.8.8|cygwin|1.5.24(0.15642)|200905270153
3972476|pass|200905|stro@cpan.org|Test-YAML-Meta|0.11|armv5tejl-linux|5.10.0|linux|2.6.17.14|200905270556
3972145|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Mailer|0.16|s390x-linux|5.10.0|linux|2.6.16.60-0.31-default|200905270403
3971628|pass|200905|cpanuser@oeuftete.com|Test-YAML-Meta|0.12|i686-linux|5.10.0|linux|2.6.18.8-linode16|200905260241
3971182|pass|200905|hholz@mcs.csueastbay.edu ((Hilary Holz))|Test-YAML-Meta|0.12|i386-linux-thread-multi|5.10.0|linux|2.6.18-128.1.6.el5xen|200905261401
3971027|fail|200905|stro@cpan.org|CPAN-Testers-WWW-Statistics|0.62|x86_64-linux|5.10.0|linux|2.6.24.5-xeon-aufs20081006-grsec|200905261548
3971008|pass|200905|arto+test@cpan.org|Test-YAML-Meta|0.12|i386-linux-thread-multi|5.10.0|linux|2.6.18-128.1.6.el5xen|200905260106
3970891|fail|200905|stro@cpan.org|CPAN-Testers-WWW-Statistics|0.62|x86_64-linux|5.8.9|linux|2.6.24.5-xeon-aufs20081006-grsec|200905261536
3970478|pass|200905|DCOLLINS@cpan.org|Parse-CPAN-Distributions|0.05|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200905261402
3970464|pass|200905|andy@hexten.net|Test-CPAN-Meta|0.13|darwin-thread-multi-2level|5.10.0|darwin|9.1.0|200905262237
3970065|pass|200905|bingos@cpan.org|Test-YAML-Meta|0.12|darwin-thread-multi-2level|5.8.8|darwin|8.11.0|200905262208
3970052|pass|200905|bingos@cpan.org|Test-CPAN-Meta|0.13|darwin-thread-multi-2level|5.8.8|darwin|8.11.0|200905262208
3969850|pass|200905|bingos@cpan.org|Test-YAML-Meta|0.12|i386-freebsd-thread-multi-64int|5.8.8|freebsd|6.4-release|200905261612
3969847|pass|200905|bingos@cpan.org|Test-CPAN-Meta|0.13|i386-freebsd-thread-multi-64int|5.8.8|freebsd|6.4-release|200905261612
3969381|pass|200905|DCOLLINS@cpan.org|WWW-UsePerl-Journal-Thread|0.12|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200905261403
3968981|pass|200905|DCOLLINS@cpan.org|CPAN-WWW-Testers-Generator|0.30|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200905261359
3966564|pass|200905|srezic@cpan.org|WWW-UsePerl-Journal|0.22|amd64-freebsd|5.10.0|freebsd|7.0-release|200905261433
3965405|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-YAML-Meta|0.12|s390x-linux-thread-multi|5.8.9|linux|2.6.16.60-0.31-default|200905261027
3965401|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.13|s390x-linux-thread-multi|5.8.9|linux|2.6.16.60-0.31-default|200905261026
3965299|pass|200905|stro@cpan.org|Test-YAML-Meta|0.12|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.00|200905261052
3965298|pass|200905|stro@cpan.org|Test-CPAN-Meta|0.13|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.00|200905261052
3965282|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-YAML-Meta|0.12|s390x-linux-thread-multi|5.8.8|linux|2.6.27.19-5-default|200905260949
3965279|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.13|s390x-linux-thread-multi|5.8.8|linux|2.6.27.19-5-default|200905260947
3965069|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-YAML-Meta|0.12|s390x-linux|5.8.8|linux|2.6.27.19-5-default|200905260900
3965067|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.13|s390x-linux|5.8.8|linux|2.6.27.19-5-default|200905260858
3965041|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-YAML-Meta|0.12|s390x-linux-thread-multi|5.8.8|linux|2.6.16.60-0.31-default|200905260854
3965036|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.13|s390x-linux-thread-multi|5.8.8|linux|2.6.16.60-0.31-default|200905260852
3964985|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-YAML-Meta|0.12|s390x-linux|5.8.9|linux|2.6.16.60-0.31-default|200905260842
3964972|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.13|s390x-linux|5.8.9|linux|2.6.16.60-0.31-default|200905260840
3964800|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-YAML-Meta|0.12|s390x-linux|5.8.8|linux|2.6.16.60-0.31-default|200905260812
3964794|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.13|s390x-linux|5.8.8|linux|2.6.16.60-0.31-default|200905260811
3964736|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-YAML-Meta|0.12|s390x-linux-thread-multi|5.8.9|linux|2.6.18-92.1.18.el5|200905260802
3964731|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.13|s390x-linux-thread-multi|5.8.9|linux|2.6.18-92.1.18.el5|200905260800
3964723|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-YAML-Meta|0.12|s390-linux-thread-multi|5.8.9|linux|2.6.5-7.315-s390|200905260759
3964713|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.13|s390-linux-thread-multi|5.8.9|linux|2.6.5-7.315-s390|200905260757
3964649|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-YAML-Meta|0.12|s390x-linux-thread-multi|5.8.9|linux|2.6.27.19-5-default|200905260745
3964610|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.13|s390x-linux-thread-multi|5.8.9|linux|2.6.27.19-5-default|200905260739
3964589|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-YAML-Meta|0.12|s390x-linux-thread-multi|5.8.8|linux|2.6.18-92.1.18.el5|200905260733
3964584|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.13|s390x-linux-thread-multi|5.8.8|linux|2.6.18-92.1.18.el5|200905260732
3964512|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-YAML-Meta|0.12|s390x-linux|5.8.9|linux|2.6.27.19-5-default|200905260713
3964500|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.13|s390x-linux|5.8.9|linux|2.6.27.19-5-default|200905260709
3964175|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-YAML-Meta|0.12|s390x-linux|5.10.0|linux|2.6.27.19-5-default|200905260604
3964159|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.13|s390x-linux|5.10.0|linux|2.6.27.19-5-default|200905260559
3964088|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-YAML-Meta|0.12|s390x-linux-thread-multi|5.10.0|linux|2.6.27.19-5-default|200905260546
3964064|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.13|s390x-linux-thread-multi|5.10.0|linux|2.6.27.19-5-default|200905260541
3964042|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-YAML-Meta|0.12|s390-linux|5.8.9|linux|2.6.5-7.315-s390|200905260538
3964028|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.13|s390-linux|5.8.9|linux|2.6.5-7.315-s390|200905260536
3963989|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-YAML-Meta|0.12|s390x-linux-thread-multi|5.10.0|linux|2.6.18-92.el5|200905260527
3963971|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.13|s390x-linux-thread-multi|5.10.0|linux|2.6.18-92.el5|200905260522
3963909|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-YAML-Meta|0.12|s390-linux|5.8.8|linux|2.6.5-7.315-s390|200905260508
3963892|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.13|s390-linux|5.8.8|linux|2.6.5-7.315-s390|200905260506
3963801|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-YAML-Meta|0.12|s390x-linux|5.10.0|linux|2.6.18-92.el5|200905260449
3963787|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.13|s390x-linux|5.10.0|linux|2.6.18-92.el5|200905260445
3963703|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-YAML-Meta|0.12|s390x-linux|5.10.0|linux|2.6.16.60-0.31-default|200905260430
3963672|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.13|s390x-linux|5.10.0|linux|2.6.16.60-0.31-default|200905260425
3963668|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-YAML-Meta|0.12|s390x-linux-thread-multi|5.10.0|linux|2.6.16.60-0.31-default|200905260424
3963651|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.13|s390x-linux-thread-multi|5.10.0|linux|2.6.16.60-0.31-default|200905260419
3963573|pass|200905|bingos@cpan.org|Test-YAML-Meta|0.12|darwin-thread-multi-2level|5.8.6|darwin|8.11.0|200905260304
3963265|fail|200905|DCOLLINS@cpan.org|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200905260109
3963117|fail|200905|DCOLLINS@cpan.org|WWW-Scraper-ISBN-Amazon_Driver|0.14|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200905260056
3962897|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-YAML-Meta|0.12|s390x-linux-thread-multi|5.6.2|linux|2.6.16.60-0.31-default|200905260204
3962892|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.13|s390x-linux-thread-multi|5.6.2|linux|2.6.16.60-0.31-default|200905260202
3962886|pass|200905|ipenburg@xs4all.nl ("Roland van Ipenburg")|Test-YAML-Meta|0.12|i686-linux|5.10.0|linux|2.6.23.11.20071215-bcm203x|200905260202
3962770|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.13|s390x-linux-thread-multi|5.6.2|linux|2.6.27.19-5-default|200905260133
3962667|pass|200905|perl@galumph.com|Test-YAML-Meta|0.12|darwin-thread-multi-64int-ld-2level|5.10.0|darwin|9.4.0|200905251818
3962583|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-YAML-Meta|0.12|s390x-linux-thread-multi|5.6.2|linux|2.6.18-92.1.18.el5|200905260102
3962579|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.13|s390x-linux-thread-multi|5.6.2|linux|2.6.18-92.1.18.el5|200905260101
3962426|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.13|s390x-linux-thread-multi-perlio|5.6.2|linux|2.6.27.19-5-default|200905260030
3962327|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-YAML-Meta|0.12|s390x-linux|5.6.2|linux|2.6.16.60-0.31-default|200905260021
3962316|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.13|s390x-linux|5.6.2|linux|2.6.16.60-0.31-default|200905260020
3962089|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.13|s390x-linux|5.6.2|linux|2.6.27.19-5-default|200905252353
3962030|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-YAML-Meta|0.12|s390x-linux|5.6.2|linux|2.6.18-92.1.18.el5|200905252345
3962026|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.13|s390x-linux|5.6.2|linux|2.6.18-92.1.18.el5|200905252344
3960457|pass|200905|srezic@cpan.org|Test-CPAN-Meta|0.13|amd64-freebsd|5.8.8|freebsd|7.0-release|200905251136
3960450|pass|200905|srezic@cpan.org|Test-YAML-Meta|0.12|amd64-freebsd|5.10.0|freebsd|7.0-release|200905251146
3960133|pass|200905|srezic@cpan.org|Test-YAML-Meta|0.12|amd64-freebsd|5.8.8|freebsd|7.0-release|200905251136
3960049|pass|200905|srezic@cpan.org|Test-YAML-Meta|0.12|amd64-freebsd|5.8.9|freebsd|7.0-release|200905251848
3960048|pass|200905|srezic@cpan.org|Test-CPAN-Meta|0.13|amd64-freebsd|5.8.9|freebsd|7.0-release|200905251848
3960010|pass|200905|srezic@cpan.org|Test-CPAN-Meta|0.13|amd64-freebsd|5.10.0|freebsd|7.0-release|200905250859
3960002|pass|200905|wiml@hhhh.org ("Wim Lewis")|Test-YAML-Meta|0.12|powerpc-netbsd-thread-multi|5.10.0|netbsd|5.0_rc3|200905251132
3959999|pass|200905|wiml@hhhh.org ("Wim Lewis")|Test-CPAN-Meta|0.13|powerpc-netbsd-thread-multi|5.10.0|netbsd|5.0_rc3|200905251131
3959761|pass|200905|jayfrombkk@gmail.com ("Jay from BKK")|Test-YAML-Meta|0.12|darwin-thread-multi-2level|5.8.8|darwin|9.0|200905251222
3959639|pass|200905|g.grigelionis@computer.org|Test-YAML-Meta|0.12|i586-linux-thread-multi|5.8.5|linux|2.6.8.1|200905251927
3959635|pass|200905|g.grigelionis@computer.org|Test-YAML-Meta|0.12|i386-linux-thread-multi|5.8.0|linux|2.6.9-22.18.bz155725.elsmp|200905251926
3959632|pass|200905|g.grigelionis@computer.org|Test-YAML-Meta|0.12|x86_64-linux-thread-multi|5.8.3|linux|2.6.4|200905251926
3959625|pass|200905|g.grigelionis@computer.org|Test-YAML-Meta|0.12|x86_64-linux|5.8.8|linux|2.6.5-7.276-smp|200905251922
3959619|pass|200905|g.grigelionis@computer.org|Test-YAML-Meta|0.12|i586-linux-thread-multi|5.8.8|linux|2.6.16|200905251916
3959501|pass|200905|david@cantrell.org.uk|Test-YAML-Meta|0.12|alpha-netbsd|5.10.0|netbsd|4.0.1|200905251601
3959491|pass|200905|david@cantrell.org.uk|Test-CPAN-Meta|0.13|alpha-netbsd|5.10.0|netbsd|4.0.1|200905251555
3959182|pass|200905|vpit@cpan.org|Test-YAML-Meta|0.12|i686-linux-thread-multi|5.10.0|linux|2.6.9-5.elsmp|200905251446
3958811|pass|200905|chris@bingosnet.co.uk|Test-YAML-Meta|0.12|i386-netbsd-thread-multi-64int|5.8.8|netbsd|3.1|200905251218
3958637|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-YAML-Meta|0.12|s390-linux|5.10.0|linux|2.6.5-7.315-s390|200905251251
3958616|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.13|s390-linux|5.10.0|linux|2.6.5-7.315-s390|200905251248
3958596|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-YAML-Meta|0.12|s390-linux-thread-multi|5.10.0|linux|2.6.5-7.315-s390|200905251245
3958581|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.13|s390-linux-thread-multi|5.10.0|linux|2.6.5-7.315-s390|200905251241
3958567|pass|200905|david@cantrell.org.uk|Test-YAML-Meta|0.12|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200905250536
3958559|pass|200905|david@cantrell.org.uk|Test-YAML-Meta|0.12|IP35-irix-64int|5.8.8|irix|6.5|200905251234
3958547|pass|200905|david@cantrell.org.uk|Test-CPAN-Meta|0.13|IP35-irix-64int|5.8.8|irix|6.5|200905251233
3958546|pass|200905|david@cantrell.org.uk|Test-CPAN-Meta|0.13|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200905250532
3958542|pass|200905|imacat@mail.imacat.idv.tw|Test-YAML-Meta|0.12|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-2-amd64|200905251832
3958534|pass|200905|imacat@mail.imacat.idv.tw|Test-CPAN-Meta|0.13|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-2-amd64|200905251831
3958422|pass|200905|david@cantrell.org.uk|Test-YAML-Meta|0.12|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200905251105
3958421|pass|200905|david@cantrell.org.uk|Test-YAML-Meta|0.12|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200905251105
3958420|pass|200905|david@cantrell.org.uk|Test-YAML-Meta|0.12|x86_64-linux-thread-multi|5.10.0|linux|2.6.18-4-xen-amd64|200905251104
3958419|pass|200905|david@cantrell.org.uk|Test-YAML-Meta|0.12|x86_64-linux-thread-multi|5.8.9|linux|2.6.18-4-xen-amd64|200905251104
3958415|pass|200905|vpit@cpan.org|Test-YAML-Meta|0.12|i686-linux-thread-multi|5.10.0|linux|2.6.18.3-tmb-desktop-2mdvsmp|200905251204
3958414|pass|200905|david@cantrell.org.uk|Test-CPAN-Meta|0.13|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200905251103
3958411|pass|200905|david@cantrell.org.uk|Test-CPAN-Meta|0.13|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200905251103
3958410|pass|200905|david@cantrell.org.uk|Test-CPAN-Meta|0.13|x86_64-linux-thread-multi|5.8.9|linux|2.6.18-4-xen-amd64|200905251103
3958408|pass|200905|david@cantrell.org.uk|Test-CPAN-Meta|0.13|x86_64-linux-thread-multi|5.10.0|linux|2.6.18-4-xen-amd64|200905251103
3958382|pass|200905|david@cantrell.org.uk|Test-CPAN-Meta|0.13|x86_64-linux-thread-multi|5.6.2|linux|2.6.18-4-xen-amd64|200905251058
3957811|pass|200905|JOST@cpan.org ("Josts Smokehouse")|Test-CPAN-Meta|0.13|i86pc-solaris-64int|5.8.9|solaris|2.11|200905251000
3957795|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.13|s390-linux-thread-multi-perlio|5.6.2|linux|2.6.5-7.315-s390|200905251002
3957792|pass|200905|JOST@cpan.org ("Josts Smokehouse")|Test-YAML-Meta|0.12|i86pc-solaris-64int|5.8.9|solaris|2.11|200905251000
3957760|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.13|s390-linux-thread-multi|5.6.2|linux|2.6.5-7.315-s390|200905250955
3957656|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.13|s390-linux|5.6.2|linux|2.6.5-7.315-s390|200905250938
3957142|pass|200905|taro-nishino@wine.ocn.ne.jp ("Taro Nishino")|Test-CPAN-Meta|0.13|MSWin32-x86-multi-thread|5.8.8|MSWin32|5.0|200905251518
3957138|pass|200905|taro-nishino@wine.ocn.ne.jp ("Taro Nishino")|Test-YAML-Meta|0.12|MSWin32-x86-multi-thread|5.8.8|MSWin32|5.0|200905251517
3957137|pass|200905|bingos@cpan.org|Test-YAML-Meta|0.11|darwin-thread-multi-2level|5.8.6|darwin|8.11.0|200905250712
3956993|pass|200905|bingos@cpan.org|Test-YAML-Meta|0.12|i386-freebsd-thread-multi-64int|5.10.0|freebsd|6.4-release|200905250625
3956308|pass|200905|cpanuser@oeuftete.com|Test-YAML-Meta|0.11|i686-linux|5.10.0|linux|2.6.18.8-linode16|200905241642
3955237|pass|200905|DCOLLINS@cpan.org|Data-FormValidator-Constraints-Words|0.03|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200905241830
3955222|fail|200905|DCOLLINS@cpan.org|Finance-Currency-Convert-XE|0.15|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200905241830
3955217|pass|200905|stro@cpan.org|Regexp-Log-Common|0.05|x86_64-linux|5.8.9|linux|2.6.24.5-xeon-aufs20081006-grsec|200905241544
3954719|pass|200905|stsc@refcnt.org ("Steven Schubiger")|Test-YAML-Meta|0.12|i686-linux-thread-multi|5.10.0|linux|2.6.18-14-ovz-686|200905242324
3954718|pass|200905|stsc@refcnt.org ("Steven Schubiger")|Test-CPAN-Meta|0.13|i686-linux-thread-multi|5.10.0|linux|2.6.18-14-ovz-686|200905242323
3954676|pass|200905|vpit@cpan.org|Test-YAML-Meta|0.12|x86_64-linux-thread-multi|5.10.0|linux|2.6.26.3-fuuka.profvince.com|200905242318
3954672|pass|200905|vpit@cpan.org|Test-CPAN-Meta|0.13|x86_64-linux-thread-multi|5.10.0|linux|2.6.26.3-fuuka.profvince.com|200905242318
3954592|pass|200905|vpit@cpan.org|Test-YAML-Meta|0.12|x86_64-linux-ld|5.10.0|linux|2.6.26.5-fuuka.profvince.com|200905242303
3953783|pass|200905|stro@cpan.org|Test-CPAN-Meta|0.12|x86_64-linux|5.8.9|linux|2.6.24.5-xeon-aufs20081006-grsec|200905241144
3953519|cpan|200905|BARBIE|Test-CPAN-Meta|0.13||0|||200905242008
3953511|cpan|200905|BARBIE|Test-YAML-Meta|0.12||0|||200905242007
3953282|pass|200905|stro@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.16|x86_64-linux|5.8.9|linux|2.6.24.5-xeon-aufs20081006-grsec|200905241012
3953276|pass|200905|stro@cpan.org|CPAN-Testers-Common-DBUtils|0.03|x86_64-linux|5.8.9|linux|2.6.24.5-xeon-aufs20081006-grsec|200905241012
3953231|pass|200905|stro@cpan.org|Regexp-Log-Common|0.05|x86_64-linux|5.10.0|linux|2.6.24.5-xeon-aufs20081006-grsec|200905241003
3951935|pass|200905|stro@cpan.org|Test-CPAN-Meta|0.12|x86_64-linux|5.10.0|linux|2.6.24.5-xeon-aufs20081006-grsec|200905240452
3951628|pass|200905|stro@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.16|x86_64-linux|5.10.0|linux|2.6.24.5-xeon-aufs20081006-grsec|200905240306
3951624|pass|200905|stro@cpan.org|CPAN-Testers-Common-DBUtils|0.03|x86_64-linux|5.10.0|linux|2.6.24.5-xeon-aufs20081006-grsec|200905240306
3951400|pass|200905|stro@cpan.org|WWW-UsePerl-Journal|0.22|x86_64-linux|5.8.9|linux|2.6.24.5-xeon-aufs20081006-grsec|200905240156
3950732|pass|200905|DCOLLINS@cpan.org|Calendar-List|0.21|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200905240338
3950522|pass|200905|DCOLLINS@cpan.org|Games-Trackword|1.06|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200905240233
3945854|pass|200905|bingos@cpan.org|Test-YAML-Meta|0.11|i86pc-solaris-thread-multi-64int|5.8.9|solaris|2.10|200905231138
3945554|pass|200905|ivan.wills@gmail.com ("Ivan Wills")|CPAN-Testers-Data-Uploads|0.06|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-19-server|200905231856
3945511|pass|200905|ivan.wills@gmail.com ("Ivan Wills")|CPAN-Testers-Data-Generator|0.36|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-19-server|200905231841
3945510|pass|200905|ivan.wills@gmail.com ("Ivan Wills")|CPAN-Testers-Common-Article|0.36|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-19-server|200905231841
3945415|pass|200905|ivan.wills@gmail.com ("Ivan Wills")|App-Maisha-Plugin-PingFM|0.02|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-19-server|200905231754
3944846|pass|200905|ivan.wills@gmail.com ("Ivan Wills")|App-Maisha|0.12|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-19-server|200905231500
3944267|fail|200905|DCOLLINS@cpan.org|WWW-Scraper-ISBN-Pearson_Driver|0.10|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200905230318
3943636|fail|200905|DCOLLINS@cpan.org|WWW-Scraper-ISBN-ORA_Driver|0.09|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200905230219
3943516|pass|200905|ivan.wills@gmail.com ("Ivan Wills")|Mail-Outlook|0.15|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-19-server|200905231158
3942372|pass|200905|bingos@cpan.org|Test-YAML-Meta|0.11|darwin-thread-multi-2level|5.10.0|darwin|8.11.0|200905222156
3942303|pass|200905|pjacklam@cpan.org|Test-YAML-Meta|0.11|cygwin-thread-multi-64int|5.10.0 patch 34065|cygwin|1.5.25(0.15642)|200905221907
3937351|pass|200905|ivan.wills@gmail.com ("Ivan Wills")|Regexp-Log-Common|0.05|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-19-server|200905221708
3935861|pass|200905|DCOLLINS@cpan.org|WWW-UsePerl-Journal-Thread|0.12|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1049-g5f1c709|linux|2.6.28-11-generic|200905220043
3935472|pass|200905|DCOLLINS@cpan.org|Parse-CPAN-Distributions|0.05|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200905211843
3935125|pass|200905|DCOLLINS@cpan.org|Parse-CPAN-Distributions|0.05|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200905211843
3935124|pass|200905|DCOLLINS@cpan.org|Parse-CPAN-Distributions|0.05|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1049-g5f1c709|linux|2.6.28-11-generic|200905211843
3934864|pass|200905|ivan.wills@gmail.com ("Ivan Wills")|Test-CPAN-Meta|0.12|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-19-server|200905220831
3934476|pass|200905|ivan.wills@gmail.com ("Ivan Wills")|CPAN-Testers-WWW-Reports-Mailer|0.16|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-19-server|200905220707
3934466|pass|200905|ivan.wills@gmail.com ("Ivan Wills")|CPAN-Testers-Common-DBUtils|0.03|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-19-server|200905220706
3933811|pass|200905|ivan.wills@gmail.com ("Ivan Wills")|WWW-UsePerl-Journal|0.22|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-19-server|200905220440
3933090|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Data-FormValidator-Constraints-Words|0.03|s390x-linux-thread-multi-perlio|5.6.2|linux|2.6.27.19-5-default|200905211800
3932370|pass|200905|DCOLLINS@cpan.org|CPAN-WWW-Testers-Generator|0.30|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200905210621
3932243|pass|200905|james@mastros.biz|Test-YAML-Meta|0.11|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.26-1-686|200905202155
3932088|pass|200905|DCOLLINS@cpan.org|WWW-UsePerl-Journal-Thread|0.12|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200905210632
3931517|pass|200905|DCOLLINS@cpan.org|CPAN-WWW-Testers-Generator|0.30|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1049-g5f1c709|linux|2.6.28-11-generic|200905210621
3931436|fail|200905|DCOLLINS@cpan.org|WWW-Scraper-ISBN-Amazon_Driver|0.14|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200905210619
3931426|fail|200905|DCOLLINS@cpan.org|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200905210619
3931239|pass|200905|DCOLLINS@cpan.org|WWW-UsePerl-Journal-Thread|0.12|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200905210632
3929976|pass|200905|DCOLLINS@cpan.org|CPAN-WWW-Testers-Generator|0.30|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200905210621
3929744|fail|200905|DCOLLINS@cpan.org|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200905210619
3929743|fail|200905|DCOLLINS@cpan.org|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1049-g5f1c709|linux|2.6.28-11-generic|200905210619
3929742|fail|200905|DCOLLINS@cpan.org|WWW-Scraper-ISBN-Amazon_Driver|0.14|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1049-g5f1c709|linux|2.6.28-11-generic|200905210619
3928037|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Mailer|0.16|s390x-linux|5.10.0|linux|2.6.27.19-5-default|200905210257
3926499|pass|200905|bingos@cpan.org|Test-YAML-Meta|0.11|alpha-linux-thread-multi|5.10.0|linux|2.6.18-5-alpha-generic|200905201831
3926066|pass|200905|bingos@cpan.org|Test-YAML-Meta|0.11|darwin-thread-multi-64int-2level|5.8.6|darwin|8.11.0|200905201723
3922794|pass|200905|bobtfish@bobtfish.net|Test-CPAN-Meta|0.12|x86_64-linux-gnu-thread-multi|5.8.8|linux|2.6.24-16-server|200905191844
3921646|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-YAML-Meta|0.11|s390-linux|5.8.9|linux|2.6.5-7.315-s390|200905200306
3920901|pass|200905|bingos@cpan.org|Test-YAML-Meta|0.11|darwin-thread-multi-64int-2level|5.10.0|darwin|8.11.0|200905192258
3920336|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-YAML-Meta|0.11|s390x-linux-thread-multi|5.8.9|linux|2.6.18-92.1.18.el5|200905192147
3920279|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Mailer|0.16|s390x-linux|5.10.0|linux|2.6.18-92.el5|200905192131
3918651|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-YAML-Meta|0.11|s390x-linux|5.8.8|linux|2.6.27.19-5-default|200905191417
3915543|pass|200905|bingos@cpan.org|Test-YAML-Meta|0.11|i86pc-solaris-thread-multi-64int|5.8.8|solaris|2.10|200905190141
3914889|pass|200905|stro@cpan.org|WWW-UsePerl-Journal|0.22|x86_64-linux|5.10.0|linux|2.6.24.5-xeon-aufs20081006-grsec|200905181504
3911308|pass|200905|DCOLLINS@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200905180741
3910881|pass|200905|DCOLLINS@cpan.org|Data-Phrasebook|0.29|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200905180741
3910260|pass|200905|DCOLLINS@cpan.org|CPAN-Testers-WWW-Statistics|0.55|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200905180740
3908677|pass|200905|DCOLLINS@cpan.org|CPAN-Testers-Data-Generator|0.35|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200905180653
3908253|pass|200905|DCOLLINS@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200905180548
3908224|pass|200905|DCOLLINS@cpan.org|CPAN-Testers-Data-Generator|0.35|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200905180543
3907965|pass|200905|DCOLLINS@cpan.org|CPAN-Testers-WWW-Statistics|0.55|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200905180433
3907713|pass|200905|DCOLLINS@cpan.org|Data-Phrasebook|0.29|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200905180327
3907187|pass|200905|DCOLLINS@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200905180226
3907185|pass|200905|DCOLLINS@cpan.org|Data-Phrasebook|0.29|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200905180225
3907100|pass|200905|DCOLLINS@cpan.org|CPAN-Testers-WWW-Statistics|0.55|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200905180217
3907099|pass|200905|DCOLLINS@cpan.org|CPAN-Testers-Data-Generator|0.35|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200905180217
3906466|pass|200905|DCOLLINS@cpan.org|Data-Phrasebook|0.29|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200905171815
3906299|pass|200905|DCOLLINS@cpan.org|CPAN-Testers-WWW-Statistics|0.55|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200905171815
3906123|pass|200905|DCOLLINS@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200905171815
3905121|pass|200905|stro@cpan.org|Test-YAML-Meta|0.11|armv5tejl-linux|5.8.8|linux|2.6.17.14|200905172240
3903123|pass|200905|DCOLLINS@cpan.org|CPAN-Testers-WWW-Statistics|0.55|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1049-g5f1c709|linux|2.6.28-11-generic|200905170849
3902553|pass|200905|DCOLLINS@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1049-g5f1c709|linux|2.6.28-11-generic|200905170849
3902478|pass|200905|DCOLLINS@cpan.org|CPAN-Testers-Data-Generator|0.36|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1049-g5f1c709|linux|2.6.28-11-generic|200905170849
3901638|pass|200905|DCOLLINS@cpan.org|Data-Phrasebook|0.29|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1049-g5f1c709|linux|2.6.28-11-generic|200905170849
3901545|pass|200905|DCOLLINS@cpan.org|CPAN-Testers-Data-Uploads|0.06|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1049-g5f1c709|linux|2.6.28-11-generic|200905170849
3901542|pass|200905|DCOLLINS@cpan.org|CPAN-Testers-Data-Generator|0.35|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1049-g5f1c709|linux|2.6.28-11-generic|200905170849
3901541|pass|200905|DCOLLINS@cpan.org|CPAN-Testers-Common-Article|0.36|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1049-g5f1c709|linux|2.6.28-11-generic|200905170849
3899730|pass|200905|DCOLLINS@cpan.org|CPAN-Testers-Common-Article|0.36|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200905170523
3899424|pass|200905|DCOLLINS@cpan.org|CPAN-Testers-Data-Uploads|0.06|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200905170345
3899408|pass|200905|DCOLLINS@cpan.org|CPAN-Testers-Data-Generator|0.36|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200905170343
3899186|pass|200905|DCOLLINS@cpan.org|CPAN-Testers-Data-Uploads|0.06|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200905170317
3899184|pass|200905|DCOLLINS@cpan.org|CPAN-Testers-Data-Generator|0.36|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200905170317
3899182|pass|200905|DCOLLINS@cpan.org|CPAN-Testers-Common-Article|0.36|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200905170317
3899004|pass|200905|DCOLLINS@cpan.org|CPAN-Testers-Data-Generator|0.35|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200905170153
3898654|pass|200905|DCOLLINS@cpan.org|CPAN-Testers-Common-Article|0.36|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200905161823
3898468|pass|200905|DCOLLINS@cpan.org|CPAN-Testers-Data-Uploads|0.06|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200905161823
3898211|pass|200905|DCOLLINS@cpan.org|CPAN-Testers-Data-Generator|0.36|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200905161823
3898200|pass|200905|DCOLLINS@cpan.org|App-Maisha-Plugin-PingFM|0.02|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200905161823
3897926|pass|200905|wiml@hhhh.org ("Wim Lewis")|Regexp-Log-Common|0.05|powerpc-netbsd-thread-multi|5.8.8|netbsd|4.0|200905161053
3897731|pass|200905|bingos@cpan.org|Test-YAML-Meta|0.11|darwin-2level|5.8.8|darwin|8.11.0|200905162134
3897063|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Parse-CPAN-Distributions|0.05|s390x-linux-thread-multi|5.8.9|linux|2.6.27.19-5-default|200905161959
3896760|pass|200905|rafl@debian.org|Test-YAML-Meta|0.11|i686-linux|5.10.0|linux|2.6.28.7|200905161834
3896169|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal-Thread|0.12|s390x-linux-thread-multi|5.8.9|linux|2.6.27.19-5-default|200905161534
3895916|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-WWW-Testers-Generator|0.30|s390x-linux-thread-multi|5.8.9|linux|2.6.27.19-5-default|200905161422
3894690|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-YAML-Meta|0.11|s390x-linux-thread-multi|5.8.8|linux|2.6.27.19-5-default|200905160935
3894495|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-YAML-Meta|0.11|s390-linux-thread-multi|5.8.9|linux|2.6.5-7.315-s390|200905160853
3894473|pass|200905|DCOLLINS@cpan.org|CPAN-Testers-Data-Uploads|0.06|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200905160643
3894200|pass|200905|DCOLLINS@cpan.org|Mail-Outlook|0.15|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1049-g5f1c709|linux|2.6.28-11-generic|200905160513
3893359|pass|200905|DCOLLINS@cpan.org|App-Maisha|0.12|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200905160308
3893019|pass|200905|DCOLLINS@cpan.org|Mail-Outlook|0.15|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200905160226
3893018|pass|200905|DCOLLINS@cpan.org|Mail-Outlook|0.15|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200905160226
3892939|pass|200905|DCOLLINS@cpan.org|CPAN-Testers-Data-Generator|0.36|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200905160218
3891334|pass|200905|wiml@hhhh.org ("Wim Lewis")|WWW-UsePerl-Journal|0.22|powerpc-netbsd-thread-multi|5.8.8|netbsd|4.0|200905150828
3890295|pass|200905|stro@cpan.org|Test-YAML-Meta|0.11|x86_64-linux|5.10.0|linux|2.6.24.5-xeon-aufs20081006-grsec|200905150823
3887999|pass|200905|DCOLLINS@cpan.org|App-Maisha-Plugin-PingFM|0.02|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200905150634
3887441|pass|200905|DCOLLINS@cpan.org|CPAN-Testers-Common-Article|0.36|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200905150634
3887415|pass|200905|DCOLLINS@cpan.org|App-Maisha|0.12|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200905150634
3885337|pass|200905|DCOLLINS@cpan.org|Mail-Outlook|0.15|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200905150358
3883137|pass|200905|DCOLLINS@cpan.org|App-Maisha|0.12|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200905141850
3882908|pass|200905|bingos@cpan.org|Test-YAML-Meta|0.11|i86pc-solaris-thread-multi-64int|5.10.0|solaris|2.10|200905142304
3882226|pass|200905|stro@cpan.org|Test-YAML-Meta|0.11|x86_64-linux|5.8.9|linux|2.6.24.5-xeon-aufs20081006-grsec|200905141318
3877814|pass|200905|DCOLLINS@cpan.org|Test-YAML-Meta|0.11|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200905140637
3877582|pass|200905|DCOLLINS@cpan.org|Regexp-Log-Common|0.05|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1049-g5f1c709|linux|2.6.28-11-generic|200905140522
3877162|pass|200905|DCOLLINS@cpan.org|Mail-Outlook|0.15|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200905140359
3876636|pass|200905|DCOLLINS@cpan.org|Test-YAML-Meta|0.11|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200905140310
3875759|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|GD-Chart-Radial|0.07|s390x-linux-thread-multi|5.10.0|linux|2.6.16.60-0.31-default|200905140119
3875003|pass|200905|bingos@cpan.org|Test-YAML-Meta|0.11|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.24.5-smp|200905132033
3874674|pass|200905|bingos@cpan.org|Test-YAML-Meta|0.11|alpha-linux-thread-multi|5.8.8|linux|2.6.18-5-alpha-generic|200905131946
3871590|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-WWW-Testers-Generator|0.30|s390x-linux-thread-multi|5.8.8|linux|2.6.18-92.1.18.el5|200905131055
3868617|pass|200905|DCOLLINS@cpan.org|Test-CPAN-Meta|0.12|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1049-g5f1c709|linux|2.6.28-11-generic|200905121302
3868330|pass|200905|DCOLLINS@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.16|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1049-g5f1c709|linux|2.6.28-11-generic|200905121242
3868298|pass|200905|DCOLLINS@cpan.org|Test-YAML-Meta|0.11|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1049-g5f1c709|linux|2.6.28-11-generic|200905121302
3868297|pass|200905|DCOLLINS@cpan.org|Test-YAML-Meta|0.11|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200905121302
3868210|pass|200905|DCOLLINS@cpan.org|Regexp-Log-Common|0.05|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200905121301
3867820|pass|200905|DCOLLINS@cpan.org|Test-YAML-Meta|0.11|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200905121302
3867519|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook-Loader-Ini|0.10|s390-linux-thread-multi-perlio|5.6.2|linux|2.6.5-7.315-s390|200905121923
3867504|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook-Loader-XML|0.12|s390-linux-thread-multi-perlio|5.6.2|linux|2.6.5-7.315-s390|200905121922
3867377|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Mail-File|0.08|s390-linux-thread-multi-perlio|5.6.2|linux|2.6.5-7.315-s390|200905121908
3867369|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Regexp-Log-Common|0.05|s390-linux-thread-multi-perlio|5.6.2|linux|2.6.5-7.315-s390|200905121907
3867363|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook|0.29|s390-linux-thread-multi-perlio|5.6.2|linux|2.6.5-7.315-s390|200905121906
3867324|pass|200905|robin@smidsrod.no ("Robin Smidsrd")|Test-YAML-Meta|0.11|i486-linux-gnu-thread-multi|5.8.8|linux|2.6.24-19-server|200905121237
3867180|pass|200905|DCOLLINS@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1049-g5f1c709|linux|2.6.28-11-generic|200905121242
3866843|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-YACSmoke-Plugin-Outlook|0.06|s390-linux-thread-multi-perlio|5.6.2|linux|2.6.5-7.315-s390|200905121747
3866683|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook-Loader-Ini|0.10|s390-linux-thread-multi|5.6.2|linux|2.6.5-7.315-s390|200905121708
3866676|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook-Loader-XML|0.12|s390-linux-thread-multi|5.6.2|linux|2.6.5-7.315-s390|200905121707
3866630|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Mail-File|0.08|s390-linux-thread-multi|5.6.2|linux|2.6.5-7.315-s390|200905121656
3866629|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Regexp-Log-Common|0.05|s390-linux-thread-multi|5.6.2|linux|2.6.5-7.315-s390|200905121655
3866627|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook|0.29|s390-linux-thread-multi|5.6.2|linux|2.6.5-7.315-s390|200905121654
3866255|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-YACSmoke-Plugin-Outlook|0.06|s390-linux-thread-multi|5.6.2|linux|2.6.5-7.315-s390|200905121541
3863734|pass|200905|DCOLLINS@cpan.org|WWW-UsePerl-Journal|0.22|i686-linux-thread-multi-ld|5.11.0 patch GitLive-blead-1049-g5f1c709|linux|2.6.28-11-generic|200905120157
3863679|pass|200905|DCOLLINS@cpan.org|Regexp-Log-Common|0.05|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200905120146
3863363|pass|200905|DCOLLINS@cpan.org|Regexp-Log-Common|0.05|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200905120114
3862960|pass|200905|DCOLLINS@cpan.org|Test-CPAN-Meta|0.12|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200905111703
3862520|pass|200905|DCOLLINS@cpan.org|Test-CPAN-Meta|0.12|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200905111712
3862324|pass|200905|DCOLLINS@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200905111713
3861739|pass|200905|DCOLLINS@cpan.org|Regexp-Log-Common|0.05|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200905111432
3861580|pass|200905|DCOLLINS@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.16|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200905111422
3861395|pass|200905|DCOLLINS@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200905111430
3860772|pass|200905|DCOLLINS@cpan.org|WWW-UsePerl-Journal|0.22|i686-linux-thread-multi|5.9.5|linux|2.6.28-11-generic|200905111409
3860080|pass|200905|bingos@cpan.org|Test-YAML-Meta|0.11|darwin-2level|5.8.6|darwin|8.11.0|200905111543
3859662|pass|200905|DCOLLINS@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.16|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200905110653
3859418|pass|200905|DCOLLINS@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.16|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200905110653
3859417|pass|200905|DCOLLINS@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200905110654
3858690|pass|200905|DCOLLINS@cpan.org|Test-CPAN-Meta|0.12|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200905110652
3856488|pass|200905|DCOLLINS@cpan.org|WWW-UsePerl-Journal|0.22|i686-linux-thread-multi|5.8.9|linux|2.6.28-11-generic|200905110137
3856422|pass|200905|DCOLLINS@cpan.org|WWW-UsePerl-Journal|0.22|i686-linux-thread-multi|5.8.8|linux|2.6.28-11-generic|200905110130
3856232|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Uploads|0.06|s390x-linux-thread-multi|5.10.0|linux|2.6.18-92.el5|200905110232
3852690|pass|200905|bingos@cpan.org|Test-YAML-Meta|0.11|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24.5-smp|200905100701
3844448|pass|200905|DCOLLINS@cpan.org|Test-CPAN-Meta|0.12|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200905090354
3843007|pass|200905|DCOLLINS@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.16|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200905081935
3843003|pass|200905|DCOLLINS@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200905081933
3842807|pass|200905|bingos@cpan.org|Test-YAML-Meta|0.11|darwin-2level|5.8.9|darwin|8.11.0|200905082340
3841868|pass|200905|DCOLLINS@cpan.org|WWW-UsePerl-Journal|0.22|i686-linux-thread-multi-ld|5.10.0|linux|2.6.28-11-generic|200905081516
3841065|pass|200905|bingos@cpan.org|Test-YAML-Meta|0.11|i386-netbsd|5.8.9|netbsd|5.0|200905081745
3829058|pass|200905|bingos@cpan.org|Test-YAML-Meta|0.11|i386-netbsd|5.10.0|netbsd|5.0|200905070317
3827273|pass|200905|bingos@cpan.org|Test-YAML-Meta|0.11|darwin-2level|5.10.0|darwin|8.11.0|200905061834
3822179|pass|200905|dagolden@cpan.org (DAGOLDEN)|CPAN-Testers-WWW-Statistics|0.55|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.24-16-generic|200905051820
3821180|pass|200905|bingos@cpan.org|Test-YAML-Meta|0.11|i386-netbsd-thread-multi-64int|5.8.9|netbsd|5.0|200905052034
3818580|pass|200905|dagolden@cpan.org (DAGOLDEN)|Test-CPAN-Meta|0.12|i686-linux-thread-multi-64int-ld|5.6.2|linux|2.6.24-16-generic|200905050700
3814742|pass|200905|bingos@cpan.org|WWW-UsePerl-Journal|0.22|i386-netbsd-thread-multi-64int|5.8.9|netbsd|5.0|200905042338
3813269|pass|200905|bingos@cpan.org|Test-YAML-Meta|0.11|darwin-thread-multi-64int-2level|5.8.9|darwin|8.11.0|200905041625
3811049|pass|200905|bingos@cpan.org|Test-YAML-Meta|0.11|i386-netbsd-thread-multi-64int|5.10.0|netbsd|5.0|200905041011
3808094|pass|200905|imacat@mail.imacat.idv.tw|WWW-UsePerl-Journal-Thread|0.12|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-2-amd64|200905040210
3808090|pass|200905|imacat@mail.imacat.idv.tw|WWW-UsePerl-Journal|0.22|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-2-amd64|200905040207
3808085|fail|200905|imacat@mail.imacat.idv.tw|WWW-Scraper-ISBN-Yahoo_Driver|0.08|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-2-amd64|200905040205
3808081|fail|200905|imacat@mail.imacat.idv.tw|WWW-Scraper-ISBN-Pearson_Driver|0.10|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-2-amd64|200905040202
3808070|fail|200905|imacat@mail.imacat.idv.tw|WWW-Scraper-ISBN-ORA_Driver|0.09|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-2-amd64|200905040159
3808063|fail|200905|imacat@mail.imacat.idv.tw|WWW-Scraper-ISBN-Amazon_Driver|0.14|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-2-amd64|200905040156
3808054|pass|200905|imacat@mail.imacat.idv.tw|Regexp-Log-Common|0.05|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-2-amd64|200905040153
3808050|pass|200905|imacat@mail.imacat.idv.tw|Parse-CPAN-Distributions|0.05|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-2-amd64|200905040153
3808049|pass|200905|imacat@mail.imacat.idv.tw|Mail-File|0.08|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-2-amd64|200905040152
3808047|pass|200905|imacat@mail.imacat.idv.tw|Games-Trackword|1.06|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-2-amd64|200905040152
3808045|pass|200905|imacat@mail.imacat.idv.tw|GD-Chart-Radial|0.07|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-2-amd64|200905040151
3808043|fail|200905|imacat@mail.imacat.idv.tw|Finance-Currency-Convert-XE|0.15|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-2-amd64|200905040151
3808037|pass|200905|imacat@mail.imacat.idv.tw|Data-Phrasebook-Loader-YAML|0.09|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-2-amd64|200905040148
3808035|pass|200905|imacat@mail.imacat.idv.tw|Data-Phrasebook-Loader-Ini|0.10|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-2-amd64|200905040147
3808034|pass|200905|imacat@mail.imacat.idv.tw|Data-Phrasebook-Loader-DBI|0.11|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-2-amd64|200905040146
3808032|pass|200905|imacat@mail.imacat.idv.tw|Data-Phrasebook|0.29|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-2-amd64|200905040145
3808031|pass|200905|imacat@mail.imacat.idv.tw|Data-FormValidator-Constraints-Words|0.03|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-2-amd64|200905040144
3808030|pass|200905|imacat@mail.imacat.idv.tw|Calendar-List|0.21|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-2-amd64|200905040144
3808029|fail|200905|imacat@mail.imacat.idv.tw|CPAN-YACSmoke-Plugin-WebList|0.05|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-2-amd64|200905040143
3808022|pass|200905|imacat@mail.imacat.idv.tw|CPAN-YACSmoke-Plugin-Outlook|0.06|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-2-amd64|200905040137
3808014|pass|200905|imacat@mail.imacat.idv.tw|CPAN-YACSmoke-Plugin-NNTPWeb|0.06|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-2-amd64|200905040136
3807985|pass|200905|imacat@mail.imacat.idv.tw|CPAN-YACSmoke-Plugin-NNTP|0.05|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-2-amd64|200905040123
3807978|pass|200905|imacat@mail.imacat.idv.tw|CPAN-WWW-Testers-Generator|0.30|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-2-amd64|200905040121
3807906|pass|200905|imacat@mail.imacat.idv.tw|CPAN-Testers-WWW-Statistics|0.55|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-2-amd64|200905040054
3807881|pass|200905|imacat@mail.imacat.idv.tw|CPAN-Testers-WWW-Reports-Mailer|0.16|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-2-amd64|200905040048
3807874|pass|200905|imacat@mail.imacat.idv.tw|CPAN-Testers-Data-Uploads|0.06|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-2-amd64|200905040043
3807869|pass|200905|imacat@mail.imacat.idv.tw|CPAN-Testers-Data-Generator|0.35|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-2-amd64|200905040037
3807864|pass|200905|imacat@mail.imacat.idv.tw|CPAN-Testers-Common-DBUtils|0.03|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-2-amd64|200905040033
3807854|pass|200905|imacat@mail.imacat.idv.tw|CPAN-Testers-Common-Article|0.36|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-2-amd64|200905040031
3807832|pass|200905|imacat@mail.imacat.idv.tw|App-Maisha|0.12|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-2-amd64|200905040027
3806026|pass|200905|bingos@cpan.org|WWW-UsePerl-Journal|0.22|i386-netbsd-thread-multi-64int|5.10.0|netbsd|5.0|200905031026
3805356|pass|200905|imacat@mail.imacat.idv.tw|Mail-Outlook|0.15|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-2-amd64|200905031413
3805026|pass|200905|imacat@mail.imacat.idv.tw|Test-YAML-Meta|0.11|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-2-amd64|200905031300
3801570|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.12|s390x-linux|5.8.9|linux|2.6.27.19-5-default|200905021813
3801498|pass|200905|cpan@tenzobox.net ("Axel Bourgeois")|Test-YAML-Meta|0.11|i686-linux|5.10.0|linux|2.6.27-11-server|200905021714
3801344|pass|200905|imacat@mail.imacat.idv.tw|Test-CPAN-Meta|0.12|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-2-amd64|200905022338
3801334|pass|200905|bingos@cpan.org|Test-YAML-Meta|0.11|darwin-thread-multi-64int-2level|5.8.8|darwin|8.11.0|200905021633
3799946|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.12|s390x-linux-thread-multi|5.10.0|linux|2.6.27.19-5-default|200905021229
3799732|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal|0.22|s390x-linux-thread-multi|5.8.8|linux|2.6.27.19-5-default|200905021150
3799358|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.12|s390x-linux-thread-multi|5.8.9|linux|2.6.27.19-5-default|200905021036
3798773|pass|200905|amiri@metalabel.com (Amiri Barksdale)|Test-YAML-Meta|0.11|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-16-server|200905010052
3798553|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Mailer|0.16|s390x-linux-thread-multi|5.10.0|linux|2.6.27.19-5-default|200905020503
3797985|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Mailer|0.16|s390x-linux-thread-multi|5.8.9|linux|2.6.27.19-5-default|200905020251
3797000|pass|200905|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Mailer|0.16|s390x-linux|5.8.9|linux|2.6.27.19-5-default|200905012020
3796795|pass|200905|bingos@cpan.org|Test-YAML-Meta|0.11|i386-freebsd-thread-multi-64int|5.8.8|freebsd|6.4-release|200905011626
3795868|pass|200905|mw487.yahoo.com@gmail.com|Test-CPAN-Meta|0.12|cygwin-thread-multi-64int|5.8.8|cygwin|1.5.24(0.15642)|200905010636
3792828|pass|200904|mw487.yahoo.com@gmail.com|CPAN-Testers-Common-DBUtils|0.03|cygwin-thread-multi-64int|5.8.8|cygwin|1.5.24(0.15642)|200904301748
3791836|pass|200904|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|darwin-thread-multi-64int-2level|5.8.8|darwin|8.11.0|200904302023
3791497|pass|200904|bingos@cpan.org|Test-CPAN-Meta|0.12|darwin-thread-multi-64int-2level|5.8.8|darwin|8.11.0|200904301910
3788422|pass|200904|bingos@cpan.org|WWW-UsePerl-Journal|0.22|i386-freebsd-thread-multi-64int|5.8.8|freebsd|6.4-release|200904300238
3788052|pass|200904|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|darwin-thread-multi-64int-2level|5.8.6|darwin|8.11.0|200904300059
3787605|pass|200904|stsc@refcnt.org ("Steven Schubiger")|WWW-UsePerl-Journal|0.22|i686-linux-thread-multi|5.10.0|linux|2.6.18-14-ovz-686|200904292350
3786708|pass|200904|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-freebsd-thread-multi-64int|5.8.8|freebsd|6.4-release|200904291808
3786517|pass|200904|bingos@cpan.org|Test-CPAN-Meta|0.12|i386-freebsd-thread-multi-64int|5.8.8|freebsd|6.4-release|200904291730
3786218|pass|200904|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|alpha-linux-thread-multi|5.8.9|linux|2.6.18-5-alpha-generic|200904291626
3786016|pass|200904|bingos@cpan.org|Test-CPAN-Meta|0.12|alpha-linux-thread-multi|5.8.9|linux|2.6.18-5-alpha-generic|200904291532
3785011|pass|200904|bobtfisg@bobtfish.net|Test-CPAN-Meta|0.12|darwin-thread-multi-2level|5.8.6|darwin|8.0|200904282318
3784766|pass|200904|bingos@cpan.org|Test-YAML-Meta|0.11|i386-freebsd-thread-multi-64int|5.8.9|freebsd|6.4-release|200904290710
3783948|pass|200904|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|darwin-thread-multi-64int-2level|5.10.0|darwin|8.11.0|200904290428
3783686|pass|200904|bingos@cpan.org|Test-CPAN-Meta|0.12|darwin-thread-multi-64int-2level|5.10.0|darwin|8.11.0|200904290253
3782315|pass|200904|andy@hexten.net|Test-YAML-Meta|0.11|x86_64-linux-gnu-thread-multi|5.10.0|linux|2.6.28-11-generic|200904282227
3778505|pass|200904|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.0-release|200904281104
3778324|pass|200904|bingos@cpan.org|Test-CPAN-Meta|0.12|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.0-release|200904281018
3777038|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha|0.12|s390-linux|5.8.9|linux|2.6.5-7.315-s390|200904280622
3776828|pass|200904|bingos@cpan.org|Test-YAML-Meta|0.11|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.0-release|200904280344
3776119|pass|200904|vpit@cpan.org|WWW-UsePerl-Journal|0.22|x86_64-linux-thread-multi|5.10.0|linux|2.6.26.3-fuuka.profvince.com|200904272249
3774510|pass|200904|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-freebsd-thread-multi-64int|5.8.9|freebsd|6.4-release|200904271535
3774240|pass|200904|bingos@cpan.org|Test-CPAN-Meta|0.12|i386-freebsd-thread-multi-64int|5.8.9|freebsd|6.4-release|200904271442
3772230|pass|200904|bingos@cpan.org|Test-YAML-Meta|0.11|i386-freebsd-thread-multi-64int|5.10.0|freebsd|6.4-release|200904270516
3770154|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha|0.12|s390x-linux|5.8.8|linux|2.6.27.19-5-default|200904262127
3769775|pass|200904|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.0-release|200904261857
3769620|pass|200904|bingos@cpan.org|Test-CPAN-Meta|0.12|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.0-release|200904261813
3768426|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook-Loader-YAML|0.09|s390x-linux-thread-multi|5.8.9|linux|2.6.27.19-5-default|200904261352
3768425|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook|0.29|s390x-linux-thread-multi|5.8.9|linux|2.6.27.19-5-default|200904261351
3767428|pass|200904|bingos@cpan.org|Test-YAML-Meta|0.11|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.0-release|200904260847
3767415|pass|200904|dagolden@cpan.org (DAGOLDEN)|CPAN-Testers-WWW-Reports-Mailer|0.16|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.24-16-generic|200904260344
3766595|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.12|s390-linux-thread-multi|5.8.9|linux|2.6.5-7.315-s390|200904260615
3766324|pass|200904|bingos@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.16|i386-netbsd-thread-multi-64int|5.8.9|netbsd|3.1|200904260419
3766320|pass|200904|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-netbsd-thread-multi-64int|5.8.9|netbsd|3.1|200904260418
3765528|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Games-Trackword|1.06|s390x-linux-thread-multi-perlio|5.6.2|linux|2.6.27.19-5-default|200904260224
3765525|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Calendar-List|0.21|s390x-linux-thread-multi-perlio|5.6.2|linux|2.6.27.19-5-default|200904260224
3765474|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Generator|0.35|s390x-linux-thread-multi|5.8.9|linux|2.6.27.19-5-default|200904260215
3764304|pass|200904|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-freebsd-thread-multi-64int|5.10.0|freebsd|6.4-release|200904252115
3763929|pass|200904|bingos@cpan.org|Test-CPAN-Meta|0.12|i386-freebsd-thread-multi-64int|5.10.0|freebsd|6.4-release|200904252011
3763459|pass|200904|dagolden@cpan.org (DAGOLDEN)|CPAN-Testers-WWW-Reports-Mailer|0.16|i686-linux|5.8.9|linux|2.6.24-16-generic|200904251359
3761834|pass|200904|david@cantrell.org.uk|CPAN-Testers-WWW-Reports-Mailer|0.16|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200904250808
3760892|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Test-YAML-Meta|0.11|s390x-linux-thread-multi|5.8.9|linux|2.6.27.19-5-default|200904251141
3760804|pass|200904|wiml@hhhh.org ("Wim Lewis")|Test-CPAN-Meta|0.12|powerpc-netbsd-thread-multi|5.8.8|netbsd|4.0|200904250919
3760714|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Mail-Outlook|0.15|s390x-linux|5.8.8|linux|2.6.27.19-5-default|200904251104
3760214|pass|200904|bingos@cpan.org|Test-YAML-Meta|0.11|OpenBSD.i386-openbsd-thread-multi-64int|5.8.8|openbsd|4.4|200904250828
3760088|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.12|s390x-linux-thread-multi-perlio|5.6.2|linux|2.6.27.19-5-default|200904250856
3758756|pass|200904|wiml@hhhh.org ("Wim Lewis")|CPAN-Testers-WWW-Reports-Mailer|0.16|powerpc-netbsd-thread-multi|5.8.8|netbsd|4.0|200904250214
3758546|pass|200904|dagolden@cpan.org (DAGOLDEN)|CPAN-Testers-WWW-Reports-Mailer|0.16|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200904250139
3757921|pass|200904|bingos@cpan.org|Test-CPAN-Meta|0.12|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.0-release|200904250050
3757651|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Mailer|0.16|s390-linux-thread-multi|5.8.9|linux|2.6.5-7.315-s390|200904250106
3757581|pass|200904|srezic@cpan.org|Test-CPAN-Meta|0.12|amd64-freebsd-thread-multi|5.10.0|freebsd|7.0-release|200904250055
3757357|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Data-FormValidator-Constraints-Words|0.03|s390x-linux-thread-multi|5.6.2|linux|2.6.27.19-5-default|200904250021
3757262|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Mailer|0.16|s390-linux|5.8.9|linux|2.6.5-7.315-s390|200904250008
3756976|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Mailer|0.16|s390-linux|5.8.8|linux|2.6.5-7.315-s390|200904242318
3756246|pass|200904|stsc@refcnt.org ("Steven Schubiger")|CPAN-Testers-WWW-Reports-Mailer|0.16|i686-linux-thread-multi|5.10.0|linux|2.6.18-14-ovz-686|200904242140
3756076|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Mailer|0.16|s390x-linux-thread-multi|5.8.9|linux|2.6.16.60-0.31-default|200904242113
3755249|pass|200904|graham@crookham.uklinux.net (grahamc)|CPAN-Testers-WWW-Reports-Mailer|0.16|i686-linux-thread-multi|5.10.0|linux|2.6.27-11-server|200904241747
3755237|pass|200904|graham@crookham.uklinux.net (grahamc)|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.10.0|linux|2.6.27-11-server|200904241744
3754222|pass|200904|srezic@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.16|amd64-freebsd|5.8.9|freebsd|7.0-release|200904241627
3754069|pass|200904|JOST@cpan.org ("Josts Smokehouse")|CPAN-Testers-WWW-Reports-Mailer|0.16|i86pc-solaris-64int|5.8.9|solaris|2.11|200904241614
3753490|pass|200904|JOST@cpan.org ("Josts Smokehouse")|CPAN-Testers-WWW-Reports-Mailer|0.16|i86pc-solaris-64int|5.10.0|solaris|2.11|200904241444
3753115|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Mailer|0.16|s390-linux-thread-multi|5.10.0|linux|2.6.5-7.315-s390|200904241355
3752649|pass|200904|dagolden@cpan.org (DAGOLDEN)|CPAN-Testers-WWW-Reports-Mailer|0.16|i686-linux|5.10.0|linux|2.6.24-16-generic|200904240718
3752626|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Mailer|0.16|s390-linux|5.10.0|linux|2.6.5-7.315-s390|200904241316
3752207|pass|200904|david@cantrell.org.uk|CPAN-Testers-WWW-Reports-Mailer|0.16|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200904241145
3752191|pass|200904|graham@crookham.uklinux.net (grahamc)|CPAN-Testers-WWW-Reports-Mailer|0.16|i686-linux-thread-multi|5.8.9|linux|2.6.27-11-server|200904241144
3752161|pass|200904|graham@crookham.uklinux.net (grahamc)|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.8.9|linux|2.6.27-11-server|200904241140
3752137|pass|200904|david@cantrell.org.uk|CPAN-Testers-WWW-Reports-Mailer|0.16|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200904241137
3752069|pass|200904|david@cantrell.org.uk|CPAN-Testers-WWW-Reports-Mailer|0.16|x86_64-linux-thread-multi|5.10.0|linux|2.6.18-4-xen-amd64|200904241124
3752067|pass|200904|david@cantrell.org.uk|CPAN-Testers-WWW-Reports-Mailer|0.16|x86_64-linux-thread-multi|5.8.9|linux|2.6.18-4-xen-amd64|200904241124
3751862|pass|200904|david@cantrell.org.uk|CPAN-Testers-WWW-Reports-Mailer|0.16|x86_64-linux-thread-multi|5.6.2|linux|2.6.18-4-xen-amd64|200904241042
3751550|pass|200904|imacat@mail.imacat.idv.tw|CPAN-Testers-WWW-Reports-Mailer|0.16|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-1-amd64|200904241647
3751409|pass|200904|bingos@cpan.org|Test-CPAN-Meta|0.12|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.16.38|200904240926
3749666|pass|200904|srezic@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.16|amd64-freebsd|5.8.8|freebsd|7.0-release|200904240023
3748821|cpan|200904|BARBIE|CPAN-Testers-WWW-Reports-Mailer|0.16||0|||200904232016
3748463|pass|200904|bingos@cpan.org|Test-CPAN-Meta|0.12|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.16.38|200904231752
3747116|pass|200904|graham@crookham.uklinux.net (grahamc)|Test-CPAN-Meta|0.12|i686-linux-thread-multi|5.8.9|linux|2.6.27-11-server|200904221850
3745035|pass|200904|bingos@cpan.org|Test-YAML-Meta|0.11|i86pc-solaris-thread-multi-64int|5.8.9|solaris|2.10|200904230703
3744877|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Games-Trackword|1.06|s390x-linux-thread-multi|5.6.2|linux|2.6.27.19-5-default|200904230705
3744876|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Calendar-List|0.21|s390x-linux-thread-multi|5.6.2|linux|2.6.27.19-5-default|200904230704
3744829|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook-Loader-YAML|0.09|s390x-linux|5.10.0|linux|2.6.27.19-5-default|200904230647
3744826|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook|0.29|s390x-linux|5.10.0|linux|2.6.27.19-5-default|200904230647
3743463|pass|200904|bingos@cpan.org|Regexp-Log-Common|0.05|OpenBSD.i386-openbsd-thread-multi-64int|5.8.9|openbsd|4.4|200904222328
3743049|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Generator|0.35|s390x-linux|5.10.0|linux|2.6.27.19-5-default|200904222328
3741697|pass|200904|bingos@cpan.org|Regexp-Log-Common|0.05|alpha-linux-thread-multi|5.10.0|linux|2.6.18-5-alpha-generic|200904221803
3741531|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.12|s390-linux|5.8.8|linux|2.6.5-7.315-s390|200904221836
3741440|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.12|s390x-linux-thread-multi|5.6.2|linux|2.6.27.19-5-default|200904221811
3740929|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.12|s390-linux|5.8.9|linux|2.6.5-7.315-s390|200904221638
3740518|pass|200904|bingos@cpan.org|Test-CPAN-Meta|0.12|alpha-linux-thread-multi|5.10.0|linux|2.6.18-5-alpha-generic|200904221418
3739964|pass|200904|srezic@cpan.org|Test-CPAN-Meta|0.12|amd64-freebsd|5.10.0|freebsd|7.0-release|200904221114
3738633|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Test-YAML-Meta|0.11|s390x-linux|5.10.0|linux|2.6.27.19-5-default|200904220736
3738164|pass|200904|rafl@debian.org|Test-CPAN-Meta|0.12|i686-linux|5.10.0 patch 35117|linux|2.6.26|200904220523
3738075|pass|200904|bingos@cpan.org|Regexp-Log-Common|0.05|i86pc-solaris-thread-multi-64int|5.8.9|solaris|2.10|200904220354
3737526|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.12|s390-linux-thread-multi|5.10.0|linux|2.6.5-7.315-s390|200904220222
3737392|pass|200904|bingos@cpan.org|Test-CPAN-Meta|0.12|i86pc-solaris-thread-multi-64int|5.8.9|solaris|2.10|200904220034
3737173|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.12|s390-linux|5.10.0|linux|2.6.5-7.315-s390|200904220036
3736707|pass|200904|bingos@cpan.org|Test-YAML-Meta|0.11|OpenBSD.i386-openbsd-thread-multi-64int|5.10.0|openbsd|4.4|200904212158
3735943|pass|200904|graham@crookham.uklinux.net ("GRAHAMC")|Test-YAML-Meta|0.11|i686-linux-thread-multi|5.10.0|linux|2.6.27-11-generic|200904202214
3733597|pass|200904|bingos@cpan.org|Regexp-Log-Common|0.05|i86pc-solaris-thread-multi-64int|5.8.8|solaris|2.10|200904211314
3732593|pass|200904|bingos@cpan.org|Test-CPAN-Meta|0.12|i86pc-solaris-thread-multi-64int|5.8.8|solaris|2.10|200904211005
3731624|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook-Loader-YAML|0.09|s390x-linux-thread-multi|5.10.0|linux|2.6.27.19-5-default|200904210733
3731616|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook|0.29|s390x-linux-thread-multi|5.10.0|linux|2.6.27.19-5-default|200904210731
3730001|pass|200904|david@cantrell.org.uk|Test-CPAN-Meta|0.12|alpha-netbsd|5.10.0|netbsd|4.0.1|200904202257
3729630|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook-Loader-YAML|0.09|s390x-linux|5.8.9|linux|2.6.27.19-5-default|200904202328
3729623|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook|0.29|s390x-linux|5.8.9|linux|2.6.27.19-5-default|200904202327
3728788|pass|200904|bingos@cpan.org|Regexp-Log-Common|0.05|i86pc-solaris-thread-multi-64int|5.8.4|solaris|2.10|200904202053
3728748|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Parse-CPAN-Distributions|0.05|s390x-linux-thread-multi-perlio|5.6.2|linux|2.6.27.19-5-default|200904202147
3728505|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Uploads|0.06|s390x-linux|5.10.0|linux|2.6.27.19-5-default|200904202103
3728022|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-Article|0.36|s390x-linux|5.10.0|linux|2.6.27.19-5-default|200904201945
3727633|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Generator|0.35|s390x-linux-thread-multi|5.10.0|linux|2.6.27.19-5-default|200904201841
3727481|pass|200904|david@cantrell.org.uk|Test-CPAN-Meta|0.12|x86_64-linux-thread-multi|5.10.0|linux|2.6.18-4-xen-amd64|200904201719
3727363|pass|200904|bingos@cpan.org|Test-CPAN-Meta|0.12|i86pc-solaris-thread-multi-64int|5.8.4|solaris|2.10|200904201704
3727351|pass|200904|david@cantrell.org.uk|Test-CPAN-Meta|0.12|x86_64-linux-thread-multi|5.8.9|linux|2.6.18-4-xen-amd64|200904201703
3726997|pass|200904|pjacklam@online.no|Test-YAML-Meta|0.11|cygwin-thread-multi-64int|5.10.0 patch 34065|cygwin|1.5.25(0.15642)|200904201707
3726919|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha-Plugin-PingFM|0.02|s390x-linux|5.10.0|linux|2.6.27.19-5-default|200904201648
3724957|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal-Thread|0.12|s390x-linux-thread-multi-perlio|5.6.2|linux|2.6.27.19-5-default|200904201103
3724533|pass|200904|bingos@cpan.org|Test-CPAN-Meta|0.12|i386-netbsd-thread-multi-64int|5.8.9|netbsd|3.1|200904200838
3724293|pass|200904|bingos@cpan.org|Regexp-Log-Common|0.05|OpenBSD.i386-openbsd-thread-multi-64int|5.10.0|openbsd|4.4|200904200757
3723292|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Parse-CPAN-Distributions|0.05|s390x-linux-thread-multi|5.6.2|linux|2.6.27.19-5-default|200904200434
3723259|pass|200904|bingos@cpan.org|Regexp-Log-Common|0.05|i86pc-solaris-thread-multi-64int|5.10.0|solaris|2.10|200904200320
3722970|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal-Thread|0.12|s390x-linux-thread-multi|5.6.2|linux|2.6.27.19-5-default|200904200222
3722688|pass|200904|bingos@cpan.org|Test-CPAN-Meta|0.12|i86pc-solaris-thread-multi-64int|5.10.0|solaris|2.10|200904192339
3722053|pass|200904|srezic@cpan.org|Regexp-Log-Common|0.05|amd64-freebsd-thread-multi|5.10.0|freebsd|7.0-release|200904192114
3721532|pass|200904|mjg@phoenixtrap.com|Test-CPAN-Meta|0.12|darwin-thread-multi-2level|5.10.0|darwin|9.6.0|200904181058
3721383|pass|200904|doug@peaches.acomp.usf.edu ("Douglas Christopher Wilson")|Test-YAML-Meta|0.11|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.0-release-p7|200904190042
3721021|pass|200904|mjg@phoenixtrap.com|Test-YAML-Meta|0.11|darwin-thread-multi-2level|5.10.0|darwin|9.6.0|200904190209
3720934|pass|200904|rbo@cpan.org|Test-CPAN-Meta|0.12|i86pc-solaris|5.8.9|solaris|2.11|200904182101
3720456|pass|200904|bingos@cpan.org|Test-YAML-Meta|0.11|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.21.5-smp|200904191049
3719789|pass|200904|taro-nishino@wine.ocn.ne.jp ("Taro Nishino")|Test-CPAN-Meta|0.12|MSWin32-x86-multi-thread|5.8.8|MSWin32|5.0|200904191604
3719595|pass|200904|bingos@cpan.org|Test-YAML-Meta|0.11|OpenBSD.i386-openbsd-thread-multi-64int|5.8.8|openbsd|4.3|200904190646
3716100|pass|200904|bingos@cpan.org|Regexp-Log-Common|0.05|i386-netbsd-thread-multi-64int|5.8.9|netbsd|3.1|200904181940
3714948|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.12|s390x-linux-thread-multi|5.8.9|linux|2.6.16.60-0.31-default|200904181729
3714681|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.12|s390x-linux|5.8.9|linux|2.6.16.60-0.31-default|200904181642
3714577|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.12|s390x-linux-thread-multi|5.8.9|linux|2.6.18-92.1.18.el5|200904181627
3714287|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.12|s390x-linux|5.8.8|linux|2.6.16.60-0.31-default|200904181543
3714278|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.12|s390x-linux|5.8.9|linux|2.6.18-92.1.18.el5|200904181543
3713785|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal|0.22|s390-linux|5.8.9|linux|2.6.5-7.315-s390|200904181441
3713371|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.12|s390x-linux-thread-multi|5.8.8|linux|2.6.18-92.1.18.el5|200904181356
3713301|pass|200904|bingos@cpan.org|Regexp-Log-Common|0.05|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.21.5-smp|200904181247
3712635|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Regexp-Log-Common|0.05|s390x-linux-thread-multi|5.8.8|linux|2.6.27.19-5-default|200904181213
3711461|pass|200904|bingos@cpan.org|Test-YAML-Meta|0.11|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.21.5-smp|200904180555
3710701|pass|200904|bingos@cpan.org|Test-CPAN-Meta|0.12|darwin-thread-multi-64int-2level|5.8.9|darwin|8.11.0|200904180120
3710689|pass|200904|bingos@cpan.org|Test-CPAN-Meta|0.12|darwin-thread-multi-64int-2level|5.8.8|darwin|8.11.0|200904180118
3710633|pass|200904|bingos@cpan.org|Test-CPAN-Meta|0.12|darwin-thread-multi-64int-2level|5.10.0|darwin|8.11.0|200904180103
3710390|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal|0.22|s390-linux-thread-multi|5.10.0|linux|2.6.5-7.315-s390|200904180105
3708826|pass|200904|bingos@cpan.org|Regexp-Log-Common|0.05|OpenBSD.i386-openbsd-thread-multi-64int|5.8.8|openbsd|4.3|200904171814
3705713|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-WWW-Testers-Generator|0.30|s390x-linux-thread-multi|5.8.8|linux|2.6.16.60-0.31-default|200904170759
3705405|pass|200904|bingos@cpan.org|Test-YAML-Meta|0.11|OpenBSD.i386-openbsd-thread-multi-64int|5.8.9|openbsd|4.3|200904170507
3705017|pass|200904|bingos@cpan.org|Regexp-Log-Common|0.05|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.21.5-smp|200904170344
3704966|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Generator|0.35|s390x-linux|5.8.9|linux|2.6.27.19-5-default|200904170425
3703511|pass|200904|bingos@cpan.org|Test-YAML-Meta|0.11|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.21.5-smp|200904162230
3703062|pass|200904|david@cantrell.org.uk|WWW-UsePerl-Journal|0.22|alpha-netbsd|5.10.0|netbsd|4.0.1|200904161944
3702959|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Test-YAML-Meta|0.11|s390x-linux-thread-multi|5.10.0|linux|2.6.27.19-5-default|200904162121
3702934|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha|0.12|s390x-linux|5.10.0|linux|2.6.27.19-5-default|200904162114
3702578|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-WWW-Testers-Generator|0.30|s390x-linux|5.8.8|linux|2.6.16.60-0.31-default|200904161955
3701645|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Uploads|0.06|s390x-linux-thread-multi|5.8.9|linux|2.6.27.19-5-default|200904161644
3701303|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-Article|0.36|s390x-linux-thread-multi|5.8.9|linux|2.6.27.19-5-default|200904161547
3700565|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Test-YAML-Meta|0.11|s390x-linux|5.8.9|linux|2.6.27.19-5-default|200904161343
3700085|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha-Plugin-PingFM|0.02|s390x-linux-thread-multi|5.8.9|linux|2.6.27.19-5-default|200904161226
3699487|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Regexp-Log-Common|0.05|s390-linux|5.8.9|linux|2.6.5-7.315-s390|200904161027
3698180|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Mail-Outlook|0.15|s390x-linux|5.10.0|linux|2.6.27.19-5-default|200904160407
3698046|pass|200904|bingos@cpan.org|WWW-UsePerl-Journal|0.22|OpenBSD.i386-openbsd-thread-multi-64int|5.8.9|openbsd|4.3|200904160225
3697302|pass|200904|andy@hexten.net|Test-YAML-Meta|0.11|i686-linux-thread-multi|5.10.0|linux|2.6.28-11-generic|200904160003
3693468|pass|200904|bingos@cpan.org|Test-YAML-Meta|0.11|OpenBSD.i386-openbsd-thread-multi-64int|5.10.0|openbsd|4.3|200904151258
3692233|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha|0.12|s390x-linux-thread-multi|5.8.9|linux|2.6.27.19-5-default|200904151043
3691663|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Uploads|0.06|s390x-linux-thread-multi|5.10.0|linux|2.6.27.19-5-default|200904150756
3691498|pass|200904|bingos@cpan.org|WWW-UsePerl-Journal|0.22|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.16.38|200904150606
3691447|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-Article|0.36|s390x-linux-thread-multi|5.10.0|linux|2.6.27.19-5-default|200904150651
3690856|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha-Plugin-PingFM|0.02|s390x-linux-thread-multi|5.10.0|linux|2.6.27.19-5-default|200904150410
3690279|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook-Loader-YAML|0.09|s390-linux-thread-multi|5.10.0|linux|2.6.5-7.315-s390|200904150140
3690277|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook|0.29|s390-linux-thread-multi|5.10.0|linux|2.6.5-7.315-s390|200904150140
3690193|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook-Loader-YAML|0.09|s390x-linux|5.8.9|linux|2.6.16.60-0.31-default|200904150120
3690187|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook|0.29|s390x-linux|5.8.9|linux|2.6.16.60-0.31-default|200904150119
3687026|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Generator|0.35|s390-linux-thread-multi|5.10.0|linux|2.6.5-7.315-s390|200904141341
3686923|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Regexp-Log-Common|0.05|s390-linux|5.8.8|linux|2.6.5-7.315-s390|200904141309
3686561|pass|200904|bingos@cpan.org|WWW-UsePerl-Journal|0.22|OpenBSD.i386-openbsd-thread-multi-64int|5.10.0|openbsd|4.3|200904141051
3685866|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Mail-Outlook|0.15|s390x-linux-thread-multi|5.8.9|linux|2.6.27.19-5-default|200904140833
3685805|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha|0.12|s390x-linux-thread-multi|5.10.0|linux|2.6.27.19-5-default|200904140813
3683373|pass|200904|bingos@cpan.org|Regexp-Log-Common|0.05|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.0-release|200904132039
3683129|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Regexp-Log-Common|0.05|s390x-linux|5.8.8|linux|2.6.27.19-5-default|200904132024
3682875|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Test-YAML-Meta|0.11|s390-linux-thread-multi|5.10.0|linux|2.6.5-7.315-s390|200904131921
3680868|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal|0.22|s390-linux-thread-multi|5.8.9|linux|2.6.5-7.315-s390|200904130630
3680117|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal|0.22|s390-linux|5.8.8|linux|2.6.5-7.315-s390|200904130018
3679943|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Mailer|0.15|s390x-linux|5.8.9|linux|2.6.27.19-5-default|200904122238
3679940|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Regexp-Log-Common|0.05|s390x-linux-thread-multi|5.8.9|linux|2.6.18-92.1.18.el5|200904122237
3679817|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Mail-Outlook|0.15|s390x-linux-thread-multi|5.10.0|linux|2.6.27.19-5-default|200904122142
3679356|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Regexp-Log-Common|0.05|s390x-linux|5.8.8|linux|2.6.18-92.1.18.el5|200904121903
3678986|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Regexp-Log-Common|0.05|s390x-linux|5.8.9|linux|2.6.18-92.1.18.el5|200904121702
3678602|pass|200904|bingos@cpan.org|Test-YAML-Meta|0.11|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.16.38|200904121443
3678146|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Regexp-Log-Common|0.05|s390-linux|5.10.0|linux|2.6.5-7.315-s390|200904121425
3678037|pass|200904|bingos@cpan.org|Regexp-Log-Common|0.05|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.0-release|200904121256
3677786|pass|200904|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.0-release|200904121147
3676954|pass|200904|bingos@cpan.org|Test-YAML-Meta|0.11|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.0-release|200904120853
3676050|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal|0.22|s390x-linux|5.8.8|linux|2.6.27.19-5-default|200904120628
3675847|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Regexp-Log-Common|0.05|s390x-linux|5.8.9|linux|2.6.27.19-5-default|200904120538
3675339|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal|0.22|s390x-linux-thread-multi|5.10.0|linux|2.6.27.19-5-default|200904120313
3675202|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Regexp-Log-Common|0.05|s390x-linux|5.10.0|linux|2.6.27.19-5-default|200904120236
3674198|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Mailer|0.15|s390x-linux-thread-multi|5.8.9|linux|2.6.27.19-5-default|200904112218
3672225|pass|200904|bingos@cpan.org|Regexp-Log-Common|0.05|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.16.38|200904111503
3672193|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal|0.22|s390-linux|5.10.0|linux|2.6.5-7.315-s390|200904111557
3671784|pass|200904|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.16.38|200904111353
3670714|pass|200904|bingos@cpan.org|Test-YAML-Meta|0.11|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.16.38|200904110935
3670678|pass|200904|stro@cpan.org|Regexp-Log-Common|0.05|MSWin32-x86-multi-thread|5.8.9|MSWin32|5.00|200904110124
3669896|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal|0.22|s390x-linux-thread-multi|5.8.9|linux|2.6.27.19-5-default|200904110626
3669827|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal|0.22|s390x-linux|5.8.9|linux|2.6.27.19-5-default|200904110610
3669670|pass|200904|justin.hunter@asu.edu|Test-YAML-Meta|0.11|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-19-server|200904100308
3669158|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal|0.22|s390x-linux|5.10.0|linux|2.6.27.19-5-default|200904110354
3667900|pass|200904|stro@cpan.org|WWW-UsePerl-Journal|0.22|MSWin32-x86-multi-thread|5.8.9|MSWin32|5.00|200904101352
3666282|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal|0.22|s390x-linux-thread-multi-perlio|5.6.2|linux|2.6.27.19-5-default|200904101611
3665914|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal|0.22|s390x-linux-thread-multi|5.6.2|linux|2.6.27.19-5-default|200904101442
3665773|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal|0.22|s390x-linux|5.6.2|linux|2.6.27.19-5-default|200904101408
3665217|pass|200904|bingos@cpan.org|Regexp-Log-Common|0.05|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.16.38|200904101130
3664710|pass|200904|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.16.38|200904101000
3663079|pass|200904|rbo@cpan.org|WWW-UsePerl-Journal|0.22|i86pc-solaris|5.8.9|solaris|2.11|200904092000
3662012|pass|200904|bingos@cpan.org|Test-YAML-Meta|0.11|i686-linux-64int-ld|5.11.0|linux|2.6.16.38|200904092229
3661531|pass|200904|bingos@cpan.org|Regexp-Log-Common|0.05|darwin-64int-2level|5.11.0|darwin|8.11.0|200904092040
3660794|pass|200904|david@cantrell.org.uk|WWW-UsePerl-Journal|0.22|x86_64-linux-thread-multi|5.10.0|linux|2.6.18-4-xen-amd64|200904091730
3660793|pass|200904|david@cantrell.org.uk|WWW-UsePerl-Journal|0.22|x86_64-linux-thread-multi|5.8.9|linux|2.6.18-4-xen-amd64|200904091730
3660776|pass|200904|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|darwin-64int-2level|5.11.0|darwin|8.11.0|200904091727
3660481|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Regexp-Log-Common|0.05|s390x-linux-thread-multi|5.8.8|linux|2.6.18-92.1.18.el5|200904091747
3660462|pass|200904|david@cantrell.org.uk|WWW-UsePerl-Journal|0.22|x86_64-linux-thread-multi|5.6.2|linux|2.6.18-4-xen-amd64|200904091645
3659944|pass|200904|rbo@consol.de|CPAN-Testers-Common-DBUtils|0.03|i86pc-solaris|5.8.9|solaris|2.11|200904091326
3659512|pass|200904|rbo@consol.de|Regexp-Log-Common|0.05|i86pc-solaris|5.8.9|solaris|2.11|200904091406
3658482|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Regexp-Log-Common|0.05|s390x-linux-thread-multi|5.8.9|linux|2.6.27.19-5-default|200904091119
3658227|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Regexp-Log-Common|0.05|s390x-linux-thread-multi|5.10.0|linux|2.6.27.19-5-default|200904091020
3658124|pass|200904|mw487.yahoo.com@gmail.com|Regexp-Log-Common|0.05|cygwin-thread-multi-64int|0|cygwin|1.5.25(0.15642)|200904090302
3658024|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Regexp-Log-Common|0.05|s390x-linux-thread-multi|5.8.9|linux|2.6.16.60-0.31-default|200904090936
3657337|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Regexp-Log-Common|0.05|s390-linux-thread-multi|5.8.9|linux|2.6.5-7.315-s390|200904090644
3656237|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Mail-Outlook|0.15|s390x-linux|5.6.2|linux|2.6.27.19-5-default|200904090253
3655586|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Regexp-Log-Common|0.05|s390x-linux|5.8.9|linux|2.6.16.60-0.31-default|200904090111
3655224|pass|200904|bingos@cpan.org|Regexp-Log-Common|0.05|i686-linux-64int-ld|5.11.0|linux|2.6.16.38|200904082316
3654557|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-Article|0.36|s390x-linux|5.6.2|linux|2.6.27.19-5-default|200904082319
3654361|pass|200904|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i686-linux-64int-ld|5.11.0|linux|2.6.16.38|200904082157
3653977|pass|200904|david@cantrell.org.uk|Regexp-Log-Common|0.05|alpha-netbsd|5.10.0|netbsd|4.0.1|200904082009
3653387|pass|200904|bingos@cpan.org|Regexp-Log-Common|0.05|i386-netbsd-thread-multi-64int|5.8.8|netbsd|4.0|200904081915
3652738|pass|200904|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-netbsd-thread-multi-64int|5.8.8|netbsd|4.0|200904081734
3652623|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Regexp-Log-Common|0.05|s390-linux-thread-multi|5.10.0|linux|2.6.5-7.315-s390|200904081823
3651665|pass|200904|bingos@cpan.org|Regexp-Log-Common|0.05|alpha-linux-thread-multi|5.8.9|linux|2.6.18-5-alpha-generic|200904081409
3651379|pass|200904|srezic@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.15|amd64-freebsd|5.10.0|freebsd|7.0-release|200904081414
3650952|pass|200904|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|alpha-linux-thread-multi|5.8.9|linux|2.6.18-5-alpha-generic|200904081226
3650489|pass|200904|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-netbsd-thread-multi-64int|5.8.8|netbsd|4.0|200904081102
3649660|pass|200904|stsc@refcnt.org ("Steven Schubiger")|CPAN-Testers-WWW-Reports-Mailer|0.15|i686-linux-thread-multi|5.10.0|linux|2.6.18-14-ovz-686|200904080925
3647159|pass|200904|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-netbsd-thread-multi-64int|5.8.9|netbsd|4.0|200904080011
3644953|pass|200904|bingos@cpan.org|Regexp-Log-Common|0.05|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.21.5-smp|200904071924
3644797|pass|200904|vpit@cpan.org|Regexp-Log-Common|0.05|x86_64-linux-thread-multi|5.10.0|linux|2.6.26.3-fuuka.profvince.com|200904072000
3644710|pass|200904|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.21.5-smp|200904071844
3644474|pass|200904|david@cantrell.org.uk|CPAN-Testers-WWW-Reports-Mailer|0.15|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200904071741
3643225|pass|200904|bingos@cpan.org|Regexp-Log-Common|0.05|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0|200904071333
3642443|pass|200904|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0|200904071142
3641521|pass|200904|bingos@cpan.org|Regexp-Log-Common|0.05|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.21.5-smp|200904070932
3641139|pass|200904|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.21.5-smp|200904070826
3639192|pass|200904|david@cantrell.org.uk|Regexp-Log-Common|0.05|x86_64-linux-thread-multi|5.10.0|linux|2.6.18-4-xen-amd64|200904070014
3639181|pass|200904|david@cantrell.org.uk|Regexp-Log-Common|0.05|x86_64-linux-thread-multi|5.8.9|linux|2.6.18-4-xen-amd64|200904070013
3637178|pass|200904|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.21.5-smp|200904062008
3636640|pass|200904|srezic@cpan.org|Regexp-Log-Common|0.05|amd64-freebsd|5.10.0|freebsd|7.0-release|200904061910
3635724|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Mail-Outlook|0.15|s390x-linux-thread-multi|5.6.2|linux|2.6.27.19-5-default|200904061505
3634252|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-Article|0.36|s390x-linux-thread-multi|5.6.2|linux|2.6.27.19-5-default|200904061021
3634153|pass|200904|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.16.38|200904060903
3633771|pass|200904|wiml@hhhh.org ("Wim Lewis")|CPAN-Testers-WWW-Reports-Mailer|0.15|powerpc-netbsd-thread-multi|5.8.8|netbsd|4.0|200904060623
3633295|pass|200904|bingos@cpan.org|Regexp-Log-Common|0.05|darwin-thread-multi-64int-2level|5.8.9|darwin|8.11.0|200904060514
3633282|pass|200904|bingos@cpan.org|Regexp-Log-Common|0.05|darwin-thread-multi-64int-2level|5.8.8|darwin|8.11.0|200904060510
3633271|pass|200904|bingos@cpan.org|Regexp-Log-Common|0.05|darwin-thread-multi-64int-2level|5.8.6|darwin|8.11.0|200904060506
3633256|pass|200904|bingos@cpan.org|Regexp-Log-Common|0.05|darwin-thread-multi-64int-2level|5.10.0|darwin|8.11.0|200904060503
3631922|pass|200904|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0.1|200904060019
3631741|pass|200904|david@cantrell.org.uk|CPAN-Testers-WWW-Reports-Mailer|0.15|x86_64-linux-thread-multi|5.10.0|linux|2.6.18-4-xen-amd64|200904052342
3631739|pass|200904|david@cantrell.org.uk|CPAN-Testers-WWW-Reports-Mailer|0.15|x86_64-linux-thread-multi|5.8.9|linux|2.6.18-4-xen-amd64|200904052342
3631424|pass|200904|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.16.38|200904052300
3630851|pass|200904|JOST@cpan.org ("Josts Smokehouse")|CPAN-Testers-WWW-Reports-Mailer|0.15|i86pc-solaris-64int|5.8.9|solaris|2.11|200904052124
3630768|pass|200904|JOST@cpan.org ("Josts Smokehouse")|CPAN-Testers-WWW-Reports-Mailer|0.15|i86pc-solaris-64int|5.10.0|solaris|2.11|200904052102
3628944|pass|200904|david@cantrell.org.uk|CPAN-Testers-Common-DBUtils|0.03|x86_64-linux-thread-multi|5.6.2|linux|2.6.18-4-xen-amd64|200904051358
3628111|pass|200904|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.16.38|200904051147
3627123|pass|200904|srezic@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.15|amd64-freebsd|5.8.9|freebsd|7.0-release|200904050646
3627120|pass|200904|srezic@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.15|amd64-freebsd|5.8.8|freebsd|7.0-release|200904050646
3626066|pass|200904|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|darwin-thread-multi-64int-2level|5.11.0|darwin|8.11.0|200904050239
3623857|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Mail-Outlook|0.15|s390x-linux-thread-multi-perlio|5.6.2|linux|2.6.27.19-5-default|200904041932
3622782|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-Article|0.36|s390x-linux|5.8.9|linux|2.6.27.19-5-default|200904041716
3622111|cpan|200904|BARBIE|CPAN-Testers-WWW-Reports-Mailer|0.15||0|||200904041549
3621387|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-Article|0.36|s390x-linux-thread-multi-perlio|5.6.2|linux|2.6.27.19-5-default|200904041402
3621371|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha-Plugin-PingFM|0.02|s390x-linux|5.8.9|linux|2.6.27.19-5-default|200904041359
3618906|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Test-YAML-Meta|0.11|s390x-linux|5.8.9|linux|2.6.16.60-0.31-default|200904040355
3618100|pass|200904|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-freebsd-thread-multi-64int|5.10.0|freebsd|6.4-release|200904032310
3615755|pass|200904|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0|200904031419
3614326|pass|200904|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.1-release|200904031035
3612627|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha|0.12|s390x-linux|5.8.9|linux|2.6.27.19-5-default|200904030308
3612329|pass|200904|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-netbsd-thread-multi-64int|5.10.0|netbsd|3.1|200904030112
3611639|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Games-Trackword|1.06|s390x-linux|5.8.8|linux|2.6.18-92.1.18.el5|200904022324
3611634|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Calendar-List|0.21|s390x-linux|5.8.8|linux|2.6.18-92.1.18.el5|200904022323
3611007|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook-Loader-YAML|0.09|s390-linux|5.8.8|linux|2.6.5-7.315-s390|200904022031
3611004|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook|0.29|s390-linux|5.8.8|linux|2.6.5-7.315-s390|200904022031
3610701|pass|200904|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.1-release|200904021832
3608837|pass|200904|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|alpha-linux-thread-multi|5.10.0|linux|2.6.18-5-alpha-generic|200904021305
3608490|pass|200904|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.0-release|200904021155
3608367|pass|200904|robertl@apnic.net ("Robert Loomans")|Test-YAML-Meta|0.11|darwin-2level|5.8.9|darwin|9.6.0|200904021313
3607255|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Mail-Outlook|0.15|s390x-linux|5.8.9|linux|2.6.27.19-5-default|200904020910
3605564|pass|200904|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.0-release|200904020147
3605482|pass|200904|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.1-release|200904020134
3604730|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook-Loader-YAML|0.09|s390x-linux|5.8.9|linux|2.6.18-92.1.18.el5|200904012307
3604726|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook|0.29|s390x-linux|5.8.9|linux|2.6.18-92.1.18.el5|200904012306
3604448|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook-Loader-YAML|0.09|s390x-linux-thread-multi|5.8.9|linux|2.6.18-92.1.18.el5|200904012151
3604442|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook|0.29|s390x-linux-thread-multi|5.8.9|linux|2.6.18-92.1.18.el5|200904012150
3604096|pass|200904|cpan@sourcentral.org ("Oliver Paukstadt")|Data-FormValidator-Constraints-Words|0.03|s390-linux-thread-multi-perlio|5.6.2|linux|2.6.5-7.315-s390|200904012006
3603324|pass|200904|schwern@pobox.com|Test-YAML-Meta|0.11|darwin-thread-multi-2level|5.10.0|darwin|8.11.1|200904011345
3599222|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-DBUtils|0.03|s390x-linux-thread-multi|5.8.9|linux|2.6.27.19-5-default|200903312028
3598463|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-DBUtils|0.03|s390x-linux-thread-multi|5.10.0|linux|2.6.27.19-5-default|200903311753
3596980|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|Data-FormValidator-Constraints-Words|0.03|s390-linux-thread-multi|5.6.2|linux|2.6.5-7.315-s390|200903311203
3594836|pass|200903|JOST@cpan.org ("Josts Smokehouse")|CPAN-Testers-WWW-Statistics|0.62|i86pc-solaris-64int|5.8.9|solaris|2.11|200903310119
3594733|pass|200903|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.0-release|200903310001
3594464|pass|200903|woody@2143.net|Test-YAML-Meta|0.11|i686-linux|5.8.8|linux|2.6.24-gentoo-r4|200903302215
3593561|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook-Loader-YAML|0.09|s390-linux|5.10.0|linux|2.6.5-7.315-s390|200903302141
3593558|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook|0.29|s390-linux|5.10.0|linux|2.6.5-7.315-s390|200903302140
3593537|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|Data-FormValidator-Constraints-Words|0.03|s390-linux|5.6.2|linux|2.6.5-7.315-s390|200903302133
3589751|pass|200903|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|darwin-thread-multi-64int-2level|5.10.0 patch 35117|darwin|8.11.0|200903300039
3587757|pass|200903|david@cantrell.org.uk|CPAN-Testers-WWW-Statistics|0.62|x86_64-linux-thread-multi|5.8.9|linux|2.6.18-4-xen-amd64|200903291636
3586929|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-Article|0.36|s390x-linux-thread-multi|5.8.9|linux|2.6.18-92.1.18.el5|200903291315
3586781|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-DBUtils|0.03|s390-linux-thread-multi|5.8.9|linux|2.6.5-7.315-s390|200903291222
3586772|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|Games-Trackword|1.06|s390-linux-thread-multi-perlio|5.6.2|linux|2.6.5-7.315-s390|200903291218
3586768|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|Calendar-List|0.21|s390-linux-thread-multi-perlio|5.6.2|linux|2.6.5-7.315-s390|200903291217
3585445|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-DBUtils|0.03|s390-linux|5.8.9|linux|2.6.5-7.315-s390|200903290857
3584148|pass|200903|wiml@hhhh.org ("Wim Lewis")|CPAN-Testers-WWW-Statistics|0.62|powerpc-netbsd-thread-multi|5.8.8|netbsd|4.0|200903290128
3583995|pass|200903|mw487.yahoo.com@gmail.com|Test-YAML-Meta|0.11|cygwin-thread-multi-64int|5.10.0 patch 34065|cygwin|1.5.25(0.15642)|200903290057
3583904|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-Article|0.36|s390x-linux|5.8.9|linux|2.6.18-92.1.18.el5|200903290132
3582839|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-Article|0.36|s390x-linux|5.8.9|linux|2.6.16.60-0.31-default|200903282124
3582493|pass|200903|JOST@cpan.org ("Josts Smokehouse")|CPAN-Testers-WWW-Statistics|0.62|i86pc-solaris-64int|5.10.0|solaris|2.11|200903281957
3582191|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|Games-Trackword|1.06|s390-linux-thread-multi|5.6.2|linux|2.6.5-7.315-s390|200903281839
3582189|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|Calendar-List|0.21|s390-linux-thread-multi|5.6.2|linux|2.6.5-7.315-s390|200903281838
3582046|pass|200903|srezic@cpan.org|CPAN-Testers-WWW-Statistics|0.62|amd64-freebsd|5.10.0|freebsd|7.0-release|200903281716
3580876|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-DBUtils|0.03|s390x-linux|5.8.8|linux|2.6.27.19-5-default|200903281401
3580751|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-DBUtils|0.03|s390x-linux|5.8.9|linux|2.6.27.19-5-default|200903281334
3580401|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-DBUtils|0.03|s390x-linux|5.10.0|linux|2.6.27.19-5-default|200903281224
3580392|pass|200903|mw487.yahoo.com@gmail.com|Test-CPAN-Meta|0.12|cygwin-thread-multi-64int|5.10.0 patch 34065|cygwin|1.5.25(0.15642)|200903280623
3580327|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|Games-Trackword|1.06|s390-linux|5.6.2|linux|2.6.5-7.315-s390|200903281211
3580325|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|Calendar-List|0.21|s390-linux|5.6.2|linux|2.6.5-7.315-s390|200903281210
3580262|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha-Plugin-PingFM|0.02|s390x-linux-thread-multi|5.8.9|linux|2.6.18-92.1.18.el5|200903281156
3577617|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha-Plugin-PingFM|0.02|s390x-linux|5.8.9|linux|2.6.18-92.1.18.el5|200903280347
3576650|pass|200903|stsc@refcnt.org ("Steven Schubiger")|CPAN-Testers-WWW-Statistics|0.62|i686-linux-thread-multi|5.10.0|linux|2.6.18-14-ovz-686|200903272320
3576301|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha-Plugin-PingFM|0.02|s390x-linux|5.8.9|linux|2.6.16.60-0.31-default|200903272211
3575772|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.12|s390-linux-thread-multi-perlio|5.6.2|linux|2.6.5-7.315-s390|200903271907
3575098|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|Mail-Outlook|0.15|s390x-linux-thread-multi|5.8.9|linux|2.6.16.60-0.31-default|200903271511
3574745|pass|200903|srezic@cpan.org|CPAN-Testers-WWW-Statistics|0.62|amd64-freebsd|5.8.8|freebsd|7.0-release|200903271240
3574375|pass|200903|srezic@cpan.org|CPAN-Testers-WWW-Statistics|0.62|amd64-freebsd|5.8.9|freebsd|7.0-release|200903271139
3574097|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.12|s390-linux-thread-multi|5.6.2|linux|2.6.5-7.315-s390|200903271013
3574036|cpan|200903|BARBIE|CPAN-Testers-WWW-Statistics|0.62||0|||200903270956
3573276|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|Mail-Outlook|0.15|s390-linux|5.8.9|linux|2.6.5-7.315-s390|200903270454
3573101|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.12|s390-linux|5.6.2|linux|2.6.5-7.315-s390|200903270329
3570724|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|GD-Chart-Radial|0.07|s390x-linux|5.6.2|linux|2.6.18-92.1.18.el5|200903261149
3569987|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha|0.12|s390x-linux|5.8.9|linux|2.6.16.60-0.31-default|200903260651
3568455|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|Test-YAML-Meta|0.11|s390-linux|5.8.8|linux|2.6.5-7.315-s390|200903260105
3568027|pass|200903|dagolden@cpan.org (DAGOLDEN)|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi-64int-ld|5.6.2|linux|2.6.24-16-generic|200903251815
3565712|pass|200903|dagolden@cpan.org (DAGOLDEN)|CPAN-Testers-WWW-Reports-Mailer|0.14|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.24-16-generic|200903251038
3565709|pass|200903|dagolden@cpan.org (DAGOLDEN)|CPAN-Testers-Data-Generator|0.35|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.24-16-generic|200903251037
3564410|pass|200903|JOST@cpan.org ("Josts Smokehouse")|CPAN-Testers-WWW-Statistics|0.61|i86pc-solaris-64int|5.10.0|solaris|2.11|200903251053
3563932|pass|200903|dagolden@cpan.org (DAGOLDEN)|CPAN-Testers-Data-Uploads|0.06|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.24-16-generic|200903250433
3563861|pass|200903|dagolden@cpan.org (DAGOLDEN)|CPAN-Testers-Common-Article|0.36|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.24-16-generic|200903250425
3563657|pass|200903|dagolden@cpan.org (DAGOLDEN)|CPAN-WWW-Testers|0.49|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.24-16-generic|200903250351
3563579|pass|200903|dagolden@cpan.org (DAGOLDEN)|App-Maisha-Plugin-PingFM|0.02|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.24-16-generic|200903250332
3563573|pass|200903|dagolden@cpan.org (DAGOLDEN)|App-Maisha|0.12|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.24-16-generic|200903250331
3562015|pass|200903|dagolden@cpan.org (DAGOLDEN)|Mail-Outlook|0.15|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.24-16-generic|200903250236
3560642|fail|200903|stsc@refcnt.org ("Steven Schubiger")|CPAN-Testers-WWW-Statistics|0.61|i686-linux-thread-multi|5.10.0|linux|2.6.18-14-ovz-686|200903242305
3558450|pass|200903|srezic@cpan.org|CPAN-Testers-WWW-Statistics|0.61|amd64-freebsd|5.8.9|freebsd|7.0-release|200903241838
3558445|pass|200903|srezic@cpan.org|CPAN-Testers-WWW-Statistics|0.61|amd64-freebsd|5.8.8|freebsd|7.0-release|200903241838
3556396|cpan|200903|BARBIE|CPAN-Testers-WWW-Statistics|0.61||0|||200903241353
3554299|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|Parse-CPAN-Distributions|0.05|s390-linux-thread-multi-perlio|5.6.2|linux|2.6.5-7.315-s390|200903240901
3553828|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|Parse-CPAN-Distributions|0.05|s390-linux-thread-multi|5.6.2|linux|2.6.5-7.315-s390|200903240803
3553541|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|Parse-CPAN-Distributions|0.05|s390-linux|5.6.2|linux|2.6.5-7.315-s390|200903240718
3552315|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|Data-FormValidator-Constraints-Words|0.03|s390x-linux|5.6.2|linux|2.6.16.60-0.31-default|200903240336
3549531|pass|200903|stro@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.08|MSWin32-x86-multi-thread|5.8.8|MSWin32|5.00|200903231235
3549518|pass|200903|stro@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.12|MSWin32-x86-multi-thread|5.8.8|MSWin32|5.00|200903231235
3549515|pass|200903|stro@cpan.org|CPAN-Testers-WWW-Statistics|0.55|MSWin32-x86-multi-thread|5.8.8|MSWin32|5.00|200903231237
3549360|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|Mail-Outlook|0.15|s390-linux-thread-multi|5.8.9|linux|2.6.5-7.315-s390|200903231932
3549121|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-DBUtils|0.03|s390-linux|5.10.0|linux|2.6.5-7.315-s390|200903231525
3549003|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|Test-YAML-Meta|0.11|s390-linux|5.10.0|linux|2.6.5-7.315-s390|200903231340
3548764|pass|200903|dagolden@cpan.org (DAGOLDEN)|Data-Phrasebook-Loader-DBI|0.11|i686-linux|5.8.9|linux|2.6.24-16-generic|200903232105
3548762|pass|200903|dagolden@cpan.org (DAGOLDEN)|Data-Phrasebook-Loader-Ini|0.10|i686-linux|5.8.9|linux|2.6.24-16-generic|200903232104
3548755|pass|200903|dagolden@cpan.org (DAGOLDEN)|Data-Phrasebook-Loader-XML|0.12|i686-linux|5.8.9|linux|2.6.24-16-generic|200903232104
3548690|pass|200903|dagolden@cpan.org (DAGOLDEN)|Mail-File|0.08|i686-linux|5.8.9|linux|2.6.24-16-generic|200903232102
3548312|pass|200903|dagolden@cpan.org (DAGOLDEN)|CPAN-YACSmoke-Plugin-Outlook|0.06|i686-linux|5.8.9|linux|2.6.24-16-generic|200903232046
3546284|pass|200903|yary@pinky.yary.ack.org ((Yary Hluchan IV))|Test-YAML-Meta|0.11|OpenBSD.i386-openbsd-thread-multi|5.10.0|openbsd|3.9|200903201500
3544917|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha|0.12|s390x-linux|5.8.9|linux|2.6.18-92.1.18.el5|200903232004
3544224|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha|0.12|s390x-linux-thread-multi|5.8.9|linux|2.6.18-92.1.18.el5|200903231948
3540697|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|GD-Chart-Radial|0.07|s390x-linux-thread-multi|5.6.2|linux|2.6.18-92.1.18.el5|200903221237
3539376|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha-Plugin-PingFM|0.02|s390-linux|5.10.0|linux|2.6.5-7.315-s390|200903220804
3537472|fail|200903|dagolden@cpan.org (DAGOLDEN)|Finance-Currency-Convert-XE|0.15|i686-linux|5.8.9|linux|2.6.24-16-generic|200903211845
3537078|pass|200903|dagolden@cpan.org (DAGOLDEN)|Data-FormValidator-Constraints-Words|0.03|i686-linux|5.8.9|linux|2.6.24-16-generic|200903211748
3535225|pass|200903|dagolden@cpan.org (DAGOLDEN)|Games-Trackword|1.06|i686-linux|5.8.9|linux|2.6.24-16-generic|200903211115
3535224|pass|200903|dagolden@cpan.org (DAGOLDEN)|Calendar-List|0.21|i686-linux|5.8.9|linux|2.6.24-16-generic|200903211115
3534524|pass|200903|dagolden@cpan.org (DAGOLDEN)|Test-CPAN-Meta|0.12|i686-linux|5.8.9|linux|2.6.24-16-generic|200903210850
3534522|pass|200903|dagolden@cpan.org (DAGOLDEN)|WWW-Scraper-ISBN-ORA_Driver|0.09|i686-linux|5.8.9|linux|2.6.24-16-generic|200903210850
3534519|fail|200903|dagolden@cpan.org (DAGOLDEN)|WWW-Scraper-ISBN-Pearson_Driver|0.10|i686-linux|5.8.9|linux|2.6.24-16-generic|200903210849
3533501|pass|200903|stro@cpan.org|CPAN-WWW-Testers|0.37|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.00|200903211116
3533441|pass|200903|stro@cpan.org|CPAN-WWW-Testers|0.36|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.00|200903211109
3533159|pass|200903|stro@cpan.org|App-Maisha-Plugin-PingFM|0.01|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.00|200903211034
3532994|pass|200903|stro@cpan.org|CPAN-WWW-Testers|0.37|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.00|200903211012
3532954|pass|200903|stro@cpan.org|CPAN-WWW-Testers|0.36|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.00|200903211003
3532920|pass|200903|stro@cpan.org|CPAN-WWW-Testers|0.35|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.00|200903210955
3532869|pass|200903|stro@cpan.org|CPAN-WWW-Testers|0.34|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.00|200903210950
3532852|pass|200903|stro@cpan.org|CPAN-WWW-Testers|0.33|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.00|200903210945
3532846|pass|200903|stro@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.08|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.00|200903210944
3531694|pass|200903|dagolden@cpan.org (DAGOLDEN)|Parse-CPAN-Distributions|0.05|i686-linux|5.8.9|linux|2.6.24-16-generic|200903210044
3531332|pass|200903|dagolden@cpan.org (DAGOLDEN)|WWW-UsePerl-Journal-Thread|0.12|i686-linux|5.8.9|linux|2.6.24-16-generic|200903210002
3531330|pass|200903|dagolden@cpan.org (DAGOLDEN)|WWW-UsePerl-Journal|0.22|i686-linux|5.8.9|linux|2.6.24-16-generic|200903210002
3531224|pass|200903|dagolden@cpan.org (DAGOLDEN)|CPAN-WWW-Testers-Generator|0.30|i686-linux|5.8.9|linux|2.6.24-16-generic|200903210349
3530840|pass|200903|jeff@zeroclue.com|CPAN-Testers-WWW-Statistics|0.55|OpenBSD.i386-openbsd|5.8.9|openbsd|4.4|200903210245
3529237|pass|200903|dagolden@cpan.org (DAGOLDEN)|Regexp-Log-Common|0.05|i686-linux|5.8.9|linux|2.6.24-16-generic|200903201838
3528805|pass|200903|dagolden@cpan.org (DAGOLDEN)|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i686-linux|5.8.9|linux|2.6.24-16-generic|200903201739
3528799|fail|200903|dagolden@cpan.org (DAGOLDEN)|WWW-Scraper-ISBN-Amazon_Driver|0.14|i686-linux|5.8.9|linux|2.6.24-16-generic|200903201738
3528602|pass|200903|jeff@zeroclue.com|CPAN-Testers-WWW-Reports-Mailer|0.14|OpenBSD.i386-openbsd|5.8.9|openbsd|4.4|200903201625
3528590|pass|200903|jeff@zeroclue.com|CPAN-Testers-Data-Generator|0.35|OpenBSD.i386-openbsd|5.8.9|openbsd|4.4|200903201623
3527350|pass|200903|stro@cpan.org|App-Maisha-Plugin-PingFM|0.02|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.00|200903202024
3524790|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|Mail-Outlook|0.15|s390-linux|5.8.8|linux|2.6.5-7.315-s390|200903201423
3524702|pass|200903|dagolden@cpan.org (DAGOLDEN)|CPAN-Testers-WWW-Statistics|0.55|i686-linux|5.8.9|linux|2.6.24-16-generic|200903200911
3524517|pass|200903|JOST@cpan.org ("Josts Smokehouse")|Data-Phrasebook-Loader-DBI|0.11|i86pc-solaris-64int|5.8.9|solaris|2.11|200903201348
3524516|pass|200903|JOST@cpan.org ("Josts Smokehouse")|Data-Phrasebook-Loader-Ini|0.10|i86pc-solaris-64int|5.8.9|solaris|2.11|200903201347
3524512|pass|200903|JOST@cpan.org ("Josts Smokehouse")|Data-Phrasebook-Loader-XML|0.12|i86pc-solaris-64int|5.8.9|solaris|2.11|200903201347
3524498|pass|200903|dagolden@cpan.org (DAGOLDEN)|Data-Phrasebook-Loader-YAML|0.09|i686-linux|5.8.9|linux|2.6.24-16-generic|200903200845
3524496|pass|200903|dagolden@cpan.org (DAGOLDEN)|Data-Phrasebook|0.29|i686-linux|5.8.9|linux|2.6.24-16-generic|200903200845
3524007|pass|200903|dagolden@cpan.org (DAGOLDEN)|CPAN-Testers-WWW-Reports-Mailer|0.14|i686-linux|5.8.9|linux|2.6.24-16-generic|200903200743
3523994|pass|200903|dagolden@cpan.org (DAGOLDEN)|CPAN-Testers-Data-Generator|0.35|i686-linux|5.8.9|linux|2.6.24-16-generic|200903200742
3521854|pass|200903|dagolden@cpan.org (DAGOLDEN)|Data-Phrasebook-Loader-DBI|0.11|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.1|200903200129
3521850|pass|200903|dagolden@cpan.org (DAGOLDEN)|Data-Phrasebook-Loader-Ini|0.10|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.1|200903200129
3521845|pass|200903|dagolden@cpan.org (DAGOLDEN)|Data-Phrasebook-Loader-XML|0.12|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.1|200903200128
3521830|pass|200903|dagolden@cpan.org (DAGOLDEN)|Mail-File|0.08|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.1|200903200125
3521346|pass|200903|dagolden@cpan.org (DAGOLDEN)|CPAN-YACSmoke-Plugin-Outlook|0.06|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.1|200903200349
3520662|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal-Thread|0.12|s390-linux-thread-multi-perlio|5.6.2|linux|2.6.5-7.315-s390|200903200246
3520657|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal|0.22|s390-linux-thread-multi-perlio|5.6.2|linux|2.6.5-7.315-s390|200903200246
3519778|pass|200903|stsc@refcnt.org ("Steven Schubiger")|Data-Phrasebook-Loader-DBI|0.11|i686-linux-thread-multi|5.10.0|linux|2.6.18-14-ovz-686|200903200000
3519777|pass|200903|stsc@refcnt.org ("Steven Schubiger")|Data-Phrasebook-Loader-Ini|0.10|i686-linux-thread-multi|5.10.0|linux|2.6.18-14-ovz-686|200903200000
3519774|pass|200903|stsc@refcnt.org ("Steven Schubiger")|Data-Phrasebook-Loader-XML|0.12|i686-linux-thread-multi|5.10.0|linux|2.6.18-14-ovz-686|200903200000
3519763|pass|200903|stsc@refcnt.org ("Steven Schubiger")|Mail-File|0.08|i686-linux-thread-multi|5.10.0|linux|2.6.18-14-ovz-686|200903192357
3519393|pass|200903|stsc@refcnt.org ("Steven Schubiger")|CPAN-YACSmoke-Plugin-Outlook|0.06|i686-linux-thread-multi|5.10.0|linux|2.6.18-14-ovz-686|200903192238
3519392|fail|200903|stsc@refcnt.org ("Steven Schubiger")|CPAN-YACSmoke-Plugin-WebList|0.05|i686-linux-thread-multi|5.10.0|linux|2.6.18-14-ovz-686|200903192238
3519387|pass|200903|stsc@refcnt.org ("Steven Schubiger")|CPAN-YACSmoke-Plugin-NNTP|0.05|i686-linux-thread-multi|5.10.0|linux|2.6.18-14-ovz-686|200903192236
3519384|pass|200903|stsc@refcnt.org ("Steven Schubiger")|CPAN-YACSmoke-Plugin-NNTPWeb|0.06|i686-linux-thread-multi|5.10.0|linux|2.6.18-14-ovz-686|200903192236
3519298|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|Data-FormValidator-Constraints-Words|0.03|s390x-linux-thread-multi|5.6.2|linux|2.6.16.60-0.31-default|200903192215
3518275|pass|200903|JOST@cpan.org ("Josts Smokehouse")|Mail-File|0.08|i86pc-solaris-64int|5.8.9|solaris|2.11|200903191857
3517785|pass|200903|JOST@cpan.org ("Josts Smokehouse")|CPAN-YACSmoke-Plugin-Outlook|0.06|i86pc-solaris-64int|5.8.9|solaris|2.11|200903191739
3517780|fail|200903|JOST@cpan.org ("Josts Smokehouse")|CPAN-YACSmoke-Plugin-WebList|0.05|i86pc-solaris-64int|5.8.9|solaris|2.11|200903191739
3517768|pass|200903|JOST@cpan.org ("Josts Smokehouse")|CPAN-YACSmoke-Plugin-NNTP|0.05|i86pc-solaris-64int|5.8.9|solaris|2.11|200903191737
3517758|pass|200903|JOST@cpan.org ("Josts Smokehouse")|CPAN-YACSmoke-Plugin-NNTPWeb|0.06|i86pc-solaris-64int|5.8.9|solaris|2.11|200903191737
3516000|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal-Thread|0.12|s390-linux|5.6.2|linux|2.6.5-7.315-s390|200903191406
3515999|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal|0.22|s390-linux|5.6.2|linux|2.6.5-7.315-s390|200903191406
3515314|pass|200903|dagolden@cpan.org (DAGOLDEN)|Test-YAML-Meta|0.11|i686-linux|5.8.9|linux|2.6.24-16-generic|200903190753
3513814|pass|200903|dagolden@cpan.org (DAGOLDEN)|CPAN-Testers-Data-Uploads|0.06|i686-linux|5.8.9|linux|2.6.24-16-generic|200903190425
3513751|pass|200903|dagolden@cpan.org (DAGOLDEN)|CPAN-Testers-Common-Article|0.36|i686-linux|5.8.9|linux|2.6.24-16-generic|200903190418
3513637|pass|200903|dagolden@cpan.org (DAGOLDEN)|CPAN-WWW-Testers|0.49|i686-linux|5.8.9|linux|2.6.24-16-generic|200903190400
3513625|pass|200903|dagolden@cpan.org (DAGOLDEN)|CPAN-Testers-Common-DBUtils|0.03|i686-linux|5.8.9|linux|2.6.24-16-generic|200903190358
3513548|pass|200903|dagolden@cpan.org (DAGOLDEN)|App-Maisha-Plugin-PingFM|0.02|i686-linux|5.8.9|linux|2.6.24-16-generic|200903190350
3510751|pass|200903|dagolden@cpan.org (DAGOLDEN)|App-Maisha|0.12|i686-linux|5.8.9|linux|2.6.24-16-generic|200903181733
3510366|pass|200903|stsc@refcnt.org ("Steven Schubiger")|GD-Chart-Radial|0.07|i686-linux-thread-multi|5.10.0|linux|2.6.18-14-ovz-686|200903182131
3506643|pass|200903|jafelds@gmail.com|Test-YAML-Meta|0.11|x86_64-linux-gnu-thread-multi|5.10.0|linux|2.6.24-16-server|200903172037
3506276|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal-Thread|0.12|s390-linux-thread-multi|5.6.2|linux|2.6.5-7.315-s390|200903180919
3506275|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal|0.22|s390-linux-thread-multi|5.6.2|linux|2.6.5-7.315-s390|200903180919
3505391|fail|200903|stsc@refcnt.org ("Steven Schubiger")|Finance-Currency-Convert-XE|0.15|i686-linux-thread-multi|5.10.0|linux|2.6.18-14-ovz-686|200903180615
3504877|pass|200903|stsc@refcnt.org ("Steven Schubiger")|Data-FormValidator-Constraints-Words|0.03|i686-linux-thread-multi|5.10.0|linux|2.6.18-14-ovz-686|200903180423
3503906|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|Mail-Outlook|0.15|s390-linux-thread-multi|5.10.0|linux|2.6.5-7.315-s390|200903180101
3503267|fail|200903|JOST@cpan.org ("Josts Smokehouse")|Finance-Currency-Convert-XE|0.15|i86pc-solaris-64int|5.8.9|solaris|2.11|200903172247
3502813|pass|200903|JOST@cpan.org ("Josts Smokehouse")|Data-FormValidator-Constraints-Words|0.03|i86pc-solaris-64int|5.8.9|solaris|2.11|200903172136
3501223|pass|200903|stsc@refcnt.org ("Steven Schubiger")|Games-Trackword|1.06|i686-linux-thread-multi|5.10.0|linux|2.6.18-14-ovz-686|200903171807
3501221|pass|200903|stsc@refcnt.org ("Steven Schubiger")|Calendar-List|0.21|i686-linux-thread-multi|5.10.0|linux|2.6.18-14-ovz-686|200903171807
3500826|pass|200903|dagolden@cpan.org (DAGOLDEN)|Mail-Outlook|0.15|i686-linux|5.8.9|linux|2.6.24-16-generic|200903171240
3499516|pass|200903|stsc@refcnt.org ("Steven Schubiger")|WWW-Scraper-ISBN-ORA_Driver|0.09|i686-linux-thread-multi|5.10.0|linux|2.6.18-14-ovz-686|200903171542
3499503|fail|200903|stsc@refcnt.org ("Steven Schubiger")|WWW-Scraper-ISBN-Pearson_Driver|0.10|i686-linux-thread-multi|5.10.0|linux|2.6.18-14-ovz-686|200903171541
3495328|pass|200903|stsc@refcnt.org ("Steven Schubiger")|CPAN-WWW-Testers-Generator|0.30|i686-linux-thread-multi|5.10.0|linux|2.6.18-14-ovz-686|200903170345
3493547|pass|200903|stsc@refcnt.org ("Steven Schubiger")|Test-CPAN-Meta|0.12|i686-linux-thread-multi|5.10.0|linux|2.6.18-14-ovz-686|200903162140
3492946|pass|200903|stsc@refcnt.org ("Steven Schubiger")|Regexp-Log-Common|0.05|i686-linux-thread-multi|5.10.0|linux|2.6.18-14-ovz-686|200903161940
3492348|pass|200903|stsc@refcnt.org ("Steven Schubiger")|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i686-linux-thread-multi|5.10.0|linux|2.6.18-14-ovz-686|200903161836
3492341|fail|200903|stsc@refcnt.org ("Steven Schubiger")|WWW-Scraper-ISBN-Amazon_Driver|0.14|i686-linux-thread-multi|5.10.0|linux|2.6.18-14-ovz-686|200903161835
3491221|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-Article|0.36|s390-linux|5.8.8|linux|2.6.5-7.315-s390|200903161605
3489651|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Uploads|0.06|s390-linux-thread-multi|5.10.0|linux|2.6.5-7.315-s390|200903161052
3488907|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|Data-FormValidator-Constraints-Words|0.03|s390x-linux-thread-multi|5.6.2|linux|2.6.18-92.1.18.el5|200903160815
3488756|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-Article|0.36|s390-linux-thread-multi|5.10.0|linux|2.6.5-7.315-s390|200903160753
3488667|pass|200903|stsc@refcnt.org ("Steven Schubiger")|CPAN-Testers-WWW-Statistics|0.55|i686-linux-thread-multi|5.10.0|linux|2.6.18-14-ovz-686|200903160731
3488567|pass|200903|stsc@refcnt.org ("Steven Schubiger")|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi|5.10.0|linux|2.6.18-14-ovz-686|200903160707
3488566|pass|200903|stsc@refcnt.org ("Steven Schubiger")|Data-Phrasebook|0.29|i686-linux-thread-multi|5.10.0|linux|2.6.18-14-ovz-686|200903160707
3488549|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-DBUtils|0.03|s390-linux-thread-multi|5.10.0|linux|2.6.5-7.315-s390|200903160700
3488253|pass|200903|stsc@refcnt.org ("Steven Schubiger")|CPAN-Testers-Data-Generator|0.35|i686-linux-thread-multi|5.10.0|linux|2.6.18-14-ovz-686|200903160534
3488068|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|Data-FormValidator-Constraints-Words|0.03|s390x-linux|5.6.2|linux|2.6.18-92.1.18.el5|200903160436
3487655|pass|200903|stsc@refcnt.org ("Steven Schubiger")|Test-YAML-Meta|0.11|i686-linux-thread-multi|5.10.0|linux|2.6.18-14-ovz-686|200903160318
3486362|pass|200903|wiml@hhhh.org ("Wim Lewis")|CPAN-Testers-WWW-Statistics|0.55|powerpc-netbsd-thread-multi|5.8.8|netbsd|4.0|200903151410
3486213|pass|200903|stsc@refcnt.org ("Steven Schubiger")|CPAN-Testers-Data-Uploads|0.06|i686-linux-thread-multi|5.10.0|linux|2.6.18-14-ovz-686|200903152231
3486146|pass|200903|stsc@refcnt.org ("Steven Schubiger")|CPAN-Testers-Common-Article|0.36|i686-linux-thread-multi|5.10.0|linux|2.6.18-14-ovz-686|200903152225
3486111|pass|200903|stsc@refcnt.org ("Steven Schubiger")|CPAN-WWW-Testers|0.49|i686-linux-thread-multi|5.10.0|linux|2.6.18-14-ovz-686|200903152220
3486105|pass|200903|stsc@refcnt.org ("Steven Schubiger")|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.10.0|linux|2.6.18-14-ovz-686|200903152219
3486069|pass|200903|stsc@refcnt.org ("Steven Schubiger")|App-Maisha-Plugin-PingFM|0.02|i686-linux-thread-multi|5.10.0|linux|2.6.18-14-ovz-686|200903152206
3485314|pass|200903|stsc@refcnt.org ("Steven Schubiger")|App-Maisha|0.12|i686-linux-thread-multi|5.10.0|linux|2.6.18-14-ovz-686|200903151939
3484069|pass|200903|stsc@refcnt.org ("Steven Schubiger")|Mail-Outlook|0.15|i686-linux-thread-multi|5.10.0|linux|2.6.18-14-ovz-686|200903151522
3483815|pass|200903|wiml@hhhh.org ("Wim Lewis")|Data-Phrasebook-Loader-YAML|0.09|powerpc-netbsd-thread-multi|5.8.8|netbsd|4.0|200903150558
3483811|pass|200903|wiml@hhhh.org ("Wim Lewis")|Data-Phrasebook|0.29|powerpc-netbsd-thread-multi|5.8.8|netbsd|4.0|200903150557
3481955|pass|200903|wiml@hhhh.org ("Wim Lewis")|CPAN-Testers-WWW-Reports-Mailer|0.14|powerpc-netbsd-thread-multi|5.8.8|netbsd|4.0|200903150026
3481937|pass|200903|wiml@hhhh.org ("Wim Lewis")|CPAN-Testers-Data-Generator|0.35|powerpc-netbsd-thread-multi|5.8.8|netbsd|4.0|200903150021
3477122|pass|200903|imacat@mail.imacat.idv.tw|WWW-UsePerl-Journal-Thread|0.12|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-1-amd64|200903150002
3477105|pass|200903|alceu.freitas.jr@gmail.com|Mail-Outlook|0.15|MSWin32-x86-multi-thread|5.8.8|MSWin32|5.00|200903141200
3477101|pass|200903|imacat@mail.imacat.idv.tw|WWW-UsePerl-Journal|0.22|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-1-amd64|200903142359
3477078|pass|200903|imacat@mail.imacat.idv.tw|WWW-Scraper-ISBN-Yahoo_Driver|0.08|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-1-amd64|200903142357
3477023|fail|200903|imacat@mail.imacat.idv.tw|WWW-Scraper-ISBN-Pearson_Driver|0.10|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-1-amd64|200903142354
3476994|pass|200903|imacat@mail.imacat.idv.tw|WWW-Scraper-ISBN-ORA_Driver|0.09|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-1-amd64|200903142350
3476946|fail|200903|imacat@mail.imacat.idv.tw|WWW-Scraper-ISBN-Amazon_Driver|0.14|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-1-amd64|200903142347
3476916|pass|200903|imacat@mail.imacat.idv.tw|Test-CPAN-Meta|0.12|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-1-amd64|200903142343
3476910|pass|200903|imacat@mail.imacat.idv.tw|Regexp-Log-Common|0.05|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-1-amd64|200903142343
3476903|pass|200903|imacat@mail.imacat.idv.tw|Parse-CPAN-Distributions|0.05|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-1-amd64|200903142343
3476896|pass|200903|imacat@mail.imacat.idv.tw|Mail-File|0.08|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-1-amd64|200903142342
3476893|pass|200903|imacat@mail.imacat.idv.tw|Games-Trackword|1.06|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-1-amd64|200903142342
3476888|pass|200903|imacat@mail.imacat.idv.tw|GD-Chart-Radial|0.07|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-1-amd64|200903142341
3476885|fail|200903|imacat@mail.imacat.idv.tw|Finance-Currency-Convert-XE|0.15|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-1-amd64|200903142341
3476867|pass|200903|imacat@mail.imacat.idv.tw|Data-Phrasebook-Loader-YAML|0.09|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-1-amd64|200903142338
3476864|pass|200903|imacat@mail.imacat.idv.tw|Data-Phrasebook-Loader-XML|0.12|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-1-amd64|200903142338
3476855|pass|200903|imacat@mail.imacat.idv.tw|Data-Phrasebook-Loader-Ini|0.10|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-1-amd64|200903142337
3476851|pass|200903|imacat@mail.imacat.idv.tw|Data-Phrasebook-Loader-DBI|0.11|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-1-amd64|200903142336
3476825|pass|200903|imacat@mail.imacat.idv.tw|Data-Phrasebook|0.29|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-1-amd64|200903142334
3476817|pass|200903|imacat@mail.imacat.idv.tw|Data-FormValidator-Constraints-Words|0.03|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-1-amd64|200903142334
3476813|pass|200903|imacat@mail.imacat.idv.tw|Calendar-List|0.21|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-1-amd64|200903142334
3476806|fail|200903|imacat@mail.imacat.idv.tw|CPAN-YACSmoke-Plugin-WebList|0.05|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-1-amd64|200903142333
3476758|pass|200903|imacat@mail.imacat.idv.tw|CPAN-YACSmoke-Plugin-Outlook|0.06|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-1-amd64|200903142326
3476753|pass|200903|imacat@mail.imacat.idv.tw|CPAN-YACSmoke-Plugin-NNTPWeb|0.06|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-1-amd64|200903142325
3476715|pass|200903|imacat@mail.imacat.idv.tw|CPAN-YACSmoke-Plugin-NNTP|0.05|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-1-amd64|200903142319
3474985|pass|200903|imacat@mail.imacat.idv.tw|CPAN-Testers-WWW-Statistics|0.55|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-1-amd64|200903141529
3474892|pass|200903|imacat@mail.imacat.idv.tw|CPAN-Testers-Common-DBUtils|0.03|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-1-amd64|200903141511
3473875|pass|200903|imacat@mail.imacat.idv.tw|CPAN-Testers-Common-Article|0.36|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-1-amd64|200903141042
3473871|pass|200903|imacat@mail.imacat.idv.tw|App-Maisha-Plugin-PingFM|0.02|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-1-amd64|200903141041
3473855|pass|200903|imacat@mail.imacat.idv.tw|App-Maisha|0.12|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-1-amd64|200903141036
3467328|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha-Plugin-PingFM|0.02|s390-linux|5.8.8|linux|2.6.5-7.315-s390|200903130148
3466915|pass|200903|imacat@mail.imacat.idv.tw|Mail-Outlook|0.15|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-1-amd64|200903131845
3466266|pass|200903|imacat@mail.imacat.idv.tw|Test-YAML-Meta|0.11|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.26-1-amd64|200903131637
3465706|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-DBUtils|0.03|s390-linux|5.8.8|linux|2.6.5-7.315-s390|200903130621
3465677|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha|0.12|s390-linux-thread-multi|5.10.0|linux|2.6.5-7.315-s390|200903130459
3465296|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha-Plugin-PingFM|0.02|s390-linux-thread-multi|5.10.0|linux|2.6.5-7.315-s390|200903130506
3461210|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|Mail-Outlook|0.15|s390-linux|5.10.0|linux|2.6.5-7.315-s390|200903121540
3459998|pass|200903|JOST@cpan.org ("Josts Smokehouse")|Games-Trackword|1.06|i86pc-solaris-64int|5.8.9|solaris|2.11|200903121244
3459994|pass|200903|JOST@cpan.org ("Josts Smokehouse")|Calendar-List|0.21|i86pc-solaris-64int|5.8.9|solaris|2.11|200903121244
3459655|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-Article|0.36|s390-linux|5.10.0|linux|2.6.5-7.315-s390|200903121207
3458191|pass|200903|JOST@cpan.org ("Josts Smokehouse")|Test-CPAN-Meta|0.12|i86pc-solaris-64int|5.8.9|solaris|2.11|200903120900
3458188|pass|200903|JOST@cpan.org ("Josts Smokehouse")|WWW-Scraper-ISBN-ORA_Driver|0.09|i86pc-solaris-64int|5.8.9|solaris|2.11|200903120859
3458185|fail|200903|JOST@cpan.org ("Josts Smokehouse")|WWW-Scraper-ISBN-Pearson_Driver|0.10|i86pc-solaris-64int|5.8.9|solaris|2.11|200903120859
3453831|pass|200903|JOST@cpan.org ("Josts Smokehouse")|Parse-CPAN-Distributions|0.05|i86pc-solaris-64int|5.8.9|solaris|2.11|200903111723
3453414|pass|200903|JOST@cpan.org ("Josts Smokehouse")|WWW-UsePerl-Journal-Thread|0.12|i86pc-solaris-64int|5.8.9|solaris|2.11|200903111637
3453413|pass|200903|JOST@cpan.org ("Josts Smokehouse")|WWW-UsePerl-Journal|0.22|i86pc-solaris-64int|5.8.9|solaris|2.11|200903111637
3452959|pass|200903|JOST@cpan.org ("Josts Smokehouse")|CPAN-WWW-Testers-Generator|0.30|i86pc-solaris-64int|5.8.9|solaris|2.11|200903111538
3449420|pass|200903|JOST@cpan.org ("Josts Smokehouse")|Regexp-Log-Common|0.05|i86pc-solaris-64int|5.8.9|solaris|2.11|200903110650
3449072|pass|200903|JOST@cpan.org ("Josts Smokehouse")|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i86pc-solaris-64int|5.8.9|solaris|2.11|200903110559
3449068|fail|200903|JOST@cpan.org ("Josts Smokehouse")|WWW-Scraper-ISBN-Amazon_Driver|0.14|i86pc-solaris-64int|5.8.9|solaris|2.11|200903110559
3443769|pass|200903|JOST@cpan.org ("Josts Smokehouse")|CPAN-Testers-WWW-Statistics|0.55|i86pc-solaris-64int|5.8.9|solaris|2.11|200903101818
3443557|pass|200903|JOST@cpan.org ("Josts Smokehouse")|Data-Phrasebook-Loader-YAML|0.09|i86pc-solaris-64int|5.8.9|solaris|2.11|200903101712
3443556|pass|200903|JOST@cpan.org ("Josts Smokehouse")|Data-Phrasebook|0.29|i86pc-solaris-64int|5.8.9|solaris|2.11|200903101712
3442091|pass|200903|JOST@cpan.org ("Josts Smokehouse")|CPAN-Testers-WWW-Reports-Mailer|0.14|i86pc-solaris-64int|5.8.9|solaris|2.11|200903101249
3442082|pass|200903|JOST@cpan.org ("Josts Smokehouse")|CPAN-Testers-Data-Generator|0.35|i86pc-solaris-64int|5.8.9|solaris|2.11|200903101248
3440670|pass|200903|stsc@refcnt.org ("Steven Schubiger")|Data-Phrasebook-Loader-XML|0.12|i686-linux|5.10.0|linux|2.6.18-14-ovz-686|200903101017
3440661|pass|200903|stsc@refcnt.org ("Steven Schubiger")|Mail-File|0.08|i686-linux|5.10.0|linux|2.6.18-14-ovz-686|200903101016
3440252|pass|200903|stsc@refcnt.org ("Steven Schubiger")|CPAN-YACSmoke-Plugin-Outlook|0.06|i686-linux|5.10.0|linux|2.6.18-14-ovz-686|200903100933
3440249|fail|200903|stsc@refcnt.org ("Steven Schubiger")|CPAN-YACSmoke-Plugin-WebList|0.05|i686-linux|5.10.0|linux|2.6.18-14-ovz-686|200903100933
3440238|pass|200903|stsc@refcnt.org ("Steven Schubiger")|CPAN-YACSmoke-Plugin-NNTP|0.05|i686-linux|5.10.0|linux|2.6.18-14-ovz-686|200903100932
3440233|pass|200903|stsc@refcnt.org ("Steven Schubiger")|CPAN-YACSmoke-Plugin-NNTPWeb|0.06|i686-linux|5.10.0|linux|2.6.18-14-ovz-686|200903100931
3439185|pass|200903|srezic@cpan.org|Mail-Outlook|0.15|amd64-freebsd|5.10.0|freebsd|7.0-release|200903100750
3439119|pass|200903|peter.kerrigan@gmail.com|Test-CPAN-Meta|0.12|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.00|200903090852
3438176|pass|200903|wiml@hhhh.org ("Wim Lewis")|Test-YAML-Meta|0.11|powerpc-netbsd-thread-multi|5.8.8|netbsd|4.0|200903100448
3436730|pass|200903|stsc@refcnt.org ("Steven Schubiger")|GD-Chart-Radial|0.07|i686-linux|5.10.0|linux|2.6.18-14-ovz-686|200903100307
3435981|pass|200903|JOST@cpan.org ("Josts Smokehouse")|Test-YAML-Meta|0.11|i86pc-solaris-64int|5.8.9|solaris|2.11|200903100126
3435409|pass|200903|JOST@cpan.org ("Josts Smokehouse")|CPAN-Testers-Data-Uploads|0.06|i86pc-solaris-64int|5.8.9|solaris|2.11|200903100009
3435303|pass|200903|JOST@cpan.org ("Josts Smokehouse")|CPAN-Testers-Common-Article|0.36|i86pc-solaris-64int|5.8.9|solaris|2.11|200903092357
3435221|pass|200903|JOST@cpan.org ("Josts Smokehouse")|CPAN-Testers-Common-DBUtils|0.03|i86pc-solaris-64int|5.8.9|solaris|2.11|200903092349
3434995|pass|200903|JOST@cpan.org ("Josts Smokehouse")|App-Maisha-Plugin-PingFM|0.02|i86pc-solaris-64int|5.8.9|solaris|2.11|200903092313
3434569|pass|200903|wiml@hhhh.org ("Wim Lewis")|CPAN-Testers-Data-Uploads|0.06|powerpc-netbsd-thread-multi|5.8.8|netbsd|4.0|200903091351
3434202|pass|200903|wiml@hhhh.org ("Wim Lewis")|CPAN-Testers-Common-Article|0.36|powerpc-netbsd-thread-multi|5.8.8|netbsd|4.0|200903091305
3433976|pass|200903|dagolden@cpan.org (DAGOLDEN)|Data-Phrasebook-Loader-DBI|0.11|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200903091614
3433975|pass|200903|dagolden@cpan.org (DAGOLDEN)|Data-Phrasebook-Loader-Ini|0.10|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200903091614
3433972|pass|200903|dagolden@cpan.org (DAGOLDEN)|Data-Phrasebook-Loader-XML|0.12|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200903091614
3433952|pass|200903|dagolden@cpan.org (DAGOLDEN)|Mail-File|0.08|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200903091612
3433787|pass|200903|dagolden@cpan.org (DAGOLDEN)|CPAN-YACSmoke-Plugin-Outlook|0.06|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200903091559
3433333|pass|200903|wiml@hhhh.org ("Wim Lewis")|CPAN-Testers-Common-DBUtils|0.03|powerpc-netbsd-thread-multi|5.8.8|netbsd|4.0|200903091126
3433162|pass|200903|JOST@cpan.org ("Josts Smokehouse")|App-Maisha|0.12|i86pc-solaris-64int|5.8.9|solaris|2.11|200903091942
3432859|pass|200903|wiml@hhhh.org ("Wim Lewis")|App-Maisha-Plugin-PingFM|0.02|powerpc-netbsd-thread-multi|5.8.8|netbsd|4.0|200903091025
3431139|pass|200903|JOST@cpan.org ("Josts Smokehouse")|Mail-Outlook|0.15|i86pc-solaris-64int|5.8.9|solaris|2.11|200903091508
3427200|pass|200903|stsc@refcnt.org ("Steven Schubiger")|Data-Phrasebook-Loader-DBI|0.11|i686-linux|5.10.0|linux|2.6.18-14-ovz-686|200903090737
3427198|pass|200903|stsc@refcnt.org ("Steven Schubiger")|Data-Phrasebook-Loader-Ini|0.10|i686-linux|5.10.0|linux|2.6.18-14-ovz-686|200903090737
3425833|pass|200903|dagolden@cpan.org (DAGOLDEN)|Data-FormValidator-Constraints-Words|0.03|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.1|200903090001
3424113|fail|200903|dagolden@cpan.org (DAGOLDEN)|Finance-Currency-Convert-XE|0.15|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200903090015
3423404|pass|200903|dagolden@cpan.org (DAGOLDEN)|Data-FormValidator-Constraints-Words|0.03|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200903081921
3418406|pass|200903|dagolden@cpan.org (DAGOLDEN)|Games-Trackword|1.06|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200903081317
3418402|pass|200903|dagolden@cpan.org (DAGOLDEN)|Calendar-List|0.21|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200903081317
3418162|fail|200903|stsc@refcnt.org ("Steven Schubiger")|Finance-Currency-Convert-XE|0.15|i686-linux|5.10.0|linux|2.6.18-14-ovz-686|200903081801
3417618|pass|200903|stsc@refcnt.org ("Steven Schubiger")|Data-FormValidator-Constraints-Words|0.03|i686-linux|5.10.0|linux|2.6.18-14-ovz-686|200903081722
3416602|pass|200903|dagolden@cpan.org (DAGOLDEN)|WWW-Scraper-ISBN-ORA_Driver|0.09|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200903081100
3416596|fail|200903|dagolden@cpan.org (DAGOLDEN)|WWW-Scraper-ISBN-Pearson_Driver|0.10|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200903081100
3412647|pass|200903|dagolden@cpan.org (DAGOLDEN)|Parse-CPAN-Distributions|0.05|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200903080316
3412457|pass|200903|dagolden@cpan.org (DAGOLDEN)|WWW-UsePerl-Journal-Thread|0.12|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200903080132
3412455|pass|200903|dagolden@cpan.org (DAGOLDEN)|WWW-UsePerl-Journal|0.22|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200903080132
3412396|pass|200903|dagolden@cpan.org (DAGOLDEN)|CPAN-WWW-Testers-Generator|0.30|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200903080121
3411870|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|Mail-Outlook|0.15|s390-linux-thread-multi-perlio|5.6.2|linux|2.6.5-7.315-s390|200903080546
3411136|pass|200903|wiml@hhhh.org ("Wim Lewis")|App-Maisha|0.12|powerpc-netbsd-thread-multi|5.8.8|netbsd|4.0|200903080244
3411116|pass|200903|dagolden@cpan.org (DAGOLDEN)|Test-CPAN-Meta|0.12|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200903080241
3410158|pass|200903|dagolden@cpan.org (DAGOLDEN)|Regexp-Log-Common|0.05|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200903071813
3409782|pass|200903|dagolden@cpan.org (DAGOLDEN)|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200903071659
3409781|fail|200903|dagolden@cpan.org (DAGOLDEN)|WWW-Scraper-ISBN-Amazon_Driver|0.14|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200903071658
3408859|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-Article|0.36|s390-linux-thread-multi-perlio|5.6.2|linux|2.6.5-7.315-s390|200903071932
3407196|pass|200903|dagolden@cpan.org (DAGOLDEN)|CPAN-Testers-WWW-Statistics|0.55|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200903070825
3407091|pass|200903|dagolden@cpan.org (DAGOLDEN)|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200903070802
3407090|pass|200903|dagolden@cpan.org (DAGOLDEN)|Data-Phrasebook|0.29|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200903070802
3406770|pass|200903|dagolden@cpan.org (DAGOLDEN)|CPAN-Testers-WWW-Reports-Mailer|0.14|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200903070654
3406767|pass|200903|dagolden@cpan.org (DAGOLDEN)|CPAN-Testers-Data-Generator|0.35|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200903070653
3406159|pass|200903|dagolden@cpan.org (DAGOLDEN)|Test-YAML-Meta|0.11|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200903070450
3405964|pass|200903|wiml@hhhh.org ("Wim Lewis")|Mail-Outlook|0.15|powerpc-netbsd-thread-multi|5.8.8|netbsd|4.0|200903070045
3405389|pass|200903|dagolden@cpan.org (DAGOLDEN)|Mail-Outlook|0.15|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200903070222
3404983|pass|200903|dagolden@cpan.org (DAGOLDEN)|Games-Trackword|1.06|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.1|200903070124
3404980|pass|200903|dagolden@cpan.org (DAGOLDEN)|Calendar-List|0.21|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.1|200903070123
3404957|pass|200903|dagolden@cpan.org (DAGOLDEN)|CPAN-Testers-Data-Uploads|0.06|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200903070120
3404887|pass|200903|dagolden@cpan.org (DAGOLDEN)|CPAN-Testers-Common-Article|0.36|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200903070113
3404857|pass|200903|dagolden@cpan.org (DAGOLDEN)|CPAN-WWW-Testers|0.49|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200903070109
3404853|pass|200903|dagolden@cpan.org (DAGOLDEN)|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200903070108
3404775|pass|200903|dagolden@cpan.org (DAGOLDEN)|App-Maisha-Plugin-PingFM|0.02|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200903070054
3403886|pass|200903|bingos@cpan.org|App-Maisha|0.12|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.1-release|200903070156
3403768|pass|200903|dagolden@cpan.org (DAGOLDEN)|App-Maisha|0.12|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200903070317
3400529|pass|200903|jeff@zeroclue.com|Mail-Outlook|0.15|OpenBSD.i386-openbsd|5.8.9|openbsd|4.4|200903061135
3398457|pass|200903|bingos@cpan.org|App-Maisha|0.12|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.21.5-smp|200903060947
3398424|pass|200903|jeff@zeroclue.com|Test-YAML-Meta|0.11|OpenBSD.i386-openbsd|0|OpenBSD|4.4|200903060537
3397318|pass|200903|jeff@zeroclue.com|CPAN-Testers-Data-Uploads|0.06|OpenBSD.i386-openbsd|5.8.9|openbsd|4.4|200903060336
3397032|pass|200903|jeff@zeroclue.com|CPAN-Testers-Common-Article|0.36|OpenBSD.i386-openbsd|5.8.9|openbsd|4.4|200903060253
3394174|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha|0.12|s390-linux|5.8.8|linux|2.6.5-7.315-s390|200903052231
3393772|pass|200903|bingos@cpan.org|App-Maisha|0.12|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.21.5-smp|200903051908
3393771|pass|200903|bingos@cpan.org|App-Maisha|0.12|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.21.5-smp|200903051908
3392602|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|Mail-Outlook|0.15|s390-linux-thread-multi|5.6.2|linux|2.6.5-7.315-s390|200903051337
3391955|pass|200903|stsc@refcnt.org ("Steven Schubiger")|Games-Trackword|1.06|i686-linux|5.10.0|linux|2.6.18-14-ovz-686|200903051124
3391954|pass|200903|stsc@refcnt.org ("Steven Schubiger")|Calendar-List|0.21|i686-linux|5.10.0|linux|2.6.18-14-ovz-686|200903051124
3391864|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|Mail-Outlook|0.15|s390-linux|5.6.2|linux|2.6.5-7.315-s390|200903051051
3391607|pass|200903|bingos@cpan.org|App-Maisha|0.12|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.16.38|200903050828
3390787|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-Article|0.36|s390-linux-thread-multi|5.6.2|linux|2.6.5-7.315-s390|200903050518
3389683|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-Article|0.36|s390-linux|5.6.2|linux|2.6.5-7.315-s390|200903050242
3387630|pass|200903|bingos@cpan.org|App-Maisha|0.12|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.1-release|200903042040
3387619|pass|200903|bingos@cpan.org|App-Maisha|0.12|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.1-release|200903042039
3386698|pass|200903|alfreitas@deloitte.com ("Freitas, Alceu Rodrigues de \\(BR - Sao Paulo\\)")|Mail-Outlook|0.15|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.00|200903041155
3386624|pass|200903|bingos@cpan.org|App-Maisha|0.12|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.16.38|200903041759
3386620|pass|200903|bingos@cpan.org|App-Maisha|0.12|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.16.38|200903041759
3383286|pass|200903|bingos@cpan.org|App-Maisha|0.12|i86pc-solaris-thread-multi-64int|5.8.8|solaris|2.10|200903040850
3380733|pass|200903|bingos@cpan.org|App-Maisha|0.12|i86pc-solaris-thread-multi-64int|5.8.4|solaris|2.10|200903032339
3379418|pass|200903|MKUTTER@cpan.org ("Martin Kutter")|Test-YAML-Meta|0.11|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-16-server|200903032102
3378755|pass|200903|bingos@cpan.org|App-Maisha|0.12|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.0-release|200903031706
3376850|pass|200903|vpit@cpan.org|CPAN-WWW-Testers|0.49|i686-linux-thread-multi|5.10.0|linux|2.6.18.3-tmb-desktop-2mdvsmp|200903031149
3376419|pass|200903|bingos@cpan.org|App-Maisha|0.12|i86pc-solaris-thread-multi-64int|5.8.9|solaris|2.10|200903030929
3376407|pass|200903|bingos@cpan.org|App-Maisha|0.12|i86pc-solaris-thread-multi-64int|5.10.0|solaris|2.10|200903030926
3375934|pass|200903|srezic@cpan.org|App-Maisha|0.12|amd64-freebsd|5.8.8|freebsd|7.0-release|200903030841
3375282|pass|200903|dagolden@cpan.org (DAGOLDEN)|Data-Phrasebook-Loader-DBI|0.11|i686-linux|5.10.0|linux|2.6.24-16-generic|200903030007
3375280|pass|200903|dagolden@cpan.org (DAGOLDEN)|Data-Phrasebook-Loader-Ini|0.10|i686-linux|5.10.0|linux|2.6.24-16-generic|200903030006
3375277|pass|200903|dagolden@cpan.org (DAGOLDEN)|Data-Phrasebook-Loader-XML|0.12|i686-linux|5.10.0|linux|2.6.24-16-generic|200903030006
3375265|pass|200903|dagolden@cpan.org (DAGOLDEN)|Mail-File|0.08|i686-linux|5.10.0|linux|2.6.24-16-generic|200903030003
3375131|pass|200903|dagolden@cpan.org (DAGOLDEN)|CPAN-YACSmoke-Plugin-Outlook|0.06|i686-linux|5.10.0|linux|2.6.24-16-generic|200903030415
3374193|pass|200903|bingos@cpan.org|App-Maisha|0.12|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.0-release|200903022341
3373877|fail|200903|srezic@cpan.org|App-Maisha|0.12|amd64-freebsd|5.8.9|freebsd|7.0-release|200903022347
3373669|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha|0.12|s390-linux|5.10.0|linux|2.6.5-7.315-s390|200903022317
3372521|pass|200903|davidrw@cpan.org|CPAN-WWW-Testers|0.49|i486-linux-gnu-thread-multi|5.8.8|linux|2.6.18-6-686|200903021435
3371915|pass|200903|vpit@cpan.org|App-Maisha|0.12|x86_64-linux-thread-multi|5.10.0|linux|2.6.26.3-fuuka.profvince.com|200903021840
3370801|pass|200903|mithaldu@yahoo.de ("Christian Walde")|Test-YAML-Meta|0.11|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.00|200903021530
3370677|pass|200903|bingos@cpan.org|App-Maisha|0.12|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.0-release|200903021406
3370367|pass|200903|mw487.yahoo.com@gmail.com|App-Maisha|0.12|cygwin-thread-multi-64int|5.10.0 patch 34065|cygwin|1.5.25(0.15642)|200903020807
3369549|pass|200903|JOST@cpan.org ("Josts Smokehouse")|App-Maisha|0.12|i86pc-solaris-64int|5.10.0|solaris|2.11|200903021119
3366141|pass|200903|bingos@cpan.org|App-Maisha|0.12|i386-freebsd-thread-multi-64int|5.8.8|freebsd|6.4-release|200903012342
3365991|pass|200903|dagolden@cpan.org (DAGOLDEN)|Parse-CPAN-Distributions|0.05|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.1|200903011811
3365925|pass|200903|alexchorny@gmail.com|Mail-Outlook|0.15|MSWin32-x86-multi-thread|5.8.8|MSWin32|5.1|200903011758
3365539|pass|200903|bingos@cpan.org|App-Maisha|0.12|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.0-release|200903012110
3365402|pass|200903|bingos@cpan.org|App-Maisha|0.12|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.0-release|200903012053
3365268|pass|200903|dagolden@cpan.org (DAGOLDEN)|Data-FormValidator-Constraints-Words|0.03|i686-linux|5.10.0|linux|2.6.24-16-generic|200903011519
3363704|pass|200903|dagolden@cpan.org (DAGOLDEN)|Games-Trackword|1.06|i686-linux|5.10.0|linux|2.6.24-16-generic|200903010634
3363702|pass|200903|dagolden@cpan.org (DAGOLDEN)|Calendar-List|0.21|i686-linux|5.10.0|linux|2.6.24-16-generic|200903010634
3362089|pass|200903|cpan@sourcentral.org ("Oliver Paukstadt")|Mail-Outlook|0.15|s390x-linux-thread-multi|5.10.0|linux|2.6.16.60-0.31-default|200903010613
3361087|pass|200902|alexchorny@gmail.com|Mail-Outlook|0.15|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.1|200902281506
3360385|pass|200902|dagolden@cpan.org (DAGOLDEN)|Parse-CPAN-Distributions|0.05|i686-linux|5.10.0|linux|2.6.24-16-generic|200902281217
3360000|pass|200902|dagolden@cpan.org (DAGOLDEN)|WWW-UsePerl-Journal-Thread|0.12|i686-linux|5.10.0|linux|2.6.24-16-generic|200902281044
3359999|pass|200902|dagolden@cpan.org (DAGOLDEN)|WWW-UsePerl-Journal|0.22|i686-linux|5.10.0|linux|2.6.24-16-generic|200902281043
3359895|pass|200902|dagolden@cpan.org (DAGOLDEN)|CPAN-WWW-Testers-Generator|0.30|i686-linux|5.10.0|linux|2.6.24-16-generic|200902281023
3359207|pass|200902|david@cantrell.org.uk|App-Maisha|0.12|alpha-netbsd|5.10.0|netbsd|4.0.1|200902281336
3359143|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha|0.12|s390x-linux-thread-multi|5.8.8|linux|2.6.18-92.1.18.el5|200902281424
3359038|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha|0.12|s390x-linux|5.8.8|linux|2.6.18-92.1.18.el5|200902281404
3359008|pass|200902|imacat@mail.imacat.idv.tw|App-Maisha|0.12|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.24-etchnhalf.1-amd64|200902282059
3358998|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha|0.12|s390x-linux-thread-multi|5.8.8|linux|2.6.16.60-0.31-default|200902281357
3358955|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha|0.12|s390x-linux-thread-multi|5.10.0|linux|2.6.18-92.el5|200902281346
3358921|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha|0.12|s390x-linux|5.8.8|linux|2.6.16.60-0.31-default|200902281340
3358805|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha|0.12|s390x-linux|5.10.0|linux|2.6.18-92.el5|200902281316
3358799|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha|0.12|s390x-linux|5.10.0|linux|2.6.16.60-0.31-default|200902281315
3358744|pass|200902|stsc@refcnt.org ("Steven Schubiger")|App-Maisha|0.12|i686-linux|5.10.0|linux|2.6.18-14-ovz-686|200902281306
3358693|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha|0.12|s390x-linux-thread-multi|5.10.0|linux|2.6.16.60-0.31-default|200902281301
3358292|pass|200902|david@cantrell.org.uk|App-Maisha|0.12|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200902280500
3358225|pass|200902|david@cantrell.org.uk|App-Maisha|0.12|IP35-irix-64int|5.8.8|irix|6.5|200902281150
3358166|pass|200902|david@cantrell.org.uk|App-Maisha|0.12|x86_64-linux-thread-multi|5.8.9|linux|2.6.18-4-xen-amd64|200902281041
3358160|pass|200902|david@cantrell.org.uk|App-Maisha|0.12|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200902281039
3358142|pass|200902|david@cantrell.org.uk|App-Maisha|0.12|x86_64-linux-thread-multi|5.10.0|linux|2.6.18-4-xen-amd64|200902281038
3358136|pass|200902|david@cantrell.org.uk|App-Maisha|0.12|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200902281038
3357831|pass|200902|dagolden@cpan.org (DAGOLDEN)|Test-CPAN-Meta|0.12|i686-linux|5.10.0|linux|2.6.24-16-generic|200902280433
3357384|pass|200902|dagolden@cpan.org (DAGOLDEN)|Regexp-Log-Common|0.05|i686-linux|5.10.0|linux|2.6.24-16-generic|200902280248
3356813|pass|200902|dagolden@cpan.org (DAGOLDEN)|App-Maisha|0.12|i686-linux|5.10.0|linux|2.6.24-16-generic|200902280454
3354476|cpan|200902|BARBIE|App-Maisha|0.12||0|||200902271414
3348752|pass|200902|bingos@cpan.org|App-Maisha|0.11|i386-dragonfly-64int|5.10.0|dragonfly|2.0.1-release|200902252333
3348739|pass|200902|bingos@cpan.org|App-Maisha|0.11|i386-dragonfly-64int|5.8.9|dragonfly|2.0.1-release|200902252330
3347622|pass|200902|stsc@refcnt.org ("Steven Schubiger")|WWW-Scraper-ISBN-ORA_Driver|0.09|i686-linux|5.10.0|linux|2.6.18-14-ovz-686|200902251932
3347369|pass|200902|bingos@cpan.org|App-Maisha|0.11|i386-freebsd-thread-multi-64int|5.8.8|freebsd|6.2-release|200902251644
3346286|pass|200902|dagolden@cpan.org (DAGOLDEN)|Data-Phrasebook-Loader-YAML|0.09|i686-linux|5.10.0|linux|2.6.24-16-generic|200902250710
3346285|pass|200902|dagolden@cpan.org (DAGOLDEN)|Data-Phrasebook|0.29|i686-linux|5.10.0|linux|2.6.24-16-generic|200902250710
3345892|pass|200902|dagolden@cpan.org (DAGOLDEN)|CPAN-Testers-WWW-Reports-Mailer|0.14|i686-linux|5.10.0|linux|2.6.24-16-generic|200902250531
3345883|pass|200902|dagolden@cpan.org (DAGOLDEN)|CPAN-Testers-Data-Generator|0.35|i686-linux|5.10.0|linux|2.6.24-16-generic|200902250530
3345358|pass|200902|dagolden@cpan.org (DAGOLDEN)|Test-YAML-Meta|0.11|i686-linux|5.10.0|linux|2.6.24-16-generic|200902250339
3343517|pass|200902|bingos@cpan.org|App-Maisha-Plugin-PingFM|0.02|i386-freebsd-thread-multi-64int|5.8.9|freebsd|6.2-release|200902250212
3343508|pass|200902|bingos@cpan.org|App-Maisha|0.11|i386-freebsd-thread-multi-64int|5.8.9|freebsd|6.2-release|200902250209
3343504|pass|200902|bingos@cpan.org|App-Maisha|0.10|i386-freebsd-thread-multi-64int|5.8.9|freebsd|6.2-release|200902250207
3343502|pass|200902|bingos@cpan.org|App-Maisha|0.09|i386-freebsd-thread-multi-64int|5.8.9|freebsd|6.2-release|200902250206
3343495|pass|200902|bingos@cpan.org|App-Maisha|0.08|i386-freebsd-thread-multi-64int|5.8.9|freebsd|6.2-release|200902250206
3343493|pass|200902|bingos@cpan.org|App-Maisha|0.07|i386-freebsd-thread-multi-64int|5.8.9|freebsd|6.2-release|200902250205
3343395|pass|200902|bingos@cpan.org|App-Maisha-Plugin-PingFM|0.02|i386-freebsd-thread-multi-64int|5.10.0|freebsd|6.2-release|200902250139
3343383|pass|200902|bingos@cpan.org|App-Maisha|0.11|i386-freebsd-thread-multi-64int|5.10.0|freebsd|6.2-release|200902250135
3343378|pass|200902|bingos@cpan.org|App-Maisha|0.10|i386-freebsd-thread-multi-64int|5.10.0|freebsd|6.2-release|200902250134
3343369|pass|200902|bingos@cpan.org|App-Maisha|0.09|i386-freebsd-thread-multi-64int|5.10.0|freebsd|6.2-release|200902250133
3343363|pass|200902|bingos@cpan.org|App-Maisha|0.08|i386-freebsd-thread-multi-64int|5.10.0|freebsd|6.2-release|200902250132
3343359|pass|200902|bingos@cpan.org|App-Maisha|0.07|i386-freebsd-thread-multi-64int|5.10.0|freebsd|6.2-release|200902250131
3342018|fail|200902|stsc@refcnt.org ("Steven Schubiger")|WWW-Scraper-ISBN-Pearson_Driver|0.10|i686-linux|5.10.0|linux|2.6.18-14-ovz-686|200902241917
3341976|pass|200902|bingos@cpan.org|App-Maisha-Plugin-PingFM|0.02|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.16.38|200902241806
3341961|pass|200902|bingos@cpan.org|App-Maisha|0.11|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.16.38|200902241804
3341960|pass|200902|bingos@cpan.org|App-Maisha|0.10|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.16.38|200902241804
3341958|pass|200902|bingos@cpan.org|App-Maisha|0.09|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.16.38|200902241804
3341956|pass|200902|bingos@cpan.org|App-Maisha|0.08|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.16.38|200902241803
3341953|pass|200902|bingos@cpan.org|App-Maisha|0.07|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.16.38|200902241803
3341873|pass|200902|dagolden@cpan.org (DAGOLDEN)|Mail-Outlook|0.15|i686-linux|5.10.0|linux|2.6.24-16-generic|200902241249
3341198|pass|200902|dagolden@cpan.org (DAGOLDEN)|CPAN-Testers-Data-Uploads|0.06|i686-linux|5.10.0|linux|2.6.24-16-generic|200902241052
3340992|pass|200902|dagolden@cpan.org (DAGOLDEN)|CPAN-Testers-Common-Article|0.36|i686-linux|5.10.0|linux|2.6.24-16-generic|200902241018
3340924|pass|200902|dagolden@cpan.org (DAGOLDEN)|CPAN-WWW-Testers|0.49|i686-linux|5.10.0|linux|2.6.24-16-generic|200902241006
3340915|pass|200902|dagolden@cpan.org (DAGOLDEN)|CPAN-Testers-Common-DBUtils|0.03|i686-linux|5.10.0|linux|2.6.24-16-generic|200902241005
3340720|pass|200902|dagolden@cpan.org (DAGOLDEN)|App-Maisha-Plugin-PingFM|0.02|i686-linux|5.10.0|linux|2.6.24-16-generic|200902240934
3340624|pass|200902|dagolden@cpan.org (DAGOLDEN)|App-Maisha|0.11|i686-linux|5.10.0|linux|2.6.24-16-generic|200902240912
3339950|pass|200902|dagolden@cpan.org (DAGOLDEN)|WWW-UsePerl-Journal-Thread|0.12|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.1|200902240558
3339948|pass|200902|dagolden@cpan.org (DAGOLDEN)|WWW-UsePerl-Journal|0.22|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.1|200902240558
3339851|pass|200902|dagolden@cpan.org (DAGOLDEN)|CPAN-WWW-Testers-Generator|0.30|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.1|200902240523
3338679|pass|200902|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i386-netbsd-thread-multi-64int|5.8.9|netbsd|3.1|200902240427
3337408|pass|200902|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.16.38|200902232257
3337407|pass|200902|bingos@cpan.org|App-Maisha-Plugin-PingFM|0.02|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.16.38|200902232256
3337404|pass|200902|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.16.38|200902232255
3337399|pass|200902|bingos@cpan.org|App-Maisha-Plugin-PingFM|0.01|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.16.38|200902232255
3337396|pass|200902|bingos@cpan.org|App-Maisha-Plugin-PingFM|0.02|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.16.38|200902232254
3337391|pass|200902|bingos@cpan.org|App-Maisha-Plugin-PingFM|0.01|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.16.38|200902232253
3337387|pass|200902|bingos@cpan.org|App-Maisha|0.11|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.16.38|200902232252
3337384|pass|200902|bingos@cpan.org|App-Maisha|0.10|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.16.38|200902232252
3337381|pass|200902|bingos@cpan.org|App-Maisha|0.09|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.16.38|200902232251
3337379|pass|200902|bingos@cpan.org|App-Maisha|0.11|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.16.38|200902232251
3337377|pass|200902|bingos@cpan.org|App-Maisha|0.08|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.16.38|200902232250
3337375|pass|200902|bingos@cpan.org|App-Maisha|0.10|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.16.38|200902232250
3337374|pass|200902|bingos@cpan.org|App-Maisha|0.07|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.16.38|200902232250
3337373|pass|200902|bingos@cpan.org|App-Maisha|0.09|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.16.38|200902232249
3337372|fail|200902|bingos@cpan.org|App-Maisha|0.06|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.16.38|200902232249
3337371|pass|200902|bingos@cpan.org|App-Maisha|0.08|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.16.38|200902232248
3337370|fail|200902|bingos@cpan.org|App-Maisha|0.05|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.16.38|200902232248
3337367|pass|200902|bingos@cpan.org|App-Maisha|0.07|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.16.38|200902232248
3337364|fail|200902|bingos@cpan.org|App-Maisha|0.06|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.16.38|200902232247
3337362|fail|200902|bingos@cpan.org|App-Maisha|0.05|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.16.38|200902232246
3336906|pass|200902|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|OpenBSD.i386-openbsd-thread-multi-64int|5.8.8|openbsd|4.3|200902231929
3336819|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha|0.11|s390x-linux-thread-multi|5.8.8|linux|2.6.16.60-0.31-default|200902231919
3336358|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha|0.11|s390x-linux|5.8.8|linux|2.6.16.60-0.31-default|200902231655
3335837|pass|200902|imacat@mail.imacat.idv.tw|App-Maisha-Plugin-PingFM|0.02|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.24-etchnhalf.1-amd64|200902232232
3335769|pass|200902|imacat@mail.imacat.idv.tw|App-Maisha|0.11|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.24-etchnhalf.1-amd64|200902232227
3335312|pass|200902|stsc@refcnt.org ("Steven Schubiger")|Test-CPAN-Meta|0.12|i686-linux|5.10.0|linux|2.6.18-14-ovz-686|200902231351
3335175|pass|200902|stsc@refcnt.org ("Steven Schubiger")|Regexp-Log-Common|0.05|i686-linux|5.10.0|linux|2.6.18-14-ovz-686|200902231312
3335053|pass|200902|dagolden@cpan.org (DAGOLDEN)|Test-YAML-Meta|0.11|x86_64-linux-ld|5.10.0|linux|2.6.27-9-generic|200902230643
3335031|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha|0.11|s390x-linux-thread-multi|5.10.0|linux|2.6.16.60-0.31-default|200902231235
3334800|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha|0.11|s390x-linux|5.10.0|linux|2.6.16.60-0.31-default|200902231128
3334517|pass|200902|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i86pc-solaris-thread-multi-64int|5.8.8|solaris|2.10|200902230912
3334513|pass|200902|bingos@cpan.org|App-Maisha-Plugin-PingFM|0.02|i86pc-solaris-thread-multi-64int|5.8.8|solaris|2.10|200902230910
3334511|pass|200902|bingos@cpan.org|App-Maisha-Plugin-PingFM|0.01|i86pc-solaris-thread-multi-64int|5.8.8|solaris|2.10|200902230909
3334503|pass|200902|bingos@cpan.org|App-Maisha|0.11|i86pc-solaris-thread-multi-64int|5.8.8|solaris|2.10|200902230907
3334501|pass|200902|bingos@cpan.org|App-Maisha|0.10|i86pc-solaris-thread-multi-64int|5.8.8|solaris|2.10|200902230906
3334498|pass|200902|bingos@cpan.org|App-Maisha|0.09|i86pc-solaris-thread-multi-64int|5.8.8|solaris|2.10|200902230905
3334495|pass|200902|bingos@cpan.org|App-Maisha|0.08|i86pc-solaris-thread-multi-64int|5.8.8|solaris|2.10|200902230904
3334490|pass|200902|bingos@cpan.org|App-Maisha|0.07|i86pc-solaris-thread-multi-64int|5.8.8|solaris|2.10|200902230903
3334482|fail|200902|bingos@cpan.org|App-Maisha|0.06|i86pc-solaris-thread-multi-64int|5.8.8|solaris|2.10|200902230902
3334477|fail|200902|bingos@cpan.org|App-Maisha|0.05|i86pc-solaris-thread-multi-64int|5.8.8|solaris|2.10|200902230901
3333766|pass|200902|rafl@debian.org|Test-YAML-Meta|0.11|i686-linux|5.10.0 patch 35117|linux|2.6.26|200902230816
3332943|pass|200902|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i386-netbsd-thread-multi-64int|5.8.8|netbsd|3.1|200902230311
3332755|pass|200902|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i86pc-solaris-thread-multi-64int|5.8.4|solaris|2.10|200902230203
3332751|pass|200902|bingos@cpan.org|App-Maisha-Plugin-PingFM|0.02|i86pc-solaris-thread-multi-64int|5.8.4|solaris|2.10|200902230202
3332748|pass|200902|bingos@cpan.org|App-Maisha-Plugin-PingFM|0.01|i86pc-solaris-thread-multi-64int|5.8.4|solaris|2.10|200902230201
3332740|pass|200902|bingos@cpan.org|App-Maisha|0.11|i86pc-solaris-thread-multi-64int|5.8.4|solaris|2.10|200902230159
3332738|pass|200902|bingos@cpan.org|App-Maisha|0.10|i86pc-solaris-thread-multi-64int|5.8.4|solaris|2.10|200902230158
3332736|pass|200902|bingos@cpan.org|App-Maisha|0.09|i86pc-solaris-thread-multi-64int|5.8.4|solaris|2.10|200902230157
3332734|pass|200902|bingos@cpan.org|App-Maisha|0.08|i86pc-solaris-thread-multi-64int|5.8.4|solaris|2.10|200902230156
3332733|pass|200902|bingos@cpan.org|App-Maisha|0.07|i86pc-solaris-thread-multi-64int|5.8.4|solaris|2.10|200902230156
3332729|fail|200902|bingos@cpan.org|App-Maisha|0.06|i86pc-solaris-thread-multi-64int|5.8.4|solaris|2.10|200902230155
3332725|fail|200902|bingos@cpan.org|App-Maisha|0.05|i86pc-solaris-thread-multi-64int|5.8.4|solaris|2.10|200902230154
3332721|fail|200902|bingos@cpan.org|App-Maisha|0.04|i86pc-solaris-thread-multi-64int|5.8.4|solaris|2.10|200902230153
3332456|pass|200902|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|OpenBSD.i386-openbsd-thread-multi-64int|5.10.0|openbsd|4.3|200902230040
3332454|pass|200902|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|OpenBSD.i386-openbsd-thread-multi-64int|5.8.9|openbsd|4.3|200902230039
3332321|pass|200902|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i86pc-solaris-thread-multi-64int|5.6.2|solaris|2.10|200902222352
3332202|pass|200902|mw487.yahoo.com@gmail.com|App-Maisha-Plugin-PingFM|0.02|cygwin-thread-multi-64int|5.10.0 patch 34065|cygwin|1.5.25(0.15642)|200902221830
3332195|pass|200902|mw487.yahoo.com@gmail.com|App-Maisha-Plugin-PingFM|0.01|cygwin-thread-multi-64int|5.10.0 patch 34065|cygwin|1.5.25(0.15642)|200902221829
3332178|pass|200902|mw487.yahoo.com@gmail.com|App-Maisha|0.11|cygwin-thread-multi-64int|5.10.0 patch 34065|cygwin|1.5.25(0.15642)|200902221826
3332173|pass|200902|mw487.yahoo.com@gmail.com|App-Maisha|0.10|cygwin-thread-multi-64int|5.10.0 patch 34065|cygwin|1.5.25(0.15642)|200902221826
3332172|pass|200902|mw487.yahoo.com@gmail.com|App-Maisha|0.09|cygwin-thread-multi-64int|5.10.0 patch 34065|cygwin|1.5.25(0.15642)|200902221826
3332170|pass|200902|mw487.yahoo.com@gmail.com|App-Maisha|0.08|cygwin-thread-multi-64int|5.10.0 patch 34065|cygwin|1.5.25(0.15642)|200902221825
3332168|pass|200902|mw487.yahoo.com@gmail.com|App-Maisha|0.07|cygwin-thread-multi-64int|5.10.0 patch 34065|cygwin|1.5.25(0.15642)|200902221825
3332166|pass|200902|mw487.yahoo.com@gmail.com|App-Maisha|0.06|cygwin-thread-multi-64int|5.10.0 patch 34065|cygwin|1.5.25(0.15642)|200902221825
3332165|pass|200902|mw487.yahoo.com@gmail.com|App-Maisha|0.05|cygwin-thread-multi-64int|5.10.0 patch 34065|cygwin|1.5.25(0.15642)|200902221824
3332163|pass|200902|mw487.yahoo.com@gmail.com|App-Maisha|0.04|cygwin-thread-multi-64int|5.10.0 patch 34065|cygwin|1.5.25(0.15642)|200902221824
3331895|pass|200902|stsc@refcnt.org ("Steven Schubiger")|CPAN-Testers-Data-Uploads|0.06|i686-linux|5.10.0|linux|2.6.18-14-ovz-686|200902222247
3331710|pass|200902|stsc@refcnt.org ("Steven Schubiger")|App-Maisha|0.11|i686-linux|5.10.0|linux|2.6.18-14-ovz-686|200902222203
3331555|pass|200902|srezic@cpan.org|CPAN-Testers-Common-Article|0.36|amd64-freebsd|5.6.2|freebsd|7.0-release|200902222123
3329175|pass|200902|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i386-netbsd-thread-multi-64int|5.8.8|netbsd|4.0|200902221047
3329078|pass|200902|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i86pc-solaris-thread-multi-64int|5.10.0|solaris|2.10|200902221019
3329077|pass|200902|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i86pc-solaris-thread-multi-64int|5.8.9|solaris|2.10|200902221019
3329074|pass|200902|bingos@cpan.org|App-Maisha-Plugin-PingFM|0.02|i86pc-solaris-thread-multi-64int|5.10.0|solaris|2.10|200902221017
3329073|pass|200902|bingos@cpan.org|App-Maisha-Plugin-PingFM|0.02|i86pc-solaris-thread-multi-64int|5.8.9|solaris|2.10|200902221017
3329070|pass|200902|bingos@cpan.org|App-Maisha-Plugin-PingFM|0.01|i86pc-solaris-thread-multi-64int|5.10.0|solaris|2.10|200902221016
3329069|pass|200902|bingos@cpan.org|App-Maisha-Plugin-PingFM|0.01|i86pc-solaris-thread-multi-64int|5.8.9|solaris|2.10|200902221016
3329065|pass|200902|bingos@cpan.org|App-Maisha|0.11|i86pc-solaris-thread-multi-64int|5.10.0|solaris|2.10|200902221014
3329064|pass|200902|bingos@cpan.org|App-Maisha|0.11|i86pc-solaris-thread-multi-64int|5.8.9|solaris|2.10|200902221013
3329063|pass|200902|bingos@cpan.org|App-Maisha|0.10|i86pc-solaris-thread-multi-64int|5.10.0|solaris|2.10|200902221012
3329062|pass|200902|bingos@cpan.org|App-Maisha|0.10|i86pc-solaris-thread-multi-64int|5.8.9|solaris|2.10|200902221012
3329061|pass|200902|bingos@cpan.org|App-Maisha|0.09|i86pc-solaris-thread-multi-64int|5.10.0|solaris|2.10|200902221011
3329060|pass|200902|bingos@cpan.org|App-Maisha|0.09|i86pc-solaris-thread-multi-64int|5.8.9|solaris|2.10|200902221011
3329059|pass|200902|bingos@cpan.org|App-Maisha|0.08|i86pc-solaris-thread-multi-64int|5.10.0|solaris|2.10|200902221010
3329058|pass|200902|bingos@cpan.org|App-Maisha|0.08|i86pc-solaris-thread-multi-64int|5.8.9|solaris|2.10|200902221010
3329057|pass|200902|bingos@cpan.org|App-Maisha|0.07|i86pc-solaris-thread-multi-64int|5.10.0|solaris|2.10|200902221009
3329056|pass|200902|bingos@cpan.org|App-Maisha|0.07|i86pc-solaris-thread-multi-64int|5.8.9|solaris|2.10|200902221009
3329055|fail|200902|bingos@cpan.org|App-Maisha|0.06|i86pc-solaris-thread-multi-64int|5.10.0|solaris|2.10|200902221008
3329053|fail|200902|bingos@cpan.org|App-Maisha|0.06|i86pc-solaris-thread-multi-64int|5.8.9|solaris|2.10|200902221008
3329052|fail|200902|bingos@cpan.org|App-Maisha|0.05|i86pc-solaris-thread-multi-64int|5.10.0|solaris|2.10|200902221007
3329051|fail|200902|bingos@cpan.org|App-Maisha|0.05|i86pc-solaris-thread-multi-64int|5.8.9|solaris|2.10|200902221007
3329050|fail|200902|bingos@cpan.org|App-Maisha|0.04|i86pc-solaris-thread-multi-64int|5.10.0|solaris|2.10|200902221007
3329049|fail|200902|bingos@cpan.org|App-Maisha|0.04|i86pc-solaris-thread-multi-64int|5.8.9|solaris|2.10|200902221006
3327465|pass|200902|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i386-netbsd-thread-multi-64int|5.6.2|netbsd|4.0|200902212347
3327169|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha|0.11|s390x-linux-thread-multi|5.8.8|linux|2.6.18-92.1.18.el5|200902212242
3327074|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha|0.11|s390x-linux|5.8.8|linux|2.6.18-92.1.18.el5|200902212207
3326511|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha|0.11|s390x-linux|5.10.0|linux|2.6.18-92.el5|200902211920
3326437|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha|0.11|s390x-linux-thread-multi|5.10.0|linux|2.6.18-92.el5|200902211924
3326089|pass|200902|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.0-release|200902211524
3326083|pass|200902|bingos@cpan.org|App-Maisha-Plugin-PingFM|0.02|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.0-release|200902211523
3326077|pass|200902|bingos@cpan.org|App-Maisha-Plugin-PingFM|0.01|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.0-release|200902211522
3326064|pass|200902|bingos@cpan.org|App-Maisha|0.11|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.0-release|200902211519
3326063|pass|200902|bingos@cpan.org|App-Maisha|0.10|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.0-release|200902211518
3326058|pass|200902|bingos@cpan.org|App-Maisha|0.09|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.0-release|200902211517
3326053|pass|200902|bingos@cpan.org|App-Maisha|0.08|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.0-release|200902211516
3326049|pass|200902|bingos@cpan.org|App-Maisha|0.07|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.0-release|200902211515
3326044|fail|200902|bingos@cpan.org|App-Maisha|0.06|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.0-release|200902211514
3326041|fail|200902|bingos@cpan.org|App-Maisha|0.05|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.0-release|200902211513
3326037|fail|200902|bingos@cpan.org|App-Maisha|0.04|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.0-release|200902211512
3326034|fail|200902|bingos@cpan.org|App-Maisha|0.03|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.0-release|200902211511
3326033|fail|200902|bingos@cpan.org|App-Maisha|0.02|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.0-release|200902211510
3325666|pass|200902|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0|200902211459
3325648|pass|200902|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i386-netbsd-thread-multi-64int|5.8.9|netbsd|4.0|200902211454
3325617|pass|200902|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i386-freebsd-thread-multi-64int|5.6.2|freebsd|7.0-release|200902211310
3323902|pass|200902|bingos@cpan.org|CPAN-Testers-Data-Uploads|0.06|i386-netbsd-thread-multi-64int|5.8.8|netbsd|4.0.1|200902210117
3323901|pass|200902|bingos@cpan.org|CPAN-Testers-Data-Uploads|0.05|i386-netbsd-thread-multi-64int|5.8.8|netbsd|4.0.1|200902210117
3323900|fail|200902|bingos@cpan.org|CPAN-Testers-Data-Uploads|0.04|i386-netbsd-thread-multi-64int|5.8.8|netbsd|4.0.1|200902210116
3323896|pass|200902|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i386-netbsd-thread-multi-64int|5.8.8|netbsd|4.0.1|200902210115
3323618|fail|200902|bingos@cpan.org|CPAN-Testers-Data-Uploads|0.04|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.0-release|200902202220
3323604|fail|200902|bingos@cpan.org|CPAN-Testers-Data-Uploads|0.04|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.0-release|200902202218
3323589|pass|200902|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.0-release|200902202217
3323583|pass|200902|bingos@cpan.org|App-Maisha-Plugin-PingFM|0.02|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.0-release|200902202215
3323578|pass|200902|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.0-release|200902202214
3323573|pass|200902|bingos@cpan.org|App-Maisha-Plugin-PingFM|0.01|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.0-release|200902202214
3323568|pass|200902|bingos@cpan.org|App-Maisha-Plugin-PingFM|0.02|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.0-release|200902202213
3323559|pass|200902|bingos@cpan.org|App-Maisha-Plugin-PingFM|0.01|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.0-release|200902202211
3323554|pass|200902|bingos@cpan.org|App-Maisha|0.11|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.0-release|200902202211
3323547|pass|200902|bingos@cpan.org|App-Maisha|0.10|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.0-release|200902202209
3323541|pass|200902|bingos@cpan.org|App-Maisha|0.09|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.0-release|200902202208
3323537|pass|200902|bingos@cpan.org|App-Maisha|0.08|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.0-release|200902202207
3323533|pass|200902|bingos@cpan.org|App-Maisha|0.11|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.0-release|200902202206
3323530|pass|200902|bingos@cpan.org|App-Maisha|0.07|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.0-release|200902202206
3323526|pass|200902|bingos@cpan.org|App-Maisha|0.10|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.0-release|200902202205
3323523|pass|200902|bingos@cpan.org|App-Maisha|0.06|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.0-release|200902202205
3323518|pass|200902|bingos@cpan.org|App-Maisha|0.09|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.0-release|200902202204
3323515|pass|200902|bingos@cpan.org|App-Maisha|0.05|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.0-release|200902202204
3323512|pass|200902|bingos@cpan.org|App-Maisha|0.08|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.0-release|200902202203
3323511|pass|200902|bingos@cpan.org|App-Maisha|0.04|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.0-release|200902202203
3323507|pass|200902|bingos@cpan.org|App-Maisha|0.07|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.0-release|200902202202
3323506|pass|200902|bingos@cpan.org|App-Maisha|0.03|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.0-release|200902202202
3323502|fail|200902|bingos@cpan.org|App-Maisha|0.02|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.0-release|200902202201
3323500|fail|200902|bingos@cpan.org|App-Maisha|0.06|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.0-release|200902202201
3323499|fail|200902|bingos@cpan.org|App-Maisha|0.01|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.0-release|200902202200
3323492|fail|200902|bingos@cpan.org|App-Maisha|0.05|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.0-release|200902202200
3323487|fail|200902|bingos@cpan.org|App-Maisha|0.04|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.0-release|200902202159
3323482|fail|200902|bingos@cpan.org|App-Maisha|0.03|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.0-release|200902202158
3323475|fail|200902|bingos@cpan.org|App-Maisha|0.02|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.0-release|200902202157
3323472|fail|200902|bingos@cpan.org|App-Maisha|0.01|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.0-release|200902202156
3323455|pass|200902|shlomif@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i686-linux|5.10.0|linux|2.6.29-desktop-0.rc5.1mnb|200902210033
3323453|pass|200902|shlomif@cpan.org|CPAN-Testers-Common-Article|0.36|i686-linux|5.10.0|linux|2.6.29-desktop-0.rc5.1mnb|200902210033
3322730|pass|200902|dagolden@cpan.org (DAGOLDEN)|Test-CPAN-Meta|0.12|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.1|200902201405
3322421|pass|200902|srezic@cpan.org|CPAN-Testers-Data-Uploads|0.06|amd64-freebsd-thread-multi|5.10.0|freebsd|7.0-release|200902201835
3321950|pass|200902|david@cantrell.org.uk|App-Maisha|0.11|alpha-netbsd|5.10.0|netbsd|4.0.1|200902201528
3321947|pass|200902|david@cantrell.org.uk|App-Maisha|0.11|IP35-irix-64int|5.8.8|irix|6.5|200902201628
3321913|pass|200902|david@cantrell.org.uk|App-Maisha|0.11|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200902200917
3321872|pass|200902|david@cantrell.org.uk|App-Maisha|0.11|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200902201503
3321870|pass|200902|david@cantrell.org.uk|App-Maisha|0.11|x86_64-linux-thread-multi|5.8.9|linux|2.6.18-4-xen-amd64|200902201503
3321863|pass|200902|david@cantrell.org.uk|App-Maisha|0.11|x86_64-linux-thread-multi|5.10.0|linux|2.6.18-4-xen-amd64|200902201503
3321862|pass|200902|david@cantrell.org.uk|App-Maisha|0.11|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200902201502
3321303|pass|200902|bingos@cpan.org|CPAN-Testers-Data-Uploads|0.06|i386-netbsd-thread-multi-64int|5.8.9|netbsd|4.0.1|200902201211
3321301|pass|200902|bingos@cpan.org|CPAN-Testers-Data-Uploads|0.05|i386-netbsd-thread-multi-64int|5.8.9|netbsd|4.0.1|200902201210
3321300|fail|200902|bingos@cpan.org|CPAN-Testers-Data-Uploads|0.04|i386-netbsd-thread-multi-64int|5.8.9|netbsd|4.0.1|200902201209
3321298|pass|200902|bingos@cpan.org|CPAN-Testers-Data-Uploads|0.06|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0.1|200902201208
3321296|pass|200902|bingos@cpan.org|CPAN-Testers-Data-Uploads|0.05|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0.1|200902201207
3321294|pass|200902|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i386-netbsd-thread-multi-64int|5.8.9|netbsd|4.0.1|200902201206
3321293|fail|200902|bingos@cpan.org|CPAN-Testers-Data-Uploads|0.04|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0.1|200902201206
3321287|pass|200902|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0.1|200902201204
3321193|fail|200902|bingos@cpan.org|CPAN-Testers-Data-Uploads|0.04|i386-netbsd-thread-multi-64int|5.8.8|netbsd|4.0|200902201102
3321191|pass|200902|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i386-netbsd-thread-multi-64int|5.8.8|netbsd|4.0|200902201101
3320605|pass|200902|jeff@zeroclue.com|Data-Phrasebook-Loader-YAML|0.09|OpenBSD.i386-openbsd|5.8.9|openbsd|4.4|200902200031
3320604|pass|200902|jeff@zeroclue.com|Data-Phrasebook|0.29|OpenBSD.i386-openbsd|5.8.9|openbsd|4.4|200902200030
3320177|pass|200902|srezic@cpan.org|CPAN-Testers-Data-Generator|0.36|amd64-freebsd-thread-multi|5.10.0|freebsd|7.0-release|200902200037
3320176|pass|200902|srezic@cpan.org|CPAN-Testers-Common-Article|0.36|amd64-freebsd-thread-multi|5.10.0|freebsd|7.0-release|200902200037
3320086|pass|200902|vpit@cpan.org|Test-YAML-Meta|0.11|i686-linux-64int-ld|5.10.0|linux|2.6.27.4-chii.profvince.com|200902200019
3318966|fail|200902|bingos@cpan.org|CPAN-Testers-Data-Uploads|0.04|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.1-release|200902191236
3318960|pass|200902|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.1-release|200902191234
3318957|pass|200902|bingos@cpan.org|App-Maisha-Plugin-PingFM|0.02|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.1-release|200902191233
3318954|pass|200902|bingos@cpan.org|App-Maisha-Plugin-PingFM|0.01|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.1-release|200902191232
3318950|pass|200902|bingos@cpan.org|App-Maisha|0.11|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.1-release|200902191231
3318948|pass|200902|bingos@cpan.org|App-Maisha|0.10|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.1-release|200902191230
3318944|pass|200902|bingos@cpan.org|App-Maisha|0.09|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.1-release|200902191229
3318942|pass|200902|bingos@cpan.org|App-Maisha|0.08|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.1-release|200902191229
3318941|pass|200902|bingos@cpan.org|App-Maisha|0.07|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.1-release|200902191228
3318940|fail|200902|bingos@cpan.org|App-Maisha|0.06|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.1-release|200902191227
3318938|fail|200902|bingos@cpan.org|App-Maisha|0.05|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.1-release|200902191227
3318936|fail|200902|bingos@cpan.org|App-Maisha|0.04|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.1-release|200902191226
3318933|fail|200902|bingos@cpan.org|App-Maisha|0.03|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.1-release|200902191226
3318931|fail|200902|bingos@cpan.org|App-Maisha|0.02|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.1-release|200902191225
3318930|fail|200902|bingos@cpan.org|App-Maisha|0.01|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.1-release|200902191225
3318529|fail|200902|bingos@cpan.org|CPAN-Testers-Data-Uploads|0.04|i386-netbsd-thread-multi-64int|5.8.9|netbsd|4.0|200902191503
3318523|pass|200902|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i386-netbsd-thread-multi-64int|5.8.9|netbsd|4.0|200902191459
3318490|fail|200902|bingos@cpan.org|CPAN-Testers-Data-Uploads|0.04|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0|200902191434
3318486|pass|200902|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0|200902191431
3318357|pass|200902|david@cantrell.org.uk|App-Maisha-Plugin-PingFM|0.02|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200902190621
3318354|pass|200902|david@cantrell.org.uk|App-Maisha-Plugin-PingFM|0.02|alpha-netbsd|5.10.0|netbsd|4.0.1|200902191220
3318337|pass|200902|david@cantrell.org.uk|App-Maisha-Plugin-PingFM|0.02|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200902191217
3318288|pass|200902|david@cantrell.org.uk|App-Maisha|0.10|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200902190554
3318285|pass|200902|david@cantrell.org.uk|App-Maisha|0.09|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200902190553
3318280|pass|200902|david@cantrell.org.uk|App-Maisha|0.08|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200902190552
3318278|pass|200902|david@cantrell.org.uk|App-Maisha|0.07|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200902190551
3318248|pass|200902|david@cantrell.org.uk|App-Maisha|0.10|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200902191109
3318246|pass|200902|david@cantrell.org.uk|App-Maisha|0.09|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200902191109
3318245|pass|200902|david@cantrell.org.uk|App-Maisha|0.08|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200902191109
3318244|pass|200902|david@cantrell.org.uk|App-Maisha|0.07|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200902191109
3318229|pass|200902|david@cantrell.org.uk|App-Maisha|0.10|alpha-netbsd|5.10.0|netbsd|4.0.1|200902191059
3318226|pass|200902|david@cantrell.org.uk|App-Maisha|0.09|alpha-netbsd|5.10.0|netbsd|4.0.1|200902191058
3318223|pass|200902|david@cantrell.org.uk|App-Maisha|0.10|IP35-irix-64int|5.8.8|irix|6.5|200902191158
3318215|pass|200902|david@cantrell.org.uk|App-Maisha|0.08|alpha-netbsd|5.10.0|netbsd|4.0.1|200902191057
3318213|pass|200902|david@cantrell.org.uk|App-Maisha|0.09|IP35-irix-64int|5.8.8|irix|6.5|200902191157
3318210|pass|200902|david@cantrell.org.uk|App-Maisha|0.08|IP35-irix-64int|5.8.8|irix|6.5|200902191156
3318207|pass|200902|david@cantrell.org.uk|App-Maisha|0.07|IP35-irix-64int|5.8.8|irix|6.5|200902191155
3318196|pass|200902|david@cantrell.org.uk|App-Maisha-Plugin-PingFM|0.02|x86_64-linux-thread-multi|5.10.0|linux|2.6.18-4-xen-amd64|200902191054
3318194|pass|200902|david@cantrell.org.uk|App-Maisha-Plugin-PingFM|0.02|x86_64-linux-thread-multi|5.8.9|linux|2.6.18-4-xen-amd64|200902191054
3318023|pass|200902|david@cantrell.org.uk|App-Maisha|0.10|x86_64-linux-thread-multi|5.10.0|linux|2.6.18-4-xen-amd64|200902190914
3318022|pass|200902|david@cantrell.org.uk|App-Maisha|0.09|x86_64-linux-thread-multi|5.10.0|linux|2.6.18-4-xen-amd64|200902190914
3318020|pass|200902|david@cantrell.org.uk|App-Maisha|0.08|x86_64-linux-thread-multi|5.10.0|linux|2.6.18-4-xen-amd64|200902190914
3318019|pass|200902|david@cantrell.org.uk|App-Maisha|0.07|x86_64-linux-thread-multi|5.10.0|linux|2.6.18-4-xen-amd64|200902190914
3318018|pass|200902|david@cantrell.org.uk|App-Maisha|0.10|x86_64-linux-thread-multi|5.8.9|linux|2.6.18-4-xen-amd64|200902190913
3318016|pass|200902|david@cantrell.org.uk|App-Maisha|0.09|x86_64-linux-thread-multi|5.8.9|linux|2.6.18-4-xen-amd64|200902190913
3318015|pass|200902|david@cantrell.org.uk|App-Maisha|0.08|x86_64-linux-thread-multi|5.8.9|linux|2.6.18-4-xen-amd64|200902190913
3318014|pass|200902|david@cantrell.org.uk|App-Maisha|0.07|x86_64-linux-thread-multi|5.8.9|linux|2.6.18-4-xen-amd64|200902190913
3318008|pass|200902|david@cantrell.org.uk|App-Maisha|0.10|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200902190912
3318006|pass|200902|david@cantrell.org.uk|App-Maisha|0.09|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200902190911
3318004|pass|200902|david@cantrell.org.uk|App-Maisha|0.08|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200902190911
3318003|pass|200902|david@cantrell.org.uk|App-Maisha|0.07|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200902190911
3317921|pass|200902|JOST@cpan.org ("Josts Smokehouse")|App-Maisha|0.11|i86pc-solaris-64int|5.10.0|solaris|2.11|200902190929
3317643|fail|200902|mw487.yahoo.com@gmail.com|App-Maisha|0.04|cygwin-thread-multi-64int|5.8.8|cygwin|1.5.24(0.15642)|200902190441
3317472|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha-Plugin-PingFM|0.02|s390x-linux-thread-multi|5.8.8|linux|2.6.18-92.1.18.el5|200902190404
3317435|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha|0.10|s390x-linux-thread-multi|5.8.8|linux|2.6.18-92.1.18.el5|200902190336
3317068|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha-Plugin-PingFM|0.02|s390x-linux|5.8.8|linux|2.6.18-92.1.18.el5|200902190134
3317008|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha-Plugin-PingFM|0.02|s390x-linux-thread-multi|5.8.8|linux|2.6.16.60-0.31-default|200902190125
3316960|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha|0.10|s390x-linux|5.8.8|linux|2.6.18-92.1.18.el5|200902190110
3316906|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha|0.10|s390x-linux-thread-multi|5.8.8|linux|2.6.16.60-0.31-default|200902190058
3316879|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha-Plugin-PingFM|0.02|s390x-linux|5.8.8|linux|2.6.16.60-0.31-default|200902190057
3316776|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha-Plugin-PingFM|0.02|s390x-linux-thread-multi|5.10.0|linux|2.6.18-92.el5|200902190041
3316774|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha|0.10|s390x-linux-thread-multi|5.10.0|linux|2.6.18-92.el5|200902190037
3316772|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha|0.10|s390x-linux|5.8.8|linux|2.6.16.60-0.31-default|200902190033
3316730|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha-Plugin-PingFM|0.02|s390x-linux|5.10.0|linux|2.6.18-92.el5|200902190020
3316722|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha|0.10|s390x-linux|5.10.0|linux|2.6.18-92.el5|200902190016
3316652|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha-Plugin-PingFM|0.02|s390x-linux-thread-multi|5.10.0|linux|2.6.16.60-0.31-default|200902182352
3316641|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha|0.10|s390x-linux-thread-multi|5.10.0|linux|2.6.16.60-0.31-default|200902182346
3316617|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha-Plugin-PingFM|0.02|s390x-linux|5.10.0|linux|2.6.16.60-0.31-default|200902182334
3316612|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha|0.10|s390x-linux|5.10.0|linux|2.6.16.60-0.31-default|200902182328
3316321|pass|200902|srezic@cpan.org|App-Maisha|0.11|amd64-freebsd|5.8.9|freebsd|7.0-release|200902182229
3316092|pass|200902|srezic@cpan.org|App-Maisha|0.11|amd64-freebsd|5.8.8|freebsd|7.0-release|200902182121
3315786|fail|200902|bingos@cpan.org|CPAN-Testers-Data-Uploads|0.04|OpenBSD.i386-openbsd-thread-multi-64int|5.8.8|openbsd|4.2|200902181824
3315776|pass|200902|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|OpenBSD.i386-openbsd-thread-multi-64int|5.8.8|openbsd|4.2|200902181821
3315702|fail|200902|bingos@cpan.org|CPAN-Testers-Data-Uploads|0.04|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.1-release|200902181738
3315700|fail|200902|bingos@cpan.org|CPAN-Testers-Data-Uploads|0.04|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.1-release|200902181737
3315693|pass|200902|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.1-release|200902181733
3315691|pass|200902|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.1-release|200902181733
3315690|pass|200902|bingos@cpan.org|App-Maisha-Plugin-PingFM|0.02|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.1-release|200902181733
3315688|pass|200902|bingos@cpan.org|App-Maisha-Plugin-PingFM|0.02|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.1-release|200902181731
3315687|pass|200902|bingos@cpan.org|App-Maisha-Plugin-PingFM|0.01|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.1-release|200902181731
3315685|pass|200902|bingos@cpan.org|App-Maisha-Plugin-PingFM|0.01|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.1-release|200902181729
3315683|pass|200902|bingos@cpan.org|App-Maisha|0.10|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.1-release|200902181727
3315681|pass|200902|bingos@cpan.org|App-Maisha|0.10|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.1-release|200902181727
3315680|pass|200902|bingos@cpan.org|App-Maisha|0.09|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.1-release|200902181726
3315679|pass|200902|bingos@cpan.org|App-Maisha|0.09|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.1-release|200902181725
3315678|pass|200902|bingos@cpan.org|App-Maisha|0.08|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.1-release|200902181725
3315677|pass|200902|bingos@cpan.org|App-Maisha|0.08|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.1-release|200902181724
3315676|pass|200902|bingos@cpan.org|App-Maisha|0.07|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.1-release|200902181724
3315673|pass|200902|bingos@cpan.org|App-Maisha|0.07|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.1-release|200902181723
3315672|fail|200902|bingos@cpan.org|App-Maisha|0.06|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.1-release|200902181722
3315671|fail|200902|bingos@cpan.org|App-Maisha|0.05|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.1-release|200902181722
3315670|fail|200902|bingos@cpan.org|App-Maisha|0.06|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.1-release|200902181721
3315668|fail|200902|bingos@cpan.org|App-Maisha|0.04|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.1-release|200902181721
3315667|fail|200902|bingos@cpan.org|App-Maisha|0.05|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.1-release|200902181720
3315666|fail|200902|bingos@cpan.org|App-Maisha|0.03|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.1-release|200902181720
3315665|fail|200902|bingos@cpan.org|App-Maisha|0.04|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.1-release|200902181719
3315664|fail|200902|bingos@cpan.org|App-Maisha|0.02|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.1-release|200902181719
3315663|fail|200902|bingos@cpan.org|App-Maisha|0.03|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.1-release|200902181718
3315662|fail|200902|bingos@cpan.org|App-Maisha|0.01|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.1-release|200902181718
3315659|fail|200902|bingos@cpan.org|App-Maisha|0.02|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.1-release|200902181717
3315656|fail|200902|bingos@cpan.org|App-Maisha|0.01|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.1-release|200902181716
3315594|pass|200902|office@darac.org.uk|Mail-Outlook|0.15|MSWin32-x86-multi-thread|5.8.6|MSWin32|4.0|200902171029
3315530|cpan|200902|BARBIE|App-Maisha|0.11||0|||200902181649
3315524|pass|200902|JOST@cpan.org ("Josts Smokehouse")|App-Maisha-Plugin-PingFM|0.02|i86pc-solaris-64int|5.10.0|solaris|2.11|200902181647
3315522|pass|200902|JOST@cpan.org ("Josts Smokehouse")|App-Maisha|0.10|i86pc-solaris-64int|5.10.0|solaris|2.11|200902181646
3314683|pass|200902|JOST@cpan.org ("Josts Smokehouse")|App-Maisha|0.08|i86pc-solaris-64int|5.10.0|solaris|2.11|200902181121
3313968|fail|200902|bingos@cpan.org|CPAN-Testers-Data-Uploads|0.04|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.0-release|200902180139
3313950|pass|200902|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.0-release|200902180134
3313947|pass|200902|bingos@cpan.org|App-Maisha-Plugin-PingFM|0.01|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.0-release|200902180133
3313945|pass|200902|bingos@cpan.org|App-Maisha|0.10|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.0-release|200902180132
3313938|fail|200902|bingos@cpan.org|App-Maisha|0.06|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.0-release|200902180129
3313936|fail|200902|bingos@cpan.org|App-Maisha|0.05|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.0-release|200902180128
3313935|fail|200902|bingos@cpan.org|App-Maisha|0.04|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.0-release|200902180127
3313932|fail|200902|bingos@cpan.org|App-Maisha|0.03|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.0-release|200902180127
3313930|fail|200902|bingos@cpan.org|App-Maisha|0.02|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.0-release|200902180126
3313613|pass|200902|DCOLLINS@cpan.org|CPAN-Testers-Data-Uploads|0.04|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902171811
3313602|pass|200902|DCOLLINS@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902171810
3313600|pass|200902|DCOLLINS@cpan.org|CPAN-Testers-Common-Article|0.36|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902171810
3313597|pass|200902|DCOLLINS@cpan.org|App-Maisha-Plugin-PingFM|0.01|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902171810
3313589|pass|200902|DCOLLINS@cpan.org|App-Maisha|0.10|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902171809
3313584|pass|200902|DCOLLINS@cpan.org|App-Maisha|0.06|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902171809
3313579|pass|200902|DCOLLINS@cpan.org|App-Maisha|0.05|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902171809
3313577|pass|200902|DCOLLINS@cpan.org|App-Maisha|0.04|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902171808
3313575|pass|200902|DCOLLINS@cpan.org|App-Maisha|0.03|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902171808
3313572|fail|200902|DCOLLINS@cpan.org|App-Maisha|0.02|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902171808
3313570|fail|200902|DCOLLINS@cpan.org|App-Maisha|0.01|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902171808
3312806|pass|200902|srezic@cpan.org|CPAN-Testers-Data-Generator|0.36|amd64-freebsd|5.10.0|freebsd|7.0-release|200902172112
3312768|pass|200902|srezic@cpan.org|CPAN-WWW-Testers|0.49|amd64-freebsd|5.10.0|freebsd|7.0-release|200902172103
3312733|pass|200902|srezic@cpan.org|App-Maisha|0.10|amd64-freebsd|5.8.8|freebsd|7.0-release|200902172038
3312687|pass|200902|srezic@cpan.org|App-Maisha-Plugin-PingFM|0.02|amd64-freebsd|5.8.8|freebsd|7.0-release|200902172038
3312673|pass|200902|srezic@cpan.org|App-Maisha-Plugin-PingFM|0.02|amd64-freebsd|5.8.9|freebsd|7.0-release|200902172037
3312671|pass|200902|srezic@cpan.org|App-Maisha|0.10|amd64-freebsd|5.8.9|freebsd|7.0-release|200902172037
3312133|fail|200902|bingos@cpan.org|CPAN-Testers-Data-Uploads|0.04|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.0-release|200902171724
3312119|pass|200902|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.0-release|200902171719
3312105|pass|200902|bingos@cpan.org|App-Maisha|0.08|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.0-release|200902171716
3312099|fail|200902|bingos@cpan.org|App-Maisha|0.05|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.0-release|200902171714
3312097|fail|200902|bingos@cpan.org|App-Maisha|0.04|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.0-release|200902171713
3312094|fail|200902|bingos@cpan.org|App-Maisha|0.03|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.0-release|200902171713
3312089|fail|200902|bingos@cpan.org|App-Maisha|0.02|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.0-release|200902171712
3312086|fail|200902|bingos@cpan.org|App-Maisha|0.01|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.0-release|200902171711
3312069|pass|200902|david@cantrell.org.uk|CPAN-Testers-Data-Uploads|0.06|alpha-netbsd|5.10.0|netbsd|4.0.1|200902171709
3312064|pass|200902|david@cantrell.org.uk|CPAN-Testers-Data-Uploads|0.05|alpha-netbsd|5.10.0|netbsd|4.0.1|200902171707
3311935|pass|200902|david@cantrell.org.uk|App-Maisha-Plugin-PingFM|0.01|alpha-netbsd|5.10.0|netbsd|4.0.1|200902171646
3311846|pass|200902|david@cantrell.org.uk|CPAN-Testers-Data-Uploads|0.06|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200902171029
3311786|pass|200902|vpit@cpan.org|App-Maisha-Plugin-PingFM|0.01|x86_64-linux-thread-multi|5.10.0|linux|2.6.26.3-fuuka.profvince.com|200902171719
3311781|pass|200902|david@cantrell.org.uk|CPAN-Testers-Data-Uploads|0.05|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200902171017
3311780|pass|200902|vpit@cpan.org|App-Maisha|0.08|x86_64-linux-thread-multi|5.10.0|linux|2.6.26.3-fuuka.profvince.com|200902171719
3311779|pass|200902|david@cantrell.org.uk|App-Maisha|0.07|alpha-netbsd|5.10.0|netbsd|4.0.1|200902171616
3311777|pass|200902|vpit@cpan.org|App-Maisha|0.06|x86_64-linux-thread-multi|5.10.0|linux|2.6.26.3-fuuka.profvince.com|200902171718
3311776|fail|200902|david@cantrell.org.uk|App-Maisha|0.06|alpha-netbsd|5.10.0|netbsd|4.0.1|200902171616
3311772|pass|200902|vpit@cpan.org|App-Maisha|0.05|x86_64-linux-thread-multi|5.10.0|linux|2.6.26.3-fuuka.profvince.com|200902171717
3311667|fail|200902|david@cantrell.org.uk|App-Maisha|0.05|alpha-netbsd|5.10.0|netbsd|4.0.1|200902171550
3311642|cpan|200902|BARBIE|App-Maisha|0.10||0|||200902171647
3311637|fail|200902|david@cantrell.org.uk|App-Maisha|0.04|alpha-netbsd|5.10.0|netbsd|4.0.1|200902171547
3311615|cpan|200902|BARBIE|App-Maisha-Plugin-PingFM|0.02||0|||200902171643
3311567|cpan|200902|BARBIE|App-Maisha|0.09||0|||200902171638
3311511|pass|200902|david@cantrell.org.uk|CPAN-Testers-Data-Uploads|0.06|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200902171525
3311510|pass|200902|david@cantrell.org.uk|CPAN-Testers-Data-Uploads|0.06|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200902171525
3311458|pass|200902|david@cantrell.org.uk|CPAN-Testers-Data-Uploads|0.05|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200902171512
3311454|pass|200902|david@cantrell.org.uk|CPAN-Testers-Data-Uploads|0.05|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200902171512
3311452|pass|200902|david@cantrell.org.uk|CPAN-Testers-Data-Uploads|0.06|x86_64-linux-thread-multi|5.10.0|linux|2.6.18-4-xen-amd64|200902171512
3311444|pass|200902|david@cantrell.org.uk|CPAN-Testers-Data-Uploads|0.05|x86_64-linux-thread-multi|5.10.0|linux|2.6.18-4-xen-amd64|200902171510
3311439|fail|200902|david@cantrell.org.uk|App-Maisha|0.06|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200902170910
3311304|fail|200902|bingos@cpan.org|CPAN-Testers-Data-Uploads|0.04|OpenBSD.i386-openbsd-thread-multi-64int|5.10.0|openbsd|4.2|200902171434
3311303|fail|200902|bingos@cpan.org|CPAN-Testers-Data-Uploads|0.04|OpenBSD.i386-openbsd-thread-multi-64int|5.8.9|openbsd|4.2|200902171434
3311285|pass|200902|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|OpenBSD.i386-openbsd-thread-multi-64int|5.8.9|openbsd|4.2|200902171428
3311283|pass|200902|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|OpenBSD.i386-openbsd-thread-multi-64int|5.10.0|openbsd|4.2|200902171428
3311015|cpan|200902|BARBIE|App-Maisha|0.08||0|||200902171407
3310770|pass|200902|JOST@cpan.org ("Josts Smokehouse")|CPAN-Testers-Data-Uploads|0.06|i86pc-solaris-64int|5.10.0|solaris|2.11|200902171301
3310697|pass|200902|JOST@cpan.org ("Josts Smokehouse")|CPAN-Testers-Data-Generator|0.36|i86pc-solaris-64int|5.10.0|solaris|2.11|200902171249
3310695|pass|200902|JOST@cpan.org ("Josts Smokehouse")|CPAN-Testers-Common-Article|0.36|i86pc-solaris-64int|5.10.0|solaris|2.11|200902171249
3310658|fail|200902|bingos@cpan.org|CPAN-Testers-Data-Uploads|0.04|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.0-release|200902171141
3310650|pass|200902|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.0-release|200902171139
3310644|pass|200902|JOST@cpan.org ("Josts Smokehouse")|App-Maisha-Plugin-PingFM|0.01|i86pc-solaris-64int|5.10.0|solaris|2.11|200902171238
3310643|fail|200902|bingos@cpan.org|App-Maisha|0.06|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.0-release|200902171138
3310642|pass|200902|JOST@cpan.org ("Josts Smokehouse")|App-Maisha|0.06|i86pc-solaris-64int|5.10.0|solaris|2.11|200902171237
3310640|fail|200902|bingos@cpan.org|App-Maisha|0.05|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.0-release|200902171137
3310637|fail|200902|bingos@cpan.org|App-Maisha|0.04|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.0-release|200902171137
3310634|fail|200902|bingos@cpan.org|App-Maisha|0.03|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.0-release|200902171136
3310632|fail|200902|bingos@cpan.org|App-Maisha|0.02|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.0-release|200902171136
3310629|fail|200902|bingos@cpan.org|App-Maisha|0.01|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.0-release|200902171135
3310527|cpan|200902|BARBIE|App-Maisha|0.07||0|||200902171212
3310525|pass|200902|david@cantrell.org.uk|CPAN-Testers-Data-Uploads|0.06|IP35-irix-64int|5.8.8|irix|6.5|200902171212
3310511|pass|200902|david@cantrell.org.uk|CPAN-Testers-Data-Uploads|0.05|IP35-irix-64int|5.8.8|irix|6.5|200902171210
3310423|fail|200902|david@cantrell.org.uk|App-Maisha|0.05|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200902170457
3310422|pass|200902|david@cantrell.org.uk|CPAN-Testers-Data-Uploads|0.06|x86_64-linux-thread-multi|5.8.9|linux|2.6.18-4-xen-amd64|200902171057
3310419|pass|200902|david@cantrell.org.uk|CPAN-Testers-Data-Uploads|0.05|x86_64-linux-thread-multi|5.8.9|linux|2.6.18-4-xen-amd64|200902171056
3310418|fail|200902|david@cantrell.org.uk|App-Maisha|0.04|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200902170456
3310241|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha|0.06|s390x-linux-thread-multi|5.8.8|linux|2.6.16.60-0.31-default|200902171119
3310211|fail|200902|david@cantrell.org.uk|App-Maisha|0.06|IP35-irix-64int|5.8.8|irix|6.5|200902171114
3310210|fail|200902|david@cantrell.org.uk|App-Maisha|0.06|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200902171013
3310208|fail|200902|david@cantrell.org.uk|App-Maisha|0.06|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200902171014
3310207|fail|200902|david@cantrell.org.uk|App-Maisha|0.05|IP35-irix-64int|5.8.8|irix|6.5|200902171113
3310204|fail|200902|david@cantrell.org.uk|App-Maisha|0.05|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200902171012
3310203|fail|200902|david@cantrell.org.uk|App-Maisha|0.05|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200902171012
3310171|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha-Plugin-PingFM|0.01|s390x-linux-thread-multi|5.8.8|linux|2.6.16.60-0.31-default|200902171104
3310170|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha|0.06|s390x-linux|5.8.8|linux|2.6.16.60-0.31-default|200902171104
3310164|pass|200902|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i386-freebsd-thread-multi-64int|5.6.2|freebsd|7.0-release|200902170935
3310113|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha|0.06|s390x-linux|5.8.8|linux|2.6.18-92.1.18.el5|200902171052
3310106|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha-Plugin-PingFM|0.01|s390x-linux|5.8.8|linux|2.6.16.60-0.31-default|200902171050
3310081|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha|0.04|s390x-linux-thread-multi|5.8.8|linux|2.6.16.60-0.31-default|200902171043
3310067|fail|200902|david@cantrell.org.uk|App-Maisha|0.04|IP35-irix-64int|5.8.8|irix|6.5|200902171038
3310065|fail|200902|david@cantrell.org.uk|App-Maisha|0.04|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200902170937
3310063|fail|200902|david@cantrell.org.uk|App-Maisha|0.04|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200902170938
3310062|fail|200902|david@cantrell.org.uk|App-Maisha|0.06|x86_64-linux-thread-multi|5.10.0|linux|2.6.18-4-xen-amd64|200902170937
3310059|fail|200902|david@cantrell.org.uk|App-Maisha|0.05|x86_64-linux-thread-multi|5.10.0|linux|2.6.18-4-xen-amd64|200902170937
3310057|fail|200902|david@cantrell.org.uk|App-Maisha|0.04|x86_64-linux-thread-multi|5.10.0|linux|2.6.18-4-xen-amd64|200902170937
3310055|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha-Plugin-PingFM|0.01|s390x-linux|5.8.8|linux|2.6.18-92.1.18.el5|200902171036
3310033|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha|0.04|s390x-linux|5.8.8|linux|2.6.16.60-0.31-default|200902171029
3309991|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha|0.04|s390x-linux|5.8.8|linux|2.6.18-92.1.18.el5|200902171016
3309972|fail|200902|david@cantrell.org.uk|App-Maisha|0.06|x86_64-linux-thread-multi|5.8.9|linux|2.6.18-4-xen-amd64|200902170913
3309971|fail|200902|david@cantrell.org.uk|App-Maisha|0.05|x86_64-linux-thread-multi|5.8.9|linux|2.6.18-4-xen-amd64|200902170912
3309956|fail|200902|david@cantrell.org.uk|App-Maisha|0.04|x86_64-linux-thread-multi|5.8.9|linux|2.6.18-4-xen-amd64|200902170910
3309921|pass|200902|imacat@mail.imacat.idv.tw|App-Maisha-Plugin-PingFM|0.01|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.24-etchnhalf.1-amd64|200902171704
3309891|pass|200902|imacat@mail.imacat.idv.tw|App-Maisha|0.06|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.24-etchnhalf.1-amd64|200902171659
3309833|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha|0.06|s390x-linux-thread-multi|5.10.0|linux|2.6.18-92.el5|200902170949
3309810|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha-Plugin-PingFM|0.01|s390x-linux-thread-multi|5.10.0|linux|2.6.16.60-0.31-default|200902170938
3309807|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha-Plugin-PingFM|0.01|s390x-linux|5.10.0|linux|2.6.16.60-0.31-default|200902170935
3309806|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha-Plugin-PingFM|0.01|s390x-linux-thread-multi|5.10.0|linux|2.6.18-92.el5|200902170934
3309803|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha|0.06|s390x-linux-thread-multi|5.10.0|linux|2.6.16.60-0.31-default|200902170934
3309802|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha|0.06|s390x-linux|5.10.0|linux|2.6.16.60-0.31-default|200902170933
3309783|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha|0.04|s390x-linux-thread-multi|5.10.0|linux|2.6.18-92.el5|200902170930
3309582|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha-Plugin-PingFM|0.01|s390x-linux|5.10.0|linux|2.6.18-92.el5|200902170858
3309571|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha|0.06|s390x-linux|5.10.0|linux|2.6.18-92.el5|200902170854
3309548|pass|200902|srezic@cpan.org|App-Maisha-Plugin-PingFM|0.01|amd64-freebsd|5.8.8|freebsd|7.0-release|200902170839
3309546|pass|200902|srezic@cpan.org|App-Maisha-Plugin-PingFM|0.01|amd64-freebsd|5.8.9|freebsd|7.0-release|200902170839
3308015|fail|200902|bingos@cpan.org|CPAN-Testers-Data-Uploads|0.04|i386-freebsd-thread-multi-64int|5.8.8|freebsd|6.4-release|200902162336
3308009|pass|200902|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i386-freebsd-thread-multi-64int|5.8.8|freebsd|6.4-release|200902162336
3308008|fail|200902|bingos@cpan.org|App-Maisha|0.04|i386-freebsd-thread-multi-64int|5.8.8|freebsd|6.4-release|200902162335
3308001|fail|200902|bingos@cpan.org|App-Maisha|0.03|i386-freebsd-thread-multi-64int|5.8.8|freebsd|6.4-release|200902162335
3307999|fail|200902|bingos@cpan.org|App-Maisha|0.02|i386-freebsd-thread-multi-64int|5.8.8|freebsd|6.4-release|200902162335
3307994|fail|200902|bingos@cpan.org|App-Maisha|0.01|i386-freebsd-thread-multi-64int|5.8.8|freebsd|6.4-release|200902162334
3307905|fail|200902|bingos@cpan.org|App-Maisha|0.05|darwin-thread-multi-64int-2level|5.8.9|darwin|8.11.0|200902162317
3307903|fail|200902|bingos@cpan.org|App-Maisha|0.05|darwin-thread-multi-64int-2level|5.8.8|darwin|8.11.0|200902162316
3307900|fail|200902|bingos@cpan.org|App-Maisha|0.05|darwin-thread-multi-64int-2level|5.8.6|darwin|8.11.0|200902162316
3307896|fail|200902|bingos@cpan.org|App-Maisha|0.05|darwin-thread-multi-64int-2level|5.10.0|darwin|8.11.0|200902162315
3307509|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.12|s390x-linux|5.8.8|linux|2.6.18-92.1.18.el5|200902162225
3307240|pass|200902|vpit@cpan.org|App-Maisha|0.04|x86_64-linux-thread-multi|5.10.0|linux|2.6.26.3-fuuka.profvince.com|200902162109
3306923|pass|200902|srezic@cpan.org|App-Maisha|0.06|amd64-freebsd|5.8.8|freebsd|7.0-release|200902161906
3306921|pass|200902|srezic@cpan.org|CPAN-Testers-Data-Generator|0.36|amd64-freebsd|5.8.8|freebsd|7.0-release|200902161906
3306845|pass|200902|srezic@cpan.org|CPAN-Testers-Data-Generator|0.36|amd64-freebsd|5.8.9|freebsd|7.0-release|200902161906
3306842|pass|200902|srezic@cpan.org|App-Maisha|0.06|amd64-freebsd|5.8.9|freebsd|7.0-release|200902161906
3306773|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.12|s390x-linux-thread-multi|5.8.8|linux|2.6.16.60-0.31-default|200902161847
3306447|cpan|200902|BARBIE|App-Maisha-Plugin-PingFM|0.01||0|||200902161716
3306379|pass|200902|imacat@mail.imacat.idv.tw|App-Maisha|0.04|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.24-etchnhalf.1-amd64|200902162355
3306087|cpan|200902|BARBIE|App-Maisha|0.06||0|||200902161530
3305952|cpan|200902|BARBIE|App-Maisha|0.05||0|||200902161422
3305780|fail|200902|bingos@cpan.org|CPAN-Testers-Data-Uploads|0.04|i386-freebsd-thread-multi-64int|5.10.0|freebsd|6.4-release|200902161238
3305775|pass|200902|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i386-freebsd-thread-multi-64int|5.10.0|freebsd|6.4-release|200902161237
3305773|fail|200902|bingos@cpan.org|App-Maisha|0.04|i386-freebsd-thread-multi-64int|5.10.0|freebsd|6.4-release|200902161236
3305768|fail|200902|bingos@cpan.org|App-Maisha|0.03|i386-freebsd-thread-multi-64int|5.10.0|freebsd|6.4-release|200902161235
3305764|fail|200902|bingos@cpan.org|App-Maisha|0.02|i386-freebsd-thread-multi-64int|5.10.0|freebsd|6.4-release|200902161234
3305760|fail|200902|bingos@cpan.org|App-Maisha|0.01|i386-freebsd-thread-multi-64int|5.10.0|freebsd|6.4-release|200902161234
3305751|fail|200902|bingos@cpan.org|CPAN-Testers-Data-Uploads|0.04|i386-freebsd-thread-multi-64int|5.8.9|freebsd|6.4-release|200902161231
3305745|pass|200902|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i386-freebsd-thread-multi-64int|5.8.9|freebsd|6.4-release|200902161229
3305743|fail|200902|bingos@cpan.org|App-Maisha|0.04|i386-freebsd-thread-multi-64int|5.8.9|freebsd|6.4-release|200902161228
3305735|fail|200902|bingos@cpan.org|App-Maisha|0.03|i386-freebsd-thread-multi-64int|5.8.9|freebsd|6.4-release|200902161228
3305732|fail|200902|bingos@cpan.org|App-Maisha|0.02|i386-freebsd-thread-multi-64int|5.8.9|freebsd|6.4-release|200902161227
3305730|fail|200902|bingos@cpan.org|App-Maisha|0.01|i386-freebsd-thread-multi-64int|5.8.9|freebsd|6.4-release|200902161226
3305692|cpan|200902|BARBIE|CPAN-WWW-Testers|0.49||0|||200902161317
3305663|cpan|200902|BARBIE|CPAN-Testers-Data-Generator|0.36||0|||200902161309
3305477|pass|200902|vpit@cpan.org|CPAN-WWW-Testers|0.48|i686-linux-thread-multi|5.10.0|linux|2.6.18.3-tmb-desktop-2mdvsmp|200902161212
3305185|fail|200902|bingos@cpan.org|CPAN-Testers-Data-Uploads|0.04|i686-linux-64int-ld|5.11.0 patch GitLive-blead-623-g4705144|linux|2.6.21.5-smp|200902161019
3305180|pass|200902|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i686-linux-64int-ld|5.11.0 patch GitLive-blead-623-g4705144|linux|2.6.21.5-smp|200902161018
3305179|pass|200902|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i686-linux-64int-ld|5.11.0 patch GitLive-blead-623-g4705144|linux|2.6.21.5-smp|200902161017
3305174|fail|200902|bingos@cpan.org|App-Maisha|0.04|i686-linux-64int-ld|5.11.0 patch GitLive-blead-623-g4705144|linux|2.6.21.5-smp|200902161016
3305173|fail|200902|bingos@cpan.org|App-Maisha|0.03|i686-linux-64int-ld|5.11.0 patch GitLive-blead-623-g4705144|linux|2.6.21.5-smp|200902161015
3305170|fail|200902|bingos@cpan.org|App-Maisha|0.02|i686-linux-64int-ld|5.11.0 patch GitLive-blead-623-g4705144|linux|2.6.21.5-smp|200902161015
3305167|fail|200902|bingos@cpan.org|App-Maisha|0.01|i686-linux-64int-ld|5.11.0 patch GitLive-blead-623-g4705144|linux|2.6.21.5-smp|200902161014
3304867|fail|200902|mw487.yahoo.com@gmail.com|CPAN-Testers-Data-Uploads|0.04|cygwin-thread-multi-64int|5.10.0 patch 34065|cygwin|1.5.25(0.15642)|200902160419
3304864|pass|200902|mw487.yahoo.com@gmail.com|CPAN-Testers-Common-Article|0.36|cygwin-thread-multi-64int|5.10.0 patch 34065|cygwin|1.5.25(0.15642)|200902160418
3304861|pass|200902|mw487.yahoo.com@gmail.com|CPAN-Testers-Common-DBUtils|0.03|cygwin-thread-multi-64int|5.10.0 patch 34065|cygwin|1.5.25(0.15642)|200902160418
3304856|pass|200902|mw487.yahoo.com@gmail.com|Mail-Outlook|0.15|cygwin-thread-multi-64int|5.8.8|cygwin|1.5.24(0.15642)|200902160418
3304413|fail|200902|bingos@cpan.org|CPAN-Testers-Data-Uploads|0.04|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.21.5-smp|200902160721
3304405|pass|200902|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.21.5-smp|200902160720
3304399|fail|200902|bingos@cpan.org|App-Maisha|0.04|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.21.5-smp|200902160718
3304394|fail|200902|bingos@cpan.org|App-Maisha|0.03|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.21.5-smp|200902160718
3304390|fail|200902|bingos@cpan.org|App-Maisha|0.02|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.21.5-smp|200902160717
3304389|fail|200902|bingos@cpan.org|App-Maisha|0.01|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.21.5-smp|200902160716
3303942|pass|200902|mw487.yahoo.com@gmail.com|App-Maisha|0.03|cygwin-thread-multi-64int|5.10.0 patch 34065|cygwin|1.5.25(0.15642)|200902160359
3303633|fail|200902|mw487.yahoo.com@gmail.com|CPAN-Testers-Data-Uploads|0.04|cygwin-thread-multi-64int|5.10.0|cygwin|1.5.25(0.15642)|200902160142
3303629|pass|200902|mw487.yahoo.com@gmail.com|App-Maisha|0.03|cygwin-thread-multi-64int|5.10.0 patch 34065|cygwin|1.5.25(0.15642)|200902160141
3303624|pass|200902|mw487.yahoo.com@gmail.com|App-Maisha|0.02|cygwin-thread-multi-64int|5.10.0 patch 34065|cygwin|1.5.25(0.15642)|200902160141
3303508|fail|200902|bingos@cpan.org|App-Maisha|0.04|darwin-thread-multi-64int-2level|5.8.9|darwin|8.11.0|200902160053
3303507|fail|200902|bingos@cpan.org|App-Maisha|0.04|darwin-thread-multi-64int-2level|5.8.8|darwin|8.11.0|200902160052
3303506|fail|200902|bingos@cpan.org|App-Maisha|0.04|darwin-thread-multi-64int-2level|5.8.6|darwin|8.11.0|200902160052
3303505|fail|200902|bingos@cpan.org|App-Maisha|0.04|darwin-thread-multi-64int-2level|5.10.0|darwin|8.11.0|200902160051
3302990|pass|200902|srezic@cpan.org|CPAN-Testers-Data-Uploads|0.06|amd64-freebsd|5.8.9|freebsd|7.0-release|200902152236
3302980|pass|200902|srezic@cpan.org|CPAN-Testers-Data-Uploads|0.06|amd64-freebsd|5.8.8|freebsd|7.0-release|200902152236
3302808|pass|200902|srezic@cpan.org|App-Maisha|0.04|amd64-freebsd|5.8.9|freebsd|7.0-release|200902152236
3302790|pass|200902|srezic@cpan.org|App-Maisha|0.04|amd64-freebsd|5.8.8|freebsd|7.0-release|200902152236
3302643|pass|200902|srezic@cpan.org|CPAN-Testers-Data-Uploads|0.06|amd64-freebsd|5.10.0|freebsd|7.0-release|200902152207
3302624|pass|200902|srezic@cpan.org|CPAN-Testers-Common-Article|0.36|amd64-freebsd|5.10.0|freebsd|7.0-release|200902152207
3302256|pass|200902|sanko@cpan.org ("Sanko Robinson")|Test-YAML-Meta|0.11|MSWin32-x86-multi-thread|5.11.0 patch blead 2009-02-05.22:06:19 c8f794576f0d940fc66e0fc10236a1b54a7e40a3 GitLive-blead-510-gc8f7945|MSWin32|5.1|200902141340
3302160|fail|200902|bingos@cpan.org|CPAN-Testers-Data-Uploads|0.04|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.21.5-smp|200902151807
3302154|pass|200902|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.21.5-smp|200902151805
3302152|fail|200902|bingos@cpan.org|App-Maisha|0.03|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.21.5-smp|200902151805
3302150|fail|200902|bingos@cpan.org|App-Maisha|0.02|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.21.5-smp|200902151804
3302148|fail|200902|bingos@cpan.org|App-Maisha|0.01|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.21.5-smp|200902151804
3302125|pass|200902|mithaldu@yahoo.de ("Christian Walde")|CPAN-Testers-Common-DBUtils|0.03|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.00|200902142242
3301739|cpan|200902|BARBIE|App-Maisha|0.04||0|||200902151742
3301669|cpan|200902|BARBIE|CPAN-Testers-Data-Uploads|0.06||0|||200902151731
3301290|fail|200902|david@cantrell.org.uk|App-Maisha|0.03|alpha-netbsd|5.10.0|netbsd|4.0.1|200902151441
3301096|fail|200902|david@cantrell.org.uk|App-Maisha|0.02|alpha-netbsd|5.10.0|netbsd|4.0.1|200902151339
3301095|fail|200902|david@cantrell.org.uk|App-Maisha|0.03|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200902150739
3300979|fail|200902|david@cantrell.org.uk|App-Maisha|0.02|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200902150709
3300784|fail|200902|david@cantrell.org.uk|App-Maisha|0.03|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200902151203
3300783|fail|200902|david@cantrell.org.uk|App-Maisha|0.03|x86_64-linux-thread-multi|5.8.9|linux|2.6.18-4-xen-amd64|200902151204
3300782|fail|200902|david@cantrell.org.uk|App-Maisha|0.03|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200902151204
3300781|fail|200902|david@cantrell.org.uk|App-Maisha|0.03|x86_64-linux-thread-multi|5.10.0|linux|2.6.18-4-xen-amd64|200902151204
3300763|fail|200902|david@cantrell.org.uk|App-Maisha|0.02|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200902151159
3300762|fail|200902|david@cantrell.org.uk|App-Maisha|0.02|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200902151159
3300761|fail|200902|david@cantrell.org.uk|App-Maisha|0.02|x86_64-linux-thread-multi|5.10.0|linux|2.6.18-4-xen-amd64|200902151159
3300760|fail|200902|david@cantrell.org.uk|App-Maisha|0.02|x86_64-linux-thread-multi|5.8.9|linux|2.6.18-4-xen-amd64|200902151159
3300758|fail|200902|bingos@cpan.org|CPAN-Testers-Data-Uploads|0.04|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.21.5-smp|200902151157
3300745|pass|200902|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.21.5-smp|200902151155
3300743|fail|200902|bingos@cpan.org|App-Maisha|0.03|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.21.5-smp|200902151153
3300741|fail|200902|bingos@cpan.org|App-Maisha|0.02|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.21.5-smp|200902151153
3300736|fail|200902|bingos@cpan.org|App-Maisha|0.01|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.21.5-smp|200902151152
3300667|fail|200902|bingos@cpan.org|CPAN-Testers-Data-Uploads|0.04|i386-dragonfly-64int|5.8.8|dragonfly|2.0.0-release|200902151140
3300662|pass|200902|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i386-dragonfly-64int|5.8.8|dragonfly|2.0.0-release|200902151138
3300660|fail|200902|bingos@cpan.org|App-Maisha|0.03|i386-dragonfly-64int|5.8.8|dragonfly|2.0.0-release|200902151138
3300659|fail|200902|bingos@cpan.org|App-Maisha|0.02|i386-dragonfly-64int|5.8.8|dragonfly|2.0.0-release|200902151137
3300657|fail|200902|bingos@cpan.org|App-Maisha|0.01|i386-dragonfly-64int|5.8.8|dragonfly|2.0.0-release|200902151136
3300567|pass|200902|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i686-linux-thread-multi-64int-ld|5.6.2|linux|2.6.21.5-smp|200902151058
3300457|pass|200902|stsc@refcnt.org ("Steven Schubiger")|App-Maisha|0.03|i686-linux|5.10.0|linux|2.6.18-14-ovz-686|200902151117
3300291|pass|200902|vpit@cpan.org|App-Maisha|0.03|x86_64-linux-thread-multi|5.10.0|linux|2.6.26.3-fuuka.profvince.com|200902151026
3300290|pass|200902|vpit@cpan.org|App-Maisha|0.02|x86_64-linux-thread-multi|5.10.0|linux|2.6.26.3-fuuka.profvince.com|200902151026
3300269|cpan|200902|BARBIE|CPAN-Testers-Data-Uploads|0.05||0|||200902150959
3299845|fail|200902|bingos@cpan.org|App-Maisha|0.03|darwin-thread-multi-64int-2level|5.8.9|darwin|8.11.0|200902150258
3299843|fail|200902|bingos@cpan.org|App-Maisha|0.03|darwin-thread-multi-64int-2level|5.8.8|darwin|8.11.0|200902150257
3299842|fail|200902|bingos@cpan.org|App-Maisha|0.03|darwin-thread-multi-64int-2level|5.8.6|darwin|8.11.0|200902150257
3299840|fail|200902|bingos@cpan.org|App-Maisha|0.03|darwin-thread-multi-64int-2level|5.10.0|darwin|8.11.0|200902150256
3299614|pass|200902|dagolden@cpan.org (DAGOLDEN)|Mail-Outlook|0.15|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.1|200902150125
3298972|fail|200902|mw487.yahoo.com@gmail.com|CPAN-Testers-Data-Uploads|0.04|cygwin-thread-multi-64int|5.8.8|cygwin|1.5.24(0.15642)|200902141742
3298962|pass|200902|mw487.yahoo.com@gmail.com|CPAN-Testers-Common-Article|0.36|cygwin-thread-multi-64int|5.8.8|cygwin|1.5.24(0.15642)|200902141740
3298952|fail|200902|bingos@cpan.org|CPAN-Testers-Data-Uploads|0.04|i386-freebsd-thread-multi-64int|5.8.8|freebsd|6.2-release|200902142236
3298948|pass|200902|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i386-freebsd-thread-multi-64int|5.8.8|freebsd|6.2-release|200902142235
3298947|fail|200902|bingos@cpan.org|App-Maisha|0.01|i386-freebsd-thread-multi-64int|5.8.8|freebsd|6.2-release|200902142234
3298556|pass|200902|mw487.yahoo.com@gmail.com|Mail-Outlook|0.15|cygwin-thread-multi-64int|5.10.0 patch 34065|cygwin|1.5.25(0.15642)|200902141633
3298554|pass|200902|mw487.yahoo.com@gmail.com|CPAN-Testers-Common-DBUtils|0.03|cygwin-thread-multi-64int|5.10.0 patch 34065|cygwin|1.5.25(0.15642)|200902141633
3298529|pass|200902|mw487.yahoo.com@gmail.com|CPAN-Testers-Common-Article|0.36|cygwin-thread-multi-64int|5.10.0 patch 34065|cygwin|1.5.25(0.15642)|200902141630
3298419|fail|200902|mw487.yahoo.com@gmail.com|App-Maisha|0.01|cygwin-thread-multi-64int|5.8.8|cygwin|1.5.24(0.15642)|200902141600
3298346|fail|200902|bingos@cpan.org|App-Maisha|0.02|darwin-thread-multi-64int-2level|5.8.9|darwin|8.11.0|200902142025
3298343|fail|200902|bingos@cpan.org|App-Maisha|0.02|darwin-thread-multi-64int-2level|5.8.8|darwin|8.11.0|200902142024
3298342|fail|200902|bingos@cpan.org|App-Maisha|0.02|darwin-thread-multi-64int-2level|5.8.6|darwin|8.11.0|200902142024
3298337|fail|200902|bingos@cpan.org|App-Maisha|0.02|darwin-thread-multi-64int-2level|5.10.0|darwin|8.11.0|200902142023
3298178|fail|200902|stsc@refcnt.org ("Steven Schubiger")|App-Maisha|0.02|i686-linux|5.10.0|linux|2.6.18-14-ovz-686|200902142040
3297991|cpan|200902|BARBIE|App-Maisha|0.03||0|||200902141945
3297758|fail|200902|imacat@mail.imacat.idv.tw|CPAN-Testers-Data-Uploads|0.04|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.24-etchnhalf.1-amd64|200902150145
3297744|fail|200902|imacat@mail.imacat.idv.tw|App-Maisha|0.01|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.24-etchnhalf.1-amd64|200902150142
3297386|pass|200902|srezic@cpan.org|App-Maisha|0.02|amd64-freebsd|5.8.9|freebsd|7.0-release|200902141733
3297385|pass|200902|srezic@cpan.org|App-Maisha|0.02|amd64-freebsd|5.8.8|freebsd|7.0-release|200902141733
3296725|fail|200902|dagolden@cpan.org (DAGOLDEN)|CPAN-Testers-Data-Uploads|0.04|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.1|200902140914
3296710|fail|200902|david@cantrell.org.uk|CPAN-Testers-Data-Uploads|0.04|alpha-netbsd|5.10.0|netbsd|4.0.1|200902141413
3296703|pass|200902|dagolden@cpan.org (DAGOLDEN)|CPAN-Testers-Common-Article|0.36|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.1|200902140912
3296658|fail|200902|bingos@cpan.org|CPAN-Testers-Data-Uploads|0.04|i386-dragonfly-64int|5.8.9|dragonfly|2.0.0-release|200902141402
3296652|pass|200902|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-dragonfly-64int|5.8.9|dragonfly|2.0.0-release|200902141401
3296529|pass|200902|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i386-dragonfly-64int|5.8.9|dragonfly|2.0.0-release|200902141346
3296517|fail|200902|bingos@cpan.org|App-Maisha|0.01|i386-dragonfly-64int|5.8.9|dragonfly|2.0.0-release|200902141345
3296510|fail|200902|david@cantrell.org.uk|CPAN-Testers-Data-Uploads|0.04|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200902140744
3296425|fail|200902|david@cantrell.org.uk|CPAN-Testers-Data-Uploads|0.04|IP35-irix-64int|5.8.8|irix|6.5|200902141429
3296415|fail|200902|david@cantrell.org.uk|App-Maisha|0.01|alpha-netbsd|5.10.0|netbsd|4.0.1|200902141327
3296362|fail|200902|david@cantrell.org.uk|CPAN-Testers-Data-Uploads|0.04|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200902141321
3296359|fail|200902|david@cantrell.org.uk|App-Maisha|0.01|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200902140721
3296357|fail|200902|david@cantrell.org.uk|CPAN-Testers-Data-Uploads|0.04|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200902141321
3296356|fail|200902|david@cantrell.org.uk|CPAN-Testers-Data-Uploads|0.04|x86_64-linux-thread-multi|5.10.0|linux|2.6.18-4-xen-amd64|200902141321
3296355|fail|200902|david@cantrell.org.uk|CPAN-Testers-Data-Uploads|0.04|x86_64-linux-thread-multi|5.8.9|linux|2.6.18-4-xen-amd64|200902141321
3296284|fail|200902|bingos@cpan.org|CPAN-Testers-Data-Uploads|0.04|i386-dragonfly-64int|5.10.0|dragonfly|2.0.0-release|200902141310
3296273|pass|200902|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i386-dragonfly-64int|5.10.0|dragonfly|2.0.0-release|200902141308
3296260|fail|200902|vpit@cpan.org|CPAN-Testers-Data-Uploads|0.04|x86_64-linux-thread-multi|5.10.0|linux|2.6.26.3-fuuka.profvince.com|200902141409
3296257|pass|200902|vpit@cpan.org|CPAN-Testers-Common-Article|0.36|x86_64-linux-thread-multi|5.10.0|linux|2.6.26.3-fuuka.profvince.com|200902141409
3296255|pass|200902|vpit@cpan.org|App-Maisha|0.01|x86_64-linux-thread-multi|5.10.0|linux|2.6.26.3-fuuka.profvince.com|200902141409
3296123|cpan|200902|BARBIE|App-Maisha|0.02||0|||200902141315
3296122|fail|200902|david@cantrell.org.uk|App-Maisha|0.01|x86_64-linux-thread-multi|5.8.9|linux|2.6.18-4-xen-amd64|200902141215
3296121|fail|200902|david@cantrell.org.uk|App-Maisha|0.01|x86_64-linux-thread-multi|5.10.0|linux|2.6.18-4-xen-amd64|200902141215
3296118|fail|200902|david@cantrell.org.uk|App-Maisha|0.01|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200902141214
3296112|fail|200902|david@cantrell.org.uk|App-Maisha|0.01|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200902141213
3295977|fail|200902|bingos@cpan.org|CPAN-Testers-Data-Uploads|0.04|i386-freebsd-thread-multi-64int|5.8.9|freebsd|6.2-release|200902141144
3295963|pass|200902|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i386-freebsd-thread-multi-64int|5.8.9|freebsd|6.2-release|200902141142
3295959|fail|200902|bingos@cpan.org|App-Maisha|0.01|i386-freebsd-thread-multi-64int|5.8.9|freebsd|6.2-release|200902141141
3295906|fail|200902|bingos@cpan.org|CPAN-Testers-Data-Uploads|0.04|i386-freebsd-thread-multi-64int|5.10.0|freebsd|6.2-release|200902141130
3295902|pass|200902|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i386-freebsd-thread-multi-64int|5.10.0|freebsd|6.2-release|200902141127
3295900|fail|200902|bingos@cpan.org|App-Maisha|0.01|i386-freebsd-thread-multi-64int|5.10.0|freebsd|6.2-release|200902141126
3295756|fail|200902|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Uploads|0.04|s390x-linux|5.8.8|linux|2.6.18-92.1.18.el5|200902141148
3295750|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|Mail-Outlook|0.15|s390x-linux|5.10.0|linux|2.6.18-92.el5|200902141145
3295664|fail|200902|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Uploads|0.04|s390x-linux-thread-multi|5.10.0|linux|2.6.18-92.el5|200902141120
3295631|fail|200902|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha|0.01|s390x-linux|5.8.8|linux|2.6.18-92.1.18.el5|200902141113
3295570|fail|200902|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Uploads|0.04|s390x-linux|5.10.0|linux|2.6.18-92.el5|200902141102
3295485|fail|200902|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha|0.01|s390x-linux-thread-multi|5.10.0|linux|2.6.18-92.el5|200902141044
3295406|fail|200902|cpan@sourcentral.org ("Oliver Paukstadt")|App-Maisha|0.01|s390x-linux|5.10.0|linux|2.6.18-92.el5|200902141018
3293390|pass|200902|DCOLLINS@cpan.org|Test-CPAN-Meta|0.12|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902140345
3292493|fail|200902|bingos@cpan.org|App-Maisha|0.01|darwin-thread-multi-64int-2level|5.8.9|darwin|8.11.0|200902140136
3292479|fail|200902|bingos@cpan.org|App-Maisha|0.01|darwin-thread-multi-64int-2level|5.8.8|darwin|8.11.0|200902140135
3292467|fail|200902|bingos@cpan.org|App-Maisha|0.01|darwin-thread-multi-64int-2level|5.8.6|darwin|8.11.0|200902140134
3292459|fail|200902|bingos@cpan.org|App-Maisha|0.01|darwin-thread-multi-64int-2level|5.10.0|darwin|8.11.0|200902140133
3290605|fail|200902|stsc@refcnt.org ("Steven Schubiger")|CPAN-Testers-Data-Uploads|0.04|i686-linux|5.10.0|linux|2.6.18-14-ovz-686|200902132305
3290439|fail|200902|stsc@refcnt.org ("Steven Schubiger")|App-Maisha|0.01|i686-linux|5.10.0|linux|2.6.18-14-ovz-686|200902132250
3290158|pass|200902|DCOLLINS@cpan.org|Regexp-Log-Common|0.05|i686-linux-thread-multi|5.11.0 patch GitLive-blead-163-g28b1dae|linux|2.6.24-19-generic|200902131621
3289641|fail|200902|bingos@cpan.org|CPAN-Testers-Data-Uploads|0.04|darwin-thread-multi-64int-2level|5.8.9|darwin|8.11.0|200902132039
3289635|fail|200902|bingos@cpan.org|CPAN-Testers-Data-Uploads|0.04|darwin-thread-multi-64int-2level|5.8.8|darwin|8.11.0|200902132039
3289624|fail|200902|bingos@cpan.org|CPAN-Testers-Data-Uploads|0.04|darwin-thread-multi-64int-2level|5.8.6|darwin|8.11.0|200902132038
3289614|fail|200902|bingos@cpan.org|CPAN-Testers-Data-Uploads|0.04|darwin-thread-multi-64int-2level|5.10.0|darwin|8.11.0|200902132037
3289453|pass|200902|DCOLLINS@cpan.org|Regexp-Log-Common|0.05|i686-linux-thread-multi|5.8.9|linux|2.6.24-19-generic|200902131328
3289324|pass|200902|srezic@cpan.org|App-Maisha|0.01|amd64-freebsd|5.8.8|freebsd|7.0-release|200902132116
3289262|pass|200902|srezic@cpan.org|App-Maisha|0.01|amd64-freebsd|5.8.9|freebsd|7.0-release|200902132109
3289039|pass|200902|DCOLLINS@cpan.org|Regexp-Log-Common|0.05|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902131446
3287570|pass|200902|DCOLLINS@cpan.org|Regexp-Log-Common|0.05|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902131228
3286379|pass|200902|srezic@cpan.org|CPAN-Testers-Data-Uploads|0.04|amd64-freebsd|5.8.9|freebsd|7.0-release|200902131633
3286284|cpan|200902|BARBIE|App-Maisha|0.01||0|||200902131648
3286173|pass|200902|srezic@cpan.org|CPAN-Testers-Data-Uploads|0.04|amd64-freebsd|5.8.8|freebsd|7.0-release|200902131633
3285769|pass|200902|srezic@cpan.org|CPAN-Testers-Common-Article|0.36|amd64-freebsd|5.8.9|freebsd|7.0-release|200902131540
3285589|pass|200902|srezic@cpan.org|CPAN-Testers-Common-Article|0.36|amd64-freebsd|5.8.8|freebsd|7.0-release|200902131540
3283955|pass|200902|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i686-linux-thread-multi-64int-ld|5.11.0 patch GitLive-blead-599-gd9acc78|linux|2.6.16.38|200902131250
3283539|cpan|200902|BARBIE|CPAN-Testers-Data-Uploads|0.04||0|||200902131317
3283159|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-Article|0.36|s390x-linux-thread-multi|5.8.8|linux|2.6.16.60-0.31-default|200902131253
3283100|pass|200902|imacat@mail.imacat.idv.tw|CPAN-Testers-Common-Article|0.36|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.24-etchnhalf.1-amd64|200902131950
3282781|pass|200902|david@cantrell.org.uk|CPAN-Testers-Common-Article|0.36|alpha-netbsd|5.10.0|netbsd|4.0.1|200902131131
3282755|pass|200902|david@cantrell.org.uk|CPAN-Testers-Common-Article|0.36|x86_64-linux-thread-multi|5.6.2|linux|2.6.18-4-xen-amd64|200902131129
3282748|pass|200902|david@cantrell.org.uk|CPAN-Testers-Common-Article|0.36|x86_64-linux-thread-multi|5.8.9|linux|2.6.18-4-xen-amd64|200902131129
3282527|pass|200902|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|alpha-linux-thread-multi|5.10.0|linux|2.6.18-5-alpha-generic|200902131110
3282505|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|Mail-Outlook|0.15|s390x-linux|5.10.0|linux|2.6.16.60-0.31-default|200902131208
3282482|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-Article|0.36|s390x-linux-thread-multi|5.8.8|linux|2.6.18-92.1.18.el5|200902131206
3282469|pass|200902|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|alpha-linux-thread-multi|5.8.9|linux|2.6.18-5-alpha-generic|200902131106
3282266|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-Article|0.36|s390x-linux|5.8.8|linux|2.6.18-92.1.18.el5|200902131150
3282178|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-Article|0.36|s390x-linux|5.8.8|linux|2.6.16.60-0.31-default|200902131142
3282046|pass|200902|david@cantrell.org.uk|CPAN-Testers-Common-Article|0.36|IP35-irix-64int|5.8.8|irix|6.5|200902131134
3281925|pass|200902|david@cantrell.org.uk|CPAN-Testers-Common-Article|0.36|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200902130428
3281901|pass|200902|david@cantrell.org.uk|CPAN-Testers-Common-Article|0.36|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200902131026
3281895|pass|200902|david@cantrell.org.uk|CPAN-Testers-Common-Article|0.36|x86_64-linux-thread-multi|5.10.0|linux|2.6.18-4-xen-amd64|200902131026
3281852|pass|200902|stro@cpan.org|CPAN-Testers-Common-Article|0.36|MSWin32-x86-multi-thread|5.8.8|MSWin32|5.00|200902131223
3281582|pass|200902|DCOLLINS@cpan.org|Parse-CPAN-Distributions|0.05|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902130310
3281543|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-Article|0.36|s390x-linux-thread-multi|5.10.0|linux|2.6.18-92.el5|200902131100
3281321|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-Article|0.36|s390x-linux-thread-multi|5.6.2|linux|2.6.16.60-0.31-default|200902131044
3281294|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-Article|0.36|s390x-linux|5.10.0|linux|2.6.18-92.el5|200902131042
3281188|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-Article|0.36|s390x-linux|5.10.0|linux|2.6.16.60-0.31-default|200902131036
3281118|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-Article|0.36|s390x-linux-thread-multi|5.10.0|linux|2.6.16.60-0.31-default|200902131031
3281035|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-Article|0.36|s390x-linux-thread-multi|5.6.2|linux|2.6.18-92.1.18.el5|200902131024
3281012|pass|200902|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.16.38|200902130921
3281002|pass|200902|david@cantrell.org.uk|CPAN-Testers-Common-Article|0.36|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200902130918
3280985|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-Article|0.36|s390x-linux|5.6.2|linux|2.6.16.60-0.31-default|200902131013
3280838|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-Article|0.36|s390x-linux|5.6.2|linux|2.6.18-92.1.18.el5|200902130956
3280521|pass|200902|stro@cpan.org|CPAN-Testers-Common-Article|0.36|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.00|200902131025
3280382|pass|200902|stsc@refcnt.org ("Steven Schubiger")|CPAN-Testers-Common-Article|0.36|i686-linux|5.10.0|linux|2.6.18-14-ovz-686|200902130813
3280280|pass|200902|DCOLLINS@cpan.org|Parse-CPAN-Distributions|0.05|i686-linux-thread-multi|5.11.0 patch GitLive-blead-163-g28b1dae|linux|2.6.24-19-generic|200902130252
3280097|pass|200902|DCOLLINS@cpan.org|Parse-CPAN-Distributions|0.05|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902130240
3280069|pass|200902|DCOLLINS@cpan.org|Parse-CPAN-Distributions|0.05|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902130237
3280043|pass|200902|DCOLLINS@cpan.org|Parse-CPAN-Distributions|0.05|i686-linux-thread-multi|5.8.9|linux|2.6.24-19-generic|200902130232
3277837|pass|200902|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|darwin-thread-multi-64int-2level|5.8.9|darwin|8.11.0|200902122357
3277832|pass|200902|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|darwin-thread-multi-64int-2level|5.8.8|darwin|8.11.0|200902122357
3277831|pass|200902|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|darwin-thread-multi-64int-2level|5.8.6|darwin|8.11.0|200902122357
3277829|pass|200902|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|darwin-thread-multi-64int|5.6.2|darwin|8.11.0|200902122356
3277824|pass|200902|bingos@cpan.org|CPAN-Testers-Common-Article|0.36|darwin-thread-multi-64int-2level|5.10.0|darwin|8.11.0|200902122356
3277296|pass|200902|bingos@cpan.org|Mail-Outlook|0.15|i386-netbsd-thread-multi-64int|5.8.9|netbsd|3.1|200902122206
3277141|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|Mail-Outlook|0.15|s390x-linux-thread-multi|5.10.0|linux|2.6.18-92.el5|200902122229
3276437|pass|200902|stsc@refcnt.org ("Steven Schubiger")|Parse-CPAN-Distributions|0.05|i686-linux|5.10.0|linux|2.6.18-14-ovz-686|200902121953
3276312|pass|200902|DCOLLINS@cpan.org|Data-Phrasebook|0.29|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902121052
3276084|pass|200902|DCOLLINS@cpan.org|Test-YAML-Meta|0.11|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902120918
3276046|pass|200902|stsc@refcnt.org ("Steven Schubiger")|WWW-UsePerl-Journal-Thread|0.12|i686-linux|5.10.0|linux|2.6.18-14-ovz-686|200902121915
3276045|pass|200902|stsc@refcnt.org ("Steven Schubiger")|WWW-UsePerl-Journal|0.22|i686-linux|5.10.0|linux|2.6.18-14-ovz-686|200902121915
3275224|pass|200902|DCOLLINS@cpan.org|Test-YAML-Meta|0.11|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902120920
3275100|pass|200902|DCOLLINS@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902121243
3275099|pass|200902|DCOLLINS@cpan.org|Data-Phrasebook|0.29|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902121243
3274975|pass|200902|DCOLLINS@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902121235
3274972|pass|200902|DCOLLINS@cpan.org|Data-Phrasebook|0.29|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902121235
3274952|pass|200902|DCOLLINS@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi|5.11.0 patch GitLive-blead-163-g28b1dae|linux|2.6.24-19-generic|200902121233
3274951|pass|200902|DCOLLINS@cpan.org|Data-Phrasebook|0.29|i686-linux-thread-multi|5.11.0 patch GitLive-blead-163-g28b1dae|linux|2.6.24-19-generic|200902121233
3274779|pass|200902|DCOLLINS@cpan.org|Mail-File|0.08|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902121722
3274039|pass|200902|DCOLLINS@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902121052
3272314|cpan|200902|BARBIE|CPAN-Testers-Common-Article|0.36||0|||200902121435
3270654|pass|200902|DCOLLINS@cpan.org|Mail-File|0.08|i686-linux-thread-multi|5.8.9|linux|2.6.24-19-generic|200902120240
3269731|pass|200902|stsc@refcnt.org ("Steven Schubiger")|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i686-linux|5.10.0|linux|2.6.18-14-ovz-686|200902121054
3269721|fail|200902|stsc@refcnt.org ("Steven Schubiger")|WWW-Scraper-ISBN-Amazon_Driver|0.14|i686-linux|5.10.0|linux|2.6.18-14-ovz-686|200902121053
3269612|pass|200902|DCOLLINS@cpan.org|Mail-File|0.08|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902120359
3269140|pass|200902|DCOLLINS@cpan.org|Mail-File|0.08|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902120234
3269115|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|Mail-Outlook|0.15|s390x-linux-thread-multi|5.6.2|linux|2.6.16.60-0.31-default|200902121115
3268811|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|Mail-Outlook|0.15|s390x-linux-thread-multi|5.6.2|linux|2.6.18-92.1.18.el5|200902121054
3268618|pass|200902|DCOLLINS@cpan.org|Mail-File|0.08|i686-linux-thread-multi|5.11.0 patch GitLive-blead-163-g28b1dae|linux|2.6.24-19-generic|200902120359
3268585|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|Mail-Outlook|0.15|s390x-linux|5.6.2|linux|2.6.16.60-0.31-default|200902121037
3268362|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|Mail-Outlook|0.15|s390x-linux|5.6.2|linux|2.6.18-92.1.18.el5|200902121023
3260158|pass|200902|srezic@cpan.org|Mail-Outlook|0.15|amd64-freebsd|5.8.8|freebsd|7.0-release|200902112134
3259888|pass|200902|srezic@cpan.org|Mail-Outlook|0.15|amd64-freebsd|5.8.9|freebsd|7.0-release|200902112134
3259349|pass|200902|stsc@refcnt.org ("Steven Schubiger")|Test-YAML-Meta|0.11|i686-linux|5.10.0|linux|2.6.18-14-ovz-686|200902112003
3258136|pass|200902|david@cantrell.org.uk|Mail-Outlook|0.15|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200902111127
3258055|pass|200902|david@cantrell.org.uk|Mail-Outlook|0.15|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200902111702
3258054|pass|200902|david@cantrell.org.uk|Mail-Outlook|0.15|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200902111702
3258047|pass|200902|david@cantrell.org.uk|Mail-Outlook|0.15|alpha-netbsd|5.10.0|netbsd|4.0.1|200902111700
3258042|pass|200902|david@cantrell.org.uk|Mail-Outlook|0.15|IP35-irix-64int|5.8.8|irix|6.5|200902111759
3258041|pass|200902|david@cantrell.org.uk|Mail-Outlook|0.15|x86_64-linux-thread-multi|5.10.0|linux|2.6.18-4-xen-amd64|200902111657
3258040|pass|200902|david@cantrell.org.uk|Mail-Outlook|0.15|x86_64-linux-thread-multi|5.8.9|linux|2.6.18-4-xen-amd64|200902111657
3258039|pass|200902|david@cantrell.org.uk|Mail-Outlook|0.15|x86_64-linux-thread-multi|5.6.2|linux|2.6.18-4-xen-amd64|200902111657
3257088|pass|200902|stsc@refcnt.org ("Steven Schubiger")|CPAN-Testers-WWW-Statistics|0.55|i686-linux|5.10.0|linux|2.6.18-14-ovz-686|200902111411
3256717|pass|200902|stsc@refcnt.org ("Steven Schubiger")|Data-Phrasebook-Loader-YAML|0.09|i686-linux|5.10.0|linux|2.6.18-14-ovz-686|200902111318
3256716|pass|200902|stsc@refcnt.org ("Steven Schubiger")|Data-Phrasebook|0.29|i686-linux|5.10.0|linux|2.6.18-14-ovz-686|200902111318
3255754|pass|200902|DCOLLINS@cpan.org|Test-YAML-Meta|0.11|i686-linux-thread-multi|5.8.9|linux|2.6.24-19-generic|200902110640
3255422|pass|200902|stsc@refcnt.org ("Steven Schubiger")|Mail-Outlook|0.15|i686-linux|5.10.0|linux|2.6.18-14-ovz-686|200902111052
3254871|pass|200902|stsc@refcnt.org ("Steven Schubiger")|CPAN-Testers-Common-DBUtils|0.03|i686-linux|5.10.0|linux|2.6.18-14-ovz-686|200902110929
3254605|pass|200902|JOST@cpan.org ("Josts Smokehouse")|Mail-Outlook|0.15|i86pc-solaris-64int|5.10.0|solaris|2.11|200902110956
3254512|pass|200902|imacat@mail.imacat.idv.tw|Mail-Outlook|0.15|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.24-etchnhalf.1-amd64|200902111637
3254339|pass|200902|taro-nishino@wine.ocn.ne.jp ("Taro Nishino")|Mail-Outlook|0.15|MSWin32-x86-multi-thread|5.8.8|MSWin32|5.0|200902111527
3253720|pass|200902|dagolden@cpan.org (DAGOLDEN)|Regexp-Log-Common|0.05|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.1|200902110157
3252997|cpan|200902|BARBIE|Mail-Outlook|0.15||0|||200902110057
3250655|pass|200902|davidp@preshweb.co.uk ("David Precious")|Test-YAML-Meta|0.11|i686-linux|5.10.0|linux|2.6.24.2|200902092159
3250492|pass|200902|bingos@cpan.org|Test-YAML-Meta|0.11|i86pc-solaris-thread-multi-64int|5.10.0|solaris|2.10|200902101533
3250108|pass|200902|artur+cpan@niif.spb.su (ARTO)|Test-YAML-Meta|0.11|i386-linux-thread-multi|5.10.0|linux|2.6.18-92.1.18.el5|200902091110
3248609|pass|200902|bingos@cpan.org|Test-YAML-Meta|0.11|i386-netbsd-thread-multi-64int|5.10.0|netbsd|3.1|200902100647
3247946|pass|200902|DCOLLINS@cpan.org|Test-YAML-Meta|0.11|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902100314
3247899|pass|200902|DCOLLINS@cpan.org|Test-YAML-Meta|0.11|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902100308
3247452|pass|200902|DCOLLINS@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.8.9|linux|2.6.24-19-generic|200902100148
3247433|pass|200902|DCOLLINS@cpan.org|Test-YAML-Meta|0.11|i686-linux-thread-multi|5.8.9|linux|2.6.24-19-generic|200902100146
3247243|pass|200902|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-freebsd-thread-multi-64int|5.11.0 patch GitLive-blead-571-gabd7186|freebsd|7.0-release|200902100124
3246971|pass|200902|DCOLLINS@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.11.0 patch GitLive-blead-163-g28b1dae|linux|2.6.24-19-generic|200902100021
3246651|pass|200902|DCOLLINS@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902091855
3246614|pass|200902|DCOLLINS@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902091852
3246495|pass|200902|DCOLLINS@cpan.org|Test-YAML-Meta|0.11|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902091845
3245565|pass|200902|DCOLLINS@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.8.9|linux|2.6.24-19-generic|200902091650
3245558|pass|200902|DCOLLINS@cpan.org|Test-YAML-Meta|0.11|i686-linux-thread-multi|5.8.9|linux|2.6.24-19-generic|200902091648
3245514|pass|200902|DCOLLINS@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902091644
3241468|pass|200902|bingos@cpan.org|Test-YAML-Meta|0.11|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.0-release|200902091457
3236614|pass|200902|cpan.dcollins.s2@gmail.com|Games-Trackword|1.06|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902090259
3236575|pass|200902|cpan.dcollins.s1@gmail.com|Games-Trackword|1.06|i686-linux-thread-multi|5.8.9|linux|2.6.24-19-generic|200902090253
3235170|pass|200902|bingos@cpan.org|Test-YAML-Meta|0.11|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.0-release|200902082255
3234983|pass|200902|cpan.dcollins.s3@gmail.com|Data-Phrasebook-Loader-Ini|0.10|i686-linux-thread-multi|5.8.9|linux|2.6.24-19-generic|200902080333
3234952|pass|200902|cpan.dcollins.s3@gmail.com|Data-Phrasebook|0.29|i686-linux-thread-multi|5.8.9|linux|2.6.24-19-generic|200902080332
3234879|pass|200902|cpan.dcollins.s3@gmail.com|Data-Phrasebook-Loader-XML|0.12|i686-linux-thread-multi|5.8.9|linux|2.6.24-19-generic|200902080334
3234534|pass|200902|cpan.dcollins.s3@gmail.com|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi|5.8.9|linux|2.6.24-19-generic|200902080335
3234531|pass|200902|cpan.dcollins.s3@gmail.com|Data-Phrasebook-Loader-DBI|0.11|i686-linux-thread-multi|5.8.9|linux|2.6.24-19-generic|200902080333
3234474|pass|200902|myxomatosis@snoogans.org|Test-YAML-Meta|0.11|x86_64-linux-gnu-thread-multi|5.8.8|linux|2.6.24-16-server|200902080810
3234401|pass|200902|cpan.dcollins.s3@gmail.com|Data-FormValidator-Constraints-Words|0.03|i686-linux-thread-multi|5.8.9|linux|2.6.24-19-generic|200902080233
3229957|pass|200902|bingos@cpan.org|Test-YAML-Meta|0.11|OpenBSD.i386-openbsd-thread-multi-64int|5.8.8|openbsd|4.3|200902081016
3229283|pass|200902|cpan.dcollins.s1@gmail.com|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902080327
3229279|pass|200902|cpan.dcollins.s1@gmail.com|Data-Phrasebook-Loader-XML|0.12|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902080327
3229262|pass|200902|cpan.dcollins.s1@gmail.com|Data-Phrasebook-Loader-Ini|0.10|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902080326
3229259|pass|200902|cpan.dcollins.s1@gmail.com|Data-Phrasebook-Loader-DBI|0.11|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902080325
3229249|pass|200902|cpan.dcollins.s1@gmail.com|Data-Phrasebook|0.29|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902080324
3229197|pass|200902|cpan.dcollins.5100rc2@gmail.com|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902080319
3229194|pass|200902|cpan.dcollins.5100rc2@gmail.com|Data-Phrasebook-Loader-XML|0.12|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902080319
3229179|pass|200902|cpan.dcollins.5100rc2@gmail.com|Data-Phrasebook-Loader-Ini|0.10|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902080317
3229177|pass|200902|cpan.dcollins.5100rc2@gmail.com|Data-Phrasebook-Loader-DBI|0.11|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902080317
3229160|pass|200902|cpan.dcollins.5100rc2@gmail.com|Data-Phrasebook|0.29|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902080316
3228897|pass|200902|cpan.dcollins.blead@gmail.com (cpanblead)|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi|5.11.0 patch GitLive-blead-163-g28b1dae|linux|2.6.24-19-generic|200902080248
3228892|pass|200902|cpan.dcollins.blead@gmail.com (cpanblead)|Data-Phrasebook-Loader-XML|0.12|i686-linux-thread-multi|5.11.0 patch GitLive-blead-163-g28b1dae|linux|2.6.24-19-generic|200902080247
3228886|pass|200902|cpan.dcollins.blead@gmail.com (cpanblead)|Data-Phrasebook-Loader-Ini|0.10|i686-linux-thread-multi|5.11.0 patch GitLive-blead-163-g28b1dae|linux|2.6.24-19-generic|200902080246
3228883|pass|200902|cpan.dcollins.blead@gmail.com (cpanblead)|Data-Phrasebook-Loader-DBI|0.11|i686-linux-thread-multi|5.11.0 patch GitLive-blead-163-g28b1dae|linux|2.6.24-19-generic|200902080246
3228875|pass|200902|cpan.dcollins.blead@gmail.com (cpanblead)|Data-Phrasebook|0.29|i686-linux-thread-multi|5.11.0 patch GitLive-blead-163-g28b1dae|linux|2.6.24-19-generic|200902080245
3228806|pass|200902|cpan.dcollins.s2@gmail.com|Data-Phrasebook-Loader-XML|0.12|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902080238
3228805|pass|200902|cpan.dcollins.s2@gmail.com|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902080238
3228798|pass|200902|cpan.dcollins.s2@gmail.com|Data-Phrasebook-Loader-Ini|0.10|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902080237
3228797|pass|200902|cpan.dcollins.s2@gmail.com|Data-Phrasebook-Loader-DBI|0.11|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902080236
3228791|pass|200902|cpan.dcollins.s2@gmail.com|Data-Phrasebook|0.29|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902080236
3228555|pass|200902|cpan.dcollins.5100rc2@gmail.com|Data-FormValidator-Constraints-Words|0.03|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902080211
3228552|pass|200902|cpan.dcollins.s1@gmail.com|Data-FormValidator-Constraints-Words|0.03|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902080209
3228475|pass|200902|cpan.dcollins.blead@gmail.com (cpanblead)|Data-FormValidator-Constraints-Words|0.03|i686-linux-thread-multi|5.11.0 patch GitLive-blead-163-g28b1dae|linux|2.6.24-19-generic|200902080155
3228437|pass|200902|cpan.dcollins.s2@gmail.com|Data-FormValidator-Constraints-Words|0.03|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902080148
3226748|pass|200902|cpan.dcollins.589@gmail.com|Calendar-List|0.21|i686-linux-thread-multi|5.8.9|linux|2.6.24-19-generic|200902080003
3226626|pass|200902|cpan.dcollins.s1@gmail.com|Calendar-List|0.21|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902071843
3221883|fail|200902|cpan.dcollins.5100@gmail.com|Finance-Currency-Convert-XE|0.15|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902070835
3221535|pass|200902|bingos@cpan.org|Test-YAML-Meta|0.11|OpenBSD.i386-openbsd-thread-multi-64int|5.10.0|openbsd|4.3|200902071207
3218664|fail|200902|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.59|i386-netbsd-thread-multi-64int|5.8.8|netbsd|4.0|200902070103
3214600|pass|200902|cpan.dcollins.s3@gmail.com|WWW-Scraper-ISBN-ORA_Driver|0.09|i686-linux-thread-multi|5.8.9|linux|2.6.24-19-generic|200902051829
3214289|fail|200902|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.59|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0|200902061230
3214277|fail|200902|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.59|i386-netbsd-thread-multi-64int|5.8.9|netbsd|4.0|200902061228
3213971|pass|200902|cpan.dcollins.s3@gmail.com|WWW-Scraper-ISBN-Pearson_Driver|0.10|i686-linux-thread-multi|5.8.9|linux|2.6.24-19-generic|200902051832
3213917|pass|200902|bingos@cpan.org|Test-YAML-Meta|0.11|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0|200902061139
3213772|fail|200902|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.59|alpha-linux-thread-multi|5.8.9|linux|2.6.18-5-alpha-generic|200902061123
3213324|pass|200902|bingos@cpan.org|Test-YAML-Meta|0.11|alpha-linux-thread-multi|5.8.9|linux|2.6.18-5-alpha-generic|200902061016
3213323|pass|200902|bingos@cpan.org|Test-YAML-Meta|0.11|alpha-linux-thread-multi|5.10.0|linux|2.6.18-5-alpha-generic|200902061016
3212378|pass|200902|dagolden@cpan.org (DAGOLDEN)|Data-Phrasebook-Loader-YAML|0.09|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.1|200902060200
3212374|pass|200902|dagolden@cpan.org (DAGOLDEN)|Data-Phrasebook|0.29|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.1|200902060159
3209733|pass|200902|cpan.dcollins.s1@gmail.com|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902051412
3209687|pass|200902|cpan.dcollins.5100rc2@gmail.com|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902051400
3209536|pass|200902|cpan.dcollins.5100rc2@gmail.com|WWW-Scraper-ISBN-Pearson_Driver|0.10|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902051335
3209528|pass|200902|cpan.dcollins.5100rc2@gmail.com|WWW-Scraper-ISBN-ORA_Driver|0.09|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902051333
3209120|pass|200902|cpan.dcollins.s2@gmail.com|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i686-linux-thread-multi|5.11.0 patch GitLive-blead-163-g28b1dae|linux|2.6.24-19-generic|200902051228
3209024|pass|200902|cpan.dcollins.s2@gmail.com|WWW-Scraper-ISBN-Pearson_Driver|0.10|i686-linux-thread-multi|5.11.0 patch GitLive-blead-163-g28b1dae|linux|2.6.24-19-generic|200902051217
3209017|pass|200902|cpan.dcollins.s2@gmail.com|WWW-Scraper-ISBN-ORA_Driver|0.09|i686-linux-thread-multi|5.11.0 patch GitLive-blead-163-g28b1dae|linux|2.6.24-19-generic|200902051216
3206570|fail|200902|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.59|i386-netbsd-thread-multi-64int|5.8.8|netbsd|4.0.1|200902051140
3206562|pass|200902|bingos@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.14|i386-netbsd-thread-multi-64int|5.8.8|netbsd|4.0.1|200902051134
3206557|pass|200902|bingos@cpan.org|CPAN-Testers-Data-Generator|0.35|i386-netbsd-thread-multi-64int|5.8.8|netbsd|4.0.1|200902051131
3206117|pass|200902|bingos@cpan.org|Test-YAML-Meta|0.11|i386-netbsd-thread-multi-64int|5.8.8|netbsd|4.0.1|200902050957
3204537|pass|200902|cpan.dcollins.s1@gmail.com|Games-Trackword|1.06|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902050319
3204460|pass|200902|cpan.dcollins.s2@gmail.com|Games-Trackword|1.06|i686-linux-thread-multi|5.11.0 patch GitLive-blead-163-g28b1dae|linux|2.6.24-19-generic|200902050312
3203518|fail|200902|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.59|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.21.5-smp|200902050127
3202654|pass|200902|david@cantrell.org.uk|CPAN-WWW-Testers|0.48|alpha-netbsd|5.10.0|netbsd|4.0.1|200902050003
3201718|pass|200902|bingos@cpan.org|Test-YAML-Meta|0.11|i386-netbsd-thread-multi-64int|5.8.8|netbsd|3.1|200902042225
3201320|pass|200902|srezic@cpan.org|CPAN-Testers-WWW-Statistics|0.60|amd64-freebsd|5.10.0|freebsd|7.0-release|200902042257
3198952|pass|200902|bingos@cpan.org|Test-YAML-Meta|0.11|i386-freebsd-thread-multi-64int|5.8.8|freebsd|6.2-release|200902041308
3197911|pass|200902|srezic@cpan.org|CPAN-WWW-Testers|0.48|amd64-freebsd|5.10.0|freebsd|7.0-release|200902041311
3197681|pass|200902|bingos@cpan.org|Test-YAML-Meta|0.11|i386-netbsd-thread-multi-64int|5.10.0|netbsd|3.1|200902041134
3197016|pass|200902|david@cantrell.org.uk|CPAN-WWW-Testers|0.48|x86_64-linux-thread-multi|5.8.9|linux|2.6.18-4-xen-amd64|200902040936
3196662|pass|200902|david@cantrell.org.uk|CPAN-WWW-Testers|0.47|x86_64-linux-thread-multi|5.8.9|linux|2.6.18-4-xen-amd64|200902040838
3195484|pass|200902|cpan.dcollins.5100rc2@gmail.com|Parse-CPAN-Distributions|0.05|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902040230
3195305|pass|200902|cpan.dcollins.5100rc1@gmail.com|Parse-CPAN-Distributions|0.05|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902040208
3195088|pass|200902|cpan.dcollins.blead@gmail.com|Parse-CPAN-Distributions|0.05|i686-linux-thread-multi|5.11.0 patch GitLive-blead-163-g28b1dae|linux|2.6.24-19-generic|200902040148
3194762|pass|200902|cpan.dcollins.5100@gmail.com|Parse-CPAN-Distributions|0.05|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902040101
3194577|pass|200902|cpan.dcollins.589@gmail.com|Parse-CPAN-Distributions|0.05|i686-linux-thread-multi|5.8.9|linux|2.6.24-19-generic|200902040041
3193732|pass|200902|david@cantrell.org.uk|CPAN-WWW-Testers|0.48|x86_64-linux-thread-multi|5.10.0|linux|2.6.18-4-xen-amd64|200902032251
3193729|pass|200902|david@cantrell.org.uk|CPAN-WWW-Testers|0.48|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200902032250
3193723|pass|200902|david@cantrell.org.uk|CPAN-WWW-Testers|0.47|x86_64-linux-thread-multi|5.10.0|linux|2.6.18-4-xen-amd64|200902032250
3193684|pass|200902|bingos@cpan.org|Test-YAML-Meta|0.11|i386-freebsd-thread-multi-64int|5.10.0|freebsd|6.2-release|200902032108
3192969|pass|200902|david@cantrell.org.uk|CPAN-WWW-Testers|0.47|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200902032141
3192563|pass|200902|david@cantrell.org.uk|CPAN-WWW-Testers|0.48|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200902031510
3192540|pass|200902|david@cantrell.org.uk|CPAN-WWW-Testers|0.47|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200902031507
3191873|fail|200902|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.59|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0.1|200902031929
3191855|pass|200902|bingos@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.14|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0.1|200902031921
3191844|fail|200902|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.59|i386-netbsd-thread-multi-64int|5.8.9|netbsd|4.0.1|200902031916
3191837|pass|200902|bingos@cpan.org|CPAN-Testers-Data-Generator|0.35|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0.1|200902031914
3191829|pass|200902|bingos@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.14|i386-netbsd-thread-multi-64int|5.8.9|netbsd|4.0.1|200902031906
3191819|pass|200902|bingos@cpan.org|CPAN-Testers-Data-Generator|0.35|i386-netbsd-thread-multi-64int|5.8.9|netbsd|4.0.1|200902031858
3191557|pass|200902|bingos@cpan.org|Test-YAML-Meta|0.11|i386-netbsd-thread-multi-64int|5.8.9|netbsd|4.0.1|200902031641
3191550|pass|200902|bingos@cpan.org|Test-YAML-Meta|0.11|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0.1|200902031639
3191539|pass|200902|dagolden@cpan.org (DAGOLDEN)|Test-YAML-Meta|0.11|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.1|200902031130
3188034|pass|200902|stsc@refcnt.org ("Steven Schubiger")|CPAN-WWW-Testers|0.48|i686-linux|5.10.0|linux|2.6.18-4-686|200902030217
3187365|fail|200902|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.59|i386-netbsd-thread-multi-64int|5.8.9|netbsd|3.1|200902022354
3187359|fail|200902|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.58|i386-netbsd-thread-multi-64int|5.8.9|netbsd|3.1|200902022353
3187156|pass|200902|bingos@cpan.org|Test-YAML-Meta|0.11|i386-netbsd-thread-multi-64int|5.8.9|netbsd|3.1|200902022319
3186366|cpan|200902|BARBIE|CPAN-WWW-Testers|0.48||0|||200902022230
3186072|pass|200902|cpan.dcollins.5100rc2@gmail.com|Test-YAML-Meta|0.11|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902021537
3186053|pass|200902|cpan.dcollins.589@gmail.com|Test-YAML-Meta|0.11|i686-linux-thread-multi|5.8.9|linux|2.6.24-19-generic|200902021534
3185949|pass|200902|srezic@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.14|amd64-freebsd-thread-multi|5.10.0|freebsd|7.0-release|200902022108
3185921|pass|200902|srezic@cpan.org|CPAN-Testers-Data-Generator|0.35|amd64-freebsd-thread-multi|5.10.0|freebsd|7.0-release|200902022106
3185393|pass|200902|srezic@cpan.org|CPAN-Testers-WWW-Statistics|0.60|amd64-freebsd|5.8.9|freebsd|7.0-release|200902021857
3185385|pass|200902|srezic@cpan.org|CPAN-Testers-WWW-Statistics|0.60|amd64-freebsd|5.8.8|freebsd|7.0-release|200902021857
3185326|pass|200902|bingos@cpan.org|Test-YAML-Meta|0.11|darwin-thread-multi-64int-2level|5.8.6|darwin|8.11.0|200902021752
3184811|cpan|200902|BARBIE|CPAN-WWW-Testers|0.47||0|||200902021735
3184401|pass|200902|JOST@cpan.org ("Josts Smokehouse")|CPAN-Testers-WWW-Statistics|0.60|i86pc-solaris-64int|5.10.0|solaris|2.11|200902021625
3184097|pass|200902|david@cantrell.org.uk|Test-YAML-Meta|0.11|alpha-netbsd|5.10.0|netbsd|4.0.1|200902021416
3183948|pass|200902|david@cantrell.org.uk|Test-YAML-Meta|0.11|x86_64-linux-thread-multi|5.10.0|linux|2.6.18-4-xen-amd64|200902021342
3183820|pass|200902|david@cantrell.org.uk|Test-YAML-Meta|0.11|x86_64-linux-thread-multi|5.8.9|linux|2.6.18-4-xen-amd64|200902021316
3183660|cpan|200902|BARBIE|CPAN-Testers-WWW-Statistics|0.60||0|||200902021333
3183425|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|Parse-CPAN-Distributions|0.05|s390x-linux-thread-multi|5.8.8|linux|2.6.18-92.1.18.el5|200902021221
3181885|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal-Thread|0.12|s390x-linux-thread-multi|5.8.8|linux|2.6.18-92.1.18.el5|200902020701
3181883|pass|200902|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal|0.22|s390x-linux-thread-multi|5.8.8|linux|2.6.18-92.1.18.el5|200902020700
3181170|pass|200902|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-netbsd-thread-multi-64int|5.8.9|netbsd|3.1|200902020116
3180309|pass|200902|srezic@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.14|amd64-freebsd|5.10.0|freebsd|7.0-release|200902012250
3180305|pass|200902|srezic@cpan.org|CPAN-Testers-Data-Generator|0.35|amd64-freebsd|5.10.0|freebsd|7.0-release|200902012249
3178689|pass|200902|cpan.dcollins.5100rc2@gmail.com|WWW-UsePerl-Journal-Thread|0.12|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902011325
3178688|pass|200902|cpan.dcollins.5100rc2@gmail.com|WWW-UsePerl-Journal|0.22|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902011325
3178668|pass|200902|cpan.dcollins.589@gmail.com|WWW-UsePerl-Journal-Thread|0.12|i686-linux-thread-multi|5.8.9|linux|2.6.24-19-generic|200902011323
3178665|pass|200902|cpan.dcollins.589@gmail.com|WWW-UsePerl-Journal|0.22|i686-linux-thread-multi|5.8.9|linux|2.6.24-19-generic|200902011323
3178652|pass|200902|cpan.dcollins.5100@gmail.com|WWW-UsePerl-Journal-Thread|0.12|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902011321
3178647|pass|200902|cpan.dcollins.5100@gmail.com|WWW-UsePerl-Journal|0.22|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902011321
3178614|pass|200902|cpan.dcollins.5100rc1@gmail.com|WWW-UsePerl-Journal-Thread|0.12|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902011319
3178611|pass|200902|cpan.dcollins.5100rc1@gmail.com|WWW-UsePerl-Journal|0.22|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200902011319
3178580|pass|200902|cpan.dcollins.blead@gmail.com|WWW-UsePerl-Journal-Thread|0.12|i686-linux-thread-multi|5.11.0 patch GitLive-blead-163-g28b1dae|linux|2.6.24-19-generic|200902011315
3178579|pass|200902|cpan.dcollins.blead@gmail.com|WWW-UsePerl-Journal|0.22|i686-linux-thread-multi|5.11.0 patch GitLive-blead-163-g28b1dae|linux|2.6.24-19-generic|200902011315
3178567|fail|200902|srezic@cpan.org|CPAN-Testers-WWW-Statistics|0.59|amd64-freebsd|5.10.0|freebsd|7.0-release|200902011912
3177029|fail|200902|srezic@cpan.org|CPAN-Testers-WWW-Statistics|0.59|amd64-freebsd|5.8.9|freebsd|7.0-release|200902011531
3176873|fail|200902|david@cantrell.org.uk|CPAN-Testers-WWW-Statistics|0.59|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200902011408
3176870|fail|200902|david@cantrell.org.uk|CPAN-Testers-WWW-Statistics|0.59|x86_64-linux-thread-multi|5.8.9|linux|2.6.18-4-xen-amd64|200902011408
3176835|fail|200902|srezic@cpan.org|CPAN-Testers-WWW-Statistics|0.59|amd64-freebsd|5.8.8|freebsd|7.0-release|200902011456
3176225|fail|200902|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.59|i386-netbsd-thread-multi-64int|5.8.8|netbsd|3.1|200902011218
3176219|fail|200902|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.57|i386-netbsd-thread-multi-64int|5.8.8|netbsd|3.1|200902011217
3176217|fail|200902|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.58|i386-netbsd-thread-multi-64int|5.8.8|netbsd|3.1|200902011217
3176178|pass|200902|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-netbsd-thread-multi-64int|5.8.8|netbsd|3.1|200902011208
3175629|fail|200902|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.59|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.0-release|200902010622
3175622|fail|200902|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.58|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.0-release|200902010620
3175618|fail|200902|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.57|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.0-release|200902010619
3175614|fail|200902|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.56|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.0-release|200902010618
3173864|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.59|i386-netbsd-thread-multi-64int|5.10.0|netbsd|3.1|200901312308
3173863|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.58|i386-netbsd-thread-multi-64int|5.10.0|netbsd|3.1|200901312307
3173862|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.57|i386-netbsd-thread-multi-64int|5.10.0|netbsd|3.1|200901312306
3173817|pass|200901|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-netbsd-thread-multi-64int|5.10.0|netbsd|3.1|200901312257
3172580|fail|200901|cpan.dcollins.5100rc2@gmail.com|CPAN-Testers-WWW-Statistics|0.59|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200901311535
3172569|fail|200901|cpan.dcollins.5100rc2@gmail.com|CPAN-Testers-WWW-Statistics|0.58|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200901311533
3172544|fail|200901|cpan.dcollins.5100rc2@gmail.com|CPAN-Testers-WWW-Statistics|0.57|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200901311530
3172538|fail|200901|cpan.dcollins.5100rc2@gmail.com|CPAN-Testers-WWW-Statistics|0.56|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200901311528
3172463|pass|200901|cpan.dcollins.s1@gmail.com|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200901311523
3172456|pass|200901|cpan.dcollins.5100rc2@gmail.com|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200901311523
3172287|fail|200901|cpan.dcollins.5100rc1@gmail.com|CPAN-Testers-WWW-Statistics|0.56|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200901311455
3172286|fail|200901|cpan.dcollins.5100rc1@gmail.com|CPAN-Testers-WWW-Statistics|0.59|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200901311458
3172279|fail|200901|cpan.dcollins.5100rc1@gmail.com|CPAN-Testers-WWW-Statistics|0.58|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200901311457
3172270|fail|200901|cpan.dcollins.5100rc1@gmail.com|CPAN-Testers-WWW-Statistics|0.57|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200901311456
3172234|pass|200901|cpan.dcollins.5100rc1@gmail.com|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200901311452
3172220|fail|200901|cpan.dcollins.589@gmail.com|CPAN-Testers-WWW-Statistics|0.59|i686-linux-thread-multi|5.8.9|linux|2.6.24-19-generic|200901311449
3172210|fail|200901|cpan.dcollins.589@gmail.com|CPAN-Testers-WWW-Statistics|0.58|i686-linux-thread-multi|5.8.9|linux|2.6.24-19-generic|200901311446
3172208|fail|200901|cpan.dcollins.589@gmail.com|CPAN-Testers-WWW-Statistics|0.57|i686-linux-thread-multi|5.8.9|linux|2.6.24-19-generic|200901311444
3172182|fail|200901|cpan.dcollins.589@gmail.com|CPAN-Testers-WWW-Statistics|0.56|i686-linux-thread-multi|5.8.9|linux|2.6.24-19-generic|200901311442
3172105|fail|200901|cpan.dcollins.blead@gmail.com|CPAN-Testers-WWW-Statistics|0.59|i686-linux-thread-multi|5.11.0|linux|2.6.24-19-generic|200901311434
3172100|pass|200901|cpan.dcollins.589@gmail.com|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.8.9|linux|2.6.24-19-generic|200901311436
3172093|fail|200901|cpan.dcollins.blead@gmail.com|CPAN-Testers-WWW-Statistics|0.58|i686-linux-thread-multi|5.11.0|linux|2.6.24-19-generic|200901311433
3172086|fail|200901|cpan.dcollins.blead@gmail.com|CPAN-Testers-WWW-Statistics|0.57|i686-linux-thread-multi|5.11.0|linux|2.6.24-19-generic|200901311432
3172083|fail|200901|cpan.dcollins.blead@gmail.com|CPAN-Testers-WWW-Statistics|0.56|i686-linux-thread-multi|5.11.0|linux|2.6.24-19-generic|200901311431
3171414|fail|200902|imacat@mail.imacat.idv.tw|CPAN-Testers-WWW-Statistics|0.59|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.24-etchnhalf.1-amd64|200902010129
3170952|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.59|i386-netbsd-thread-multi-64int|5.8.9|netbsd|3.1|200901311558
3170921|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.59|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.1-release|200901311554
3170915|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.58|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.1-release|200901311553
3170914|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.57|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.1-release|200901311552
3170903|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.56|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.1-release|200901311552
3170737|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.59|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.1-release|200901311539
3170719|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.58|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.1-release|200901311537
3170703|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.57|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.1-release|200901311536
3170686|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.56|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.1-release|200901311535
3169457|pass|200901|davidrw@cpan.org|CPAN-WWW-Testers|0.46|i486-linux-gnu-thread-multi|5.8.8|linux|2.6.18-6-686|200901310914
3168973|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.59|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.0-release|200901311214
3168971|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.58|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.0-release|200901311213
3168969|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.57|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.0-release|200901311211
3168968|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.56|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.0-release|200901311210
3168947|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.58|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.0-release|200901311153
3168945|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.59|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.0-release|200901311155
3168944|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.57|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.0-release|200901311151
3168941|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.56|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.0-release|200901311150
3168571|pass|200901|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.0-release|200901310514
3168570|pass|200901|bingos@cpan.org|Data-Phrasebook|0.29|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.0-release|200901310514
3168073|pass|200901|cpan.dcollins.5100@gmail.com|GD-Chart-Radial|0.07|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200901310426
3167893|pass|200901|cpan.dcollins.589@gmail.com|GD-Chart-Radial|0.07|i686-linux-thread-multi|5.8.9|linux|2.6.24-19-generic|200901310412
3167885|pass|200901|cpan.dcollins.5100rc2@gmail.com|GD-Chart-Radial|0.07|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200901310411
3167849|pass|200901|cpan.dcollins.5100rc1@gmail.com|GD-Chart-Radial|0.07|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200901310409
3167818|pass|200901|cpan.dcollins.blead@gmail.com|GD-Chart-Radial|0.07|i686-linux-thread-multi|5.11.0 patch GitLive-blead-163-g28b1dae|linux|2.6.24-19-generic|200901310405
3166461|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.58|i386-netbsd-thread-multi-64int|5.8.8|netbsd|4.0|200901302221
3166460|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.57|i386-netbsd-thread-multi-64int|5.8.8|netbsd|4.0|200901302220
3165707|pass|200901|stro@cpan.org|CPAN-Testers-Data-Generator|0.34|MSWin32-x86-multi-thread|5.8.9|MSWin32|5.00|200901301215
3165675|pass|200901|alexchorny@gmail.com|Mail-Outlook|0.14|MSWin32-x86-multi-thread|5.8.8|MSWin32|5.1|200901301504
3164595|pass|200901|dagolden@cpan.org (DAGOLDEN)|CPAN-Testers-Data-Generator|0.35|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.1|200901301158
3164585|pass|200901|dagolden@cpan.org (DAGOLDEN)|CPAN-Testers-Common-DBUtils|0.03|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.1|200901301156
3163156|cpan|200901|BARBIE|CPAN-Testers-WWW-Statistics|0.59||0|||200901301421
3162917|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.58|i386-netbsd-thread-multi-64int|5.8.9|netbsd|4.0|200901300955
3162711|pass|200901|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.0-release|200901301110
3162708|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.57|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0|200901301006
3162702|pass|200901|bingos@cpan.org|Data-Phrasebook|0.29|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.0-release|200901301109
3162650|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.58|i386-netbsd-thread-multi-64int|5.8.9|netbsd|4.0|200901300955
3162538|pass|200901|david@cantrell.org.uk|CPAN-Testers-WWW-Reports-Mailer|0.14|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200901300530
3162518|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.57|i386-netbsd-thread-multi-64int|5.8.9|netbsd|4.0|200901300953
3162411|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.57|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0|200901301006
3162377|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.58|i386-netbsd-thread-multi-64int|5.8.9|netbsd|4.0|200901300955
3162373|pass|200901|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.0-release|200901301013
3162371|pass|200901|bingos@cpan.org|Data-Phrasebook|0.29|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.0-release|200901301013
3162297|fail|200901|stsc@refcnt.org ("Steven Schubiger")|Finance-Currency-Convert-XE|0.15|i686-linux|5.10.0|linux|2.6.18-4-686|200901301142
3162287|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.57|i386-netbsd-thread-multi-64int|5.8.9|netbsd|4.0|200901300953
3162227|pass|200901|david@cantrell.org.uk|CPAN-Testers-WWW-Reports-Mailer|0.14|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200901301024
3162222|pass|200901|david@cantrell.org.uk|CPAN-Testers-WWW-Reports-Mailer|0.14|x86_64-linux-thread-multi|5.10.0|linux|2.6.18-4-xen-amd64|200901301028
3162220|pass|200901|david@cantrell.org.uk|CPAN-Testers-WWW-Reports-Mailer|0.14|x86_64-linux-thread-multi|5.8.9|linux|2.6.18-4-xen-amd64|200901301028
3162209|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.58|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0|200901301007
3162205|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.57|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0|200901301006
3162187|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.58|i386-netbsd-thread-multi-64int|5.8.9|netbsd|4.0|200901300955
3162163|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.57|i386-netbsd-thread-multi-64int|5.8.9|netbsd|4.0|200901300953
3162103|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.58|i386-netbsd-thread-multi-64int|5.8.9|netbsd|4.0|200901300955
3162090|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.57|i386-netbsd-thread-multi-64int|5.8.9|netbsd|4.0|200901300953
3161945|pass|200901|david@cantrell.org.uk|CPAN-Testers-WWW-Reports-Mailer|0.14|alpha-netbsd|5.10.0|netbsd|4.0.1|200901300939
3161867|pass|200901|david@cantrell.org.uk|CPAN-Testers-WWW-Reports-Mailer|0.14|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200901300927
3161310|pass|200901|stro@cpan.org|CPAN-Testers-WWW-Statistics|0.55|MSWin32-x86-multi-thread|5.8.9|MSWin32|5.00|200901300018
3160706|pass|200901|davidrw@cpan.org|CPAN-Testers-Data-Generator|0.35|i486-linux-gnu-thread-multi|5.8.8|linux|2.6.18.3|200901300516
3160516|pass|200901|stro@cpan.org|Data-Phrasebook-Loader-YAML|0.09|MSWin32-x86-multi-thread|5.8.9|MSWin32|5.00|200901300430
3160513|pass|200901|stro@cpan.org|Data-Phrasebook|0.29|MSWin32-x86-multi-thread|5.8.9|MSWin32|5.00|200901300430
3160459|pass|200901|davidrw@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.14|i486-linux-gnu-thread-multi|5.8.8|linux|2.6.18.3|200901300417
3159773|pass|200901|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|OpenBSD.i386-openbsd-thread-multi-64int|5.8.8|openbsd|4.2|200901300130
3159771|pass|200901|bingos@cpan.org|Data-Phrasebook|0.29|OpenBSD.i386-openbsd-thread-multi-64int|5.8.8|openbsd|4.2|200901300129
3159518|pass|200901|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.0-release|200901300040
3159420|pass|200901|stsc@refcnt.org ("Steven Schubiger")|CPAN-Testers-WWW-Reports-Mailer|0.14|i686-linux|5.10.0|linux|2.6.18-4-686|200901300121
3159382|pass|200901|stsc@refcnt.org ("Steven Schubiger")|CPAN-Testers-Data-Generator|0.35|i686-linux|5.10.0|linux|2.6.18-4-686|200901300112
3159323|pass|200901|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.0-release|200901292354
3158015|pass|200901|JOST@cpan.org ("Josts Smokehouse")|CPAN-Testers-WWW-Reports-Mailer|0.14|i86pc-solaris-64int|5.10.0|solaris|2.11|200901292237
3158013|pass|200901|JOST@cpan.org ("Josts Smokehouse")|CPAN-Testers-Data-Generator|0.35|i86pc-solaris-64int|5.10.0|solaris|2.11|200901292236
3157332|cpan|200901|BARBIE|CPAN-Testers-WWW-Reports-Mailer|0.14||0|||200901291331
3157225|cpan|200901|BARBIE|CPAN-Testers-Data-Generator|0.35||0|||200901291422
3157165|pass|200901|srezic@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.14|amd64-freebsd|5.8.8|freebsd|7.0-release|200901291813
3157068|pass|200901|srezic@cpan.org|CPAN-Testers-Data-Generator|0.35|amd64-freebsd|5.8.9|freebsd|7.0-release|200901291813
3157067|pass|200901|srezic@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.14|amd64-freebsd|5.8.9|freebsd|7.0-release|200901291813
3157065|pass|200901|srezic@cpan.org|CPAN-Testers-Data-Generator|0.35|amd64-freebsd|5.8.8|freebsd|7.0-release|200901291813
3156634|pass|200901|stro@cpan.org|CPAN-Testers-Common-DBUtils|0.03|MSWin32-x86-multi-thread|5.8.9|MSWin32|5.00|200901290813
3156457|pass|200901|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i386-freebsd-thread-multi-64int|5.8.8|freebsd|6.4-release|200901291517
3156456|pass|200901|bingos@cpan.org|Data-Phrasebook|0.29|i386-freebsd-thread-multi-64int|5.8.8|freebsd|6.4-release|200901291517
3155886|fail|200901|vpit@cpan.org|CPAN-Testers-WWW-Statistics|0.58|x86_64-linux-thread-multi|5.10.0|linux|2.6.26.3-fuuka.profvince.com|200901291500
3155641|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.58|i386-netbsd-thread-multi-64int|5.8.9|netbsd|3.1|200901291248
3155640|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.57|i386-netbsd-thread-multi-64int|5.8.9|netbsd|3.1|200901291247
3155292|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.58|i386-freebsd-thread-multi-64int|5.8.8|freebsd|6.4-release|200901291035
3155287|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.57|i386-freebsd-thread-multi-64int|5.8.8|freebsd|6.4-release|200901291035
3155284|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.56|i386-freebsd-thread-multi-64int|5.8.8|freebsd|6.4-release|200901291034
3155123|pass|200901|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|OpenBSD.i386-openbsd-thread-multi-64int|5.10.0|openbsd|4.2|200901290920
3155121|pass|200901|bingos@cpan.org|Data-Phrasebook|0.29|OpenBSD.i386-openbsd-thread-multi-64int|5.10.0|openbsd|4.2|200901290919
3155103|pass|200901|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|OpenBSD.i386-openbsd-thread-multi-64int|5.8.9|openbsd|4.2|200901290903
3155102|pass|200901|bingos@cpan.org|Data-Phrasebook|0.29|OpenBSD.i386-openbsd-thread-multi-64int|5.8.9|openbsd|4.2|200901290902
3154588|pass|200901|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i386-freebsd-thread-multi-64int|5.10.0|freebsd|6.4-release|200901290615
3154585|pass|200901|bingos@cpan.org|Data-Phrasebook|0.29|i386-freebsd-thread-multi-64int|5.10.0|freebsd|6.4-release|200901290615
3154564|pass|200901|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i386-freebsd-thread-multi-64int|5.8.9|freebsd|6.4-release|200901290613
3154560|pass|200901|bingos@cpan.org|Data-Phrasebook|0.29|i386-freebsd-thread-multi-64int|5.8.9|freebsd|6.4-release|200901290612
3154337|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.58|alpha-linux-thread-multi|5.8.9|linux|2.6.18-5-alpha-generic|200901290917
3154231|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.58|i386-freebsd-thread-multi-64int|5.10.0|freebsd|6.4-release|200901290853
3154223|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.56|i386-freebsd-thread-multi-64int|5.10.0|freebsd|6.4-release|200901290850
3154143|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.56|i386-freebsd-thread-multi-64int|5.8.9|freebsd|6.4-release|200901290835
3154061|pass|200901|MKUTTER@cpan.org ("Martin Kutter")|Test-CPAN-Meta|0.12|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-16-server|200901290920
3153432|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.58|alpha-linux-thread-multi|5.8.9|linux|2.6.18-5-alpha-generic|200901290536
3153302|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.58|i386-freebsd-thread-multi-64int|5.10.0|freebsd|6.4-release|200901290503
3153291|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.56|i386-freebsd-thread-multi-64int|5.10.0|freebsd|6.4-release|200901290500
3153290|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.57|i386-freebsd-thread-multi-64int|5.10.0|freebsd|6.4-release|200901290500
3153252|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.58|i386-freebsd-thread-multi-64int|5.8.9|freebsd|6.4-release|200901290444
3153246|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.56|i386-freebsd-thread-multi-64int|5.8.9|freebsd|6.4-release|200901290440
3153245|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.57|i386-freebsd-thread-multi-64int|5.8.9|freebsd|6.4-release|200901290440
3152009|pass|200901|bingos@cpan.org|Test-YAML-Meta|0.11|i386-dragonfly-64int|5.10.0|dragonfly|2.0.1-release|200901290205
3151796|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.58|alpha-linux-thread-multi|5.8.9|linux|2.6.18-5-alpha-generic|200901290106
3150849|pass|200901|pjacklam@online.no|Test-YAML-Meta|0.11|cygwin-thread-multi-64int|5.10.0 patch 34065|cygwin|1.5.25(0.15642)|200901282306
3150420|pass|200901|dagolden@cpan.org (DAGOLDEN)|CPAN-WWW-Testers-Generator|0.30|x86_64-linux-ld|5.10.0|linux|2.6.27-9-generic|200901281527
3149927|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.58|alpha-linux-thread-multi|5.8.9|linux|2.6.18-5-alpha-generic|200901281321
3149905|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.57|alpha-linux-thread-multi|5.8.9|linux|2.6.18-5-alpha-generic|200901281320
3149903|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.56|alpha-linux-thread-multi|5.8.9|linux|2.6.18-5-alpha-generic|200901281319
3149853|pass|200901|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|alpha-linux-thread-multi|5.8.9|linux|2.6.18-5-alpha-generic|200901281307
3149621|pass|200901|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|alpha-linux-thread-multi|5.10.0|linux|2.6.18-5-alpha-generic|200901281225
3147820|pass|200901|bingos@cpan.org|Test-YAML-Meta|0.11|i386-dragonfly-64int|5.8.8|dragonfly|2.0.1-release|200901280657
3147801|pass|200901|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.21.5-smp|200901280649
3147799|pass|200901|bingos@cpan.org|Data-Phrasebook|0.29|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.21.5-smp|200901280649
3147767|pass|200901|bingos@cpan.org|Test-YAML-Meta|0.11|i386-dragonfly-64int|5.8.9|dragonfly|2.0.1-release|200901280645
3145983|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.56|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.21.5-smp|200901280218
3145637|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.58|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.21.5-smp|200901272244
3145632|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.57|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.21.5-smp|200901272243
3145627|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.56|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.21.5-smp|200901272242
3145359|pass|200901|srezic@cpan.org|CPAN-Testers-WWW-Statistics|0.58|amd64-freebsd|5.10.0|freebsd|7.0-release|200901272326
3144281|pass|200901|alexchorny@gmail.com|Parse-CPAN-Distributions|0.05|MSWin32-x86-multi-thread|5.8.8|MSWin32|5.1|200901271302
3143884|pass|200901|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i386-freebsd-thread-multi-64int|5.8.8|freebsd|6.2-release|200901271511
3143881|pass|200901|bingos@cpan.org|Data-Phrasebook|0.29|i386-freebsd-thread-multi-64int|5.8.8|freebsd|6.2-release|200901271511
3143633|pass|200901|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i386-dragonfly-64int|5.8.8|dragonfly|2.0.1-release|200901271510
3143632|pass|200901|bingos@cpan.org|Data-Phrasebook|0.29|i386-dragonfly-64int|5.8.8|dragonfly|2.0.1-release|200901271509
3142220|fail|200901|david@cantrell.org.uk|CPAN-Testers-WWW-Statistics|0.58|x86_64-linux-thread-multi|5.10.0|linux|2.6.18-4-xen-amd64|200901271052
3142207|fail|200901|david@cantrell.org.uk|CPAN-Testers-WWW-Statistics|0.58|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200901271051
3142205|fail|200901|david@cantrell.org.uk|CPAN-Testers-WWW-Statistics|0.58|x86_64-linux-thread-multi|5.8.9|linux|2.6.18-4-xen-amd64|200901271052
3142195|pass|200901|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-dragonfly-64int|5.8.8|dragonfly|2.0.1-release|200901271050
3141467|pass|200901|bingos@cpan.org|Data-Phrasebook|0.29|i386-freebsd-thread-multi-64int|5.8.9|freebsd|6.2-release|200901270609
3141437|pass|200901|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i386-freebsd-thread-multi-64int|5.10.0|freebsd|6.2-release|200901270600
3141436|pass|200901|bingos@cpan.org|Data-Phrasebook|0.29|i386-freebsd-thread-multi-64int|5.10.0|freebsd|6.2-release|200901270559
3140613|pass|200901|cpan.dcollins.5100rc1@gmail.com|Regexp-Log-Common|0.05|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200901270307
3140527|pass|200901|cpan.dcollins.blead@gmail.com|Regexp-Log-Common|0.05|i686-linux-thread-multi|5.11.0 patch GitLive-blead-163-g28b1dae|linux|2.6.24-19-generic|200901270300
3139959|fail|200901|rhaen@cpan.org (Ulrich Habel)|Finance-Currency-Convert-XE|0.15|i386-netbsd-thread-multi|5.10.0|netbsd|5.0_beta|200901270218
3139897|pass|200901|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i386-dragonfly-64int|5.8.9|dragonfly|2.0.1-release|200901270129
3139891|pass|200901|bingos@cpan.org|Data-Phrasebook|0.29|i386-dragonfly-64int|5.8.9|dragonfly|2.0.1-release|200901270129
3139856|pass|200901|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i386-dragonfly-64int|5.10.0|dragonfly|2.0.1-release|200901270128
3139855|pass|200901|bingos@cpan.org|Data-Phrasebook|0.29|i386-dragonfly-64int|5.10.0|dragonfly|2.0.1-release|200901270128
3139252|pass|200901|cpan.dcollins.5100rc2@gmail.com|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200901270054
3139209|pass|200901|cpan.dcollins.589@gmail.com|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.8.9|linux|2.6.24-19-generic|200901270048
3138283|pass|200901|rhaen@cpan.org (Ulrich Habel)|Data-FormValidator-Constraints-Words|0.03|i386-netbsd-thread-multi|5.10.0|netbsd|5.0_beta|200901262210
3137683|fail|200901|imacat@mail.imacat.idv.tw|CPAN-Testers-WWW-Statistics|0.58|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.24-etchnhalf.1-amd64|200901270421
3137224|pass|200901|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-dragonfly-64int|5.10.0|dragonfly|2.0.1-release|200901261752
3137157|pass|200901|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-dragonfly-64int|5.8.9|dragonfly|2.0.1-release|200901261741
3137128|fail|200901|vpit@cpan.org|CPAN-Testers-WWW-Statistics|0.57|x86_64-linux-thread-multi|5.10.0|linux|2.6.26.3-fuuka.profvince.com|200901261837
3137127|fail|200901|vpit@cpan.org|CPAN-Testers-WWW-Statistics|0.56|x86_64-linux-thread-multi|5.10.0|linux|2.6.26.3-fuuka.profvince.com|200901261837
3136547|pass|200901|JOST@cpan.org ("Josts Smokehouse")|CPAN-Testers-WWW-Statistics|0.58|i86pc-solaris-64int|5.10.0|solaris|2.11|200901261625
3136426|pass|200901|srezic@cpan.org|CPAN-Testers-WWW-Statistics|0.58|amd64-freebsd|5.8.9|freebsd|7.0-release|200901261532
3136421|pass|200901|srezic@cpan.org|CPAN-Testers-WWW-Statistics|0.58|amd64-freebsd|5.8.8|freebsd|7.0-release|200901261532
3135923|fail|200901|david@cantrell.org.uk|CPAN-Testers-WWW-Statistics|0.57|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200901261232
3135462|pass|200901|vpit@cpan.org|CPAN-WWW-Testers|0.46|i686-linux-thread-multi|5.10.0|linux|2.6.18.3-tmb-desktop-2mdvsmp|200901261139
3135423|cpan|200901|BARBIE|CPAN-Testers-WWW-Statistics|0.58||0|||200901261122
3135399|fail|200901|david@cantrell.org.uk|CPAN-Testers-WWW-Statistics|0.56|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200901261015
3135398|fail|200901|david@cantrell.org.uk|CPAN-Testers-WWW-Statistics|0.57|x86_64-linux-thread-multi|5.8.9|linux|2.6.18-4-xen-amd64|200901261016
3135385|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.57|i386-dragonfly-64int|5.8.8|dragonfly|2.0.0-release|200901261007
3135384|fail|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.56|i386-dragonfly-64int|5.8.8|dragonfly|2.0.0-release|200901261006
3135381|pass|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.55|i386-dragonfly-64int|5.8.8|dragonfly|2.0.0-release|200901261004
3135327|fail|200901|david@cantrell.org.uk|CPAN-Testers-WWW-Statistics|0.57|x86_64-linux-thread-multi|5.10.0|linux|2.6.18-4-xen-amd64|200901260927
3135325|fail|200901|david@cantrell.org.uk|CPAN-Testers-WWW-Statistics|0.56|x86_64-linux-thread-multi|5.8.9|linux|2.6.18-4-xen-amd64|200901260927
3134950|fail|200901|srezic@cpan.org|CPAN-Testers-WWW-Statistics|0.57|amd64-freebsd|5.10.0|freebsd|7.0-release|200901260840
3134694|pass|200901|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.16.38|200901260703
3134690|pass|200901|bingos@cpan.org|Data-Phrasebook|0.29|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.16.38|200901260702
3133334|pass|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.55|i386-dragonfly-64int|5.10.0|dragonfly|2.0.0-release|200901260030
3133297|pass|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.55|i386-dragonfly-64int|5.8.9|dragonfly|2.0.0-release|200901260014
3133209|pass|200901|srezic@cpan.org|CPAN-Testers-WWW-Statistics|0.57|amd64-freebsd|5.8.9|freebsd|7.0-release|200901260008
3133111|pass|200901|srezic@cpan.org|CPAN-Testers-WWW-Statistics|0.57|amd64-freebsd|5.8.8|freebsd|7.0-release|200901260008
3132914|pass|200901|srezic@cpan.org|CPAN-Testers-WWW-Statistics|0.56|amd64-freebsd|5.8.8|freebsd|7.0-release|200901252205
3132897|pass|200901|srezic@cpan.org|CPAN-Testers-WWW-Statistics|0.56|amd64-freebsd|5.8.9|freebsd|7.0-release|200901252205
3132861|cpan|200901|BARBIE|CPAN-Testers-WWW-Statistics|0.57||0|||200901252159
3132344|cpan|200901|BARBIE|CPAN-Testers-WWW-Statistics|0.56||0|||200901251837
3131987|pass|200901|david@cantrell.org.uk|Data-Phrasebook-Loader-YAML|0.09|alpha-netbsd|5.10.0|netbsd|4.0.1|200901251602
3131984|pass|200901|david@cantrell.org.uk|Data-Phrasebook|0.29|alpha-netbsd|5.10.0|netbsd|4.0.1|200901251601
3131323|pass|200901|david@cantrell.org.uk|Data-Phrasebook-Loader-YAML|0.09|x86_64-linux-thread-multi|5.10.0|linux|2.6.18-4-xen-amd64|200901251228
3131322|pass|200901|david@cantrell.org.uk|Data-Phrasebook|0.29|x86_64-linux-thread-multi|5.10.0|linux|2.6.18-4-xen-amd64|200901251228
3131070|pass|200901|david@cantrell.org.uk|Data-Phrasebook-Loader-YAML|0.09|x86_64-linux-thread-multi|5.8.9|linux|2.6.18-4-xen-amd64|200901251159
3131068|pass|200901|david@cantrell.org.uk|Data-Phrasebook|0.29|x86_64-linux-thread-multi|5.8.9|linux|2.6.18-4-xen-amd64|200901251159
3129244|pass|200901|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.24.5-smp|200901250057
3129243|pass|200901|bingos@cpan.org|Data-Phrasebook|0.29|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.24.5-smp|200901250057
3128280|pass|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.55|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.24.5-smp|200901242122
3128252|pass|200901|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.24.5-smp|200901242116
3128236|pass|200901|srezic@cpan.org|CPAN-WWW-Testers|0.46|amd64-freebsd|5.10.0|freebsd|7.0-release|200901242107
3127536|pass|200901|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24.5-smp|200901241827
3127534|pass|200901|bingos@cpan.org|Data-Phrasebook|0.29|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24.5-smp|200901241827
3126616|pass|200901|vpit@cpan.org|Data-Phrasebook-Loader-YAML|0.09|x86_64-linux-thread-multi|5.10.0|linux|2.6.26.3-fuuka.profvince.com|200901241528
3126615|pass|200901|vpit@cpan.org|Data-Phrasebook|0.29|x86_64-linux-thread-multi|5.10.0|linux|2.6.26.3-fuuka.profvince.com|200901241528
3126187|pass|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.55|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24.5-smp|200901241337
3126154|pass|200901|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24.5-smp|200901241331
3125449|pass|200901|rhaen@cpan.org (Ulrich Habel)|Games-Trackword|1.06|i386-netbsd-thread-multi|5.10.0|netbsd|5.0_beta|200901240914
3125448|pass|200901|rhaen@cpan.org (Ulrich Habel)|Calendar-List|0.21|i386-netbsd-thread-multi|5.10.0|netbsd|5.0_beta|200901240914
3123991|pass|200901|rhaen@cpan.org (Ulrich Habel)|WWW-Scraper-ISBN-ORA_Driver|0.09|i386-netbsd-thread-multi|5.10.0|netbsd|5.0_beta|200901240111
3121008|pass|200901|david@cantrell.org.uk|CPAN-WWW-Testers|0.46|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200901231508
3121007|pass|200901|david@cantrell.org.uk|CPAN-WWW-Testers|0.46|x86_64-linux-thread-multi|5.8.9|linux|2.6.18-4-xen-amd64|200901231508
3120829|pass|200901|srezic@cpan.org|CPAN-WWW-Testers|0.44|amd64-freebsd-thread-multi|5.10.0|freebsd|7.0-release|200901231522
3120712|pass|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.55|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.0-release|200901231353
3118892|pass|200901|srezic@cpan.org|CPAN-Testers-WWW-Statistics|0.55|amd64-freebsd-thread-multi|5.10.0|freebsd|7.0-release|200901230916
3118159|pass|200901|cpan@sourcentral.org ("Oliver Paukstadt")|Parse-CPAN-Distributions|0.05|s390x-linux|5.8.8|linux|2.6.18-92.1.18.el5|200901230657
3117234|pass|200901|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal-Thread|0.12|s390x-linux|5.8.8|linux|2.6.18-92.1.18.el5|200901230104
3117233|pass|200901|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal|0.22|s390x-linux|5.8.8|linux|2.6.18-92.1.18.el5|200901230104
3117002|pass|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.55|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.0-release|200901222200
3116913|pass|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.55|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.0-release|200901222148
3116496|pass|200901|vpit@cpan.org|CPAN-Testers-WWW-Statistics|0.55|x86_64-linux-thread-multi|5.10.0|linux|2.6.26.3-fuuka.profvince.com|200901222131
3114867|cpan|200901|BARBIE|CPAN-WWW-Testers|0.46||0|||200901221456
3114825|cpan|200901|BARBIE|CPAN-WWW-Testers|0.45||0|||200901221439
3114541|pass|200901|stro@cpan.org|CPAN-Testers-WWW-Statistics|0.55|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.00|200901221402
3114481|pass|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.55|i386-netbsd-thread-multi-64int|5.8.8|netbsd|4.0|200901221145
3114300|pass|200901|jeff@zeroclue.com|CPAN-Testers-Data-Generator|0.34|OpenBSD.i386-openbsd|5.8.9|openbsd|4.4|200901221035
3114294|pass|200901|jeff@zeroclue.com|CPAN-Testers-WWW-Statistics|0.54|OpenBSD.i386-openbsd|5.8.9|openbsd|4.4|200901221034
3112230|pass|200901|srezic@cpan.org|CPAN-Testers-WWW-Statistics|0.55|amd64-freebsd|5.10.0|freebsd|7.0-release|200901220037
3112126|pass|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.55|i386-netbsd-thread-multi-64int|5.8.9|netbsd|4.0|200901212313
3112103|pass|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.55|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0|200901212307
3111416|pass|200901|srezic@cpan.org|CPAN-WWW-Testers|0.44|amd64-freebsd|5.10.0|freebsd|7.0-release|200901212135
3111325|pass|200901|srezic@cpan.org|CPAN-Testers-WWW-Statistics|0.55|amd64-freebsd|5.8.9|freebsd|7.0-release|200901212102
3110750|pass|200901|jeff@zeroclue.com|CPAN-Testers-WWW-Statistics|0.55|darwin-2level|5.10.0|darwin|9.2.0|200901211022
3110729|pass|200901|srezic@cpan.org|CPAN-Testers-WWW-Statistics|0.55|amd64-freebsd|5.8.8|freebsd|7.0-release|200901211919
3110014|pass|200901|imacat@mail.imacat.idv.tw|CPAN-Testers-WWW-Statistics|0.55|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.24-etchnhalf.1-amd64|200901220011
3109560|pass|200901|stsc@refcnt.org ("Steven Schubiger")|CPAN-Testers-WWW-Statistics|0.55|i686-linux|5.10.0|linux|2.6.18-4-686|200901211516
3109435|pass|200901|JOST@cpan.org ("Josts Smokehouse")|CPAN-Testers-WWW-Statistics|0.55|i86pc-solaris-64int|5.10.0|solaris|2.11|200901211512
3109191|pass|200901|davidrw@cpan.org|CPAN-Testers-WWW-Statistics|0.55|i486-linux-gnu-thread-multi|5.8.8|linux|2.6.18.3|200901210747
3108606|pass|200901|david@cantrell.org.uk|CPAN-Testers-WWW-Statistics|0.55|alpha-netbsd|5.10.0|netbsd|4.0.1|200901211035
3108310|pass|200901|david@cantrell.org.uk|CPAN-Testers-WWW-Statistics|0.55|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200901210907
3108297|pass|200901|david@cantrell.org.uk|CPAN-Testers-WWW-Statistics|0.55|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200901210905
3108292|pass|200901|david@cantrell.org.uk|CPAN-Testers-WWW-Statistics|0.55|x86_64-linux-thread-multi|5.8.9|linux|2.6.18-4-xen-amd64|200901210904
3108005|pass|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.55|i386-netbsd-thread-multi-64int|5.8.9|netbsd|3.1|200901210805
3107989|pass|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.55|i386-netbsd-thread-multi-64int|5.8.8|netbsd|4.0|200901210801
3107740|pass|200901|jeff@zeroclue.com|CPAN-Testers-Common-DBUtils|0.03|OpenBSD.i386-openbsd|5.8.9|openbsd|4.4|200901210647
3107649|pass|200901|jeff@zeroclue.com|CPAN-Testers-WWW-Reports-Mailer|0.13|darwin-2level|5.10.0|darwin|9.2.0|200901210624
3106271|pass|200901|cpan@sourcentral.org ("Oliver Paukstadt")|Games-Trackword|1.06|s390x-linux-thread-multi|5.6.2|linux|2.6.16.60-0.31-default|200901210030
3106268|pass|200901|cpan@sourcentral.org ("Oliver Paukstadt")|Calendar-List|0.21|s390x-linux-thread-multi|5.6.2|linux|2.6.16.60-0.31-default|200901210030
3105793|cpan|200901|BARBIE|CPAN-Testers-WWW-Statistics|0.55||0|||200901202218
3105536|pass|200901|srezic@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.13|amd64-freebsd|5.10.0|freebsd|7.0-release|200901202122
3105101|pass|200901|davidrw@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.13|i486-linux-gnu-thread-multi|5.8.8|linux|2.6.18.3|200901201328
3104430|pass|200901|JOST@cpan.org ("Josts Smokehouse")|CPAN-Testers-WWW-Reports-Mailer|0.13|i86pc-solaris-64int|5.10.0|solaris|2.11|200901201737
3103215|pass|200901|david@cantrell.org.uk|CPAN-WWW-Testers|0.44|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200901200628
3103212|pass|200901|david@cantrell.org.uk|CPAN-WWW-Testers|0.44|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200901201227
3103206|pass|200901|david@cantrell.org.uk|CPAN-Testers-WWW-Reports-Mailer|0.13|x86_64-linux-thread-multi|5.10.0|linux|2.6.18-4-xen-amd64|200901201227
3103179|pass|200901|david@cantrell.org.uk|CPAN-Testers-WWW-Reports-Mailer|0.12|x86_64-linux-thread-multi|5.10.0|linux|2.6.18-4-xen-amd64|200901201219
3103174|pass|200901|david@cantrell.org.uk|CPAN-Testers-Common-DBUtils|0.03|x86_64-linux-thread-multi|5.10.0|linux|2.6.18-4-xen-amd64|200901201219
3103090|pass|200901|stsc@refcnt.org ("Steven Schubiger")|CPAN-WWW-Testers|0.44|i686-linux|5.10.0|linux|2.6.18-4-686|200901201308
3103032|pass|200901|david@cantrell.org.uk|CPAN-Testers-WWW-Reports-Mailer|0.12|alpha-netbsd|5.10.0|netbsd|4.0.1|200901201202
3102994|pass|200901|david@cantrell.org.uk|CPAN-Testers-WWW-Reports-Mailer|0.13|x86_64-linux-thread-multi|5.8.9|linux|2.6.18-4-xen-amd64|200901201155
3102818|pass|200901|david@cantrell.org.uk|CPAN-Testers-WWW-Reports-Mailer|0.13|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200901200520
3102817|pass|200901|david@cantrell.org.uk|CPAN-Testers-WWW-Reports-Mailer|0.13|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200901201119
3102815|pass|200901|david@cantrell.org.uk|CPAN-Testers-WWW-Reports-Mailer|0.13|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200901201119
3102812|pass|200901|david@cantrell.org.uk|CPAN-Testers-WWW-Reports-Mailer|0.12|x86_64-linux-thread-multi|5.8.9|linux|2.6.18-4-xen-amd64|200901201119
3102808|pass|200901|david@cantrell.org.uk|CPAN-Testers-Common-DBUtils|0.03|x86_64-linux-thread-multi|5.8.9|linux|2.6.18-4-xen-amd64|200901201119
3102763|pass|200901|david@cantrell.org.uk|CPAN-Testers-WWW-Reports-Mailer|0.12|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200901200506
3102762|pass|200901|david@cantrell.org.uk|CPAN-Testers-WWW-Reports-Mailer|0.12|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200901201105
3102758|pass|200901|david@cantrell.org.uk|CPAN-Testers-WWW-Reports-Mailer|0.12|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200901201105
3102664|pass|200901|stsc@refcnt.org ("Steven Schubiger")|CPAN-Testers-WWW-Reports-Mailer|0.13|i686-linux|5.10.0|linux|2.6.18-4-686|200901201141
3102555|pass|200901|bingos@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.13|i386-netbsd-thread-multi-64int|5.8.8|netbsd|4.0.1|200901201009
3102550|pass|200901|bingos@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.12|i386-netbsd-thread-multi-64int|5.8.8|netbsd|4.0.1|200901201008
3102529|pass|200901|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-netbsd-thread-multi-64int|5.8.8|netbsd|4.0.1|200901201004
3102442|pass|200901|jeff@zeroclue.com|CPAN-Testers-Common-DBUtils|0.03|OpenBSD.i386-openbsd|5.8.9|openbsd|4.4|200901200944
3100337|pass|200901|rhaen@cpan.org (Ulrich Habel)|Test-YAML-Meta|0.11|i386-netbsd-thread-multi|5.10.0|netbsd|5.0_beta|200901200022
3099844|pass|200901|davidrw@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.12|i486-linux-gnu-thread-multi|5.8.8|linux|2.6.18.3|200901191822
3099356|pass|200901|srezic@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.13|amd64-freebsd|5.8.9|freebsd|7.0-release|200901192252
3099354|pass|200901|srezic@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.13|amd64-freebsd|5.8.8|freebsd|7.0-release|200901192252
3098688|cpan|200901|BARBIE|CPAN-Testers-WWW-Reports-Mailer|0.13||0|||200901192108
3097789|pass|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.54|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0.1|200901191838
3097710|pass|200901|bingos@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.11|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0.1|200901191833
3097621|pass|200901|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0.1|200901191827
3097561|pass|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.54|i386-netbsd-thread-multi-64int|5.8.9|netbsd|4.0.1|200901191820
3097549|pass|200901|vpit@cpan.org|CPAN-Testers-WWW-Statistics|0.54|x86_64-linux-thread-multi|5.10.0|linux|2.6.26.3-fuuka.profvince.com|200901191922
3097545|pass|200901|vpit@cpan.org|CPAN-Testers-Common-DBUtils|0.03|x86_64-linux-thread-multi|5.10.0|linux|2.6.26.3-fuuka.profvince.com|200901191921
3097468|pass|200901|bingos@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.11|i386-netbsd-thread-multi-64int|5.8.9|netbsd|4.0.1|200901191814
3097406|pass|200901|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-netbsd-thread-multi-64int|5.8.9|netbsd|4.0.1|200901191807
3097326|pass|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.54|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.21.5-smp|200901191751
3097272|pass|200901|srezic@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.12|amd64-freebsd|5.8.9|freebsd|7.0-release|200901191810
3097194|pass|200901|cpan@sourcentral.org ("Oliver Paukstadt")|Data-FormValidator-Constraints-Words|0.03|s390x-linux-thread-multi|5.10.0|linux|2.6.18-92.el5|200901191839
3096998|pass|200901|cpan@sourcentral.org ("Oliver Paukstadt")|Data-FormValidator-Constraints-Words|0.03|s390x-linux|5.10.0|linux|2.6.18-92.el5|200901191817
3096967|pass|200901|srezic@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.12|amd64-freebsd|5.8.8|freebsd|7.0-release|200901191810
3096412|pass|200901|stsc@refcnt.org ("Steven Schubiger")|CPAN-Testers-WWW-Reports-Mailer|0.11|i686-linux|5.10.0|linux|2.6.18-4-686|200901191637
3095709|pass|200901|JOST@cpan.org ("Josts Smokehouse")|CPAN-Testers-WWW-Reports-Mailer|0.11|i86pc-solaris-64int|5.10.0|solaris|2.11|200901191507
3095461|pass|200901|davidrw@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.11|i486-linux-gnu-thread-multi|5.8.8|linux|2.6.18.3|200901190809
3095281|cpan|200901|BARBIE|CPAN-WWW-Testers|0.44||0|||200901191324
3095212|cpan|200901|BARBIE|CPAN-Testers-WWW-Reports-Mailer|0.12||0|||200901191313
3094905|pass|200901|vpit@cpan.org|CPAN-WWW-Testers|0.43|i686-linux-thread-multi|5.10.0|linux|2.6.18.3-tmb-desktop-2mdvsmp|200901191224
3094834|pass|200901|david@cantrell.org.uk|CPAN-Testers-WWW-Reports-Mailer|0.11|alpha-netbsd|5.10.0|netbsd|4.0.1|200901191107
3094832|pass|200901|david@cantrell.org.uk|CPAN-Testers-WWW-Reports-Mailer|0.11|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200901191107
3094825|pass|200901|david@cantrell.org.uk|CPAN-Testers-Common-DBUtils|0.03|alpha-netbsd|5.10.0|netbsd|4.0.1|200901191106
3094791|pass|200901|david@cantrell.org.uk|CPAN-Testers-WWW-Reports-Mailer|0.11|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200901190459
3094529|pass|200901|rhaen@cpan.org (Ulrich Habel)|Mail-Outlook|0.14|i386-netbsd-thread-multi|5.10.0|netbsd|5.0_beta|200901191001
3094287|pass|200901|david@cantrell.org.uk|CPAN-Testers-WWW-Reports-Mailer|0.11|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200901190859
3094282|pass|200901|david@cantrell.org.uk|CPAN-Testers-WWW-Reports-Mailer|0.11|x86_64-linux-thread-multi|5.10.0|linux|2.6.18-4-xen-amd64|200901190859
3094279|pass|200901|david@cantrell.org.uk|CPAN-Testers-WWW-Reports-Mailer|0.11|x86_64-linux-thread-multi|5.8.9|linux|2.6.18-4-xen-amd64|200901190859
3094277|pass|200901|david@cantrell.org.uk|CPAN-Testers-Common-DBUtils|0.03|x86_64-linux-thread-multi|5.10.0|linux|2.6.18-4-xen-amd64|200901190859
3094276|pass|200901|david@cantrell.org.uk|CPAN-Testers-Common-DBUtils|0.03|x86_64-linux-thread-multi|5.8.9|linux|2.6.18-4-xen-amd64|200901190859
3094055|pass|200901|imacat@mail.imacat.idv.tw|CPAN-Testers-WWW-Reports-Mailer|0.11|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.24-etchnhalf.1-amd64|200901191618
3093856|pass|200901|srezic@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.11|amd64-freebsd|5.8.9|freebsd|7.0-release|200901190829
3093854|pass|200901|srezic@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.11|amd64-freebsd|5.8.8|freebsd|7.0-release|200901190829
3093794|pass|200901|rhaen@cpan.org (Ulrich Habel)|WWW-UsePerl-Journal-Thread|0.12|i386-netbsd-thread-multi|5.10.0|netbsd|5.0_beta|200901190719
3093793|pass|200901|rhaen@cpan.org (Ulrich Habel)|WWW-UsePerl-Journal|0.22|i386-netbsd-thread-multi|5.10.0|netbsd|5.0_beta|200901190719
3092512|pass|200901|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|MirBSD.i386-mirbsd-thread-multi-64int|5.8.9|mirbsd|10|200901182356
3091968|cpan|200901|BARBIE|CPAN-Testers-WWW-Reports-Mailer|0.11||0|||200901182252
3091952|pass|200901|davidrw@cpan.org|CPAN-Testers-Data-Generator|0.34|i486-linux-gnu-thread-multi|5.8.8|linux|2.6.18.3|200901181647
3091946|pass|200901|davidrw@cpan.org|CPAN-Testers-WWW-Statistics|0.54|i486-linux-gnu-thread-multi|5.8.8|linux|2.6.18.3|200901181646
3090779|pass|200901|stsc@refcnt.org ("Steven Schubiger")|Data-Phrasebook-Loader-DBI|0.11|i686-linux|5.10.0|linux|2.6.18-4-686|200901181857
3090767|pass|200901|stsc@refcnt.org ("Steven Schubiger")|Data-Phrasebook-Loader-Ini|0.10|i686-linux|5.10.0|linux|2.6.18-4-686|200901181855
3090754|pass|200901|stsc@refcnt.org ("Steven Schubiger")|Data-Phrasebook-Loader-XML|0.12|i686-linux|5.10.0|linux|2.6.18-4-686|200901181852
3090542|pass|200901|stsc@refcnt.org ("Steven Schubiger")|Mail-File|0.08|i686-linux|5.10.0|linux|2.6.18-4-686|200901181824
3089291|fail|200901|vrurg@otoib.dp.ua|Finance-Currency-Convert-XE|0.15|i386-freebsd-64int|5.8.8|freebsd|7.0-release|200901161558
3089176|pass|200901|nothingmuch@woobling.org|CPAN-WWW-Testers|0.43|darwin-2level|5.10.0|darwin|9.5.0|200901172112
3088656|pass|200901|stsc@refcnt.org ("Steven Schubiger")|CPAN-YACSmoke-Plugin-Outlook|0.06|i686-linux|5.10.0|linux|2.6.18-4-686|200901181423
3088644|fail|200901|stsc@refcnt.org ("Steven Schubiger")|CPAN-YACSmoke-Plugin-WebList|0.05|i686-linux|5.10.0|linux|2.6.18-4-686|200901181420
3088610|pass|200901|stsc@refcnt.org ("Steven Schubiger")|CPAN-YACSmoke-Plugin-NNTP|0.05|i686-linux|5.10.0|linux|2.6.18-4-686|200901181416
3088598|pass|200901|stsc@refcnt.org ("Steven Schubiger")|CPAN-YACSmoke-Plugin-NNTPWeb|0.06|i686-linux|5.10.0|linux|2.6.18-4-686|200901181413
3087765|pass|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.54|i386-netbsd-thread-multi-64int|5.8.9|netbsd|3.1|200901180958
3083718|pass|200901|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|MirBSD.i386-mirbsd-thread-multi-64int|5.10.0|mirbsd|10|200901171827
3080417|pass|200901|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|MirBSD.i386-mirbsd-thread-multi-64int|5.8.8|mirbsd|10|200901170117
3079417|pass|200901|bingos@cpan.org|Test-YAML-Meta|0.11|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.1-release|200901162015
3076616|pass|200901|bingos@cpan.org|Test-YAML-Meta|0.11|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.1-release|200901160836
3074438|fail|200901|imacat@mail.imacat.idv.tw|Finance-Currency-Convert-XE|0.15|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.24-etchnhalf.1-amd64|200901160600
3072714|pass|200901|davidrw@cpan.org|CPAN-WWW-Testers|0.43|i486-linux-gnu-thread-multi|5.8.8|linux|2.6.18-6-686|200901150921
3072052|pass|200901|sartak@gmail.com|Test-YAML-Meta|0.11|darwin-2level|5.8.8|darwin|9.5.0|200901141112
3071547|pass|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.54|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.0-release|200901150807
3071483|pass|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.54|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.0-release|200901150741
3069852|pass|200901|srezic@cpan.org|CPAN-WWW-Testers|0.43|amd64-freebsd-thread-multi|5.10.0|freebsd|7.0-release|200901150043
3069155|pass|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.54|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.0-release|200901142144
3069112|pass|200901|bingos@cpan.org|Test-YAML-Meta|0.11|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.1-release|200901141303
3068593|pass|200901|srezic@cpan.org|CPAN-WWW-Testers|0.43|amd64-freebsd|5.10.0|freebsd|7.0-release|200901142008
3068541|pass|200901|vpit@cpan.org|CPAN-Testers-WWW-Statistics|0.54|x86_64-linux-thread-multi|5.10.0|linux|2.6.26.3-fuuka.profvince.com|200901141955
3067194|pass|200901|david@cantrell.org.uk|CPAN-WWW-Testers|0.43|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200901140813
3067063|pass|200901|david@cantrell.org.uk|CPAN-WWW-Testers|0.43|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200901141311
3067002|pass|200901|david@cantrell.org.uk|CPAN-WWW-Testers|0.43|i686-linux|5.8.8|linux|2.4.27-3-686|200901141253
3066688|pass|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.54|i386-netbsd-thread-multi-64int|5.8.8|netbsd|4.0|200901141136
3066502|pass|200901|stro@cpan.org|CPAN-Testers-WWW-Statistics|0.54|MSWin32-x86-multi-thread|5.8.8|MSWin32|5.00|200901141222
3066501|pass|200901|stro@cpan.org|CPAN-Testers-Data-Generator|0.34|MSWin32-x86-multi-thread|5.8.8|MSWin32|5.00|200901141222
3064369|pass|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.54|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0|200901140020
3064315|pass|200901|bingos@cpan.org|CPAN-Testers-WWW-Statistics|0.54|i386-netbsd-thread-multi-64int|5.8.9|netbsd|4.0|200901140007
3063820|cpan|200901|BARBIE|CPAN-WWW-Testers|0.43||0|||200901132314
3061634|pass|200901|bingos@cpan.org|Test-YAML-Meta|0.11|i386-netbsd-thread-multi-64int|5.8.9|netbsd|3.1|200901131428
3061485|pass|200901|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.1-release|200901131117
3061455|pass|200901|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|OpenBSD.i386-openbsd-thread-multi-64int|5.8.9|openbsd|4.2|200901131404
3061296|pass|200901|imacat@mail.imacat.idv.tw|CPAN-Testers-WWW-Statistics|0.54|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.24-etchnhalf.1-amd64|200901132141
3060302|pass|200901|david@cantrell.org.uk|CPAN-Testers-WWW-Statistics|0.54|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200901131057
3060061|pass|200901|david@cantrell.org.uk|CPAN-Testers-WWW-Statistics|0.54|i686-linux|5.8.8|linux|2.4.27-3-686|200901130959
3060051|pass|200901|david@cantrell.org.uk|CPAN-Testers-WWW-Statistics|0.54|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200901130957
3057036|pass|200901|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|OpenBSD.i386-openbsd-thread-multi-64int|5.10.0|openbsd|4.2|200901130041
3056785|pass|200901|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|OpenBSD.i386-openbsd-thread-multi-64int|5.8.8|openbsd|4.2|200901122356
3056591|pass|200901|stro@cpan.org|CPAN-Testers-WWW-Statistics|0.54|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.00|200901130118
3056556|pass|200901|stro@cpan.org|CPAN-Testers-Data-Generator|0.34|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.00|200901130110
3056486|pass|200901|JOST@cpan.org ("Josts Smokehouse")|CPAN-Testers-Data-Generator|0.34|i86pc-solaris-64int|5.10.0|solaris|2.11|200901130019
3056482|pass|200901|JOST@cpan.org ("Josts Smokehouse")|CPAN-Testers-WWW-Statistics|0.54|i86pc-solaris-64int|5.10.0|solaris|2.11|200901130019
3055683|pass|200901|bingos@cpan.org|WWW-UsePerl-Journal-Thread|0.12|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.21.5-smp|200901122053
3055678|pass|200901|bingos@cpan.org|WWW-UsePerl-Journal|0.22|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.21.5-smp|200901122053
3055603|pass|200901|bingos@cpan.org|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.21.5-smp|200901122044
3055593|pass|200901|bingos@cpan.org|WWW-Scraper-ISBN-Pearson_Driver|0.10|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.21.5-smp|200901122044
3055586|pass|200901|bingos@cpan.org|WWW-Scraper-ISBN-ORA_Driver|0.09|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.21.5-smp|200901122043
3055572|fail|200901|bingos@cpan.org|WWW-Scraper-ISBN-Amazon_Driver|0.14|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.21.5-smp|200901122041
3055184|pass|200901|cpan@sourcentral.org ("Oliver Paukstadt")|Games-Trackword|1.06|s390x-linux|5.10.0|linux|2.6.18-92.el5|200901122057
3055157|pass|200901|cpan@sourcentral.org ("Oliver Paukstadt")|Calendar-List|0.21|s390x-linux|5.10.0|linux|2.6.18-92.el5|200901122056
3054740|pass|200901|srezic@cpan.org|CPAN-Testers-Data-Generator|0.34|amd64-freebsd-thread-multi|5.10.0|freebsd|7.0-release|200901122013
3054109|pass|200901|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.1-release|200901121754
3053826|pass|200901|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.1-release|200901121717
3053530|pass|200901|srezic@cpan.org|CPAN-Testers-WWW-Statistics|0.54|amd64-freebsd|5.10.0|freebsd|7.0-release|200901121724
3053529|pass|200901|srezic@cpan.org|CPAN-Testers-Data-Generator|0.34|amd64-freebsd|5.10.0|freebsd|7.0-release|200901121724
3053474|pass|200901|bingos@cpan.org|Test-CPAN-Meta|0.12|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.21.5-smp|200901121613
3052765|pass|200901|srezic@cpan.org|CPAN-Testers-WWW-Statistics|0.54|amd64-freebsd|5.8.9|freebsd|7.0-release|200901121515
3052764|pass|200901|srezic@cpan.org|CPAN-Testers-Data-Generator|0.34|amd64-freebsd|5.8.9|freebsd|7.0-release|200901121515
3052676|pass|200901|srezic@cpan.org|CPAN-Testers-Data-Generator|0.34|amd64-freebsd|5.8.8|freebsd|7.0-release|200901121458
3052675|pass|200901|srezic@cpan.org|CPAN-Testers-WWW-Statistics|0.54|amd64-freebsd|5.8.8|freebsd|7.0-release|200901121458
3052585|pass|200901|bingos@cpan.org|Regexp-Log-Common|0.05|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.21.5-smp|200901121336
3052403|pass|200901|vpit@cpan.org|CPAN-WWW-Testers|0.42|i686-linux-thread-multi|5.10.0|linux|2.6.18.3-tmb-desktop-2mdvsmp|200901121355
3052324|cpan|200901|BARBIE|CPAN-Testers-WWW-Statistics|0.54||0|||200901121338
3052213|cpan|200901|BARBIE|CPAN-Testers-Data-Generator|0.34||0|||200901121310
3051861|pass|200901|bingos@cpan.org|Parse-CPAN-Distributions|0.05|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.21.5-smp|200901121024
3050831|pass|200901|bingos@cpan.org|Mail-File|0.08|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.21.5-smp|200901120708
3049557|pass|200901|bingos@cpan.org|GD-Chart-Radial|0.07|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.21.5-smp|200901120241
3049536|pass|200901|bingos@cpan.org|Games-Trackword|1.06|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.21.5-smp|200901120227
3048751|pass|200901|cpan@sourcentral.org ("Oliver Paukstadt")|Data-FormValidator-Constraints-Words|0.03|s390x-linux-thread-multi|5.10.0|linux|2.6.16.60-0.31-default|200901120112
3048746|pass|200901|cpan@sourcentral.org ("Oliver Paukstadt")|Data-FormValidator-Constraints-Words|0.03|s390x-linux|5.10.0|linux|2.6.16.60-0.31-default|200901120111
3048558|pass|200901|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-netbsd-thread-multi-64int|5.8.9|netbsd|3.1|200901112336
3048441|pass|200901|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.21.5-smp|200901112312
3048439|pass|200901|bingos@cpan.org|Data-Phrasebook-Loader-XML|0.12|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.21.5-smp|200901112311
3048438|pass|200901|bingos@cpan.org|Data-Phrasebook-Loader-Ini|0.10|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.21.5-smp|200901112311
3048436|pass|200901|bingos@cpan.org|Data-Phrasebook-Loader-DBI|0.11|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.21.5-smp|200901112311
3048434|pass|200901|bingos@cpan.org|Data-Phrasebook|0.29|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.21.5-smp|200901112310
3048419|pass|200901|bingos@cpan.org|Data-FormValidator-Constraints-Words|0.03|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.21.5-smp|200901112306
3048141|pass|200901|bingos@cpan.org|CPAN-YACSmoke-Plugin-NNTP|0.05|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.21.5-smp|200901112155
3048132|pass|200901|bingos@cpan.org|CPAN-WWW-Testers-Generator|0.30|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.21.5-smp|200901112154
3047350|pass|200901|bingos@cpan.org|Calendar-List|0.21|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.21.5-smp|200901111947
3046764|pass|200901|davidrw@cpan.org|Data-Phrasebook-Loader-DBI|0.11|i486-linux-gnu-thread-multi|5.8.8|linux|2.6.18.3|200901111246
3046760|pass|200901|davidrw@cpan.org|Data-Phrasebook-Loader-Ini|0.10|i486-linux-gnu-thread-multi|5.8.8|linux|2.6.18.3|200901111246
3046740|pass|200901|davidrw@cpan.org|Mail-File|0.08|i486-linux-gnu-thread-multi|5.8.8|linux|2.6.18.3|200901111242
3046582|pass|200901|davidrw@cpan.org|CPAN-YACSmoke-Plugin-Outlook|0.06|i486-linux-gnu-thread-multi|5.8.8|linux|2.6.18.3|200901111210
3046581|pass|200901|davidrw@cpan.org|CPAN-YACSmoke-Plugin-NNTP|0.05|i486-linux-gnu-thread-multi|5.8.8|linux|2.6.18.3|200901111209
3046184|pass|200901|cpan@sourcentral.org ("Oliver Paukstadt")|Games-Trackword|1.06|s390x-linux-thread-multi|5.6.2|linux|2.6.18-92.1.18.el5|200901111641
3046183|pass|200901|cpan@sourcentral.org ("Oliver Paukstadt")|Calendar-List|0.21|s390x-linux-thread-multi|5.6.2|linux|2.6.18-92.1.18.el5|200901111640
3044186|pass|200901|bingos@cpan.org|Test-YAML-Meta|0.11|i386-freebsd-thread-multi-64int|5.8.8|freebsd|6.4-release|200901110105
3043869|pass|200901|cpan@sourcentral.org ("Oliver Paukstadt")|Games-Trackword|1.06|s390x-linux|5.6.2|linux|2.6.18-92.1.18.el5|200901110329
3043867|pass|200901|cpan@sourcentral.org ("Oliver Paukstadt")|Calendar-List|0.21|s390x-linux|5.6.2|linux|2.6.18-92.1.18.el5|200901110329
3043456|pass|200901|david@cantrell.org.uk|CPAN-WWW-Testers|0.42|i686-linux-thread-multi|5.10.0|linux|2.4.27-3-686|200901110009
3043328|pass|200901|david@cantrell.org.uk|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.10.0|linux|2.4.27-3-686|200901102344
3043223|pass|200901|david@cantrell.org.uk|CPAN-WWW-Testers|0.42|i686-linux|5.8.8|linux|2.4.27-3-686|200901102326
3043218|pass|200901|david@cantrell.org.uk|CPAN-WWW-Testers|0.42|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200901101727
3043216|pass|200901|david@cantrell.org.uk|CPAN-WWW-Testers|0.42|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200901102327
3043214|pass|200901|david@cantrell.org.uk|CPAN-Testers-Common-DBUtils|0.03|IP35-irix|5.8.8|irix|6.5|200901110027
3041170|pass|200901|bingos@cpan.org|Test-YAML-Meta|0.11|i386-freebsd-thread-multi-64int|5.8.9|freebsd|6.4-release|200901101516
3039409|pass|200901|nothingmuch@woobling.org|CPAN-Testers-Common-DBUtils|0.03|darwin-2level|5.10.0|darwin|9.5.0|200901100653
3039279|pass|200901|nothingmuch@woobling.org|CPAN-WWW-Testers|0.42|darwin-2level|5.10.0|darwin|9.5.0|200901100655
3036271|pass|200901|davidrw@cpan.org|CPAN-WWW-Testers|0.42|i486-linux-gnu-thread-multi|5.8.8|linux|2.6.18-6-686|200901100032
3036265|pass|200901|davidrw@cpan.org|CPAN-WWW-Testers|0.41|i486-linux-gnu-thread-multi|5.8.8|linux|2.6.18-6-686|200901100031
3036037|pass|200901|srezic@cpan.org|CPAN-WWW-Testers|0.42|amd64-freebsd-thread-multi|5.10.0|freebsd|7.0-release|200901100047
3035215|pass|200901|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-freebsd-thread-multi-64int|5.8.8|freebsd|6.4-release|200901092059
3034843|pass|200901|srezic@cpan.org|CPAN-WWW-Testers|0.42|amd64-freebsd|5.10.0|freebsd|7.0-release|200901092147
3034228|pass|200901|cpan@sourcentral.org ("Oliver Paukstadt")|Games-Trackword|1.06|s390x-linux|5.6.2|linux|2.6.16.60-0.31-default|200901091939
3034224|pass|200901|cpan@sourcentral.org ("Oliver Paukstadt")|Calendar-List|0.21|s390x-linux|5.6.2|linux|2.6.16.60-0.31-default|200901091938
3032625|pass|200901|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.12|s390x-linux-thread-multi|5.6.2|linux|2.6.18-92.1.18.el5|200901091552
3032431|cpan|200901|BARBIE|CPAN-WWW-Testers|0.42||0|||200901091513
3031482|pass|200901|bingos@cpan.org|Test-YAML-Meta|0.11|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.16.38|200901090847
3031481|pass|200901|bingos@cpan.org|Test-YAML-Meta|0.11|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.16.38|200901090847
3031239|pass|200901|david@cantrell.org.uk|CPAN-WWW-Testers|0.41|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200901090309
3030035|pass|200901|davidrw@cpan.org|Data-FormValidator-Constraints-Words|0.03|i486-linux-gnu-thread-multi|5.8.8|linux|2.6.18.3|200901090039
3029345|pass|200901|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.12|s390x-linux|5.6.2|linux|2.6.18-92.1.18.el5|200901090424
3028567|pass|200901|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-freebsd-thread-multi-64int|5.10.0|freebsd|6.4-release|200901090056
3028344|pass|200901|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-freebsd-thread-multi-64int|5.8.9|freebsd|6.4-release|200901090028
3027881|pass|200901|david@cantrell.org.uk|CPAN-WWW-Testers|0.41|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200901082327
3027375|pass|200901|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.12|s390x-linux|5.6.2|linux|2.6.16.60-0.31-default|200901082257
3026466|pass|200901|david@cantrell.org.uk|CPAN-WWW-Testers|0.41|i686-linux|5.8.8|linux|2.4.27-3-686|200901081928
3025994|pass|200901|davidrw@cpan.org|Games-Trackword|1.06|i486-linux-gnu-thread-multi|5.8.8|linux|2.6.18.3|200901081229
3025992|pass|200901|davidrw@cpan.org|Calendar-List|0.21|i486-linux-gnu-thread-multi|5.8.8|linux|2.6.18.3|200901081229
3025648|pass|200901|JOST@cpan.org ("Josts Smokehouse")|CPAN-WWW-Testers|0.41|i86pc-solaris-64int|5.10.0|solaris|2.11|200901081745
3025030|pass|200901|davidrw@cpan.org|Test-CPAN-Meta|0.12|i486-linux-gnu-thread-multi|5.8.8|linux|2.6.18.3|200901080847
3024969|pass|200901|stsc@refcnt.org ("Steven Schubiger")|CPAN-WWW-Testers|0.41|i686-linux|5.10.0|linux|2.6.18-4-686|200901081408
3024800|pass|200901|vpit@cpan.org|CPAN-WWW-Testers|0.41|i686-linux-thread-multi|5.10.0|linux|2.6.18.3-tmb-desktop-2mdvsmp|200901081308
3024678|pass|200901|imacat@mail.imacat.idv.tw|CPAN-WWW-Testers|0.41|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.24-etchnhalf.1-amd64|200901081929
3024207|pass|200901|cpan.dcollins.589@gmail.com|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.8.9|linux|2.6.24-19-generic|200901080419
3023770|pass|200901|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.16.38|200901080733
3023768|pass|200901|bingos@cpan.org|Data-Phrasebook|0.29|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.16.38|200901080733
3023762|pass|200901|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.16.38|200901080731
3023761|pass|200901|bingos@cpan.org|Data-Phrasebook|0.29|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.16.38|200901080730
3022226|pass|200901|srezic@cpan.org|CPAN-WWW-Testers|0.41|amd64-freebsd-thread-multi|5.10.0|freebsd|7.0-release|200901080133
3021967|pass|200901|srezic@cpan.org|CPAN-WWW-Testers|0.41|amd64-freebsd|5.8.9|freebsd|7.0-release|200901080049
3021963|pass|200901|srezic@cpan.org|CPAN-WWW-Testers|0.41|amd64-freebsd|5.8.8|freebsd|7.0-release|200901080049
3021922|pass|200901|srezic@cpan.org|CPAN-WWW-Testers|0.41|amd64-freebsd|5.10.0|freebsd|7.0-release|200901080044
3021277|pass|200901|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.26.3-29.fc9.i686|200901072221
3021245|pass|200901|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.26.3-29.fc9.i686|200901072214
3021074|cpan|200901|BARBIE|CPAN-WWW-Testers|0.41||0|||200901072251
3020365|pass|200901|bingos@cpan.org|Test-YAML-Meta|0.11|i86pc-solaris-thread-multi-64int|5.8.9|solaris|2.10|200901072005
3017356|pass|200901|cpan.dcollins.5100rc2@gmail.com|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200901070607
3017208|pass|200901|cpan.dcollins.5100rc2@gmail.com|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200901070531
3017206|pass|200901|cpan.dcollins.5100rc2@gmail.com|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200901070531
3016304|pass|200901|bingos@cpan.org|Test-YAML-Meta|0.11|i386-dragonfly-64int|5.8.8|dragonfly|2.0.0-release|200901070852
3015833|pass|200901|bingos@cpan.org|Test-YAML-Meta|0.11|i386-dragonfly-64int|5.10.0|dragonfly|2.0.0-release|200901070742
3015335|pass|200901|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i386-dragonfly-64int|5.8.9|dragonfly|2.0.0-release|200901070452
3015333|pass|200901|bingos@cpan.org|Data-Phrasebook|0.29|i386-dragonfly-64int|5.8.9|dragonfly|2.0.0-release|200901070451
3013964|pass|200901|amoore@cpan.org|Test-YAML-Meta|0.11|x86_64-linux-gnu-thread-multi|5.8.8|linux|2.6.26-1-vserver-amd64|200901061008
3013566|pass|200901|davidrw@cpan.org|Mail-Outlook|0.14|i486-linux-gnu-thread-multi|5.8.8|linux|2.6.18.3|200901061752
3013549|pass|200901|davidrw@cpan.org|Parse-CPAN-Distributions|0.05|i486-linux-gnu-thread-multi|5.8.8|linux|2.6.18.3|200901061748
3013520|pass|200901|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i86pc-solaris-thread-multi-64int|5.8.9|solaris|2.10|200901062244
3013518|pass|200901|bingos@cpan.org|Data-Phrasebook|0.29|i86pc-solaris-thread-multi-64int|5.8.9|solaris|2.10|200901062243
3013455|pass|200901|bingos@cpan.org|Test-YAML-Meta|0.11|i86pc-solaris-thread-multi-64int|5.8.8|solaris|2.10|200901062234
3012503|pass|200901|davidrw@cpan.org|WWW-UsePerl-Journal-Thread|0.12|i486-linux-gnu-thread-multi|5.8.8|linux|2.6.18.3|200901061533
3012502|pass|200901|davidrw@cpan.org|WWW-UsePerl-Journal|0.22|i486-linux-gnu-thread-multi|5.8.8|linux|2.6.18.3|200901061533
3011998|pass|200901|davidrw@cpan.org|CPAN-WWW-Testers-Generator|0.30|i486-linux-gnu-thread-multi|5.8.8|linux|2.6.18.3|200901061441
3010831|pass|200901|cpan.dcollins.s1@gmail.com|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200901061258
3010830|pass|200901|cpan.dcollins.s1@gmail.com|Data-Phrasebook|0.29|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200901061257
3010752|pass|200901|cpan.dcollins.5100@gmail.com|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200901061247
3010751|pass|200901|cpan.dcollins.5100@gmail.com|Data-Phrasebook|0.29|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200901061247
3010213|pass|200901|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-dragonfly-64int|5.8.9|dragonfly|2.0.0-release|200901061652
3009249|pass|200901|bingos@cpan.org|Test-YAML-Meta|0.11|i86pc-solaris-thread-multi-64int|5.8.4|solaris|2.10|200901061508
3008773|pass|200901|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i86pc-solaris-thread-multi-64int|5.8.9|solaris|2.10|200901061419
3007965|pass|200901|cpan.dcollins.s2@gmail.com|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200901060731
3007927|pass|200901|cpan.dcollins.s1@gmail.com|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200901060724
3007333|pass|200901|vpit@cpan.org|CPAN-WWW-Testers|0.40|i686-linux-thread-multi|5.10.0|linux|2.6.18.3-tmb-desktop-2mdvsmp|200901061159
3007306|pass|200901|vpit@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.10.0|linux|2.6.18.3-tmb-desktop-2mdvsmp|200901061152
3006476|pass|200901|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i86pc-solaris-thread-multi-64int|5.8.8|solaris|2.10|200901060830
3006475|pass|200901|bingos@cpan.org|Data-Phrasebook|0.29|i86pc-solaris-thread-multi-64int|5.8.8|solaris|2.10|200901060829
3006161|pass|200901|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i86pc-solaris-thread-multi-64int|5.8.4|solaris|2.10|200901060729
3006158|pass|200901|bingos@cpan.org|Data-Phrasebook|0.29|i86pc-solaris-thread-multi-64int|5.8.4|solaris|2.10|200901060729
3006030|pass|200901|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i386-dragonfly-64int|5.8.8|dragonfly|2.0.0-release|200901060709
3006028|pass|200901|bingos@cpan.org|Data-Phrasebook|0.29|i386-dragonfly-64int|5.8.8|dragonfly|2.0.0-release|200901060709
3005832|pass|200901|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i386-dragonfly-64int|5.10.0|dragonfly|2.0.0-release|200901060635
3005830|pass|200901|bingos@cpan.org|Data-Phrasebook|0.29|i386-dragonfly-64int|5.10.0|dragonfly|2.0.0-release|200901060634
3003872|pass|200901|davidrw@cpan.org|Regexp-Log-Common|0.05|i486-linux-gnu-thread-multi|5.8.8|linux|2.6.18.3|200901060213
3003818|pass|200901|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.12|s390x-linux-thread-multi|5.6.2|linux|2.6.16.60-0.31-default|200901060302
3003229|pass|200901|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-dragonfly-64int|5.8.8|dragonfly|2.0.0-release|200901060103
3002998|pass|200901|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-dragonfly-64int|5.10.0|dragonfly|2.0.0-release|200901060036
3002477|pass|200901|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i86pc-solaris-thread-multi-64int|5.8.8|solaris|2.10|200901052348
3002307|pass|200901|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i86pc-solaris-thread-multi-64int|5.8.4|solaris|2.10|200901052342
3001676|pass|200901|vpit@cpan.org|CPAN-Testers-Common-DBUtils|0.03|x86_64-linux-thread-multi|5.10.0|linux|2.6.26.3-fuuka.profvince.com|200901052349
3000184|pass|200901|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i86pc-solaris-thread-multi-64int|5.10.0|solaris|2.10|200901051929
3000181|pass|200901|bingos@cpan.org|Data-Phrasebook|0.29|i86pc-solaris-thread-multi-64int|5.10.0|solaris|2.10|200901051929
2998257|pass|200901|cpan.dcollins.5100rc1@gmail.com|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200901050944
2998256|pass|200901|cpan.dcollins.5100rc1@gmail.com|Data-Phrasebook|0.29|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200901050944
2997269|pass|200901|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i86pc-solaris-thread-multi-64int|5.10.0|solaris|2.10|200901051203
2995860|pass|200901|vutral@gmail.com|Test-YAML-Meta|0.11|x86_64-linux-gnu-thread-multi|5.8.8|linux|2.6.26-1-vserver-amd64|200901042304
2995350|pass|200901|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i386-dragonfly-64int|5.8.9|dragonfly|2.0.1-release|200901050311
2995349|pass|200901|bingos@cpan.org|Data-Phrasebook|0.29|i386-dragonfly-64int|5.8.9|dragonfly|2.0.1-release|200901050311
2995223|pass|200901|davidrw@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i486-linux-gnu-thread-multi|5.8.8|linux|2.6.18.3|200901050233
2995222|pass|200901|davidrw@cpan.org|Data-Phrasebook|0.29|i486-linux-gnu-thread-multi|5.8.8|linux|2.6.18.3|200901050233
2994663|pass|200901|david@cantrell.org.uk|CPAN-WWW-Testers|0.40|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200901050039
2994651|pass|200901|david@cantrell.org.uk|CPAN-WWW-Testers|0.39|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200901050037
2994621|pass|200901|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-dragonfly-64int|5.8.9|dragonfly|2.0.1-release|200901050031
2994413|pass|200901|david@cantrell.org.uk|CPAN-Testers-Data-Generator|0.33|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200901042351
2994379|pass|200901|david@cantrell.org.uk|CPAN-Testers-Common-DBUtils|0.03|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200901042347
2994362|pass|200901|david@cantrell.org.uk|CPAN-Testers-Data-Generator|0.33|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200901041741
2994357|pass|200901|david@cantrell.org.uk|CPAN-Testers-Common-DBUtils|0.03|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200901041740
2994221|pass|200901|david@cantrell.org.uk|CPAN-Testers-Common-DBUtils|0.03|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200901042316
2993878|pass|200901|JOST@cpan.org ("Josts Smokehouse")|CPAN-Testers-Data-Generator|0.33|i86pc-solaris-64int|5.10.0|solaris|2.11|200901042341
2993691|pass|200901|david@cantrell.org.uk|CPAN-Testers-Data-Generator|0.33|IP35-irix-64int|5.8.8|irix|6.5|200901042254
2993680|pass|200901|david@cantrell.org.uk|CPAN-Testers-Common-DBUtils|0.03|IP35-irix-64int|5.8.8|irix|6.5|200901042252
2993675|pass|200901|david@cantrell.org.uk|CPAN-WWW-Testers|0.40|i686-linux|5.8.8|linux|2.4.27-3-686|200901042150
2993481|pass|200901|david@cantrell.org.uk|CPAN-WWW-Testers|0.39|i686-linux|5.8.8|linux|2.4.27-3-686|200901042131
2993437|pass|200901|cpan.dcollins.589@gmail.com|Data-FormValidator-Constraints-Words|0.03|i686-linux-thread-multi|5.8.9|linux|2.6.24-19-generic|200901041626
2993323|pass|200901|JOST@cpan.org ("Josts Smokehouse")|CPAN-WWW-Testers|0.40|i86pc-solaris-64int|5.10.0|solaris|2.11|200901042234
2993162|pass|200901|cpan.dcollins.5100rc2@gmail.com|Data-FormValidator-Constraints-Words|0.03|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200901041603
2993111|pass|200901|david@cantrell.org.uk|CPAN-Testers-Data-Generator|0.33|i686-linux|5.8.8|linux|2.4.27-3-686|200901042100
2993077|pass|200901|cpan.dcollins.5100rc1@gmail.com|Data-FormValidator-Constraints-Words|0.03|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200901041558
2993062|pass|200901|david@cantrell.org.uk|CPAN-Testers-Common-DBUtils|0.03|i686-linux|5.8.8|linux|2.4.27-3-686|200901042057
2991475|fail|200901|altblue@gmail.com ("Marius Feraru")|WWW-Scraper-ISBN-Amazon_Driver|0.14|x86_64-linux-ld|5.11.0 patch 34814|linux|2.6.18-8.1.14.el5|200901041832
2991460|pass|200901|altblue@gmail.com ("Marius Feraru")|WWW-Scraper-ISBN-Yahoo_Driver|0.08|x86_64-linux-ld|5.11.0 patch 34814|linux|2.6.18-8.1.14.el5|200901041830
2989637|pass|200901|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.0-release|200901041530
2989635|pass|200901|bingos@cpan.org|Data-Phrasebook|0.29|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.0-release|200901041530
2988314|pass|200901|bingos@cpan.org|Test-YAML-Meta|0.11|i386-dragonfly-thread-multi-64int|5.8.9|dragonfly|2.0.1-release|200901040912
2986882|pass|200901|jeff@zeroclue.com|CPAN-WWW-Testers|0.40|darwin-2level|5.10.0|darwin|9.2.0|200901040031
2986704|pass|200901|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.0-release|200901032335
2986701|pass|200901|bingos@cpan.org|Data-Phrasebook|0.29|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.0-release|200901032335
2986563|pass|200901|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.0-release|200901032310
2986559|pass|200901|bingos@cpan.org|Data-Phrasebook|0.29|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.0-release|200901032309
2984710|pass|200901|cpan.dcollins.589@gmail.com|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.8.9|linux|2.6.24-19-generic|200901031329
2984650|pass|200901|cpan.dcollins.5100rc2@gmail.com|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200901031319
2984643|pass|200901|cpan.dcollins.5100rc1@gmail.com|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200901031318
2984608|pass|200901|cpan.dcollins.blead@gmail.com|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.11.0 patch GitLive-blead-163-g28b1dae|linux|2.6.24-19-generic|200901031313
2984080|pass|200901|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i386-dragonfly-thread-multi-64int|5.8.9|dragonfly|2.0.1-release|200901031524
2984078|pass|200901|bingos@cpan.org|Data-Phrasebook|0.29|i386-dragonfly-thread-multi-64int|5.8.9|dragonfly|2.0.1-release|200901031524
2983710|pass|200901|cpan.dcollins.5100@gmail.com|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200901030843
2982966|pass|200901|bingos@cpan.org|Test-YAML-Meta|0.11|i386-netbsd-thread-multi-64int|5.8.9|netbsd|4.0|200901031149
2982873|pass|200901|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-dragonfly-thread-multi-64int|5.8.9|dragonfly|2.0.1-release|200901031122
2981194|pass|200901|cpan.dcollins.589@gmail.com|Data-Phrasebook|0.29|i686-linux-thread-multi|5.8.9|linux|2.6.24-19-generic|200901020117
2981114|pass|200901|cpan.dcollins.5100rc1@gmail.com|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200901030148
2981086|pass|200901|cpan.dcollins.5100rc2@gmail.com|Test-YAML-Meta|0.11|i686-linux-thread-multi|5.10.0 RC2|linux|2.6.24-19-generic|200901030143
2980827|pass|200901|cpan.dcollins.5100rc1@gmail.com|Test-YAML-Meta|0.11|i686-linux-thread-multi|5.10.0 RC1|linux|2.6.24-19-generic|200901030116
2980722|pass|200901|cpan.dcollins.589@gmail.com|Data-Phrasebook|0.29|i686-linux-thread-multi|5.8.9|linux|2.6.24-19-generic|200901021030
2980617|pass|200901|jeff@zeroclue.com|CPAN-Testers-Common-DBUtils|0.03|darwin-2level|5.10.0|darwin|9.2.0|200901030050
2980608|pass|200901|cpan.dcollins.589@gmail.com|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.8.9|linux|2.6.24-19-generic|200901030032
2980412|pass|200901|cpan.dcollins.589@gmail.com|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi|5.8.9|linux|2.6.24-19-generic|200901021030
2980369|pass|200901|cpan.dcollins.589@gmail.com|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi|5.8.9|linux|2.6.24-19-generic|200901020117
2980094|pass|200901|cpan.dcollins.blead@gmail.com|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.11.0 patch GitLive-blead-163-g28b1dae|linux|2.6.24-19-generic|200901030006
2979957|pass|200901|cpan.dcollins.5100@gmail.com|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200901021832
2979956|pass|200901|cpan.dcollins.5100@gmail.com|Data-Phrasebook|0.29|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200901021831
2979486|pass|200901|bingos@cpan.org|Data-Phrasebook|0.29|i386-dragonfly-thread-multi-64int|5.8.8|dragonfly|2.0.1-release|200901022053
2979455|pass|200901|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i386-dragonfly-thread-multi-64int|5.10.0|dragonfly|2.0.1-release|200901022046
2979453|pass|200901|bingos@cpan.org|Data-Phrasebook|0.29|i386-dragonfly-thread-multi-64int|5.10.0|dragonfly|2.0.1-release|200901022045
2979177|pass|200901|jeff@zeroclue.com|Data-Phrasebook-Loader-YAML|0.09|i686-linux|5.10.0|linux|2.6.18.8|200901021459
2979175|pass|200901|jeff@zeroclue.com|Data-Phrasebook|0.29|i686-linux|5.10.0|linux|2.6.18.8|200901021459
2978757|pass|200901|jeff@zeroclue.com|CPAN-Testers-Common-DBUtils|0.03|i686-linux|5.10.0|linux|2.6.18.8|200901021413
2978618|pass|200901|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i386-netbsd-thread-multi-64int|5.8.9|netbsd|4.0|200901021900
2978615|pass|200901|bingos@cpan.org|Data-Phrasebook|0.29|i386-netbsd-thread-multi-64int|5.8.9|netbsd|4.0|200901021900
2977436|pass|200901|cpan.dcollins.blead@gmail.com|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi|5.11.0 patch GitLive-blead-163-g28b1dae|linux|2.6.24-19-generic|200901021133
2977433|pass|200901|cpan.dcollins.blead@gmail.com|Data-Phrasebook|0.29|i686-linux-thread-multi|5.11.0 patch GitLive-blead-163-g28b1dae|linux|2.6.24-19-generic|200901021132
2977401|pass|200901|cpan.dcollins.5100@gmail.com|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200901021128
2977381|pass|200901|cpan.dcollins.5100rc2@gmail.com|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200901021126
2976844|pass|200901|cpan.dcollins.5100rc1@gmail.com|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200901021029
2976839|pass|200901|cpan.dcollins.5100rc1@gmail.com|Data-Phrasebook|0.29|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200901021029
2976598|pass|200901|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-dragonfly-thread-multi-64int|5.10.0|dragonfly|2.0.1-release|200901021440
2976559|pass|200901|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-dragonfly-thread-multi-64int|5.8.8|dragonfly|2.0.1-release|200901021432
2976393|pass|200901|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-netbsd-thread-multi-64int|5.8.9|netbsd|4.0|200901021351
2976207|pass|200901|stsc@refcnt.org ("Steven Schubiger")|CPAN-WWW-Testers|0.40|i686-linux|5.10.0|linux|2.6.18-4-686|200901021403
2975964|pass|200901|imacat@mail.imacat.idv.tw|CPAN-WWW-Testers|0.40|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.24-etchnhalf.1-amd64|200901021918
2975765|pass|200901|cpan.dcollins.5100@gmail.com|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200901020240
2975759|pass|200901|rhaen@cpan.org (Ulrich Habel)|CPAN-WWW-Testers|0.40|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.1|200901021006
2975632|pass|200901|srezic@cpan.org|CPAN-WWW-Testers|0.40|amd64-freebsd|5.8.9|freebsd|7.0-release|200901020836
2975507|pass|200901|srezic@cpan.org|CPAN-WWW-Testers|0.40|amd64-freebsd|5.8.8|freebsd|7.0-release|200901020836
2974898|pass|200901|cpan.dcollins.5100rc1@gmail.com|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200901020212
2974754|pass|200901|davidrw@cpan.org|CPAN-WWW-Testers|0.40|i486-linux-gnu-thread-multi|5.8.8|linux|2.6.18-6-k7|200901020036
2974607|pass|200901|cpan.dcollins.blead@gmail.com|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi|5.11.0 patch GitLive-blead-163-g28b1dae|linux|2.6.24-19-generic|200901011730
2974516|pass|200901|cpan.dcollins.589@gmail.com|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.8.9|linux|2.6.24-19-generic|200901020241
2974399|pass|200901|davidrw@cpan.org|Test-CPAN-Meta|0.12|i486-linux-gnu-thread-multi|5.8.8|linux|2.6.18-6-k7|200901020045
2974286|pass|200901|davidrw@cpan.org|CPAN-WWW-Testers|0.39|i486-linux-gnu-thread-multi|5.8.8|linux|2.6.18-6-k7|200901020025
2974135|pass|200901|cpan.dcollins.blead@gmail.com|Data-Phrasebook|0.29|i686-linux-thread-multi|5.11.0 patch GitLive-blead-163-g28b1dae|linux|2.6.24-19-generic|200901011730
2974090|pass|200901|CPAN.DCOLLINS@comcast.net|Test-YAML-Meta|0.11|i686-linux-thread-multi|5.10.0 RC2|linux|2.6.24-19-generic|200901011500
2974057|pass|200901|cpan.dcollins.5100rc2@gmail.com|Data-Phrasebook|0.29|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200901011733
2973903|pass|200901|cpan.dcollins.5100rc1@gmail.com|Data-Phrasebook|0.29|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200901020212
2973859|pass|200901|cpan.dcollins.5100@gmail.com|Test-YAML-Meta|0.11|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200901020142
2973768|pass|200901|cpan.dcollins.5100rc2@gmail.com|Test-YAML-Meta|0.11|i686-linux-thread-multi|5.10.0 RC2|linux|2.6.24-19-generic|200901020056
2973626|pass|200901|davidrw@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i486-linux-gnu-thread-multi|5.8.8|linux|2.6.18-6-k7|200901020022
2973610|pass|200901|davidrw@cpan.org|CPAN-WWW-Testers|0.37|i486-linux-gnu-thread-multi|5.8.8|linux|2.6.18-6-k7|200901020017
2973579|pass|200901|davidrw@cpan.org|Parse-CPAN-Distributions|0.05|i486-linux-gnu-thread-multi|5.8.8|linux|2.6.18-6-k7|200901020012
2973465|pass|200901|cpan.dcollins.5100rc1@gmail.com|Test-YAML-Meta|0.11|i686-linux-thread-multi|5.10.0 RC1|linux|2.6.24-19-generic|200901011842
2973332|pass|200901|cpan.dcollins.5100rc1@gmail.com|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200901011745
2973303|pass|200901|cpan.dcollins.5100rc2@gmail.com|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200901011733
2973046|pass|200901|CPAN.DCOLLINS@comcast.net|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200901011411
2972624|pass|200901|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-19-generic|200901020050
2972299|pass|200901|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.24-19-generic|200901012342
2972154|pass|200901|CPAN.DCOLLINS@comcast.net|Data-Phrasebook|0.29|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200901010228
2972024|pass|200901|srezic@cpan.org|CPAN-WWW-Testers|0.40|amd64-freebsd-thread-multi|5.10.0|freebsd|7.0-release|200901012345
2971872|pass|200901|srezic@cpan.org|CPAN-WWW-Testers|0.40|amd64-freebsd|5.10.0|freebsd|7.0-release|200901012301
2971793|pass|200901|CPAN.DCOLLINS@comcast.net|Data-Phrasebook|0.29|i686-linux-thread-multi|5.11.0 patch GitLive-blead-163-g28b1dae|linux|2.6.24-19-generic|200901010421
2971676|cpan|200901|BARBIE|CPAN-WWW-Testers|0.40||0|||200901012155
2971370|pass|200812|CPAN.DCOLLINS@comcast.net|Data-Phrasebook|0.29|i686-linux-thread-multi|5.11.0 patch GitLive-blead-163-g28b1dae|linux|2.6.24-19-generic|200812311752
2971253|pass|200901|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Mailer|0.10|s390x-linux-thread-multi|5.10.0|linux|2.6.18-92.el5|200901012012
2970603|pass|200901|CPAN.DCOLLINS@comcast.net|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200901010010
2970572|pass|200901|CPAN.DCOLLINS@comcast.net|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200901010350
2970387|pass|200901|CPAN.DCOLLINS@comcast.net|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200901010138
2970266|pass|200901|cpan@herlpacker.co.uk|Test-YAML-Meta|0.11|i486-linux-gnu-thread-multi|5.10.0|linux|2.6.24-16-server|200901011620
2970244|pass|200901|CPAN.DCOLLINS@comcast.net|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200901010228
2970229|pass|200901|CPAN.DCOLLINS@comcast.net|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200901010220
2970228|pass|200901|CPAN.DCOLLINS@comcast.net|Data-Phrasebook|0.29|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200901010220
2970006|pass|200901|CPAN.DCOLLINS@comcast.net|Data-Phrasebook|0.29|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200901010010
2969991|pass|200901|CPAN.DCOLLINS@comcast.net|Test-YAML-Meta|0.11|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200901010006
2969977|pass|200901|CPAN.DCOLLINS@comcast.net|Test-YAML-Meta|0.11|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200901010001
2969883|pass|200901|CPAN.DCOLLINS@comcast.net|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi|5.11.0 patch GitLive-blead-163-g28b1dae|linux|2.6.24-19-generic|200901010421
2969791|pass|200901|CPAN.DCOLLINS@comcast.net|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200901010348
2969610|pass|200901|CPAN.DCOLLINS@comcast.net|Test-YAML-Meta|0.11|i686-linux-thread-multi|5.10.0|linux|2.6.24-19-generic|200901010237
2969405|pass|200901|CPAN.DCOLLINS@comcast.net|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.11.0 patch GitLive-blead-163-g28b1dae|linux|2.6.24-19-generic|200901010105
2969353|pass|200812|CPAN.DCOLLINS@comcast.net|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi|5.11.0 patch GitLive-blead-163-g28b1dae|linux|2.6.24-19-generic|200812311752
2969173|pass|200812|cpanblead@example.com ((cpanblead))|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi|5.11.0 patch GitLive-blead-163-g28b1dae|linux|2.6.24-19-generic|200812311538
2968744|pass|200901|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Data-Generator|0.33|s390x-linux-thread-multi|5.10.0|linux|2.6.18-92.el5|200901011542
2966905|pass|200901|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i386-netbsd-thread-multi-64int|5.8.8|netbsd|4.0|200901010735
2966904|pass|200901|bingos@cpan.org|Data-Phrasebook|0.29|i386-netbsd-thread-multi-64int|5.8.8|netbsd|4.0|200901010735
2966873|pass|200901|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0|200901010727
2966872|pass|200901|bingos@cpan.org|Data-Phrasebook|0.29|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0|200901010726
2965720|pass|200901|bingos@cpan.org|Test-YAML-Meta|0.11|i386-netbsd-thread-multi-64int|5.8.8|netbsd|4.0|200901010222
2965711|pass|200901|bingos@cpan.org|Test-YAML-Meta|0.11|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0|200901010220
2965403|pass|200901|cpan@sourcentral.org ("Oliver Paukstadt")|Games-Trackword|1.06|s390x-linux|5.10.0|linux|2.6.16.60-0.31-default|200901010227
2965397|pass|200901|cpan@sourcentral.org ("Oliver Paukstadt")|Calendar-List|0.21|s390x-linux|5.10.0|linux|2.6.16.60-0.31-default|200901010226
2965152|pass|200901|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0|200901010037
2965151|pass|200901|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-netbsd-thread-multi-64int|5.8.8|netbsd|4.0|200901010037
2964991|pass|200901|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook-Loader-YAML|0.09|s390x-linux-thread-multi|5.8.8|linux|2.6.18-92.1.18.el5|200901010106
2964988|pass|200901|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook|0.29|s390x-linux-thread-multi|5.8.8|linux|2.6.18-92.1.18.el5|200901010106
2964901|pass|200901|cpan@sourcentral.org ("Oliver Paukstadt")|Games-Trackword|1.06|s390x-linux-thread-multi|5.10.0|linux|2.6.18-92.el5|200901010044
2964894|pass|200901|cpan@sourcentral.org ("Oliver Paukstadt")|Calendar-List|0.21|s390x-linux-thread-multi|5.10.0|linux|2.6.18-92.el5|200901010043
2964830|pass|200812|CPAN.DCOLLINS@comcast.net|Test-YAML-Meta|0.11|i686-linux-thread-multi|5.11.0 patch GitLive-blead-163-g28b1dae|linux|2.6.24-19-generic|200812311140
2962836|pass|200812|srezic@cpan.org|Data-Phrasebook|0.29|amd64-freebsd-thread-multi|5.10.0|freebsd|7.0-release|200812311618
2962835|pass|200812|srezic@cpan.org|Data-Phrasebook-Loader-YAML|0.09|amd64-freebsd-thread-multi|5.10.0|freebsd|7.0-release|200812311618
2962485|pass|200812|srezic@cpan.org|Data-Phrasebook-Loader-YAML|0.09|amd64-freebsd|5.10.0|freebsd|7.0-release|200812311342
2962484|pass|200812|srezic@cpan.org|Data-Phrasebook|0.29|amd64-freebsd|5.10.0|freebsd|7.0-release|200812311342
2962257|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|Test-YAML-Meta|0.11|s390x-linux-thread-multi|5.6.2|linux|2.6.18-92.1.18.el5|200812311141
2962226|pass|200812|rhaen@cpan.org (Ulrich Habel)|Data-Phrasebook-Loader-YAML|0.09|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.1|200812311127
2962225|pass|200812|rhaen@cpan.org (Ulrich Habel)|Data-Phrasebook|0.29|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.1|200812311127
2962224|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|Test-YAML-Meta|0.11|s390x-linux|5.6.2|linux|2.6.18-92.1.18.el5|200812311125
2961998|pass|200812|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|darwin-thread-multi-64int-2level|5.8.9|darwin|8.11.0|200812310725
2961996|pass|200812|bingos@cpan.org|Data-Phrasebook|0.29|darwin-thread-multi-64int-2level|5.8.9|darwin|8.11.0|200812310725
2961992|pass|200812|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|darwin-thread-multi-64int-2level|5.8.8|darwin|8.11.0|200812310722
2961991|pass|200812|bingos@cpan.org|Data-Phrasebook|0.29|darwin-thread-multi-64int-2level|5.8.8|darwin|8.11.0|200812310722
2961960|pass|200812|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|darwin-thread-multi-64int-2level|5.8.6|darwin|8.11.0|200812310654
2961959|pass|200812|bingos@cpan.org|Data-Phrasebook|0.29|darwin-thread-multi-64int-2level|5.8.6|darwin|8.11.0|200812310653
2961937|pass|200812|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|darwin-thread-multi-64int-2level|5.10.0|darwin|8.11.0|200812310651
2961936|pass|200812|bingos@cpan.org|Data-Phrasebook|0.29|darwin-thread-multi-64int-2level|5.10.0|darwin|8.11.0|200812310650
2961375|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|Test-YAML-Meta|0.11|s390x-linux-thread-multi|5.6.2|linux|2.6.16.60-0.31-default|200812310336
2961288|pass|200812|davidrw@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i486-linux-gnu-thread-multi|5.8.8|linux|2.6.18.3|200812301413
2961120|pass|200812|davidrw@cpan.org|Test-YAML-Meta|0.11|i486-linux-gnu-thread-multi|5.8.8|linux|2.6.18.3|200812301537
2959270|pass|200812|rhaen@cpan.org (Ulrich Habel)|Test-YAML-Meta|0.11|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.1|200812301425
2958555|pass|200812|rhaen@cpan.org (Ulrich Habel)|CPAN-Testers-Data-Generator|0.33|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.1|200812301113
2957248|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|Mail-Outlook|0.14|s390x-linux-thread-multi|5.6.2|linux|2.6.18-92.1.18.el5|200812300632
2957162|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.12|s390x-linux|5.10.0|linux|2.6.16.60-0.31-default|200812300558
2956435|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal-Thread|0.12|s390x-linux-thread-multi|5.6.2|linux|2.6.18-92.1.18.el5|200812300221
2956434|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal|0.22|s390x-linux-thread-multi|5.6.2|linux|2.6.18-92.1.18.el5|200812300220
2956320|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook-Loader-YAML|0.09|s390x-linux|5.8.8|linux|2.6.18-92.1.18.el5|200812300147
2956318|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook|0.29|s390x-linux|5.8.8|linux|2.6.18-92.1.18.el5|200812300146
2955596|pass|200812|srezic@cpan.org|CPAN-Testers-Data-Generator|0.33|amd64-freebsd-thread-multi|5.10.0|freebsd|7.0-release|200812292255
2955545|pass|200812|srezic@cpan.org|CPAN-Testers-Data-Generator|0.33|amd64-freebsd|5.10.0|freebsd|7.0-release|200812292156
2955276|pass|200812|srezic@cpan.org|CPAN-Testers-Data-Generator|0.33|amd64-freebsd|5.8.9|freebsd|7.0-release|200812292137
2955070|pass|200812|srezic@cpan.org|CPAN-Testers-Data-Generator|0.33|amd64-freebsd|5.8.8|freebsd|7.0-release|200812292041
2954945|cpan|200812|BARBIE|CPAN-Testers-Data-Generator|0.33||0|||200812292011
2954898|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|Games-Trackword|1.06|s390x-linux-thread-multi|5.10.0|linux|2.6.16.60-0.31-default|200812291948
2954895|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|Calendar-List|0.21|s390x-linux-thread-multi|5.10.0|linux|2.6.16.60-0.31-default|200812291947
2953095|pass|200812|rhaen@cpan.org (Ulrich Habel)|CPAN-WWW-Testers|0.39|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.1|200812291159
2953071|pass|200812|rhaen@cpan.org (Ulrich Habel)|CPAN-Testers-Common-DBUtils|0.03|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.1|200812291153
2952894|pass|200812|stsc@refcnt.org ("Steven Schubiger")|CPAN-WWW-Testers|0.39|i686-linux|5.10.0|linux|2.6.18-4-686|200812291111
2952691|pass|200812|srezic@cpan.org|CPAN-WWW-Testers|0.39|amd64-freebsd|5.8.9|freebsd|7.0-release|200812291001
2952690|pass|200812|srezic@cpan.org|CPAN-WWW-Testers|0.39|amd64-freebsd|5.8.8|freebsd|7.0-release|200812291000
2952186|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|Mail-Outlook|0.14|s390x-linux|5.6.2|linux|2.6.18-92.1.18.el5|200812290717
2951803|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|Mail-Outlook|0.14|s390x-linux|5.10.0|linux|2.6.18-92.el5|200812290447
2951567|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal-Thread|0.12|s390x-linux|5.6.2|linux|2.6.18-92.1.18.el5|200812290233
2951565|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal|0.22|s390x-linux|5.6.2|linux|2.6.18-92.1.18.el5|200812290232
2951543|pass|200812|bingos@cpan.org|WWW-UsePerl-Journal-Thread|0.12|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.24.5-smp|200812290219
2951542|pass|200812|bingos@cpan.org|WWW-UsePerl-Journal|0.22|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.24.5-smp|200812290219
2951541|pass|200812|bingos@cpan.org|Test-CPAN-Meta|0.12|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.24.5-smp|200812290217
2951539|pass|200812|bingos@cpan.org|Parse-CPAN-Distributions|0.05|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.24.5-smp|200812290216
2951538|pass|200812|bingos@cpan.org|Mail-File|0.08|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.24.5-smp|200812290216
2951537|pass|200812|bingos@cpan.org|Games-Trackword|1.06|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.24.5-smp|200812290216
2951536|pass|200812|bingos@cpan.org|GD-Chart-Radial|0.07|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.24.5-smp|200812290216
2951535|pass|200812|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.24.5-smp|200812290215
2951534|pass|200812|bingos@cpan.org|Data-Phrasebook-Loader-XML|0.12|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.24.5-smp|200812290215
2951533|pass|200812|bingos@cpan.org|Data-Phrasebook-Loader-Ini|0.10|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.24.5-smp|200812290215
2951532|pass|200812|bingos@cpan.org|Data-Phrasebook-Loader-DBI|0.11|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.24.5-smp|200812290215
2951531|pass|200812|bingos@cpan.org|Data-Phrasebook|0.29|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.24.5-smp|200812290215
2951530|pass|200812|bingos@cpan.org|Data-FormValidator-Constraints-Words|0.03|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.24.5-smp|200812290214
2951529|pass|200812|bingos@cpan.org|Calendar-List|0.21|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.24.5-smp|200812290214
2951527|pass|200812|bingos@cpan.org|CPAN-YACSmoke-Plugin-NNTP|0.05|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.24.5-smp|200812290214
2951524|pass|200812|bingos@cpan.org|CPAN-WWW-Testers-Generator|0.30|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.24.5-smp|200812290213
2951522|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.24.5-smp|200812290211
2951098|pass|200812|srezic@cpan.org|CPAN-WWW-Testers|0.39|amd64-freebsd|5.10.0|freebsd|7.0-release|200812290003
2950893|cpan|200812|BARBIE|CPAN-WWW-Testers|0.39||0|||200812282251
2950588|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|Mail-Outlook|0.14|s390x-linux-thread-multi|5.6.2|linux|2.6.16.60-0.31-default|200812282131
2948887|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Mailer|0.10|s390x-linux|5.10.0|linux|2.6.18-92.el5|200812281359
2946292|pass|200812|imacat@mail.imacat.idv.tw|CPAN-Testers-WWW-Reports-Mailer|0.10|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.24-etchnhalf.1-amd64|200812281359
2946253|pass|200812|imacat@mail.imacat.idv.tw|CPAN-Testers-Common-DBUtils|0.03|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.24-etchnhalf.1-amd64|200812281353
2945386|pass|200812|bingos@cpan.org|Test-YAML-Meta|0.11|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.24.5-smp|200812280434
2945298|pass|200812|bingos@cpan.org|Test-YAML-Meta|0.11|OpenBSD.i386-openbsd-thread-multi-64int|5.8.9|openbsd|4.2|200812280325
2943675|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-DBUtils|0.03|s390x-linux|5.8.8|linux|2.6.16.60-0.31-default|200812280009
2942633|pass|200812|srezic@cpan.org|Test-YAML-Meta|0.11|amd64-freebsd-thread-multi|5.10.0|freebsd|7.0-release|200812271951
2941799|pass|200812|bingos@cpan.org|Test-YAML-Meta|0.11|OpenBSD.i386-openbsd-thread-multi-64int|5.8.8|openbsd|4.2|200812271557
2941747|pass|200812|bingos@cpan.org|Test-YAML-Meta|0.11|OpenBSD.i386-openbsd-thread-multi-64int|5.10.0|openbsd|4.2|200812271547
2941430|pass|200812|bingos@cpan.org|Test-YAML-Meta|0.11|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24.5-smp|200812271545
2941402|pass|200812|bingos@cpan.org|Test-YAML-Meta|0.11|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.24.5-smp|200812271541
2941195|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal-Thread|0.12|s390x-linux-thread-multi|5.6.2|linux|2.6.16.60-0.31-default|200812271506
2941194|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal|0.22|s390x-linux-thread-multi|5.6.2|linux|2.6.16.60-0.31-default|200812271506
2938630|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|Parse-CPAN-Distributions|0.05|s390x-linux-thread-multi|5.6.2|linux|2.6.18-92.1.18.el5|200812262244
2938606|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|Test-YAML-Meta|0.11|s390x-linux|5.8.8|linux|2.6.16.60-0.31-default|200812262237
2938358|pass|200812|bingos@cpan.org|Test-YAML-Meta|0.11|OpenBSD.i386-openbsd-thread-multi-64int|5.8.9|openbsd|4.4|200812262045
2936769|pass|200812|stsc@refcnt.org ("Steven Schubiger")|Data-FormValidator-Constraints-Words|0.03|i686-linux|5.10.0|linux|2.6.18-4-686|200812261634
2936032|pass|200812|bingos@cpan.org|Test-YAML-Meta|0.11|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.21.5-smp|200812261147
2935787|pass|200812|bingos@cpan.org|Test-YAML-Meta|0.11|darwin-thread-multi-64int-2level|5.8.9|darwin|8.11.0|200812261050
2935751|pass|200812|bingos@cpan.org|Test-YAML-Meta|0.11|darwin-thread-multi-64int-2level|5.8.8|darwin|8.11.0|200812261043
2935671|pass|200812|bingos@cpan.org|Test-YAML-Meta|0.11|darwin-thread-multi-64int-2level|5.10.0|darwin|8.11.0|200812261034
2935235|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|Test-YAML-Meta|0.11|s390x-linux|5.8.8|linux|2.6.18-92.1.18.el5|200812261011
2935195|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|Test-YAML-Meta|0.11|s390x-linux-thread-multi|5.8.8|linux|2.6.16.60-0.31-default|200812261004
2935170|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|Test-YAML-Meta|0.11|s390x-linux|5.10.0|linux|2.6.18-92.el5|200812261001
2935156|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|Test-YAML-Meta|0.11|s390x-linux-thread-multi|5.8.8|linux|2.6.18-92.1.18.el5|200812260958
2934745|pass|200812|mw487.yahoo.com@gmail.com|CPAN-Testers-Common-DBUtils|0.03|cygwin-thread-multi-64int|5.8.8|cygwin|1.5.24(0.15642)|200812260018
2934099|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|OpenBSD.i386-openbsd-thread-multi-64int|5.8.9|openbsd|4.4|200812252335
2933310|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.21.5-smp|200812251642
2932930|pass|200812|bingos@cpan.org|Test-YAML-Meta|0.11|OpenBSD.i386-openbsd-thread-multi-64int|5.10.0|openbsd|4.4|200812251252
2932449|pass|200812|bingos@cpan.org|Test-YAML-Meta|0.11|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.21.5-smp|200812251116
2932298|pass|200812|bingos@cpan.org|Test-YAML-Meta|0.11|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.21.5-smp|200812251051
2927850|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|OpenBSD.i386-openbsd-thread-multi-64int|5.10.0|openbsd|4.4|200812241513
2927823|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.21.5-smp|200812241509
2927781|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|OpenBSD.i386-openbsd-thread-multi-64int|5.8.8|openbsd|4.4|200812241459
2927342|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.21.5-smp|200812241303
2926513|pass|200812|bingos@cpan.org|Test-YAML-Meta|0.11|i386-freebsd-thread-multi-64int|5.8.9|freebsd|6.2-release|200812240457
2926459|pass|200812|bingos@cpan.org|Test-YAML-Meta|0.11|OpenBSD.i386-openbsd-thread-multi-64int|5.8.9|openbsd|4.3|200812240912
2919650|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|OpenBSD.i386-openbsd-thread-multi-64int|5.8.9|openbsd|4.3|200812231550
2919643|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi-64int|5.10.0|linux|2.4.26|200812231551
2918307|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-freebsd-thread-multi-64int|5.8.9|freebsd|6.2-release|200812231252
2913677|pass|200812|dagolden@cpan.org (DAGOLDEN)|Data-Phrasebook-Loader-DBI|0.11|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.24-16-generic|200812230023
2913676|pass|200812|dagolden@cpan.org (DAGOLDEN)|Data-Phrasebook-Loader-Ini|0.10|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.24-16-generic|200812230023
2913675|pass|200812|dagolden@cpan.org (DAGOLDEN)|Mail-File|0.08|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.24-16-generic|200812230023
2913674|pass|200812|dagolden@cpan.org (DAGOLDEN)|Data-Phrasebook-Loader-XML|0.12|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.24-16-generic|200812230023
2913618|pass|200812|dagolden@cpan.org (DAGOLDEN)|CPAN-YACSmoke-Plugin-Outlook|0.06|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.24-16-generic|200812230011
2911545|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|OpenBSD.i386-openbsd-thread-multi-64int|5.10.0|openbsd|4.3|200812221827
2911541|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.02|OpenBSD.i386-openbsd-thread-multi-64int|5.10.0|openbsd|4.3|200812221826
2911506|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|OpenBSD.i386-openbsd-thread-multi-64int|5.8.8|openbsd|4.3|200812221818
2911502|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.02|OpenBSD.i386-openbsd-thread-multi-64int|5.8.8|openbsd|4.3|200812221818
2909190|pass|200812|JOST@cpan.org ("Josts Smokehouse")|CPAN-Testers-Data-Generator|0.32|i86pc-solaris-64int|5.10.0|solaris|2.11|200812221147
2909183|pass|200812|bingos@cpan.org|Test-YAML-Meta|0.11|i386-netbsd-thread-multi-64int|5.8.9|netbsd|4.0|200812221028
2908483|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-freebsd-thread-multi-64int|5.10.0|freebsd|6.2-release|200812220831
2908479|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.02|i386-freebsd-thread-multi-64int|5.10.0|freebsd|6.2-release|200812220831
2908354|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-freebsd-thread-multi-64int|5.8.8|freebsd|6.2-release|200812220814
2908347|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.02|i386-freebsd-thread-multi-64int|5.8.8|freebsd|6.2-release|200812220813
2905973|pass|200812|bingos@cpan.org|Test-YAML-Meta|0.11|i386-netbsd-thread-multi-64int|5.8.8|netbsd|4.0|200812220153
2905470|pass|200812|bingos@cpan.org|Test-YAML-Meta|0.11|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.16.38|200812220030
2905000|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-netbsd-thread-multi-64int|5.8.9|netbsd|4.0|200812212321
2904998|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.02|i386-netbsd-thread-multi-64int|5.8.9|netbsd|4.0|200812212321
2904269|pass|200812|dagolden@cpan.org (DAGOLDEN)|Data-FormValidator-Constraints-Words|0.03|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.24-16-generic|200812211649
2903811|pass|200812|rafl@debian.org|Test-CPAN-Meta|0.12|i686-linux-multi|5.10.0|linux|2.6.24-rc5|200812212108
2902906|pass|200812|dagolden@cpan.org (DAGOLDEN)|Games-Trackword|1.06|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.24-16-generic|200812211152
2902904|pass|200812|dagolden@cpan.org (DAGOLDEN)|Calendar-List|0.21|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.24-16-generic|200812211152
2901880|pass|200812|dagolden@cpan.org (DAGOLDEN)|Test-CPAN-Meta|0.12|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.24-16-generic|200812210932
2901088|pass|200812|rhaen@cpan.org (Ulrich Habel)|Test-CPAN-Meta|0.12|i386-netbsd-thread-multi|5.10.0|netbsd|5.0_beta|200812211227
2900304|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.16.38|200812211059
2900299|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.02|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.16.38|200812211059
2899912|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-netbsd-thread-multi-64int|5.8.8|netbsd|4.0|200812211031
2899909|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.02|i386-netbsd-thread-multi-64int|5.8.8|netbsd|4.0|200812211030
2899463|pass|200812|dagolden@cpan.org (DAGOLDEN)|Test-YAML-Meta|0.11|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.24-16-generic|200812210448
2898276|pass|200812|dagolden@cpan.org (DAGOLDEN)|Mail-Outlook|0.14|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.24-16-generic|200812210148
2897855|pass|200812|dagolden@cpan.org (DAGOLDEN)|WWW-UsePerl-Journal-Thread|0.12|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.24-16-generic|200812210055
2897854|pass|200812|dagolden@cpan.org (DAGOLDEN)|WWW-UsePerl-Journal|0.22|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.24-16-generic|200812210054
2897806|pass|200812|dagolden@cpan.org (DAGOLDEN)|CPAN-WWW-Testers-Generator|0.30|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.24-16-generic|200812210042
2896094|pass|200812|dagolden@cpan.org (DAGOLDEN)|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.24-16-generic|200812210017
2896092|pass|200812|dagolden@cpan.org (DAGOLDEN)|Data-Phrasebook|0.29|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.24-16-generic|200812210017
2895952|pass|200812|dagolden@cpan.org (DAGOLDEN)|Regexp-Log-Common|0.05|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.24-16-generic|200812210003
2895467|pass|200812|rhaen@cpan.org (Ulrich Habel)|Data-Phrasebook-Loader-YAML|0.09|i386-netbsd-thread-multi|5.10.0|netbsd|5.0_beta|200812202254
2895465|pass|200812|rhaen@cpan.org (Ulrich Habel)|Data-Phrasebook|0.29|i386-netbsd-thread-multi|5.10.0|netbsd|5.0_beta|200812202254
2895353|pass|200812|dagolden@cpan.org (DAGOLDEN)|Parse-CPAN-Distributions|0.05|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.24-16-generic|200812201741
2892496|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0|200812201710
2892494|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.02|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0|200812201710
2892492|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.01|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0|200812201710
2892447|pass|200812|rhaen@cpan.org (Ulrich Habel)|Regexp-Log-Common|0.05|i386-netbsd-thread-multi|5.10.0|netbsd|5.0_beta|200812201703
2891823|pass|200812|dagolden@cpan.org (DAGOLDEN)|CPAN-Testers-WWW-Reports-Mailer|0.10|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.24-16-generic|200812201045
2891436|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.16.38|200812201502
2891435|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.02|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.16.38|200812201501
2891434|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.01|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.16.38|200812201501
2891368|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.16.38|200812201456
2891359|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.02|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.16.38|200812201456
2891355|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.01|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.16.38|200812201456
2890852|pass|200812|dagolden@cpan.org (DAGOLDEN)|CPAN-Testers-Data-Generator|0.32|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.24-16-generic|200812200916
2890849|pass|200812|dagolden@cpan.org (DAGOLDEN)|CPAN-Testers-Common-DBUtils|0.03|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.24-16-generic|200812200916
2890325|pass|200812|imacat@mail.imacat.idv.tw|WWW-UsePerl-Journal-Thread|0.12|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.24-etchnhalf.1-amd64|200812202129
2890313|pass|200812|imacat@mail.imacat.idv.tw|WWW-UsePerl-Journal|0.22|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.24-etchnhalf.1-amd64|200812202127
2890278|pass|200812|rhaen@cpan.org (Ulrich Habel)|Parse-CPAN-Distributions|0.05|i386-netbsd-thread-multi|5.10.0|netbsd|5.0_beta|200812201318
2890259|pass|200812|imacat@mail.imacat.idv.tw|Test-CPAN-Meta|0.12|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.24-etchnhalf.1-amd64|200812202114
2890257|pass|200812|imacat@mail.imacat.idv.tw|Regexp-Log-Common|0.05|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.24-etchnhalf.1-amd64|200812202114
2890254|pass|200812|imacat@mail.imacat.idv.tw|Mail-Outlook|0.14|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.24-etchnhalf.1-amd64|200812202113
2890253|pass|200812|imacat@mail.imacat.idv.tw|Mail-File|0.08|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.24-etchnhalf.1-amd64|200812202113
2890251|pass|200812|imacat@mail.imacat.idv.tw|Games-Trackword|1.06|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.24-etchnhalf.1-amd64|200812202113
2890248|pass|200812|imacat@mail.imacat.idv.tw|GD-Chart-Radial|0.07|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.24-etchnhalf.1-amd64|200812202112
2890242|pass|200812|imacat@mail.imacat.idv.tw|Data-Phrasebook-Loader-YAML|0.09|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.24-etchnhalf.1-amd64|200812202110
2890236|pass|200812|imacat@mail.imacat.idv.tw|Data-Phrasebook-Loader-XML|0.12|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.24-etchnhalf.1-amd64|200812202109
2890233|pass|200812|imacat@mail.imacat.idv.tw|Data-Phrasebook-Loader-Ini|0.10|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.24-etchnhalf.1-amd64|200812202109
2890232|pass|200812|imacat@mail.imacat.idv.tw|Data-Phrasebook-Loader-DBI|0.11|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.24-etchnhalf.1-amd64|200812202108
2890218|pass|200812|imacat@mail.imacat.idv.tw|Data-Phrasebook|0.29|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.24-etchnhalf.1-amd64|200812202106
2890215|pass|200812|imacat@mail.imacat.idv.tw|Data-FormValidator-Constraints-Words|0.03|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.24-etchnhalf.1-amd64|200812202106
2890213|pass|200812|imacat@mail.imacat.idv.tw|Calendar-List|0.21|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.24-etchnhalf.1-amd64|200812202106
2890196|pass|200812|imacat@mail.imacat.idv.tw|CPAN-YACSmoke-Plugin-Outlook|0.06|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.24-etchnhalf.1-amd64|200812202102
2890181|pass|200812|imacat@mail.imacat.idv.tw|CPAN-YACSmoke-Plugin-NNTP|0.05|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.24-etchnhalf.1-amd64|200812202058
2890160|pass|200812|imacat@mail.imacat.idv.tw|Parse-CPAN-Distributions|0.05|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.24-etchnhalf.1-amd64|200812202054
2890104|pass|200812|imacat@mail.imacat.idv.tw|CPAN-Testers-WWW-Reports-Mailer|0.08|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.24-etchnhalf.1-amd64|200812202042
2890100|pass|200812|imacat@mail.imacat.idv.tw|CPAN-Testers-Common-DBUtils|0.02|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.24-etchnhalf.1-amd64|200812202038
2889794|pass|200812|dagolden@cpan.org (DAGOLDEN)|CPAN-Testers-Data-Generator|0.32|i686-linux-64int-ld|5.8.9|linux|2.6.24-16-generic|200812200608
2889579|pass|200812|bingos@cpan.org|Test-YAML-Meta|0.11|i386-netbsd-thread-multi-64int|5.8.9|netbsd|4.0.1|200812201018
2889022|pass|200812|srezic@cpan.org|CPAN-Testers-Data-Generator|0.32|amd64-freebsd-thread-multi|5.10.0|freebsd|7.0-release|200812200937
2887993|pass|200812|imacat@mail.imacat.idv.tw|Test-YAML-Meta|0.11|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.24-etchnhalf.1-amd64|200812201256
2886056|pass|200812|srezic@cpan.org|CPAN-Testers-Data-Generator|0.32|amd64-freebsd|5.10.0|freebsd|7.0-release|200812200201
2885838|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-DBUtils|0.03|s390x-linux-thread-multi|5.8.9|linux|2.6.16.60-0.31-default|200812200149
2885670|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Mailer|0.10|s390x-linux-thread-multi|5.10.0|linux|2.6.16.60-0.31-default|200812200131
2885454|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Mailer|0.10|s390x-linux|5.10.0|linux|2.6.16.60-0.31-default|200812200114
2885379|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i86pc-solaris-thread-multi-64int|5.10.0|solaris|2.10|200812200007
2885376|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.02|i86pc-solaris-thread-multi-64int|5.10.0|solaris|2.10|200812200007
2885369|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.01|i86pc-solaris-thread-multi-64int|5.10.0|solaris|2.10|200812200006
2884956|pass|200812|david@cantrell.org.uk|CPAN-Testers-Common-DBUtils|0.02|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200812192332
2884481|pass|200812|david@cantrell.org.uk|CPAN-Testers-Common-DBUtils|0.02|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200812191646
2884183|pass|200812|david@cantrell.org.uk|CPAN-Testers-Common-DBUtils|0.02|IP35-irix-64int|5.8.8|irix|6.5|200812192308
2884165|pass|200812|david@cantrell.org.uk|CPAN-Testers-Common-DBUtils|0.02|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200812192205
2884162|pass|200812|david@cantrell.org.uk|CPAN-Testers-Common-DBUtils|0.02|i686-linux|5.8.8|linux|2.4.27-3-686|200812192204
2881586|pass|200812|srezic@cpan.org|CPAN-Testers-Data-Generator|0.32|amd64-freebsd|5.8.8|freebsd|7.0-release|200812191729
2881337|pass|200812|bingos@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.10|i386-netbsd-thread-multi-64int|5.8.9|netbsd|4.0.1|200812191652
2881335|pass|200812|bingos@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.09|i386-netbsd-thread-multi-64int|5.8.9|netbsd|4.0.1|200812191651
2881330|pass|200812|bingos@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.08|i386-netbsd-thread-multi-64int|5.8.9|netbsd|4.0.1|200812191651
2881328|pass|200812|bingos@cpan.org|Test-YAML-Meta|0.11|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.0-release|200812191552
2881205|pass|200812|srezic@cpan.org|CPAN-Testers-Data-Generator|0.32|amd64-freebsd|5.8.9|freebsd|7.0-release|200812191729
2879925|pass|200812|JOST@cpan.org ("Josts Smokehouse")|CPAN-Testers-Data-Generator|0.31|i86pc-solaris-64int|5.10.0|solaris|2.11|200812191511
2879730|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|darwin-thread-multi-64int-2level|5.8.9|darwin|8.11.0|200812191330
2879719|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.02|darwin-thread-multi-64int-2level|5.8.9|darwin|8.11.0|200812191328
2879706|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.01|darwin-thread-multi-64int-2level|5.8.9|darwin|8.11.0|200812191327
2879469|pass|200812|bingos@cpan.org|CPAN-Testers-Data-Generator|0.31|i386-netbsd-thread-multi-64int|5.8.9|netbsd|4.0.1|200812191245
2879464|cpan|200812|BARBIE|CPAN-Testers-Data-Generator|0.32||0|||200812191344
2878914|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|Test-YAML-Meta|0.11|s390x-linux|5.6.2|linux|2.6.16.60-0.31-default|200812191249
2878705|pass|200812|srezic@cpan.org|Test-YAML-Meta|0.11|amd64-freebsd|5.10.0|freebsd|7.0-release|200812191223
2878457|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-netbsd-thread-multi-64int|5.8.9|netbsd|4.0.1|200812191104
2878454|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.02|i386-netbsd-thread-multi-64int|5.8.9|netbsd|4.0.1|200812191104
2878450|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.01|i386-netbsd-thread-multi-64int|5.8.9|netbsd|4.0.1|200812191104
2878212|pass|200812|dagolden@cpan.org (DAGOLDEN)|CPAN-Testers-Data-Generator|0.31|i686-linux-64int-ld|5.8.9|linux|2.6.24-16-generic|200812190538
2878112|pass|200812|rhaen@cpan.org (Ulrich Habel)|CPAN-Testers-Common-DBUtils|0.03|i386-netbsd-thread-multi|5.10.0|netbsd|5.0_beta|200812191023
2877243|pass|200812|srezic@cpan.org|CPAN-Testers-Data-Generator|0.31|amd64-freebsd|5.10.0|freebsd|7.0-release|200812190924
2874863|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|Parse-CPAN-Distributions|0.05|s390x-linux|5.6.2|linux|2.6.18-92.1.18.el5|200812190344
2874278|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-DBUtils|0.03|s390x-linux-thread-multi|5.8.9|linux|2.6.18-92.1.18.el5|200812190234
2874234|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-DBUtils|0.03|s390x-linux-thread-multi|5.8.8|linux|2.6.18-92.1.18.el5|200812190228
2873909|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.0-release|200812190057
2873904|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.02|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.0-release|200812190057
2873894|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.01|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.0-release|200812190056
2873851|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-DBUtils|0.03|s390x-linux|5.8.9|linux|2.6.18-92.1.18.el5|200812190152
2873698|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-DBUtils|0.03|s390x-linux|5.8.8|linux|2.6.18-92.1.18.el5|200812190138
2873668|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-DBUtils|0.03|s390x-linux-thread-multi|5.8.8|linux|2.6.16.60-0.31-default|200812190136
2873441|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-DBUtils|0.03|s390x-linux|5.8.9|linux|2.6.16.60-0.31-default|200812190120
2872995|pass|200812|srezic@cpan.org|CPAN-Testers-Data-Generator|0.31|amd64-freebsd|5.8.9|freebsd|7.0-release|200812190041
2872986|pass|200812|srezic@cpan.org|CPAN-Testers-Data-Generator|0.31|amd64-freebsd|5.8.8|freebsd|7.0-release|200812190041
2872306|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-DBUtils|0.03|s390x-linux-thread-multi|5.10.0|linux|2.6.18-92.el5|200812182346
2872109|pass|200812|dagolden@cpan.org (DAGOLDEN)|Data-Phrasebook-Loader-DBI|0.11|i686-linux-64int-ld|5.8.9|linux|2.6.24-16-generic|200812181727
2872107|pass|200812|dagolden@cpan.org (DAGOLDEN)|Data-Phrasebook-Loader-Ini|0.10|i686-linux-64int-ld|5.8.9|linux|2.6.24-16-generic|200812181727
2872105|pass|200812|dagolden@cpan.org (DAGOLDEN)|Data-Phrasebook-Loader-XML|0.12|i686-linux-64int-ld|5.8.9|linux|2.6.24-16-generic|200812181727
2872089|pass|200812|dagolden@cpan.org (DAGOLDEN)|Mail-File|0.08|i686-linux-64int-ld|5.8.9|linux|2.6.24-16-generic|200812181726
2872083|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-DBUtils|0.03|s390x-linux|5.10.0|linux|2.6.16.60-0.31-default|200812182323
2871972|pass|200812|dagolden@cpan.org (DAGOLDEN)|CPAN-YACSmoke-Plugin-Outlook|0.06|i686-linux-64int-ld|5.8.9|linux|2.6.24-16-generic|200812181715
2871850|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-DBUtils|0.03|s390x-linux-thread-multi|5.10.0|linux|2.6.16.60-0.31-default|200812182302
2871834|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-DBUtils|0.03|s390x-linux|5.10.0|linux|2.6.18-92.el5|200812182300
2871393|pass|200812|srezic@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.10|amd64-freebsd-thread-multi|5.10.0|freebsd|7.0-release|200812182223
2870200|cpan|200812|BARBIE|CPAN-Testers-Data-Generator|0.31||0|||200812182043
2867312|pass|200812|bingos@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.10|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0.1|200812181350
2867300|pass|200812|bingos@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.09|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0.1|200812181348
2867242|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0.1|200812181342
2867238|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.02|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0.1|200812181341
2867232|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.01|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0.1|200812181341
2866979|pass|200812|bingos@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.10|i386-netbsd-thread-multi-64int|5.8.8|netbsd|4.0.1|200812181306
2866968|pass|200812|bingos@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.09|i386-netbsd-thread-multi-64int|5.8.8|netbsd|4.0.1|200812181305
2866930|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-netbsd-thread-multi-64int|5.8.8|netbsd|4.0.1|200812181301
2866925|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.02|i386-netbsd-thread-multi-64int|5.8.8|netbsd|4.0.1|200812181300
2866922|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.01|i386-netbsd-thread-multi-64int|5.8.8|netbsd|4.0.1|200812181300
2866799|pass|200812|JOST@cpan.org ("Josts Smokehouse")|CPAN-Testers-WWW-Reports-Mailer|0.10|i86pc-solaris-64int|5.10.0|solaris|2.11|200812181400
2866797|pass|200812|JOST@cpan.org ("Josts Smokehouse")|CPAN-Testers-Common-DBUtils|0.03|i86pc-solaris-64int|5.10.0|solaris|2.11|200812181400
2865954|pass|200812|dagolden@cpan.org (DAGOLDEN)|CPAN-Testers-Common-DBUtils|0.03|i686-linux-64int-ld|5.8.9|linux|2.6.24-16-generic|200812180553
2865937|pass|200812|dagolden@cpan.org (DAGOLDEN)|CPAN-Testers-WWW-Reports-Mailer|0.10|i686-linux-64int-ld|5.8.9|linux|2.6.24-16-generic|200812180550
2865792|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.0-release|200812180951
2865788|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.02|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.0-release|200812180950
2865785|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.01|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.0-release|200812180950
2864818|pass|200812|srezic@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.10|amd64-freebsd|5.10.0|freebsd|7.0-release|200812180958
2864684|fail|200812|dagolden@cpan.org (DAGOLDEN)|Finance-Currency-Convert-XE|0.15|i686-linux-64int-ld|5.8.9|linux|2.6.24-16-generic|200812180339
2864383|pass|200812|dagolden@cpan.org (DAGOLDEN)|Data-FormValidator-Constraints-Words|0.03|i686-linux-64int-ld|5.8.9|linux|2.6.24-16-generic|200812180300
2862884|pass|200812|dagolden@cpan.org (DAGOLDEN)|Games-Trackword|1.06|i686-linux-64int-ld|5.8.9|linux|2.6.24-16-generic|200812180355
2862879|pass|200812|dagolden@cpan.org (DAGOLDEN)|Calendar-List|0.21|i686-linux-64int-ld|5.8.9|linux|2.6.24-16-generic|200812180354
2862208|pass|200812|dagolden@cpan.org (DAGOLDEN)|WWW-Scraper-ISBN-Pearson_Driver|0.10|i686-linux-64int-ld|5.8.9|linux|2.6.24-16-generic|200812180221
2862187|pass|200812|dagolden@cpan.org (DAGOLDEN)|Test-CPAN-Meta|0.12|i686-linux-64int-ld|5.8.9|linux|2.6.24-16-generic|200812180217
2862184|pass|200812|dagolden@cpan.org (DAGOLDEN)|WWW-Scraper-ISBN-ORA_Driver|0.09|i686-linux-64int-ld|5.8.9|linux|2.6.24-16-generic|200812180217
2861137|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.0-release|200812180001
2861132|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.02|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.0-release|200812180001
2861131|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.01|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.0-release|200812180000
2860312|pass|200812|stsc@refcnt.org ("Steven Schubiger")|CPAN-Testers-WWW-Reports-Mailer|0.10|i686-linux|5.10.0|linux|2.6.18-4-686|200812172300
2860309|pass|200812|stsc@refcnt.org ("Steven Schubiger")|CPAN-Testers-Common-DBUtils|0.03|i686-linux|5.10.0|linux|2.6.18-4-686|200812172300
2860244|pass|200812|dagolden@cpan.org (DAGOLDEN)|Test-YAML-Meta|0.11|i686-linux-64int-ld|5.8.9|linux|2.6.24-16-generic|200812171651
2859850|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|darwin-thread-multi-64int-2level|5.8.8|darwin|8.11.0|200812172101
2859845|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|darwin-thread-multi-64int-2level|5.8.6|darwin|8.11.0|200812172100
2859842|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.03|darwin-thread-multi-64int-2level|5.10.0|darwin|8.11.0|200812172059
2859233|pass|200812|srezic@cpan.org|CPAN-Testers-Common-DBUtils|0.03|amd64-freebsd-thread-multi|5.10.0|freebsd|7.0-release|200812172030
2859210|pass|200812|dagolden@cpan.org (DAGOLDEN)|Mail-Outlook|0.14|i686-linux-64int-ld|5.8.9|linux|2.6.24-16-generic|200812171429
2858943|pass|200812|dagolden@cpan.org (DAGOLDEN)|WWW-UsePerl-Journal-Thread|0.12|i686-linux-64int-ld|5.8.9|linux|2.6.24-16-generic|200812171350
2858942|pass|200812|dagolden@cpan.org (DAGOLDEN)|WWW-UsePerl-Journal|0.22|i686-linux-64int-ld|5.8.9|linux|2.6.24-16-generic|200812171350
2858873|pass|200812|dagolden@cpan.org (DAGOLDEN)|CPAN-WWW-Testers-Generator|0.30|i686-linux-64int-ld|5.8.9|linux|2.6.24-16-generic|200812171342
2858473|pass|200812|dagolden@cpan.org (DAGOLDEN)|CPAN-Testers-WWW-Statistics|0.52|i686-linux-64int-ld|5.8.9|linux|2.6.24-16-generic|200812171250
2858223|pass|200812|bingos@cpan.org|Test-YAML-Meta|0.11|i386-netbsd-thread-multi-64int|5.8.9|netbsd|4.0|200812171715
2857017|pass|200812|srezic@cpan.org|CPAN-Testers-Common-DBUtils|0.03|amd64-freebsd|5.8.9|freebsd|7.0-release|200812171540
2856967|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|Mail-Outlook|0.14|s390x-linux-thread-multi|5.10.0|linux|2.6.16.60-0.31-default|200812171613
2856669|pass|200812|srezic@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.10|amd64-freebsd|5.8.9|freebsd|7.0-release|200812171540
2856665|pass|200812|srezic@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.10|amd64-freebsd|5.8.8|freebsd|7.0-release|200812171540
2856660|pass|200812|srezic@cpan.org|CPAN-Testers-Common-DBUtils|0.03|amd64-freebsd|5.8.8|freebsd|7.0-release|200812171540
2856403|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|Mail-Outlook|0.14|s390x-linux|5.10.0|linux|2.6.16.60-0.31-default|200812171510
2856157|pass|200812|david@cantrell.org.uk|CPAN-Testers-WWW-Reports-Mailer|0.08|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200812171351
2856101|pass|200812|david@cantrell.org.uk|CPAN-Testers-Common-DBUtils|0.01|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200812171342
2855779|pass|200812|david@cantrell.org.uk|CPAN-Testers-Common-DBUtils|0.01|IP35-irix-64int|5.8.8|irix|6.5|200812171428
2855440|cpan|200812|BARBIE|CPAN-Testers-WWW-Reports-Mailer|0.10||0|||200812171408
2855403|cpan|200812|BARBIE|CPAN-Testers-WWW-Reports-Mailer|0.09||0|||200812171406
2855159|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.02|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.0-release|200812171214
2855156|pass|200812|srezic@cpan.org|CPAN-Testers-Common-DBUtils|0.03|amd64-freebsd|5.10.0|freebsd|7.0-release|200812171332
2855154|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.01|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.0-release|200812171213
2855026|pass|200812|stro@cpan.org|CPAN-Testers-Common-DBUtils|0.02|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.00|200812171423
2854900|cpan|200812|BARBIE|CPAN-Testers-Common-DBUtils|0.03||0|||200812171309
2854304|pass|200812|stro@cpan.org|CPAN-Testers-Common-DBUtils|0.02|MSWin32-x86-multi-thread|5.8.8|MSWin32|5.00|200812171223
2854053|pass|200812|david@cantrell.org.uk|CPAN-Testers-WWW-Reports-Mailer|0.08|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200812170324
2854051|pass|200812|david@cantrell.org.uk|CPAN-Testers-WWW-Reports-Mailer|0.08|i686-linux|5.8.8|linux|2.4.27-3-686|200812170924
2854050|pass|200812|david@cantrell.org.uk|CPAN-Testers-WWW-Reports-Mailer|0.08|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200812170924
2853818|pass|200812|david@cantrell.org.uk|CPAN-Testers-Common-DBUtils|0.01|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200812170249
2853645|pass|200812|david@cantrell.org.uk|CPAN-Testers-Common-DBUtils|0.01|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200812170835
2853613|pass|200812|david@cantrell.org.uk|CPAN-Testers-Common-DBUtils|0.01|i686-linux|5.8.8|linux|2.4.27-3-686|200812170831
2853582|pass|200812|dagolden@cpan.org (DAGOLDEN)|Data-Phrasebook-Loader-YAML|0.09|i686-linux-64int-ld|5.8.9|linux|2.6.24-16-generic|200812170330
2853581|pass|200812|dagolden@cpan.org (DAGOLDEN)|Data-Phrasebook|0.29|i686-linux-64int-ld|5.8.9|linux|2.6.24-16-generic|200812170330
2853394|pass|200812|dagolden@cpan.org (DAGOLDEN)|Regexp-Log-Common|0.05|i686-linux-64int-ld|5.8.9|linux|2.6.24-16-generic|200812170312
2853363|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-DBUtils|0.02|s390x-linux-thread-multi|5.8.9|linux|2.6.16.60-0.31-default|200812170907
2852671|pass|200812|dagolden@cpan.org (DAGOLDEN)|Parse-CPAN-Distributions|0.05|i686-linux-64int-ld|5.8.9|linux|2.6.24-16-generic|200812170153
2852658|fail|200812|dagolden@cpan.org (DAGOLDEN)|WWW-Scraper-ISBN-Amazon_Driver|0.14|i686-linux-64int-ld|5.8.9|linux|2.6.24-16-generic|200812170151
2852655|pass|200812|dagolden@cpan.org (DAGOLDEN)|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i686-linux-64int-ld|5.8.9|linux|2.6.24-16-generic|200812170152
2851083|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-DBUtils|0.02|s390x-linux|5.8.9|linux|2.6.16.60-0.31-default|200812170512
2850688|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-DBUtils|0.02|s390x-linux-thread-multi|5.8.9|linux|2.6.18-92.1.18.el5|200812170432
2850308|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-DBUtils|0.02|s390x-linux|5.8.9|linux|2.6.18-92.1.18.el5|200812170358
2849016|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|Mail-Outlook|0.14|s390x-linux|5.6.2|linux|2.6.16.60-0.31-default|200812170211
2848854|pass|200812|dagolden@cpan.org (DAGOLDEN)|CPAN-Testers-WWW-Reports-Mailer|0.08|i686-linux-64int-ld|5.8.9|linux|2.6.24-16-generic|200812170101
2848424|pass|200812|dagolden@cpan.org (DAGOLDEN)|CPAN-Testers-Common-DBUtils|0.02|i686-linux-64int-ld|5.8.9|linux|2.6.24-16-generic|200812170030
2846571|pass|200812|mw487.yahoo.com@gmail.com|CPAN-Testers-Common-DBUtils|0.01|cygwin-thread-multi-64int|5.8.8|cygwin|1.5.24(0.15642)|200812161640
2846108|pass|200812|stsc@refcnt.org ("Steven Schubiger")|Games-Trackword|1.06|i686-linux|5.10.0|linux|2.6.18-4-686|200812162144
2846084|pass|200812|stsc@refcnt.org ("Steven Schubiger")|Calendar-List|0.21|i686-linux|5.10.0|linux|2.6.18-4-686|200812162141
2843738|pass|200812|vpit@cpan.org|CPAN-Testers-Common-DBUtils|0.02|x86_64-linux-thread-multi|5.10.0|linux|2.6.26.3-fuuka.profvince.com|200812161724
2843736|pass|200812|vpit@cpan.org|CPAN-Testers-Common-DBUtils|0.01|x86_64-linux-thread-multi|5.10.0|linux|2.6.26.3-fuuka.profvince.com|200812161724
2843566|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.02|i386-netbsd-thread-multi-64int|5.8.9|netbsd|4.0|200812161610
2843563|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.01|i386-netbsd-thread-multi-64int|5.8.9|netbsd|4.0|200812161610
2843258|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.02|i686-linux-thread-multi-64int|5.10.0|linux|2.4.26|200812161544
2843256|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.01|i686-linux-thread-multi-64int|5.10.0|linux|2.4.26|200812161544
2842371|pass|200812|JOST@cpan.org ("Josts Smokehouse")|CPAN-Testers-Common-DBUtils|0.02|i86pc-solaris-64int|5.10.0|solaris|2.11|200812161449
2842037|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-DBUtils|0.02|s390x-linux-thread-multi|5.8.8|linux|2.6.16.60-0.31-default|200812161305
2841901|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.02|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.0-release|200812161118
2841896|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.01|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.0-release|200812161118
2841693|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-DBUtils|0.02|s390x-linux-thread-multi|5.8.8|linux|2.6.18-92.1.18.el5|200812161155
2841673|pass|200812|salvacpan@gmail.com ("Salvador Fandino")|CPAN-Testers-Common-DBUtils|0.01|sparc64-netbsd|5.10.0|netbsd|4.0_rc5|200812161146
2841595|pass|200812|salvacpan@gmail.com ("Salvador Fandino")|CPAN-Testers-WWW-Reports-Mailer|0.08|sparc64-netbsd|5.10.0|netbsd|4.0_rc5|200812161131
2841590|pass|200812|salvacpan@gmail.com ("Salvador Fandino")|CPAN-Testers-Common-DBUtils|0.02|sparc64-netbsd|5.10.0|netbsd|4.0_rc5|200812161131
2841553|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-DBUtils|0.02|s390x-linux|5.8.8|linux|2.6.18-92.1.18.el5|200812161122
2841513|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-DBUtils|0.02|s390x-linux|5.8.8|linux|2.6.16.60-0.31-default|200812161113
2841207|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-DBUtils|0.02|s390x-linux-thread-multi|5.10.0|linux|2.6.18-92.el5|200812161027
2841172|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-DBUtils|0.02|s390x-linux-thread-multi|5.10.0|linux|2.6.16.60-0.31-default|200812161019
2841097|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-DBUtils|0.02|s390x-linux|5.10.0|linux|2.6.16.60-0.31-default|200812161010
2841087|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-DBUtils|0.02|s390x-linux|5.10.0|linux|2.6.18-92.el5|200812161007
2840319|pass|200812|imacat@mail.imacat.idv.tw|CPAN-Testers-WWW-Reports-Mailer|0.08|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.22.10|200812161452
2840308|pass|200812|imacat@mail.imacat.idv.tw|CPAN-Testers-Common-DBUtils|0.02|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.22.10|200812161448
2839655|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.02|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.0-release|200812160217
2839654|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.01|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.0-release|200812160215
2839443|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.02|darwin-thread-multi-64int-2level|5.8.8|darwin|8.11.0|200812160051
2839442|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.02|darwin-thread-multi-64int-2level|5.8.6|darwin|8.11.0|200812160049
2839437|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.02|darwin-thread-multi-64int-2level|5.10.0|darwin|8.11.0|200812160048
2838554|pass|200812|srezic@cpan.org|CPAN-Testers-Common-DBUtils|0.02|amd64-freebsd|5.10.0|freebsd|7.0-release|200812152146
2838155|pass|200812|srezic@cpan.org|CPAN-Testers-Common-DBUtils|0.02|amd64-freebsd-thread-multi|5.10.0|freebsd|7.0-release|200812152157
2837967|pass|200812|stsc@refcnt.org ("Steven Schubiger")|CPAN-Testers-Common-DBUtils|0.02|i686-linux|5.10.0|linux|2.6.18-4-686|200812152145
2837217|pass|200812|JOST@cpan.org ("Josts Smokehouse")|CPAN-Testers-Common-DBUtils|0.01|i86pc-solaris-64int|5.10.0|solaris|2.11|200812151821
2837216|pass|200812|JOST@cpan.org ("Josts Smokehouse")|CPAN-Testers-WWW-Reports-Mailer|0.08|i86pc-solaris-64int|5.10.0|solaris|2.11|200812151821
2837147|pass|200812|srezic@cpan.org|CPAN-Testers-Common-DBUtils|0.02|amd64-freebsd|5.8.8|freebsd|7.0-release|200812151748
2837140|pass|200812|srezic@cpan.org|CPAN-Testers-Common-DBUtils|0.02|amd64-freebsd|5.8.9|freebsd|7.0-release|200812151748
2836863|cpan|200812|BARBIE|CPAN-Testers-Common-DBUtils|0.02||0|||200812151614
2836606|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.01|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0|200812151319
2836496|pass|200812|stsc@refcnt.org ("Steven Schubiger")|CPAN-Testers-WWW-Reports-Mailer|0.08|i686-linux|5.10.0|linux|2.6.18-4-686|200812151329
2836495|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.01|i386-netbsd-thread-multi-64int|5.8.8|netbsd|4.0|200812151229
2836494|pass|200812|stsc@refcnt.org ("Steven Schubiger")|CPAN-Testers-Common-DBUtils|0.01|i686-linux|5.10.0|linux|2.6.18-4-686|200812151329
2836377|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-DBUtils|0.01|s390x-linux-thread-multi|5.8.8|linux|2.6.16.60-0.31-default|200812151240
2836146|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-DBUtils|0.01|s390x-linux-thread-multi|5.8.8|linux|2.6.18-92.el5|200812151108
2836032|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-DBUtils|0.01|s390x-linux|5.8.8|linux|2.6.16.60-0.31-default|200812151042
2836013|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-DBUtils|0.01|s390x-linux|5.8.8|linux|2.6.18-92.el5|200812151036
2835938|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-DBUtils|0.01|s390x-linux-thread-multi|5.10.0|linux|2.6.16.60-0.31-default|200812151011
2835916|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-DBUtils|0.01|s390x-linux|5.10.0|linux|2.6.18-92.el5|200812151004
2835857|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-DBUtils|0.01|s390x-linux|5.10.0|linux|2.6.16.60-0.31-default|200812150952
2835826|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Reports-Mailer|0.08|s390x-linux-thread-multi|5.10.0|linux|2.6.18-92.el5|200812150943
2835825|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-Common-DBUtils|0.01|s390x-linux-thread-multi|5.10.0|linux|2.6.18-92.el5|200812150943
2832589|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.01|darwin-thread-multi-64int-2level|5.8.8|darwin|8.11.0|200812141851
2832580|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.01|darwin-thread-multi-64int-2level|5.8.6|darwin|8.11.0|200812141849
2832572|pass|200812|bingos@cpan.org|CPAN-Testers-Common-DBUtils|0.01|darwin-thread-multi-64int-2level|5.10.0|darwin|8.11.0|200812141848
2832388|pass|200812|vovkasm@gmail.com|Regexp-Log-Common|0.05|amd64-freebsd|5.10.0|freebsd|6.2-release-p1|200812141326
2831988|pass|200812|srezic@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.08|amd64-freebsd-thread-multi|5.10.0|freebsd|7.0-release|200812141806
2831987|pass|200812|srezic@cpan.org|CPAN-Testers-Common-DBUtils|0.01|amd64-freebsd-thread-multi|5.10.0|freebsd|7.0-release|200812141806
2831366|pass|200812|srezic@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.08|amd64-freebsd|5.8.8|freebsd|7.0-release|200812141648
2831363|pass|200812|srezic@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.08|amd64-freebsd|5.8.9|freebsd|7.0-release|200812141648
2831177|pass|200812|srezic@cpan.org|CPAN-Testers-WWW-Reports-Mailer|0.08|amd64-freebsd|5.10.0|freebsd|7.0-release|200812141618
2831176|pass|200812|srezic@cpan.org|CPAN-Testers-Common-DBUtils|0.01|amd64-freebsd|5.10.0|freebsd|7.0-release|200812141618
2829541|pass|200812|srezic@cpan.org|CPAN-Testers-Common-DBUtils|0.01|amd64-freebsd|5.8.8|freebsd|7.0-release|200812141258
2829540|pass|200812|srezic@cpan.org|CPAN-Testers-Common-DBUtils|0.01|amd64-freebsd|5.8.9|freebsd|7.0-release|200812141258
2829497|cpan|200812|BARBIE|CPAN-Testers-WWW-Reports-Mailer|0.08||0|||200812141249
2829106|cpan|200812|BARBIE|CPAN-Testers-Common-DBUtils|0.01||0|||200812141127
2828164|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal-Thread|0.12|s390x-linux|5.8.8|linux|2.6.16.60-0.31-default|200812140650
2828162|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal|0.22|s390x-linux|5.8.8|linux|2.6.16.60-0.31-default|200812140650
2828010|pass|200812|stsc@refcnt.org ("Steven Schubiger")|WWW-Scraper-ISBN-ORA_Driver|0.09|i686-linux|5.10.0|linux|2.6.18-4-686|200812140557
2827999|pass|200812|stsc@refcnt.org ("Steven Schubiger")|WWW-Scraper-ISBN-Pearson_Driver|0.10|i686-linux|5.10.0|linux|2.6.18-4-686|200812140554
2825793|pass|200812|bingos@cpan.org|Test-YAML-Meta|0.11|OpenBSD.i386-openbsd-thread-multi-64int|5.8.9|openbsd|4.2|200812131729
2824171|fail|200812|srezic@cpan.org|WWW-Scraper-ISBN-ORA_Driver|0.09|amd64-freebsd|5.8.9|freebsd|7.0-release|200812131225
2822681|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal-Thread|0.12|s390x-linux-thread-multi|5.6.2|linux|2.6.18-92.1.17.el5|200812131010
2822680|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal|0.22|s390x-linux-thread-multi|5.6.2|linux|2.6.18-92.1.17.el5|200812131010
2805145|pass|200812|bingos@cpan.org|Test-YAML-Meta|0.11|i386-freebsd-thread-multi-64int|5.8.9|freebsd|6.2-release|200812102100
2804552|fail|200812|srezic@cpan.org|CPAN-YACSmoke-Plugin-WebList|0.05|amd64-freebsd|5.8.8|freebsd|7.0-release|200812102258
2804544|fail|200812|srezic@cpan.org|CPAN-YACSmoke-Plugin-WebList|0.05|amd64-freebsd|5.8.9|freebsd|7.0-release|200812102258
2799747|pass|200812|bingos@cpan.org|Test-YAML-Meta|0.11|i86pc-solaris-thread-multi-64int|5.8.9|solaris|2.10|200812101330
2796635|pass|200812|srezic@cpan.org|GD-Chart-Radial|0.07|amd64-freebsd|5.8.9|freebsd|7.0-release|200812100417
2796244|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal-Thread|0.12|s390x-linux|5.10.0|linux|2.6.18-92.el5|200812100337
2796242|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal|0.22|s390x-linux|5.10.0|linux|2.6.18-92.el5|200812100337
2795808|pass|200812|srezic@cpan.org|Mail-File|0.08|amd64-freebsd|5.8.9|freebsd|7.0-release|200812100100
2795752|pass|200812|srezic@cpan.org|Data-Phrasebook-Loader-Ini|0.10|amd64-freebsd|5.8.9|freebsd|7.0-release|200812100052
2795721|pass|200812|srezic@cpan.org|Data-Phrasebook-Loader-DBI|0.11|amd64-freebsd|5.8.8|freebsd|7.0-release|200812100047
2795499|pass|200812|srezic@cpan.org|CPAN-YACSmoke-Plugin-NNTPWeb|0.06|amd64-freebsd|5.8.9|freebsd|7.0-release|200812100023
2795095|pass|200812|srezic@cpan.org|Data-Phrasebook-Loader-Ini|0.10|amd64-freebsd|5.8.8|freebsd|7.0-release|200812092201
2795033|pass|200812|srezic@cpan.org|CPAN-YACSmoke-Plugin-Outlook|0.06|amd64-freebsd|5.8.8|freebsd|7.0-release|200812092201
2794880|pass|200812|srezic@cpan.org|Mail-File|0.08|amd64-freebsd|5.8.8|freebsd|7.0-release|200812092201
2794877|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|Test-YAML-Meta|0.11|s390x-linux|5.6.2|linux|2.6.18-92.1.17.el5|200812100037
2794785|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal-Thread|0.12|s390x-linux|5.6.2|linux|2.6.16.60-0.31-default|200812092332
2794430|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal|0.22|s390x-linux|5.6.2|linux|2.6.16.60-0.31-default|200812092332
2794150|pass|200812|srezic@cpan.org|CPAN-YACSmoke-Plugin-NNTP|0.05|amd64-freebsd|5.8.9|freebsd|7.0-release|200812092124
2794025|pass|200812|srezic@cpan.org|Data-Phrasebook-Loader-XML|0.12|amd64-freebsd|5.8.9|freebsd|7.0-release|200812092124
2793798|pass|200812|srezic@cpan.org|Data-Phrasebook-Loader-DBI|0.11|amd64-freebsd|5.8.9|freebsd|7.0-release|200812092124
2793649|pass|200812|srezic@cpan.org|Data-Phrasebook-Loader-XML|0.12|amd64-freebsd|5.8.8|freebsd|7.0-release|200812092201
2793637|pass|200812|srezic@cpan.org|CPAN-YACSmoke-Plugin-Outlook|0.06|amd64-freebsd|5.8.9|freebsd|7.0-release|200812092124
2793595|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal-Thread|0.12|s390x-linux-thread-multi|5.10.0|linux|2.6.18-92.el5|200812092202
2793586|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal|0.22|s390x-linux-thread-multi|5.10.0|linux|2.6.18-92.el5|200812092201
2789880|pass|200812|srezic@cpan.org|GD-Chart-Radial|0.07|amd64-freebsd|5.8.8|freebsd|7.0-release|200812091151
2789708|pass|200812|srezic@cpan.org|Data-Phrasebook|0.29|amd64-freebsd|5.8.8|freebsd|7.0-release|200812091129
2789321|pass|200812|srezic@cpan.org|Test-CPAN-Meta|0.12|amd64-freebsd|5.8.8|freebsd|7.0-release|200812091306
2789234|pass|200812|srezic@cpan.org|Calendar-List|0.21|amd64-freebsd|5.8.8|freebsd|7.0-release|200812091108
2788759|pass|200812|srezic@cpan.org|WWW-UsePerl-Journal-Thread|0.12|amd64-freebsd|5.8.8|freebsd|7.0-release|200812091330
2787823|pass|200812|srezic@cpan.org|WWW-Scraper-ISBN-Yahoo_Driver|0.08|amd64-freebsd|5.8.8|freebsd|7.0-release|200812091329
2787793|pass|200812|srezic@cpan.org|Mail-Outlook|0.14|amd64-freebsd|5.8.8|freebsd|7.0-release|200812091214
2787141|pass|200812|srezic@cpan.org|CPAN-WWW-Testers-Generator|0.30|amd64-freebsd|5.8.8|freebsd|7.0-release|200812091123
2786702|pass|200812|srezic@cpan.org|WWW-Scraper-ISBN-Amazon_Driver|0.14|amd64-freebsd|5.8.8|freebsd|7.0-release|200812091329
2786701|pass|200812|srezic@cpan.org|WWW-Scraper-ISBN-Pearson_Driver|0.10|amd64-freebsd|5.8.8|freebsd|7.0-release|200812091329
2786546|pass|200812|srezic@cpan.org|WWW-UsePerl-Journal|0.22|amd64-freebsd|5.8.8|freebsd|7.0-release|200812091330
2786259|pass|200812|srezic@cpan.org|Test-YAML-Meta|0.11|amd64-freebsd|5.8.8|freebsd|7.0-release|200812091311
2785237|pass|200812|srezic@cpan.org|Regexp-Log-Common|0.05|amd64-freebsd|5.8.8|freebsd|7.0-release|200812091250
2785191|pass|200812|chris@bingosnet.co.uk|WWW-UsePerl-Journal|0.22|i386-netbsd-thread-multi-64int|5.8.8|netbsd|3.1|200812091151
2784959|pass|200812|srezic@cpan.org|Parse-CPAN-Distributions|0.05|amd64-freebsd|5.8.8|freebsd|7.0-release|200812091236
2784291|pass|200812|srezic@cpan.org|Data-FormValidator-Constraints-Words|0.03|amd64-freebsd|5.8.8|freebsd|7.0-release|200812091127
2783609|pass|200812|srezic@cpan.org|Games-Trackword|1.06|amd64-freebsd|5.8.8|freebsd|7.0-release|200812091151
2783565|pass|200812|srezic@cpan.org|Finance-Currency-Convert-XE|0.15|amd64-freebsd|5.8.8|freebsd|7.0-release|200812091148
2783234|pass|200812|srezic@cpan.org|Data-Phrasebook-Loader-YAML|0.09|amd64-freebsd|5.8.8|freebsd|7.0-release|200812091129
2782987|pass|200812|srezic@cpan.org|CPAN-Testers-WWW-Statistics|0.52|amd64-freebsd|5.8.8|freebsd|7.0-release|200812091123
2779535|pass|200812|srezic@cpan.org|Data-FormValidator-Constraints-Words|0.03|amd64-freebsd|5.8.9|freebsd|7.0-release|200812082233
2779426|pass|200812|srezic@cpan.org|Finance-Currency-Convert-XE|0.15|amd64-freebsd|5.8.9|freebsd|7.0-release|200812082250
2778891|pass|200812|stro@cpan.org|CPAN-WWW-Testers|0.37|MSWin32-x86-multi-thread|5.8.8|MSWin32|5.00|200812082312
2778482|pass|200812|salvacpan@gmail.com ("Salvador Fandino")|Test-CPAN-Meta|0.12|sparc64-netbsd|5.10.0|netbsd|4.0_rc5|200812082043
2777263|pass|200812|srezic@cpan.org|Calendar-List|0.21|amd64-freebsd|5.8.9|freebsd|7.0-release|200812081700
2777032|pass|200812|srezic@cpan.org|Games-Trackword|1.06|amd64-freebsd|5.8.9|freebsd|7.0-release|200812081700
2777004|pass|200812|bingos@cpan.org|Test-YAML-Meta|0.11|i686-linux-thread-multi-64int-ld|5.8.9|linux|2.6.16.38|200812081322
2776696|pass|200812|stro@cpan.org|WWW-UsePerl-Journal-Thread|0.12|MSWin32-x86-multi-thread|5.8.8|MSWin32|5.00|200812081729
2776276|pass|200812|srezic@cpan.org|Test-CPAN-Meta|0.12|amd64-freebsd|5.8.9|freebsd|7.0-release|200812081527
2776266|pass|200812|srezic@cpan.org|WWW-Scraper-ISBN-Pearson_Driver|0.10|amd64-freebsd|5.8.9|freebsd|7.0-release|200812081527
2774551|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal-Thread|0.12|s390x-linux|5.8.8|linux|2.6.18-92.el5|200812081020
2774550|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal|0.22|s390x-linux|5.8.8|linux|2.6.18-92.el5|200812081020
2774138|pass|200812|srezic@cpan.org|Test-YAML-Meta|0.11|amd64-freebsd|5.8.9|freebsd|7.0-release|200812080846
2771648|pass|200812|srezic@cpan.org|Mail-Outlook|0.14|amd64-freebsd|5.8.9|freebsd|7.0-release|200812072336
2770687|pass|200812|srezic@cpan.org|WWW-UsePerl-Journal-Thread|0.12|amd64-freebsd|5.8.9|freebsd|7.0-release|200812072153
2770542|pass|200812|srezic@cpan.org|WWW-UsePerl-Journal|0.22|amd64-freebsd|5.8.9|freebsd|7.0-release|200812072153
2770494|pass|200812|srezic@cpan.org|CPAN-WWW-Testers-Generator|0.30|amd64-freebsd|5.8.9|freebsd|7.0-release|200812072152
2770439|pass|200812|srezic@cpan.org|CPAN-Testers-WWW-Statistics|0.52|amd64-freebsd|5.8.9|freebsd|7.0-release|200812072046
2770408|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|Test-YAML-Meta|0.11|s390x-linux-thread-multi|5.10.0|linux|2.6.18-92.el5|200812072142
2768217|pass|200812|stsc@refcnt.org ("Steven Schubiger")|Test-YAML-Meta|0.11|i686-linux|5.10.0|linux|2.6.18-4-686|200812071740
2767804|pass|200812|salvacpan@gmail.com ("Salvador Fandino")|Data-Phrasebook-Loader-YAML|0.09|sparc64-netbsd|5.10.0|netbsd|4.0_rc5|200812071541
2767802|pass|200812|salvacpan@gmail.com ("Salvador Fandino")|Data-Phrasebook|0.29|sparc64-netbsd|5.10.0|netbsd|4.0_rc5|200812071540
2767220|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|Mail-Outlook|0.14|s390x-linux|5.6.2|linux|2.6.18-92.1.17.el5|200812071210
2767044|pass|200812|srezic@cpan.org|WWW-Scraper-ISBN-Amazon_Driver|0.14|amd64-freebsd|5.8.9|freebsd|7.0-release|200812071009
2766732|pass|200812|srezic@cpan.org|Regexp-Log-Common|0.05|amd64-freebsd|5.8.9|freebsd|7.0-release|200812071008
2766165|pass|200812|srezic@cpan.org|Data-Phrasebook-Loader-YAML|0.09|amd64-freebsd|5.8.9|freebsd|7.0-release|200812071006
2766020|pass|200812|srezic@cpan.org|Data-Phrasebook|0.29|amd64-freebsd|5.8.9|freebsd|7.0-release|200812071006
2765771|pass|200812|srezic@cpan.org|WWW-Scraper-ISBN-Yahoo_Driver|0.08|amd64-freebsd|5.8.9|freebsd|7.0-release|200812071009
2765548|pass|200812|srezic@cpan.org|Parse-CPAN-Distributions|0.05|amd64-freebsd|5.8.9|freebsd|7.0-release|200812071008
2764264|pass|200812|salvacpan@gmail.com ("Salvador Fandino")|Regexp-Log-Common|0.05|sparc64-netbsd|5.10.0|netbsd|4.0_rc5|200812070838
2758574|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|Test-YAML-Meta|0.11|s390x-linux|5.10.0|linux|2.6.16.60-0.31-default|200812061323
2756980|pass|200812|stro@cpan.org|WWW-UsePerl-Journal-Thread|0.12|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.00|200812060801
2756883|pass|200812|salvacpan@gmail.com ("Salvador Fandino")|Parse-CPAN-Distributions|0.05|sparc64-netbsd|5.10.0|netbsd|4.0_rc5|200812060629
2756854|pass|200812|salvacpan@gmail.com ("Salvador Fandino")|WWW-Scraper-ISBN-Yahoo_Driver|0.08|sparc64-netbsd|5.10.0|netbsd|4.0_rc5|200812060616
2756845|pass|200812|salvacpan@gmail.com ("Salvador Fandino")|WWW-Scraper-ISBN-Amazon_Driver|0.14|sparc64-netbsd|5.10.0|netbsd|4.0_rc5|200812060613
2755452|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal-Thread|0.12|s390x-linux|5.6.2|linux|2.6.18-92.1.17.el5|200812052256
2755450|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal|0.22|s390x-linux|5.6.2|linux|2.6.18-92.1.17.el5|200812052256
2754807|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|Parse-CPAN-Distributions|0.05|s390x-linux-thread-multi|5.6.2|linux|2.6.18-92.1.17.el5|200812052004
2747847|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal-Thread|0.12|s390x-linux-thread-multi|5.8.8|linux|2.6.18-92.el5|200812042250
2747844|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal|0.22|s390x-linux-thread-multi|5.8.8|linux|2.6.18-92.el5|200812042249
2747707|pass|200812|stro@cpan.org|WWW-Scraper-ISBN-Yahoo_Driver|0.08|MSWin32-x86-multi-thread|5.8.8|MSWin32|5.00|200812042333
2746594|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal-Thread|0.12|s390x-linux-thread-multi|5.8.8|linux|2.6.16.60-0.31-default|200812041910
2746593|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal|0.22|s390x-linux-thread-multi|5.8.8|linux|2.6.16.60-0.31-default|200812041910
2743353|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|Test-YAML-Meta|0.11|s390x-linux-thread-multi|5.10.0|linux|2.6.16.60-0.31-default|200812040922
2741657|pass|200812|stsc@refcnt.org ("Steven Schubiger")|Mail-Outlook|0.14|i686-linux|5.10.0|linux|2.6.18-4-686|200812032216
2736326|pass|200812|stsc@refcnt.org ("Steven Schubiger")|WWW-UsePerl-Journal-Thread|0.12|i686-linux|5.10.0|linux|2.6.18-4-686|200812030632
2736325|pass|200812|stsc@refcnt.org ("Steven Schubiger")|WWW-UsePerl-Journal|0.22|i686-linux|5.10.0|linux|2.6.18-4-686|200812030632
2727784|pass|200812|stsc@refcnt.org ("Steven Schubiger")|CPAN-Testers-WWW-Statistics|0.52|i686-linux|5.10.0|linux|2.6.18-4-686|200812011925
2723646|pass|200812|cpan@sourcentral.org ("Oliver Paukstadt")|Parse-CPAN-Distributions|0.05|s390x-linux-thread-multi|5.6.2|linux|2.6.16.60-0.31-default|200812010017
2719703|pass|200811|cpan@sourcentral.org ("Oliver Paukstadt")|Parse-CPAN-Distributions|0.05|s390x-linux|5.6.2|linux|2.6.18-92.1.17.el5|200811301527
2717789|pass|200811|cpan@sourcentral.org ("Oliver Paukstadt")|Parse-CPAN-Distributions|0.05|s390x-linux|5.6.2|linux|2.6.16.60-0.31-default|200811300911
2713941|pass|200811|sjn@pvv.org ("Salve J. Nilsen")|Test-YAML-Meta|0.11|x86_64-linux-thread-multi|5.10.0|linux|2.6.25|200811281705
2708214|pass|200811|srezic@cpan.org|Finance-Currency-Convert-XE|0.15|amd64-freebsd|5.8.9|freebsd|7.0-release|200811290019
2708013|pass|200811|srezic@cpan.org|Data-FormValidator-Constraints-Words|0.03|amd64-freebsd|5.8.9|freebsd|7.0-release|200811290018
2706461|pass|200811|srezic@cpan.org|Calendar-List|0.21|amd64-freebsd|5.8.9|freebsd|7.0-release|200811282003
2706347|pass|200811|srezic@cpan.org|Games-Trackword|1.06|amd64-freebsd|5.8.9|freebsd|7.0-release|200811282003
2705964|pass|200811|srezic@cpan.org|Test-CPAN-Meta|0.12|amd64-freebsd|5.8.9|freebsd|7.0-release|200811281757
2705798|pass|200811|srezic@cpan.org|WWW-Scraper-ISBN-Pearson_Driver|0.10|amd64-freebsd|5.8.9|freebsd|7.0-release|200811281757
2705691|pass|200811|srezic@cpan.org|WWW-Scraper-ISBN-ORA_Driver|0.09|amd64-freebsd|5.8.9|freebsd|7.0-release|200811281757
2705047|pass|200811|stsc@refcnt.org ("Steven Schubiger")|Test-CPAN-Meta|0.12|i686-linux|5.10.0|linux|2.6.18-4-686|200811281639
2704447|pass|200811|srezic@cpan.org|Test-YAML-Meta|0.11|amd64-freebsd|5.8.9|freebsd|7.0-release|200811281437
2703779|pass|200811|cpan@sourcentral.org ("Oliver Paukstadt")|Mail-Outlook|0.14|s390x-linux-thread-multi|5.10.0|linux|2.6.18-92.el5|200811281327
2699696|pass|200811|srezic@cpan.org|Data-Phrasebook|0.29|amd64-freebsd|5.8.9|freebsd|7.0-release|200811280030
2699688|pass|200811|srezic@cpan.org|Data-Phrasebook-Loader-YAML|0.09|amd64-freebsd|5.8.9|freebsd|7.0-release|200811280030
2699392|pass|200811|srezic@cpan.org|WWW-Scraper-ISBN-Yahoo_Driver|0.08|amd64-freebsd|5.8.9|freebsd|7.0-release|200811272323
2699375|pass|200811|srezic@cpan.org|WWW-Scraper-ISBN-Amazon_Driver|0.14|amd64-freebsd|5.8.9|freebsd|7.0-release|200811272323
2698458|pass|200811|stsc@refcnt.org ("Steven Schubiger")|Data-Phrasebook-Loader-YAML|0.09|i686-linux|5.10.0|linux|2.6.18-4-686|200811272109
2698453|pass|200811|stsc@refcnt.org ("Steven Schubiger")|Data-Phrasebook|0.29|i686-linux|5.10.0|linux|2.6.18-4-686|200811272108
2696139|pass|200811|stsc@refcnt.org ("Steven Schubiger")|Regexp-Log-Common|0.05|i686-linux|5.10.0|linux|2.6.18-4-686|200811271357
2691706|pass|200811|stsc@refcnt.org ("Steven Schubiger")|Parse-CPAN-Distributions|0.05|i686-linux|5.10.0|linux|2.6.18-4-686|200811261441
2691680|pass|200811|stsc@refcnt.org ("Steven Schubiger")|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i686-linux|5.10.0|linux|2.6.18-4-686|200811261432
2691670|pass|200811|stsc@refcnt.org ("Steven Schubiger")|WWW-Scraper-ISBN-Amazon_Driver|0.14|i686-linux|5.10.0|linux|2.6.18-4-686|200811261429
2687479|pass|200811|stro@cpan.org|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i686-linux|5.8.8|linux|2.4.27-2-386|200811260015
2679016|pass|200811|bingos@cpan.org|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.0-release|200811240653
2679012|pass|200811|bingos@cpan.org|WWW-Scraper-ISBN-Amazon_Driver|0.14|i386-freebsd-thread-multi-64int|5.8.9|freebsd|7.0-release|200811240648
2678739|pass|200811|JOST@cpan.org ("Josts Smokehouse")|Data-Phrasebook-Loader-DBI|0.11|i86pc-solaris-64int|5.8.9|solaris|2.11|200811241148
2678738|pass|200811|JOST@cpan.org ("Josts Smokehouse")|Data-Phrasebook-Loader-Ini|0.10|i86pc-solaris-64int|5.8.9|solaris|2.11|200811241148
2678736|pass|200811|JOST@cpan.org ("Josts Smokehouse")|Data-Phrasebook-Loader-XML|0.12|i86pc-solaris-64int|5.8.9|solaris|2.11|200811241148
2678730|pass|200811|JOST@cpan.org ("Josts Smokehouse")|Mail-File|0.08|i86pc-solaris-64int|5.8.9|solaris|2.11|200811241147
2678614|pass|200811|vpit@cpan.org|CPAN-WWW-Testers|0.37|i686-linux-thread-multi|5.10.0|linux|2.6.18.3-tmb-desktop-2mdvsmp|200811241055
2677615|pass|200811|rafl@debian.org|Mail-Outlook|0.14|x86_64-linux-multi|5.11.0|linux|2.6.26-1-xen-amd64|200811240351
2677603|pass|200811|rafl@debian.org|Parse-CPAN-Distributions|0.05|x86_64-linux-multi|5.11.0|linux|2.6.26-1-xen-amd64|200811240348
2677391|pass|200811|rafl@debian.org|WWW-UsePerl-Journal-Thread|0.12|x86_64-linux-multi|5.11.0|linux|2.6.26-1-xen-amd64|200811240250
2677390|pass|200811|rafl@debian.org|WWW-UsePerl-Journal|0.22|x86_64-linux-multi|5.11.0|linux|2.6.26-1-xen-amd64|200811240250
2677358|pass|200811|rafl@debian.org|CPAN-WWW-Testers-Generator|0.30|x86_64-linux-multi|5.11.0|linux|2.6.26-1-xen-amd64|200811240237
2677141|pass|200811|rafl@debian.org|CPAN-Testers-WWW-Statistics|0.52|x86_64-linux-multi|5.11.0|linux|2.6.26-1-xen-amd64|200811240142
2674933|pass|200811|dmdk1@comcast.net|Test-YAML-Meta|0.11|i486-linux-gnu|5.10.0|linux|2.6.24-15-server|200811230918
2674682|pass|200811|bingos@cpan.org|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.0-release|200811231020
2674678|pass|200811|bingos@cpan.org|WWW-Scraper-ISBN-Amazon_Driver|0.14|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.0-release|200811231016
2674533|pass|200811|bingos@cpan.org|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i386-freebsd-thread-multi-64int|5.8.8|freebsd|6.2-release|200811231048
2674527|pass|200811|bingos@cpan.org|WWW-Scraper-ISBN-Amazon_Driver|0.14|i386-freebsd-thread-multi-64int|5.8.8|freebsd|6.2-release|200811231045
2674502|pass|200811|bingos@cpan.org|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i386-freebsd-thread-multi-64int|5.10.0|freebsd|6.2-release|200811231037
2674493|pass|200811|bingos@cpan.org|WWW-Scraper-ISBN-Amazon_Driver|0.14|i386-freebsd-thread-multi-64int|5.10.0|freebsd|6.2-release|200811231033
2674384|pass|200811|rafl@debian.org|Data-Phrasebook-Loader-YAML|0.09|x86_64-linux-multi|5.11.0|linux|2.6.26-1-xen-amd64|200811231040
2674383|pass|200811|rafl@debian.org|Data-Phrasebook|0.29|x86_64-linux-multi|5.11.0|linux|2.6.26-1-xen-amd64|200811231040
2674251|pass|200811|rafl@debian.org|Regexp-Log-Common|0.05|x86_64-linux-multi|5.11.0|linux|2.6.26-1-xen-amd64|200811231002
2673435|pass|200811|rafl@debian.org|WWW-Scraper-ISBN-Yahoo_Driver|0.08|x86_64-linux-multi|5.11.0|linux|2.6.26-1-xen-amd64|200811230706
2673430|pass|200811|rafl@debian.org|WWW-Scraper-ISBN-Amazon_Driver|0.14|x86_64-linux-multi|5.11.0|linux|2.6.26-1-xen-amd64|200811230705
2671493|pass|200811|david@cantrell.org.uk|WWW-Scraper-ISBN-Yahoo_Driver|0.08|alpha-netbsd|5.10.0|netbsd|2.1.0_stable|200811222145
2671486|pass|200811|david@cantrell.org.uk|WWW-Scraper-ISBN-Amazon_Driver|0.14|alpha-netbsd|5.10.0|netbsd|2.1.0_stable|200811222143
2671400|pass|200811|david@cantrell.org.uk|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200811222111
2671393|pass|200811|david@cantrell.org.uk|WWW-Scraper-ISBN-Amazon_Driver|0.14|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200811222110
2671149|pass|200811|david@cantrell.org.uk|WWW-Scraper-ISBN-Yahoo_Driver|0.08|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200811221330
2671148|pass|200811|david@cantrell.org.uk|WWW-Scraper-ISBN-Amazon_Driver|0.14|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200811221329
2670865|pass|200811|david@cantrell.org.uk|WWW-Scraper-ISBN-Yahoo_Driver|0.08|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200811221803
2670855|pass|200811|david@cantrell.org.uk|WWW-Scraper-ISBN-Amazon_Driver|0.14|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200811221802
2670805|pass|200811|david@cantrell.org.uk|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i686-linux|5.8.8|linux|2.4.27-3-686|200811221757
2670802|pass|200811|david@cantrell.org.uk|WWW-Scraper-ISBN-Amazon_Driver|0.14|i686-linux|5.8.8|linux|2.4.27-3-686|200811221756
2670654|pass|200811|bingos@cpan.org|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.0-release|200811221728
2670633|pass|200811|bingos@cpan.org|WWW-Scraper-ISBN-Amazon_Driver|0.14|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.0-release|200811221724
2670570|pass|200811|vpit@cpan.org|WWW-Scraper-ISBN-Yahoo_Driver|0.08|x86_64-linux-thread-multi|5.10.0|linux|2.6.26.3-fuuka.profvince.com|200811221817
2670565|pass|200811|vpit@cpan.org|WWW-Scraper-ISBN-Amazon_Driver|0.14|x86_64-linux-thread-multi|5.10.0|linux|2.6.26.3-fuuka.profvince.com|200811221816
2669900|pass|200811|stro@cpan.org|WWW-Scraper-ISBN-Yahoo_Driver|0.08|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.00|200811221632
2669863|pass|200811|stro@cpan.org|WWW-Scraper-ISBN-Amazon_Driver|0.14|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.00|200811221628
2669316|pass|200811|bingos@cpan.org|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.16.38|200811221219
2669307|pass|200811|bingos@cpan.org|WWW-Scraper-ISBN-Amazon_Driver|0.14|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.16.38|200811221215
2669229|pass|200811|imacat@mail.imacat.idv.tw|WWW-Scraper-ISBN-Yahoo_Driver|0.08|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.22.10|200811221959
2669222|pass|200811|imacat@mail.imacat.idv.tw|WWW-Scraper-ISBN-Amazon_Driver|0.14|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.22.10|200811221957
2666669|pass|200811|bingos@cpan.org|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.16.38|200811212332
2666668|pass|200811|bingos@cpan.org|WWW-Scraper-ISBN-Amazon_Driver|0.14|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.16.38|200811212329
2665787|pass|200811|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i386-dragonfly-thread-multi-64int|5.8.9|dragonfly|2.0.1-release|200811211719
2665786|pass|200811|bingos@cpan.org|Data-Phrasebook|0.29|i386-dragonfly-thread-multi-64int|5.8.9|dragonfly|2.0.1-release|200811211719
2665723|pass|200811|stro@cpan.org|WWW-Scraper-ISBN-Amazon_Driver|0.14|MSWin32-x86-multi-thread|5.8.8|MSWin32|5.00|200811211850
2664772|pass|200811|JOST@cpan.org ("Josts Smokehouse")|CPAN-YACSmoke-Plugin-Outlook|0.06|i86pc-solaris-64int|5.8.9|solaris|2.11|200811211141
2660368|pass|200811|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal-Thread|0.12|s390x-linux-thread-multi|5.10.0|linux|2.6.16.60-0.31-default|200811201957
2660365|pass|200811|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal|0.22|s390x-linux-thread-multi|5.10.0|linux|2.6.16.60-0.31-default|200811201957
2660169|pass|200811|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal-Thread|0.12|s390x-linux|5.10.0|linux|2.6.16.60-0.31-default|200811201923
2660167|pass|200811|cpan@sourcentral.org ("Oliver Paukstadt")|WWW-UsePerl-Journal|0.22|s390x-linux|5.10.0|linux|2.6.16.60-0.31-default|200811201923
2659813|pass|200811|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-WWW-Testers-Generator|0.30|s390x-linux-thread-multi|5.10.0|linux|2.6.16.60-0.31-default|200811201834
2659608|pass|200811|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-WWW-Testers-Generator|0.30|s390x-linux|5.10.0|linux|2.6.16.60-0.31-default|200811201809
2658718|pass|200811|srezic@cpan.org|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i386-freebsd-thread-multi|5.8.8|freebsd|6.1-release|200811201430
2658694|pass|200811|srezic@cpan.org|WWW-Scraper-ISBN-Amazon_Driver|0.14|i386-freebsd-thread-multi|5.8.8|freebsd|6.1-release|200811201429
2658643|pass|200811|bingos@cpan.org|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i386-dragonfly-thread-multi-64int|5.8.9|dragonfly|2.0.1-release|200811201319
2658635|pass|200811|bingos@cpan.org|WWW-Scraper-ISBN-Amazon_Driver|0.14|i386-dragonfly-thread-multi-64int|5.8.9|dragonfly|2.0.1-release|200811201315
2657769|pass|200811|bingos@cpan.org|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i86pc-solaris-thread-multi-64int|5.8.4|solaris|2.10|200811200919
2657737|pass|200811|bingos@cpan.org|WWW-Scraper-ISBN-Amazon_Driver|0.14|i86pc-solaris-thread-multi-64int|5.8.4|solaris|2.10|200811200911
2656857|pass|200811|JOST@cpan.org ("Josts Smokehouse")|Finance-Currency-Convert-XE|0.15|i86pc-solaris-64int|5.8.9|solaris|2.11|200811200749
2656378|pass|200811|JOST@cpan.org ("Josts Smokehouse")|Data-FormValidator-Constraints-Words|0.03|i86pc-solaris-64int|5.8.9|solaris|2.11|200811200628
2653887|pass|200811|JOST@cpan.org ("Josts Smokehouse")|Games-Trackword|1.06|i86pc-solaris-64int|5.8.9|solaris|2.11|200811192318
2653886|pass|200811|JOST@cpan.org ("Josts Smokehouse")|Calendar-List|0.21|i86pc-solaris-64int|5.8.9|solaris|2.11|200811192318
2652883|pass|200811|JOST@cpan.org ("Josts Smokehouse")|Test-YAML-Meta|0.11|i86pc-solaris-64int|5.8.9|solaris|2.11|200811192026
2652882|pass|200811|JOST@cpan.org ("Josts Smokehouse")|Test-CPAN-Meta|0.12|i86pc-solaris-64int|5.8.9|solaris|2.11|200811192026
2652880|pass|200811|JOST@cpan.org ("Josts Smokehouse")|WWW-Scraper-ISBN-Pearson_Driver|0.10|i86pc-solaris-64int|5.8.9|solaris|2.11|200811192025
2652879|pass|200811|JOST@cpan.org ("Josts Smokehouse")|WWW-Scraper-ISBN-ORA_Driver|0.09|i86pc-solaris-64int|5.8.9|solaris|2.11|200811192026
2652577|pass|200811|srezic@cpan.org|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i386-freebsd-thread-multi|5.10.0|freebsd|6.1-release|200811191845
2652570|pass|200811|srezic@cpan.org|WWW-Scraper-ISBN-Amazon_Driver|0.14|i386-freebsd-thread-multi|5.10.0|freebsd|6.1-release|200811191844
2652125|fail|200811|bingos@cpan.org|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i86pc-solaris-thread-multi-64int|5.8.8|solaris|2.10|200811191511
2652104|pass|200811|bingos@cpan.org|WWW-Scraper-ISBN-Amazon_Driver|0.14|i86pc-solaris-thread-multi-64int|5.8.8|solaris|2.10|200811191507
2649926|pass|200811|JOST@cpan.org ("Josts Smokehouse")|Mail-Outlook|0.14|i86pc-solaris-64int|5.8.9|solaris|2.11|200811190615
2649479|pass|200811|JOST@cpan.org ("Josts Smokehouse")|WWW-UsePerl-Journal-Thread|0.12|i86pc-solaris-64int|5.8.9|solaris|2.11|200811190454
2649478|pass|200811|JOST@cpan.org ("Josts Smokehouse")|WWW-UsePerl-Journal|0.22|i86pc-solaris-64int|5.8.9|solaris|2.11|200811190454
2649419|pass|200811|JOST@cpan.org ("Josts Smokehouse")|CPAN-WWW-Testers-Generator|0.30|i86pc-solaris-64int|5.8.9|solaris|2.11|200811190442
2649162|pass|200811|JOST@cpan.org ("Josts Smokehouse")|CPAN-Testers-WWW-Statistics|0.52|i86pc-solaris-64int|5.8.9|solaris|2.11|200811190322
2648876|pass|200811|bingos@cpan.org|Regexp-Log-Common|0.05|i86pc-solaris-thread-multi-64int|5.10.0|solaris|2.10|200811190018
2648183|pass|200811|bingos@cpan.org|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i86pc-solaris-thread-multi-64int|5.10.0|solaris|2.10|200811182139
2648153|pass|200811|bingos@cpan.org|WWW-Scraper-ISBN-Amazon_Driver|0.14|i86pc-solaris-thread-multi-64int|5.10.0|solaris|2.10|200811182134
2647773|pass|200811|cpan@sourcentral.org ("Oliver Paukstadt")|Parse-CPAN-Distributions|0.05|s390x-linux-thread-multi|5.8.8|linux|2.6.16.60-0.31-default|200811182130
2647728|pass|200811|cpan@sourcentral.org ("Oliver Paukstadt")|Parse-CPAN-Distributions|0.05|s390x-linux|5.8.8|linux|2.6.16.60-0.31-default|200811182111
2647499|pass|200811|cpan@sourcentral.org ("Oliver Paukstadt")|Parse-CPAN-Distributions|0.05|s390x-linux|5.10.0|linux|2.6.16.60-0.31-default|200811182023
2647114|pass|200811|JOST@cpan.org ("Josts Smokehouse")|Data-Phrasebook-Loader-YAML|0.09|i86pc-solaris-64int|5.8.9|solaris|2.11|200811181857
2647113|pass|200811|JOST@cpan.org ("Josts Smokehouse")|Data-Phrasebook|0.29|i86pc-solaris-64int|5.8.9|solaris|2.11|200811181857
2647109|pass|200811|srezic@cpan.org|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i386-freebsd-64int|5.8.8|freebsd|6.1-release|200811181845
2647108|pass|200811|srezic@cpan.org|WWW-Scraper-ISBN-Amazon_Driver|0.14|i386-freebsd-64int|5.8.8|freebsd|6.1-release|200811181844
2646921|pass|200811|JOST@cpan.org ("Josts Smokehouse")|Regexp-Log-Common|0.05|i86pc-solaris-64int|5.8.9|solaris|2.11|200811181806
2646109|pass|200811|JOST@cpan.org ("Josts Smokehouse")|Parse-CPAN-Distributions|0.05|i86pc-solaris-64int|5.8.9|solaris|2.11|200811181501
2646105|pass|200811|JOST@cpan.org ("Josts Smokehouse")|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i86pc-solaris-64int|5.8.9|solaris|2.11|200811181500
2646104|pass|200811|JOST@cpan.org ("Josts Smokehouse")|WWW-Scraper-ISBN-Amazon_Driver|0.14|i86pc-solaris-64int|5.8.9|solaris|2.11|200811181459
2645758|pass|200811|bingos@cpan.org|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i386-dragonfly-thread-multi-64int|5.8.8|dragonfly|2.0.1-release|200811181209
2645754|pass|200811|bingos@cpan.org|WWW-Scraper-ISBN-Amazon_Driver|0.14|i386-dragonfly-thread-multi-64int|5.8.8|dragonfly|2.0.1-release|200811181204
2645417|pass|200811|cpan@sourcentral.org ("Oliver Paukstadt")|Parse-CPAN-Distributions|0.05|s390x-linux-thread-multi|5.8.8|linux|2.6.18-92.el5|200811181148
2645305|pass|200811|cpan@sourcentral.org ("Oliver Paukstadt")|Parse-CPAN-Distributions|0.05|s390x-linux|5.8.8|linux|2.6.18-92.el5|200811181127
2643089|pass|200811|cpan@sourcentral.org ("Oliver Paukstadt")|Parse-CPAN-Distributions|0.05|s390x-linux-thread-multi|5.10.0|linux|2.6.16.60-0.31-default|200811180352
2642306|pass|200811|bingos@cpan.org|WWW-Scraper-ISBN-Amazon_Driver|0.14|darwin-thread-multi-64int-2level|5.8.8|darwin|8.10.0|200811180041
2642206|pass|200811|bingos@cpan.org|WWW-Scraper-ISBN-Amazon_Driver|0.14|darwin-thread-multi-64int-2level|5.10.0|darwin|8.10.0|200811180029
2642166|pass|200811|bingos@cpan.org|WWW-Scraper-ISBN-Yahoo_Driver|0.08|darwin-thread-multi-64int-2level|5.8.8|darwin|8.10.0|200811180025
2642012|pass|200811|bingos@cpan.org|WWW-Scraper-ISBN-Yahoo_Driver|0.08|darwin-thread-multi-64int-2level|5.10.0|darwin|8.10.0|200811180006
2641944|fail|200811|srezic@cpan.org|WWW-UsePerl-Journal|0.22|i386-freebsd-thread-multi|5.8.9|freebsd|6.1-release-p23|200811180056
2641611|pass|200811|bingos@cpan.org|WWW-Scraper-ISBN-Amazon_Driver|0.14|i386-netbsd-thread-multi-64int|5.8.8|netbsd|3.1|200811172309
2641594|pass|200811|bingos@cpan.org|WWW-Scraper-ISBN-Amazon_Driver|0.14|i386-netbsd-thread-multi-64int|5.10.0|netbsd|3.1|200811172306
2641588|pass|200811|srezic@cpan.org|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i386-freebsd|5.10.0|freebsd|6.1-release|200811180001
2641587|fail|200811|srezic@cpan.org|WWW-Scraper-ISBN-Amazon_Driver|0.14|i386-freebsd|5.10.0|freebsd|6.1-release|200811180000
2641584|pass|200811|bingos@cpan.org|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i386-netbsd-thread-multi-64int|5.8.8|netbsd|3.1|200811172303
2641570|pass|200811|bingos@cpan.org|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i386-netbsd-thread-multi-64int|5.10.0|netbsd|3.1|200811172301
2641380|pass|200811|bingos@cpan.org|Regexp-Log-Common|0.05|i386-freebsd-thread-multi-64int|5.8.8|freebsd|7.0-release|200811172206
2640361|pass|200811|srezic@cpan.org|WWW-Scraper-ISBN-Amazon_Driver|0.14|i386-freebsd|5.8.9|freebsd|6.1-release-p23|200811171941
2640359|pass|200811|srezic@cpan.org|WWW-Scraper-ISBN-Yahoo_Driver|0.08|i386-freebsd|5.8.9|freebsd|6.1-release-p23|200811171941
2639933|cpan|200811|BARBIE|WWW-Scraper-ISBN-Amazon_Driver|0.14||0|||200811171550
2639894|cpan|200811|BARBIE|WWW-Scraper-ISBN-Yahoo_Driver|0.08||0|||200811171541
2639885|cpan|200811|BARBIE|CPAN-WWW-Testers|0.37||0|||200811171539
2636733|pass|200811|jeff@zeroclue.com|Data-Phrasebook-Loader-YAML|0.09|darwin-2level|5.10.0|darwin|9.2.0|200811161253
2636729|pass|200811|jeff@zeroclue.com|Data-Phrasebook|0.29|darwin-2level|5.10.0|darwin|9.2.0|200811161253
2630342|pass|200811|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i86pc-solaris-thread-multi-64int|5.8.4|solaris|2.10|200811151216
2630340|pass|200811|bingos@cpan.org|Data-Phrasebook|0.29|i86pc-solaris-thread-multi-64int|5.8.4|solaris|2.10|200811151216
2622891|pass|200811|cpan@sourcentral.org ("Oliver Paukstadt")|Regexp-Log-Common|0.05|s390x-linux|5.8.8|linux|2.6.16.60-0.31-default|200811141528
2621178|pass|200811|cpan@sourcentral.org ("Oliver Paukstadt")|Regexp-Log-Common|0.05|s390x-linux|5.10.0|linux|2.6.16.60-0.31-default|200811141110
2620615|pass|200811|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i86pc-solaris-thread-multi-64int|5.10.0|solaris|2.10|200811140927
2620597|pass|200811|bingos@cpan.org|Data-Phrasebook|0.29|i86pc-solaris-thread-multi-64int|5.10.0|solaris|2.10|200811140926
2619299|pass|200811|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i86pc-solaris-thread-multi-64int|5.8.8|solaris|2.10|200811140757
2619277|pass|200811|bingos@cpan.org|Data-Phrasebook|0.29|i86pc-solaris-thread-multi-64int|5.8.8|solaris|2.10|200811140756
2616431|unknown|200811|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Statistics|0.52|s390x-linux|5.6.2|linux|2.6.18-92.1.17.el5|200811140051
2616430|fail|200811|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-Testers-WWW-Statistics|0.52|s390x-linux|5.6.2|linux|2.6.18-92.1.17.el5|200811140051
2615760|unknown|200811|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-WWW-Testers|0.36|s390x-linux|5.6.2|linux|2.6.18-92.1.17.el5|200811140018
2615759|fail|200811|cpan@sourcentral.org ("Oliver Paukstadt")|CPAN-WWW-Testers|0.36|s390x-linux|5.6.2|linux|2.6.18-92.1.17.el5|200811140018
2612723|fail|200811|srezic@cpan.org|CPAN-YACSmoke-Plugin-WebList|0.05|i386-freebsd|5.8.9|freebsd|6.1-release-p23|200811132053
2611723|pass|200811|srezic@cpan.org|Regexp-Log-Common|0.05|i386-freebsd|5.8.9|freebsd|6.1-release-p23|200811131728
2611660|pass|200811|srezic@cpan.org|Data-Phrasebook-Loader-Ini|0.10|i386-freebsd|5.8.9|freebsd|6.1-release-p23|200811131727
2611481|pass|200811|srezic@cpan.org|CPAN-YACSmoke-Plugin-Outlook|0.06|i386-freebsd|5.8.9|freebsd|6.1-release-p23|200811131727
2610819|pass|200811|srezic@cpan.org|CPAN-YACSmoke-Plugin-NNTP|0.05|i386-freebsd|5.8.9|freebsd|6.1-release-p23|200811131727
2610806|pass|200811|srezic@cpan.org|Data-Phrasebook-Loader-XML|0.12|i386-freebsd|5.8.9|freebsd|6.1-release-p23|200811131727
2610680|pass|200811|srezic@cpan.org|Data-Phrasebook-Loader-DBI|0.11|i386-freebsd|5.8.9|freebsd|6.1-release-p23|200811131727
2610439|pass|200811|srezic@cpan.org|Mail-File|0.08|i386-freebsd|5.8.9|freebsd|6.1-release-p23|200811131727
2609478|pass|200811|srezic@cpan.org|GD-Chart-Radial|0.07|i386-freebsd|5.8.9|freebsd|6.1-release-p23|200811131443
2607386|pass|200811|srezic@cpan.org|Finance-Currency-Convert-XE|0.15|i386-freebsd|5.8.9|freebsd|6.1-release-p23|200811131049
2607342|pass|200811|srezic@cpan.org|Data-FormValidator-Constraints-Words|0.03|i386-freebsd|5.8.9|freebsd|6.1-release-p23|200811131049
2605206|pass|200811|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24.5-smp|200811130215
2605205|pass|200811|bingos@cpan.org|Data-Phrasebook|0.29|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24.5-smp|200811130215
2605115|pass|200811|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.24.5-smp|200811130152
2605114|pass|200811|bingos@cpan.org|Data-Phrasebook|0.29|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.24.5-smp|200811130151
2604776|pass|200811|srezic@cpan.org|Test-CPAN-Meta|0.12|i386-freebsd|5.8.9|freebsd|6.1-release-p23|200811130002
2604707|pass|200811|srezic@cpan.org|Games-Trackword|1.06|i386-freebsd|5.8.9|freebsd|6.1-release-p23|200811130012
2604474|pass|200811|srezic@cpan.org|Calendar-List|0.21|i386-freebsd|5.8.9|freebsd|6.1-release-p23|200811130012
2604396|fail|200811|srezic@cpan.org|WWW-Scraper-ISBN-Amazon_Driver|0.13|i386-freebsd|5.8.9|freebsd|6.1-release-p23|200811130003
2603015|pass|200811|srezic@cpan.org|WWW-Scraper-ISBN-ORA_Driver|0.09|i386-freebsd|5.8.9|freebsd|6.1-release-p23|200811121601
2602723|fail|200811|srezic@cpan.org|WWW-Scraper-ISBN-Yahoo_Driver|0.07|i386-freebsd|5.8.9|freebsd|6.1-release-p23|200811121601
2602699|pass|200811|srezic@cpan.org|WWW-Scraper-ISBN-Pearson_Driver|0.10|i386-freebsd|5.8.9|freebsd|6.1-release-p23|200811121601
2601885|pass|200811|srezic@cpan.org|Test-YAML-Meta|0.11|i386-freebsd|5.8.9|freebsd|6.1-release-p23|200811121403
2600929|pass|200811|srezic@cpan.org|Parse-CPAN-Distributions|0.05|i386-freebsd|5.8.9|freebsd|6.1-release-p23|200811121130
2600756|pass|200811|srezic@cpan.org|Mail-Outlook|0.14|i386-freebsd|5.8.9|freebsd|6.1-release-p23|200811121130
2600711|pass|200811|srezic@cpan.org|WWW-UsePerl-Journal-Thread|0.12|i386-freebsd|5.8.9|freebsd|6.1-release-p23|200811121131
2600710|pass|200811|srezic@cpan.org|WWW-UsePerl-Journal|0.22|i386-freebsd|5.8.9|freebsd|6.1-release-p23|200811121131
2600616|pass|200811|srezic@cpan.org|CPAN-WWW-Testers-Generator|0.30|i386-freebsd|5.8.9|freebsd|6.1-release-p23|200811121130
2598855|pass|200811|srezic@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i386-freebsd|5.8.9|freebsd|6.1-release-p23|200811120755
2597985|pass|200811|srezic@cpan.org|Data-Phrasebook|0.29|i386-freebsd|5.8.9|freebsd|6.1-release-p23|200811120755
2597448|pass|200811|cpan@sourcentral.org ("Oliver Paukstadt")|Regexp-Log-Common|0.05|s390x-linux-thread-multi|5.8.8|linux|2.6.16.60-0.31-default|200811120623
2597413|pass|200811|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|OpenBSD.i386-openbsd-thread-multi-64int|5.8.8|openbsd|4.4|200811120515
2597410|pass|200811|bingos@cpan.org|Data-Phrasebook|0.29|OpenBSD.i386-openbsd-thread-multi-64int|5.8.8|openbsd|4.4|200811120514
2597116|pass|200811|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|OpenBSD.i386-openbsd-thread-multi-64int|5.10.0|openbsd|4.4|200811120352
2597111|pass|200811|bingos@cpan.org|Data-Phrasebook|0.29|OpenBSD.i386-openbsd-thread-multi-64int|5.10.0|openbsd|4.4|200811120351
2596676|pass|200811|cpan@sourcentral.org ("Oliver Paukstadt")|Regexp-Log-Common|0.05|s390x-linux-thread-multi|5.10.0|linux|2.6.16.60-0.31-default|200811120319
2596645|pass|200811|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook-Loader-YAML|0.09|s390x-linux|5.8.8|linux|2.6.16.60-0.31-default|200811120314
2596641|pass|200811|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook|0.29|s390x-linux|5.8.8|linux|2.6.16.60-0.31-default|200811120314
2596408|pass|200811|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook-Loader-YAML|0.09|s390x-linux|5.10.0|linux|2.6.16.60-0.31-default|200811120222
2596406|pass|200811|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook|0.29|s390x-linux|5.10.0|linux|2.6.16.60-0.31-default|200811120222
2596193|pass|200811|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.12|s390x-linux-thread-multi|5.10.0|linux|2.6.16.60-0.31-default|200811120140
2583410|pass|200811|cpan@sourcentral.org ("Oliver Paukstadt")|Regexp-Log-Common|0.05|s390x-linux|5.8.8|linux|2.6.18-92.el5|200811101102
2582489|pass|200811|cpan@sourcentral.org ("Oliver Paukstadt")|Regexp-Log-Common|0.05|s390x-linux-thread-multi|5.10.0|linux|2.6.18-92.el5|200811100834
2582443|pass|200811|cpan@sourcentral.org ("Oliver Paukstadt")|Regexp-Log-Common|0.05|s390x-linux|5.10.0|linux|2.6.18-92.el5|200811100825
2581869|pass|200811|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.12|s390x-linux-thread-multi|5.10.0|linux|2.6.18-92.el5|200811100640
2581861|pass|200811|cpan@sourcentral.org ("Oliver Paukstadt")|Test-CPAN-Meta|0.12|s390x-linux|5.10.0|linux|2.6.18-92.el5|200811100639
2580640|pass|200811|perl@galumph.com|Test-YAML-Meta|0.11|darwin-thread-multi-64int-ld-2level|5.10.0|darwin|9.4.0|200811091457
2578676|pass|200811|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook|0.29|s390x-linux-thread-multi|5.10.0|linux|2.6.16.60-0.31-default|200811090840
2578092|pass|200811|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook|0.29|s390x-linux-thread-multi|5.8.8|linux|2.6.18-92.el5|200811091007
2577925|pass|200811|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook-Loader-YAML|0.09|s390x-linux-thread-multi|5.10.0|linux|2.6.16.60-0.31-default|200811090841
2577915|pass|200811|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook|0.29|s390x-linux|5.10.0|linux|2.6.18-92.el5|200811090939
2577844|pass|200811|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook-Loader-YAML|0.09|s390x-linux-thread-multi|5.8.8|linux|2.6.16.60-0.31-default|200811090916
2576856|pass|200811|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook-Loader-YAML|0.09|s390x-linux-thread-multi|5.8.8|linux|2.6.18-92.el5|200811091007
2576848|pass|200811|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook-Loader-YAML|0.09|s390x-linux-thread-multi|5.10.0|linux|2.6.18-92.el5|200811090945
2576838|pass|200811|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook-Loader-YAML|0.09|s390x-linux|5.8.8|linux|2.6.18-92.el5|200811091000
2576837|pass|200811|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook|0.29|s390x-linux|5.8.8|linux|2.6.18-92.el5|200811091000
2576783|pass|200811|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook|0.29|s390x-linux-thread-multi|5.10.0|linux|2.6.18-92.el5|200811090945
2576771|pass|200811|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook-Loader-YAML|0.09|s390x-linux|5.10.0|linux|2.6.18-92.el5|200811090939
2576722|pass|200811|cpan@sourcentral.org ("Oliver Paukstadt")|Data-Phrasebook|0.29|s390x-linux-thread-multi|5.8.8|linux|2.6.16.60-0.31-default|200811090916
2553967|pass|200811|JOST@cpan.org ("Josts Smokehouse")|Data-Phrasebook-Loader-DBI|0.11|i86pc-solaris-64int|5.8.8 patch 34559|solaris|2.11|200811051707
2553966|pass|200811|JOST@cpan.org ("Josts Smokehouse")|Data-Phrasebook-Loader-Ini|0.10|i86pc-solaris-64int|5.8.8 patch 34559|solaris|2.11|200811051707
2553965|pass|200811|JOST@cpan.org ("Josts Smokehouse")|Data-Phrasebook-Loader-XML|0.12|i86pc-solaris-64int|5.8.8 patch 34559|solaris|2.11|200811051707
2549127|pass|200811|JOST@cpan.org ("Josts Smokehouse")|Mail-File|0.08|i86pc-solaris-64int|5.8.8 patch 34559|solaris|2.11|200811042147
2548874|pass|200811|JOST@cpan.org ("Josts Smokehouse")|CPAN-YACSmoke-Plugin-Outlook|0.06|i86pc-solaris-64int|5.8.8 patch 34559|solaris|2.11|200811042056
2548873|fail|200811|JOST@cpan.org ("Josts Smokehouse")|CPAN-YACSmoke-Plugin-WebList|0.05|i86pc-solaris-64int|5.8.8 patch 34559|solaris|2.11|200811042056
2548872|pass|200811|JOST@cpan.org ("Josts Smokehouse")|CPAN-YACSmoke-Plugin-NNTP|0.05|i86pc-solaris-64int|5.8.8 patch 34559|solaris|2.11|200811042055
2548870|pass|200811|JOST@cpan.org ("Josts Smokehouse")|CPAN-YACSmoke-Plugin-NNTPWeb|0.06|i86pc-solaris-64int|5.8.8 patch 34559|solaris|2.11|200811042054
2547333|fail|200811|altblue@gmail.com ("Marius Feraru")|WWW-Scraper-ISBN-Yahoo_Driver|0.07|x86_64-linux|5.11.0 patch 34595|linux|2.6.18-8.1.14.el5|200811040101
2547040|fail|200811|altblue@gmail.com ("Marius Feraru")|WWW-Scraper-ISBN-Yahoo_Driver|0.07|x86_64-linux|5.11.0 patch 34712|linux|2.6.18-8.1.14.el5|200811040805
2547022|fail|200811|altblue@gmail.com ("Marius Feraru")|WWW-Scraper-ISBN-Amazon_Driver|0.13|x86_64-linux|5.11.0 patch 34595|linux|2.6.18-8.1.14.el5|200811040246
2538544|fail|200811|srezic@cpan.org|CPAN-YACSmoke-Plugin-WebList|0.05|i386-freebsd|5.8.8 patch 34559|freebsd|6.1-release-p23|200811022057
2538479|pass|200811|perl@galumph.com|Test-CPAN-Meta|0.12|darwin-2level|5.10.0|darwin|9.1.0|200811021338
2536552|pass|200811|srezic@cpan.org|CPAN-Testers-WWW-Statistics|0.52|i386-freebsd|5.8.8 patch 34559|freebsd|6.1-release-p23|200811021220
2534982|fail|200811|srezic@cpan.org|WWW-UsePerl-Journal|0.22|i386-freebsd|5.8.8 patch 34559|freebsd|6.1-release-p23|200811012219
2533864|pass|200811|mw487.yahoo.com@gmail.com|Parse-CPAN-Distributions|0.05|cygwin-thread-multi-64int|5.8.8|cygwin|1.5.24(0.15642)|200811011109
2530540|pass|200810|mw487.yahoo.com@gmail.com|Data-Phrasebook-Loader-YAML|0.09|cygwin-thread-multi-64int|5.8.8|cygwin|1.5.24(0.15642)|200810311209
2530539|pass|200810|mw487.yahoo.com@gmail.com|Data-Phrasebook|0.29|cygwin-thread-multi-64int|5.8.8|cygwin|1.5.24(0.15642)|200810311208
2524873|pass|200810|frank.wiegand@gmail.com ("Frank Wiegand")|Test-YAML-Meta|0.11|i686-linux|5.11.0 patch 34669|linux|2.6.24-21-generic|200810302226
2524825|pass|200810|JOST@cpan.org ("Josts Smokehouse")|Finance-Currency-Convert-XE|0.15|i86pc-solaris-64int|5.8.8 patch 34559|solaris|2.11|200810302227
2523954|pass|200810|JOST@cpan.org ("Josts Smokehouse")|Data-FormValidator-Constraints-Words|0.03|i86pc-solaris-64int|5.8.8 patch 34559|solaris|2.11|200810302028
2516202|pass|200810|JOST@cpan.org ("Josts Smokehouse")|Games-Trackword|1.06|i86pc-solaris-64int|5.8.8 patch 34559|solaris|2.11|200810291541
2516199|pass|200810|JOST@cpan.org ("Josts Smokehouse")|Calendar-List|0.21|i86pc-solaris-64int|5.8.8 patch 34559|solaris|2.11|200810291541
2515674|pass|200810|autarch@urth.org|Test-YAML-Meta|0.11|x86_64-linux-gnu|5.10.0|linux|2.6.24-15-server|200810290221
2513981|pass|200810|JOST@cpan.org ("Josts Smokehouse")|Test-CPAN-Meta|0.12|i86pc-solaris-64int|5.8.8 patch 34559|solaris|2.11|200810290700
2513978|fail|200810|JOST@cpan.org ("Josts Smokehouse")|WWW-Scraper-ISBN-ORA_Driver|0.09|i86pc-solaris-64int|5.8.8 patch 34559|solaris|2.11|200810290659
2513974|pass|200810|JOST@cpan.org ("Josts Smokehouse")|WWW-Scraper-ISBN-Pearson_Driver|0.10|i86pc-solaris-64int|5.8.8 patch 34559|solaris|2.11|200810290659
2513968|fail|200810|JOST@cpan.org ("Josts Smokehouse")|WWW-Scraper-ISBN-Yahoo_Driver|0.07|i86pc-solaris-64int|5.8.8 patch 34559|solaris|2.11|200810290659
2510577|pass|200810|JOST@cpan.org ("Josts Smokehouse")|Test-YAML-Meta|0.11|i86pc-solaris-64int|5.8.8 patch 34559|solaris|2.11|200810281918
2507524|pass|200810|JOST@cpan.org ("Josts Smokehouse")|Mail-Outlook|0.14|i86pc-solaris-64int|5.8.8 patch 34559|solaris|2.11|200810280630
2507069|pass|200810|JOST@cpan.org ("Josts Smokehouse")|WWW-UsePerl-Journal-Thread|0.12|i86pc-solaris-64int|5.8.8 patch 34559|solaris|2.11|200810280343
2507067|pass|200810|JOST@cpan.org ("Josts Smokehouse")|WWW-UsePerl-Journal|0.22|i86pc-solaris-64int|5.8.8 patch 34559|solaris|2.11|200810280343
2506908|pass|200810|JOST@cpan.org ("Josts Smokehouse")|CPAN-WWW-Testers-Generator|0.30|i86pc-solaris-64int|5.8.8 patch 34559|solaris|2.11|200810280244
2506353|pass|200810|JOST@cpan.org ("Josts Smokehouse")|CPAN-Testers-WWW-Statistics|0.52|i86pc-solaris-64int|5.8.8 patch 34559|solaris|2.11|200810272329
2505665|pass|200810|JOST@cpan.org ("Josts Smokehouse")|Parse-CPAN-Distributions|0.05|i86pc-solaris-64int|5.8.8 patch 34559|solaris|2.11|200810272014
2505599|pass|200810|JOST@cpan.org ("Josts Smokehouse")|Data-Phrasebook-Loader-YAML|0.09|i86pc-solaris-64int|5.8.8 patch 34559|solaris|2.11|200810271958
2505598|pass|200810|JOST@cpan.org ("Josts Smokehouse")|Data-Phrasebook|0.29|i86pc-solaris-64int|5.8.8 patch 34559|solaris|2.11|200810271958
2504683|pass|200810|JOST@cpan.org ("Josts Smokehouse")|Regexp-Log-Common|0.05|i86pc-solaris-64int|5.8.8 patch 34559|solaris|2.11|200810271639
2502592|pass|200810|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i386-netbsd-thread-multi-64int|5.8.8|netbsd|4.0|200810270337
2502590|pass|200810|bingos@cpan.org|Data-Phrasebook|0.29|i386-netbsd-thread-multi-64int|5.8.8|netbsd|4.0|200810270336
2498417|pass|200810|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|MirBSD.i386-mirbsd-thread-multi-64int|5.10.0|mirbsd|10|200810260934
2498415|pass|200810|bingos@cpan.org|Data-Phrasebook|0.29|MirBSD.i386-mirbsd-thread-multi-64int|5.10.0|mirbsd|10|200810260933
2497665|pass|200810|stro@cpan.org|Parse-CPAN-Distributions|0.05|i686-linux|5.8.8|linux|2.4.27-2-386|200810260811
2497407|pass|200810|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|OpenBSD.i386-openbsd-thread-multi-64int|5.8.8|openbsd|4.2|200810260208
2497405|pass|200810|bingos@cpan.org|Data-Phrasebook|0.29|OpenBSD.i386-openbsd-thread-multi-64int|5.8.8|openbsd|4.2|200810260207
2497361|pass|200810|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|OpenBSD.i386-openbsd-thread-multi-64int|5.10.0|openbsd|4.2|200810260138
2497360|pass|200810|bingos@cpan.org|Data-Phrasebook|0.29|OpenBSD.i386-openbsd-thread-multi-64int|5.10.0|openbsd|4.2|200810260138
2496291|pass|200810|srezic@cpan.org|Mail-File|0.08|i386-freebsd|5.8.8 patch 34559|freebsd|6.1-release-p23|200810252224
2495715|pass|200810|srezic@cpan.org|Data-Phrasebook-Loader-DBI|0.11|i386-freebsd|5.8.8 patch 34559|freebsd|6.1-release-p23|200810252222
2495463|pass|200810|srezic@cpan.org|CPAN-YACSmoke-Plugin-NNTP|0.05|i386-freebsd|5.8.8 patch 34559|freebsd|6.1-release-p23|200810252222
2494539|pass|200810|srezic@cpan.org|Data-Phrasebook-Loader-XML|0.12|i386-freebsd|5.8.8 patch 34559|freebsd|6.1-release-p23|200810252222
2494538|pass|200810|srezic@cpan.org|Data-Phrasebook-Loader-Ini|0.10|i386-freebsd|5.8.8 patch 34559|freebsd|6.1-release-p23|200810252222
2494508|pass|200810|srezic@cpan.org|CPAN-YACSmoke-Plugin-WebList|0.05|i386-freebsd|5.8.8 patch 34559|freebsd|6.1-release-p23|200810252222
2494507|pass|200810|srezic@cpan.org|CPAN-YACSmoke-Plugin-Outlook|0.06|i386-freebsd|5.8.8 patch 34559|freebsd|6.1-release-p23|200810252222
2493787|pass|200810|stro@cpan.org|Mail-Outlook|0.14|i686-linux|5.10.0|linux|2.4.27-2-386|200810252140
2493782|pass|200810|alexchorny@gmail.com|Test-YAML-Meta|0.11|MSWin32-x86-multi-thread|5.8.8|MSWin32|5.1|200810251440
2492762|pass|200810|stro@cpan.org|WWW-UsePerl-Journal-Thread|0.12|i686-linux|5.10.0|linux|2.4.27-2-386|200810251904
2492549|pass|200810|stro@cpan.org|CPAN-WWW-Testers-Generator|0.30|i686-linux|5.10.0|linux|2.4.27-2-386|200810251821
2492275|pass|200810|srezic@cpan.org|Finance-Currency-Convert-XE|0.15|i386-freebsd|5.8.8 patch 34559|freebsd|6.1-release-p23|200810251455
2491698|pass|200810|srezic@cpan.org|GD-Chart-Radial|0.07|i386-freebsd|5.8.8 patch 34559|freebsd|6.1-release-p23|200810251456
2491491|pass|200810|srezic@cpan.org|Data-FormValidator-Constraints-Words|0.03|i386-freebsd|5.8.8 patch 34559|freebsd|6.1-release-p23|200810251455
2489651|pass|200810|autarch@urth.org|WWW-UsePerl-Journal|0.22|x86_64-linux-gnu|5.8.8|linux|2.6.15.7|200810250112
2488394|pass|200810|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.21.5-smp|200810250318
2488393|pass|200810|bingos@cpan.org|Data-Phrasebook|0.29|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.21.5-smp|200810250317
2488369|pass|200810|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.21.5-smp|200810250249
2488367|pass|200810|bingos@cpan.org|Data-Phrasebook|0.29|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.21.5-smp|200810250248
2487577|pass|200810|bingos@cpan.org|Data-Phrasebook|0.29|i686-linux-thread-multi-64int-ld|5.6.2|linux|2.6.21.5-smp|200810242146
2485083|pass|200810|srezic@cpan.org|Games-Trackword|1.06|i386-freebsd|5.8.8 patch 34559|freebsd|6.1-release-p23|200810240958
2484856|pass|200810|srezic@cpan.org|Regexp-Log-Common|0.05|i386-freebsd|5.8.8 patch 34559|freebsd|6.1-release-p23|200810240958
2484663|pass|200810|srezic@cpan.org|Calendar-List|0.21|i386-freebsd|5.8.8 patch 34559|freebsd|6.1-release-p23|200810240958
2483972|fail|200810|srezic@cpan.org|WWW-Scraper-ISBN-Yahoo_Driver|0.07|i386-freebsd|5.8.8 patch 34559|freebsd|6.1-release-p23|200810240826
2483965|fail|200810|srezic@cpan.org|WWW-Scraper-ISBN-Amazon_Driver|0.13|i386-freebsd|5.8.8 patch 34559|freebsd|6.1-release-p23|200810240826
2483937|pass|200810|srezic@cpan.org|Test-CPAN-Meta|0.12|i386-freebsd|5.8.8 patch 34559|freebsd|6.1-release-p23|200810240825
2483851|pass|200810|srezic@cpan.org|WWW-Scraper-ISBN-ORA_Driver|0.09|i386-freebsd|5.8.8 patch 34559|freebsd|6.1-release-p23|200810240826
2483850|pass|200810|srezic@cpan.org|WWW-Scraper-ISBN-Pearson_Driver|0.10|i386-freebsd|5.8.8 patch 34559|freebsd|6.1-release-p23|200810240826
2482679|pass|200810|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i386-freebsd-thread-multi-64int|5.8.8|freebsd|6.2-release|200810240052
2482678|pass|200810|bingos@cpan.org|Data-Phrasebook|0.29|i386-freebsd-thread-multi-64int|5.8.8|freebsd|6.2-release|200810240052
2482066|pass|200810|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i386-dragonfly-thread-multi-64int|5.8.8|dragonfly|2.0.0-release|200810240020
2482063|pass|200810|bingos@cpan.org|Data-Phrasebook|0.29|i386-dragonfly-thread-multi-64int|5.8.8|dragonfly|2.0.0-release|200810240019
2481867|pass|200810|srezic@cpan.org|Test-YAML-Meta|0.11|i386-freebsd|5.8.8 patch 34559|freebsd|6.1-release-p23|200810240003
2481483|pass|200810|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i386-freebsd-thread-multi-64int|5.10.0|freebsd|6.2-release|200810232006
2481480|pass|200810|bingos@cpan.org|Data-Phrasebook|0.29|i386-freebsd-thread-multi-64int|5.10.0|freebsd|6.2-release|200810232006
2481330|pass|200810|srezic@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i386-freebsd|5.8.8 patch 34559|freebsd|6.1-release-p23|200810232057
2480867|pass|200810|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i386-dragonfly-thread-multi-64int|5.10.0|dragonfly|2.0.0-release|200810232148
2480866|pass|200810|bingos@cpan.org|Data-Phrasebook|0.29|i386-dragonfly-thread-multi-64int|5.10.0|dragonfly|2.0.0-release|200810232147
2480531|pass|200810|srezic@cpan.org|WWW-UsePerl-Journal-Thread|0.12|i386-freebsd|5.8.8 patch 34559|freebsd|6.1-release-p23|200810232100
2480529|pass|200810|srezic@cpan.org|WWW-UsePerl-Journal|0.22|i386-freebsd|5.8.8 patch 34559|freebsd|6.1-release-p23|200810232100
2480440|pass|200810|srezic@cpan.org|Mail-Outlook|0.14|i386-freebsd|5.8.8 patch 34559|freebsd|6.1-release-p23|200810232058
2480271|pass|200810|srezic@cpan.org|Parse-CPAN-Distributions|0.05|i386-freebsd|5.8.8 patch 34559|freebsd|6.1-release-p23|200810232058
2480057|pass|200810|srezic@cpan.org|CPAN-WWW-Testers-Generator|0.30|i386-freebsd|5.8.8 patch 34559|freebsd|6.1-release-p23|200810232057
2479887|pass|200810|srezic@cpan.org|Data-Phrasebook|0.29|i386-freebsd|5.8.8 patch 34559|freebsd|6.1-release-p23|200810232057
2475823|pass|200810|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.16.38|200810230034
2475817|pass|200810|bingos@cpan.org|Data-Phrasebook|0.29|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.16.38|200810230034
2475765|pass|200810|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.16.38|200810230029
2475758|pass|200810|bingos@cpan.org|Data-Phrasebook|0.29|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.16.38|200810230029
2471123|pass|200810|mw487.yahoo.com@gmail.com|Regexp-Log-Common|0.05|cygwin-thread-multi-64int|5.8.8|cygwin|1.5.24(0.15642)|200810220821
2470570|pass|200810|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.24-19-generic|200810221128
2470566|pass|200810|bingos@cpan.org|Data-Phrasebook|0.29|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.24-19-generic|200810221127
2470179|pass|200810|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-19-generic|200810221021
2470172|pass|200810|bingos@cpan.org|Data-Phrasebook|0.29|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-19-generic|200810221021
2468604|pass|200810|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i86pc-solaris-thread-multi-64int|5.8.8|solaris|2.10|200810220329
2468602|pass|200810|bingos@cpan.org|Data-Phrasebook|0.29|i86pc-solaris-thread-multi-64int|5.8.8|solaris|2.10|200810220329
2468096|pass|200810|davidp@preshweb.co.uk ("David Precious")|Finance-Currency-Convert-XE|0.15|i486-linux-gnu|5.10.0|linux|2.6.26.1|200810211927
2466508|pass|200810|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i86pc-solaris-thread-multi-64int|5.10.0|solaris|2.10|200810211219
2466502|pass|200810|bingos@cpan.org|Data-Phrasebook|0.29|i86pc-solaris-thread-multi-64int|5.10.0|solaris|2.10|200810211217
2466225|pass|200810|stro@cpan.org|CPAN-Testers-WWW-Statistics|0.52|i686-linux|5.10.0|linux|2.4.27-2-386|200810211227
2465472|pass|200810|bingos@cpan.org|Data-Phrasebook|0.29|i86pc-solaris-thread-multi-64int|5.6.2|solaris|2.10|200810210222
2462643|pass|200810|vpit@cpan.org|Data-Phrasebook-Loader-YAML|0.09|x86_64-linux-thread-multi|5.10.0|linux|2.6.26.3-fuuka.profvince.com|200810201938
2462642|pass|200810|vpit@cpan.org|Data-Phrasebook|0.29|x86_64-linux-thread-multi|5.10.0|linux|2.6.26.3-fuuka.profvince.com|200810201938
2462231|pass|200810|stro@cpan.org|Parse-CPAN-Distributions|0.05|i686-linux|5.10.0|linux|2.4.27-2-386|200810201815
2461954|pass|200810|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i86pc-solaris-thread-multi-64int|5.8.4|solaris|2.10|200810201443
2461951|pass|200810|bingos@cpan.org|Data-Phrasebook|0.29|i86pc-solaris-thread-multi-64int|5.8.4|solaris|2.10|200810201443
2461757|pass|200810|stro@cpan.org|WWW-UsePerl-Journal|0.22|i686-linux|5.10.0|linux|2.4.27-2-386|200810201541
2461685|pass|200810|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i386-netbsd-thread-multi-64int|5.8.8|netbsd|3.1|200810201314
2461682|pass|200810|bingos@cpan.org|Data-Phrasebook|0.29|i386-netbsd-thread-multi-64int|5.8.8|netbsd|3.1|200810201314
2461677|pass|200810|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i386-netbsd-thread-multi-64int|5.8.7|netbsd|3.1|200810201311
2461676|pass|200810|bingos@cpan.org|Data-Phrasebook|0.29|i386-netbsd-thread-multi-64int|5.8.7|netbsd|3.1|200810201310
2461607|pass|200810|bingos@cpan.org|Data-Phrasebook|0.29|i386-netbsd-thread-multi-64int|5.6.2|netbsd|3.1|200810201257
2461603|pass|200810|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i386-netbsd-thread-multi-64int|5.10.0|netbsd|3.1|200810201256
2461601|pass|200810|bingos@cpan.org|Data-Phrasebook|0.29|i386-netbsd-thread-multi-64int|5.10.0|netbsd|3.1|200810201256
2461146|pass|200810|vpit@cpan.org|CPAN-WWW-Testers|0.36|i686-linux-thread-multi|5.10.0|linux|2.6.18.3-tmb-desktop-2mdvsmp|200810201125
2460909|pass|200810|bingos@cpan.org|Regexp-Log-Common|0.05|i386-netbsd-thread-multi-64int|5.8.8|netbsd|3.1|200810200701
2460904|pass|200810|bingos@cpan.org|Regexp-Log-Common|0.05|i386-netbsd-thread-multi-64int|5.8.7|netbsd|3.1|200810200654
2460895|pass|200810|bingos@cpan.org|Regexp-Log-Common|0.05|i386-netbsd-thread-multi-64int|5.10.0|netbsd|3.1|200810200640
2460641|pass|200810|stro@cpan.org|WWW-UsePerl-Journal|0.22|i686-linux|5.8.8|linux|2.4.27-2-386|200810200058
2459261|pass|200810|bingos@cpan.org|Data-Phrasebook|0.29|i86pc-solaris-thread-multi-64int|5.6.2|solaris|2.10|200810191616
2458601|pass|200810|stro@cpan.org|Test-YAML-Meta|0.11|i686-linux|5.10.0|linux|2.4.27-2-386|200810191525
2457437|pass|200810|stro@cpan.org|CPAN-WWW-Testers-Generator|0.30|MSWin32-x86-multi-thread|5.8.8|MSWin32|5.00|200810191354
2457431|pass|200810|stro@cpan.org|CPAN-WWW-Testers|0.36|MSWin32-x86-multi-thread|5.8.8|MSWin32|5.00|200810191349
2457411|pass|200810|stro@cpan.org|CPAN-WWW-Testers|0.34|MSWin32-x86-multi-thread|5.8.8|MSWin32|5.00|200810191343
2457386|pass|200810|stro@cpan.org|CPAN-Testers-WWW-Statistics|0.52|MSWin32-x86-multi-thread|5.8.8|MSWin32|5.00|200810191338
2457371|pass|200810|stro@cpan.org|CPAN-Testers-WWW-Statistics|0.51|MSWin32-x86-multi-thread|5.8.8|MSWin32|5.00|200810191333
2456880|pass|200810|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|darwin-thread-multi-64int-2level|5.8.8|darwin|8.10.0|200810190757
2456878|pass|200810|bingos@cpan.org|Data-Phrasebook|0.29|darwin-thread-multi-64int-2level|5.8.8|darwin|8.10.0|200810190757
2456873|pass|200810|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|darwin-thread-multi-64int-2level|5.8.6|darwin|8.10.0|200810190755
2456870|pass|200810|bingos@cpan.org|Data-Phrasebook|0.29|darwin-thread-multi-64int-2level|5.8.6|darwin|8.10.0|200810190754
2456865|pass|200810|bingos@cpan.org|Data-Phrasebook|0.29|darwin-thread-multi-64int|5.6.2|darwin|8.10.0|200810190753
2456859|pass|200810|bingos@cpan.org|Data-Phrasebook-Loader-YAML|0.09|darwin-thread-multi-64int-2level|5.10.0|darwin|8.10.0|200810190752
2456854|pass|200810|bingos@cpan.org|Data-Phrasebook|0.29|darwin-thread-multi-64int-2level|5.10.0|darwin|8.10.0|200810190751
2454535|pass|200810|bingos@cpan.org|Regexp-Log-Common|0.05|darwin-thread-multi-64int-2level|5.8.8|darwin|8.10.0|200810181609
2454509|pass|200810|bingos@cpan.org|Regexp-Log-Common|0.05|darwin-thread-multi-64int-2level|5.8.6|darwin|8.10.0|200810181557
2454477|pass|200810|bingos@cpan.org|Regexp-Log-Common|0.05|darwin-thread-multi-64int-2level|5.10.0|darwin|8.10.0|200810181544
2450710|cpan|200810|BARBIE|CPAN-WWW-Testers|0.36||0|||200810171419
2448609|pass|200810|srezic@cpan.org|Data-Phrasebook-Loader-DBI|0.11|i386-freebsd|5.8.8 patch 34467|freebsd|6.1-release-p23|200810162113
2448587|pass|200810|srezic@cpan.org|CPAN-YACSmoke-Plugin-NNTP|0.05|i386-freebsd|5.8.8|freebsd|6.1-release-p23|200810162147
2448569|pass|200810|srezic@cpan.org|CPAN-YACSmoke-Plugin-Outlook|0.06|i386-freebsd|5.8.8|freebsd|6.1-release-p23|200810162147
2448559|pass|200810|srezic@cpan.org|Data-Phrasebook-Loader-Ini|0.10|i386-freebsd|5.8.8|freebsd|6.1-release-p23|200810162147
2448557|pass|200810|srezic@cpan.org|Regexp-Log-Common|0.05|i386-freebsd|5.8.8 patch 34467|freebsd|6.1-release-p23|200810162114
2448405|pass|200810|srezic@cpan.org|Data-Phrasebook-Loader-Ini|0.10|i386-freebsd|5.8.8 patch 34467|freebsd|6.1-release-p23|200810162113
2448298|pass|200810|srezic@cpan.org|CPAN-YACSmoke-Plugin-WebList|0.05|i386-freebsd|5.8.8|freebsd|6.1-release-p23|200810162147
2448286|pass|200810|srezic@cpan.org|Data-Phrasebook-Loader-DBI|0.11|i386-freebsd|5.8.8|freebsd|6.1-release-p23|200810162147
2448283|pass|200810|srezic@cpan.org|Data-Phrasebook-Loader-XML|0.12|i386-freebsd|5.8.8|freebsd|6.1-release-p23|200810162147
2448065|pass|200810|srezic@cpan.org|Regexp-Log-Common|0.05|i386-freebsd|5.8.8|freebsd|6.1-release-p23|200810162148
2448037|pass|200810|srezic@cpan.org|Data-Phrasebook-Loader-XML|0.12|i386-freebsd|5.8.8 patch 34467|freebsd|6.1-release-p23|200810162113
2447973|pass|200810|srezic@cpan.org|Mail-File|0.08|i386-freebsd|5.8.8|freebsd|6.1-release-p23|200810162148
2447792|pass|200810|srezic@cpan.org|Mail-File|0.08|i386-freebsd|5.8.8 patch 34467|freebsd|6.1-release-p23|200810162113
2447735|pass|200810|srezic@cpan.org|CPAN-YACSmoke-Plugin-Outlook|0.06|i386-freebsd|5.8.8 patch 34467|freebsd|6.1-release-p23|200810162113
2447734|pass|200810|srezic@cpan.org|CPAN-YACSmoke-Plugin-WebList|0.05|i386-freebsd|5.8.8 patch 34467|freebsd|6.1-release-p23|200810162113
2447732|pass|200810|srezic@cpan.org|CPAN-YACSmoke-Plugin-NNTP|0.05|i386-freebsd|5.8.8 patch 34467|freebsd|6.1-release-p23|200810162112
2439818|pass|200810|srezic@cpan.org|GD-Chart-Radial|0.07|i386-freebsd|5.8.8 patch 34467|freebsd|6.1-release-p23|200810151106
2439497|pass|200810|srezic@cpan.org|GD-Chart-Radial|0.07|i386-freebsd|5.8.8|freebsd|6.1-release-p23|200810151051
2436197|pass|200810|srezic@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i386-freebsd|5.8.8 patch 34467|freebsd|6.1-release-p23|200810141125
2435630|pass|200810|srezic@cpan.org|Test-YAML-Meta|0.11|i386-freebsd|5.8.8|freebsd|6.1-release-p23|200810141009
2435084|pass|200810|srezic@cpan.org|Parse-CPAN-Distributions|0.05|i386-freebsd|5.8.8 patch 34467|freebsd|6.1-release-p23|200810140831
2434754|pass|200810|srezic@cpan.org|Calendar-List|0.21|i386-freebsd|5.8.8|freebsd|6.1-release-p23|200810140749
2434730|pass|200810|srezic@cpan.org|Mail-Outlook|0.14|i386-freebsd|5.8.8 patch 34467|freebsd|6.1-release-p23|200810140747
2434558|pass|200810|srezic@cpan.org|Parse-CPAN-Distributions|0.05|i386-freebsd|5.8.8|freebsd|6.1-release-p23|200810140728
2434418|pass|200810|srezic@cpan.org|WWW-Scraper-ISBN-Pearson_Driver|0.10|i386-freebsd|5.8.8 patch 34467|freebsd|6.1-release-p23|200810140709
2434155|pass|200810|srezic@cpan.org|CPAN-WWW-Testers-Generator|0.30|i386-freebsd|5.8.8 patch 34467|freebsd|6.1-release-p23|200810140634
2434039|pass|200810|srezic@cpan.org|Test-CPAN-Meta|0.12|i386-freebsd|5.8.8 patch 34467|freebsd|6.1-release-p23|200810140621
2434022|pass|200810|srezic@cpan.org|Finance-Currency-Convert-XE|0.15|i386-freebsd|5.8.8 patch 34467|freebsd|6.1-release-p23|200810140620
2433982|pass|200810|srezic@cpan.org|Test-YAML-Meta|0.11|i386-freebsd|5.8.8 patch 34467|freebsd|6.1-release-p23|200810140616
2433823|pass|200810|srezic@cpan.org|Finance-Currency-Convert-XE|0.15|i386-freebsd|5.8.8|freebsd|6.1-release-p23|200810140558
2433778|pass|200810|srezic@cpan.org|Mail-Outlook|0.14|i386-freebsd|5.8.8|freebsd|6.1-release-p23|200810140552
2433486|fail|200810|srezic@cpan.org|WWW-Scraper-ISBN-Amazon_Driver|0.13|i386-freebsd|5.8.8|freebsd|6.1-release-p23|200810140003
2433423|pass|200810|srezic@cpan.org|WWW-UsePerl-Journal-Thread|0.12|i386-freebsd|5.8.8|freebsd|6.1-release-p23|200810140517
2433112|pass|200810|srezic@cpan.org|CPAN-Testers-WWW-Statistics|0.51|i386-freebsd|5.8.8 patch 34467|freebsd|6.1-release-p23|200810140437
2432748|pass|200810|srezic@cpan.org|Games-Trackword|1.06|i386-freebsd|5.8.8 patch 34467|freebsd|6.1-release-p23|200810140401
2432631|pass|200810|srezic@cpan.org|Data-FormValidator-Constraints-Words|0.03|i386-freebsd|5.8.8 patch 34467|freebsd|6.1-release-p23|200810140352
2431228|fail|200810|srezic@cpan.org|WWW-Scraper-ISBN-Amazon_Driver|0.13|i386-freebsd|5.8.8 patch 34467|freebsd|6.1-release-p23|200810140147
2430379|pass|200810|srezic@cpan.org|CPAN-WWW-Testers-Generator|0.30|i386-freebsd|5.8.8|freebsd|6.1-release-p23|200810140054
2430316|pass|200810|srezic@cpan.org|CPAN-Testers-WWW-Statistics|0.51|i386-freebsd|5.8.8|freebsd|6.1-release-p23|200810140050
2429821|pass|200810|srezic@cpan.org|Test-CPAN-Meta|0.12|i386-freebsd|5.8.8|freebsd|6.1-release-p23|200810140017
2429750|pass|200810|srezic@cpan.org|WWW-UsePerl-Journal-Thread|0.12|i386-freebsd|5.8.8|freebsd|6.1-release-p23|200810140010
2429458|pass|200810|srezic@cpan.org|WWW-Scraper-ISBN-ORA_Driver|0.09|i386-freebsd|5.8.8|freebsd|6.1-release-p23|200810140141
2428537|pass|200810|srezic@cpan.org|Data-Phrasebook|0.29|i386-freebsd|5.8.8 patch 34467|freebsd|6.1-release-p23|200810140026
2427681|pass|200810|srezic@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i386-freebsd|5.8.8|freebsd|6.1-release-p23|200810132322
2427674|pass|200810|srezic@cpan.org|Data-FormValidator-Constraints-Words|0.03|i386-freebsd|5.8.8|freebsd|6.1-release-p23|200810132322
2427587|fail|200810|srezic@cpan.org|WWW-Scraper-ISBN-Yahoo_Driver|0.07|i386-freebsd|5.8.8 patch 34467|freebsd|6.1-release-p23|200810132319
2427477|pass|200810|srezic@cpan.org|Calendar-List|0.21|i386-freebsd|5.8.8 patch 34467|freebsd|6.1-release-p23|200810132233
2424396|pass|200810|stro@cpan.org|CPAN-Testers-WWW-Statistics|0.52|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.00|200810130104
2424009|pass|200810|vpit@cpan.org|CPAN-Testers-WWW-Statistics|0.52|x86_64-linux-thread-multi|5.10.0|linux|2.6.26.3-fuuka.profvince.com|200810122159
2423549|pass|200810|david@cantrell.org.uk|CPAN-Testers-WWW-Statistics|0.52|alpha-netbsd|5.10.0|netbsd|2.1.0_stable|200810121702
2422614|pass|200810|david@cantrell.org.uk|CPAN-Testers-WWW-Statistics|0.52|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200810120417
2422607|pass|200810|david@cantrell.org.uk|CPAN-Testers-WWW-Statistics|0.52|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200810121006
2422604|pass|200810|david@cantrell.org.uk|CPAN-Testers-WWW-Statistics|0.52|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200810121004
2422603|pass|200810|david@cantrell.org.uk|CPAN-Testers-WWW-Statistics|0.52|i686-linux|5.8.8|linux|2.4.27-3-686|200810121003
2421572|pass|200810|imacat@mail.imacat.idv.tw|CPAN-Testers-WWW-Statistics|0.52|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.22.10|200810120238
2417194|pass|200810|JOST@cpan.org ("Josts Smokehouse")|CPAN-Testers-WWW-Statistics|0.52|i86pc-solaris-64int|5.10.0|solaris|2.11|200810101615
2417025|pass|200810|srezic@cpan.org|CPAN-Testers-WWW-Statistics|0.52|i386-freebsd|5.8.8 patch 33662|freebsd|6.1-release-p23|200810101419
2416945|pass|200810|martin.evans@easysoft.com|Test-YAML-Meta|0.11|i486-linux-gnu|5.8.8|linux|2.6.15.7|200810101151
2416872|cpan|200810|BARBIE|CPAN-Testers-WWW-Statistics|0.52||0|||200810101156
2416812|pass|200810|bobtfish@bobtfish.net|Test-YAML-Meta|0.11|x86_64-linux-gnu|5.8.8|linux|2.6.15.7|200810100014
2416426|pass|200810|carlos.arenas@gmail.com ("Carlos Arenas")|Test-YAML-Meta|0.11|i686-linux-thread-multi|5.10.0|linux|2.6.25-arch|200810091809
2416149|fail|200810|bingos@cpan.org|WWW-Scraper-ISBN-Amazon_Driver|0.13|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-19-generic|200810100730
2416125|pass|200810|bingos@cpan.org|WWW-Scraper-ISBN-ORA_Driver|0.09|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-19-generic|200810100723
2416121|pass|200810|bingos@cpan.org|WWW-Scraper-ISBN-Pearson_Driver|0.10|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-19-generic|200810100721
2416047|fail|200810|bingos@cpan.org|WWW-Scraper-ISBN-Yahoo_Driver|0.07|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-19-generic|200810100648
2415921|pass|200810|bingos@cpan.org|Test-YAML-Meta|0.11|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-19-generic|200810100557
2415636|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal|0.22|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.24-19-generic|200810100354
2412252|pass|200810|vpit@cpan.org|Regexp-Log-Common|0.05|x86_64-linux-thread-multi|5.10.0|linux|2.6.26.3-fuuka.profvince.com|200810091941
2408910|fail|200810|rick@jrmyers.net ("Rick Myers")|WWW-Scraper-ISBN-Yahoo_Driver|0.07|i686-linux|5.8.7|linux|2.6.26.5|200810090340
2406226|pass|200810|rick@jrmyers.net ("Rick Myers")|Regexp-Log-Common|0.05|i686-linux|5.11.0 patch 34456|linux|2.6.26.5|200810081533
2405360|pass|200810|bingos@cpan.org|CPAN-WWW-Testers-Generator|0.30|i686-linux-thread-multi-64int|5.8.8|linux|2.4.26|200810081857
2405253|pass|200810|david@cantrell.org.uk|Regexp-Log-Common|0.05|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200810081245
2405246|pass|200810|david@cantrell.org.uk|Regexp-Log-Common|0.05|alpha-netbsd|5.10.0|netbsd|2.1.0_stable|200810081744
2405027|pass|200810|david@cantrell.org.uk|Regexp-Log-Common|0.05|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200810081815
2404331|pass|200810|david@cantrell.org.uk|Regexp-Log-Common|0.05|i686-linux|5.8.8|linux|2.4.27-3-686|200810081702
2403907|pass|200810|david@cantrell.org.uk|Regexp-Log-Common|0.05|IP35-irix-64int|5.8.8|irix|6.5|200810081719
2403862|pass|200810|david@cantrell.org.uk|Regexp-Log-Common|0.05|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200810081609
2403731|pass|200810|rick@jrmyers.net ("Rick Myers")|Regexp-Log-Common|0.05|i686-linux|5.8.7|linux|2.6.26.5|200810081056
2402905|pass|200810|rick@jrmyers.net ("Rick Myers")|WWW-UsePerl-Journal-Thread|0.12|i686-linux|5.8.7|linux|2.6.26.5|200810080837
2402904|pass|200810|rick@jrmyers.net ("Rick Myers")|WWW-UsePerl-Journal|0.22|i686-linux|5.8.7|linux|2.6.26.5|200810080837
2400112|pass|200810|rick@jrmyers.net ("Rick Myers")|Data-FormValidator-Constraints-Words|0.03|i686-linux|5.8.7|linux|2.6.26.5|200810080340
2397651|pass|200810|rick@jrmyers.net ("Rick Myers")|Test-YAML-Meta|0.11|i686-linux|5.8.6|linux|2.6.26.5|200810071811
2395731|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal-Thread|0.12|i386-netbsd-thread-multi-64int|5.10.0 patch 34465|netbsd|4.0|200810071903
2395730|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal|0.22|i386-netbsd-thread-multi-64int|5.10.0 patch 34465|netbsd|4.0|200810071903
2395373|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal-Thread|0.12|i386-netbsd-thread-multi-64int|5.11.0 patch 34470|netbsd|4.0|200810071818
2395371|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal|0.22|i386-netbsd-thread-multi-64int|5.11.0 patch 34470|netbsd|4.0|200810071818
2395217|pass|200810|rick@jrmyers.net ("Rick Myers")|Test-YAML-Meta|0.11|i686-linux|5.11.0 patch 34456|linux|2.6.26.5|200810071259
2394084|pass|200810|rick@jrmyers.net ("Rick Myers")|Finance-Currency-Convert-XE|0.15|i686-linux|5.8.6|linux|2.6.26.5|200810071031
2393177|pass|200810|rick@jrmyers.net ("Rick Myers")|Finance-Currency-Convert-XE|0.15|i686-linux|5.11.0 patch 34456|linux|2.6.26.5|200810070813
2392395|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal-Thread|0.12|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-19-generic|200810071134
2392393|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal|0.22|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-19-generic|200810071133
2391457|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal-Thread|0.12|i386-netbsd-thread-multi-64int|5.8.8|netbsd|3.1|200810071000
2391450|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal-Thread|0.12|i386-netbsd-thread-multi-64int|5.8.7|netbsd|3.1|200810070959
2391439|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal-Thread|0.12|i386-netbsd-thread-multi-64int|5.8.6|netbsd|3.1|200810070958
2391432|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal-Thread|0.12|i386-netbsd-thread-multi-64int|5.8.5|netbsd|3.1|200810070956
2391421|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal-Thread|0.12|i386-netbsd-thread-multi-64int|5.8.4|netbsd|3.1|200810070955
2391410|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal-Thread|0.12|i386-netbsd-thread-multi-64int|5.8.3|netbsd|3.1|200810070953
2391404|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal-Thread|0.12|i386-netbsd-thread-multi-64int|5.8.2|netbsd|3.1|200810070952
2391400|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal-Thread|0.12|i386-netbsd-thread-multi-64int|5.8.1|netbsd|3.1|200810070951
2391393|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal-Thread|0.12|i386-netbsd-thread-multi-64int|5.6.2|netbsd|3.1|200810070950
2391389|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal-Thread|0.12|i386-netbsd-thread-multi-64int|5.10.0|netbsd|3.1|200810070949
2391280|pass|200810|srezic@cpan.org|Regexp-Log-Common|0.05|i386-freebsd-thread-multi|5.8.8|freebsd|6.1-release|200810071037
2391088|pass|200810|srezic@cpan.org|Regexp-Log-Common|0.05|i386-freebsd-thread-multi|5.10.0|freebsd|6.1-release|200810071002
2389068|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal-Thread|0.12|i386-dragonfly-thread-multi-64int|5.10.0|dragonfly|2.0.0-release|200810070339
2389054|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal-Thread|0.11|i386-dragonfly-thread-multi-64int|5.10.0|dragonfly|2.0.0-release|200810070337
2389039|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal|0.22|i386-dragonfly-thread-multi-64int|5.10.0|dragonfly|2.0.0-release|200810070335
2386689|pass|200810|imacat@mail.imacat.idv.tw|CPAN-Testers-WWW-Statistics|0.51|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.22.10|200810070330
2385724|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal-Thread|0.12|i386-netbsd-thread-multi-64int|5.8.8|netbsd|4.0|200810061738
2385708|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal-Thread|0.11|i386-netbsd-thread-multi-64int|5.8.8|netbsd|4.0|200810061736
2385697|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal|0.22|i386-netbsd-thread-multi-64int|5.8.8|netbsd|4.0|200810061735
2385523|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal-Thread|0.12|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0|200810061713
2385509|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal-Thread|0.11|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0|200810061711
2385490|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal|0.22|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0|200810061709
2380651|pass|200810|rick@jrmyers.net ("Rick Myers")|Data-Phrasebook-Loader-YAML|0.09|i686-linux|5.8.6|linux|2.6.26.5|200810041705
2380650|pass|200810|rick@jrmyers.net ("Rick Myers")|Data-Phrasebook|0.29|i686-linux|5.8.6|linux|2.6.26.5|200810041704
2377550|pass|200810|jeff@zeroclue.com|CPAN-WWW-Testers-Generator|0.30|darwin-2level|5.10.0|darwin|9.2.0|200810031110
2377123|pass|200810|jeff@zeroclue.com|CPAN-Testers-WWW-Statistics|0.51|darwin-2level|5.10.0|darwin|9.2.0|200810031112
2377018|pass|200810|jeff@zeroclue.com|Test-YAML-Meta|0.11|darwin-2level|5.10.0|darwin|9.2.0|200810030909
2373644|pass|200810|rick@jrmyers.net ("Rick Myers")|Data-Phrasebook-Loader-YAML|0.09|i686-linux|5.8.7|linux|2.6.26.5|200810040006
2373643|pass|200810|rick@jrmyers.net ("Rick Myers")|Data-Phrasebook|0.29|i686-linux|5.8.7|linux|2.6.26.5|200810040006
2373476|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal-Thread|0.12|OpenBSD.i386-openbsd-thread-multi-64int|5.11.0 patch 34456|openbsd|4.2|200810032227
2373460|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal-Thread|0.11|OpenBSD.i386-openbsd-thread-multi-64int|5.11.0 patch 34456|openbsd|4.2|200810032225
2373443|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal|0.22|OpenBSD.i386-openbsd-thread-multi-64int|5.11.0 patch 34456|openbsd|4.2|200810032222
2365509|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal-Thread|0.12|OpenBSD.i386-openbsd-thread-multi-64int|5.8.8|openbsd|4.2|200810022330
2365493|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal-Thread|0.11|OpenBSD.i386-openbsd-thread-multi-64int|5.8.8|openbsd|4.2|200810022327
2365477|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal|0.22|OpenBSD.i386-openbsd-thread-multi-64int|5.8.8|openbsd|4.2|200810022325
2364857|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal-Thread|0.12|OpenBSD.i386-openbsd-thread-multi-64int|5.10.0|openbsd|4.2|200810022201
2364839|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal-Thread|0.11|OpenBSD.i386-openbsd-thread-multi-64int|5.10.0|openbsd|4.2|200810022159
2364831|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal|0.22|OpenBSD.i386-openbsd-thread-multi-64int|5.10.0|openbsd|4.2|200810022157
2363284|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal-Thread|0.12|darwin-thread-multi-64int-2level|5.8.8|darwin|8.10.0|200810021923
2363281|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal-Thread|0.12|darwin-thread-multi-64int-2level|5.8.6|darwin|8.10.0|200810021921
2363273|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal-Thread|0.12|darwin-thread-multi-64int|5.6.2|darwin|8.10.0|200810021920
2363262|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal-Thread|0.12|darwin-thread-multi-64int-2level|5.10.0|darwin|8.10.0|200810021918
2363260|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal-Thread|0.11|darwin-thread-multi-64int-2level|5.8.8|darwin|8.10.0|200810021916
2363259|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal-Thread|0.11|darwin-thread-multi-64int-2level|5.8.6|darwin|8.10.0|200810021915
2363252|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal-Thread|0.11|darwin-thread-multi-64int|5.6.2|darwin|8.10.0|200810021913
2363247|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal-Thread|0.11|darwin-thread-multi-64int-2level|5.10.0|darwin|8.10.0|200810021911
2363244|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal|0.22|darwin-thread-multi-64int-2level|5.8.8|darwin|8.10.0|200810021910
2363226|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal|0.22|darwin-thread-multi-64int-2level|5.8.6|darwin|8.10.0|200810021906
2363193|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal|0.22|darwin-thread-multi-64int|5.6.2|darwin|8.10.0|200810021903
2363179|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal|0.22|darwin-thread-multi-64int-2level|5.10.0|darwin|8.10.0|200810021859
2362870|pass|200810|rick@jrmyers.net ("Rick Myers")|Games-Trackword|1.06|i686-linux|5.11.0 patch 34435|linux|2.6.26.5|200810021339
2362850|pass|200810|rick@jrmyers.net ("Rick Myers")|Mail-File|0.08|i686-linux|5.11.0 patch 34435|linux|2.6.26.5|200810021335
2362798|pass|200810|rick@jrmyers.net ("Rick Myers")|Parse-CPAN-Distributions|0.05|i686-linux|5.11.0 patch 34435|linux|2.6.26.5|200810021326
2362795|pass|200810|david@cantrell.org.uk|CPAN-WWW-Testers-Generator|0.30|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200810021225
2362783|pass|200810|rick@jrmyers.net ("Rick Myers")|Calendar-List|0.21|i686-linux|5.11.0 patch 34435|linux|2.6.26.5|200810021324
2362777|pass|200810|rick@jrmyers.net ("Rick Myers")|GD-Chart-Radial|0.07|i686-linux|5.11.0 patch 34435|linux|2.6.26.5|200810021323
2362771|pass|200810|rick@jrmyers.net ("Rick Myers")|WWW-Scraper-ISBN-ORA_Driver|0.09|i686-linux|5.11.0 patch 34435|linux|2.6.26.5|200810021323
2362755|pass|200810|david@cantrell.org.uk|CPAN-Testers-WWW-Statistics|0.51|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200810021221
2362754|pass|200810|rick@jrmyers.net ("Rick Myers")|WWW-Scraper-ISBN-Pearson_Driver|0.10|i686-linux|5.11.0 patch 34435|linux|2.6.26.5|200810021321
2362646|pass|200810|david@cantrell.org.uk|CPAN-WWW-Testers-Generator|0.30|alpha-netbsd|5.10.0|netbsd|2.1.0_stable|200810021707
2362642|fail|200810|rick@jrmyers.net ("Rick Myers")|WWW-Scraper-ISBN-Yahoo_Driver|0.07|i686-linux|5.11.0 patch 34435|linux|2.6.26.5|200810021307
2362625|pass|200810|david@cantrell.org.uk|CPAN-Testers-WWW-Statistics|0.51|alpha-netbsd|5.10.0|netbsd|2.1.0_stable|200810021703
2362549|pass|200810|david@cantrell.org.uk|CPAN-WWW-Testers-Generator|0.30|IP35-irix-64int|5.8.8|irix|6.5|200810021850
2362547|pass|200810|david@cantrell.org.uk|CPAN-WWW-Testers-Generator|0.30|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200810021749
2362542|pass|200810|taro-nishino@wine.ocn.ne.jp ("Taro Nishino")|CPAN-WWW-Testers-Generator|0.30|MSWin32-x86-multi-thread|5.8.8|MSWin32|5.0|200810030148
2362539|pass|200810|david@cantrell.org.uk|CPAN-Testers-WWW-Statistics|0.51|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200810021742
2362537|pass|200810|srezic@cpan.org|WWW-UsePerl-Journal-Thread|0.12|i386-freebsd|5.6.2|freebsd|6.1-release|200810021809
2362528|pass|200810|david@cantrell.org.uk|CPAN-WWW-Testers-Generator|0.30|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200810021746
2362526|pass|200810|taro-nishino@wine.ocn.ne.jp ("Taro Nishino")|CPAN-Testers-WWW-Statistics|0.51|MSWin32-x86-multi-thread|5.8.8|MSWin32|5.0|200810030146
2362523|pass|200810|david@cantrell.org.uk|CPAN-Testers-WWW-Statistics|0.51|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200810021745
2362517|pass|200810|david@cantrell.org.uk|CPAN-WWW-Testers-Generator|0.30|i686-linux|5.8.8|linux|2.4.27-3-686|200810021743
2362508|pass|200810|david@cantrell.org.uk|CPAN-Testers-WWW-Statistics|0.51|i686-linux|5.8.8|linux|2.4.27-3-686|200810021742
2362128|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal-Thread|0.12|i386-freebsd-thread-multi-64int|5.8.8 patch 34450|freebsd|7.0-release|200810021413
2362123|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal-Thread|0.11|i386-freebsd-thread-multi-64int|5.8.8 patch 34450|freebsd|7.0-release|200810021411
2362109|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal|0.22|i386-freebsd-thread-multi-64int|5.8.8 patch 34450|freebsd|7.0-release|200810021408
2362093|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal-Thread|0.12|i386-freebsd-thread-multi-64int|5.10.0 patch 34445|freebsd|7.0-release|200810021405
2362085|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal-Thread|0.11|i386-freebsd-thread-multi-64int|5.10.0 patch 34445|freebsd|7.0-release|200810021402
2362080|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal|0.22|i386-freebsd-thread-multi-64int|5.10.0 patch 34445|freebsd|7.0-release|200810021359
2361919|pass|200810|vpit@cpan.org|WWW-UsePerl-Journal-Thread|0.12|x86_64-linux-thread-multi|5.10.0|linux|2.6.26.3-fuuka.profvince.com|200810021638
2361915|pass|200810|vpit@cpan.org|CPAN-Testers-WWW-Statistics|0.51|x86_64-linux-thread-multi|5.10.0|linux|2.6.26.3-fuuka.profvince.com|200810021637
2361765|pass|200810|srezic@cpan.org|CPAN-WWW-Testers-Generator|0.30|i386-freebsd|5.6.2|freebsd|6.1-release|200810021558
2360537|pass|200810|srezic@cpan.org|WWW-UsePerl-Journal-Thread|0.12|i386-freebsd-64int|5.8.8|freebsd|6.1-release|200810021256
2360267|pass|200810|martin.evans@easysoft.com|CPAN-Testers-WWW-Statistics|0.51|i686-linux-ld|5.10.0|linux|2.6.24-19-generic|200810021128
2360261|pass|200810|martin.evans@easysoft.com|CPAN-WWW-Testers-Generator|0.30|i686-linux-ld|5.10.0|linux|2.6.24-19-generic|200810021127
2359737|pass|200810|srezic@cpan.org|CPAN-Testers-WWW-Statistics|0.51|i386-freebsd-64int|5.8.8|freebsd|6.1-release|200810021102
2359736|pass|200810|srezic@cpan.org|CPAN-WWW-Testers-Generator|0.30|i386-freebsd-64int|5.8.8|freebsd|6.1-release|200810021102
2359088|pass|200810|vpit@cpan.org|CPAN-WWW-Testers-Generator|0.30|i686-linux-thread-multi|5.10.0|linux|2.6.18.3-tmb-desktop-2mdvsmp|200810020955
2358997|pass|200810|JOST@cpan.org ("Josts Smokehouse")|CPAN-Testers-WWW-Statistics|0.51|i86pc-solaris-64int|5.10.0|solaris|2.11|200810020945
2358994|pass|200810|JOST@cpan.org ("Josts Smokehouse")|CPAN-WWW-Testers-Generator|0.30|i86pc-solaris-64int|5.10.0|solaris|2.11|200810020945
2357109|pass|200810|rick@jrmyers.net ("Rick Myers")|WWW-UsePerl-Journal|0.21|i686-linux|5.11.0 patch 34435|linux|2.6.26.5|200810020300
2356926|pass|200810|rick@jrmyers.net ("Rick Myers")|Data-FormValidator-Constraints-Words|0.03|i686-linux|5.11.0 patch 34435|linux|2.6.26.5|200810020231
2356861|pass|200810|rick@jrmyers.net ("Rick Myers")|Parse-CPAN-Distributions|0.01|i686-linux|5.11.0 patch 34435|linux|2.6.26.5|200810020222
2356805|pass|200810|rick@jrmyers.net ("Rick Myers")|Data-Phrasebook-Loader-Ini|0.10|i686-linux|5.11.0 patch 34435|linux|2.6.26.5|200810020215
2356696|pass|200810|rick@jrmyers.net ("Rick Myers")|Data-Phrasebook-Loader-DBI|0.11|i686-linux|5.11.0 patch 34435|linux|2.6.26.5|200810020158
2356615|pass|200810|rick@jrmyers.net ("Rick Myers")|Mail-Outlook|0.14|i686-linux|5.11.0 patch 34435|linux|2.6.26.5|200810020135
2356603|fail|200810|rick@jrmyers.net ("Rick Myers")|WWW-Scraper-ISBN-Amazon_Driver|0.13|i686-linux|5.11.0 patch 34435|linux|2.6.26.5|200810020134
2356509|pass|200810|rick@jrmyers.net ("Rick Myers")|Test-CPAN-Meta|0.12|i686-linux|5.11.0 patch 34435|linux|2.6.26.5|200810020117
2356440|pass|200810|rick@jrmyers.net ("Rick Myers")|Regexp-Log-Common|0.05|i686-linux|5.11.0 patch 34435|linux|2.6.26.5|200810020056
2356052|pass|200810|stro@cpan.org|CPAN-WWW-Testers-Generator|0.30|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.00|200810020222
2356040|pass|200810|stro@cpan.org|CPAN-Testers-WWW-Statistics|0.51|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.00|200810020217
2355940|pass|200810|srezic@cpan.org|WWW-UsePerl-Journal-Thread|0.12|i386-freebsd|5.10.0|freebsd|6.1-release|200810020044
2355603|pass|200810|srezic@cpan.org|CPAN-WWW-Testers-Generator|0.30|i386-freebsd|5.8.8 patch 33662|freebsd|6.1-release-p23|200810012348
2355602|pass|200810|srezic@cpan.org|CPAN-Testers-WWW-Statistics|0.51|i386-freebsd|5.8.8 patch 33662|freebsd|6.1-release-p23|200810012348
2354883|pass|200810|srezic@cpan.org|CPAN-Testers-WWW-Statistics|0.51|i386-freebsd|5.10.0|freebsd|6.1-release|200810012133
2354882|pass|200810|srezic@cpan.org|CPAN-WWW-Testers-Generator|0.30|i386-freebsd|5.10.0|freebsd|6.1-release|200810012133
2354375|cpan|200810|BARBIE|CPAN-WWW-Testers-Generator|0.30||0|||200810012017
2354368|cpan|200810|BARBIE|CPAN-Testers-WWW-Statistics|0.51||0|||200810012015
2353976|fail|200810|bingos@cpan.org|WWW-UsePerl-Journal|0.22|i386-freebsd-thread-multi-64int|5.11.0 patch 34451|freebsd|7.0-release|200810011630
2353936|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal-Thread|0.12|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.21.5-smp|200810011735
2353914|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal-Thread|0.11|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.21.5-smp|200810011733
2353892|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal|0.22|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.21.5-smp|200810011730
2353882|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal-Thread|0.12|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.21.5-smp|200810011728
2353873|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal-Thread|0.11|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.21.5-smp|200810011726
2353851|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal|0.22|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.21.5-smp|200810011723
2353029|pass|200810|martin.evans@easysoft.com|WWW-UsePerl-Journal-Thread|0.12|i686-linux-ld|5.10.0|linux|2.6.24-19-generic|200810011518
2352864|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal-Thread|0.12|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.0-release|200810011337
2352850|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal-Thread|0.11|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.0-release|200810011335
2352834|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal|0.22|i386-freebsd-thread-multi-64int|5.10.0|freebsd|7.0-release|200810011332
2352159|pass|200810|david@cantrell.org.uk|WWW-UsePerl-Journal-Thread|0.12|alpha-netbsd|5.10.0|netbsd|2.1.0_stable|200810011053
2352146|pass|200810|david@cantrell.org.uk|WWW-UsePerl-Journal-Thread|0.12|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200810011151
2352145|pass|200810|david@cantrell.org.uk|WWW-UsePerl-Journal-Thread|0.12|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200810010552
2352144|pass|200810|david@cantrell.org.uk|WWW-UsePerl-Journal-Thread|0.12|i686-linux|5.8.8|linux|2.4.27-3-686|200810011152
2352143|pass|200810|david@cantrell.org.uk|WWW-UsePerl-Journal-Thread|0.12|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200810011151
2351776|pass|200810|david@cantrell.org.uk|WWW-UsePerl-Journal-Thread|0.12|i686-linux|5.6.2|linux|2.4.27-3-686|200810011039
2351627|pass|200810|imacat@mail.imacat.idv.tw|WWW-UsePerl-Journal-Thread|0.12|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.22.10|200810011707
2351467|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal-Thread|0.11|i386-netbsd-thread-multi-64int|5.8.8|netbsd|3.1|200810010921
2351461|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal-Thread|0.11|i386-netbsd-thread-multi-64int|5.8.7|netbsd|3.1|200810010919
2351452|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal-Thread|0.11|i386-netbsd-thread-multi-64int|5.8.6|netbsd|3.1|200810010918
2351450|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal-Thread|0.11|i386-netbsd-thread-multi-64int|5.8.5|netbsd|3.1|200810010917
2351448|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal-Thread|0.11|i386-netbsd-thread-multi-64int|5.8.4|netbsd|3.1|200810010916
2351434|pass|200810|vpit@cpan.org|CPAN-WWW-Testers|0.35|i686-linux-thread-multi|5.10.0|linux|2.6.18.3-tmb-desktop-2mdvsmp|200810011015
2351432|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal-Thread|0.11|i386-netbsd-thread-multi-64int|5.8.3|netbsd|3.1|200810010914
2351426|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal-Thread|0.11|i386-netbsd-thread-multi-64int|5.8.2|netbsd|3.1|200810010913
2351422|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal-Thread|0.11|i386-netbsd-thread-multi-64int|5.8.1|netbsd|3.1|200810010912
2351417|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal-Thread|0.11|i386-netbsd-thread-multi-64int|5.6.2|netbsd|3.1|200810010911
2351413|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal-Thread|0.11|i386-netbsd-thread-multi-64int|5.10.0|netbsd|3.1|200810010910
2351409|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal|0.22|i386-netbsd-thread-multi-64int|5.8.8|netbsd|3.1|200810010909
2351402|pass|200810|JOST@cpan.org ("Josts Smokehouse")|WWW-UsePerl-Journal-Thread|0.12|i86pc-solaris-64int|5.10.0|solaris|2.11|200810011007
2351401|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal|0.22|i386-netbsd-thread-multi-64int|5.8.7|netbsd|3.1|200810010906
2351387|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal|0.22|i386-netbsd-thread-multi-64int|5.8.6|netbsd|3.1|200810010904
2351373|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal|0.22|i386-netbsd-thread-multi-64int|5.8.5|netbsd|3.1|200810010859
2351353|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal|0.22|i386-netbsd-thread-multi-64int|5.8.4|netbsd|3.1|200810010857
2351331|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal|0.22|i386-netbsd-thread-multi-64int|5.8.3|netbsd|3.1|200810010854
2351318|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal|0.22|i386-netbsd-thread-multi-64int|5.8.2|netbsd|3.1|200810010851
2351292|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal|0.22|i386-netbsd-thread-multi-64int|5.8.1|netbsd|3.1|200810010849
2351286|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal|0.22|i386-netbsd-thread-multi-64int|5.6.2|netbsd|3.1|200810010846
2351281|pass|200810|bingos@cpan.org|WWW-UsePerl-Journal|0.22|i386-netbsd-thread-multi-64int|5.10.0|netbsd|3.1|200810010843
2350924|pass|200810|rick@jrmyers.net ("Rick Myers")|WWW-UsePerl-Journal-Thread|0.12|i686-linux|5.8.8|linux|2.6.26.5|200810010238
2350899|pass|200810|rick@jrmyers.net ("Rick Myers")|WWW-UsePerl-Journal|0.22|i686-linux|5.8.8|linux|2.6.26.5|200810010234
2347172|pass|200809|stro@cpan.org|WWW-UsePerl-Journal|0.22|MSWin32-x86-multi-thread|5.8.8|MSWin32|5.00|200809302309
2346747|pass|200809|rick@jrmyers.net ("Rick Myers")|Finance-Currency-Convert-XE|0.15|i686-linux|5.11.0 patch 34435|linux|2.6.26.5|200809301527
2346466|pass|200809|bingos@cpan.org|WWW-UsePerl-Journal-Thread|0.11|i386-netbsd-thread-multi-64int|5.10.0 patch 34437|netbsd|4.0|200809301946
2346463|pass|200809|bingos@cpan.org|WWW-UsePerl-Journal|0.22|i386-netbsd-thread-multi-64int|5.10.0 patch 34437|netbsd|4.0|200809301946
2346350|pass|200809|bingos@cpan.org|WWW-UsePerl-Journal-Thread|0.11|i386-freebsd-thread-multi-64int|5.11.0 patch 34448|freebsd|6.2-release|200809301408
2346340|pass|200809|bingos@cpan.org|WWW-UsePerl-Journal|0.22|i386-freebsd-thread-multi-64int|5.11.0 patch 34448|freebsd|6.2-release|200809301407
2346258|pass|200809|rick@jrmyers.net ("Rick Myers")|WWW-UsePerl-Journal|0.22|i686-linux|5.10.0|linux|2.6.26.5|200809301418
2346081|pass|200809|chris@bingosnet.co.uk|WWW-UsePerl-Journal-Thread|0.12|darwin-thread-multi-64int-2level|5.8.8|darwin|8.10.0|200809301851
2346078|pass|200809|chris@bingosnet.co.uk|WWW-UsePerl-Journal-Thread|0.12|darwin-thread-multi-64int-2level|5.8.6|darwin|8.10.0|200809301849
2346073|pass|200809|chris@bingosnet.co.uk|WWW-UsePerl-Journal-Thread|0.12|darwin-thread-multi-64int|5.6.2|darwin|8.10.0|200809301847
2346071|pass|200809|chris@bingosnet.co.uk|WWW-UsePerl-Journal-Thread|0.12|darwin-thread-multi-64int-2level|5.10.0|darwin|8.10.0|200809301846
2345812|pass|200809|vpit@cpan.org|WWW-UsePerl-Journal-Thread|0.11|x86_64-linux-thread-multi|5.10.0|linux|2.6.26.3-fuuka.profvince.com|200809301902
2345806|pass|200809|vpit@cpan.org|WWW-UsePerl-Journal|0.22|x86_64-linux-thread-multi|5.10.0|linux|2.6.26.3-fuuka.profvince.com|200809301902
2345797|pass|200809|bingos@cpan.org|WWW-UsePerl-Journal-Thread|0.11|i386-netbsd-thread-multi-64int|5.8.8 patch 34439|netbsd|4.0|200809301755
2345792|pass|200809|bingos@cpan.org|WWW-UsePerl-Journal|0.22|i386-netbsd-thread-multi-64int|5.8.8 patch 34439|netbsd|4.0|200809301755
2345656|pass|200809|rick@jrmyers.net ("Rick Myers")|WWW-UsePerl-Journal-Thread|0.12|i686-linux|5.10.0|linux|2.6.26.5|200809301223
2345541|pass|200809|rick@jrmyers.net ("Rick Myers")|WWW-UsePerl-Journal-Thread|0.12|i686-linux|5.11.0 patch 34435|linux|2.6.26.5|200809301156
2345432|pass|200809|srezic@cpan.org|WWW-UsePerl-Journal|0.22|i386-freebsd|5.6.2|freebsd|6.1-release|200809301740
2345425|pass|200809|srezic@cpan.org|WWW-UsePerl-Journal-Thread|0.12|i386-freebsd|5.8.8 patch 33662|freebsd|6.1-release-p23|200809301741
2344729|pass|200809|srezic@cpan.org|WWW-UsePerl-Journal|0.22|i386-freebsd-64int|5.8.8|freebsd|6.1-release|200809301549
2344624|pass|200809|martin.evans@easysoft.com|WWW-UsePerl-Journal-Thread|0.11|i686-linux-ld|5.10.0|linux|2.6.24-19-generic|200809301436
2344622|pass|200809|martin.evans@easysoft.com|WWW-UsePerl-Journal|0.22|i686-linux-ld|5.10.0|linux|2.6.24-19-generic|200809301436
2344331|pass|200809|bingos@cpan.org|WWW-UsePerl-Journal-Thread|0.11|i386-netbsd-thread-multi-64int|5.11.0 patch 34444|netbsd|4.0|200809301356
2344318|pass|200809|bingos@cpan.org|WWW-UsePerl-Journal|0.22|i386-netbsd-thread-multi-64int|5.11.0 patch 34444|netbsd|4.0|200809301351
2343991|pass|200809|david@cantrell.org.uk|WWW-UsePerl-Journal-Thread|0.11|alpha-netbsd|5.10.0|netbsd|2.1.0_stable|200809301212
2343989|pass|200809|david@cantrell.org.uk|WWW-UsePerl-Journal|0.22|alpha-netbsd|5.10.0|netbsd|2.1.0_stable|200809301211
2343964|pass|200809|david@cantrell.org.uk|WWW-UsePerl-Journal-Thread|0.11|i686-linux|5.6.2|linux|2.4.27-3-686|200809301306
2343962|pass|200809|david@cantrell.org.uk|WWW-UsePerl-Journal|0.22|i686-linux|5.6.2|linux|2.4.27-3-686|200809301306
2343758|pass|200809|david@cantrell.org.uk|WWW-UsePerl-Journal-Thread|0.11|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200809300627
2343753|pass|200809|david@cantrell.org.uk|WWW-UsePerl-Journal|0.22|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200809300627
2343649|pass|200809|srezic@cpan.org|WWW-UsePerl-Journal-Thread|0.11|i386-freebsd|5.8.8 patch 33662|freebsd|6.1-release-p23|200809301303
2343578|pass|200809|david@cantrell.org.uk|WWW-UsePerl-Journal-Thread|0.11|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200809301157
2343577|pass|200809|david@cantrell.org.uk|WWW-UsePerl-Journal|0.22|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200809301157
2343499|cpan|200809|BARBIE|WWW-UsePerl-Journal-Thread|0.12||0|||200809301242
2343456|pass|200809|david@cantrell.org.uk|WWW-UsePerl-Journal-Thread|0.11|i686-linux|5.8.8|linux|2.4.27-3-686|200809301136
2343452|pass|200809|david@cantrell.org.uk|WWW-UsePerl-Journal|0.22|i686-linux|5.8.8|linux|2.4.27-3-686|200809301136
2343451|pass|200809|david@cantrell.org.uk|WWW-UsePerl-Journal-Thread|0.11|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200809301135
2343448|pass|200809|david@cantrell.org.uk|WWW-UsePerl-Journal|0.22|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200809301135
2343415|pass|200809|imacat@mail.imacat.idv.tw|WWW-UsePerl-Journal-Thread|0.11|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.22.10|200809301823
2343409|pass|200809|imacat@mail.imacat.idv.tw|WWW-UsePerl-Journal|0.22|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.22.10|200809301821
2342949|pass|200809|srezic@cpan.org|WWW-UsePerl-Journal|0.22|i386-freebsd|5.10.0|freebsd|6.1-release|200809301057
2342907|pass|200809|JOST@cpan.org ("Josts Smokehouse")|Mail-Outlook|0.14|i86pc-solaris-64int|5.10.0|solaris|2.11|200809301055
2342864|pass|200809|JOST@cpan.org ("Josts Smokehouse")|WWW-UsePerl-Journal|0.22|i86pc-solaris-64int|5.10.0|solaris|2.11|200809301044
2342681|pass|200809|JOST@cpan.org ("Josts Smokehouse")|WWW-UsePerl-Journal-Thread|0.11|i86pc-solaris-64int|5.10.0|solaris|2.11|200809301008
2342667|pass|200809|rick@jrmyers.net ("Rick Myers")|WWW-UsePerl-Journal-Thread|0.11|i686-linux|5.11.0 patch 34435|linux|2.6.26.5|200809300401
2342666|pass|200809|rick@jrmyers.net ("Rick Myers")|WWW-UsePerl-Journal|0.22|i686-linux|5.11.0 patch 34435|linux|2.6.26.5|200809300400
2342584|pass|200809|chris@bingosnet.co.uk|WWW-UsePerl-Journal-Thread|0.11|darwin-thread-multi-64int-2level|5.8.8|darwin|8.10.0|200809300846
2342561|pass|200809|chris@bingosnet.co.uk|WWW-UsePerl-Journal-Thread|0.11|darwin-thread-multi-64int-2level|5.8.6|darwin|8.10.0|200809300843
2342521|pass|200809|chris@bingosnet.co.uk|WWW-UsePerl-Journal-Thread|0.11|darwin-thread-multi-64int|5.6.2|darwin|8.10.0|200809300839
2342500|pass|200809|chris@bingosnet.co.uk|WWW-UsePerl-Journal-Thread|0.11|darwin-thread-multi-64int-2level|5.10.0|darwin|8.10.0|200809300837
2342223|pass|200809|stro@cpan.org|WWW-UsePerl-Journal|0.22|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.00|200809301001
2339845|pass|200809|rick@jrmyers.net ("Rick Myers")|Data-Phrasebook-Loader-YAML|0.09|i686-linux|5.11.0 patch 34435|linux|2.6.26.5|200809291953
2339842|pass|200809|rick@jrmyers.net ("Rick Myers")|Data-Phrasebook|0.29|i686-linux|5.11.0 patch 34435|linux|2.6.26.5|200809291953
2338665|cpan|200809|BARBIE|WWW-UsePerl-Journal-Thread|0.11||0|||200809292345
2338362|pass|200809|chris@bingosnet.co.uk|WWW-UsePerl-Journal|0.22|darwin-thread-multi-64int-2level|5.8.8|darwin|8.10.0|200809292207
2338326|pass|200809|chris@bingosnet.co.uk|WWW-UsePerl-Journal|0.22|darwin-thread-multi-64int-2level|5.8.6|darwin|8.10.0|200809292202
2338249|pass|200809|chris@bingosnet.co.uk|WWW-UsePerl-Journal|0.22|darwin-thread-multi-64int|5.6.2|darwin|8.10.0|200809292157
2338231|pass|200809|chris@bingosnet.co.uk|WWW-UsePerl-Journal|0.22|darwin-thread-multi-64int-2level|5.10.0|darwin|8.10.0|200809292153
2336646|pass|200809|JOST@cpan.org ("Josts Smokehouse")|Data-Phrasebook-Loader-DBI|0.11|i86pc-solaris-64int|5.10.0|solaris|2.11|200809291955
2336644|pass|200809|JOST@cpan.org ("Josts Smokehouse")|Data-Phrasebook-Loader-Ini|0.10|i86pc-solaris-64int|5.10.0|solaris|2.11|200809291955
2336642|pass|200809|JOST@cpan.org ("Josts Smokehouse")|Data-Phrasebook-Loader-XML|0.12|i86pc-solaris-64int|5.10.0|solaris|2.11|200809291955
2336173|pass|200809|srezic@cpan.org|WWW-UsePerl-Journal|0.22|i386-freebsd|5.8.8 patch 33662|freebsd|6.1-release-p23|200809291847
2335954|pass|200809|JOST@cpan.org ("Josts Smokehouse")|CPAN-WWW-Testers-Generator|0.29|i86pc-solaris-64int|5.10.0|solaris|2.11|200809291829
2334984|pass|200809|JOST@cpan.org ("Josts Smokehouse")|CPAN-Testers-WWW-Statistics|0.50|i86pc-solaris-64int|5.10.0|solaris|2.11|200809291642
2334761|pass|200809|JOST@cpan.org ("Josts Smokehouse")|Parse-CPAN-Distributions|0.05|i86pc-solaris-64int|5.10.0|solaris|2.11|200809291610
2334461|cpan|200809|BARBIE|WWW-UsePerl-Journal|0.22||0|||200809291524
2333219|pass|200809|rick@jrmyers.net ("Rick Myers")|Test-YAML-Meta|0.11|i686-linux|5.11.0 patch 34435|linux|2.6.26.5|200809290631
2331775|pass|200809|stro@cpan.org|CPAN-WWW-Testers|0.35|MSWin32-x86-multi-thread|5.8.8|MSWin32|5.00|200809290840
2328912|pass|200809|rick@jrmyers.net ("Rick Myers")|Games-Trackword|1.06|i686-linux|5.10.0|linux|2.6.26.5|200809281619
2328786|pass|200809|rick@jrmyers.net ("Rick Myers")|Games-Trackword|1.06|i686-linux|5.8.8|linux|2.6.26.5|200809281552
2328728|pass|200809|rick@jrmyers.net ("Rick Myers")|Mail-File|0.08|i686-linux|5.10.0|linux|2.6.26.5|200809281543
2328573|pass|200809|rick@jrmyers.net ("Rick Myers")|Mail-File|0.08|i686-linux|5.8.8|linux|2.6.26.5|200809281526
2328494|pass|200809|taro-nishino@wine.ocn.ne.jp ("Taro Nishino")|Parse-CPAN-Distributions|0.05|MSWin32-x86-multi-thread|5.8.8|MSWin32|5.0|200809290417
2328135|pass|200809|rick@jrmyers.net ("Rick Myers")|Calendar-List|0.21|i686-linux|5.10.0|linux|2.6.26.5|200809281443
2328101|pass|200809|rick@jrmyers.net ("Rick Myers")|GD-Chart-Radial|0.07|i686-linux|5.10.0|linux|2.6.26.5|200809281440
2328066|pass|200809|rick@jrmyers.net ("Rick Myers")|WWW-Scraper-ISBN-ORA_Driver|0.09|i686-linux|5.10.0|linux|2.6.26.5|200809281437
2328009|pass|200809|rick@jrmyers.net ("Rick Myers")|WWW-Scraper-ISBN-Pearson_Driver|0.10|i686-linux|5.10.0|linux|2.6.26.5|200809281430
2327982|pass|200809|rick@jrmyers.net ("Rick Myers")|Calendar-List|0.21|i686-linux|5.8.8|linux|2.6.26.5|200809281426
2327950|pass|200809|rick@jrmyers.net ("Rick Myers")|GD-Chart-Radial|0.07|i686-linux|5.8.8|linux|2.6.26.5|200809281423
2327773|pass|200809|rick@jrmyers.net ("Rick Myers")|WWW-Scraper-ISBN-ORA_Driver|0.09|i686-linux|5.8.8|linux|2.6.26.5|200809281405
2327726|pass|200809|rick@jrmyers.net ("Rick Myers")|WWW-Scraper-ISBN-Pearson_Driver|0.10|i686-linux|5.8.8|linux|2.6.26.5|200809281400
2327359|fail|200809|rick@jrmyers.net ("Rick Myers")|WWW-Scraper-ISBN-Yahoo_Driver|0.07|i686-linux|5.10.0|linux|2.6.26.5|200809281316
2327202|pass|200809|rick@jrmyers.net ("Rick Myers")|WWW-UsePerl-Journal|0.21|i686-linux|5.10.0|linux|2.6.26.5|200809281254
2327197|fail|200809|rick@jrmyers.net ("Rick Myers")|WWW-Scraper-ISBN-Yahoo_Driver|0.07|i686-linux|5.8.8|linux|2.6.26.5|200809281253
2326887|pass|200809|rick@jrmyers.net ("Rick Myers")|WWW-UsePerl-Journal|0.21|i686-linux|5.8.8|linux|2.6.26.5|200809281222
2326635|pass|200809|rick@jrmyers.net ("Rick Myers")|Data-FormValidator-Constraints-Words|0.03|i686-linux|5.10.0|linux|2.6.26.5|200809281157
2326370|pass|200809|rick@jrmyers.net ("Rick Myers")|Parse-CPAN-Distributions|0.01|i686-linux|5.10.0|linux|2.6.26.5|200809281131
2326201|pass|200809|rick@jrmyers.net ("Rick Myers")|Data-FormValidator-Constraints-Words|0.03|i686-linux|5.8.8|linux|2.6.26.5|200809281109
2326134|pass|200809|rick@jrmyers.net ("Rick Myers")|Data-Phrasebook-Loader-Ini|0.10|i686-linux|5.10.0|linux|2.6.26.5|200809281102
2325916|pass|200809|rick@jrmyers.net ("Rick Myers")|Parse-CPAN-Distributions|0.01|i686-linux|5.8.8|linux|2.6.26.5|200809281042
2325877|cpan|200809|BARBIE|CPAN-WWW-Testers|0.35||0|||200809281637
2325646|pass|200809|rick@jrmyers.net ("Rick Myers")|Data-Phrasebook-Loader-DBI|0.11|i686-linux|5.10.0|linux|2.6.26.5|200809281019
2325554|pass|200809|rick@jrmyers.net ("Rick Myers")|Data-Phrasebook-Loader-Ini|0.10|i686-linux|5.8.8|linux|2.6.26.5|200809281009
2325216|pass|200809|rick@jrmyers.net ("Rick Myers")|Mail-Outlook|0.14|i686-linux|5.10.0|linux|2.6.26.5|200809280933
2325185|fail|200809|rick@jrmyers.net ("Rick Myers")|WWW-Scraper-ISBN-Amazon_Driver|0.13|i686-linux|5.10.0|linux|2.6.26.5|200809280930
2325061|pass|200809|rick@jrmyers.net ("Rick Myers")|Data-Phrasebook-Loader-DBI|0.11|i686-linux|5.8.8|linux|2.6.26.5|200809280919
2324825|pass|200809|rick@jrmyers.net ("Rick Myers")|Test-CPAN-Meta|0.12|i686-linux|5.10.0|linux|2.6.26.5|200809280854
2324668|pass|200809|rick@jrmyers.net ("Rick Myers")|Mail-Outlook|0.14|i686-linux|5.8.8|linux|2.6.26.5|200809280835
2324635|fail|200809|rick@jrmyers.net ("Rick Myers")|WWW-Scraper-ISBN-Amazon_Driver|0.13|i686-linux|5.8.8|linux|2.6.26.5|200809280832
2324573|pass|200809|rick@jrmyers.net ("Rick Myers")|Regexp-Log-Common|0.05|i686-linux|5.10.0|linux|2.6.26.5|200809280827
2324378|pass|200809|rick@jrmyers.net ("Rick Myers")|Test-CPAN-Meta|0.12|i686-linux|5.8.8|linux|2.6.26.5|200809280804
2324083|pass|200809|rick@jrmyers.net ("Rick Myers")|Regexp-Log-Common|0.05|i686-linux|5.8.8|linux|2.6.26.5|200809280739
2323122|pass|200809|rick@jrmyers.net ("Rick Myers")|Games-Trackword|1.06|i686-linux|5.11.0 patch 34383|linux|2.6.26.5|200809280539
2323066|pass|200809|rick@jrmyers.net ("Rick Myers")|Mail-File|0.08|i686-linux|5.11.0 patch 34383|linux|2.6.26.5|200809280525
2322843|pass|200809|rick@jrmyers.net ("Rick Myers")|Calendar-List|0.21|i686-linux|5.11.0 patch 34383|linux|2.6.26.5|200809280434
2322837|pass|200809|rick@jrmyers.net ("Rick Myers")|GD-Chart-Radial|0.07|i686-linux|5.11.0 patch 34383|linux|2.6.26.5|200809280432
2322830|pass|200809|rick@jrmyers.net ("Rick Myers")|WWW-Scraper-ISBN-ORA_Driver|0.09|i686-linux|5.11.0 patch 34383|linux|2.6.26.5|200809280431
2322801|pass|200809|rick@jrmyers.net ("Rick Myers")|WWW-Scraper-ISBN-Pearson_Driver|0.10|i686-linux|5.11.0 patch 34383|linux|2.6.26.5|200809280427
2322514|fail|200809|rick@jrmyers.net ("Rick Myers")|WWW-Scraper-ISBN-Yahoo_Driver|0.07|i686-linux|5.11.0 patch 34383|linux|2.6.26.5|200809280321
2322285|pass|200809|rick@jrmyers.net ("Rick Myers")|WWW-UsePerl-Journal|0.21|i686-linux|5.11.0 patch 34383|linux|2.6.26.5|200809280254
2321723|pass|200809|rick@jrmyers.net ("Rick Myers")|Data-FormValidator-Constraints-Words|0.03|i686-linux|5.11.0 patch 34383|linux|2.6.26.5|200809280139
2321554|pass|200809|rick@jrmyers.net ("Rick Myers")|Parse-CPAN-Distributions|0.01|i686-linux|5.11.0 patch 34383|linux|2.6.26.5|200809280117
2321455|pass|200809|rick@jrmyers.net ("Rick Myers")|Data-Phrasebook-Loader-Ini|0.10|i686-linux|5.11.0 patch 34383|linux|2.6.26.5|200809280100
2321215|pass|200809|rick@jrmyers.net ("Rick Myers")|Data-Phrasebook-Loader-DBI|0.11|i686-linux|5.11.0 patch 34383|linux|2.6.26.5|200809280029
2321104|pass|200809|rick@jrmyers.net ("Rick Myers")|Mail-Outlook|0.14|i686-linux|5.11.0 patch 34383|linux|2.6.26.5|200809280004
2321088|fail|200809|rick@jrmyers.net ("Rick Myers")|WWW-Scraper-ISBN-Amazon_Driver|0.13|i686-linux|5.11.0 patch 34383|linux|2.6.26.5|200809280001
2320930|pass|200809|rick@jrmyers.net ("Rick Myers")|Test-CPAN-Meta|0.12|i686-linux|5.11.0 patch 34383|linux|2.6.26.5|200809280325
2320827|pass|200809|rick@jrmyers.net ("Rick Myers")|Regexp-Log-Common|0.05|i686-linux|5.11.0 patch 34383|linux|2.6.26.5|200809280250
2318193|pass|200809|vpit@cpan.org|CPAN-Testers-WWW-Statistics|0.50|x86_64-linux-thread-multi|5.10.0|linux|2.6.26.3-fuuka.profvince.com|200809272013
2318020|pass|200809|stro@cpan.org|CPAN-Testers-WWW-Statistics|0.50|MSWin32-x86-multi-thread|5.8.8|MSWin32|5.00|200809272055
2317920|pass|200809|dagolden@cpan.org (DAGOLDEN)|CPAN-Testers-WWW-Statistics|0.50|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.1|200809271346
2316164|pass|200809|imacat@mail.imacat.idv.tw|CPAN-Testers-WWW-Statistics|0.50|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.22.10|200809271919
2315731|pass|200809|jeff@zeroclue.com|CPAN-WWW-Testers-Generator|0.25|darwin-2level|5.10.0|darwin|9.2.0|200809261631
2315279|pass|200809|david@cantrell.org.uk|CPAN-Testers-WWW-Statistics|0.50|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200809270420
2315229|pass|200809|david@cantrell.org.uk|CPAN-Testers-WWW-Statistics|0.50|alpha-netbsd|5.10.0|netbsd|2.1.0_stable|200809270910
2315157|pass|200809|david@cantrell.org.uk|CPAN-Testers-WWW-Statistics|0.50|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200809270948
2315129|pass|200809|david@cantrell.org.uk|CPAN-Testers-WWW-Statistics|0.50|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200809270949
2315116|pass|200809|david@cantrell.org.uk|CPAN-Testers-WWW-Statistics|0.50|i686-linux|5.8.8|linux|2.4.27-3-686|200809270947
2312452|pass|200809|dagolden@cpan.org (DAGOLDEN)|CPAN-Testers-WWW-Statistics|0.50|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200809270100
2312163|pass|200809|stro@cpan.org|CPAN-Testers-WWW-Statistics|0.50|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.00|200809270304
2311698|pass|200809|chris@bingosnet.co.uk|CPAN-Testers-WWW-Statistics|0.50|i386-netbsd-thread-multi-64int|5.8.8|netbsd|3.1|200809262331
2311665|pass|200809|chris@bingosnet.co.uk|CPAN-Testers-WWW-Statistics|0.50|i386-netbsd-thread-multi-64int|5.8.7|netbsd|3.1|200809262327
2311647|pass|200809|chris@bingosnet.co.uk|CPAN-Testers-WWW-Statistics|0.50|i386-netbsd-thread-multi-64int|5.8.6|netbsd|3.1|200809262322
2311624|pass|200809|chris@bingosnet.co.uk|CPAN-Testers-WWW-Statistics|0.50|i386-netbsd-thread-multi-64int|5.8.5|netbsd|3.1|200809262316
2311596|pass|200809|chris@bingosnet.co.uk|CPAN-Testers-WWW-Statistics|0.50|i386-netbsd-thread-multi-64int|5.8.4|netbsd|3.1|200809262312
2311583|pass|200809|dagolden@cpan.org (DAGOLDEN)|Test-YAML-Meta|0.11|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.1|200809261807
2311573|pass|200809|chris@bingosnet.co.uk|CPAN-Testers-WWW-Statistics|0.50|i386-netbsd-thread-multi-64int|5.8.3|netbsd|3.1|200809262304
2311546|pass|200809|chris@bingosnet.co.uk|CPAN-Testers-WWW-Statistics|0.50|i386-netbsd-thread-multi-64int|5.8.2|netbsd|3.1|200809262258
2311524|pass|200809|chris@bingosnet.co.uk|CPAN-Testers-WWW-Statistics|0.50|i386-netbsd-thread-multi-64int|5.8.1|netbsd|3.1|200809262254
2311477|pass|200809|chris@bingosnet.co.uk|CPAN-Testers-WWW-Statistics|0.50|i386-netbsd-thread-multi-64int|5.10.0|netbsd|3.1|200809262248
2310946|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.05|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.16.38|200809262113
2310514|pass|200809|srezic@cpan.org|CPAN-Testers-WWW-Statistics|0.50|i386-freebsd|5.8.8 patch 33662|freebsd|6.1-release-p23|200809262115
2310408|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.05|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.16.38|200809262002
2310126|pass|200809|bingos@cpan.org|Parse-CPAN-Distributions|0.05|i686-linux-thread-multi-64int|5.8.8|linux|2.6.26.3-29.fc9.i686|200809261914
2309683|pass|200809|vpit@cpan.org|Mail-Outlook|0.14|x86_64-linux-thread-multi|5.10.0|linux|2.6.26.3-fuuka.profvince.com|200809261852
2309528|pass|200809|martin.evans@easysoft.com|CPAN-Testers-WWW-Statistics|0.49|i686-linux-ld|5.10.0|linux|2.6.24-19-generic|200809261730
2309134|pass|200809|martin.evans@easysoft.com|Mail-Outlook|0.14|i686-linux-ld|5.10.0|linux|2.6.24-19-generic|200809261643
2308805|pass|200809|bingos@cpan.org|Parse-CPAN-Distributions|0.05|i686-linux-thread-multi-64int|5.10.0|linux|2.6.26.3-29.fc9.i686|200809261603
2308749|pass|200809|martin.evans@easysoft.com|Parse-CPAN-Distributions|0.05|i686-linux-ld|5.10.0|linux|2.6.24-19-generic|200809261557
2308060|pass|200809|srezic@cpan.org|CPAN-Testers-WWW-Statistics|0.50|i386-freebsd-64int|5.8.8|freebsd|6.1-release|200809261452
2308057|pass|200809|srezic@cpan.org|CPAN-Testers-WWW-Statistics|0.50|i386-freebsd|5.10.0|freebsd|6.1-release|200809261450
2307990|cpan|200809|BARBIE|CPAN-Testers-WWW-Statistics|0.50||0|||200809261437
2306641|pass|200809|rick@jrmyers.net ("Rick Myers")|Finance-Currency-Convert-XE|0.15|i686-linux|5.10.0|linux|2.6.26.5|200809260422
2305306|pass|200809|rick@jrmyers.net ("Rick Myers")|Finance-Currency-Convert-XE|0.15|i686-linux|5.8.8|linux|2.6.26.5|200809260327
2304285|pass|200809|bingos@cpan.org|Parse-CPAN-Distributions|0.05|i86pc-solaris-thread-multi-64int|5.11.0 patch 34419|solaris|2.10|200809260113
2299794|pass|200809|rick@jrmyers.net ("Rick Myers")|Finance-Currency-Convert-XE|0.15|i686-linux|5.11.0 patch 34383|linux|2.6.26.5|200809250846
2296934|pass|200809|dagolden@cpan.org (DAGOLDEN)|Test-CPAN-Meta|0.12|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200809250157
2296930|pass|200809|dagolden@cpan.org (DAGOLDEN)|WWW-Scraper-ISBN-ORA_Driver|0.09|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200809250157
2296929|pass|200809|dagolden@cpan.org (DAGOLDEN)|WWW-Scraper-ISBN-Pearson_Driver|0.10|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200809250157
2296926|fail|200809|dagolden@cpan.org (DAGOLDEN)|WWW-Scraper-ISBN-Yahoo_Driver|0.07|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200809250156
2296923|fail|200809|dagolden@cpan.org (DAGOLDEN)|WWW-Scraper-ISBN-Amazon_Driver|0.13|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200809250155
2294573|pass|200809|bingos@cpan.org|Parse-CPAN-Distributions|0.05|i86pc-solaris-thread-multi-64int|5.8.8 patch 34415|solaris|2.10|200809250121
2294556|pass|200809|bingos@cpan.org|Parse-CPAN-Distributions|0.04|i86pc-solaris-thread-multi-64int|5.8.8 patch 34415|solaris|2.10|200809250119
2294231|pass|200809|bingos@cpan.org|Parse-CPAN-Distributions|0.05|i86pc-solaris-thread-multi-64int|5.10.0 patch 34413|solaris|2.10|200809250038
2294228|pass|200809|bingos@cpan.org|Parse-CPAN-Distributions|0.04|i86pc-solaris-thread-multi-64int|5.10.0 patch 34413|solaris|2.10|200809250036
2293382|pass|200809|dagolden@cpan.org (DAGOLDEN)|Test-YAML-Meta|0.11|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200809241754
2291953|pass|200809|stro@cpan.org|WWW-Scraper-ISBN-Amazon_Driver|0.12|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.00|200809242129
2291859|pass|200809|stro@cpan.org|WWW-Scraper-ISBN-Pearson_Driver|0.10|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.00|200809242127
2291848|pass|200809|stro@cpan.org|WWW-Scraper-ISBN-Pearson_Driver|0.09|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.00|200809242126
2291402|pass|200809|rick@jrmyers.net ("Rick Myers")|Data-Phrasebook-Loader-YAML|0.09|i686-linux|5.10.0|linux|2.6.26.5|200809241329
2291400|pass|200809|rick@jrmyers.net ("Rick Myers")|Data-Phrasebook|0.29|i686-linux|5.10.0|linux|2.6.26.5|200809241329
2291279|pass|200809|dagolden@cpan.org (DAGOLDEN)|CPAN-WWW-Testers-Generator|0.29|i686-linux-64int-ld|5.10.0|linux|2.6.22-14-386|200809241309
2290685|pass|200809|rick@jrmyers.net ("Rick Myers")|Data-Phrasebook-Loader-YAML|0.09|i686-linux|5.8.8|linux|2.6.26.5|200809241144
2290683|pass|200809|rick@jrmyers.net ("Rick Myers")|Data-Phrasebook|0.29|i686-linux|5.8.8|linux|2.6.26.5|200809241144
2286032|pass|200809|dmdk1@comcast.net|Parse-CPAN-Distributions|0.05|i486-linux-gnu|5.8.8|linux|2.6.15.7|200809240215
2283686|pass|200809|rick@jrmyers.net ("Rick Myers")|Data-Phrasebook-Loader-YAML|0.09|i686-linux|5.11.0 patch 34383|linux|2.6.26.5|200809231619
2283682|pass|200809|rick@jrmyers.net ("Rick Myers")|Data-Phrasebook|0.29|i686-linux|5.11.0 patch 34383|linux|2.6.26.5|200809231619
2282819|pass|200809|dagolden@cpan.org (DAGOLDEN)|Data-Phrasebook-Loader-YAML|0.09|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.1|200809231413
2282818|pass|200809|dagolden@cpan.org (DAGOLDEN)|Data-Phrasebook|0.29|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.1|200809231413
2282790|pass|200809|bingos@cpan.org|Parse-CPAN-Distributions|0.05|i86pc-solaris-thread-multi-64int|5.8.4|solaris|2.10|200809231909
2282756|pass|200809|bingos@cpan.org|Parse-CPAN-Distributions|0.04|i86pc-solaris-thread-multi-64int|5.8.4|solaris|2.10|200809231906
2282732|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.05|i86pc-solaris-thread-multi-64int|5.10.0|solaris|2.10|200809231904
2282696|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.04|i86pc-solaris-thread-multi-64int|5.10.0|solaris|2.10|200809231901
2282597|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.05|i86pc-solaris-thread-multi-64int|5.8.8|solaris|2.10|200809231851
2282568|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.04|i86pc-solaris-thread-multi-64int|5.8.8|solaris|2.10|200809231849
2282119|pass|200809|dagolden@cpan.org (DAGOLDEN)|CPAN-Testers-WWW-Statistics|0.49|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200809231316
2282072|pass|200809|dagolden@cpan.org (DAGOLDEN)|Mail-Outlook|0.14|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200809231312
2282002|pass|200809|dagolden@cpan.org (DAGOLDEN)|CPAN-WWW-Testers-Generator|0.29|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200809231308
2281994|pass|200809|dagolden@cpan.org (DAGOLDEN)|Parse-CPAN-Distributions|0.05|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200809231307
2281935|pass|200809|dagolden@cpan.org (DAGOLDEN)|Parse-CPAN-Distributions|0.05|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.1|200809231303
2281929|pass|200809|dagolden@cpan.org (DAGOLDEN)|CPAN-WWW-Testers-Generator|0.29|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.1|200809231303
2281611|pass|200809|dagolden@cpan.org (DAGOLDEN)|Parse-CPAN-Distributions|0.04|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.1|200809231242
2281389|pass|200809|dagolden@cpan.org (DAGOLDEN)|CPAN-WWW-Testers-Generator|0.28|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.1|200809231227
2281383|pass|200809|dagolden@cpan.org (DAGOLDEN)|CPAN-Testers-WWW-Statistics|0.49|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.1|200809231227
2281221|pass|200809|dagolden@cpan.org (DAGOLDEN)|Mail-Outlook|0.14|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.1|200809231215
2280449|pass|200809|martin.evans@easysoft.com|Test-YAML-Meta|0.11|i686-linux-ld|5.10.0|linux|2.6.24-19-generic|200809231509
2280257|pass|200809|andy@hexten.net|Test-YAML-Meta|0.11|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200809231543
2278975|pass|200809|andy@hexten.net|Finance-Currency-Convert-XE|0.15|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200809231258
2278876|pass|200809|dagolden@cpan.org (DAGOLDEN)|Data-Phrasebook|0.29|i686-linux|5.10.0|linux|2.6.24-16-generic|200809230655
2278843|pass|200809|dagolden@cpan.org (DAGOLDEN)|Test-YAML-Meta|0.11|i686-linux|5.10.0|linux|2.6.24-16-generic|200809230653
2273048|pass|200809|dagolden@cpan.org (DAGOLDEN)|Test-YAML-Meta|0.11|i686-linux|5.10.0|linux|2.6.24-16-generic|200809230153
2271937|pass|200809|dagolden@cpan.org (DAGOLDEN)|Data-Phrasebook|0.29|i686-linux|5.10.0|linux|2.6.24-16-generic|200809230054
2271289|pass|200809|dagolden@cpan.org (DAGOLDEN)|Finance-Currency-Convert-XE|0.15|i686-linux|5.10.0|linux|2.6.24-16-generic|200809230011
2271060|pass|200809|dagolden@cpan.org (DAGOLDEN)|Finance-Currency-Convert-XE|0.15|i686-linux|5.10.0|linux|2.6.24-16-generic|200809230356
2270074|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.05|i86pc-solaris-thread-multi-64int|5.8.4|solaris|2.10|200809222342
2270058|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.04|i86pc-solaris-thread-multi-64int|5.8.4|solaris|2.10|200809222334
2270030|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.03|i86pc-solaris-thread-multi-64int|5.8.4|solaris|2.10|200809222327
2269998|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.02|i86pc-solaris-thread-multi-64int|5.8.4|solaris|2.10|200809222319
2269934|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.05|i86pc-solaris-thread-multi-64int|5.8.8|solaris|2.10|200809222304
2269899|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.04|i86pc-solaris-thread-multi-64int|5.8.8|solaris|2.10|200809222258
2269873|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.03|i86pc-solaris-thread-multi-64int|5.8.8|solaris|2.10|200809222251
2269859|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.02|i86pc-solaris-thread-multi-64int|5.8.8|solaris|2.10|200809222245
2269843|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.05|i86pc-solaris-thread-multi-64int|5.10.0|solaris|2.10|200809222241
2269837|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.04|i86pc-solaris-thread-multi-64int|5.10.0|solaris|2.10|200809222239
2269833|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.03|i86pc-solaris-thread-multi-64int|5.10.0|solaris|2.10|200809222237
2269829|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.02|i86pc-solaris-thread-multi-64int|5.10.0|solaris|2.10|200809222235
2268222|pass|200809|bingos@cpan.org|Parse-CPAN-Distributions|0.05|i386-freebsd-thread-multi-64int|5.8.8 patch 34395|freebsd|7.0-release|200809221432
2268201|pass|200809|bingos@cpan.org|Parse-CPAN-Distributions|0.04|i386-freebsd-thread-multi-64int|5.8.8 patch 34395|freebsd|7.0-release|200809221429
2268180|pass|200809|bingos@cpan.org|Parse-CPAN-Distributions|0.03|i386-freebsd-thread-multi-64int|5.8.8 patch 34395|freebsd|7.0-release|200809221426
2268160|pass|200809|bingos@cpan.org|Parse-CPAN-Distributions|0.02|i386-freebsd-thread-multi-64int|5.8.8 patch 34395|freebsd|7.0-release|200809221423
2267948|pass|200809|bingos@cpan.org|Parse-CPAN-Distributions|0.05|i386-freebsd-thread-multi-64int|5.10.0 patch 34372|freebsd|7.0-release|200809221355
2267934|pass|200809|bingos@cpan.org|Parse-CPAN-Distributions|0.04|i386-freebsd-thread-multi-64int|5.10.0 patch 34372|freebsd|7.0-release|200809221352
2267925|pass|200809|bingos@cpan.org|Parse-CPAN-Distributions|0.03|i386-freebsd-thread-multi-64int|5.10.0 patch 34372|freebsd|7.0-release|200809221349
2267918|pass|200809|bingos@cpan.org|Parse-CPAN-Distributions|0.02|i386-freebsd-thread-multi-64int|5.10.0 patch 34372|freebsd|7.0-release|200809221348
2267507|pass|200809|stro@cpan.org|Parse-CPAN-Distributions|0.05|MSWin32-x86-multi-thread|5.8.8|MSWin32|5.00|200809221043
2267444|pass|200809|vpit@cpan.org|Parse-CPAN-Distributions|0.05|x86_64-linux-thread-multi|5.10.0|linux|2.6.26.3-fuuka.profvince.com|200809221509
2267442|pass|200809|vpit@cpan.org|Parse-CPAN-Distributions|0.04|x86_64-linux-thread-multi|5.10.0|linux|2.6.26.3-fuuka.profvince.com|200809221508
2267441|pass|200809|vpit@cpan.org|Parse-CPAN-Distributions|0.03|x86_64-linux-thread-multi|5.10.0|linux|2.6.26.3-fuuka.profvince.com|200809221508
2267439|pass|200809|vpit@cpan.org|Parse-CPAN-Distributions|0.02|x86_64-linux-thread-multi|5.10.0|linux|2.6.26.3-fuuka.profvince.com|200809221508
2267435|pass|200809|vpit@cpan.org|CPAN-Testers-WWW-Statistics|0.49|x86_64-linux-thread-multi|5.10.0|linux|2.6.26.3-fuuka.profvince.com|200809221506
2267302|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.05|i386-freebsd-64int|5.10.0|freebsd|7.0-release|200809221220
2267295|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.04|i386-freebsd-64int|5.10.0|freebsd|7.0-release|200809221219
2267289|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.03|i386-freebsd-64int|5.10.0|freebsd|7.0-release|200809221218
2267284|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.02|i386-freebsd-64int|5.10.0|freebsd|7.0-release|200809221217
2267140|pass|200809|chris@bingosnet.co.uk|CPAN-Testers-WWW-Statistics|0.49|i386-freebsd-64int|5.10.0|freebsd|7.0-release|200809221157
2267134|pass|200809|frank.wiegand@gmail.com ("Frank Wiegand")|Parse-CPAN-Distributions|0.05|i686-linux|5.11.0 patch 34384|linux|2.6.24-21-generic|200809221419
2266757|pass|200809|stro@cpan.org|Parse-CPAN-Distributions|0.03|MSWin32-x86-multi-thread|5.8.8|MSWin32|5.00|200809221028
2266596|pass|200809|stro@cpan.org|Parse-CPAN-Distributions|0.04|MSWin32-x86-multi-thread|5.8.8|MSWin32|5.00|200809221035
2266595|pass|200809|stro@cpan.org|Parse-CPAN-Distributions|0.01|MSWin32-x86-multi-thread|5.8.8|MSWin32|5.00|200809221020
2266272|pass|200809|vpit@cpan.org|CPAN-WWW-Testers-Generator|0.29|i686-linux-thread-multi|5.10.0|linux|2.6.18.3-tmb-desktop-2mdvsmp|200809221151
2266266|pass|200809|vpit@cpan.org|Parse-CPAN-Distributions|0.05|i686-linux-thread-multi|5.10.0|linux|2.6.18.3-tmb-desktop-2mdvsmp|200809221150
2262879|pass|200809|srezic@cpan.org|CPAN-WWW-Testers-Generator|0.29|i386-freebsd-thread-multi|5.8.8|freebsd|6.1-release|200809212116
2262844|pass|200809|srezic@cpan.org|Parse-CPAN-Distributions|0.05|i386-freebsd-thread-multi|5.8.8|freebsd|6.1-release|200809212114
2260545|pass|200809|david@cantrell.org.uk|CPAN-WWW-Testers-Generator|0.29|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200809211506
2260513|pass|200809|david@cantrell.org.uk|Parse-CPAN-Distributions|0.05|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200809211502
2260338|pass|200809|david@cantrell.org.uk|CPAN-WWW-Testers-Generator|0.29|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200809210833
2260293|pass|200809|david@cantrell.org.uk|Parse-CPAN-Distributions|0.05|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200809210826
2260202|pass|200809|david@cantrell.org.uk|CPAN-WWW-Testers-Generator|0.29|alpha-netbsd|5.10.0|netbsd|2.1.0_stable|200809211311
2260151|pass|200809|david@cantrell.org.uk|Parse-CPAN-Distributions|0.05|alpha-netbsd|5.10.0|netbsd|2.1.0_stable|200809211302
2259964|pass|200809|david@cantrell.org.uk|CPAN-WWW-Testers-Generator|0.29|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200809211340
2259922|pass|200809|david@cantrell.org.uk|Parse-CPAN-Distributions|0.05|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200809211336
2259820|pass|200809|david@cantrell.org.uk|CPAN-WWW-Testers-Generator|0.29|IP35-irix-64int|5.8.8|irix|6.5|200809211421
2259722|pass|200809|david@cantrell.org.uk|Parse-CPAN-Distributions|0.05|IP35-irix-64int|5.8.8|irix|6.5|200809211418
2259674|pass|200809|david@cantrell.org.uk|CPAN-WWW-Testers-Generator|0.29|i686-linux|5.8.8|linux|2.4.27-3-686|200809211316
2259649|pass|200809|david@cantrell.org.uk|Parse-CPAN-Distributions|0.05|i686-linux|5.8.8|linux|2.4.27-3-686|200809211312
2259630|pass|200809|david@cantrell.org.uk|Parse-CPAN-Distributions|0.05|i686-linux|5.6.2|linux|2.4.27-3-686|200809211310
2259534|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.05|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0|200809211258
2259518|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.04|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0|200809211256
2259512|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.05|i386-netbsd-thread-multi-64int|5.8.8|netbsd|4.0|200809211255
2259504|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.03|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0|200809211254
2259503|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.04|i386-netbsd-thread-multi-64int|5.8.8|netbsd|4.0|200809211254
2259464|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.03|i386-netbsd-thread-multi-64int|5.8.8|netbsd|4.0|200809211253
2259430|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.02|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0|200809211252
2259408|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.02|i386-netbsd-thread-multi-64int|5.8.8|netbsd|4.0|200809211251
2259108|pass|200809|chris@bingosnet.co.uk|CPAN-Testers-WWW-Statistics|0.49|i386-netbsd-thread-multi-64int|5.8.8|netbsd|4.0|200809211232
2259105|pass|200809|chris@bingosnet.co.uk|CPAN-Testers-WWW-Statistics|0.49|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0|200809211231
2258892|pass|200809|shlomif@cpan.org|Parse-CPAN-Distributions|0.05|i686-linux|5.10.0|linux|2.6.27-desktop-0.rc6.3.2mnb|200809211338
2258388|pass|200809|srezic@cpan.org|CPAN-WWW-Testers-Generator|0.29|i386-freebsd-thread-multi|5.10.0|freebsd|6.1-release|200809211018
2258018|pass|200809|rick@jrmyers.net ("Rick Myers")|Test-YAML-Meta|0.11|i686-linux|5.8.8|linux|2.6.26.5|200809210339
2257851|pass|200809|srezic@cpan.org|Parse-CPAN-Distributions|0.05|i386-freebsd-thread-multi|5.10.0|freebsd|6.1-release|200809210909
2257645|pass|200809|rick@jrmyers.net ("Rick Myers")|Test-YAML-Meta|0.11|i686-linux|5.11.0 patch 34383|linux|2.6.26.5|200809210233
2257543|pass|200809|rick@jrmyers.net ("Rick Myers")|Test-YAML-Meta|0.11|i686-linux|5.10.0|linux|2.6.26.5|200809210213
2256782|pass|200809|chris@bingosnet.co.uk|CPAN-WWW-Testers-Generator|0.29|i386-netbsd-thread-multi-64int|5.8.8|netbsd|3.1|200809210225
2256508|pass|200809|rick@jrmyers.net ("Rick Myers")|Parse-CPAN-Distributions|0.05|i686-linux|5.8.8|linux|2.6.26.5|200809210002
2256472|pass|200809|stro@cpan.org|Parse-CPAN-Distributions|0.05|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.00|200809210250
2256457|pass|200809|stro@cpan.org|Parse-CPAN-Distributions|0.04|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.00|200809210244
2256431|pass|200809|stro@cpan.org|Parse-CPAN-Distributions|0.03|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.00|200809210236
2256414|pass|200809|stro@cpan.org|Parse-CPAN-Distributions|0.01|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.00|200809210230
2256355|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.05|i386-netbsd-thread-multi-64int|5.8.8|netbsd|3.1|200809210013
2256353|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.05|i386-netbsd-thread-multi-64int|5.8.7|netbsd|3.1|200809210012
2256351|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.05|i386-netbsd-thread-multi-64int|5.8.6|netbsd|3.1|200809210011
2256348|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.05|i386-netbsd-thread-multi-64int|5.8.5|netbsd|3.1|200809210010
2256340|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.05|i386-netbsd-thread-multi-64int|5.8.4|netbsd|3.1|200809210009
2256334|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.05|i386-netbsd-thread-multi-64int|5.8.3|netbsd|3.1|200809210008
2256329|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.05|i386-netbsd-thread-multi-64int|5.8.2|netbsd|3.1|200809210006
2256323|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.05|i386-netbsd-thread-multi-64int|5.8.1|netbsd|3.1|200809210005
2256318|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.05|i386-netbsd-thread-multi-64int|5.6.2|netbsd|3.1|200809210004
2256313|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.05|i386-netbsd-thread-multi-64int|5.10.0|netbsd|3.1|200809210003
2256304|pass|200809|rick@jrmyers.net ("Rick Myers")|Parse-CPAN-Distributions|0.05|i686-linux|5.10.0|linux|2.6.26.5|200809201902
2256268|pass|200809|rick@jrmyers.net ("Rick Myers")|Parse-CPAN-Distributions|0.05|i686-linux|5.11.0 patch 34383|linux|2.6.26.5|200809201849
2255287|pass|200809|srezic@cpan.org|CPAN-WWW-Testers-Generator|0.29|i386-freebsd|5.6.2|freebsd|6.1-release|200809202039
2255256|pass|200809|taro-nishino@wine.ocn.ne.jp ("Taro Nishino")|Test-YAML-Meta|0.11|MSWin32-x86-multi-thread|5.8.8|MSWin32|5.0|200809210316
2255194|pass|200809|srezic@cpan.org|Parse-CPAN-Distributions|0.05|i386-freebsd|5.6.2|freebsd|6.1-release|200809201943
2254964|pass|200809|srezic@cpan.org|CPAN-WWW-Testers-Generator|0.29|i386-freebsd-64int|5.8.8|freebsd|6.1-release|200809201739
2254836|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.05|OpenBSD.i386-openbsd-thread-multi-64int|5.10.0|openbsd|4.3|200809201602
2254822|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.04|OpenBSD.i386-openbsd-thread-multi-64int|5.10.0|openbsd|4.3|200809201558
2254808|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.03|OpenBSD.i386-openbsd-thread-multi-64int|5.10.0|openbsd|4.3|200809201554
2254792|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.02|OpenBSD.i386-openbsd-thread-multi-64int|5.10.0|openbsd|4.3|200809201550
2254520|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.05|OpenBSD.i386-openbsd-thread-multi-64int|5.10.0|openbsd|4.2|200809201403
2254508|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.04|OpenBSD.i386-openbsd-thread-multi-64int|5.10.0|openbsd|4.2|200809201359
2254498|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.03|OpenBSD.i386-openbsd-thread-multi-64int|5.10.0|openbsd|4.2|200809201356
2254492|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.02|OpenBSD.i386-openbsd-thread-multi-64int|5.10.0|openbsd|4.2|200809201354
2254470|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.05|OpenBSD.i386-openbsd-thread-multi-64int|5.8.8|openbsd|4.2|200809201350
2254452|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.04|OpenBSD.i386-openbsd-thread-multi-64int|5.8.8|openbsd|4.2|200809201348
2254439|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.03|OpenBSD.i386-openbsd-thread-multi-64int|5.8.8|openbsd|4.2|200809201345
2254428|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.02|OpenBSD.i386-openbsd-thread-multi-64int|5.8.8|openbsd|4.2|200809201343
2254256|pass|200809|stro@cpan.org|CPAN-WWW-Testers-Generator|0.29|MSWin32-x86-multi-thread|5.8.8|MSWin32|5.00|200809201438
2254249|pass|200809|rick@jrmyers.net ("Rick Myers")|Parse-CPAN-Distributions|0.05|i686-linux|5.10.0|linux|2.6.24.3|200809200733
2254078|pass|200809|rick@jrmyers.net ("Rick Myers")|Parse-CPAN-Distributions|0.05|i686-linux|5.11.0 patch 34379|linux|2.6.24.3|200809200627
2253895|pass|200809|shlomif@cpan.org|Parse-CPAN-Distributions|0.04|i686-linux|5.10.0|linux|2.6.27-desktop-0.rc6.3.2mnb|200809201247
2253889|pass|200809|shlomif@cpan.org|CPAN-WWW-Testers-Generator|0.28|i686-linux|5.10.0|linux|2.6.27-desktop-0.rc6.3.2mnb|200809201247
2253743|pass|200809|rick@jrmyers.net ("Rick Myers")|Parse-CPAN-Distributions|0.05|i686-linux|5.8.8|linux|2.6.24.3|200809200511
2253631|pass|200809|chris@bingosnet.co.uk|Mail-Outlook|0.14|i386-netbsd-thread-multi-64int|5.8.8|netbsd|3.1|200809200915
2253605|pass|200809|srezic@cpan.org|Parse-CPAN-Distributions|0.05|i386-freebsd-64int|5.8.8|freebsd|6.1-release|200809200925
2251195|pass|200809|chris@bingosnet.co.uk|CPAN-Testers-WWW-Statistics|0.49|i386-netbsd-thread-multi-64int|5.8.8|netbsd|3.1|200809192245
2251164|pass|200809|chris@bingosnet.co.uk|CPAN-Testers-WWW-Statistics|0.49|i386-netbsd-thread-multi-64int|5.8.7|netbsd|3.1|200809192241
2251123|pass|200809|chris@bingosnet.co.uk|CPAN-Testers-WWW-Statistics|0.49|i386-netbsd-thread-multi-64int|5.8.6|netbsd|3.1|200809192237
2251089|pass|200809|chris@bingosnet.co.uk|CPAN-Testers-WWW-Statistics|0.49|i386-netbsd-thread-multi-64int|5.8.5|netbsd|3.1|200809192231
2251040|pass|200809|chris@bingosnet.co.uk|CPAN-Testers-WWW-Statistics|0.49|i386-netbsd-thread-multi-64int|5.8.4|netbsd|3.1|200809192227
2251037|pass|200809|stro@cpan.org|Parse-CPAN-Distributions|0.04|i686-linux|5.10.0|linux|2.4.27-2-386|200809200026
2250993|pass|200809|chris@bingosnet.co.uk|CPAN-Testers-WWW-Statistics|0.49|i386-netbsd-thread-multi-64int|5.8.3|netbsd|3.1|200809192222
2250943|pass|200809|srezic@cpan.org|CPAN-WWW-Testers-Generator|0.29|i386-freebsd|5.10.0|freebsd|6.1-release|200809192316
2250936|pass|200809|chris@bingosnet.co.uk|CPAN-Testers-WWW-Statistics|0.49|i386-netbsd-thread-multi-64int|5.8.2|netbsd|3.1|200809192217
2250857|pass|200809|chris@bingosnet.co.uk|CPAN-Testers-WWW-Statistics|0.49|i386-netbsd-thread-multi-64int|5.8.1|netbsd|3.1|200809192212
2250706|pass|200809|chris@bingosnet.co.uk|CPAN-Testers-WWW-Statistics|0.49|i386-netbsd-thread-multi-64int|5.10.0|netbsd|3.1|200809192206
2250580|pass|200809|srezic@cpan.org|Parse-CPAN-Distributions|0.05|i386-freebsd|5.10.0|freebsd|6.1-release|200809192258
2250532|pass|200809|chris@bingosnet.co.uk|CPAN-WWW-Testers-Generator|0.28|i386-netbsd-thread-multi-64int|5.8.8|netbsd|3.1|200809192200
2250508|pass|200809|srezic@cpan.org|WWW-UsePerl-Journal|0.21|i386-freebsd|5.8.8 patch 34313|freebsd|6.1-release-p23|200809192114
2250478|pass|200809|stro@cpan.org|CPAN-WWW-Testers-Generator|0.28|i686-linux|5.10.0|linux|2.4.27-2-386|200809191816
2250467|pass|200809|stro@cpan.org|CPAN-Testers-WWW-Statistics|0.49|i686-linux|5.10.0|linux|2.4.27-2-386|200809191815
2250123|pass|200809|srezic@cpan.org|CPAN-WWW-Testers-Generator|0.29|i386-freebsd|5.8.8 patch 33662|freebsd|6.1-release-p23|200809191607
2249729|pass|200809|srezic@cpan.org|CPAN-WWW-Testers-Generator|0.27|i386-freebsd|5.8.8 patch 34313|freebsd|6.1-release-p23|200809192111
2249454|pass|200809|srezic@cpan.org|Parse-CPAN-Distributions|0.04|i386-freebsd-64int|5.8.8|freebsd|6.1-release|200809190854
2249269|pass|200809|srezic@cpan.org|Parse-CPAN-Distributions|0.04|i386-freebsd-thread-multi|5.8.8|freebsd|6.1-release|200809192149
2249241|pass|200809|imacat@mail.imacat.idv.tw|Parse-CPAN-Distributions|0.05|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.22.10|200809200345
2249239|pass|200809|imacat@mail.imacat.idv.tw|Mail-Outlook|0.14|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.22.10|200809200345
2249227|pass|200809|imacat@mail.imacat.idv.tw|CPAN-Testers-WWW-Statistics|0.49|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.22.10|200809200343
2248611|pass|200809|srezic@cpan.org|Mail-Outlook|0.14|i386-freebsd-thread-multi|5.8.8|freebsd|6.1-release|200809191650
2248553|pass|200809|srezic@cpan.org|CPAN-WWW-Testers-Generator|0.28|i386-freebsd|5.6.2|freebsd|6.1-release|200809190953
2248541|pass|200809|srezic@cpan.org|Parse-CPAN-Distributions|0.04|i386-freebsd|5.6.2|freebsd|6.1-release|200809191200
2248525|pass|200809|srezic@cpan.org|CPAN-Testers-WWW-Statistics|0.49|i386-freebsd-thread-multi|5.10.0|freebsd|6.1-release|200809191319
2248522|pass|200809|srezic@cpan.org|CPAN-WWW-Testers-Generator|0.28|i386-freebsd-thread-multi|5.10.0|freebsd|6.1-release|200809191320
2248503|pass|200809|srezic@cpan.org|Parse-CPAN-Distributions|0.05|i386-freebsd|5.8.8 patch 33662|freebsd|6.1-release-p23|200809191340
2248502|pass|200809|srezic@cpan.org|Mail-Outlook|0.14|i386-freebsd-thread-multi|5.10.0|freebsd|6.1-release|200809191215
2248485|pass|200809|srezic@cpan.org|Mail-Outlook|0.14|i386-freebsd|5.6.2|freebsd|6.1-release|200809190855
2248444|pass|200809|srezic@cpan.org|Parse-CPAN-Distributions|0.04|i386-freebsd-thread-multi|5.10.0|freebsd|6.1-release|200809191634
2248047|pass|200809|vpit@cpan.org|Parse-CPAN-Distributions|0.01|x86_64-linux-thread-multi|5.10.0|linux|2.6.26.3-fuuka.profvince.com|200809192007
2247924|pass|200809|rick@jrmyers.net ("Rick Myers")|Mail-Outlook|0.14|i686-linux|5.8.8|linux|2.6.24.3|200809191339
2247883|pass|200809|rick@jrmyers.net ("Rick Myers")|Mail-Outlook|0.14|i686-linux|5.10.0|linux|2.6.24.3|200809191333
2247547|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.05|darwin-thread-multi-64int-2level|5.8.8|darwin|8.10.0|200809191709
2247537|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.05|darwin-thread-multi-64int-2level|5.8.6|darwin|8.10.0|200809191706
2247524|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.05|darwin-thread-multi-64int|5.6.2|darwin|8.10.0|200809191700
2247520|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.05|darwin-thread-multi-64int-2level|5.10.0|darwin|8.10.0|200809191658
2247274|pass|200809|stro@cpan.org|CPAN-WWW-Testers-Generator|0.29|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.00|200809191756
2246985|cpan|200809|BARBIE|CPAN-WWW-Testers|0.34||0|||200809191518
2246896|pass|200809|bingos@cpan.org|Parse-CPAN-Distributions|0.04|i386-dragonfly-thread-multi-64int|5.10.0 patch 34372|dragonfly|2.0.0-release|200809191425
2246869|pass|200809|bingos@cpan.org|Parse-CPAN-Distributions|0.03|i386-dragonfly-thread-multi-64int|5.10.0 patch 34372|dragonfly|2.0.0-release|200809191421
2246852|pass|200809|bingos@cpan.org|Parse-CPAN-Distributions|0.02|i386-dragonfly-thread-multi-64int|5.10.0 patch 34372|dragonfly|2.0.0-release|200809191416
2246835|pass|200809|bingos@cpan.org|Parse-CPAN-Distributions|0.01|i386-dragonfly-thread-multi-64int|5.10.0 patch 34372|dragonfly|2.0.0-release|200809191413
2246501|pass|200809|rick@jrmyers.net ("Rick Myers")|Test-YAML-Meta|0.11|i686-linux|5.11.0 patch 34379|linux|2.6.24.3|200809190748
2245811|pass|200809|david@cantrell.org.uk|Mail-Outlook|0.14|i686-linux|5.6.2|linux|2.4.27-3-686|200809191141
2245699|pass|200809|david@cantrell.org.uk|Mail-Outlook|0.14|alpha-netbsd|5.10.0|netbsd|2.1.0_stable|200809191023
2245695|pass|200809|david@cantrell.org.uk|CPAN-WWW-Testers-Generator|0.28|alpha-netbsd|5.10.0|netbsd|2.1.0_stable|200809191022
2245677|pass|200809|david@cantrell.org.uk|CPAN-Testers-WWW-Statistics|0.49|alpha-netbsd|5.10.0|netbsd|2.1.0_stable|200809191020
2245653|pass|200809|david@cantrell.org.uk|Mail-Outlook|0.14|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200809190518
2245644|pass|200809|david@cantrell.org.uk|CPAN-WWW-Testers-Generator|0.28|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200809190518
2245631|pass|200809|david@cantrell.org.uk|CPAN-Testers-WWW-Statistics|0.49|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200809190516
2245625|pass|200809|david@cantrell.org.uk|Mail-Outlook|0.14|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200809191112
2245622|pass|200809|david@cantrell.org.uk|CPAN-WWW-Testers-Generator|0.28|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200809191111
2245613|pass|200809|david@cantrell.org.uk|CPAN-Testers-WWW-Statistics|0.49|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200809191110
2245580|pass|200809|david@cantrell.org.uk|Mail-Outlook|0.14|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200809191107
2245579|pass|200809|david@cantrell.org.uk|CPAN-WWW-Testers-Generator|0.28|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200809191107
2245573|pass|200809|david@cantrell.org.uk|CPAN-Testers-WWW-Statistics|0.49|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200809191106
2245560|pass|200809|david@cantrell.org.uk|Mail-Outlook|0.14|IP35-irix-64int|5.8.8|irix|6.5|200809191205
2245550|pass|200809|david@cantrell.org.uk|CPAN-WWW-Testers-Generator|0.28|IP35-irix-64int|5.8.8|irix|6.5|200809191204
2245547|pass|200809|david@cantrell.org.uk|Mail-Outlook|0.14|i686-linux|5.8.8|linux|2.4.27-3-686|200809191103
2245544|pass|200809|david@cantrell.org.uk|CPAN-WWW-Testers-Generator|0.28|i686-linux|5.8.8|linux|2.4.27-3-686|200809191103
2245538|pass|200809|david@cantrell.org.uk|CPAN-Testers-WWW-Statistics|0.49|i686-linux|5.8.8|linux|2.4.27-3-686|200809191102
2245437|cpan|200809|BARBIE|CPAN-WWW-Testers-Generator|0.29||0|||200809191150
2245222|pass|200809|bingos@cpan.org|Parse-CPAN-Distributions|0.04|i686-linux-thread-multi-64int-ld|5.11.0 patch 34379|linux|2.6.21.5-smp|200809191005
2245212|pass|200809|bingos@cpan.org|Parse-CPAN-Distributions|0.03|i686-linux-thread-multi-64int-ld|5.11.0 patch 34379|linux|2.6.21.5-smp|200809191003
2245203|pass|200809|bingos@cpan.org|Parse-CPAN-Distributions|0.02|i686-linux-thread-multi-64int-ld|5.11.0 patch 34379|linux|2.6.21.5-smp|200809191000
2245187|pass|200809|bingos@cpan.org|Parse-CPAN-Distributions|0.01|i686-linux-thread-multi-64int-ld|5.11.0 patch 34379|linux|2.6.21.5-smp|200809190958
2245094|cpan|200809|BARBIE|Parse-CPAN-Distributions|0.05||0|||200809191048
2244332|pass|200809|rick@jrmyers.net ("Rick Myers")|Mail-Outlook|0.14|i686-linux|5.11.0 patch 34379|linux|2.6.24.3|200809190249
2243892|pass|200809|stro@cpan.org|CPAN-WWW-Testers-Generator|0.28|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.00|200809190646
2243887|pass|200809|stro@cpan.org|CPAN-Testers-WWW-Statistics|0.49|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.00|200809190642
2243525|pass|200809|stro@cpan.org|CPAN-WWW-Testers-Generator|0.28|MSWin32-x86-multi-thread|5.8.8|MSWin32|5.00|200809190403
2243511|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.04|i386-netbsd-thread-multi-64int|5.8.8|netbsd|3.1|200809190157
2243507|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.04|i386-netbsd-thread-multi-64int|5.8.7|netbsd|3.1|200809190156
2243505|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.04|i386-netbsd-thread-multi-64int|5.8.6|netbsd|3.1|200809190155
2243499|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.04|i386-netbsd-thread-multi-64int|5.8.5|netbsd|3.1|200809190154
2243495|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.04|i386-netbsd-thread-multi-64int|5.8.4|netbsd|3.1|200809190153
2243492|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.04|i386-netbsd-thread-multi-64int|5.8.3|netbsd|3.1|200809190152
2243489|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.04|i386-netbsd-thread-multi-64int|5.8.2|netbsd|3.1|200809190151
2243487|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.04|i386-netbsd-thread-multi-64int|5.8.1|netbsd|3.1|200809190149
2243481|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.04|i386-netbsd-thread-multi-64int|5.10.0|netbsd|3.1|200809190147
2243477|pass|200809|stro@cpan.org|CPAN-Testers-WWW-Statistics|0.49|MSWin32-x86-multi-thread|5.8.8|MSWin32|5.00|200809190347
2243038|pass|200809|bingos@cpan.org|Parse-CPAN-Distributions|0.04|i386-dragonfly-thread-multi-64int|5.8.8 patch 34376|dragonfly|2.0.0-release|200809182332
2243027|pass|200809|bingos@cpan.org|Parse-CPAN-Distributions|0.03|i386-dragonfly-thread-multi-64int|5.8.8 patch 34376|dragonfly|2.0.0-release|200809182329
2243011|pass|200809|bingos@cpan.org|Parse-CPAN-Distributions|0.02|i386-dragonfly-thread-multi-64int|5.8.8 patch 34376|dragonfly|2.0.0-release|200809182326
2242999|pass|200809|bingos@cpan.org|Parse-CPAN-Distributions|0.01|i386-dragonfly-thread-multi-64int|5.8.8 patch 34376|dragonfly|2.0.0-release|200809182324
2242978|pass|200809|taro-nishino@wine.ocn.ne.jp ("Taro Nishino")|Mail-Outlook|0.14|MSWin32-x86-multi-thread|5.8.8|MSWin32|5.0|200809190643
2242964|pass|200809|srezic@cpan.org|CPAN-WWW-Testers-Generator|0.28|i386-freebsd-64int|5.8.8|freebsd|6.1-release|200809182334
2242963|pass|200809|srezic@cpan.org|CPAN-Testers-WWW-Statistics|0.49|i386-freebsd-64int|5.8.8|freebsd|6.1-release|200809182334
2242925|pass|200809|srezic@cpan.org|Mail-Outlook|0.14|i386-freebsd-64int|5.8.8|freebsd|6.1-release|200809182324
2242924|pass|200809|srezic@cpan.org|Parse-CPAN-Distributions|0.04|i386-freebsd|5.10.0|freebsd|6.1-release|200809182323
2242827|pass|200809|srezic@cpan.org|Mail-Outlook|0.14|i386-freebsd|5.8.8 patch 33662|freebsd|6.1-release-p23|200809182301
2242473|pass|200809|srezic@cpan.org|CPAN-WWW-Testers-Generator|0.28|i386-freebsd|5.10.0|freebsd|6.1-release|200809182100
2242472|pass|200809|srezic@cpan.org|CPAN-Testers-WWW-Statistics|0.49|i386-freebsd|5.10.0|freebsd|6.1-release|200809182059
2242465|pass|200809|srezic@cpan.org|CPAN-WWW-Testers-Generator|0.28|i386-freebsd|5.8.8 patch 33662|freebsd|6.1-release-p23|200809182057
2242464|pass|200809|srezic@cpan.org|CPAN-Testers-WWW-Statistics|0.49|i386-freebsd|5.8.8 patch 33662|freebsd|6.1-release-p23|200809182057
2242338|pass|200809|dmdk1@comcast.net|Parse-CPAN-Distributions|0.04|i486-linux-gnu|5.8.8|linux|2.6.15.7|200809181415
2242174|pass|200809|srezic@cpan.org|Mail-Outlook|0.14|i386-freebsd|5.10.0|freebsd|6.1-release|200809181913
2242134|cpan|200809|BARBIE|Mail-Outlook|0.14||0|||200809181859
2242111|pass|200809|rick@jrmyers.net ("Rick Myers")|Parse-CPAN-Distributions|0.04|i686-linux|5.8.8|linux|2.6.24.3|200809181249
2241588|cpan|200809|BARBIE|CPAN-Testers-WWW-Statistics|0.49||0|||200809181548
2241584|cpan|200809|BARBIE|CPAN-WWW-Testers-Generator|0.28||0|||200809181547
2241281|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.04|i386-dragonfly-thread-multi-64int|5.8.8|dragonfly|2.0.0-release|200809181302
2241273|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.03|i386-dragonfly-thread-multi-64int|5.8.8|dragonfly|2.0.0-release|200809181259
2241263|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.02|i386-dragonfly-thread-multi-64int|5.8.8|dragonfly|2.0.0-release|200809181257
2241247|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.01|i386-dragonfly-thread-multi-64int|5.8.8|dragonfly|2.0.0-release|200809181254
2241093|pass|200809|david@cantrell.org.uk|Parse-CPAN-Distributions|0.04|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200809181124
2241084|pass|200809|david@cantrell.org.uk|Parse-CPAN-Distributions|0.04|IP35-irix-64int|5.8.8|irix|6.5|200809181237
2241078|pass|200809|david@cantrell.org.uk|Parse-CPAN-Distributions|0.04|alpha-netbsd|5.10.0|netbsd|2.1.0_stable|200809181035
2241076|pass|200809|david@cantrell.org.uk|Parse-CPAN-Distributions|0.04|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200809180534
2241074|pass|200809|david@cantrell.org.uk|Parse-CPAN-Distributions|0.04|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200809181133
2241072|pass|200809|david@cantrell.org.uk|Parse-CPAN-Distributions|0.04|i686-linux|5.8.8|linux|2.4.27-3-686|200809181133
2240564|pass|200809|david@cantrell.org.uk|Parse-CPAN-Distributions|0.04|i686-linux|5.6.2|linux|2.4.27-3-686|200809180910
2240552|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.04|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.21.5-smp|200809180907
2240541|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.03|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.21.5-smp|200809180904
2240540|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.04|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.21.5-smp|200809180904
2240532|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.02|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.21.5-smp|200809180901
2240527|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.03|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.21.5-smp|200809180859
2240524|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.01|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.21.5-smp|200809180859
2240519|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.02|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.21.5-smp|200809180857
2240506|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.01|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.21.5-smp|200809180855
2240431|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.04|i386-dragonfly-thread-multi-64int|5.10.0|dragonfly|2.0.0-release|200809180907
2240428|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.03|i386-dragonfly-thread-multi-64int|5.10.0|dragonfly|2.0.0-release|200809180906
2240424|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.02|i386-dragonfly-thread-multi-64int|5.10.0|dragonfly|2.0.0-release|200809180905
2240421|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.01|i386-dragonfly-thread-multi-64int|5.10.0|dragonfly|2.0.0-release|200809180904
2239785|pass|200809|rick@jrmyers.net ("Rick Myers")|Parse-CPAN-Distributions|0.03|i686-linux|5.8.8|linux|2.6.24.3|200809180038
2238583|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.04|darwin-thread-multi-64int-2level|5.8.8|darwin|8.10.0|200809180202
2238556|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.04|darwin-thread-multi-64int-2level|5.8.6|darwin|8.10.0|200809180158
2238543|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.04|darwin-thread-multi-64int|5.6.2|darwin|8.10.0|200809180155
2238525|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.04|darwin-thread-multi-64int-2level|5.10.0|darwin|8.10.0|200809180153
2235646|pass|200809|stro@cpan.org|CPAN-WWW-Testers-Generator|0.27|MSWin32-x86-multi-thread|5.8.8|MSWin32|5.00|200809172012
2235641|pass|200809|stro@cpan.org|CPAN-WWW-Testers-Generator|0.26|MSWin32-x86-multi-thread|5.8.8|MSWin32|5.00|200809172012
2235639|pass|200809|stro@cpan.org|CPAN-WWW-Testers-Generator|0.25|MSWin32-x86-multi-thread|5.8.8|MSWin32|5.00|200809172011
2235539|pass|200809|stro@cpan.org|CPAN-WWW-Testers-Generator|0.27|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.00|200809171955
2235534|pass|200809|stro@cpan.org|CPAN-WWW-Testers-Generator|0.26|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.00|200809171955
2235528|pass|200809|stro@cpan.org|CPAN-WWW-Testers-Generator|0.25|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.00|200809171953
2235092|pass|200809|bingos@cpan.org|Parse-CPAN-Distributions|0.03|i386-freebsd-thread-multi-64int|5.8.8 patch 34376|freebsd|6.2-release|200809171039
2235086|pass|200809|bingos@cpan.org|Parse-CPAN-Distributions|0.02|i386-freebsd-thread-multi-64int|5.8.8 patch 34376|freebsd|6.2-release|200809171038
2235077|pass|200809|bingos@cpan.org|Parse-CPAN-Distributions|0.01|i386-freebsd-thread-multi-64int|5.8.8 patch 34376|freebsd|6.2-release|200809171037
2234467|pass|200809|bingos@cpan.org|Parse-CPAN-Distributions|0.03|i686-linux-thread-multi-64int-ld|5.11.0 patch 34378|linux|2.6.24-19-generic|200809171345
2234443|pass|200809|bingos@cpan.org|Parse-CPAN-Distributions|0.02|i686-linux-thread-multi-64int-ld|5.11.0 patch 34378|linux|2.6.24-19-generic|200809171338
2234437|pass|200809|bingos@cpan.org|Parse-CPAN-Distributions|0.01|i686-linux-thread-multi-64int-ld|5.11.0 patch 34378|linux|2.6.24-19-generic|200809171335
2234136|pass|200809|srezic@cpan.org|Parse-CPAN-Distributions|0.04|i386-freebsd|5.8.8 patch 33662|freebsd|6.1-release-p23|200809171302
2233790|pass|200809|bingos@cpan.org|Parse-CPAN-Distributions|0.03|i686-linux-thread-multi-64int-ld|5.8.8 patch 34376|linux|2.6.24-19-generic|200809171029
2233781|pass|200809|bingos@cpan.org|Parse-CPAN-Distributions|0.02|i686-linux-thread-multi-64int-ld|5.8.8 patch 34376|linux|2.6.24-19-generic|200809171027
2233768|pass|200809|bingos@cpan.org|Parse-CPAN-Distributions|0.01|i686-linux-thread-multi-64int-ld|5.8.8 patch 34376|linux|2.6.24-19-generic|200809171026
2233641|cpan|200809|BARBIE|Parse-CPAN-Distributions|0.04||0|||200809171102
2233502|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.03|i386-netbsd-thread-multi-64int|5.8.8|netbsd|3.1|200809170925
2233501|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.03|i386-netbsd-thread-multi-64int|5.8.7|netbsd|3.1|200809170924
2233500|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.03|i386-netbsd-thread-multi-64int|5.8.6|netbsd|3.1|200809170924
2233499|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.03|i386-netbsd-thread-multi-64int|5.8.5|netbsd|3.1|200809170923
2233498|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.03|i386-netbsd-thread-multi-64int|5.8.4|netbsd|3.1|200809170922
2233497|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.03|i386-netbsd-thread-multi-64int|5.8.3|netbsd|3.1|200809170922
2233496|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.03|i386-netbsd-thread-multi-64int|5.8.2|netbsd|3.1|200809170921
2233495|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.03|i386-netbsd-thread-multi-64int|5.8.1|netbsd|3.1|200809170921
2233494|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.03|i386-netbsd-thread-multi-64int|5.6.2|netbsd|3.1|200809170920
2233492|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.03|i386-netbsd-thread-multi-64int|5.10.0|netbsd|3.1|200809170920
2233475|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.02|i386-netbsd-thread-multi-64int|5.8.8|netbsd|3.1|200809170909
2233474|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.02|i386-netbsd-thread-multi-64int|5.8.7|netbsd|3.1|200809170909
2233472|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.02|i386-netbsd-thread-multi-64int|5.8.6|netbsd|3.1|200809170908
2233471|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.02|i386-netbsd-thread-multi-64int|5.8.5|netbsd|3.1|200809170908
2233469|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.02|i386-netbsd-thread-multi-64int|5.8.4|netbsd|3.1|200809170907
2233465|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.02|i386-netbsd-thread-multi-64int|5.8.3|netbsd|3.1|200809170906
2233461|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.02|i386-netbsd-thread-multi-64int|5.8.2|netbsd|3.1|200809170906
2233460|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.02|i386-netbsd-thread-multi-64int|5.8.1|netbsd|3.1|200809170905
2233459|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.02|i386-netbsd-thread-multi-64int|5.6.2|netbsd|3.1|200809170905
2233458|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.02|i386-netbsd-thread-multi-64int|5.10.0|netbsd|3.1|200809170904
2232284|pass|200809|dmdk1@comcast.net|Test-YAML-Meta|0.11|i486-linux-gnu|5.8.8|linux|2.6.15.7|200809170152
2232196|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.03|darwin-thread-multi-64int-2level|5.8.8|darwin|8.10.0|200809170232
2232177|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.03|darwin-thread-multi-64int-2level|5.8.6|darwin|8.10.0|200809170230
2232171|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.03|darwin-thread-multi-64int|5.6.2|darwin|8.10.0|200809170229
2232167|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.03|darwin-thread-multi-64int-2level|5.10.0|darwin|8.10.0|200809170227
2232153|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.02|darwin-thread-multi-64int-2level|5.8.8|darwin|8.10.0|200809170223
2232145|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.02|darwin-thread-multi-64int-2level|5.8.6|darwin|8.10.0|200809170222
2232133|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.02|darwin-thread-multi-64int|5.6.2|darwin|8.10.0|200809170220
2232129|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.02|darwin-thread-multi-64int-2level|5.10.0|darwin|8.10.0|200809170219
2231795|pass|200809|srezic@cpan.org|Parse-CPAN-Distributions|0.03|i386-freebsd-thread-multi|5.8.8|freebsd|6.1-release|200809170121
2231045|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.03|i686-linux-thread-multi-64int-ld|5.10.0 patch 34372|linux|2.6.24-19-generic|200809162055
2231037|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.02|i686-linux-thread-multi-64int-ld|5.10.0 patch 34372|linux|2.6.24-19-generic|200809162054
2231030|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.01|i686-linux-thread-multi-64int-ld|5.10.0 patch 34372|linux|2.6.24-19-generic|200809162053
2230876|pass|200809|srezic@cpan.org|Parse-CPAN-Distributions|0.03|i386-freebsd-thread-multi|5.10.0|freebsd|6.1-release|200809162103
2230583|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.03|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-19-generic|200809161835
2230578|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.02|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-19-generic|200809161834
2230576|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.01|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-19-generic|200809161832
2230461|pass|200809|srezic@cpan.org|Parse-CPAN-Distributions|0.03|i386-freebsd|5.6.2|freebsd|6.1-release|200809161856
2230141|pass|200809|srezic@cpan.org|Parse-CPAN-Distributions|0.03|i386-freebsd-64int|5.8.8|freebsd|6.1-release|200809161743
2229839|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.03|i386-freebsd-thread-multi-64int|5.8.8|freebsd|6.2-release|200809161422
2229838|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.02|i386-freebsd-thread-multi-64int|5.8.8|freebsd|6.2-release|200809161421
2229837|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.01|i386-freebsd-thread-multi-64int|5.8.8|freebsd|6.2-release|200809161421
2229834|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.03|i386-freebsd-thread-multi-64int|5.10.0|freebsd|6.2-release|200809161418
2229831|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.02|i386-freebsd-thread-multi-64int|5.10.0|freebsd|6.2-release|200809161417
2229830|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.01|i386-freebsd-thread-multi-64int|5.10.0|freebsd|6.2-release|200809161416
2229593|pass|200809|dmdk1@comcast.net|Parse-CPAN-Distributions|0.03|i486-linux-gnu|5.8.8|linux|2.6.15.7|200809160632
2228913|pass|200809|srezic@cpan.org|Parse-CPAN-Distributions|0.03|i386-freebsd|5.10.0|freebsd|6.1-release|200809161205
2228771|pass|200809|imacat@mail.imacat.idv.tw|Parse-CPAN-Distributions|0.03|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.22.10|200809161651
2228673|pass|200809|david@cantrell.org.uk|Parse-CPAN-Distributions|0.03|alpha-netbsd|5.10.0|netbsd|2.1.0_stable|200809160817
2228670|pass|200809|david@cantrell.org.uk|Parse-CPAN-Distributions|0.02|alpha-netbsd|5.10.0|netbsd|2.1.0_stable|200809160816
2228669|pass|200809|david@cantrell.org.uk|Parse-CPAN-Distributions|0.03|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200809160913
2228665|pass|200809|david@cantrell.org.uk|Parse-CPAN-Distributions|0.02|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200809160912
2228664|pass|200809|david@cantrell.org.uk|Parse-CPAN-Distributions|0.03|IP35-irix-64int|5.8.8|irix|6.5|200809161014
2228663|pass|200809|david@cantrell.org.uk|Parse-CPAN-Distributions|0.03|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200809160314
2228661|pass|200809|david@cantrell.org.uk|Parse-CPAN-Distributions|0.02|IP35-irix-64int|5.8.8|irix|6.5|200809161014
2228660|pass|200809|david@cantrell.org.uk|Parse-CPAN-Distributions|0.02|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200809160314
2228657|pass|200809|david@cantrell.org.uk|Parse-CPAN-Distributions|0.03|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200809160911
2228655|pass|200809|david@cantrell.org.uk|Parse-CPAN-Distributions|0.02|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200809160911
2228653|pass|200809|david@cantrell.org.uk|Parse-CPAN-Distributions|0.03|i686-linux|5.8.8|linux|2.4.27-3-686|200809160911
2228652|pass|200809|david@cantrell.org.uk|Parse-CPAN-Distributions|0.03|i686-linux|5.6.2|linux|2.4.27-3-686|200809160911
2228649|pass|200809|david@cantrell.org.uk|Parse-CPAN-Distributions|0.02|i686-linux|5.6.2|linux|2.4.27-3-686|200809160910
2228648|pass|200809|david@cantrell.org.uk|Parse-CPAN-Distributions|0.02|i686-linux|5.8.8|linux|2.4.27-3-686|200809160910
2228072|pass|200809|srezic@cpan.org|Parse-CPAN-Distributions|0.02|i386-freebsd-thread-multi|5.8.8|freebsd|6.1-release|200809160529
2227779|pass|200809|srezic@cpan.org|Parse-CPAN-Distributions|0.02|i386-freebsd-thread-multi|5.10.0|freebsd|6.1-release|200809160151
2227588|pass|200809|srezic@cpan.org|Parse-CPAN-Distributions|0.02|i386-freebsd|5.6.2|freebsd|6.1-release|200809160026
2227060|pass|200809|srezic@cpan.org|Parse-CPAN-Distributions|0.03|i386-freebsd|5.8.8 patch 33662|freebsd|6.1-release-p23|200809152105
2226296|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.01|OpenBSD.i386-openbsd-thread-multi|5.8.8|openbsd|4.1|200809151705
2226240|fail|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.01|OpenBSD.i386-openbsd-thread-multi-64int|5.10.0|openbsd|4.1|200809151656
2225962|cpan|200809|BARBIE|Parse-CPAN-Distributions|0.03||0|||200809151650
2225863|fail|200809|srezic@cpan.org|Parse-CPAN-Distributions|0.02|i386-freebsd-64int|5.8.8|freebsd|6.1-release|200809151634
2225852|pass|200809|bingos@cpan.org|Parse-CPAN-Distributions|0.01|i386-freebsd-thread-multi-64int|5.8.8 patch 34360|freebsd|7.0-release|200809151153
2225763|pass|200809|vpit@cpan.org|Parse-CPAN-Distributions|0.01|x86_64-linux-thread-multi|5.10.0|linux|2.6.24.2-fuuka.profvince.com|200809151604
2225705|fail|200809|rick@jrmyers.net ("Rick Myers")|WWW-Scraper-ISBN-Yahoo_Driver|0.07|i686-linux|5.8.8|linux|2.6.24.3|200809150951
2225671|pass|200809|srezic@cpan.org|Parse-CPAN-Distributions|0.02|i386-freebsd|5.10.0|freebsd|6.1-release|200809151537
2225556|cpan|200809|BARBIE|Parse-CPAN-Distributions|0.02||0|||200809151506
2225488|pass|200809|rick@jrmyers.net ("Rick Myers")|Mail-File|0.08|i686-linux|5.8.8|linux|2.6.24.3|200809150837
2225277|pass|200809|rick@jrmyers.net ("Rick Myers")|Data-Phrasebook-Loader-DBI|0.11|i686-linux|5.8.8|linux|2.6.24.3|200809150721
2224606|pass|200809|rick@jrmyers.net ("Rick Myers")|Data-Phrasebook-Loader-Ini|0.10|i686-linux|5.8.8|linux|2.6.24.3|200809150502
2224056|pass|200809|rick@jrmyers.net ("Rick Myers")|Parse-CPAN-Distributions|0.01|i686-linux|5.8.8|linux|2.6.24.3|200809150313
2223931|pass|200809|rick@jrmyers.net ("Rick Myers")|Parse-CPAN-Distributions|0.01|i686-linux|5.10.0|linux|2.6.24.3|200809150256
2223583|pass|200809|rick@jrmyers.net ("Rick Myers")|WWW-Scraper-ISBN-Pearson_Driver|0.10|i686-linux|5.8.8|linux|2.6.24.3|200809150159
2221486|pass|200809|srezic@cpan.org|Parse-CPAN-Distributions|0.01|i386-freebsd-thread-multi|5.8.8|freebsd|6.1-release|200809150139
2219047|pass|200809|srezic@cpan.org|Parse-CPAN-Distributions|0.01|i386-freebsd|5.8.8 patch 34313|freebsd|6.1-release-p23|200809141832
2218167|pass|200809|bingos@cpan.org|Parse-CPAN-Distributions|0.01|i386-freebsd-thread-multi-64int|5.10.0 patch 34342|freebsd|7.0-release|200809141333
2218050|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.01|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.16.38|200809141335
2217983|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.01|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.16.38|200809141326
2217367|fail|200809|rick@jrmyers.net ("Rick Myers")|WWW-Scraper-ISBN-Yahoo_Driver|0.07|i686-linux|5.10.0|linux|2.6.24.3|200809140633
2217243|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.01|i386-freebsd-64int|5.10.0|freebsd|7.0-release|200809141026
2216972|pass|200809|rick@jrmyers.net ("Rick Myers")|Mail-File|0.08|i686-linux|5.10.0|linux|2.6.24.3|200809140401
2216519|pass|200809|dmdk1@comcast.net|Parse-CPAN-Distributions|0.01|i486-linux-gnu|5.8.8|linux|2.6.15.7|200809140215
2216415|pass|200809|rick@jrmyers.net ("Rick Myers")|Data-Phrasebook-Loader-DBI|0.11|i686-linux|5.10.0|linux|2.6.24.3|200809140223
2214985|pass|200809|rick@jrmyers.net ("Rick Myers")|Data-Phrasebook-Loader-Ini|0.10|i686-linux|5.10.0|linux|2.6.24.3|200809140248
2214911|pass|200809|rick@jrmyers.net ("Rick Myers")|Regexp-Log-Common|0.05|i686-linux|5.8.8|linux|2.6.24.3|200809140237
2214378|pass|200809|rick@jrmyers.net ("Rick Myers")|WWW-Scraper-ISBN-Pearson_Driver|0.10|i686-linux|5.10.0|linux|2.6.24.3|200809140103
2213654|unknown|200809|rick@jrmyers.net ("Rick Myers")|WWW-Scraper-ISBN-Amazon_Driver|0.13|i686-linux|5.8.8|linux|2.6.24.3|200809131950
2211332|pass|200809|srezic@cpan.org|Parse-CPAN-Distributions|0.01|i386-freebsd-thread-multi|5.10.0|freebsd|6.1-release|200809131900
2210741|pass|200809|JOST@cpan.org ("Josts Smokehouse")|Parse-CPAN-Distributions|0.01|i86pc-solaris-64int|5.10.0|solaris|2.11|200809131723
2210033|pass|200809|srezic@cpan.org|Parse-CPAN-Distributions|0.01|i386-freebsd|5.6.2|freebsd|6.1-release|200809131528
2209853|pass|200809|rick@jrmyers.net ("Rick Myers")|Games-Trackword|1.06|i686-linux|5.8.8|linux|2.6.24.3|200809130857
2209439|pass|200809|srezic@cpan.org|Parse-CPAN-Distributions|0.01|i386-freebsd|5.10.0|freebsd|6.1-release|200809131339
2209344|pass|200809|david@cantrell.org.uk|Parse-CPAN-Distributions|0.01|alpha-netbsd|5.10.0|netbsd|2.1.0_stable|200809131131
2209339|pass|200809|david@cantrell.org.uk|Parse-CPAN-Distributions|0.01|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200809130631
2209329|pass|200809|david@cantrell.org.uk|Parse-CPAN-Distributions|0.01|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200809131229
2208840|pass|200809|david@cantrell.org.uk|Parse-CPAN-Distributions|0.01|IP35-irix-64int|5.8.8|irix|6.5|200809131230
2208837|pass|200809|david@cantrell.org.uk|Parse-CPAN-Distributions|0.01|i686-linux|5.6.2|linux|2.4.27-3-686|200809131129
2208813|pass|200809|david@cantrell.org.uk|Parse-CPAN-Distributions|0.01|i686-linux|5.8.8|linux|2.4.27-3-686|200809131127
2208711|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.01|i386-netbsd-thread-multi-64int|5.8.8|netbsd|3.1|200809131054
2208709|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.01|i386-netbsd-thread-multi-64int|5.8.7|netbsd|3.1|200809131053
2208706|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.01|i386-netbsd-thread-multi-64int|5.8.6|netbsd|3.1|200809131052
2208705|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.01|i386-netbsd-thread-multi-64int|5.8.5|netbsd|3.1|200809131052
2208702|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.01|i386-netbsd-thread-multi-64int|5.8.4|netbsd|3.1|200809131051
2208693|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.01|i386-netbsd-thread-multi-64int|5.8.3|netbsd|3.1|200809131050
2208687|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.01|i386-netbsd-thread-multi-64int|5.8.2|netbsd|3.1|200809131050
2208684|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.01|i386-netbsd-thread-multi-64int|5.8.1|netbsd|3.1|200809131049
2208665|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.01|i386-netbsd-thread-multi-64int|5.6.2|netbsd|3.1|200809131048
2208652|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.01|i386-netbsd-thread-multi-64int|5.10.0|netbsd|3.1|200809131048
2208578|pass|200809|imacat@mail.imacat.idv.tw|Parse-CPAN-Distributions|0.01|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.22.10|200809131731
2206225|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.01|darwin-thread-multi-64int-2level|5.8.8|darwin|8.10.0|200809130415
2206213|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.01|darwin-thread-multi-64int-2level|5.8.6|darwin|8.10.0|200809130410
2206166|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.01|darwin-thread-multi-64int|5.6.2|darwin|8.10.0|200809130357
2206159|pass|200809|chris@bingosnet.co.uk|Parse-CPAN-Distributions|0.01|darwin-thread-multi-64int-2level|5.10.0|darwin|8.10.0|200809130355
2204842|fail|200809|chris@bingosnet.co.uk|WWW-UsePerl-Journal-Thread|0.10|darwin-thread-multi-64int-2level|5.8.8 patch 34327|darwin|8.10.0|200809130218
2204777|pass|200809|chris@bingosnet.co.uk|WWW-UsePerl-Journal|0.21|darwin-thread-multi-64int-2level|5.8.8 patch 34327|darwin|8.10.0|200809130216
2204722|fail|200809|chris@bingosnet.co.uk|WWW-Scraper-ISBN-Yahoo_Driver|0.07|darwin-thread-multi-64int-2level|5.8.8 patch 34327|darwin|8.10.0|200809130213
2204588|pass|200809|martin.evans@easysoft.com|CPAN-WWW-Testers-Generator|0.27|i686-linux-ld|5.10.0|linux|2.6.24-19-generic|200809121635
2204575|pass|200809|chris@bingosnet.co.uk|WWW-Scraper-ISBN-Pearson_Driver|0.10|darwin-thread-multi-64int-2level|5.8.8 patch 34327|darwin|8.10.0|200809130207
2204482|pass|200809|chris@bingosnet.co.uk|WWW-Scraper-ISBN-ORA_Driver|0.09|darwin-thread-multi-64int-2level|5.8.8 patch 34327|darwin|8.10.0|200809130202
2204436|fail|200809|chris@bingosnet.co.uk|WWW-Scraper-ISBN-Amazon_Driver|0.13|darwin-thread-multi-64int-2level|5.8.8 patch 34327|darwin|8.10.0|200809130158
2204414|pass|200809|chris@bingosnet.co.uk|Test-YAML-Meta|0.11|darwin-thread-multi-64int-2level|5.8.8 patch 34327|darwin|8.10.0|200809130153
2204391|pass|200809|chris@bingosnet.co.uk|Test-CPAN-Meta|0.12|darwin-thread-multi-64int-2level|5.8.8 patch 34327|darwin|8.10.0|200809130150
2204378|pass|200809|chris@bingosnet.co.uk|Regexp-Log-Common|0.05|darwin-thread-multi-64int-2level|5.8.8 patch 34327|darwin|8.10.0|200809130148
2204372|pass|200809|chris@bingosnet.co.uk|Mail-File|0.08|darwin-thread-multi-64int-2level|5.8.8 patch 34327|darwin|8.10.0|200809130146
2204371|pass|200809|chris@bingosnet.co.uk|Games-Trackword|1.06|darwin-thread-multi-64int-2level|5.8.8 patch 34327|darwin|8.10.0|200809130145
2204369|pass|200809|chris@bingosnet.co.uk|GD-Chart-Radial|0.07|darwin-thread-multi-64int-2level|5.8.8 patch 34327|darwin|8.10.0|200809130144
2204346|pass|200809|chris@bingosnet.co.uk|Finance-Currency-Convert-XE|0.15|darwin-thread-multi-64int-2level|5.8.8 patch 34327|darwin|8.10.0|200809130142
2204319|pass|200809|chris@bingosnet.co.uk|Data-Phrasebook-Loader-YAML|0.09|darwin-thread-multi-64int-2level|5.8.8 patch 34327|darwin|8.10.0|200809130140
2204312|pass|200809|chris@bingosnet.co.uk|Data-Phrasebook-Loader-XML|0.12|darwin-thread-multi-64int-2level|5.8.8 patch 34327|darwin|8.10.0|200809130139
2204304|pass|200809|chris@bingosnet.co.uk|Data-Phrasebook-Loader-Ini|0.10|darwin-thread-multi-64int-2level|5.8.8 patch 34327|darwin|8.10.0|200809130137
2204282|pass|200809|chris@bingosnet.co.uk|Data-Phrasebook-Loader-DBI|0.11|darwin-thread-multi-64int-2level|5.8.8 patch 34327|darwin|8.10.0|200809130136
2204273|pass|200809|chris@bingosnet.co.uk|Data-Phrasebook|0.29|darwin-thread-multi-64int-2level|5.8.8 patch 34327|darwin|8.10.0|200809130133
2204267|pass|200809|chris@bingosnet.co.uk|Data-FormValidator-Constraints-Words|0.03|darwin-thread-multi-64int-2level|5.8.8 patch 34327|darwin|8.10.0|200809130132
2204257|pass|200809|chris@bingosnet.co.uk|Calendar-List|0.21|darwin-thread-multi-64int-2level|5.8.8 patch 34327|darwin|8.10.0|200809130131
2201808|pass|200809|rick@jrmyers.net ("Rick Myers")|WWW-Scraper-ISBN-ORA_Driver|0.09|i686-linux|5.8.8|linux|2.6.24.3|200809121443
2201744|pass|200809|srezic@cpan.org|Parse-CPAN-Distributions|0.01|i386-freebsd-64int|5.8.8|freebsd|6.1-release|200809122026
2201632|pass|200809|srezic@cpan.org|Parse-CPAN-Distributions|0.01|i386-freebsd|5.8.8 patch 33662|freebsd|6.1-release-p23|200809122011
2201153|pass|200809|rick@jrmyers.net ("Rick Myers")|Regexp-Log-Common|0.05|i686-linux|5.10.0|linux|2.6.24.3|200809121303
2200886|cpan|200809|BARBIE|Parse-CPAN-Distributions|0.01||0|||200809121832
2199134|unknown|200809|rick@jrmyers.net ("Rick Myers")|WWW-Scraper-ISBN-Amazon_Driver|0.13|i686-linux|5.10.0|linux|2.6.24.3|200809120911
2198985|pass|200809|rick@jrmyers.net ("Rick Myers")|Test-CPAN-Meta|0.12|i686-linux|5.8.8|linux|2.6.24.3|200809120850
2197133|fail|200809|rick@jrmyers.net ("Rick Myers")|WWW-UsePerl-Journal-Thread|0.10|i686-linux|5.8.8|linux|2.6.24.3|200809120404
2195019|pass|200809|rick@jrmyers.net ("Rick Myers")|WWW-UsePerl-Journal|0.21|i686-linux|5.8.8|linux|2.6.24.3|200809111912
2193426|pass|200809|srezic@cpan.org|CPAN-WWW-Testers-Generator|0.27|i386-freebsd|5.6.2|freebsd|6.1-release|200809112054
2192181|pass|200809|chris@bingosnet.co.uk|CPAN-WWW-Testers-Generator|0.27|i386-netbsd-thread-multi-64int|5.8.8|netbsd|3.1|200809111658
2192018|pass|200809|srezic@cpan.org|CPAN-WWW-Testers-Generator|0.27|i386-freebsd-64int|5.8.8|freebsd|6.1-release|200809111653
2191986|pass|200809|srezic@cpan.org|Data-Phrasebook-Loader-DBI|0.11|i386-freebsd|5.8.8 patch 34313|freebsd|6.1-release-p23|200809111654
2191955|pass|200809|srezic@cpan.org|Data-Phrasebook-Loader-XML|0.12|i386-freebsd|5.8.8 patch 34313|freebsd|6.1-release-p23|200809111653
2191943|pass|200809|srezic@cpan.org|Data-Phrasebook-Loader-Ini|0.10|i386-freebsd|5.8.8 patch 34313|freebsd|6.1-release-p23|200809111654
2191311|pass|200809|JOST@cpan.org ("Josts Smokehouse")|CPAN-WWW-Testers-Generator|0.27|i86pc-solaris-64int|5.10.0|solaris|2.11|200809111632
2190575|pass|200809|srezic@cpan.org|CPAN-WWW-Testers-Generator|0.27|i386-freebsd|5.10.0|freebsd|6.1-release|200809111428
2190144|pass|200809|srezic@cpan.org|GD-Chart-Radial|0.07|i386-freebsd|5.8.8 patch 34313|freebsd|6.1-release-p23|200809111412
2189662|pass|200809|srezic@cpan.org|CPAN-WWW-Testers-Generator|0.27|i386-freebsd|5.8.8 patch 33662|freebsd|6.1-release-p23|200809111326
2189451|pass|200809|srezic@cpan.org|Mail-File|0.08|i386-freebsd|5.8.8 patch 34313|freebsd|6.1-release-p23|200809111220
2188209|cpan|200809|BARBIE|CPAN-WWW-Testers-Generator|0.27||0|||200809111056
2188021|pass|200809|srezic@cpan.org|Regexp-Log-Common|0.05|i386-freebsd|5.8.8 patch 34313|freebsd|6.1-release-p23|200809111035
2184824|pass|200809|srezic@cpan.org|CPAN-YACSmoke-Plugin-WebList|0.05|i386-freebsd|5.8.8 patch 34313|freebsd|6.1-release-p23|200809102327
2184823|pass|200809|srezic@cpan.org|CPAN-YACSmoke-Plugin-Outlook|0.06|i386-freebsd|5.8.8 patch 34313|freebsd|6.1-release-p23|200809102325
2184822|pass|200809|srezic@cpan.org|CPAN-YACSmoke-Plugin-NNTP|0.05|i386-freebsd|5.8.8 patch 34313|freebsd|6.1-release-p23|200809102324
2183867|pass|200809|rick@jrmyers.net ("Rick Myers")|Games-Trackword|1.06|i686-linux|5.10.0|linux|2.6.24.3|200809101449
2179546|pass|200809|srezic@cpan.org|Data-FormValidator-Constraints-Words|0.03|i386-freebsd|5.8.8 patch 34313|freebsd|6.1-release-p23|200809100845
2179345|pass|200809|srezic@cpan.org|Finance-Currency-Convert-XE|0.15|i386-freebsd|5.8.8 patch 34313|freebsd|6.1-release-p23|200809100846
2178705|pass|200809|srezic@cpan.org|Test-CPAN-Meta|0.12|i386-freebsd|5.8.8 patch 34313|freebsd|6.1-release-p23|200809100848
2178115|pass|200809|srezic@cpan.org|Games-Trackword|1.06|i386-freebsd|5.8.8 patch 34313|freebsd|6.1-release-p23|200809100846
2177930|pass|200809|srezic@cpan.org|CPAN-Testers-WWW-Statistics|0.48|i386-freebsd|5.8.8 patch 34313|freebsd|6.1-release-p23|200809100845
2177924|pass|200809|srezic@cpan.org|CPAN-WWW-Testers-Generator|0.26|i386-freebsd|5.8.8 patch 34313|freebsd|6.1-release-p23|200809100845
2177820|pass|200809|srezic@cpan.org|Calendar-List|0.21|i386-freebsd|5.8.8 patch 34313|freebsd|6.1-release-p23|200809100844
2174008|fail|200809|srezic@cpan.org|WWW-Scraper-ISBN-Amazon_Driver|0.13|i386-freebsd|5.8.8 patch 34313|freebsd|6.1-release-p23|200809091937
2173607|fail|200809|srezic@cpan.org|WWW-Scraper-ISBN-Yahoo_Driver|0.07|i386-freebsd|5.8.8 patch 34313|freebsd|6.1-release-p23|200809091836
2173606|pass|200809|srezic@cpan.org|WWW-Scraper-ISBN-Pearson_Driver|0.10|i386-freebsd|5.8.8 patch 34313|freebsd|6.1-release-p23|200809091836
2173604|pass|200809|srezic@cpan.org|WWW-Scraper-ISBN-ORA_Driver|0.09|i386-freebsd|5.8.8 patch 34313|freebsd|6.1-release-p23|200809091836
2168892|pass|200809|rick@jrmyers.net ("Rick Myers")|WWW-Scraper-ISBN-ORA_Driver|0.09|i686-linux|5.10.0|linux|2.6.24.3|200809090057
2168804|pass|200809|rick@jrmyers.net ("Rick Myers")|Data-FormValidator-Constraints-Words|0.03|i686-linux|5.8.8|linux|2.6.24.3|200809090047
2167734|pass|200809|rick@jrmyers.net ("Rick Myers")|GD-Chart-Radial|0.07|i686-linux|5.8.8|linux|2.6.24.3|200809090148
2167605|pass|200809|JOST@cpan.org ("Josts Smokehouse")|Mail-File|0.08|i86pc-solaris-64int|5.10.0|solaris|2.11|200809090331
2167603|pass|200809|JOST@cpan.org ("Josts Smokehouse")|Regexp-Log-Common|0.05|i86pc-solaris-64int|5.10.0|solaris|2.11|200809090331
2167049|pass|200809|JOST@cpan.org ("Josts Smokehouse")|CPAN-YACSmoke-Plugin-Outlook|0.06|i86pc-solaris-64int|5.10.0|solaris|2.11|200809090206
2167047|pass|200809|JOST@cpan.org ("Josts Smokehouse")|CPAN-YACSmoke-Plugin-WebList|0.05|i86pc-solaris-64int|5.10.0|solaris|2.11|200809090205
2167042|pass|200809|JOST@cpan.org ("Josts Smokehouse")|CPAN-YACSmoke-Plugin-NNTP|0.05|i86pc-solaris-64int|5.10.0|solaris|2.11|200809090202
2167041|pass|200809|JOST@cpan.org ("Josts Smokehouse")|CPAN-YACSmoke-Plugin-NNTPWeb|0.06|i86pc-solaris-64int|5.10.0|solaris|2.11|200809090202
2166973|pass|200809|chris@bingosnet.co.uk|CPAN-Testers-WWW-Statistics|0.48|i386-netbsd-thread-multi-64int|5.8.8|netbsd|4.0|200809090040
2166926|pass|200809|chris@bingosnet.co.uk|CPAN-Testers-WWW-Statistics|0.48|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0|200809090026
2166024|pass|200809|srezic@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i386-freebsd|5.8.8 patch 34313|freebsd|6.1-release-p23|200809082325
2166006|pass|200809|dwheeler@cpan.org|Test-YAML-Meta|0.11|darwin-2level|5.10.0|darwin|9.4.0|200809082129
2165955|pass|200809|srezic@cpan.org|Data-Phrasebook|0.29|i386-freebsd|5.8.8 patch 34313|freebsd|6.1-release-p23|200809082325
2165663|pass|200809|srezic@cpan.org|Test-YAML-Meta|0.11|i386-freebsd|5.8.8 patch 34313|freebsd|6.1-release-p23|200809082257
2164485|pass|200809|rick@jrmyers.net ("Rick Myers")|Test-CPAN-Meta|0.12|i686-linux|5.10.0|linux|2.6.24.3|200809081416
2162942|fail|200809|rick@jrmyers.net ("Rick Myers")|WWW-UsePerl-Journal-Thread|0.10|i686-linux|5.10.0|linux|2.6.24.3|200809081009
2162294|pass|200809|chris@bingosnet.co.uk|Data-Phrasebook-Loader-YAML|0.09|OpenBSD.i386-openbsd-thread-multi-64int|5.10.0|openbsd|4.2|200809081238
2162293|pass|200809|chris@bingosnet.co.uk|Data-Phrasebook|0.29|OpenBSD.i386-openbsd-thread-multi-64int|5.10.0|openbsd|4.2|200809081237
2162288|pass|200809|chris@bingosnet.co.uk|Data-Phrasebook-Loader-YAML|0.09|OpenBSD.i386-openbsd-thread-multi-64int|5.8.8|openbsd|4.2|200809081235
2162287|pass|200809|chris@bingosnet.co.uk|Data-Phrasebook|0.29|OpenBSD.i386-openbsd-thread-multi-64int|5.8.8|openbsd|4.2|200809081234
2161032|pass|200809|rick@jrmyers.net ("Rick Myers")|WWW-UsePerl-Journal|0.21|i686-linux|5.10.0|linux|2.6.24.3|200809080318
2159632|pass|200809|david@cantrell.org.uk|CPAN-WWW-Testers-Generator|0.26|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200809080029
2159615|pass|200809|david@cantrell.org.uk|CPAN-Testers-WWW-Statistics|0.48|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200809080027
2157889|fail|200809|david@cantrell.org.uk|CPAN-WWW-Testers-Generator|0.26|IP35-irix-64int|5.8.8|irix|6.5|200809072059
2157584|fail|200809|david@cantrell.org.uk|CPAN-WWW-Testers-Generator|0.26|i686-linux|5.8.8|linux|2.4.27-3-686|200809071902
2157488|pass|200809|david@cantrell.org.uk|CPAN-Testers-WWW-Statistics|0.48|i686-linux|5.8.8|linux|2.4.27-3-686|200809071845
2156662|pass|200809|rick@jrmyers.net ("Rick Myers")|Data-Phrasebook-Loader-XML|0.12|i686-linux|5.10.0|linux|2.6.24.3|200809071057
2156268|pass|200809|chris@bingosnet.co.uk|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi-ld|5.11.0 patch 34282|linux|2.6.21.5-smp|200809071353
2156266|pass|200809|chris@bingosnet.co.uk|Data-Phrasebook|0.29|i686-linux-thread-multi-ld|5.11.0 patch 34282|linux|2.6.21.5-smp|200809071353
2155934|pass|200809|rick@jrmyers.net ("Rick Myers")|Data-Phrasebook-Loader-XML|0.12|i686-linux|5.8.8|linux|2.6.24.3|200809070716
2155899|fail|200809|david@cantrell.org.uk|CPAN-WWW-Testers-Generator|0.26|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200809070608
2155832|pass|200809|david@cantrell.org.uk|CPAN-Testers-WWW-Statistics|0.48|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200809070555
2154286|pass|200809|rick@jrmyers.net ("Rick Myers")|Data-Phrasebook-Loader-YAML|0.09|i686-linux|5.10.0|linux|2.6.24.3|200809070111
2154285|pass|200809|rick@jrmyers.net ("Rick Myers")|Data-Phrasebook|0.29|i686-linux|5.10.0|linux|2.6.24.3|200809070111
2146766|pass|200809|chris@bingosnet.co.uk|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.21.5-smp|200809051944
2146759|pass|200809|chris@bingosnet.co.uk|Data-Phrasebook|0.29|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.21.5-smp|200809051943
2145614|pass|200809|chris@bingosnet.co.uk|CPAN-WWW-Testers-Generator|0.25|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0|200809051523
2145489|pass|200809|rick@jrmyers.net ("Rick Myers")|Data-FormValidator-Constraints-Words|0.03|i686-linux|5.10.0|linux|2.6.24.3|200809051003
2145203|pass|200809|jrockway@cpan.org|Test-YAML-Meta|0.11|x86_64-linux|5.10.0|linux|2.6.22-3-amd64|200809050732
2143992|fail|200809|JOST@cpan.org ("Josts Smokehouse")|WWW-UsePerl-Journal-Thread|0.10|i86pc-solaris-64int|5.10.0|solaris|2.11|200809051116
2143988|pass|200809|JOST@cpan.org ("Josts Smokehouse")|WWW-UsePerl-Journal|0.21|i86pc-solaris-64int|5.10.0|solaris|2.11|200809051116
2142422|pass|200809|rick@jrmyers.net ("Rick Myers")|GD-Chart-Radial|0.07|i686-linux|5.10.0|linux|2.6.24.3|200809050100
2141487|pass|200809|vpit@cpan.org|CPAN-WWW-Testers-Generator|0.25|x86_64-linux-thread-multi|5.10.0|linux|2.6.24.2-fuuka.profvince.com|200809050201
2139471|pass|200809|vpit@cpan.org|CPAN-Testers-WWW-Statistics|0.48|x86_64-linux-thread-multi|5.10.0|linux|2.6.24.2-fuuka.profvince.com|200809042234
2139454|pass|200809|autarch@urth.org|WWW-UsePerl-Journal|0.21|x86_64-linux-gnu|5.8.8|linux|2.6.15.7|200809041000
2138943|pass|200809|JOST@cpan.org ("Josts Smokehouse")|Finance-Currency-Convert-XE|0.15|i86pc-solaris-64int|5.10.0|solaris|2.11|200809041948
2138812|pass|200809|chris@bingosnet.co.uk|CPAN-WWW-Testers-Generator|0.25|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.21.5-smp|200809041718
2138810|pass|200809|chris@bingosnet.co.uk|CPAN-Testers-WWW-Statistics|0.48|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.21.5-smp|200809041716
2138512|pass|200809|JOST@cpan.org ("Josts Smokehouse")|Data-FormValidator-Constraints-Words|0.03|i86pc-solaris-64int|5.10.0|solaris|2.11|200809041740
2137749|pass|200809|david@cantrell.org.uk|CPAN-WWW-Testers-Generator|0.25|i686-linux-thread-multi|5.10.0|linux|2.4.27-3-686|200809041251
2134098|pass|200809|david@cantrell.org.uk|CPAN-WWW-Testers-Generator|0.25|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200809031706
2133935|fail|200809|david@cantrell.org.uk|CPAN-WWW-Testers-Generator|0.26|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200809031948
2133871|pass|200809|david@cantrell.org.uk|CPAN-WWW-Testers-Generator|0.25|i686-linux|5.8.8|linux|2.4.27-3-686|200809031920
2133859|pass|200809|david@cantrell.org.uk|CPAN-Testers-WWW-Statistics|0.48|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200809031915
2133852|fail|200809|david@cantrell.org.uk|CPAN-WWW-Testers-Generator|0.26|alpha-netbsd|5.10.0|netbsd|2.1.0_stable|200809031814
2133695|pass|200809|david@cantrell.org.uk|CPAN-Testers-WWW-Statistics|0.48|alpha-netbsd|5.10.0|netbsd|2.1.0_stable|200809031747
2133403|pass|200809|vpit@cpan.org|Data-Phrasebook-Loader-YAML|0.09|x86_64-linux-thread-multi|5.10.0|linux|2.6.24.2-fuuka.profvince.com|200809031843
2133402|pass|200809|vpit@cpan.org|Data-Phrasebook|0.29|x86_64-linux-thread-multi|5.10.0|linux|2.6.24.2-fuuka.profvince.com|200809031843
2133398|pass|200809|srezic@cpan.org|CPAN-Testers-WWW-Statistics|0.48|i386-freebsd-thread-multi|5.10.0|freebsd|6.1-release|200809031839
2133038|fail|200809|srezic@cpan.org|CPAN-WWW-Testers-Generator|0.26|i386-freebsd|5.6.2|freebsd|6.1-release|200809031734
2132302|pass|200809|srezic@cpan.org|CPAN-WWW-Testers-Generator|0.26|i386-freebsd-64int|5.8.8|freebsd|6.1-release|200809031445
2132207|pass|200809|chris@bingosnet.co.uk|CPAN-WWW-Testers-Generator|0.25|i386-freebsd-thread-multi-64int|5.10.0|freebsd|6.2-release|200809031203
2132068|pass|200809|chris@bingosnet.co.uk|CPAN-WWW-Testers-Generator|0.25|i386-freebsd-thread-multi-64int|5.8.8|freebsd|6.2-release|200809031125
2132056|pass|200809|chris@bingosnet.co.uk|CPAN-Testers-WWW-Statistics|0.48|i386-netbsd-thread-multi-64int|5.8.8|netbsd|3.1|200809031233
2132052|pass|200809|chris@bingosnet.co.uk|CPAN-Testers-WWW-Statistics|0.48|i386-netbsd-thread-multi-64int|5.8.7|netbsd|3.1|200809031231
2132044|pass|200809|chris@bingosnet.co.uk|CPAN-Testers-WWW-Statistics|0.48|i386-netbsd-thread-multi-64int|5.8.6|netbsd|3.1|200809031228
2132038|pass|200809|chris@bingosnet.co.uk|CPAN-Testers-WWW-Statistics|0.48|i386-netbsd-thread-multi-64int|5.8.5|netbsd|3.1|200809031226
2132031|pass|200809|chris@bingosnet.co.uk|CPAN-Testers-WWW-Statistics|0.48|i386-netbsd-thread-multi-64int|5.8.4|netbsd|3.1|200809031223
2132026|pass|200809|chris@bingosnet.co.uk|CPAN-Testers-WWW-Statistics|0.48|i386-netbsd-thread-multi-64int|5.8.3|netbsd|3.1|200809031221
2132020|pass|200809|chris@bingosnet.co.uk|CPAN-Testers-WWW-Statistics|0.48|i386-netbsd-thread-multi-64int|5.8.2|netbsd|3.1|200809031219
2132015|pass|200809|chris@bingosnet.co.uk|CPAN-Testers-WWW-Statistics|0.48|i386-netbsd-thread-multi-64int|5.8.1|netbsd|3.1|200809031216
2132007|pass|200809|chris@bingosnet.co.uk|CPAN-Testers-WWW-Statistics|0.48|i386-netbsd-thread-multi-64int|5.10.0|netbsd|3.1|200809031213
2131944|pass|200809|vpit@cpan.org|Test-YAML-Meta|0.11|i686-linux-thread-multi|5.10.0|linux|2.6.18.3-tmb-desktop-2mdvsmp|200809031300
2131838|pass|200809|srezic@cpan.org|CPAN-Testers-WWW-Statistics|0.48|i386-freebsd-64int|5.8.8|freebsd|6.1-release|200809031227
2131773|pass|200809|JOST@cpan.org ("Josts Smokehouse")|CPAN-WWW-Testers-Generator|0.26|i86pc-solaris-64int|5.10.0|solaris|2.11|200809031210
2131768|pass|200809|JOST@cpan.org ("Josts Smokehouse")|CPAN-Testers-WWW-Statistics|0.48|i86pc-solaris-64int|5.10.0|solaris|2.11|200809031209
2131735|fail|200809|vpit@cpan.org|CPAN-WWW-Testers-Generator|0.26|i686-linux-thread-multi|5.10.0|linux|2.6.18.3-tmb-desktop-2mdvsmp|200809031201
2131732|fail|200809|chris@bingosnet.co.uk|CPAN-WWW-Testers-Generator|0.26|i386-netbsd-thread-multi-64int|5.8.8|netbsd|3.1|200809031059
2131355|pass|200809|srezic@cpan.org|CPAN-Testers-WWW-Statistics|0.48|i386-freebsd|5.8.8 patch 33662|freebsd|6.1-release-p23|200809031123
2131275|pass|200809|imacat@mail.imacat.idv.tw|CPAN-Testers-WWW-Statistics|0.48|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.22.10|200809031713
2130598|pass|200809|srezic@cpan.org|CPAN-WWW-Testers-Generator|0.26|i386-freebsd|5.10.0|freebsd|6.1-release|200809031000
2130080|pass|200809|srezic@cpan.org|CPAN-WWW-Testers-Generator|0.26|i386-freebsd|5.8.8 patch 33662|freebsd|6.1-release-p23|200809030819
2130010|pass|200809|srezic@cpan.org|CPAN-Testers-WWW-Statistics|0.48|i386-freebsd|5.10.0|freebsd|6.1-release|200809030845
2129768|pass|200809|srezic@cpan.org|Games-Trackword|1.06|i386-freebsd-thread-multi|5.8.8|freebsd|6.1-release|200809030744
2128787|cpan|200809|BARBIE|CPAN-Testers-WWW-Statistics|0.48||0|||200809030203
2128258|pass|200809|david@cantrell.org.uk|CPAN-WWW-Testers-Generator|0.25|IP35-irix-64int|5.8.8|irix|6.5|200809030045
2127841|cpan|200809|BARBIE|CPAN-WWW-Testers-Generator|0.26||0|||200809022319
2127302|pass|200809|shlomif@cpan.org|CPAN-WWW-Testers-Generator|0.25|i686-linux|5.10.0|linux|2.6.26.2-desktop-2mnb|200809022210
2126220|pass|200809|chris@bingosnet.co.uk|Data-Phrasebook-Loader-YAML|0.09|i86pc-solaris-thread-multi-64int|5.8.8|solaris|2.10|200809021600
2126213|pass|200809|chris@bingosnet.co.uk|Data-Phrasebook|0.29|i86pc-solaris-thread-multi-64int|5.8.8|solaris|2.10|200809021559
2125629|pass|200809|vpit@cpan.org|Test-YAML-Meta|0.11|x86_64-linux-thread-multi|5.10.0|linux|2.6.24.2-fuuka.profvince.com|200809011947
2124190|pass|200809|chris@bingosnet.co.uk|Data-Phrasebook-Loader-YAML|0.09|i86pc-solaris-thread-multi-64int|5.8.4|solaris|2.10|200809020607
2124189|pass|200809|chris@bingosnet.co.uk|Data-Phrasebook|0.29|i86pc-solaris-thread-multi-64int|5.8.4|solaris|2.10|200809020607
2123195|pass|200809|david@cantrell.org.uk|CPAN-WWW-Testers-Generator|0.25|alpha-netbsd|5.10.0|netbsd|2.1.0_stable|200809012144
2123193|pass|200809|david@cantrell.org.uk|CPAN-WWW-Testers-Generator|0.25|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200809012243
2122142|pass|200809|vpit@cpan.org|CPAN-WWW-Testers-Generator|0.25|i686-linux-thread-multi|5.10.0|linux|2.6.18.3-tmb-desktop-2mdvsmp|200809011608
2121278|pass|200809|chris@bingosnet.co.uk|CPAN-WWW-Testers-Generator|0.25|OpenBSD.i386-openbsd-thread-multi|5.8.8|openbsd|4.1|200809011109
2120926|pass|200809|chris@bingosnet.co.uk|CPAN-WWW-Testers-Generator|0.25|OpenBSD.i386-openbsd-thread-multi-64int|5.10.0|openbsd|4.1|200809010921
2120361|pass|200809|stro@cpan.org|CPAN-WWW-Testers-Generator|0.25|i686-linux|5.8.8|linux|2.4.27-2-386|200809010602
2120231|pass|200809|stro@cpan.org|CPAN-WWW-Testers-Generator|0.25|i686-linux|5.10.0|linux|2.4.27-2-386|200809010511
2115709|pass|200808|chris@bingosnet.co.uk|CPAN-WWW-Testers-Generator|0.25|i86pc-solaris-thread-multi-64int|5.10.0|solaris|2.10|200808311327
2114880|pass|200808|chris@bingosnet.co.uk|CPAN-WWW-Testers-Generator|0.25|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.16.38|200808311030
2114071|pass|200808|chris@bingosnet.co.uk|Data-Phrasebook-Loader-YAML|0.09|OpenBSD.i386-openbsd-thread-multi-64int|5.11.0 patch 34234|openbsd|4.3|200808310415
2114070|pass|200808|chris@bingosnet.co.uk|Data-Phrasebook|0.29|OpenBSD.i386-openbsd-thread-multi-64int|5.11.0 patch 34234|openbsd|4.3|200808310414
2113898|pass|200808|chris@bingosnet.co.uk|Data-Phrasebook-Loader-YAML|0.09|darwin-thread-multi-64int-2level|5.8.8|darwin|8.10.0|200808310231
2113896|pass|200808|chris@bingosnet.co.uk|Data-Phrasebook|0.29|darwin-thread-multi-64int-2level|5.8.8|darwin|8.10.0|200808310231
2113887|pass|200808|chris@bingosnet.co.uk|Data-Phrasebook-Loader-YAML|0.09|darwin-thread-multi-64int-2level|5.8.6|darwin|8.10.0|200808310229
2113886|pass|200808|chris@bingosnet.co.uk|Data-Phrasebook|0.29|darwin-thread-multi-64int-2level|5.8.6|darwin|8.10.0|200808310229
2113882|pass|200808|chris@bingosnet.co.uk|Data-Phrasebook|0.29|darwin-thread-multi-64int|5.6.2|darwin|8.10.0|200808310228
2113875|pass|200808|chris@bingosnet.co.uk|Data-Phrasebook-Loader-YAML|0.09|darwin-thread-multi-64int-2level|5.10.0|darwin|8.10.0|200808310226
2113873|pass|200808|chris@bingosnet.co.uk|Data-Phrasebook|0.29|darwin-thread-multi-64int-2level|5.10.0|darwin|8.10.0|200808310226
2113470|pass|200808|chris@bingosnet.co.uk|Data-Phrasebook-Loader-YAML|0.09|OpenBSD.i386-openbsd-thread-multi-64int|5.10.0 patch 34161|openbsd|4.3|200808302247
2113466|pass|200808|chris@bingosnet.co.uk|Data-Phrasebook|0.29|OpenBSD.i386-openbsd-thread-multi-64int|5.10.0 patch 34161|openbsd|4.3|200808302246
2113120|pass|200808|chris@bingosnet.co.uk|Data-Phrasebook-Loader-YAML|0.09|i86pc-solaris-thread-multi-64int|5.8.8|solaris|2.10|200808302020
2113119|pass|200808|chris@bingosnet.co.uk|Data-Phrasebook|0.29|i86pc-solaris-thread-multi-64int|5.8.8|solaris|2.10|200808302019
2113049|pass|200808|chris@bingosnet.co.uk|Data-Phrasebook-Loader-YAML|0.09|i86pc-solaris-thread-multi-64int|5.11.0 patch 34234|solaris|2.10|200808301949
2113045|pass|200808|chris@bingosnet.co.uk|Data-Phrasebook|0.29|i86pc-solaris-thread-multi-64int|5.11.0 patch 34234|solaris|2.10|200808301948
2112968|pass|200808|rurban@x-ray.at (Reini Urban)|Test-YAML-Meta|0.11|cygwin-thread-multi-64int|5.10.0 patch 34065|cygwin|1.5.25(0.15642)|200808301817
2112729|pass|200808|chris@bingosnet.co.uk|Data-Phrasebook-Loader-YAML|0.09|OpenBSD.i386-openbsd-thread-multi-64int|5.10.0|openbsd|4.3|200808301736
2112725|pass|200808|chris@bingosnet.co.uk|Data-Phrasebook|0.29|OpenBSD.i386-openbsd-thread-multi-64int|5.10.0|openbsd|4.3|200808301734
2111920|pass|200808|imacat@mail.imacat.idv.tw|CPAN-WWW-Testers-Generator|0.25|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.22.10|200808301956
2109677|pass|200808|srezic@cpan.org|CPAN-WWW-Testers-Generator|0.25|i386-freebsd|5.8.8 patch 33662|freebsd|6.1-release-p23|200808300139
2109504|pass|200808|chris@bingosnet.co.uk|CPAN-WWW-Testers-Generator|0.25|i386-netbsd-thread-multi-64int|5.8.8|netbsd|3.1|200808292358
2109501|pass|200808|chris@bingosnet.co.uk|CPAN-WWW-Testers-Generator|0.25|i386-netbsd-thread-multi-64int|5.8.7|netbsd|3.1|200808292357
2109498|pass|200808|chris@bingosnet.co.uk|CPAN-WWW-Testers-Generator|0.25|i386-netbsd-thread-multi-64int|5.8.6|netbsd|3.1|200808292356
2109490|pass|200808|chris@bingosnet.co.uk|CPAN-WWW-Testers-Generator|0.25|i386-netbsd-thread-multi-64int|5.8.5|netbsd|3.1|200808292355
2109487|pass|200808|chris@bingosnet.co.uk|CPAN-WWW-Testers-Generator|0.25|i386-netbsd-thread-multi-64int|5.8.4|netbsd|3.1|200808292353
2109485|pass|200808|chris@bingosnet.co.uk|CPAN-WWW-Testers-Generator|0.25|i386-netbsd-thread-multi-64int|5.8.3|netbsd|3.1|200808292352
2109483|pass|200808|chris@bingosnet.co.uk|CPAN-WWW-Testers-Generator|0.25|i386-netbsd-thread-multi-64int|5.8.2|netbsd|3.1|200808292351
2109478|pass|200808|chris@bingosnet.co.uk|CPAN-WWW-Testers-Generator|0.25|i386-netbsd-thread-multi-64int|5.8.1|netbsd|3.1|200808292350
2109476|pass|200808|chris@bingosnet.co.uk|CPAN-WWW-Testers-Generator|0.25|i386-netbsd-thread-multi-64int|5.10.0|netbsd|3.1|200808292348
2109462|pass|200808|srezic@cpan.org|CPAN-WWW-Testers-Generator|0.25|i386-freebsd-thread-multi|5.8.8|freebsd|6.1-release|200808300036
2109448|pass|200808|srezic@cpan.org|CPAN-WWW-Testers-Generator|0.25|i386-freebsd|5.10.0|freebsd|6.1-release|200808300031
2109304|pass|200808|srezic@cpan.org|CPAN-WWW-Testers-Generator|0.25|i386-freebsd-thread-multi|5.10.0|freebsd|6.1-release|200808292345
2109194|pass|200808|srezic@cpan.org|CPAN-WWW-Testers-Generator|0.25|i386-freebsd-64int|5.8.8|freebsd|6.1-release|200808292305
2109078|pass|200808|srezic@cpan.org|CPAN-WWW-Testers-Generator|0.25|i386-freebsd|5.6.2|freebsd|6.1-release|200808292219
2106482|pass|200808|rick@jrmyers.net ("Rick Myers")|Test-YAML-Meta|0.11|i686-linux|5.6.2|linux|2.6.24.3|200808290657
2106471|cpan|200808|BARBIE|CPAN-WWW-Testers-Generator|0.25||0|||200808291251
2105277|pass|200808|rick@jrmyers.net ("Rick Myers")|Test-YAML-Meta|0.11|i686-linux|5.10.0|linux|2.6.24.3|200808290322
2102387|pass|200808|chris@bingosnet.co.uk|Data-Phrasebook-Loader-YAML|0.09|i386-freebsd-thread-multi-64int|5.10.0 patch 34161|freebsd|7.0-release|200808282035
2102378|pass|200808|chris@bingosnet.co.uk|Data-Phrasebook|0.29|i386-freebsd-thread-multi-64int|5.10.0 patch 34161|freebsd|7.0-release|200808282034
2102108|pass|200808|chris@bingosnet.co.uk|Data-Phrasebook-Loader-YAML|0.09|i386-freebsd-thread-multi|5.11.0 patch 34233|freebsd|7.0-release|200808282001
2102103|pass|200808|chris@bingosnet.co.uk|Data-Phrasebook|0.29|i386-freebsd-thread-multi|5.11.0 patch 34233|freebsd|7.0-release|200808282000
2101905|pass|200808|chris@bingosnet.co.uk|Data-Phrasebook-Loader-YAML|0.09|i386-dragonfly-thread-multi-64int|5.8.8 patch 34096|dragonfly|2.0.0-release|200808282300
2101902|pass|200808|chris@bingosnet.co.uk|Data-Phrasebook|0.29|i386-dragonfly-thread-multi-64int|5.8.8 patch 34096|dragonfly|2.0.0-release|200808282300
2099624|pass|200808|chris@bingosnet.co.uk|Data-Phrasebook-Loader-YAML|0.09|i386-freebsd-64int|5.10.0|freebsd|7.0-release|200808281243
2099618|pass|200808|chris@bingosnet.co.uk|Data-Phrasebook|0.29|i386-freebsd-64int|5.10.0|freebsd|7.0-release|200808281242
2099088|pass|200808|cpan@herlpacker.co.uk|Data-Phrasebook|0.29|i486-linux-gnu|5.8.8|linux|2.6.15.7|200808281008
2098476|pass|200808|chris@bingosnet.co.uk|Data-Phrasebook-Loader-YAML|0.09|i386-dragonfly-64int|5.11.0 patch 34233|dragonfly|2.0.0-release|200808281245
2098463|pass|200808|chris@bingosnet.co.uk|Data-Phrasebook|0.29|i386-dragonfly-64int|5.11.0 patch 34233|dragonfly|2.0.0-release|200808281244
2098435|pass|200808|cpan@herlpacker.co.uk|Data-Phrasebook-Loader-YAML|0.09|i486-linux-gnu|5.8.8|linux|2.6.15.7|200808281008
2097810|pass|200808|chris@bingosnet.co.uk|Data-Phrasebook-Loader-YAML|0.09|i386-dragonfly-thread-multi-64int|5.10.0 patch 34161|dragonfly|2.0.0-release|200808280910
2097807|pass|200808|chris@bingosnet.co.uk|Data-Phrasebook|0.29|i386-dragonfly-thread-multi-64int|5.10.0 patch 34161|dragonfly|2.0.0-release|200808280909
2097359|pass|200808|rick@jrmyers.net ("Rick Myers")|CPAN-YACSmoke-Plugin-Outlook|0.06|i686-linux|5.6.2|linux|2.6.24.3|200808280045
2096441|fail|200808|stro@cpan.org|WWW-UsePerl-Journal-Thread|0.10|i686-linux|5.10.0|linux|2.4.27-2-386|200808280143
2096437|pass|200808|stro@cpan.org|WWW-UsePerl-Journal|0.21|i686-linux|5.10.0|linux|2.4.27-2-386|200808280143
2095937|pass|200808|rick@jrmyers.net ("Rick Myers")|Calendar-List|0.21|i686-linux|5.10.0|linux|2.6.24.3|200808271619
2095809|pass|200808|rick@jrmyers.net ("Rick Myers")|Calendar-List|0.21|i686-linux|5.8.8|linux|2.6.24.3|200808271547
2095603|pass|200808|rick@jrmyers.net ("Rick Myers")|CPAN-YACSmoke-Plugin-WebList|0.05|i686-linux|5.10.0|linux|2.6.24.3|200808271440
2095591|pass|200808|rick@jrmyers.net ("Rick Myers")|CPAN-YACSmoke-Plugin-Outlook|0.06|i686-linux|5.10.0|linux|2.6.24.3|200808271438
2095587|pass|200808|rick@jrmyers.net ("Rick Myers")|CPAN-YACSmoke-Plugin-NNTPWeb|0.06|i686-linux|5.10.0|linux|2.6.24.3|200808271436
2095567|pass|200808|rick@jrmyers.net ("Rick Myers")|CPAN-YACSmoke-Plugin-NNTP|0.05|i686-linux|5.10.0|linux|2.6.24.3|200808271434
2095556|pass|200808|rick@jrmyers.net ("Rick Myers")|CPAN-WWW-Testers-Generator|0.24|i686-linux|5.10.0|linux|2.6.24.3|200808271433
2095555|pass|200808|rick@jrmyers.net ("Rick Myers")|CPAN-YACSmoke-Plugin-WebList|0.05|i686-linux|5.8.8|linux|2.6.24.3|200808271433
2095536|pass|200808|rick@jrmyers.net ("Rick Myers")|CPAN-YACSmoke-Plugin-NNTPWeb|0.06|i686-linux|5.8.8|linux|2.6.24.3|200808271419
2095528|pass|200808|rick@jrmyers.net ("Rick Myers")|CPAN-YACSmoke-Plugin-Outlook|0.06|i686-linux|5.8.8|linux|2.6.24.3|200808271424
2095506|pass|200808|rick@jrmyers.net ("Rick Myers")|CPAN-YACSmoke-Plugin-NNTP|0.05|i686-linux|5.8.8|linux|2.6.24.3|200808271412
2095493|pass|200808|rick@jrmyers.net ("Rick Myers")|CPAN-WWW-Testers-Generator|0.24|i686-linux|5.8.8|linux|2.6.24.3|200808271408
2095064|pass|200808|rick@jrmyers.net ("Rick Myers")|Finance-Currency-Convert-XE|0.15|i686-linux|5.10.0|linux|2.6.24.3|200808270805
2093572|fail|200808|stro@cpan.org|WWW-Scraper-ISBN-Yahoo_Driver|0.07|i686-linux|5.10.0|linux|2.4.27-2-386|200808271137
2093530|pass|200808|stro@cpan.org|WWW-Scraper-ISBN-Pearson_Driver|0.10|i686-linux|5.10.0|linux|2.4.27-2-386|200808271131
2093529|pass|200808|stro@cpan.org|WWW-Scraper-ISBN-ORA_Driver|0.09|i686-linux|5.10.0|linux|2.4.27-2-386|200808271131
2093522|fail|200808|stro@cpan.org|WWW-Scraper-ISBN-Amazon_Driver|0.13|i686-linux|5.10.0|linux|2.4.27-2-386|200808271129
2093045|pass|200808|david@cantrell.org.uk|CPAN-WWW-Testers-Generator|0.24|i686-linux-thread-multi|5.10.0|linux|2.4.27-3-686|200808271153
2093036|fail|200808|david@cantrell.org.uk|CPAN-WWW-Testers-Generator|0.23|i686-linux-thread-multi|5.10.0|linux|2.4.27-3-686|200808271151
2092376|pass|200808|chris@bingosnet.co.uk|Data-Phrasebook-Loader-YAML|0.09|i386-netbsd-thread-multi-64int|5.8.8|netbsd|4.0|200808270736
2092369|pass|200808|chris@bingosnet.co.uk|Data-Phrasebook|0.29|i386-netbsd-thread-multi-64int|5.8.8|netbsd|4.0|200808270735
2092266|pass|200808|chris@bingosnet.co.uk|Data-Phrasebook-Loader-YAML|0.09|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0|200808270713
2092265|pass|200808|chris@bingosnet.co.uk|Data-Phrasebook|0.29|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0|200808270712
2092152|pass|200808|chris@bingosnet.co.uk|Data-Phrasebook-Loader-YAML|0.09|i386-netbsd-thread-multi-64int|5.11.0 patch 34225|netbsd|4.0|200808270641
2092145|pass|200808|chris@bingosnet.co.uk|Data-Phrasebook|0.29|i386-netbsd-thread-multi-64int|5.11.0 patch 34225|netbsd|4.0|200808270640
2092059|pass|200808|chris@bingosnet.co.uk|Data-Phrasebook-Loader-YAML|0.09|i386-dragonfly-thread-multi-64int|5.8.8|dragonfly|2.0.0-release|200808270647
2092057|pass|200808|chris@bingosnet.co.uk|Data-Phrasebook|0.29|i386-dragonfly-thread-multi-64int|5.8.8|dragonfly|2.0.0-release|200808270646
2092035|pass|200808|chris@bingosnet.co.uk|Data-Phrasebook-Loader-YAML|0.09|i386-dragonfly-thread-multi-64int|5.10.0|dragonfly|2.0.0-release|200808270637
2092032|pass|200808|chris@bingosnet.co.uk|Data-Phrasebook|0.29|i386-dragonfly-thread-multi-64int|5.10.0|dragonfly|2.0.0-release|200808270636
2089310|pass|200808|chris@bingosnet.co.uk|CPAN-WWW-Testers-Generator|0.24|i386-dragonfly-thread-multi-64int|5.10.0|dragonfly|2.0.0-release|200808261930
2089258|pass|200808|chris@bingosnet.co.uk|CPAN-WWW-Testers-Generator|0.24|i386-dragonfly-thread-multi-64int|5.8.8|dragonfly|2.0.0-release|200808261921
2088944|pass|200808|rick@jrmyers.net ("Rick Myers")|Finance-Currency-Convert-XE|0.15|i686-linux|5.8.8|linux|2.6.24.3|200808261302
2088810|pass|200808|david@cantrell.org.uk|CPAN-WWW-Testers-Generator|0.24|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200808261140
2088802|fail|200808|david@cantrell.org.uk|CPAN-WWW-Testers-Generator|0.23|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200808261139
2086234|pass|200808|stro@cpan.org|CPAN-WWW-Testers-Generator|0.24|MSWin32-x86-multi-thread|5.8.8|MSWin32|5.00|200808261244
2086233|pass|200808|stro@cpan.org|CPAN-WWW-Testers-Generator|0.23|MSWin32-x86-multi-thread|5.8.8|MSWin32|5.00|200808261244
2085607|pass|200808|chris@bingosnet.co.uk|Data-Phrasebook-Loader-YAML|0.09|i686-linux-64int-ld|5.8.8 patch 34096|linux|2.6.24-19-generic|200808260447
2085594|pass|200808|chris@bingosnet.co.uk|Data-Phrasebook|0.29|i686-linux-64int-ld|5.8.8 patch 34096|linux|2.6.24-19-generic|200808260447
2084491|pass|200808|david@cantrell.org.uk|CPAN-WWW-Testers-Generator|0.24|IP35-irix-64int|5.8.8|irix|6.5|200808260056
2083458|pass|200808|chris@bingosnet.co.uk|Data-Phrasebook-Loader-YAML|0.09|i686-linux-64int-ld|5.10.0 patch 34161|linux|2.6.24-19-generic|200808251732
2083456|pass|200808|chris@bingosnet.co.uk|Data-Phrasebook|0.29|i686-linux-64int-ld|5.10.0 patch 34161|linux|2.6.24-19-generic|200808251732
2083226|pass|200808|david@cantrell.org.uk|CPAN-WWW-Testers-Generator|0.24|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200808251511
2083223|fail|200808|david@cantrell.org.uk|CPAN-WWW-Testers-Generator|0.23|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200808251509
2081519|pass|200808|chris@bingosnet.co.uk|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi-ld|5.11.0 patch 34225|linux|2.6.24-19-generic|200808250618
2081518|pass|200808|chris@bingosnet.co.uk|Data-Phrasebook|0.29|i686-linux-thread-multi-ld|5.11.0 patch 34225|linux|2.6.24-19-generic|200808250618
2081259|pass|200808|chris@bingosnet.co.uk|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-19-generic|200808250448
2081257|pass|200808|chris@bingosnet.co.uk|Data-Phrasebook|0.29|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-19-generic|200808250448
2081031|pass|200808|rick@jrmyers.net ("Rick Myers")|Test-YAML-Meta|0.11|i686-linux|5.8.8|linux|2.6.24.3|200808250235
2080488|pass|200808|chris@bingosnet.co.uk|Data-Phrasebook-Loader-YAML|0.09|OpenBSD.i386-openbsd-64int|5.11.0 patch 34218|openbsd|4.2|200808250046
2080487|pass|200808|chris@bingosnet.co.uk|Data-Phrasebook|0.29|OpenBSD.i386-openbsd-64int|5.11.0 patch 34218|openbsd|4.2|200808250045
2077086|pass|200808|srezic@cpan.org|Finance-Currency-Convert-XE|0.15|i386-freebsd-thread-multi|5.8.8|freebsd|6.1-release|200808241006
2072369|pass|200808|chris@bingosnet.co.uk|Data-Phrasebook-Loader-YAML|0.09|i386-netbsd-thread-multi-64int|5.8.7|netbsd|3.1|200808231858
2072367|pass|200808|chris@bingosnet.co.uk|Data-Phrasebook|0.29|i386-netbsd-thread-multi-64int|5.8.7|netbsd|3.1|200808231858
2072366|pass|200808|chris@bingosnet.co.uk|CPAN-WWW-Testers-Generator|0.24|i386-freebsd-64int|5.10.0|freebsd|7.0-release|200808231748
2072364|pass|200808|chris@bingosnet.co.uk|Data-Phrasebook-Loader-YAML|0.09|i386-netbsd-thread-multi-64int|5.8.6|netbsd|3.1|200808231857
2072360|pass|200808|chris@bingosnet.co.uk|Data-Phrasebook|0.29|i386-netbsd-thread-multi-64int|5.8.6|netbsd|3.1|200808231857
2072351|pass|200808|chris@bingosnet.co.uk|Data-Phrasebook-Loader-YAML|0.09|i386-netbsd-thread-multi-64int|5.8.5|netbsd|3.1|200808231855
2072350|pass|200808|chris@bingosnet.co.uk|Data-Phrasebook|0.29|i386-netbsd-thread-multi-64int|5.8.5|netbsd|3.1|200808231855
2072339|pass|200808|chris@bingosnet.co.uk|Data-Phrasebook-Loader-YAML|0.09|i386-netbsd-thread-multi-64int|5.8.4|netbsd|3.1|200808231854
2072337|pass|200808|chris@bingosnet.co.uk|Data-Phrasebook|0.29|i386-netbsd-thread-multi-64int|5.8.4|netbsd|3.1|200808231854
2072333|pass|200808|chris@bingosnet.co.uk|Data-Phrasebook-Loader-YAML|0.09|i386-netbsd-thread-multi-64int|5.8.3|netbsd|3.1|200808231852
2072327|pass|200808|chris@bingosnet.co.uk|Data-Phrasebook|0.29|i386-netbsd-thread-multi-64int|5.8.3|netbsd|3.1|200808231852
2072320|pass|200808|chris@bingosnet.co.uk|Data-Phrasebook-Loader-YAML|0.09|i386-netbsd-thread-multi-64int|5.8.2|netbsd|3.1|200808231851
2072317|pass|200808|chris@bingosnet.co.uk|Data-Phrasebook|0.29|i386-netbsd-thread-multi-64int|5.8.2|netbsd|3.1|200808231851
2072303|pass|200808|chris@bingosnet.co.uk|Data-Phrasebook-Loader-YAML|0.09|i386-netbsd-thread-multi-64int|5.8.1|netbsd|3.1|200808231849
2072302|pass|200808|chris@bingosnet.co.uk|Data-Phrasebook|0.29|i386-netbsd-thread-multi-64int|5.8.1|netbsd|3.1|200808231849
2072290|pass|200808|chris@bingosnet.co.uk|Data-Phrasebook|0.29|i386-netbsd-thread-multi-64int|5.6.2|netbsd|3.1|200808231848
2072282|pass|200808|chris@bingosnet.co.uk|Data-Phrasebook-Loader-YAML|0.09|i386-netbsd-thread-multi-64int|5.10.0|netbsd|3.1|200808231847
2072276|pass|200808|chris@bingosnet.co.uk|Data-Phrasebook|0.29|i386-netbsd-thread-multi-64int|5.10.0|netbsd|3.1|200808231846
2069911|pass|200808|david@cantrell.org.uk|CPAN-WWW-Testers-Generator|0.24|i686-linux|5.8.8|linux|2.4.27-3-686|200808222302
2069908|pass|200808|david@cantrell.org.uk|CPAN-WWW-Testers-Generator|0.23|i686-linux|5.8.8|linux|2.4.27-3-686|200808222302
2068374|pass|200808|stro@cpan.org|CPAN-WWW-Testers-Generator|0.24|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.00|200808221840
2068372|pass|200808|stro@cpan.org|CPAN-WWW-Testers-Generator|0.23|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.00|200808221840
2066816|pass|200808|srezic@cpan.org|CPAN-WWW-Testers-Generator|0.24|i386-freebsd|5.10.0|freebsd|6.1-release|200808220749
2066159|pass|200808|chris@bingosnet.co.uk|Test-YAML-Meta|0.11|i686-linux-thread-multi-64int-ld|5.11.0 patch 34212|linux|2.6.21.5-smp|200808220100
2065567|pass|200808|chris@bingosnet.co.uk|Test-YAML-Meta|0.11|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.21.5-smp|200808212030
2065222|pass|200808|chris@bingosnet.co.uk|CPAN-WWW-Testers-Generator|0.24|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.21.5-smp|200808211940
2065151|pass|200808|chris@bingosnet.co.uk|CPAN-WWW-Testers-Generator|0.24|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.21.5-smp|200808211931
2064205|pass|200808|chris@bingosnet.co.uk|Test-YAML-Meta|0.11|i386-netbsd-thread-multi-64int|5.10.0 patch 34161|netbsd|4.0|200808211509
2063863|pass|200808|gabor@pti.co.il ("Gabor Szabo")|Test-YAML-Meta|0.11|i486-linux-gnu|5.8.8|linux|2.6.15.7|200808211610
2063152|pass|200808|chris@bingosnet.co.uk|Test-YAML-Meta|0.11|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0|200808211138
2062795|pass|200808|chris@bingosnet.co.uk|CPAN-WWW-Testers-Generator|0.24|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0|200808211100
2060294|pass|200808|srezic@cpan.org|Finance-Currency-Convert-XE|0.15|i386-freebsd-thread-multi|5.10.0|freebsd|6.1-release|200808210033
2058699|pass|200808|david@cantrell.org.uk|CPAN-WWW-Testers-Generator|0.24|alpha-netbsd|5.10.0|netbsd|2.1.0_stable|200808201703
2058693|fail|200808|david@cantrell.org.uk|CPAN-WWW-Testers-Generator|0.23|alpha-netbsd|5.10.0|netbsd|2.1.0_stable|200808201703
2058475|pass|200808|david@cantrell.org.uk|CPAN-WWW-Testers-Generator|0.24|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200808201732
2058470|fail|200808|david@cantrell.org.uk|CPAN-WWW-Testers-Generator|0.23|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200808201731
2057887|fail|200808|shlomif@cpan.org|CPAN-WWW-Testers-Generator|0.23|i686-linux|5.10.0|linux|2.6.26.2-desktop-2mnb|200808191841
2057442|pass|200808|chris@bingosnet.co.uk|Test-YAML-Meta|0.11|i86pc-solaris-thread-multi-64int|5.10.0 patch 34161|solaris|2.10|200808201231
2057388|pass|200808|chris@bingosnet.co.uk|Test-YAML-Meta|0.11|i386-freebsd-thread-multi-64int|5.10.0|freebsd|6.2-release|200808201105
2057042|pass|200808|chris@bingosnet.co.uk|CPAN-WWW-Testers-Generator|0.24|i386-freebsd-thread-multi-64int|5.10.0|freebsd|6.2-release|200808201020
2057037|pass|200808|chris@bingosnet.co.uk|CPAN-WWW-Testers-Generator|0.24|i386-freebsd-thread-multi-64int|5.8.8|freebsd|6.2-release|200808201019
2056635|pass|200808|shlomif@cpan.org|Test-YAML-Meta|0.11|i686-linux|5.10.0|linux|2.6.26.2-desktop-2mnb|200808192004
2056441|pass|200808|imacat@mail.imacat.idv.tw|CPAN-WWW-Testers-Generator|0.24|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.22.10|200808201614
2054515|pass|200808|chris@bingosnet.co.uk|CPAN-WWW-Testers-Generator|0.24|i386-netbsd-thread-multi-64int|5.8.8|netbsd|3.1|200808192233
2054512|pass|200808|chris@bingosnet.co.uk|CPAN-WWW-Testers-Generator|0.24|i386-netbsd-thread-multi-64int|5.8.7|netbsd|3.1|200808192232
2054490|pass|200808|chris@bingosnet.co.uk|CPAN-WWW-Testers-Generator|0.24|i386-netbsd-thread-multi-64int|5.8.4|netbsd|3.1|200808192228
2054488|pass|200808|chris@bingosnet.co.uk|CPAN-WWW-Testers-Generator|0.24|i386-netbsd-thread-multi-64int|5.8.6|netbsd|3.1|200808192231
2054487|pass|200808|chris@bingosnet.co.uk|CPAN-WWW-Testers-Generator|0.24|i386-netbsd-thread-multi-64int|5.8.5|netbsd|3.1|200808192230
2054475|pass|200808|chris@bingosnet.co.uk|CPAN-WWW-Testers-Generator|0.24|i386-netbsd-thread-multi-64int|5.8.3|netbsd|3.1|200808192227
2054457|pass|200808|chris@bingosnet.co.uk|CPAN-WWW-Testers-Generator|0.24|i386-netbsd-thread-multi-64int|5.8.2|netbsd|3.1|200808192226
2054451|pass|200808|chris@bingosnet.co.uk|CPAN-WWW-Testers-Generator|0.24|i386-netbsd-thread-multi-64int|5.8.1|netbsd|3.1|200808192225
2054446|pass|200808|chris@bingosnet.co.uk|CPAN-WWW-Testers-Generator|0.24|i386-netbsd-thread-multi-64int|5.10.0|netbsd|3.1|200808192223
2053988|pass|200808|chris@bingosnet.co.uk|Test-YAML-Meta|0.11|i86pc-solaris-thread-multi-64int|5.10.0|solaris|2.10|200808192049
2053935|pass|200808|srezic@cpan.org|CPAN-WWW-Testers-Generator|0.24|i386-freebsd|5.8.8 patch 33662|freebsd|6.1-release-p23|200808192128
2051753|pass|200808|srezic@cpan.org|CPAN-WWW-Testers-Generator|0.23|i386-freebsd|5.8.8 patch 33662|freebsd|6.1-release-p23|200808191446
2051686|pass|200808|JOST@cpan.org ("Josts Smokehouse")|CPAN-WWW-Testers-Generator|0.23|i86pc-solaris-64int|5.10.0|solaris|2.11|200808191436
2050939|cpan|200808|BARBIE|CPAN-WWW-Testers-Generator|0.24||0|||200808191231
2050781|fail|200808|srezic@cpan.org|CPAN-WWW-Testers-Generator|0.23|i386-freebsd|5.6.2|freebsd|6.1-release|200808191134
2050752|pass|200808|JOST@cpan.org ("Josts Smokehouse")|Calendar-List|0.21|i86pc-solaris-64int|5.10.0|solaris|2.11|200808190213
2049987|pass|200808|JOST@cpan.org ("Josts Smokehouse")|Test-CPAN-Meta|0.12|i86pc-solaris-64int|5.10.0|solaris|2.11|200808181926
2049321|pass|200808|JOST@cpan.org ("Josts Smokehouse")|Games-Trackword|1.06|i86pc-solaris-64int|5.10.0|solaris|2.11|200808190214
2048497|pass|200808|srezic@cpan.org|CPAN-WWW-Testers-Generator|0.23|i386-freebsd-64int|5.8.8|freebsd|6.1-release|200808190736
2047910|pass|200808|chris@bingosnet.co.uk|Test-YAML-Meta|0.11|OpenBSD.i386-openbsd-thread-multi-64int|5.10.0|openbsd|4.1|200808190128
2047558|fail|200808|chris@bingosnet.co.uk|CPAN-WWW-Testers-Generator|0.23|i386-netbsd-thread-multi-64int|5.8.8|netbsd|3.1|200808182246
2045819|pass|200808|stro@cpan.org|Test-CPAN-Meta|0.12|i686-linux|5.10.0|linux|2.4.27-2-386|200808181541
2045778|pass|200808|chris@bingosnet.co.uk|Test-YAML-Meta|0.11|OpenBSD.i386-openbsd-thread-multi-64int|5.10.0 patch 34161|openbsd|4.3|200808181747
2045247|pass|200808|srezic@cpan.org|CPAN-WWW-Testers-Generator|0.23|i386-freebsd|5.10.0|freebsd|6.1-release|200808181802
2045017|fail|200808|srezic@cpan.org|CPAN-WWW-Testers-Generator|0.22|i386-freebsd-64int|5.8.8|freebsd|6.1-release|200808181711
2044382|cpan|200808|BARBIE|CPAN-WWW-Testers-Generator|0.23||0|||200808181624
2044069|pass|200808|chris@bingosnet.co.uk|Test-YAML-Meta|0.11|OpenBSD.i386-openbsd-thread-multi-64int|5.10.0|openbsd|4.3|200808181430
2041067|pass|200808|chris@bingosnet.co.uk|Test-YAML-Meta|0.11|i686-linux|5.11.0 patch 34204|linux|2.6.16.38|200808180040
2036762|pass|200808|chris@bingosnet.co.uk|Test-YAML-Meta|0.11|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.16.38|200808170231
2036543|pass|200808|chris@bingosnet.co.uk|Test-YAML-Meta|0.11|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.16.38|200808170055
2035785|pass|200808|srezic@cpan.org|Test-YAML-Meta|0.11|cygwin-thread-multi-64int|5.8.8|cygwin|1.5.24(0.15642)|200808162050
2035316|pass|200808|rick@jrmyers.net ("Rick Myers")|Data-Phrasebook-Loader-YAML|0.09|i686-linux|5.8.8|linux|2.6.24.3|200808161308
2035315|pass|200808|rick@jrmyers.net ("Rick Myers")|Data-Phrasebook|0.29|i686-linux|5.8.8|linux|2.6.24.3|200808161308
2034996|fail|200808|srezic@cpan.org|CPAN-WWW-Testers-Generator|0.22|i386-freebsd|5.10.0|freebsd|6.1-release|200808161754
2032426|pass|200808|rafl@debian.org|Test-YAML-Meta|0.11|x86_64-linux|5.10.0|linux|2.6.18-6-xen-amd64|200808151104
2032015|pass|200808|skendric@fhcrc.org|Test-YAML-Meta|0.11|i686-linux-thread-multi|5.8.8|linux|2.6.18-53.1.13.el5|200808150739
2030960|pass|200808|Jost.Krieger+smokeback@ruhr-uni-bochum.de ("Josts Smokehouse")|Data-Phrasebook-Loader-YAML|0.09|i86pc-solaris-64int|5.10.0|solaris|2.11|200808152211
2030959|pass|200808|Jost.Krieger+smokeback@ruhr-uni-bochum.de ("Josts Smokehouse")|Data-Phrasebook|0.29|i86pc-solaris-64int|5.10.0|solaris|2.11|200808152211
2027218|pass|200808|chris@bingosnet.co.uk|Test-YAML-Meta|0.11|darwin-thread-multi-64int-2level|5.8.8|darwin|8.10.0|200808141413
2027176|pass|200808|chris@bingosnet.co.uk|Test-YAML-Meta|0.11|darwin-thread-multi-64int-2level|5.10.0|darwin|8.10.0|200808141358
2027128|pass|200808|mmlange@cpan.org (Matthew Lange)|Data-Phrasebook-Loader-YAML|0.09|x86_64-linux|5.8.8|linux|2.6.24-gentoo-r3|200808140049
2027074|pass|200808|Jost.Krieger+smokeback@ruhr-uni-bochum.de ("Josts Smokehouse")|Test-YAML-Meta|0.11|i86pc-solaris-64int|5.10.0|solaris|2.11|200808141432
2026875|pass|200808|mmlange@cpan.org (Matthew Lange)|Data-Phrasebook|0.29|x86_64-linux|5.8.8|linux|2.6.24-gentoo-r3|200808140049
2026520|pass|200808|stro@cpan.org|Data-Phrasebook-Loader-YAML|0.09|armv5tejl-linux|5.8.8|linux|2.6.17.14|200808141251
2026509|pass|200808|stro@cpan.org|Data-Phrasebook-Loader-YAML|0.09|armv5tejl-linux|5.10.0|linux|2.6.17.14|200808141247
2026434|pass|200808|stro@cpan.org|Data-Phrasebook-Loader-Ini|0.10|armv5tejl-linux|5.8.8|linux|2.6.17.14|200808141231
2026423|pass|200808|stro@cpan.org|Data-Phrasebook-Loader-Ini|0.10|armv5tejl-linux|5.10.0|linux|2.6.17.14|200808141228
2026413|pass|200808|stro@cpan.org|Data-Phrasebook-Loader-DBI|0.11|armv5tejl-linux|5.8.8|linux|2.6.17.14|200808141224
2026402|pass|200808|stro@cpan.org|Data-Phrasebook-Loader-DBI|0.11|armv5tejl-linux|5.10.0|linux|2.6.17.14|200808141222
2026365|pass|200808|stro@cpan.org|Data-Phrasebook|0.29|armv5tejl-linux|5.8.8|linux|2.6.17.14|200808141216
2026342|pass|200808|stro@cpan.org|Data-Phrasebook|0.29|armv5tejl-linux|5.10.0|linux|2.6.17.14|200808141213
2024763|pass|200808|stro@cpan.org|Data-FormValidator-Constraints-Words|0.03|armv5tejl-linux|5.8.8|linux|2.6.17.14|200808132223
2024761|pass|200808|stro@cpan.org|Data-FormValidator-Constraints-Words|0.03|armv5tejl-linux|5.10.0|linux|2.6.17.14|200808132220
2021010|pass|200808|Pascal@Rockford.Com|Test-YAML-Meta|0.11|i386-linux|5.8.8|linux|2.6.18-53.1.19.el5xen|200808120329
2019709|pass|200808|Jost.Krieger+smokeback@ruhr-uni-bochum.de ("Josts Smokehouse")|Games-Trackword|1.06|i86pc-solaris|5.10.0|solaris|2.11|200808120916
2019655|pass|200808|Jost.Krieger+smokeback@ruhr-uni-bochum.de ("Josts Smokehouse")|Data-Phrasebook-Loader-YAML|0.09|i86pc-solaris|5.10.0|solaris|2.11|200808120908
2018237|pass|200808|Jost.Krieger+smokeback@ruhr-uni-bochum.de ("Josts Smokehouse")|Test-YAML-Meta|0.11|i86pc-solaris|5.10.0|solaris|2.11|200808120037
2018236|pass|200808|Jost.Krieger+smokeback@ruhr-uni-bochum.de ("Josts Smokehouse")|Test-CPAN-Meta|0.12|i86pc-solaris|5.10.0|solaris|2.11|200808120037
2016705|pass|200808|Jost.Krieger+smokeback@ruhr-uni-bochum.de ("Josts Smokehouse")|Data-Phrasebook|0.29|i86pc-solaris|5.10.0|solaris|2.11|200808111504
2015837|pass|200808|rick@jrmyers.net|Test-YAML-Meta|0.11|i686-linux|5.10.0|linux|2.6.24.3|200808110140
2014239|pass|200808|chris@bingosnet.co.uk|Test-YAML-Meta|0.11|i386-netbsd-thread-multi-64int|5.8.7|netbsd|3.1|200808102142
2014197|pass|200808|chris@bingosnet.co.uk|Test-YAML-Meta|0.11|i386-netbsd-thread-multi-64int|5.8.6|netbsd|3.1|200808102126
2014155|pass|200808|chris@bingosnet.co.uk|Test-YAML-Meta|0.11|i386-netbsd-thread-multi-64int|5.8.5|netbsd|3.1|200808102110
2014075|pass|200808|chris@bingosnet.co.uk|Test-YAML-Meta|0.11|i386-netbsd-thread-multi-64int|5.8.4|netbsd|3.1|200808102035
2014033|pass|200808|chris@bingosnet.co.uk|Test-YAML-Meta|0.11|i386-netbsd-thread-multi-64int|5.8.3|netbsd|3.1|200808102019
2013975|pass|200808|chris@bingosnet.co.uk|Test-YAML-Meta|0.11|i386-netbsd-thread-multi-64int|5.10.0|netbsd|3.1|200808101953
1999312|pass|200808|stro@cpan.org|Regexp-Log-Common|0.05|i686-linux|5.10.0|linux|2.4.27-2-386|200808071706
1974799|pass|200808|chris@bingosnet.co.uk|Test-YAML-Meta|0.11|i686-linux|5.8.8|linux|2.6.16.38|200808020952
1950838|pass|200807|yanick@cpan.org ("Yanick Champoux")|Test-YAML-Meta|0.11|i686-linux|5.10.0|linux|2.6.22-gentoo-r2enkidu|200807261442
1948782|pass|200807|conrad@fringehead.org|Test-YAML-Meta|0.11|darwin-2level|5.10.0|darwin|9.3.0|200807270006
1945904|pass|200807|chris@bingosnet.co.uk|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.21.5-smp|200807260823
1945903|pass|200807|chris@bingosnet.co.uk|Data-Phrasebook|0.29|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.21.5-smp|200807260823
1945659|pass|200807|chris@bingosnet.co.uk|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.21.5-smp|200807260735
1945656|pass|200807|chris@bingosnet.co.uk|Data-Phrasebook|0.29|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.21.5-smp|200807260734
1944878|pass|200807|chris@bingosnet.co.uk|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi-64int-ld|5.11.0 patch 34156|linux|2.6.21.5-smp|200807260334
1944876|pass|200807|chris@bingosnet.co.uk|Data-Phrasebook|0.29|i686-linux-thread-multi-64int-ld|5.11.0 patch 34156|linux|2.6.21.5-smp|200807260333
1942761|pass|200807|stro@cpan.org|Calendar-List|0.21|armv5tejl-linux|5.8.8|linux|2.6.17.14|200807252107
1942753|pass|200807|stro@cpan.org|Calendar-List|0.21|armv5tejl-linux|5.10.0|linux|2.6.17.14|200807252102
1940574|pass|200807|chris@bingosnet.co.uk|Data-Phrasebook-Loader-YAML|0.09|i386-freebsd-64int|5.11.0 patch 34156|freebsd|7.0-release|200807250000
1940572|pass|200807|chris@bingosnet.co.uk|Data-Phrasebook|0.29|i386-freebsd-64int|5.11.0 patch 34156|freebsd|7.0-release|200807250000
1940356|pass|200807|chris@bingosnet.co.uk|Data-Phrasebook-Loader-YAML|0.09|i386-freebsd-64int|5.10.0|freebsd|7.0-release|200807250205
1940353|pass|200807|chris@bingosnet.co.uk|Data-Phrasebook|0.29|i386-freebsd-64int|5.10.0|freebsd|7.0-release|200807250204
1940334|pass|200807|chris@bingosnet.co.uk|Data-Phrasebook-Loader-YAML|0.09|i386-freebsd-thread-multi-64int|5.8.8|freebsd|6.2-release|200807250056
1940330|pass|200807|chris@bingosnet.co.uk|Data-Phrasebook|0.29|i386-freebsd-thread-multi-64int|5.8.8|freebsd|6.2-release|200807250056
1940261|pass|200807|chris@bingosnet.co.uk|Data-Phrasebook-Loader-YAML|0.09|i386-freebsd-thread-multi-64int|5.10.0|freebsd|6.2-release|200807250039
1940257|pass|200807|chris@bingosnet.co.uk|Data-Phrasebook|0.29|i386-freebsd-thread-multi-64int|5.10.0|freebsd|6.2-release|200807250039
1938884|pass|200807|chris@bingosnet.co.uk|Data-Phrasebook-Loader-YAML|0.09|i386-freebsd-thread-multi|5.11.0 patch 34156|freebsd|6.2-release|200807242026
1938875|pass|200807|chris@bingosnet.co.uk|Data-Phrasebook|0.29|i386-freebsd-thread-multi|5.11.0 patch 34156|freebsd|6.2-release|200807242025
1937840|pass|200807|Pascal@Rockford.Com|Test-YAML-Meta|0.11|i386-linux|5.8.8|linux|2.6.18-53.1.19.el5xen|200807241201
1934282|pass|200807|chris@bingosnet.co.uk|Data-Phrasebook-Loader-YAML|0.09|OpenBSD.i386-openbsd-thread-multi|5.8.8|openbsd|4.1|200807232307
1934280|pass|200807|chris@bingosnet.co.uk|Data-Phrasebook|0.29|OpenBSD.i386-openbsd-thread-multi|5.8.8|openbsd|4.1|200807232306
1933856|pass|200807|chris@bingosnet.co.uk|Data-Phrasebook-Loader-YAML|0.09|OpenBSD.i386-openbsd-thread-multi-64int|5.10.0|openbsd|4.1|200807232013
1933853|pass|200807|chris@bingosnet.co.uk|Data-Phrasebook|0.29|OpenBSD.i386-openbsd-thread-multi-64int|5.10.0|openbsd|4.1|200807232012
1933736|pass|200807|chris@bingosnet.co.uk|Data-Phrasebook-Loader-YAML|0.09|OpenBSD.i386-openbsd-64int|5.11.0 patch 34153|openbsd|4.1|200807231854
1933733|pass|200807|chris@bingosnet.co.uk|Data-Phrasebook|0.29|OpenBSD.i386-openbsd-64int|5.11.0 patch 34153|openbsd|4.1|200807231853
1930997|pass|200807|chris@bingosnet.co.uk|Test-YAML-Meta|0.11|darwin-thread-multi-64int-2level|5.10.0 patch 34095|darwin|8.10.0|200807230809
1926612|pass|200807|chris@bingosnet.co.uk|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.16.38|200807221644
1926611|pass|200807|chris@bingosnet.co.uk|Data-Phrasebook|0.29|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.16.38|200807221644
1926472|pass|200807|chris@bingosnet.co.uk|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.16.38|200807221555
1926470|pass|200807|chris@bingosnet.co.uk|Data-Phrasebook|0.29|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.16.38|200807221554
1925805|pass|200807|chris@bingosnet.co.uk|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi-ld|5.11.0 patch 34151|linux|2.6.16.38|200807221211
1925801|pass|200807|chris@bingosnet.co.uk|Data-Phrasebook|0.29|i686-linux-thread-multi-ld|5.11.0 patch 34151|linux|2.6.16.38|200807221210
1925619|pass|200807|chris@bingosnet.co.uk|Data-Phrasebook-Loader-YAML|0.09|i86pc-solaris-thread-multi-64int|5.10.0|solaris|2.10|200807221054
1925615|pass|200807|chris@bingosnet.co.uk|Data-Phrasebook|0.29|i86pc-solaris-thread-multi-64int|5.10.0|solaris|2.10|200807221053
1925049|pass|200807|chris@bingosnet.co.uk|Data-Phrasebook-Loader-YAML|0.09|i86pc-solaris-thread-multi-64int|5.11.0 patch 34151|solaris|2.10|200807220751
1925043|pass|200807|chris@bingosnet.co.uk|Data-Phrasebook|0.29|i86pc-solaris-thread-multi-64int|5.11.0 patch 34151|solaris|2.10|200807220748
1923938|pass|200807|chris@bingosnet.co.uk|Data-Phrasebook-Loader-YAML|0.09|darwin-thread-multi-64int-2level|5.8.8|darwin|8.10.0|200807220101
1923933|pass|200807|chris@bingosnet.co.uk|Data-Phrasebook|0.29|darwin-thread-multi-64int-2level|5.8.8|darwin|8.10.0|200807220059
1923898|pass|200807|chris@bingosnet.co.uk|Data-Phrasebook-Loader-YAML|0.09|darwin-thread-multi-64int-2level|5.10.0|darwin|8.10.0|200807220050
1923894|pass|200807|chris@bingosnet.co.uk|Data-Phrasebook|0.29|darwin-thread-multi-64int-2level|5.10.0|darwin|8.10.0|200807220050
1920520|pass|200807|chris@bingosnet.co.uk|Data-Phrasebook|0.29|i86pc-solaris-thread-multi-64int|5.6.2|solaris|2.10|200807210633
1919659|pass|200807|chris@bingosnet.co.uk|Data-Phrasebook-Loader-YAML|0.09|i86pc-solaris-thread-multi-64int|5.10.0|solaris|2.10|200807210131
1919657|pass|200807|chris@bingosnet.co.uk|Data-Phrasebook|0.29|i86pc-solaris-thread-multi-64int|5.10.0|solaris|2.10|200807210131
1919282|pass|200807|chris@bingosnet.co.uk|Data-Phrasebook-Loader-YAML|0.09|i86pc-solaris-thread-multi-64int|5.11.0 patch 34151|solaris|2.10|200807202216
1919279|pass|200807|chris@bingosnet.co.uk|Data-Phrasebook|0.29|i86pc-solaris-thread-multi-64int|5.11.0 patch 34151|solaris|2.10|200807202215
1917094|pass|200807|stro@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i686-linux|5.10.0|linux|2.4.27-2-386|200807200946
1917093|pass|200807|stro@cpan.org|Data-Phrasebook|0.29|i686-linux|5.10.0|linux|2.4.27-2-386|200807200946
1916299|pass|200807|greg@turnstep.com|Test-YAML-Meta|0.11|x86_64-linux|5.8.8|linux|2.6.18-53.1.19.el5xen|200807200253
1913928|pass|200807|david@cantrell.org.uk|Data-Phrasebook-Loader-YAML|0.09|IP35-irix-64int|5.8.8|irix|6.5|200807192217
1913925|pass|200807|david@cantrell.org.uk|Data-Phrasebook|0.29|IP35-irix-64int|5.8.8|irix|6.5|200807192216
1909521|pass|200807|vovkasm@gmail.com|Regexp-Log-Common|0.05|amd64-freebsd|5.10.0|freebsd|6.2-release-p1|200807190202
1909520|pass|200807|vovkasm@gmail.com|Test-YAML-Meta|0.11|amd64-freebsd|5.10.0|freebsd|6.2-release-p1|200807190203
1909349|pass|200807|chris@bingosnet.co.uk|Data-Phrasebook-Loader-YAML|0.09|darwin-thread-multi-64int-2level|5.8.8|darwin|8.10.0|200807182351
1909346|pass|200807|chris@bingosnet.co.uk|Data-Phrasebook|0.29|darwin-thread-multi-64int-2level|5.8.8|darwin|8.10.0|200807182349
1909326|pass|200807|chris@bingosnet.co.uk|Data-Phrasebook|0.29|darwin-thread-multi-64int|5.6.2|darwin|8.10.0|200807182342
1909298|pass|200807|chris@bingosnet.co.uk|Data-Phrasebook-Loader-YAML|0.09|darwin-thread-multi-64int-2level|5.10.0|darwin|8.10.0|200807182334
1909290|pass|200807|chris@bingosnet.co.uk|Data-Phrasebook|0.29|darwin-thread-multi-64int-2level|5.10.0|darwin|8.10.0|200807182332
1898099|pass|200807|chris@bingosnet.co.uk|Test-YAML-Meta|0.11|i386-freebsd-64int|5.10.0|freebsd|7.0-release|200807160841
1898098|pass|200807|chris@bingosnet.co.uk|Test-YAML-Meta|0.11|i386-freebsd-64int|5.11.0 patch 34144|freebsd|7.0-release|200807160840
1895675|fail|200807|srezic@cpan.org|CPAN-YACSmoke-Plugin-NNTPWeb|0.06|i386-freebsd-64int|5.8.8|freebsd|6.1-release|200807152233
1895511|pass|200807|srezic@cpan.org|WWW-Scraper-ISBN-Yahoo_Driver|0.07|i386-freebsd-thread-multi|5.8.8|freebsd|6.1-release|200807152202
1895510|pass|200807|srezic@cpan.org|WWW-Scraper-ISBN-Amazon_Driver|0.13|i386-freebsd-thread-multi|5.8.8|freebsd|6.1-release|200807152202
1894296|pass|200807|chris@bingosnet.co.uk|Test-YAML-Meta|0.11|OpenBSD.i386-openbsd-thread-multi|5.11.0 patch 34134|openbsd|4.2|200807151325
1892246|pass|200807|chris@bingosnet.co.uk|Test-YAML-Meta|0.11|i386-netbsd-64int|5.11.0 patch 34134|netbsd|4.0|200807142147
1891975|pass|200807|chris@bingosnet.co.uk|Test-YAML-Meta|0.11|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0|200807141959
1889384|pass|200807|chris@bingosnet.co.uk|Test-YAML-Meta|0.11|i686-linux-thread-multi-ld|5.11.0 patch 34136|linux|2.6.21.5-smp|200807132117
1887800|pass|200807|chris@bingosnet.co.uk|Test-YAML-Meta|0.11|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.21.5-smp|200807131019
1884463|pass|200807|unimlor@tibo.dk ((unimlor))|Test-YAML-Meta|0.11|i586-linux-thread-multi|5.8.3|linux|2.6.5|200807121055
1884307|pass|200807|chris@bingosnet.co.uk|Test-YAML-Meta|0.11|i86pc-solaris|5.11.0 patch 34131|solaris|2.10|200807121558
1883631|pass|200807|chris@bingosnet.co.uk|Test-YAML-Meta|0.11|i86pc-solaris-thread-multi-64int|5.10.0|solaris|2.10|200807121344
1881738|pass|200807|chris@bingosnet.co.uk|Test-YAML-Meta|0.11|i386-freebsd|5.11.0 patch 34120|freebsd|6.2-release|200807111942
1881689|pass|200807|chris@bingosnet.co.uk|Test-YAML-Meta|0.11|i386-freebsd-thread-multi-64int|5.10.0|freebsd|6.2-release|200807111916
1881293|pass|200807|chris@bingosnet.co.uk|Test-YAML-Meta|0.11|darwin-thread-multi-64int-2level|5.10.0 patch 34095|darwin|8.10.0|200807111759
1880579|fail|200807|srezic@cpan.org|WWW-UsePerl-Journal-Thread|0.10|i386-freebsd|5.8.8 patch 33662|freebsd|6.1-release-p23|200807111552
1878981|pass|200807|chris@bingosnet.co.uk|Test-YAML-Meta|0.11|OpenBSD.i386-openbsd-thread-multi|5.11.0 patch 34117|openbsd|4.3|200807110013
1878908|pass|200807|chris@bingosnet.co.uk|Test-YAML-Meta|0.11|OpenBSD.i386-openbsd-thread-multi-64int|5.10.0|openbsd|4.3|200807110022
1877360|pass|200807|chris@bingosnet.co.uk|Test-YAML-Meta|0.11|OpenBSD.i386-openbsd-thread-multi|5.8.8|openbsd|4.1|200807101548
1874495|pass|200807|chris@bingosnet.co.uk|Test-YAML-Meta|0.11|OpenBSD.i386-openbsd-64int|5.11.0 patch 34114|openbsd|4.1|200807092159
1873407|pass|200807|chris@bingosnet.co.uk|Test-YAML-Meta|0.11|OpenBSD.i386-openbsd-thread-multi-64int|5.10.0|openbsd|4.1|200807091654
1871673|fail|200807|Jost.Krieger+smokeback@ruhr-uni-bochum.de ("Josts Smokehouse")|CPAN-WWW-Testers-Generator|0.22|sun4-solaris|5.10.0|solaris|2.9|200807090412
1870334|pass|200807|mgardner@usatech.com|Test-YAML-Meta|0.11|cygwin-thread-multi-64int|5.10.0 patch 34065|cygwin|1.5.25(0.15642)|200807081529
1869573|pass|200807|chris@bingosnet.co.uk|Test-YAML-Meta|0.11|i686-linux-thread-multi-64int|5.10.0|linux|2.6.23.1-42.fc8|200807081703
1868356|pass|200807|mmlange@cpan.org (Matthew Lange)|Test-YAML-Meta|0.11|x86_64-linux|5.8.8|linux|2.6.24-gentoo-r3|200807080206
1866706|pass|200807|jlmartinez@capside.com|Mail-File|0.08|i386-freebsd|5.8.7|freebsd|6.0-stable|200807071503
1866705|pass|200807|jlmartinez@capside.com|Test-CPAN-Meta|0.12|i386-freebsd|5.8.7|freebsd|6.0-stable|200807071517
1866703|pass|200807|jlmartinez@capside.com|Regexp-Log-Common|0.05|i386-freebsd|5.8.7|freebsd|6.0-stable|200807071512
1866702|pass|200807|jlmartinez@capside.com|GD-Chart-Radial|0.07|i386-freebsd|5.8.7|freebsd|6.0-stable|200807071506
1866570|pass|200807|jlmartinez@capside.com|Calendar-List|0.21|i386-freebsd|5.8.7|freebsd|6.0-stable|200807071501
1866460|pass|200807|jlmartinez@capside.com|Regexp-Log-Common|0.05|i386-freebsd|5.8.7|freebsd|6.0-stable|200807071509
1865855|pass|200807|artur+cpan@niif.spb.su (ARTO)|Test-YAML-Meta|0.11|i386-linux-thread-multi|5.10.0|linux|2.6.18-92.1.6.el5|200807071056
1864552|pass|200807|sanko@cpan.org|Test-CPAN-Meta|0.12|MSWin32-x86-multi-thread|5.11.0 patch 34101|MSWin32|5.1|200807052312
1863824|pass|200807|sanko@cpan.org|Test-YAML-Meta|0.11|MSWin32-x86-multi-thread|5.11.0 patch 34101|MSWin32|5.1|200807052307
1861536|pass|200807|rurban@x-ray.at (Reini Urban laptop)|Test-YAML-Meta|0.11|cygwin-thread-multi-64int|5.10.0 patch 34065|cygwin|1.5.25(0.15642)|200807052344
1861397|pass|200807|chris@bingosnet.co.uk|Test-YAML-Meta|0.11|i386-netbsd-thread-multi-64int|5.8.8|netbsd|3.1|200807052251
1860664|pass|200807|andy@hexten.net|Test-YAML-Meta|0.11|i686-linux-thread-multi|5.10.0|linux|2.6.22-14-generic|200807051909
1860131|pass|200807|dagolden@cpan.org (DAGOLDEN)|Data-FormValidator-Constraints-Words|0.03|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200807051236
1858296|pass|200807|dagolden@cpan.org (DAGOLDEN)|Games-Trackword|1.06|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200807050610
1858215|pass|200807|dagolden@cpan.org (DAGOLDEN)|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200807050600
1858214|pass|200807|dagolden@cpan.org (DAGOLDEN)|Data-Phrasebook|0.29|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200807050600
1857012|pass|200807|dagolden@cpan.org (DAGOLDEN)|Test-YAML-Meta|0.11|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200807050218
1857010|pass|200807|dagolden@cpan.org (DAGOLDEN)|Test-CPAN-Meta|0.12|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200807050218
1857004|pass|200807|dagolden@cpan.org (DAGOLDEN)|WWW-Scraper-ISBN-Amazon_Driver|0.13|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200807050217
1854518|pass|200807|chris@bingosnet.co.uk|WWW-Scraper-ISBN-Yahoo_Driver|0.07|darwin-thread-multi-64int-2level|5.10.0|darwin|8.10.0|200807041625
1854497|pass|200807|chris@bingosnet.co.uk|WWW-Scraper-ISBN-Pearson_Driver|0.10|darwin-thread-multi-64int-2level|5.8.8|darwin|8.10.0|200807041615
1854449|pass|200807|chris@bingosnet.co.uk|WWW-Scraper-ISBN-Pearson_Driver|0.10|darwin-thread-multi-64int-2level|5.10.0|darwin|8.10.0|200807041552
1854397|pass|200807|chris@bingosnet.co.uk|WWW-Scraper-ISBN-ORA_Driver|0.09|darwin-thread-multi-64int-2level|5.10.0|darwin|8.10.0|200807041521
1854305|pass|200807|chris@bingosnet.co.uk|WWW-Scraper-ISBN-Amazon_Driver|0.13|darwin-thread-multi-64int-2level|5.10.0|darwin|8.10.0|200807041448
1853273|pass|200807|chris@bingosnet.co.uk|Test-YAML-Meta|0.11|i386-freebsd-64int|5.8.8|freebsd|6.2-release|200807040910
1852933|pass|200807|chris@bingosnet.co.uk|Test-YAML-Meta|0.11|i386-freebsd-64int|5.8.6|freebsd|5.4-release|200807040818
1852851|pass|200807|chris@bingosnet.co.uk|Test-YAML-Meta|0.11|i686-linux-thread-multi-64int|5.10.0|linux|2.4.26|200807040737
1852425|pass|200807|chris@bingosnet.co.uk|WWW-Scraper-ISBN-Amazon_Driver|0.12|darwin-thread-multi-64int-2level|5.10.0|darwin|8.10.0|200807040604
1852369|pass|200807|chris@bingosnet.co.uk|Test-YAML-Meta|0.11|darwin-thread-multi-64int-2level|5.8.8|darwin|8.10.0|200807040554
1852351|pass|200807|chris@bingosnet.co.uk|Test-YAML-Meta|0.11|darwin-thread-multi-64int-2level|5.10.0|darwin|8.10.0|200807040551
1852342|pass|200807|chris@bingosnet.co.uk|Test-CPAN-Meta|0.12|darwin-thread-multi-64int-2level|5.8.8|darwin|8.10.0|200807040548
1852339|pass|200807|chris@bingosnet.co.uk|Test-CPAN-Meta|0.12|darwin-thread-multi-64int-2level|5.10.0|darwin|8.10.0|200807040547
1851722|pass|200807|chris@bingosnet.co.uk|WWW-Scraper-ISBN-Yahoo_Driver|0.07|i386-freebsd|5.11.0 patch 34101|freebsd|7.0-release|200807040553
1851689|pass|200807|chris@bingosnet.co.uk|WWW-Scraper-ISBN-Pearson_Driver|0.10|i386-freebsd|5.11.0 patch 34101|freebsd|7.0-release|200807040546
1851661|pass|200807|chris@bingosnet.co.uk|WWW-Scraper-ISBN-ORA_Driver|0.09|i386-freebsd|5.11.0 patch 34101|freebsd|7.0-release|200807040542
1851620|pass|200807|chris@bingosnet.co.uk|WWW-Scraper-ISBN-Amazon_Driver|0.13|i386-freebsd|5.11.0 patch 34101|freebsd|7.0-release|200807040531
1851578|pass|200807|chris@bingosnet.co.uk|WWW-Scraper-ISBN-Amazon_Driver|0.12|i386-freebsd|5.11.0 patch 34101|freebsd|7.0-release|200807040518
1851537|pass|200807|chris@bingosnet.co.uk|Test-YAML-Meta|0.11|i386-freebsd|5.11.0 patch 34101|freebsd|7.0-release|200807040506
1851523|pass|200807|chris@bingosnet.co.uk|Test-CPAN-Meta|0.12|i386-freebsd|5.11.0 patch 34101|freebsd|7.0-release|200807040503
1851454|pass|200807|chris@bingosnet.co.uk|WWW-Scraper-ISBN-Yahoo_Driver|0.07|i386-freebsd-64int|5.10.0|freebsd|7.0-release|200807040439
1851448|pass|200807|chris@bingosnet.co.uk|WWW-Scraper-ISBN-Pearson_Driver|0.10|i386-freebsd-64int|5.10.0|freebsd|7.0-release|200807040436
1851422|pass|200807|chris@bingosnet.co.uk|WWW-Scraper-ISBN-ORA_Driver|0.09|i386-freebsd-64int|5.10.0|freebsd|7.0-release|200807040423
1851393|pass|200807|chris@bingosnet.co.uk|WWW-Scraper-ISBN-Amazon_Driver|0.13|i386-freebsd-64int|5.10.0|freebsd|7.0-release|200807040411
1851351|pass|200807|chris@bingosnet.co.uk|WWW-Scraper-ISBN-Amazon_Driver|0.12|i386-freebsd-64int|5.10.0|freebsd|7.0-release|200807040357
1851332|pass|200807|chris@bingosnet.co.uk|Test-YAML-Meta|0.11|i386-freebsd-64int|5.10.0|freebsd|7.0-release|200807040354
1851317|pass|200807|chris@bingosnet.co.uk|Test-CPAN-Meta|0.12|i386-freebsd-64int|5.10.0|freebsd|7.0-release|200807040350
1850772|pass|200807|andy@hexten.net|Test-YAML-Meta|0.11|darwin-thread-multi-2level|5.10.0|darwin|9.2.2|200807040247
1850725|pass|200807|rlane10@wi.rr.com|Test-YAML-Meta|0.11|darwin-2level-ld|5.10.0|darwin|8.11.0|200807040055
1850327|pass|200807|dagolden@cpan.org (DAGOLDEN)|Regexp-Log-Common|0.05|i686-linux-thread-multi-64int-ld|5.8.8 patch 34066|linux|2.6.24-16-generic|200807040029
1850042|pass|200807|dagolden@cpan.org (DAGOLDEN)|CPAN-YACSmoke-Plugin-Outlook|0.06|i686-linux-thread-multi-64int-ld|5.8.8 patch 34066|linux|2.6.24-16-generic|200807031935
1845045|pass|200807|stro@cpan.org|CPAN-YACSmoke-Plugin-WebList|0.05|i386-freebsd-64int|5.8.8|freebsd|7.0-release|200807031158
1845040|pass|200807|stro@cpan.org|CPAN-YACSmoke-Plugin-Outlook|0.06|i386-freebsd-64int|5.8.8|freebsd|7.0-release|200807031152
1845037|pass|200807|stro@cpan.org|CPAN-YACSmoke-Plugin-NNTPWeb|0.06|i386-freebsd-64int|5.8.8|freebsd|7.0-release|200807031150
1845026|pass|200807|stro@cpan.org|CPAN-YACSmoke-Plugin-NNTP|0.05|i386-freebsd-64int|5.8.8|freebsd|7.0-release|200807031144
1845023|fail|200807|stro@cpan.org|CPAN-WWW-Testers-Generator|0.22|i386-freebsd-64int|5.8.8|freebsd|7.0-release|200807031140
1842934|pass|200807|chris@bingosnet.co.uk|WWW-Scraper-ISBN-Yahoo_Driver|0.07|i386-netbsd-thread-multi-64int|5.8.8|netbsd|4.0|200807021535
1842911|pass|200807|chris@bingosnet.co.uk|WWW-Scraper-ISBN-Pearson_Driver|0.10|i386-netbsd-thread-multi-64int|5.8.8|netbsd|4.0|200807021525
1842834|pass|200807|claco@chrislaco.com ("Christopher H. Laco")|Test-YAML-Meta|0.11|darwin-thread-multi-2level|5.8.6|darwin|8.0|200807011833
1842817|pass|200807|chris@bingosnet.co.uk|WWW-Scraper-ISBN-ORA_Driver|0.09|i386-netbsd-thread-multi-64int|5.8.8|netbsd|4.0|200807021515
1842747|pass|200807|chris@bingosnet.co.uk|WWW-Scraper-ISBN-Amazon_Driver|0.13|i386-netbsd-thread-multi-64int|5.8.8|netbsd|4.0|200807021506
1842698|pass|200807|chris@bingosnet.co.uk|WWW-Scraper-ISBN-Amazon_Driver|0.12|i386-netbsd-thread-multi-64int|5.8.8|netbsd|4.0|200807021456
1842665|pass|200807|chris@bingosnet.co.uk|Test-YAML-Meta|0.11|i386-netbsd-thread-multi-64int|5.8.8|netbsd|4.0|200807021445
1842643|pass|200807|chris@bingosnet.co.uk|Test-CPAN-Meta|0.12|i386-netbsd-thread-multi-64int|5.8.8|netbsd|4.0|200807021438
1842593|pass|200807|chris@bingosnet.co.uk|Test-YAML-Meta|0.11|i686-linux|5.8.6|linux|2.4.20|200807021424
1841745|pass|200807|srezic@cpan.org|Calendar-List|0.21|i386-freebsd-thread-multi|5.8.8|freebsd|6.1-release|200807020841
1840882|pass|200807|stro@cpan.org|Test-YAML-Meta|0.11|i686-linux|5.8.8|linux|2.4.27-2-386|200807020023
1840026|pass|200807|srezic@cpan.org|WWW-Scraper-ISBN-Amazon_Driver|0.13|i386-freebsd-thread-multi|5.10.0|freebsd|6.1-release|200807012256
1840024|pass|200807|srezic@cpan.org|WWW-Scraper-ISBN-Yahoo_Driver|0.07|i386-freebsd-thread-multi|5.10.0|freebsd|6.1-release|200807012256
1838883|pass|200807|chris@bingosnet.co.uk|WWW-Scraper-ISBN-Yahoo_Driver|0.07|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0|200807011915
1838839|pass|200807|chris@bingosnet.co.uk|WWW-Scraper-ISBN-Yahoo_Driver|0.07|i386-netbsd|5.11.0 patch 34094|netbsd|4.0|200807011907
1838827|pass|200807|chris@bingosnet.co.uk|WWW-Scraper-ISBN-Pearson_Driver|0.10|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0|200807011904
1838781|pass|200807|chris@bingosnet.co.uk|WWW-Scraper-ISBN-Pearson_Driver|0.10|i386-netbsd|5.11.0 patch 34094|netbsd|4.0|200807011858
1838746|pass|200807|chris@bingosnet.co.uk|WWW-Scraper-ISBN-ORA_Driver|0.09|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0|200807011853
1838730|pass|200807|chris@bingosnet.co.uk|WWW-Scraper-ISBN-ORA_Driver|0.09|i386-netbsd|5.11.0 patch 34094|netbsd|4.0|200807011849
1838675|pass|200807|chris@bingosnet.co.uk|WWW-Scraper-ISBN-Amazon_Driver|0.13|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0|200807011843
1838662|pass|200807|chris@bingosnet.co.uk|WWW-Scraper-ISBN-Amazon_Driver|0.13|i386-netbsd|5.11.0 patch 34094|netbsd|4.0|200807011841
1838623|pass|200807|chris@bingosnet.co.uk|WWW-Scraper-ISBN-Amazon_Driver|0.12|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0|200807011832
1838617|pass|200807|chris@bingosnet.co.uk|WWW-Scraper-ISBN-Amazon_Driver|0.12|i386-netbsd|5.11.0 patch 34094|netbsd|4.0|200807011832
1838562|pass|200807|chris@bingosnet.co.uk|Test-YAML-Meta|0.11|i386-netbsd|5.11.0 patch 34094|netbsd|4.0|200807011822
1838556|pass|200807|chris@bingosnet.co.uk|Test-YAML-Meta|0.11|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0|200807011820
1838551|pass|200807|chris@bingosnet.co.uk|Test-CPAN-Meta|0.12|i386-netbsd|5.11.0 patch 34094|netbsd|4.0|200807011819
1838537|pass|200807|chris@bingosnet.co.uk|Test-CPAN-Meta|0.12|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0|200807011817
1838110|pass|200807|srezic@cpan.org|Test-CPAN-Meta|0.12|i386-freebsd|5.5.5|freebsd|6.1-release|200807011728
1837506|pass|200807|stro@cpan.org|Finance-Currency-Convert-XE|0.15|armv5tejl-linux|5.10.0|linux|2.6.17.14|200807011732
1837158|fail|200807|dagolden@cpan.org (DAGOLDEN)|CPAN-WWW-Testers-Generator|0.22|i686-linux|5.10.0|linux|2.6.24-16-generic|200807010922
1835124|pass|200807|dagolden@cpan.org (DAGOLDEN)|Data-FormValidator-Constraints-Words|0.03|i686-linux-thread-multi-64int-ld|5.8.8 patch 34066|linux|2.6.24-16-generic|200807010254
1831266|pass|200806|andy@hexten.net|Test-YAML-Meta|0.11|darwin-thread-multi-2level|5.10.0|darwin|9.1.0|200806302106
1831015|pass|200806|g.grigelionis@computer.org|Test-YAML-Meta|0.11|i586-linux-thread-multi|5.8.5|linux|2.6.8.1|200806301122
1830585|pass|200806|dagolden@cpan.org (DAGOLDEN)|Games-Trackword|1.06|i686-linux-thread-multi-64int-ld|5.8.8 patch 34066|linux|2.6.24-16-generic|200806301343
1830426|pass|200806|dagolden@cpan.org (DAGOLDEN)|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi-64int-ld|5.8.8 patch 34066|linux|2.6.24-16-generic|200806301315
1830422|pass|200806|dagolden@cpan.org (DAGOLDEN)|Data-Phrasebook|0.29|i686-linux-thread-multi-64int-ld|5.8.8 patch 34066|linux|2.6.24-16-generic|200806301314
1829239|pass|200806|stro@cpan.org|WWW-Scraper-ISBN-Yahoo_Driver|0.07|MSWin32-x86-multi-thread|5.8.8|MSWin32|5.00|200806301703
1829234|pass|200806|stro@cpan.org|WWW-Scraper-ISBN-Pearson_Driver|0.10|MSWin32-x86-multi-thread|5.8.8|MSWin32|5.00|200806301702
1829146|pass|200806|stro@cpan.org|Test-YAML-Meta|0.11|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.00|200806301647
1829140|pass|200806|stro@cpan.org|Test-CPAN-Meta|0.12|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.00|200806301645
1828681|pass|200806|dagolden@cpan.org (DAGOLDEN)|Data-Phrasebook-Loader-DBI|0.11|i686-linux|5.10.0|linux|2.6.24-16-generic|200806300809
1828680|pass|200806|dagolden@cpan.org (DAGOLDEN)|Data-Phrasebook-Loader-Ini|0.10|i686-linux|5.10.0|linux|2.6.24-16-generic|200806300809
1828679|pass|200806|dagolden@cpan.org (DAGOLDEN)|Data-Phrasebook-Loader-XML|0.12|i686-linux|5.10.0|linux|2.6.24-16-generic|200806300809
1828672|pass|200806|dagolden@cpan.org (DAGOLDEN)|Mail-File|0.08|i686-linux|5.10.0|linux|2.6.24-16-generic|200806300807
1828671|pass|200806|dagolden@cpan.org (DAGOLDEN)|Regexp-Log-Common|0.05|i686-linux|5.10.0|linux|2.6.24-16-generic|200806300807
1828562|pass|200806|rafl@debian.org|WWW-Scraper-ISBN-ORA_Driver|0.09|x86_64-linux|5.10.0|linux|2.6.18-6-xen-amd64|200806300210
1828536|pass|200806|chris@bingosnet.co.uk|WWW-Scraper-ISBN-Amazon_Driver|0.13|i386-netbsd-thread-multi-64int|5.8.8|netbsd|3.1|200806301158
1828527|pass|200806|chris@bingosnet.co.uk|WWW-Scraper-ISBN-Amazon_Driver|0.13|i386-netbsd-thread-multi-64int|5.8.7|netbsd|3.1|200806301155
1828520|pass|200806|chris@bingosnet.co.uk|WWW-Scraper-ISBN-Amazon_Driver|0.13|i386-netbsd-thread-multi-64int|5.8.6|netbsd|3.1|200806301151
1828503|pass|200806|chris@bingosnet.co.uk|WWW-Scraper-ISBN-Amazon_Driver|0.13|i386-netbsd-thread-multi-64int|5.8.4|netbsd|3.1|200806301146
1828495|pass|200806|chris@bingosnet.co.uk|WWW-Scraper-ISBN-Amazon_Driver|0.13|i386-netbsd-thread-multi-64int|5.8.3|netbsd|3.1|200806301142
1828487|pass|200806|chris@bingosnet.co.uk|WWW-Scraper-ISBN-Amazon_Driver|0.13|i386-netbsd-thread-multi-64int|5.8.2|netbsd|3.1|200806301139
1828479|pass|200806|chris@bingosnet.co.uk|WWW-Scraper-ISBN-Amazon_Driver|0.13|i386-netbsd-thread-multi-64int|5.8.1|netbsd|3.1|200806301136
1828453|pass|200806|chris@bingosnet.co.uk|WWW-Scraper-ISBN-Amazon_Driver|0.13|i386-netbsd-thread-multi-64int|5.10.0|netbsd|3.1|200806301119
1828442|pass|200806|chris@bingosnet.co.uk|WWW-Scraper-ISBN-Yahoo_Driver|0.07|i386-netbsd-thread-multi-64int|5.8.8|netbsd|3.1|200806301116
1828437|pass|200806|chris@bingosnet.co.uk|WWW-Scraper-ISBN-Yahoo_Driver|0.07|i386-netbsd-thread-multi-64int|5.8.7|netbsd|3.1|200806301112
1828429|pass|200806|chris@bingosnet.co.uk|WWW-Scraper-ISBN-Yahoo_Driver|0.07|i386-netbsd-thread-multi-64int|5.8.6|netbsd|3.1|200806301109
1828411|pass|200806|chris@bingosnet.co.uk|WWW-Scraper-ISBN-Yahoo_Driver|0.07|i386-netbsd-thread-multi-64int|5.8.4|netbsd|3.1|200806301104
1828353|pass|200806|rafl@debian.org|WWW-Scraper-ISBN-Amazon_Driver|0.13|x86_64-linux|5.10.0|linux|2.6.18-6-xen-amd64|200806300207
1828341|pass|200806|chris@bingosnet.co.uk|WWW-Scraper-ISBN-Yahoo_Driver|0.07|i386-netbsd-thread-multi-64int|5.8.3|netbsd|3.1|200806301043
1828339|pass|200806|chris@bingosnet.co.uk|WWW-Scraper-ISBN-Yahoo_Driver|0.07|i386-netbsd-thread-multi-64int|5.8.2|netbsd|3.1|200806301040
1828336|pass|200806|chris@bingosnet.co.uk|WWW-Scraper-ISBN-Yahoo_Driver|0.07|i386-netbsd-thread-multi-64int|5.8.1|netbsd|3.1|200806301037
1828301|pass|200806|chris@bingosnet.co.uk|WWW-Scraper-ISBN-Yahoo_Driver|0.07|i386-netbsd-thread-multi-64int|5.10.0|netbsd|3.1|200806301021
1828187|pass|200806|chris@bingosnet.co.uk|WWW-Scraper-ISBN-Pearson_Driver|0.10|i386-netbsd-thread-multi-64int|5.8.8|netbsd|3.1|200806300911
1828185|pass|200806|chris@bingosnet.co.uk|WWW-Scraper-ISBN-Pearson_Driver|0.10|i386-netbsd-thread-multi-64int|5.8.7|netbsd|3.1|200806300908
1828180|pass|200806|chris@bingosnet.co.uk|WWW-Scraper-ISBN-Pearson_Driver|0.10|i386-netbsd-thread-multi-64int|5.8.6|netbsd|3.1|200806300904
1828166|pass|200806|chris@bingosnet.co.uk|WWW-Scraper-ISBN-Pearson_Driver|0.10|i386-netbsd-thread-multi-64int|5.8.4|netbsd|3.1|200806300859
1828158|pass|200806|chris@bingosnet.co.uk|WWW-Scraper-ISBN-Pearson_Driver|0.10|i386-netbsd-thread-multi-64int|5.8.3|netbsd|3.1|200806300856
1828149|pass|200806|chris@bingosnet.co.uk|WWW-Scraper-ISBN-Pearson_Driver|0.10|i386-netbsd-thread-multi-64int|5.8.2|netbsd|3.1|200806300852
1828146|pass|200806|chris@bingosnet.co.uk|WWW-Scraper-ISBN-Pearson_Driver|0.10|i386-netbsd-thread-multi-64int|5.8.1|netbsd|3.1|200806300849
1828129|pass|200806|chris@bingosnet.co.uk|WWW-Scraper-ISBN-Pearson_Driver|0.10|i386-netbsd-thread-multi-64int|5.10.0|netbsd|3.1|200806300833
1828128|pass|200806|chris@bingosnet.co.uk|WWW-Scraper-ISBN-ORA_Driver|0.09|i386-netbsd-thread-multi-64int|5.8.8|netbsd|3.1|200806300829
1828125|pass|200806|chris@bingosnet.co.uk|WWW-Scraper-ISBN-ORA_Driver|0.09|i386-netbsd-thread-multi-64int|5.8.7|netbsd|3.1|200806300826
1828123|pass|200806|chris@bingosnet.co.uk|WWW-Scraper-ISBN-ORA_Driver|0.09|i386-netbsd-thread-multi-64int|5.8.6|netbsd|3.1|200806300823
1828086|pass|200806|chris@bingosnet.co.uk|WWW-Scraper-ISBN-ORA_Driver|0.09|i386-netbsd-thread-multi-64int|5.8.4|netbsd|3.1|200806300818
1828082|pass|200806|chris@bingosnet.co.uk|WWW-Scraper-ISBN-ORA_Driver|0.09|i386-netbsd-thread-multi-64int|5.8.3|netbsd|3.1|200806300815
1828081|pass|200806|chris@bingosnet.co.uk|WWW-Scraper-ISBN-ORA_Driver|0.09|i386-netbsd-thread-multi-64int|5.8.2|netbsd|3.1|200806300812
1828080|pass|200806|chris@bingosnet.co.uk|WWW-Scraper-ISBN-ORA_Driver|0.09|i386-netbsd-thread-multi-64int|5.8.1|netbsd|3.1|200806300809
1828066|pass|200806|chris@bingosnet.co.uk|WWW-Scraper-ISBN-ORA_Driver|0.09|i386-netbsd-thread-multi-64int|5.10.0|netbsd|3.1|200806300752
1827983|pass|200806|chris@bingosnet.co.uk|WWW-Scraper-ISBN-Amazon_Driver|0.12|i386-netbsd-thread-multi-64int|5.8.8|netbsd|3.1|200806300744
1827943|pass|200806|rafl@debian.org|Test-YAML-Meta|0.11|x86_64-linux|5.10.0|linux|2.6.18-6-xen-amd64|200806300212
1827942|pass|200806|rafl@debian.org|Test-CPAN-Meta|0.12|x86_64-linux|5.10.0|linux|2.6.18-6-xen-amd64|200806300211
1827937|pass|200806|rafl@debian.org|WWW-Scraper-ISBN-Pearson_Driver|0.10|x86_64-linux|5.10.0|linux|2.6.18-6-xen-amd64|200806300210
1827935|pass|200806|rafl@debian.org|WWW-Scraper-ISBN-Yahoo_Driver|0.07|x86_64-linux|5.10.0|linux|2.6.18-6-xen-amd64|200806300208
1827841|pass|200806|chris@bingosnet.co.uk|WWW-Scraper-ISBN-Amazon_Driver|0.12|i386-netbsd-thread-multi-64int|5.8.7|netbsd|3.1|200806300723
1827838|pass|200806|chris@bingosnet.co.uk|WWW-Scraper-ISBN-Amazon_Driver|0.12|i386-netbsd-thread-multi-64int|5.8.6|netbsd|3.1|200806300720
1827832|pass|200806|chris@bingosnet.co.uk|WWW-Scraper-ISBN-Amazon_Driver|0.12|i386-netbsd-thread-multi-64int|5.8.4|netbsd|3.1|200806300714
1827828|pass|200806|chris@bingosnet.co.uk|WWW-Scraper-ISBN-Amazon_Driver|0.12|i386-netbsd-thread-multi-64int|5.8.3|netbsd|3.1|200806300711
1827822|pass|200806|chris@bingosnet.co.uk|WWW-Scraper-ISBN-Amazon_Driver|0.12|i386-netbsd-thread-multi-64int|5.8.2|netbsd|3.1|200806300707
1827818|pass|200806|chris@bingosnet.co.uk|WWW-Scraper-ISBN-Amazon_Driver|0.12|i386-netbsd-thread-multi-64int|5.8.1|netbsd|3.1|200806300704
1827799|pass|200806|chris@bingosnet.co.uk|WWW-Scraper-ISBN-Amazon_Driver|0.12|i386-netbsd-thread-multi-64int|5.10.0|netbsd|3.1|200806300648
1827795|pass|200806|chris@bingosnet.co.uk|Test-YAML-Meta|0.11|i386-netbsd-thread-multi-64int|5.8.8|netbsd|3.1|200806300644
1827791|pass|200806|chris@bingosnet.co.uk|Test-YAML-Meta|0.11|i386-netbsd-thread-multi-64int|5.8.7|netbsd|3.1|200806300643
1827787|pass|200806|chris@bingosnet.co.uk|Test-YAML-Meta|0.11|i386-netbsd-thread-multi-64int|5.8.6|netbsd|3.1|200806300642
1827784|pass|200806|chris@bingosnet.co.uk|Test-YAML-Meta|0.11|i386-netbsd-thread-multi-64int|5.8.5|netbsd|3.1|200806300641
1827781|pass|200806|chris@bingosnet.co.uk|Test-YAML-Meta|0.11|i386-netbsd-thread-multi-64int|5.8.4|netbsd|3.1|200806300640
1827780|pass|200806|chris@bingosnet.co.uk|Test-YAML-Meta|0.11|i386-netbsd-thread-multi-64int|5.8.3|netbsd|3.1|200806300639
1827778|pass|200806|chris@bingosnet.co.uk|Test-YAML-Meta|0.11|i386-netbsd-thread-multi-64int|5.8.2|netbsd|3.1|200806300639
1827777|pass|200806|chris@bingosnet.co.uk|Test-YAML-Meta|0.11|i386-netbsd-thread-multi-64int|5.8.1|netbsd|3.1|200806300638
1827774|pass|200806|chris@bingosnet.co.uk|Test-YAML-Meta|0.11|i386-netbsd-thread-multi-64int|5.10.0|netbsd|3.1|200806300637
1827773|pass|200806|chris@bingosnet.co.uk|Test-CPAN-Meta|0.12|i386-netbsd-thread-multi-64int|5.8.8|netbsd|3.1|200806300635
1827772|pass|200806|chris@bingosnet.co.uk|Test-CPAN-Meta|0.12|i386-netbsd-thread-multi-64int|5.8.7|netbsd|3.1|200806300635
1827771|pass|200806|chris@bingosnet.co.uk|Test-CPAN-Meta|0.12|i386-netbsd-thread-multi-64int|5.8.6|netbsd|3.1|200806300634
1827770|pass|200806|chris@bingosnet.co.uk|Test-CPAN-Meta|0.12|i386-netbsd-thread-multi-64int|5.8.5|netbsd|3.1|200806300634
1827769|pass|200806|chris@bingosnet.co.uk|Test-CPAN-Meta|0.12|i386-netbsd-thread-multi-64int|5.8.4|netbsd|3.1|200806300633
1827768|pass|200806|chris@bingosnet.co.uk|Test-CPAN-Meta|0.12|i386-netbsd-thread-multi-64int|5.8.3|netbsd|3.1|200806300633
1827767|pass|200806|chris@bingosnet.co.uk|Test-CPAN-Meta|0.12|i386-netbsd-thread-multi-64int|5.8.2|netbsd|3.1|200806300633
1827764|pass|200806|chris@bingosnet.co.uk|Test-CPAN-Meta|0.12|i386-netbsd-thread-multi-64int|5.8.1|netbsd|3.1|200806300632
1827763|pass|200806|chris@bingosnet.co.uk|Test-CPAN-Meta|0.12|i386-netbsd-thread-multi-64int|5.6.2|netbsd|3.1|200806300632
1827762|pass|200806|chris@bingosnet.co.uk|Test-CPAN-Meta|0.12|i386-netbsd-thread-multi-64int|5.10.0|netbsd|3.1|200806300631
1827580|pass|200806|dagolden@cpan.org (DAGOLDEN)|CPAN-YACSmoke-Plugin-Outlook|0.06|i686-linux|5.10.0|linux|2.6.24-16-generic|200806300359
1827565|pass|200806|stro@cpan.org|Test-YAML-Meta|0.11|MSWin32-x86-multi-thread|5.8.8|MSWin32|5.00|200806300653
1827561|pass|200806|stro@cpan.org|Test-CPAN-Meta|0.12|MSWin32-x86-multi-thread|5.8.8|MSWin32|5.00|200806300651
1826328|pass|200806|vpit@cpan.org|Test-YAML-Meta|0.11|i686-linux-thread-multi|5.10.0|linux|2.6.9-5.elsmp|200806292321
1826201|pass|200806|vpit@cpan.org|Test-YAML-Meta|0.11|sun4-solaris-thread-multi-64|5.10.0|solaris|2.7|200806300545
1826035|pass|200806|dagolden@cpan.org (DAGOLDEN)|Test-YAML-Meta|0.11|i686-linux-thread-multi-64int-ld|5.8.8 patch 34066|linux|2.6.24-16-generic|200806291753
1826032|pass|200806|dagolden@cpan.org (DAGOLDEN)|Test-CPAN-Meta|0.12|i686-linux-thread-multi-64int-ld|5.8.8 patch 34066|linux|2.6.24-16-generic|200806291753
1825068|pass|200806|chris@bingosnet.co.uk|WWW-Scraper-ISBN-Yahoo_Driver|0.07|OpenBSD.i386-openbsd-64int|5.11.0 patch 34093|openbsd|4.2|200806292049
1824983|pass|200806|chris@bingosnet.co.uk|WWW-Scraper-ISBN-Pearson_Driver|0.10|OpenBSD.i386-openbsd-64int|5.11.0 patch 34093|openbsd|4.2|200806292037
1824942|pass|200806|chris@bingosnet.co.uk|WWW-Scraper-ISBN-ORA_Driver|0.09|OpenBSD.i386-openbsd-64int|5.11.0 patch 34093|openbsd|4.2|200806292026
1824891|pass|200806|chris@bingosnet.co.uk|WWW-Scraper-ISBN-Amazon_Driver|0.13|OpenBSD.i386-openbsd-64int|5.11.0 patch 34093|openbsd|4.2|200806292015
1824811|pass|200806|chris@bingosnet.co.uk|WWW-Scraper-ISBN-Amazon_Driver|0.12|OpenBSD.i386-openbsd-64int|5.11.0 patch 34093|openbsd|4.2|200806292003
1824748|pass|200806|chris@bingosnet.co.uk|Test-YAML-Meta|0.11|OpenBSD.i386-openbsd-64int|5.11.0 patch 34093|openbsd|4.2|200806291951
1824707|pass|200806|chris@bingosnet.co.uk|Test-CPAN-Meta|0.12|OpenBSD.i386-openbsd-64int|5.11.0 patch 34093|openbsd|4.2|200806291947
1824429|pass|200806|mw487.yahoo.com@gmail.com|Test-YAML-Meta|0.11|cygwin-thread-multi-64int|5.8.8|cygwin|1.5.24(0.15642)|200806290353
1824426|pass|200806|mw487.yahoo.com@gmail.com|Test-CPAN-Meta|0.12|cygwin-thread-multi-64int|5.8.8|cygwin|1.5.24(0.15642)|200806290340
1824270|pass|200806|chris@bingosnet.co.uk|WWW-Scraper-ISBN-Yahoo_Driver|0.07|OpenBSD.i386-openbsd-thread-multi-64int|5.8.8|openbsd|4.2|200806291812
1824216|pass|200806|chris@bingosnet.co.uk|WWW-Scraper-ISBN-Pearson_Driver|0.10|OpenBSD.i386-openbsd-thread-multi-64int|5.8.8|openbsd|4.2|200806291759
1824137|pass|200806|chris@bingosnet.co.uk|WWW-Scraper-ISBN-ORA_Driver|0.09|OpenBSD.i386-openbsd-thread-multi-64int|5.8.8|openbsd|4.2|200806291745
1824033|pass|200806|chris@bingosnet.co.uk|WWW-Scraper-ISBN-Amazon_Driver|0.13|OpenBSD.i386-openbsd-thread-multi-64int|5.8.8|openbsd|4.2|200806291731
1823988|pass|200806|chris@bingosnet.co.uk|WWW-Scraper-ISBN-Amazon_Driver|0.12|OpenBSD.i386-openbsd-thread-multi-64int|5.8.8|openbsd|4.2|200806291721
1823953|pass|200806|chris@bingosnet.co.uk|Test-YAML-Meta|0.11|OpenBSD.i386-openbsd-thread-multi-64int|5.8.8|openbsd|4.2|200806291713
1823948|pass|200806|chris@bingosnet.co.uk|Test-CPAN-Meta|0.12|OpenBSD.i386-openbsd-thread-multi-64int|5.8.8|openbsd|4.2|200806291711
1823186|fail|200806|dagolden@cpan.org (DAGOLDEN)|WWW-UsePerl-Journal-Thread|0.10|i686-linux|5.10.0|linux|2.6.24-16-generic|200806290914
1823185|pass|200806|dagolden@cpan.org (DAGOLDEN)|WWW-UsePerl-Journal|0.21|i686-linux|5.10.0|linux|2.6.24-16-generic|200806290914
1822838|pass|200806|david@cantrell.org.uk|WWW-Scraper-ISBN-Pearson_Driver|0.10|IP35-irix-64int|5.8.8|irix|6.5|200806291322
1822820|pass|200806|david@cantrell.org.uk|Test-YAML-Meta|0.11|IP35-irix-64int|5.8.8|irix|6.5|200806291316
1822809|pass|200806|david@cantrell.org.uk|Test-CPAN-Meta|0.12|IP35-irix-64int|5.8.8|irix|6.5|200806291315
1819789|pass|200806|MKUTTER@cpan.org ("Martin Kutter")|Test-YAML-Meta|0.11|i486-linux-gnu|5.8.8|linux|2.6.15.7|200806282245
1819477|pass|200806|MKUTTER@cpan.org ("Martin Kutter")|Test-CPAN-Meta|0.12|i486-linux-gnu|5.8.8|linux|2.6.15.7|200806282246
1819476|pass|200806|MKUTTER@cpan.org ("Martin Kutter")|Test-YAML-Meta|0.11|i686-linux|5.10.0|linux|2.6.22-14-generic|200806282244
1819174|pass|200806|MKUTTER@cpan.org ("Martin Kutter")|Test-CPAN-Meta|0.12|i686-linux|5.10.0|linux|2.6.22-14-generic|200806282244
1818245|pass|200806|stro@cpan.org|Data-Phrasebook|0.29|i386-freebsd-64int|5.8.8|freebsd|7.0-release|200806290153
1817500|pass|200806|david@cantrell.org.uk|WWW-Scraper-ISBN-Yahoo_Driver|0.07|i686-linux-thread-multi|5.10.0|linux|2.4.27-3-686|200806282002
1817493|pass|200806|david@cantrell.org.uk|WWW-Scraper-ISBN-Pearson_Driver|0.10|i686-linux-thread-multi|5.10.0|linux|2.4.27-3-686|200806282002
1817490|pass|200806|david@cantrell.org.uk|WWW-Scraper-ISBN-ORA_Driver|0.09|i686-linux-thread-multi|5.10.0|linux|2.4.27-3-686|200806282001
1817427|pass|200806|david@cantrell.org.uk|WWW-Scraper-ISBN-Amazon_Driver|0.13|i686-linux-thread-multi|5.10.0|linux|2.4.27-3-686|200806281954
1817423|pass|200806|david@cantrell.org.uk|WWW-Scraper-ISBN-Amazon_Driver|0.12|i686-linux-thread-multi|5.10.0|linux|2.4.27-3-686|200806281953
1817416|pass|200806|david@cantrell.org.uk|Test-YAML-Meta|0.11|i686-linux-thread-multi|5.10.0|linux|2.4.27-3-686|200806281951
1817413|pass|200806|david@cantrell.org.uk|Test-CPAN-Meta|0.12|i686-linux-thread-multi|5.10.0|linux|2.4.27-3-686|200806281950
1817196|pass|200806|david@cantrell.org.uk|WWW-Scraper-ISBN-Yahoo_Driver|0.07|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200806281704
1817174|pass|200806|david@cantrell.org.uk|WWW-Scraper-ISBN-Pearson_Driver|0.10|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200806281703
1817157|pass|200806|david@cantrell.org.uk|WWW-Scraper-ISBN-ORA_Driver|0.09|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200806281701
1817134|pass|200806|david@cantrell.org.uk|WWW-Scraper-ISBN-Amazon_Driver|0.13|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200806281659
1817114|pass|200806|david@cantrell.org.uk|WWW-Scraper-ISBN-Amazon_Driver|0.12|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200806281657
1817037|pass|200806|david@cantrell.org.uk|Test-YAML-Meta|0.11|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200806281651
1817018|pass|200806|david@cantrell.org.uk|Test-CPAN-Meta|0.12|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200806281649
1815735|pass|200806|rafl@debian.org|Test-YAML-Meta|0.11|i686-linux-multi|5.10.0|linux|2.6.24-rc5|200806281158
1815733|pass|200806|david@cantrell.org.uk|WWW-Scraper-ISBN-Yahoo_Driver|0.07|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200806282030
1815724|pass|200806|david@cantrell.org.uk|WWW-Scraper-ISBN-Pearson_Driver|0.10|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200806282028
1815713|pass|200806|david@cantrell.org.uk|WWW-Scraper-ISBN-ORA_Driver|0.09|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200806282026
1815699|pass|200806|david@cantrell.org.uk|WWW-Scraper-ISBN-Amazon_Driver|0.13|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200806282025
1815678|pass|200806|david@cantrell.org.uk|WWW-Scraper-ISBN-Amazon_Driver|0.12|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200806282023
1815620|pass|200806|david@cantrell.org.uk|Test-YAML-Meta|0.11|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200806282019
1815600|pass|200806|david@cantrell.org.uk|Test-CPAN-Meta|0.12|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200806282017
1815024|pass|200806|dagolden@cpan.org (DAGOLDEN)|Finance-Currency-Convert-XE|0.15|i686-linux|5.10.0|linux|2.6.24-16-generic|200806281419
1813052|pass|200806|dagolden@cpan.org (DAGOLDEN)|Data-FormValidator-Constraints-Words|0.03|i686-linux|5.10.0|linux|2.6.24-16-generic|200806281048
1812492|pass|200806|imacat@mail.imacat.idv.tw|WWW-Scraper-ISBN-Yahoo_Driver|0.07|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.22.10|200806282129
1812479|pass|200806|imacat@mail.imacat.idv.tw|WWW-Scraper-ISBN-Pearson_Driver|0.10|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.22.10|200806282127
1812454|pass|200806|imacat@mail.imacat.idv.tw|WWW-Scraper-ISBN-ORA_Driver|0.09|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.22.10|200806282124
1812447|pass|200806|imacat@mail.imacat.idv.tw|WWW-Scraper-ISBN-Yahoo_Driver|0.07|x86_64-linux-thread-multi-ld|5.8.8|linux|2.6.22.10|200806282123
1812444|pass|200806|imacat@mail.imacat.idv.tw|WWW-Scraper-ISBN-Amazon_Driver|0.13|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.22.10|200806282122
1812431|pass|200806|imacat@mail.imacat.idv.tw|WWW-Scraper-ISBN-Pearson_Driver|0.10|x86_64-linux-thread-multi-ld|5.8.8|linux|2.6.22.10|200806282121
1812429|pass|200806|imacat@mail.imacat.idv.tw|Test-YAML-Meta|0.11|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.22.10|200806282120
1812424|pass|200806|imacat@mail.imacat.idv.tw|Test-CPAN-Meta|0.12|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.22.10|200806282119
1812401|pass|200806|imacat@mail.imacat.idv.tw|WWW-Scraper-ISBN-ORA_Driver|0.09|x86_64-linux-thread-multi-ld|5.8.8|linux|2.6.22.10|200806282117
1812387|pass|200806|imacat@mail.imacat.idv.tw|WWW-Scraper-ISBN-Amazon_Driver|0.13|x86_64-linux-thread-multi-ld|5.8.8|linux|2.6.22.10|200806282115
1812376|pass|200806|david@cantrell.org.uk|WWW-Scraper-ISBN-Yahoo_Driver|0.07|alpha-netbsd|5.10.0|netbsd|2.1.0_stable|200806281313
1812375|pass|200806|imacat@mail.imacat.idv.tw|Test-YAML-Meta|0.11|x86_64-linux-thread-multi-ld|5.8.8|linux|2.6.22.10|200806282113
1812367|pass|200806|david@cantrell.org.uk|WWW-Scraper-ISBN-Pearson_Driver|0.10|alpha-netbsd|5.10.0|netbsd|2.1.0_stable|200806281312
1812364|pass|200806|imacat@mail.imacat.idv.tw|Test-CPAN-Meta|0.12|x86_64-linux-thread-multi-ld|5.8.8|linux|2.6.22.10|200806282112
1812356|pass|200806|david@cantrell.org.uk|WWW-Scraper-ISBN-ORA_Driver|0.09|alpha-netbsd|5.10.0|netbsd|2.1.0_stable|200806281311
1812351|pass|200806|david@cantrell.org.uk|WWW-Scraper-ISBN-Amazon_Driver|0.13|alpha-netbsd|5.10.0|netbsd|2.1.0_stable|200806281310
1812343|pass|200806|david@cantrell.org.uk|WWW-Scraper-ISBN-Amazon_Driver|0.12|alpha-netbsd|5.10.0|netbsd|2.1.0_stable|200806281309
1812308|pass|200806|david@cantrell.org.uk|WWW-Scraper-ISBN-Pearson_Driver|0.10|i686-linux|5.8.8|linux|2.4.27-3-686|200806281041
1812305|pass|200806|david@cantrell.org.uk|WWW-Scraper-ISBN-Yahoo_Driver|0.07|i686-linux|5.8.8|linux|2.4.27-3-686|200806281041
1812304|pass|200806|david@cantrell.org.uk|WWW-Scraper-ISBN-Amazon_Driver|0.13|i686-linux|5.8.8|linux|2.4.27-3-686|200806281040
1812295|pass|200806|david@cantrell.org.uk|WWW-Scraper-ISBN-ORA_Driver|0.09|i686-linux|5.8.8|linux|2.4.27-3-686|200806281040
1812291|pass|200806|david@cantrell.org.uk|WWW-Scraper-ISBN-Amazon_Driver|0.12|i686-linux|5.8.8|linux|2.4.27-3-686|200806281040
1812283|pass|200806|david@cantrell.org.uk|WWW-Scraper-ISBN-Yahoo_Driver|0.07|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200806281401
1812277|pass|200806|david@cantrell.org.uk|WWW-Scraper-ISBN-Pearson_Driver|0.10|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200806281401
1812272|pass|200806|david@cantrell.org.uk|WWW-Scraper-ISBN-ORA_Driver|0.09|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200806281400
1812269|pass|200806|david@cantrell.org.uk|WWW-Scraper-ISBN-Amazon_Driver|0.13|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200806281400
1812266|pass|200806|david@cantrell.org.uk|WWW-Scraper-ISBN-Amazon_Driver|0.12|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200806281359
1812263|pass|200806|david@cantrell.org.uk|Test-YAML-Meta|0.11|alpha-netbsd|5.10.0|netbsd|2.1.0_stable|200806281259
1812252|pass|200806|david@cantrell.org.uk|Test-YAML-Meta|0.11|i686-linux|5.8.8|linux|2.4.27-3-686|200806281035
1812244|pass|200806|david@cantrell.org.uk|Test-CPAN-Meta|0.12|i686-linux|5.6.2|linux|2.4.27-3-686|200806281035
1812239|pass|200806|david@cantrell.org.uk|Test-CPAN-Meta|0.12|alpha-netbsd|5.10.0|netbsd|2.1.0_stable|200806281256
1812228|pass|200806|david@cantrell.org.uk|Test-CPAN-Meta|0.12|i686-linux|5.8.8|linux|2.4.27-3-686|200806281033
1812218|pass|200806|david@cantrell.org.uk|Test-YAML-Meta|0.11|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200806281354
1812209|pass|200806|david@cantrell.org.uk|Test-CPAN-Meta|0.12|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200806281352
1811946|pass|200806|chris@bingosnet.co.uk|WWW-Scraper-ISBN-Yahoo_Driver|0.07|i686-linux-ld|5.11.0 patch 34090|linux|2.6.21.5-smp|200806281201
1811906|pass|200806|chris@bingosnet.co.uk|WWW-Scraper-ISBN-Pearson_Driver|0.10|i686-linux-ld|5.11.0 patch 34090|linux|2.6.21.5-smp|200806281154
1811863|pass|200806|chris@bingosnet.co.uk|WWW-Scraper-ISBN-ORA_Driver|0.09|i686-linux-ld|5.11.0 patch 34090|linux|2.6.21.5-smp|200806281145
1811830|pass|200806|chris@bingosnet.co.uk|WWW-Scraper-ISBN-Amazon_Driver|0.13|i686-linux-ld|5.11.0 patch 34090|linux|2.6.21.5-smp|200806281138
1811797|pass|200806|chris@bingosnet.co.uk|WWW-Scraper-ISBN-Amazon_Driver|0.12|i686-linux-ld|5.11.0 patch 34090|linux|2.6.21.5-smp|200806281130
1811753|pass|200806|Jost.Krieger+smokeback@ruhr-uni-bochum.de ("Josts Smokehouse")|Test-YAML-Meta|0.11|sun4-solaris|5.10.0|solaris|2.9|200806281318
1811742|pass|200806|Jost.Krieger+smokeback@ruhr-uni-bochum.de ("Josts Smokehouse")|Test-CPAN-Meta|0.12|sun4-solaris|5.10.0|solaris|2.9|200806281317
1811722|pass|200806|chris@bingosnet.co.uk|Test-YAML-Meta|0.11|i686-linux-ld|5.11.0 patch 34090|linux|2.6.21.5-smp|200806281122
1811703|pass|200806|chris@bingosnet.co.uk|Test-CPAN-Meta|0.12|i686-linux-ld|5.11.0 patch 34090|linux|2.6.21.5-smp|200806281119
1811702|pass|200806|Jost.Krieger+smokeback@ruhr-uni-bochum.de ("Josts Smokehouse")|WWW-Scraper-ISBN-ORA_Driver|0.09|sun4-solaris|5.10.0|solaris|2.9|200806281312
1811686|pass|200806|Jost.Krieger+smokeback@ruhr-uni-bochum.de ("Josts Smokehouse")|WWW-Scraper-ISBN-Pearson_Driver|0.10|sun4-solaris|5.10.0|solaris|2.9|200806281309
1811670|pass|200806|Jost.Krieger+smokeback@ruhr-uni-bochum.de ("Josts Smokehouse")|WWW-Scraper-ISBN-Yahoo_Driver|0.07|sun4-solaris|5.10.0|solaris|2.9|200806281304
1811660|pass|200806|Jost.Krieger+smokeback@ruhr-uni-bochum.de ("Josts Smokehouse")|WWW-Scraper-ISBN-Amazon_Driver|0.13|sun4-solaris|5.10.0|solaris|2.9|200806281259
1811385|pass|200806|chris@bingosnet.co.uk|Test-YAML-Meta|0.11|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.21.5-smp|200806280959
1811371|pass|200806|chris@bingosnet.co.uk|Test-CPAN-Meta|0.12|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.21.5-smp|200806280956
1810693|pass|200806|g.grigelionis@computer.org|Test-YAML-Meta|0.11|i386-linux|5.8.0|linux|2.6.9-22.18.bz155725.elsmp|200806280008
1810295|pass|200806|srezic@cpan.org|WWW-Scraper-ISBN-Amazon_Driver|0.13|i386-freebsd|5.8.8 patch 33662|freebsd|6.1-release-p23|200806280818
1810293|pass|200806|srezic@cpan.org|WWW-Scraper-ISBN-ORA_Driver|0.09|i386-freebsd|5.8.8 patch 33662|freebsd|6.1-release-p23|200806280818
1810292|pass|200806|srezic@cpan.org|WWW-Scraper-ISBN-Pearson_Driver|0.10|i386-freebsd|5.8.8 patch 33662|freebsd|6.1-release-p23|200806280818
1810291|pass|200806|srezic@cpan.org|WWW-Scraper-ISBN-Yahoo_Driver|0.07|i386-freebsd|5.8.8 patch 33662|freebsd|6.1-release-p23|200806280818
1810081|pass|200806|g.grigelionis@computer.org|Test-YAML-Meta|0.11|x86_64-linux-thread-multi|5.8.3|linux|2.6.4|200806280010
1810075|pass|200806|g.grigelionis@computer.org|Test-YAML-Meta|0.11|x86_64-linux|5.8.8|linux|2.6.5-7.276-smp|200806280005
1810073|pass|200806|g.grigelionis@computer.org|Test-YAML-Meta|0.11|i586-linux-thread-multi|5.8.8|linux|2.6.16|200806272320
1809666|pass|200806|dagolden@cpan.org (DAGOLDEN)|Test-YAML-Meta|0.11|i686-linux-64int-ld|5.8.8 patch 34066|linux|2.6.24-16-generic|200806280348
1809664|pass|200806|dagolden@cpan.org (DAGOLDEN)|Test-CPAN-Meta|0.12|i686-linux-64int-ld|5.8.8 patch 34066|linux|2.6.24-16-generic|200806280347
1809654|pass|200806|dagolden@cpan.org (DAGOLDEN)|WWW-Scraper-ISBN-Amazon_Driver|0.13|i686-linux-64int-ld|5.8.8 patch 34066|linux|2.6.24-16-generic|200806280345
1809334|pass|200806|yanick@cpan.org ("Yanick Champoux")|WWW-UsePerl-Journal|0.21|i686-linux|5.10.0|linux|2.6.22-gentoo-r2enkidu|200806271210
1808295|pass|200806|srezic@cpan.org|WWW-Scraper-ISBN-Yahoo_Driver|0.07|i386-freebsd-64int|5.8.8|freebsd|6.1-release|200806280030
1808293|pass|200806|srezic@cpan.org|WWW-Scraper-ISBN-Amazon_Driver|0.13|i386-freebsd-64int|5.8.8|freebsd|6.1-release|200806280030
1808218|pass|200806|srezic@cpan.org|WWW-Scraper-ISBN-ORA_Driver|0.09|i386-freebsd|5.10.0|freebsd|6.1-release|200806271926
1808198|pass|200806|dagolden@cpan.org (DAGOLDEN)|Test-YAML-Meta|0.11|i686-linux|5.10.0|linux|2.6.24-16-generic|200806271818
1808195|pass|200806|dagolden@cpan.org (DAGOLDEN)|Test-CPAN-Meta|0.12|i686-linux|5.10.0|linux|2.6.24-16-generic|200806271818
1808187|pass|200806|dagolden@cpan.org (DAGOLDEN)|WWW-Scraper-ISBN-ORA_Driver|0.09|i686-linux|5.10.0|linux|2.6.24-16-generic|200806271817
1808179|pass|200806|dagolden@cpan.org (DAGOLDEN)|WWW-Scraper-ISBN-Pearson_Driver|0.10|i686-linux|5.10.0|linux|2.6.24-16-generic|200806271816
1808170|pass|200806|dagolden@cpan.org (DAGOLDEN)|WWW-Scraper-ISBN-Yahoo_Driver|0.07|i686-linux|5.10.0|linux|2.6.24-16-generic|200806271814
1808163|pass|200806|dagolden@cpan.org (DAGOLDEN)|WWW-Scraper-ISBN-Amazon_Driver|0.13|i686-linux|5.10.0|linux|2.6.24-16-generic|200806271812
1807847|pass|200806|srezic@cpan.org|WWW-Scraper-ISBN-Pearson_Driver|0.10|i386-freebsd-64int|5.8.8|freebsd|6.1-release|200806271928
1807827|pass|200806|srezic@cpan.org|WWW-Scraper-ISBN-Yahoo_Driver|0.07|i386-freebsd|5.10.0|freebsd|6.1-release|200806272303
1807826|fail|200806|srezic@cpan.org|WWW-Scraper-ISBN-Amazon_Driver|0.13|i386-freebsd|5.10.0|freebsd|6.1-release|200806272303
1807735|pass|200806|chris@bingosnet.co.uk|Test-CPAN-Meta|0.12|darwin-thread-multi-64int-2level|5.8.8|darwin|8.10.0|200806272111
1807695|pass|200806|chris@bingosnet.co.uk|Test-CPAN-Meta|0.12|darwin-thread-multi-64int-2level|5.10.0|darwin|8.10.0|200806272109
1807514|pass|200806|chris@bingosnet.co.uk|Test-YAML-Meta|0.11|darwin-thread-multi-64int-2level|5.8.8|darwin|8.10.0|200806272050
1807476|pass|200806|chris@bingosnet.co.uk|Test-YAML-Meta|0.11|darwin-thread-multi-64int-2level|5.10.0|darwin|8.10.0|200806272044
1807402|pass|200806|dagolden@cpan.org (DAGOLDEN)|Finance-Currency-Convert-XE|0.15|i686-linux-64int-ld|5.8.8 patch 34066|linux|2.6.24-16-generic|200806271559
1806711|pass|200806|srezic@cpan.org|WWW-Scraper-ISBN-Pearson_Driver|0.10|i386-freebsd|5.10.0|freebsd|6.1-release|200806271927
1806697|pass|200806|srezic@cpan.org|WWW-Scraper-ISBN-ORA_Driver|0.09|i386-freebsd-64int|5.8.8|freebsd|6.1-release|200806271928
1806686|pass|200806|srezic@cpan.org|WWW-Scraper-ISBN-Pearson_Driver|0.10|i386-freebsd-thread-multi|5.10.0|freebsd|6.1-release|200806271944
1806684|pass|200806|chris@bingosnet.co.uk|Test-YAML-Meta|0.11|i686-linux|5.8.6|linux|2.4.18|200806271826
1806661|pass|200806|srezic@cpan.org|WWW-Scraper-ISBN-ORA_Driver|0.09|i386-freebsd|5.10.0|freebsd|6.1-release|200806271926
1806647|pass|200806|srezic@cpan.org|Test-CPAN-Meta|0.12|i386-freebsd-thread-multi|5.8.8|freebsd|6.1-release|200806271957
1806645|pass|200806|srezic@cpan.org|Test-YAML-Meta|0.11|i386-freebsd-thread-multi|5.8.8|freebsd|6.1-release|200806271957
1806625|pass|200806|srezic@cpan.org|WWW-Scraper-ISBN-ORA_Driver|0.09|i386-freebsd-thread-multi|5.10.0|freebsd|6.1-release|200806271944
1806380|cpan|200806|BARBIE|WWW-Scraper-ISBN-Amazon_Driver|0.13||0|||200806271901
1806263|cpan|200806|BARBIE|WWW-Scraper-ISBN-Yahoo_Driver|0.07||0|||200806271830
1806119|pass|200806|Jost.Krieger+smokeback@ruhr-uni-bochum.de ("Josts Smokehouse")|Data-Phrasebook-Loader-DBI|0.11|sun4-solaris|5.10.0|solaris|2.9|200806271807
1806108|pass|200806|Jost.Krieger+smokeback@ruhr-uni-bochum.de ("Josts Smokehouse")|Data-Phrasebook-Loader-Ini|0.10|sun4-solaris|5.10.0|solaris|2.9|200806271805
1806097|pass|200806|Jost.Krieger+smokeback@ruhr-uni-bochum.de ("Josts Smokehouse")|Data-Phrasebook-Loader-XML|0.12|sun4-solaris|5.10.0|solaris|2.9|200806271804
1806091|pass|200806|Jost.Krieger+smokeback@ruhr-uni-bochum.de ("Josts Smokehouse")|WWW-Scraper-ISBN-ORA_Driver|0.08|sun4-solaris|5.10.0|solaris|2.9|200806271802
1806040|cpan|200806|BARBIE|WWW-Scraper-ISBN-Pearson_Driver|0.10||0|||200806271749
1806018|pass|200806|srezic@cpan.org|Test-YAML-Meta|0.11|i386-freebsd-64int|5.8.8|freebsd|6.1-release|200806271528
1805958|cpan|200806|BARBIE|WWW-Scraper-ISBN-ORA_Driver|0.09||0|||200806271734
1805823|pass|200806|srezic@cpan.org|Test-CPAN-Meta|0.12|i386-freebsd-64int|5.8.8|freebsd|6.1-release|200806271528
1805820|pass|200806|srezic@cpan.org|Test-YAML-Meta|0.11|i386-freebsd|5.8.8 patch 33662|freebsd|6.1-release-p23|200806271550
1805812|pass|200806|srezic@cpan.org|Test-YAML-Meta|0.11|i386-freebsd|5.6.2|freebsd|6.1-release|200806271538
1805806|pass|200806|srezic@cpan.org|Test-CPAN-Meta|0.12|i386-freebsd|5.6.2|freebsd|6.1-release|200806271537
1805804|pass|200806|srezic@cpan.org|Test-YAML-Meta|0.11|i386-freebsd-thread-multi|5.10.0|freebsd|6.1-release|200806271541
1805803|pass|200806|srezic@cpan.org|Test-CPAN-Meta|0.12|i386-freebsd-thread-multi|5.10.0|freebsd|6.1-release|200806271541
1805754|pass|200806|Jost.Krieger+smokeback@ruhr-uni-bochum.de ("Josts Smokehouse")|Mail-File|0.08|sun4-solaris|5.10.0|solaris|2.9|200806271658
1805751|pass|200806|Jost.Krieger+smokeback@ruhr-uni-bochum.de ("Josts Smokehouse")|Regexp-Log-Common|0.05|sun4-solaris|5.10.0|solaris|2.9|200806271657
1805632|pass|200806|srezic@cpan.org|Test-CPAN-Meta|0.12|i386-freebsd|5.8.8 patch 33662|freebsd|6.1-release-p23|200806271550
1805614|pass|200806|srezic@cpan.org|Test-YAML-Meta|0.11|i386-freebsd|5.10.0|freebsd|6.1-release|200806271520
1805613|pass|200806|srezic@cpan.org|Test-CPAN-Meta|0.12|i386-freebsd|5.10.0|freebsd|6.1-release|200806271520
1805611|cpan|200806|BARBIE|WWW-Scraper-ISBN-Amazon_Driver|0.12||0|||200806271644
1805268|pass|200806|dagolden@cpan.org (DAGOLDEN)|Test-CPAN-Meta|0.11|i686-linux|5.10.0|linux|2.6.24-16-generic|200806270952
1805267|pass|200806|dagolden@cpan.org (DAGOLDEN)|Games-Trackword|1.06|i686-linux|5.10.0|linux|2.6.24-16-generic|200806270951
1805266|pass|200806|dagolden@cpan.org (DAGOLDEN)|Calendar-List|0.21|i686-linux|5.10.0|linux|2.6.24-16-generic|200806270951
1805120|pass|200806|dagolden@cpan.org (DAGOLDEN)|Data-Phrasebook-Loader-YAML|0.09|i686-linux|5.10.0|linux|2.6.24-16-generic|200806270911
1805119|pass|200806|dagolden@cpan.org (DAGOLDEN)|Data-Phrasebook|0.29|i686-linux|5.10.0|linux|2.6.24-16-generic|200806270910
1804993|cpan|200806|BARBIE|Test-CPAN-Meta|0.12||0|||200806271438
1804978|cpan|200806|BARBIE|Test-YAML-Meta|0.11||0|||200806271437
1804819|pass|200806|Jost.Krieger+smokeback@ruhr-uni-bochum.de ("Josts Smokehouse")|CPAN-YACSmoke-Plugin-Outlook|0.06|sun4-solaris|5.10.0|solaris|2.9|200806271357
1804136|pass|200806|dagolden@cpan.org (DAGOLDEN)|Test-YAML-Meta|0.10|i686-linux|5.10.0|linux|2.6.24-16-generic|200806270503
1801897|pass|200806|dagolden@cpan.org (DAGOLDEN)|Regexp-Log-Common|0.05|i686-linux-64int-ld|5.8.8 patch 34066|linux|2.6.24-16-generic|200806270122
1801697|pass|200806|dagolden@cpan.org (DAGOLDEN)|CPAN-YACSmoke-Plugin-Outlook|0.06|i686-linux-64int-ld|5.8.8 patch 34066|linux|2.6.24-16-generic|200806270035
1801214|fail|200806|srezic@cpan.org|WWW-Scraper-ISBN-Yahoo_Driver|0.06|i386-freebsd-64int|5.8.8|freebsd|6.1-release|200806270001
1795155|fail|200806|dagolden@cpan.org (DAGOLDEN)|WWW-Scraper-ISBN-Amazon_Driver|0.11|i686-linux-64int-ld|5.8.8 patch 34066|linux|2.6.24-16-generic|200806260122
1794922|pass|200806|stro@cpan.org|Test-CPAN-Meta|0.11|MSWin32-x86-multi-thread|5.8.8|MSWin32|5.00|200806260702
1794527|pass|200806|stro@cpan.org|Test-CPAN-Meta|0.11|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.00|200806260328
1794349|pass|200806|stro@cpan.org|Calendar-List|0.20|i386-freebsd-64int|5.8.8|freebsd|7.0-release|200806260206
1785435|fail|200806|dagolden@cpan.org (DAGOLDEN)|CPAN-WWW-Testers-Generator|0.22|i686-linux-thread-multi-64int-ld|5.10.0 patch 34034|linux|2.6.24-16-generic|200806250132
1782136|pass|200806|dagolden@cpan.org (DAGOLDEN)|Test-CPAN-Meta|0.11|i686-linux-64int-ld|5.8.8 patch 34066|linux|2.6.24-16-generic|200806240733
1782132|pass|200806|dagolden@cpan.org (DAGOLDEN)|Games-Trackword|1.06|i686-linux-64int-ld|5.8.8 patch 34066|linux|2.6.24-16-generic|200806240733
1781918|pass|200806|dagolden@cpan.org (DAGOLDEN)|Data-Phrasebook-Loader-YAML|0.09|i686-linux-64int-ld|5.8.8 patch 34066|linux|2.6.24-16-generic|200806240705
1781916|pass|200806|dagolden@cpan.org (DAGOLDEN)|Data-Phrasebook|0.29|i686-linux-64int-ld|5.8.8 patch 34066|linux|2.6.24-16-generic|200806240705
1781326|pass|200806|dagolden@cpan.org (DAGOLDEN)|Data-Phrasebook-Loader-DBI|0.11|i686-linux-thread-multi-64int-ld|5.10.0 patch 34034|linux|2.6.24-16-generic|200806240539
1781324|pass|200806|dagolden@cpan.org (DAGOLDEN)|Data-Phrasebook-Loader-Ini|0.10|i686-linux-thread-multi-64int-ld|5.10.0 patch 34034|linux|2.6.24-16-generic|200806240539
1781323|pass|200806|dagolden@cpan.org (DAGOLDEN)|Data-Phrasebook-Loader-XML|0.12|i686-linux-thread-multi-64int-ld|5.10.0 patch 34034|linux|2.6.24-16-generic|200806240539
1781321|pass|200806|dagolden@cpan.org (DAGOLDEN)|WWW-Scraper-ISBN-ORA_Driver|0.08|i686-linux-thread-multi-64int-ld|5.10.0 patch 34034|linux|2.6.24-16-generic|200806240538
1781313|pass|200806|dagolden@cpan.org (DAGOLDEN)|Mail-File|0.08|i686-linux-thread-multi-64int-ld|5.10.0 patch 34034|linux|2.6.24-16-generic|200806240537
1781312|pass|200806|dagolden@cpan.org (DAGOLDEN)|Regexp-Log-Common|0.05|i686-linux-thread-multi-64int-ld|5.10.0 patch 34034|linux|2.6.24-16-generic|200806240537
1781223|pass|200806|dagolden@cpan.org (DAGOLDEN)|CPAN-YACSmoke-Plugin-Outlook|0.06|i686-linux-thread-multi-64int-ld|5.10.0 patch 34034|linux|2.6.24-16-generic|200806240527
1781069|pass|200806|dagolden@cpan.org (DAGOLDEN)|Test-YAML-Meta|0.10|i686-linux-64int-ld|5.8.8 patch 34066|linux|2.6.24-16-generic|200806240506
1779631|pass|200806|dagolden@cpan.org (DAGOLDEN)|WWW-Scraper-ISBN-Pearson_Driver|0.09|i686-linux-thread-multi-64int-ld|5.10.0 patch 34034|linux|2.6.24-16-generic|200806240143
1779622|fail|200806|dagolden@cpan.org (DAGOLDEN)|WWW-Scraper-ISBN-Yahoo_Driver|0.06|i686-linux-thread-multi-64int-ld|5.10.0 patch 34034|linux|2.6.24-16-generic|200806240142
1779020|pass|200806|srezic@cpan.org|Test-YAML-Meta|0.10|i386-freebsd-thread-multi|5.8.8|freebsd|6.1-release|200806240618
1778120|fail|200806|dagolden@cpan.org (DAGOLDEN)|WWW-Scraper-ISBN-Amazon_Driver|0.11|i686-linux-thread-multi-64int-ld|5.10.0 patch 34034|linux|2.6.24-16-generic|200806240243
1777989|fail|200806|dagolden@cpan.org (DAGOLDEN)|WWW-UsePerl-Journal-Thread|0.10|i686-linux-thread-multi-64int-ld|5.10.0 patch 34034|linux|2.6.24-16-generic|200806240217
1777987|pass|200806|dagolden@cpan.org (DAGOLDEN)|WWW-UsePerl-Journal|0.21|i686-linux-thread-multi-64int-ld|5.10.0 patch 34034|linux|2.6.24-16-generic|200806240217
1774380|fail|200806|chris@bingosnet.co.uk|WWW-UsePerl-Journal-Thread|0.10|darwin-thread-multi-64int-2level|5.10.0 patch 34065|darwin|8.10.0|200806231714
1774371|pass|200806|chris@bingosnet.co.uk|WWW-UsePerl-Journal|0.21|darwin-thread-multi-64int-2level|5.10.0 patch 34065|darwin|8.10.0|200806231712
1774338|fail|200806|chris@bingosnet.co.uk|WWW-Scraper-ISBN-Yahoo_Driver|0.06|darwin-thread-multi-64int-2level|5.10.0 patch 34065|darwin|8.10.0|200806231706
1774325|pass|200806|chris@bingosnet.co.uk|WWW-Scraper-ISBN-Pearson_Driver|0.09|darwin-thread-multi-64int-2level|5.10.0 patch 34065|darwin|8.10.0|200806231703
1774313|pass|200806|chris@bingosnet.co.uk|WWW-Scraper-ISBN-ORA_Driver|0.08|darwin-thread-multi-64int-2level|5.10.0 patch 34065|darwin|8.10.0|200806231700
1774290|fail|200806|chris@bingosnet.co.uk|WWW-Scraper-ISBN-Amazon_Driver|0.11|darwin-thread-multi-64int-2level|5.10.0 patch 34065|darwin|8.10.0|200806231657
1774263|pass|200806|chris@bingosnet.co.uk|Test-YAML-Meta|0.10|darwin-thread-multi-64int-2level|5.10.0 patch 34065|darwin|8.10.0|200806231651
1774221|pass|200806|dagolden@cpan.org (DAGOLDEN)|Finance-Currency-Convert-XE|0.15|i686-linux-thread-multi-64int-ld|5.10.0 patch 34034|linux|2.6.24-16-generic|200806231146
1774198|pass|200806|chris@bingosnet.co.uk|Test-CPAN-Meta|0.11|darwin-thread-multi-64int-2level|5.10.0 patch 34065|darwin|8.10.0|200806231642
1774179|pass|200806|chris@bingosnet.co.uk|Regexp-Log-Common|0.05|darwin-thread-multi-64int-2level|5.10.0 patch 34065|darwin|8.10.0|200806231640
1774142|pass|200806|chris@bingosnet.co.uk|Mail-File|0.08|darwin-thread-multi-64int-2level|5.10.0 patch 34065|darwin|8.10.0|200806231635
1774130|pass|200806|chris@bingosnet.co.uk|Games-Trackword|1.06|darwin-thread-multi-64int-2level|5.10.0 patch 34065|darwin|8.10.0|200806231633
1774122|pass|200806|chris@bingosnet.co.uk|GD-Chart-Radial|0.07|darwin-thread-multi-64int-2level|5.10.0 patch 34065|darwin|8.10.0|200806231631
1774104|pass|200806|chris@bingosnet.co.uk|Finance-Currency-Convert-XE|0.15|darwin-thread-multi-64int-2level|5.10.0 patch 34065|darwin|8.10.0|200806231627
1774091|pass|200806|chris@bingosnet.co.uk|Data-Phrasebook-Loader-YAML|0.09|darwin-thread-multi-64int-2level|5.10.0 patch 34065|darwin|8.10.0|200806231624
1774077|pass|200806|chris@bingosnet.co.uk|Data-Phrasebook-Loader-XML|0.12|darwin-thread-multi-64int-2level|5.10.0 patch 34065|darwin|8.10.0|200806231622
1774060|pass|200806|chris@bingosnet.co.uk|Data-Phrasebook-Loader-Ini|0.10|darwin-thread-multi-64int-2level|5.10.0 patch 34065|darwin|8.10.0|200806231620
1774050|pass|200806|chris@bingosnet.co.uk|Data-Phrasebook-Loader-DBI|0.11|darwin-thread-multi-64int-2level|5.10.0 patch 34065|darwin|8.10.0|200806231619
1774038|pass|200806|chris@bingosnet.co.uk|Data-Phrasebook|0.29|darwin-thread-multi-64int-2level|5.10.0 patch 34065|darwin|8.10.0|200806231617
1774029|pass|200806|chris@bingosnet.co.uk|Data-FormValidator-Constraints-Words|0.03|darwin-thread-multi-64int-2level|5.10.0 patch 34065|darwin|8.10.0|200806231615
1774020|pass|200806|chris@bingosnet.co.uk|Calendar-List|0.21|darwin-thread-multi-64int-2level|5.10.0 patch 34065|darwin|8.10.0|200806231613
1773993|pass|200806|chris@bingosnet.co.uk|CPAN-YACSmoke-Plugin-WebList|0.05|darwin-thread-multi-64int-2level|5.10.0 patch 34065|darwin|8.10.0|200806231608
1773969|pass|200806|chris@bingosnet.co.uk|CPAN-YACSmoke-Plugin-Outlook|0.06|darwin-thread-multi-64int-2level|5.10.0 patch 34065|darwin|8.10.0|200806231601
1773959|pass|200806|chris@bingosnet.co.uk|CPAN-YACSmoke-Plugin-NNTPWeb|0.06|darwin-thread-multi-64int-2level|5.10.0 patch 34065|darwin|8.10.0|200806231558
1773930|pass|200806|dagolden@cpan.org (DAGOLDEN)|Data-FormValidator-Constraints-Words|0.03|i686-linux-thread-multi-64int-ld|5.10.0 patch 34034|linux|2.6.24-16-generic|200806231053
1773896|pass|200806|chris@bingosnet.co.uk|CPAN-YACSmoke-Plugin-NNTP|0.05|darwin-thread-multi-64int-2level|5.10.0 patch 34065|darwin|8.10.0|200806231540
1772531|pass|200806|stro@cpan.org|Games-Trackword|1.05|i686-linux|5.8.8|linux|2.4.27-2-386|200806231239
1771556|pass|200806|dagolden@cpan.org (DAGOLDEN)|Test-CPAN-Meta|0.11|i686-linux-thread-multi-64int-ld|5.10.0 patch 34034|linux|2.6.24-16-generic|200806230418
1771555|pass|200806|dagolden@cpan.org (DAGOLDEN)|Games-Trackword|1.06|i686-linux-thread-multi-64int-ld|5.10.0 patch 34034|linux|2.6.24-16-generic|200806230418
1771497|pass|200806|dagolden@cpan.org (DAGOLDEN)|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi-64int-ld|5.10.0 patch 34034|linux|2.6.24-16-generic|200806230407
1771496|pass|200806|dagolden@cpan.org (DAGOLDEN)|Data-Phrasebook|0.29|i686-linux-thread-multi-64int-ld|5.10.0 patch 34034|linux|2.6.24-16-generic|200806230407
1771136|pass|200806|dagolden@cpan.org (DAGOLDEN)|Test-YAML-Meta|0.10|i686-linux-thread-multi-64int-ld|5.10.0 patch 34034|linux|2.6.24-16-generic|200806230312
1767997|pass|200806|stro@cpan.org|Test-YAML-Meta|0.09|i686-linux|5.10.0|linux|2.4.27-2-386|200806230125
1765104|pass|200806|andy@hexten.net|Test-YAML-Meta|0.10|i686-linux-thread-multi|5.10.0|linux|2.6.18-5-686|200806221951
1757459|fail|200806|srezic@cpan.org|WWW-Scraper-ISBN-Yahoo_Driver|0.06|i386-freebsd|5.10.0|freebsd|6.1-release|200806211849
1754111|pass|200806|dagolden@cpan.org (DAGOLDEN)|Regexp-Log-Common|0.05|i686-linux-64int-ld|5.6.2|linux|2.6.24-16-generic|200806210014
1754056|pass|200806|skendric@fhcrc.org|Test-YAML-Meta|0.10|i686-linux-thread-multi|5.8.8|linux|2.6.18-53.1.13.el5|200806201444
1753915|pass|200806|dagolden@cpan.org (DAGOLDEN)|CPAN-YACSmoke-Plugin-Outlook|0.06|i686-linux-64int-ld|5.6.2|linux|2.6.24-16-generic|200806210331
1753444|pass|200806|rlane10@wi.rr.com|Test-YAML-Meta|0.10|darwin-2level-ld|5.10.0|darwin|8.11.0|200806201137
1751237|pass|200806|dagolden@cpan.org (DAGOLDEN)|Data-Phrasebook-Loader-DBI|0.11|i686-linux-thread-multi-64int-ld|5.6.2|linux|2.6.24-16-generic|200806201706
1751236|pass|200806|dagolden@cpan.org (DAGOLDEN)|Data-Phrasebook-Loader-Ini|0.10|i686-linux-thread-multi-64int-ld|5.6.2|linux|2.6.24-16-generic|200806201706
1751235|pass|200806|dagolden@cpan.org (DAGOLDEN)|Data-Phrasebook-Loader-XML|0.12|i686-linux-thread-multi-64int-ld|5.6.2|linux|2.6.24-16-generic|200806201706
1751232|pass|200806|dagolden@cpan.org (DAGOLDEN)|Mail-File|0.08|i686-linux-thread-multi-64int-ld|5.6.2|linux|2.6.24-16-generic|200806201705
1751231|pass|200806|dagolden@cpan.org (DAGOLDEN)|Regexp-Log-Common|0.05|i686-linux-thread-multi-64int-ld|5.6.2|linux|2.6.24-16-generic|200806201705
1751145|pass|200806|dagolden@cpan.org (DAGOLDEN)|CPAN-YACSmoke-Plugin-Outlook|0.06|i686-linux-thread-multi-64int-ld|5.6.2|linux|2.6.24-16-generic|200806201657
1750277|pass|200806|smoretti@unil.ch|Test-YAML-Meta|0.10|i386-linux|5.8.6|linux|2.6.9-34.elsmp|200806201502
1747362|pass|200806|srezic@cpan.org|Data-Phrasebook-Loader-DBI|0.11|i386-freebsd-64int|5.8.8|freebsd|6.1-release|200806200937
1747361|pass|200806|srezic@cpan.org|Data-Phrasebook-Loader-XML|0.12|i386-freebsd-64int|5.8.8|freebsd|6.1-release|200806200937
1747360|pass|200806|srezic@cpan.org|Data-Phrasebook-Loader-Ini|0.10|i386-freebsd-64int|5.8.8|freebsd|6.1-release|200806200937
1747359|pass|200806|srezic@cpan.org|WWW-Scraper-ISBN-ORA_Driver|0.08|i386-freebsd-64int|5.8.8|freebsd|6.1-release|200806200936
1747348|pass|200806|srezic@cpan.org|Regexp-Log-Common|0.05|i386-freebsd|5.10.0|freebsd|6.1-release|200806200912
1747321|pass|200806|srezic@cpan.org|Regexp-Log-Common|0.05|i386-freebsd-64int|5.8.8|freebsd|6.1-release|200806200935
1747319|pass|200806|srezic@cpan.org|Mail-File|0.08|i386-freebsd-64int|5.8.8|freebsd|6.1-release|200806200935
1747198|pass|200806|srezic@cpan.org|WWW-Scraper-ISBN-ORA_Driver|0.08|i386-freebsd|5.10.0|freebsd|6.1-release|200806200911
1747164|pass|200806|srezic@cpan.org|CPAN-YACSmoke-Plugin-WebList|0.05|i386-freebsd-64int|5.8.8|freebsd|6.1-release|200806200907
1747163|pass|200806|srezic@cpan.org|CPAN-YACSmoke-Plugin-NNTP|0.05|i386-freebsd-64int|5.8.8|freebsd|6.1-release|200806200909
1747161|pass|200806|srezic@cpan.org|CPAN-YACSmoke-Plugin-Outlook|0.06|i386-freebsd-64int|5.8.8|freebsd|6.1-release|200806200907
1745397|pass|200806|srezic@cpan.org|Mail-File|0.08|i386-freebsd|5.6.2|freebsd|6.1-release|200806200511
1745396|pass|200806|srezic@cpan.org|Regexp-Log-Common|0.05|i386-freebsd|5.6.2|freebsd|6.1-release|200806200512
1745392|pass|200806|srezic@cpan.org|Data-Phrasebook-Loader-XML|0.12|i386-freebsd|5.6.2|freebsd|6.1-release|200806200510
1745391|pass|200806|srezic@cpan.org|Data-Phrasebook-Loader-Ini|0.10|i386-freebsd|5.6.2|freebsd|6.1-release|200806200509
1745390|pass|200806|srezic@cpan.org|Data-Phrasebook-Loader-DBI|0.11|i386-freebsd|5.6.2|freebsd|6.1-release|200806200509
1745316|pass|200806|srezic@cpan.org|CPAN-YACSmoke-Plugin-Outlook|0.06|i386-freebsd|5.6.2|freebsd|6.1-release|200806200500
1745314|pass|200806|srezic@cpan.org|CPAN-YACSmoke-Plugin-NNTP|0.05|i386-freebsd|5.6.2|freebsd|6.1-release|200806200459
1745041|fail|200806|dagolden@cpan.org (DAGOLDEN)|WWW-UsePerl-Journal-Thread|0.10|i686-linux-thread-multi-64int-ld|5.6.2|linux|2.6.24-16-generic|200806200225
1745040|pass|200806|dagolden@cpan.org (DAGOLDEN)|WWW-UsePerl-Journal|0.21|i686-linux-thread-multi-64int-ld|5.6.2|linux|2.6.24-16-generic|200806200225
1744322|pass|200806|srezic@cpan.org|Test-CPAN-Meta|0.11|i386-freebsd-64int|5.8.8|freebsd|6.1-release|200806200231
1744321|pass|200806|srezic@cpan.org|Games-Trackword|1.06|i386-freebsd-64int|5.8.8|freebsd|6.1-release|200806200231
1744319|pass|200806|srezic@cpan.org|Calendar-List|0.21|i386-freebsd-64int|5.8.8|freebsd|6.1-release|200806200232
1742442|pass|200806|dagolden@cpan.org (DAGOLDEN)|Data-FormValidator-Constraints-Words|0.03|i686-linux-64int-ld|5.6.2|linux|2.6.24-16-generic|200806191606
1741370|pass|200806|joel-cpan@fysh.org|Test-YAML-Meta|0.10|darwin-thread-multi-2level|5.8.8|darwin|9.0|200806181622
1741026|pass|200806|dagolden@cpan.org (DAGOLDEN)|Data-FormValidator-Constraints-Words|0.03|i686-linux-thread-multi-64int-ld|5.6.2|linux|2.6.24-16-generic|200806191230
1739686|pass|200806|chris@bingosnet.co.uk|Test-YAML-Meta|0.10|darwin-thread-multi-64int-2level|5.10.0 patch 34065|darwin|8.10.0|200806191350
1738988|pass|200806|srezic@cpan.org|Games-Trackword|1.06|i386-freebsd-thread-multi|5.10.0|freebsd|6.1-release|200806191255
1738987|pass|200806|srezic@cpan.org|Test-CPAN-Meta|0.11|i386-freebsd-thread-multi|5.10.0|freebsd|6.1-release|200806191255
1738984|pass|200806|srezic@cpan.org|Calendar-List|0.21|i386-freebsd-thread-multi|5.10.0|freebsd|6.1-release|200806191255
1737925|pass|200806|srezic@cpan.org|Test-CPAN-Meta|0.11|i386-freebsd|5.10.0|freebsd|6.1-release|200806190814
1737918|pass|200806|srezic@cpan.org|Games-Trackword|1.06|i386-freebsd|5.10.0|freebsd|6.1-release|200806190814
1737917|pass|200806|srezic@cpan.org|Calendar-List|0.21|i386-freebsd|5.10.0|freebsd|6.1-release|200806190813
1737081|pass|200806|dagolden@cpan.org (DAGOLDEN)|Test-CPAN-Meta|0.11|i686-linux-64int-ld|5.6.2|linux|2.6.24-16-generic|200806190321
1737076|pass|200806|dagolden@cpan.org (DAGOLDEN)|Games-Trackword|1.06|i686-linux-64int-ld|5.6.2|linux|2.6.24-16-generic|200806190321
1736998|pass|200806|dagolden@cpan.org (DAGOLDEN)|Data-Phrasebook|0.29|i686-linux-64int-ld|5.6.2|linux|2.6.24-16-generic|200806190254
1736628|pass|200806|dagolden@cpan.org (DAGOLDEN)|Test-CPAN-Meta|0.11|i686-linux-thread-multi-64int-ld|5.6.2|linux|2.6.24-16-generic|200806190159
1736627|pass|200806|dagolden@cpan.org (DAGOLDEN)|Games-Trackword|1.06|i686-linux-thread-multi-64int-ld|5.6.2|linux|2.6.24-16-generic|200806190159
1736561|pass|200806|dagolden@cpan.org (DAGOLDEN)|Data-Phrasebook|0.29|i686-linux-thread-multi-64int-ld|5.6.2|linux|2.6.24-16-generic|200806190150
1735631|pass|200806|chris@bingosnet.co.uk|Test-YAML-Meta|0.10|i386-netbsd-thread-multi-64int|5.11.0 patch 34073|netbsd|4.0|200806190008
1733599|pass|200806|srezic@cpan.org|Test-CPAN-Meta|0.11|i386-freebsd|5.8.8 patch 33662|freebsd|6.1-release-p23|200806182134
1733292|pass|200806|srezic@cpan.org|Test-YAML-Meta|0.10|i386-freebsd|5.8.8 patch 33662|freebsd|6.1-release-p23|200806182142
1732405|pass|200806|Jost.Krieger+smokeback@ruhr-uni-bochum.de ("Josts Smokehouse")|WWW-Scraper-ISBN-Pearson_Driver|0.09|sun4-solaris|5.10.0|solaris|2.9|200806182008
1732348|fail|200806|Jost.Krieger+smokeback@ruhr-uni-bochum.de ("Josts Smokehouse")|WWW-Scraper-ISBN-Yahoo_Driver|0.06|sun4-solaris|5.10.0|solaris|2.9|200806182004
1731449|pass|200806|chris@bingosnet.co.uk|Test-YAML-Meta|0.10|i386-freebsd-64int|5.8.8|freebsd|6.2-release|200806181717
1731253|pass|200806|chris@bingosnet.co.uk|Test-YAML-Meta|0.10|OpenBSD.i386-openbsd-thread-multi-64int|5.8.8|openbsd|4.2|200806181638
1730166|pass|200806|jlmartinez@capside.com|Mail-File|0.08|i386-freebsd|5.8.4|freebsd|4.7-release-p22|200806180108
1729810|pass|200806|jlmartinez@capside.com|Test-CPAN-Meta|0.11|i386-freebsd|5.8.4|freebsd|4.7-release-p22|200806180109
1729808|pass|200806|jlmartinez@capside.com|Regexp-Log-Common|0.05|i386-freebsd|5.8.4|freebsd|4.7-release-p22|200806180108
1729807|pass|200806|jlmartinez@capside.com|Calendar-List|0.21|i386-freebsd|5.8.4|freebsd|4.7-release-p22|200806180107
1729805|pass|200806|jlmartinez@capside.com|GD-Chart-Radial|0.07|i386-freebsd|5.8.4|freebsd|4.7-release-p22|200806180108
1729038|pass|200806|srezic@cpan.org|Test-YAML-Meta|0.10|i386-freebsd-thread-multi|5.10.0|freebsd|6.1-release|200806181435
1728243|pass|200806|srezic@cpan.org|Calendar-List|0.21|i386-freebsd|5.6.2|freebsd|6.1-release|200806181240
1728206|pass|200806|srezic@cpan.org|Test-CPAN-Meta|0.11|i386-freebsd|5.5.5|freebsd|6.1-release|200806181300
1728011|pass|200806|srezic@cpan.org|Games-Trackword|1.06|i386-freebsd|5.6.2|freebsd|6.1-release|200806181240
1728009|pass|200806|srezic@cpan.org|Test-CPAN-Meta|0.11|i386-freebsd|5.6.2|freebsd|6.1-release|200806181241
1726789|fail|200806|dagolden@cpan.org (DAGOLDEN)|CPAN-WWW-Testers-Generator|0.22|i686-linux-64int-ld|5.10.0 patch 34034|linux|2.6.24-16-generic|200806180502
1726250|pass|200806|srezic@cpan.org|Test-YAML-Meta|0.10|i386-freebsd-64int|5.8.8|freebsd|6.1-release|200806181008
1725852|pass|200806|srezic@cpan.org|Test-YAML-Meta|0.10|i386-freebsd|5.10.0|freebsd|6.1-release|200806180928
1723503|pass|200806|srezic@cpan.org|Games-Trackword|1.06|i386-freebsd|5.5.5|freebsd|6.1-release|200806180415
1722642|pass|200806|srezic@cpan.org|Test-YAML-Meta|0.10|i386-freebsd|5.6.2|freebsd|6.1-release|200806180227
1722119|pass|200806|cpan@ap0.org|Test-YAML-Meta|0.10|x86_64-linux|5.10.0|linux|2.6.18-53.1.14.el5|200806171209
1721741|pass|200806|cpan@ap0.org|Test-CPAN-Meta|0.11|x86_64-linux|5.10.0|linux|2.6.18-53.1.14.el5|200806171208
1719966|pass|200806|srezic@cpan.org|Games-Trackword|1.06|i386-freebsd|5.8.8 patch 33662|freebsd|6.1-release-p23|200806172151
1719201|pass|200806|dagolden@cpan.org (DAGOLDEN)|Data-Phrasebook-Loader-DBI|0.11|i686-linux-64int-ld|5.10.0 patch 34034|linux|2.6.24-16-generic|200806171437
1719200|pass|200806|dagolden@cpan.org (DAGOLDEN)|Data-Phrasebook-Loader-XML|0.12|i686-linux-64int-ld|5.10.0 patch 34034|linux|2.6.24-16-generic|200806171437
1719199|pass|200806|dagolden@cpan.org (DAGOLDEN)|WWW-Scraper-ISBN-ORA_Driver|0.08|i686-linux-64int-ld|5.10.0 patch 34034|linux|2.6.24-16-generic|200806171436
1719188|pass|200806|dagolden@cpan.org (DAGOLDEN)|Mail-File|0.08|i686-linux-64int-ld|5.10.0 patch 34034|linux|2.6.24-16-generic|200806171435
1719183|pass|200806|dagolden@cpan.org (DAGOLDEN)|Regexp-Log-Common|0.05|i686-linux-64int-ld|5.10.0 patch 34034|linux|2.6.24-16-generic|200806171435
1719071|pass|200806|dagolden@cpan.org (DAGOLDEN)|CPAN-YACSmoke-Plugin-Outlook|0.06|i686-linux-64int-ld|5.10.0 patch 34034|linux|2.6.24-16-generic|200806171423
1717461|pass|200806|srezic@cpan.org|Calendar-List|0.21|i386-freebsd|5.8.8 patch 33662|freebsd|6.1-release-p23|200806171733
1716738|pass|200806|dagolden@cpan.org (DAGOLDEN)|WWW-Scraper-ISBN-Pearson_Driver|0.09|i686-linux-64int-ld|5.10.0 patch 34034|linux|2.6.24-16-generic|200806171011
1716732|fail|200806|dagolden@cpan.org (DAGOLDEN)|WWW-Scraper-ISBN-Yahoo_Driver|0.06|i686-linux-64int-ld|5.10.0 patch 34034|linux|2.6.24-16-generic|200806171010
1715590|fail|200806|dagolden@cpan.org (DAGOLDEN)|WWW-Scraper-ISBN-Amazon_Driver|0.11|i686-linux-64int-ld|5.10.0 patch 34034|linux|2.6.24-16-generic|200806170655
1715424|fail|200806|dagolden@cpan.org (DAGOLDEN)|WWW-UsePerl-Journal-Thread|0.10|i686-linux-64int-ld|5.10.0 patch 34034|linux|2.6.24-16-generic|200806170622
1715421|pass|200806|dagolden@cpan.org (DAGOLDEN)|WWW-UsePerl-Journal|0.21|i686-linux-64int-ld|5.10.0 patch 34034|linux|2.6.24-16-generic|200806170622
1713208|pass|200806|dagolden@cpan.org (DAGOLDEN)|Finance-Currency-Convert-XE|0.15|i686-linux-64int-ld|5.10.0 patch 34034|linux|2.6.24-16-generic|200806170154
1712993|pass|200806|dagolden@cpan.org (DAGOLDEN)|Data-FormValidator-Constraints-Words|0.03|i686-linux-64int-ld|5.10.0 patch 34034|linux|2.6.24-16-generic|200806170109
1712965|pass|200806|chris@bingosnet.co.uk|Test-YAML-Meta|0.10|OpenBSD.i386-openbsd-thread-multi-64int|5.10.0|openbsd|4.2|200806170203
1712383|pass|200806|chris@bingosnet.co.uk|Test-YAML-Meta|0.10|i386-freebsd-64int|5.10.0|freebsd|7.0-release|200806170004
1711701|pass|200806|jj@jonallen.info ("JJ")|Calendar-List|0.21|darwin-2level|5.8.1|darwin|7.9.0|200806162212
1711158|pass|200806|chris@bingosnet.co.uk|Test-YAML-Meta|0.10|i686-linux-thread-multi-64int-ld|5.10.0 patch 34034|linux|2.4.26|200806162043
1710487|pass|200806|dagolden@cpan.org (DAGOLDEN)|Test-CPAN-Meta|0.11|i686-linux-64int-ld|5.10.0 patch 34034|linux|2.6.24-16-generic|200806161413
1710486|pass|200806|dagolden@cpan.org (DAGOLDEN)|Games-Trackword|1.06|i686-linux-64int-ld|5.10.0 patch 34034|linux|2.6.24-16-generic|200806161413
1710485|pass|200806|dagolden@cpan.org (DAGOLDEN)|Calendar-List|0.21|i686-linux-64int-ld|5.10.0 patch 34034|linux|2.6.24-16-generic|200806161413
1710412|pass|200806|dagolden@cpan.org (DAGOLDEN)|Data-Phrasebook-Loader-YAML|0.09|i686-linux-64int-ld|5.10.0 patch 34034|linux|2.6.24-16-generic|200806161402
1710410|pass|200806|dagolden@cpan.org (DAGOLDEN)|Data-Phrasebook|0.29|i686-linux-64int-ld|5.10.0 patch 34034|linux|2.6.24-16-generic|200806161402
1709975|pass|200806|dagolden@cpan.org (DAGOLDEN)|Test-YAML-Meta|0.10|i686-linux-64int-ld|5.10.0 patch 34034|linux|2.6.24-16-generic|200806161251
1709162|pass|200806|chris@bingosnet.co.uk|Test-YAML-Meta|0.10|i686-linux|5.8.6|linux|2.4.18|200806161426
1708013|pass|200806|dagolden@cpan.org (DAGOLDEN)|WWW-Scraper-ISBN-Pearson_Driver|0.09|i686-linux-64int-ld|5.11.0 patch 34053|linux|2.6.24-16-generic|200806160148
1708009|fail|200806|dagolden@cpan.org (DAGOLDEN)|WWW-Scraper-ISBN-Yahoo_Driver|0.06|i686-linux-64int-ld|5.11.0 patch 34053|linux|2.6.24-16-generic|200806160148
1707722|pass|200806|stro@cpan.org|Finance-Currency-Convert-XE|0.15|i386-freebsd-64int|5.8.8|freebsd|7.0-release|200806162149
1704877|fail|200806|dagolden@cpan.org (DAGOLDEN)|WWW-Scraper-ISBN-Amazon_Driver|0.11|i686-linux-64int-ld|5.11.0 patch 34053|linux|2.6.24-16-generic|200806151149
1704656|fail|200806|dagolden@cpan.org (DAGOLDEN)|WWW-UsePerl-Journal-Thread|0.10|i686-linux-64int-ld|5.11.0 patch 34053|linux|2.6.24-16-generic|200806151123
1704654|pass|200806|dagolden@cpan.org (DAGOLDEN)|WWW-UsePerl-Journal|0.21|i686-linux-64int-ld|5.11.0 patch 34053|linux|2.6.24-16-generic|200806151123
1700165|pass|200806|dagolden@cpan.org (DAGOLDEN)|Finance-Currency-Convert-XE|0.15|i686-linux-64int-ld|5.11.0 patch 34053|linux|2.6.24-16-generic|200806141606
1699918|pass|200806|dagolden@cpan.org (DAGOLDEN)|Data-FormValidator-Constraints-Words|0.03|i686-linux-64int-ld|5.11.0 patch 34053|linux|2.6.24-16-generic|200806141519
1697550|pass|200806|chris@bingosnet.co.uk|Test-YAML-Meta|0.10|i686-linux-thread-multi-64int-ld|5.11.0 patch 34053|linux|2.6.21.5-smp|200806141246
1697275|pass|200806|dagolden@cpan.org (DAGOLDEN)|Test-CPAN-Meta|0.11|i686-linux-64int-ld|5.11.0 patch 34053|linux|2.6.24-16-generic|200806140757
1697274|pass|200806|dagolden@cpan.org (DAGOLDEN)|Games-Trackword|1.06|i686-linux-64int-ld|5.11.0 patch 34053|linux|2.6.24-16-generic|200806140757
1696337|pass|200806|dagolden@cpan.org (DAGOLDEN)|Data-Phrasebook-Loader-YAML|0.09|i686-linux-64int-ld|5.11.0 patch 34053|linux|2.6.24-16-generic|200806140231
1696336|pass|200806|dagolden@cpan.org (DAGOLDEN)|Data-Phrasebook|0.29|i686-linux-64int-ld|5.11.0 patch 34053|linux|2.6.24-16-generic|200806140231
1695136|pass|200806|dagolden@cpan.org (DAGOLDEN)|Test-YAML-Meta|0.10|i686-linux-64int-ld|5.11.0 patch 34053|linux|2.6.24-16-generic|200806140103
1692568|pass|200806|stro@cpan.org|Data-FormValidator-Constraints-Words|0.03|i686-linux|5.8.8|linux|2.4.27-2-386|200806140033
1690574|fail|200806|Jost.Krieger+smokeback@ruhr-uni-bochum.de ("Josts Smokehouse")|WWW-Scraper-ISBN-Amazon_Driver|0.11|sun4-solaris|5.10.0|solaris|2.9|200806140011
1689425|pass|200806|Jost.Krieger+smokeback@ruhr-uni-bochum.de ("Josts Smokehouse")|GD-Chart-Radial|0.07|sun4-solaris|5.10.0|solaris|2.9|200806132246
1688976|pass|200806|chris@bingosnet.co.uk|Test-YAML-Meta|0.10|darwin-thread-multi-64int-2level|5.10.0 patch 34034|darwin|8.10.0|200806132112
1687618|pass|200806|chris@bingosnet.co.uk|Test-YAML-Meta|0.10|i386-freebsd-thread-multi-64int|5.8.8|freebsd|6.2-release|200806131725
1687187|pass|200806|chris@bingosnet.co.uk|Test-YAML-Meta|0.10|i686-linux-thread-multi-64int-ld|5.10.0 patch 34034|linux|2.4.26|200806131745
1686509|fail|200806|Jost.Krieger+smokeback@ruhr-uni-bochum.de ("Josts Smokehouse")|WWW-UsePerl-Journal-Thread|0.10|sun4-solaris|5.10.0|solaris|2.9|200806131736
1686497|pass|200806|Jost.Krieger+smokeback@ruhr-uni-bochum.de ("Josts Smokehouse")|WWW-UsePerl-Journal|0.21|sun4-solaris|5.10.0|solaris|2.9|200806131736
1686059|pass|200806|chris@bingosnet.co.uk|Test-YAML-Meta|0.10|i686-linux|5.8.6|linux|2.4.20|200806131455
1684487|fail|200806|dagolden@cpan.org (DAGOLDEN)|CPAN-WWW-Testers-Generator|0.22|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.24-16-generic|200806130823
1683501|pass|200806|d@0x64.nl (DEVOGON)|Test-YAML-Meta|0.10|i686-linux-thread-multi|5.11.0 patch 33261|linux|2.6.22-3-486|200806130758
1676377|pass|200806|dagolden@cpan.org (DAGOLDEN)|Data-Phrasebook-Loader-DBI|0.11|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.24-16-generic|200806121242
1676375|pass|200806|dagolden@cpan.org (DAGOLDEN)|Data-Phrasebook-Loader-Ini|0.10|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.24-16-generic|200806121242
1676374|pass|200806|dagolden@cpan.org (DAGOLDEN)|Data-Phrasebook-Loader-XML|0.12|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.24-16-generic|200806121241
1676365|fail|200806|dagolden@cpan.org (DAGOLDEN)|WWW-Scraper-ISBN-ORA_Driver|0.08|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.24-16-generic|200806121241
1676350|pass|200806|dagolden@cpan.org (DAGOLDEN)|Mail-File|0.08|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.24-16-generic|200806121240
1676348|pass|200806|dagolden@cpan.org (DAGOLDEN)|Regexp-Log-Common|0.05|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.24-16-generic|200806121240
1676235|pass|200806|dagolden@cpan.org (DAGOLDEN)|CPAN-YACSmoke-Plugin-Outlook|0.06|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.24-16-generic|200806121230
1675391|pass|200806|chris@bingosnet.co.uk|Test-YAML-Meta|0.10|i386-freebsd-thread-multi-64int|5.10.0|freebsd|6.2-release|200806121458
1675227|pass|200806|chris@bingosnet.co.uk|Test-YAML-Meta|0.10|i386-netbsd-thread-multi-64int|5.8.8|netbsd|4.0|200806121525
1674507|pass|200806|dagolden@cpan.org (DAGOLDEN)|WWW-Scraper-ISBN-Pearson_Driver|0.09|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.24-16-generic|200806120855
1674503|fail|200806|dagolden@cpan.org (DAGOLDEN)|WWW-Scraper-ISBN-Yahoo_Driver|0.06|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.24-16-generic|200806120855
1673760|pass|200806|david@cantrell.org.uk|Test-YAML-Meta|0.10|IP35-irix-64int|5.8.8|irix|6.5|200806121321
1673116|fail|200806|dagolden@cpan.org (DAGOLDEN)|WWW-Scraper-ISBN-Amazon_Driver|0.11|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.24-16-generic|200806120556
1672968|fail|200806|dagolden@cpan.org (DAGOLDEN)|WWW-UsePerl-Journal-Thread|0.10|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.24-16-generic|200806120529
1672966|pass|200806|dagolden@cpan.org (DAGOLDEN)|WWW-UsePerl-Journal|0.21|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.24-16-generic|200806120529
1669368|pass|200806|dagolden@cpan.org (DAGOLDEN)|Finance-Currency-Convert-XE|0.15|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.24-16-generic|200806120052
1668306|pass|200806|dagolden@cpan.org (DAGOLDEN)|Data-FormValidator-Constraints-Words|0.03|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.24-16-generic|200806111537
1667265|pass|200806|chris@bingosnet.co.uk|Data-Phrasebook-Loader-YAML|0.09|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0|200806111658
1667250|pass|200806|chris@bingosnet.co.uk|Data-Phrasebook|0.29|i386-netbsd-thread-multi-64int|5.10.0|netbsd|4.0|200806111657
1665532|pass|200806|dagolden@cpan.org (DAGOLDEN)|Test-CPAN-Meta|0.11|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.24-16-generic|200806110726
1665530|pass|200806|dagolden@cpan.org (DAGOLDEN)|Games-Trackword|1.06|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.24-16-generic|200806110726
1665423|pass|200806|dagolden@cpan.org (DAGOLDEN)|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.24-16-generic|200806110713
1665421|pass|200806|dagolden@cpan.org (DAGOLDEN)|Data-Phrasebook|0.29|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.24-16-generic|200806110713
1664746|pass|200806|dagolden@cpan.org (DAGOLDEN)|Test-YAML-Meta|0.10|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.24-16-generic|200806110546
1664665|pass|200806|dagolden@cpan.org (DAGOLDEN)|Mail-File|0.08|i686-linux-thread-multi-64int-ld|5.8.8 patch 33819|linux|2.6.24-16-generic|200806110536
1664664|pass|200806|dagolden@cpan.org (DAGOLDEN)|Regexp-Log-Common|0.05|i686-linux-thread-multi-64int-ld|5.8.8 patch 33819|linux|2.6.24-16-generic|200806110536
1664474|pass|200806|dagolden@cpan.org (DAGOLDEN)|CPAN-YACSmoke-Plugin-Outlook|0.06|i686-linux-thread-multi-64int-ld|5.8.8 patch 33819|linux|2.6.24-16-generic|200806110447
1661094|pass|200806|dagolden@cpan.org (DAGOLDEN)|WWW-Scraper-ISBN-Pearson_Driver|0.09|i686-linux-thread-multi-64int-ld|5.8.8 patch 33819|linux|2.6.24-16-generic|200806101807
1661089|fail|200806|dagolden@cpan.org (DAGOLDEN)|WWW-Scraper-ISBN-Yahoo_Driver|0.06|i686-linux-thread-multi-64int-ld|5.8.8 patch 33819|linux|2.6.24-16-generic|200806101807
1659934|pass|200806|stro@cpan.org|Games-Trackword|1.06|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.00|200806102300
1657338|fail|200806|dagolden@cpan.org (DAGOLDEN)|CPAN-WWW-Testers-Generator|0.22|i686-linux-64int-ld|5.8.8|linux|2.6.24-16-generic|200806101007
1656201|pass|200806|chris@bingosnet.co.uk|Test-YAML-Meta|0.10|i686-linux-thread-multi-64int|5.10.0|linux|2.4.26|200806101232
1655489|pass|200806|stro@cpan.org|Calendar-List|0.21|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.00|200806101258
1655397|pass|200806|chris@bingosnet.co.uk|Test-YAML-Meta|0.10|alpha-linux-thread-multi|5.11.0 patch 34031|linux|2.6.18-5-alpha-generic|200806101043
1652156|pass|200806|dagolden@cpan.org (DAGOLDEN)|Data-Phrasebook-Loader-DBI|0.11|i686-linux-64int-ld|5.8.8|linux|2.6.24-16-generic|200806100100
1652154|pass|200806|dagolden@cpan.org (DAGOLDEN)|Data-Phrasebook-Loader-Ini|0.10|i686-linux-64int-ld|5.8.8|linux|2.6.24-16-generic|200806100100
1652153|pass|200806|dagolden@cpan.org (DAGOLDEN)|Data-Phrasebook-Loader-XML|0.12|i686-linux-64int-ld|5.8.8|linux|2.6.24-16-generic|200806100059
1652152|fail|200806|dagolden@cpan.org (DAGOLDEN)|WWW-Scraper-ISBN-ORA_Driver|0.08|i686-linux-64int-ld|5.8.8|linux|2.6.24-16-generic|200806100059
1652146|pass|200806|dagolden@cpan.org (DAGOLDEN)|Mail-File|0.08|i686-linux-64int-ld|5.8.8|linux|2.6.24-16-generic|200806100058
1652145|pass|200806|dagolden@cpan.org (DAGOLDEN)|Regexp-Log-Common|0.05|i686-linux-64int-ld|5.8.8|linux|2.6.24-16-generic|200806100058
1652084|pass|200806|dagolden@cpan.org (DAGOLDEN)|CPAN-YACSmoke-Plugin-Outlook|0.06|i686-linux-64int-ld|5.8.8|linux|2.6.24-16-generic|200806100049
1651587|fail|200806|dagolden@cpan.org (DAGOLDEN)|WWW-Scraper-ISBN-Amazon_Driver|0.11|i686-linux-thread-multi-64int-ld|5.8.8 patch 33819|linux|2.6.24-16-generic|200806091918
1650639|pass|200806|dagolden@cpan.org (DAGOLDEN)|WWW-Scraper-ISBN-Pearson_Driver|0.09|i686-linux-64int-ld|5.8.8|linux|2.6.24-16-generic|200806091653
1650637|fail|200806|dagolden@cpan.org (DAGOLDEN)|WWW-Scraper-ISBN-Yahoo_Driver|0.06|i686-linux-64int-ld|5.8.8|linux|2.6.24-16-generic|200806091652
1650449|fail|200806|dagolden@cpan.org (DAGOLDEN)|WWW-UsePerl-Journal-Thread|0.10|i686-linux-thread-multi-64int-ld|5.8.8 patch 33819|linux|2.6.24-16-generic|200806091617
1650447|pass|200806|dagolden@cpan.org (DAGOLDEN)|WWW-UsePerl-Journal|0.21|i686-linux-thread-multi-64int-ld|5.8.8 patch 33819|linux|2.6.24-16-generic|200806091616
1648974|fail|200806|dagolden@cpan.org (DAGOLDEN)|WWW-Scraper-ISBN-Amazon_Driver|0.11|i686-linux-64int-ld|5.8.8|linux|2.6.24-16-generic|200806091117
1648795|fail|200806|dagolden@cpan.org (DAGOLDEN)|WWW-UsePerl-Journal-Thread|0.10|i686-linux-64int-ld|5.8.8|linux|2.6.24-16-generic|200806091048
1648793|pass|200806|dagolden@cpan.org (DAGOLDEN)|WWW-UsePerl-Journal|0.21|i686-linux-64int-ld|5.8.8|linux|2.6.24-16-generic|200806091048
1648349|pass|200806|perl@galumph.com ("Elliot Shank")|Test-YAML-Meta|0.10|darwin-thread-multi-2level|5.8.8|darwin|8.9.1|200806090447
1645920|pass|200806|chris@bingosnet.co.uk|Data-Phrasebook-Loader-YAML|0.09|i386-freebsd-64int|5.10.0|freebsd|7.0-release|200806090139
1645912|pass|200806|chris@bingosnet.co.uk|Data-Phrasebook|0.29|i386-freebsd-64int|5.10.0|freebsd|7.0-release|200806090137
1642719|fail|200806|dagolden@cpan.org (DAGOLDEN)|Mail-Outlook|0.13|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.1|200806080928
1642272|pass|200806|dagolden@cpan.org (DAGOLDEN)|Finance-Currency-Convert-XE|0.15|i686-linux-64int-ld|5.8.8|linux|2.6.24-16-generic|200806080808
1641865|pass|200806|dagolden@cpan.org (DAGOLDEN)|Data-FormValidator-Constraints-Words|0.03|i686-linux-64int-ld|5.8.8|linux|2.6.24-16-generic|200806080707
1641782|pass|200806|chris@bingosnet.co.uk|Test-YAML-Meta|0.10|i386-freebsd-64int|5.10.0|freebsd|7.0-release|200806080706
1641757|pass|200806|chris@bingosnet.co.uk|Test-CPAN-Meta|0.11|i386-freebsd-64int|5.10.0|freebsd|7.0-release|200806080702
1641747|pass|200806|chris@bingosnet.co.uk|Games-Trackword|1.06|i386-freebsd-64int|5.10.0|freebsd|7.0-release|200806080701
1641742|pass|200806|chris@bingosnet.co.uk|Calendar-List|0.21|i386-freebsd-64int|5.10.0|freebsd|7.0-release|200806080701
1641328|pass|200806|chris@bingosnet.co.uk|Test-CPAN-Meta|0.11|i386-freebsd-64int|5.11.0 patch 34005|freebsd|7.0-release|200806080603
1641315|pass|200806|chris@bingosnet.co.uk|Test-YAML-Meta|0.10|i386-freebsd-64int|5.11.0 patch 34005|freebsd|7.0-release|200806080602
1641305|pass|200806|chris@bingosnet.co.uk|Games-Trackword|1.06|i386-freebsd-64int|5.11.0 patch 34005|freebsd|7.0-release|200806080559
1641031|pass|200806|dagolden@cpan.org (DAGOLDEN)|Finance-Currency-Convert-XE|0.15|i686-linux-thread-multi-64int-ld|5.8.8 patch 33819|linux|2.6.24-16-generic|200806080452
1640009|pass|200806|dagolden@cpan.org (DAGOLDEN)|Data-FormValidator-Constraints-Words|0.03|i686-linux-thread-multi-64int-ld|5.8.8 patch 33819|linux|2.6.24-16-generic|200806080143
1638818|pass|200806|jj@jonallen.info ("JJ")|Finance-Currency-Convert-XE|0.15|darwin-2level|5.8.3|darwin|7.9.0|200806080100
1638803|pass|200806|chris@bingosnet.co.uk|Data-Phrasebook-Loader-YAML|0.09|i386-freebsd-64int|5.11.0 patch 34005|freebsd|7.0-release|200806080056
1638797|pass|200806|chris@bingosnet.co.uk|Data-Phrasebook|0.29|i386-freebsd-64int|5.11.0 patch 34005|freebsd|7.0-release|200806080056
1637741|pass|200806|dagolden@cpan.org (DAGOLDEN)|Test-YAML-Meta|0.10|i686-linux-64int-ld|5.8.8|linux|2.6.24-16-generic|200806071549
1637740|pass|200806|dagolden@cpan.org (DAGOLDEN)|Test-CPAN-Meta|0.11|i686-linux-64int-ld|5.8.8|linux|2.6.24-16-generic|200806071549
1637738|pass|200806|dagolden@cpan.org (DAGOLDEN)|Games-Trackword|1.06|i686-linux-64int-ld|5.8.8|linux|2.6.24-16-generic|200806071548
1637737|fail|200806|dagolden@cpan.org (DAGOLDEN)|Calendar-List|0.21|i686-linux-64int-ld|5.8.8|linux|2.6.24-16-generic|200806071548
1637643|pass|200806|dagolden@cpan.org (DAGOLDEN)|Data-Phrasebook-Loader-YAML|0.09|i686-linux-64int-ld|5.8.8|linux|2.6.24-16-generic|200806071531
1637642|pass|200806|dagolden@cpan.org (DAGOLDEN)|Data-Phrasebook|0.29|i686-linux-64int-ld|5.8.8|linux|2.6.24-16-generic|200806071531
1636941|pass|200806|stro@cpan.org|Data-Phrasebook-Loader-YAML|0.09|i686-linux|5.8.8|linux|2.4.27-2-386|200806071752
1636940|pass|200806|stro@cpan.org|Data-Phrasebook-Loader-XML|0.12|i686-linux|5.8.8|linux|2.4.27-2-386|200806071752
1636938|pass|200806|stro@cpan.org|Data-Phrasebook-Loader-Ini|0.10|i686-linux|5.8.8|linux|2.4.27-2-386|200806071752
1636937|pass|200806|stro@cpan.org|Data-Phrasebook-Loader-DBI|0.11|i686-linux|5.8.8|linux|2.4.27-2-386|200806071751
1636935|pass|200806|stro@cpan.org|Data-Phrasebook|0.29|i686-linux|5.8.8|linux|2.4.27-2-386|200806071751
1636643|pass|200806|andy@hexten.net|Test-YAML-Meta|0.10|darwin-thread-multi-2level|5.10.0|darwin|9.1.0|200806071805
1635681|pass|200806|andy@hexten.net|Test-YAML-Meta|0.10|i686-linux-thread-multi|5.10.0|linux|2.6.22-14-generic|200806071523
1632769|pass|200806|chris@bingosnet.co.uk|Data-Phrasebook|0.29|i86pc-solaris-thread-multi-64int|5.6.2|solaris|2.10|200806070948
1632554|pass|200806|rafl@debian.org|Test-YAML-Meta|0.10|i686-linux-multi|5.10.0|linux|2.6.24-rc5|200806070003
1632495|pass|200806|jj@jonallen.info ("JJ")|Finance-Currency-Convert-XE|0.15|darwin-2level|5.8.2|darwin|7.9.0|200806070911
1629277|pass|200806|dagolden@cpan.org (DAGOLDEN)|Test-YAML-Meta|0.10|i686-linux-thread-multi-64int-ld|5.8.8 patch 33819|linux|2.6.24-16-generic|200806070034
1629252|pass|200806|dagolden@cpan.org (DAGOLDEN)|Test-CPAN-Meta|0.11|i686-linux-thread-multi-64int-ld|5.8.8 patch 33819|linux|2.6.24-16-generic|200806070031
1629249|pass|200806|dagolden@cpan.org (DAGOLDEN)|Games-Trackword|1.06|i686-linux-thread-multi-64int-ld|5.8.8 patch 33819|linux|2.6.24-16-generic|200806070030
1629247|pass|200806|dagolden@cpan.org (DAGOLDEN)|Calendar-List|0.21|i686-linux-thread-multi-64int-ld|5.8.8 patch 33819|linux|2.6.24-16-generic|200806070030
1629235|fail|200806|dagolden@cpan.org (DAGOLDEN)|CPAN-WWW-Testers-Generator|0.22|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200806070027
1628963|pass|200806|dagolden@cpan.org (DAGOLDEN)|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi-64int-ld|5.8.8 patch 33819|linux|2.6.24-16-generic|200806061945
1628962|pass|200806|dagolden@cpan.org (DAGOLDEN)|Data-Phrasebook|0.29|i686-linux-thread-multi-64int-ld|5.8.8 patch 33819|linux|2.6.24-16-generic|200806061945
1627339|pass|200806|chris@bingosnet.co.uk|Test-CPAN-Meta|0.11|i86pc-solaris-thread-multi-64int|5.6.2|solaris|2.10|200806062135
1627319|pass|200806|chris@bingosnet.co.uk|Games-Trackword|1.06|i86pc-solaris-thread-multi-64int|5.6.2|solaris|2.10|200806062134
1627311|pass|200806|chris@bingosnet.co.uk|Calendar-List|0.21|i86pc-solaris-thread-multi-64int|5.6.2|solaris|2.10|200806062133
1626740|fail|200806|jj@jonallen.info ("JJ")|WWW-Scraper-ISBN-ORA_Driver|0.08|darwin-2level|5.8.1|darwin|7.9.0|200806062016
1623961|pass|200806|andy@hexten.net|Test-YAML-Meta|0.10|darwin-thread-multi-2level|5.10.0|darwin|9.2.2|200806061514
1622948|pass|200806|jj@jonallen.info ("JJ")|Data-FormValidator-Constraints-Words|0.03|darwin-2level|5.8.3|darwin|7.9.0|200806061339
1622481|fail|200806|dagolden@cpan.org (DAGOLDEN)|WWW-UsePerl-Journal-Thread|0.10|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200806060742
1622258|pass|200806|chris@bingosnet.co.uk|Test-CPAN-Meta|0.11|i86pc-solaris-thread-multi-64int|5.8.8|solaris|2.10|200806061145
1622256|pass|200806|chris@bingosnet.co.uk|Test-YAML-Meta|0.10|i86pc-solaris-thread-multi-64int|5.8.8|solaris|2.10|200806061144
1622246|pass|200806|chris@bingosnet.co.uk|Games-Trackword|1.06|i86pc-solaris-thread-multi-64int|5.8.8|solaris|2.10|200806061141
1622244|pass|200806|chris@bingosnet.co.uk|Calendar-List|0.21|i86pc-solaris-thread-multi-64int|5.8.8|solaris|2.10|200806061140
1621857|pass|200806|stro@cpan.org|CPAN-YACSmoke-Plugin-WebList|0.05|i686-linux|5.8.8|linux|2.4.27-2-386|200806060055
1621845|pass|200806|stro@cpan.org|CPAN-YACSmoke-Plugin-Outlook|0.06|i686-linux|5.8.8|linux|2.4.27-2-386|200806060053
1621843|pass|200806|stro@cpan.org|CPAN-YACSmoke-Plugin-NNTPWeb|0.06|i686-linux|5.8.8|linux|2.4.27-2-386|200806060053
1621829|pass|200806|stro@cpan.org|CPAN-YACSmoke-Plugin-NNTP|0.05|i686-linux|5.8.8|linux|2.4.27-2-386|200806060050
1621827|fail|200806|stro@cpan.org|CPAN-WWW-Testers-Generator|0.22|i686-linux|5.8.8|linux|2.4.27-2-386|200806060049
1621660|pass|200806|chris@bingosnet.co.uk|Test-CPAN-Meta|0.11|darwin-thread-multi-64int-2level|5.10.0 patch 33976|darwin|8.10.0|200806060939
1621651|pass|200806|chris@bingosnet.co.uk|Test-YAML-Meta|0.10|darwin-thread-multi-64int-2level|5.10.0 patch 33976|darwin|8.10.0|200806060937
1621628|pass|200806|chris@bingosnet.co.uk|Games-Trackword|1.06|darwin-thread-multi-64int-2level|5.10.0 patch 33976|darwin|8.10.0|200806060933
1621621|pass|200806|chris@bingosnet.co.uk|Calendar-List|0.21|darwin-thread-multi-64int-2level|5.10.0 patch 33976|darwin|8.10.0|200806060932
1621156|pass|200806|chris@bingosnet.co.uk|Test-CPAN-Meta|0.11|i86pc-solaris-thread-multi-64int|5.8.8|solaris|2.10|200806060733
1621152|pass|200806|chris@bingosnet.co.uk|Test-YAML-Meta|0.10|i86pc-solaris-thread-multi-64int|5.8.8|solaris|2.10|200806060732
1621142|pass|200806|chris@bingosnet.co.uk|Games-Trackword|1.06|i86pc-solaris-thread-multi-64int|5.8.8|solaris|2.10|200806060730
1621140|pass|200806|chris@bingosnet.co.uk|Calendar-List|0.21|i86pc-solaris-thread-multi-64int|5.8.8|solaris|2.10|200806060730
1621057|pass|200806|chris@bingosnet.co.uk|Test-YAML-Meta|0.10|i386-netbsd-thread-multi-64int|5.8.8|netbsd|3.1|200806060706
1620226|pass|200806|chris@bingosnet.co.uk|Data-Phrasebook-Loader-YAML|0.09|i86pc-solaris-thread-multi-64int|5.8.8|solaris|2.10|200806060533
1620222|pass|200806|chris@bingosnet.co.uk|Data-Phrasebook|0.29|i86pc-solaris-thread-multi-64int|5.8.8|solaris|2.10|200806060532
1619465|pass|200806|dagolden@cpan.org (DAGOLDEN)|Data-Phrasebook-Loader-DBI|0.11|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200806060242
1619464|pass|200806|dagolden@cpan.org (DAGOLDEN)|Data-Phrasebook-Loader-Ini|0.10|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200806060242
1619462|pass|200806|dagolden@cpan.org (DAGOLDEN)|Data-Phrasebook-Loader-XML|0.12|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200806060242
1619461|fail|200806|dagolden@cpan.org (DAGOLDEN)|WWW-Scraper-ISBN-ORA_Driver|0.08|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200806060242
1619456|pass|200806|dagolden@cpan.org (DAGOLDEN)|Mail-File|0.08|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200806060241
1619455|pass|200806|dagolden@cpan.org (DAGOLDEN)|Regexp-Log-Common|0.05|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200806060241
1619340|pass|200806|dagolden@cpan.org (DAGOLDEN)|CPAN-YACSmoke-Plugin-Outlook|0.06|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200806060228
1617946|fail|200806|jj@jonallen.info ("JJ")|WWW-Scraper-ISBN-Yahoo_Driver|0.06|darwin-2level|5.8.1|darwin|7.9.0|200806060021
1617094|pass|200806|dagolden@cpan.org (DAGOLDEN)|WWW-Scraper-ISBN-Pearson_Driver|0.09|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200806051756
1617085|fail|200806|dagolden@cpan.org (DAGOLDEN)|WWW-Scraper-ISBN-Yahoo_Driver|0.06|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200806051755
1615359|pass|200806|stro@cpan.org|Test-YAML-Meta|0.10|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.00|200806052152
1615059|fail|200806|dagolden@cpan.org (DAGOLDEN)|WWW-Scraper-ISBN-Amazon_Driver|0.11|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200806051421
1614779|pass|200806|dagolden@cpan.org (DAGOLDEN)|WWW-UsePerl-Journal|0.21|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200806051348
1614644|pass|200806|chris@bingosnet.co.uk|Data-Phrasebook-Loader-YAML|0.09|i86pc-solaris-thread-multi-64int|5.10.0|solaris|2.10|200806051831
1614621|pass|200806|chris@bingosnet.co.uk|Data-Phrasebook|0.29|i86pc-solaris-thread-multi-64int|5.10.0|solaris|2.10|200806051829
1614539|pass|200806|jj@jonallen.info ("JJ")|Calendar-List|0.21|darwin-2level|5.8.2|darwin|7.9.0|200806051820
1614062|pass|200806|chris@bingosnet.co.uk|Data-Phrasebook-Loader-YAML|0.09|i86pc-solaris-thread-multi-64int|5.8.8|solaris|2.10|200806051729
1614051|pass|200806|chris@bingosnet.co.uk|Data-Phrasebook|0.29|i86pc-solaris-thread-multi-64int|5.8.8|solaris|2.10|200806051729
1613717|pass|200806|chris@bingosnet.co.uk|Data-Phrasebook-Loader-YAML|0.09|darwin-thread-multi-64int-2level|5.10.0 patch 33976|darwin|8.10.0|200806051656
1613707|pass|200806|chris@bingosnet.co.uk|Data-Phrasebook|0.29|darwin-thread-multi-64int-2level|5.10.0 patch 33976|darwin|8.10.0|200806051656
1612193|pass|200806|chris@bingosnet.co.uk|Data-Phrasebook-Loader-YAML|0.09|i86pc-solaris-thread-multi-64int|5.10.0|solaris|2.10|200806051426
1612182|pass|200806|icerider70@gmail.com ("ICERIDER")|Calendar-List|0.21|i386-linux|5.8.8|linux|2.6.18-53.el5|200806050825
1612176|pass|200806|chris@bingosnet.co.uk|Data-Phrasebook|0.29|i86pc-solaris-thread-multi-64int|5.10.0|solaris|2.10|200806051425
1612173|pass|200806|icerider70@gmail.com ("ICERIDER")|Games-Trackword|1.06|i386-linux|5.8.8|linux|2.6.18-53.el5|200806050824
1612168|pass|200806|icerider70@gmail.com ("ICERIDER")|Test-YAML-Meta|0.10|i386-linux|5.8.8|linux|2.6.18-53.el5|200806050824
1612160|pass|200806|icerider70@gmail.com ("ICERIDER")|Test-CPAN-Meta|0.11|i386-linux|5.8.8|linux|2.6.18-53.el5|200806050823
1609410|pass|200806|dagolden@cpan.org (DAGOLDEN)|Finance-Currency-Convert-XE|0.15|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200806050200
1609322|fail|200806|jj@jonallen.info ("JJ")|WWW-Scraper-ISBN-Amazon_Driver|0.11|darwin-2level|5.8.1|darwin|7.9.0|200806050642
1609208|fail|200806|jj@jonallen.info ("JJ")|WWW-UsePerl-Journal-Thread|0.10|darwin-2level|5.8.1|darwin|7.9.0|200806050620
1609071|pass|200806|dagolden@cpan.org (DAGOLDEN)|Data-FormValidator-Constraints-Words|0.03|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200806050045
1607971|pass|200806|chris@bingosnet.co.uk|Test-YAML-Meta|0.10|i86pc-solaris-thread-multi-64int|5.10.0|solaris|2.10|200806050254
1607952|pass|200806|chris@bingosnet.co.uk|Test-CPAN-Meta|0.11|i86pc-solaris-thread-multi-64int|5.10.0|solaris|2.10|200806050252
1607946|pass|200806|chris@bingosnet.co.uk|Games-Trackword|1.06|i86pc-solaris-thread-multi-64int|5.10.0|solaris|2.10|200806050251
1607938|pass|200806|chris@bingosnet.co.uk|Calendar-List|0.21|i86pc-solaris-thread-multi-64int|5.10.0|solaris|2.10|200806050251
1607408|pass|200806|Jost.Krieger+smokeback@ruhr-uni-bochum.de ("Josts Smokehouse")|Finance-Currency-Convert-XE|0.15|sun4-solaris|5.10.0|solaris|2.9|200806050234
1605389|pass|200806|chris@bingosnet.co.uk|Test-YAML-Meta|0.10|i86pc-solaris-thread-multi-64int|5.10.0|solaris|2.10|200806042233
1605361|pass|200806|chris@bingosnet.co.uk|Test-CPAN-Meta|0.11|i86pc-solaris-thread-multi-64int|5.10.0|solaris|2.10|200806042230
1605352|pass|200806|chris@bingosnet.co.uk|Games-Trackword|1.06|i86pc-solaris-thread-multi-64int|5.10.0|solaris|2.10|200806042229
1605347|pass|200806|chris@bingosnet.co.uk|Calendar-List|0.21|i86pc-solaris-thread-multi-64int|5.10.0|solaris|2.10|200806042229
1605127|pass|200806|d@0x64.nl (devogon)|Calendar-List|0.21|x86_64-linux-gnu|5.10.0|linux|2.6.18-6-xen-amd64|200806042317
1605106|pass|200806|d@0x64.nl (devogon)|Test-YAML-Meta|0.10|x86_64-linux-gnu|5.10.0|linux|2.6.18-6-xen-amd64|200806042315
1605102|pass|200806|d@0x64.nl (devogon)|Test-CPAN-Meta|0.11|x86_64-linux-gnu|5.10.0|linux|2.6.18-6-xen-amd64|200806042315
1604193|pass|200806|g.grigelionis@computer.org|Test-YAML-Meta|0.10|i586-linux-thread-multi|5.8.5|linux|2.6.8.1|200806041823
1602965|pass|200806|chris@bingosnet.co.uk|Games-Trackword|1.06|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.21.5-smp|200806041750
1602959|pass|200806|chris@bingosnet.co.uk|Test-CPAN-Meta|0.11|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.21.5-smp|200806041749
1602944|pass|200806|chris@bingosnet.co.uk|Test-YAML-Meta|0.10|i686-linux-thread-multi-64int-ld|5.8.8|linux|2.6.21.5-smp|200806041748
1602099|pass|200806|dagolden@cpan.org (DAGOLDEN)|Test-CPAN-Meta|0.11|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200806041212
1602096|pass|200806|dagolden@cpan.org (DAGOLDEN)|Test-YAML-Meta|0.10|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200806041212
1602093|pass|200806|dagolden@cpan.org (DAGOLDEN)|Games-Trackword|1.06|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200806041212
1602091|pass|200806|dagolden@cpan.org (DAGOLDEN)|Calendar-List|0.21|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200806041212
1601665|pass|200806|dagolden@cpan.org (DAGOLDEN)|Data-Phrasebook-Loader-YAML|0.09|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200806041119
1601664|pass|200806|dagolden@cpan.org (DAGOLDEN)|Data-Phrasebook|0.29|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.24-16-generic|200806041119
1600273|pass|200806|dagolden@cpan.org (DAGOLDEN)|Test-CPAN-Meta|0.11|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.1|200806040908
1600259|pass|200806|dagolden@cpan.org (DAGOLDEN)|Test-YAML-Meta|0.10|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.1|200806040906
1600243|pass|200806|dagolden@cpan.org (DAGOLDEN)|Games-Trackword|1.06|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.1|200806040902
1600203|pass|200806|dagolden@cpan.org (DAGOLDEN)|Calendar-List|0.21|MSWin32-x86-multi-thread|5.10.0|MSWin32|5.1|200806040859
1599571|pass|200806|Jost.Krieger+smokeback@ruhr-uni-bochum.de ("Josts Smokehouse")|Data-FormValidator-Constraints-Words|0.03|sun4-solaris|5.10.0|solaris|2.9|200806041407
1598774|pass|200806|stro@cpan.org|Test-YAML-Meta|0.10|MSWin32-x86-multi-thread|5.8.8|MSWin32|5.00|200806041342
1598003|pass|200806|imacat@mail.imacat.idv.tw|Test-YAML-Meta|0.10|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.22.10|200806041711
1597990|pass|200806|imacat@mail.imacat.idv.tw|Test-CPAN-Meta|0.11|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.22.10|200806041711
1597979|pass|200806|imacat@mail.imacat.idv.tw|Games-Trackword|1.06|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.22.10|200806041711
1597969|pass|200806|imacat@mail.imacat.idv.tw|Calendar-List|0.21|x86_64-linux-thread-multi-ld|5.10.0|linux|2.6.22.10|200806041710
1597851|pass|200806|imacat@mail.imacat.idv.tw|Test-YAML-Meta|0.10|x86_64-linux-thread-multi-ld|5.8.8|linux|2.6.22.10|200806041707
1597847|pass|200806|imacat@mail.imacat.idv.tw|Test-CPAN-Meta|0.11|x86_64-linux-thread-multi-ld|5.8.8|linux|2.6.22.10|200806041706
1597842|pass|200806|imacat@mail.imacat.idv.tw|Games-Trackword|1.06|x86_64-linux-thread-multi-ld|5.8.8|linux|2.6.22.10|200806041705
1597837|pass|200806|imacat@mail.imacat.idv.tw|Calendar-List|0.21|x86_64-linux-thread-multi-ld|5.8.8|linux|2.6.22.10|200806041705
1597664|pass|200806|claco@chrislaco.com ("Christopher H. Laco")|Test-YAML-Meta|0.10|darwin-thread-multi-2level|5.8.6|darwin|8.0|200806031755
1597574|pass|200806|g.grigelionis@computer.org|Test-YAML-Meta|0.10|x86_64-linux|5.8.8|linux|2.6.5-7.276-smp|200806031922
1597564|pass|200806|g.grigelionis@computer.org|Test-YAML-Meta|0.10|i386-linux|5.8.0|linux|2.6.9-22.18.bz155725.elsmp|200806031925
1597559|pass|200806|g.grigelionis@computer.org|Test-YAML-Meta|0.10|x86_64-linux-thread-multi|5.8.3|linux|2.6.4|200806031924
1597548|pass|200806|g.grigelionis@computer.org|Test-YAML-Meta|0.10|i586-linux-thread-multi|5.8.8|linux|2.6.16|200806031902
1595315|pass|200806|chris@bingosnet.co.uk|Test-YAML-Meta|0.10|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.21.5-smp|200806040315
1595287|pass|200806|chris@bingosnet.co.uk|Test-CPAN-Meta|0.11|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.21.5-smp|200806040311
1595282|pass|200806|chris@bingosnet.co.uk|Games-Trackword|1.06|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.21.5-smp|200806040310
1595279|pass|200806|chris@bingosnet.co.uk|Calendar-List|0.21|i686-linux-thread-multi-64int-ld|5.10.0|linux|2.6.21.5-smp|200806040309
1594624|pass|200806|jj@jonallen.info ("JJ")|Data-FormValidator-Constraints-Words|0.03|darwin-2level|5.8.2|darwin|7.9.0|200806040228
1594159|fail|200806|dagolden@cpan.org (DAGOLDEN)|CPAN-WWW-Testers-Generator|0.22|i686-linux-64int-ld|5.10.0|linux|2.6.24-16-generic|200806031858
1592796|fail|200806|dagolden@cpan.org (DAGOLDEN)|Data-Phrasebook|0.29|i686-linux-64int-ld|5.8.8 patch 33935|linux|2.6.24-16-generic|200806031343
1592717|pass|200806|dagolden@cpan.org (DAGOLDEN)|Test-CPAN-Meta|0.11|i686-linux-64int-ld|5.8.8 patch 33935|linux|2.6.24-16-generic|200806031335
1592716|pass|200806|dagolden@cpan.org (DAGOLDEN)|Test-YAML-Meta|0.10|i686-linux-64int-ld|5.8.8 patch 33935|linux|2.6.24-16-generic|200806031334
1592715|pass|200806|dagolden@cpan.org (DAGOLDEN)|Games-Trackword|1.06|i686-linux-64int-ld|5.8.8 patch 33935|linux|2.6.24-16-generic|200806031334
1592610|pass|200806|dagolden@cpan.org (DAGOLDEN)|Test-CPAN-Meta|0.11|i686-linux-64int-ld|5.10.0|linux|2.6.24-16-generic|200806031314
1592609|pass|200806|dagolden@cpan.org (DAGOLDEN)|Test-YAML-Meta|0.10|i686-linux-64int-ld|5.10.0|linux|2.6.24-16-generic|200806031314
1592608|pass|200806|dagolden@cpan.org (DAGOLDEN)|Calendar-List|0.21|i686-linux-64int-ld|5.10.0|linux|2.6.24-16-generic|200806031313
1592607|pass|200806|dagolden@cpan.org (DAGOLDEN)|Games-Trackword|1.06|i686-linux-64int-ld|5.10.0|linux|2.6.24-16-generic|200806031314
1592166|pass|200806|vpit@cpan.org|Test-YAML-Meta|0.10|x86_64-linux-thread-multi|5.10.0|linux|2.6.24.2-fuuka.profvince.com|200806031631
1592154|pass|200806|vpit@cpan.org|Test-YAML-Meta|0.10|i686-linux-thread-multi|5.10.0|linux|2.6.18.3-tmb-desktop-2mdvsmp|200806031301
1591764|pass|200806|david@cantrell.org.uk|Test-YAML-Meta|0.10|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200806030942
1591749|pass|200806|david@cantrell.org.uk|Test-CPAN-Meta|0.11|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200806030940
1591736|pass|200806|david@cantrell.org.uk|Games-Trackword|1.06|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200806030939
1591727|pass|200806|david@cantrell.org.uk|Calendar-List|0.21|sun4-solaris-thread-multi|5.10.0|solaris|2.9|200806030938
1591686|pass|200806|david@cantrell.org.uk|Test-YAML-Meta|0.10|IP35-irix|5.8.8|irix|6.5|200806031633
1591678|pass|200806|david@cantrell.org.uk|Test-CPAN-Meta|0.11|IP35-irix|5.8.8|irix|6.5|200806031632
1591671|pass|200806|david@cantrell.org.uk|Games-Trackword|1.06|IP35-irix|5.8.8|irix|6.5|200806031631
1591666|pass|200806|david@cantrell.org.uk|Calendar-List|0.21|IP35-irix|5.8.8|irix|6.5|200806031631
1591658|pass|200806|david@cantrell.org.uk|Test-YAML-Meta|0.10|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200806030936
1591647|pass|200806|david@cantrell.org.uk|Test-CPAN-Meta|0.11|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200806030935
1591642|pass|200806|david@cantrell.org.uk|Test-YAML-Meta|0.10|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200806031527
1591638|pass|200806|david@cantrell.org.uk|Games-Trackword|1.06|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200806031526
1591637|pass|200806|david@cantrell.org.uk|Test-CPAN-Meta|0.11|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200806031526
1591635|pass|200806|david@cantrell.org.uk|Games-Trackword|1.06|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200806030933
1591633|pass|200806|david@cantrell.org.uk|Calendar-List|0.21|darwin-thread-multi-2level|5.10.0|darwin|8.10.1|200806031526
1591622|pass|200806|david@cantrell.org.uk|Calendar-List|0.21|i386-freebsd-thread-multi|5.10.0|freebsd|6.2-release|200806030932
1591576|pass|200806|david@cantrell.org.uk|Test-YAML-Meta|0.10|alpha-netbsd|5.10.0|netbsd|2.1.0_stable|200806031412
1591572|pass|200806|david@cantrell.org.uk|Test-CPAN-Meta|0.11|alpha-netbsd|5.10.0|netbsd|2.1.0_stable|200806031411
1591567|pass|200806|david@cantrell.org.uk|Games-Trackword|1.06|alpha-netbsd|5.10.0|netbsd|2.1.0_stable|200806031410
1591563|pass|200806|david@cantrell.org.uk|Calendar-List|0.21|alpha-netbsd|5.10.0|netbsd|2.1.0_stable|200806031409
1591513|pass|200806|david@cantrell.org.uk|Test-YAML-Meta|0.10|i686-linux-thread-multi|5.10.0|linux|2.4.27-3-686|200806031451
1591507|pass|200806|david@cantrell.org.uk|Test-CPAN-Meta|0.11|i686-linux-thread-multi|5.10.0|linux|2.4.27-3-686|200806031451
1591503|pass|200806|david@cantrell.org.uk|Games-Trackword|1.06|i686-linux-thread-multi|5.10.0|linux|2.4.27-3-686|200806031450
1591502|pass|200806|david@cantrell.org.uk|Calendar-List|0.21|i686-linux-thread-multi|5.10.0|linux|2.4.27-3-686|200806031450
1591265|pass|200806|dagolden@cpan.org (DAGOLDEN)|Data-Phrasebook-Loader-DBI|0.11|i686-linux-64int-ld|5.8.8 patch 33935|linux|2.6.24-16-generic|200806030916
1591263|pass|200806|dagolden@cpan.org (DAGOLDEN)|Data-Phrasebook-Loader-Ini|0.10|i686-linux