use warnings;
use strict;
use utf8;
use YAML::Syck;
use feature 'say';

my %data;

$data{greetings} = <<'BLOCK';
Siebel Enterprise Applications Siebel Server Manager, Version 8.1.1.5 [21229] LANG_INDEPENDENT 
Copyright (c) 1990-2008, Oracle. All rights reserved.

The Programs (which include both the software and documentation) contain
proprietary information; they are provided under a license agreement containing
restrictions on use and disclosure and are also protected by copyright, patent,
and other intellectual and industrial property laws. Reverse engineering,
disassembly, or decompilation of the Programs, except to the extent required to
obtain interoperability with other independently created software or as specified
by law, is prohibited.

Oracle, JD Edwards, PeopleSoft, and Siebel are registered trademarks of
Oracle Corporation and/or its affiliates. Other names may be trademarks
of their respective owners.

If you have received this software in error, please notify Oracle Corporation
immediately at 1.800.ORACLE1.

Type "help" for list of commands, "help <topic>" for detailed help

Connected to 1 server(s) out of a total of 1 server(s) in the enterprise
BLOCK

$data{load_preferences} = <<'BLOCK';
srvrmgr> load preferences
File: C:\Siebel\8.1\Client\BIN\.Siebel_svrmgr.pref
BLOCK

$data{ls_comp} = <<'BLOCK';
SV_NAME     CC_ALIAS                   CC_NAME                                              CT_ALIAS         CG_ALIAS        CC_RUNMODE   CP_DISP_RUN_STATE  CP_NUM_RUN_TASKS  CP_MAX_TASKS  CP_ACTV_MTS_PROCS  CP_MAX_MTS_PROCS  CP_START_TIME        CP_END_TIME  CP_STATUS  CC_INCARN_NO  CC_DESC_TEXT  
----------  -------------------------  ---------------------------------------------------  ---------------  --------------  -----------  -----------------  ----------------  ------------  -----------------  ----------------  -------------------  -----------  ---------  ------------  ------------  
siebfoobar  ADMBatchProc               Application Deployment Manager Batch Processor       BusSvcMgr        ADM             Batch        Online             0                 1             1                  1                 2013-04-22 15:32:31               Enabled                                
siebfoobar  ADMObjMgr_enu              Application Deployment Manager Object Manager (ENU)  AppObjMgr        ADM             Interactive  Online             0                 20            1                  1                 2013-04-22 15:32:31               Enabled                                
siebfoobar  ADMObjMgr_ptb              Application Deployment Manager Object Manager (PTB)  AppObjMgr        ADM             Interactive  Online             0                 20            1                  1                 2013-04-22 15:32:31               Enabled                                
siebfoobar  ADMProc                    Application Deployment Manager Processor             BusSvcMgr        ADM             Batch        Online             0                 3             1                  1                 2013-04-22 15:32:31               Enabled                                
siebfoobar  AsgnSrvr                   Assignment Manager                                   AsgnSrvr         AsgnMgmt        Batch        Online             0                 20            1                  1                 2013-04-22 15:32:31               Enabled                                
siebfoobar  AsgnBatch                  Batch Assignment                                     AsgnBatch        AsgnMgmt        Batch        Online             0                 20                                                 2013-04-22 15:32:31               Enabled                                
siebfoobar  BusIntBatchMgr             Business Integration Batch Manager                   BusSvcMgr        EAI             Batch        Online             0                 20            1                  1                 2013-04-22 15:32:31               Enabled                                
siebfoobar  BusIntMgr                  Business Integration Manager                         BusSvcMgr        EAI             Batch        Online             0                 20            1                  1                 2013-04-22 15:32:31               Enabled                                
siebfoobar  CommConfigMgr              Communications Configuration Manager                 BusSvcMgr        CommMgmt        Batch        Online             0                 20            1                  1                 2013-04-22 15:32:31               Enabled                                
siebfoobar  CommInboundProcessor       Communications Inbound Processor                     BusSvcMgr        CommMgmt        Batch        Online             0                 50            1                  1                 2013-04-22 15:32:31               Enabled                                
siebfoobar  CommInboundRcvr            Communications Inbound Receiver                      CommInboundRcvr  CommMgmt        Batch        Online             0                 21            1                  1                 2013-04-22 15:32:31               Enabled                                
siebfoobar  CommOutboundMgr            Communications Outbound Manager                      BusSvcMgr        CommMgmt        Batch        Online             0                 50            1                  1                 2013-04-22 15:32:31               Enabled                                
siebfoobar  CommSessionMgr             Communications Session Manager                       CommSessionMgr   CommMgmt        Batch        Online             0                 20            1                  1                 2013-04-22 15:32:31               Enabled                                
siebfoobar  CustomAppObjMgr_enu        Custom Application Object Manager (ENU)              CustomAppObjMgr  EAI             Interactive  Online             0                 20            1                  1                 2013-04-22 15:32:31               Enabled                                
siebfoobar  CustomAppObjMgr_ptb        Custom Application Object Manager (PTB)              CustomAppObjMgr  EAI             Interactive  Online             0                 20            1                  1                 2013-04-22 15:32:31               Enabled                                
siebfoobar  DbXtract                   Database Extract                                     DbXtract         Remote          Batch        Online             0                 10                                                 2013-04-22 15:32:31               Enabled                                
siebfoobar  EAIObjMgr_enu              EAI Object Manager (ENU)                             EAIObjMgr        EAI             Interactive  Running            20                500           1                  8                 2013-04-22 15:32:31               Enabled                                
siebfoobar  EAIObjMgr_ptb              EAI Object Manager (PTB)                             EAIObjMgr        EAI             Interactive  Online             0                 500           1                  8                 2013-04-22 15:32:31               Enabled                                
siebfoobar  MailMgr                    Email Manager                                        MailMgr          CommMgmt        Background   Online             0                 20                                                 2013-04-22 15:32:31               Enabled                                
siebfoobar  EIM                        Enterprise Integration Mgr                           EIM              EAI             Batch        Online             0                 5                                                  2013-04-22 15:32:31               Enabled                                
siebfoobar  FSMSrvr                    File System Manager                                  FSMSrvr          SystemAux       Batch        Online             0                 20            1                  1                 2013-04-22 15:32:25               Enabled                                
siebfoobar  GenNewDb                   Generate New Database                                GenNewDb         Remote          Batch        Online             0                 1                                                  2013-04-22 15:32:31               Enabled                                
siebfoobar  GenTrig                    Generate Triggers                                    GenTrig          Workflow        Batch        Online             0                 1                                                  2013-04-22 15:32:31               Enabled                                
siebfoobar  htimObjMgr_enu             HTIM Object Manager (ENU)                            AppObjMgr        HTIM            Interactive  Online             0                 20            1                  1                 2013-04-22 15:32:31               Enabled                                
siebfoobar  htimObjMgr_ptb             HTIM Object Manager (PTB)                            AppObjMgr        HTIM            Interactive  Online             0                 20            1                  1                 2013-04-22 15:32:31               Enabled                                
siebfoobar  htimprmObjMgr_enu          HTIM PRM Object Manager (ENU)                        AppObjMgr        HTIM            Interactive  Online             0                 20            1                  1                 2013-04-22 15:32:31               Enabled                                
siebfoobar  htimprmObjMgr_ptb          HTIM PRM Object Manager (PTB)                        AppObjMgr        HTIM            Interactive  Online             0                 20            1                  1                 2013-04-22 15:32:31               Enabled                                
siebfoobar  JMSReceiver                JMS Receiver                                         EAIRcvr          EAI             Background   Online             0                 20                                                 2013-04-22 15:32:31               Enabled                                
siebfoobar  ListImportSvcMgr           List Import Service Manager                          BusSvcMgr        MktgSrv         Batch        Online             0                 20            1                  1                 2013-04-22 15:32:31               Enabled                                
siebfoobar  PDbXtract                  Parallel Database Extract                            DbXtract         Remote          Batch        Online             0                 10            1                  1                 2013-04-22 15:32:31               Enabled                                
siebfoobar  RepAgent                   Replication Agent                                    RepAgent         Remote          Background   Online             0                 1                                                  2013-04-22 15:32:31               Enabled                                
siebfoobar  SERAssetRecCMon            SER Asset Recipro Canceled Monitor                   WorkMon          Workflow        Background   Running            1                 1                                                  2013-04-22 15:32:31               Enabled                                
siebfoobar  SERAssetWorkMon            SER Asset Workflow Monitor Agent                     WorkMon          Workflow        Background   Running            1                 1                                                  2013-04-22 15:32:31               Enabled                                
siebfoobar  ServerMgr                  Server Manager                                       ServerMgr        System          Interactive  Running            1                 20                                                 2013-04-22 15:32:25               Enabled                                
siebfoobar  SRBroker                   Server Request Broker                                ReqBroker        System          Interactive  Running            38                100           1                  1                 2013-04-22 15:32:25               Enabled                                
siebfoobar  SRProc                     Server Request Processor                             SRProc           SystemAux       Interactive  Running            2                 20            1                  1                 2013-04-22 15:32:25               Enabled                                
siebfoobar  SvrTblCleanup              Server Tables Cleanup                                BusSvcMgr        SystemAux       Background   Running            1                 1                                                  2013-04-22 15:32:25               Enabled                                
siebfoobar  SvrTaskPersist             Server Task Persistance                              BusSvcMgr        SystemAux       Background   Running            1                 1                                                  2013-04-22 15:32:25               Enabled                                
siebfoobar  AdminNotify                Siebel Administrator Notification Component          AdminNotify      SystemAux       Batch        Online             0                 10            1                  1                 2013-04-22 15:32:25               Enabled                                
siebfoobar  SCBroker                   Siebel Connection Broker                             SCBroker         System          Background   Running            1                 1                                                  2013-04-22 15:32:25               Enabled                                
siebfoobar  SynchMgr                   Synchronization Manager                              SynchMgr         Remote          Interactive  Online             0                 100           1                  1                 2013-04-22 15:32:31               Enabled                                
siebfoobar  TaskLogCleanup             Task Log Cleanup                                     BusSvcMgr        TaskUI          Background   Running            1                 1                                                  2013-04-22 15:32:31               Enabled                                
siebfoobar  WorkActn                   Workflow Action Agent                                WorkActn         Workflow        Background   Online             0                 5                                                  2013-04-22 15:32:31               Enabled                                
siebfoobar  WorkMon                    Workflow Monitor Agent                               WorkMon          Workflow        Background   Online             0                 5                                                  2013-04-22 15:32:31               Enabled                                
siebfoobar  WorkMonSWI                 Workflow Monitor Agent SWI                           WorkMon          Workflow        Background   Running            1                 1                                                  2013-04-22 15:32:31               Enabled                                
siebfoobar  WfProcBatchMgr             Workflow Process Batch Manager                       BusSvcMgr        Workflow        Batch        Online             0                 20            1                  1                 2013-04-22 15:32:31               Enabled                                
siebfoobar  WfProcMgr                  Workflow Process Manager                             BusSvcMgr        Workflow        Batch        Online             0                 20            1                  1                 2013-04-22 15:32:31               Enabled                                
siebfoobar  WfRecvMgr                  Workflow Recovery Manager                            BusSvcMgr        Workflow        Batch        Online             0                 20            1                  1                 2013-04-22 15:32:31               Enabled                                
siebfoobar  eChannelCMEObjMgr_enu      eChannel Power Communications Object Manager (ENU)   AppObjMgr        Communications  Interactive  Online             0                 20            1                  1                 2013-04-22 15:32:31               Enabled                                
siebfoobar  eChannelCMEObjMgr_ptb      eChannel Power Communications Object Manager (PTB)   AppObjMgr        Communications  Interactive  Online             0                 20            1                  1                 2013-04-22 15:32:31               Enabled                                
siebfoobar  eCommunicationsObjMgr_enu  eCommunications Object Manager (ENU)                 AppObjMgr        Communications  Interactive  Online             0                 20            1                  1                 2013-04-22 15:32:31               Enabled                                
siebfoobar  eCommunicationsObjMgr_ptb  eCommunications Object Manager (PTB)                 AppObjMgr        Communications  Interactive  Online             0                 20            1                  1                 2013-04-22 15:32:31               Enabled                                

52 rows returned.

BLOCK

$data{ls_comp_types} = <<'BLOCK';
CT_NAME                                                                       CT_RUNMODE                       CT_ALIAS                                                       CT_DESC_TEXT                                                                                                                                                                                                                                                 
----------------------------------------------------------------------------  -------------------------------  -------------------------------------------------------------  --------------------------------------------------------------------------------------------------------------------  
ABO Bulk Request GoToView Svc                                                 Batch                            ABO Bulk Request GoToView Svc                                  ABO Bulk Request GoToView Svc Service                                                                                                                                                                                                                        
ABO Bulk Request GoToView Svc                                                 Background                       ABO Bulk Request GoToView Svc                                  ABO Bulk Request GoToView Svc Service                                                                                                                                                                                                                        
ABO Bulk Request Import Service                                               Batch                            ABO Bulk Request Import Service                                ABO Bulk Request Import Service Service                                                                                                                                                                                                                      
ABO Bulk Request Import Service                                               Background                       ABO Bulk Request Import Service                                ABO Bulk Request Import Service Service                                                                                                                                                                                                                      
ABO Bulk Request Processing Service                                           Batch                            ABO Bulk Request Processing Service                            ABO Bulk Request Processing Service Service                                                                                                                                                                                                                  
ABO Bulk Request Processing Service                                           Background                       ABO Bulk Request Processing Service                            ABO Bulk Request Processing Service Service                                                                                                                                                                                                                  
ABO Bulk Request Validation Service                                           Batch                            ABO Bulk Request Validation Service                            ABO Bulk Request Validation Service Service                                                                                                                                                                                                                  
ABO Bulk Request Validation Service                                           Background                       ABO Bulk Request Validation Service                            ABO Bulk Request Validation Service Service                                                                                                                                                                                                                  
ADM Service                                                                   Batch                            ADM Service                                                    ADM Service Service                                                                                                                                                                                                                                          
ADM Service                                                                   Background                       ADM Service                                                    ADM Service Service                                                                                                                                                                                                                                          
Siebel Administrator Notification Component                                   Batch                            AdminNotify                                                    Component used for administrator notification                                                                                                                                                                                                                
Analytic Adaptor Manager                                                      Batch                            Analytic Adaptor Manager                                       Analytic Adaptor Manager Service                                                                                                                                                                                                                             
Analytic Adaptor Manager                                                      Background                       Analytic Adaptor Manager                                       Analytic Adaptor Manager Service                                                                                                                                                                                                                             
Application Object Manager                                                    Interactive                      AppObjMgr                                                      Object manager component type for thin-client and web-client applications                                                                                                                                                                                    
Appointment Booking Service                                                   Batch                            Appointment Booking Service                                    Appointment Booking Service Service                                                                                                                                                                                                                          
Appointment Booking Service                                                   Background                       Appointment Booking Service                                    Appointment Booking Service Service                                                                                                                                                                                                                          
Batch Assignment                                                              Batch                            AsgnBatch                                                      Batch assigns positions and employees to objects                                                                                                                                                                                                             
Assignment Manager                                                            Batch                            AsgnSrvr                                                       Assigns positions and employees to objects                                                                                                                                                                                                                   
Business Service Manager                                                      Batch                            BusSvcMgr                                                      Business Service Manager component                                                                                                                                                                                                                           
Business Service Manager                                                      Background                       BusSvcMgr                                                      Business Service Manager component                                                                                                                                                                                                                           
CG Payment Business Service                                                   Batch                            CG Payment Business Service                                    CG Payment Business Service Service                                                                                                                                                                                                                          
CG Payment Business Service                                                   Background                       CG Payment Business Service                                    CG Payment Business Service Service                                                                                                                                                                                                                          
CG SVP Business Service                                                       Batch                            CG SVP Business Service                                        CG SVP Business Service Service                                                                                                                                                                                                                              
CG SVP Business Service                                                       Background                       CG SVP Business Service                                        CG SVP Business Service Service                                                                                                                                                                                                                              
CS Fund Business Service                                                      Batch                            CS Fund Business Service                                       CS Fund Business Service Service                                                                                                                                                                                                                             
CS Fund Business Service                                                      Background                       CS Fund Business Service                                       CS Fund Business Service Service                                                                                                                                                                                                                             
Categorization Manager                                                        Batch                            Categorization Manager                                         Categorization Manager Service                                                                                                                                                                                                                               
Categorization Manager                                                        Background                       Categorization Manager                                         Categorization Manager Service                                                                                                                                                                                                                               
CheckDup                                                                      Batch                            CheckDup                                                       CheckDup Service                                                                                                                                                                                                                                             
CheckDup                                                                      Background                       CheckDup                                                       CheckDup Service                                                                                                                                                                                                                                             
Communications Inbound Receiver                                               Batch                            CommInboundRcvr                                                Loads response groups to receive and queue inbound events                                                                                                                                                                                                    
Communications Session Manager                                                Batch                            CommSessionMgr                                                 Interact with end user for utilizing communications channels                                                                                                                                                                                                 
Communication Server Configuration                                            Batch                            Communication Server Configuration                             Communication Server Configuration Service                                                                                                                                                                                                                   
Communication Server Configuration                                            Background                       Communication Server Configuration                             Communication Server Configuration Service                                                                                                                                                                                                                   
Communications Inbound Processor                                              Batch                            Communications Inbound Processor                               Communications Inbound Processor Service                                                                                                                                                                                                                     
Communications Inbound Processor                                              Background                       Communications Inbound Processor                               Communications Inbound Processor Service                                                                                                                                                                                                                     
Complete Activity                                                             Batch                            Complete Activity                                              Complete Activity Service                                                                                                                                                                                                                                    
Complete Activity                                                             Background                       Complete Activity                                              Complete Activity Service                                                                                                                                                                                                                                    
Content Project                                                               Batch                            Content Project                                                Content Project Service                                                                                                                                                                                                                                      
Content Project                                                               Background                       Content Project                                                Content Project Service                                                                                                                                                                                                                                      
Contracts Accumulator Service                                                 Batch                            Contracts Accumulator Service                                  Contracts Accumulator Service Service                                                                                                                                                                                                                        
Contracts Accumulator Service                                                 Background                       Contracts Accumulator Service                                  Contracts Accumulator Service Service                                                                                                                                                                                                                        
Contracts Evaluator Service                                                   Batch                            Contracts Evaluator Service                                    Contracts Evaluator Service Service                                                                                                                                                                                                                          
Contracts Evaluator Service                                                   Background                       Contracts Evaluator Service                                    Contracts Evaluator Service Service                                                                                                                                                                                                                          
Contracts Resolver Service                                                    Batch                            Contracts Resolver Service                                     Contracts Resolver Service Service                                                                                                                                                                                                                           
Contracts Resolver Service                                                    Background                       Contracts Resolver Service                                     Contracts Resolver Service Service                                                                                                                                                                                                                           
Crediting Engine DB Operations                                                Batch                            Crediting Engine DB Operations                                 Crediting Engine DB Operations Service                                                                                                                                                                                                                       
Crediting Engine DB Operations                                                Background                       Crediting Engine DB Operations                                 Crediting Engine DB Operations Service                                                                                                                                                                                                                       
Custom Application Object Manager                                             Interactive                      CustomAppObjMgr                                                Object manager component type for thin-client Custom UI applications                                                                                                                                                                                         
DCommerce Alerts                                                              Background                       DCommerce Alerts                                               Background process that manages DCommerce alerts                                                                                                                                                                                                             
DCommerce Automatic Auction Close                                             Background                       DCommerce Automatic Auction Close                              Background process that detects and closes auctions                                                                                                                                                                                                          
DNB Update                                                                    Batch                            DNB Update                                                     DNB Update Service                                                                                                                                                                                                                                           
DNB Update                                                                    Background                       DNB Update                                                     DNB Update Service                                                                                                                                                                                                                                           
Data Cleansing                                                                Batch                            Data Cleansing                                                 Data Cleansing Service                                                                                                                                                                                                                                       
Data Cleansing                                                                Background                       Data Cleansing                                                 Data Cleansing Service                                                                                                                                                                                                                                       
Database Extract                                                              Batch                            DbXtract                                                       Extracts visible data for a Siebel Remote client                                                                                                                                                                                                             
DeDuplication                                                                 Batch                            DeDuplication                                                  DeDuplication Service                                                                                                                                                                                                                                        
DeDuplication                                                                 Background                       DeDuplication                                                  DeDuplication Service                                                                                                                                                                                                                                        
Document Driver                                                               Batch                            Document Driver                                                Document Driver Service                                                                                                                                                                                                                                      
Document Driver                                                               Background                       Document Driver                                                Document Driver Service                                                                                                                                                                                                                                      
Data Quality Manager                                                          Batch                            Dqmgr                                                          Cleanse data and de-duplicate records                                                                                                                                                                                                                        
DynamicCommerce                                                               Batch                            DynamicCommerce                                                DynamicCommerce Service                                                                                                                                                                                                                                      
DynamicCommerce                                                               Background                       DynamicCommerce                                                DynamicCommerce Service                                                                                                                                                                                                                                      
EAI Business Integration Manager                                              Batch                            EAI Business Integration Manager                               EAI Business Integration Manager Service                                                                                                                                                                                                                     
EAI Business Integration Manager                                              Background                       EAI Business Integration Manager                               EAI Business Integration Manager Service                                                                                                                                                                                                                     
EAI Outbound Service                                                          Batch                            EAI Outbound Service                                           EAI Outbound Service Service                                                                                                                                                                                                                                 
EAI Outbound Service                                                          Background                       EAI Outbound Service                                           EAI Outbound Service Service                                                                                                                                                                                                                                 
Enterprise Application Integration Connector Receiver                         Background                       EAIDeprecatedRcvr                                              Deprecated receiver for in-bound EAI transactions used by connectors                                                                                                                                                                                         
EAILOVService                                                                 Batch                            EAILOVService                                                  EAILOVService Service                                                                                                                                                                                                                                        
EAILOVService                                                                 Background                       EAILOVService                                                  EAILOVService Service                                                                                                                                                                                                                                        
EAI Object Manager                                                            Interactive                      EAIObjMgr                                                      Object manager component type for thin-client EAI applications                                                                                                                                                                                               
Enterprise Application Integration Receiver                                   Background                       EAIRcvr                                                        Generic receiver for in-bound EAI transactions                                                                                                                                                                                                               
Enterprise Integration Mgr                                                    Batch                            EIM                                                            Integrates enterprise data to and from other systems                                                                                                                                                                                                         
ERM Compensation Planning Service                                             Batch                            ERM Compensation Planning Service                              ERM Compensation Planning Service Service                                                                                                                                                                                                                    
ERM Compensation Planning Service                                             Background                       ERM Compensation Planning Service                              ERM Compensation Planning Service Service                                                                                                                                                                                                                    
Excel Importer Exporter                                                       Batch                            Excel Importer Exporter                                        Excel Importer Exporter Service                                                                                                                                                                                                                              
Excel Importer Exporter                                                       Background                       Excel Importer Exporter                                        Excel Importer Exporter Service                                                                                                                                                                                                                              
FINS Workflow UI Utilities                                                    Batch                            FINS Workflow UI Utilities                                     FINS Workflow UI Utilities Service                                                                                                                                                                                                                           
FINS Workflow UI Utilities                                                    Background                       FINS Workflow UI Utilities                                     FINS Workflow UI Utilities Service                                                                                                                                                                                                                           
FS Cycle Counting                                                             Batch                            FS Cycle Counting                                              FS Cycle Counting Service                                                                                                                                                                                                                                    
FS Cycle Counting                                                             Background                       FS Cycle Counting                                              FS Cycle Counting Service                                                                                                                                                                                                                                    
FS Fulfillment Service                                                        Batch                            FS Fulfillment Service                                         FS Fulfillment Service Service                                                                                                                                                                                                                               
FS Fulfillment Service                                                        Background                       FS Fulfillment Service                                         FS Fulfillment Service Service                                                                                                                                                                                                                               
FS Mobile Inventory Transaction                                               Batch                            FS Mobile Inventory Transaction                                FS Mobile Inventory Transaction Service                                                                                                                                                                                                                      
FS Mobile Inventory Transaction                                               Background                       FS Mobile Inventory Transaction                                FS Mobile Inventory Transaction Service                                                                                                                                                                                                                      
FS Part Locator Service                                                       Batch                            FS Part Locator Service                                        FS Part Locator Service Service                                                                                                                                                                                                                              
FS Part Locator Service                                                       Background                       FS Part Locator Service                                        FS Part Locator Service Service                                                                                                                                                                                                                              
FS Preventive Maintenance                                                     Batch                            FS Preventive Maintenance                                      FS Preventive Maintenance Service                                                                                                                                                                                                                            
FS Preventive Maintenance                                                     Background                       FS Preventive Maintenance                                      FS Preventive Maintenance Service                                                                                                                                                                                                                            
FS Replenish                                                                  Batch                            FS Replenish                                                   FS Replenish Service                                                                                                                                                                                                                                         
FS Replenish                                                                  Background                       FS Replenish                                                   FS Replenish Service                                                                                                                                                                                                                                         
File System Manager                                                           Batch                            FSMSrvr                                                        The file system manager component                                                                                                                                                                                                                            
Forecast 2000 Internal Service                                                Batch                            Forecast 2000 Internal Service                                 Forecast 2000 Internal Service Service                                                                                                                                                                                                                       
Forecast 2000 Internal Service                                                Background                       Forecast 2000 Internal Service                                 Forecast 2000 Internal Service Service                                                                                                                                                                                                                       
Generate New Database                                                         Batch                            GenNewDb                                                       Generates a new Sybase SQL Anywhere database template file for Siebel Remote                                                                                                                                                                                 
Generate Triggers                                                             Batch                            GenTrig                                                        Generates triggers for Workflow Manager and Assignment Manager                                                                                                                                                                                               
HTIM MDF Period Ending Service                                                Batch                            HTIM MDF Period Ending Service                                 HTIM MDF Period Ending Service Service                                                                                                                                                                                                                       
HTIM MDF Period Ending Service                                                Background                       HTIM MDF Period Ending Service                                 HTIM MDF Period Ending Service Service                                                                                                                                                                                                                       
Handheld Batch Synchronization                                                Batch                            Handheld Batch Synchronization                                 Handheld Batch Synchronization Service                                                                                                                                                                                                                       
Handheld Batch Synchronization                                                Background                       Handheld Batch Synchronization                                 Handheld Batch Synchronization Service                                                                                                                                                                                                                       
Handheld Synchronization Agent                                                Batch                            Handheld Synchronization Agent                                 Handheld Synchronization Agent Service                                                                                                                                                                                                                       
Handheld Synchronization Agent                                                Background                       Handheld Synchronization Agent                                 Handheld Synchronization Agent Service                                                                                                                                                                                                                       
Handheld Synchronization                                                      Batch                            Handheld Synchronization                                       Handheld Synchronization Service                                                                                                                                                                                                                             
Handheld Synchronization                                                      Background                       Handheld Synchronization                                       Handheld Synchronization Service                                                                                                                                                                                                                             
IC Quota Import Service                                                       Batch                            IC Quota Import Service                                        IC Quota Import Service Service                                                                                                                                                                                                                              
IC Quota Import Service                                                       Background                       IC Quota Import Service                                        IC Quota Import Service Service                                                                                                                                                                                                                              
IComp Credit Assignment Engine                                                Batch                            ICompCreditAsgn                                                Assigns credit allocation based on crediting rules                                                                                                                                                                                                           
Incentive Compensation Mgr                                                    Batch                            ICompMgr                                                       Calculates Incentive Compensations                                                                                                                                                                                                                           
SRM Tester for key-based routing                                              Batch                            KRSrmTst                                                       Server Request Manager Test Component for key-based routing                                                                                                                                                                                                  
LOY Interactive Processing Engine                                             Batch                            LOY Interactive Processing Engine                              LOY Interactive Processing Engine Service                                                                                                                                                                                                                    
LOY Interactive Processing Engine                                             Background                       LOY Interactive Processing Engine                              LOY Interactive Processing Engine Service                                                                                                                                                                                                                    
LOY Processing Engine                                                         Batch                            LOY Processing Engine                                          LOY Processing Engine Service                                                                                                                                                                                                                                
LOY Processing Engine                                                         Background                       LOY Processing Engine                                          LOY Processing Engine Service                                                                                                                                                                                                                                
LS Data Rollup                                                                Batch                            LS Data Rollup                                                 LS Data Rollup Service                                                                                                                                                                                                                                       
LS Data Rollup                                                                Background                       LS Data Rollup                                                 LS Data Rollup Service                                                                                                                                                                                                                                       
LS MC MarketingComplianceExpenseAllocation                                    Batch                            LS MC MarketingComplianceExpenseAllocation                     LS MC MarketingComplianceExpenseAllocation Service                                                                                                                                                                                                           
LS MC MarketingComplianceExpenseAllocation                                    Background                       LS MC MarketingComplianceExpenseAllocation                     LS MC MarketingComplianceExpenseAllocation Service                                                                                                                                                                                                           
LS Pharma Account GanttChart Utility Service                                  Batch                            LS Pharma Account GanttChart Utility Service                   LS Pharma Account GanttChart Utility Service Service                                                                                                                                                                                                         
LS Pharma Account GanttChart Utility Service                                  Background                       LS Pharma Account GanttChart Utility Service                   LS Pharma Account GanttChart Utility Service Service                                                                                                                                                                                                         
LS Pharma Contact GanttChart Utility Service                                  Batch                            LS Pharma Contact GanttChart Utility Service                   LS Pharma Contact GanttChart Utility Service Service                                                                                                                                                                                                         
LS Pharma Contact GanttChart Utility Service                                  Background                       LS Pharma Contact GanttChart Utility Service                   LS Pharma Contact GanttChart Utility Service Service                                                                                                                                                                                                         
LS Pharma GanttChart Utility Service                                          Batch                            LS Pharma GanttChart Utility Service                           LS Pharma GanttChart Utility Service Service                                                                                                                                                                                                                 
LS Pharma GanttChart Utility Service                                          Background                       LS Pharma GanttChart Utility Service                           LS Pharma GanttChart Utility Service Service                                                                                                                                                                                                                 
Lead Processing Service                                                       Batch                            Lead Processing Service                                        Lead Processing Service Service                                                                                                                                                                                                                              
Lead Processing Service                                                       Background                       Lead Processing Service                                        Lead Processing Service Service                                                                                                                                                                                                                              
List Import                                                                   Batch                            List Import                                                    List Import Service                                                                                                                                                                                                                                          
List Import                                                                   Background                       List Import                                                    List Import Service                                                                                                                                                                                                                                          
List                                                                          Batch                            List                                                           List Service                                                                                                                                                                                                                                                 
List                                                                          Background                       List                                                           List Service                                                                                                                                                                                                                                                 
List Manager                                                                  Batch                            ListMgr                                                        Loads outside files for list manager                                                                                                                                                                                                                         
E-mail Manager                                                                Background                       MailMgr                                                        Sends e-mail initiated by Workflow Manager                                                                                                                                                                                                                   
Message Board Maintenance Service                                             Batch                            Message Board Maintenance Service                              Message Board Maintenance Service Service                                                                                                                                                                                                                    
Message Board Maintenance Service                                             Background                       Message Board Maintenance Service                              Message Board Maintenance Service Service                                                                                                                                                                                                                    
OM Benchmark Test                                                             Batch                            OM Benchmark Test                                              OM Benchmark Test Service                                                                                                                                                                                                                                    
OM Benchmark Test                                                             Background                       OM Benchmark Test                                              OM Benchmark Test Service                                                                                                                                                                                                                                    
OM Regression Test                                                            Batch                            OM Regression Test                                             OM Regression Test Service                                                                                                                                                                                                                                   
OM Regression Test                                                            Background                       OM Regression Test                                             OM Regression Test Service                                                                                                                                                                                                                                   
OM Remote Regression Test                                                     Batch                            OM Remote Regression Test                                      OM Remote Regression Test Service                                                                                                                                                                                                                            
OM Remote Regression Test                                                     Background                       OM Remote Regression Test                                      OM Remote Regression Test Service                                                                                                                                                                                                                            
Optimizer Service                                                             Batch                            Optimizer Service                                              Optimizer Service Service                                                                                                                                                                                                                                    
Optimizer Service                                                             Background                       Optimizer Service                                              Optimizer Service Service                                                                                                                                                                                                                                    
Outbound Communications Manager                                               Batch                            Outbound Communications Manager                                Outbound Communications Manager Service                                                                                                                                                                                                                      
Outbound Communications Manager                                               Background                       Outbound Communications Manager                                Outbound Communications Manager Service                                                                                                                                                                                                                      
PIMSI Engine Service                                                          Batch                            PIMSI Engine Service                                           PIMSI Engine Service Service                                                                                                                                                                                                                                 
PIMSI Engine Service                                                          Background                       PIMSI Engine Service                                           PIMSI Engine Service Service                                                                                                                                                                                                                                 
Page Manager                                                                  Background                       PageMgr                                                        Sends pages initiated by Workflow Manager and Siebel Client                                                                                                                                                                                                  
Perf MQReceive Processor                                                      Batch                            Perf MQReceive Processor                                       Perf MQReceive Processor Service                                                                                                                                                                                                                             
Perf MQReceive Processor                                                      Background                       Perf MQReceive Processor                                       Perf MQReceive Processor Service                                                                                                                                                                                                                             
Quick Fill Service                                                            Batch                            Quick Fill Service                                             Quick Fill Service Service                                                                                                                                                                                                                                   
Quick Fill Service                                                            Background                       Quick Fill Service                                             Quick Fill Service Service                                                                                                                                                                                                                                   
Batch Real-Time Integration                                                   Batch                            RTIBatch                                                       Batch for Real-Time integration with BackOffice (ERP) Systems                                                                                                                                                                                                
RTS Extractor Service                                                         Batch                            RTS Extractor Service                                          RTS Extractor Service Service                                                                                                                                                                                                                                
RTS Extractor Service                                                         Background                       RTS Extractor Service                                          RTS Extractor Service Service                                                                                                                                                                                                                                
RTS Message Apply Service                                                     Batch                            RTS Message Apply Service                                      RTS Message Apply Service Service                                                                                                                                                                                                                            
RTS Message Apply Service                                                     Background                       RTS Message Apply Service                                      RTS Message Apply Service Service                                                                                                                                                                                                                            
RTS Sender Service                                                            Batch                            RTS Sender Service                                             RTS Sender Service Service                                                                                                                                                                                                                                   
RTS Sender Service                                                            Background                       RTS Sender Service                                             RTS Sender Service Service                                                                                                                                                                                                                                   
RTS Subscription Service                                                      Batch                            RTS Subscription Service                                       RTS Subscription Service Service                                                                                                                                                                                                                             
RTS Subscription Service                                                      Background                       RTS Subscription Service                                       RTS Subscription Service Service                                                                                                                                                                                                                             
RTS Transaction Dispatch Service                                              Batch                            RTS Transaction Dispatch Service                               RTS Transaction Dispatch Service Service                                                                                                                                                                                                                     
RTS Transaction Dispatch Service                                              Background                       RTS Transaction Dispatch Service                               RTS Transaction Dispatch Service Service                                                                                                                                                                                                                     
RTS Transaction Dispatcher                                                    Background                       RTSDispatcher                                                  Dispatches the transactions to the RTS channel                                                                                                                                                                                                               
Replication Agent                                                             Background                       RepAgent                                                       Synchronizes a Siebel Remote regional database with HQ                                                                                                                                                                                                       
Report Business Service                                                       Batch                            Report Business Service                                        Report Business Service Service                                                                                                                                                                                                                              
Report Business Service                                                       Background                       Report Business Service                                        Report Business Service Service                                                                                                                                                                                                                              
Server Request Broker                                                         Interactive                      ReqBroker                                                      Route requests and asynchronous notification among clients and components                                                                                                                                                                                    
Response                                                                      Batch                            Response                                                       Response Service                                                                                                                                                                                                                                             
Response                                                                      Background                       Response                                                       Response Service                                                                                                                                                                                                                                             
Row Set Transformation Toolkit                                                Batch                            Row Set Transformation Toolkit                                 Row Set Transformation Toolkit Service                                                                                                                                                                                                                       
Row Set Transformation Toolkit                                                Background                       Row Set Transformation Toolkit                                 Row Set Transformation Toolkit Service                                                                                                                                                                                                                       
Rule Manager Service                                                          Batch                            Rule Manager Service                                           Rule Manager Service Service                                                                                                                                                                                                                                 
Rule Manager Service                                                          Background                       Rule Manager Service                                           Rule Manager Service Service                                                                                                                                                                                                                                 
Rule Runtime Administration                                                   Batch                            Rule Runtime Administration                                    Rule Runtime Administration Service                                                                                                                                                                                                                          
Rule Runtime Administration                                                   Background                       Rule Runtime Administration                                    Rule Runtime Administration Service                                                                                                                                                                                                                          
Siebel Connection Broker                                                      Background                       SCBroker                                                       Route and load balance connections to components                                                                                                                                                                                                             
SCF Message Facility Test Component                                           Batch                            SCFMsgFacTest                                                  Component used for testing the SCF Message Facility                                                                                                                                                                                                          
SCF Message Facility Test Component                                           Background                       SCFMsgFacTest                                                  Component used for testing the SCF Message Facility                                                                                                                                                                                                          
SHM Function Service                                                          Batch                            SHM Function Service                                           SHM Function Service Service                                                                                                                                                                                                                                 
SHM Function Service                                                          Background                       SHM Function Service                                           SHM Function Service Service                                                                                                                                                                                                                                 
SIA CS ADL Business Service                                                   Batch                            SIA CS ADL Business Service                                    SIA CS ADL Business Service Service                                                                                                                                                                                                                          
SIA CS ADL Business Service                                                   Background                       SIA CS ADL Business Service                                    SIA CS ADL Business Service Service                                                                                                                                                                                                                          
SIA CS ADL Delete Business Service                                            Batch                            SIA CS ADL Delete Business Service                             SIA CS ADL Delete Business Service Service                                                                                                                                                                                                                   
SIA CS ADL Delete Business Service                                            Background                       SIA CS ADL Delete Business Service                             SIA CS ADL Delete Business Service Service                                                                                                                                                                                                                   
SIS Test Component                                                            Batch                            SISTst                                                         SIS Test Component use for testing shared memory instance                                                                                                                                                                                                    
SIS Test Component                                                            Interactive                      SISTst                                                         SIS Test Component use for testing shared memory instance                                                                                                                                                                                                    
SIS Test Component                                                            Background                       SISTst                                                         SIS Test Component use for testing shared memory instance                                                                                                                                                                                                    
SMQ Message Service                                                           Batch                            SMQ Message Service                                            SMQ Message Service Service                                                                                                                                                                                                                                  
SMQ Message Service                                                           Background                       SMQ Message Service                                            SMQ Message Service Service                                                                                                                                                                                                                                  
SMQ Transport Service                                                         Batch                            SMQ Transport Service                                          SMQ Transport Service Service                                                                                                                                                                                                                                
SMQ Transport Service                                                         Background                       SMQ Transport Service                                          SMQ Transport Service Service                                                                                                                                                                                                                                
Server Request Processor (SRP)                                                Interactive                      SRProc                                                         Store requests/notifications into database and forward them to components/clients                                                                                                                                                                            
Sales Hierarchy Service                                                       Batch                            Sales Hierarchy Service                                        Sales Hierarchy Service Service                                                                                                                                                                                                                              
Sales Hierarchy Service                                                       Background                       Sales Hierarchy Service                                        Sales Hierarchy Service Service                                                                                                                                                                                                                              
Search Data Processor                                                         Batch                            Search Data Processor                                          Search Data Processor Service                                                                                                                                                                                                                                
Search Data Processor                                                         Background                       Search Data Processor                                          Search Data Processor Service                                                                                                                                                                                                                                
Search External Service                                                       Batch                            Search External Service                                        Search External Service Service                                                                                                                                                                                                                              
Search External Service                                                       Background                       Search External Service                                        Search External Service Service                                                                                                                                                                                                                              
Search Solution Service                                                       Batch                            Search Solution Service                                        Search Solution Service Service                                                                                                                                                                                                                              
Search Solution Service                                                       Background                       Search Solution Service                                        Search Solution Service Service                                                                                                                                                                                                                              
Server Manager                                                                Interactive                      ServerMgr                                                      Administration of Siebel Servers within the Enterprise                                                                                                                                                                                                       
Signal Modify Service                                                         Batch                            Signal Modify Service                                          Signal Modify Service Service                                                                                                                                                                                                                                
Signal Modify Service                                                         Background                       Signal Modify Service                                          Signal Modify Service Service                                                                                                                                                                                                                                
Smart Answer Client                                                           Batch                            Smart Answer Client                                            Smart Answer Client Service                                                                                                                                                                                                                                  
Smart Answer Client                                                           Background                       Smart Answer Client                                            Smart Answer Client Service                                                                                                                                                                                                                                  
Smart Script Execution Cleanup                                                Batch                            Smart Script Execution Cleanup                                 Smart Script Execution Cleanup Service                                                                                                                                                                                                                       
Smart Script Execution Cleanup                                                Background                       Smart Script Execution Cleanup                                 Smart Script Execution Cleanup Service                                                                                                                                                                                                                       
Source Code Lookup                                                            Batch                            Source Code Lookup                                             Source Code Lookup Service                                                                                                                                                                                                                                   
Source Code Lookup                                                            Background                       Source Code Lookup                                             Source Code Lookup Service                                                                                                                                                                                                                                   
SrchFileSrvr                                                                  Batch                            SrchFileSrvr                                                   SrchFileSrvr Service                                                                                                                                                                                                                                         
SrchFileSrvr                                                                  Background                       SrchFileSrvr                                                   SrchFileSrvr Service                                                                                                                                                                                                                                         
SRM Tester 1                                                                  Batch                            SrmTst1                                                        Server Request Manager Test Component 1                                                                                                                                                                                                                      
SRM Tester 2                                                                  Batch                            SrmTst2                                                        Server Request Manager Test Component 2                                                                                                                                                                                                                      
SRM Tester 3                                                                  Batch                            SrmTst3                                                        Server Request Manager Test Component 3                                                                                                                                                                                                                      
SRM Tester 4                                                                  Batch                            SrmTst4                                                        Server Request Manager Test Component 4                                                                                                                                                                                                                      
Synchronization Manager                                                       Interactive                      SynchMgr                                                       Services Siebel Remote synchronization clients                                                                                                                                                                                                               
TNT SHM Event Template Copy Service                                           Batch                            TNT SHM Event Template Copy Service                            TNT SHM Event Template Copy Service Service                                                                                                                                                                                                                  
TNT SHM Event Template Copy Service                                           Background                       TNT SHM Event Template Copy Service                            TNT SHM Event Template Copy Service Service                                                                                                                                                                                                                  
TNT SHM Quote Service                                                         Batch                            TNT SHM Quote Service                                          TNT SHM Quote Service Service                                                                                                                                                                                                                                
TNT SHM Quote Service                                                         Background                       TNT SHM Quote Service                                          TNT SHM Quote Service Service                                                                                                                                                                                                                                
TNT SHM Revenue Service                                                       Batch                            TNT SHM Revenue Service                                        TNT SHM Revenue Service Service                                                                                                                                                                                                                              
TNT SHM Revenue Service                                                       Background                       TNT SHM Revenue Service                                        TNT SHM Revenue Service Service                                                                                                                                                                                                                              
Target List Service                                                           Batch                            Target List Service                                            Target List Service Service                                                                                                                                                                                                                                  
Target List Service                                                           Background                       Target List Service                                            Target List Service Service                                                                                                                                                                                                                                  
Task Log Cleanup Service                                                      Batch                            Task Log Cleanup Service                                       Task Log Cleanup Service Service                                                                                                                                                                                                                             
Task Log Cleanup Service                                                      Background                       Task Log Cleanup Service                                       Task Log Cleanup Service Service                                                                                                                                                                                                                             
Test Utilities                                                                Batch                            Test Utilities                                                 Test Utilities Service                                                                                                                                                                                                                                       
Test Utilities                                                                Background                       Test Utilities                                                 Test Utilities Service                                                                                                                                                                                                                                       
Test Data Access                                                              Batch                            TestDataAccess                                                 Component used for testing SCF data access layer.                                                                                                                                                                                                            
Test Data Access                                                              Background                       TestDataAccess                                                 Component used for testing SCF data access layer.                                                                                                                                                                                                            
Test SCF Data Access Performance                                              Batch                            TestDataAccessPerf                                             Component used for testing SCF data access layer performance.                                                                                                                                                                                                
Test SCF Event Facility                                                       Batch                            TestEventFacility                                              Component used for testing SCF event facility and its performance.                                                                                                                                                                                           
Request MT Test Server                                                        Batch                            TestMTReq                                                      Component used for testing Multi-threaded Request Mode Server                                                                                                                                                                                                
Multithreaded Test Server                                                     Batch                            TestMTSrvr                                                     Component used for testing Multithreaded Server                                                                                                                                                                                                              
Multithreaded Test Server                                                     Interactive                      TestMTSrvr                                                     Component used for testing Multithreaded Server                                                                                                                                                                                                              
Request Test Server                                                           Batch                            TestReq                                                        Component used for testing Request Mode Server                                                                                                                                                                                                               
Test SCF Facilities                                                           Batch                            TestScfFacilities                                              Component used for testing new SCF facilities.                                                                                                                                                                                                               
Test SCF Facilities                                                           Background                       TestScfFacilities                                              Component used for testing new SCF facilities.                                                                                                                                                                                                               
Session Test Server                                                           Interactive                      TestSess                                                       Component used for testing Session Mode Server                                                                                                                                                                                                               
Test Server                                                                   Batch                            TestSrvr                                                       Component used for testing Client Administration                                                                                                                                                                                                             
Test Server                                                                   Background                       TestSrvr                                                       Component used for testing Client Administration                                                                                                                                                                                                             
Transaction Merger                                                            Background                       TxnMerge                                                       Merges transactions from Siebel Remote clients                                                                                                                                                                                                               
Transaction Processor                                                         Background                       TxnProc                                                        Prepares the transaction log for the Transaction Router                                                                                                                                                                                                      
Transaction Router                                                            Background                       TxnRoute                                                       Routes visible transactions to Siebel Remote clients                                                                                                                                                                                                         
UDA Service                                                                   Batch                            UDA Service                                                    UDA Service Service                                                                                                                                                                                                                                          
UDA Service                                                                   Background                       UDA Service                                                    UDA Service Service                                                                                                                                                                                                                                          
Universal Data Cleansing Service                                              Batch                            Universal Data Cleansing Service                               Universal Data Cleansing Service Service                                                                                                                                                                                                                     
Universal Data Cleansing Service                                              Background                       Universal Data Cleansing Service                               Universal Data Cleansing Service Service                                                                                                                                                                                                                     
UoM Conversion Business Service                                               Batch                            UoM Conversion Business Service                                UoM Conversion Business Service Service                                                                                                                                                                                                                      
UoM Conversion Business Service                                               Background                       UoM Conversion Business Service                                UoM Conversion Business Service Service                                                                                                                                                                                                                      
Update Manager                                                                Batch                            UpdateMgr                                                      Server component that will update DNB and List Management                                                                                                                                                                                                    
Upgrade Kit Wizard OMSV                                                       Batch                            Upgrade Kit Wizard OMSV                                        Upgrade Kit Wizard OMSV Service                                                                                                                                                                                                                              
Upgrade Kit Wizard OMSV                                                       Background                       Upgrade Kit Wizard OMSV                                        Upgrade Kit Wizard OMSV Service                                                                                                                                                                                                                              
Workflow Action Agent                                                         Background                       WorkActn                                                       Executes actions for pre-defined events                                                                                                                                                                                                                      
Workflow Monitor Agent                                                        Background                       WorkMon                                                        Monitors the database for pre-defined events                                                                                                                                                                                                                 
Workflow Process Manager                                                      Batch                            Workflow Process Manager                                       Workflow Process Manager Service                                                                                                                                                                                                                             
Workflow Process Manager                                                      Background                       Workflow Process Manager                                       Workflow Process Manager Service                                                                                                                                                                                                                             
Workflow Recovery Manager                                                     Batch                            Workflow Recovery Manager                                      Workflow Recovery Manager Service                                                                                                                                                                                                                            
Workflow Recovery Manager                                                     Background                       Workflow Recovery Manager                                      Workflow Recovery Manager Service                                                                                                                                                                                                                            
XMLP Driver Service                                                           Batch                            XMLP Driver Service                                            XMLP Driver Service Service                                                                                                                                                                                                                                  
XMLP Driver Service                                                           Background                       XMLP Driver Service                                            XMLP Driver Service Service                                                                                                                                                                                                                                  
eAuto VDS Accessorization Utility Service                                     Batch                            eAuto VDS Accessorization Utility Service                      eAuto VDS Accessorization Utility Service Service                                                                                                                                                                                                            
eAuto VDS Accessorization Utility Service                                     Background                       eAuto VDS Accessorization Utility Service                      eAuto VDS Accessorization Utility Service Service                                                                                                                                                                                                            

262 rows returned.

BLOCK

$data{ls_params} = <<'BLOCK';
PA_ALIAS                               PA_VALUE                                                                                 PA_DATATYPE  PA_SCOPE   PA_SUBSYSTEM                                   PA_SETLEVEL       PA_DISP_SETLEVEL      PA  PA  PA  PA  PA_NAME                                                                                                                                                                  
-------------------------------------  ---------------------------------------------------------------------------------------  -----------  ---------  ---------------------------------------------  ----------------  --------------------  --  --  --  --  --------------------------------------------------------------------------------------------------------------------  
16KTblSpace                                                                                                                     String       Subsystem  Database Access                                Never set         Never set             Y   N   N   N   16K Tablespace Name                                                                                                                                                      
32KTblSpace                                                                                                                     String       Subsystem  Database Access                                Never set         Never set             Y   N   N   N   32K Tablespace Name                                                                                                                                                      
ActivityId                                                                                                                      String       Subsystem  Communications Outbound Manager                Never set         Never set             N   N   N   N   Activity Id                                                                                                                                                              
ActuateReportCastDomain                                                                                                         String       Subsystem  Infrastructure Actuate Reports Subsystem       Never set         Never set             Y   N   N   N   Actuate Report Cast Domain                                                                                                                                               
ActuateReportCastLang                  LANG_INDEPENDENT                                                                         String       Subsystem  Infrastructure Actuate Reports Subsystem       Server level      Server level set      Y   N   N   N   Actuate Server Report Cast Language                                                                                                                                      
ActuateReportPollWait                  30                                                                                       Integer      Subsystem  Infrastructure Actuate Reports Subsystem       Server level      Server level set      Y   N   N   N   Actuate Server Poll Wait Limit                                                                                                                                           
ActuateRequestPollInterval             10,0,0,10                                                                                String       Subsystem  Infrastructure Actuate Reports Subsystem       Default value     Default value         Y   N   N   N   Actuate Request Status Poll Interval                                                                                                                                     
ActuateRoxDir                          /Siebel Reports/                                                                         String       Subsystem  Infrastructure Actuate Reports Subsystem       Server level      Server level set      Y   N   N   N   Actuate Server Rox Directory                                                                                                                                             
AddToCartAutoQuote                     TRUE                                                                                     String       Subsystem  Infrastructure Shopping Service Subsystem      Default value     Default value         Y   N   N   N   AddToCartAutoQuote                                                                                                                                                       
AddToCartGotoView                      NONE                                                                                     String       Subsystem  Infrastructure Shopping Service Subsystem      Default value     Default value         Y   N   N   N   AddToCartGotoView                                                                                                                                                        
AddressList                                                                                                                     String       Subsystem  Communications Outbound Manager                Never set         Never set             N   N   N   N   Address List                                                                                                                                                             
AnonymousQuote                         FALSE                                                                                    String       Subsystem  Infrastructure Shopping Service Subsystem      Default value     Default value         Y   N   N   N   AnonymousQuote                                                                                                                                                           
AppendOrigMsg                                                                                                                   String       Subsystem  Communications Outbound Manager                Never set         Never set             N   N   N   N   Append Original Message                                                                                                                                                  
AssetBasedOrderingEnabled              False                                                                                    Boolean      Subsystem  Object Manager                                 Default value     Default value         Y   N   N   N   Order Management - Enable Asset Based Ordering                                                                                                                           
AttachFileList                                                                                                                  String       Subsystem  Communications Outbound Manager                Never set         Never set             N   N   N   N   Attachment File List                                                                                                                                                     
AttachNameList                                                                                                                  String       Subsystem  Communications Outbound Manager                Never set         Never set             N   N   N   N   Attachment Name List                                                                                                                                                     
AutoQuoteDefaultOwner                  TRUE                                                                                     String       Subsystem  Infrastructure Shopping Service Subsystem      Default value     Default value         Y   N   N   N   AutoQuoteDefaultOwner                                                                                                                                                    
AutoRestart                            True                                                                                     Boolean      Subsystem  Process Management                             Default value     Default value         Y   N   N   N   Auto Restart                                                                                                                                                             
AutoStart                              True                                                                                     Boolean      Server                                                    Default value     Default value         Y   N   N   N   Auto Startup Mode                                                                                                                                                        
BizRuleUseLIC                          False                                                                                    Boolean      Subsystem  Rules Engine                                   Default value     Default value         Y   N   N   N   Use LIC for Business Rules                                                                                                                                               
BusObjCacheSize                        0                                                                                        Integer      Subsystem  EAI                                            Never set         Never set             Y   N   N   N   Business Object Cache Size                                                                                                                                               
BusinessServiceQueryAccessList                                                                                                  String       Subsystem  Object Manager                                 Never set         Never set             N   N   N   N   Business Service Query Access List                                                                                                                                       
CACertFileName                                                                                                                  String       Subsystem  Networking                                     Never set         Never set             N   N   Y   N   CA certificate file name                                                                                                                                                 
CFGAccessDir                           \sea\access                                                                              String       Subsystem  Infrastructure Objmgr configuration subsystem  Default value     Default value         Y   N   N   N   Application Access Directory                                                                                                                                             
CFGClientRootDir                       /app/siebel/siebsrvr                                                                     String       Subsystem  Infrastructure Objmgr configuration subsystem  Server level      Server level set      Y   N   N   N   Application Client Rootdir                                                                                                                                               
CFGCorbaDLL                                                                                                                     String       Subsystem  Infrastructure Objmgr configuration subsystem  Never set         Never set             Y   N   N   N   Application Corba DLL                                                                                                                                                    
CFGCorrespODBCDatasource               Siebel Reports: Access                                                                   String       Subsystem  Infrastructure Objmgr configuration subsystem  Default value     Default value         Y   N   N   N   Application Correspondence ODBC datasource                                                                                                                               
CFGDatasource                          ServerDataSrc                                                                            String       Subsystem  Infrastructure Objmgr configuration subsystem  Default value     Default value         Y   N   N   N   Application Datasource                                                                                                                                                   
CFGDocumentIntegrator                  Microsoft Office                                                                         String       Subsystem  Infrastructure Objmgr configuration subsystem  Default value     Default value         Y   N   N   N   Application Document Integrator                                                                                                                                          
CFGEnableBizRule                       True                                                                                     Boolean      Subsystem  Infrastructure Objmgr configuration subsystem  Default value     Default value         Y   N   N   N   Enable Business Rule modules                                                                                                                                             
CFGEnableMsgBrdcstCache                False                                                                                    Boolean      Subsystem  Infrastructure Objmgr configuration subsystem  Default value     Default value         Y   N   N   N   Application Enable Message Broadcast Cache                                                                                                                               
CFGEnableOLEAutomation                 False                                                                                    Boolean      Subsystem  Infrastructure Objmgr configuration subsystem  Server level      Server level set      Y   N   N   N   Application OLE Automated Flag                                                                                                                                           
CFGEnableScripting                     True                                                                                     Boolean      Subsystem  Infrastructure Objmgr configuration subsystem  Default value     Default value         Y   N   N   N   Application Scripting Enabled                                                                                                                                            
CFGEnableTrainingQueue                 False                                                                                    Boolean      Subsystem  Infrastructure Objmgr configuration subsystem  Default value     Default value         Y   N   N   N   Application Enable Training Queue                                                                                                                                        
CFGJTCHelpURL                                                                                                                   String       Subsystem  Infrastructure Objmgr configuration subsystem  Never set         Never set             Y   N   N   N   Application JTC HELP URL                                                                                                                                                 
CFGJseCorbaConnector                                                                                                            String       Subsystem  Infrastructure Objmgr configuration subsystem  Never set         Never set             Y   N   N   N   Application JSE Corba Connector Dll                                                                                                                                      
CFGMsgBrdcstCacheSize                  100                                                                                      Integer      Subsystem  Infrastructure Objmgr configuration subsystem  Default value     Default value         Y   N   N   N   Application Message Broadcast Cache Size                                                                                                                                 
CFGOLEAutomationDLL                    libsscfole.so                                                                            String       Subsystem  Infrastructure Objmgr configuration subsystem  Server level      Server level set      Y   N   N   N   Application OLE Automation DLL                                                                                                                                           
CFGReportsDir                                                                                                                   String       Subsystem  Infrastructure Objmgr configuration subsystem  Never set         Never set             Y   N   N   N   Application Reports Directory                                                                                                                                            
CFGScriptingDLL                        sscfjs.so                                                                                String       Subsystem  Infrastructure Objmgr configuration subsystem  Server level      Server level set      Y   N   N   N   Application Scripting Dll                                                                                                                                                
CFGServerODBCDatasource                                                                                                         String       Subsystem  Infrastructure Objmgr configuration subsystem  Never set         Never set             Y   N   N   N   Application Server ODBC datasource                                                                                                                                       
CFGSharedModeUsersDir                  /app/siebel/gtwysrvr/fs/userpref                                                         String       Subsystem  Infrastructure Objmgr configuration subsystem  Enterprise level  Enterprise level set  Y   N   N   N   Application Shared Mode users directory                                                                                                                                  
CFGShowMessageBar                      User Enable                                                                              String       Subsystem  Infrastructure Objmgr configuration subsystem  Default value     Default value         Y   N   N   N   Application Message Bar Flag                                                                                                                                             
CFGTempDir                             /app/siebel/siebsrvr/temp                                                                String       Subsystem  Infrastructure Objmgr configuration subsystem  Server level      Server level set      Y   N   N   N   Application Client Tempdir                                                                                                                                               
CacheCategoryId                        False                                                                                    Boolean      Subsystem  Categorization Manager                         Default value     Default value         N   N   N   N   Cache Category ID                                                                                                                                                        
CacheStatsEnabled                      False                                                                                    Boolean      Subsystem  Object Manager                                 Default value     Default value         N   N   N   N   Cache Statistics Enabled                                                                                                                                                 
CatMgrType                             Master                                                                                   String       Subsystem  Categorization Manager                         Default value     Default value         N   N   N   N   Categorization Manager Type                                                                                                                                              
CertFileName                                                                                                                    String       Subsystem  Networking                                     Never set         Never set             N   N   Y   N   Certificate file name                                                                                                                                                    
Charset                                                                                                                         String       Subsystem  Communications Outbound Manager                Never set         Never set             N   N   N   N   Charset                                                                                                                                                                  
CheckErrorLeaks                        False                                                                                    Boolean      Subsystem  Infrastructure Core                            Default value     Default value         Y   N   N   N   Check Error Leaks                                                                                                                                                        
CheckIfCandidateActive                 False                                                                                    Boolean      Subsystem  Assignment Subsystem                           Default value     Default value         Y   N   N   N   Check If CandidateActive                                                                                                                                                 
ChildRecipSearchSpec                                                                                                            String       Subsystem  Communications Outbound Manager                Never set         Never set             N   N   N   N   Child Recipient Search Spec                                                                                                                                              
CommProfile                                                                                                                     String       Subsystem  Communications Outbound Manager                Never set         Never set             N   N   N   N   Communication Profile                                                                                                                                                    
CommProfileOverride                                                                                                             String       Subsystem  Communications Outbound Manager                Never set         Never set             N   N   N   N   Comm Profile Override                                                                                                                                                    
CommRequestId                                                                                                                   String       Subsystem  Communications Outbound Manager                Never set         Never set             N   N   N   N   Comm Request Id                                                                                                                                                          
CommRequestParentId                                                                                                             String       Subsystem  Communications Outbound Manager                Never set         Never set             N   N   N   N   Request Parent Id                                                                                                                                                        
CommType                               TCPIP                                                                                    String       Subsystem  Networking                                     Default value     Default value         Y   N   N   N   Communication Transport                                                                                                                                                  
Comments                                                                                                                        String       Subsystem  Communications Outbound Manager                Never set         Never set             N   N   N   N   Comm Request Comments                                                                                                                                                    
CommentsLogToDBSrvr                    True                                                                                     Boolean      Subsystem  Object Manager                                 Default value     Default value         N   N   N   N   Comments logged to DB Server                                                                                                                                             
CompPriorityTime                       300                                                                                      Integer      Server                                                    Default value     Default value         N   N   Y   N   Component Priority Level Timeout                                                                                                                                         
Compress                               NONE                                                                                     String       Subsystem  Networking                                     Default value     Default value         Y   N   N   N   Compression Type                                                                                                                                                         
CompressedFileDownload                 True                                                                                     Boolean      Subsystem  Object Manager                                 Default value     Default value         Y   N   N   N   Compressed File Download                                                                                                                                                 
ConfigFile                             siebel.cfg                                                                               String       Subsystem  Object Manager                                 Default value     Default value         N   N   Y   N   OM - Configuration File                                                                                                                                                  
Connect                                SBL_DEV_DSN                                                                              String       Subsystem  Database Access                                Enterprise level  Enterprise level set  Y   N   N   N   ODBC Data Source                                                                                                                                                         
CopyCandSpecData                       No                                                                                       String       Subsystem  Assignment Subsystem                           Default value     Default value         Y   N   N   N   Copy Candidate Specific Data                                                                                                                                             
CopyPersonSpecData                     No                                                                                       String       Subsystem  Assignment Subsystem                           Default value     Default value         Y   N   N   N   Copy Person Specific Data                                                                                                                                                
Crypt                                  NONE                                                                                     String       Subsystem  Networking                                     Default value     Default value         Y   N   N   N   Encryption Type                                                                                                                                                          
DB2DisableAutoCommit                   Y                                                                                        String       Subsystem  Database Access                                Default value     Default value         Y   N   N   N   Disable Autocommit                                                                                                                                                       
DB2DisableMinMemMode                                                                                                            String       Subsystem  Database Access                                Never set         Never set             Y   N   N   N   Disable DB2 CLI MinMemMode                                                                                                                                               
DBRollbackSeg                                                                                                                   String       Subsystem  Database Access                                Never set         Never set             Y   N   N   N   DataBase Rollback Segment Name                                                                                                                                           
DDDSN                                                                                                                           String       Subsystem  Data Dictionary Manager                        Never set         Never set             N   N   N   N   ODBC DSN                                                                                                                                                                 
DDPWD                                                                                                                           String       Subsystem  Data Dictionary Manager                        Never set         Never set             N   N   N   N   Database PWD                                                                                                                                                             
DDTABLEID                                                                                                                       String       Subsystem  Data Dictionary Manager                        Never set         Never set             N   N   N   N   TABLEID                                                                                                                                                                  
DDTABLENAME                                                                                                                     String       Subsystem  Data Dictionary Manager                        Never set         Never set             N   N   N   N   Database TABLENAME                                                                                                                                                       
DDTABLEOWNER                                                                                                                    String       Subsystem  Data Dictionary Manager                        Never set         Never set             N   N   N   N   Database TABLEOWNER                                                                                                                                                      
DDUID                                                                                                                           String       Subsystem  Data Dictionary Manager                        Never set         Never set             N   N   N   N   Database UID                                                                                                                                                             
DSChartImageFormat                                                                                                              String       Subsystem  Datasources Subsystem                          Never set         Never set             Y   N   N   N   Chart Image Format                                                                                                                                                       
DSChartServer                                                                                                                   String       Subsystem  Datasources Subsystem                          Never set         Never set             Y   N   N   N   Chart Server                                                                                                                                                             
DSUseNativeDbConnPooling               False                                                                                    Boolean      Subsystem  Datasources Subsystem                          Default value     Default value         N   Y   N   Y   Enable or Disable the DB Native Connection Pooling                                                                                                                       
DataCleansingType                      Vendor1                                                                                  String       Subsystem  Infrastructure Datacleansing subsystem         Enterprise level  Enterprise level set  Y   N   N   N   Data Cleansing Type                                                                                                                                                      
DataSource                             ServerDataSrc                                                                            String       Subsystem  Object Manager                                 Default value     Default value         Y   N   N   N   OM - Data Source                                                                                                                                                         
DeDupTypeType                          None                                                                                     String       Subsystem  Infrastructure DeDuplication subsystem         Enterprise level  Enterprise level set  Y   N   N   N   DeDuplication Data Type                                                                                                                                                  
DefaultAdminAddress                                                                                                             String       Subsystem  SMTP subsystem                                 Never set         Never set             Y   N   N   N   Default Administrator Address                                                                                                                                            
DefaultAnalyticsWebServer              Default Analytics Web Server                                                             String       Subsystem  Marketing Server Subsystem                     Default value     Default value         Y   N   N   N   Default Analytics Web Server                                                                                                                                             
DefaultFromAddress                                                                                                              String       Subsystem  SMTP subsystem                                 Never set         Never set             Y   N   N   N   Default From Address                                                                                                                                                     
DefaultLeadListFormat                  /shared/Marketing/Example List Formats/Galena - Analytics Data Load - Leads example      String       Subsystem  Marketing Server Subsystem                     Default value     Default value         Y   N   N   N   Default Lead List Format                                                                                                                                                 
DefaultResponseListFormat              /shared/Marketing/Example List Formats/Galena - Analytics Data Load - Responses example  String       Subsystem  Marketing Server Subsystem                     Default value     Default value         Y   N   N   N   Default Response List Format                                                                                                                                             
DefinedComponent                                                                                                                String       Subsystem  Communications Outbound Manager                Never set         Never set             N   N   N   N   Defined Component                                                                                                                                                        
DisableNotification                    False                                                                                    Boolean      Subsystem  Infrastructure Notification                    Default value     Default value         N   N   N   N   Disable Notification                                                                                                                                                     
DocumentServerName                                                                                                              String       Subsystem  eDoc Sub System                                Never set         Never set             N   N   N   N   Document Server Name                                                                                                                                                     
DynCandParam                                                                                                                    String       Subsystem  Assignment Subsystem                           Never set         Never set             Y   N   N   N   Dynamic Candidate Parameters                                                                                                                                             
EAIOutboundWaitTime                    30                                                                                       Integer      Subsystem  Infrastructure EAI Outbound Subsystem          Default value     Default value         Y   N   N   N   EAI Outbound Wait Time Limit                                                                                                                                             
EAISSLCertFile                                                                                                                  String       Subsystem  Infrastructure EAI Outbound Subsystem          Never set         Never set             N   N   Y   N   EAI SSL Cert File                                                                                                                                                        
EAISSLEnabled                          False                                                                                    Boolean      Subsystem  Infrastructure EAI Outbound Subsystem          Default value     Default value         N   N   Y   N   EAI SSL Enabled                                                                                                                                                          
EAISSLHostVerification                 True                                                                                     Boolean      Subsystem  Infrastructure EAI Outbound Subsystem          Default value     Default value         N   N   Y   N   EAI SSL Host Name Verification                                                                                                                                           
EAISSLKeyFile                                                                                                                   String       Subsystem  Infrastructure EAI Outbound Subsystem          Never set         Never set             N   N   Y   N   EAI SSL Key File                                                                                                                                                         
EAISSLTrustStore                                                                                                                String       Subsystem  Infrastructure EAI Outbound Subsystem          Never set         Never set             N   N   Y   N   EAI SSL Trust Store                                                                                                                                                      
EAISSLTrustStorePass                   ********                                                                                 String       Subsystem  Infrastructure EAI Outbound Subsystem          Never set         Never set             N   N   Y   N   EAI SSL Trust Store Password                                                                                                                                             
EligibilityDisplayMode                 1                                                                                        Integer      Subsystem  PSP Engine                                     Default value     Default value         Y   N   N   N   Eligibility Display Mode                                                                                                                                                 
EmailDebugLevel                        0                                                                                        Integer      Subsystem  Email Client Subsystem                         Never set         Never set             Y   N   N   N   Email Client Debug Level                                                                                                                                                 
EmailDefaultClient                     Siebel Mail Client                                                                       String       Subsystem  Email Client Subsystem                         Default value     Default value         Y   N   N   N   Default Email Client                                                                                                                                                     
EmailExtMailClientAttDir                                                                                                        String       Subsystem  Email Client Subsystem                         Never set         Never set             Y   N   N   N   Email Temporary Attachment Location                                                                                                                                      
EmailLotusForm                                                                                                                  String       Subsystem  Email Client Subsystem                         Never set         Never set             Y   N   N   N   Siebel/Lotus Form                                                                                                                                                        
EmailOutlookForm                                                                                                                String       Subsystem  Email Client Subsystem                         Never set         Never set             Y   N   N   N   Siebel/Outlook Form                                                                                                                                                      
EmailPersonalizationFormat             Default Merge Fields                                                                     String       Subsystem  Marketing Server Subsystem                     Default value     Default value         Y   N   N   N   Email Personalization Format                                                                                                                                             
EnableAssetBasedOrdering               FALSE                                                                                    String       Subsystem  OrderManagement                                Default value     Default value         Y   N   N   N   Enable Asset Based Ordering                                                                                                                                              
EnableEAIMemoryMetrics                 False                                                                                    Boolean      Subsystem  EAI                                            Default value     Default value         Y   N   N   N   Enable Memory Metrics for EAI                                                                                                                                            
EnableEventHistory                     True                                                                                     Boolean      Subsystem  Infrastructure Core                            Default value     Default value         N   N   N   N   Enable Event History Facility                                                                                                                                            
EnableNewOutboundDispatcher            N                                                                                        String       Subsystem  EAI                                            Default value     Default value         Y   N   N   N   Enable New Outbound Dispatcher                                                                                                                                           
EnablePrePickCompatibility             False                                                                                    Boolean      Subsystem  OrderManagement                                Default value     Default value         N   N   N   N   Enable Pre Pick Compatibility                                                                                                                                            
EnableServiceArgTracing                False                                                                                    Boolean      Subsystem  EAI                                            Default value     Default value         Y   N   N   N   Enable Business Service Argument Tracing                                                                                                                                 
EnableTransferCart                     FALSE                                                                                    String       Subsystem  Infrastructure Shopping Service Subsystem      Default value     Default value         Y   N   N   N   EnableTransferCart                                                                                                                                                       
EnableVirtualHosts                     False                                                                                    Boolean      Subsystem  Client Uses Session Manager                    Default value     Default value         N   N   Y   N   Enable internal load balancing                                                                                                                                           
EngineID                                                                                                                        String       Subsystem  PIMSI Engine                                   Never set         Never set             N   Y   N   Y   Engine Id                                                                                                                                                                
ErrorBufferSize                        1000                                                                                     Integer      Server                                                    Default value     Default value         N   N   Y   N   Size of Error Buffer                                                                                                                                                     
EventSleepTime                         30                                                                                       Integer      Subsystem  Infrastructure Core                            Default value     Default value         Y   N   N   N   Event History Sleep Time                                                                                                                                                 
ExtDBODBCDataSource                                                                                                             String       Subsystem  External DB Subsystem                          Never set         Never set             Y   N   N   N   External DB ODBC Data Source                                                                                                                                             
ExtDBPassword                          ********                                                                                 String       Subsystem  External DB Subsystem                          Never set         Never set             Y   N   N   N   External DB Password                                                                                                                                                     
ExtDBTableOwner                                                                                                                 String       Subsystem  External DB Subsystem                          Never set         Never set             Y   N   N   N   External DB Table Owner                                                                                                                                                  
ExtDBUserName                                                                                                                   String       Subsystem  External DB Subsystem                          Never set         Never set             Y   N   N   N   External DB User Name                                                                                                                                                    
FDRAppendFile                          False                                                                                    Boolean      Subsystem  (FDR) Flight Data Recorder                     Default value     Default value         N   N   N   N   FDR Periodic Dump and Append                                                                                                                                             
FDRBufferSize                          5000000                                                                                  Integer      Subsystem  (FDR) Flight Data Recorder                     Default value     Default value         N   Y   N   Y   FDR Buffer Size                                                                                                                                                          
FileSystem                             /app/siebel/gtwysrvr/fs                                                                  String       Subsystem  Infrastructure Core                            Enterprise level  Enterprise level set  Y   N   N   N   Siebel File System                                                                                                                                                       
ForwardFlag                                                                                                                     String       Subsystem  Communications Outbound Manager                Never set         Never set             N   N   N   N   Forward Flag                                                                                                                                                             
HTTPKeepAlive                          0                                                                                        Integer      Subsystem  Networking                                     Default value     Default value         Y   N   N   N   Server http keepalive time                                                                                                                                               
Host                                   siebfoobar                                                                               String       Server                                                    Server level      Server level set      N   N   Y   N   Host Name                                                                                                                                                                
ISSCtxtNumSignals                      150                                                                                      Integer      Subsystem  Object Manager                                 Default value     Default value         Y   N   N   N   ISS Context - Maximum number of signal objects cached in memory                                                                                                          
ISSCtxtNumVarMaps                      100                                                                                      Integer      Subsystem  Object Manager                                 Default value     Default value         Y   N   N   N   ISS Context - Maximum number of variable map objects cached in memory                                                                                                    
ISSCtxtSignalSnapshot                  True                                                                                     Boolean      Subsystem  Object Manager                                 Default value     Default value         Y   N   N   N   ISS Context - Collect and use snapshots of ISS Context signal metadata                                                                                                   
ISSCtxtVarMapSnapshot                  True                                                                                     Boolean      Subsystem  Object Manager                                 Default value     Default value         Y   N   N   N   ISS Context - Collect and use snapshots of ISS Context variable maps                                                                                                     
IdxSpace                                                                                                                        String       Subsystem  Database Access                                Never set         Never set             Y   N   N   N   Indexspace Name                                                                                                                                                          
ImportBatchSize                        1000                                                                                     Integer      Subsystem  Marketing Server Subsystem                     Default value     Default value         Y   N   N   N   Import Batch Size                                                                                                                                                        
Industries                                                                                                                      String       Subsystem  Vertical                                       Never set         Never set             Y   N   N   N   OM - Industries                                                                                                                                                          
JVMsubsys                              JAVA                                                                                     String       Subsystem  EAI                                            Default value     Default value         Y   N   N   N   JVM Subsystem Name                                                                                                                                                       
KBName                                 KB                                                                                       String       Subsystem  Categorization Manager                         Default value     Default value         N   N   N   N   Knowledge Base Name                                                                                                                                                      
KBWriteInterval                        100                                                                                      Integer      Subsystem  Categorization Manager                         Default value     Default value         N   N   N   N   KB Write Back Interval                                                                                                                                                   
KeepSuccessMessage                     False                                                                                    Boolean      Subsystem  Communications Outbound Manager                Never set         Never set             N   N   N   N   Keep Successful Tracking Message                                                                                                                                         
KeyFileName                                                                                                                     String       Subsystem  Networking                                     Never set         Never set             N   N   Y   N   Private key file name                                                                                                                                                    
KeyFilePassword                        ********                                                                                 String       Subsystem  Networking                                     Never set         Never set             N   N   Y   N   Private key file password                                                                                                                                                
LOYEngineMemberSync                    Y                                                                                        String       Subsystem  LoyEngineBatch                                 Default value     Default value         Y   N   N   N   LOY - Engine Member Synchronization                                                                                                                                      
LOYEngineNumberOfRuns                  -1                                                                                       Integer      Subsystem  LoyEngineBatch                                 Default value     Default value         Y   N   N   N   LOY - Engine Number of Runs                                                                                                                                              
LOYEngineNumberofTasks                 0                                                                                        Integer      Subsystem  LoyEngineBatch                                 Default value     Default value         Y   N   N   N   LOY - Engine Number of Tasks                                                                                                                                             
LOYEngineQueueObjects                  Transaction:500,Bucket:200                                                               String       Subsystem  LoyEngineBatch                                 Default value     Default value         Y   N   N   N   LOY - Engine Queue Objects                                                                                                                                               
LOYEngineSearchSpec                                                                                                             String       Subsystem  LoyEngineBatch                                 Never set         Never set             Y   N   N   N   LOY - Engine Search Specification                                                                                                                                        
LOYEngineSleepTime                     5                                                                                        Integer      Subsystem  LoyEngineBatch                                 Default value     Default value         Y   N   N   N   LOY - Engine Sleep Time (secs.)                                                                                                                                          
LOYIPNumOfObjPerTask                   30                                                                                       Integer      Subsystem  LoyEngineInteractive                           Default value     Default value         Y   N   N   N   LOY - Interactive Number of Objects in Task                                                                                                                              
LOYIPParaMemberTxn                     Y                                                                                        String       Subsystem  LoyEngineInteractive                           Default value     Default value         Y   N   N   N   LOY - Interactive Parallel Member Trasnactions                                                                                                                           
LOYIPSleepTime                         5                                                                                        Integer      Subsystem  LoyEngineInteractive                           Default value     Default value         Y   N   N   N   LOY - Interactive Task Sleep Time (secs.)                                                                                                                                
Lang                                   enu                                                                                      String       Subsystem  Infrastructure Core                            Server level      Server level set      Y   N   N   N   Language Code                                                                                                                                                            
ListenOneIPAddress                     False                                                                                    Boolean      Server                                                    Default value     Default value         N   N   Y   N   Listen One IP Address                                                                                                                                                    
LoadAtStart                            True                                                                                     Boolean      Subsystem  Categorization Manager                         Default value     Default value         N   N   N   N   Load KB at Startup                                                                                                                                                       
LocaleCode                                                                                                                      String       Subsystem  Object Manager                                 Never set         Never set             N   Y   N   Y   Locale Code                                                                                                                                                              
LogArchive                             2                                                                                        Integer      Subsystem  Event Logging                                  Server level      Server level set      Y   N   N   N   Log Archive Keep                                                                                                                                                         
LogArchiveDir                                                                                                                   String       Subsystem  Event Logging                                  Never set         Never set             Y   N   N   N   Log Archive Directory                                                                                                                                                    
LogDir                                 /app/siebel/siebsrvr/enterprises/SBL_DEV/siebfoobar/log                                  String       Subsystem  Event Logging                                  Server level      Server level set      N   N   N   N   Log directory                                                                                                                                                            
LogFlushFreq                           0                                                                                        Integer      Subsystem  Event Logging                                  Default value     Default value         N   N   N   N   Number of lines after which to flush the log file                                                                                                                        
LogMaxSegments                         0                                                                                        Integer      Subsystem  Event Logging                                  Default value     Default value         N   N   N   N   Maximum number of log file segments                                                                                                                                      
LogSegmentSize                         0                                                                                        Integer      Subsystem  Event Logging                                  Default value     Default value         N   N   N   N   Log file segment size in KB                                                                                                                                              
LogTimestamp                           True                                                                                     Boolean      Subsystem  Event Logging                                  Default value     Default value         N   N   N   N   Log Print Timestamp                                                                                                                                                      
LogUseErrorBuffer                      False                                                                                    Boolean      Subsystem  Event Logging                                  Default value     Default value         Y   N   N   N   Use Error Buffer                                                                                                                                                         
LogUseSharedFile                       False                                                                                    Boolean      Subsystem  Event Logging                                  Default value     Default value         Y   N   N   N   Use Shared Log File                                                                                                                                                      
LoginDomain                            INTERNAL                                                                                 String       Subsystem  Object Manager                                 Default value     Default value         Y   N   N   N   OM - Login Domain                                                                                                                                                        
LongTblSpace                                                                                                                    String       Subsystem  Database Access                                Never set         Never set             Y   N   N   N   Long Tablespace Name                                                                                                                                                     
MarketingFileSystem                    /app/siebel/gtwysrvr/fs                                                                  String       Subsystem  Marketing Server Subsystem                     Enterprise level  Enterprise level set  Y   N   N   N   Marketing File System                                                                                                                                                    
MarketingFileSystemForCommOutboundMgr                                                                                           String       Subsystem  Marketing Server Subsystem                     Never set         Never set             Y   N   N   N   Marketing File System for Communications Outbound Manager                                                                                                                
MarketingWorkflowProcessManager                                                                                                 String       Subsystem  Marketing Server Subsystem                     Never set         Never set             Y   N   N   N   Marketing Workflow Process Manager                                                                                                                                       
MarketingWorkflowServer                                                                                                         String       Subsystem  Marketing Server Subsystem                     Never set         Never set             Y   N   N   N   Marketing Workflow Server                                                                                                                                                
MaxNumCat                              4                                                                                        Integer      Subsystem  Categorization Manager                         Default value     Default value         N   N   N   N   Maximum Number of Categories                                                                                                                                             
MaxSharedDbConns                       -1                                                                                       Integer      Subsystem  Object Manager                                 Default value     Default value         N   N   Y   N   DB Multiplex - Max Number of Shared DB Connections                                                                                                                       
MaxTaskHistory                         20                                                                                       Integer      Subsystem  Process Management                             Default value     Default value         N   N   Y   N   Maximum Historic Tasks                                                                                                                                                   
MaxThreads                             20                                                                                       Integer      Subsystem  Communications Inbound Processor               Default value     Default value         Y   N   N   N   Max Threads                                                                                                                                                              
MaximumPageSize                        100                                                                                      Integer      Subsystem  EAI                                            Default value     Default value         Y   N   N   N   Maximum Page Size                                                                                                                                                        
MemoryBasedRecycle                     False                                                                                    Boolean      Subsystem  Multi-Threading                                Default value     Default value         Y   N   N   N   Memory usage based multithread shell recycling                                                                                                                           
MemoryLimit                            1500                                                                                     Integer      Subsystem  Multi-Threading                                Default value     Default value         Y   N   N   N   Process VM usage lower limit                                                                                                                                             
MemoryLimitPercent                     20                                                                                       Integer      Subsystem  Multi-Threading                                Default value     Default value         Y   N   N   N   Process VM usage upper limit                                                                                                                                             
MessageObjectId                                                                                                                 String       Subsystem  Communications Outbound Manager                Never set         Never set             N   N   N   N   Message Tracking Object Id                                                                                                                                               
MessageTracking                        False                                                                                    Boolean      Subsystem  Communications Outbound Manager                Never set         Never set             N   N   N   N   Message Tracking                                                                                                                                                         
MessageType                                                                                                                     String       Subsystem  Communications Outbound Manager                Never set         Never set             N   N   N   N   Message Tracking Type                                                                                                                                                    
MinSharedDbConns                       -1                                                                                       Integer      Subsystem  Object Manager                                 Default value     Default value         N   N   Y   N   DB Multiplex - Min Number of Shared DB Connections                                                                                                                       
MinTrxDbConns                          -1                                                                                       Integer      Subsystem  Object Manager                                 Default value     Default value         N   N   Y   N   DB Multiplex - Min Number of Dedicated DB Connections                                                                                                                    
MinUpTime                              60                                                                                       Integer      Subsystem  Process Management                             Default value     Default value         Y   N   N   N   Minimum Up Time                                                                                                                                                          
ModelCacheMax                          10                                                                                       Integer      Subsystem  Object Manager                                 Default value     Default value         Y   N   N   N   OM - Model Cache Maximum                                                                                                                                                 
MsgBccList                                                                                                                      String       Subsystem  Communications Outbound Manager                Never set         Never set             N   N   N   N   Message Bcc List                                                                                                                                                         
MsgBody                                                                                                                         String       Subsystem  Communications Outbound Manager                Never set         Never set             N   N   N   N   Message Body                                                                                                                                                             
MsgCcList                                                                                                                       String       Subsystem  Communications Outbound Manager                Never set         Never set             N   N   N   N   Message Cc List                                                                                                                                                          
MsgClientAddInCacheRefreshInterval     4320                                                                                     Integer      Subsystem  Messaging Client Subsystem                     Default value     Default value         Y   N   N   N   Messaging Client AddIn Cache Refresh Interval                                                                                                                            
MsgClientAddInCommModule               EAI                                                                                      String       Subsystem  Messaging Client Subsystem                     Default value     Default value         Y   N   N   N   Messaging Client AddIn Communication Module                                                                                                                              
MsgClientAddInEAIUrl                                                                                                            String       Subsystem  Messaging Client Subsystem                     Never set         Never set             Y   N   N   N   Messaging Client AddIn EAI Url                                                                                                                                           
MsgClientAddInLinkHistory              30                                                                                       Integer      Subsystem  Messaging Client Subsystem                     Default value     Default value         Y   N   N   N   Messaging Client AddIn Link History                                                                                                                                      
MsgFrom                                                                                                                         String       Subsystem  Communications Outbound Manager                Never set         Never set             N   N   N   N   Message From                                                                                                                                                             
MsgHTMLBody                                                                                                                     String       Subsystem  Communications Outbound Manager                Never set         Never set             N   N   N   N   Message HTML Body                                                                                                                                                        
MsgReplyToAddressList                                                                                                           String       Subsystem  Communications Outbound Manager                Never set         Never set             N   N   N   N   MessageReplyAddress  List                                                                                                                                                
MsgSubject                                                                                                                      String       Subsystem  Communications Outbound Manager                Never set         Never set             N   N   N   N   Message Subject                                                                                                                                                          
MsgToList                                                                                                                       String       Subsystem  Communications Outbound Manager                Never set         Never set             N   N   N   N   Message To List                                                                                                                                                          
MssqlOptimizeCursorFlg                 False                                                                                    Boolean      Subsystem  Database Access                                Default value     Default value         N   Y   N   Y   MSSQL Optimize Cursor Flag                                                                                                                                               
MuteIdleState                          False                                                                                    Boolean      Subsystem  Infrastructure Core                            Never set         Never set             Y   N   N   N   Mute Idle State                                                                                                                                                          
NotifyHandler                          AdminEmailAlert                                                                          String       Subsystem  Infrastructure Notification                    Server level      Server level set      N   N   N   N   Notification Handler                                                                                                                                                     
NotifyOnTaskExit                       0                                                                                        Integer      Subsystem  Infrastructure Notification                    Default value     Default value         N   N   N   N   Notification Action on Task Exit                                                                                                                                         
NotifyTimeOut                          100                                                                                      Integer      Subsystem  Infrastructure Notification                    Default value     Default value         N   N   N   N   Time to wait for doing notification                                                                                                                                      
NumRecipients                                                                                                                   String       Subsystem  Communications Outbound Manager                Never set         Never set             N   N   N   N   Number Of Recipients                                                                                                                                                     
NumRestart                             10                                                                                       Integer      Subsystem  Process Management                             Default value     Default value         Y   N   N   N   Numbers of Restarts                                                                                                                                                      
NumRetries                             10000                                                                                    Integer      Subsystem  Recovery                                       Default value     Default value         Y   N   N   N   Number of Retries                                                                                                                                                        
NumTasks                                                                                                                        String       Subsystem  Communications Outbound Manager                Never set         Never set             N   N   N   N   Number Of Tasks                                                                                                                                                          
ORCLBatchSize                          0                                                                                        Integer      Subsystem  External DB Subsystem                          Never set         Never set             Y   N   N   N   ORCL Batch Size                                                                                                                                                          
ORCLGroupSize                          0                                                                                        Integer      Subsystem  External DB Subsystem                          Never set         Never set             Y   N   N   N   ORCL Group Size                                                                                                                                                          
ORCLQueueName                                                                                                                   String       Subsystem  External DB Subsystem                          Never set         Never set             Y   N   N   N   ORCL Queue Name                                                                                                                                                          
OrderCartBC                            Order Entry - Orders                                                                     String       Subsystem  Infrastructure Shopping Service Subsystem      Default value     Default value         Y   N   N   N   OrderCartBC                                                                                                                                                              
OrderCartView                          Order Entry - Line Items View (Sales)                                                    String       Subsystem  Infrastructure Shopping Service Subsystem      Default value     Default value         Y   N   N   N   OrderCartView                                                                                                                                                            
OrigMsgFile                                                                                                                     String       Subsystem  Communications Outbound Manager                Never set         Never set             N   N   N   N   Original Message File                                                                                                                                                    
PSPCacheMaxItemCntLevel1               10000                                                                                    Integer      Subsystem  PSP Engine                                     Default value     Default value         Y   N   N   N   PSP Level 1 Cache Max Item Count                                                                                                                                         
PSPCacheMaxItemCntLevel2               10000                                                                                    Integer      Subsystem  PSP Engine                                     Default value     Default value         Y   N   N   N   PSP Level 2 Cache Max Item Count                                                                                                                                         
PackageNameList                                                                                                                 String       Subsystem  Communications Outbound Manager                Never set         Never set             N   N   N   N   Comm Template Name List                                                                                                                                                  
ParametricSearchResultsView            Parametric Search Results View                                                           String       Subsystem  Infrastructure Shopping Service Subsystem      Default value     Default value         Y   N   N   N   ParametricSearchResultsView                                                                                                                                              
Password                               ********                                                                                 String       Subsystem  Database Access                                Enterprise level  Enterprise level set  Y   N   N   N   Password                                                                                                                                                                 
PeerAuth                               False                                                                                    Boolean      Subsystem  Networking                                     Default value     Default value         N   N   Y   N   Peer Authentication                                                                                                                                                      
PeerCertValidation                     False                                                                                    Boolean      Subsystem  Networking                                     Default value     Default value         N   N   Y   N   Validate peer certificate                                                                                                                                                
PersistentShoppingCart                 FALSE                                                                                    String       Subsystem  Infrastructure Shopping Service Subsystem      Default value     Default value         Y   N   N   N   PersistentShoppingCart                                                                                                                                                   
PostAddToCartLogic                                                                                                              String       Subsystem  Infrastructure Shopping Service Subsystem      Never set         Never set             Y   N   N   N   PostAddToCartLogic                                                                                                                                                       
PreloadJVM                             False                                                                                    Boolean      Subsystem  Object Manager                                 Default value     Default value         N   Y   N   Y   OM - Preload Java VM                                                                                                                                                     
PreloadSRF                             False                                                                                    Boolean      Subsystem  Object Manager                                 Default value     Default value         N   N   Y   N   OM - Preload SRF Data                                                                                                                                                    
PriceListCacheLifeTime                 -1                                                                                       Integer      Subsystem  Infrastructure Pricingcache subsystem          Default value     Default value         Y   N   N   N   Price List Cache Life Time                                                                                                                                               
PriceListItemCacheLifeTime             -1                                                                                       Integer      Subsystem  Infrastructure Pricingcache subsystem          Default value     Default value         Y   N   N   N   Price List Item Cache Life Time                                                                                                                                          
PricerMappingCacheSize                 100                                                                                      Integer      Subsystem  Infrastructure Pricingcache subsystem          Default value     Default value         Y   N   N   N   Pricer Mapping Cache Size                                                                                                                                                
PricerPriceItemCacheSize               100                                                                                      Integer      Subsystem  Infrastructure Pricingcache subsystem          Default value     Default value         Y   N   N   N   Price Item Cache Size                                                                                                                                                    
PricerPriceListCacheSize               20                                                                                       Integer      Subsystem  Infrastructure Pricingcache subsystem          Default value     Default value         Y   N   N   N   Price List Cache Size                                                                                                                                                    
PricerPriceModelCacheSize              50                                                                                       Integer      Subsystem  Infrastructure Pricingcache subsystem          Default value     Default value         Y   N   N   N   Price Model Cache Size                                                                                                                                                   
PricerVolDisCacheSize                  50                                                                                       Integer      Subsystem  Infrastructure Pricingcache subsystem          Default value     Default value         Y   N   N   N   Price Volume discount Cache Size                                                                                                                                         
ProcessMode                            Remote                                                                                   String       Subsystem  Communications Outbound Manager                Default value     Default value         N   N   N   N   Process Mode                                                                                                                                                             
ProductDetailView                      NONE                                                                                     String       Subsystem  Infrastructure Shopping Service Subsystem      Default value     Default value         Y   N   N   N   ProductDetailView                                                                                                                                                        
ProposalReportTimeoutInSecond          1800                                                                                     Integer      Subsystem  eDoc Sub System                                Default value     Default value         N   N   N   N   ProposalReportTimeoutInSecond                                                                                                                                            
ProxyEmployee                                                                                                                   String       Subsystem  Object Manager                                 Never set         Never set             Y   N   N   N   OM - Proxy Employee                                                                                                                                                      
QuoteCartBC                            Quote                                                                                    String       Subsystem  Infrastructure Shopping Service Subsystem      Default value     Default value         Y   N   N   N   QuoteCartBC                                                                                                                                                              
QuoteCartView                          Quote Detail View                                                                        String       Subsystem  Infrastructure Shopping Service Subsystem      Default value     Default value         Y   N   N   N   QuoteCartView                                                                                                                                                            
RTSSleepTime                           30                                                                                       Integer      Subsystem  RTS Sub System                                 Default value     Default value         Y   N   N   N   RTS Sleep Time                                                                                                                                                           
RecipSearchSpec                                                                                                                 String       Subsystem  Communications Outbound Manager                Never set         Never set             N   N   N   N   Recipient Search Spec                                                                                                                                                    
RecipientBusComp                                                                                                                String       Subsystem  Communications Outbound Manager                Never set         Never set             N   N   N   N   Recipient Business Component                                                                                                                                             
RecipientGroup                                                                                                                  String       Subsystem  Communications Outbound Manager                Never set         Never set             N   N   N   N   Recipient Group                                                                                                                                                          
RecycleFactor                          0                                                                                        Integer      Subsystem  Multi-Threading                                Default value     Default value         N   N   Y   N   Recycle Factor                                                                                                                                                           
RegularAsgn                            True                                                                                     Boolean      Subsystem  Assignment Subsystem                           Default value     Default value         Y   N   N   N   Regular Assignment                                                                                                                                                       
Repository                             Siebel Repository                                                                        String       Subsystem  Database Access                                Default value     Default value         Y   N   N   N   Siebel Repository                                                                                                                                                        
RequestBodyTemplate                                                                                                             String       Subsystem  Communications Outbound Manager                Never set         Never set             N   N   N   N   Request Body Template                                                                                                                                                    
RequestDefaultMedium                                                                                                            String       Subsystem  Communications Outbound Manager                Never set         Never set             N   N   N   N   Request Default Medium                                                                                                                                                   
RequestLanguageCode                                                                                                             String       Subsystem  Communications Outbound Manager                Never set         Never set             N   N   N   N   Language Code                                                                                                                                                            
RequestLocaleCode                                                                                                               String       Subsystem  Communications Outbound Manager                Never set         Never set             N   N   N   N   Locale Code                                                                                                                                                              
RequestName                                                                                                                     String       Subsystem  Communications Outbound Manager                Never set         Never set             N   N   N   N   Request Name                                                                                                                                                             
RequestSendFlag                        N                                                                                        String       Subsystem  Communications Outbound Manager                Default value     Default value         N   N   N   N   Request Send Flag                                                                                                                                                        
RequestSubjectTemplate                                                                                                          String       Subsystem  Communications Outbound Manager                Never set         Never set             N   N   N   N   Request Subject Template                                                                                                                                                 
RequestTimeZone                                                                                                                 String       Subsystem  Communications Outbound Manager                Never set         Never set             N   N   N   N   Request Time Zone                                                                                                                                                        
ResourceAccessControl                  True                                                                                     Boolean      Subsystem  Object Manager                                 Default value     Default value         N   N   Y   N   OM - Enable Resource Access Control                                                                                                                                      
ResourceLanguage                                                                                                                String       Subsystem  Object Manager                                 Never set         Never set             Y   N   N   N   OM - Resource Language Code                                                                                                                                              
RestrictPrimaryJoin                    False                                                                                    Boolean      Subsystem  Datasources Subsystem                          Default value     Default value         Y   N   N   N   Restrict Primary Join                                                                                                                                                    
RetryInterval                          5                                                                                        Integer      Subsystem  Recovery                                       Default value     Default value         Y   N   N   N   Retry Interval                                                                                                                                                           
RetryUpTime                            600                                                                                      Integer      Subsystem  Recovery                                       Default value     Default value         Y   N   N   N   Retry Up Time                                                                                                                                                            
RootDir                                /app/siebel/siebsrvr                                                                     String       Server                                                    Server level      Server level set      N   N   Y   N   Siebel Root Directory                                                                                                                                                    
RptMode                                None                                                                                     String       Subsystem  Assignment Subsystem                           Default value     Default value         Y   N   N   N   Reporting Mode                                                                                                                                                           
RtdApplicationName                                                                                                              String       Subsystem  Marketing Server Subsystem                     Never set         Never set             Y   N   N   N   RTD Application Name                                                                                                                                                     
RtdSessionCookieName                   JSESSIONID                                                                               String       Subsystem  Marketing Server Subsystem                     Default value     Default value         Y   N   N   N   RTD Session Cookie Name                                                                                                                                                  
RtdSoapURL                             http://CHANGE_ME/rtis/sdwp                                                               String       Subsystem  Marketing Server Subsystem                     Default value     Default value         Y   N   N   N   RTD SOAP URL                                                                                                                                                             
RtdWebServiceTimeout                   3000                                                                                     Integer      Subsystem  Marketing Server Subsystem                     Default value     Default value         Y   N   N   N   RTD WebService Timeout                                                                                                                                                   
SAPBAPIDispatchMethod                                                                                                           String       Subsystem  SAP                                            Never set         Never set             Y   N   N   N   SAP BAPI Dispatch Method Name                                                                                                                                            
SAPBAPIDispatchService                                                                                                          String       Subsystem  SAP                                            Never set         Never set             Y   N   N   N   SAP BAPI Dispatch Service Name                                                                                                                                           
SAPCodepage                                                                                                                     String       Subsystem  SAP                                            Never set         Never set             Y   N   N   N   SAP Codepage                                                                                                                                                             
SAPIDOCDispatchMethod                                                                                                           String       Subsystem  SAP                                            Never set         Never set             Y   N   N   N   SAPIDOC Dispatch Method Name                                                                                                                                             
SAPIDOCDispatchService                                                                                                          String       Subsystem  SAP                                            Never set         Never set             Y   N   N   N   SAP IDOC Dispatch Service Name                                                                                                                                           
SAPIdocAllowedObjects                                                                                                           String       Subsystem  SAP                                            Never set         Never set             Y   N   N   N   SAP IDOC Allowed Objects                                                                                                                                                 
SAPIgnoreCharSetConvErrors             False                                                                                    String       Subsystem  SAP                                            Default value     Default value         Y   N   N   N   SAP Ignore Char Set Conversion Errors                                                                                                                                    
SAPInitialSystemCodepage                                                                                                        String       Subsystem  SAP                                            Never set         Never set             Y   N   N   N   SAP Initial System Codepage                                                                                                                                              
SAPMqLink                              False                                                                                    Boolean      Subsystem  SAP                                            Never set         Never set             Y   N   N   N   SAP MQSeries Link                                                                                                                                                        
SAPReceiverPrtnrNum                    DFLT_PRTNR                                                                               String       Subsystem  SAP                                            Default value     Default value         Y   N   N   N   SAP Receiver Partner Number                                                                                                                                              
SAPReceiverPrtnrType                   LS                                                                                       String       Subsystem  SAP                                            Default value     Default value         Y   N   N   N   SAP Receiver Partner Type                                                                                                                                                
SAPReceiverReconnectTime               0                                                                                        String       Subsystem  SAP                                            Default value     Default value         Y   N   N   N   SAP Receiver Reconnect Time                                                                                                                                              
SAPRfcConnectString                                                                                                             String       Subsystem  SAP                                            Never set         Never set             Y   N   N   N   SAP RFC Connect String                                                                                                                                                   
SAPRfcDestEntry                                                                                                                 String       Subsystem  SAP                                            Never set         Never set             Y   N   N   N   SAP RFC Destination Entry                                                                                                                                                
SAPRfcPassword                         ********                                                                                 String       Subsystem  SAP                                            Never set         Never set             Y   N   N   N   SAP RFC Password                                                                                                                                                         
SAPRfcTrace                            False                                                                                    Boolean      Subsystem  SAP                                            Never set         Never set             Y   N   N   N   SAP RFC Trace                                                                                                                                                            
SAPRfcUserName                                                                                                                  String       Subsystem  SAP                                            Never set         Never set             Y   N   N   N   SAP RFC User Name                                                                                                                                                        
SAPSenderPrtnrNum                                                                                                               String       Subsystem  SAP                                            Never set         Never set             Y   N   N   N   SAP Sender Partner Number                                                                                                                                                
SAPSenderPrtnrType                     LS                                                                                       String       Subsystem  SAP                                            Default value     Default value         Y   N   N   N   SAP Sender Partner Type                                                                                                                                                  
SAPSiebelWaitTime                                                                                                               String       Subsystem  SAP                                            Never set         Never set             Y   N   N   N   SAP Siebel Wait Time                                                                                                                                                     
SAPSleepTime                                                                                                                    String       Subsystem  SAP                                            Never set         Never set             Y   N   N   N   SAP Sleep Time                                                                                                                                                           
SAPTransactionMode                                                                                                              String       Subsystem  SAP                                            Never set         Never set             Y   N   N   N   SAP Transaction Mode                                                                                                                                                     
SAPWaitTime                                                                                                                     String       Subsystem  SAP                                            Never set         Never set             Y   N   N   N   SAP Wait Time                                                                                                                                                            
SAPWakeupCount                                                                                                                  String       Subsystem  SAP                                            Never set         Never set             Y   N   N   N   SAP Wakeup Count                                                                                                                                                         
SAPWakeupTime                                                                                                                   String       Subsystem  SAP                                            Never set         Never set             Y   N   N   N   SAP Wakeup Time                                                                                                                                                          
SAPWriteXML                                                                                                                     String       Subsystem  SAP                                            Never set         Never set             Y   N   N   N   SAP Write XML Mode                                                                                                                                                       
SAPXMLQueueCleanup                                                                                                              String       Subsystem  SAP                                            Never set         Never set             Y   N   N   N   SAP XML Queue Cleanup Flag                                                                                                                                               
SAPXMLQueueName                                                                                                                 String       Subsystem  SAP                                            Never set         Never set             Y   N   N   N   SAP XML Queue Name                                                                                                                                                       
SAPXMLQueueService                                                                                                              String       Subsystem  SAP                                            Never set         Never set             Y   N   N   N   SAP XML Queue Service Name                                                                                                                                               
SAPtRFCService                                                                                                                  String       Subsystem  SAP                                            Never set         Never set             Y   N   N   N   SAP tRFC Service Name                                                                                                                                                    
SARMBufferSize                         5000000                                                                                  Integer      Subsystem  (SARM) Response Measurement                    Default value     Default value         N   N   N   N   SARM Buffer Size                                                                                                                                                         
SARMClientLevel                        0                                                                                        Integer      Subsystem  (SARM) Response Measurement                    Default value     Default value         N   N   N   N   Sarm Client Granularity Level                                                                                                                                            
SARMFileSize                           15000000                                                                                 Integer      Subsystem  (SARM) Response Measurement                    Default value     Default value         N   N   N   N   SARM Data File Size                                                                                                                                                      
SARMLevel                              0                                                                                        Integer      Subsystem  (SARM) Response Measurement                    Default value     Default value         N   N   N   N   SARM Granularity Level                                                                                                                                                   
SARMLogDirectory                                                                                                                String       Subsystem  (SARM) Response Measurement                    Never set         Never set             N   N   N   N   Sarm Log Directory                                                                                                                                                       
SARMMaxFiles                           4                                                                                        Integer      Subsystem  (SARM) Response Measurement                    Default value     Default value         N   N   N   N   SARM Max Number of files                                                                                                                                                 
SARMPeriod                             3                                                                                        Integer      Subsystem  (SARM) Response Measurement                    Default value     Default value         N   N   N   N   SARM Period                                                                                                                                                              
SARMThreshold                          0                                                                                        Integer      Subsystem  (SARM) Response Measurement                    Default value     Default value         N   N   N   N   Sarm Threshold                                                                                                                                                           
SARMUsers                                                                                                                       String       Subsystem  (SARM) Response Measurement                    Never set         Never set             N   N   N   N   Sarm Users                                                                                                                                                               
SMTPServer                                                                                                                      String       Subsystem  SMTP subsystem                                 Never set         Never set             Y   N   N   N   SMTP Server Name                                                                                                                                                         
SMTPServerPort                         25                                                                                       Integer      Subsystem  SMTP subsystem                                 Default value     Default value         Y   N   N   N   SMTP Server Port                                                                                                                                                         
SRB ReqId                              0                                                                                        String       Subsystem  Infrastructure Core                            Default value     Default value         Y   N   N   N   SRB RequestId                                                                                                                                                            
SSLHello                               False                                                                                    Boolean      Subsystem  Networking                                     Default value     Default value         Y   N   N   N   SSL Encrypted SISNAPI HELLO                                                                                                                                              
SavePreferences                        True                                                                                     Boolean      Subsystem  Object Manager                                 Default value     Default value         N   N   Y   N   OM - Save Preferences                                                                                                                                                    
SearchDefName                                                                                                                   String       Subsystem  Object Manager                                 Never set         Never set             Y   N   N   N   Search - Definition Name                                                                                                                                                 
SearchEngine                           Fulcrum                                                                                  String       Subsystem  Object Manager                                 Default value     Default value         Y   N   N   N   Search - Engine Name                                                                                                                                                     
SearchInstallDir                                                                                                                String       Subsystem  Object Manager                                 Never set         Never set             Y   N   N   N   Search - Install Directory                                                                                                                                               
SearchRemoteServer                     FALSE                                                                                    String       Subsystem  Object Manager                                 Default value     Default value         Y   N   N   N   Search - Remote Server                                                                                                                                                   
SearchRemoteServerPath                                                                                                          String       Subsystem  Object Manager                                 Never set         Never set             Y   N   N   N   Search - Remote Server Path                                                                                                                                              
SecAdptMode                            DB                                                                                       String       Subsystem  Security Manager                               Enterprise level  Enterprise level set  N   Y   N   Y   Security Adapter Mode                                                                                                                                                    
SecAdptName                            DBSecAdpt                                                                                String       Subsystem  Security Manager                               Enterprise level  Enterprise level set  N   Y   N   Y   Security Adapter Name                                                                                                                                                    
Server                                                                                                                          String       Server                                                    Never set         Never set             Y   N   N   N   Siebel Server Name                                                                                                                                                       
ServerDesc                             Siebel Server Profile siebfoobar                                                         String       Server                                                    Server level      Server level set      Y   N   N   N   Server Description                                                                                                                                                       
ServerHostAddress                                                                                                               String       Server                                                    Never set         Never set             N   N   Y   N   Server Host Address                                                                                                                                                      
ServerSessionBusSvc                                                                                                             String       Subsystem  Object Manager                                 Never set         Never set             N   Y   N   Y   Server Session Business Service                                                                                                                                          
ServerSessionBusSvcContext                                                                                                      String       Subsystem  Object Manager                                 Never set         Never set             N   N   N   N   Server Session Business Service Context                                                                                                                                  
ServerSessionBusSvcMethod                                                                                                       String       Subsystem  Object Manager                                 Never set         Never set             N   Y   N   Y   Server Session Business Service Method                                                                                                                                   
ServerSessionLoopSleepTime             -1                                                                                       Integer      Subsystem  Object Manager                                 Default value     Default value         N   N   N   N   Server Session Loop Sleep Time                                                                                                                                           
ShoppingCartView                       Current Quote View (eSales)                                                              String       Subsystem  Infrastructure Shopping Service Subsystem      Default value     Default value         Y   N   N   N   ShoppingCartView                                                                                                                                                         
ShutdownTime                           60                                                                                       Integer      Server                                                    Default value     Default value         Y   N   N   N   Server Shutdown Wait Time                                                                                                                                                
SleepTime                              60                                                                                       Integer      Subsystem  Infrastructure Core                            Default value     Default value         Y   N   N   N   Sleep Time                                                                                                                                                               
SmqAlwaysAuthenticate                  False                                                                                    Boolean      Subsystem  SMQ Transport Subsystem                        Default value     Default value         Y   N   N   N   SMQ Always Authenticate                                                                                                                                                  
SmqCompression                         GZIP                                                                                     String       Subsystem  SMQ Transport Subsystem                        Default value     Default value         Y   N   N   N   SMQ Compression Algorithm                                                                                                                                                
SmqEncryption                          RC4                                                                                      String       Subsystem  SMQ Transport Subsystem                        Default value     Default value         Y   N   N   N   SMQ Encryption Algorithm                                                                                                                                                 
SourceBusObj                                                                                                                    String       Subsystem  Communications Outbound Manager                Never set         Never set             N   N   N   N   Source Business Object                                                                                                                                                   
SourceIdList                                                                                                                    String       Subsystem  Communications Outbound Manager                Never set         Never set             N   N   N   N   Source Id List                                                                                                                                                           
StageAllocationThreshold               0                                                                                        Integer      Subsystem  Marketing Server Subsystem                     Never set         Never set             Y   N   N   N   Stage Allocation Threshold                                                                                                                                               
TableGroupFile                                                                                                                  String       Subsystem  Database Access                                Never set         Never set             Y   N   N   N   Table Groupings File                                                                                                                                                     
TableOwnPass                           ********                                                                                 String       Subsystem  Database Access                                Never set         Never set             Y   N   N   N   Table Owner Password                                                                                                                                                     
TableOwner                             SIEBEL                                                                                   String       Subsystem  Database Access                                Enterprise level  Enterprise level set  Y   N   N   N   Table Owner                                                                                                                                                              
TaskRecipMin                                                                                                                    String       Subsystem  Communications Outbound Manager                Never set         Never set             N   N   N   N   Task Recipient Minimum                                                                                                                                                   
TaskStartDate                                                                                                                   String       Subsystem  Communications Outbound Manager                Never set         Never set             N   N   N   N   Task Start Date                                                                                                                                                          
TblSpace                                                                                                                        String       Subsystem  Database Access                                Never set         Never set             Y   N   N   N   Tablespace Name                                                                                                                                                          
TestAddress                                                                                                                     String       Subsystem  Communications Outbound Manager                Never set         Never set             N   N   N   N   Test Address                                                                                                                                                             
TestExecutableSearchPath                                                                                                        String       Subsystem  Testing Subsystem                              Never set         Never set             Y   N   N   N   Test Exectuable Search Path                                                                                                                                              
TestExecuteMethodName                                                                                                           String       Subsystem  Testing Subsystem                              Never set         Never set             Y   N   N   N   Test Execute Method Name                                                                                                                                                 
TestExecuteServiceName                                                                                                          String       Subsystem  Testing Subsystem                              Never set         Never set             Y   N   N   N   Test Execute Service Name                                                                                                                                                
TestInputDataSearchPath                                                                                                         String       Subsystem  Testing Subsystem                              Never set         Never set             Y   N   N   N   Test Input Data Search Path                                                                                                                                              
TestResultsSearchPath                                                                                                           String       Subsystem  Testing Subsystem                              Never set         Never set             Y   N   N   N   Test Results Search Path                                                                                                                                                 
TestScriptSearchPath                                                                                                            String       Subsystem  Testing Subsystem                              Never set         Never set             Y   N   N   N   Test Script Search Path                                                                                                                                                  
TestSuiteFileName                                                                                                               String       Subsystem  Testing Subsystem                              Never set         Never set             Y   N   N   N   Test Suite File Name                                                                                                                                                     
TestSuiteTestName                                                                                                               String       Subsystem  Testing Subsystem                              Never set         Never set             Y   N   N   N   Test Suite Test Name                                                                                                                                                     
TestSuiteWriteResults                  True                                                                                     Boolean      Subsystem  Testing Subsystem                              Default value     Default value         Y   N   N   N   Test Suite Write Results                                                                                                                                                 
UCMBatchObjectType                     Contact                                                                                  String       Subsystem  Universal Customer Master Subsystem            Default value     Default value         N   N   N   N   UCM Batch Object Type                                                                                                                                                    
UCMBatchSize                           10                                                                                       Integer      Subsystem  Universal Customer Master Subsystem            Default value     Default value         N   N   N   N   UCM Batch Size                                                                                                                                                           
UCMCDMCleanseFlag                      False                                                                                    Boolean      Subsystem  Universal Customer Master Subsystem            Default value     Default value         N   N   N   N   UCM Data Management Cleanse Flag                                                                                                                                         
UCMCDMExactMatchFlag                   False                                                                                    Boolean      Subsystem  Universal Customer Master Subsystem            Default value     Default value         N   N   N   N   UCM Data Management Exact Match Flag                                                                                                                                     
UCMCDMMatchFlag                        False                                                                                    Boolean      Subsystem  Universal Customer Master Subsystem            Default value     Default value         N   N   N   N   UCM Data Management Match Flag                                                                                                                                           
UCMPubSubFlag                          False                                                                                    Boolean      Subsystem  Universal Customer Master Subsystem            Default value     Default value         N   N   N   N   UCM Publish/Subscribe Flag                                                                                                                                               
UCMSearchSpec                                                                                                                   String       Subsystem  Universal Customer Master Subsystem            Never set         Never set             N   N   N   N   UCM Search Specification                                                                                                                                                 
UCMSleepTime                           60                                                                                       Integer      Subsystem  Universal Customer Master Subsystem            Default value     Default value         N   N   N   N   UCM Sleep Time                                                                                                                                                           
UCMSortSpec                                                                                                                     String       Subsystem  Universal Customer Master Subsystem            Never set         Never set             N   N   N   N   UCM Sort Specification                                                                                                                                                   
UCMSurvivorshipEngineFlag              False                                                                                    Boolean      Subsystem  Universal Customer Master Subsystem            Default value     Default value         N   N   N   N   UCM Survivorship Engine Flag                                                                                                                                             
UpdateInterval                         1440                                                                                     Integer      Subsystem  Categorization Manager                         Default value     Default value         N   N   N   N   KB Update Interval                                                                                                                                                       
UpgComponent                           Siebel HQ Server                                                                         String       Server                                                    Default value     Default value         Y   N   N   N   Upgrade Component                                                                                                                                                        
UpperThreshold                         100                                                                                      Integer      Subsystem  Multi-Threading                                Default value     Default value         N   N   Y   N   Local load balancing upper threshold                                                                                                                                     
UseKeyVal                              None                                                                                     String       Subsystem  Assignment Subsystem                           Default value     Default value         Y   N   N   N   Use Key Value                                                                                                                                                            
Username                               SADMIN                                                                                   String       Subsystem  Database Access                                Enterprise level  Enterprise level set  Y   N   N   N   User Name                                                                                                                                                                
UsernameBCField                                                                                                                 String       Subsystem  Object Manager                                 Never set         Never set             Y   N   N   N   OM - Username BC Field                                                                                                                                                   
VersionCheck                           False                                                                                    Boolean      Server                                                    Default value     Default value         Y   N   N   N   Version Check                                                                                                                                                            
Vertical                               sia                                                                                      String       Subsystem  Vertical                                       Enterprise level  Enterprise level set  Y   N   N   N   OM - Vertical                                                                                                                                                            
VirtualHostsFile                                                                                                                String       Subsystem  Client Uses Session Manager                    Never set         Never set             N   N   Y   N   Session manager load balancing configuration file                                                                                                                        
WaveBatchSize                          10000                                                                                    Integer      Subsystem  Marketing Server Subsystem                     Default value     Default value         Y   N   N   N   Wave Batch Size                                                                                                                                                          
WebCollabEnable                        False                                                                                    Boolean      Subsystem  Web Collaboration Subsystem                    Default value     Default value         Y   N   N   N   Web Collab Enable                                                                                                                                                        
WebCollabEnableSimulation              False                                                                                    Boolean      Subsystem  Web Collaboration Subsystem                    Default value     Default value         Y   N   N   N   Web Collab Enable Simulation                                                                                                                                             
WebCollabLangCodeMap                   PIXION_LANGCODE_MAP                                                                      String       Subsystem  Web Collaboration Subsystem                    Default value     Default value         Y   N   N   N   Web Collab Language Code Map                                                                                                                                             
WebCollabLogFile                       WebCollab.log                                                                            String       Subsystem  Web Collaboration Subsystem                    Default value     Default value         Y   N   N   N   Web Collab Log File                                                                                                                                                      
WebCollabLogLevel                      0                                                                                        Integer      Subsystem  Web Collaboration Subsystem                    Default value     Default value         Y   N   N   N   Web Collab Log Level                                                                                                                                                     
WebCollabServer                        CHANGE_ME                                                                                String       Subsystem  Web Collaboration Subsystem                    Default value     Default value         Y   N   N   N   Web Collab Server                                                                                                                                                        
WebCollabType                          Siebel eCollaboration                                                                    String       Subsystem  Web Collaboration Subsystem                    Default value     Default value         Y   N   N   N   Web Collab Package                                                                                                                                                       
WebCollabUseSiebelSessionId            True                                                                                     Boolean      Subsystem  Web Collaboration Subsystem                    Default value     Default value         Y   N   N   N   Web Collab Using Siebel Session Id                                                                                                                                       
WebCollabUseSiebelUQ                   True                                                                                     Boolean      Subsystem  Web Collaboration Subsystem                    Default value     Default value         Y   N   N   N   Web Collab Using Siebel UQ                                                                                                                                               
WebServer                                                                                                                       String       Subsystem  Communications Outbound Manager                Never set         Never set             N   N   N   N   Web Server                                                                                                                                                               
XMLPReportDataDir                      /xmlp/data/                                                                              String       Subsystem  Infrastructure XMLP Reports Subsystem          Default value     Default value         Y   N   N   N   XMLP Report Data.cfg Dir                                                                                                                                                 
XMLPReportOutputDir                    /xmlp/reports/                                                                           String       Subsystem  Infrastructure XMLP Reports Subsystem          Default value     Default value         Y   N   N   N   XMLP Report Output.cfg Dir                                                                                                                                               
XMLPReportWaitTime                     10                                                                                       Integer      Subsystem  Infrastructure XMLP Reports Subsystem          Default value     Default value         Y   N   N   N   XMLP Report Wait Time Limit                                                                                                                                              
XMLPReportXdoDir                       /xmlp/templates/                                                                         String       Subsystem  Infrastructure XMLP Reports Subsystem          Default value     Default value         Y   N   N   N   XMLP Report xdo.cfg Dir                                                                                                                                                  
eProdCfgAttrSnapshotFlg                True                                                                                     Boolean      Subsystem  Object Manager                                 Default value     Default value         Y   N   N   N   Product Configurator - Collect and Use the snapshots of the ISS_ATTR_DEF ObWhether or not to check the synchronization between Cfg Cache and DB Record For ISS_ATTR_DEF  
eProdCfgAutoMatchInstance              False                                                                                    Boolean      Subsystem  Object Manager                                 Default value     Default value         Y   N   N   N   Product Configurator - Auto match quote on reconfigure                                                                                                                   
eProdCfgCacheFS                                                                                                                 String       Subsystem  Object Manager                                 Never set         Never set             Y   N   N   N   Product Configurator - FS location                                                                                                                                       
eProdCfgCheckSelfContainded            True                                                                                     Boolean      Subsystem  Object Manager                                 Default value     Default value         Y   N   N   N   Product Configurator - Check if Complex Product is Self-containded                                                                                                       
eProdCfgClassSnapshotFlg               True                                                                                     Boolean      Subsystem  Object Manager                                 Default value     Default value         Y   N   N   N   Product Configurator - Collect and Use the snapshots of  ISS_CLASS_DEF Ob                                                                                                
eProdCfgKeepAliveTime                  900                                                                                      Integer      Subsystem  Object Manager                                 Default value     Default value         Y   N   N   N   Product Configurator - Keep Alive Time of Idle Session                                                                                                                   
eProdCfgMaxNumbOfWorkerReuses          10                                                                                       Integer      Subsystem  Object Manager                                 Default value     Default value         Y   N   N   N   Product Configurator - Number of Reuse for each Worker                                                                                                                   
eProdCfgNumOfCachedAttrs               100                                                                                      Integer      Subsystem  Object Manager                                 Default value     Default value         Y   N   N   N   Product Configurator - Number of Attribute Definitions Cached in Memory                                                                                                  
eProdCfgNumOfCachedClasses             100                                                                                      Integer      Subsystem  Object Manager                                 Default value     Default value         Y   N   N   N   Product Configurator - Number of Class Definitions Cached in Memory                                                                                                      
eProdCfgNumOfCachedObjects             1000                                                                                     Integer      Subsystem  Object Manager                                 Default value     Default value         Y   N   N   N   Product Configurator - Number of Objects Cached in Memory                                                                                                                
eProdCfgNumOfCachedProdInfo            1000                                                                                     Integer      Subsystem  Object Manager                                 Default value     Default value         Y   N   N   N   Product Configurator - Number of ProdIfo Objects Cached in Memory                                                                                                        
eProdCfgNumOfCachedProducts            1000                                                                                     Integer      Subsystem  Object Manager                                 Default value     Default value         Y   N   N   N   Product Configurator - Number of Product Definitions Cached in Memory                                                                                                    
eProdCfgNumbOfCachedCatalogs           10                                                                                       Integer      Subsystem  Object Manager                                 Default value     Default value         Y   N   N   N   Product Configurator - Number of Catalogs Cached in Memory                                                                                                               
eProdCfgNumbOfCachedFactories          10                                                                                       Integer      Subsystem  Object Manager                                 Default value     Default value         Y   N   N   N   Product Configurator - Number of Factories Cached in Memory                                                                                                              
eProdCfgNumbOfCachedWorkers            50                                                                                       Integer      Subsystem  Object Manager                                 Default value     Default value         Y   N   N   N   Product Configurator - Number of Workers Cached in Memory                                                                                                                
eProdCfgProdSnapshotFlg                True                                                                                     Boolean      Subsystem  Object Manager                                 Default value     Default value         Y   N   N   N   Product Configurator - Collect and Use the snapshots of  ISS_PROD_DEF Ob                                                                                                 
eProdCfgRemote                         False                                                                                    Boolean      Subsystem  Object Manager                                 Default value     Default value         Y   N   N   N   Product Configurator - Use Remote Service                                                                                                                                
eProdCfgServer                                                                                                                  String       Subsystem  Object Manager                                 Never set         Never set             Y   N   N   N   Product Configurator - Remote Server Name                                                                                                                                
eProdCfgSnapshotFlg                    True                                                                                     Boolean      Subsystem  Object Manager                                 Default value     Default value         Y   N   N   N   Product Configurator - Collect and Use the snapshots of the Cfg Objects                                                                                                  
eProdCfgTimeOut                        20                                                                                       Integer      Subsystem  Object Manager                                 Default value     Default value         Y   N   N   N   Product Configurator - Time Out of Connection                                                                                                                            
eProdCfgTryBypassIlog                  True                                                                                     Boolean      Subsystem  Object Manager                                 Default value     Default value         Y   N   N   N   Product Configurator - Try to  Restore Quote witout Ilog                                                                                                                 
eProdCfgWorkerMemReleaseFlg            False                                                                                    Boolean      Subsystem  Object Manager                                 Default value     Default value         Y   N   N   N   Product Configurator - Release Worker Memory at the end of session                                                                                                       

398 rows returned.

BLOCK

$data{ls_params_srproc} = <<'BLOCK';
PA_ALIAS                 PA_VALUE                                                 PA_DATATYPE  PA_SCOPE   PA_SUBSYSTEM                 PA_SETLEVEL       PA_DISP_SETLEVEL                PA  PA  PA  PA  PA_NAME                                            
-----------------------  -------------------------------------------------------  -----------  ---------  ---------------------------  ----------------  ------------------------------  --  --  --  --  -------------------------------------------------  
16KTblSpace                                                                       String       Subsystem  Database Access              Never set         Never set                       Y   N   N   N   16K Tablespace Name                                
32KTblSpace                                                                       String       Subsystem  Database Access              Never set         Never set                       Y   N   N   N   32K Tablespace Name                                
AutoRestart              True                                                     Boolean      Subsystem  Process Management           Default value     Default value                   Y   N   N   N   Auto Restart                                       
CACertFileName                                                                    String       Subsystem  Networking                   Never set         Never set                       N   N   Y   N   CA certificate file name                           
CertFileName                                                                      String       Subsystem  Networking                   Never set         Never set                       N   N   Y   N   Certificate file name                              
CheckErrorLeaks          False                                                    Boolean      Subsystem  Infrastructure Core          Default value     Default value                   Y   N   N   N   Check Error Leaks                                  
CommType                 TCPIP                                                    String       Subsystem  Networking                   Default value     Default value                   Y   N   N   N   Communication Transport                            
Compress                 NONE                                                     String       Subsystem  Networking                   Default value     Default value                   Y   N   N   N   Compression Type                                   
ConnIdleTime             -1                                                       Integer      Subsystem  Networking                   Default value     Default value                   Y   N   N   N   SISNAPI connection maximum idle time               
Connect                  SBL_DEV_DSN                                              String       Subsystem  Database Access              Enterprise level  Enterprise level set            Y   N   N   N   ODBC Data Source                                   
Crypt                    NONE                                                     String       Subsystem  Networking                   Default value     Default value                   Y   N   N   N   Encryption Type                                    
DB2DisableAutoCommit     Y                                                        String       Subsystem  Database Access              Default value     Default value                   Y   N   N   N   Disable Autocommit                                 
DB2DisableMinMemMode                                                              String       Subsystem  Database Access              Never set         Never set                       Y   N   N   N   Disable DB2 CLI MinMemMode                         
DBRollbackSeg                                                                     String       Subsystem  Database Access              Never set         Never set                       Y   N   N   N   DataBase Rollback Segment Name                     
DfltTasks                1                                                        Integer      Subsystem  Process Management           Compdef level     Component definition level set  Y   N   N   N   Default Tasks                                      
DisableNotification      False                                                    Boolean      Subsystem  Infrastructure Notification  Default value     Default value                   N   N   N   N   Disable Notification                               
EnableAuditTrail         True                                                     Boolean      Subsystem  Name Server Management       Default value     Default value                   Y   N   N   N   Enable Name Server Audit Trail                     
EnableDbSessCorrelation  False                                                    Boolean      Subsystem  Database Access              Default value     Default value                   Y   N   N   N   Enable Database Session Correlation                
EnableEventHistory       True                                                     Boolean      Subsystem  Infrastructure Core          Default value     Default value                   N   N   N   N   Enable Event History Facility                      
EnableHousekeeping       False                                                    Boolean      Component                               Default value     Default value                   N   N   N   N   Enable Various Housekeeping Tasks                  
EnableUsageTracking      False                                                    Boolean      Subsystem  Usage Tracking               Default value     Default value                   N   N   N   N   UsageTracking Enabled                              
EventSleepTime           30                                                       Integer      Subsystem  Infrastructure Core          Default value     Default value                   Y   N   N   N   Event History Sleep Time                           
FDRAppendFile            False                                                    Boolean      Subsystem  (FDR) Flight Data Recorder   Default value     Default value                   N   N   N   N   FDR Periodic Dump and Append                       
FDRBufferSize            5000000                                                  Integer      Subsystem  (FDR) Flight Data Recorder   Default value     Default value                   N   Y   N   Y   FDR Buffer Size                                    
FileSystem               /app/siebel/gtwysrvr/fs                                  String       Subsystem  Infrastructure Core          Enterprise level  Enterprise level set            Y   N   N   N   Siebel File System                                 
HTTPKeepAlive            0                                                        Integer      Subsystem  Networking                   Default value     Default value                   Y   N   N   N   Server http keepalive time                         
IdxSpace                                                                          String       Subsystem  Database Access              Never set         Never set                       Y   N   N   N   Indexspace Name                                    
KeyFileName                                                                       String       Subsystem  Networking                   Never set         Never set                       N   N   Y   N   Private key file name                              
KeyFilePassword          ********                                                 String       Subsystem  Networking                   Never set         Never set                       N   N   Y   N   Private key file password                          
Lang                     enu                                                      String       Subsystem  Infrastructure Core          Server level      Server level set                Y   N   N   N   Language Code                                      
LogArchive               2                                                        Integer      Subsystem  Event Logging                Server level      Server level set                Y   N   N   N   Log Archive Keep                                   
LogArchiveDir                                                                     String       Subsystem  Event Logging                Never set         Never set                       Y   N   N   N   Log Archive Directory                              
LogDir                   /app/siebel/siebsrvr/enterprises/SBL_DEV/siebfoobar/log  String       Subsystem  Event Logging                Server level      Server level set                N   N   N   N   Log directory                                      
LogFileDir               c:\temp                                                  String       Subsystem  Usage Tracking               Default value     Default value                   N   N   N   N   UsageTracking LogFile Dir                          
LogFileEncoding          ASCII                                                    String       Subsystem  Usage Tracking               Default value     Default value                   N   N   N   N   UsageTracking LogFile Encoding                     
LogFileFormat            XML                                                      String       Subsystem  Usage Tracking               Default value     Default value                   N   N   N   N   UsageTracking LogFile Format                       
LogFilePeriod            Hourly                                                   String       Subsystem  Usage Tracking               Default value     Default value                   N   N   N   N   UsageTracking LogFile Period                       
LogFlushFreq             0                                                        Integer      Subsystem  Event Logging                Default value     Default value                   N   N   N   N   Number of lines after which to flush the log file  
LogMaxSegments           100                                                      Integer      Subsystem  Event Logging                Compdef level     Component definition level set  N   N   N   N   Maximum number of log file segments                
LogSegmentSize           100                                                      Integer      Subsystem  Event Logging                Compdef level     Component definition level set  N   N   N   N   Log file segment size in KB                        
LogTimestamp             True                                                     Boolean      Subsystem  Event Logging                Default value     Default value                   N   N   N   N   Log Print Timestamp                                
LogUseErrorBuffer        False                                                    Boolean      Subsystem  Event Logging                Default value     Default value                   Y   N   N   N   Use Error Buffer                                   
LogUseSharedFile         False                                                    Boolean      Subsystem  Event Logging                Default value     Default value                   Y   N   N   N   Use Shared Log File                                
LongTblSpace                                                                      String       Subsystem  Database Access              Never set         Never set                       Y   N   N   N   Long Tablespace Name                               
MaxMTServers             1                                                        Integer      Subsystem  Multi-Threading              Compdef level     Component definition level set  N   N   Y   N   Maximum MT Servers                                 
MaxTaskHistory           20                                                       Integer      Subsystem  Process Management           Default value     Default value                   N   N   Y   N   Maximum Historic Tasks                             
MaxTasks                 20                                                       Integer      Subsystem  Process Management           Compdef level     Component definition level set  N   N   Y   N   Maximum Tasks                                      
MemoryBasedRecycle       False                                                    Boolean      Subsystem  Multi-Threading              Default value     Default value                   Y   N   N   N   Memory usage based multithread shell recycling     
MemoryLimit              1500                                                     Integer      Subsystem  Multi-Threading              Default value     Default value                   Y   N   N   N   Process VM usage lower limit                       
MemoryLimitPercent       20                                                       Integer      Subsystem  Multi-Threading              Default value     Default value                   Y   N   N   N   Process VM usage upper limit                       
MinMTServers             1                                                        Integer      Subsystem  Multi-Threading              Compdef level     Component definition level set  N   N   Y   N   Minimum MT Servers                                 
MinUpTime                60                                                       Integer      Subsystem  Process Management           Default value     Default value                   Y   N   N   N   Minimum Up Time                                    
MssqlOptimizeCursorFlg   False                                                    Boolean      Subsystem  Database Access              Default value     Default value                   N   Y   N   Y   MSSQL Optimize Cursor Flag                         
MuteIdleState            False                                                    Boolean      Subsystem  Infrastructure Core          Never set         Never set                       Y   N   N   N   Mute Idle State                                    
NSAdminRole              Siebel Administrator                                     String       Subsystem  Name Server Management       Default value     Default value                   N   N   Y   N   Name Server Admin Role                             
NotifyHandler            AdminEmailAlert                                          String       Subsystem  Infrastructure Notification  Server level      Server level set                N   N   N   N   Notification Handler                               
NotifyOnTaskExit         0                                                        Integer      Subsystem  Infrastructure Notification  Default value     Default value                   N   N   N   N   Notification Action on Task Exit                   
NotifyTimeOut            100                                                      Integer      Subsystem  Infrastructure Notification  Default value     Default value                   N   N   N   N   Time to wait for doing notification                
NumRestart               10                                                       Integer      Subsystem  Process Management           Default value     Default value                   Y   N   N   N   Numbers of Restarts                                
NumRetries               10000                                                    Integer      Subsystem  Recovery                     Default value     Default value                   Y   N   N   N   Number of Retries                                  
OOBSizeTaskDivisor       5                                                        Integer      Subsystem  Multi-Threading              Default value     Default value                   N   Y   N   Y   OOB Queue size MaxTasks divisor                    
Password                 ********                                                 String       Subsystem  Database Access              Enterprise level  Enterprise level set            Y   N   N   N   Password                                           
PeerAuth                 False                                                    Boolean      Subsystem  Networking                   Default value     Default value                   N   N   Y   N   Peer Authentication                                
PeerCertValidation       False                                                    Boolean      Subsystem  Networking                   Default value     Default value                   N   N   Y   N   Validate peer certificate                          
PortNumber               0                                                        Integer      Subsystem  Networking                   Default value     Default value                   N   N   Y   N   Static Port Number                                 
RecycleFactor            0                                                        Integer      Subsystem  Multi-Threading              Default value     Default value                   N   N   Y   N   Recycle Factor                                     
Repository               Siebel Repository                                        String       Subsystem  Database Access              Default value     Default value                   Y   N   N   N   Siebel Repository                                  
RetryInterval            5                                                        Integer      Subsystem  Recovery                     Default value     Default value                   Y   N   N   N   Retry Interval                                     
RetryUpTime              600                                                      Integer      Subsystem  Recovery                     Default value     Default value                   Y   N   N   N   Retry Up Time                                      
SARMBufferSize           5000000                                                  Integer      Subsystem  (SARM) Response Measurement  Default value     Default value                   N   N   N   N   SARM Buffer Size                                   
SARMClientLevel          0                                                        Integer      Subsystem  (SARM) Response Measurement  Default value     Default value                   N   N   N   N   Sarm Client Granularity Level                      
SARMFileSize             15000000                                                 Integer      Subsystem  (SARM) Response Measurement  Default value     Default value                   N   N   N   N   SARM Data File Size                                
SARMLevel                0                                                        Integer      Subsystem  (SARM) Response Measurement  Default value     Default value                   N   N   N   N   SARM Granularity Level                             
SARMLogDirectory                                                                  String       Subsystem  (SARM) Response Measurement  Never set         Never set                       N   N   N   N   Sarm Log Directory                                 
SARMMaxFiles             4                                                        Integer      Subsystem  (SARM) Response Measurement  Default value     Default value                   N   N   N   N   SARM Max Number of files                           
SARMPeriod               3                                                        Integer      Subsystem  (SARM) Response Measurement  Default value     Default value                   N   N   N   N   SARM Period                                        
SARMThreshold            0                                                        Integer      Subsystem  (SARM) Response Measurement  Default value     Default value                   N   N   N   N   Sarm Threshold                                     
SARMUsers                                                                         String       Subsystem  (SARM) Response Measurement  Never set         Never set                       N   N   N   N   Sarm Users                                         
SQLTraceThreshold                                                                 String       Subsystem  Database Access              Never set         Never set                       Y   N   N   N   SQL Trace Threshold                                
SRB ReqId                0                                                        String       Subsystem  Infrastructure Core          Default value     Default value                   Y   N   N   N   SRB RequestId                                      
SSLHello                 False                                                    Boolean      Subsystem  Networking                   Default value     Default value                   Y   N   N   N   SSL Encrypted SISNAPI HELLO                        
SessPerSisnConn          20                                                       Integer      Subsystem  Interactive                  Default value     Default value                   N   Y   N   Y   Number of Sessions per SISNAPI Connection          
SessionCacheSize         100                                                      Integer      Subsystem  Usage Tracking               Default value     Default value                   N   N   N   N   UsageTracking Session Cache Size                   
SleepTime                60                                                       Integer      Subsystem  Infrastructure Core          Default value     Default value                   Y   N   N   N   Sleep Time                                         
TableGroupFile                                                                    String       Subsystem  Database Access              Never set         Never set                       Y   N   N   N   Table Groupings File                               
TableOwnPass             ********                                                 String       Subsystem  Database Access              Never set         Never set                       Y   N   N   N   Table Owner Password                               
TableOwner               SIEBEL                                                   String       Subsystem  Database Access              Enterprise level  Enterprise level set            Y   N   N   N   Table Owner                                        
TblSpace                                                                          String       Subsystem  Database Access              Never set         Never set                       Y   N   N   N   Tablespace Name                                    
UpperThreshold           100                                                      Integer      Subsystem  Multi-Threading              Default value     Default value                   N   N   Y   N   Local load balancing upper threshold               
UserList                                                                          String       Subsystem  Event Logging                Never set         Never set                       N   N   N   N   List of users                                      
Username                 SADMIN                                                   String       Subsystem  Database Access              Enterprise level  Enterprise level set            Y   N   N   N   User Name                                          

91 rows returned.

BLOCK

$data{ls_comp_def_srproc} = <<'BLOCK';
CC_NAME                                                                       CT_NAME                                                                       CC_RUNMODE                       CC_ALIAS                         CC_DISP_ENABLE_ST                                              CC_DESC_TEXT                                                                                                                                                                                                                                                 CG_NAME                                                                       CG_ALIAS                         CC_INCARN_NO             
----------------------------------------------------------------------------  ----------------------------------------------------------------------------  -------------------------------  -------------------------------  -------------------------------------------------------------  --------------------------------------------------------------------------------------------------------------------  ----------------------------------------------------------------------------  -------------------------------  -----------------------  
Server Request Processor                                                      Server Request Processor (SRP)                                                Interactive                      SRProc                           Active                                                         Server Request scheduler and request/notification store and forward processor                                                                                                                                                                                Auxiliary System Management                                                   SystemAux                        0                        

1 row returned.

BLOCK

$data{ls_tasks} = <<'BLOCK';
SV_NAME     CC_ALIAS                   TK_TASKID  TK_PID  TK_DISP_RUNSTATE   CC_RUNMODE   TK_START_TIME        TK_END_TIME          TK_STATUS                                                                                                         CG_ALIAS        TK_PARENT_TASKNUM  CC_INCARN_NO  TK_LABEL             TK_TASKTYPE  TK_PING_TIME  
----------  -------------------------  ---------  ------  -----------------  -----------  -------------------  -------------------  ----------------------------------------------------------------------------------------------------------------  --------------  -----------------  ------------  -------------------  -----------  ------------  
siebfoobar  ServerMgr                  46137346   22151   Running            Interactive  2013-04-22 19:03:08  2000-00-00 00:00:00  Processing "List Tasks" command                                                                                   System                             0                                  Normal                     
siebfoobar  ServerMgr                  45088770   22145   Completed          Interactive  2013-04-22 19:01:40  2013-04-22 19:01:43                                                                                                                    System                             0                                  Normal                     
siebfoobar  eCommunicationsObjMgr_enu  39845898   21139   Completed          Interactive  2013-04-22 15:34:14  2013-04-22 15:39:31                                                                                                                    Communications                     0             guestcst             Normal                     
siebfoobar  EAIObjMgr_enu              37748863   20903   Running            Interactive  2013-04-22 18:01:18  2000-00-00 00:00:00  Waiting for command                                                                                               EAI                                0             AIAUSER              Normal                     
siebfoobar  EAIObjMgr_enu              37748860   20903   Running            Interactive  2013-04-22 18:01:17  2000-00-00 00:00:00  Waiting for command                                                                                               EAI                                0             AIAUSER              Normal                     
siebfoobar  EAIObjMgr_enu              37748857   20903   Running            Interactive  2013-04-22 18:01:17  2000-00-00 00:00:00  Waiting for command                                                                                               EAI                                0             AIAUSER              Normal                     
siebfoobar  EAIObjMgr_enu              37748854   20903   Running            Interactive  2013-04-22 18:01:17  2000-00-00 00:00:00  Waiting for command                                                                                               EAI                                0             AIAUSER              Normal                     
siebfoobar  EAIObjMgr_enu              37748851   20903   Running            Interactive  2013-04-22 18:01:17  2000-00-00 00:00:00  Waiting for command                                                                                               EAI                                0             AIAUSER              Normal                     
siebfoobar  EAIObjMgr_enu              37748848   20903   Running            Interactive  2013-04-22 18:01:16  2000-00-00 00:00:00  Waiting for command                                                                                               EAI                                0             AIAUSER              Normal                     
siebfoobar  EAIObjMgr_enu              37748845   20903   Running            Interactive  2013-04-22 18:01:16  2000-00-00 00:00:00  Waiting for command                                                                                               EAI                                0             AIAUSER              Normal                     
siebfoobar  EAIObjMgr_enu              37748842   20903   Running            Interactive  2013-04-22 18:01:16  2000-00-00 00:00:00  Waiting for command                                                                                               EAI                                0             AIAUSER              Normal                     
siebfoobar  EAIObjMgr_enu              37748839   20903   Running            Interactive  2013-04-22 18:01:16  2000-00-00 00:00:00  Waiting for command                                                                                               EAI                                0             AIAUSER              Normal                     
siebfoobar  EAIObjMgr_enu              37748836   20903   Running            Interactive  2013-04-22 18:01:16  2000-00-00 00:00:00  Waiting for command                                                                                               EAI                                0             AIAUSER              Normal                     
siebfoobar  EAIObjMgr_enu              37748833   20903   Running            Interactive  2013-04-22 18:01:15  2000-00-00 00:00:00  Waiting for command                                                                                               EAI                                0             AIAUSER              Normal                     
siebfoobar  EAIObjMgr_enu              37748830   20903   Running            Interactive  2013-04-22 18:01:15  2000-00-00 00:00:00  Waiting for command                                                                                               EAI                                0             AIAUSER              Normal                     
siebfoobar  EAIObjMgr_enu              37748827   20903   Running            Interactive  2013-04-22 18:01:15  2000-00-00 00:00:00  Waiting for command                                                                                               EAI                                0             AIAUSER              Normal                     
siebfoobar  EAIObjMgr_enu              37748824   20903   Running            Interactive  2013-04-22 18:01:15  2000-00-00 00:00:00  Waiting for command                                                                                               EAI                                0             AIAUSER              Normal                     
siebfoobar  EAIObjMgr_enu              37748821   20903   Running            Interactive  2013-04-22 18:01:14  2000-00-00 00:00:00  Waiting for command                                                                                               EAI                                0             AIAUSER              Normal                     
siebfoobar  EAIObjMgr_enu              37748818   20903   Running            Interactive  2013-04-22 18:01:14  2000-00-00 00:00:00  Waiting for command                                                                                               EAI                                0             AIAUSER              Normal                     
siebfoobar  EAIObjMgr_enu              37748815   20903   Running            Interactive  2013-04-22 18:01:14  2000-00-00 00:00:00  Waiting for command                                                                                               EAI                                0             AIAUSER              Normal                     
siebfoobar  EAIObjMgr_enu              37748812   20903   Running            Interactive  2013-04-22 18:01:14  2000-00-00 00:00:00  Waiting for command                                                                                               EAI                                0             AIAUSER              Normal                     
siebfoobar  EAIObjMgr_enu              37748809   20903   Running            Interactive  2013-04-22 18:01:14  2000-00-00 00:00:00  Waiting for command                                                                                               EAI                                0             AIAUSER              Normal                     
siebfoobar  EAIObjMgr_enu              37748806   20903   Running            Interactive  2013-04-22 18:01:13  2000-00-00 00:00:00  Waiting for command                                                                                               EAI                                0             AIAUSER              Normal                     
siebfoobar  EAIObjMgr_enu              37748803   20903   Completed          Interactive  2013-04-22 15:56:57  2013-04-22 18:01:18                                                                                                                    EAI                                0             AIAUSER              Normal                     
siebfoobar  EAIObjMgr_enu              37748800   20903   Completed          Interactive  2013-04-22 15:56:57  2013-04-22 18:01:17                                                                                                                    EAI                                0             AIAUSER              Normal                     
siebfoobar  EAIObjMgr_enu              37748797   20903   Completed          Interactive  2013-04-22 15:56:56  2013-04-22 18:01:17                                                                                                                    EAI                                0             AIAUSER              Normal                     
siebfoobar  EAIObjMgr_enu              37748794   20903   Completed          Interactive  2013-04-22 15:56:56  2013-04-22 18:01:17                                                                                                                    EAI                                0             AIAUSER              Normal                     
siebfoobar  EAIObjMgr_enu              37748791   20903   Completed          Interactive  2013-04-22 15:56:56  2013-04-22 18:01:17                                                                                                                    EAI                                0             AIAUSER              Normal                     
siebfoobar  EAIObjMgr_enu              37748788   20903   Completed          Interactive  2013-04-22 15:56:56  2013-04-22 18:01:16                                                                                                                    EAI                                0             AIAUSER              Normal                     
siebfoobar  EAIObjMgr_enu              37748785   20903   Completed          Interactive  2013-04-22 15:56:56  2013-04-22 18:01:16                                                                                                                    EAI                                0             AIAUSER              Normal                     
siebfoobar  EAIObjMgr_enu              37748782   20903   Completed          Interactive  2013-04-22 15:56:55  2013-04-22 18:01:16                                                                                                                    EAI                                0             AIAUSER              Normal                     
siebfoobar  EAIObjMgr_enu              37748779   20903   Completed          Interactive  2013-04-22 15:56:55  2013-04-22 18:01:16                                                                                                                    EAI                                0             AIAUSER              Normal                     
siebfoobar  EAIObjMgr_enu              37748776   20903   Completed          Interactive  2013-04-22 15:56:55  2013-04-22 18:01:16                                                                                                                    EAI                                0             AIAUSER              Normal                     
siebfoobar  EAIObjMgr_enu              37748773   20903   Completed          Interactive  2013-04-22 15:56:55  2013-04-22 18:01:15                                                                                                                    EAI                                0             AIAUSER              Normal                     
siebfoobar  EAIObjMgr_enu              37748770   20903   Completed          Interactive  2013-04-22 15:56:55  2013-04-22 18:01:15                                                                                                                    EAI                                0             AIAUSER              Normal                     
siebfoobar  EAIObjMgr_enu              37748767   20903   Completed          Interactive  2013-04-22 15:56:54  2013-04-22 18:01:15                                                                                                                    EAI                                0             AIAUSER              Normal                     
siebfoobar  EAIObjMgr_enu              37748764   20903   Completed          Interactive  2013-04-22 15:56:54  2013-04-22 18:01:15                                                                                                                    EAI                                0             AIAUSER              Normal                     
siebfoobar  EAIObjMgr_enu              37748761   20903   Completed          Interactive  2013-04-22 15:56:54  2013-04-22 18:01:14                                                                                                                    EAI                                0             AIAUSER              Normal                     
siebfoobar  EAIObjMgr_enu              37748758   20903   Completed          Interactive  2013-04-22 15:56:54  2013-04-22 18:01:14                                                                                                                    EAI                                0             AIAUSER              Normal                     
siebfoobar  EAIObjMgr_enu              37748755   20903   Completed          Interactive  2013-04-22 15:56:54  2013-04-22 18:01:14                                                                                                                    EAI                                0             AIAUSER              Normal                     
siebfoobar  EAIObjMgr_enu              37748752   20903   Completed          Interactive  2013-04-22 15:56:53  2013-04-22 18:01:14                                                                                                                    EAI                                0             AIAUSER              Normal                     
siebfoobar  EAIObjMgr_enu              37748749   20903   Completed          Interactive  2013-04-22 15:56:53  2013-04-22 18:01:13                                                                                                                    EAI                                0             AIAUSER              Normal                     
siebfoobar  EAIObjMgr_enu              37748746   20903   Completed          Interactive  2013-04-22 15:56:12  2013-04-22 18:01:13                                                                                                                    EAI                                0             AIAUSER              Normal                     
siebfoobar  WfProcBatchMgr             34603065   20770   Completed          Batch        2013-04-22 19:00:00  2013-04-22 19:00:22                                                                                                                    Workflow                           0                                  Normal                     
siebfoobar  WfProcBatchMgr             34603064   20770   Completed          Batch        2013-04-22 19:00:00  2013-04-22 19:00:22                                                                                                                    Workflow                           0                                  Normal                     
siebfoobar  WfProcBatchMgr             34603063   20770   Exited with error  Batch        2013-04-22 19:00:00  2013-04-22 19:00:05  SBL-OMS-00203: Error 6750317 invoking method "RunBatch" for Bus                                                   Workflow                           0                                  Normal                     
siebfoobar  WfProcBatchMgr             34603062   20770   Exited with error  Batch        2013-04-22 18:50:01  2013-04-22 18:50:05  SBL-OMS-00203: Error 6750317 invoking method "RunBatch" for Bus                                                   Workflow                           0                                  Normal                     
siebfoobar  WfProcBatchMgr             34603061   20770   Exited with error  Batch        2013-04-22 18:40:02  2013-04-22 18:40:06  SBL-OMS-00203: Error 6750317 invoking method "RunBatch" for Bus                                                   Workflow                           0                                  Normal                     
siebfoobar  WfProcBatchMgr             34603060   20770   Exited with error  Batch        2013-04-22 18:30:03  2013-04-22 18:30:07  SBL-OMS-00203: Error 6750317 invoking method "RunBatch" for Bus                                                   Workflow                           0                                  Normal                     
siebfoobar  WfProcBatchMgr             34603059   20770   Exited with error  Batch        2013-04-22 18:20:03  2013-04-22 18:20:07  SBL-OMS-00203: Error 6750317 invoking method "RunBatch" for Bus                                                   Workflow                           0                                  Normal                     
siebfoobar  WfProcBatchMgr             34603058   20770   Exited with error  Batch        2013-04-22 18:10:04  2013-04-22 18:10:09  SBL-OMS-00203: Error 6750317 invoking method "RunBatch" for Bus                                                   Workflow                           0                                  Normal                     
siebfoobar  WfProcBatchMgr             34603057   20770   Completed          Batch        2013-04-22 18:00:05  2013-04-22 18:00:26                                                                                                                    Workflow                           0                                  Normal                     
siebfoobar  WfProcBatchMgr             34603056   20770   Completed          Batch        2013-04-22 18:00:05  2013-04-22 18:00:26                                                                                                                    Workflow                           0                                  Normal                     
siebfoobar  WfProcBatchMgr             34603055   20770   Exited with error  Batch        2013-04-22 18:00:05  2013-04-22 18:00:10  SBL-OMS-00203: Error 6750317 invoking method "RunBatch" for Bus                                                   Workflow                           0                                  Normal                     
siebfoobar  WfProcBatchMgr             34603054   20770   Exited with error  Batch        2013-04-22 17:50:06  2013-04-22 17:50:10  SBL-OMS-00203: Error 6750317 invoking method "RunBatch" for Bus                                                   Workflow                           0                                  Normal                     
siebfoobar  WfProcBatchMgr             34603053   20770   Exited with error  Batch        2013-04-22 17:40:07  2013-04-22 17:40:12  SBL-OMS-00203: Error 6750317 invoking method "RunBatch" for Bus                                                   Workflow                           0                                  Normal                     
siebfoobar  WfProcBatchMgr             34603052   20770   Exited with error  Batch        2013-04-22 17:30:08  2013-04-22 17:30:12  SBL-OMS-00203: Error 6750317 invoking method "RunBatch" for Bus                                                   Workflow                           0                                  Normal                     
siebfoobar  WfProcBatchMgr             34603051   20770   Exited with error  Batch        2013-04-22 17:20:09  2013-04-22 17:20:12  SBL-OMS-00203: Error 6750317 invoking method "RunBatch" for Bus                                                   Workflow                           0                                  Normal                     
siebfoobar  WfProcBatchMgr             34603050   20770   Exited with error  Batch        2013-04-22 17:10:10  2013-04-22 17:10:13  SBL-OMS-00203: Error 6750317 invoking method "RunBatch" for Bus                                                   Workflow                           0                                  Normal                     
siebfoobar  WfProcBatchMgr             34603049   20770   Completed          Batch        2013-04-22 17:00:00  2013-04-22 17:00:21                                                                                                                    Workflow                           0                                  Normal                     
siebfoobar  WfProcBatchMgr             34603048   20770   Completed          Batch        2013-04-22 17:00:00  2013-04-22 17:00:21                                                                                                                    Workflow                           0                                  Normal                     
siebfoobar  WfProcBatchMgr             34603047   20770   Exited with error  Batch        2013-04-22 17:00:00  2013-04-22 17:00:05  SBL-OMS-00203: Error 6750317 invoking method "RunBatch" for Bus                                                   Workflow                           0                                  Normal                     
siebfoobar  WfProcBatchMgr             34603046   20770   Exited with error  Batch        2013-04-22 16:50:01  2013-04-22 16:50:05  SBL-OMS-00203: Error 6750317 invoking method "RunBatch" for Bus                                                   Workflow                           0                                  Normal                     
siebfoobar  eCommunicationsObjMgr_ptb  30408717   21078   Completed          Interactive  2013-04-22 17:15:17  2013-04-22 17:16:20                                                                                                                    Communications                     0             DEL3004              Normal                     
siebfoobar  eCommunicationsObjMgr_ptb  30408714   21078   Completed          Interactive  2013-04-22 15:33:45  2013-04-22 15:39:04                                                                                                                    Communications                     0             guestcst             Normal                     
siebfoobar  TaskLogCleanup             28311554   20932   Running            Background   2013-04-22 15:32:34  2000-00-00 00:00:00  Method CleanTaskLog for service Task Log Cleanup Service has executed 42 times -- Sleeping                        TaskUI                             0             SADMIN               Normal                     
siebfoobar  WfProcMgr                  16777245   20818   Completed          Batch        2013-04-22 15:33:41  2013-04-22 15:33:41                                                                                                                    Workflow                           0             SADMIN               Normal                     
siebfoobar  WfProcMgr                  16777244   20818   Completed          Batch        2013-04-22 15:33:41  2013-04-22 15:33:41                                                                                                                    Workflow                           0                                  Normal                     
siebfoobar  SERAssetWorkMon            13631489   20806   Running            Background   2013-04-22 15:32:31  2000-00-00 00:00:00  Processed 0 requests                                                                                              Workflow                           0                                  Normal                     
siebfoobar  WorkMonSWI                 12582914   20803   Running            Background   2013-04-22 15:32:31  2000-00-00 00:00:00  Sleeping for 5 seconds...                                                                                         Workflow                           0                                  Normal                     
siebfoobar  SERAssetRecCMon            11534337   20761   Running            Background   2013-04-22 15:32:31  2000-00-00 00:00:00  Processed 0 requests                                                                                              Workflow                           0                                  Normal                     
siebfoobar  SvrTblCleanup              8388610    20562   Running            Background   2013-04-22 15:32:26  2000-00-00 00:00:00  Method DelCompletedDelExpiredReq for service Message Board Maintenance Service has executed 42 times -- Sleeping  SystemAux                          0             SADMIN               Normal                     
siebfoobar  SvrTaskPersist             7340034    20543   Running            Background   2013-04-22 15:32:26  2000-00-00 00:00:00  Method InsertUpdateTaskHistory for service Message Board Maintenance Service has executed 420 times -- Sleeping   SystemAux                          0             SADMIN               Normal                     
siebfoobar  SRProc                     5242888    20503   Running            Interactive  2013-04-22 15:32:28  2000-00-00 00:00:00                                                                                                                    SystemAux                          0                                  Normal                     
siebfoobar  SRProc                     5242885    20503   Running            Interactive  2013-04-22 15:32:28  2000-00-00 00:00:00                                                                                                                    SystemAux                          0             Forwarding Task      Worker                     
siebfoobar  FSMSrvr                    4194336    20500   Completed          Batch        2013-04-22 17:16:18  2013-04-22 17:16:20                                                                                                                    SystemAux                          0                                  Normal                     
siebfoobar  FSMSrvr                    4194335    20500   Completed          Batch        2013-04-22 17:15:22  2013-04-22 17:15:22                                                                                                                    SystemAux                          0                                  Normal                     
siebfoobar  FSMSrvr                    4194334    20500   Completed          Batch        2013-04-22 17:15:21  2013-04-22 17:15:21                                                                                                                    SystemAux                          0                                  Normal                     
siebfoobar  FSMSrvr                    4194333    20500   Completed          Batch        2013-04-22 17:15:21  2013-04-22 17:15:21                                                                                                                    SystemAux                          0                                  Normal                     
siebfoobar  FSMSrvr                    4194332    20500   Completed          Batch        2013-04-22 17:15:21  2013-04-22 17:15:21                                                                                                                    SystemAux                          0                                  Normal                     
siebfoobar  SCBroker                   3145730    20493   Running            Background   2013-04-22 15:32:25  2000-00-00 00:00:00                                                                                                                    System                             0                                  Normal                     
siebfoobar  SRBroker                   2097198    20490   Running            Interactive  2013-04-22 17:15:21  2000-00-00 00:00:00                                                                                                                    System                             0             COMP:FSMSrvr         Worker                     
siebfoobar  SRBroker                   2097196    20490   Running            Interactive  2013-04-22 15:34:42  2000-00-00 00:00:00                                                                                                                    System                             0             COMP:WfProcBatchMgr  Worker                     
siebfoobar  SRBroker                   2097194    20490   Running            Interactive  2013-04-22 15:33:41  2000-00-00 00:00:00                                                                                                                    System                             0             COMP:WfProcMgr       Worker                     
siebfoobar  SRBroker                   2097193    20490   Running            Interactive  2013-04-22 15:32:54  2000-00-00 00:00:00                                                                                                                    System                             0                                  Normal                     
siebfoobar  SRBroker                   2097192    20490   Running            Interactive  2013-04-22 15:32:46  2000-00-00 00:00:00                                                                                                                    System                             0                                  Normal                     
siebfoobar  SRBroker                   2097191    20490   Running            Interactive  2013-04-22 15:32:44  2000-00-00 00:00:00                                                                                                                    System                             0                                  Normal                     
siebfoobar  SRBroker                   2097190    20490   Running            Interactive  2013-04-22 15:32:43  2000-00-00 00:00:00                                                                                                                    System                             0                                  Normal                     
siebfoobar  SRBroker                   2097189    20490   Running            Interactive  2013-04-22 15:32:39  2000-00-00 00:00:00                                                                                                                    System                             0                                  Normal                     
siebfoobar  SRBroker                   2097188    20490   Running            Interactive  2013-04-22 15:32:39  2000-00-00 00:00:00                                                                                                                    System                             0                                  Normal                     
siebfoobar  SRBroker                   2097187    20490   Running            Interactive  2013-04-22 15:32:39  2000-00-00 00:00:00                                                                                                                    System                             0                                  Normal                     
siebfoobar  SRBroker                   2097186    20490   Running            Interactive  2013-04-22 15:32:39  2000-00-00 00:00:00                                                                                                                    System                             0                                  Normal                     
siebfoobar  SRBroker                   2097185    20490   Running            Interactive  2013-04-22 15:32:38  2000-00-00 00:00:00                                                                                                                    System                             0                                  Normal                     
siebfoobar  SRBroker                   2097184    20490   Running            Interactive  2013-04-22 15:32:38  2000-00-00 00:00:00                                                                                                                    System                             0                                  Normal                     
siebfoobar  SRBroker                   2097183    20490   Running            Interactive  2013-04-22 15:32:38  2000-00-00 00:00:00                                                                                                                    System                             0                                  Normal                     
siebfoobar  SRBroker                   2097182    20490   Running            Interactive  2013-04-22 15:32:38  2000-00-00 00:00:00                                                                                                                    System                             0                                  Normal                     
siebfoobar  SRBroker                   2097181    20490   Running            Interactive  2013-04-22 15:32:37  2000-00-00 00:00:00                                                                                                                    System                             0                                  Normal                     
siebfoobar  SRBroker                   2097180    20490   Running            Interactive  2013-04-22 15:32:36  2000-00-00 00:00:00                                                                                                                    System                             0                                  Normal                     
siebfoobar  SRBroker                   2097179    20490   Running            Interactive  2013-04-22 15:32:36  2000-00-00 00:00:00                                                                                                                    System                             0                                  Normal                     
siebfoobar  SRBroker                   2097178    20490   Running            Interactive  2013-04-22 15:32:36  2000-00-00 00:00:00                                                                                                                    System                             0                                  Normal                     
siebfoobar  SRBroker                   2097177    20490   Running            Interactive  2013-04-22 15:32:37  2000-00-00 00:00:00                                                                                                                    System                             0                                  Normal                     
siebfoobar  SRBroker                   2097176    20490   Running            Interactive  2013-04-22 15:32:36  2000-00-00 00:00:00                                                                                                                    System                             0                                  Normal                     
siebfoobar  SRBroker                   2097175    20490   Running            Interactive  2013-04-22 15:32:36  2000-00-00 00:00:00                                                                                                                    System                             0                                  Normal                     
siebfoobar  SRBroker                   2097174    20490   Running            Interactive  2013-04-22 15:32:35  2000-00-00 00:00:00                                                                                                                    System                             0                                  Normal                     
siebfoobar  SRBroker                   2097173    20490   Running            Interactive  2013-04-22 15:32:35  2000-00-00 00:00:00                                                                                                                    System                             0                                  Normal                     
siebfoobar  SRBroker                   2097172    20490   Running            Interactive  2013-04-22 15:32:35  2000-00-00 00:00:00                                                                                                                    System                             0                                  Normal                     
siebfoobar  SRBroker                   2097171    20490   Running            Interactive  2013-04-22 15:32:33  2000-00-00 00:00:00                                                                                                                    System                             0                                  Normal                     
siebfoobar  SRBroker                   2097170    20490   Running            Interactive  2013-04-22 15:32:32  2000-00-00 00:00:00                                                                                                                    System                             0                                  Normal                     
siebfoobar  SRBroker                   2097169    20490   Running            Interactive  2013-04-22 15:32:31  2000-00-00 00:00:00                                                                                                                    System                             0                                  Normal                     
siebfoobar  SRBroker                   2097168    20490   Running            Interactive  2013-04-22 15:32:31  2000-00-00 00:00:00                                                                                                                    System                             0                                  Normal                     
siebfoobar  SRBroker                   2097167    20490   Running            Interactive  2013-04-22 15:32:31  2000-00-00 00:00:00                                                                                                                    System                             0                                  Normal                     
siebfoobar  SRBroker                   2097166    20490   Running            Interactive  2013-04-22 15:32:31  2000-00-00 00:00:00                                                                                                                    System                             0                                  Normal                     
siebfoobar  SRBroker                   2097164    20490   Running            Interactive  2013-04-22 15:32:28  2000-00-00 00:00:00                                                                                                                    System                             0                                  Normal                     
siebfoobar  SRBroker                   2097163    20490   Running            Interactive  2013-04-22 15:32:26  2000-00-00 00:00:00                                                                                                                    System                             0                                  Normal                     
siebfoobar  SRBroker                   2097162    20490   Running            Interactive  2013-04-22 15:32:26  2000-00-00 00:00:00                                                                                                                    System                             0             Task creation task   Worker                     
siebfoobar  SRBroker                   2097161    20490   Running            Interactive  2013-04-22 15:32:26  2000-00-00 00:00:00                                                                                                                    System                             0             Store task           Worker                     
siebfoobar  SRBroker                   2097160    20490   Running            Interactive  2013-04-22 15:32:26  2000-00-00 00:00:00                                                                                                                    System                             0             Response task        Worker                     
siebfoobar  SRBroker                   2097159    20490   Running            Interactive  2013-04-22 15:32:26  2000-00-00 00:00:00                                                                                                                    System                             0                                  Normal                     
siebfoobar  SRBroker                   2097157    20490   Running            Interactive  2013-04-22 15:32:26  2000-00-00 00:00:00                                                                                                                    System                             0             Information caching task  Worker                     

119 rows returned.

BLOCK

$data{ls_tasks_srproc} = <<'BLOCK';
SV_NAME     CC_ALIAS  TK_TASKID  TK_PID  TK_DISP_RUNSTATE  CC_RUNMODE   TK_START_TIME        TK_END_TIME          TK_STATUS  CG_ALIAS   TK_PARENT_TASKNUM  CC_INCARN_NO  TK_LABEL         TK_TASKTYPE  TK_PING_TIME  
----------  --------  ---------  ------  ----------------  -----------  -------------------  -------------------  ---------  ---------  -----------------  ------------  ---------------  -----------  ------------  
siebfoobar  SRProc    5242888    20503   Running           Interactive  2013-04-22 15:32:28  2000-00-00 00:00:00             SystemAux                     0                              Normal                     
siebfoobar  SRProc    5242885    20503   Running           Interactive  2013-04-22 15:32:28  2000-00-00 00:00:00             SystemAux                     0             Forwarding Task  Worker                     

2 rows returned.

BLOCK

$data{ls_servers} = <<'BLOCK';
SBLSRVR_NAME  SBLSRVR_GROUP_NAME  HOST_NAME   INSTALL_DIR           SBLMGR_PID  SV_DISP_STATE  SBLSRVR_STATE  START_TIME           END_TIME  SBLSRVR_STATUS                    
------------  ------------------  ----------  --------------------  ----------  -------------  -------------  -------------------  --------  --------------------------------  
siebfoobar                        siebfoobar  /app/siebel/siebsrvr  20452       Running        Running        2013-04-22 15:32:25            8.1.1.7 [21238] LANG_INDEPENDENT  

1 row returned.

BLOCK

foreach my $key ( keys(%data) ) {

    say $key;

    my @data;

    open( my $in, '<', \$data{$key} ) or die "Cannot read $key: $!\n";
    while (<$in>) {

        push( @data, $_ );

    }

    $data{$key} = \@data;

}

my $filename = shift;
chomp($filename);
DumpFile( $filename, \%data );
