package Test::ListCompTypes;

use Test::Most;
use Test::Moose 'has_attribute_ok';
use base 'Test::Class';

sub class { 'Siebel::Srvrmgr::ListParser::Output::ListCompTypes' }

sub startup : Tests(startup => 1) {

    my $test = shift;
    use_ok $test->class;
}

sub constructor : Tests(5) {

    my $test  = shift;
    my $class = $test->class;

    can_ok( $class, 'new' );

    #extended method tests
    can_ok( $class, qw(parse get_attribs set_attribs) );

    my @data = <Test::ListCompTypes::DATA>;
    close(Test::ListCompTypes::DATA);

    ok(
        my $comps = $class->new(
            {
                data_type => 'list_comp_types',
                raw_data  => \@data,
                cmd_line  => 'list comp types'
            }
        ),
        '... and the constructor should succeed'
    );

    has_attribute_ok( $comps, 'types_attribs' );

    isa_ok( $comps, $class, '... and the object it returns' );

}

1;

__DATA__
CT_NAME                                                                       CT_RUNMODE                       CT_ALIAS                                                       CT_DESC_TEXT                                                                                                                                                                                                                                                 
----------------------------------------------------------------------------  -------------------------------  -------------------------------------------------------------  --------------------------------------------------------------------------------------------------------------------  
ADM Service                                                                   Batch                            ADM Service                                                    ADM Service Service                                                                                                                                                                                                                                          
ADM Service                                                                   Background                       ADM Service                                                    ADM Service Service                                                                                                                                                                                                                                          
Siebel Administrator Notification Component                                   Batch                            AdminNotify                                                    Component used for administrator notification                                                                                                                                                                                                                
Analytic Adaptor Manager                                                      Batch                            Analytic Adaptor Manager                                       Analytic Adaptor Manager Service                                                                                                                                                                                                                             
Analytic Adaptor Manager                                                      Background                       Analytic Adaptor Manager                                       Analytic Adaptor Manager Service                                                                                                                                                                                                                             
Application Object Manager                                                    Interactive                      AppObjMgr                                                      Object manager component type for thin-client and web-client applications                                                                                                                                                                                    
Appointment Booking Service                                                   Batch                            Appointment Booking Service                                    Appointment Booking Service Service                                                                                                                                                                                                                          
Appointment Booking Service                                                   Background                       Appointment Booking Service                                    Appointment Booking Service Service                                                                                                                                                                                                                          
Batch Assignment                                                              Batch                            AsgnBatch                                                      Batch assigns positions and employees to objects                                                                                                                                                                                                             
Assignment Manager                                                            Batch                            AsgnSrvr                                                       Assigns positions and employees to objects                                                                                                                                                                                                                   
Business Service Manager                                                      Batch                            BusSvcMgr                                                      Business Service Manager component                                                                                                                                                                                                                           
Business Service Manager                                                      Background                       BusSvcMgr                                                      Business Service Manager component                                                                                                                                                                                                                           
Categorization Manager                                                        Batch                            Categorization Manager                                         Categorization Manager Service                                                                                                                                                                                                                               
Categorization Manager                                                        Background                       Categorization Manager                                         Categorization Manager Service                                                                                                                                                                                                                               
CheckDup                                                                      Batch                            CheckDup                                                       CheckDup Service                                                                                                                                                                                                                                             
CheckDup                                                                      Background                       CheckDup                                                       CheckDup Service                                                                                                                                                                                                                                             
Communications Inbound Receiver                                               Batch                            CommInboundRcvr                                                Loads response groups to receive and queue inbound events                                                                                                                                                                                                    
Communications Session Manager                                                Batch                            CommSessionMgr                                                 Interact with end user for utilizing communications channels                                                                                                                                                                                                 
Communication Server Configuration                                            Batch                            Communication Server Configuration                             Communication Server Configuration Service                                                                                                                                                                                                                   
Communication Server Configuration                                            Background                       Communication Server Configuration                             Communication Server Configuration Service                                                                                                                                                                                                                   
Communications Inbound Processor                                              Batch                            Communications Inbound Processor                               Communications Inbound Processor Service                                                                                                                                                                                                                     
Communications Inbound Processor                                              Background                       Communications Inbound Processor                               Communications Inbound Processor Service                                                                                                                                                                                                                     
Complete Activity                                                             Batch                            Complete Activity                                              Complete Activity Service                                                                                                                                                                                                                                    
Complete Activity                                                             Background                       Complete Activity                                              Complete Activity Service                                                                                                                                                                                                                                    
Content Project                                                               Batch                            Content Project                                                Content Project Service                                                                                                                                                                                                                                      
Content Project                                                               Background                       Content Project                                                Content Project Service                                                                                                                                                                                                                                      
Contracts Accumulator Service                                                 Batch                            Contracts Accumulator Service                                  Contracts Accumulator Service Service                                                                                                                                                                                                                        
Contracts Accumulator Service                                                 Background                       Contracts Accumulator Service                                  Contracts Accumulator Service Service                                                                                                                                                                                                                        
Contracts Evaluator Service                                                   Batch                            Contracts Evaluator Service                                    Contracts Evaluator Service Service                                                                                                                                                                                                                          
Contracts Evaluator Service                                                   Background                       Contracts Evaluator Service                                    Contracts Evaluator Service Service                                                                                                                                                                                                                          
Contracts Resolver Service                                                    Batch                            Contracts Resolver Service                                     Contracts Resolver Service Service                                                                                                                                                                                                                           
Contracts Resolver Service                                                    Background                       Contracts Resolver Service                                     Contracts Resolver Service Service                                                                                                                                                                                                                           
Crediting Engine DB Operations                                                Batch                            Crediting Engine DB Operations                                 Crediting Engine DB Operations Service                                                                                                                                                                                                                       
Crediting Engine DB Operations                                                Background                       Crediting Engine DB Operations                                 Crediting Engine DB Operations Service                                                                                                                                                                                                                       
Custom Application Object Manager                                             Interactive                      CustomAppObjMgr                                                Object manager component type for thin-client Custom UI applications                                                                                                                                                                                         
DCommerce Alerts                                                              Background                       DCommerce Alerts                                               Background process that manages DCommerce alerts                                                                                                                                                                                                             
DCommerce Automatic Auction Close                                             Background                       DCommerce Automatic Auction Close                              Background process that detects and closes auctions                                                                                                                                                                                                          
DNB Update                                                                    Batch                            DNB Update                                                     DNB Update Service                                                                                                                                                                                                                                           
DNB Update                                                                    Background                       DNB Update                                                     DNB Update Service                                                                                                                                                                                                                                           
Data Cleansing                                                                Batch                            Data Cleansing                                                 Data Cleansing Service                                                                                                                                                                                                                                       
Data Cleansing                                                                Background                       Data Cleansing                                                 Data Cleansing Service                                                                                                                                                                                                                                       
Database Extract                                                              Batch                            DbXtract                                                       Extracts visible data for a Siebel Remote client                                                                                                                                                                                                             
DeDuplication                                                                 Batch                            DeDuplication                                                  DeDuplication Service                                                                                                                                                                                                                                        
DeDuplication                                                                 Background                       DeDuplication                                                  DeDuplication Service                                                                                                                                                                                                                                        
Document Driver                                                               Batch                            Document Driver                                                Document Driver Service                                                                                                                                                                                                                                      
Document Driver                                                               Background                       Document Driver                                                Document Driver Service                                                                                                                                                                                                                                      
Data Quality Manager                                                          Batch                            Dqmgr                                                          Cleanse data and de-duplicate records                                                                                                                                                                                                                        
DynamicCommerce                                                               Batch                            DynamicCommerce                                                DynamicCommerce Service                                                                                                                                                                                                                                      
DynamicCommerce                                                               Background                       DynamicCommerce                                                DynamicCommerce Service                                                                                                                                                                                                                                      
EAI Business Integration Manager                                              Batch                            EAI Business Integration Manager                               EAI Business Integration Manager Service                                                                                                                                                                                                                     
EAI Business Integration Manager                                              Background                       EAI Business Integration Manager                               EAI Business Integration Manager Service                                                                                                                                                                                                                     
Enterprise Application Integration Connector Receiver                         Background                       EAIDeprecatedRcvr                                              Deprecated receiver for in-bound EAI transactions used by connectors                                                                                                                                                                                         
EAILOVService                                                                 Batch                            EAILOVService                                                  EAILOVService Service                                                                                                                                                                                                                                        
EAILOVService                                                                 Background                       EAILOVService                                                  EAILOVService Service                                                                                                                                                                                                                                        
EAI Object Manager                                                            Interactive                      EAIObjMgr                                                      Object manager component type for thin-client EAI applications                                                                                                                                                                                               
Enterprise Application Integration Receiver                                   Background                       EAIRcvr                                                        Generic receiver for in-bound EAI transactions                                                                                                                                                                                                               
Enterprise Integration Mgr                                                    Batch                            EIM                                                            Integrates enterprise data to and from other systems                                                                                                                                                                                                         
ERM Compensation Planning Service                                             Batch                            ERM Compensation Planning Service                              ERM Compensation Planning Service Service                                                                                                                                                                                                                    
ERM Compensation Planning Service                                             Background                       ERM Compensation Planning Service                              ERM Compensation Planning Service Service                                                                                                                                                                                                                    
Excel Importer Exporter                                                       Batch                            Excel Importer Exporter                                        Excel Importer Exporter Service                                                                                                                                                                                                                              
Excel Importer Exporter                                                       Background                       Excel Importer Exporter                                        Excel Importer Exporter Service                                                                                                                                                                                                                              
FS Cycle Counting                                                             Batch                            FS Cycle Counting                                              FS Cycle Counting Service                                                                                                                                                                                                                                    
FS Cycle Counting                                                             Background                       FS Cycle Counting                                              FS Cycle Counting Service                                                                                                                                                                                                                                    
FS Fulfillment Service                                                        Batch                            FS Fulfillment Service                                         FS Fulfillment Service Service                                                                                                                                                                                                                               
FS Fulfillment Service                                                        Background                       FS Fulfillment Service                                         FS Fulfillment Service Service                                                                                                                                                                                                                               
FS Mobile Inventory Transaction                                               Batch                            FS Mobile Inventory Transaction                                FS Mobile Inventory Transaction Service                                                                                                                                                                                                                      
FS Mobile Inventory Transaction                                               Background                       FS Mobile Inventory Transaction                                FS Mobile Inventory Transaction Service                                                                                                                                                                                                                      
FS Part Locator Service                                                       Batch                            FS Part Locator Service                                        FS Part Locator Service Service                                                                                                                                                                                                                              
FS Part Locator Service                                                       Background                       FS Part Locator Service                                        FS Part Locator Service Service                                                                                                                                                                                                                              
FS Preventive Maintenance                                                     Batch                            FS Preventive Maintenance                                      FS Preventive Maintenance Service                                                                                                                                                                                                                            
FS Preventive Maintenance                                                     Background                       FS Preventive Maintenance                                      FS Preventive Maintenance Service                                                                                                                                                                                                                            
FS Replenish                                                                  Batch                            FS Replenish                                                   FS Replenish Service                                                                                                                                                                                                                                         
FS Replenish                                                                  Background                       FS Replenish                                                   FS Replenish Service                                                                                                                                                                                                                                         
File System Manager                                                           Batch                            FSMSrvr                                                        The file system manager component                                                                                                                                                                                                                            
Forecast 2000 Internal Service                                                Batch                            Forecast 2000 Internal Service                                 Forecast 2000 Internal Service Service                                                                                                                                                                                                                       
Forecast 2000 Internal Service                                                Background                       Forecast 2000 Internal Service                                 Forecast 2000 Internal Service Service                                                                                                                                                                                                                       
Generate New Database                                                         Batch                            GenNewDb                                                       Generates a new Sybase SQL Anywhere database template file for Siebel Remote                                                                                                                                                                                 
Generate Triggers                                                             Batch                            GenTrig                                                        Generates triggers for Workflow Manager and Assignment Manager                                                                                                                                                                                               
HTIM MDF Period Ending Service                                                Batch                            HTIM MDF Period Ending Service                                 HTIM MDF Period Ending Service Service                                                                                                                                                                                                                       
HTIM MDF Period Ending Service                                                Background                       HTIM MDF Period Ending Service                                 HTIM MDF Period Ending Service Service                                                                                                                                                                                                                       
Handheld Batch Synchronization                                                Batch                            Handheld Batch Synchronization                                 Handheld Batch Synchronization Service                                                                                                                                                                                                                       
Handheld Batch Synchronization                                                Background                       Handheld Batch Synchronization                                 Handheld Batch Synchronization Service                                                                                                                                                                                                                       
Handheld Synchronization Agent                                                Batch                            Handheld Synchronization Agent                                 Handheld Synchronization Agent Service                                                                                                                                                                                                                       
Handheld Synchronization Agent                                                Background                       Handheld Synchronization Agent                                 Handheld Synchronization Agent Service                                                                                                                                                                                                                       
Handheld Synchronization                                                      Batch                            Handheld Synchronization                                       Handheld Synchronization Service                                                                                                                                                                                                                             
Handheld Synchronization                                                      Background                       Handheld Synchronization                                       Handheld Synchronization Service                                                                                                                                                                                                                             
IC Quota Import Service                                                       Batch                            IC Quota Import Service                                        IC Quota Import Service Service                                                                                                                                                                                                                              
IC Quota Import Service                                                       Background                       IC Quota Import Service                                        IC Quota Import Service Service                                                                                                                                                                                                                              
IComp Credit Assignment Engine                                                Batch                            ICompCreditAsgn                                                Assigns credit allocation based on crediting rules                                                                                                                                                                                                           
Incentive Compensation Mgr                                                    Batch                            ICompMgr                                                       Calculates Incentive Compensations                                                                                                                                                                                                                           
SRM Tester for key-based routing                                              Batch                            KRSrmTst                                                       Server Request Manager Test Component for key-based routing                                                                                                                                                                                                  
LOY Processing Engine                                                         Batch                            LOY Processing Engine                                          LOY Processing Engine Service                                                                                                                                                                                                                                
LOY Processing Engine                                                         Background                       LOY Processing Engine                                          LOY Processing Engine Service                                                                                                                                                                                                                                
List Import                                                                   Batch                            List Import                                                    List Import Service                                                                                                                                                                                                                                          
List Import                                                                   Background                       List Import                                                    List Import Service                                                                                                                                                                                                                                          
List Manager                                                                  Batch                            ListMgr                                                        Loads outside files for list manager                                                                                                                                                                                                                         
E-mail Manager                                                                Background                       MailMgr                                                        Sends e-mail initiated by Workflow Manager                                                                                                                                                                                                                   
Message Board Maintenance Service                                             Batch                            Message Board Maintenance Service                              Message Board Maintenance Service Service                                                                                                                                                                                                                    
Message Board Maintenance Service                                             Background                       Message Board Maintenance Service                              Message Board Maintenance Service Service                                                                                                                                                                                                                    
OM Regression Test                                                            Batch                            OM Regression Test                                             OM Regression Test Service                                                                                                                                                                                                                                   
OM Regression Test                                                            Background                       OM Regression Test                                             OM Regression Test Service                                                                                                                                                                                                                                   
OM Remote Regression Test                                                     Batch                            OM Remote Regression Test                                      OM Remote Regression Test Service                                                                                                                                                                                                                            
OM Remote Regression Test                                                     Background                       OM Remote Regression Test                                      OM Remote Regression Test Service                                                                                                                                                                                                                            
Optimizer Service                                                             Batch                            Optimizer Service                                              Optimizer Service Service                                                                                                                                                                                                                                    
Optimizer Service                                                             Background                       Optimizer Service                                              Optimizer Service Service                                                                                                                                                                                                                                    
Outbound Communications Manager                                               Batch                            Outbound Communications Manager                                Outbound Communications Manager Service                                                                                                                                                                                                                      
Outbound Communications Manager                                               Background                       Outbound Communications Manager                                Outbound Communications Manager Service                                                                                                                                                                                                                      
PIMSI Engine Service                                                          Batch                            PIMSI Engine Service                                           PIMSI Engine Service Service                                                                                                                                                                                                                                 
PIMSI Engine Service                                                          Background                       PIMSI Engine Service                                           PIMSI Engine Service Service                                                                                                                                                                                                                                 
Page Manager                                                                  Background                       PageMgr                                                        Sends pages initiated by Workflow Manager and Siebel Client                                                                                                                                                                                                  
Perf MQReceive Processor                                                      Batch                            Perf MQReceive Processor                                       Perf MQReceive Processor Service                                                                                                                                                                                                                             
Perf MQReceive Processor                                                      Background                       Perf MQReceive Processor                                       Perf MQReceive Processor Service                                                                                                                                                                                                                             
Quick Fill Service                                                            Batch                            Quick Fill Service                                             Quick Fill Service Service                                                                                                                                                                                                                                   
Quick Fill Service                                                            Background                       Quick Fill Service                                             Quick Fill Service Service                                                                                                                                                                                                                                   
Batch Real-Time Integration                                                   Batch                            RTIBatch                                                       Batch for Real-Time integration with BackOffice (ERP) Systems                                                                                                                                                                                                
RTS Extractor Service                                                         Batch                            RTS Extractor Service                                          RTS Extractor Service Service                                                                                                                                                                                                                                
RTS Extractor Service                                                         Background                       RTS Extractor Service                                          RTS Extractor Service Service                                                                                                                                                                                                                                
RTS Message Apply Service                                                     Batch                            RTS Message Apply Service                                      RTS Message Apply Service Service                                                                                                                                                                                                                            
RTS Message Apply Service                                                     Background                       RTS Message Apply Service                                      RTS Message Apply Service Service                                                                                                                                                                                                                            
RTS Sender Service                                                            Batch                            RTS Sender Service                                             RTS Sender Service Service                                                                                                                                                                                                                                   
RTS Sender Service                                                            Background                       RTS Sender Service                                             RTS Sender Service Service                                                                                                                                                                                                                                   
RTS Subscription Service                                                      Batch                            RTS Subscription Service                                       RTS Subscription Service Service                                                                                                                                                                                                                             
RTS Subscription Service                                                      Background                       RTS Subscription Service                                       RTS Subscription Service Service                                                                                                                                                                                                                             
RTS Transaction Dispatch Service                                              Batch                            RTS Transaction Dispatch Service                               RTS Transaction Dispatch Service Service                                                                                                                                                                                                                     
RTS Transaction Dispatch Service                                              Background                       RTS Transaction Dispatch Service                               RTS Transaction Dispatch Service Service                                                                                                                                                                                                                     
RTS Transaction Dispatcher                                                    Background                       RTSDispatcher                                                  Dispatches the transactions to the RTS channel                                                                                                                                                                                                               
Replication Agent                                                             Background                       RepAgent                                                       Synchronizes a Siebel Remote regional database with HQ                                                                                                                                                                                                       
Report Business Service                                                       Batch                            Report Business Service                                        Report Business Service Service                                                                                                                                                                                                                              
Report Business Service                                                       Background                       Report Business Service                                        Report Business Service Service                                                                                                                                                                                                                              
Server Request Broker                                                         Interactive                      ReqBroker                                                      Route requests and asynchronous notification among clients and components                                                                                                                                                                                    
Row Set Transformation Toolkit                                                Batch                            Row Set Transformation Toolkit                                 Row Set Transformation Toolkit Service                                                                                                                                                                                                                       
Row Set Transformation Toolkit                                                Background                       Row Set Transformation Toolkit                                 Row Set Transformation Toolkit Service                                                                                                                                                                                                                       
Rule Manager Service                                                          Batch                            Rule Manager Service                                           Rule Manager Service Service                                                                                                                                                                                                                                 
Rule Manager Service                                                          Background                       Rule Manager Service                                           Rule Manager Service Service                                                                                                                                                                                                                                 
Rule Runtime Administration                                                   Batch                            Rule Runtime Administration                                    Rule Runtime Administration Service                                                                                                                                                                                                                          
Rule Runtime Administration                                                   Background                       Rule Runtime Administration                                    Rule Runtime Administration Service                                                                                                                                                                                                                          
Siebel Connection Broker                                                      Background                       SCBroker                                                       Route and load balance connections to components                                                                                                                                                                                                             
SCF Message Facility Test Component                                           Batch                            SCFMsgFacTest                                                  Component used for testing the SCF Message Facility                                                                                                                                                                                                          
SCF Message Facility Test Component                                           Background                       SCFMsgFacTest                                                  Component used for testing the SCF Message Facility                                                                                                                                                                                                          
SIS Test Component                                                            Batch                            SISTst                                                         SIS Test Component use for testing shared memory instance                                                                                                                                                                                                    
SIS Test Component                                                            Interactive                      SISTst                                                         SIS Test Component use for testing shared memory instance                                                                                                                                                                                                    
SIS Test Component                                                            Background                       SISTst                                                         SIS Test Component use for testing shared memory instance                                                                                                                                                                                                    
SMQ Message Service                                                           Batch                            SMQ Message Service                                            SMQ Message Service Service                                                                                                                                                                                                                                  
SMQ Message Service                                                           Background                       SMQ Message Service                                            SMQ Message Service Service                                                                                                                                                                                                                                  
SMQ Transport Service                                                         Batch                            SMQ Transport Service                                          SMQ Transport Service Service                                                                                                                                                                                                                                
SMQ Transport Service                                                         Background                       SMQ Transport Service                                          SMQ Transport Service Service                                                                                                                                                                                                                                
Server Request Processor (SRP)                                                Interactive                      SRProc                                                         Store requests/notifications into database and forward them to components/clients                                                                                                                                                                            
Sales Hierarchy Service                                                       Batch                            Sales Hierarchy Service                                        Sales Hierarchy Service Service                                                                                                                                                                                                                              
Sales Hierarchy Service                                                       Background                       Sales Hierarchy Service                                        Sales Hierarchy Service Service                                                                                                                                                                                                                              
Search Data Processor                                                         Batch                            Search Data Processor                                          Search Data Processor Service                                                                                                                                                                                                                                
Search Data Processor                                                         Background                       Search Data Processor                                          Search Data Processor Service                                                                                                                                                                                                                                
Search External Service                                                       Batch                            Search External Service                                        Search External Service Service                                                                                                                                                                                                                              
Search External Service                                                       Background                       Search External Service                                        Search External Service Service                                                                                                                                                                                                                              
Server Manager                                                                Interactive                      ServerMgr                                                      Administration of Siebel Servers within the Enterprise                                                                                                                                                                                                       
Smart Answer Client                                                           Batch                            Smart Answer Client                                            Smart Answer Client Service                                                                                                                                                                                                                                  
Smart Answer Client                                                           Background                       Smart Answer Client                                            Smart Answer Client Service                                                                                                                                                                                                                                  
Smart Script Execution Cleanup                                                Batch                            Smart Script Execution Cleanup                                 Smart Script Execution Cleanup Service                                                                                                                                                                                                                       
Smart Script Execution Cleanup                                                Background                       Smart Script Execution Cleanup                                 Smart Script Execution Cleanup Service                                                                                                                                                                                                                       
Source Code Lookup                                                            Batch                            Source Code Lookup                                             Source Code Lookup Service                                                                                                                                                                                                                                   
Source Code Lookup                                                            Background                       Source Code Lookup                                             Source Code Lookup Service                                                                                                                                                                                                                                   
SrchFileSrvr                                                                  Batch                            SrchFileSrvr                                                   SrchFileSrvr Service                                                                                                                                                                                                                                         
SrchFileSrvr                                                                  Background                       SrchFileSrvr                                                   SrchFileSrvr Service                                                                                                                                                                                                                                         
SRM Tester 1                                                                  Batch                            SrmTst1                                                        Server Request Manager Test Component 1                                                                                                                                                                                                                      
SRM Tester 2                                                                  Batch                            SrmTst2                                                        Server Request Manager Test Component 2                                                                                                                                                                                                                      
SRM Tester 3                                                                  Batch                            SrmTst3                                                        Server Request Manager Test Component 3                                                                                                                                                                                                                      
SRM Tester 4                                                                  Batch                            SrmTst4                                                        Server Request Manager Test Component 4                                                                                                                                                                                                                      
Synchronization Manager                                                       Interactive                      SynchMgr                                                       Services Siebel Remote synchronization clients                                                                                                                                                                                                               
TNT SHM Quote Service                                                         Batch                            TNT SHM Quote Service                                          TNT SHM Quote Service Service                                                                                                                                                                                                                                
TNT SHM Quote Service                                                         Background                       TNT SHM Quote Service                                          TNT SHM Quote Service Service                                                                                                                                                                                                                                
Task Log Cleanup Service                                                      Batch                            Task Log Cleanup Service                                       Task Log Cleanup Service Service                                                                                                                                                                                                                             
Task Log Cleanup Service                                                      Background                       Task Log Cleanup Service                                       Task Log Cleanup Service Service                                                                                                                                                                                                                             
Test Utilities                                                                Batch                            Test Utilities                                                 Test Utilities Service                                                                                                                                                                                                                                       
Test Utilities                                                                Background                       Test Utilities                                                 Test Utilities Service                                                                                                                                                                                                                                       
Test Data Access                                                              Batch                            TestDataAccess                                                 Component used for testing SCF data access layer.                                                                                                                                                                                                            
Test Data Access                                                              Background                       TestDataAccess                                                 Component used for testing SCF data access layer.                                                                                                                                                                                                            
Test SCF Data Access Performance                                              Batch                            TestDataAccessPerf                                             Component used for testing SCF data access layer performance.                                                                                                                                                                                                
Test SCF Event Facility                                                       Batch                            TestEventFacility                                              Component used for testing SCF event facility and its performance.                                                                                                                                                                                           
Request MT Test Server                                                        Batch                            TestMTReq                                                      Component used for testing Multi-threaded Request Mode Server                                                                                                                                                                                                
Multithreaded Test Server                                                     Batch                            TestMTSrvr                                                     Component used for testing Multithreaded Server                                                                                                                                                                                                              
Multithreaded Test Server                                                     Interactive                      TestMTSrvr                                                     Component used for testing Multithreaded Server                                                                                                                                                                                                              
Request Test Server                                                           Batch                            TestReq                                                        Component used for testing Request Mode Server                                                                                                                                                                                                               
Test SCF Facilities                                                           Batch                            TestScfFacilities                                              Component used for testing new SCF facilities.                                                                                                                                                                                                               
Test SCF Facilities                                                           Background                       TestScfFacilities                                              Component used for testing new SCF facilities.                                                                                                                                                                                                               
Session Test Server                                                           Interactive                      TestSess                                                       Component used for testing Session Mode Server                                                                                                                                                                                                               
Test Server                                                                   Batch                            TestSrvr                                                       Component used for testing Client Administration                                                                                                                                                                                                             
Test Server                                                                   Background                       TestSrvr                                                       Component used for testing Client Administration                                                                                                                                                                                                             
Transaction Merger                                                            Background                       TxnMerge                                                       Merges transactions from Siebel Remote clients                                                                                                                                                                                                               
Transaction Processor                                                         Background                       TxnProc                                                        Prepares the transaction log for the Transaction Router                                                                                                                                                                                                      
Transaction Router                                                            Background                       TxnRoute                                                       Routes visible transactions to Siebel Remote clients                                                                                                                                                                                                         
UDA Service                                                                   Batch                            UDA Service                                                    UDA Service Service                                                                                                                                                                                                                                          
UDA Service                                                                   Background                       UDA Service                                                    UDA Service Service                                                                                                                                                                                                                                          
Universal Data Cleansing Service                                              Batch                            Universal Data Cleansing Service                               Universal Data Cleansing Service Service                                                                                                                                                                                                                     
Universal Data Cleansing Service                                              Background                       Universal Data Cleansing Service                               Universal Data Cleansing Service Service                                                                                                                                                                                                                     
UoM Conversion Business Service                                               Batch                            UoM Conversion Business Service                                UoM Conversion Business Service Service                                                                                                                                                                                                                      
UoM Conversion Business Service                                               Background                       UoM Conversion Business Service                                UoM Conversion Business Service Service                                                                                                                                                                                                                      
Update Manager                                                                Batch                            UpdateMgr                                                      Server component that will update DNB and List Management                                                                                                                                                                                                    
Upgrade Kit Wizard OMSV                                                       Batch                            Upgrade Kit Wizard OMSV                                        Upgrade Kit Wizard OMSV Service                                                                                                                                                                                                                              
Upgrade Kit Wizard OMSV                                                       Background                       Upgrade Kit Wizard OMSV                                        Upgrade Kit Wizard OMSV Service                                                                                                                                                                                                                              
Workflow Action Agent                                                         Background                       WorkActn                                                       Executes actions for pre-defined events                                                                                                                                                                                                                      
Workflow Monitor Agent                                                        Background                       WorkMon                                                        Monitors the database for pre-defined events                                                                                                                                                                                                                 
Workflow Process Manager                                                      Batch                            Workflow Process Manager                                       Workflow Process Manager Service                                                                                                                                                                                                                             
Workflow Process Manager                                                      Background                       Workflow Process Manager                                       Workflow Process Manager Service                                                                                                                                                                                                                             
Workflow Recovery Manager                                                     Batch                            Workflow Recovery Manager                                      Workflow Recovery Manager Service                                                                                                                                                                                                                            
Workflow Recovery Manager                                                     Background                       Workflow Recovery Manager                                      Workflow Recovery Manager Service                                                                                                                                                                                                                            
eAuto VDS Accessorization Utility Service                                     Batch                            eAuto VDS Accessorization Utility Service                      eAuto VDS Accessorization Utility Service Service                                                                                                                                                                                                            
eAuto VDS Accessorization Utility Service                                     Background                       eAuto VDS Accessorization Utility Service                      eAuto VDS Accessorization Utility Service Service                                                                                                                                                                                                            

206 rows returned.

