--[[
   This Lua code was generated by Lemplate, the Lua
   Template Toolkit. Any changes made to this file will be lost the next
   time the templates are compiled.

   Copyright 2016 - Yichun Zhang (agentzh) - All rights reserved.

   Copyright 2006-2014 - Ingy döt Net - All rights reserved.
]]

local gsub = ngx.re.gsub
local concat = table.concat
local type = type
local math_floor = math.floor
local table_maxn = table.maxn

local _M = {
    version = '0.01'
}

local template_map = {}

local function tt2_true(v)
    return v and v ~= 0 and v ~= "" and v ~= '0'
end

local function tt2_not(v)
    return not v or v == 0 or v == "" or v == '0'
end

local context_meta = {}

function context_meta.plugin(context, name, args)
    if name == "iterator" then
        local list = args[1]
        local count = table_maxn(list)
        return { list = list, count = 1, max = count - 1, index = 0, size = count, first = true, last = false, prev = "" }
    else
        return error("unknown iterator: " .. name)
    end
end

function context_meta.process(context, file)
    local f = template_map[file]
    if not f then
        return error("file error - " .. file .. ": not found")
    end
    return f(context)
end

function context_meta.include(context, file)
    local f = template_map[file]
    if not f then
        return error("file error - " .. file .. ": not found")
    end
    return f(context)
end

context_meta = { __index = context_meta }

local function stash_get(stash, k)
    local v
    if type(k) == "table" then
        v = stash
        for i = 1, #k, 2 do
            local key = k[i]
            local typ = k[i + 1]
            if type(typ) == "table" then
                local value = v[key]
                if type(value) == "function" then
                    return value()
                end
                if value then
                    return value
                end
                if key == "size" then
                    if type(v) == "table" then
                        return #v
                    else
                        return 1
                    end
                else
                    return error("virtual method " .. key .. " not supported")
                end
            end
            if type(key) == "number" and key == math_floor(key) and key >= 0 then
                key = key + 1
            end
            if type(v) ~= "table" then
                return nil
            end
            v = v[key]
        end
    else
        v = stash[k]
    end
    if type(v) == "function" then
        return v()
    end
    return v
end

local function stash_set(stash, k, v, default)
    if default then
        local old = stash[k]
        if old == nil then
            stash[k] = v
        end
    else
        stash[k] = v
    end
end

function _M.process(file, params)
    local stash = params
    local context = {
        stash = stash,
        filter = function (bits, name, params)
            local s = concat(bits)
            if name == "html" then
                s = gsub(s, "&", '&amp;', "jo")
                s = gsub(s, "<", '&lt;', "jo");
                s = gsub(s, ">", '&gt;', "jo");
                s = gsub(s, '"', '&quot;', "jo"); -- " end quote for emacs
                return s
            end
        end
    }
    context = setmetatable(context, context_meta)
    local f = template_map[file]
    if not f then
        return error("file error - " .. file .. ": not found")
    end
    return f(context)
end
-- a.tt2
template_map['a.tt2'] = function (context)
    if not context then
        return error("Lemplate function called without context\n")
    end
    local stash = context.stash
    local output = {}
    local i = 0

i = i + 1 output[i] = '<!-- file a.tt2 -->\n<html><body>\n<ul>\n'
-- line 6 "a.tt2"

-- FOREACH
do
    local list = stash_get(stash, 'list')
    local iterator
    if list.list then
        iterator = list
        list = list.list
    end
    local oldloop = stash_get(stash, 'loop')
    local count
    if not iterator then
        count = table_maxn(list)
        iterator = { count = 1, max = count - 1, index = 0, size = count, first = true, last = false, prev = "" }
    else
        count = iterator.size
    end
    stash.loop = iterator
    for idx, value in ipairs(list) do
        if idx == count then
            iterator.last = true
        end
        iterator.index = idx - 1
        iterator.count = idx
        iterator.next = list[idx + 1]
        stash['v'] = value
i = i + 1 output[i] = '  <li>'
-- line 5 "a.tt2"

-- FILTER
local value
do
    local output = {}
    local i = 0

i = i + 1 output[i] = stash_get(stash, 'v')

    value = context.filter(output, 'html', {})
end
i = i + 1 output[i] = value

i = i + 1 output[i] = '</li>\n'
        iterator.first = false
        iterator.prev = value
    end
    stash_set(stash, 'loop', oldloop)
end

i = i + 1 output[i] = '</ul>\n</body></html>\n\n'

    return output
end

return _M
