# -*- cperl -*-
# ABSTRACT: LaTeX Scientificnumber object


use strict;
use warnings;
package SpeL::Object::Scientificnumber;

use parent 'Exporter';
use Carp;

use SpeL::Object::Realnumber;
use SpeL::Object::Integernumber;

use SpeL::I18n;

use Data::Dumper;



sub read {
  my $self = shift;
  my ( $level ) = @_;
  my $sign = '';
  if ( exists $self->{Sign} ) {
    $sign .= $self->{Sign} eq '+' ? $SpeL::I18n::lh->maketext('+') . ' ' : '';
    $sign .= $self->{Sign} eq '-' ? $SpeL::I18n::lh->maketext('-') . ' ' : '';
  }
  my $value = '';
  if ( exists $self->{Value} ) {
      $value = $self->{Value};
  }
  my $exp = '';
  if ( exists $self->{Exponent} ) {
      if ( exists $self->{Value} ) {
	  $exp .= ' ' . $SpeL::I18n::lh->maketext('times');
      }
      $exp .= ' 10 ' . $SpeL::I18n::lh->maketext('Intpower' ) . ' ' . $self->{Exponent}->read( $level + 1 );
  }
  return $sign . $value . $exp;
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

SpeL::Object::Scientificnumber - LaTeX Scientificnumber object

=head1 VERSION

version 20250129.1405

=head1 METHODS

=head2 new()

We keep the default method, as the object is generated by the parser.

=head2 read( level )

returns a string with the spoken version of the node

=over 4

=item level: parsing level

=back

=head1 SYNOPSYS

Represents a LaTeX Scientificnumber

=head1 AUTHOR

Walter Daems <wdaems@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2025 by Walter Daems.

This is free software, licensed under:

  The GNU General Public License, Version 3, June 2007

=head1 CONTRIBUTOR

=for stopwords Paul Levrie

Paul Levrie

=cut
