package App::Manoc::Form::DHCPServer;

use HTML::FormHandler::Moose;

our $VERSION = '2.99.4'; ##TRIAL VERSION

use namespace::autoclean;

extends 'App::Manoc::Form::BaseDBIC';
with 'App::Manoc::Form::TraitFor::SaveButton';

has '+name' => ( default => 'form-dhcpserver' );

has '+item_class' => ( default => 'DHCPServer' );

has_field 'name' => (
    type     => 'Text',
    required => 1,
    label    => 'Name',
);

has_field 'max_lease_time' => (
    type  => 'Integer',
    label => 'Default maximum lease time',
);
has_field 'default_lease_time' => (
    type  => 'Integer',
    label => 'Default lease time',
);
has_field 'ntp_server' => (
    type  => 'Text',
    label => 'Default NTP Server',
);
has_field 'domain_nameserver' => (
    type  => 'Text',
    label => 'Default Domain Nameserver',
);
has_field 'domain_name' => (
    type  => 'Text',
    label => 'Default Domain Name',
);

__PACKAGE__->meta->make_immutable;
no HTML::FormHandler::Moose;

__END__

=pod

=head1 NAME

App::Manoc::Form::DHCPServer

=head1 VERSION

version 2.99.4

=head1 AUTHORS

=over 4

=item *

Gabriele Mambrini <gmambro@cpan.org>

=item *

Enrico Liguori

=back

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by Gabriele Mambrini.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
