package App::Manoc::Model::ManocDB;
#ABSTRACT:  Catalyst DBIC Schema Model for Manoc


use Moose;
extends 'Catalyst::Model::DBIC::Schema';

our $VERSION = '2.99.3'; ##TRIAL VERSION

use namespace::autoclean;

__PACKAGE__->config( schema_class => 'App::Manoc::DB', );

has 'search_engine' => (
    is      => 'ro',
    isa     => 'App::Manoc::DB::Search',
    lazy    => 1,
    builder => '_build_search_engine',
);


sub search {
    my $self = shift;
    return $self->schema->manoc_search(@_);
}

__PACKAGE__->meta->make_immutable;
1;

__END__

=pod

=head1 NAME

App::Manoc::Model::ManocDB - Catalyst DBIC Schema Model for Manoc

=head1 VERSION

version 2.99.3

=head1 DESCRIPTION

L<Catalyst::Model::DBIC::Schema> Model using schema L<App::Manoc::DB>

=head1 METHODS

=head2 search( $query_string, $params )

Run query using L<App::Manoc::DB> C<manoc_search> method.

=head1 AUTHORS

=over 4

=item *

Gabriele Mambrini <gmambro@cpan.org>

=item *

Enrico Liguori

=back

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by Gabriele Mambrini.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
