package App::Manoc::DB::Helper::NetwalkerCredentials;
#ABSTRACT: Helper for creating credentials columns needed by netwalker pollers

use strict;
use warnings;

our $VERSION = '2.99.2'; ##TRIAL VERSION

use parent 'DBIx::Class';


sub make_credentials_columns {
    my $self = shift;

    $self->add_columns(
        username => {
            data_type     => 'varchar',
            size          => 64,
            default_value => 'NULL',
            is_nullable   => 1,
        },
        password => {
            data_type     => 'varchar',
            size          => 64,
            default_value => 'NULL',
            is_nullable   => 1,
        },
        password2 => {
            data_type     => 'varchar',
            size          => 64,
            default_value => 'NULL',
            is_nullable   => 1,
        },

        use_ssh_key => {
            data_type     => 'int',
            size          => 1,
            default_value => 'NULL',
            is_nullable   => 1,
        },

        key_path => {
            data_type     => 'varchar',
            size          => 256,
            default_value => 'NULL',
            is_nullable   => 1,
        },

        snmp_community => {
            data_type     => 'varchar',
            size          => 64,
            default_value => 'NULL',
            is_nullable   => 1,
        },
        snmp_user => {
            data_type     => 'varchar',
            size          => 50,
            default_value => 'NULL',
            is_nullable   => 1,
        },
        snmp_password => {
            data_type     => 'varchar',
            size          => 50,
            default_value => 'NULL',
            is_nullable   => 1,
        },
        snmp_version => {
            data_type     => 'int',
            size          => 1,
            default_value => '0',
        },
    );
}


sub get_credentials_hash {
    my $self = shift;

    return {
        username       => $self->username,
        password       => $self->password,
        password2      => $self->password2,
        use_ssh_key    => $self->use_ssh_key,
        key_path       => $self->key_path,
        snmp_community => $self->snmp_community,
        snmp_user      => $self->snmp_user,
        snmp_password  => $self->snmp_password,
        snmp_version   => $self->snmp_version,
    };
}

1;

__END__

=pod

=head1 NAME

App::Manoc::DB::Helper::NetwalkerCredentials - Helper for creating credentials columns needed by netwalker pollers

=head1 VERSION

version 2.99.2

=head1 METHODS

=head2 make_credentials_columns

Add all the columns required for netwalker credentials support

=head2 get_credentials_hash

Return all credential data as a hashref

=head1 AUTHORS

=over 4

=item *

Gabriele Mambrini <gmambro@cpan.org>

=item *

Enrico Liguori

=back

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by Gabriele Mambrini.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
