signature UTIL = sig
  val stringEqual : string * string -> bool
  val printSep : string -> string list -> unit
  val wn : string list -> unit
  val err : string list -> 'a

  val zeroTime : System.Timer.time
  val isZeroTime : System.Timer.time -> bool
  val currentTime : unit -> System.Timer.time
  val seconds : System.Timer.time -> int
  val microSeconds : System.Timer.time -> int
  val newer : System.Timer.time * System.Timer.time -> bool
  val newAs : System.Timer.time * System.Timer.time -> bool

  val absoluteName : string -> string -> string
  val trim :string -> string
  val modtime : string -> System.Timer.time
  val getwd : unit -> string

  val remDuplicates : string list -> string list -> string list * string list

  val handleInterrupt :(unit -> unit) -> unit

  val toolIsDefined :(string * int -> bool) ref
end
