(* Copyright (c) 1991 by Carnegie Mellon University *)

signature DEST =
   sig
       val pushDest : string -> unit
       val getDest : unit -> outstream
       val popDest : unit -> unit
       exception NoDest       
   end

functor Dest(structure Print : CPRINT) : DEST =
  struct
     val pr = outputc std_out
     val dest = ref (nil  : (outstream * string) list)
     exception NoDest

     val pushDest = fn s =>
		 let val _ = pr ("[Opening output file " ^ s ^ "]\n")
		     val f = open_out s
		     val _ =  Print.startFile (outputc f)
		  in dest := (f,s) :: (!dest)
		  end

     val getDest = fn () =>
	     case dest 
	     of ref ((f,_) :: _)  => f
	      | _ => raise NoDest

      val popDest = fn () =>
	     case dest
	     of ref ((f,s) :: r) => 
		 (pr ("[Closing output file "^s^"]\n");
		  close_out f; dest := r)
	      | _ => ()
  end
