/*
	Memory manager specific definitions.
*/
#ifndef  __MANAGER_H__
#define  __MANAGER_H__ 1

#include "stdio.h"
#include "concon.h"

#define REQ_NONE        0
#define REQ_NEWPROCESS  1
#define REQ_NEWSTATE    2
#define REQ_HALTED      3
#define REQ_ERROR       4

#define Real           float
#define actionFuncType void ((*actionFuncP)( void ))

typedef union data
	{
	void    *dataP;
	actionFuncType;
	long    integer;
	Real    real;
	} Data;

typedef struct props
    {
    unsigned type:5,
             marked:1,
             quoted:1,
             locked:1;
    } Props;
    
typedef struct list
	{
	void     *nextP;
    union
        {
        Props p;
        char  b;
        } u;
	Data     data;
	} List, Descr;
	
typedef struct reqData
	{
	List *newReadP;
	actionFuncType;
	} ReqData;

typedef struct state
	{

/*  Lexical analysis. */
	int 		token;
	int 		brackets;
	Inherit     quoted;
	Inherit 	termStarted;
	Inherit 	newLiner;
	int 		lineNo;
	Inherit 	endOfFile;

/*  Execution state control. */
	int 		process;
	List 		*execP,
		 		*returnP,
	 			*readP,
	 			*writeP,
	 			*localP,
	 			*titleP,
	 			*operatorP;
	actionFuncType;

/*  Input / output. */
	List 		*inP;
	List 		*outP;
	char 		*readInP;    /* The input buffer itself. */
	char 		*walkerP,
		 		*inputMarkP,
		 		*lookAheadP;

/*  Process / state control. */
	void *prevProcessStateP;
	void *nextProcessStateP;
	int   parentProcess;
	void *prevStateP;
    int validState, request;
	ReqData  req;
	} State;


typedef struct commands
	{
	char	lexeme[32];
	actionFuncType;
	} Commands;



#endif

		
			

