/*
        Concon - Constraint Constructor
            Programmed by Ayal Pinkus
              A lisplike language.
*/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <stddef.h>
#include <time.h>
#include <setjmp.h>
#include <signal.h>
#include "parser.fdf"
#include "input.fdf"
#include "manager.fdf"
#include "states.fdf"
#include "service.fdf"
#include "commands.fdf"
#include "format.fdf"
#include "methods.fdf"
#include "symbol.h"
#include "concon.h"
#include "cmdlist.h"
#include "manager.h"
#ifdef _SEE_SPEED_
#include <profile.h>
#endif


/* The globals used by all the modules. */
Inherit programHalted = FALSE;
clock_t garbColTime = 0;
jmp_buf env;
clock_t conConTimer;
Inherit requestAttention = FALSE;

/* nofunc does nothing! */
void nofunc( void )
    {
    }

void proMain_exit( void )
	{
    proMeth_exit();
    proMem_exit();
	}

#ifdef  INTER_ATTENTION
void proMain_requestAttention( int sig )
	{
	if (sig != SIGINT)
		proFor_print("\nERROR - Strange interrupt...");
	requestAttention = TRUE;
    return;
	}
#endif

int  main ( int argc, char **argv )
	{
    long sym=-1, lex=-1, lst=-1, stt = -1;
	int   i, xxx;
	char  buf[60];
	char  initFile[FILENAME_MAX + 3];
	Descr *initDescrP;
	List  new;

#ifdef _SEE_SPEED_
    _profile_setup( argc, argv );
#endif
    
    initFile[1] = '\0';
    for (i=0;i<argc;i++)
    		{
    		sscanf( argv[i], "-s%ld", &sym );
    		sscanf( argv[i], "-l%ld", &lex );
    		sscanf( argv[i], "-m%ld", &lst );
     		sscanf( argv[i], "-p%ld", &stt );
			sscanf( argv[i], "-i%s" , &initFile[1] );
	   		}
	if (sym < 0)
		sym = 211;
	if (lex < 0)
        lex = 50000;
	if (lst < 0)
        lst = 300000;
	if (stt < 0)
        stt = 400;
    if (initFile[1] == '\0')
		strcpy( &initFile[1], "init.con" );
    initFile[0] = '\"';
	initFile[strlen(initFile)+1] = '\0';
	initFile[strlen(initFile)]   = '\"';
	
    proMem_init( sym, lex, lst, stt );
    proMem_register( cmdList );
    proMem_constants();
    proInput_init();
    proMeth_init();
    atexit( proMain_exit );
    printf("Concon Version " CONCON_VERSION );
    printf("\nAyal Pinkus\n");
	proMem_memFree();
	printf("\nList Element Size is %ld\n", sizeof( List ));
	printf("\n\n-----------------------------------------------\n");

	cc_clearLElm( &new );
	cc_makeAtom( &new, initFile );
	cc_newDescr( &initDescrP, NULL );
	cc_copyAndInsert( initDescrP, &new, FALSE );
	proState_request( REQ_NEWPROCESS,
		initDescrP->nextP, proCmd_load );
	cc_freeDescr( &initDescrP );

	xxx = setjmp( env );
	if (xxx == 1)
		{
		proFor_print("\nAborted...");
		proState_abortAllProcesses();
		}

#ifdef  INTER_ATTENTION
    signal( SIGINT, proMain_requestAttention );
#endif

    while (!programHalted)
        proState_dispatch();

#ifdef  INTER_ATTENTION
    signal( SIGINT, SIG_IGN );
#endif

    proState_abortAllProcesses();
    proState_dispatch();
 	proFor_print("\nProgram is halting. Bye!");
	sprintf( buf, "\ngarbage collection : %.3f seconds.", 
		(float)garbColTime / CLOCKS_PER_SEC );
	proFor_print( buf );
	proFor_print("\nHit any key...");
	getchar();
	return 0;
    }



