#ifndef	DATE_H
#define	DATE_H

/* Date.h -- declarations for Gregorian calendar dates

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	K. E. Gorlen
	Computer Systems Laboratory, DCRT
	National Institutes of Health
	Bethesda, MD 20892

$Log:	Date.h,v $
 * Revision 2.6  88/10/12  10:17:20  ted
 * Revamped to work with Julian day number instead of day and year.  Julian day number
 * is not what most programmers think of as Julian date; i.e., Jan. 29, 1988 is not the same
 * as 88029 in Julian day number.  They are different.
 *
 * Revision 2.1  88/03/28  14:46:20  keith
 * Make Date(istream&) public and Date(istream&,Date&) protected
 * 
 * Revision 2.0  88/02/04  12:58:50  keith
 * Version 2 Release 2.  Make Class class_CLASSNAME const.
 * 
 * Revision 1.2  88/01/16  23:38:37  keith
 * Remove pre-RCS modification history
 * 
*/

#include "Object.h"

typedef unsigned short dayTy;
typedef unsigned short monthTy;
typedef unsigned short yearTy;
typedef unsigned long  julTy;

extern const Class class_Date;
overload Date_reader;

dayTy	dayOfWeek(const char* dayName);
dayTy	daysInYear(yearTy year);
monthTy	numberOfMonth(const char* monthName);
bool	leapYear(yearTy year);
const char*	nameOfMonth(monthTy monthNumber);
const char*	nameOfDay(dayTy weekDayNumber);

class Date: public Object {
        julTy julnum;   // Julian Day Number (Not same as Julian date.  Jan. 29, 1988 
                        // is not the same as 88029 in Julian Day Number.)
	Date(julTy j)                   { julnum = j; }
	julTy parseDate(istream&);
protected:
	Date(fileDescTy&,Date&);
	Date(istream&,Date&);
	friend	void Date_reader(istream& strm, Object& where);
	friend	void Date_reader(fileDescTy& fd, Object& where);
	virtual void storer(fileDescTy&);
	virtual void storer(ostream&);
public:
	Date();				// current date 
	Date(int dayCount);
	Date(int dayCount, yearTy referenceYear);
	Date(dayTy newDay, const char* monthName, yearTy newYear);
	Date(istream&);			// read date from stream 
	Date(const Date& d)             { julnum = d.julnum; }
	bool	operator<(Date date)    { return julnum < date.julnum; }
	bool	operator<=(Date date)   { return julnum <= date.julnum; }
	bool	operator>(Date date)	{ return date < *this; }
	bool	operator>=(Date date)	{ return date <= *this; }
	bool	operator==(Date date)	{ return julnum == date.julnum; }
	bool	operator!=(Date date)	{ return julnum != date.julnum; }
	friend Date operator+(Date dt, int dd)	{ dt.julnum += dd; return dt; }
	friend Date operator+(int dd, Date dt)	{ dt.julnum += dd; return dt; }
	int	operator-(Date dt)      { return (int)(julnum - dt.julnum); }
	Date	operator-(int dd)	{ return Date(julnum - dd); }
	void	operator+=(int dd)	{ julnum += dd; }
	void	operator-=(int dd)	{ julnum -= dd; }
	bool	between(Date d1, Date d2) { return julnum >= d1.julnum && julnum <= d2.julnum; }
	dayTy	day();
	dayTy	dayOfMonth();
	dayTy	firstDayOfMonth()	{ return firstDayOfMonth(month()); }
	dayTy	firstDayOfMonth(monthTy month);
	bool	leap();
	Date	max(Date dt) { 
	        if (dt.julnum > julnum)
		  return dt;
		else
		  return *this;
        }
	void	mdy(monthTy&,dayTy&,yearTy&);
	Date	min(Date dt) {
	        if (dt.julnum < julnum)
		  return dt;
		else
		  return *this;
        }
	monthTy	month();
	const char*	nameOfMonth();
	Date	previous(const char* dayName);
	dayTy	weekDay();
	yearTy	year();
	virtual int compare(const Object&);
	virtual Object*	copy();			// { return shallowCopy(); }
	virtual void	deepenShallowCopy();	// {}
	virtual unsigned hash();
	virtual const Class* isA();
	virtual bool isEqual(const Object&);
	virtual void printOn(ostream& strm =cout);
	virtual void scanFrom(istream& strm);
	virtual const Class* species();
};

#endif
