#ifdef DYNIX
$stdunit
#endif DYNIX
*********************************************************
*                                                       *
*  Copyright 1988, by D.M. Etter, All rights reserved;  *
*          EECE Dept, University of New Mexico          *
*         Albuquereque, New Mexico,  87131  USA         *
*                                                       *
*********************************************************


CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C

        Subroutine FileSn (X, Y, Numpt, NumCrv, term)


****************************************************************
*                                                              *
*  Subroutine File_Input_Single_File                           *
*                                                              *
*     This routine gets the XY points for all of the           *
*     curves out of the same file.  The user is prompted       *
*     for a file name, and it is assumed that this file        *
*     is set up as follows:                                    *
*                                                              *
*        X        Y(1)       Y(2)  ...   Y(NumCrv)             *
*                                                              *
*       1.0        5.0       10.3  ...     16.4                *
*       2.0        7.3        9.5  ...      8.6                *
*                                                              *
*     (The headings are not part of the data file, just the    *
*     values.)                                                 *
*                                                              *
*     Minor error checking is done by this routine; mainly     *
*     to make sure that the data file to be opened exists.     *
*                                                              *
****************************************************************

*
*     There is a maximum number of 3 curves supported by this program.
*
        Integer MAXCRV
        Parameter (MAXCRV = 3)

        Logical         cldrun
        Common /strtup/ cldrun
        Save   /strtup/

        Integer         max, num, maxC
        Common /Object/ max, num, maxC
        Save   /Object/

        Character    ans
        Character*35 files
        Real         X(max,num), Y(max,num), Xtemp, Ytemp(MAXCRV)
        Integer      NumCrv, Numpt(num), I, IOerr, term, J, k

*       (* Get the data for the different curves. *)
    3   Call clear(term)
        Write (*,30) 
   30   Format(/15x,'File Input',///5x,'Please enter the ',
     +              'name of the data file for the curves  ...')
        Read (*,'(a35)',err=3) files
        IF (files .EQ. ' ') THEN
          Write(*,'(a1)') Char(7)
          GOTO 3
        ENDIF
        Open (unit = 1, file = files, status = 'old', iostat = IOerr)

*       (* Check to see if the file was successfully opened. *)
        IF (IOerr .NE. 0) THEN
*         (* Disaster!! The file wasn't found. Allow the user to 
*            either quit or retry to enter the filename. *)
    4     Call clear(term)
          Write (*,40) files
   40     Format (/15x,'File Input',///5x,'Sorry, but file: ',
     +               a,/5x,'wasn''t found.',//
     +             5x,'Do you wish to stop the program? (Y/N) ... ')
          Read (*,'(a1)',err=4) ans
          IF ((ans .EQ. 'Y') .OR. (ans .EQ. 'y')) THEN
            Write (*,50)
   50       Format (//,5x,'Goodbye!',//)
            STOP
          ENDIF
        ELSE
*         (* The file was successfully opened. *)
          Rewind 1

*         (* Get the data points. *)
          K = 1
          DO 10 I = 1,NumCrv
            Numpt(I) = 0
   10     CONTINUE
  400     IF (Numpt(K) .LT. max) THEN
            Read (1,*,err=500,end=600) Xtemp, (Ytemp(J),J=1,NumCrv)
            DO 12 I = 1, NumCrv
              Numpt(I) = Numpt(I) +1
              X(Numpt(I), I) = Xtemp
              Y(Numpt(I), I) = Ytemp(I)
   12       CONTINUE
            GOTO 400
  500       print *,'error: in input of file ',files
            print *,'       on line ',Numpt(K)
            GOTO 400
          ELSE
            Read (1,*,err=600,end=600) Xtemp, (Ytemp(J),J=1,NumCrv)
*           (* Convey to the user that the file contains more
*              than the maximum number of allowed points. *)
    5       Call clear(term)
            Write (*,60) files, max
   60       Format (/15x,'File Input',//5x,'Sorry, but file ''',
     +              a,''' has more than'/,
     +              5x,'the maximum ',i5,' points allowed!'//,
     +              5x,'Do you wish to stop the program? (Y/N)... ')
            Read (*,'(a1)',err=5) ans
            IF (ans .EQ. 'Y' .OR. ans .EQ. 'y') THEN
              Write (*,70)
   70         Format (/15x,'Goodbye!'//)
              STOP
            ENDIF
          ENDIF

  600     IF (Numpt(K) .LE. 1) THEN
*           (* Convey to the user that the file doesn't contain
*              enough points. They then have the option of 
*              stopping or re-entering a new filename. *)
    6       Call clear(term)
            Write (*,80) files
   80       Format (/15x,'File Input',//5x,'Sorry, but file ''',
     +               a,''' doesn''t contain'
     +              ,'enough ',/5x,'points!',//5x,'Do you wish',
     +              ' to stop the program? (Y/N)... ')
            Read (*,'(a1)',err=6) ans
            IF ((ans .EQ. 'Y') .OR. (ans .EQ. 'y')) THEN
              Write (*,90)
   90         Format (/15x,'Goodbye!')
              STOP
            ENDIF
          ENDIF
        ENDIF

        RETURN
        END
